#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: pandit_model_2001_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "pandit_model_2001_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellpandit_model_2001_epiFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00059999999999999995 * HeartConfig::Instance()->GetCapacitance() / NV_Ith_S(mParameters, 0); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 5.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellpandit_model_2001_epiFromCellMLCvode::Cellpandit_model_2001_epiFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 0.0001; // (var_membrane__Cm) [microF]
    }

    Cellpandit_model_2001_epiFromCellMLCvode::~Cellpandit_model_2001_epiFromCellMLCvode()
    {
    }
    
    double Cellpandit_model_2001_epiFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 21);
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 139.2751
        
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B + var_hyperpolarisation_activated_current__i_f + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_Ca_P + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_steady_state_outward_K_current__i_ss) * HeartConfig::Instance()->GetCapacitance() / NV_Ith_S(mParameters, 0); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellpandit_model_2001_epiFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.0004327548
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 6.06254e-10
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.6348229
        double var_chaste_interface__SR_Ca_release_channel__P_C2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.3647471
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 0.1394301
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 0.0051619
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 21);
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 139.2751
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 8.737212e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.06607948
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = NV_Ith_S(rY, 25);
        // Units: millimolar; Initial value: 0.06600742

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact = 0.0089999999999999993; // second
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_SERCA2a_pump__K_SR = 1.0; // dimensionless
        const double var_SERCA2a_pump__K_fb = 0.00016799999999999999; // millimolar
        const double var_SERCA2a_pump__K_rb = 3.29; // millimolar
        const double var_SERCA2a_pump__N_fb = 1.2; // dimensionless
        const double var_SERCA2a_pump__N_rb = 1.0; // dimensionless
        const double var_SERCA2a_pump__Vmaxf = 0.040000000000000001; // millimolar_per_second
        const double var_SERCA2a_pump__Vmaxr = 0.90000000000000002; // millimolar_per_second
        const double var_SR_Ca_release_channel__k_a_minus = 576.0; // per_second
        const double var_SR_Ca_release_channel__k_a_plus = 12150000000000.0; // per_second
        const double var_SR_Ca_release_channel__k_b_minus = 1930.0; // per_second
        const double var_SR_Ca_release_channel__k_b_plus = 4050000000.0; // per_second
        const double var_SR_Ca_release_channel__k_c_minus = 0.80000000000000004; // per_second
        const double var_SR_Ca_release_channel__k_c_plus = 100.0; // per_second
        const double var_SR_Ca_release_channel__P_C2_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus - var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2 = 0.001 * var_SR_Ca_release_channel__P_C2_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__m = 3.0; // dimensionless
        const double var_SR_Ca_release_channel__n = 4.0; // dimensionless
        const double var_SR_Ca_release_channel__v1 = 1800.0; // per_second
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_intracellular_and_SR_Ca_fluxes__HTRPN_tot = 0.14000000000000001; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__LTRPN_tot = 0.070000000000000007; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus = 0.066000000000000003; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus = 200000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus = 40.0; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus = 40000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__tau_tr = 0.00057470000000000004; // second
        const double var_intracellular_and_SR_Ca_fluxes__tau_xfer = 0.026700000000000002; // second
        const double var_intracellular_ion_concentrations__CMDN_tot = 0.050000000000000003; // millimolar
        const double var_intracellular_ion_concentrations__CSQN_tot = 15.0; // millimolar
        const double var_SERCA2a_pump__rb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_NSR / var_SERCA2a_pump__K_rb), var_SERCA2a_pump__N_rb); // dimensionless
        const double var_intracellular_and_SR_Ca_fluxes__J_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_chaste_interface__intracellular_ion_concentrations__Ca_NSR) / var_intracellular_and_SR_Ca_fluxes__tau_tr; // millimolar_per_second
        const double var_SERCA2a_pump__fb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_SERCA2a_pump__K_fb), var_SERCA2a_pump__N_fb); // dimensionless
        const double var_SERCA2a_pump__J_up = (var_SERCA2a_pump__Vmaxf * var_SERCA2a_pump__fb - var_SERCA2a_pump__Vmaxr * var_SERCA2a_pump__rb) * var_SERCA2a_pump__K_SR / (1.0 + var_SERCA2a_pump__fb + var_SERCA2a_pump__rb); // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_trpn = var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa + var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity = 1 / (1.0 + 100.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss); // dimensionless
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact + var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity) / var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact = 0.001 * var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__J_rel = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2) * var_SR_Ca_release_channel__v1; // millimolar_per_second
        const double var_SR_Ca_release_channel__P_C1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1 = 0.001 * var_SR_Ca_release_channel__P_C1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus + var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1 = 0.001 * var_SR_Ca_release_channel__P_O1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O2_orig_deriv = -var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2 = 0.001 * var_SR_Ca_release_channel__P_O2_orig_deriv; // 1 / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_xfer = (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_ss) / var_intracellular_and_SR_Ca_fluxes__tau_xfer; // millimolar_per_second
        const double var_intracellular_ion_concentrations__EGTA_tot = 10.0; // millimolar
        const double var_intracellular_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_intracellular_ion_concentrations__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_intracellular_ion_concentrations__K_mEGTA = 0.00014999999999999999; // millimolar
        const double var_intracellular_ion_concentrations__V_JSR = 5.6000000000000004e-7; // micro_litre
        const double var_intracellular_ion_concentrations__V_NSR = 5.04e-6; // micro_litre
        const double var_intracellular_ion_concentrations__V_SS = 1.2e-8; // micro_litre
        const double var_intracellular_ion_concentrations__V_myo = 9.3600000000000002e-6; // micro_litre
        const double var_intracellular_ion_concentrations__Ca_NSR_orig_deriv = var_SERCA2a_pump__J_up * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_NSR - var_intracellular_and_SR_Ca_fluxes__J_tr * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_NSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.001 * var_intracellular_ion_concentrations__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_JSR = 1 / (1.0 + var_intracellular_ion_concentrations__CSQN_tot * var_intracellular_ion_concentrations__K_mCSQN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_intracellular_ion_concentrations__K_mCSQN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__Ca_JSR_orig_deriv = (-var_SR_Ca_release_channel__J_rel + var_intracellular_and_SR_Ca_fluxes__J_tr) * var_intracellular_ion_concentrations__beta_JSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * var_intracellular_ion_concentrations__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_SS = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_intracellular_ion_concentrations__K_mCMDN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__beta_i = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mCMDN), 2) + var_intracellular_ion_concentrations__EGTA_tot * var_intracellular_ion_concentrations__K_mEGTA / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mEGTA), 2)); // dimensionless
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-0.92819614711033271 - 0.087565674255691769 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 1 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.035000000000000003 + 0.34999999999999998 * exp(-21.777777777777779 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current_s_gate__s_infinity) / var_Ca_independent_transient_outward_K_current_s_gate__tau_s; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow = 0.035000000000000003 + 3.7000000000000002 * exp(-5.4444444444444446 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow + var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity) / var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s = 0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = 0.001 * var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-3.0600000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = 0.00025000000000000001 + 0.0010499999999999999 * exp(-0.64800000000000002 * pow((-1 + 0.055555555555555552 * var_chaste_interface__membrane__V), 2)) + 0.0030500000000000002 * exp(-0.22049999999999997 * pow((1 + 0.14285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d + var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_11_gate__f_11_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_11_gate__tau_f_11 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.040000000000000001 / (1.0 + exp(1.0 - 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.105 * exp(-14.0625 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_11_gate__f_11_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 + var_L_type_Ca_channel_f_11_gate__f_11_infinity) / var_L_type_Ca_channel_f_11_gate__tau_f_11; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_11_gate__f_11 = 0.001 * var_L_type_Ca_channel_f_11_gate__f_11_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_12_gate__f_12_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_12_gate__tau_f_12 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.080000000000000002 / (1.0 + exp(-11.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.041000000000000002 * exp(-15.340277777777779 * pow((1 + 0.021276595744680851 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_12_gate__f_12_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + var_L_type_Ca_channel_f_12_gate__f_12_infinity) / var_L_type_Ca_channel_f_12_gate__tau_f_12; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_12_gate__f_12 = 0.001 * var_L_type_Ca_channel_f_12_gate__f_12_orig_deriv; // 1 / millisecond
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (0.56230000000000002 * exp(-5.6377730796335452 - 0.070472163495419307 * var_chaste_interface__membrane__V) + 0.11885 * exp(2.8198801550934083 + 0.035248501938667604 * var_chaste_interface__membrane__V)); // second
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(13.225190839694655 + 0.095419847328244267 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + var_hyperpolarisation_activated_current_y_gate__y_infinity) / var_hyperpolarisation_activated_current_y_gate__tau_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_intracellular_ion_concentrations__Ca_ss_orig_deriv = (var_SR_Ca_release_channel__J_rel * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_SS - var_intracellular_and_SR_Ca_fluxes__J_xfer * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L / (var_intracellular_ion_concentrations__V_SS * var_membrane__F)) * var_intracellular_ion_concentrations__beta_SS; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * var_intracellular_ion_concentrations__Ca_ss_orig_deriv; // millimolar / millisecond
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_current_h_gate__h_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__tau_h = ((var_chaste_interface__membrane__V >= -40.0) ? (0.00045370000000000002 + 0.00045370000000000002 * exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)) : (0.00349 / (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_h_gate__h_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h + var_sodium_current_h_gate__h_infinity) / var_sodium_current_h_gate__tau_h; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h = 0.001 * var_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_sodium_current_j_gate__j_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_j_gate__tau_j = ((var_chaste_interface__membrane__V >= -40.0) ? (0.01163 * (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)) / exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V)) : (0.00349 / (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V)) + (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))))); // second
        const double var_sodium_current_j_gate__j_orig_deriv = (-var_chaste_interface__sodium_current_j_gate__j + var_sodium_current_j_gate__j_infinity) / var_sodium_current_j_gate__tau_j; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_j_gate__j = 0.001 * var_sodium_current_j_gate__j_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-6.9230769230769234 - 0.15384615384615385 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 0.0013600000000000001 / (0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V) + 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V))); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = (-var_SERCA2a_pump__J_up - var_intracellular_and_SR_Ca_fluxes__J_trpn - 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_Ca_P) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F) + var_intracellular_and_SR_Ca_fluxes__J_xfer) * var_intracellular_ion_concentrations__beta_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_hyperpolarisation_activated_current__i_f_Na - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity = 1 / (1.0 + exp(-0.97292724196277491 - 0.084602368866328256 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_r_ss_gate__tau_r_ss = 10.0 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_orig_deriv = (-var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss + var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity) / var_steady_state_outward_K_current_r_ss_gate__tau_r_ss; // 1 / second
        const double d_dt_chaste_interface_var_steady_state_outward_K_current_r_ss_gate__r_ss = 0.001 * var_steady_state_outward_K_current_r_ss_gate__r_ss_orig_deriv; // 1 / millisecond
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_background_currents__i_B_K - var_hyperpolarisation_activated_current__i_f_K - var_inward_rectifier__i_K1 - var_steady_state_outward_K_current__i_ss + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity = 1 / (1.0 + exp(8.4951456310679614 + 0.097087378640776698 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_s_ss_gate__tau_s_ss = 2.1000000000000001; // second
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_orig_deriv = (-var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss + var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity) / var_steady_state_outward_K_current_s_ss_gate__tau_s_ss; // 1 / second
        const double d_dt_chaste_interface_var_steady_state_outward_K_current_s_ss_gate__s_ss = 0.001 * var_steady_state_outward_K_current_s_ss_gate__s_ss_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane__i_Stim = 1000.0 * NV_Ith_S(mParameters, 0) * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
            const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
            const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
            const double var_membrane__V_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_L_type_Ca_channel__i_Ca_L - var_Na_Ca_ion_exchanger_current__i_NaCa - var_background_currents__i_B - var_hyperpolarisation_activated_current__i_f - var_inward_rectifier__i_K1 - var_membrane__i_Stim - var_sarcolemmal_calcium_pump_current__i_Ca_P - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK - var_steady_state_outward_K_current__i_ss) / NV_Ith_S(mParameters, 0); // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_sodium_current_h_gate__h;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_sodium_current_j_gate__j;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_L_type_Ca_channel_f_11_gate__f_11;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_L_type_Ca_channel_f_12_gate__f_12;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_steady_state_outward_K_current_r_ss_gate__r_ss;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_steady_state_outward_K_current_s_ss_gate__s_ss;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }

    void Cellpandit_model_2001_epiFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time_converted, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.0004327548
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 6.06254e-10
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.6348229
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 0.1394301
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 0.0051619
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 21);
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 139.2751
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 8.737212e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.06607948
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = NV_Ith_S(rY, 25);
        // Units: millimolar; Initial value: 0.06600742
        
        const double var_x0 = -0.0039900000000000005 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow - 0.031010000000000003 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s;
        const double var_x1 = var_x0 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        const double var_x2 = 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        const double var_x3 = 0.10000000000000001 - var_x2;
        const double var_x4 = var_x3 * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12;
        const double var_x5 = 0.90000000000000002 + var_x2;
        const double var_x6 = var_x5 * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11;
        const double var_x7 = 1 / (1.0 + exp(-35.49354838709678));
        const double var_x8 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
        const double var_x9 = log(5.4000000000000004 * var_x8);
        const double var_x10 = exp(-0.10977188457982838 + 0.06345195640452507 * var_chaste_interface__membrane__V - 1.613 * var_x9);
        const double var_x11 = 1.0 + var_x10;
        const double var_x12 = var_x7 / var_x11;
        const double var_x13 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
        const double var_x14 = 1 / (1.0 + 0.00012 * var_x13 + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
        const double var_x15 = 0.018714999999999999 * var_chaste_interface__membrane__V;
        const double var_x16 = exp(var_x15);
        const double var_x17 = var_x13 * var_x16;
        const double var_x18 = exp(-var_x15);
        const double var_x19 = var_x18 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x20 = var_x14 * (0.022457999999999999 * var_x17 + 51353.959999999999 * var_x19);
        const double var_x21 = var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss;
        const double var_x22 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
        const double var_x23 = var_x22 * var_chaste_interface__sodium_current_j_gate__j;
        const double var_x24 = var_x23 * var_chaste_interface__sodium_current_h_gate__h;
        const double var_x25 = exp(4.5158823529411762 + 1.4953416461467837 * var_x9 - 0.058823529411764705 * var_chaste_interface__membrane__V);
        const double var_x26 = 1.0 + var_x25;
        const double var_x27 = 0.040000000000000001 * var_chaste_interface__membrane__V;
        const double var_x28 = exp(1.48 + var_x27);
        const double var_x29 = -var_x27;
        const double var_x30 = exp(-1.48 + var_x29);
        const double var_x31 = var_x28 + var_x30;
        const double var_x32 = (0.040000000000000001 * var_x30 - 0.040000000000000001 * var_x28) / (var_x26 * pow(var_x31, 2));
        const double var_x33 = var_x25 * (10.0 + 48.0 / var_x31) / pow(var_x26, 2);
        const double var_x34 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
        const double var_x35 = pow(var_x34, 1.5);
        const double var_x36 = exp(-0.0039337852699643568 * var_chaste_interface__membrane__V);
        const double var_x37 = exp(2.0802377414561666);
        const double var_x38 = exp(-0.039337852699643565 * var_chaste_interface__membrane__V);
        const double var_x39 = 1.0 + 0.1245 * var_x36 + 0.036499999999999998 * var_x38 * (-0.14285714285714285 + 0.14285714285714285 * var_x37);
        const double var_x40 = (0.00048975626611056245 * var_x36 + 0.039337852699643565 * var_x38 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x37)) / (pow(var_x39, 2) * (1.0 + 31.622776601683793 * var_x35));
        const double var_x41 = -25.420807984495319 * var_x9 + var_chaste_interface__membrane__V;
        const double var_x42 = var_x10 * var_x7 * (-1.73 + var_x41) / pow(var_x11, 2);
        const double var_x43 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x44 = 0.001 * var_x43;
        const double var_x45 = log(140.0 * var_x34);
        const double var_x46 = -25.420807984495319 * var_x45 + var_chaste_interface__membrane__V;
        const double var_x47 = var_x43 * var_x46;
        const double var_x48 = pow(var_chaste_interface__sodium_current_m_gate__m, 2) * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j;
        const double var_x49 = 0.00080000000000000004 * var_x47;
        const double var_x50 = var_x22 * var_chaste_interface__sodium_current_h_gate__h;
        const double var_x51 = var_x4 + var_x6;
        const double var_x52 = var_x44 * (2.0150000000000001 - 0.031 * var_chaste_interface__membrane__V);
        const double var_x53 = var_x52 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x54 = 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12;
        const double var_x55 = 0.001 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        const double var_x56 = var_x43 * var_x55;
        const double var_x57 = 0.17794565589146724 * var_x9 - 0.0070000000000000001 * var_chaste_interface__membrane__V;
        const double var_x58 = 0.001 * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss;
        const double var_x59 = var_x34 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y;
        const double var_x60 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2);
        const double var_x61 = 1.2 * var_x17 - 2744000.0 * var_x19;
        const double var_x62 = var_x61 / pow((0.0036443148688046646 + 4.3731778425655972e-7 * var_x13 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
        const double var_x63 = var_x60 * var_x62;
        const double var_x64 = var_x14 * var_x16 * var_x60;
        const double var_x65 = var_x34 * var_x35 / (var_x39 * pow((0.031622776601683791 + var_x35), 2));
        const double var_x66 = var_x24 * var_x34;
        const double var_x67 = 0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x68 = 1 / var_x67;
        const double var_x69 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x70 = var_chaste_interface__intracellular_ion_concentrations__Ca_i / pow(var_x67, 2);
        const double var_x71 = var_x14 * var_x18;
        const double var_x72 = var_x8 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y;
        const double var_x73 = 25.420807984495319 * var_x8;
        const double var_x74 = var_x21 * var_x8;
        const double var_x75 = var_x12 * var_x8;
        const double var_x76 = var_x33 * var_x8;
        const double var_x77 = var_x42 * var_x8;
        const double var_x78 = exp(-6.9230769230769234 - 0.15384615384615385 * var_chaste_interface__membrane__V);
        const double var_x79 = 1.0 + var_x78;
        const double var_x80 = -0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x81 = exp(-4.7130000000000001 + var_x80);
        const double var_x82 = 1.0 - var_x81;
        const double var_x83 = 1 / var_x82;
        const double var_x84 = 235.29411764705881 * var_x83;
        const double var_x85 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x86 = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_x87 = exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V);
        const double var_x88 = 1.0 + var_x87;
        const double var_x89 = 0.001 / var_x88;
        const double var_x90 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
        const double var_x91 = var_chaste_interface__membrane__V >= -40.0;
        const double var_x92 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
        const double var_x93 = exp(0.34999999999999998 * var_chaste_interface__membrane__V);
        const double var_x94 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x95 = ((var_x91) ? (1 / (0.00045370000000000002 + 0.00045370000000000002 * var_x90)) : (88825214.899713472 * var_x93 + 38.681948424068771 * var_x94 + 1020.0573065902579 * var_x92));
        const double var_x96 = 0.00016474464579901152 * var_x87 / pow(var_x88, 2);
        const double var_x97 = exp(-3.2000000000000002 + var_x80);
        const double var_x98 = 1.0 + var_x97;
        const double var_x99 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V);
        const double var_x100 = var_x99 / var_x98;
        const double var_x101 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
        const double var_x102 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
        const double var_x103 = -127140.0 * var_x101 - 3.4740000000000003e-5 * var_x102;
        const double var_x104 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
        const double var_x105 = 1.0 + var_x104;
        const double var_x106 = 286.53295128939828 / var_x105;
        const double var_x107 = var_x103 * var_x106;
        const double var_x108 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
        const double var_x109 = 1.0 + var_x108;
        const double var_x110 = exp(-0.01052 * var_chaste_interface__membrane__V);
        const double var_x111 = var_x110 / var_x109;
        const double var_x112 = 37.780000000000001 + var_chaste_interface__membrane__V;
        const double var_x113 = ((var_x91) ? (85.984522785898534 * var_x100) : (34.727793696275072 * var_x111 + var_x107 * var_x112));
        const double var_x114 = exp(-0.64800000000000002 * pow((-1 + 0.055555555555555552 * var_chaste_interface__membrane__V), 2));
        const double var_x115 = exp(-0.22049999999999997 * pow((1 + 0.14285714285714285 * var_chaste_interface__membrane__V), 2));
        const double var_x116 = -0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x117 = exp(-3.0600000000000001 + var_x116);
        const double var_x118 = 1.0 + var_x117;
        const double var_x119 = 0.0010499999999999999 * var_x114;
        const double var_x120 = 0.0030500000000000002 * var_x115;
        const double var_x121 = 1 / (0.00025000000000000001 + var_x119 + var_x120);
        const double var_x122 = exp(1.0 + var_x29);
        const double var_x123 = 1.0 + var_x122;
        const double var_x124 = 1 / var_x123;
        const double var_x125 = exp(3.0 + var_x27);
        const double var_x126 = 1.0 + var_x125;
        const double var_x127 = 1 / var_x126;
        const double var_x128 = exp(-14.0625 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2));
        const double var_x129 = exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V);
        const double var_x130 = 1.0 + var_x129;
        const double var_x131 = 1 / var_x130;
        const double var_x132 = 0.00059999999999999995 * var_x125 / pow(var_x126, 2);
        const double var_x133 = 0.105 * var_x128;
        const double var_x134 = 0.0016999999999999999 + 0.014999999999999999 * var_x127;
        const double var_x135 = 1 / (var_x133 + var_x134 + 0.040000000000000001 * var_x124);
        const double var_x136 = 0.00018518518518518518 * var_x129 / pow(var_x130, 2);
        const double var_x137 = exp(-11.0 + var_x116);
        const double var_x138 = 1.0 + var_x137;
        const double var_x139 = 1 / var_x138;
        const double var_x140 = exp(-15.340277777777779 * pow((1 + 0.021276595744680851 * var_chaste_interface__membrane__V), 2));
        const double var_x141 = 0.041000000000000002 * var_x140;
        const double var_x142 = 1 / (var_x134 + var_x141 + 0.080000000000000002 * var_x139);
        const double var_x143 = exp(-0.92819614711033271 - 0.087565674255691769 * var_chaste_interface__membrane__V);
        const double var_x144 = 1.0 + var_x143;
        const double var_x145 = exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V);
        const double var_x146 = exp(-3.8000000000000003 + var_x80);
        const double var_x147 = pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2);
        const double var_x148 = exp(-21.777777777777779 * var_x147);
        const double var_x149 = 1 / (0.035000000000000003 + 0.34999999999999998 * var_x148);
        const double var_x150 = exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V);
        const double var_x151 = 1.0 + var_x150;
        const double var_x152 = 0.00014526227103034528 * var_x150 / pow(var_x151, 2);
        const double var_x153 = 1 / var_x151;
        const double var_x154 = exp(-5.4444444444444446 * var_x147);
        const double var_x155 = 1 / (0.035000000000000003 + 3.7000000000000002 * var_x154);
        const double var_x156 = exp(-0.97292724196277491 - 0.084602368866328256 * var_chaste_interface__membrane__V);
        const double var_x157 = 1.0 + var_x156;
        const double var_x158 = exp(8.4951456310679614 + 0.097087378640776698 * var_chaste_interface__membrane__V);
        const double var_x159 = exp(13.225190839694655 + 0.095419847328244267 * var_chaste_interface__membrane__V);
        const double var_x160 = 1.0 + var_x159;
        const double var_x161 = exp(2.8198801550934083 + 0.035248501938667604 * var_chaste_interface__membrane__V);
        const double var_x162 = exp(-5.6377730796335452 - 0.070472163495419307 * var_chaste_interface__membrane__V);
        const double var_x163 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0);
        const double var_x164 = 4050000.0 * var_x163;
        const double var_x165 = 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0);
        const double var_x166 = 48600000000.0 * var_x163 * var_chaste_interface__SR_Ca_release_channel__P_C1;
        const double var_x167 = 12150000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 2.0) * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x168 = 40.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa;
        const double var_x169 = 0.00088581970078959317 * var_x46;
        const double var_x170 = 0.00014999999999999999 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x171 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x172 = 1.0 + 0.0014999999999999998 / pow(var_x170, 2) + 0.00011900000000000002 / pow(var_x171, 2);
        const double var_x173 = 1 / var_x172;
        const double var_x174 = 0.001 * var_x173;
        const double var_x175 = 200000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x176 = 40000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x177 = 0.0022145492519739826 * var_x68;
        const double var_x178 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2);
        const double var_x179 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0);
        const double var_x180 = 1 / (1.0 + 33855.471141425078 * var_x178 + 0.303951367781155 * var_x179);
        const double var_x181 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 0.19999999999999996);
        const double var_x182 = var_x180 * var_x181;
        const double var_x183 = 1354.2188456570032 * var_x178 - 0.2735562310030395 * var_x179;
        const double var_x184 = var_x183 / pow((2.9537323401073989e-5 + var_x178 + 8.9779098483507565e-6 * var_x179), 2);
        const double var_x185 = var_x181 * var_x184;
        const double var_x186 = -3.4336586151856603e-5 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s - 4.4180257576880957e-6 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow;
        const double var_x187 = var_x186 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        const double var_x188 = 0.00019703470957323427 * var_x9 - 7.7509223819089404e-6 * var_chaste_interface__membrane__V;
        const double var_x189 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x190 = 1.0 + 0.00011900000000000002 / pow(var_x189, 2);
        const double var_x191 = 1 / var_x190;
        const double var_x192 = 0.001 * var_x191;
        const double var_x193 = var_x192 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x194 = 870.15176483187713 - 13.386950228182727 * var_chaste_interface__membrane__V;
        const double var_x195 = var_x193 * var_x194;
        const double var_x196 = var_x192 * (84000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 84000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss);
        const double var_x197 = 84000.0 * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x198 = 84000.0 * var_chaste_interface__SR_Ca_release_channel__P_O2;
        const double var_x199 = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2);
        const double var_x200 = 0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR;
        const double var_x201 = pow(var_x200, (-2));
        const double var_x202 = 1 / (1.0 + 12.0 * var_x201);
        const double var_x203 = 0.001 * var_x202;
        const double var_x204 = var_x203 * (1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR);
        const double var_x205 = 1800.0 * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x206 = 1800.0 * var_chaste_interface__SR_Ca_release_channel__P_O2;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * (-0.00025054999999999999 + var_x1 + 0.0015228469537086019 * var_x42 - 0.0014499999999999999 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.024 * var_x12 - 0.80000000000000004 * var_x24 - 9.9839999999999996e-6 * var_x20 - 0.0070000000000000001 * var_x21 - 0.0048000000000000004 * var_x32 - 5.8823529411764709e-6 * var_x33 - 0.062608695652173918 * var_x40 + (-0.031 * var_x4 - 0.031 * var_x6) * var_chaste_interface__L_type_Ca_channel_d_gate__d));
        IJth(rJacobian, 1, 0) = (0.001 / var_x79 - 0.001 * var_chaste_interface__sodium_current_m_gate__m) * (var_x84 - 5.3475935828877006 * var_x85 - 23.529411764705884 * var_x81 * var_x86 / pow(var_x82, 2)) + 0.00015384615384615385 * var_x78 * (58.823529411764703 * var_x85 + var_x84 * var_x86) / pow(var_x79, 2);
        IJth(rJacobian, 2, 0) = (var_x89 - 0.001 * var_chaste_interface__sodium_current_h_gate__h) * ((var_x91) ? (198.5675338110868 * var_x90 / pow((1 + var_x90), 2)) : (80.584527220630378 * var_x92 + 31088825.214899711 * var_x93 - 5.6885218270689366 * var_x94)) - var_x95 * var_x96;
        IJth(rJacobian, 3, 0) = (var_x89 - 0.001 * var_chaste_interface__sodium_current_j_gate__j) * ((var_x91) ? (-2.1797076526225279e-5 * var_x100 + 8.5984522785898552 * var_x97 * var_x99 / pow(var_x98, 2)) : (var_x107 - 0.36533638968481374 * var_x111 + var_x106 * var_x112 * (1.5254334000000001e-6 * var_x102 - 31073.016 * var_x101) + 4.7854899713467054 * var_x108 * var_x110 / pow(var_x109, 2) - 89.11174785100286 * var_x103 * var_x104 * var_x112 / pow(var_x105, 2))) - var_x113 * var_x96;
        IJth(rJacobian, 4, 0) = 107.49798441279225 * (-var_chaste_interface__L_type_Ca_channel_d_gate__d + 1 / var_x118) * (-var_x119 * (0.072000000000000008 - 0.0040000000000000001 * var_chaste_interface__membrane__V) - var_x120 * (-0.063 - 0.0089999999999999993 * var_chaste_interface__membrane__V)) / pow((0.081967213114754092 + var_x115 + 0.34426229508196715 * var_x114), 2) + 0.00020000000000000001 * var_x117 * var_x121 / pow(var_x118, 2);
        IJth(rJacobian, 5, 0) = -var_x135 * var_x136 + 0.090702947845805001 * (var_x131 - var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * (var_x132 - var_x133 * (-0.625 - 0.013888888888888888 * var_chaste_interface__membrane__V) - 0.0016000000000000001 * var_x122 / pow(var_x123, 2)) / pow((0.016190476190476189 + var_x128 + 0.38095238095238099 * var_x124 + 0.14285714285714285 * var_x127), 2);
        IJth(rJacobian, 6, 0) = -var_x136 * var_x142 + 0.15625 * (var_x131 - var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12) * (var_x132 - var_x141 * (-0.65277777777777779 - 0.013888888888888888 * var_chaste_interface__membrane__V) - 0.016 * var_x137 / pow(var_x138, 2)) / pow((0.021249999999999998 + var_x139 + 0.51249999999999996 * var_x140 + 0.1875 * var_x127), 2);
        IJth(rJacobian, 8, 0) = (-var_x55 + 0.001 / var_x144) * (1.6153732000000001 * var_x145 - 9.8900000000000006 * var_x146) + 8.7565674255691772e-5 * var_x143 * (45.159999999999997 * var_x145 + 98.900000000000006 * var_x146) / pow(var_x144, 2);
        IJth(rJacobian, 9, 0) = -var_x149 * var_x152 - 0.0028571428571428571 * var_x148 * (-0.62222222222222223 - 0.0088888888888888889 * var_chaste_interface__membrane__V) * (var_x153 - var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s) / pow((0.10000000000000002 + var_x148), 2);
        IJth(rJacobian, 10, 0) = -var_x152 * var_x155 - 0.00027027027027027027 * var_x154 * (-0.15555555555555556 - 0.0022222222222222222 * var_chaste_interface__membrane__V) * (var_x153 - var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) / pow((0.00945945945945946 + var_x154), 2);
        IJth(rJacobian, 11, 0) = (-var_x58 + 0.001 / var_x157) * (0.16153732000000001 * var_x145 - 0.9890000000000001 * var_x146) + 8.4602368866328257e-5 * var_x156 * (9.8900000000000006 * var_x146 + 4.516 * var_x145) / pow(var_x157, 2);
        IJth(rJacobian, 12, 0) = -4.6232085067036518e-5 * var_x158 / pow((1.0 + var_x158), 2);
        IJth(rJacobian, 13, 0) = (0.001 / var_x160 - 0.001 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) * (0.0041892844554106447 * var_x161 - 0.039626497533474282 * var_x162) - 9.5419847328244274e-5 * var_x159 * (0.56230000000000002 * var_x162 + 0.11885 * var_x161) / pow(var_x160, 2);
        IJth(rJacobian, 20, 0) = -8.8748061272857348e-8 - 3.3165089597562367e-8 * var_x20 - 3.2110964153622751e-7 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00020797506018538275 * var_x40 - 0.00088581970078959317 * var_x24;
        IJth(rJacobian, 21, 0) = var_x174 * (-1.7937848940989261e-5 + 1.1055029865854122e-5 * var_x20);
        IJth(rJacobian, 22, 0) = -1.528038983862048e-7 + var_x187 + 0.00013865004012358849 * var_x40 + 1.6862097911031213e-6 * var_x42 - 5.3149182047375591e-6 * var_x32 - 2.6574591023687795e-5 * var_x12 - 6.5133801528646552e-9 * var_x33 - 7.7509223819089404e-6 * var_x21 - 1.2844385661449098e-6 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y;
        IJth(rJacobian, 23, 0) = var_x193 * (-13.386950228182727 * var_x4 - 13.386950228182727 * var_x6);
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0024000000000000002 * var_x47 * var_x48);
        IJth(rJacobian, 1, 1) = -0.058823529411764705 * var_x85 - 0.23529411764705882 * var_x83 * var_x86;
        IJth(rJacobian, 20, 1) = -0.0026574591023687793 * var_x46 * var_x48;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x23 * var_x49);
        IJth(rJacobian, 2, 2) = -0.001 * var_x95;
        IJth(rJacobian, 20, 2) = -var_x169 * var_x23;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x49 * var_x50);
        IJth(rJacobian, 3, 3) = -0.001 * var_x113;
        IJth(rJacobian, 20, 3) = -var_x169 * var_x50;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (var_x51 * var_x52);
        IJth(rJacobian, 4, 4) = -0.001 * var_x121;
        IJth(rJacobian, 23, 4) = var_x192 * var_x194 * var_x51;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (var_x5 * var_x53);
        IJth(rJacobian, 5, 5) = -0.001 * var_x135;
        IJth(rJacobian, 23, 5) = var_x195 * var_x5;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (var_x3 * var_x53);
        IJth(rJacobian, 6, 6) = -0.001 * var_x142;
        IJth(rJacobian, 23, 6) = var_x195 * var_x3;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (var_x53 * var_x54);
        IJth(rJacobian, 7, 7) = -0.11111111111111112;
        IJth(rJacobian, 23, 7) = var_x195 * var_x54;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * var_x41 * var_x44);
        IJth(rJacobian, 8, 8) = -0.045159999999999999 * var_x145 - 0.098900000000000002 * var_x146;
        IJth(rJacobian, 22, 8) = var_x186 * var_x41;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (var_x56 * (0.7882992555992 * var_x9 - 0.031010000000000003 * var_chaste_interface__membrane__V));
        IJth(rJacobian, 9, 9) = -0.001 * var_x149;
        IJth(rJacobian, 22, 9) = (0.00087286376340942788 * var_x9 - 3.4336586151856603e-5 * var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (var_x56 * (0.10142902385813635 * var_x9 - 0.0039900000000000005 * var_chaste_interface__membrane__V));
        IJth(rJacobian, 10, 10) = -0.001 * var_x155;
        IJth(rJacobian, 22, 10) = (0.00011230978445674354 * var_x9 - 4.4180257576880957e-6 * var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * var_x57 * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss);
        IJth(rJacobian, 11, 11) = -0.0098900000000000012 * var_x146 - 0.004516 * var_x145;
        IJth(rJacobian, 22, 11) = var_x188 * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (var_x43 * var_x57 * var_x58);
        IJth(rJacobian, 12, 12) = -0.00047619047619047619;
        IJth(rJacobian, 22, 12) = var_x188 * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * (0.0073720343155036427 * var_x45 + 0.029488137262014571 * var_x9 - 0.0014499999999999999 * var_chaste_interface__membrane__V));
        IJth(rJacobian, 13, 13) = -0.00056230000000000006 * var_x162 - 0.00011885 * var_x161;
        IJth(rJacobian, 20, 13) = 8.1628665394625614e-6 * var_x45 - 3.2110964153622751e-7 * var_chaste_interface__membrane__V;
        IJth(rJacobian, 22, 13) = 3.2651466157850246e-5 * var_x9 - 1.2844385661449098e-6 * var_chaste_interface__membrane__V;
        IJth(rJacobian, 14, 14) = -0.67600000000000005 - var_x164;
        IJth(rJacobian, 15, 14) = var_x164;
        IJth(rJacobian, 16, 14) = 0.57599999999999996;
        IJth(rJacobian, 17, 14) = 0.10000000000000001;
        IJth(rJacobian, 23, 14) = var_x196;
        IJth(rJacobian, 24, 14) = var_x204;
        IJth(rJacobian, 14, 15) = 1.9299999999999999;
        IJth(rJacobian, 15, 15) = -1.9299999999999999;
        IJth(rJacobian, 23, 15) = var_x196;
        IJth(rJacobian, 24, 15) = var_x204;
        IJth(rJacobian, 14, 16) = var_x165;
        IJth(rJacobian, 16, 16) = -var_x165;
        IJth(rJacobian, 14, 17) = 0.00080000000000000004;
        IJth(rJacobian, 17, 17) = -0.00080000000000000004;
        IJth(rJacobian, 18, 18) = -6.6000000000000005e-5 - 200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        IJth(rJacobian, 21, 18) = var_x174 * (0.066000000000000003 + var_x175);
        IJth(rJacobian, 19, 19) = -0.040000000000000001 - 40.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        IJth(rJacobian, 21, 19) = var_x174 * (40.0 + var_x176);
        IJth(rJacobian, 0, 20) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * (4.7735212368995909e-14 * var_x63 - 0.0020374777599573 * var_x34 - 0.0029697911938972605 * var_x65 - 0.0073720343155036427 * var_x59 - 3.5942399999999997e-5 * var_x64 - 20.336646387596257 * var_x66));
        IJth(rJacobian, 20, 20) = 1.5856796826686865e-16 * var_x63 - 2.2560474246135324e-6 * var_x34 - 1.193943225512245e-7 * var_x64 - 0.022518252522655345 * var_x66 - 8.1628665394625614e-6 * var_x59 - 9.8651233004461501e-6 * var_x65;
        IJth(rJacobian, 21, 20) = var_x174 * (3.9798107517074834e-5 * var_x64 - 5.2855989422289547e-14 * var_x63);
        IJth(rJacobian, 22, 20) = 6.5767488669640998e-6 * var_x65;
        IJth(rJacobian, 0, 21) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * (0.0040000000000000001 * var_x70 + 3.6384839650145766e-8 * var_x62 + 27.396096 * var_x71 - 0.0040000000000000001 * var_x68 - 0.00041181708934882422 * var_x69));
        IJth(rJacobian, 18, 21) = 28.000000000000004 - 200.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa;
        IJth(rJacobian, 19, 21) = 2.8000000000000003 - var_x168;
        IJth(rJacobian, 20, 21) = 0.091005005855711127 * var_x71 + 1.2086402914563544e-10 * var_x62;
        IJth(rJacobian, 21, 21) = var_x174 * (-30837.453183520603 - var_x177 + 40000.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + 200000.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 3.5444788081288787e-5 * var_x185 + 0.0022145492519739826 * var_x70 - 4.0288009715211813e-8 * var_x62 - 0.00022799730679188537 * var_x69 - 30.33500195190371 * var_x71 - 1625.0626147884036 * var_x182) + 0.001 * (0.0029999999999999996 / pow(var_x170, 3) + 0.00023800000000000004 / pow(var_x171, 3)) * (var_x168 + 0.066000000000000003 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 0.00022799730679188537 * log(1.2 * var_x69) + 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 1.7937848940989261e-5 * var_chaste_interface__membrane__V - var_x175 * (0.14000000000000001 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa) - var_x176 * (0.070000000000000007 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa) - var_x177 * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 1.1055029865854122e-5 * var_x14 * var_x61 - 1.0 * var_x180 * var_x183) / pow(var_x172, 2);
        IJth(rJacobian, 23, 21) = 29.213483146067414 * var_x191;
        IJth(rJacobian, 25, 21) = 3.0179734274641783 * var_x182 - 6.5826035008107738e-8 * var_x185;
        IJth(rJacobian, 0, 22) = mSetVoltageDerivativeToZero ? 0.0 : (var_x44 * (0.038712000000000003 * var_x77 - 0.17794565589146724 * var_x74 - 0.61009939162788773 * var_x75 - 0.00014953416461467836 * var_x76 - 0.0035080715018603542 * var_x8 - 0.029488137262014571 * var_x72 + var_x1 * var_x73));
        IJth(rJacobian, 22, 22) = 4.286481532120841e-5 * var_x77 - 3.2651466157850246e-5 * var_x72 - 3.8843985601580465e-6 * var_x8 - 0.00019703470957323427 * var_x74 - 0.00067554757567966038 * var_x75 - 1.6557538619599519e-7 * var_x76 + var_x187 * var_x73;
        IJth(rJacobian, 7, 23) = -0.0011111111111111113 / pow((0.01 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss), 2);
        IJth(rJacobian, 14, 23) = var_x166 - var_x167;
        IJth(rJacobian, 15, 23) = var_x167;
        IJth(rJacobian, 16, 23) = -var_x166;
        IJth(rJacobian, 21, 23) = 0.037453183520599252 * var_x173;
        IJth(rJacobian, 23, 23) = var_x192 * (-29213.483146067414 - var_x197 - var_x198) + 2.3800000000000004e-7 * (29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 84000.0 * var_x199 - 29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 13.386950228182727 * var_x51 * (-65.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_Ca_channel_d_gate__d) / (pow(var_x189, 3) * pow(var_x190, 2));
        IJth(rJacobian, 24, 23) = var_x203 * (var_x205 + var_x206);
        IJth(rJacobian, 23, 24) = var_x192 * (var_x197 + var_x198);
        IJth(rJacobian, 24, 24) = var_x203 * (-1740.0382808421784 - var_x205 - var_x206) + 0.00016666666666666666 * (1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR - 1800.0 * var_x199 - 1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) / (pow(var_x200, 3) * pow((0.083333333333333329 + var_x201), 2));
        IJth(rJacobian, 25, 24) = 0.19333758676024207;
        IJth(rJacobian, 21, 25) = var_x174 * (0.2735562310030395 * var_x180 + 2.651834266564234e-10 * var_x184);
        IJth(rJacobian, 24, 25) = 1.7400382808421784 * var_x202;
        IJth(rJacobian, 25, 25) = -0.19333758676024207 - 4.9248350664764349e-13 * var_x184 - 0.00050803300043421621 * var_x180;
    }

    N_Vector Cellpandit_model_2001_epiFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        NV_Ith_S(dqs, 1) = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "pandit_model_2001_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.50146);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004164108);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6735613);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6729362);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.171081e-06);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("L_type_Ca_channel_f_11_gate__f_11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("L_type_Ca_channel_f_12_gate__f_12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_inact_gate__Ca_inact");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913102);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002191519);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9842542);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_slow_gate__s_slow");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6421196);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("steady_state_outward_K_current_r_ss_gate__r_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002907171);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("steady_state_outward_K_current_s_ss_gate__s_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3142767);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003578708);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004327548);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.06254e-10);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6348229);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3647471);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1394301);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0051619);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.73519);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.901351e-05);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.2751);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.737212e-05);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06607948);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06600742);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellpandit_model_2001_epiFromCellMLCvode)
#endif // CHASTE_CVODE
