#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: NN_SAN_model_1984
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_noble_SAN_model_1984.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    double Cellnoble_noble_SAN_model_1984FromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellnoble_noble_SAN_model_1984FromCellMLCvode::Cellnoble_noble_SAN_model_1984FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                15,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_noble_SAN_model_1984FromCellMLCvode>::Instance();
        Init();
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 0.0060000000000000001; // (var_membrane__C) [microF]
    }

    Cellnoble_noble_SAN_model_1984FromCellMLCvode::~Cellnoble_noble_SAN_model_1984FromCellMLCvode()
    {
    }
    
    double Cellnoble_noble_SAN_model_1984FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__intracellular_calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 5.8e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__second_inward_current_f2_gate__f2 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_sodium_concentration__Nai = NV_Ith_S(rY, 9);
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__extracellular_potassium_concentration__Kc = NV_Ith_S(rY, 13);
        // Units: millimolar; Initial value: 3.0
        double var_chaste_interface__intracellular_potassium_concentration__Ki = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.01; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 1.25; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 6.0; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 6.0; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 7.5; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.070000000000000007; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 50.0; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_chaste_interface__extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 20.0; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.75; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_chaste_interface__extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_f + var_second_inward_current__i_si + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_p + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * HeartConfig::Instance()->GetCapacitance() / NV_Ith_S(mParameters, 0); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_noble_SAN_model_1984FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__intracellular_calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 5.8e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__second_inward_current_f2_gate__f2 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_sodium_concentration__Nai = NV_Ith_S(rY, 9);
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = NV_Ith_S(rY, 10);
        // Units: millimolar; Initial value: 1.98
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = NV_Ith_S(rY, 11);
        // Units: millimolar; Initial value: 0.55
        double var_chaste_interface__intracellular_calcium_concentration__p = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__extracellular_potassium_concentration__Kc = NV_Ith_S(rY, 13);
        // Units: millimolar; Initial value: 3.0
        double var_chaste_interface__intracellular_potassium_concentration__Ki = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 140.0

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.01; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kb = 3.0; // millimolar
        const double var_extracellular_potassium_concentration__V_e = 0.00016076999999999999; // micrometre3
        const double var_extracellular_potassium_concentration__pf = 1.0; // per_second
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 1.25; // microS
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 6.0; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 6.0; // microS
        const double var_hyperpolarising_activated_current_y_gate__delta_y = 1.0000000000000001e-5; // millivolt
        const double var_hyperpolarising_activated_current_y_gate__speed_y = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.080000000000000002; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.080000000000000002; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_intracellular_calcium_concentration__V_up = 0.050000000000000003 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_rel + var_intracellular_calcium_concentration__i_tr) / (var_intracellular_calcium_concentration__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_tr + var_intracellular_calcium_concentration__i_up) / (var_intracellular_calcium_concentration__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_hyperpolarising_activated_current__i_fK = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current_y_gate__E0_y = 52.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.050000000000000003 * exp(-0.067000000000000004 * var_hyperpolarising_activated_current_y_gate__E0_y); // per_second
        const double var_hyperpolarising_activated_current_y_gate__beta_y = ((var_hyperpolarising_activated_current_y_gate__delta_y > fabs(var_hyperpolarising_activated_current_y_gate__E0_y)) ? (2.5) : (var_hyperpolarising_activated_current_y_gate__E0_y / (1.0 - 1.0 * exp(-0.20000000000000001 * var_hyperpolarising_activated_current_y_gate__E0_y)))); // per_second
        const double var_hyperpolarising_activated_current_y_gate__y_orig_deriv = ((1.0 - var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__alpha_y - var_hyperpolarising_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__speed_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y = 0.001 * var_hyperpolarising_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_intracellular_calcium_concentration__alpha_p = 0.625 * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__beta_p = 5.0 / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__p_orig_deriv = (1.0 - var_chaste_interface__intracellular_calcium_concentration__p) * var_intracellular_calcium_concentration__alpha_p - var_intracellular_calcium_concentration__beta_p * var_chaste_interface__intracellular_calcium_concentration__p; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__p = 0.001 * var_intracellular_calcium_concentration__p_orig_deriv; // 1 / millisecond
        const double var_second_inward_current__P_si = 7.5; // nanoA_per_millimolar
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_d_gate__delta_d = 0.0001; // millivolt
        const double var_second_inward_current_d_gate__alpha_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__beta_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__d_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_d_gate__d) * var_second_inward_current_d_gate__alpha_d - var_second_inward_current_d_gate__beta_d * var_chaste_interface__second_inward_current_d_gate__d; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_d_gate__d = 0.001 * var_second_inward_current_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_second_inward_current_f2_gate__K_mf2 = 0.00050000000000000001; // millimolar
        const double var_second_inward_current_f2_gate__alpha_f2 = 10.0; // per_second
        const double var_second_inward_current_f2_gate__beta_f2 = var_chaste_interface__intracellular_calcium_concentration__Cai * var_second_inward_current_f2_gate__alpha_f2 / var_second_inward_current_f2_gate__K_mf2; // per_second
        const double var_second_inward_current_f2_gate__f2_orig_deriv = -(var_second_inward_current_f2_gate__alpha_f2 + var_second_inward_current_f2_gate__beta_f2) * var_chaste_interface__second_inward_current_f2_gate__f2 + var_second_inward_current_f2_gate__alpha_f2; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.001 * var_second_inward_current_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_second_inward_current_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_f_gate__beta_f = 50.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_second_inward_current_f_gate__delta_f = 0.0001; // millivolt
        const double var_second_inward_current_f_gate__alpha_f = ((var_second_inward_current_f_gate__delta_f > fabs(var_second_inward_current_f_gate__E0_f)) ? (25.0) : (6.25 * var_second_inward_current_f_gate__E0_f / (-1.0 + exp(0.25 * var_second_inward_current_f_gate__E0_f)))); // per_second
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_intracellular_calcium_concentration__Cai_orig_deriv = -0.5 * (-var_intracellular_calcium_concentration__i_rel - 2.0 * var_Na_Ca_exchanger__i_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_calcium_background_current__i_Ca_b + var_intracellular_calcium_concentration__i_up + var_second_inward_current__i_siCa) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.001 * var_intracellular_calcium_concentration__Cai_orig_deriv; // millimolar / millisecond
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current_f_gate__f_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_f_gate__f) * var_second_inward_current_f_gate__alpha_f - var_second_inward_current_f_gate__beta_f * var_chaste_interface__second_inward_current_f_gate__f; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f_gate__f = 0.001 * var_second_inward_current_f_gate__f_orig_deriv; // 1 / millisecond
        const double var_sodium_background_current__g_Nab = 0.070000000000000007; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 50.0; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_chaste_interface__extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Nai_orig_deriv = -1.0 * (3.0 * var_sodium_potassium_pump__i_p + var_Na_Ca_exchanger__i_NaCa * var_Na_Ca_exchanger__n_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_fNa + var_second_inward_current__i_siNa + var_sodium_background_current__i_Na_b) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = 0.001 * var_intracellular_sodium_concentration__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K_max = 20.0; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current_x_gate__E0_x = 22.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_time_dependent_potassium_current_x_gate__delta_x = 0.0001; // millivolt
        const double var_time_dependent_potassium_current_x_gate__alpha_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (0.5 * var_time_dependent_potassium_current_x_gate__E0_x / (1.0 - exp(-0.20000000000000001 * var_time_dependent_potassium_current_x_gate__E0_x)))); // per_second
        const double var_time_dependent_potassium_current_x_gate__beta_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (0.17799999999999999 * var_time_dependent_potassium_current_x_gate__E0_x / (-1.0 + exp(0.066666666666666666 * var_time_dependent_potassium_current_x_gate__E0_x)))); // per_second
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_potassium_current_x_gate__x_orig_deriv = (1.0 - var_chaste_interface__time_dependent_potassium_current_x_gate__x) * var_time_dependent_potassium_current_x_gate__alpha_x - var_time_dependent_potassium_current_x_gate__beta_x * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // 1 / second
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x = 0.001 * var_time_dependent_potassium_current_x_gate__x_orig_deriv; // 1 / millisecond
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.75; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_chaste_interface__extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_extracellular_potassium_concentration__i_mK = -2.0 * var_sodium_potassium_pump__i_p + var_hyperpolarising_activated_current__i_fK + var_second_inward_current__i_siK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // nanoA
        const double var_extracellular_potassium_concentration__Kc_orig_deriv = -(-var_extracellular_potassium_concentration__Kb + var_chaste_interface__extracellular_potassium_concentration__Kc) * var_extracellular_potassium_concentration__pf + var_extracellular_potassium_concentration__i_mK / (var_extracellular_potassium_concentration__V_e * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_extracellular_potassium_concentration__Kc = 0.001 * var_extracellular_potassium_concentration__Kc_orig_deriv; // millimolar / millisecond
        const double var_intracellular_potassium_concentration__Ki_orig_deriv = -1.0 * var_extracellular_potassium_concentration__i_mK / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.001 * var_intracellular_potassium_concentration__Ki_orig_deriv; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
            const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
            const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / NV_Ith_S(mParameters, 0); // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_second_inward_current_d_gate__d;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_second_inward_current_f_gate__f;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_intracellular_calcium_concentration__p;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_extracellular_potassium_concentration__Kc;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;
    }

    void Cellnoble_noble_SAN_model_1984FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time_converted, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__intracellular_calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 5.8e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__second_inward_current_f2_gate__f2 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_sodium_concentration__Nai = NV_Ith_S(rY, 9);
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = NV_Ith_S(rY, 10);
        // Units: millimolar; Initial value: 1.98
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = NV_Ith_S(rY, 11);
        // Units: millimolar; Initial value: 0.55
        double var_chaste_interface__intracellular_calcium_concentration__p = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__extracellular_potassium_concentration__Kc = NV_Ith_S(rY, 13);
        // Units: millimolar; Initial value: 3.0
        double var_chaste_interface__intracellular_potassium_concentration__Ki = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 140.0
        
        const double var_x0 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
        const double var_x1 = var_x0 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x2 = 0.074867781645490947 * var_chaste_interface__membrane__V;
        const double var_x3 = var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki;
        const double var_x4 = log(var_x3);
        const double var_x5 = exp(0.74867781645490938 + var_x2 - 2.0 * var_x4);
        const double var_x6 = 1.0 + var_x5;
        const double var_x7 = 1 / var_x6;
        const double var_x8 = 1 / (10.0 + var_chaste_interface__extracellular_potassium_concentration__Kc);
        const double var_x9 = var_x7 * var_x8;
        const double var_x10 = 0.75 * var_x9;
        const double var_x11 = 1 / (45.0 + var_chaste_interface__extracellular_potassium_concentration__Kc);
        const double var_x12 = var_x11 * var_chaste_interface__hyperpolarising_activated_current_y_gate__y;
        const double var_x13 = var_x12 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
        const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
        const double var_x16 = exp(var_x15);
        const double var_x17 = var_x14 * var_x16;
        const double var_x18 = exp(-var_x15);
        const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x22 = var_x20 * var_x21;
        const double var_x23 = var_x22 * (0.037433890822745473 * var_x17 + 51359.298208806787 * var_x19);
        const double var_x24 = -0.037433890822745473 * var_chaste_interface__membrane__V;
        const double var_x25 = exp(var_x24);
        const double var_x26 = var_x25 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x27 = var_x26 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x28 = -26.713760659695652 * var_x4 + var_chaste_interface__membrane__V;
        const double var_x29 = var_x28 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x30 = var_x5 * var_x8 / pow(var_x6, 2);
        const double var_x31 = var_x29 * var_x30;
        const double var_x32 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
        const double var_x33 = var_x32 * var_chaste_interface__second_inward_current_d_gate__d;
        const double var_x34 = exp(3.7433890822745473 - var_x2);
        const double var_x35 = 1.0 - var_x34;
        const double var_x36 = 1 / var_x35;
        const double var_x37 = exp(3.7433890822745473);
        const double var_x38 = -2.0 * var_x34 + var_x37 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        const double var_x39 = var_x36 * var_x38;
        const double var_x40 = 1.1230167246823641 * var_x39;
        const double var_x41 = exp(1.8716945411372736 + var_x24);
        const double var_x42 = 1.0 - var_x41;
        const double var_x43 = 1 / var_x42;
        const double var_x44 = 0.0028075418117059106 * var_x43;
        const double var_x45 = exp(1.8716945411372736);
        const double var_x46 = -140.0 * var_x41 + var_x45 * var_chaste_interface__intracellular_sodium_concentration__Nai;
        const double var_x47 = var_x33 * var_x46;
        const double var_x48 = var_x41 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x49 = -var_x48 + var_x45 * var_chaste_interface__intracellular_potassium_concentration__Ki;
        const double var_x50 = var_x44 * var_x49;
        const double var_x51 = -50.0 + var_chaste_interface__membrane__V;
        const double var_x52 = var_x33 * var_x51;
        const double var_x53 = var_x36 * var_x52;
        const double var_x54 = var_x34 * var_x53;
        const double var_x55 = var_x41 * var_x52;
        const double var_x56 = var_x43 * var_x55;
        const double var_x57 = var_x34 * var_x38 * var_x52 / pow(var_x35, 2);
        const double var_x58 = var_x41 * var_x51 / pow(var_x42, 2);
        const double var_x59 = 0.00010509721365969207 * var_x58;
        const double var_x60 = var_x33 * var_x49;
        const double var_x61 = var_x43 * var_x48 * var_x52;
        const double var_x62 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x63 = 0.001 * var_x62;
        const double var_x64 = 1 / var_chaste_interface__intracellular_calcium_concentration__Cai;
        const double var_x65 = var_x18 * var_x22;
        const double var_x66 = 2.0 * var_x17 - 2744000.0 * var_x19;
        const double var_x67 = var_x21 * var_x66 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x68 = var_x20 * var_x66 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x14 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x69 = var_x37 * var_x53;
        const double var_x70 = 1 / var_chaste_interface__intracellular_sodium_concentration__Nai;
        const double var_x71 = -26.713760659695652 * log(140.0 * var_x70) + var_chaste_interface__membrane__V;
        const double var_x72 = 6.0 * var_x71;
        const double var_x73 = var_x11 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x74 = 6.0 * var_x28;
        const double var_x75 = 1 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki);
        const double var_x76 = 140.0 + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x77 = -26.713760659695652 * log(var_x75 * var_x76) + var_chaste_interface__membrane__V;
        const double var_x78 = var_x77 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 2) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x79 = var_x0 * var_x77;
        const double var_x80 = var_x32 * var_x51;
        const double var_x81 = var_x44 * var_x46;
        const double var_x82 = var_x51 * var_chaste_interface__second_inward_current_d_gate__d;
        const double var_x83 = var_x82 * var_chaste_interface__second_inward_current_f2_gate__f2;
        const double var_x84 = var_x82 * var_chaste_interface__second_inward_current_f_gate__f;
        const double var_x85 = 1.0 + var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x86 = 1 / var_x85;
        const double var_x87 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai);
        const double var_x88 = var_x86 * var_x87;
        const double var_x89 = 50.0 * var_x88;
        const double var_x90 = var_x1 * var_x75;
        const double var_x91 = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai;
        const double var_x92 = var_x86 * var_x91 / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Nai), 2);
        const double var_x93 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 2.0);
        const double var_x94 = var_x68 * var_x93;
        const double var_x95 = var_x16 * var_x22 * var_x93;
        const double var_x96 = 160.28256395817391 * var_x12;
        const double var_x97 = var_x70 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x98 = var_x45 * var_x52;
        const double var_x99 = -var_x44 * var_x98;
        const double var_x100 = 20.035320494771739 * var_x9;
        const double var_x101 = 0.14285714285714285 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x102 = var_x1 / var_x76;
        const double var_x103 = var_x87 * var_x91 / pow(var_x85, 2);
        const double var_x104 = var_x29 * var_x7 / pow((1 + 0.10000000000000001 * var_chaste_interface__extracellular_potassium_concentration__Kc), 2);
        const double var_x105 = var_chaste_interface__hyperpolarising_activated_current_y_gate__y / pow((1 + 0.022222222222222223 * var_chaste_interface__extracellular_potassium_concentration__Kc), 2);
        const double var_x106 = 0.0029629629629629628 * var_x105;
        const double var_x107 = var_x71 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x108 = var_x28 * var_x30;
        const double var_x109 = 1.5 * var_x108;
        const double var_x110 = 4.0200601101640967e-6 * var_x39;
        const double var_x111 = 0.0040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x112 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
        const double var_x113 = 3.9999999999999998e-6 + var_x112;
        const double var_x114 = 1 / var_x113;
        const double var_x115 = var_x114 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 1.0);
        const double var_x116 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 3.0) / pow(var_x113, 2);
        const double var_x117 = var_x112 * var_x114;
        const double var_x118 = exp(-3.484 - 0.067000000000000004 * var_chaste_interface__membrane__V);
        const double var_x119 = 52.0 + var_chaste_interface__membrane__V;
        const double var_x120 = fabs(var_x119) < 1.0000000000000001e-5;
        const double var_x121 = exp(-10.4 - 0.20000000000000001 * var_chaste_interface__membrane__V);
        const double var_x122 = 1.0 - 1.0 * var_x121;
        const double var_x123 = 1 / var_x122;
        const double var_x124 = 0.001 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x125 = 22.0 + var_chaste_interface__membrane__V;
        const double var_x126 = fabs(var_x125) < 0.0001;
        const double var_x127 = exp(-4.4000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane__V);
        const double var_x128 = 1.0 - var_x127;
        const double var_x129 = 0.5 / var_x128;
        const double var_x130 = exp(1.4666666666666666 + 0.066666666666666666 * var_chaste_interface__membrane__V);
        const double var_x131 = -1.0 + var_x130;
        const double var_x132 = 0.17799999999999999 / var_x131;
        const double var_x133 = 41.0 + var_chaste_interface__membrane__V;
        const double var_x134 = fabs(var_x133) < 1.0000000000000001e-5;
        const double var_x135 = -0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x136 = exp(-4.1000000000000005 + var_x135);
        const double var_x137 = 1.0 - var_x136;
        const double var_x138 = 200.0 / var_x137;
        const double var_x139 = exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
        const double var_x140 = exp(-9.375 - 0.125 * var_chaste_interface__membrane__V);
        const double var_x141 = exp(-7.5 + var_x135);
        const double var_x142 = 0.001 * var_chaste_interface__second_inward_current_d_gate__d;
        const double var_x143 = 19.0 + var_chaste_interface__membrane__V;
        const double var_x144 = fabs(var_x143) < 0.0001;
        const double var_x145 = 0.25 * var_chaste_interface__membrane__V;
        const double var_x146 = -var_x145;
        const double var_x147 = exp(-4.75 + var_x146);
        const double var_x148 = 1.0 - var_x147;
        const double var_x149 = 30.0 / var_x148;
        const double var_x150 = exp(1.8999999999999999 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x151 = -1.0 + var_x150;
        const double var_x152 = 12.0 / var_x151;
        const double var_x153 = 34.0 + var_chaste_interface__membrane__V;
        const double var_x154 = fabs(var_x153) < 0.0001;
        const double var_x155 = exp(8.5 + var_x145);
        const double var_x156 = -1.0 + var_x155;
        const double var_x157 = 6.25 / var_x156;
        const double var_x158 = exp(-8.5 + var_x146);
        const double var_x159 = 1.0 + var_x158;
        const double var_x160 = -4.2956369448205359e-5 * var_x13;
        const double var_x161 = 2.0100300550820484e-8 * var_x43;
        const double var_x162 = 7.5243245632378463e-10 * var_x58;
        const double var_x163 = 4.2956369448205359e-5 * var_x71;
        const double var_x164 = var_x161 * var_x46;
        const double var_x165 = 0.0010739092362051341 * var_x88;
        const double var_x166 = 0.0011475261722488205 * var_x12;
        const double var_x167 = -var_x161 * var_x98;
        const double var_x168 = 2.1213021949731043e-8 * var_x105;
        const double var_x169 = 0.002 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x170 = 0.19999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x171 = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x172 = 1.0 - var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x173 = exp(16.0 + var_x145);
        const double var_x174 = -1.0 + var_x173;
        const double var_x175 = 0.00062500000000000001 / var_x174;
        const double var_x176 = exp(-16.0 + var_x146);
        const double var_x177 = 1.0 + var_x176;
        const double var_x178 = 64.0 + var_chaste_interface__membrane__V;
        const double var_x179 = 4.8349825755906823e-5 * var_x9;
        const double var_x180 = 1.8099220986453831e-7 * var_x43;
        const double var_x181 = 0.00038679860604725458 * var_x28;
        const double var_x182 = var_x180 * var_x49;
        const double var_x183 = 0.0064466434341209095 * var_x88;
        const double var_x184 = 9.2094906201727277e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x185 = 0.0012916056731812832 * var_x9;
        const double var_x186 = 0.010332845385450266 * var_x12;
        const double var_x187 = 9.6699651511813646e-5 * var_x108;
        const double var_x188 = 5.3695461810256699e-6 * var_x9;
        const double var_x189 = 4.2956369448205359e-5 * var_x28;
        const double var_x190 = var_x161 * var_x49;
        const double var_x191 = 0.00071593949080342272 * var_x88;
        const double var_x192 = 1.0227707011477466e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x193 = 0.00014344077153110256 * var_x9;
        const double var_x194 = 1.073909236205134e-5 * var_x108;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (-0.080000000000000002 + 0.084077770927753662 * var_x57 + 0.056150836234118207 * var_x31 - 12.0 * var_x13 - 1.25 * var_x1 - 0.002 * var_x23 - 0.16815554185550732 * var_x54 - 0.00010509721365969207 * var_x61 - 0.01471360991235689 * var_x56 - 0.0053476986889636384 * var_x27 + var_x47 * var_x59 + var_x59 * var_x60 - var_x10 * var_chaste_interface__extracellular_potassium_concentration__Kc - var_x33 * var_x40 - var_x33 * var_x50 - var_x44 * var_x47));
        IJth(rJacobian, 1, 0) = -3.5796974540171133e-8 + 3.0097298252951385e-7 * var_x57 + 1.4318789816068453e-8 * var_x23 - 6.019459650590277e-7 * var_x54 - var_x110 * var_x33;
        IJth(rJacobian, 2, 0) = -0.067000000000000004 * var_x118 * (0.0001 - 0.0001 * var_chaste_interface__hyperpolarising_activated_current_y_gate__y) - 0.002 * ((var_x120) ? (0) : (var_x123 - 0.20000000000000001 * var_x119 * var_x121 / pow(var_x122, 2))) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y;
        IJth(rJacobian, 3, 0) = (0.001 - var_x124) * ((var_x126) ? (0) : (var_x129 - 0.10000000000000001 * var_x125 * var_x127 / pow(var_x128, 2))) - var_x124 * ((var_x126) ? (0) : (var_x132 - 0.011866666666666666 * var_x125 * var_x130 / pow(var_x131, 2)));
        IJth(rJacobian, 4, 0) = (0.001 - 0.001 * var_chaste_interface__fast_sodium_current_m_gate__m) * ((var_x134) ? (0) : (var_x138 - 20.0 * var_x133 * var_x136 / pow(var_x137, 2))) + 0.44800000000000001 * var_x139 * var_chaste_interface__fast_sodium_current_m_gate__m;
        IJth(rJacobian, 5, 0) = -0.125 * var_x140 * (0.02 - 0.02 * var_chaste_interface__fast_sodium_current_h_gate__h) - 0.00062500000000000001 * var_x141 * var_chaste_interface__fast_sodium_current_h_gate__h / pow((0.0031250000000000002 + var_x141), 2);
        IJth(rJacobian, 6, 0) = (0.001 - var_x142) * ((var_x144) ? (0) : (var_x149 - 7.5 * var_x143 * var_x147 / pow(var_x148, 2))) - var_x142 * ((var_x144) ? (0) : (var_x152 - 1.2 * var_x143 * var_x150 / pow(var_x151, 2)));
        IJth(rJacobian, 7, 0) = (0.001 - 0.001 * var_chaste_interface__second_inward_current_f_gate__f) * ((var_x154) ? (0) : (var_x157 - 1.5625 * var_x153 * var_x155 / pow(var_x156, 2))) - 0.012500000000000001 * var_x158 * var_chaste_interface__second_inward_current_f_gate__f / pow(var_x159, 2);
        IJth(rJacobian, 9, 0) = -5.0115764356239594e-7 + var_x160 - 4.2956369448205359e-8 * var_x23 - 8.9492436350427826e-6 * var_x1 - 1.0534054388532985e-7 * var_x56 + var_x162 * var_x47 - var_x161 * var_x47;
        IJth(rJacobian, 12, 0) = var_x172 * var_x175 - 0.00125 * var_x176 * var_chaste_interface__intracellular_calcium_concentration__p / pow(var_x177, 2) - 0.00015625 * var_x172 * var_x173 * var_x178 / pow(var_x174, 2);
        IJth(rJacobian, 13, 0) = 6.7752426238365633e-9 * var_x61 + 3.4474706640864439e-7 * var_x27 + 0.00038679860604725458 * var_x13 - 3.6198441972907658e-6 * var_x31 + var_x179 * var_chaste_interface__extracellular_potassium_concentration__Kc + var_x180 * var_x60 - 6.7752426238365633e-9 * var_x58 * var_x60;
        IJth(rJacobian, 14, 0) = var_x160 + 4.0200601101640964e-7 * var_x31 - 3.8286286763467583e-8 * var_x27 - 7.5243245632378463e-10 * var_x61 + var_x162 * var_x60 - var_x161 * var_x60 - var_x188 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (5488.0 * var_x65 + 1.38e-5 * var_x67 + 7.288629737609329e-6 * var_x68 - 1.1230167246823641 * var_x69 - 0.13356880329847826 * var_x64));
        IJth(rJacobian, 1, 1) = -0.19999999999999998 + 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 9.8799649730872331e-11 * var_x67 - 4.7813590510367518e-7 * var_x64 - 4.0200601101640967e-6 * var_x69 - 0.039290759255291838 * var_x65 - 5.2182178629987073e-11 * var_x68 + var_x111 * var_x115 - var_x111 * var_x116;
        IJth(rJacobian, 8, 1) = -20.0 * var_chaste_interface__second_inward_current_f2_gate__f2;
        IJth(rJacobian, 9, 1) = 1.5654653588996123e-10 * var_x68 + 2.9639894919261698e-10 * var_x67 + 0.11787227776587551 * var_x65;
        IJth(rJacobian, 10, 1) = 3.9999999999999996 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Ca_up;
        IJth(rJacobian, 11, 1) = var_x116 * var_x170 - var_x115 * var_x170;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (-var_x72 * var_x73 - var_x73 * var_x74));
        IJth(rJacobian, 2, 2) = -0.0001 * var_x118 - 0.002 * ((var_x120) ? (2.5) : (var_x119 * var_x123));
        IJth(rJacobian, 9, 2) = -var_x163 * var_x73;
        IJth(rJacobian, 13, 2) = var_x181 * var_x73;
        IJth(rJacobian, 14, 2) = -var_x189 * var_x73;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (0.14285714285714285 * var_x26 - 0.14285714285714285 * var_chaste_interface__intracellular_potassium_concentration__Ki));
        IJth(rJacobian, 3, 3) = -0.001 * ((var_x126) ? (2.5) : (var_x125 * var_x129)) - 0.001 * ((var_x126) ? (2.5) : (var_x125 * var_x132));
        IJth(rJacobian, 13, 3) = 9.2094906201727277e-6 * var_chaste_interface__intracellular_potassium_concentration__Ki - 9.2094906201727277e-6 * var_x26;
        IJth(rJacobian, 14, 3) = 1.0227707011477466e-6 * var_x26 - 1.0227707011477466e-6 * var_chaste_interface__intracellular_potassium_concentration__Ki;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0037499999999999999 * var_x62 * var_x78);
        IJth(rJacobian, 4, 4) = -8.0 * var_x139 - 0.001 * ((var_x134) ? (2000.0) : (var_x133 * var_x138));
        IJth(rJacobian, 9, 4) = -2.6847730905128351e-5 * var_x78;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00125 * var_x62 * var_x79);
        IJth(rJacobian, 5, 5) = -2.0 / (1.0 + 320.0 * var_x141) - 0.02 * var_x140;
        IJth(rJacobian, 9, 5) = -8.9492436350427826e-6 * var_x79;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (-var_x40 * var_x80 - var_x50 * var_x80 - var_x80 * var_x81));
        IJth(rJacobian, 1, 6) = -var_x110 * var_x80;
        IJth(rJacobian, 6, 6) = -0.001 * ((var_x144) ? (120.0) : (var_x143 * var_x149)) - 0.001 * ((var_x144) ? (120.0) : (var_x143 * var_x152));
        IJth(rJacobian, 9, 6) = -var_x164 * var_x80;
        IJth(rJacobian, 13, 6) = var_x182 * var_x80;
        IJth(rJacobian, 14, 6) = -var_x190 * var_x80;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (-var_x40 * var_x83 - var_x50 * var_x83 - var_x81 * var_x83));
        IJth(rJacobian, 1, 7) = -var_x110 * var_x83;
        IJth(rJacobian, 7, 7) = -0.001 * ((var_x154) ? (25.0) : (var_x153 * var_x157)) - 0.050000000000000003 / var_x159;
        IJth(rJacobian, 9, 7) = -var_x164 * var_x83;
        IJth(rJacobian, 13, 7) = var_x182 * var_x83;
        IJth(rJacobian, 14, 7) = -var_x190 * var_x83;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (-var_x40 * var_x84 - var_x50 * var_x84 - var_x81 * var_x84));
        IJth(rJacobian, 1, 8) = -var_x110 * var_x84;
        IJth(rJacobian, 8, 8) = -0.01 - 20.0 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        IJth(rJacobian, 9, 8) = -var_x164 * var_x84;
        IJth(rJacobian, 13, 8) = var_x182 * var_x84;
        IJth(rJacobian, 14, 8) = -var_x190 * var_x84;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (var_x99 + 0.03125 * var_x92 + 1.5937237035588913e-11 * var_x94 - 0.012 * var_x95 - 33.392200824619565 * var_x90 - 1.8699632461786957 * var_x70 - var_x89 * var_chaste_interface__extracellular_potassium_concentration__Kc - var_x96 * var_x97));
        IJth(rJacobian, 1, 9) = 8.5912738896410719e-8 * var_x95 - 1.1410097368072975e-16 * var_x94;
        IJth(rJacobian, 9, 9) = var_x167 + 6.7119327262820874e-7 * var_x92 + 3.4230292104218926e-16 * var_x94 - 2.5773821668923216e-7 * var_x95 - 1.3387805342902908e-5 * var_x70 - 0.0002390679525518376 * var_x90 - var_x165 * var_chaste_interface__extracellular_potassium_concentration__Kc - var_x166 * var_x97;
        IJth(rJacobian, 13, 9) = 4.0291521463255683e-6 * var_x92 - var_x183 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        IJth(rJacobian, 14, 9) = -4.4746218175213919e-7 * var_x92 + var_x191 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        IJth(rJacobian, 1, 10) = 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        IJth(rJacobian, 10, 10) = -var_x169 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        IJth(rJacobian, 11, 10) = var_x171;
        IJth(rJacobian, 1, 11) = 0.002 * var_x117;
        IJth(rJacobian, 10, 11) = var_x169;
        IJth(rJacobian, 11, 11) = -var_x171 - 0.099999999999999992 * var_x117;
        IJth(rJacobian, 10, 12) = 0.002 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel - 0.002 * var_chaste_interface__intracellular_calcium_concentration__Ca_up;
        IJth(rJacobian, 11, 12) = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        IJth(rJacobian, 12, 12) = -0.0050000000000000001 / var_x177 - var_x175 * var_x178;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (var_x100 + var_x96 - var_x109 + 50.0 * var_x103 + 4.0070640989543476 * var_x102 + 0.0074999999999999997 * var_x104 + var_x101 * var_x25 + var_x106 * var_x107 + var_x106 * var_x29 + var_x44 * var_x55 - var_x10 * var_x28 - var_x12 * var_x72 - var_x12 * var_x74 - var_x89 * var_chaste_interface__intracellular_sodium_concentration__Nai));
        IJth(rJacobian, 9, 13) = 0.0010739092362051341 * var_x103 + 2.8688154306220512e-5 * var_x102 + var_x107 * var_x168 - var_x12 * var_x163 - var_x165 * var_chaste_interface__intracellular_sodium_concentration__Nai;
        IJth(rJacobian, 13, 13) = -0.001 + var_x187 - var_x185 - var_x186 + 0.0064466434341209095 * var_x103 - 4.8349825755906825e-7 * var_x104 + var_x12 * var_x181 + var_x179 * var_x28 - var_x180 * var_x55 - var_x183 * var_chaste_interface__intracellular_sodium_concentration__Nai - var_x184 * var_x25 - 1.9101165730728621e-7 * var_x105 * var_x29;
        IJth(rJacobian, 14, 13) = var_x166 + var_x193 - var_x194 + 5.3695461810256699e-8 * var_x104 - 0.00071593949080342272 * var_x103 + var_x161 * var_x55 + var_x168 * var_x29 + var_x191 * var_chaste_interface__intracellular_sodium_concentration__Nai + var_x192 * var_x25 - var_x12 * var_x189 - var_x188 * var_x28;
        IJth(rJacobian, 0, 14) = mSetVoltageDerivativeToZero ? 0.0 : (var_x63 * (var_x99 - var_x101 - 4.0070640989543476 * var_x90 + var_x109 * var_x3 - var_x100 * var_x3 - var_x3 * var_x96));
        IJth(rJacobian, 9, 14) = -2.8688154306220512e-5 * var_x90;
        IJth(rJacobian, 13, 14) = var_x184 + var_x180 * var_x98 + var_x185 * var_x3 + var_x186 * var_x3 - var_x187 * var_x3;
        IJth(rJacobian, 14, 14) = var_x167 - var_x192 + var_x194 * var_x3 - var_x166 * var_x3 - var_x193 * var_x3;
    }

    N_Vector Cellnoble_noble_SAN_model_1984FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics

        N_Vector dqs = N_VNew_Serial(1);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_noble_SAN_model_1984FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "NN_SAN_model_1984";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-60.0);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.8e-05);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.54);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.076);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("second_inward_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0011);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("second_inward_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("second_inward_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("intracellular_sodium_concentration__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.5);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.98);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.55);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("intracellular_calcium_concentration__p");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("extracellular_potassium_concentration__Kc");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.0);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("intracellular_potassium_concentration__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_noble_SAN_model_1984FromCellMLCvode)
#endif // CHASTE_CVODE
