#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: matsuoka_model_2003
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "matsuoka_model_2003.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellmatsuoka_model_2003FromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 400.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellmatsuoka_model_2003FromCellMLCvode::Cellmatsuoka_model_2003FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                37,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 132.0; // (var_membrane__Cm) [picoF]
    }

    Cellmatsuoka_model_2003FromCellMLCvode::~Cellmatsuoka_model_2003FromCellMLCvode()
    {
    }
    
    double Cellmatsuoka_model_2003FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = NV_Ith_S(rY, 2);
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = NV_Ith_S(rY, 3);
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = NV_Ith_S(rY, 4);
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * NV_Ith_S(mParameters, 0) * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * NV_Ith_S(mParameters, 0) * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * NV_Ith_S(mParameters, 0) * var_sodium_potassium_pump__P_NaK; // picoA
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * NV_Ith_S(mParameters, 0) * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
        const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmatsuoka_model_2003FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = NV_Ith_S(rY, 2);
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = NV_Ith_S(rY, 3);
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = NV_Ith_S(rY, 4);
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.40285968661346977
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.000877325391245903
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.4250747299372254
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = NV_Ith_S(rY, 31);
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = NV_Ith_S(rY, 32);
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = NV_Ith_S(rY, 36);
        // Units: micrometre; Initial value: 0.9573749975411884

        // Mathematics
        double d_dt_chaste_interface_var_membrane__Vm;
        const double var_ATP_production__Adenosine_Total = 5.0; // millimolar
        const double var_ATP_production__ProducingRate_Max = 0.0030000000000000001; // per_millisecond
        const double var_Ca_concentrations_in_SR__CSQN_max = 10.0; // millimolar
        const double var_Ca_concentrations_in_SR__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_Ca_concentrations_in_SR__V_rel = 160.0; // micrometre3
        const double var_Ca_concentrations_in_SR__V_up = 400.0; // micrometre3
        const double var_Ca_concentrations_in_SR__b1 = -var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + var_Ca_concentrations_in_SR__CSQN_max + var_Ca_concentrations_in_SR__K_mCSQN; // millimolar
        const double var_Ca_concentrations_in_SR__c1 = var_chaste_interface__Ca_concentrations_in_SR__Ca_Total * var_Ca_concentrations_in_SR__K_mCSQN; // millimolar2
        const double var_Ca_concentrations_in_SR__Carel = sqrt(0.25 * pow(var_Ca_concentrations_in_SR__b1, 2) + var_Ca_concentrations_in_SR__c1) - 0.5 * var_Ca_concentrations_in_SR__b1; // millimolar
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C = 0.0041999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa = 0.00029999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_U = 0.14299999999999999; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_C = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa / (var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_C); // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP = 0.001; // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI = 0.0040000000000000001; // per_millisecond
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double var_NL_model__B = 1.2; // per_millisecond
        const double var_NL_model__L = 0.96237999754118841; // micrometre
        const double var_NL_model__L_a = 1.1699999999999999; // micrometre
        const double var_NL_model__EffFraction = exp(-20.0 * pow((-var_NL_model__L_a + var_NL_model__L), 2)); // dimensionless
        const double var_NL_model__T_t = 0.070000000000000007; // millimolar
        const double var_NL_model__Y_1 = 39.0; // per_millimolar_millisecond
        const double var_NL_model__Y_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Y_3 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Y_4 = 0.12; // per_millisecond
        const double var_NL_model__Y_d = 0.027; // millisecond_per_micrometre2
        const double var_NL_model__Z_1 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Z_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Z_3 = 1560.0; // per_millimolar_millisecond
        const double var_NL_model__h = -var_chaste_interface__NL_model__X + var_NL_model__L; // micrometre
        const double var_NL_model__h_c = 0.0050000000000000001; // micrometre
        const double d_dt_chaste_interface_var_NL_model__X = (-var_NL_model__h_c + var_NL_model__h) * var_NL_model__B; // micrometre / millisecond
        const double var_NL_model__Q_d = var_NL_model__Y_4 * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_d1 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_a = -var_NL_model__Z_2 * var_chaste_interface__NL_model__pCaCB + var_NL_model__EffFraction * var_NL_model__Y_2 * var_chaste_interface__NL_model__pCa; // per_millisecond
        const double var_NL_model__Q_d2 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_NL_model__dATPdt = -0.40000000000000002 * var_NL_model__T_t * var_chaste_interface__NL_model__pCaCB; // millimolar_per_millisecond
        const double var_NL_model__p = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB; // dimensionless
        const double var_RyR_channel__Diadid_Factor = -150.0; // per_picoA_millisecond
        const double var_RyR_channel__P_RyR = 62000.0; // picoA_per_millimolar
        const double var_RyR_channel__k2 = 0.080000000000000002 / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // per_millisecond
        const double var_RyR_channel__k3 = 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2); // per_millisecond
        const double var_RyR_channel__k4 = 0.00084900000000000004; // per_millisecond
        const double var_SR_L_current__P_SR_L = 459.0; // picoA_per_millimolar
        const double var_SR_T_current__P_SR_T = 386.0; // picoA_per_millimolar
        const double var_SR_T_current__i_SR_T = (-var_Ca_concentrations_in_SR__Carel + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_T_current__P_SR_T; // picoA
        const double var_SR_calcium_pump__Km_ATP = 0.10000000000000001; // millimolar
        const double var_SR_calcium_pump__Km_CaCyto = 0.00080000000000000004; // millimolar
        const double var_SR_calcium_pump__Km_CaSR = 0.080000000000000002; // millimolar
        const double var_SR_calcium_pump__i_max = 162500.0; // picoA
        const double var_SR_calcium_pump__k1 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + var_SR_calcium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__k3 = 1.0; // per_millisecond
        const double var_SR_calcium_pump__k4 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaSR / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_SR_calcium_pump__p_E1 = 1.0 - var_SR_calcium_pump__p_E1Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__beta_y = var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca + var_SR_calcium_pump__k3 * var_SR_calcium_pump__p_E1; // per_millisecond
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__Vi = 8000.0; // micrometre3
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_NL_model__Q_b = -var_NL_model__Z_1 * var_chaste_interface__NL_model__pCa + var_NL_model__Y_1 * var_NL_model__p * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond
        const double var_NL_model__Q_r = var_NL_model__Y_3 * var_chaste_interface__NL_model__pCaCB - var_NL_model__Z_3 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -var_NL_model__Q_d - var_NL_model__Q_d1 + var_NL_model__Q_r; // 1 / millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond
        const double var_NL_model__dCaidt = (-var_NL_model__Q_b + var_NL_model__Q_d2 + var_NL_model__Q_r) * var_NL_model__T_t; // millimolar_per_millisecond
        const double var_RyR_channel__i_RyR = (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_RyR_channel__P_RyR * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = (-var_internal_ion_concentrations__Cai + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_L_current__P_SR_L; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaCyto / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = (var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) * var_SR_calcium_pump__i_max; // picoA
        const double var_SR_calcium_pump__p_E2 = 1.0 - var_SR_calcium_pump__p_E2Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__alpha_y = var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k4 * var_SR_calcium_pump__p_E2; // per_millisecond
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump_y_gate__alpha_y - var_SR_calcium_pump_y_gate__beta_y * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 0.5 * (-var_RyR_channel__i_RyR + var_SR_T_current__i_SR_T) / (var_Ca_concentrations_in_SR__V_rel * var_membrane__F); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = 0.5 * (-var_SR_L_current__i_SR_L - var_SR_T_current__i_SR_T - var_SR_calcium_pump__i_SR_U) / (var_Ca_concentrations_in_SR__V_up * var_membrane__F); // millimolar / millisecond
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_ultra_slow_gate__alpha_y = 1 / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_ultra_slow_gate__beta_y = 1 / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y = (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) * var_L_type_Ca_channel_ultra_slow_gate__alpha_y - var_L_type_Ca_channel_ultra_slow_gate__beta_y * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP = 0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond
        const double var_T_type_Ca_channel_y1_gate__alpha_y1 = 1 / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_T_type_Ca_channel_y1_gate__beta_y1 = 1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1 = (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) * var_T_type_Ca_channel_y1_gate__alpha_y1 - var_T_type_Ca_channel_y1_gate__beta_y1 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1; // 1 / millisecond
        const double var_T_type_Ca_channel_y2_gate__alpha_y2 = 1 / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_T_type_Ca_channel_y2_gate__beta_y2 = 1 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2 = (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) * var_T_type_Ca_channel_y2_gate__alpha_y2 - var_T_type_Ca_channel_y2_gate__beta_y2 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2; // 1 / millisecond
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic = var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_Ca_dependent_gate__k_C_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffC = var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffU = (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + var_L_type_Ca_channel_Ca_dependent_gate__CaEffC; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = var_L_type_Ca_channel_Ca_dependent_gate__CaEffU * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // 1 / millisecond
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) + var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic * var_RyR_channel__Diadid_Factor; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR) * var_RyR_channel__k3 - (var_RyR_channel__k1 + var_RyR_channel__k4) * var_chaste_interface__RyR_channel__p_close_RyR; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - var_RyR_channel__k2 * var_chaste_interface__RyR_channel__p_open_RyR; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_ext = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_ext_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * NV_Ith_S(mParameters, 0) * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 - var_rapid_time_dependent_potassium_current_y1_gate__beta_y1 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 = 1 / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y2_gate__beta_y2 = 1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) * var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 - var_rapid_time_dependent_potassium_current_y2_gate__beta_y2 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 = 1 / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y3_gate__beta_y3 = 1 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) * var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 - var_rapid_time_dependent_potassium_current_y3_gate__beta_y3 * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_slow_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) * var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 - var_slow_time_dependent_potassium_current_y1_gate__beta_y1 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 = 3.7000000000000002 * var_internal_ion_concentrations__Cai; // per_millisecond
        const double var_slow_time_dependent_potassium_current_y2_gate__beta_y2 = 0.004444; // per_millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 - var_slow_time_dependent_potassium_current_y2_gate__beta_y2 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k3 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__k4 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Ca = 1 / (1.0 + (1.0 + pow(var_chaste_interface__internal_ion_concentrations__Nai, 3) / pow(var_sodium_calcium_exchanger__Km_Nai, 3)) * var_sodium_calcium_exchanger__Km_Cai / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Ca = 1 / (1.0 + (1.0 + pow(var_external_ion_concentrations__Nao, 3) / pow(var_sodium_calcium_exchanger__Km_Nao, 3)) * var_sodium_calcium_exchanger__Km_Cao / var_external_ion_concentrations__Cao); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger_y_gate__alpha_y = var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na + var_sodium_calcium_exchanger__k4 * var_sodium_calcium_exchanger__p_E2Ca; // per_millisecond
        const double var_sodium_calcium_exchanger_y_gate__beta_y = var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na + var_sodium_calcium_exchanger__k3 * var_sodium_calcium_exchanger__p_E1Ca; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger_y_gate__alpha_y - var_sodium_calcium_exchanger_y_gate__beta_y * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * NV_Ith_S(mParameters, 0) * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_internal_ion_concentrations__i_net_Ca = -2.0 * var_sodium_calcium_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaL_Ca + var_T_type_Ca_channel__i_Ca_T + var_background_Cab_current__i_Cab; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.5 * (-var_internal_ion_concentrations__i_net_Ca + var_RyR_channel__i_RyR + var_SR_L_current__i_SR_L + var_SR_calcium_pump__i_SR_U) / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dCaidt; // millimolar / millisecond
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current_ultra_slow_gate__alpha_y = 1 / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_ultra_slow_gate__beta_y = 1 / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y = (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) * var_sodium_current_ultra_slow_gate__alpha_y - var_sodium_current_ultra_slow_gate__beta_y * var_chaste_interface__sodium_current_ultra_slow_gate__y; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_AP = 8.7499999999999999e-5; // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + var_sodium_current_voltage_dependent_gate__k_AI_AP * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_RP = 0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = var_sodium_current_voltage_dependent_gate__k_AI_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_AI_AP + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_RP * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__k3 = 0.01; // per_millisecond
        const double var_sodium_potassium_pump__k4 = 0.16500000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ki / var_chaste_interface__internal_ion_concentrations__Ki), 1.1200000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Nai / var_sodium_potassium_pump__Km_Nai), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ko / var_external_ion_concentrations__Ko), 1.1200000000000001) * (1.0 + pow((var_sodium_potassium_pump__Nao_Eff / var_sodium_potassium_pump__Km_Nao), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump_y_gate__alpha_y = var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k4 * var_sodium_potassium_pump__p_E2K; // per_millisecond
        const double var_sodium_potassium_pump_y_gate__beta_y = var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na + var_sodium_potassium_pump__k3 * var_sodium_potassium_pump__p_E1K; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump_y_gate__alpha_y - var_sodium_potassium_pump_y_gate__beta_y * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * NV_Ith_S(mParameters, 0) * var_sodium_potassium_pump__P_NaK; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = (-var_chaste_interface__ATP_production__ATPi + var_ATP_production__Adenosine_Total) * var_ATP_production__ProducingRate_Max - var_sodium_potassium_pump__i_NaK / (var_internal_ion_concentrations__Vi * var_membrane__F) + 0.25 * var_SR_calcium_pump__i_SR_U / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dATPdt; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * NV_Ith_S(mParameters, 0) * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current_y_gate__alpha_y = 1 / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current_y_gate__beta_y = pow(var_time_independent_potassium_current__fO, 4) / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) * var_time_independent_potassium_current_y_gate__alpha_y - var_time_independent_potassium_current_y_gate__beta_y * var_chaste_interface__time_independent_potassium_current_y_gate__y; // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current_y1_gate__alpha_y1 = 1 / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_transient_outward_current_y1_gate__beta_y1 = 1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1 = (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) * var_transient_outward_current_y1_gate__alpha_y1 - var_transient_outward_current_y1_gate__beta_y1 * var_chaste_interface__transient_outward_current_y1_gate__y1; // 1 / millisecond
        const double var_transient_outward_current_y2_gate__alpha_y2 = 0.0038 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_transient_outward_current_y2_gate__beta_y2 = 0.0038 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2 = (1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2) * var_transient_outward_current_y2_gate__alpha_y2 - var_transient_outward_current_y2_gate__beta_y2 * var_chaste_interface__transient_outward_current_y2_gate__y2; // 1 / millisecond
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_K = -2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_K + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC_K + var_background_lCa_current__i_lCa_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks_K + var_sodium_current__i_Na_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to_K; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = (-var_internal_ion_concentrations__i_net_K - var_membrane__i_ext) / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_Na = 3.0 * var_sodium_calcium_exchanger__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_Na + var_background_NSC_current__i_bNSC_Na + var_background_lCa_current__i_lCa_Na + var_slow_time_dependent_potassium_current__i_Ks_Na + var_sodium_current__i_Na_Na + var_transient_outward_current__i_to_Na; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -var_internal_ion_concentrations__i_net_Na / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__Vm = 0.0;
        }
        else
        {
            const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
            const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
            const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
            const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
            const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
            const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
            const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
            const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
            d_dt_chaste_interface_var_membrane__Vm = (-var_membrane__i_ext - var_membrane__i_tot) / NV_Ith_S(mParameters, 0); // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__Vm;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_ATP_production__ATPi;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
        NV_Ith_S(rDY,29) = d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
        NV_Ith_S(rDY,30) = d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
        NV_Ith_S(rDY,31) = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
        NV_Ith_S(rDY,32) = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
        NV_Ith_S(rDY,33) = d_dt_chaste_interface_var_NL_model__pCa;
        NV_Ith_S(rDY,34) = d_dt_chaste_interface_var_NL_model__pCaCB;
        NV_Ith_S(rDY,35) = d_dt_chaste_interface_var_NL_model__pCB;
        NV_Ith_S(rDY,36) = d_dt_chaste_interface_var_NL_model__X;
    }

    void Cellmatsuoka_model_2003FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = NV_Ith_S(rY, 2);
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = NV_Ith_S(rY, 3);
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = NV_Ith_S(rY, 4);
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.40285968661346977
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.000877325391245903
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.4250747299372254
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = NV_Ith_S(rY, 31);
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = NV_Ith_S(rY, 32);
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = NV_Ith_S(rY, 36);
        // Units: micrometre; Initial value: 0.9573749975411884
        
        const double var_x0 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x1 = 0.037435192301797954 * var_chaste_interface__membrane__Vm;
        const double var_x2 = exp(-var_x1);
        const double var_x3 = 1.0 - var_x2;
        const double var_x4 = 1 / var_x3;
        const double var_x5 = -5.4000000000000004 * var_x2 + var_chaste_interface__internal_ion_concentrations__Ki;
        const double var_x6 = var_x4 * var_x5;
        const double var_x7 = var_x4 * var_chaste_interface__membrane__Vm;
        const double var_x8 = var_x2 * var_x7;
        const double var_x9 = var_x2 * var_chaste_interface__membrane__Vm / pow(var_x3, 2);
        const double var_x10 = var_x5 * var_x9;
        const double var_x11 = var_chaste_interface__membrane__Vm == (-3.0);
        const double var_x12 = -0.076923076923076927 * var_chaste_interface__membrane__Vm;
        const double var_x13 = exp(-0.23076923076923078 + var_x12);
        const double var_x14 = 1.0 - var_x13;
        const double var_x15 = 1 / var_x14;
        const double var_x16 = 0.00011 * var_x15;
        const double var_x17 = 3.0 + var_chaste_interface__membrane__Vm;
        const double var_x18 = var_x13 * var_x17 / pow(var_x14, 2);
        const double var_x19 = var_chaste_interface__membrane__Vm == 0;
        const double var_x20 = var_x15 * var_x17;
        const double var_x21 = 4.1178711531977753e-6 * var_x6;
        const double var_x22 = ((var_x11) ? (5.3564032599450697e-5 * var_x6 + 1.0827971248429142e-5 * var_x8 - 2.0051798608202113e-6 * var_x10) : ((var_x19) ? (var_x16 * var_chaste_interface__internal_ion_concentrations__Ki - 8.4615384615384621e-6 * var_x18 * var_chaste_interface__internal_ion_concentrations__Ki) : (var_x20 * var_x21 + 8.3242781186752018e-7 * var_x20 * var_x8 - 1.5415329849398521e-7 * var_x10 * var_x20 + var_x15 * var_x21 * var_chaste_interface__membrane__Vm - 3.1675931947675192e-7 * var_x18 * var_x6 * var_chaste_interface__membrane__Vm)));
        const double var_x23 = -140.0 * var_x2 + var_chaste_interface__internal_ion_concentrations__Nai;
        const double var_x24 = var_x23 * var_x4;
        const double var_x25 = ((var_x19) ? (0) : (0.037435192301797954 * var_x24 + 0.196195107174163 * var_x8 - 0.0014013936226725929 * var_x23 * var_x9));
        const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
        const double var_x27 = exp(-var_x26);
        const double var_x28 = 1.0 - var_x27;
        const double var_x29 = 1 / var_x28;
        const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
        const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x32 = var_x31 - 1.8 * var_x27;
        const double var_x33 = var_x29 * var_x32;
        const double var_x34 = var_x27 * var_chaste_interface__membrane__Vm;
        const double var_x35 = ((var_x19) ? (0) : (0.074870384603595908 * var_x33 + 0.010090034083242669 * var_x29 * var_x34 - 0.0056055744906903715 * var_x32 * var_x34 / pow(var_x28, 2)));
        const double var_x36 = pow(var_chaste_interface__ATP_production__ATPi, 2);
        const double var_x37 = 1 / (1.0 + 99.999999999999986 * var_x36);
        const double var_x38 = ((var_x19) ? (0) : (0.037435192301797954 * var_x6 + 0.0075675255624320014 * var_x8 - 0.0014013936226725929 * var_x10));
        const double var_x39 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm);
        const double var_x40 = var_x39 * (-0.6399652192815608 + 0.6399652192815608 * var_chaste_interface__sodium_calcium_exchanger_y_gate__y);
        const double var_x41 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
        const double var_x42 = 1 / var_x41;
        const double var_x43 = -17.978260869565219 + 362.31884057971018 * var_x30 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x44 = var_x42 * var_x43;
        const double var_x45 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
        const double var_x46 = var_x45 / (1.0 + 669.921875 * var_x44);
        const double var_x47 = var_x46 * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
        const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x49 = 1.0 + 1.3823999999999997e-8 / pow(var_x48, 3);
        const double var_x50 = 1 / var_x49;
        const double var_x51 = 0.11 * var_x50;
        const double var_x52 = -0.0034560000000000003 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 - 0.0051840000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1;
        const double var_x53 = NV_Ith_S(mParameters, 0) * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3;
        const double var_x54 = var_x52 * var_x53;
        const double var_x55 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
        const double var_x56 = log(5.4000000000000004 * var_x55);
        const double var_x57 = exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.40069247885978065 * var_x56);
        const double var_x58 = 1.0 + var_x57;
        const double var_x59 = exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.93494911733948827 * var_x56);
        const double var_x60 = var_x59 / var_x58;
        const double var_x61 = exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 1.7096212431350641 * var_x56);
        const double var_x62 = 1.0 + var_x61;
        const double var_x63 = exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.80138495771956131 * var_x56);
        const double var_x64 = 1.0 + var_x63;
        const double var_x65 = exp(0.47999999999999998 + 1.282215932351298 * var_x56 - 0.048000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x66 = var_x65 / var_x64;
        const double var_x67 = var_x62 * var_x66;
        const double var_x68 = var_x67 + 0.25 * var_x60;
        const double var_x69 = pow(var_x68, (-4));
        const double var_x70 = pow(var_x62, 4);
        const double var_x71 = pow(var_x64, (-4));
        const double var_x72 = pow(var_x65, 4);
        const double var_x73 = var_x70 * var_x71 * var_x72;
        const double var_x74 = var_x69 * var_x73;
        const double var_x75 = pow(var_x58, (-2));
        const double var_x76 = pow(var_x65, 2);
        const double var_x77 = pow(var_x59, 2);
        const double var_x78 = var_x69 * var_x75 * var_x76 * var_x77;
        const double var_x79 = pow(var_x64, (-2));
        const double var_x80 = pow(var_x62, 2);
        const double var_x81 = var_x79 * var_x80;
        const double var_x82 = var_x78 * var_x81;
        const double var_x83 = 1 / (0.75 * var_x60 + 3.0 * var_x67);
        const double var_x84 = pow(var_x65, 3);
        const double var_x85 = var_x83 * var_x84 / pow(var_x68, 3);
        const double var_x86 = pow(var_x62, 3);
        const double var_x87 = pow(var_x64, (-3));
        const double var_x88 = var_x60 * var_x86 * var_x87;
        const double var_x89 = var_x85 * var_x88;
        const double var_x90 = NV_Ith_S(mParameters, 0) * var_chaste_interface__time_independent_potassium_current_y_gate__y;
        const double var_x91 = 612.0 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2;
        const double var_x92 = var_x91 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1;
        const double var_x93 = var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
        const double var_x94 = 2860.0 * var_x93;
        const double var_x95 = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2);
        const double var_x96 = 0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2;
        const double var_x97 = var_x95 * var_x96;
        const double var_x98 = 0.2016 * var_x97;
        const double var_x99 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3);
        const double var_x100 = var_x99 * var_chaste_interface__transient_outward_current_y2_gate__y2;
        const double var_x101 = 0.033000000000000002 * var_x100;
        const double var_x102 = 5.04 * var_x97;
        const double var_x103 = 0.00297 * var_x100;
        const double var_x104 = 286.0 * var_x93;
        const double var_x105 = 0.192 * var_x74;
        const double var_x106 = pow(var_x68, (-5));
        const double var_x107 = var_x57 * var_x59 * var_x75;
        const double var_x108 = var_x61 * var_x66;
        const double var_x109 = 0.12 * var_x63;
        const double var_x110 = var_x62 * var_x79;
        const double var_x111 = var_x110 * var_x65;
        const double var_x112 = var_x106 * (0.014999999999999999 * var_x107 + 0.192 * var_x67 - 0.25600000000000001 * var_x108 - 0.035000000000000003 * var_x60 + var_x109 * var_x111);
        const double var_x113 = var_x73;
        const double var_x114 = var_x112 * var_x113;
        const double var_x115 = var_x69 * var_x72;
        const double var_x116 = var_x71 * var_x86;
        const double var_x117 = var_x115 * var_x116 * var_x61;
        const double var_x118 = 0.25600000000000001 * var_x117;
        const double var_x119 = var_x115 * var_x70 / pow(var_x64, 5);
        const double var_x120 = var_x109 * var_x119;
        const double var_x121 = var_x76 * var_x77 * var_x81;
        const double var_x122 = 0.125 * var_x121 * var_x75;
        const double var_x123 = var_x110 * var_x61 * var_x78;
        const double var_x124 = var_x111 * var_x63;
        const double var_x125 = var_x84 * var_x88;
        const double var_x126 = var_x125 * (0.01125 * var_x107 + 0.089999999999999997 * var_x124 + 0.14400000000000002 * var_x67 - 0.192 * var_x108 - 0.026250000000000002 * var_x60);
        const double var_x127 = 0.22222222222222221 * var_x106;
        const double var_x128 = var_x121 * var_x57 * var_x69 / pow(var_x58, 3);
        const double var_x129 = var_x80 * var_x87;
        const double var_x130 = var_x129 * var_x78;
        const double var_x131 = 2.0 * var_x69 * var_x83;
        const double var_x132 = var_x60 * var_x85;
        const double var_x133 = var_x129 * var_x61;
        const double var_x134 = var_x85 * var_x86 * var_x87;
        const double var_x135 = var_x116 * var_x63;
        const double var_x136 = var_x114 + var_x118 - var_x105 - var_x120 + 0.016 * var_x123 - 0.0032499999999999994 * var_x82 - 0.0037499999999999999 * var_x128 - 0.218 * var_x89 + var_x112 * var_x122 + var_x126 * var_x127 + var_x126 * var_x131 + 0.38400000000000001 * var_x132 * var_x133 - 0.0074999999999999997 * var_x130 * var_x63 - 0.029999999999999999 * var_x107 * var_x134 - 0.17999999999999999 * var_x132 * var_x135;
        const double var_x137 = 30.612905384887238 * var_x56 - 1.1459999999999999 * var_chaste_interface__membrane__Vm;
        const double var_x138 = var_x137 * var_x90;
        const double var_x139 = 1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y;
        const double var_x140 = exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm);
        const double var_x141 = pow(1 / var_x140, 1.0600000000000001);
        const double var_x142 = var_x141 / pow((0.067138346456864173 + var_x141), 2);
        const double var_x143 = var_x139 * var_x142 * NV_Ith_S(mParameters, 0);
        const double var_x144 = var_x35 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
        const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
        const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
        const double var_x149 = var_x145 * var_x148;
        const double var_x150 = 8712.0 * var_x149;
        const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x152 = 3.1798799999999998 * var_x151;
        const double var_x153 = 0.16117199999999998 * var_x151;
        const double var_x154 = var_x1 * var_x4;
        const double var_x155 = ((var_x19) ? (0) : (var_x154));
        const double var_x156 = var_x45 / pow((0.0014927113702623907 + var_x44), 2);
        const double var_x157 = var_x156 * var_x43 / pow(var_chaste_interface__internal_ion_concentrations__Nai, 4);
        const double var_x158 = NV_Ith_S(mParameters, 0) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
        const double var_x159 = var_x157 * var_x158;
        const double var_x160 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
        const double var_x161 = pow(var_x160, 1.0600000000000001);
        const double var_x162 = var_x161 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
        const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
        const double var_x164 = 1.0 + 0.094 * var_x163;
        const double var_x165 = 1 / var_x164;
        const double var_x166 = var_x165 / pow((0.22703754152993499 + var_x162), 2);
        const double var_x167 = var_x160 * var_x162 * var_x166;
        const double var_x168 = NV_Ith_S(mParameters, 0) * var_chaste_interface__sodium_potassium_pump_y_gate__y;
        const double var_x169 = var_x167 * var_x168;
        const double var_x170 = ((var_x11) ? (5.3564032599450697e-5 * var_x7) : ((var_x19) ? (var_x16 * var_x17) : (4.1178711531977753e-6 * var_x20 * var_x7)));
        const double var_x171 = ((var_x19) ? (1) : (var_x154));
        const double var_x172 = var_x37 * var_x55;
        const double var_x173 = var_x55 * var_x60;
        const double var_x174 = var_x107 * var_x55;
        const double var_x175 = var_x55 * var_x67;
        const double var_x176 = var_x108 * var_x55;
        const double var_x177 = var_x124 * var_x55;
        const double var_x178 = var_x106 * (0.40069247885978065 * var_x174 + 3.2055398308782452 * var_x177 + 5.1288637294051922 * var_x175 - 6.8384849725402566 * var_x176 - 0.93494911733948827 * var_x173);
        const double var_x179 = var_x113 * var_x178;
        const double var_x180 = 5.1288637294051922 * var_x55 * var_x74;
        const double var_x181 = 6.8384849725402566 * var_x117 * var_x55;
        const double var_x182 = var_x55 * var_x63;
        const double var_x183 = 3.2055398308782452 * var_x119 * var_x182;
        const double var_x184 = var_x125 * (0.30051935914483546 * var_x174 + 2.4041548731586837 * var_x177 + 3.8466477970538944 * var_x175 - 5.1288637294051922 * var_x176 - 0.70121183800461617 * var_x173);
        const double var_x185 = var_x173 * var_x85;
        const double var_x186 = var_x179 + var_x181 - var_x180 - var_x183 + var_x122 * var_x178 + var_x127 * var_x184 + var_x131 * var_x184 + 10.257727458810384 * var_x133 * var_x185 + 0.42740531078376603 * var_x123 * var_x55 - 0.10017311971494516 * var_x128 * var_x55 - 0.20034623942989033 * var_x130 * var_x182 - 0.80138495771956131 * var_x134 * var_x174 - 4.8083097463173674 * var_x135 * var_x185 - 0.086816703752952459 * var_x55 * var_x82 - 5.823397359428812 * var_x134 * var_x173;
        const double var_x187 = 26.712831923985377 * var_x55;
        const double var_x188 = var_x74;
        const double var_x189 = var_x188 + 0.125 * var_x82 + 2.0 * var_x89;
        const double var_x190 = var_x189 * var_x55 * var_x90;
        const double var_x191 = var_x161 * var_x166 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 0.12000000000000011);
        const double var_x192 = var_x168 * var_x191;
        const double var_x193 = (-0.047620000000000003 + var_chaste_interface__internal_ion_concentrations__Ca_Total) / var_x30;
        const double var_x194 = 0.5 * var_x193;
        const double var_x195 = 0.5 + var_x194;
        const double var_x196 = ((var_x19) ? (0) : (var_x195 * var_x26 * var_x29));
        const double var_x197 = ((var_x19) ? (-140.0) : (var_x1 * var_x24));
        const double var_x198 = (-3 - 3 * var_x193) / (pow(var_x48, 4) * pow(var_x49, 2));
        const double var_x199 = 1.5206399999999996e-9 * var_x198;
        const double var_x200 = ((var_x19) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (var_x1 * var_x6));
        const double var_x201 = var_x156 * var_x42 * (362.31884057971018 + 362.31884057971018 * var_x193);
        const double var_x202 = var_x158 * var_x201;
        const double var_x203 = -26.712831923985377 * var_x56 + var_chaste_interface__membrane__Vm;
        const double var_x204 = var_x203 * var_chaste_interface__ATP_production__ATPi / pow((0.010000000000000002 + var_x36), 2);
        const double var_x205 = 1 / (1.0 + 4.4045579125871104 * var_x162);
        const double var_x206 = 1 / var_x36;
        const double var_x207 = var_x205 * var_x206 * var_chaste_interface__sodium_potassium_pump_y_gate__y / pow(var_x164, 2);
        const double var_x208 = var_x207 * NV_Ith_S(mParameters, 0);
        const double var_x209 = var_x145 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x210 = var_x209 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / (pow((0.36443148688046656 + var_x146), 2) * pow(var_chaste_interface__ATP_production__ATPi, 4));
        const double var_x211 = var_x200 * var_x210;
        const double var_x212 = var_x197 * var_x210;
        const double var_x213 = ((var_x19) ? (-1.8) : (var_x26 * var_x33));
        const double var_x214 = var_x210 * var_x213;
        const double var_x215 = 2860.0 * var_x197;
        const double var_x216 = 286.0 * var_x200;
        const double var_x217 = 8712.0 * var_x213;
        const double var_x218 = 3.1798799999999998 * var_x200;
        const double var_x219 = 0.16117199999999998 * var_x197;
        const double var_x220 = var_x148 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x221 = var_x0 * (-var_x217 * var_x220 - var_x218 * var_x220 - var_x219 * var_x220);
        const double var_x222 = var_x147 * var_x209;
        const double var_x223 = var_x0 * var_x213;
        const double var_x224 = var_x96 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1;
        const double var_x225 = var_x197 * var_x224;
        const double var_x226 = var_x200 * var_x224;
        const double var_x227 = var_x200 * var_x95;
        const double var_x228 = var_x197 * var_x95;
        const double var_x229 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 2) * var_chaste_interface__transient_outward_current_y2_gate__y2;
        const double var_x230 = var_x200 * var_x229;
        const double var_x231 = var_x197 * var_x229;
        const double var_x232 = var_x200 * var_x99;
        const double var_x233 = var_x197 * var_x99;
        const double var_x234 = 1 / (1.0 + 14.894617648090152 * var_x141);
        const double var_x235 = var_x165 * var_x205;
        const double var_x236 = 1.4250668745018745e-7 * var_x50;
        const double var_x237 = 3.8476805611550606e-9 * var_x100;
        const double var_x238 = 2.6117589263597991e-7 * var_x97;
        const double var_x239 = 0.0037051738737048732 * var_x93;
        const double var_x240 = 2.0880079845201463e-7 * var_x151;
        const double var_x241 = 1.9700124473113906e-15 * var_x198;
        const double var_x242 = 0.0037051738737048732 * var_x197;
        const double var_x243 = 2.0880079845201463e-7 * var_x197;
        const double var_x244 = -var_x220 * var_x243;
        const double var_x245 = -4.477301016616798e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 - 6.7159515249251966e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1;
        const double var_x246 = var_x245 * var_x53;
        const double var_x247 = 0.00037051738737048736 * var_x93;
        const double var_x248 = 6.5293973158994975e-6 * var_x97;
        const double var_x249 = 4.2752006235056235e-8 * var_x100;
        const double var_x250 = 3.9659488542057145e-5 * var_x56 - 1.4846605801628617e-6 * var_chaste_interface__membrane__Vm;
        const double var_x251 = var_x250 * var_x90;
        const double var_x252 = 4.1195833208100184e-6 * var_x151;
        const double var_x253 = 0.00037051738737048736 * var_x200;
        const double var_x254 = 4.1195833208100184e-6 * var_x200;
        const double var_x255 = -var_x220 * var_x254;
        const double var_x256 = 0.00039642769417961232 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2;
        const double var_x257 = var_x144 * var_x149;
        const double var_x258 = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB;
        const double var_x259 = 1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y;
        const double var_x260 = 1.0 + 0.10000000000000001 * var_x163;
        const double var_x261 = 1 / var_x260;
        const double var_x262 = 1 / var_x31;
        const double var_x263 = 1.0 + 0.00080000000000000004 * var_x262;
        const double var_x264 = pow(var_x48, 2);
        const double var_x265 = (-0.5 - var_x194) / var_x264;
        const double var_x266 = var_x265 / pow(var_x263, 2);
        const double var_x267 = var_x261 * var_x266;
        const double var_x268 = var_x259 * var_x267;
        const double var_x269 = var_x151 * var_x196;
        const double var_x270 = 1 / var_x263;
        const double var_x271 = var_x206 * var_x259 * var_x270 / pow(var_x260, 2);
        const double var_x272 = 0.0056432648230274225 * var_x213;
        const double var_x273 = -var_x220 * var_x272;
        const double var_x274 = 0.00039642769417961232 * var_x213;
        const double var_x275 = 1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup;
        const double var_x276 = 1 / var_x275;
        const double var_x277 = var_x261 * var_x270;
        const double var_x278 = 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total;
        const double var_x279 = sqrt(pow((1 - var_x278), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total);
        const double var_x280 = (-0.078875171467764058 + 0.0085733882030178329 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total) / var_x279;
        const double var_x281 = var_chaste_interface__SR_calcium_pump_y_gate__y / (pow(var_x275, 2) * pow(var_chaste_interface__Ca_concentrations_in_SR__Caup, 2));
        const double var_x282 = -0.069398700000000008 + 1.3650000000000002 * var_x30 + 1.3650000000000002 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x283 = pow((0.95737999754118841 - var_chaste_interface__NL_model__X), 2);
        const double var_x284 = exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x285 = 1 / var_x284;
        const double var_x286 = 0.0031249999999999997 * var_x285;
        const double var_x287 = exp(0.00125 * var_chaste_interface__membrane__Vm);
        const double var_x288 = 0.058823529411764705 * var_chaste_interface__membrane__Vm;
        const double var_x289 = exp(var_x288);
        const double var_x290 = (-1.5294117647058822 * var_x289 - 2.5000000000000001e-5 * var_x287) / pow((var_x289 + 0.00076923076923076923 * var_x287), 2);
        const double var_x291 = 0.0014792899408284023 * var_x290;
        const double var_x292 = exp(-0.125 * var_chaste_interface__membrane__Vm);
        const double var_x293 = exp(-0.02 * var_chaste_interface__membrane__Vm);
        const double var_x294 = 0.0128375 * var_x292;
        const double var_x295 = 0.0050000000000000001 * var_x293;
        const double var_x296 = 16.0 * (var_x294 + var_x295) / pow((var_x293 + 0.4108 * var_x292), 2);
        const double var_x297 = 1 / (26.0 * var_x289 + 0.02 * var_x287);
        const double var_x298 = var_x297;
        const double var_x299 = 1.25 * var_x285;
        const double var_x300 = 0.25 * var_x293 + 0.1027 * var_x292;
        const double var_x301 = 1 / var_x300;
        const double var_x302 = 1 / (5.0 * var_x284 + 0.0001027 * var_x292);
        const double var_x303 = exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
        const double var_x304 = 1300.0 * var_x303 + 0.040000000000000001 * var_x287;
        const double var_x305 = var_x284 * var_x297 * var_x300 * var_x304;
        const double var_x306 = var_x302 * var_x305;
        const double var_x307 = 1.0 + 7.0000000000000007e-5 * var_x306;
        const double var_x308 = 65.0 * var_x303;
        const double var_x309 = 5.0000000000000002e-5 * var_x287;
        const double var_x310 = var_x284 * var_x300 * var_x302;
        const double var_x311 = 7.0000000000000007e-5 * var_x297;
        const double var_x312 = (1.28375e-5 * var_x292 + 0.012500000000000001 * var_x284) / pow((var_x284 + 2.054e-5 * var_x292), 2);
        const double var_x313 = 0.01 * (1.7500000000000002e-7 * var_x306 - 2.8000000000000003e-6 * var_x305 * var_x312 - var_x310 * var_x311 * (var_x308 + var_x309) - 1.0355029585798818e-7 * var_x290 * var_x304 * var_x310 - var_x284 * var_x302 * var_x304 * var_x311 * (-var_x294 - var_x295)) / pow(var_x307, 2);
        const double var_x314 = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na;
        const double var_x315 = -0.01 + 0.01 / var_x307;
        const double var_x316 = -1.0 * var_x302;
        const double var_x317 = 0.01 * var_chaste_interface__membrane__Vm;
        const double var_x318 = exp(var_x317);
        const double var_x319 = 0.20000000000000001 * var_chaste_interface__membrane__Vm;
        const double var_x320 = exp(var_x319);
        const double var_x321 = exp(-var_x319);
        const double var_x322 = exp(-var_x317);
        const double var_x323 = exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm);
        const double var_x324 = 0.015384615384615385 * var_chaste_interface__membrane__Vm;
        const double var_x325 = exp(-var_x324);
        const double var_x326 = 0.04576271186440678 * var_x323;
        const double var_x327 = 0.023076923076923078 * var_x325;
        const double var_x328 = 0.44444444444444442 * (var_x326 + var_x327) / pow((var_x325 + 0.18000000000000002 * var_x323), 2);
        const double var_x329 = exp(var_x324);
        const double var_x330 = exp(0.14285714285714285 * var_chaste_interface__membrane__Vm);
        const double var_x331 = (-68.571428571428569 * var_x330 - 0.033846153846153852 * var_x329) / pow((var_x330 + 0.0045833333333333334 * var_x329), 2);
        const double var_x332 = 4.3402777777777778e-6 * var_x331 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x333 = 1 / (480.0 * var_x330 + 2.2000000000000002 * var_x329);
        const double var_x334 = var_x333;
        const double var_x335 = 1.5 * var_x325 + 0.27000000000000002 * var_x323;
        const double var_x336 = 1 / var_x335;
        const double var_x337 = 0.13513513513513511 * var_chaste_interface__membrane__Vm;
        const double var_x338 = exp(var_x337);
        const double var_x339 = 11.0 * var_x318 + 2200000.0 * var_x338;
        const double var_x340 = var_x333 * var_x335 * var_x339;
        const double var_x341 = exp(-var_x337);
        const double var_x342 = 1 / (2.0 * var_x322 + 0.0018 * var_x341);
        const double var_x343 = 0.25 * var_x342;
        const double var_x344 = 1.0 + var_x340 * var_x343;
        const double var_x345 = 297297.29729729728 * var_x338;
        const double var_x346 = 0.11 * var_x318;
        const double var_x347 = var_x333 * var_x343;
        const double var_x348 = (0.00024324324324324323 * var_x341 + 0.02 * var_x322) / pow((var_x322 + 0.00089999999999999998 * var_x341), 2);
        const double var_x349 = 0.040000000000000001 * (-0.0625 * var_x340 * var_x348 - var_x335 * var_x347 * (var_x345 + var_x346) - var_x339 * var_x347 * (-var_x326 - var_x327) - 1.0850694444444444e-6 * var_x331 * var_x335 * var_x339 * var_x342) / pow(var_x344, 2);
        const double var_x350 = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x351 = var_x350 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        const double var_x352 = -0.040000000000000001 + 0.040000000000000001 / var_x344;
        const double var_x353 = -1.0 * var_x342;
        const double var_x354 = 0.14102711999999998 * var_x144;
        const double var_x355 = var_x354 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U;
        const double var_x356 = 6.9539999999999997 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x357 = var_x195 * (6.9539999999999997 - var_x356);
        const double var_x358 = (3.4769999999999999 + 3.4769999999999999 * var_x193 - 0.14102711999999998 * var_x196) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x359 = 0.14102711999999998 * var_x213;
        const double var_x360 = var_x359 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U;
        const double var_x361 = 6.9539999999999997 * var_x31 * var_x350;
        const double var_x362 = var_x356 * (var_x31 - 0.020279999999999996 * var_x213);
        const double var_x363 = -var_x362;
        const double var_x364 = exp(0.1111111111111111 * var_chaste_interface__membrane__Vm);
        const double var_x365 = exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm);
        const double var_x366 = exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm);
        const double var_x367 = exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x368 = exp(0.0001 * var_chaste_interface__membrane__Vm);
        const double var_x369 = exp(0.15873015873015872 * var_chaste_interface__membrane__Vm);
        const double var_x370 = exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm);
        const double var_x371 = exp(0.099009900990099015 * var_chaste_interface__membrane__Vm);
        const double var_x372 = exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm);
        const double var_x373 = exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x374 = 0.0033333333333333335 * var_chaste_interface__membrane__Vm;
        const double var_x375 = exp(-0.32333333333333331 + var_x374 - 0.08904277307995126 * var_x56);
        const double var_x376 = exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 3.142686108704162 * var_x56);
        const double var_x377 = 1.5624999999999999e-8 * (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) / pow((var_x376 + 0.00087500000000000002 * var_x375), 2);
        const double var_x378 = exp(10.659340659340661 + 2.9354760356027887 * var_x56 - 0.10989010989010989 * var_chaste_interface__membrane__Vm);
        const double var_x379 = 0.002 * var_chaste_interface__membrane__Vm;
        const double var_x380 = exp(0.19400000000000001 - var_x379 + 0.053425663847970754 * var_x56);
        const double var_x381 = 1 / (0.00013999999999999999 * var_x378 + 0.20000000000000001 * var_x380);
        const double var_x382 = var_x381 * var_chaste_interface__time_independent_potassium_current_y_gate__y;
        const double var_x383 = 24.999999999999996 * var_x74 * var_chaste_interface__time_independent_potassium_current_y_gate__y / pow((var_x380 + 0.00069999999999999988 * var_x378), 2);
        const double var_x384 = 1 / var_x303;
        const double var_x385 = 0.035714285714285712 * var_chaste_interface__membrane__Vm;
        const double var_x386 = exp(var_x385);
        const double var_x387 = exp(0.001 * var_chaste_interface__membrane__Vm);
        const double var_x388 = pow((var_x387 + 0.80000000000000004 * var_x386), (-2));
        const double var_x389 = exp(-var_x374);
        const double var_x390 = exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm);
        const double var_x391 = exp(var_x12);
        const double var_x392 = exp(var_x374);
        const double var_x393 = exp(-var_x288);
        const double var_x394 = exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm);
        const double var_x395 = exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm);
        const double var_x396 = exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm);
        const double var_x397 = exp(-var_x385);
        const double var_x398 = exp(var_x379);
        const double var_x399 = exp(0.0625 * var_chaste_interface__membrane__Vm);
        const double var_x400 = 0.088495575221238937 * var_chaste_interface__membrane__Vm;
        const double var_x401 = exp(-1.1946902654867255 - var_x400);
        const double var_x402 = 1.0 + 0.051334999999999999 * var_x401;
        const double var_x403 = 1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2;
        const double var_x404 = exp(1.1946902654867255 + var_x400);
        const double var_x405 = 1.0 + 0.067083000000000004 * var_x404;
        const double var_x406 = var_x404 / var_x405;
        const double var_x407 = var_x401 / var_x402;
        const double var_x408 = 1.0 + 0.0014927113702623907 * var_x41;
        const double var_x409 = 1.0 + 0.0013799999999999999 * var_x262 * var_x408;
        const double var_x410 = pow(var_x409, (-2));
        const double var_x411 = pow(var_x140, 1.0600000000000001);
        const double var_x412 = pow(var_x55, 1.1200000000000001);
        const double var_x413 = var_x412 * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001));
        const double var_x414 = pow((0.020000293738509214 + var_x413), (-2));
        const double var_x415 = 10.139999999999999 * var_x257 * var_chaste_interface__RyR_channel__p_close_RyR;
        const double var_x416 = 70000.0 * var_x48 * (2 + 2 * var_x193);
        const double var_x417 = 10.139999999999999 * var_x269;
        const double var_x418 = 11.08600583090379 * var_x214 * var_chaste_interface__RyR_channel__p_close_RyR;
        const double var_x419 = 10.139999999999999 * var_x213;
        const double var_x420 = var_x419 * var_chaste_interface__RyR_channel__p_close_RyR;
        const double var_x421 = var_x149 * var_x420;
        const double var_x422 = var_x220 * var_x420;
        const double var_x423 = -var_x422;
        const double var_x424 = var_x222 * var_x420;
        const double var_x425 = 1.0 + 0.35999999999999999 / (-5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * var_x279);
        const double var_x426 = 70000.0 * var_x264;
        const double var_x427 = var_x151 * var_x419;
        const double var_x428 = -1 + var_x278 + var_x279;
        const double var_x429 = pow(var_x428, 2);
        const double var_x430 = -0.010993320000000001 * var_x429;
        const double var_x431 = 0.0038999999999999998 * exp(-0.86212130841993795);
        const double var_x432 = -19.5 * var_x30 - 19.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x433 = 780.0 * var_x193;
        const double var_x434 = -0.038879999999999998 * var_x283;
        const double var_x435 = 780.0 * var_x30;
        const double var_x436 = 780.0 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x437 = 0.074445868608802798 - 0.077759999999999996 * var_chaste_interface__NL_model__X;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (var_x54 - var_x22 - 0.38500000000000001 * var_x25 - 0.040000000000000001 * var_x35 - 66.022388395163091 * var_x37 - 0.15400000000000003 * var_x38 - 0.0018350576517438713 * var_x143 + var_x136 * var_x138 + var_x90 * (-0.14324999999999999 * var_x82 - 1.1459999999999999 * var_x74 - 2.2919999999999998 * var_x89) + (0.17335488851116596 * var_x40 - 0.081578771064078098 * var_x47) * NV_Ith_S(mParameters, 0) - var_x101 * var_x38 - var_x102 * var_x38 - var_x103 * var_x25 - var_x104 * var_x38 - var_x144 * var_x150 - var_x152 * var_x38 - var_x153 * var_x25 - var_x25 * var_x51 - var_x25 * var_x94 - var_x25 * var_x98 - var_x35 * var_x92 - var_x38 * var_x51));
        IJth(rJacobian, 1, 0) = -7.1320360153674206e-9 * var_x143 - 4.9877340607565601e-7 * var_x25 + (6.7375175222789497e-7 * var_x40 - 3.170596481072447e-7 * var_x47) * NV_Ith_S(mParameters, 0) - var_x236 * var_x25 - var_x237 * var_x25 - var_x238 * var_x25 - var_x239 * var_x25 - var_x240 * var_x25;
        IJth(rJacobian, 2, 0) = var_x246 + 4.754690676911614e-9 * var_x143 - 8.5533016979494439e-5 * var_x37 - 1.2955153404562495e-6 * var_x22 - 1.9950936243026244e-7 * var_x38 + var_x136 * var_x251 + var_x90 * (-1.8558257252035771e-7 * var_x82 - 1.4846605801628617e-6 * var_x74 - 2.9693211603257233e-6 * var_x89) - var_x236 * var_x38 - var_x247 * var_x38 - var_x248 * var_x38 - var_x249 * var_x38 - var_x252 * var_x38;
        IJth(rJacobian, 3, 0) = -0.0056432648230274225 * var_x257 - 2.591030680912499e-8 * var_x35 + (1.0568654936908156e-7 * var_x47 - 2.2458391740929832e-7 * var_x40) * NV_Ith_S(mParameters, 0) - var_x256 * var_x35;
        IJth(rJacobian, 4, 0) = -2.377345338455807e-9 * var_x143;
        IJth(rJacobian, 5, 0) = var_x296 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na + (-var_x286 - var_x291) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
        IJth(rJacobian, 6, 0) = var_x291 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + (-var_x296 - var_x313) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - var_x313 * var_x314;
        IJth(rJacobian, 7, 0) = var_x286 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 0.040000000000000001 * var_x312 * var_x314 - 5.917159763313609e-7 * (-var_x308 - var_x309) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na / pow((var_x303 + 3.0769230769230768e-5 * var_x287), 2);
        IJth(rJacobian, 8, 0) = 1.2345679012345679e-20 * (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) * (-80.0 * var_x318 - 1800000000.0 * var_x320) / pow((var_x320 + 8.8888888888888887e-7 * var_x318), 2) - 6.2499999999999997e-8 * (40.0 * var_x322 + 0.0028 * var_x321) * var_chaste_interface__sodium_current_ultra_slow_gate__y / pow((var_x322 + 3.4999999999999999e-6 * var_x321), 2);
        IJth(rJacobian, 9, 0) = -var_x332 + var_x328 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        IJth(rJacobian, 10, 0) = var_x332 + (-var_x328 - var_x349) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - var_x349 * var_x351;
        IJth(rJacobian, 11, 0) = 0.25 * var_x348 * var_x351 - 2.0661157024793388e-13 * (-var_x345 - var_x346) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL / pow((var_x338 + 5.0000000000000004e-6 * var_x318), 2);
        IJth(rJacobian, 12, 0) = var_x355;
        IJth(rJacobian, 13, 0) = -var_x355;
        IJth(rJacobian, 14, 0) = var_x354 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C;
        IJth(rJacobian, 15, 0) = 1.6e-11 * (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) * (-27777.777777777777 * var_x364 - 0.89230769230769236 * var_x329) / pow((var_x364 + 0.000232 * var_x329), 2) - 3.0864197530864198e-7 * (1.0153846153846153 * var_x325 + 128.57142857142858 * var_x365) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / pow((var_x365 + 0.036666666666666667 * var_x325), 2);
        IJth(rJacobian, 16, 0) = 1.4872099940511603 * (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) * (0.0033928571428571428 * var_x366 + 0.0032799999999999999 * var_x367) / pow((var_x367 + 0.023170731707317073 * var_x366), 2) - 0.00062500000000000001 * (-6.3492063492063497 * var_x369 - 0.00014999999999999999 * var_x368) * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 / pow((var_x369 + 0.037499999999999999 * var_x368), 2);
        IJth(rJacobian, 17, 0) = 2.6014568158168572e-10 * (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) * (-0.01 * var_x370 - 6138.6138613861385 * var_x371) / pow((var_x371 + 0.00048387096774193548 * var_x370), 2) - 0.69444444444444453 * (8.9552238805970142e-5 * var_x372 + 0.048000000000000001 * var_x373) * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 / pow((var_x373 + 0.00050000000000000001 * var_x372), 2);
        IJth(rJacobian, 18, 0) = var_x105 * var_x382 + var_x120 * var_x382 + var_x377 * (-0.023333333333333334 * var_x375 - 941.17647058823525 * var_x376) - var_x114 * var_x382 - var_x118 * var_x382 - var_x383 * (0.00040000000000000002 * var_x380 + 1.5384615384615384e-5 * var_x378);
        IJth(rJacobian, 19, 0) = (2.0000000000000002e-5 * var_x384 - 2.5000000000000001e-5 * var_x388 * (-5.7142857142857144 * var_x386 - 0.20000000000000001 * var_x387)) * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 + 0.0025000000000000001 * (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * (1.7391304347826086 * var_x390 + 0.016666666666666666 * var_x389) / pow((var_x390 + 0.25 * var_x389), 2);
        IJth(rJacobian, 20, 0) = (5.0000000000000004e-6 * var_x384 - 2.4999999999999999e-7 * var_x388 * (-2.0 * var_x387 - 57.142857142857146 * var_x386)) * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 2.5000000000000001e-5 * (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) * (0.066666666666666666 * var_x389 + 15.384615384615385 * var_x391) / pow((var_x391 + 0.10000000000000001 * var_x389), 2);
        IJth(rJacobian, 21, 0) = 0.01 * (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) * (-0.0083333333333333332 * var_x392 - 0.58823529411764708 * var_x289) / pow((var_x289 + 0.25 * var_x392), 2) - 0.25 * (0.020588235294117647 * var_x393 + 0.013333333333333334 * var_x394) * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 / pow((var_x394 + 0.17499999999999999 * var_x393), 2);
        IJth(rJacobian, 22, 0) = 7.3046018991964936e-6 * (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) * (8.0952380952380949 * var_x395 + 5.967741935483871 * var_x396) / pow((var_x396 + 0.22972972972972974 * var_x395), 2) - 4.7562425683709868e-7 * (-72.5 * var_x303 - 2.6000000000000001 * var_x318) * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 / pow((var_x303 + 0.1793103448275862 * var_x318), 2);
        IJth(rJacobian, 24, 0) = 0.0082644628099173556 * (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) * (0.00050000000000000001 * var_x284 + 0.39285714285714285 * var_x397) / pow((var_x397 + 0.018181818181818184 * var_x284), 2) - 0.051652892561983466 * (-0.27500000000000002 * var_x399 - 0.00040000000000000002 * var_x398) * var_chaste_interface__transient_outward_current_y1_gate__y1 / pow((var_x399 + 0.045454545454545456 * var_x398), 2);
        IJth(rJacobian, 25, 0) = -0.00033628318584070794 * var_x403 * var_x407 - 0.00033628318584070794 * var_x406 * var_chaste_interface__transient_outward_current_y2_gate__y2 + 1.7263097345132742e-5 * var_x403 * pow(var_x401, 2) / pow(var_x402, 2) + 2.2558884955752213e-5 * pow(var_x404, 2) * var_chaste_interface__transient_outward_current_y2_gate__y2 / pow(var_x405, 2);
        IJth(rJacobian, 26, 0) = -0.011979261536575346 * var_x47 - 0.016290910314181915 * var_x39 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y);
        IJth(rJacobian, 27, 0) = var_x139 * (-8.738369770208911e-5 * var_x142 + 0.00034888555005620854 * var_x411 / pow((1 + 0.067138346456864173 * var_x411), 2));
        IJth(rJacobian, 29, 0) = -var_x415;
        IJth(rJacobian, 30, 0) = var_x415;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-0.38500000000000001 * var_x155 - 0.030496093294460638 * var_x159 - 1.8699265995488508 * var_x169 - var_x103 * var_x155 - var_x153 * var_x155 - var_x155 * var_x51 - var_x155 * var_x94 - var_x155 * var_x98));
        IJth(rJacobian, 1, 1) = -7.2675557857281787e-6 * var_x169 - 1.1852447006087616e-7 * var_x159 - 4.9877340607565601e-7 * var_x155 - var_x155 * var_x236 - var_x155 * var_x237 - var_x155 * var_x238 - var_x155 * var_x239 - var_x155 * var_x240;
        IJth(rJacobian, 2, 1) = 4.8450371904854522e-6 * var_x169;
        IJth(rJacobian, 3, 1) = 3.9508156686958718e-8 * var_x159;
        IJth(rJacobian, 4, 1) = -2.4225185952427261e-6 * var_x169;
        IJth(rJacobian, 26, 1) = (-0.0044781341107871719 * var_x157 + 6.1798250728862972e-6 * var_x262 * var_x410 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 2)) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
        IJth(rJacobian, 27, 1) = (-0.089044123788040511 * var_x167 + 4.8132665714837462e-5 * var_x412 * var_x414 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 0.060000000000000053)) * var_chaste_interface__sodium_potassium_pump_y_gate__y;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x170 + 0.039516010388377508 * var_x192 - 1763.6449644200743 * var_x172 - 0.15400000000000003 * var_x171 - 30.612905384887238 * var_x190 + var_x138 * var_x186 + var_x187 * var_x54 - var_x101 * var_x171 - var_x102 * var_x171 - var_x104 * var_x171 - var_x152 * var_x171 - var_x171 * var_x51));
        IJth(rJacobian, 1, 2) = 1.5358079295531472e-7 * var_x192;
        IJth(rJacobian, 2, 2) = -3.9659488542057145e-5 * var_x190 - 1.0238719530354315e-7 * var_x192 - 0.0022848291065246224 * var_x172 - 1.2955153404562495e-6 * var_x170 - 1.9950936243026244e-7 * var_x171 + var_x186 * var_x251 + var_x187 * var_x246 - var_x171 * var_x236 - var_x171 * var_x247 - var_x171 * var_x248 - var_x171 * var_x249 - var_x171 * var_x252;
        IJth(rJacobian, 4, 2) = 5.1193597651771573e-8 * var_x192;
        IJth(rJacobian, 18, 2) = var_x180 * var_x382 + var_x183 * var_x382 + var_x377 * (-0.62329941155965873 * var_x375 * var_x55 - 25141.488869633296 * var_x376 * var_x55) - var_x179 * var_x382 - var_x181 * var_x382 - var_x383 * (0.010685132769594151 * var_x380 * var_x55 + 0.00041096664498439041 * var_x378 * var_x55);
        IJth(rJacobian, 27, 2) = (0.0018817147803989289 * var_x191 - 0.00022400328987130325 * var_x413 * var_x414 * var_x55) * var_chaste_interface__sodium_potassium_pump_y_gate__y;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (0.010165364431486881 * var_x202 - 0.040000000000000001 * var_x196 + var_x197 * var_x199 + var_x199 * var_x200 - var_x196 * var_x92 - var_x150 * var_x196 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL));
        IJth(rJacobian, 1, 3) = 3.9508156686958718e-8 * var_x202 + var_x197 * var_x241;
        IJth(rJacobian, 2, 3) = var_x200 * var_x241;
        IJth(rJacobian, 3, 3) = -0.00014866038531735463 + 0.00033683398851862484 * var_x268 - 0.0056432648230274225 * var_x269 - 0.00014866038531735463 * var_x193 - 2.591030680912499e-8 * var_x196 - 1.3169385562319573e-8 * var_x202 + var_x258 * (-1.3650000000000002 - 1.3650000000000002 * var_x193) + (-54.600000000000009 - 54.600000000000009 * var_x193) * var_chaste_interface__NL_model__pCB + (-0.020080487777071866 - 0.020080487777071866 * var_x193) * var_chaste_interface__RyR_channel__p_open_RyR - var_x196 * var_x256;
        IJth(rJacobian, 4, 3) = 0.00016841699425931242 * var_x268;
        IJth(rJacobian, 12, 3) = (-var_x357 - var_x358) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U;
        IJth(rJacobian, 13, 3) = (var_x357 + var_x358) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U;
        IJth(rJacobian, 14, 3) = -var_x358 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C;
        IJth(rJacobian, 23, 3) = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * (1.8500000000000001 + 1.8500000000000001 * var_x193);
        IJth(rJacobian, 26, 3) = (0.0014927113702623907 * var_x201 + 0.0055199999999999997 * var_x265 * var_x408 * var_x410) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
        IJth(rJacobian, 28, 3) = var_x259 * (3.2000000000000005e-5 * var_x266 - 0.0032000000000000002 * var_x267);
        IJth(rJacobian, 29, 3) = (var_x416 - var_x417) * var_chaste_interface__RyR_channel__p_close_RyR;
        IJth(rJacobian, 30, 3) = (var_x417 - var_x416) * var_chaste_interface__RyR_channel__p_close_RyR;
        IJth(rJacobian, 31, 3) = (1.0040243888535934 + 1.0040243888535934 * var_x193) * var_chaste_interface__RyR_channel__p_open_RyR;
        IJth(rJacobian, 32, 3) = 0.0029732077063470926 + 0.0029732077063470926 * var_x193 - 0.0067366797703724973 * var_x268;
        IJth(rJacobian, 33, 3) = var_x258 * (19.5 + 19.5 * var_x193);
        IJth(rJacobian, 34, 3) = (780.0 + var_x433) * var_chaste_interface__NL_model__pCB;
        IJth(rJacobian, 35, 3) = (-780.0 - var_x433) * var_chaste_interface__NL_model__pCB;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (1.320447767903262 * var_x204 - 3.4765451895043737 * var_x211 - 0.17620845481049566 * var_x212 - 0.73038000000000003 * var_x208 - 9524.7813411078732 * var_x214));
        IJth(rJacobian, 1, 4) = -2.2828075632508891e-7 * var_x212 - 2.8386554830873062e-6 * var_x208;
        IJth(rJacobian, 2, 4) = 1.710660339589889e-6 * var_x204 + 1.8924369887248709e-6 * var_x208 - 4.5039176247922949e-6 * var_x211;
        IJth(rJacobian, 3, 4) = -0.010526062141207028 * var_x271 - 0.0061697501709483491 * var_x214;
        IJth(rJacobian, 4, 4) = -0.0030000000000000001 - 9.4621849436243545e-7 * var_x208 - 0.005263031070603514 * var_x271;
        IJth(rJacobian, 27, 4) = -0.034779999999999998 * var_x207;
        IJth(rJacobian, 28, 4) = 0.10000000000000001 * var_x271;
        IJth(rJacobian, 29, 4) = -var_x418;
        IJth(rJacobian, 30, 4) = var_x418;
        IJth(rJacobian, 32, 4) = 0.21052124282414053 * var_x271;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x215 * var_chaste_interface__sodium_current_ultra_slow_gate__y - var_x216 * var_chaste_interface__sodium_current_ultra_slow_gate__y));
        IJth(rJacobian, 1, 5) = -var_x242 * var_chaste_interface__sodium_current_ultra_slow_gate__y;
        IJth(rJacobian, 2, 5) = -var_x253 * var_chaste_interface__sodium_current_ultra_slow_gate__y;
        IJth(rJacobian, 5, 5) = -var_x298 - var_x299;
        IJth(rJacobian, 6, 5) = var_x298 + var_x315;
        IJth(rJacobian, 7, 5) = var_x299 + var_x316;
        IJth(rJacobian, 5, 6) = var_x301;
        IJth(rJacobian, 6, 6) = -0.01 - var_x301;
        IJth(rJacobian, 7, 6) = var_x316;
        IJth(rJacobian, 5, 7) = 8.7499999999999999e-5;
        IJth(rJacobian, 6, 7) = var_x315;
        IJth(rJacobian, 7, 7) = -8.7499999999999999e-5 + var_x316 - 1.0 / var_x304;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x215 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_x216 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na));
        IJth(rJacobian, 1, 8) = -var_x242 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
        IJth(rJacobian, 2, 8) = -var_x253 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
        IJth(rJacobian, 8, 8) = -1.0 / (4000.0 * var_x322 + 0.014 * var_x321) - 1.0 / (8000.0 * var_x318 + 9000000000.0 * var_x320);
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x149 * var_x217 - var_x149 * var_x218 - var_x149 * var_x219));
        IJth(rJacobian, 1, 9) = -var_x149 * var_x243;
        IJth(rJacobian, 2, 9) = -var_x149 * var_x254;
        IJth(rJacobian, 3, 9) = -var_x149 * var_x272;
        IJth(rJacobian, 9, 9) = -0.0040000000000000001 - var_x334;
        IJth(rJacobian, 10, 9) = var_x334 + var_x352;
        IJth(rJacobian, 11, 9) = 0.0040000000000000001 + var_x353;
        IJth(rJacobian, 12, 9) = var_x360;
        IJth(rJacobian, 13, 9) = -var_x360;
        IJth(rJacobian, 14, 9) = (0.18212526000000001 + var_x359 - 3.4769999999999999 * var_x30 - 3.4769999999999999 * var_chaste_interface__internal_ion_concentrations__Ca_Total) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C;
        IJth(rJacobian, 29, 9) = -var_x421;
        IJth(rJacobian, 30, 9) = var_x421;
        IJth(rJacobian, 9, 10) = var_x336;
        IJth(rJacobian, 10, 10) = -0.040000000000000001 - var_x336;
        IJth(rJacobian, 11, 10) = var_x353;
        IJth(rJacobian, 9, 11) = 0.001;
        IJth(rJacobian, 10, 11) = var_x352;
        IJth(rJacobian, 11, 11) = -0.001 + var_x353 - 1.0 / var_x339;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (var_x221);
        IJth(rJacobian, 1, 12) = var_x244;
        IJth(rJacobian, 2, 12) = var_x255;
        IJth(rJacobian, 3, 12) = var_x273;
        IJth(rJacobian, 12, 12) = -0.34999999999999998 + var_x363 - var_x361;
        IJth(rJacobian, 13, 12) = -0.00029999999999999997 + var_x361 + var_x362;
        IJth(rJacobian, 14, 12) = 0.3458;
        IJth(rJacobian, 29, 12) = var_x423;
        IJth(rJacobian, 30, 12) = var_x422;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x221);
        IJth(rJacobian, 1, 13) = var_x244;
        IJth(rJacobian, 2, 13) = var_x255;
        IJth(rJacobian, 3, 13) = var_x273;
        IJth(rJacobian, 12, 13) = 2.0019999999999998;
        IJth(rJacobian, 13, 13) = -2.3523000000000001;
        IJth(rJacobian, 14, 13) = -0.0041999999999999997;
        IJth(rJacobian, 29, 13) = var_x423;
        IJth(rJacobian, 30, 13) = var_x422;
        IJth(rJacobian, 12, 14) = 0.14299999999999999;
        IJth(rJacobian, 13, 14) = -0.00029999999999999997;
        IJth(rJacobian, 14, 14) = -0.1472 + var_x363;
        IJth(rJacobian, 0, 15) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x217 * var_x222 - var_x218 * var_x222 - var_x219 * var_x222));
        IJth(rJacobian, 1, 15) = -var_x222 * var_x243;
        IJth(rJacobian, 2, 15) = -var_x222 * var_x254;
        IJth(rJacobian, 3, 15) = -var_x222 * var_x272;
        IJth(rJacobian, 15, 15) = -1.0 / (58.0 * var_x329 + 250000.0 * var_x364) - 1.0 / (66.0 * var_x325 + 1800.0 * var_x365);
        IJth(rJacobian, 29, 15) = -var_x424;
        IJth(rJacobian, 30, 15) = var_x424;
        IJth(rJacobian, 0, 16) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x223 * var_x91);
        IJth(rJacobian, 3, 16) = -var_x274 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2;
        IJth(rJacobian, 16, 16) = -1.0 / (1.5 * var_x368 + 40.0 * var_x369) - 1.0 / (0.019 * var_x366 + 0.81999999999999995 * var_x367);
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (-612.0 * var_x223 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1);
        IJth(rJacobian, 3, 17) = -var_x274 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1;
        IJth(rJacobian, 17, 17) = -1.0 / (30.0 * var_x370 + 62000.0 * var_x371) - 1.0 / (1.2 * var_x373 + 0.00059999999999999995 * var_x372);
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (var_x137 * var_x189);
        IJth(rJacobian, 2, 18) = var_x189 * var_x250 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 18, 18) = -1.0 / (7.0 * var_x375 + 8000.0 * var_x376) - var_x188 * var_x381;
        IJth(rJacobian, 0, 19) = mSetVoltageDerivativeToZero ? 0.0 : ((0.1384793206939402 * var_x56 - 0.0051840000000000002 * var_chaste_interface__membrane__Vm) * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3);
        IJth(rJacobian, 2, 19) = var_x53 * (1.7940208429496008e-7 * var_x56 - 6.7159515249251966e-9 * var_chaste_interface__membrane__Vm);
        IJth(rJacobian, 19, 19) = -1.0 / (5.0 * var_x389 + 20.0 * var_x390) - 1.0 / (160.0 * var_x386 + 200.0 * var_x387) - 0.00040000000000000002 * var_x384;
        IJth(rJacobian, 0, 20) = mSetVoltageDerivativeToZero ? 0.0 : ((0.092319547129293467 * var_x56 - 0.0034560000000000003 * var_chaste_interface__membrane__Vm) * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3);
        IJth(rJacobian, 2, 20) = var_x53 * (1.196013895299734e-7 * var_x56 - 4.477301016616798e-9 * var_chaste_interface__membrane__Vm);
        IJth(rJacobian, 20, 20) = -1.0 / (20.0 * var_x389 + 200.0 * var_x391) - 1.0 / (1600.0 * var_x386 + 2000.0 * var_x387) - 0.0001 * var_x384;
        IJth(rJacobian, 0, 21) = mSetVoltageDerivativeToZero ? 0.0 : (var_x203 * var_x52);
        IJth(rJacobian, 2, 21) = var_x203 * var_x245 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 21, 21) = -1.0 / (2.0 * var_x394 + 0.34999999999999998 * var_x393) - 1.0 / (2.5 * var_x392 + 10.0 * var_x289);
        IJth(rJacobian, 0, 22) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-0.4032 * var_x225 - 10.08 * var_x226));
        IJth(rJacobian, 1, 22) = -5.2235178527195981e-7 * var_x225;
        IJth(rJacobian, 2, 22) = -1.3058794631798995e-5 * var_x226;
        IJth(rJacobian, 22, 22) = -1.0 / (260.0 * var_x318 + 1450.0 * var_x303) - 1.0 / (85.0 * var_x395 + 370.0 * var_x396);
        IJth(rJacobian, 0, 23) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-4.5360000000000005 * var_x227 - 0.18144000000000002 * var_x228));
        IJth(rJacobian, 1, 23) = -2.3505830337238192e-7 * var_x228;
        IJth(rJacobian, 2, 23) = -5.8764575843095472e-6 * var_x227;
        IJth(rJacobian, 23, 23) = 0.092459000000000013 - 1.8500000000000001 * var_x30 - 1.8500000000000001 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        IJth(rJacobian, 0, 24) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-0.099000000000000005 * var_x230 - 0.0089099999999999995 * var_x231));
        IJth(rJacobian, 1, 24) = -1.1543041683465182e-8 * var_x231;
        IJth(rJacobian, 2, 24) = -1.2825601870516871e-7 * var_x230;
        IJth(rJacobian, 24, 24) = -1.0 / (11.0 * var_x397 + 0.20000000000000001 * var_x284) - 1.0 / (4.4000000000000004 * var_x399 + 0.20000000000000001 * var_x398);
        IJth(rJacobian, 0, 25) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-0.033000000000000002 * var_x232 - 0.00297 * var_x233));
        IJth(rJacobian, 1, 25) = -3.8476805611550606e-9 * var_x233;
        IJth(rJacobian, 2, 25) = -4.2752006235056235e-8 * var_x232;
        IJth(rJacobian, 25, 25) = -0.0038 * var_x406 - 0.0038 * var_x407;
        IJth(rJacobian, 0, 26) = mSetVoltageDerivativeToZero ? 0.0 : (-6.8099999999999996 * var_x46 - 4.3581631433074284 * var_x39);
        IJth(rJacobian, 1, 26) = (-1.6938201625097406e-5 * var_x39 - 2.6467378405521174e-5 * var_x46) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 3, 26) = (8.8224594685070574e-6 * var_x46 + 5.6460672083658019e-6 * var_x39) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 26, 26) = -0.20379327210477693 - 1.0 * var_x46 - 1.0 / var_x409 - 0.6399652192815608 * var_x39;
        IJth(rJacobian, 0, 27) = mSetVoltageDerivativeToZero ? 0.0 : (-7.7699999999999996 * var_x235 - 0.83999999999999997 * var_x234);
        IJth(rJacobian, 1, 27) = (-3.2646986579497488e-6 * var_x234 - 3.0198462586035172e-5 * var_x235) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 2, 27) = (2.1764657719664992e-6 * var_x234 + 2.0132308390690117e-5 * var_x235) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 4, 27) = (-1.0882328859832496e-6 * var_x234 - 1.0066154195345059e-5 * var_x235) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 27, 27) = -0.37 * var_x235 - 0.01 / (1.0 + 49.999265664512095 * var_x413) - 0.040000000000000001 * var_x234 - 0.16500000000000001 / (1.0331690520373935 + 0.069365261764196454 * var_x411);
        IJth(rJacobian, 3, 28) = 0.0010526062141207027 * var_x276 + 0.10526062141207027 * var_x277;
        IJth(rJacobian, 4, 28) = 0.00052630310706035135 * var_x276 + 0.052630310706035133 * var_x277;
        IJth(rJacobian, 28, 28) = -1.01 + 0.01 * var_x270 + 0.98999999999999999 * var_x276 - 1.0 * var_x277;
        IJth(rJacobian, 32, 28) = -0.021052124282414052 * var_x276 - 2.1052124282414053 * var_x277;
        IJth(rJacobian, 3, 29) = -0.21581745204261313 + 0.020080487777071866 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 0.21686926799237616 * var_x279 - 0.020080487777071866 * var_x30 - 0.020080487777071866 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        IJth(rJacobian, 29, 29) = -0.080000000000000002 / var_x425;
        IJth(rJacobian, 30, 29) = var_x430;
        IJth(rJacobian, 31, 29) = 10.790872602130657 + 1.0040243888535934 * var_x30 + 1.0040243888535934 * var_chaste_interface__internal_ion_concentrations__Ca_Total - 1.0040243888535934 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total - 10.843463399618807 * var_x279;
        IJth(rJacobian, 29, 30) = var_x426 - var_x427;
        IJth(rJacobian, 30, 30) = -0.00084900000000000004 + var_x427 + var_x430 - var_x426;
        IJth(rJacobian, 3, 31) = (0.020080487777071866 + 0.21686926799237616 * var_x280) * var_chaste_interface__RyR_channel__p_open_RyR;
        IJth(rJacobian, 29, 31) = 0.00098765432098765434 * (-0.5 - 5.4000000000000004 * var_x280) * var_chaste_interface__RyR_channel__p_open_RyR / (pow(var_x425, 2) * var_x429);
        IJth(rJacobian, 30, 31) = 0.010993320000000001 * var_x428 * (0.18518518518518517 + 2 * var_x280) * (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR);
        IJth(rJacobian, 31, 31) = -0.0062508615177014034 - 0.067509304391175154 * var_x280 + (-1.0040243888535934 - 10.843463399618807 * var_x280) * var_chaste_interface__RyR_channel__p_open_RyR;
        IJth(rJacobian, 32, 31) = 0.0025003446070805614 + 0.027003721756470062 * var_x280;
        IJth(rJacobian, 3, 32) = 0.00029732077063470926 + 8.4208497129656211e-5 * var_x281;
        IJth(rJacobian, 4, 32) = 4.2104248564828106e-5 * var_x281;
        IJth(rJacobian, 28, 32) = 0.079200000000000007 * var_x281;
        IJth(rJacobian, 31, 32) = 0.012501723035402807;
        IJth(rJacobian, 32, 32) = -0.010947104626855308 - 0.0016841699425931243 * var_x281;
        IJth(rJacobian, 3, 33) = var_x282;
        IJth(rJacobian, 33, 33) = 0.99141000000000001 + var_x432 - var_x431;
        IJth(rJacobian, 34, 33) = var_x431;
        IJth(rJacobian, 3, 34) = var_x282 + 0.0027216000000000002 * var_x283;
        IJth(rJacobian, 4, 34) = -0.028000000000000004;
        IJth(rJacobian, 33, 34) = 1.0253100000000002 + var_x432;
        IJth(rJacobian, 34, 34) = -0.0339 + var_x434;
        IJth(rJacobian, 35, 34) = 0.029999999999999999;
        IJth(rJacobian, 3, 35) = 2.7884493000000004 - 53.235000000000007 * var_x30 - 53.235000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        IJth(rJacobian, 33, 35) = 1.0214100000000002 + var_x432;
        IJth(rJacobian, 34, 35) = -40.856400000000001 + var_x435 + var_x436;
        IJth(rJacobian, 35, 35) = 40.736400000000003 + var_x434 - var_x435 - var_x436;
        IJth(rJacobian, 3, 36) = (-0.0052112108026161966 + 0.0054432000000000005 * var_chaste_interface__NL_model__X) * var_chaste_interface__NL_model__pCaCB;
        IJth(rJacobian, 34, 36) = var_x437 * var_chaste_interface__NL_model__pCaCB;
        IJth(rJacobian, 35, 36) = var_x437 * var_chaste_interface__NL_model__pCB;
        IJth(rJacobian, 36, 36) = -1.2;
    }

    N_Vector Cellmatsuoka_model_2003FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = NV_Ith_S(rY, 3);
        // Units: millimolar; Initial value: 0.00040180173572968586
        
        // Mathematics
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(4);
        NV_Ith_S(dqs, 0) = var_internal_ion_concentrations__Cai;
        NV_Ith_S(dqs, 1) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 2) = var_membrane__Cm_converted;
        NV_Ith_S(dqs, 3) = var_membrane__i_ext_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "matsuoka_model_2003";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.95752434460744);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("internal_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.925761439682025);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("internal_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(143.1837333000449);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("internal_ion_concentrations__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00040180173572968586);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("ATP_production__ATPi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.657102729020499);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.779648367445368e-05);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_RP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3556412697995689);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AI_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.40285968661346977);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("sodium_current_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5861887862983165);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5445004166497696e-06);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9968480629364956);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000877325391245903);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_U");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.17246483915629204);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_UCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.098246017787626e-05);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4250747299372254);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("L_type_Ca_channel_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9985266538252986);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("T_type_Ca_channel_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.6882718240109127e-05);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("T_type_Ca_channel_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8585352091865849);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("time_independent_potassium_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6080573900752752);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018339931180983765);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.20443083454225305);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y3_gate__y3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.967887666264921);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09738789658609195);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09745345578743213);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("transient_outward_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007956883250874798);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("transient_outward_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999125083105881);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("sodium_calcium_exchanger_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9891789193465331);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("sodium_potassium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5910747147428818);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("SR_calcium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46108441538480216);

    // NV_Ith_S(rY, 29):
    this->mVariableNames.push_back("RyR_channel__p_open_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00034314360001543243);

    // NV_Ith_S(rY, 30):
    this->mVariableNames.push_back("RyR_channel__p_close_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.19135178123107768);

    // NV_Ith_S(rY, 31):
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.455741736977666);

    // NV_Ith_S(rY, 32):
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.611712901567567);

    // NV_Ith_S(rY, 33):
    this->mVariableNames.push_back("NL_model__pCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02490898775497523);

    // NV_Ith_S(rY, 34):
    this->mVariableNames.push_back("NL_model__pCaCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001990153835322864);

    // NV_Ith_S(rY, 35):
    this->mVariableNames.push_back("NL_model__pCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00042941813853474524);

    // NV_Ith_S(rY, 36):
    this->mVariableNames.push_back("NL_model__X");
    this->mVariableUnits.push_back("micrometre");
    this->mInitialConditions.push_back(0.9573749975411884);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmatsuoka_model_2003FromCellMLCvode)
#endif // CHASTE_CVODE
