#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: luo_rudy_1994
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "luo_rudy_1994.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellluo_rudy_1994FromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stimCurrent_converted = 50.000000000000007; // uA_per_cm2
        const double var_chaste_interface__membrane__stimDuration = 0.5; // ms
        const double var_chaste_interface__membrane__stimPeriod = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stimCurrent_converted),
                var_chaste_interface__membrane__stimDuration,
                var_chaste_interface__membrane__stimPeriod,
                0.0
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellluo_rudy_1994FromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellluo_rudy_1994FromCellMLCvode::Cellluo_rudy_1994FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                12,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellluo_rudy_1994FromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 1.8; // (var_ionic_concentrations__Cao) [mM]
        NV_Ith_S(this->mParameters, 1) = 5.4000000000000004; // (var_ionic_concentrations__Ko) [mM]
        NV_Ith_S(this->mParameters, 2) = 140.0; // (var_ionic_concentrations__Nao) [mM]
        NV_Ith_S(this->mParameters, 3) = 0.01; // (var_membrane__Cm) [uF_per_mm2]
        NV_Ith_S(this->mParameters, 4) = 0.16; // (var_fast_sodium_current__g_Na) [mS_per_mm2]
        NV_Ith_S(this->mParameters, 5) = 0.0074999999999999997; // (var_time_independent_potassium_current__g_K1_max) [mS_per_mm2]
    }

    Cellluo_rudy_1994FromCellMLCvode::~Cellluo_rudy_1994FromCellMLCvode()
    {
    }
    
    double Cellluo_rudy_1994FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -84.624
        double var_chaste_interface__ionic_concentrations__Cai = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 8);
        // Units: mM; Initial value: 10.0
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 9);
        // Units: mM; Initial value: 145.0
        
        const double var_L_type_Ca_channel__P_Ca = 5.4e-6; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.9300000000000002e-9; // mm_per_ms
        const double var_L_type_Ca_channel__P_Na = 6.7500000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34000000000000002; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // mM
        const double var_Na_Ca_exchanger__K_NaCa = 20.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__K_sat = 0.10000000000000001; // dimensionless
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_calcium_background_current__g_Cab = 3.0159999999999999e-5; // mS_per_mm2
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + pow(var_chaste_interface__ionic_concentrations__Cai, 2) / pow(var_L_type_Ca_channel_f_Ca_gate__Km_Ca, 2)); // dimensionless
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 0) / var_chaste_interface__ionic_concentrations__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 2) / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * NV_Ith_S(mParameters, 0) + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__ionic_concentrations__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * NV_Ith_S(mParameters, 1) + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * NV_Ith_S(mParameters, 2) + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * NV_Ith_S(mParameters, 0) * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(NV_Ith_S(mParameters, 2), 3) * var_chaste_interface__ionic_concentrations__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + var_Na_Ca_exchanger__K_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(NV_Ith_S(mParameters, 2), 3)) * (var_Na_Ca_exchanger__K_mCa + NV_Ith_S(mParameters, 0))); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 4) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_fast_sodium_current__i_Na_converted = 100.00000000000001 * var_fast_sodium_current__i_Na; // uA_per_cm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((NV_Ith_S(mParameters, 1) + NV_Ith_S(mParameters, 2)) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__Vns = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * NV_Ith_S(mParameters, 1) + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__Vns / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * NV_Ith_S(mParameters, 2) + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__Vns / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__ionic_concentrations__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__ionic_concentrations__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.000183; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__ionic_concentrations__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__ionic_concentrations__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.014999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * NV_Ith_S(mParameters, 2)); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = NV_Ith_S(mParameters, 1) * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (NV_Ith_S(mParameters, 1) + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__PR_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((NV_Ith_S(mParameters, 2) * var_time_dependent_potassium_current__PR_NaK + NV_Ith_S(mParameters, 1)) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__PR_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.00282; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(NV_Ith_S(mParameters, 1)) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 1) / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(NV_Ith_S(mParameters, 1)) * NV_Ith_S(mParameters, 5); // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double var_time_independent_potassium_current__i_K1_converted = 100.00000000000001 * var_time_independent_potassium_current__i_K1; // uA_per_cm2
        const double var_chaste_interface__i_ionic = -var_fast_sodium_current__i_Na_converted - var_time_independent_potassium_current__i_K1_converted - 100.00000000000001 * var_L_type_Ca_channel__i_Ca_L - 100.00000000000001 * var_Na_Ca_exchanger__i_NaCa - 100.00000000000001 * var_calcium_background_current__i_Ca_b - 100.00000000000001 * var_non_specific_calcium_activated_current__i_ns_Ca - 100.00000000000001 * var_plateau_potassium_current__i_Kp - 100.00000000000001 * var_sarcolemmal_calcium_pump__i_p_Ca - 100.00000000000001 * var_sodium_background_current__i_Na_b - 100.00000000000001 * var_sodium_potassium_pump__i_NaK - 100.00000000000001 * var_time_dependent_potassium_current__i_K; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellluo_rudy_1994FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -84.624
        double var_chaste_interface__ionic_concentrations__Cai = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 8);
        // Units: mM; Initial value: 10.0
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 9);
        // Units: mM; Initial value: 145.0
        double var_chaste_interface__ionic_concentrations__Ca_JSR = NV_Ith_S(rY, 10);
        // Units: mM; Initial value: 1.8
        double var_chaste_interface__ionic_concentrations__Ca_NSR = NV_Ith_S(rY, 11);
        // Units: mM; Initial value: 1.8

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__P_Ca = 5.4e-6; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.9300000000000002e-9; // mm_per_ms
        const double var_L_type_Ca_channel__P_Na = 6.7500000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34000000000000002; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // mM
        const double var_Na_Ca_exchanger__K_NaCa = 20.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__K_sat = 0.10000000000000001; // dimensionless
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_calcium_background_current__g_Cab = 3.0159999999999999e-5; // mS_per_mm2
        const double var_calcium_fluxes_in_the_SR__Ca_NSR_max = 15.0; // mM
        const double var_calcium_fluxes_in_the_SR__G_rel_max = 60.0; // per_ms
        const double var_calcium_fluxes_in_the_SR__I_up = 0.0050000000000000001; // mM_per_ms
        const double var_calcium_fluxes_in_the_SR__K_leak = var_calcium_fluxes_in_the_SR__I_up / var_calcium_fluxes_in_the_SR__Ca_NSR_max; // per_ms
        const double var_calcium_fluxes_in_the_SR__K_mrel = 0.00080000000000000004; // mM
        const double var_calcium_fluxes_in_the_SR__K_mup = 0.00092000000000000003; // mM
        const double var_calcium_fluxes_in_the_SR__delta_Ca_i2 = 0; // mM
        const double var_calcium_fluxes_in_the_SR__delta_Ca_ith = 0.00018000000000000001; // mM
        const double var_calcium_fluxes_in_the_SR__G_rel_peak = ((var_calcium_fluxes_in_the_SR__delta_Ca_i2 < var_calcium_fluxes_in_the_SR__delta_Ca_ith) ? (0) : (var_calcium_fluxes_in_the_SR__G_rel_max)); // per_ms
        const double var_calcium_fluxes_in_the_SR__t_CICR = 0; // ms
        const double var_calcium_fluxes_in_the_SR__tau_off = 2.0; // ms
        const double var_calcium_fluxes_in_the_SR__tau_on = 2.0; // ms
        const double var_calcium_fluxes_in_the_SR__G_rel = (1.0 - exp(-var_calcium_fluxes_in_the_SR__t_CICR / var_calcium_fluxes_in_the_SR__tau_on)) * (-var_calcium_fluxes_in_the_SR__delta_Ca_ith + var_calcium_fluxes_in_the_SR__delta_Ca_i2) * var_calcium_fluxes_in_the_SR__G_rel_peak * exp(-var_calcium_fluxes_in_the_SR__t_CICR / var_calcium_fluxes_in_the_SR__tau_off) / (-var_calcium_fluxes_in_the_SR__delta_Ca_ith + var_calcium_fluxes_in_the_SR__K_mrel + var_calcium_fluxes_in_the_SR__delta_Ca_i2); // per_ms
        const double var_calcium_fluxes_in_the_SR__tau_tr = 180.0; // ms
        const double var_ionic_concentrations__Am = 200.0; // per_mm
        const double var_calcium_fluxes_in_the_SR__i_leak = var_calcium_fluxes_in_the_SR__K_leak * var_chaste_interface__ionic_concentrations__Ca_NSR; // mM_per_ms
        const double var_calcium_fluxes_in_the_SR__i_tr = (-var_chaste_interface__ionic_concentrations__Ca_JSR + var_chaste_interface__ionic_concentrations__Ca_NSR) / var_calcium_fluxes_in_the_SR__tau_tr; // mM_per_ms
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + pow(var_chaste_interface__ionic_concentrations__Cai, 2) / pow(var_L_type_Ca_channel_f_Ca_gate__Km_Ca, 2)); // dimensionless
        const double var_calcium_fluxes_in_the_SR__i_rel = (-var_chaste_interface__ionic_concentrations__Cai + var_chaste_interface__ionic_concentrations__Ca_JSR) * var_calcium_fluxes_in_the_SR__G_rel; // mM_per_ms
        const double var_calcium_fluxes_in_the_SR__i_up = var_calcium_fluxes_in_the_SR__I_up * var_chaste_interface__ionic_concentrations__Cai / (var_calcium_fluxes_in_the_SR__K_mup + var_chaste_interface__ionic_concentrations__Cai); // mM_per_ms
        const double d_dt_chaste_interface_var_ionic_concentrations__Ca_NSR = -var_calcium_fluxes_in_the_SR__i_leak - var_calcium_fluxes_in_the_SR__i_tr + var_calcium_fluxes_in_the_SR__i_up; // mM / ms
        const double var_ionic_concentrations__V_JSR = 0.0047999999999999996; // dimensionless
        const double var_ionic_concentrations__V_NSR = 0.055199999999999999; // dimensionless
        const double d_dt_chaste_interface_var_ionic_concentrations__Ca_JSR = -var_calcium_fluxes_in_the_SR__i_rel + var_calcium_fluxes_in_the_SR__i_tr * var_ionic_concentrations__V_NSR / var_ionic_concentrations__V_JSR; // mM / ms
        const double var_ionic_concentrations__V_myo = 0.68000000000000005; // dimensionless
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 0) / var_chaste_interface__ionic_concentrations__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 2) / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * NV_Ith_S(mParameters, 0) + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__ionic_concentrations__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * NV_Ith_S(mParameters, 1) + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * NV_Ith_S(mParameters, 2) + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // uA_per_mm2
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = 28.571428571428569 * (1.0 - exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V)) * var_L_type_Ca_channel_d_gate__d_infinity / (10.0 + var_chaste_interface__membrane__V); // ms
        const double var_L_type_Ca_channel_d_gate__alpha_d = var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__tau_d; // per_ms
        const double var_L_type_Ca_channel_d_gate__beta_d = (1.0 - var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = (1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__alpha_d - var_L_type_Ca_channel_d_gate__beta_d * var_chaste_interface__L_type_Ca_channel_d_gate__d; // 1 / ms
        const double var_L_type_Ca_channel_f_gate__f_infinity = 1 / (1.0 + exp(4.0767441860465121 + 0.11627906976744186 * var_chaste_interface__membrane__V)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f = 1 / (0.02 + 0.019699999999999999 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2))); // ms
        const double var_L_type_Ca_channel_f_gate__alpha_f = var_L_type_Ca_channel_f_gate__f_infinity / var_L_type_Ca_channel_f_gate__tau_f; // per_ms
        const double var_L_type_Ca_channel_f_gate__beta_f = (1.0 - var_L_type_Ca_channel_f_gate__f_infinity) / var_L_type_Ca_channel_f_gate__tau_f; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = (1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__alpha_f - var_L_type_Ca_channel_f_gate__beta_f * var_chaste_interface__L_type_Ca_channel_f_gate__f; // 1 / ms
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * NV_Ith_S(mParameters, 0) * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(NV_Ith_S(mParameters, 2), 3) * var_chaste_interface__ionic_concentrations__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + var_Na_Ca_exchanger__K_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(NV_Ith_S(mParameters, 2), 3)) * (var_Na_Ca_exchanger__K_mCa + NV_Ith_S(mParameters, 0))); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 4) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_ms
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / ms
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_ms
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (1.0 - var_chaste_interface__fast_sodium_current_j_gate__j) * var_fast_sodium_current_j_gate__alpha_j - var_fast_sodium_current_j_gate__beta_j * var_chaste_interface__fast_sodium_current_j_gate__j; // 1 / ms
        const double var_fast_sodium_current_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_ms
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / ms
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((NV_Ith_S(mParameters, 1) + NV_Ith_S(mParameters, 2)) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__Vns = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * NV_Ith_S(mParameters, 1) + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__Vns / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * NV_Ith_S(mParameters, 2) + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__Vns / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__Vns / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__ionic_concentrations__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__ionic_concentrations__Cai, 3)); // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.000183; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__ionic_concentrations__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__ionic_concentrations__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Cai = (-var_calcium_fluxes_in_the_SR__i_up + var_calcium_fluxes_in_the_SR__i_leak) * var_ionic_concentrations__V_NSR / var_ionic_concentrations__V_myo + var_calcium_fluxes_in_the_SR__i_rel * var_ionic_concentrations__V_JSR / var_ionic_concentrations__V_myo + 0.5 * (-var_L_type_Ca_channel__i_CaCa - var_calcium_background_current__i_Ca_b - var_sarcolemmal_calcium_pump__i_p_Ca + var_Na_Ca_exchanger__i_NaCa) * var_ionic_concentrations__Am / (var_ionic_concentrations__V_myo * var_membrane__F); // mM / ms
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.014999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * NV_Ith_S(mParameters, 2)); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = NV_Ith_S(mParameters, 1) * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (NV_Ith_S(mParameters, 1) + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = (-var_L_type_Ca_channel__i_CaNa - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__Am / (var_ionic_concentrations__V_myo * var_membrane__F); // mM / ms
        const double var_time_dependent_potassium_current__PR_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((NV_Ith_S(mParameters, 2) * var_time_dependent_potassium_current__PR_NaK + NV_Ith_S(mParameters, 1)) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__PR_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.00282; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(NV_Ith_S(mParameters, 1)) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_X_gate__alpha_X = 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_dependent_potassium_current_X_gate__beta_X = 0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)); // per_ms
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X = (1.0 - var_chaste_interface__time_dependent_potassium_current_X_gate__X) * var_time_dependent_potassium_current_X_gate__alpha_X - var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_X_gate__beta_X; // 1 / ms
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 1) / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(NV_Ith_S(mParameters, 1)) * NV_Ith_S(mParameters, 5); // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = (-var_L_type_Ca_channel__i_CaK - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + 2.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__Am / (var_ionic_concentrations__V_myo * var_membrane__F); // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__I_st_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_membrane__I_st = 0.0099999999999999985 * var_membrane__I_st_converted; // uA_per_mm2
            const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // uA_per_mm2
            const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
            const double var_membrane__dV_dt = (-var_L_type_Ca_channel__i_Ca_L - var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Ca - var_plateau_potassium_current__i_Kp - var_sarcolemmal_calcium_pump__i_p_Ca - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_NaK - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + var_membrane__I_st) / NV_Ith_S(mParameters, 3); // mV_per_ms
            d_dt_chaste_interface_var_membrane__V = var_membrane__dV_dt; // mV / ms
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_ionic_concentrations__Cai;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_ionic_concentrations__Nai;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_ionic_concentrations__Ki;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_ionic_concentrations__Ca_JSR;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_ionic_concentrations__Ca_NSR;
    }

    void Cellluo_rudy_1994FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -84.624
        double var_chaste_interface__ionic_concentrations__Cai = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 8);
        // Units: mM; Initial value: 10.0
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 9);
        // Units: mM; Initial value: 145.0
        
        const double var_x0 = 1 / NV_Ith_S(mParameters, 3);
        const double var_x1 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V);
        const double var_x2 = 1.0 + var_x1;
        const double var_x3 = 1 / var_x2;
        const double var_x4 = -0.75 * NV_Ith_S(mParameters, 1);
        const double var_x5 = 0.037573302761014088 * var_chaste_interface__membrane__V;
        const double var_x6 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
        const double var_x7 = log(var_x6 * (NV_Ith_S(mParameters, 1) + NV_Ith_S(mParameters, 2)));
        const double var_x8 = exp(var_x5 - 1.0 * var_x7);
        const double var_x9 = 0.75 * var_x8;
        const double var_x10 = var_x9 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x11 = var_x10 + var_x4;
        const double var_x12 = 1.0 + 1.7279999999999996e-9 / pow(var_chaste_interface__ionic_concentrations__Cai, 3);
        const double var_x13 = 1 / var_x12;
        const double var_x14 = -1.0 + var_x8;
        const double var_x15 = 1 / var_x14;
        const double var_x16 = var_x13 * var_x15;
        const double var_x17 = 6.3678763853082156e-6 * var_x16;
        const double var_x18 = -0.75 * NV_Ith_S(mParameters, 2);
        const double var_x19 = var_x9 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x20 = var_x18 + var_x19;
        const double var_x21 = 1 / var_chaste_interface__ionic_concentrations__Ki;
        const double var_x22 = log(var_x21 * NV_Ith_S(mParameters, 1));
        const double var_x23 = -26.614641953637257 * var_x22 + var_chaste_interface__membrane__V;
        const double var_x24 = var_x1 * var_x23 / pow(var_x2, 2);
        const double var_x25 = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2);
        const double var_x26 = exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V);
        const double var_x27 = 1.0 + var_x26;
        const double var_x28 = sqrt(NV_Ith_S(mParameters, 1));
        const double var_x29 = var_x28 / var_x27;
        const double var_x30 = var_x25 * var_x29;
        const double var_x31 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
        const double var_x32 = var_x31 * NV_Ith_S(mParameters, 4) * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x33 = var_x32 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x34 = exp(-0.024422646794659157 * var_chaste_interface__membrane__V);
        const double var_x35 = pow(NV_Ith_S(mParameters, 2), 3);
        const double var_x36 = var_x34 * var_x35;
        const double var_x37 = var_x36 * var_chaste_interface__ionic_concentrations__Cai;
        const double var_x38 = NV_Ith_S(mParameters, 0) * exp(0.013150655966354929 * var_chaste_interface__membrane__V);
        const double var_x39 = var_x38 * pow(var_chaste_interface__ionic_concentrations__Nai, 3);
        const double var_x40 = 1.0 + 0.10000000000000001 * var_x34;
        const double var_x41 = 1 / ((669921.875 + var_x35) * (1.3799999999999999 + NV_Ith_S(mParameters, 0)));
        const double var_x42 = var_x41 / var_x40;
        const double var_x43 = var_x42 * (0.024422646794659157 * var_x37 + 0.013150655966354929 * var_x39);
        const double var_x44 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3475921059424856 * var_x22);
        const double var_x45 = 1.0 + var_x44;
        const double var_x46 = 1 / var_x45;
        const double var_x47 = exp(-2.4444678999999998 + 13.687910356755641 * var_x22 - 0.51429999999999998 * var_chaste_interface__membrane__V);
        const double var_x48 = 1.0 + var_x47;
        const double var_x49 = 1 / var_x48;
        const double var_x50 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1376880417161446 * var_x22);
        const double var_x51 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6434541406371006 * var_x22);
        const double var_x52 = var_x51 + 0.49124000000000001 * var_x50;
        const double var_x53 = var_x49 * var_x52;
        const double var_x54 = var_x28 * NV_Ith_S(mParameters, 5) / (var_x53 + 1.02 * var_x46);
        const double var_x55 = var_x46 * var_x54;
        const double var_x56 = -26.614641953637257 * var_x7 + var_chaste_interface__membrane__V;
        const double var_x57 = var_x56 * var_x8;
        const double var_x58 = var_x13 * var_x57 / pow(var_x14, 2);
        const double var_x59 = 2.3926214736989759e-7 * var_x58;
        const double var_x60 = 1 / (0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki);
        const double var_x61 = -26.614641953637257 * log(var_x60 * (0.018329999999999999 * NV_Ith_S(mParameters, 2) + NV_Ith_S(mParameters, 1))) + var_chaste_interface__membrane__V;
        const double var_x62 = var_x25 * var_x26 * var_x28 * var_x61 / pow(var_x27, 2);
        const double var_x63 = 1 / var_chaste_interface__ionic_concentrations__Nai;
        const double var_x64 = pow(var_x63, 1.5);
        const double var_x65 = exp(-0.0037573302761014088 * var_chaste_interface__membrane__V);
        const double var_x66 = exp(0.01485884101040119 * NV_Ith_S(mParameters, 2));
        const double var_x67 = exp(-var_x5);
        const double var_x68 = 1.0 + 0.1245 * var_x65 + 0.036499999999999998 * var_x67 * (-0.14285714285714285 + 0.14285714285714285 * var_x66);
        const double var_x69 = NV_Ith_S(mParameters, 1) / (1.5 + NV_Ith_S(mParameters, 1));
        const double var_x70 = var_x69 * (0.00046778761937462537 * var_x65 + 0.037573302761014088 * var_x67 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x66)) / (pow(var_x68, 2) * (1.0 + 31.622776601683793 * var_x64));
        const double var_x71 = var_x34 * var_x41 * (var_x39 - var_x37) / pow(var_x40, 2);
        const double var_x72 = exp(var_x5);
        const double var_x73 = -1.0 + var_x72;
        const double var_x74 = 1 / var_x73;
        const double var_x75 = pow(var_chaste_interface__ionic_concentrations__Cai, 2);
        const double var_x76 = 1 / (1.0 + 2777777.7777777785 * var_x75);
        const double var_x77 = var_x76 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x78 = var_x77 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x79 = var_x74 * var_x78;
        const double var_x80 = 0.75 * var_x72;
        const double var_x81 = var_x4 + var_x80 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x82 = 7.0228579563684903e-6 * var_x81;
        const double var_x83 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
        const double var_x84 = -1.0 + var_x83;
        const double var_x85 = 1 / var_x84;
        const double var_x86 = var_x83 * var_chaste_interface__ionic_concentrations__Cai;
        const double var_x87 = var_x86 - 0.34000000000000002 * NV_Ith_S(mParameters, 0);
        const double var_x88 = var_x85 * var_x87;
        const double var_x89 = 0.078597788527232842 * var_x88;
        const double var_x90 = var_x16 * var_x57;
        const double var_x91 = 1.7944661052742319e-7 * var_x90;
        const double var_x92 = var_x18 + var_x80 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x93 = 2.4561808914760263e-5 * var_x92;
        const double var_x94 = var_x44 / pow(var_x45, 2);
        const double var_x95 = var_x23 * var_x54;
        const double var_x96 = var_x94 * var_x95;
        const double var_x97 = var_x47 * var_x52 / pow(var_x48, 2);
        const double var_x98 = 0.24326999999999999 * var_x94 - 0.51429999999999998 * var_x97 - var_x49 * (0.061749999999999999 * var_x51 + 0.039456396800000001 * var_x50);
        const double var_x99 = var_x23 * var_x28 * var_x46 * NV_Ith_S(mParameters, 5) / pow((var_x46 + 0.98039215686274506 * var_x53), 2);
        const double var_x100 = 0.42189361069797565 * var_x99;
        const double var_x101 = var_x78 * var_chaste_interface__membrane__V;
        const double var_x102 = var_x101 * var_x72 / pow(var_x73, 2);
        const double var_x103 = var_x102 * var_x92;
        const double var_x104 = var_x102 * var_x81;
        const double var_x105 = var_x101 * var_x83;
        const double var_x106 = var_x105 * var_x87 / pow(var_x84, 2);
        const double var_x107 = var_x72 * var_x79 * var_chaste_interface__membrane__V;
        const double var_x108 = var_x107 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x109 = var_x107 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x110 = var_x101 * var_x85 * var_x86;
        const double var_x111 = 0.00050000000000000001 + var_chaste_interface__ionic_concentrations__Cai;
        const double var_x112 = 1 / var_x111;
        const double var_x113 = 1 / var_chaste_interface__ionic_concentrations__Cai;
        const double var_x114 = var_chaste_interface__ionic_concentrations__Cai / pow(var_x111, 2);
        const double var_x115 = var_x36 * var_x42;
        const double var_x116 = var_x15 * var_x56 / (pow(var_x12, 2) * pow(var_chaste_interface__ionic_concentrations__Cai, 4));
        const double var_x117 = 3.301107118143778e-14 * var_x116;
        const double var_x118 = var_x105 * var_x85;
        const double var_x119 = var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__membrane__V;
        const double var_x120 = var_x119 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_chaste_interface__ionic_concentrations__Cai / pow((3.5999999999999994e-7 + var_x75), 2);
        const double var_x121 = var_x120 * var_x74;
        const double var_x122 = var_x121 * var_x81;
        const double var_x123 = var_x120 * var_x88;
        const double var_x124 = var_x121 * var_x92;
        const double var_x125 = -26.614641953637257 * log(var_x63 * NV_Ith_S(mParameters, 2)) + var_chaste_interface__membrane__V;
        const double var_x126 = var_x0 * var_x125;
        const double var_x127 = NV_Ith_S(mParameters, 4) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x128 = var_x127 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 2) * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x129 = var_x127 * var_x31;
        const double var_x130 = var_x77 * var_chaste_interface__membrane__V;
        const double var_x131 = var_x130 * var_x74;
        const double var_x132 = var_x119 * var_x76;
        const double var_x133 = var_x132 * var_x74;
        const double var_x134 = var_x29 * var_x61 * var_chaste_interface__time_dependent_potassium_current_X_gate__X;
        const double var_x135 = var_x9 + var_x19 * var_x6;
        const double var_x136 = var_x17 * var_x56;
        const double var_x137 = var_x30 * var_x60;
        const double var_x138 = var_x33 * var_x63;
        const double var_x139 = var_x38 * var_x42 * pow(var_chaste_interface__ionic_concentrations__Nai, 2);
        const double var_x140 = var_x16 * var_x6;
        const double var_x141 = var_x140 * var_x57;
        const double var_x142 = 4.7759072889811619e-6 * var_x141;
        const double var_x143 = var_x63 * var_x64 * var_x69 / (var_x68 * pow((0.031622776601683791 + var_x64), 2));
        const double var_x144 = 0.00016947874999999999 * var_x140;
        const double var_x145 = var_x58 * var_x6;
        const double var_x146 = 6.3678763853082156e-6 * var_x145;
        const double var_x147 = var_x11 * var_x146 + var_x146 * var_x20 - var_x11 * var_x144 - var_x144 * var_x20;
        const double var_x148 = var_x21 * var_x3;
        const double var_x149 = var_x9 + var_x10 * var_x6;
        const double var_x150 = var_x21 * var_x55;
        const double var_x151 = var_x21 * var_x94;
        const double var_x152 = 6.4745439480613349 * var_x151 - var_x49 * (1.0501178736126389 * var_x21 * var_x50 + 1.6434541406371006 * var_x21 * var_x51) - 13.687910356755641 * var_x21 * var_x97;
        const double var_x153 = var_x151 * var_x95;
        const double var_x154 = 0.00011935049112322121 * var_x88;
        const double var_x155 = 0.00092000000000000003 + var_chaste_interface__ionic_concentrations__Cai;
        const double var_x156 = 1 / var_x155;
        const double var_x157 = var_chaste_interface__ionic_concentrations__Cai / pow(var_x155, 2);
        const double var_x158 = 1.0 - var_chaste_interface__fast_sodium_current_m_gate__m;
        const double var_x159 = -0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x160 = exp(-4.7130000000000001 + var_x159);
        const double var_x161 = 1.0 - var_x160;
        const double var_x162 = 0.32000000000000001 / var_x161;
        const double var_x163 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x164 = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_x165 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x166 = var_chaste_interface__membrane__V < -40.0;
        const double var_x167 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
        const double var_x168 = exp(0.34999999999999998 * var_chaste_interface__membrane__V);
        const double var_x169 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
        const double var_x170 = 1.0 + var_x169;
        const double var_x171 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
        const double var_x172 = 1.0 + var_x171;
        const double var_x173 = 1 / var_x172;
        const double var_x174 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
        const double var_x175 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
        const double var_x176 = -127140.0 * var_x174 - 3.4740000000000003e-5 * var_x175;
        const double var_x177 = var_x173 * var_x176;
        const double var_x178 = 37.780000000000001 + var_chaste_interface__membrane__V;
        const double var_x179 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
        const double var_x180 = 1.0 + var_x179;
        const double var_x181 = exp(-0.01052 * var_chaste_interface__membrane__V);
        const double var_x182 = var_x181 / var_x180;
        const double var_x183 = exp(-3.2000000000000002 + var_x159);
        const double var_x184 = 1.0 + var_x183;
        const double var_x185 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V);
        const double var_x186 = var_x185 / var_x184;
        const double var_x187 = 1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x188 = exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V);
        const double var_x189 = 1.0 - var_x188;
        const double var_x190 = 1 / var_x189;
        const double var_x191 = 0.035000000000000003 * var_x190;
        const double var_x192 = 1.0 + var_x188;
        const double var_x193 = 1 / var_x192;
        const double var_x194 = 1.0 - 1.0 * var_x193;
        const double var_x195 = var_x192 * var_x194;
        const double var_x196 = var_x195 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x197 = 10.0 + var_chaste_interface__membrane__V;
        const double var_x198 = 0.005608974358974359 * var_x188 * var_x197;
        const double var_x199 = var_x198 / pow(var_x189, 2);
        const double var_x200 = var_x190 * var_x198 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x201 = var_x191 * var_x197;
        const double var_x202 = 1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x203 = 0.019699999999999999 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_x204 = exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V);
        const double var_x205 = 1.0 + var_x204;
        const double var_x206 = 0.029999999999999999 * var_x204 / pow(var_x205, 2);
        const double var_x207 = exp(4.0767441860465121 + 0.11627906976744186 * var_chaste_interface__membrane__V);
        const double var_x208 = 1.0 + var_x207;
        const double var_x209 = 0.11627906976744186 * var_x207 / pow(var_x208, 2);
        const double var_x210 = -0.02 - var_x203;
        const double var_x211 = 1 / var_x208;
        const double var_x212 = 0.59999999999999998 / var_x205;
        const double var_x213 = var_x211 + var_x212;
        const double var_x214 = var_x203 * (-0.022713800000000003 - 0.0022713799999999999 * var_chaste_interface__membrane__V);
        const double var_x215 = 1.0 - var_x211 - var_x212;
        const double var_x216 = 1.0 - var_chaste_interface__time_dependent_potassium_current_X_gate__X;
        const double var_x217 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V);
        const double var_x218 = 1.0 - var_x217;
        const double var_x219 = 7.1899999999999999e-5 / var_x218;
        const double var_x220 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V);
        const double var_x221 = -1.0 + var_x220;
        const double var_x222 = 0.00013100000000000001 / var_x221;
        const double var_x223 = 30.0 + var_chaste_interface__membrane__V;
        const double var_x224 = 1.9339199950521953e-8 * var_x16;
        const double var_x225 = 7.2663761489674998e-10 * var_x58;
        const double var_x226 = 5.4497821117256254e-10 * var_x90;
        const double var_x227 = 7.4594056952013249e-8 * var_x92;
        const double var_x228 = 1.0025441254350579e-16 * var_x116;
        const double var_x229 = 0.0030369936192764057 * var_x125;
        const double var_x230 = var_x224 * var_x56;
        const double var_x231 = 5.1470588235294113e-7 * var_x140;
        const double var_x232 = 1.9339199950521953e-8 * var_x145;
        const double var_x233 = var_x20 * var_x232 - var_x20 * var_x231;
        const double var_x234 = 1.4504399962891466e-8 * var_x141;
        const double var_x235 = 2.1328374802575643e-8 * var_x81;
        const double var_x236 = 0.0012812882037032361 * var_x99;
        const double var_x237 = var_x11 * var_x232 - var_x11 * var_x231;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-4.426e-5 - var_x33 + 9.2286828271246209e-7 * var_x103 + 0.10468673984798647 * var_x96 + 2.6387196824222991e-7 * var_x104 + 3.7804821863291499e-5 * var_x62 + 0.0059063570093597579 * var_x106 - 20.0 * var_x43 - 0.000183 * var_x3 - 0.014999999999999999 * var_x70 - 6.9215121203434662e-7 * var_x108 - 0.048845293589318314 * var_x71 - 1.9790397618167244e-7 * var_x109 - 3.0602006688963209e-5 * var_x24 - 0.0012135347818116574 * var_x30 - 0.0059063570093597579 * var_x110 - 0.4389381125701739 * var_x55 + var_x11 * var_x59 + var_x20 * var_x59 - var_x100 * var_x98 - var_x11 * var_x17 - var_x17 * var_x20 - var_x78 * var_x89 - var_x79 * var_x82 - var_x79 * var_x93 - var_x91 * var_chaste_interface__ionic_concentrations__Ki - var_x91 * var_chaste_interface__ionic_concentrations__Nai));
        IJth(rJacobian, 1, 0) = -4.5797863778688198e-8 + 0.030369936192764058 * var_x43 + 7.4171422481221223e-5 * var_x71 + 8.9687842752970284e-6 * var_x106 - 8.9687842752970284e-6 * var_x110 - var_x154 * var_x78;
        IJth(rJacobian, 2, 0) = var_x158 * var_x162 + 0.0072727272727272727 * var_x163 * var_chaste_interface__fast_sodium_current_m_gate__m - 0.032000000000000001 * var_x158 * var_x160 * var_x164 / pow(var_x161, 2);
        IJth(rJacobian, 3, 0) = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * ((var_x166) ? (-0.019852941176470591 * var_x165) : (0)) - ((var_x166) ? (0.28123999999999999 * var_x167 + 108500.0 * var_x168) : (0.693000693000693 * var_x169 / pow(var_x170, 2))) * var_chaste_interface__fast_sodium_current_h_gate__h;
        IJth(rJacobian, 4, 0) = (1.0 - var_chaste_interface__fast_sodium_current_j_gate__j) * ((var_x166) ? (var_x177 + var_x173 * var_x178 * (1.5254334000000001e-6 * var_x175 - 31073.016 * var_x174) - 0.311 * var_x171 * var_x176 * var_x178 / pow(var_x172, 2)) : (0)) - ((var_x166) ? (-0.001275024 * var_x182 + 0.016701360000000002 * var_x179 * var_x181 / pow(var_x180, 2)) : (-7.6049999999999996e-8 * var_x186 + 0.029999999999999999 * var_x183 * var_x185 / pow(var_x184, 2))) * var_chaste_interface__fast_sodium_current_j_gate__j;
        IJth(rJacobian, 5, 0) = var_x187 * var_x191 + var_x193 * var_x200 + var_x194 * var_x200 + var_x196 * var_x199 - var_x187 * var_x199 - var_x191 * var_x196;
        IJth(rJacobian, 6, 0) = var_x202 * var_x213 * var_x214 + var_x202 * (0.02 + var_x203) * (var_x206 - var_x209) + var_x210 * (var_x209 - var_x206) * var_chaste_interface__L_type_Ca_channel_f_gate__f - var_x214 * var_x215 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        IJth(rJacobian, 7, 0) = var_x216 * var_x219 - var_x222 * var_chaste_interface__time_dependent_potassium_current_X_gate__X + 8.9997000000000013e-6 * var_x220 * var_x223 * var_chaste_interface__time_dependent_potassium_current_X_gate__X / pow(var_x221, 2) - 1.0641199999999999e-5 * var_x216 * var_x217 * var_x223 / pow(var_x218, 2);
        IJth(rJacobian, 8, 0) = -4.2821610031797325e-8 + 2.8027450860303217e-9 * var_x103 - 2.1020588145227411e-9 * var_x108 - 0.00013666471286743825 * var_x70 - 0.18221961715658433 * var_x43 - 0.0030369936192764057 * var_x33 - 0.00044502853488732734 * var_x71 + var_x20 * var_x225 - var_x20 * var_x224 - var_x226 * var_chaste_interface__ionic_concentrations__Nai - var_x227 * var_x79;
        IJth(rJacobian, 9, 0) = 9.110980857829217e-5 * var_x70 + 1.1481300277669745e-7 * var_x62 + 0.00031793296094118393 * var_x96 + 8.0137748385755867e-10 * var_x104 - 5.5576983232758224e-7 * var_x3 - 9.2938099051435146e-8 * var_x24 - 0.0013330522471328469 * var_x55 - 3.6854973891319883e-6 * var_x30 - 6.0103311289316898e-10 * var_x109 + var_x11 * var_x225 - var_x11 * var_x224 - var_x226 * var_chaste_interface__ionic_concentrations__Ki - var_x235 * var_x79 - var_x236 * var_x98;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (20.0 * var_x115 + 0.0115 * var_x114 + 5.0564577285853121e-12 * var_x122 + 5.659040773960763e-8 * var_x123 + 1.7684502418627385e-11 * var_x124 - 0.0115 * var_x112 - 0.078597788527232842 * var_x118 - 0.00040134880066084979 * var_x113 - var_x11 * var_x117 - var_x117 * var_x20));
        IJth(rJacobian, 1, 1) = 8.5932353608719255e-11 * var_x123 + 1.7462713310839333e-5 * var_x114 + 0.00040588235294117644 * var_x157 - 0.030369936192764058 * var_x115 - 0.00011935049112322121 * var_x118 - 6.0944687335561951e-7 * var_x113 - 1.7462713310839333e-5 * var_x112 - 0.00040588235294117644 * var_x156;
        IJth(rJacobian, 8, 1) = 0.18221961715658433 * var_x115 + 5.3707721005449532e-14 * var_x124 - var_x20 * var_x228;
        IJth(rJacobian, 9, 1) = 1.5356429857854459e-14 * var_x122 - var_x11 * var_x228;
        IJth(rJacobian, 11, 1) = 0.0050000000000000001 * var_x156 - 0.0050000000000000001 * var_x157;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-3 * var_x126 * var_x128);
        IJth(rJacobian, 2, 2) = -0.080000000000000002 * var_x163 - var_x162 * var_x164;
        IJth(rJacobian, 8, 2) = -0.0091109808578292168 * var_x125 * var_x128;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x126 * var_x32);
        IJth(rJacobian, 3, 3) = -((var_x166) ? (0.13500000000000001 * var_x165) : (0)) - ((var_x166) ? (310000.0 * var_x168 + 3.5600000000000001 * var_x167) : (7.6923076923076916 / var_x170));
        IJth(rJacobian, 8, 3) = -var_x229 * var_x32;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x126 * var_x129);
        IJth(rJacobian, 4, 4) = -((var_x166) ? (0.1212 * var_x182) : (0.29999999999999999 * var_x186)) - ((var_x166) ? (var_x177 * var_x178) : (0));
        IJth(rJacobian, 8, 4) = -var_x129 * var_x229;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x130 * var_x89 - var_x131 * var_x82 - var_x131 * var_x93));
        IJth(rJacobian, 1, 5) = -var_x130 * var_x154;
        IJth(rJacobian, 5, 5) = -var_x201 - var_x195 * var_x201;
        IJth(rJacobian, 8, 5) = -var_x131 * var_x227;
        IJth(rJacobian, 9, 5) = -var_x131 * var_x235;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x132 * var_x89 - var_x133 * var_x82 - var_x133 * var_x93));
        IJth(rJacobian, 1, 6) = -var_x132 * var_x154;
        IJth(rJacobian, 6, 6) = var_x210 * var_x213 + var_x210 * var_x215;
        IJth(rJacobian, 8, 6) = -var_x133 * var_x227;
        IJth(rJacobian, 9, 6) = -var_x133 * var_x235;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0024270695636233147 * var_x0 * var_x134);
        IJth(rJacobian, 7, 7) = -var_x219 * var_x223 - var_x222 * var_x223;
        IJth(rJacobian, 9, 7) = -7.3709947782639767e-6 * var_x134;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (var_x147 - 60.0 * var_x139 - 1.8421356686070195e-5 * var_x107 - 0.000592018558817993 * var_x137 - 0.00071151247353788531 * var_x143 - 0.0003752664515462853 * var_x63 - 26.614641953637257 * var_x138 - var_x135 * var_x136 - var_x142 * var_chaste_interface__ionic_concentrations__Ki));
        IJth(rJacobian, 1, 8) = 0.091109808578292165 * var_x139;
        IJth(rJacobian, 8, 8) = var_x233 - 5.594554271400994e-8 * var_x107 - 0.54665885146975302 * var_x139 - 1.139681818874567e-6 * var_x63 - 0.080828497792522477 * var_x138 - 6.4825765265103909e-6 * var_x143 - var_x135 * var_x230;
        IJth(rJacobian, 9, 8) = var_x237 + 4.3217176843402606e-6 * var_x143 - 1.7979565856234583e-6 * var_x137 - var_x234 * var_chaste_interface__ionic_concentrations__Ki;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (var_x147 + 2.78620009834773 * var_x153 - 11.682180705860503 * var_x150 - 0.032297793716202568 * var_x137 - 0.0048704794775156178 * var_x148 - 5.2671434672763675e-6 * var_x107 - var_x100 * var_x152 - var_x136 * var_x149 - var_x142 * var_chaste_interface__ionic_concentrations__Nai));
        IJth(rJacobian, 8, 9) = var_x233 - var_x234 * var_chaste_interface__ionic_concentrations__Nai;
        IJth(rJacobian, 9, 9) = var_x237 + 0.0084616719207093495 * var_x153 - 1.5996281101931733e-8 * var_x107 - 0.035478708262932285 * var_x150 - 9.808819343281279e-5 * var_x137 - 1.4791615096031613e-5 * var_x148 - var_x149 * var_x230 - var_x152 * var_x236;
        IJth(rJacobian, 10, 10) = -0.063888888888888898;
        IJth(rJacobian, 11, 10) = 0.0055555555555555558;
        IJth(rJacobian, 1, 11) = 2.7058823529411762e-5;
        IJth(rJacobian, 10, 11) = 0.063888888888888898;
        IJth(rJacobian, 11, 11) = -0.0058888888888888888;
    }

    N_Vector Cellluo_rudy_1994FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -84.624
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 8);
        // Units: mM; Initial value: 10.0
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 9);
        // Units: mM; Initial value: 145.0
        
        // Mathematics
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__I_st_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 2) / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 4) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_fast_sodium_current__i_Na_converted = 100.00000000000001 * var_fast_sodium_current__i_Na; // uA_per_cm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(NV_Ith_S(mParameters, 1) / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(NV_Ith_S(mParameters, 1)) * NV_Ith_S(mParameters, 5); // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double var_time_independent_potassium_current__i_K1_converted = 100.00000000000001 * var_time_independent_potassium_current__i_K1; // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(4);
        NV_Ith_S(dqs, 0) = var_fast_sodium_current__i_Na_converted;
        NV_Ith_S(dqs, 1) = var_time_independent_potassium_current__i_K1_converted;
        NV_Ith_S(dqs, 2) = var_membrane__I_st_converted;
        NV_Ith_S(dqs, 3) = var_chaste_interface__environment__time;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellluo_rudy_1994FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "luo_rudy_1994";
    this->mFreeVariableName = "time";
    this->mFreeVariableUnits = "ms";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-84.624);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("time_dependent_potassium_current_X_gate__X");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(10.0);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("cytosolic_potassium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(145.0);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("JSR_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.8);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("NSR_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.8);

    // mParameters[0]:
    this->mParameterNames.push_back("extracellular_calcium_concentration");
    this->mParameterUnits.push_back("mM");

    // mParameters[1]:
    this->mParameterNames.push_back("extracellular_potassium_concentration");
    this->mParameterUnits.push_back("mM");

    // mParameters[2]:
    this->mParameterNames.push_back("extracellular_sodium_concentration");
    this->mParameterUnits.push_back("mM");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("uF_per_mm2");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("mS_per_mm2");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_inward_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("mS_per_mm2");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_inward_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("time");
    this->mDerivedQuantityUnits.push_back("ms");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellluo_rudy_1994FromCellMLCvode)

#endif // CHASTE_CVODE
