#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: kurata_model_2002
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "kurata_model_2002.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Cellkurata_model_2002FromCellMLCvode::Cellkurata_model_2002FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellkurata_model_2002FromCellMLCvode>::Instance();
        Init();
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 32.0; // (var_membrane__Cm) [picoF]
    }

    Cellkurata_model_2002FromCellMLCvode::~Cellkurata_model_2002FromCellMLCvode()
    {
    }
    
    double Cellkurata_model_2002FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 139.984146485614
        
        const double var_AP_sensitive_currents__g_sus = 0.02; // nanoS
        const double var_AP_sensitive_currents__g_to = 0.17999999999999999; // nanoS
        const double var_L_type_calcium_channel_current__E_CaL = 45.0; // millivolt
        const double var_L_type_calcium_channel_current__g_CaL = 0.57999999999999996; // nanoS
        const double var_T_type_calcium_channel_current__E_CaT = 45.0; // millivolt
        const double var_T_type_calcium_channel_current__g_CaT = 0.45800000000000002; // nanoS
        const double var_hyperpolarisation_activated_current__g_h_K = 0.23126250000000001; // nanoS
        const double var_hyperpolarisation_activated_current__g_h_Na = 0.14373749999999999; // nanoS
        const double var_intracellular_ion_concentrations__Cao = 2.0; // millimolar
        const double var_intracellular_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_muscarinic_potassium_channel_current__g_K_ACh = 0.0011000000000000001 * pow(var_intracellular_ion_concentrations__Ko, 0.40999999999999998); // picoA
        const double var_intracellular_ion_concentrations__Nao = 140.0; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__F = 96485000000000000.0; // femtocoulomb_per_millimole
        const double var_membrane__R = 8314400000000000.0; // attojoule_per_millimole_kelvin
        const double var_membrane__T = 310.14999999999998; // kelvin
        const double var_L_type_calcium_channel_current__i_CaL = (-var_L_type_calcium_channel_current__E_CaL + var_chaste_interface__membrane__V) * var_L_type_calcium_channel_current__g_CaL * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = (-var_T_type_calcium_channel_current__E_CaT + var_chaste_interface__membrane__V) * var_T_type_calcium_channel_current__g_CaT * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = (-var_intracellular_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + var_chaste_interface__intracellular_ion_concentrations__Ki) * var_background_muscarinic_potassium_channel_current__g_K_ACh; // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__g_Kr = 0.025000000000000001 * pow(var_intracellular_ion_concentrations__Ko, 0.58999999999999997); // nanoS
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_intracellular_ion_concentrations__Ko / var_chaste_interface__intracellular_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_AP_sensitive_currents__i_sus = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_AP_sensitive_currents__g_sus * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_AP_sensitive_currents__g_to * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_h_K; // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_rapidly_activating_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_intracellular_ion_concentrations__Nao / var_chaste_interface__intracellular_ion_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_h_Na; // picoA
        const double var_hyperpolarisation_activated_current__i_h = var_hyperpolarisation_activated_current__i_h_K + var_hyperpolarisation_activated_current__i_h_Na; // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_intracellular_ion_concentrations__Ko + 0.12 * var_intracellular_ion_concentrations__Nao) / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) / var_membrane__F; // millivolt
        const double var_slowly_activating_delayed_rectifier_potassium_current__g_Ks = 0.025899999999999999; // nanoS
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-var_slowly_activating_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slowly_activating_delayed_rectifier_potassium_current__g_Ks; // picoA
        const double var_sodium_calcium_exchange_current__K1ni = 395.30000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K1no = 1628.0; // millimolar
        const double var_sodium_calcium_exchange_current__K2ni = 2.2890000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K2no = 561.39999999999998; // millimolar
        const double var_sodium_calcium_exchange_current__K3ni = 26.440000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K3no = 4.6630000000000003; // millimolar
        const double var_sodium_calcium_exchange_current__Kci = 0.0207; // millimolar
        const double var_sodium_calcium_exchange_current__Kcni = 26.440000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__Kco = 3.6629999999999998; // millimolar
        const double var_sodium_calcium_exchange_current__Qci = 0.13689999999999999; // dimensionless
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__Qn = 0.43149999999999999; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + (1.0 + (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K3ni) * var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K2ni) * var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K1ni + (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__Kcni + exp(-var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qci / (var_membrane__R * var_membrane__T))) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub / var_sodium_calcium_exchange_current__Kci; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 1.0 + (1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco / (var_membrane__R * var_membrane__T))) * var_intracellular_ion_concentrations__Cao / var_sodium_calcium_exchange_current__Kco + (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K2no) * (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K3no) * var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K1no; // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qci / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__Kci * var_sodium_calcium_exchange_current__di); // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K3ni) * exp(0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__K1ni * var_sodium_calcium_exchange_current__K2ni * var_sodium_calcium_exchange_current__di); // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = var_intracellular_ion_concentrations__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__Kco * var_sodium_calcium_exchange_current__do); // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = pow(var_intracellular_ion_concentrations__Nao, 2) * (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K3no) * exp(-0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__K1no * var_sodium_calcium_exchange_current__K2no * var_sodium_calcium_exchange_current__do); // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)); // dimensionless
        const double var_sodium_calcium_exchange_current__k34 = var_intracellular_ion_concentrations__Nao / (var_intracellular_ion_concentrations__Nao + var_sodium_calcium_exchange_current__K3no); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (var_chaste_interface__intracellular_ion_concentrations__Nai + var_sodium_calcium_exchange_current__K3ni); // dimensionless
        const double var_sodium_calcium_exchange_current__kNaCa = 125.0; // picoA
        const double var_sodium_calcium_exchange_current__x1 = (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k34 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32; // dimensionless
        const double var_sodium_calcium_exchange_current__x2 = (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41; // dimensionless
        const double var_sodium_calcium_exchange_current__x3 = (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23; // dimensionless
        const double var_sodium_calcium_exchange_current__x4 = (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 * var_sodium_calcium_exchange_current__k34 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21; // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = (var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__x2 - var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__x1) * var_sodium_calcium_exchange_current__kNaCa / (var_sodium_calcium_exchange_current__x1 + var_sodium_calcium_exchange_current__x2 + var_sodium_calcium_exchange_current__x3 + var_sodium_calcium_exchange_current__x4); // picoA
        const double var_sodium_dependent_background_current__g_b_Na = 0.0054000000000000003; // nanoS
        const double var_sodium_dependent_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_dependent_background_current__g_b_Na; // picoA
        const double var_sodium_potassium_pump_current__Km_Kp = 1.3999999999999999; // millimolar
        const double var_sodium_potassium_pump_current__Km_Nap = 14.0; // millimolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 3.6000000000000001; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Kp / var_intracellular_ion_concentrations__Ko), 1.2)) * (1.0 + pow((var_sodium_potassium_pump_current__Km_Nap / var_chaste_interface__intracellular_ion_concentrations__Nai), 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__E_st = 37.399999999999999; // millivolt
        const double var_sustained_inward_current__g_st = 0.014999999999999999; // nanoS
        const double var_sustained_inward_current__i_st = (-var_sustained_inward_current__E_st + var_chaste_interface__membrane__V) * var_sustained_inward_current__g_st * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * (var_AP_sensitive_currents__i_sus + var_AP_sensitive_currents__i_to + var_L_type_calcium_channel_current__i_CaL + var_T_type_calcium_channel_current__i_CaT + var_background_muscarinic_potassium_channel_current__i_K_ACh + var_hyperpolarisation_activated_current__i_h + var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr + var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_dependent_background_current__i_b_Na + var_sodium_potassium_pump_current__i_NaK + var_sustained_inward_current__i_st) * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellkurata_model_2002FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Cai = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 1.462338380106
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 139.984146485614
        double var_chaste_interface__calcium_buffering__fTMM = NV_Ith_S(rY, 21);
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fCMi = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 0.116947220413
        double var_chaste_interface__calcium_buffering__fCMs = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 0.074631965653
        double var_chaste_interface__calcium_buffering__fTC = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.059206293446
        double var_chaste_interface__calcium_buffering__fTMC = NV_Ith_S(rY, 25);
        // Units: millimolar; Initial value: 0.602955114871
        double var_chaste_interface__calcium_buffering__fCQ = NV_Ith_S(rY, 26);
        // Units: millimolar; Initial value: 0.260317260703

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_AP_sensitive_currents__g_sus = 0.02; // nanoS
        const double var_AP_sensitive_currents__g_to = 0.17999999999999999; // nanoS
        const double var_L_type_calcium_channel_current__E_CaL = 45.0; // millivolt
        const double var_L_type_calcium_channel_current__g_CaL = 0.57999999999999996; // nanoS
        const double var_L_type_calcium_channel_current_fCa_gate__Km_fCa = 0.00035; // millimolar
        const double var_L_type_calcium_channel_current_fCa_gate__beta_fCa = 60.0; // per_millimolar_millisecond
        const double var_L_type_calcium_channel_current_fCa_gate__alpha_fCa = var_L_type_calcium_channel_current_fCa_gate__Km_fCa * var_L_type_calcium_channel_current_fCa_gate__beta_fCa; // per_millisecond
        const double var_T_type_calcium_channel_current__E_CaT = 45.0; // millivolt
        const double var_T_type_calcium_channel_current__g_CaT = 0.45800000000000002; // nanoS
        const double var_calcium_buffering__CM_tot = 0.044999999999999998; // dimensionless
        const double var_calcium_buffering__CQ_tot = 10.0; // dimensionless
        const double var_calcium_buffering__TC_tot = 0.031; // dimensionless
        const double var_calcium_buffering__TMC_tot = 0.062; // dimensionless
        const double var_calcium_buffering__kb_CM = 0.54200000000000004; // per_millisecond
        const double var_calcium_buffering__kb_CQ = 0.44500000000000001; // per_millisecond
        const double var_calcium_buffering__kb_TC = 0.44600000000000001; // per_millisecond
        const double var_calcium_buffering__kb_TMC = 0.0075100000000000002; // per_millisecond
        const double var_calcium_buffering__kb_TMM = 0.751; // per_millisecond
        const double var_calcium_buffering__kf_CM = 227.69999999999999; // per_millimolar_millisecond
        const double var_calcium_buffering__kf_CQ = 0.53400000000000003; // per_millimolar_millisecond
        const double var_calcium_buffering__kf_TC = 88.799999999999997; // per_millimolar_millisecond
        const double var_calcium_buffering__kf_TMC = 227.69999999999999; // per_millimolar_millisecond
        const double var_calcium_buffering__kf_TMM = 2.2770000000000001; // per_millimolar_millisecond
        const double var_hyperpolarisation_activated_current__g_h_K = 0.23126250000000001; // nanoS
        const double var_hyperpolarisation_activated_current__g_h_Na = 0.14373749999999999; // nanoS
        const double var_intracellular_calcium_dynamics__K_rel = 0.0011999999999999999; // millimolar
        const double var_intracellular_calcium_dynamics__K_up = 0.00059999999999999995; // millimolar
        const double var_intracellular_calcium_dynamics__P_rel = 0.5; // per_millisecond
        const double var_intracellular_calcium_dynamics__P_up = 0.0050000000000000001; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__tau_dif_Ca = 0.040000000000000001; // millisecond
        const double var_intracellular_calcium_dynamics__tau_tr = 60.0; // millisecond
        const double var_calcium_buffering__delta_fCQ = -var_chaste_interface__calcium_buffering__fCQ * var_calcium_buffering__kb_CQ + (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_calcium_buffering__kf_CQ * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCQ = var_calcium_buffering__delta_fCQ; // millimolar / millisecond
        const double var_L_type_calcium_channel_current_fCa_gate__fCa_infinity = var_L_type_calcium_channel_current_fCa_gate__Km_fCa / (var_L_type_calcium_channel_current_fCa_gate__Km_fCa + var_chaste_interface__intracellular_ion_concentrations__Ca_sub); // dimensionless
        const double var_L_type_calcium_channel_current_fCa_gate__tau_fCa = var_L_type_calcium_channel_current_fCa_gate__fCa_infinity / var_L_type_calcium_channel_current_fCa_gate__alpha_fCa; // millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa = (-var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa + var_L_type_calcium_channel_current_fCa_gate__fCa_infinity) / var_L_type_calcium_channel_current_fCa_gate__tau_fCa; // 1 / millisecond
        const double var_calcium_buffering__delta_fCMs = -var_chaste_interface__calcium_buffering__fCMs * var_calcium_buffering__kb_CM + (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_calcium_buffering__kf_CM * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMs = var_calcium_buffering__delta_fCMs; // millimolar / millisecond
        const double var_intracellular_calcium_dynamics__j_rel = (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) * var_intracellular_calcium_dynamics__P_rel / (1.0 + pow(var_intracellular_calcium_dynamics__K_rel, 2) / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)); // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_rel + var_chaste_interface__intracellular_ion_concentrations__Ca_up) / var_intracellular_calcium_dynamics__tau_tr; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel = -var_intracellular_calcium_dynamics__j_rel - var_calcium_buffering__CQ_tot * var_calcium_buffering__delta_fCQ + var_intracellular_calcium_dynamics__j_tr; // millimolar / millisecond
        const double var_calcium_buffering__delta_fCMi = -var_chaste_interface__calcium_buffering__fCMi * var_calcium_buffering__kb_CM + (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_calcium_buffering__kf_CM * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMi = var_calcium_buffering__delta_fCMi; // millimolar / millisecond
        const double var_calcium_buffering__delta_fTC = -var_chaste_interface__calcium_buffering__fTC * var_calcium_buffering__kb_TC + (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_calcium_buffering__kf_TC * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTC = var_calcium_buffering__delta_fTC; // millimolar / millisecond
        const double var_calcium_buffering__delta_fTMC = -var_chaste_interface__calcium_buffering__fTMC * var_calcium_buffering__kb_TMC + (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_calcium_buffering__kf_TMC * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMC = var_calcium_buffering__delta_fTMC; // millimolar / millisecond
        const double var_intracellular_calcium_dynamics__j_Ca_dif = (-var_chaste_interface__intracellular_ion_concentrations__Cai + var_chaste_interface__intracellular_ion_concentrations__Ca_sub) / var_intracellular_calcium_dynamics__tau_dif_Ca; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_up = var_intracellular_calcium_dynamics__P_up / (1.0 + var_intracellular_calcium_dynamics__K_up / var_chaste_interface__intracellular_ion_concentrations__Cai); // millimolar_per_millisecond
        const double var_intracellular_ion_concentrations__Cao = 2.0; // millimolar
        const double var_intracellular_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_muscarinic_potassium_channel_current__g_K_ACh = 0.0011000000000000001 * pow(var_intracellular_ion_concentrations__Ko, 0.40999999999999998); // picoA
        const double var_intracellular_ion_concentrations__Mgi = 2.5; // millimolar
        const double var_calcium_buffering__delta_fTMM = -var_chaste_interface__calcium_buffering__fTMM * var_calcium_buffering__kb_TMM + (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_calcium_buffering__kf_TMM * var_intracellular_ion_concentrations__Mgi; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMM = var_calcium_buffering__delta_fTMM; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Nao = 140.0; // millimolar
        const double var_intracellular_ion_concentrations__V_i = 1.5835000000000001e-12; // liter
        const double var_intracellular_ion_concentrations__V_rel = 4.2223e-15; // liter
        const double var_intracellular_ion_concentrations__V_sub = 3.5097999999999997e-14; // liter
        const double var_intracellular_ion_concentrations__V_up = 4.0815999999999997e-14; // liter
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up = -var_intracellular_calcium_dynamics__j_tr * var_intracellular_ion_concentrations__V_rel / var_intracellular_ion_concentrations__V_up + var_intracellular_calcium_dynamics__j_up; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = (var_intracellular_calcium_dynamics__j_Ca_dif * var_intracellular_ion_concentrations__V_sub - var_intracellular_calcium_dynamics__j_up * var_intracellular_ion_concentrations__V_up) / var_intracellular_ion_concentrations__V_i - var_calcium_buffering__CM_tot * var_calcium_buffering__delta_fCMi - var_calcium_buffering__TC_tot * var_calcium_buffering__delta_fTC - var_calcium_buffering__TMC_tot * var_calcium_buffering__delta_fTMC; // millimolar / millisecond
        const double var_membrane__F = 96485000000000000.0; // femtocoulomb_per_millimole
        const double var_membrane__R = 8314400000000000.0; // attojoule_per_millimole_kelvin
        const double var_membrane__T = 310.14999999999998; // kelvin
        const double var_AP_sensitive_currents_q_gate__q_infinity = 1 / (1.0 + exp(3.7692307692307692 + 0.076923076923076927 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_AP_sensitive_currents_q_gate__tau_q = 6.0599999999999996 + 39.101999999999997 / (0.065000000000000002 * exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.56999999999999995 * exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V)); // millisecond
        const double var_AP_sensitive_currents_r_gate__r_infinity = 1 / (1.0 + exp(1.2866666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_AP_sensitive_currents_r_gate__tau_r = 2.75352 + 14.40516 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q = (-var_chaste_interface__AP_sensitive_currents_q_gate__q + var_AP_sensitive_currents_q_gate__q_infinity) / var_AP_sensitive_currents_q_gate__tau_q; // 1 / millisecond
        const double d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r = (-var_chaste_interface__AP_sensitive_currents_r_gate__r + var_AP_sensitive_currents_r_gate__r_infinity) / var_AP_sensitive_currents_r_gate__tau_r; // 1 / millisecond
        const double var_L_type_calcium_channel_current__i_CaL = (-var_L_type_calcium_channel_current__E_CaL + var_chaste_interface__membrane__V) * var_L_type_calcium_channel_current__g_CaL * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_L_type_calcium_channel_current_d_gate__alpha_d = -0.028389999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.084900000000000003 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20798668885191349 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_channel_current_d_gate__beta_d = 0.011429999999999999 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_channel_current_d_gate__d_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_calcium_channel_current_d_gate__tau_d = 1 / (var_L_type_calcium_channel_current_d_gate__alpha_d + var_L_type_calcium_channel_current_d_gate__beta_d); // millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__L_type_calcium_channel_current_d_gate__d + var_L_type_calcium_channel_current_d_gate__d_infinity) / var_L_type_calcium_channel_current_d_gate__tau_d; // 1 / millisecond
        const double var_L_type_calcium_channel_current_f_gate__f_infinity = 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_calcium_channel_current_f_gate__tau_f = 44.299999999999997 + 257.10000000000002 * exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__L_type_calcium_channel_current_f_gate__f + var_L_type_calcium_channel_current_f_gate__f_infinity) / var_L_type_calcium_channel_current_f_gate__tau_f; // 1 / millisecond
        const double var_T_type_calcium_channel_current__i_CaT = (-var_T_type_calcium_channel_current__E_CaT + var_chaste_interface__membrane__V) * var_T_type_calcium_channel_current__g_CaT * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current_d_gate__d_infinity = 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_calcium_channel_current_d_gate__tau_d = 1 / (1.0680000000000001 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1.0680000000000001 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__T_type_calcium_channel_current_d_gate__d + var_T_type_calcium_channel_current_d_gate__d_infinity) / var_T_type_calcium_channel_current_d_gate__tau_d; // 1 / millisecond
        const double var_T_type_calcium_channel_current_f_gate__f_infinity = 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_calcium_channel_current_f_gate__tau_f = 1 / (0.014999999999999999 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 0.015299999999999999 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__T_type_calcium_channel_current_f_gate__f + var_T_type_calcium_channel_current_f_gate__f_infinity) / var_T_type_calcium_channel_current_f_gate__tau_f; // 1 / millisecond
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = (-var_intracellular_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + var_chaste_interface__intracellular_ion_concentrations__Ki) * var_background_muscarinic_potassium_channel_current__g_K_ACh; // picoA
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 0.71665290000000004 / (exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V) + exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V)); // millisecond
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(4.7407407407407405 + 0.07407407407407407 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + var_hyperpolarisation_activated_current_y_gate__y_infinity) / var_hyperpolarisation_activated_current_y_gate__tau_y; // 1 / millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current__g_Kr = 0.025000000000000001 * pow(var_intracellular_ion_concentrations__Ko, 0.58999999999999997); // nanoS
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity = 1 / (1.0 + exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paF = 0.84655354000000005 / (0.037199999999999997 * exp(0.062893081761006289 * var_chaste_interface__membrane__V) + 0.00096000000000000002 * exp(-0.044444444444444446 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) / var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paF; // 1 / millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paS = 0.84655354000000005 / (0.0041999999999999997 * exp(0.058823529411764705 * var_chaste_interface__membrane__V) + 0.00014999999999999999 * exp(-0.046296296296296294 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) / var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paS; // 1 / millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__pi_infinity = 1 / (1.0 + exp(1.672514619883041 + 0.058479532163742687 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__tau_pi = 1 / (0.10000000000000001 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 0.65600000000000003 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy + var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__pi_infinity) / var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__tau_pi; // 1 / millisecond
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_intracellular_ion_concentrations__Ko / var_chaste_interface__intracellular_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_AP_sensitive_currents__i_sus = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_AP_sensitive_currents__g_sus * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_AP_sensitive_currents__g_to * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_h_K; // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_rapidly_activating_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_intracellular_ion_concentrations__Nao / var_chaste_interface__intracellular_ion_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_h_Na; // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_intracellular_ion_concentrations__Ko + 0.12 * var_intracellular_ion_concentrations__Nao) / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) / var_membrane__F; // millivolt
        const double var_slowly_activating_delayed_rectifier_potassium_current__g_Ks = 0.025899999999999999; // nanoS
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n = 0.014 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n = 0.001 * exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-var_slowly_activating_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slowly_activating_delayed_rectifier_potassium_current__g_Ks; // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n_infinity = var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n / (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n); // dimensionless
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__tau_n = 1 / (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n); // millisecond
        const double d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n = (-var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n_infinity) / var_slowly_activating_delayed_rectifier_potassium_current_n_gate__tau_n; // 1 / millisecond
        const double var_sodium_calcium_exchange_current__K1ni = 395.30000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K1no = 1628.0; // millimolar
        const double var_sodium_calcium_exchange_current__K2ni = 2.2890000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K2no = 561.39999999999998; // millimolar
        const double var_sodium_calcium_exchange_current__K3ni = 26.440000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__K3no = 4.6630000000000003; // millimolar
        const double var_sodium_calcium_exchange_current__Kci = 0.0207; // millimolar
        const double var_sodium_calcium_exchange_current__Kcni = 26.440000000000001; // millimolar
        const double var_sodium_calcium_exchange_current__Kco = 3.6629999999999998; // millimolar
        const double var_sodium_calcium_exchange_current__Qci = 0.13689999999999999; // dimensionless
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__Qn = 0.43149999999999999; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + (1.0 + (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K3ni) * var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K2ni) * var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K1ni + (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__Kcni + exp(-var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qci / (var_membrane__R * var_membrane__T))) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub / var_sodium_calcium_exchange_current__Kci; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 1.0 + (1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco / (var_membrane__R * var_membrane__T))) * var_intracellular_ion_concentrations__Cao / var_sodium_calcium_exchange_current__Kco + (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K2no) * (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K3no) * var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K1no; // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qci / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__Kci * var_sodium_calcium_exchange_current__di); // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + var_chaste_interface__intracellular_ion_concentrations__Nai / var_sodium_calcium_exchange_current__K3ni) * exp(0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__K1ni * var_sodium_calcium_exchange_current__K2ni * var_sodium_calcium_exchange_current__di); // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = var_intracellular_ion_concentrations__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__Kco * var_sodium_calcium_exchange_current__do); // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = pow(var_intracellular_ion_concentrations__Nao, 2) * (1.0 + var_intracellular_ion_concentrations__Nao / var_sodium_calcium_exchange_current__K3no) * exp(-0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)) / (var_sodium_calcium_exchange_current__K1no * var_sodium_calcium_exchange_current__K2no * var_sodium_calcium_exchange_current__do); // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)); // dimensionless
        const double var_sodium_calcium_exchange_current__k34 = var_intracellular_ion_concentrations__Nao / (var_intracellular_ion_concentrations__Nao + var_sodium_calcium_exchange_current__K3no); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.5 * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qn / (var_membrane__R * var_membrane__T)); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (var_chaste_interface__intracellular_ion_concentrations__Nai + var_sodium_calcium_exchange_current__K3ni); // dimensionless
        const double var_sodium_calcium_exchange_current__kNaCa = 125.0; // picoA
        const double var_sodium_calcium_exchange_current__x1 = (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k34 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32; // dimensionless
        const double var_sodium_calcium_exchange_current__x2 = (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41; // dimensionless
        const double var_sodium_calcium_exchange_current__x3 = (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23; // dimensionless
        const double var_sodium_calcium_exchange_current__x4 = (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 * var_sodium_calcium_exchange_current__k34 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21; // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = (var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__x2 - var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__x1) * var_sodium_calcium_exchange_current__kNaCa / (var_sodium_calcium_exchange_current__x1 + var_sodium_calcium_exchange_current__x2 + var_sodium_calcium_exchange_current__x3 + var_sodium_calcium_exchange_current__x4); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub = -var_intracellular_calcium_dynamics__j_Ca_dif + (var_intracellular_calcium_dynamics__j_rel * var_intracellular_ion_concentrations__V_rel + 0.5 * (-var_L_type_calcium_channel_current__i_CaL - var_T_type_calcium_channel_current__i_CaT + 2.0 * var_sodium_calcium_exchange_current__i_NaCa) * NV_Ith_S(mParameters, 0) / var_membrane__F) / var_intracellular_ion_concentrations__V_sub - var_calcium_buffering__CM_tot * var_calcium_buffering__delta_fCMs; // millimolar / millisecond
        const double var_sodium_dependent_background_current__g_b_Na = 0.0054000000000000003; // nanoS
        const double var_sodium_dependent_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_dependent_background_current__g_b_Na; // picoA
        const double var_sodium_potassium_pump_current__Km_Kp = 1.3999999999999999; // millimolar
        const double var_sodium_potassium_pump_current__Km_Nap = 14.0; // millimolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 3.6000000000000001; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Kp / var_intracellular_ion_concentrations__Ko), 1.2)) * (1.0 + pow((var_sodium_potassium_pump_current__Km_Nap / var_chaste_interface__intracellular_ion_concentrations__Nai), 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = (-var_AP_sensitive_currents__i_sus - var_AP_sensitive_currents__i_to - var_background_muscarinic_potassium_channel_current__i_K_ACh - var_hyperpolarisation_activated_current__i_h_K - var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + 2.0 * var_sodium_potassium_pump_current__i_NaK) * NV_Ith_S(mParameters, 0) / ((var_intracellular_ion_concentrations__V_i + var_intracellular_ion_concentrations__V_sub) * var_membrane__F); // millimolar / millisecond
        const double var_sustained_inward_current__E_st = 37.399999999999999; // millivolt
        const double var_sustained_inward_current__g_st = 0.014999999999999999; // nanoS
        const double var_sustained_inward_current_qa_gate__alpha_qa = 1 / (0.20000000000000001 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current_qa_gate__beta_qa = 1 / (16.0 * exp(0.125 * var_chaste_interface__membrane__V) + 15.0 * exp(0.02 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current_qa_gate__qa_infinity = 1 / (1.0 + exp(-11.4 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_inward_current_qa_gate__tau_qa = 1 / (var_sustained_inward_current_qa_gate__alpha_qa + var_sustained_inward_current_qa_gate__beta_qa); // millisecond
        const double d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa = (-var_chaste_interface__sustained_inward_current_qa_gate__qa + var_sustained_inward_current_qa_gate__qa_infinity) / var_sustained_inward_current_qa_gate__tau_qa; // 1 / millisecond
        const double var_sustained_inward_current_qi_gate__alpha_qi = 1 / (700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current_qi_gate__beta_qi = 1 / (50.0 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 95.0 * exp(-0.10000000000000001 * var_chaste_interface__membrane__V)) + 0.00022900000000000001 / (1.0 + exp(-0.20000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current__i_st = (-var_sustained_inward_current__E_st + var_chaste_interface__membrane__V) * var_sustained_inward_current__g_st * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = (-var_hyperpolarisation_activated_current__i_h_Na - var_sodium_dependent_background_current__i_b_Na - var_sustained_inward_current__i_st - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * NV_Ith_S(mParameters, 0) / ((var_intracellular_ion_concentrations__V_i + var_intracellular_ion_concentrations__V_sub) * var_membrane__F); // millimolar / millisecond
        const double var_sustained_inward_current_qi_gate__qi_infinity = var_sustained_inward_current_qi_gate__alpha_qi / (var_sustained_inward_current_qi_gate__alpha_qi + var_sustained_inward_current_qi_gate__beta_qi); // dimensionless
        const double var_sustained_inward_current_qi_gate__tau_qi = 6.6500000000000004 / (var_sustained_inward_current_qi_gate__alpha_qi + var_sustained_inward_current_qi_gate__beta_qi); // millisecond
        const double d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi = (-var_chaste_interface__sustained_inward_current_qi_gate__qi + var_sustained_inward_current_qi_gate__qi_infinity) / var_sustained_inward_current_qi_gate__tau_qi; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_hyperpolarisation_activated_current__i_h = var_hyperpolarisation_activated_current__i_h_K + var_hyperpolarisation_activated_current__i_h_Na; // picoA
            d_dt_chaste_interface_var_membrane__V = -1.0 * var_AP_sensitive_currents__i_sus - 1.0 * var_AP_sensitive_currents__i_to - 1.0 * var_L_type_calcium_channel_current__i_CaL - 1.0 * var_T_type_calcium_channel_current__i_CaT - 1.0 * var_background_muscarinic_potassium_channel_current__i_K_ACh - 1.0 * var_hyperpolarisation_activated_current__i_h - 1.0 * var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - 1.0 * var_slowly_activating_delayed_rectifier_potassium_current__i_Ks - 1.0 * var_sodium_calcium_exchange_current__i_NaCa - 1.0 * var_sodium_dependent_background_current__i_b_Na - 1.0 * var_sodium_potassium_pump_current__i_NaK - 1.0 * var_sustained_inward_current__i_st; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_calcium_buffering__fTMM;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_calcium_buffering__fCMi;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_calcium_buffering__fCMs;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_calcium_buffering__fTC;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_calcium_buffering__fTMC;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_calcium_buffering__fCQ;
    }

    void Cellkurata_model_2002FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Cai = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 139.984146485614
        double var_chaste_interface__calcium_buffering__fTMM = NV_Ith_S(rY, 21);
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fCMi = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 0.116947220413
        double var_chaste_interface__calcium_buffering__fCMs = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 0.074631965653
        double var_chaste_interface__calcium_buffering__fTC = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.059206293446
        double var_chaste_interface__calcium_buffering__fTMC = NV_Ith_S(rY, 25);
        // Units: millimolar; Initial value: 0.602955114871
        double var_chaste_interface__calcium_buffering__fCQ = NV_Ith_S(rY, 26);
        // Units: millimolar; Initial value: 0.260317260703
        
        const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
        const double var_x1 = pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2);
        const double var_x2 = exp(-0.037415977988011655 * var_chaste_interface__membrane__V);
        const double var_x3 = -0.040569866382531065 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF - 0.027046577588354045 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
        const double var_x4 = var_x3 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
        const double var_x5 = exp(-0.0051222473865587953 * var_chaste_interface__membrane__V);
        const double var_x6 = 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x7 = 1.0 + var_x6;
        const double var_x8 = (var_x5 + var_x7) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        const double var_x9 = var_x7 * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x10 = (1.0 + 0.43687199650502401 * var_x9) * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x11 = pow((0.0207 + var_x8 + 5.2365292183152033e-5 * var_x10), (-2));
        const double var_x12 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2);
        const double var_x13 = var_x11 * var_x12 * pow(var_x5, 2);
        const double var_x14 = 0.0051222473865587953 * var_x13;
        const double var_x15 = 1 / (1.0 + 48.309178743961354 * var_x8 + 0.0025297242600556538 * var_x10);
        const double var_x16 = var_x5 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        const double var_x17 = var_x15 * var_x16;
        const double var_x18 = 0.24745156456805775 * var_x17;
        const double var_x19 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2);
        const double var_x20 = 0.0080724972509135153 * var_chaste_interface__membrane__V;
        const double var_x21 = exp(var_x20);
        const double var_x22 = var_x15 * var_x21;
        const double var_x23 = var_x19 * var_x22;
        const double var_x24 = var_x23 * var_x7;
        const double var_x25 = var_x19 * var_x7;
        const double var_x26 = var_x21 * var_x25;
        const double var_x27 = 1.1718129359175982e-7 * var_x11 * var_x16;
        const double var_x28 = var_x14 - var_x18 + 8.9214469789726909e-6 * var_x24 + var_x26 * var_x27;
        const double var_x29 = 1 / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai);
        const double var_x30 = var_x29 * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x31 = var_x21 * var_x30;
        const double var_x32 = var_x28 * var_x31;
        const double var_x33 = 48.309178743961354 * var_x5;
        const double var_x34 = var_x15 * var_x33;
        const double var_x35 = var_x34 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        const double var_x36 = var_x35 + 0.0011051656880977081 * var_x24;
        const double var_x37 = var_x21 * var_x36;
        const double var_x38 = var_x30 * var_x37;
        const double var_x39 = 0.0080724972509135153 * var_x38;
        const double var_x40 = exp(-var_x20);
        const double var_x41 = 0.96776646412697098 + var_x21;
        const double var_x42 = var_x40 * var_x41;
        const double var_x43 = var_x14 * var_x42;
        const double var_x44 = 0.38997571260451763 * var_x17 * var_x21 * var_x40;
        const double var_x45 = var_x17 * var_x42;
        const double var_x46 = 0.63742727717257541 * var_x45;
        const double var_x47 = exp(0);
        const double var_x48 = 0.54600054600054604 * var_x47;
        const double var_x49 = 1 / (4.8791826399715319 + var_x48);
        const double var_x50 = var_x48 * var_x49;
        const double var_x51 = var_x40 * var_x49;
        const double var_x52 = 0.66530580717983756 * var_x51;
        const double var_x53 = var_x50 + var_x52;
        const double var_x54 = var_x40 * var_x53;
        const double var_x55 = var_x30 + var_x40;
        const double var_x56 = var_x21 * var_x55;
        const double var_x57 = 0.96776646412697098 * var_x54 + var_x50 * var_x56;
        const double var_x58 = var_x49 * pow(var_x40, 2);
        const double var_x59 = 0.0051975633156138403 * var_x58;
        const double var_x60 = 0.64386064857757164 * var_x51;
        const double var_x61 = var_x47 * var_x49;
        const double var_x62 = 0.0080724972509135153 * var_x40 * (var_x60 + 0.52840101781434401 * var_x61);
        const double var_x63 = var_x56 * var_x61;
        const double var_x64 = 0.0044075879065866861 * var_x63;
        const double var_x65 = 0.0044075879065866861 * var_x21 * var_x47 * var_x51;
        const double var_x66 = var_x18 * var_x57 + var_x50 * (var_x32 + var_x39 + var_x43 + var_x44 - var_x46) - var_x14 * var_x57 - var_x35 * (var_x64 - var_x59 - var_x62 - var_x65);
        const double var_x67 = var_x29 * var_x53;
        const double var_x68 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3);
        const double var_x69 = var_x22 * var_x68;
        const double var_x70 = var_x67 * var_x69;
        const double var_x71 = var_x7 * var_x70;
        const double var_x72 = var_x51 * var_x55;
        const double var_x73 = 32.140377158446256 * var_x72;
        const double var_x74 = var_x41 * var_x61;
        const double var_x75 = var_x24 * var_x74;
        const double var_x76 = var_x38 + var_x35 * var_x42;
        const double var_x77 = 1 / (var_x57 + var_x76 + 0.0011051656880977081 * var_x71 + 0.00060342106912241779 * var_x75 + var_x17 * var_x73 + var_x36 * var_x60);
        const double var_x78 = 125.0 * var_x77;
        const double var_x79 = var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi;
        const double var_x80 = var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r;
        const double var_x81 = var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f;
        const double var_x82 = var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_f_gate__f;
        const double var_x83 = var_x82 * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa;
        const double var_x84 = var_x36 * var_x51;
        const double var_x85 = 4.871114921634011e-6 * var_x61;
        const double var_x86 = var_x69 * var_x7;
        const double var_x87 = var_x21 * var_x67 * var_x68 * var_x7;
        const double var_x88 = var_x26 * var_x74;
        const double var_x89 = var_x46 + var_x59 + var_x62 + var_x65 - var_x32 - var_x39 - var_x43 - var_x44 - var_x64 + 0.0051975633156138403 * var_x84 - 8.9214469789726909e-6 * var_x71 - var_x27 * var_x87 - var_x28 * var_x60 + 0.42408406915774627 * var_x17 * var_x72 + 0.25945310625488094 * var_x17 * var_x58 - 0.0034078609320893128 * var_x13 * var_x72 - var_x24 * var_x41 * var_x85 + 5.9354904835575489e-6 * var_x29 * var_x51 * var_x86 - 6.398105028215114e-8 * var_x11 * var_x16 * var_x88 - var_x15 * var_x25 * var_x85 * pow(var_x21, 2);
        const double var_x90 = (var_x50 * var_x76 - var_x35 * var_x57) / pow((var_x45 + 0.0207 * var_x38 + 0.020032765807428299 * var_x54 + 2.2876929743622558e-5 * var_x71 + 0.011302211302211302 * var_x63 + 1.2490816130834047e-5 * var_x75 + 0.013327915425555734 * var_x84 + var_x17 * var_x52 * var_x55), 2);
        const double var_x91 = 0.053561249999999998 * var_x90;
        const double var_x92 = 1 / var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x93 = pow(var_x92, 1.3);
        const double var_x94 = log(140.0 * var_x92);
        const double var_x95 = 0.033333333333333333 * var_chaste_interface__membrane__V;
        const double var_x96 = -var_x95;
        const double var_x97 = exp(-4.0 + var_x96 + 0.89088499421326284 * var_x94);
        const double var_x98 = 1.0 + var_x97;
        const double var_x99 = var_x97 / (pow(var_x98, 2) * (1.0 + 30.900566853219949 * var_x93));
        const double var_x100 = 26.099999999999998 - 0.57999999999999996 * var_chaste_interface__membrane__V;
        const double var_x101 = var_x100 * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa;
        const double var_x102 = var_x101 * var_chaste_interface__L_type_calcium_channel_current_f_gate__f;
        const double var_x103 = var_x101 * var_chaste_interface__L_type_calcium_channel_current_d_gate__d;
        const double var_x104 = var_x100 * var_x82;
        const double var_x105 = 20.609999999999999 - 0.45800000000000002 * var_chaste_interface__membrane__V;
        const double var_x106 = var_x105 * var_chaste_interface__T_type_calcium_channel_current_f_gate__f;
        const double var_x107 = var_x105 * var_chaste_interface__T_type_calcium_channel_current_d_gate__d;
        const double var_x108 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ki;
        const double var_x109 = log(5.4000000000000004 * var_x108);
        const double var_x110 = (0.72286170354868073 * var_x109 - 0.027046577588354045 * var_chaste_interface__membrane__V) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
        const double var_x111 = (1.0842925553230209 * var_x109 - 0.040569866382531065 * var_chaste_interface__membrane__V) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
        const double var_x112 = -26.726549826397882 * var_x109 + var_chaste_interface__membrane__V;
        const double var_x113 = var_x112 * var_x3;
        const double var_x114 = var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x115 = (-26.726549826397882 * log(22.199999999999999 / var_x114) + var_chaste_interface__membrane__V) * var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n;
        const double var_x116 = 4.8107789687516185 * var_x109 - 0.17999999999999999 * var_chaste_interface__membrane__V;
        const double var_x117 = var_x116 * var_chaste_interface__AP_sensitive_currents_r_gate__r;
        const double var_x118 = var_x116 * var_chaste_interface__AP_sensitive_currents_q_gate__q;
        const double var_x119 = (-26.726549826397882 * var_x94 + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y;
        const double var_x120 = var_x112 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y;
        const double var_x121 = 0.56099999999999994 - 0.014999999999999999 * var_chaste_interface__membrane__V;
        const double var_x122 = var_x121 * var_chaste_interface__sustained_inward_current_qi_gate__qi;
        const double var_x123 = var_x121 * var_chaste_interface__sustained_inward_current_qa_gate__qa;
        const double var_x124 = var_x11 * (-48.309178743961354 - var_x33 - 1.8271247633873431 * var_chaste_interface__intracellular_ion_concentrations__Nai);
        const double var_x125 = 0.0207 * var_x16;
        const double var_x126 = var_x124 * var_x125;
        const double var_x127 = 4.7355244569298691e-7 * var_x26;
        const double var_x128 = var_x126 + var_x34 + var_x124 * var_x127;
        const double var_x129 = var_x128 * var_x31;
        const double var_x130 = var_x34 * var_x42;
        const double var_x131 = var_x126 * var_x42;
        const double var_x132 = var_x50 * (var_x129 + var_x130 + var_x131) - var_x126 * var_x57 - var_x34 * var_x57;
        const double var_x133 = 0.013771830208622637 * var_x16 * var_x72;
        const double var_x134 = 4.7355244569298691e-7 * var_x87;
        const double var_x135 = 2.5855989390826479e-7 * var_x88;
        const double var_x136 = -var_x129 - var_x130 - var_x131 - var_x124 * var_x133 - var_x124 * var_x134 - var_x124 * var_x135 - var_x128 * var_x60 - var_x15 * var_x5 * var_x73;
        const double var_x137 = var_x29 * var_x37;
        const double var_x138 = var_x11 * (-0.0025297242600556538 - 0.0011051656880977081 * var_x9 - 1.8271247633873431 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub - (0.0011051656880977081 + 8.3598009689690465e-5 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai);
        const double var_x139 = var_x125 * var_x138;
        const double var_x140 = var_x22 * var_x9;
        const double var_x141 = var_x139 + 0.0022103313761954162 * var_x140 + 4.1799004844845232e-5 * var_x23 + var_x127 * var_x138;
        const double var_x142 = var_x141 * var_x31;
        const double var_x143 = pow((1 + var_x6), (-2));
        const double var_x144 = 0.0014304645462223146 * var_x143 * var_chaste_interface__intracellular_ion_concentrations__Nai;
        const double var_x145 = var_x144 * var_x37;
        const double var_x146 = var_x139 * var_x42;
        const double var_x147 = var_x29 - var_x144;
        const double var_x148 = var_x147 * var_x21;
        const double var_x149 = var_x50 * (var_x137 + var_x142 + var_x146 - var_x145) - var_x139 * var_x57 - 26.376837971040871 * var_x148 * var_x17 * var_x61;
        const double var_x150 = var_x0 * var_x92;
        const double var_x151 = var_x145 - var_x137 - var_x142 - var_x146 - 4.1799004844845232e-5 * var_x70 - var_x133 * var_x138 - var_x134 * var_x138 - var_x135 * var_x138 - var_x141 * var_x60 - var_x148 * var_x50 - 0.0033154970642931239 * var_x24 * var_x67 - 0.0012068421382448356 * var_x140 * var_x74 - 2.2822279467564968e-5 * var_x23 * var_x74 + 1.5809003345251601e-6 * var_x143 * var_x53 * var_x86 - 32.140377158446256 * var_x147 * var_x17 * var_x51;
        const double var_x152 = var_x1 * (0.0054054054054054048 * var_chaste_interface__intracellular_ion_concentrations__Nai + 0.045045045045045043 * var_chaste_interface__intracellular_ion_concentrations__Ki) / pow(var_x114, 2);
        const double var_x153 = var_x92 * var_x93 / (var_x98 * pow((0.032361865876120534 + var_x93), 2));
        const double var_x154 = var_x92 * var_x99;
        const double var_x155 = var_x0 * var_x108;
        const double var_x156 = var_x108 * var_chaste_interface__AP_sensitive_currents_r_gate__r;
        const double var_x157 = var_x108 * var_x4;
        const double var_x158 = var_x108 * var_x80;
        const double var_x159 = -0.16666666666666666 * var_chaste_interface__membrane__V;
        const double var_x160 = exp(-2.3500000000000001 + var_x159);
        const double var_x161 = 1.0 + var_x160;
        const double var_x162 = 0.40000000000000002 * var_chaste_interface__membrane__V;
        const double var_x163 = exp(-2.0 + var_x162);
        const double var_x164 = -1.0 + var_x163;
        const double var_x165 = 0.011429999999999999 / var_x164;
        const double var_x166 = exp(-14.0 - var_x162);
        const double var_x167 = -1.0 + var_x166;
        const double var_x168 = 0.028389999999999999 / var_x167;
        const double var_x169 = exp(-0.20798668885191349 * var_chaste_interface__membrane__V);
        const double var_x170 = -1.0 + var_x169;
        const double var_x171 = 0.084900000000000003 / var_x170;
        const double var_x172 = -5.0 + var_chaste_interface__membrane__V;
        const double var_x173 = 35.0 + var_chaste_interface__membrane__V;
        const double var_x174 = var_x165 * var_x172;
        const double var_x175 = var_x168 * var_x173;
        const double var_x176 = var_x171 * var_chaste_interface__membrane__V;
        const double var_x177 = 0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x178 = exp(6.0 + var_x177);
        const double var_x179 = 1.0 + var_x178;
        const double var_x180 = exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2));
        const double var_x181 = 1 / (44.299999999999997 + 257.10000000000002 * var_x180);
        const double var_x182 = 60.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        const double var_x183 = 0.00035 + var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        const double var_x184 = exp(-4.3833333333333337 + var_x159);
        const double var_x185 = 1.0 + var_x184;
        const double var_x186 = exp(0.87666666666666671 + var_x95);
        const double var_x187 = exp(-0.87666666666666671 + var_x96);
        const double var_x188 = 1.0680000000000001 * var_x186;
        const double var_x189 = 1.0680000000000001 * var_x187;
        const double var_x190 = exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V);
        const double var_x191 = 1.0 + var_x190;
        const double var_x192 = exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V);
        const double var_x193 = exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V);
        const double var_x194 = 0.014999999999999999 * var_x192;
        const double var_x195 = 0.015299999999999999 * var_x193;
        const double var_x196 = exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V);
        const double var_x197 = 1.0 + var_x196;
        const double var_x198 = 1 / var_x197;
        const double var_x199 = exp(0.058823529411764705 * var_chaste_interface__membrane__V);
        const double var_x200 = exp(-0.046296296296296294 * var_chaste_interface__membrane__V);
        const double var_x201 = 0.0049612928202981696 * var_x199;
        const double var_x202 = 0.0001771890292963632 * var_x200;
        const double var_x203 = 0.094339622641509441 * var_x196 / pow(var_x197, 2);
        const double var_x204 = exp(0.062893081761006289 * var_chaste_interface__membrane__V);
        const double var_x205 = exp(-0.044444444444444446 * var_chaste_interface__membrane__V);
        const double var_x206 = 0.043942879265498072 * var_x204;
        const double var_x207 = 0.0011340097874967246 * var_x205;
        const double var_x208 = exp(1.672514619883041 + 0.058479532163742687 * var_chaste_interface__membrane__V);
        const double var_x209 = 1.0 + var_x208;
        const double var_x210 = exp(0.009420009985210585 * var_chaste_interface__membrane__V);
        const double var_x211 = exp(-0.018299935950224173 * var_chaste_interface__membrane__V);
        const double var_x212 = 0.10000000000000001 * var_x211;
        const double var_x213 = 0.65600000000000003 * var_x210;
        const double var_x214 = exp(-0.022222222222222223 * var_chaste_interface__membrane__V);
        const double var_x215 = 0.001 * var_x214;
        const double var_x216 = exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V);
        const double var_x217 = 1.0 + var_x216;
        const double var_x218 = 1 / var_x217;
        const double var_x219 = 0.014 * var_x218;
        const double var_x220 = var_x215 + var_x219;
        const double var_x221 = 1 / var_x220;
        const double var_x222 = 2.2222222222222223e-5 * var_x214;
        const double var_x223 = 0.0015555555555555557 * var_x216 / pow(var_x217, 2);
        const double var_x224 = 0.076923076923076927 * var_chaste_interface__membrane__V;
        const double var_x225 = exp(3.7692307692307692 + var_x224);
        const double var_x226 = 1.0 + var_x225;
        const double var_x227 = exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x228 = exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V);
        const double var_x229 = 1 / (0.065000000000000002 * var_x227 + 0.56999999999999995 * var_x228);
        const double var_x230 = 1 / (6.0599999999999996 + 39.101999999999997 * var_x229);
        const double var_x231 = exp(1.2866666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V);
        const double var_x232 = 1.0 + var_x231;
        const double var_x233 = exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V);
        const double var_x234 = exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V);
        const double var_x235 = 1 / (1.0369999999999999 * var_x233 + 0.36899999999999999 * var_x234);
        const double var_x236 = 1 / (2.75352 + 14.40516 * var_x235);
        const double var_x237 = exp(4.7407407407407405 + 0.07407407407407407 * var_chaste_interface__membrane__V);
        const double var_x238 = 1.0 + var_x237;
        const double var_x239 = exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V);
        const double var_x240 = exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V);
        const double var_x241 = 1.3953756414018557 * var_x240;
        const double var_x242 = 1.3953756414018557 * var_x239;
        const double var_x243 = -var_x177;
        const double var_x244 = exp(-11.4 + var_x243);
        const double var_x245 = 1.0 + var_x244;
        const double var_x246 = exp(0.02 * var_chaste_interface__membrane__V);
        const double var_x247 = exp(0.125 * var_chaste_interface__membrane__V);
        const double var_x248 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x249 = exp(-0.0014285714285714286 * var_chaste_interface__membrane__V);
        const double var_x250 = 1 / (16.0 * var_x247 + 15.0 * var_x246);
        const double var_x251 = 1 / (0.20000000000000001 * var_x249 + 0.14999999999999999 * var_x248);
        const double var_x252 = exp(-0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x253 = 1 / (50.0 * var_x249 + 95.0 * var_x252);
        const double var_x254 = exp(0.014285714285714285 * var_chaste_interface__membrane__V);
        const double var_x255 = exp(var_x224);
        const double var_x256 = 1 / (700.0 * var_x254 + 3100.0 * var_x255);
        const double var_x257 = var_x256;
        const double var_x258 = exp(var_x243);
        const double var_x259 = 1.0 + var_x258;
        const double var_x260 = 1 / var_x259;
        const double var_x261 = var_x257 + var_x253 + 0.00022900000000000001 * var_x260;
        const double var_x262 = 1 / var_x261;
        const double var_x263 = var_x258 / pow(var_x259, 2);
        const double var_x264 = (9.5 * var_x252 + 0.071428571428571425 * var_x249) / pow((var_x252 + 0.52631578947368418 * var_x249), 2);
        const double var_x265 = (-10.0 * var_x254 - 238.46153846153845 * var_x255) / pow((var_x255 + 0.22580645161290322 * var_x254), 2);
        const double var_x266 = 1.0405827263267429e-7 * var_x265;
        const double var_x267 = 3.4436090225563911e-5 * var_x260;
        const double var_x268 = 0.15037593984962405 * var_x253;
        const double var_x269 = 0.15037593984962405 * var_x256;
        const double var_x270 = 1 / (pow((1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai), 2) * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 2));
        const double var_x271 = 14.1174 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        const double var_x272 = 1.0 + 1.4399999999999998e-6 / var_x12;
        const double var_x273 = 1 / var_x272;
        const double var_x274 = 0.5 * var_x273;
        const double var_x275 = (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (pow(var_x272, 2) * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 3));
        const double var_x276 = 0.036912022524200436 * var_x77;
        const double var_x277 = 1.5816432531394641e-5 * var_x90;
        const double var_x278 = 0.00014764809009680174 * NV_Ith_S(mParameters, 0);
        const double var_x279 = 0.060150151005755319 * var_x273;
        const double var_x280 = 0.0024012228482076215 * var_x77;
        const double var_x281 = 1.0288999782284837e-6 * var_x90;
        const double var_x282 = 6.4032609285536579e-6 * NV_Ith_S(mParameters, 0);
        const double var_x283 = -227.69999999999999 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0054000000000000003 + var_x4 - 0.375 * var_x0 - 0.014999999999999999 * var_x79 - 0.17999999999999999 * var_x80 - 0.025899999999999999 * var_x1 - 0.57999999999999996 * var_x83 - 0.02 * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.45800000000000002 * var_x81 - 0.10017396017979863 * var_x99 - 0.00044373633078820127 * var_x2 - var_x66 * var_x78 - var_x89 * var_x91);
        IJth(rJacobian, 1, 0) = (-var_chaste_interface__L_type_calcium_channel_current_d_gate__d + 1 / var_x161) * (var_x165 - var_x168 - var_x171 - 0.0045719999999999997 * var_x163 * var_x172 / pow(var_x164, 2) - 0.017658069883527455 * var_x169 * var_chaste_interface__membrane__V / pow(var_x170, 2) - 0.011356 * var_x166 * var_x173 / pow(var_x167, 2)) + 0.16666666666666666 * var_x160 * (var_x174 - var_x175 - var_x176) / pow(var_x161, 2);
        IJth(rJacobian, 2, 0) = -0.20000000000000001 * var_x178 * var_x181 / pow(var_x179, 2) - 0.0038895371450797353 * var_x180 * (-0.33642151027379535 - 0.010351431085347548 * var_chaste_interface__membrane__V) * (-var_chaste_interface__L_type_calcium_channel_current_f_gate__f + 1 / var_x179) / pow((0.17230649552703226 + var_x180), 2);
        IJth(rJacobian, 4, 0) = (-var_chaste_interface__T_type_calcium_channel_current_d_gate__d + 1 / var_x185) * (0.0356 * var_x186 - 0.0356 * var_x187) + 0.16666666666666666 * var_x184 * (var_x188 + var_x189) / pow(var_x185, 2);
        IJth(rJacobian, 5, 0) = (-var_chaste_interface__T_type_calcium_channel_current_f_gate__f + 1 / var_x191) * (0.00097529258777633281 * var_x192 - 0.00018367346938775509 * var_x193) - 0.17857142857142858 * var_x190 * (var_x194 + var_x195) / pow(var_x191, 2);
        IJth(rJacobian, 6, 0) = var_x203 * (var_x201 + var_x202) + (var_x198 - var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS) * (0.00029184075413518645 * var_x199 - 8.2031958007575546e-6 * var_x200);
        IJth(rJacobian, 7, 0) = var_x203 * (var_x206 + var_x207) + (var_x198 - var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * (0.0027637030984589985 * var_x204 - 5.0400434999854427e-5 * var_x205);
        IJth(rJacobian, 8, 0) = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy + 1 / var_x209) * (0.0061795265502981441 * var_x210 - 0.0018299935950224174 * var_x211) - 0.058479532163742687 * var_x208 * (var_x212 + var_x213) / pow(var_x209, 2);
        IJth(rJacobian, 9, 0) = var_x220 * (var_x221 * var_x223 + 71.428571428571431 * var_x218 * (var_x222 - var_x223) / pow((var_x218 + 0.071428571428571425 * var_x214), 2)) + (var_x223 - var_x222) * (-var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n + var_x219 * var_x221);
        IJth(rJacobian, 10, 0) = -0.076923076923076927 * var_x225 * var_x230 / pow(var_x226, 2) - 0.078713879440468384 * (-var_chaste_interface__AP_sensitive_currents_q_gate__q + 1 / var_x226) * (0.045599999999999995 * var_x228 - 0.0065000000000000006 * var_x227) / (pow((0.15497928494706154 + var_x229), 2) * pow((var_x228 + 0.11403508771929825 * var_x227), 2));
        IJth(rJacobian, 11, 0) = 0.066666666666666666 * var_x231 * var_x236 / pow(var_x232, 2) - 0.064554184748538135 * (-var_chaste_interface__AP_sensitive_currents_r_gate__r + 1 / var_x232) * (0.04428 * var_x234 - 0.093329999999999996 * var_x233) / (pow((0.19114817190506736 + var_x235), 2) * pow((var_x233 + 0.35583413693346194 * var_x234), 2));
        IJth(rJacobian, 12, 0) = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 1 / var_x238) * (0.0725586626489447 * var_x239 - 0.030801634395873377 * var_x240) - 0.07407407407407407 * var_x237 * (var_x241 + var_x242) / pow(var_x238, 2);
        IJth(rJacobian, 13, 0) = (-var_chaste_interface__sustained_inward_current_qa_gate__qa + 1 / var_x245) * (0.00390625 * (-2.0 * var_x247 - 0.29999999999999999 * var_x246) / pow((var_x247 + 0.9375 * var_x246), 2) + 24.999999999999996 * (0.013636363636363636 * var_x248 + 0.00028571428571428574 * var_x249) / pow((var_x249 + 0.74999999999999989 * var_x248), 2)) + 0.20000000000000001 * var_x244 * (var_x250 + var_x251) / pow(var_x245, 2);
        IJth(rJacobian, 14, 0) = (-var_chaste_interface__sustained_inward_current_qi_gate__qi + var_x257 * var_x262) * (6.8872180451127816e-6 * var_x263 + 1.6662153999958345e-5 * var_x264 + 1.5647860546266811e-8 * var_x265) + (var_x262 * var_x266 + var_x257 * (-var_x266 - 4.5800000000000002e-5 * var_x263 - 0.00011080332409972299 * var_x264) / pow(var_x261, 2)) * (var_x267 + var_x268 + var_x269);
        IJth(rJacobian, 18, 0) = (-6.7622825264335192e-5 * var_x81 - 8.5635892256145002e-5 * var_x83 + var_x276 * var_x66 + var_x277 * var_x89) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 19, 0) = (-3.4577609014189752e-8 - 1.9243200158333837e-6 * var_x99 - 9.6048913928304863e-8 * var_x79 - 9.2038871771798129e-7 * var_x0 - var_x280 * var_x66 - var_x281 * var_x89) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 20, 0) = (1.282880010555589e-6 * var_x99 + 6.4032609285536579e-6 * var_x4 - 2.8413595095158507e-9 * var_x2 - 1.2806521857107316e-7 * var_chaste_interface__AP_sensitive_currents_r_gate__r - 1.6584445804953973e-7 * var_x1 - 1.4808341304896403e-6 * var_x0 - 1.1525869671396584e-6 * var_x80) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (var_x102);
        IJth(rJacobian, 1, 1) = var_x175 + var_x176 - var_x174;
        IJth(rJacobian, 18, 1) = var_x102 * var_x278;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (var_x103);
        IJth(rJacobian, 2, 2) = -var_x181;
        IJth(rJacobian, 18, 2) = var_x103 * var_x278;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (var_x104);
        IJth(rJacobian, 3, 3) = -0.021000000000000001 - var_x182;
        IJth(rJacobian, 18, 3) = var_x104 * var_x278;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (var_x106);
        IJth(rJacobian, 4, 4) = -var_x188 - var_x189;
        IJth(rJacobian, 18, 4) = var_x106 * var_x278;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (var_x107);
        IJth(rJacobian, 5, 5) = -var_x194 - var_x195;
        IJth(rJacobian, 18, 5) = var_x107 * var_x278;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (var_x110);
        IJth(rJacobian, 6, 6) = -var_x201 - var_x202;
        IJth(rJacobian, 20, 6) = var_x110 * var_x282;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (var_x111);
        IJth(rJacobian, 7, 7) = -var_x206 - var_x207;
        IJth(rJacobian, 20, 7) = var_x111 * var_x282;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x113);
        IJth(rJacobian, 8, 8) = -var_x212 - var_x213;
        IJth(rJacobian, 20, 8) = var_x113 * var_x282;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-0.051799999999999999 * var_x115);
        IJth(rJacobian, 9, 9) = -var_x215 - var_x219;
        IJth(rJacobian, 20, 9) = -3.3168891609907947e-7 * var_x115 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (var_x117);
        IJth(rJacobian, 10, 10) = -var_x230;
        IJth(rJacobian, 20, 10) = var_x117 * var_x282;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (var_x118 + 0.53453099652795766 * var_x109 - 0.02 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 11, 11) = -var_x236;
        IJth(rJacobian, 20, 11) = (3.4227414451683221e-6 * var_x109 + 6.4032609285536579e-6 * var_x118 - 1.2806521857107316e-7 * var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (-0.28747499999999998 * var_x119 - 0.46252500000000002 * var_x120);
        IJth(rJacobian, 12, 12) = -var_x241 - var_x242;
        IJth(rJacobian, 19, 12) = -1.8407774354359626e-6 * var_x119 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 20, 12) = -2.9616682609792806e-6 * var_x120 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x122);
        IJth(rJacobian, 13, 13) = -var_x250 - var_x251;
        IJth(rJacobian, 19, 13) = var_x122 * var_x282;
        IJth(rJacobian, 0, 14) = mSetVoltageDerivativeToZero ? 0.0 : (var_x123);
        IJth(rJacobian, 14, 14) = -var_x267 - var_x268 - var_x269;
        IJth(rJacobian, 19, 14) = var_x123 * var_x282;
        IJth(rJacobian, 15, 15) = -27.670820618882221 + 10.246499999999999 * var_chaste_interface__calcium_buffering__fCMi + 2.7527999999999997 * var_chaste_interface__calcium_buffering__fTC + 14.1174 * var_chaste_interface__calcium_buffering__fTMC + 14.1174 * var_chaste_interface__calcium_buffering__fTMM - 7.7327439216924522e-8 * var_x270;
        IJth(rJacobian, 16, 15) = 2.9999999999999997e-6 * var_x270;
        IJth(rJacobian, 18, 15) = 25.0;
        IJth(rJacobian, 22, 15) = 227.69999999999999 - 227.69999999999999 * var_chaste_interface__calcium_buffering__fCMi;
        IJth(rJacobian, 24, 15) = 88.799999999999997 - 88.799999999999997 * var_chaste_interface__calcium_buffering__fTC;
        IJth(rJacobian, 25, 15) = 227.69999999999999 - 227.69999999999999 * var_chaste_interface__calcium_buffering__fTMC - 227.69999999999999 * var_chaste_interface__calcium_buffering__fTMM;
        IJth(rJacobian, 16, 16) = -0.0017241196262903437;
        IJth(rJacobian, 17, 16) = 0.016666666666666666;
        IJth(rJacobian, 16, 17) = 0.0017241196262903437;
        IJth(rJacobian, 17, 17) = -5.3566666666666674 - var_x274 + 5.3399999999999999 * var_chaste_interface__calcium_buffering__fCQ;
        IJth(rJacobian, 18, 17) = var_x279;
        IJth(rJacobian, 26, 17) = 0.53400000000000003 - 0.53400000000000003 * var_chaste_interface__calcium_buffering__fCQ;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x132 * var_x78 - var_x136 * var_x91);
        IJth(rJacobian, 3, 18) = 0.021000000000000001 / var_x183 - 60.0 * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa - 0.00035 * (0.021000000000000001 + var_x182) / pow(var_x183, 2);
        IJth(rJacobian, 15, 18) = 0.55412061888222286;
        IJth(rJacobian, 17, 18) = var_x274 - 1.4399999999999998e-6 * var_x275;
        IJth(rJacobian, 18, 18) = -35.246499999999997 - var_x279 + 10.246499999999999 * var_chaste_interface__calcium_buffering__fCMs + 1.7323243489657528e-7 * var_x275 + (var_x132 * var_x276 + var_x136 * var_x277) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 19, 18) = (-var_x132 * var_x280 - var_x136 * var_x281) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 23, 18) = 227.69999999999999 - 227.69999999999999 * var_chaste_interface__calcium_buffering__fCMs;
        IJth(rJacobian, 0, 19) = mSetVoltageDerivativeToZero ? 0.0 : (-1.8440677943018704 * var_x152 - 0.14432336906254858 * var_x92 - 0.12643083428112081 * var_x153 - 2.6773043380529855 * var_x154 - 3.8416074556718653 * var_x150 - var_x149 * var_x78 - var_x151 * var_x91);
        IJth(rJacobian, 18, 19) = (var_x149 * var_x276 + var_x151 * var_x277) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 19, 19) = (-2.4598814923744084e-5 * var_x150 - 2.4287088639502301e-6 * var_x153 - 5.1430434785105685e-5 * var_x154 - 9.2414019019544699e-7 * var_x92 - var_x149 * var_x280 - var_x151 * var_x281) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 20, 19) = (3.4286956523403795e-5 * var_x154 + 1.6191392426334868e-6 * var_x153 - 1.1808047256857289e-5 * var_x152) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 20) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0021962113249247841 + 26.726549826397882 * var_x157 - 15.367231619182254 * var_x152 - 6.1808487292273409 * var_x155 - 0.53453099652795766 * var_x156 - 4.8107789687516185 * var_x158);
        IJth(rJacobian, 20, 20) = (-1.406291416773793e-8 + 0.0001711370722584161 * var_x157 - 3.4227414451683221e-6 * var_x156 - 9.8400393807144087e-5 * var_x152 - 3.0804673006514896e-5 * var_x158 - 3.9577587173161957e-5 * var_x155) * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 15, 21) = var_x271;
        IJth(rJacobian, 21, 21) = -6.4435000000000002;
        IJth(rJacobian, 25, 21) = var_x283;
        IJth(rJacobian, 15, 22) = 0.024390000000000002 + 10.246499999999999 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        IJth(rJacobian, 22, 22) = -0.54200000000000004 + var_x283;
        IJth(rJacobian, 18, 23) = 0.024390000000000002 + 10.246499999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        IJth(rJacobian, 23, 23) = -0.54200000000000004 - 227.69999999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        IJth(rJacobian, 15, 24) = 0.013826 + 2.7527999999999997 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        IJth(rJacobian, 24, 24) = -0.44600000000000001 - 88.799999999999997 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        IJth(rJacobian, 15, 25) = 0.00046562000000000003 + var_x271;
        IJth(rJacobian, 21, 25) = -5.6925000000000008;
        IJth(rJacobian, 25, 25) = -0.0075100000000000002 + var_x283;
        IJth(rJacobian, 17, 26) = 4.4500000000000002 + 5.3399999999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel;
        IJth(rJacobian, 26, 26) = -0.44500000000000001 - 0.53400000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel;
    }

    N_Vector Cellkurata_model_2002FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 1) = var_membrane__Cm_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellkurata_model_2002FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "kurata_model_2002";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-58.600291137693);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("L_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000602055134);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("L_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.626999773853);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("L_type_calcium_channel_current_fCa_gate__fCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.589580408056);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("T_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004571884917);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("T_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.249637570396);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.629323128348);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3493633709533);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.852396631172);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("slowly_activating_delayed_rectifier_potassium_current_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.054409723782);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("AP_sensitive_currents_q_gate__q");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.531446952485);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("AP_sensitive_currents_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005550489445);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.067156687129);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("sustained_inward_current_qa_gate__qa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.426018100136);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("sustained_inward_current_qi_gate__qi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.333330378068);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Cai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000312494921);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.462338380106);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.296742023718);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_sub");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00019074741);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.438646305915);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.984146485614);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("calcium_buffering__fTMM");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.350600895635);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("calcium_buffering__fCMi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.116947220413);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("calcium_buffering__fCMs");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.074631965653);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("calcium_buffering__fTC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.059206293446);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("calcium_buffering__fTMC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.602955114871);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("calcium_buffering__fCQ");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.260317260703);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellkurata_model_2002FromCellMLCvode)
#endif // CHASTE_CVODE
