#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: hund_rudy_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "hund_rudy_2004_a.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellhund_rudy_2004_aFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellhund_rudy_2004_aFromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellhund_rudy_2004_aFromCellMLCvode::Cellhund_rudy_2004_aFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 1.0; // (var_ICaL__G_CaL_mult) [dimensionless]
        NV_Ith_S(this->mParameters, 1) = 1.0; // (var_INa__G_Na_mult) [dimensionless]
        NV_Ith_S(this->mParameters, 2) = 1.0; // (var_IKr__G_Kr_mult) [dimensionless]
    }

    Cellhund_rudy_2004_aFromCellMLCvode::~Cellhund_rudy_2004_aFromCellMLCvode()
    {
    }
    
    double Cellhund_rudy_2004_aFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 23);
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 24);
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 25);
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = NV_Ith_S(rY, 28);
        // Units: mM; Initial value: 0.00012271265
        
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__Cl_o = 100.0; // mM
        const double var_Environment__F = 96485.0; // C_per_mole
        const double var_Environment__FonRT = 0.0374358835078; // per_mV
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 140.0; // mM
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__gacai = 1.0; // dimensionless
        const double var_ICaL__gacao = 0.34100000000000003; // dimensionless
        const double var_ICaL__pca = 0.000243; // L_per_F_ms
        const double var_IClb__GClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKr__gkr = 0.0059618984305585326 * sqrt(var_Environment__K_o); // mS_per_uF
        const double var_IKs__gks = 0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INa__GNa = ((var_Environment__tissue == 0) ? (8.25) : (33.0)); // mS_per_uF
        const double var_INa__gNa = pow(var_chaste_interface__INa__m, 3) * var_INa__GNa * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mS_per_uF
        const double var_INaCa__KmCa = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__NCXmax = 4.5; // uA_per_uF
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__allo = 1 / (1.0 + pow(var_INaCa__KmCa, 2) / pow(var_INaCa__ca_i_NaCa, 2)); // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__ibarnak = 0.61875000000000002; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 10.0; // mM
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INal__GNaL = 0.0064999999999999997; // mS_per_uF
        const double var_IpCa__ibarpca = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__kmpca = 0.00050000000000000001; // mM
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__ibarpca / (var_chaste_interface__Ca__Ca_i + var_IpCa__kmpca); // uA_per_uF
        const double var_Ito__gitodv = 0.19; // mS_per_uF
        const double var_Ito2__PCl = 3.9999999999999998e-7; // L_per_F_ms
        const double var_INaCa__denom2 = pow(var_INaCa__KmNao, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_INaCa__ca_i_NaCa / var_INaCa__KmCai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__denom3 = pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o + pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_ICaL__ibarca = 4.0 * (-15.0 + var_chaste_interface__cell__V) * (-var_Environment__Ca_o * var_ICaL__gacao + var_chaste_interface__Ca__Ca_ss * var_ICaL__gacai * exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)) * var_Environment__F * var_Environment__FonRT * NV_Ith_S(mParameters, 0) * var_ICaL__pca / (-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICab__ICab = 7.9803360000000004e-7 * (-0.34100000000000003 * var_Environment__Ca_o + var_chaste_interface__Ca__Ca_i * exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)) * var_Environment__F * var_Environment__FonRT * var_chaste_interface__cell__V / (-1.0 + exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__denom1 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__num = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(var_Environment__FonRT * var_INaCa__eta * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__INaCa = var_INaCa__NCXmax * var_INaCa__allo * var_INaCa__num / ((var_INaCa__denom2 + var_INaCa__denom3) * var_INaCa__denom1); // uA_per_uF
        const double var_INaK__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__INaK = var_Environment__K_o * var_INaK__fnak * var_INaK__ibarnak / ((1.0 + pow(var_INaK__kmnai, 2) / pow(var_chaste_interface__Na__Na_i, 2)) * (var_Environment__K_o + var_INaK__kmko)); // uA_per_uF
        const double var_Ito__rv = exp(0.0033333333333333335 * var_chaste_interface__cell__V); // dimensionless
        const double var_Ito2__Ito2_max = (-var_Environment__Cl_o * exp(var_Environment__FonRT * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_Environment__F * var_Environment__FonRT * var_Ito2__PCl * var_chaste_interface__cell__V / (1.0 - exp(var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Ito2__Ito2 = var_chaste_interface__Ito2__AA * var_Ito2__Ito2_max; // uA_per_uF
        const double var_cell__caiont = -2.0 * var_INaCa__INaCa + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_cell__i_Stim = 0.0; // uA_per_uF
        const double var_reversal_potentials__ECl = -log(var_Environment__Cl_o / var_chaste_interface__Cl__Cl_i) / var_Environment__FonRT; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__cell__V) * var_IClb__GClb; // uA_per_uF
        const double var_cell__clont = 0.5 * var_cell__i_Stim + var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = log(var_Environment__K_o / var_chaste_interface__K__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__ak1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)); // per_ms
        const double var_IK1__bk1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__IK1 = 0.21516574145596759 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_IK1__ak1 / (var_IK1__ak1 + var_IK1__bk1); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 2) * var_IKr__gkr * var_IKr__r * var_chaste_interface__IKr__xr; // uA_per_uF
        const double var_Ito__Ito = pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_Ito__gitodv * var_Ito__rv * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv; // uA_per_uF
        const double var_reversal_potentials__ENa = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__INa = (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 1) * var_INa__gNa; // uA_per_uF
        const double var_INal__INal = pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_INal__GNaL * var_chaste_interface__INal__hL; // uA_per_uF
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INal__INal; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = log((var_Environment__Na_o * var_reversal_potentials__prnak + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__cell__V) * var_IKs__gks * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito__Ito; // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_cell__caiont + var_cell__clont + var_cell__kiont + var_cell__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellhund_rudy_2004_aFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__Environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Irel__CaMKtrap = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Irel__ro = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 23);
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 24);
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 25);
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_jsr = NV_Ith_S(rY, 26);
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = NV_Ith_S(rY, 27);
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = NV_Ith_S(rY, 28);
        // Units: mM; Initial value: 0.00012271265

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Ca__BSLmax = 1.1240000000000001; // mM
        const double var_Ca__BSRmax = 0.047; // mM
        const double var_Ca__KmBSL = 0.0086999999999999994; // mM
        const double var_Ca__KmBSR = 0.00087000000000000001; // mM
        const double var_Ca__bss = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__cbar = 0.050000000000000003; // mM
        const double var_Ca__csqnbar = 10.0; // mM
        const double var_Ca__kmc = 0.0023800000000000002; // mM
        const double var_Ca__kmcsqn = 0.80000000000000004; // mM
        const double var_Ca__bcsqn = 1 / (1.0 + var_Ca__csqnbar * var_Ca__kmcsqn / pow((var_chaste_interface__Ca__Ca_jsr + var_Ca__kmcsqn), 2)); // dimensionless
        const double var_Ca__kmt = 0.00050000000000000001; // mM
        const double var_Ca__tbar = 0.070000000000000007; // mM
        const double var_Ca__bmyo = 1 / (1.0 + var_Ca__cbar * var_Ca__kmc / pow((var_chaste_interface__Ca__Ca_i + var_Ca__kmc), 2) + var_Ca__kmt * var_Ca__tbar / pow((var_chaste_interface__Ca__Ca_i + var_Ca__kmt), 2)); // dimensionless
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__Cl_o = 100.0; // mM
        const double var_Environment__F = 96485.0; // C_per_mole
        const double var_Environment__FonRT = 0.0374358835078; // per_mV
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 140.0; // mM
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__gacai = 1.0; // dimensionless
        const double var_ICaL__gacao = 0.34100000000000003; // dimensionless
        const double var_ICaL__pca = 0.000243; // L_per_F_ms
        const double var_IClb__GClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKr__gkr = 0.0059618984305585326 * sqrt(var_Environment__K_o); // mS_per_uF
        const double var_IKs__gks = 0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INa__GNa = ((var_Environment__tissue == 0) ? (8.25) : (33.0)); // mS_per_uF
        const double var_INa__gNa = pow(var_chaste_interface__INa__m, 3) * var_INa__GNa * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mS_per_uF
        const double var_INaCa__KmCa = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__NCXmax = 4.5; // uA_per_uF
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__allo = 1 / (1.0 + pow(var_INaCa__KmCa, 2) / pow(var_INaCa__ca_i_NaCa, 2)); // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__ibarnak = 0.61875000000000002; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 10.0; // mM
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INal__GNaL = 0.0064999999999999997; // mS_per_uF
        const double var_Idiff_Itr__idiff = 5.0 * var_chaste_interface__Ca__Ca_ss - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_Idiff_Itr__itr = 0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr; // mM_per_ms
        const double var_IpCa__ibarpca = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__kmpca = 0.00050000000000000001; // mM
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__ibarpca / (var_chaste_interface__Ca__Ca_i + var_IpCa__kmpca); // uA_per_uF
        const double var_Irel__CaMK0 = 0.050000000000000003; // dimensionless
        const double var_Irel__Km = 0.0015; // mM
        const double var_Irel__CaMKbound = (1.0 - var_chaste_interface__Irel__CaMKtrap) * var_Irel__CaMK0 / (1.0 + var_Irel__Km / var_chaste_interface__Ca__Ca_ss); // dimensionless
        const double var_Irel__CaMKactive = var_Irel__CaMKbound + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double d_dt_chaste_interface_var_Irel__CaMKtrap = -0.00068000000000000005 * var_chaste_interface__Irel__CaMKtrap + 0.050000000000000003 * (-var_chaste_interface__Irel__CaMKtrap + var_Irel__CaMKactive) * var_Irel__CaMKactive; // 1 / ms
        const double var_ICaL__taufca = 0.5 + 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive); // ms
        const double var_Irel__KmCaMK = 0.14999999999999999; // dimensionless
        const double var_Irel__dro_inf = pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) / (pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) + 1644.6531773416521 * pow((var_chaste_interface__Ca__Ca_ss / (0.0028 + var_chaste_interface__Ca__Ca_ss)), 1.8999999999999999)); // dimensionless
        const double var_Irel__dtau_rel_max = 10.0; // ms
        const double var_Irel__dtau_rel = var_Irel__CaMKactive * var_Irel__dtau_rel_max / (var_Irel__CaMKactive + var_Irel__KmCaMK); // ms
        const double var_Ito__gitodv = 0.19; // mS_per_uF
        const double var_Ito2__Kmto2 = 0.1502; // mM
        const double var_Ito2__AAss = 1 / (1.0 + var_Ito2__Kmto2 / var_chaste_interface__Ca__Ca_ss); // dimensionless
        const double d_dt_chaste_interface_var_Ito2__AA = var_Ito2__AAss - 1.0 * var_chaste_interface__Ito2__AA; // 1 / ms
        const double var_Ito2__PCl = 3.9999999999999998e-7; // L_per_F_ms
        const double var_Iup_Ileak__Kmup = 0.00092000000000000003; // mM
        const double var_Iup_Ileak__dJupmax = 0.75; // dimensionless
        const double var_Iup_Ileak__dJup = var_Irel__CaMKactive * var_Iup_Ileak__dJupmax / (var_Irel__CaMKactive + var_Irel__KmCaMK); // dimensionless
        const double var_Iup_Ileak__dKmPLBmax = 0.00017000000000000001; // mM
        const double var_Iup_Ileak__dKmPLB = var_Irel__CaMKactive * var_Iup_Ileak__dKmPLBmax / (var_Irel__CaMKactive + var_Irel__KmCaMK); // mM
        const double var_Iup_Ileak__iupmax = 0.0043750000000000004; // mM_per_ms
        const double var_Iup_Ileak__iup = (1.0 + var_Iup_Ileak__dJup) * var_chaste_interface__Ca__Ca_i * var_Iup_Ileak__iupmax / (-var_Iup_Ileak__dKmPLB + var_chaste_interface__Ca__Ca_i + var_Iup_Ileak__Kmup); // mM_per_ms
        const double var_Iup_Ileak__nsrmax = 15.0; // mM
        const double var_Iup_Ileak__ileak = var_chaste_interface__Ca__Ca_nsr * var_Iup_Ileak__iupmax / var_Iup_Ileak__nsrmax; // mM_per_ms
        const double var_K__CTKClmax = 7.0755999999999996e-6; // mM_per_ms
        const double var_Na__CTNaClmax = 9.8442999999999999e-6; // mM_per_ms
        const double var_INaCa__denom2 = pow(var_INaCa__KmNao, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_INaCa__ca_i_NaCa / var_INaCa__KmCai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__denom3 = pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o + pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_ICaL__dpss = 9.0 - 8.0 / (1.0 + exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_ICaL__dp = 0.10000000000000001 * var_ICaL__dpss - 0.10000000000000001 * var_chaste_interface__ICaL__dp; // 1 / ms
        const double var_ICaL__dss = 1 / (1.0 + exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__f2ss = 0.23000000000000001 + 0.77000000000000002 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__fss = 0.29999999999999999 + 0.69999999999999996 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__ibarca = 4.0 * (-15.0 + var_chaste_interface__cell__V) * (-var_Environment__Ca_o * var_ICaL__gacao + var_chaste_interface__Ca__Ca_ss * var_ICaL__gacai * exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)) * var_Environment__F * var_Environment__FonRT * NV_Ith_S(mParameters, 0) * var_ICaL__pca / (-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICaL__fca2ss = 1 / (1.0 - 100.0 * var_ICaL__ICaL); // dimensionless
        const double var_ICaL__fcass = 0.14999999999999999 + 0.55000000000000004 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 0.29999999999999999 / (1.0 - 20.0 * var_ICaL__ICaL); // dimensionless
        const double d_dt_chaste_interface_var_ICaL__fca = (-var_chaste_interface__ICaL__fca + var_ICaL__fcass) / var_ICaL__taufca; // 1 / ms
        const double var_ICaL__taud = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V)); // ms
        const double d_dt_chaste_interface_var_ICaL__d = (-var_chaste_interface__ICaL__d + var_ICaL__dss) / var_ICaL__taud; // 1 / ms
        const double var_ICaL__tauf = 1 / (0.052900000000000003 + 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2))); // ms
        const double d_dt_chaste_interface_var_ICaL__f = (-var_chaste_interface__ICaL__f + var_ICaL__fss) / var_ICaL__tauf; // 1 / ms
        const double var_ICaL__tauf2 = 1 / (0.0054000000000000003 + 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2))); // ms
        const double d_dt_chaste_interface_var_ICaL__f2 = (-var_chaste_interface__ICaL__f2 + var_ICaL__f2ss) / var_ICaL__tauf2; // 1 / ms
        const double var_ICaL__taufca2 = 125.0 + 300.0 / (1.0 + exp(-4.375 - 25.0 * var_ICaL__ICaL)); // ms
        const double d_dt_chaste_interface_var_ICaL__fca2 = (-var_chaste_interface__ICaL__fca2 + var_ICaL__fca2ss) / var_ICaL__taufca2; // 1 / ms
        const double var_ICab__ICab = 7.9803360000000004e-7 * (-0.34100000000000003 * var_Environment__Ca_o + var_chaste_interface__Ca__Ca_i * exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)) * var_Environment__F * var_Environment__FonRT * var_chaste_interface__cell__V / (-1.0 + exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr__tauxr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__cell__V) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__cell__V) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V))); // ms
        const double var_IKr__xrss = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + var_IKr__xrss) / var_IKr__tauxr; // 1 / ms
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V))); // ms
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__xs2 = 0.5 * (-var_chaste_interface__IKs__xs2 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms
        const double var_INa__ah = ((var_chaste_interface__cell__V >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V))); // per_ms
        const double var_INa__aj = ((var_chaste_interface__cell__V >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V)))); // per_ms
        const double var_INa__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_INa__bh = ((var_chaste_interface__cell__V >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V))); // per_ms
        const double d_dt_chaste_interface_var_INa__H = (1.0 - var_chaste_interface__INa__H) * var_INa__ah - var_chaste_interface__INa__H * var_INa__bh; // 1 / ms
        const double var_INa__bj = ((var_chaste_interface__cell__V >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__J = (1.0 - var_chaste_interface__INa__J) * var_INa__aj - var_chaste_interface__INa__J * var_INa__bj; // 1 / ms
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double d_dt_chaste_interface_var_INa__m = (1.0 - var_chaste_interface__INa__m) * var_INa__am - var_INa__bm * var_chaste_interface__INa__m; // 1 / ms
        const double var_INaCa__denom1 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__num = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(var_Environment__FonRT * var_INaCa__eta * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__INaCa = var_INaCa__NCXmax * var_INaCa__allo * var_INaCa__num / ((var_INaCa__denom2 + var_INaCa__denom3) * var_INaCa__denom1); // uA_per_uF
        const double var_INaK__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__INaK = var_Environment__K_o * var_INaK__fnak * var_INaK__ibarnak / ((1.0 + pow(var_INaK__kmnai, 2) / pow(var_chaste_interface__Na__Na_i, 2)) * (var_Environment__K_o + var_INaK__kmko)); // uA_per_uF
        const double var_INal__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_INal__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double d_dt_chaste_interface_var_INal__mL = (1.0 - var_chaste_interface__INal__mL) * var_INal__amL - var_INal__bmL * var_chaste_interface__INal__mL; // 1 / ms
        const double var_INal__hLss = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_INal__hL = 0.0016666666666666668 * var_INal__hLss - 0.0016666666666666668 * var_chaste_interface__INal__hL; // 1 / ms
        const double var_Irel__cafac = 1 / (1.0 + exp(3.3333333333333335 + 66.666666666666671 * var_ICaL__ICaL)); // dimensionless
        const double var_Irel__riss = 1 / (1.0 + exp(-16.0 + 80.0 * var_Irel__cafac + 40000.0 * var_chaste_interface__Ca__Ca_ss)); // dimensionless
        const double var_Irel__ross = var_Irel__dro_inf / (1.0 + 1 / pow(var_ICaL__ICaL, 2)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__ro = 0.33333333333333331 * var_Irel__ross - 0.33333333333333331 * var_chaste_interface__Irel__ro; // 1 / ms
        const double var_Irel__tauri = 3.0 + (350.0 - var_Irel__dtau_rel) / (1.0 + exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_Irel__cafac)) + var_Irel__dtau_rel; // ms
        const double d_dt_chaste_interface_var_Irel__ri = (-var_chaste_interface__Irel__ri + var_Irel__riss) / var_Irel__tauri; // 1 / ms
        const double var_Irel__vg = ((var_Environment__tissue == 0) ? (1 / (1.0 + exp(2.6000000000000001 + 0.20000000000000001 * var_ICaL__ibarca))) : (1.0)); // dimensionless
        const double var_Irel__Grel = 3000.0 * var_Irel__vg; // per_ms
        const double var_Irel__irelcicr = (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * var_Irel__Grel * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_jsr = (-var_Irel__irelcicr + var_Idiff_Itr__itr) * var_Ca__bcsqn; // mM / ms
        const double var_Ito__ay = 25.0 * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__ay2 = 0.029999999999999999 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__ay3 = 0.0022499999999999998 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__by = 25.0 * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double d_dt_chaste_interface_var_Ito__ydv = (1.0 - var_chaste_interface__Ito__ydv) * var_Ito__ay - var_Ito__by * var_chaste_interface__Ito__ydv; // 1 / ms
        const double var_Ito__by2 = 0.20000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double d_dt_chaste_interface_var_Ito__ydv2 = (1.0 - var_chaste_interface__Ito__ydv2) * var_Ito__ay2 - var_Ito__by2 * var_chaste_interface__Ito__ydv2; // 1 / ms
        const double var_Ito__by3 = 0.10000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double d_dt_chaste_interface_var_Ito__zdv = (1.0 - var_chaste_interface__Ito__zdv) * var_Ito__ay3 - var_Ito__by3 * var_chaste_interface__Ito__zdv; // 1 / ms
        const double var_Ito__rv = exp(0.0033333333333333335 * var_chaste_interface__cell__V); // dimensionless
        const double var_Ito2__Ito2_max = (-var_Environment__Cl_o * exp(var_Environment__FonRT * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_Environment__F * var_Environment__FonRT * var_Ito2__PCl * var_chaste_interface__cell__V / (1.0 - exp(var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Ito2__Ito2 = var_chaste_interface__Ito2__AA * var_Ito2__Ito2_max; // uA_per_uF
        const double var_cell__a = 0.0011000000000000001; // cm
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell__l = 0.01; // cm
        const double var_cell__ageo = 2.0 * M_PI * pow(var_cell__a, 2) + 2.0 * M_PI * var_cell__a * var_cell__l; // cm2
        const double var_cell__Acap = 2.0 * var_cell__ageo; // uF
        const double var_cell__AF = var_cell__Acap / var_Environment__F; // uF_mole_per_C
        const double var_cell__vcell = 1000.0 * M_PI * pow(var_cell__a, 2) * var_cell__l; // uL
        const double var_cell__vjsr = 0.0047999999999999996 * var_cell__vcell; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_cell__vnsr = 0.055199999999999999 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_nsr = -var_Iup_Ileak__ileak - var_Idiff_Itr__itr * var_cell__vjsr / var_cell__vnsr + var_Iup_Ileak__iup; // mM / ms
        const double var_cell__vss = 0.02 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup_Ileak__iup + var_Iup_Ileak__ileak) * var_cell__vnsr / var_cell__vmyo + var_Idiff_Itr__idiff * var_cell__vss / var_cell__vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell__AF / var_cell__vmyo) * var_Ca__bmyo; // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (-var_Idiff_Itr__idiff + var_Irel__irelcicr * var_cell__vjsr / var_cell__vss - 0.5 * var_ICaL__ICaL * var_cell__AF / var_cell__vss) * var_Ca__bss; // mM / ms
        const double var_reversal_potentials__ECl = -log(var_Environment__Cl_o / var_chaste_interface__Cl__Cl_i) / var_Environment__FonRT; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__cell__V) * var_IClb__GClb; // uA_per_uF
        const double var_cell__clont = 0.5 * var_cell__i_Stim + var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = log(var_Environment__K_o / var_chaste_interface__K__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__ak1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)); // per_ms
        const double var_IK1__bk1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__IK1 = 0.21516574145596759 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_IK1__ak1 / (var_IK1__ak1 + var_IK1__bk1); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 2) * var_IKr__gkr * var_IKr__r * var_chaste_interface__IKr__xr; // uA_per_uF
        const double var_Ito__Ito = pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_Ito__gitodv * var_Ito__rv * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv; // uA_per_uF
        const double var_K__CTKCl = (-var_reversal_potentials__ECl + var_reversal_potentials__EK) * var_K__CTKClmax / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_reversal_potentials__ENa = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__INa = (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 1) * var_INa__gNa; // uA_per_uF
        const double var_INal__INal = pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_INal__GNaL * var_chaste_interface__INal__hL; // uA_per_uF
        const double var_Na__CTNaCl = pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) * var_Na__CTNaClmax / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_cell__AF * var_cell__clont / var_cell__vmyo + var_K__CTKCl + var_Na__CTNaCl; // mM / ms
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INal__INal; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = -var_cell__AF * var_cell__naiont / var_cell__vmyo + var_Na__CTNaCl; // mM / ms
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = log((var_Environment__Na_o * var_reversal_potentials__prnak + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__cell__V) * var_IKs__gks * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito__Ito; // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -var_cell__AF * var_cell__kiont / var_cell__vmyo + var_K__CTKCl; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            const double var_cell__caiont = -2.0 * var_INaCa__INaCa + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
            d_dt_chaste_interface_var_cell__V = -var_cell__caiont - var_cell__clont - var_cell__kiont - var_cell__naiont; // mV / ms
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_cell__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_Ca__Ca_i;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_INa__H;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_INa__m;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_INa__J;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_ICaL__d;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_ICaL__dp;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_ICaL__f;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_ICaL__fca;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_ICaL__fca2;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_ICaL__f2;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_IKr__xr;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_IKs__xs1;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_IKs__xs2;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_Ito__ydv;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_Ito__ydv2;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_Ito__zdv;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_Ito2__AA;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_INal__mL;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_INal__hL;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_Irel__CaMKtrap;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_Irel__ro;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_Irel__ri;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_Na__Na_i;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_K__K_i;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_Cl__Cl_i;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_Ca__Ca_jsr;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_Ca__Ca_nsr;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_Ca__Ca_ss;
    }

    void Cellhund_rudy_2004_aFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__Environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Irel__CaMKtrap = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Irel__ro = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 23);
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 24);
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 25);
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_jsr = NV_Ith_S(rY, 26);
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = NV_Ith_S(rY, 27);
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = NV_Ith_S(rY, 28);
        // Units: mM; Initial value: 0.00012271265
        
        const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V);
        const double var_x1 = 1.0 + var_x0;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = pow(var_chaste_interface__INal__mL, 3);
        const double var_x4 = 0.0064999999999999997 * var_x3;
        const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
        const double var_x6 = exp(var_x5);
        const double var_x7 = -1.0 + var_x6;
        const double var_x8 = 1 / var_x7;
        const double var_x9 = var_x6 * var_chaste_interface__Ca__Ca_i;
        const double var_x10 = -0.61380000000000001 + var_x9;
        const double var_x11 = var_x10 * var_x8;
        const double var_x12 = 1 / var_chaste_interface__K__K_i;
        const double var_x13 = log(5.4000000000000004 * var_x12);
        const double var_x14 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * var_x13);
        const double var_x15 = 1.0 + var_x14;
        const double var_x16 = 1 / var_x15;
        const double var_x17 = exp(-2.4444678999999998 + 13.738155796238718 * var_x13 - 0.51429999999999998 * var_chaste_interface__cell__V);
        const double var_x18 = 1.0 + var_x17;
        const double var_x19 = 1 / var_x18;
        const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * var_x13);
        const double var_x21 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * var_x13);
        const double var_x22 = var_x20 + 0.49124000000000001 * var_x21;
        const double var_x23 = var_x19 * var_x22;
        const double var_x24 = 1 / (var_x23 + 1.02 * var_x16);
        const double var_x25 = var_x16 * var_x24;
        const double var_x26 = 1 / var_chaste_interface__Ca__Ca_i;
        const double var_x27 = pow(var_x26, 1.3999999999999999);
        const double var_x28 = 1.0 + 6.4818210260626455e-7 * var_x27;
        const double var_x29 = 1 / var_x28;
        const double var_x30 = -0.024897499999999999 - 0.014938499999999999 * var_x29;
        const double var_x31 = var_x30 * var_chaste_interface__IKs__xs2;
        const double var_x32 = var_x31 * var_chaste_interface__IKs__xs1;
        const double var_x33 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V);
        const double var_x34 = 1.0 + var_x33;
        const double var_x35 = NV_Ith_S(mParameters, 2) / var_x34;
        const double var_x36 = 0.013854200000000001 * var_x35;
        const double var_x37 = 0.0374358835078 * var_chaste_interface__cell__V;
        const double var_x38 = exp(var_x37);
        const double var_x39 = 1.0 - var_x38;
        const double var_x40 = 1 / var_x39;
        const double var_x41 = -100.0 * var_x38 + var_chaste_interface__Cl__Cl_i;
        const double var_x42 = var_x40 * var_x41;
        const double var_x43 = 0.001444800488100033 * var_x42;
        const double var_x44 = pow(var_chaste_interface__Na__Na_i, 2);
        const double var_x45 = 1 / var_x44;
        const double var_x46 = exp(-0.00374358835078 * var_chaste_interface__cell__V);
        const double var_x47 = exp(2.0802377414561666);
        const double var_x48 = exp(-var_x37);
        const double var_x49 = 1.0 + 0.1245 * var_x46 + 0.036499999999999998 * var_x48 * (-0.14285714285714285 + 0.14285714285714285 * var_x47);
        const double var_x50 = (0.00046607674967211004 * var_x46 + 0.0374358835078 * var_x48 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x47)) / (pow(var_x49, 2) * (1.0 + 100.0 * var_x45));
        const double var_x51 = 26.712338705500134 * var_x13;
        const double var_x52 = -var_x51 + var_chaste_interface__cell__V;
        const double var_x53 = var_x0 * var_x52 / pow(var_x1, 2);
        const double var_x54 = var_x6 * var_chaste_interface__cell__V;
        const double var_x55 = var_x10 * var_x54 / pow(var_x7, 2);
        const double var_x56 = var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V;
        const double var_x57 = var_x40 * var_x56;
        const double var_x58 = var_x38 * var_x57;
        const double var_x59 = var_x14 / pow(var_x15, 2);
        const double var_x60 = var_x24 * var_x52;
        const double var_x61 = var_x59 * var_x60;
        const double var_x62 = pow(var_chaste_interface__Na__Na_i, 3);
        const double var_x63 = exp(0.01310255922773 * var_chaste_interface__cell__V);
        const double var_x64 = var_x62 * var_x63;
        const double var_x65 = exp(-0.024333324280070002 * var_chaste_interface__cell__V);
        const double var_x66 = var_x65 * var_chaste_interface__Ca__Ca_i;
        const double var_x67 = 1 / (13227.9606 + 8.4084932990912282 * var_x62 + 6516533.0625 * var_chaste_interface__Ca__Ca_i);
        const double var_x68 = 1.0 + 0.27000000000000002 * var_x65;
        const double var_x69 = 1 / var_x68;
        const double var_x70 = 1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2);
        const double var_x71 = 1 / var_x70;
        const double var_x72 = var_x69 * var_x71;
        const double var_x73 = var_x67 * var_x72;
        const double var_x74 = var_x73 * (0.023584606609913999 * var_x64 + 100155.96273676812 * var_x66);
        const double var_x75 = pow(var_chaste_interface__INa__m, 3);
        const double var_x76 = var_x75 * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa__J;
        const double var_x77 = 8.25 * var_x76;
        const double var_x78 = pow(var_chaste_interface__Ito__ydv, 3);
        const double var_x79 = exp(0.0033333333333333335 * var_chaste_interface__cell__V);
        const double var_x80 = var_x78 * var_x79 * var_chaste_interface__Ito__zdv;
        const double var_x81 = 0.19 * var_x80;
        const double var_x82 = var_x8 * var_x9 * var_chaste_interface__cell__V;
        const double var_x83 = var_x17 * var_x22 / pow(var_x18, 2);
        const double var_x84 = 0.24326999999999999 * var_x59 - 0.51429999999999998 * var_x83 - var_x19 * (0.061749999999999999 * var_x20 + 0.039456396800000001 * var_x21);
        const double var_x85 = var_x16 * var_x52 / pow((var_x16 + 0.98039215686274506 * var_x23), 2);
        const double var_x86 = 0.49019607843137253 * var_x85;
        const double var_x87 = var_x33 * var_x52 * NV_Ith_S(mParameters, 2) * var_chaste_interface__IKr__xr / pow(var_x34, 2);
        const double var_x88 = var_x38 * var_x41 * var_x56 / pow(var_x39, 2);
        const double var_x89 = var_x52 * var_chaste_interface__Ito__ydv2;
        const double var_x90 = var_x80 * var_x89;
        const double var_x91 = 1.8 * var_x64 - 4116000.0 * var_x66;
        const double var_x92 = var_x67 * var_x91;
        const double var_x93 = var_x65 * var_x71 * var_x92 / pow(var_x68, 2);
        const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
        const double var_x95 = exp(-1.1230765052339999 + var_x5);
        const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
        const double var_x97 = -0.61380000000000001 + var_x96;
        const double var_x98 = -1.0 + var_x95;
        const double var_x99 = NV_Ith_S(mParameters, 0) / var_x98;
        const double var_x100 = var_x97 * var_x99;
        const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
        const double var_x102 = 3.5108651860830804 * var_chaste_interface__ICaL__fca;
        const double var_x103 = var_x101 * var_x102;
        const double var_x104 = pow(var_x98, 2);
        const double var_x105 = var_x95 * var_x97 * NV_Ith_S(mParameters, 0) / var_x104;
        const double var_x106 = -15.0 + var_chaste_interface__cell__V;
        const double var_x107 = var_x106 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__fca2;
        const double var_x108 = var_x107 * var_chaste_interface__ICaL__fca;
        const double var_x109 = var_x108 * var_chaste_interface__ICaL__f2;
        const double var_x110 = 0.26286468023559356 * var_x109;
        const double var_x111 = var_x96 * var_x99;
        const double var_x112 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
        const double var_x113 = 1 / var_x112;
        const double var_x114 = pow(var_x112, (-2));
        const double var_x115 = var_x114 * var_chaste_interface__Ca__Ca_i;
        const double var_x116 = var_x54 * var_x8;
        const double var_x117 = var_x65 * var_x73;
        const double var_x118 = var_x72 * var_x91 / pow((0.0020299076937277489 + 1.2903323313862536e-6 * var_x62 + var_chaste_interface__Ca__Ca_i), 2);
        const double var_x119 = var_x69 * var_x92 / (pow(var_x70, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
        const double var_x120 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
        const double var_x121 = -26.712338705500134 * log(7.9662000000000006 / var_x120) + var_chaste_interface__cell__V;
        const double var_x122 = var_x121 * var_chaste_interface__IKs__xs1;
        const double var_x123 = var_x122 * var_x26 * var_x27 * var_chaste_interface__IKs__xs2 / pow(var_x28, 2);
        const double var_x124 = 1 / var_chaste_interface__Na__Na_i;
        const double var_x125 = log(140.0 * var_x124);
        const double var_x126 = -26.712338705500134 * var_x125 + var_chaste_interface__cell__V;
        const double var_x127 = var_x126 * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa__H;
        const double var_x128 = var_x127 * pow(var_chaste_interface__INa__m, 2) * var_chaste_interface__INa__J;
        const double var_x129 = var_x127 * var_x75;
        const double var_x130 = var_x103 * var_x106;
        const double var_x131 = var_chaste_interface__ICaL__dp / var_chaste_interface__ICaL__d;
        const double var_x132 = log(var_chaste_interface__ICaL__d);
        const double var_x133 = var_x100 * var_x106 * var_x94 * var_chaste_interface__ICaL__f2;
        const double var_x134 = var_x102 * var_x133;
        const double var_x135 = var_x101 * var_x106;
        const double var_x136 = var_x102 * var_x107;
        const double var_x137 = var_x79 * var_x89;
        const double var_x138 = var_x137 * pow(var_chaste_interface__Ito__ydv, 2) * var_chaste_interface__Ito__zdv;
        const double var_x139 = var_x137 * var_x78;
        const double var_x140 = var_x126 * pow(var_chaste_interface__INal__mL, 2) * var_chaste_interface__INal__hL;
        const double var_x141 = 1 / (var_x49 * var_x62 * pow((0.01 + var_x45), 2));
        const double var_x142 = var_x124 * var_x3 * var_chaste_interface__INal__hL;
        const double var_x143 = var_x118 * var_x44;
        const double var_x144 = (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x120, 2);
        const double var_x145 = var_x144 * var_x32;
        const double var_x146 = var_x44 * var_x63 * var_x73;
        const double var_x147 = var_x124 * var_x76 * var_chaste_interface__INa__H;
        const double var_x148 = var_x12 * var_x2;
        const double var_x149 = var_x12 * var_x25;
        const double var_x150 = var_x12 * var_x35 * var_chaste_interface__IKr__xr;
        const double var_x151 = var_x12 * var_x59;
        const double var_x152 = 6.4983106368870169 * var_x151 - var_x19 * (1.6494869150646332 * var_x12 * var_x20 + 1.0539726354202117 * var_x12 * var_x21) - 13.738155796238718 * var_x12 * var_x83;
        const double var_x153 = var_x151 * var_x60;
        const double var_x154 = var_x12 * var_x80 * var_chaste_interface__Ito__ydv2;
        const double var_x155 = 1 / var_chaste_interface__Cl__Cl_i;
        const double var_x156 = var_x95 * var_x99;
        const double var_x157 = var_x156 * var_chaste_interface__ICaL__f2;
        const double var_x158 = 8.8666719524733664e-8 * var_x11;
        const double var_x159 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
        const double var_x160 = 1.0 + 0.00011900000000000002 / pow(var_x159, 2) + 3.5000000000000004e-5 * var_x114;
        const double var_x161 = 1 / var_x160;
        const double var_x162 = var_x161;
        const double var_x163 = 1.768721357868101e-6 * var_x113;
        const double var_x164 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
        const double var_x165 = 1 / var_chaste_interface__Ca__Ca_ss;
        const double var_x166 = 1.0 + 0.0015 * var_x165;
        const double var_x167 = 1 / var_x166;
        const double var_x168 = 0.050000000000000003 * var_x167;
        const double var_x169 = var_x164 * var_x168 + var_chaste_interface__Irel__CaMKtrap;
        const double var_x170 = 0.14999999999999999 + var_x169;
        const double var_x171 = 1 / var_x170;
        const double var_x172 = var_x169 * var_x171;
        const double var_x173 = 0.00092000000000000003 - 0.00017000000000000001 * var_x172 + var_chaste_interface__Ca__Ca_i;
        const double var_x174 = 1 / var_x173;
        const double var_x175 = 1.0 + 0.75 * var_x172;
        const double var_x176 = var_x174 * var_x175;
        const double var_x177 = 0.00035514705882352943 * var_x176;
        const double var_x178 = 0.00035514705882352943 * var_chaste_interface__Ca__Ca_i;
        const double var_x179 = var_x175 / pow(var_x173, 2);
        const double var_x180 = var_x178 * var_x179;
        const double var_x181 = 1 - var_x168;
        const double var_x182 = var_x171 * var_x181;
        const double var_x183 = var_x169 / pow(var_x170, 2);
        const double var_x184 = var_x183 * (-1 + var_x168);
        const double var_x185 = 0.75 * var_x182 + 0.75 * var_x184;
        const double var_x186 = var_x174 * var_x178;
        const double var_x187 = 0.00017000000000000001 * var_x182 + 0.00017000000000000001 * var_x184;
        const double var_x188 = pow(var_chaste_interface__Ca__Ca_ss, (-2));
        const double var_x189 = var_x164 * var_x188 / pow(var_x166, 2);
        const double var_x190 = var_x171 * var_x189;
        const double var_x191 = var_x183 * var_x189;
        const double var_x192 = 5.6250000000000005e-5 * var_x190 - 5.6250000000000005e-5 * var_x191;
        const double var_x193 = 1.2750000000000002e-8 * var_x190 - 1.2750000000000002e-8 * var_x191;
        const double var_x194 = var_chaste_interface__cell__V >= -40.0;
        const double var_x195 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V);
        const double var_x196 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V);
        const double var_x197 = 1.0 + var_x196;
        const double var_x198 = exp(0.079000000000000001 * var_chaste_interface__cell__V);
        const double var_x199 = exp(0.34999999999999998 * var_chaste_interface__cell__V);
        const double var_x200 = 1.0 - var_chaste_interface__INa__m;
        const double var_x201 = -0.10000000000000001 * var_chaste_interface__cell__V;
        const double var_x202 = exp(-4.7130000000000001 + var_x201);
        const double var_x203 = 1.0 - var_x202;
        const double var_x204 = 0.32000000000000001 / var_x203;
        const double var_x205 = exp(-0.090909090909090912 * var_chaste_interface__cell__V);
        const double var_x206 = 0.0072727272727272727 * var_x205;
        const double var_x207 = 47.130000000000003 + var_chaste_interface__cell__V;
        const double var_x208 = 0.032000000000000001 * var_x202 * var_x207 / pow(var_x203, 2);
        const double var_x209 = -0.080000000000000002 * var_x205 - var_x204 * var_x207;
        const double var_x210 = exp(0.24440000000000001 * var_chaste_interface__cell__V);
        const double var_x211 = exp(-0.043909999999999998 * var_chaste_interface__cell__V);
        const double var_x212 = -127140.0 * var_x210 - 3.4740000000000003e-5 * var_x211;
        const double var_x213 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V);
        const double var_x214 = 1.0 + var_x213;
        const double var_x215 = 1 / var_x214;
        const double var_x216 = var_x212 * var_x215;
        const double var_x217 = 37.780000000000001 + var_chaste_interface__cell__V;
        const double var_x218 = exp(-3.2000000000000002 + var_x201);
        const double var_x219 = 1.0 + var_x218;
        const double var_x220 = exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V);
        const double var_x221 = var_x220 / var_x219;
        const double var_x222 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V);
        const double var_x223 = 1.0 + var_x222;
        const double var_x224 = exp(-0.01052 * var_chaste_interface__cell__V);
        const double var_x225 = var_x224 / var_x223;
        const double var_x226 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V);
        const double var_x227 = 1.0 + var_x226;
        const double var_x228 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V);
        const double var_x229 = var_x228 / var_x227;
        const double var_x230 = exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V);
        const double var_x231 = 1.0 + var_x230;
        const double var_x232 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x229);
        const double var_x233 = exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V);
        const double var_x234 = exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V);
        const double var_x235 = 1.0 + var_x234;
        const double var_x236 = 1 / var_x235;
        const double var_x237 = 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2));
        const double var_x238 = var_x234 / pow(var_x235, 2);
        const double var_x239 = var_x101 * var_chaste_interface__ICaL__fca;
        const double var_x240 = 5.2572936047118706 * var_x109;
        const double var_x241 = 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss);
        const double var_x242 = 10.0 * var_x172;
        const double var_x243 = 1 / (0.5 + var_x242 + var_x241);
        const double var_x244 = var_x135 * var_chaste_interface__ICaL__fca;
        const double var_x245 = -var_x244;
        const double var_x246 = pow((0.0142415038316475 + var_x245), (-2));
        const double var_x247 = var_x243 * var_x246;
        const double var_x248 = 0.0042724511494942495 * var_x247;
        const double var_x249 = var_x131 * var_x244;
        const double var_x250 = var_x132 * var_x244;
        const double var_x251 = var_x133 * var_chaste_interface__ICaL__fca;
        const double var_x252 = var_x251 * var_chaste_interface__ICaL__fca2;
        const double var_x253 = 0.0042724511494942495 * var_x246;
        const double var_x254 = var_x251 * var_chaste_interface__ICaL__f;
        const double var_x255 = var_x100 * var_x108;
        const double var_x256 = -10.0 * var_x182 - 10.0 * var_x184;
        const double var_x257 = 0.01 * (0.14999999999999999 - var_chaste_interface__ICaL__fca + 0.55000000000000004 * var_x241 + 0.29999999999999999 / (1.0 - 70.217303721661608 * var_x244)) / pow((0.050000000000000003 + var_x172 + 0.10000000000000001 * var_x241), 2);
        const double var_x258 = pow((0.0030000000000000001 + var_chaste_interface__Ca__Ca_ss), (-2));
        const double var_x259 = var_x108 * var_x157;
        const double var_x260 = 0.00075000000000000002 * var_x191 - 0.00075000000000000002 * var_x190;
        const double var_x261 = 26.286468023559355 * var_x109;
        const double var_x262 = exp(-4.375 - 87.77162965207701 * var_x244);
        const double var_x263 = 1.0 + var_x262;
        const double var_x264 = 1 / var_x263;
        const double var_x265 = 1 / (125.0 + 300.0 * var_x264);
        const double var_x266 = pow((0.0028483007663294996 + var_x245), (-2));
        const double var_x267 = var_x265 * var_x266;
        const double var_x268 = 6.5716170058898387 * var_x109;
        const double var_x269 = var_x262 * (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 351.08651860830804 * var_x244)) / (pow(var_x263, 2) * pow((0.41666666666666669 + var_x264), 2));
        const double var_x270 = 0.0028483007663294996 * var_x267;
        const double var_x271 = 0.2925720988402567 * var_x269;
        const double var_x272 = 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2));
        const double var_x273 = exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V);
        const double var_x274 = 1.0 + var_x273;
        const double var_x275 = exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V);
        const double var_x276 = -1.0 + var_x275;
        const double var_x277 = 0.00029999999999999997 / var_x276;
        const double var_x278 = exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V);
        const double var_x279 = 1.0 - var_x278;
        const double var_x280 = 0.00059999999999999995 / var_x279;
        const double var_x281 = -1.7383999999999999 + var_chaste_interface__cell__V;
        const double var_x282 = 38.360799999999998 + var_chaste_interface__cell__V;
        const double var_x283 = var_x277 * var_x282;
        const double var_x284 = var_x280 * var_x281;
        const double var_x285 = exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V);
        const double var_x286 = 1.0 + var_x285;
        const double var_x287 = 1 / var_x286;
        const double var_x288 = exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V);
        const double var_x289 = 1.0 - var_x288;
        const double var_x290 = 1 / var_x289;
        const double var_x291 = 7.6100000000000007e-5 * var_x290;
        const double var_x292 = exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V);
        const double var_x293 = -1.0 + var_x292;
        const double var_x294 = 1 / var_x293;
        const double var_x295 = 0.00036000000000000002 * var_x294;
        const double var_x296 = -0.55000000000000004 + var_chaste_interface__cell__V;
        const double var_x297 = 44.600000000000001 + var_chaste_interface__cell__V;
        const double var_x298 = var_x291 + var_x295 - 4.6080000000000006e-5 * var_x292 * var_x296 / pow(var_x293, 2) - 0.00075871700000000012 * var_x288 * var_x297 / pow(var_x289, 2);
        const double var_x299 = var_x291 * var_x297;
        const double var_x300 = var_x295 * var_x296;
        const double var_x301 = var_x285 * (var_x299 + var_x300) / pow(var_x286, 2);
        const double var_x302 = 0.040000000000000001 * var_chaste_interface__cell__V;
        const double var_x303 = exp(-1.6000000000000001 + var_x302);
        const double var_x304 = 1.0 + var_x303;
        const double var_x305 = var_x303 / var_x304;
        const double var_x306 = 1.0 - 1.0 * var_chaste_interface__Ito__ydv;
        const double var_x307 = exp(-3.6000000000000001 - var_x302);
        const double var_x308 = 1.0 + var_x307;
        const double var_x309 = var_x307 / var_x308;
        const double var_x310 = var_chaste_interface__Ito__ydv;
        const double var_x311 = 0.040000000000000001 * var_chaste_interface__Ito__ydv2;
        const double var_x312 = 0.20000000000000001 * var_chaste_interface__cell__V;
        const double var_x313 = exp(5.0 + var_x312);
        const double var_x314 = 1.0 + var_x313;
        const double var_x315 = pow(var_x313, 2) / pow(var_x314, 2);
        const double var_x316 = var_x313 / var_x314;
        const double var_x317 = exp(12.0 + var_x312);
        const double var_x318 = 1.0 + var_x317;
        const double var_x319 = var_x317 / pow(var_x318, 2);
        const double var_x320 = 1 / var_x318;
        const double var_x321 = 0.02 * var_chaste_interface__Ito__zdv;
        const double var_x322 = 1.0 - var_chaste_interface__INal__mL;
        const double var_x323 = exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V);
        const double var_x324 = 0.0025000000000000005 * var_x167;
        const double var_x325 = -1 + 0.066666666666666666 * var_chaste_interface__cell__V;
        const double var_x326 = pow(var_x97, (-2));
        const double var_x327 = pow(NV_Ith_S(mParameters, 0), (-2));
        const double var_x328 = pow(var_chaste_interface__ICaL__d, (-2 * var_chaste_interface__ICaL__dp));
        const double var_x329 = pow(var_chaste_interface__ICaL__f, (-2));
        const double var_x330 = pow(var_chaste_interface__ICaL__f2, (-2));
        const double var_x331 = pow(var_chaste_interface__ICaL__fca, (-2));
        const double var_x332 = pow(var_chaste_interface__ICaL__fca2, (-2));
        const double var_x333 = var_x104 * var_x326 * var_x327 * var_x328 * var_x329 * var_x330 * var_x331 * var_x332;
        const double var_x334 = pow(var_x325, (-2));
        const double var_x335 = var_x326 * var_x327 * var_x328 * var_x330 * var_x331 * var_x332 * var_x334;
        const double var_x336 = 5.399297452372711e-5 * var_x329;
        const double var_x337 = var_x104 * var_x327 * var_x328 * var_x330 * var_x332 * var_x334;
        const double var_x338 = var_x331 * var_x337 / pow(var_x97, 3);
        const double var_x339 = pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999);
        const double var_x340 = 0.0028 + var_chaste_interface__Ca__Ca_ss;
        const double var_x341 = 1 / var_x340;
        const double var_x342 = pow((var_x341 * var_chaste_interface__Ca__Ca_ss), 1.8999999999999999);
        const double var_x343 = 1 / (var_x339 + 1644.6531773416521 * var_x342);
        const double var_x344 = var_x333 * var_x334;
        const double var_x345 = 1.0 + 0.00036056965579880955 * var_x344;
        const double var_x346 = var_x339 * var_x343 / pow(var_x345, 2);
        const double var_x347 = 0.00024037977053253972 * var_x346;
        const double var_x348 = var_x344 * var_x347;
        const double var_x349 = var_x104 * var_x347;
        const double var_x350 = var_x326 * var_x329;
        const double var_x351 = var_x327 * var_x328 * var_x331 * var_x334 * var_x349 * var_x350;
        const double var_x352 = 1 / var_x345;
        const double var_x353 = var_x352 / pow((var_x342 + 0.00060803092942449902 * var_x339), 2);
        const double var_x354 = exp(3.3333333333333335 + 234.05767907220539 * var_x244);
        const double var_x355 = 1.0 + var_x354;
        const double var_x356 = 1 / var_x355;
        const double var_x357 = exp(-16.0 + 80.0 * var_x356 + 40000.0 * var_chaste_interface__Ca__Ca_ss);
        const double var_x358 = 1.0 + var_x357;
        const double var_x359 = exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_x356);
        const double var_x360 = 1.0 + var_x359;
        const double var_x361 = 1 / var_x360;
        const double var_x362 = 350.0 - var_x242;
        const double var_x363 = var_x361 * var_x362;
        const double var_x364 = 1 / (3.0 + var_x242 + var_x363);
        const double var_x365 = var_x357 * var_x364 / pow(var_x358, 2);
        const double var_x366 = 17.524312015706236 * var_x109;
        const double var_x367 = var_x354 / pow(var_x355, 2);
        const double var_x368 = var_x367 * (234.05767907220539 * var_x239 + var_x111 * var_x366 - var_x105 * var_x366);
        const double var_x369 = (-var_chaste_interface__Irel__ri + 1 / var_x358) / pow((0.29999999999999999 + var_x172 + 0.10000000000000001 * var_x363), 2);
        const double var_x370 = var_x359 * var_x362 / pow(var_x360, 2);
        const double var_x371 = var_x369 * var_x370;
        const double var_x372 = 18724.614325776431 * var_x365;
        const double var_x373 = var_x367 * var_x372;
        const double var_x374 = 35.108651860830804 * var_x371;
        const double var_x375 = var_x367 * var_x374;
        const double var_x376 = var_x252 * var_x367;
        const double var_x377 = 0.01 * var_x369;
        const double var_x378 = var_x259 * var_x367;
        const double var_x379 = 3.998848287353967e-7 * var_x3;
        const double var_x380 = 0.00050754612877954204 * var_x76;
        const double var_x381 = log(100.0 * var_x155);
        const double var_x382 = var_x125 + var_x381;
        const double var_x383 = pow(var_x382, 4);
        const double var_x384 = 2.8839711417381356e-9 * pow(var_x382, 7) / pow((1 + 0.008558014922736952 * var_x383), 2);
        const double var_x385 = 20.048989239405216 * pow(var_x382, 3) / (59494197.640692554 + 509152.23122530844 * var_x383);
        const double var_x386 = var_x124 * var_x384 - var_x124 * var_x385;
        const double var_x387 = var_x155 * var_x384 - var_x155 * var_x385;
        const double var_x388 = -1.5317126959137754e-6 - 9.1902761754826519e-7 * var_x29;
        const double var_x389 = var_x388 * var_chaste_interface__IKs__xs2;
        const double var_x390 = var_x389 * var_chaste_interface__IKs__xs1;
        const double var_x391 = 8.5232067604091287e-7 * var_x35;
        const double var_x392 = 1.1688941147650058e-5 * var_x80;
        const double var_x393 = 3.0157226903121925e-5 * var_x85;
        const double var_x394 = var_x144 * var_x390;
        const double var_x395 = var_x51 + 26.712338705500134 * var_x381;
        const double var_x396 = 0.00018900582374463672 / (87.825100000000006 + var_x395);
        const double var_x397 = 2.4504050574883893e-8 * var_x395 / pow((1 + 0.30415380916731244 * var_x13 + 0.30415380916731244 * var_x381), 2);
        const double var_x398 = var_x12 * var_x397 - var_x12 * var_x396;
        const double var_x399 = var_x155 * var_x397 - var_x155 * var_x396;
        const double var_x400 = 8.8885199344722979e-8 * var_x42;
        const double var_x401 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr;
        const double var_x402 = pow(var_x401, (-2));
        const double var_x403 = 1 / (1.0 + 8.0 * var_x402);
        const double var_x404 = 3000.0 * var_x403;
        const double var_x405 = 0.70217303721661617 * var_x100;
        const double var_x406 = 0.052572936047118712 * var_x106;
        const double var_x407 = exp(2.6000000000000001 + var_x106 * var_x405);
        const double var_x408 = 1.0 + var_x407;
        const double var_x409 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr;
        const double var_x410 = var_x409 * var_chaste_interface__Irel__ro;
        const double var_x411 = var_x407 * var_x410 * var_chaste_interface__Irel__ri / pow(var_x408, 2);
        const double var_x412 = var_x411 * (var_x405 + var_x111 * var_x406 - var_x105 * var_x406);
        const double var_x413 = 1 / var_x408;
        const double var_x414 = var_x413 * var_chaste_interface__Irel__ri;
        const double var_x415 = var_x409 * var_x414;
        const double var_x416 = var_x410 * var_x413;
        const double var_x417 = var_x414 * var_chaste_interface__Irel__ro;
        const double var_x418 = 3000.0 * var_x417;
        const double var_x419 = var_x403;
        const double var_x420 = var_x106 * var_x156 * var_x411;
        const double var_x421 = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_i;
        const double var_x422 = var_x179 * var_x421;
        const double var_x423 = var_x174 * var_x421;
        const double var_x424 = 0.0002749177168957104 * var_x109;
        const double var_x425 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss;
        const double var_x426 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss;
        const double var_x427 = 1.0 + 0.0097788000000000007 / pow(var_x425, 2) + 4.0890000000000003e-5 / pow(var_x426, 2);
        const double var_x428 = 1 / var_x427;
        const double var_x429 = var_x428;
        const double var_x430 = 0.0036718475849305066 * var_x428;
        const double var_x431 = 719.99999999999989 * var_x428;
        const double var_x432 = 719.99999999999989 * var_x417;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00022499999999999999 + var_x32 - var_x103 + 0.00021581774391076088 * var_x55 + 0.00089962337662337659 * var_x87 + 0.005408738276452542 * var_x58 + 0.12163499999999999 * var_x61 - 4.5 * var_x74 - 0.0027599999999999999 * var_x2 - 0.00021581774391076088 * var_x82 - 5.4087382764525417e-5 * var_x88 - 0.0028824983370005666 * var_x11 - 0.48423913043478262 * var_x50 - 0.51000000000000001 * var_x25 - 0.0006333333333333333 * var_x90 - 0.00046153846153846147 * var_x53 - 0.029564989000285053 * var_x93 + var_x105 * var_x110 - var_x110 * var_x111 - var_x36 * var_chaste_interface__IKr__xr - var_x4 * var_chaste_interface__INal__hL - var_x43 * var_chaste_interface__Ito2__AA - var_x77 * var_chaste_interface__INa__H - var_x81 * var_chaste_interface__Ito__ydv2 - var_x84 * var_x86);
        IJth(rJacobian, 1, 0) = var_x162 * (-var_x158 + 1.8188600866065964e-6 * var_x93 + 6.6386339662934098e-9 * var_x55 + 0.00027684334297065928 * var_x74 - 6.6386339662934098e-9 * var_x82);
        IJth(rJacobian, 2, 0) = (1.0 - var_chaste_interface__INa__H) * ((var_x194) ? (0) : (-0.019852941176470591 * var_x195)) - ((var_x194) ? (0.693000693000693 * var_x196 / pow(var_x197, 2)) : (0.28123999999999999 * var_x198 + 108500.0 * var_x199)) * var_chaste_interface__INa__H;
        IJth(rJacobian, 3, 0) = var_x200 * var_x204 + var_x206 * var_chaste_interface__INa__m - var_x200 * var_x208;
        IJth(rJacobian, 4, 0) = (1.0 - var_chaste_interface__INa__J) * ((var_x194) ? (0) : (var_x216 + var_x215 * var_x217 * (1.5254334000000001e-6 * var_x211 - 31073.016 * var_x210) - 0.311 * var_x212 * var_x213 * var_x217 / pow(var_x214, 2))) - ((var_x194) ? (-7.6049999999999996e-8 * var_x221 + 0.029999999999999999 * var_x218 * var_x220 / pow(var_x219, 2)) : (-0.001275024 * var_x225 + 0.016701360000000002 * var_x222 * var_x224 / pow(var_x223, 2))) * var_chaste_interface__INa__J;
        IJth(rJacobian, 5, 0) = 1.5624999999999998 * (-var_chaste_interface__ICaL__d + 1 / var_x231) * (-0.041599999999999998 * var_x229 + 0.10560000000000001 * var_x226 * var_x228 / pow(var_x227, 2)) / pow((0.73749999999999993 + var_x229), 2) + 0.14836795252225518 * var_x230 * var_x232 / pow(var_x231, 2);
        IJth(rJacobian, 6, 0) = -0.23529411764705882 * var_x233 / pow((1.0 + var_x233), 2);
        IJth(rJacobian, 7, 0) = -0.099999999999999992 * var_x238 * (0.052900000000000003 + var_x237) + var_x237 * (0.039250169999999994 - 0.0040499999999999998 * var_chaste_interface__cell__V) * (0.29999999999999999 - var_chaste_interface__ICaL__f + 0.69999999999999996 * var_x236);
        IJth(rJacobian, 8, 0) = 6.0846129416049119e-5 * var_x247 * (70.217303721661608 * var_x239 + var_x111 * var_x240 - var_x105 * var_x240);
        IJth(rJacobian, 9, 0) = 8.1128172554732154e-6 * var_x267 * (351.08651860830804 * var_x239 + var_x111 * var_x261 - var_x105 * var_x261) + 0.0033333333333333335 * var_x269 * (-87.77162965207701 * var_x239 + var_x105 * var_x268 - var_x111 * var_x268);
        IJth(rJacobian, 10, 0) = -0.11 * var_x238 * (0.0054000000000000003 + var_x272) + var_x272 * (0.12930244120000001 - 0.0069619999999999994 * var_chaste_interface__cell__V) * (0.23000000000000001 - var_chaste_interface__ICaL__f2 + 0.77000000000000002 * var_x236);
        IJth(rJacobian, 11, 0) = (-var_chaste_interface__IKr__xr + 1 / var_x274) * (var_x277 + var_x280 - 8.1600000000000005e-5 * var_x278 * var_x281 / pow(var_x279, 2) - 4.566e-5 * var_x275 * var_x282 / pow(var_x276, 2)) + 0.23529411764705882 * var_x273 * (var_x283 + var_x284) / pow(var_x274, 2);
        IJth(rJacobian, 12, 0) = 0.04048582995951417 * var_x301 + var_x298 * (-var_chaste_interface__IKs__xs1 + var_x287);
        IJth(rJacobian, 13, 0) = 0.020242914979757085 * var_x301 + var_x298 * (0.5 * var_x287 - 0.5 * var_chaste_interface__IKs__xs2);
        IJth(rJacobian, 14, 0) = var_x305 * var_x306 + var_x309 * var_x310 - var_x306 * pow(var_x303, 2) / pow(var_x304, 2) - var_x310 * pow(var_x307, 2) / pow(var_x308, 2);
        IJth(rJacobian, 15, 0) = var_x311 * var_x315 - var_x311 * var_x316 - 0.0060000000000000001 * var_x319 * (1.0 - var_chaste_interface__Ito__ydv2);
        IJth(rJacobian, 16, 0) = var_x315 * var_x321 - var_x316 * var_x321 - 0.00044999999999999999 * var_x319 * (1.0 - var_chaste_interface__Ito__zdv);
        IJth(rJacobian, 18, 0) = var_x204 * var_x322 + var_x206 * var_chaste_interface__INal__mL - var_x208 * var_x322;
        IJth(rJacobian, 19, 0) = -0.00027322404371584699 * var_x323 / pow((1.0 + var_x323), 2);
        IJth(rJacobian, 21, 0) = 0.33333333333333331 * var_x346 * (4.8075954106507941e-5 * var_x333 / pow(var_x325, 3) + var_x336 * var_x338 * var_x96 - var_x335 * var_x336 * var_x95 * var_x98);
        IJth(rJacobian, 22, 0) = 80.0 * var_x365 * var_x368 - 0.14999999999999999 * var_x368 * var_x371;
        IJth(rJacobian, 23, 0) = -8.9372253111180233e-5 * var_x50 - 5.456580259819789e-6 * var_x93 - 0.00083053002891197785 * var_x74 - var_x379 * var_chaste_interface__INal__hL - var_x380 * var_chaste_interface__INa__H;
        IJth(rJacobian, 24, 0) = var_x390 + 5.5345498444215123e-8 * var_x87 + 5.9581502074120151e-5 * var_x50 + 7.4830755604969202e-6 * var_x61 - 1.6979725035533768e-7 * var_x2 - 3.137557887000805e-5 * var_x25 - 3.8963137158833531e-8 * var_x90 - 2.8394189022631718e-8 * var_x53 - var_x391 * var_chaste_interface__IKr__xr - var_x392 * var_chaste_interface__Ito__ydv2 - var_x393 * var_x84;
        IJth(rJacobian, 25, 0) = 1.3842167148532964e-8 + 3.3274959682366304e-9 * var_x88 - 3.3274959682366302e-7 * var_x58 + var_x400 * var_chaste_interface__Ito2__AA;
        IJth(rJacobian, 26, 0) = var_x404 * var_x412;
        IJth(rJacobian, 28, 0) = var_x429 * (-719.99999999999989 * var_x412 - 0.0036718475849305066 * var_x239 + var_x105 * var_x424 - var_x111 * var_x424);
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (18522000.0 * var_x117 + 0.057500000000000002 * var_x115 + 6.9055124202402519e-7 * var_x118 - 0.057500000000000002 * var_x113 - 1.3556015675697155e-8 * var_x123 - 0.0028824983370005666 * var_x116 - 6.2499999999999997e-8 * var_x119);
        IJth(rJacobian, 1, 1) = var_x162 * (-0.14705882352941174 + var_x180 - var_x163 - var_x177 + 3.8450464301480458e-12 * var_x119 + 1.768721357868101e-6 * var_x115 - 4.2483225407660435e-11 * var_x118 - 1139.4871996672337 * var_x117 - 8.8666719524733664e-8 * var_x116) + (0.00023800000000000004 / pow(var_x159, 3) + 7.0000000000000007e-5 / pow(var_x112, 3)) * (0.14705882352941174 * var_chaste_interface__Ca__Ca_ss + 2.3676470588235295e-5 * var_chaste_interface__Ca__Ca_nsr - 0.14705882352941174 * var_chaste_interface__Ca__Ca_i - var_x158 * var_chaste_interface__cell__V - var_x163 * var_chaste_interface__Ca__Ca_i - var_x177 * var_chaste_interface__Ca__Ca_i + 0.00027684334297065928 * var_x73 * var_x91) / pow(var_x160, 2);
        IJth(rJacobian, 23, 1) = 1.274496762229813e-10 * var_x118 + 3418.461599001701 * var_x117 - 1.1535139290444137e-11 * var_x119;
        IJth(rJacobian, 24, 1) = -8.3397615489392458e-13 * var_x123;
        IJth(rJacobian, 27, 1) = -var_x422 + 0.0043750000000000004 * var_x176;
        IJth(rJacobian, 28, 1) = 5.0 * var_x428;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x126 * var_x77);
        IJth(rJacobian, 2, 2) = -((var_x194) ? (0) : (0.13500000000000001 * var_x195)) - ((var_x194) ? (7.6923076923076916 / var_x197) : (310000.0 * var_x199 + 3.5600000000000001 * var_x198));
        IJth(rJacobian, 23, 2) = -var_x126 * var_x380;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-24.75 * var_x128);
        IJth(rJacobian, 3, 3) = var_x209;
        IJth(rJacobian, 23, 3) = -0.001522638386338626 * var_x128;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-8.25 * var_x129);
        IJth(rJacobian, 4, 4) = -((var_x194) ? (0) : (var_x216 * var_x217)) - ((var_x194) ? (0.29999999999999999 * var_x221) : (0.1212 * var_x225));
        IJth(rJacobian, 23, 4) = -0.00050754612877954204 * var_x129;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x130 * var_x131);
        IJth(rJacobian, 5, 5) = -var_x232;
        IJth(rJacobian, 8, 5) = var_x248 * var_x249;
        IJth(rJacobian, 9, 5) = var_x249 * var_x270 - var_x249 * var_x271;
        IJth(rJacobian, 21, 5) = var_x131 * var_x348;
        IJth(rJacobian, 22, 5) = var_x249 * var_x373 - var_x249 * var_x375;
        IJth(rJacobian, 28, 5) = -var_x249 * var_x430;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x130 * var_x132);
        IJth(rJacobian, 6, 6) = -0.10000000000000001;
        IJth(rJacobian, 8, 6) = var_x248 * var_x250;
        IJth(rJacobian, 9, 6) = var_x250 * var_x270 - var_x250 * var_x271;
        IJth(rJacobian, 21, 6) = var_x132 * var_x348;
        IJth(rJacobian, 22, 6) = var_x250 * var_x373 - var_x250 * var_x375;
        IJth(rJacobian, 28, 6) = -var_x250 * var_x430;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x134 * var_chaste_interface__ICaL__fca2);
        IJth(rJacobian, 7, 7) = -0.052900000000000003 - var_x237;
        IJth(rJacobian, 8, 7) = var_x248 * var_x252;
        IJth(rJacobian, 9, 7) = var_x252 * var_x270 - var_x252 * var_x271;
        IJth(rJacobian, 21, 7) = var_x335 * var_x349 / pow(var_chaste_interface__ICaL__f, 3);
        IJth(rJacobian, 22, 7) = var_x372 * var_x376 - var_x374 * var_x376;
        IJth(rJacobian, 28, 7) = -var_x252 * var_x430;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (-3.5108651860830804 * var_x135);
        IJth(rJacobian, 8, 8) = var_x243 * (-1 + var_x135 * var_x253);
        IJth(rJacobian, 9, 8) = var_x135 * var_x270 - var_x135 * var_x271;
        IJth(rJacobian, 21, 8) = var_x337 * var_x347 * var_x350 / pow(var_chaste_interface__ICaL__fca, 3);
        IJth(rJacobian, 22, 8) = var_x135 * var_x373 - var_x135 * var_x375;
        IJth(rJacobian, 28, 8) = -var_x135 * var_x430;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x134 * var_chaste_interface__ICaL__f);
        IJth(rJacobian, 8, 9) = var_x248 * var_x254;
        IJth(rJacobian, 9, 9) = var_x265 * (-1 + 0.0028483007663294996 * var_x254 * var_x266) - var_x254 * var_x271;
        IJth(rJacobian, 21, 9) = var_x330 * var_x351 / pow(var_chaste_interface__ICaL__fca2, 3);
        IJth(rJacobian, 22, 9) = var_x254 * var_x373 - var_x254 * var_x375;
        IJth(rJacobian, 28, 9) = -var_x254 * var_x430;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x100 * var_x136);
        IJth(rJacobian, 8, 10) = var_x248 * var_x255;
        IJth(rJacobian, 9, 10) = var_x255 * var_x270 - var_x255 * var_x271;
        IJth(rJacobian, 10, 10) = -0.0054000000000000003 - var_x272;
        IJth(rJacobian, 21, 10) = var_x332 * var_x351 / pow(var_chaste_interface__ICaL__f2, 3);
        IJth(rJacobian, 22, 10) = var_x255 * var_x373 - var_x255 * var_x375;
        IJth(rJacobian, 28, 10) = -var_x255 * var_x430;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x36 * var_x52);
        IJth(rJacobian, 11, 11) = -var_x283 - var_x284;
        IJth(rJacobian, 24, 11) = -var_x391 * var_x52;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (var_x121 * var_x31);
        IJth(rJacobian, 12, 12) = -var_x299 - var_x300;
        IJth(rJacobian, 24, 12) = var_x121 * var_x389;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x122 * var_x30);
        IJth(rJacobian, 13, 13) = -3.8050000000000003e-5 * var_x290 * var_x297 - 0.00018000000000000001 * var_x294 * var_x296;
        IJth(rJacobian, 24, 13) = var_x122 * var_x388;
        IJth(rJacobian, 0, 14) = mSetVoltageDerivativeToZero ? 0.0 : (-0.57000000000000006 * var_x138);
        IJth(rJacobian, 14, 14) = -25.0 * var_x305 - 25.0 * var_x309;
        IJth(rJacobian, 24, 14) = -3.5066823442950178e-5 * var_x138;
        IJth(rJacobian, 0, 15) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x52 * var_x81);
        IJth(rJacobian, 15, 15) = -0.029999999999999999 * var_x320 - 0.20000000000000001 * var_x316;
        IJth(rJacobian, 24, 15) = -var_x392 * var_x52;
        IJth(rJacobian, 0, 16) = mSetVoltageDerivativeToZero ? 0.0 : (-0.19 * var_x139);
        IJth(rJacobian, 16, 16) = -0.10000000000000001 * var_x316 - 0.0022499999999999998 * var_x320;
        IJth(rJacobian, 24, 16) = -1.1688941147650058e-5 * var_x139;
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x43 * var_chaste_interface__cell__V);
        IJth(rJacobian, 17, 17) = -1.0;
        IJth(rJacobian, 25, 17) = var_x400 * var_chaste_interface__cell__V;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0195 * var_x140);
        IJth(rJacobian, 18, 18) = var_x209;
        IJth(rJacobian, 23, 18) = -1.1996544862061903e-6 * var_x140;
        IJth(rJacobian, 0, 19) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x126 * var_x4);
        IJth(rJacobian, 19, 19) = -0.0016666666666666668;
        IJth(rJacobian, 23, 19) = -var_x126 * var_x379;
        IJth(rJacobian, 1, 20) = var_x162 * (-var_x180 * var_x187 - var_x185 * var_x186);
        IJth(rJacobian, 8, 20) = var_x256 * var_x257;
        IJth(rJacobian, 20, 20) = -0.00068000000000000005 - var_x169 * var_x324 + var_x164 * var_x181 * var_x324;
        IJth(rJacobian, 22, 20) = var_x377 * (var_x256 - var_x256 * var_x361);
        IJth(rJacobian, 27, 20) = var_x185 * var_x423 + var_x187 * var_x422;
        IJth(rJacobian, 21, 21) = -0.33333333333333331;
        IJth(rJacobian, 26, 21) = -var_x404 * var_x415;
        IJth(rJacobian, 28, 21) = var_x415 * var_x431;
        IJth(rJacobian, 22, 22) = -var_x364;
        IJth(rJacobian, 26, 22) = -var_x404 * var_x416;
        IJth(rJacobian, 28, 22) = var_x416 * var_x431;
        IJth(rJacobian, 0, 23) = mSetVoltageDerivativeToZero ? 0.0 : (2.6731217821876006e-12 * var_x143 + 3.9005476114801918 * var_x145 - 24.300000000000001 * var_x146 - 220.37679432037609 * var_x147 - 0.0096847826086956523 * var_x141 - 0.17363020158575085 * var_x142);
        IJth(rJacobian, 1, 23) = var_x162 * (0.0014949540520415602 * var_x146 - 1.6445243785522266e-16 * var_x143);
        IJth(rJacobian, 23, 23) = var_x386 + 4.9335731356566794e-16 * var_x143 - 1.7874450622236046e-6 * var_x141 - 1.068185898837083e-5 * var_x142 - 0.013557744100624516 * var_x147 - 0.0044848621561246801 * var_x146;
        IJth(rJacobian, 24, 23) = 3.9005476114801918 * var_x394 + 1.191630041482403e-6 * var_x141;
        IJth(rJacobian, 25, 23) = var_x386;
        IJth(rJacobian, 0, 24) = mSetVoltageDerivativeToZero ? 0.0 : (3.2491553184435085 * var_x153 + 212.79583259575517 * var_x145 - 0.37007808289373995 * var_x150 - 0.073726054827180365 * var_x148 - 5.0753443540450256 * var_x154 - 13.623292739805068 * var_x149 - var_x152 * var_x86);
        IJth(rJacobian, 24, 24) = var_x398 + 212.79583259575517 * var_x394 + 0.00019989044893084398 * var_x153 - 4.535681662754383e-6 * var_x148 - 0.00031223895504468581 * var_x154 - 2.2767478584105716e-5 * var_x150 - 0.0008381150898567882 * var_x149 - var_x152 * var_x393;
        IJth(rJacobian, 25, 24) = var_x398;
        IJth(rJacobian, 0, 25) = mSetVoltageDerivativeToZero ? 0.0 : (0.00601027620873753 * var_x155 - 0.001444800488100033 * var_x57);
        IJth(rJacobian, 23, 25) = var_x387;
        IJth(rJacobian, 24, 25) = var_x399;
        IJth(rJacobian, 25, 25) = var_x387 + var_x399 + 8.8885199344722979e-8 * var_x57 - 3.6975665728975948e-7 * var_x155;
        IJth(rJacobian, 21, 26) = -2.3414435371998602e-7 * var_x353 * pow(var_chaste_interface__Ca__Ca_jsr, 2.7999999999999998) + 0.6333333333333333 * var_x343 * var_x352 * pow(var_chaste_interface__Ca__Ca_jsr, 0.89999999999999991);
        IJth(rJacobian, 26, 26) = var_x419 * (-0.0083333333333333332 - var_x418) + 0.25 * (0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr - var_x409 * var_x418) / (pow(var_x401, 3) * pow((0.125 + var_x402), 2));
        IJth(rJacobian, 27, 26) = 0.00072463768115942019;
        IJth(rJacobian, 28, 26) = var_x428 * var_x432;
        IJth(rJacobian, 1, 27) = 2.3676470588235295e-5 * var_x161;
        IJth(rJacobian, 26, 27) = 0.0083333333333333332 * var_x403;
        IJth(rJacobian, 27, 27) = -0.0010163043478260869;
        IJth(rJacobian, 0, 28) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x136 * var_x157);
        IJth(rJacobian, 1, 28) = var_x162 * (0.14705882352941174 - var_x180 * var_x193 - var_x186 * var_x192);
        IJth(rJacobian, 8, 28) = var_x243 * (-0.0016500000000000002 * var_x258 + var_x253 * var_x259) + var_x257 * (var_x260 + 0.0030000000000000001 * var_x258);
        IJth(rJacobian, 9, 28) = var_x259 * var_x270 - var_x259 * var_x271;
        IJth(rJacobian, 17, 28) = 0.1502 * var_x188 / pow((1.0 + 0.1502 * var_x165), 2);
        IJth(rJacobian, 20, 28) = 3.7500000000000005e-6 * var_x169 * var_x189 + 1.8750000000000003e-7 * var_x188 * pow(var_x164, 2) / pow(var_x166, 3);
        IJth(rJacobian, 21, 28) = var_x329 * var_x338 * var_x347 * var_x95 - 0.00020267697647483301 * var_x165 * var_x339 * var_x340 * var_x342 * var_x353 * (1.8999999999999999 * var_x341 - 1.8999999999999999 * var_chaste_interface__Ca__Ca_ss / pow(var_x340, 2));
        IJth(rJacobian, 22, 28) = var_x377 * (var_x260 + var_x370 * (5000.0 - 3510.8651860830805 * var_x378) - var_x260 * var_x361) - 1.0 * var_x365 * (40000.0 - 18724.614325776431 * var_x378);
        IJth(rJacobian, 26, 28) = var_x419 * (var_x418 + 2106.5191116498486 * var_x420);
        IJth(rJacobian, 27, 28) = var_x192 * var_x423 + var_x193 * var_x422;
        IJth(rJacobian, 28, 28) = var_x429 * (-5.0 - var_x432 - 0.0036718475849305066 * var_x259 - 505.56458679596358 * var_x420) + (0.019557600000000001 / pow(var_x425, 3) + 8.1780000000000006e-5 / pow(var_x426, 3)) * (5.0 * var_chaste_interface__Ca__Ca_i - 5.0 * var_chaste_interface__Ca__Ca_ss - 0.0036718475849305066 * var_x244 + var_x409 * var_x432) / pow(var_x427, 2);
    }

    N_Vector Cellhund_rudy_2004_aFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__Environment__time;
        NV_Ith_S(dqs, 1) = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "hund_rudy_2004";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-85.781844107117);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012131666);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("INa__H");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.987317750543);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("INa__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("INa__J");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991924983076);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("ICaL__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.64013e-06);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("ICaL__dp");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.98230672628);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("ICaL__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999961508634);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("ICaL__fca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.97836624923);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("ICaL__fca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893052931249);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("ICaL__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.992234519148);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.24074e-06);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019883138161);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019890650554);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("Ito__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.013970786703);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("Ito__ydv2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99996472752);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("Ito__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.829206149767);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("Ito2__AA");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000816605172);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("INal__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("INal__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.26130711759);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("Irel__CaMKtrap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.021123704774);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("Irel__ro");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("Irel__ri");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.862666650318);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(12.972433387269);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(135.469546216758);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(15.59207157178);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("Ca__Ca_jsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.737580994071);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("Ca__Ca_nsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.832822335168);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("Ca__Ca_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012271265);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellhund_rudy_2004_aFromCellMLCvode)
#endif // CHASTE_CVODE
