#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: grandi2010
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "grandi2010ss.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellgrandi2010ssFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellgrandi2010ssFromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 37);
    }
    
    Cellgrandi2010ssFromCellMLCvode::Cellgrandi2010ssFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                38,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellgrandi2010ssFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 1.0; // (var_cell__G_CaL_mult) [dimensionless]
        NV_Ith_S(this->mParameters, 1) = 23.0; // (var_cell__GNa) [dimensionless]
        NV_Ith_S(this->mParameters, 2) = 1.0; // (var_cell__gkr_mult) [dimensionless]
    }

    Cellgrandi2010ssFromCellMLCvode::~Cellgrandi2010ssFromCellMLCvode()
    {
    }
    
    double Cellgrandi2010ssFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sNaj = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.000105614570409386
        
        const double var_cell__Cao = 1.8; // dimensionless
        const double var_cell__Cli = 15.0; // dimensionless
        const double var_cell__Clo = 150.0; // dimensionless
        const double var_cell__Fjunc = 0.11; // dimensionless
        const double var_cell__Fjunc_CaL = 0.90000000000000002; // dimensionless
        const double var_cell__Frdy = 96485.0; // dimensionless
        const double var_cell__Fsl = 1.0 - var_cell__Fjunc; // dimensionless
        const double var_cell__Fsl_CaL = 1.0 - var_cell__Fjunc_CaL; // dimensionless
        const double var_cell__GCaB = 0.00055130000000000001; // dimensionless
        const double var_cell__GClB = 0.0089999999999999993; // dimensionless
        const double var_cell__GClCa = 0.0548125; // dimensionless
        const double var_cell__GNaB = 0.00059699999999999998; // dimensionless
        const double var_cell__GtoFast = 0.1144; // dimensionless
        const double var_cell__GtoSlow = 0.015599999999999999; // dimensionless
        const double var_cell__IbarNCX = 4.5; // dimensionless
        const double var_cell__IbarNaK = 1.8; // dimensionless
        const double var_cell__IbarSLCaP = 0.067299999999999999; // dimensionless
        const double var_cell__KdClCa = 0.10000000000000001; // dimensionless
        const double var_cell__Kdact = 0.00014999999999999999; // dimensionless
        const double var_cell__KmCai = 0.0035899999999999999; // dimensionless
        const double var_cell__KmCao = 1.3; // dimensionless
        const double var_cell__KmKo = 1.5; // dimensionless
        const double var_cell__KmNai = 12.289999999999999; // dimensionless
        const double var_cell__KmNaip = 11.0; // dimensionless
        const double var_cell__KmNao = 87.5; // dimensionless
        const double var_cell__KmPCa = 0.00050000000000000001; // dimensionless
        const double var_cell__Ko = 5.4000000000000004; // dimensionless
        const double var_cell__Nao = 140.0; // dimensionless
        const double var_cell__Q10CaL = 1.8; // dimensionless
        const double var_cell__Q10NCX = 1.5700000000000001; // dimensionless
        const double var_cell__Q10SLCaP = 2.3500000000000001; // dimensionless
        const double var_cell__R = 8314.0; // dimensionless
        const double var_cell__Temp = 310.0; // dimensionless
        const double var_cell__FoRT = var_cell__Frdy / (var_cell__R * var_cell__Temp); // dimensionless
        const double var_cell__Qpow = -31.0 + 0.10000000000000001 * var_cell__Temp; // dimensionless
        const double var_cell__ecl = log(var_cell__Cli / var_cell__Clo) / var_cell__FoRT; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__gkp = 0.002; // dimensionless
        const double var_cell__gkr = 0.015061601901917734 * sqrt(var_cell__Ko) * NV_Ith_S(mParameters, 2); // dimensionless
        const double var_cell__gks_junc = 0.0035000000000000001; // dimensionless
        const double var_cell__gks_sl = 0.0035000000000000001; // dimensionless
        const double var_cell__ksat = 0.32000000000000001; // dimensionless
        const double var_cell__nu = 0.27000000000000002; // dimensionless
        const double var_cell__pCa = 0.00027 * NV_Ith_S(mParameters, 0); // dimensionless
        const double var_cell__pK = 1.35e-7 * NV_Ith_S(mParameters, 0); // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * NV_Ith_S(mParameters, 0); // dimensionless
        const double var_cell__pNaK = 0.018329999999999999; // dimensionless
        const double var_cell__I_pca_junc = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) * var_cell__Fjunc * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_junc = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCaj, 2)); // dimensionless
        const double var_cell__eca_junc = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCaj) / var_cell__FoRT; // dimensionless
        const double var_cell__I_pca_sl = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) * var_cell__Fsl * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_sl = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCasl, 2)); // dimensionless
        const double var_cell__eca_sl = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCasl) / var_cell__FoRT; // dimensionless
        const double var_cell__sKi = 120.0; // dimensionless
        const double var_cell__ek = log(var_cell__Ko / var_cell__sKi) / var_cell__FoRT; // dimensionless
        const double var_cell__eks = log((var_cell__Nao * var_cell__pNaK + var_cell__Ko) / (var_cell__pNaK * var_chaste_interface__cell__sNai + var_cell__sKi)) / var_cell__FoRT; // dimensionless
        const double var_cell__ena_junc = log(var_cell__Nao / var_chaste_interface__cell__sNaj) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCaj / var_cell__KmCai) * var_chaste_interface__cell__sCaj + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNaj, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__ena_sl = log(var_cell__Nao / var_chaste_interface__cell__sNasl) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCasl / var_cell__KmCai) * var_chaste_interface__cell__sCasl + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNasl, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__I_ClCa_junc = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCaj); // dimensionless
        const double var_cell__I_ClCa_sl = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCasl); // dimensionless
        const double var_cell__I_ClCa = var_cell__I_ClCa_junc + var_cell__I_ClCa_sl; // dimensionless
        const double var_cell__I_Clbk = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__GClB; // dimensionless
        const double var_cell__I_Cl_tot = var_cell__I_ClCa + var_cell__I_Clbk; // dimensionless
        const double var_cell__I_cabk_junc = (-var_cell__eca_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GCaB; // dimensionless
        const double var_cell__I_cabk_sl = (-var_cell__eca_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GCaB; // dimensionless
        const double var_cell__I_nabk_junc = (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GNaB; // dimensionless
        const double var_cell__I_nabk_sl = (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GNaB; // dimensionless
        const double var_cell__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__sVm - 0.23849999999999999 * var_cell__ek)); // dimensionless
        const double var_cell__bki = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__sVm - 0.080320000000000003 * var_cell__ek) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__sVm - 0.061749999999999999 * var_cell__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_cell__ek - 0.51429999999999998 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_j = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_sl = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibark = (-0.75 * var_cell__Ko + 0.75 * var_cell__sKi * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pK * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_j = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNaj * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_sl = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNasl * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__kiss = var_cell__aki / (var_cell__aki + var_cell__bki); // dimensionless
        const double var_cell__I_ki = 0.15061601901917732 * sqrt(var_cell__Ko) * (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__kiss; // dimensionless
        const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_kp_junc = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gkp * var_cell__kp_kp; // dimensionless
        const double var_cell__I_kp_sl = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gkp * var_cell__kp_kp; // dimensionless
        const double var_cell__I_kp = var_cell__I_kp_junc + var_cell__I_kp_sl; // dimensionless
        const double var_cell__rkr = 1 / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__s1_junc = pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s1_sl = pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s2_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_junc = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_junc + var_cell__s1_junc) * var_cell__Fjunc * var_cell__IbarNCX * var_cell__Ka_junc / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_junc); // dimensionless
        const double var_cell__s2_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_sl = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_sl + var_cell__s1_sl) * var_cell__Fsl * var_cell__IbarNCX * var_cell__Ka_sl / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_sl); // dimensionless
        const double var_cell__I_CaNa_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarna_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarca_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_junc = -2.0 * var_cell__I_ncx_junc + var_cell__I_Ca_junc + var_cell__I_cabk_junc + var_cell__I_pca_junc; // dimensionless
        const double var_cell__I_CaK = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * ((1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL + (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL) * var_cell__ibark * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_CaNa_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarna_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarca_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_sl = -2.0 * var_cell__I_ncx_sl + var_cell__I_Ca_sl + var_cell__I_cabk_sl + var_cell__I_pca_sl; // dimensionless
        const double var_cell__I_Ca_tot = var_cell__I_Ca_tot_junc + var_cell__I_Ca_tot_sl; // dimensionless
        const double var_cell__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_cell__Nao); // dimensionless
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_cell__FoRT * var_chaste_interface__cell__sVm) + 0.036499999999999998 * var_cell__sigma * exp(-var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = var_cell__Fjunc * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNaj, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak_sl = var_cell__Fsl * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNasl, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak = var_cell__I_nak_junc + var_cell__I_nak_sl; // dimensionless
        const double var_cell__I_Na_junc = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_sl = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_tot_junc = 3.0 * var_cell__I_nak_junc + 3.0 * var_cell__I_ncx_junc + var_cell__I_CaNa_junc + var_cell__I_Na_junc + var_cell__I_nabk_junc; // dimensionless
        const double var_cell__I_Na_tot_sl = 3.0 * var_cell__I_nak_sl + 3.0 * var_cell__I_ncx_sl + var_cell__I_CaNa_sl + var_cell__I_Na_sl + var_cell__I_nabk_sl; // dimensionless
        const double var_cell__I_Na_tot = var_cell__I_Na_tot_junc + var_cell__I_Na_tot_sl; // dimensionless
        const double var_cell__I_kr = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__gkr * var_cell__rkr * var_chaste_interface__cell__sxkr; // dimensionless
        const double var_cell__I_ks_junc = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gks_junc; // dimensionless
        const double var_cell__I_ks_sl = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gks_sl; // dimensionless
        const double var_cell__I_ks = var_cell__I_ks_junc + var_cell__I_ks_sl; // dimensionless
        const double var_cell__I_tof = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoFast * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof; // dimensionless
        const double var_cell__I_tos = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoSlow * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos; // dimensionless
        const double var_cell__I_to = var_cell__I_tof + var_cell__I_tos; // dimensionless
        const double var_cell__I_K_tot = -2.0 * var_cell__I_nak + var_cell__I_CaK + var_cell__I_ki + var_cell__I_kp + var_cell__I_kr + var_cell__I_ks + var_cell__I_to; // dimensionless
        const double var_cell__I_tot = var_cell__I_Ca_tot + var_cell__I_Cl_tot + var_cell__I_K_tot + var_cell__I_Na_tot; // uA_per_uF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_cell__I_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellgrandi2010ssFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__cell__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sRyRr = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.893326456705696
        double var_chaste_interface__cell__sRyRo = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 7.56436968249499e-07
        double var_chaste_interface__cell__sRyRi = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 9.03266331737064e-08
        double var_chaste_interface__cell__sNaBj = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 3.41097946062695
        double var_chaste_interface__cell__sNaBsl = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.744248540671373
        double var_chaste_interface__cell__sTnCL = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.00904644567707666
        double var_chaste_interface__cell__sTnCHc = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.1183943202639
        double var_chaste_interface__cell__sTnCHm = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0101423649465603
        double var_chaste_interface__cell__sCaM = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.000299824763475116
        double var_chaste_interface__cell__sMyoc = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 0.00201443980536826
        double var_chaste_interface__cell__sMyom = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.137467597337588
        double var_chaste_interface__cell__sSRB = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.00220110816535249
        double var_chaste_interface__cell__sSLLj = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.00739549938515031
        double var_chaste_interface__cell__sSLLsl = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.00979616077807075
        double var_chaste_interface__cell__sSLHj = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.0735225248399363
        double var_chaste_interface__cell__sSLHsl = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.113642236788144
        double var_chaste_interface__cell__sCsqnb = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 1.20762712858574
        double var_chaste_interface__cell__sCa_sr = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.563755421404699
        double var_chaste_interface__cell__sNaj = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.000105614570409386
        double var_chaste_interface__cell__sCai = NV_Ith_S(rY, 37);
        // Units: dimensionless; Initial value: 8.85230799863012e-05

        // Mathematics
        double d_dt_chaste_interface_var_cell__sVm;
        const double var_cell__Bmax_CaM = 0.024; // dimensionless
        const double var_cell__Bmax_Naj = 7.5609999999999999; // dimensionless
        const double var_cell__Bmax_Nasl = 1.6499999999999999; // dimensionless
        const double var_cell__Bmax_SR = 0.017100000000000001; // dimensionless
        const double var_cell__Bmax_TnChigh = 0.14000000000000001; // dimensionless
        const double var_cell__Bmax_TnClow = 0.070000000000000007; // dimensionless
        const double var_cell__Bmax_myosin = 0.14000000000000001; // dimensionless
        const double var_cell__Cao = 1.8; // dimensionless
        const double var_cell__Cmem = 1.3809999999999999e-10; // dimensionless
        const double var_cell__Fjunc = 0.11; // dimensionless
        const double var_cell__Fjunc_CaL = 0.90000000000000002; // dimensionless
        const double var_cell__Frdy = 96485.0; // dimensionless
        const double var_cell__Fsl = 1.0 - var_cell__Fjunc; // dimensionless
        const double var_cell__Fsl_CaL = 1.0 - var_cell__Fjunc_CaL; // dimensionless
        const double var_cell__GCaB = 0.00055130000000000001; // dimensionless
        const double var_cell__GNaB = 0.00059699999999999998; // dimensionless
        const double var_cell__IbarNCX = 4.5; // dimensionless
        const double var_cell__IbarNaK = 1.8; // dimensionless
        const double var_cell__IbarSLCaP = 0.067299999999999999; // dimensionless
        const double var_cell__J_ca_juncsl = 8.2413054227789685e-13; // dimensionless
        const double var_cell__J_ca_slmyo = 3.7242560798480505e-12; // dimensionless
        const double var_cell__J_na_juncsl = 1.8312782322060799e-14; // dimensionless
        const double var_cell__J_na_slmyo = 1.6386279222197945e-12; // dimensionless
        const double var_cell__Kdact = 0.00014999999999999999; // dimensionless
        const double var_cell__KmCai = 0.0035899999999999999; // dimensionless
        const double var_cell__KmCao = 1.3; // dimensionless
        const double var_cell__KmKo = 1.5; // dimensionless
        const double var_cell__KmNai = 12.289999999999999; // dimensionless
        const double var_cell__KmNaip = 11.0; // dimensionless
        const double var_cell__KmNao = 87.5; // dimensionless
        const double var_cell__KmPCa = 0.00050000000000000001; // dimensionless
        const double var_cell__Kmf = 0.00024600000000000002; // dimensionless
        const double var_cell__Kmr = 1.7; // dimensionless
        const double var_cell__Ko = 5.4000000000000004; // dimensionless
        const double var_cell__MaxSR = 15.0; // dimensionless
        const double var_cell__Mgi = 1.0; // dimensionless
        const double var_cell__MinSR = 1.0; // dimensionless
        const double var_cell__Nao = 140.0; // dimensionless
        const double var_cell__Q10CaL = 1.8; // dimensionless
        const double var_cell__Q10NCX = 1.5700000000000001; // dimensionless
        const double var_cell__Q10SLCaP = 2.3500000000000001; // dimensionless
        const double var_cell__Q10SRCaP = 2.6000000000000001; // dimensionless
        const double var_cell__R = 8314.0; // dimensionless
        const double var_cell__Temp = 310.0; // dimensionless
        const double var_cell__FoRT = var_cell__Frdy / (var_cell__R * var_cell__Temp); // dimensionless
        const double var_cell__Qpow = -31.0 + 0.10000000000000001 * var_cell__Temp; // dimensionless
        const double var_cell__Vmax_SRCaP = 0.0053114; // dimensionless
        const double var_cell__cellLength = 100.0; // dimensionless
        const double var_cell__cellRadius = 10.25; // dimensionless
        const double var_cell__Vcell = 1.0000000000000001e-15 * M_PI * pow(var_cell__cellRadius, 2) * var_cell__cellLength; // dimensionless
        const double var_cell__Vjunc = 0.00053900000000000009 * var_cell__Vcell; // dimensionless
        const double var_cell__Vmyo = 0.65000000000000002 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_SLhighj = 0.000165 * var_cell__Vmyo / var_cell__Vjunc; // dimensionless
        const double var_cell__Bmax_SLlowj = 0.00046000000000000001 * var_cell__Vmyo / var_cell__Vjunc; // dimensionless
        const double var_cell__Vsl = 0.02 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_SLhighsl = 0.0134 * var_cell__Vmyo / var_cell__Vsl; // dimensionless
        const double var_cell__Bmax_SLlowsl = 0.037400000000000003 * var_cell__Vmyo / var_cell__Vsl; // dimensionless
        const double var_cell__Vsr = 0.035000000000000003 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_Csqn = 0.14000000000000001 * var_cell__Vmyo / var_cell__Vsr; // dimensionless
        const double var_cell__ec50SR = 0.45000000000000001; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__hillSRCaP = 1.7869999999999999; // dimensionless
        const double var_cell__kiCa = 0.5; // dimensionless
        const double var_cell__kim = 0.0050000000000000001; // dimensionless
        const double var_cell__koCa = 10.0; // dimensionless
        const double var_cell__koff_cam = 0.23799999999999999; // dimensionless
        const double var_cell__koff_csqn = 65.0; // dimensionless
        const double var_cell__koff_myoca = 0.00046000000000000001; // dimensionless
        const double var_cell__koff_myomg = 5.7000000000000003e-5; // dimensionless
        const double var_cell__koff_na = 0.001; // dimensionless
        const double var_cell__koff_slh = 0.029999999999999999; // dimensionless
        const double var_cell__koff_sll = 1.3; // dimensionless
        const double var_cell__koff_sr = 0.059999999999999998; // dimensionless
        const double var_cell__koff_tnchca = 3.1999999999999999e-5; // dimensionless
        const double var_cell__koff_tnchmg = 0.0033300000000000001; // dimensionless
        const double var_cell__koff_tncl = 0.019599999999999999; // dimensionless
        const double var_cell__kom = 0.059999999999999998; // dimensionless
        const double var_cell__kon_cam = 34.0; // dimensionless
        const double var_cell__kon_csqn = 100.0; // dimensionless
        const double var_cell__kon_myoca = 13.800000000000001; // dimensionless
        const double var_cell__kon_myomg = 0.015699999999999999; // dimensionless
        const double var_cell__kon_na = 0.0001; // dimensionless
        const double var_cell__kon_slh = 100.0; // dimensionless
        const double var_cell__kon_sll = 100.0; // dimensionless
        const double var_cell__kon_sr = 100.0; // dimensionless
        const double var_cell__kon_tnchca = 2.3700000000000001; // dimensionless
        const double var_cell__kon_tnchmg = 0.0030000000000000001; // dimensionless
        const double var_cell__kon_tncl = 32.700000000000003; // dimensionless
        const double var_cell__ks = 25.0; // dimensionless
        const double var_cell__ksat = 0.32000000000000001; // dimensionless
        const double var_cell__nu = 0.27000000000000002; // dimensionless
        const double var_cell__pCa = 0.00027 * NV_Ith_S(mParameters, 0); // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * NV_Ith_S(mParameters, 0); // dimensionless
        const double var_cell__kCaSR = -(-var_cell__MinSR + var_cell__MaxSR) / (1.0 + pow((var_cell__ec50SR / var_chaste_interface__cell__sCa_sr), 2.5)) + var_cell__MaxSR; // dimensionless
        const double var_cell__kiSRCa = var_cell__kCaSR * var_cell__kiCa; // dimensionless
        const double var_cell__koSRCa = var_cell__koCa / var_cell__kCaSR; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaM = -var_cell__koff_cam * var_chaste_interface__cell__sCaM + (-var_chaste_interface__cell__sCaM + var_cell__Bmax_CaM) * var_cell__kon_cam * var_chaste_interface__cell__sCai; // 1 / ms
        const double var_cell__J_serca = pow(var_cell__Q10SRCaP, var_cell__Qpow) * (pow((var_chaste_interface__cell__sCai / var_cell__Kmf), var_cell__hillSRCaP) - pow((var_chaste_interface__cell__sCa_sr / var_cell__Kmr), var_cell__hillSRCaP)) * var_cell__Vmax_SRCaP / (1.0 + pow((var_chaste_interface__cell__sCai / var_cell__Kmf), var_cell__hillSRCaP) + pow((var_chaste_interface__cell__sCa_sr / var_cell__Kmr), var_cell__hillSRCaP)); // dimensionless
        const double var_cell__I_pca_junc = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) * var_cell__Fjunc * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)); // dimensionless
        const double var_cell__J_SRleak = 5.3480000000000003e-6 * var_chaste_interface__cell__sCa_sr - 5.3480000000000003e-6 * var_chaste_interface__cell__sCaj; // dimensionless
        const double var_cell__Ka_junc = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCaj, 2)); // dimensionless
        const double var_cell__eca_junc = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCaj) / var_cell__FoRT; // dimensionless
        const double var_cell__I_pca_sl = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) * var_cell__Fsl * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_sl = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCasl, 2)); // dimensionless
        const double var_cell__eca_sl = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCasl) / var_cell__FoRT; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCsqnb = -var_cell__koff_csqn * var_chaste_interface__cell__sCsqnb + (-var_chaste_interface__cell__sCsqnb + var_cell__Bmax_Csqn) * var_cell__kon_csqn * var_chaste_interface__cell__sCa_sr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyoc = -var_cell__koff_myoca * var_chaste_interface__cell__sMyoc + (-var_chaste_interface__cell__sMyoc - var_chaste_interface__cell__sMyom + var_cell__Bmax_myosin) * var_cell__kon_myoca * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyom = -var_cell__koff_myomg * var_chaste_interface__cell__sMyom + (-var_chaste_interface__cell__sMyoc - var_chaste_interface__cell__sMyom + var_cell__Bmax_myosin) * var_cell__Mgi * var_cell__kon_myomg; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNaBj = -var_cell__koff_na * var_chaste_interface__cell__sNaBj + (-var_chaste_interface__cell__sNaBj + var_cell__Bmax_Naj) * var_cell__kon_na * var_chaste_interface__cell__sNaj; // 1 / ms
        const double var_cell__ena_junc = log(var_cell__Nao / var_chaste_interface__cell__sNaj) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCaj / var_cell__KmCai) * var_chaste_interface__cell__sCaj + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNaj, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaBsl = -var_cell__koff_na * var_chaste_interface__cell__sNaBsl + (-var_chaste_interface__cell__sNaBsl + var_cell__Bmax_Nasl) * var_cell__kon_na * var_chaste_interface__cell__sNasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNai = (-var_chaste_interface__cell__sNai + var_chaste_interface__cell__sNasl) * var_cell__J_na_slmyo / var_cell__Vmyo; // 1 / ms
        const double var_cell__ena_sl = log(var_cell__Nao / var_chaste_interface__cell__sNasl) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCasl / var_cell__KmCai) * var_chaste_interface__cell__sCasl + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNasl, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__J_SRCarel = (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCa_sr) * var_cell__ks * var_chaste_interface__cell__sRyRo; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCa_sr = -d_dt_chaste_interface_var_cell__sCsqnb - var_cell__J_SRCarel - var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vsr + var_cell__J_serca; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRo = var_cell__kim * var_chaste_interface__cell__sRyRi - var_cell__kom * var_chaste_interface__cell__sRyRo + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double var_cell__RI = 1.0 - var_chaste_interface__cell__sRyRi - var_chaste_interface__cell__sRyRo - var_chaste_interface__cell__sRyRr; // dimensionless
        const double d_dt_chaste_interface_var_cell__sRyRi = -var_cell__kim * var_chaste_interface__cell__sRyRi - var_cell__kom * var_chaste_interface__cell__sRyRi + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__RI * var_cell__koSRCa + var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRr = var_cell__RI * var_cell__kim + var_cell__kom * var_chaste_interface__cell__sRyRo - pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHj = -var_cell__koff_slh * var_chaste_interface__cell__sSLHj + (-var_chaste_interface__cell__sSLHj + var_cell__Bmax_SLhighj) * var_cell__kon_slh * var_chaste_interface__cell__sCaj; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHsl = -var_cell__koff_slh * var_chaste_interface__cell__sSLHsl + (-var_chaste_interface__cell__sSLHsl + var_cell__Bmax_SLhighsl) * var_cell__kon_slh * var_chaste_interface__cell__sCasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLLj = -var_cell__koff_sll * var_chaste_interface__cell__sSLLj + (-var_chaste_interface__cell__sSLLj + var_cell__Bmax_SLlowj) * var_cell__kon_sll * var_chaste_interface__cell__sCaj; // 1 / ms
        const double var_cell__J_CaB_junction = d_dt_chaste_interface_var_cell__sSLHj + d_dt_chaste_interface_var_cell__sSLLj; // dimensionless
        const double d_dt_chaste_interface_var_cell__sSLLsl = -var_cell__koff_sll * var_chaste_interface__cell__sSLLsl + (-var_chaste_interface__cell__sSLLsl + var_cell__Bmax_SLlowsl) * var_cell__kon_sll * var_chaste_interface__cell__sCasl; // 1 / ms
        const double var_cell__J_CaB_sl = d_dt_chaste_interface_var_cell__sSLHsl + d_dt_chaste_interface_var_cell__sSLLsl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sSRB = -var_cell__koff_sr * var_chaste_interface__cell__sSRB + (-var_chaste_interface__cell__sSRB + var_cell__Bmax_SR) * var_cell__kon_sr * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHc = -var_cell__koff_tnchca * var_chaste_interface__cell__sTnCHc + (-var_chaste_interface__cell__sTnCHc - var_chaste_interface__cell__sTnCHm + var_cell__Bmax_TnChigh) * var_cell__kon_tnchca * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHm = -var_cell__koff_tnchmg * var_chaste_interface__cell__sTnCHm + (-var_chaste_interface__cell__sTnCHc - var_chaste_interface__cell__sTnCHm + var_cell__Bmax_TnChigh) * var_cell__Mgi * var_cell__kon_tnchmg; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCL = -var_cell__koff_tncl * var_chaste_interface__cell__sTnCL + (-var_chaste_interface__cell__sTnCL + var_cell__Bmax_TnClow) * var_cell__kon_tncl * var_chaste_interface__cell__sCai; // 1 / ms
        const double var_cell__J_CaB_cytosol = d_dt_chaste_interface_var_cell__sCaM + d_dt_chaste_interface_var_cell__sMyoc + d_dt_chaste_interface_var_cell__sMyom + d_dt_chaste_interface_var_cell__sSRB + d_dt_chaste_interface_var_cell__sTnCHc + d_dt_chaste_interface_var_cell__sTnCHm + d_dt_chaste_interface_var_cell__sTnCL; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCai = -var_cell__J_CaB_cytosol + (-var_chaste_interface__cell__sCai + var_chaste_interface__cell__sCasl) * var_cell__J_ca_slmyo / var_cell__Vmyo - var_cell__J_serca * var_cell__Vsr / var_cell__Vmyo; // 1 / ms
        const double var_cell__I_cabk_junc = (-var_cell__eca_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GCaB; // dimensionless
        const double var_cell__I_cabk_sl = (-var_cell__eca_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GCaB; // dimensionless
        const double var_cell__I_nabk_junc = (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GNaB; // dimensionless
        const double var_cell__I_nabk_sl = (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GNaB; // dimensionless
        const double var_cell__ah = ((var_chaste_interface__cell__sVm >= -40.0) ? (0) : (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__aj = ((var_chaste_interface__cell__sVm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__sVm) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__cell__sVm) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__cell__sVm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__sVm)))); // dimensionless
        const double var_cell__bh = ((var_chaste_interface__cell__sVm >= -40.0) ? (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__sVm))) : (310000.0 * exp(0.34849999999999998 * var_chaste_interface__cell__sVm) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__bj = ((var_chaste_interface__cell__sVm >= -40.0) ? (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__cell__sVm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__sVm))) : (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__cell__sVm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__sVm)))); // dimensionless
        const double var_cell__dss = 1 / (1.0 + exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__fss = 1 / (1.0 + exp(3.8888888888888888 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__hss = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__ibarca_j = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_sl = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_j = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNaj * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_sl = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNasl * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__jss = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__mss = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__s1_junc = pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s1_sl = pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s2_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_junc = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_junc + var_cell__s1_junc) * var_cell__Fjunc * var_cell__IbarNCX * var_cell__Ka_junc / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_junc); // dimensionless
        const double var_cell__s2_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_sl = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_sl + var_cell__s1_sl) * var_cell__Fsl * var_cell__IbarNCX * var_cell__Ka_sl / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_sl); // dimensionless
        const double d_dt_chaste_interface_var_cell__sfcaBj = -0.011900000000000001 * var_chaste_interface__cell__sfcaBj + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBj) * var_chaste_interface__cell__sCaj; // 1 / ms
        const double var_cell__I_CaNa_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarna_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarca_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_junc = -2.0 * var_cell__I_ncx_junc + var_cell__I_Ca_junc + var_cell__I_cabk_junc + var_cell__I_pca_junc; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaj = -var_cell__J_CaB_junction + (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCasl) * var_cell__J_ca_juncsl / var_cell__Vjunc + var_cell__J_SRCarel * var_cell__Vsr / var_cell__Vjunc + var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vjunc - 0.5 * var_cell__Cmem * var_cell__I_Ca_tot_junc / (var_cell__Frdy * var_cell__Vjunc); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sfcaBsl = -0.011900000000000001 * var_chaste_interface__cell__sfcaBsl + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBsl) * var_chaste_interface__cell__sCasl; // 1 / ms
        const double var_cell__I_CaNa_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarna_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarca_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_sl = -2.0 * var_cell__I_ncx_sl + var_cell__I_Ca_sl + var_cell__I_cabk_sl + var_cell__I_pca_sl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCasl = -var_cell__J_CaB_sl + (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCai) * var_cell__J_ca_slmyo / var_cell__Vsl + (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCaj) * var_cell__J_ca_juncsl / var_cell__Vsl - 0.5 * var_cell__Cmem * var_cell__I_Ca_tot_sl / (var_cell__Frdy * var_cell__Vsl); // 1 / ms
        const double var_cell__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_cell__Nao); // dimensionless
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_cell__FoRT * var_chaste_interface__cell__sVm) + 0.036499999999999998 * var_cell__sigma * exp(-var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = var_cell__Fjunc * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNaj, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak_sl = var_cell__Fsl * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNasl, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_Na_junc = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_sl = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_tot_junc = 3.0 * var_cell__I_nak_junc + 3.0 * var_cell__I_ncx_junc + var_cell__I_CaNa_junc + var_cell__I_Na_junc + var_cell__I_nabk_junc; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaj = -d_dt_chaste_interface_var_cell__sNaBj + (-var_chaste_interface__cell__sNaj + var_chaste_interface__cell__sNasl) * var_cell__J_na_juncsl / var_cell__Vjunc - var_cell__Cmem * var_cell__I_Na_tot_junc / (var_cell__Frdy * var_cell__Vjunc); // 1 / ms
        const double var_cell__I_Na_tot_sl = 3.0 * var_cell__I_nak_sl + 3.0 * var_cell__I_ncx_sl + var_cell__I_CaNa_sl + var_cell__I_Na_sl + var_cell__I_nabk_sl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNasl = -d_dt_chaste_interface_var_cell__sNaBsl + (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNai) * var_cell__J_na_slmyo / var_cell__Vsl + (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNaj) * var_cell__J_na_juncsl / var_cell__Vsl - var_cell__Cmem * var_cell__I_Na_tot_sl / (var_cell__Frdy * var_cell__Vsl); // 1 / ms
        const double var_cell__taud = 28.571428571428569 * (1.0 - exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)) * var_cell__dss / (5.0 + var_chaste_interface__cell__sVm); // dimensionless
        const double d_dt_chaste_interface_var_cell__sd = (-var_chaste_interface__cell__sd + var_cell__dss) / var_cell__taud; // 1 / ms
        const double var_cell__tauf = 1 / (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__sVm), 2))); // dimensionless
        const double d_dt_chaste_interface_var_cell__sf = (-var_chaste_interface__cell__sf + var_cell__fss) / var_cell__tauf; // 1 / ms
        const double var_cell__tauh = 1 / (var_cell__ah + var_cell__bh); // dimensionless
        const double d_dt_chaste_interface_var_cell__sh = (-var_chaste_interface__cell__sh + var_cell__hss) / var_cell__tauh; // 1 / ms
        const double var_cell__tauj = 1 / (var_cell__aj + var_cell__bj); // dimensionless
        const double d_dt_chaste_interface_var_cell__sj = (-var_chaste_interface__cell__sj + var_cell__jss) / var_cell__tauj; // 1 / ms
        const double var_cell__taum = 0.12920000000000001 * exp(-8.682389366752302 * pow((1 + 0.021838829438742085 * var_chaste_interface__cell__sVm), 2)) + 0.064869999999999997 * exp(-0.0089012876052174655 * pow((-1 + 0.2073398299813394 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sm = (-var_chaste_interface__cell__sm + var_cell__mss) / var_cell__taum; // 1 / ms
        const double var_cell__tauxr = 230.0 / (1.0 + exp(2.0 + 0.050000000000000003 * var_chaste_interface__cell__sVm)) + 3300.0 / ((1.0 + exp(1.2222222222222223 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) * (1.0 + exp(-2.4444444444444446 - 0.1111111111111111 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__tauxs = 990.10000000000002 / (1.0 + exp(-0.17252124645892353 - 0.070821529745042494 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__tauxtof = 0.5 + 8.5 * exp(-0.81000000000000005 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double var_cell__tauxtos = 0.5 + 9.0 / (1.0 + exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__tauytof = 7.0 + 85.0 * exp(-7.2727272727272725 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double var_cell__tauytos = 30.0 + 800.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__xrss = 1 / (1.0 + exp(-2.0 - 0.20000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sxkr = (-var_chaste_interface__cell__sxkr + var_cell__xrss) / var_cell__tauxr; // 1 / ms
        const double var_cell__xsss = 1 / (1.0 + exp(-0.26666666666666666 - 0.070175438596491224 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sxks = (-var_chaste_interface__cell__sxks + var_cell__xsss) / var_cell__tauxs; // 1 / ms
        const double var_cell__xtoss = 1 / (1.0 + exp(1.4615384615384615 - 0.076923076923076927 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sxtof = (-var_chaste_interface__cell__sxtof + var_cell__xtoss) / var_cell__tauxtof; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sxtos = (-var_chaste_interface__cell__sxtos + var_cell__xtoss) / var_cell__tauxtos; // 1 / ms
        const double var_cell__ytoss = 1 / (1.0 + exp(3.8999999999999999 + 0.20000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sytof = (-var_chaste_interface__cell__sytof + var_cell__ytoss) / var_cell__tauytof; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sytos = (-var_chaste_interface__cell__sytos + var_cell__ytoss) / var_cell__tauytos; // 1 / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__sVm = 0.0;
        }
        else
        {
            const double var_cell__Cli = 15.0; // dimensionless
            const double var_cell__Clo = 150.0; // dimensionless
            const double var_cell__GClB = 0.0089999999999999993; // dimensionless
            const double var_cell__GClCa = 0.0548125; // dimensionless
            const double var_cell__GtoFast = 0.1144; // dimensionless
            const double var_cell__GtoSlow = 0.015599999999999999; // dimensionless
            const double var_cell__KdClCa = 0.10000000000000001; // dimensionless
            const double var_cell__ecl = log(var_cell__Cli / var_cell__Clo) / var_cell__FoRT; // dimensionless
            const double var_cell__gkp = 0.002; // dimensionless
            const double var_cell__gkr = 0.015061601901917734 * sqrt(var_cell__Ko) * NV_Ith_S(mParameters, 2); // dimensionless
            const double var_cell__gks_junc = 0.0035000000000000001; // dimensionless
            const double var_cell__gks_sl = 0.0035000000000000001; // dimensionless
            const double var_cell__pK = 1.35e-7 * NV_Ith_S(mParameters, 0); // dimensionless
            const double var_cell__pNaK = 0.018329999999999999; // dimensionless
            const double var_cell__sKi = 120.0; // dimensionless
            const double var_cell__ek = log(var_cell__Ko / var_cell__sKi) / var_cell__FoRT; // dimensionless
            const double var_cell__eks = log((var_cell__Nao * var_cell__pNaK + var_cell__Ko) / (var_cell__pNaK * var_chaste_interface__cell__sNai + var_cell__sKi)) / var_cell__FoRT; // dimensionless
            const double var_cell__I_ClCa_junc = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCaj); // dimensionless
            const double var_cell__I_ClCa_sl = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCasl); // dimensionless
            const double var_cell__I_ClCa = var_cell__I_ClCa_junc + var_cell__I_ClCa_sl; // dimensionless
            const double var_cell__I_Clbk = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__GClB; // dimensionless
            const double var_cell__I_Cl_tot = var_cell__I_ClCa + var_cell__I_Clbk; // dimensionless
            const double var_cell__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__sVm - 0.23849999999999999 * var_cell__ek)); // dimensionless
            const double var_cell__bki = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__sVm - 0.080320000000000003 * var_cell__ek) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__sVm - 0.061749999999999999 * var_cell__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_cell__ek - 0.51429999999999998 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__ibark = (-0.75 * var_cell__Ko + 0.75 * var_cell__sKi * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pK * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__kiss = var_cell__aki / (var_cell__aki + var_cell__bki); // dimensionless
            const double var_cell__I_ki = 0.15061601901917732 * sqrt(var_cell__Ko) * (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__kiss; // dimensionless
            const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__I_kp_junc = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gkp * var_cell__kp_kp; // dimensionless
            const double var_cell__I_kp_sl = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gkp * var_cell__kp_kp; // dimensionless
            const double var_cell__I_kp = var_cell__I_kp_junc + var_cell__I_kp_sl; // dimensionless
            const double var_cell__rkr = 1 / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__I_CaK = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * ((1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL + (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL) * var_cell__ibark * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
            const double var_cell__I_Ca_tot = var_cell__I_Ca_tot_junc + var_cell__I_Ca_tot_sl; // dimensionless
            const double var_cell__I_nak = var_cell__I_nak_junc + var_cell__I_nak_sl; // dimensionless
            const double var_cell__I_Na_tot = var_cell__I_Na_tot_junc + var_cell__I_Na_tot_sl; // dimensionless
            const double var_cell__I_kr = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__gkr * var_cell__rkr * var_chaste_interface__cell__sxkr; // dimensionless
            const double var_cell__I_ks_junc = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gks_junc; // dimensionless
            const double var_cell__I_ks_sl = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gks_sl; // dimensionless
            const double var_cell__I_ks = var_cell__I_ks_junc + var_cell__I_ks_sl; // dimensionless
            const double var_cell__I_tof = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoFast * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof; // dimensionless
            const double var_cell__I_tos = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoSlow * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos; // dimensionless
            const double var_cell__I_to = var_cell__I_tof + var_cell__I_tos; // dimensionless
            const double var_cell__I_K_tot = -2.0 * var_cell__I_nak + var_cell__I_CaK + var_cell__I_ki + var_cell__I_kp + var_cell__I_kr + var_cell__I_ks + var_cell__I_to; // dimensionless
            const double var_cell__I_tot = var_cell__I_Ca_tot + var_cell__I_Cl_tot + var_cell__I_K_tot + var_cell__I_Na_tot; // uA_per_uF
            const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__cell__time); // uA_per_cm2
            const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
            d_dt_chaste_interface_var_cell__sVm = -var_cell__I_tot - var_cell__i_Stim; // millivolt / ms
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_cell__sVm;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_cell__sm;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_cell__sh;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_cell__sj;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_cell__sd;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_cell__sf;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_cell__sfcaBj;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_cell__sfcaBsl;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_cell__sxtos;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_cell__sytos;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_cell__sxtof;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_cell__sytof;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_cell__sxkr;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_cell__sxks;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_cell__sRyRr;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_cell__sRyRo;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_cell__sRyRi;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_cell__sNaBj;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_cell__sNaBsl;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_cell__sTnCL;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_cell__sTnCHc;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_cell__sTnCHm;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_cell__sCaM;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_cell__sMyoc;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_cell__sMyom;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_cell__sSRB;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_cell__sSLLj;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_cell__sSLLsl;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_cell__sSLHj;
        NV_Ith_S(rDY,29) = d_dt_chaste_interface_var_cell__sSLHsl;
        NV_Ith_S(rDY,30) = d_dt_chaste_interface_var_cell__sCsqnb;
        NV_Ith_S(rDY,31) = d_dt_chaste_interface_var_cell__sCa_sr;
        NV_Ith_S(rDY,32) = d_dt_chaste_interface_var_cell__sNaj;
        NV_Ith_S(rDY,33) = d_dt_chaste_interface_var_cell__sNasl;
        NV_Ith_S(rDY,34) = d_dt_chaste_interface_var_cell__sNai;
        NV_Ith_S(rDY,35) = d_dt_chaste_interface_var_cell__sCaj;
        NV_Ith_S(rDY,36) = d_dt_chaste_interface_var_cell__sCasl;
        NV_Ith_S(rDY,37) = d_dt_chaste_interface_var_cell__sCai;
    }

    void Cellgrandi2010ssFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__cell__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sRyRr = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.893326456705696
        double var_chaste_interface__cell__sRyRo = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 7.56436968249499e-07
        double var_chaste_interface__cell__sRyRi = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 9.03266331737064e-08
        double var_chaste_interface__cell__sNaBj = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 3.41097946062695
        double var_chaste_interface__cell__sNaBsl = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.744248540671373
        double var_chaste_interface__cell__sTnCL = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.00904644567707666
        double var_chaste_interface__cell__sTnCHc = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.1183943202639
        double var_chaste_interface__cell__sTnCHm = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0101423649465603
        double var_chaste_interface__cell__sCaM = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.000299824763475116
        double var_chaste_interface__cell__sMyoc = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 0.00201443980536826
        double var_chaste_interface__cell__sMyom = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.137467597337588
        double var_chaste_interface__cell__sSRB = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.00220110816535249
        double var_chaste_interface__cell__sSLLj = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.00739549938515031
        double var_chaste_interface__cell__sSLLsl = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.00979616077807075
        double var_chaste_interface__cell__sSLHj = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.0735225248399363
        double var_chaste_interface__cell__sSLHsl = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.113642236788144
        double var_chaste_interface__cell__sCsqnb = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 1.20762712858574
        double var_chaste_interface__cell__sCa_sr = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.563755421404699
        double var_chaste_interface__cell__sNaj = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.000105614570409386
        double var_chaste_interface__cell__sCai = NV_Ith_S(rY, 37);
        // Units: dimensionless; Initial value: 8.85230799863012e-05
        
        const double var_x0 = exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm);
        const double var_x1 = 1.0 + var_x0;
        const double var_x2 = pow(var_chaste_interface__cell__sxks, 2);
        const double var_x3 = 1 / var_chaste_interface__cell__sCaj;
        const double var_x4 = 1.0 + 0.10000000000000001 * var_x3;
        const double var_x5 = 1 / var_chaste_interface__cell__sCasl;
        const double var_x6 = 1.0 + 0.10000000000000001 * var_x5;
        const double var_x7 = exp(5.6339521648111468 + 0.23849999999999999 * var_chaste_interface__cell__sVm);
        const double var_x8 = 1.0 + var_x7;
        const double var_x9 = 1 / var_x8;
        const double var_x10 = exp(-45.047763776781437 - 0.51429999999999998 * var_chaste_interface__cell__sVm);
        const double var_x11 = 1.0 + var_x10;
        const double var_x12 = 1 / var_x11;
        const double var_x13 = exp(7.0933355765099853 + 0.080320000000000003 * var_chaste_interface__cell__sVm);
        const double var_x14 = exp(-31.583430521794174 + 0.061749999999999999 * var_chaste_interface__cell__sVm);
        const double var_x15 = var_x14 + 0.49124000000000001 * var_x13;
        const double var_x16 = var_x12 * var_x15;
        const double var_x17 = 1 / (var_x16 + 1.02 * var_x9);
        const double var_x18 = NV_Ith_S(mParameters, 2) * var_chaste_interface__cell__sxkr;
        const double var_x19 = exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm);
        const double var_x20 = 1.0 + var_x19;
        const double var_x21 = 0.035000000000000003 / var_x20;
        const double var_x22 = 82.837440942604388 + var_chaste_interface__cell__sVm;
        const double var_x23 = pow(var_chaste_interface__cell__sNaj, (-4));
        const double var_x24 = exp(-0.003743588350780262 * var_chaste_interface__cell__sVm);
        const double var_x25 = exp(2.0802377414561666);
        const double var_x26 = 0.037435883507802616 * var_chaste_interface__cell__sVm;
        const double var_x27 = exp(-var_x26);
        const double var_x28 = 1.0 + 0.1245 * var_x24 + 0.036499999999999998 * var_x27 * (-0.14285714285714285 + 0.14285714285714285 * var_x25);
        const double var_x29 = (0.00046607674967214262 * var_x24 + 0.037435883507802616 * var_x27 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x25)) / pow(var_x28, 2);
        const double var_x30 = var_x29 / (1.0 + 14641.0 * var_x23);
        const double var_x31 = pow(var_chaste_interface__cell__sNasl, (-4));
        const double var_x32 = var_x29 / (1.0 + 14641.0 * var_x31);
        const double var_x33 = var_x7 / pow(var_x8, 2);
        const double var_x34 = pow(var_chaste_interface__cell__sm, 3);
        const double var_x35 = var_x34 * NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sj;
        const double var_x36 = var_x35 * var_chaste_interface__cell__sh;
        const double var_x37 = exp(-0.027328194960695912 * var_chaste_interface__cell__sVm);
        const double var_x38 = 74988.56697214958 * var_x37;
        const double var_x39 = pow(var_chaste_interface__cell__sNaj, 3);
        const double var_x40 = exp(0.010107688547106707 * var_chaste_interface__cell__sVm);
        const double var_x41 = 0.018193839384792073 * var_x40;
        const double var_x42 = 1.0 + 0.32000000000000001 * var_x37;
        const double var_x43 = 1 / var_x42;
        const double var_x44 = pow(var_chaste_interface__cell__sCaj, 2);
        const double var_x45 = 1 / var_x44;
        const double var_x46 = 1.0 + 2.2499999999999996e-8 * var_x45;
        const double var_x47 = 1 / var_x46;
        const double var_x48 = 2744000.0 * var_chaste_interface__cell__sCaj;
        const double var_x49 = (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCaj) * var_chaste_interface__cell__sCaj;
        const double var_x50 = 1 / (9850.9599999999991 + var_x48 + 669921.875 * var_x49 + 8.4066800865219591 * var_x39);
        const double var_x51 = var_x47 * var_x50;
        const double var_x52 = var_x43 * var_x51;
        const double var_x53 = var_x52 * (var_x38 * var_chaste_interface__cell__sCaj + var_x39 * var_x41);
        const double var_x54 = pow(var_chaste_interface__cell__sNasl, 3);
        const double var_x55 = pow(var_chaste_interface__cell__sCasl, (-2));
        const double var_x56 = 1.0 + 2.2499999999999996e-8 * var_x55;
        const double var_x57 = 1 / var_x56;
        const double var_x58 = 2744000.0 * var_chaste_interface__cell__sCasl;
        const double var_x59 = (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCasl) * var_chaste_interface__cell__sCasl;
        const double var_x60 = 1 / (9850.9599999999991 + var_x58 + 669921.875 * var_x59 + 8.4066800865219591 * var_x54);
        const double var_x61 = var_x57 * var_x60;
        const double var_x62 = var_x43 * var_x61;
        const double var_x63 = var_x62 * (var_x38 * var_chaste_interface__cell__sCasl + var_x41 * var_x54);
        const double var_x64 = 1.8 * var_x40;
        const double var_x65 = var_x39 * var_x64 - var_x37 * var_x48;
        const double var_x66 = var_x37 / pow(var_x42, 2);
        const double var_x67 = var_x51 * var_x65 * var_x66;
        const double var_x68 = var_x54 * var_x64 - var_x37 * var_x58;
        const double var_x69 = var_x61 * var_x66 * var_x68;
        const double var_x70 = 1.0 - var_chaste_interface__cell__sfcaBsl;
        const double var_x71 = exp(var_x26);
        const double var_x72 = -1.0 + var_x71;
        const double var_x73 = 1 / var_x72;
        const double var_x74 = NV_Ith_S(mParameters, 0) * var_chaste_interface__cell__sf;
        const double var_x75 = var_x74 * var_chaste_interface__cell__sd;
        const double var_x76 = var_x73 * var_x75;
        const double var_x77 = var_x70 * var_x76;
        const double var_x78 = 0.75 * var_x71;
        const double var_x79 = -105.0 + var_x78 * var_chaste_interface__cell__sNasl;
        const double var_x80 = 1.2190504118344879e-6 * var_x79;
        const double var_x81 = var_x77 * var_x80;
        const double var_x82 = 1.0 - var_chaste_interface__cell__sfcaBj;
        const double var_x83 = var_x76 * var_x82;
        const double var_x84 = -105.0 + var_x78 * var_chaste_interface__cell__sNaj;
        const double var_x85 = 1.0971453706510394e-5 * var_x84;
        const double var_x86 = var_x83 * var_x85;
        const double var_x87 = exp(0.074871767015605231 * var_chaste_interface__cell__sVm);
        const double var_x88 = -1.0 + var_x87;
        const double var_x89 = 1 / var_x88;
        const double var_x90 = var_x75 * var_x89;
        const double var_x91 = var_x82 * var_x90;
        const double var_x92 = 0.34100000000000003 * var_x87;
        const double var_x93 = -0.61380000000000001 + var_x92 * var_chaste_interface__cell__sCaj;
        const double var_x94 = 1.5798893337374968 * var_x93;
        const double var_x95 = var_x91 * var_x94;
        const double var_x96 = var_x70 * var_x90;
        const double var_x97 = -0.61380000000000001 + var_x92 * var_chaste_interface__cell__sCasl;
        const double var_x98 = 0.17554325930416628 * var_x97;
        const double var_x99 = var_x96 * var_x98;
        const double var_x100 = -4.0500000000000007 + 90.0 * var_x71;
        const double var_x101 = var_x100 * var_x76;
        const double var_x102 = 1.0 - 0.099999999999999978 * var_chaste_interface__cell__sfcaBsl - 0.90000000000000002 * var_chaste_interface__cell__sfcaBj;
        const double var_x103 = 0.0002194290741302079 * var_x102;
        const double var_x104 = var_x76 * var_chaste_interface__cell__sVm;
        const double var_x105 = var_x102 * var_x71;
        const double var_x106 = var_x82 * var_x84;
        const double var_x107 = var_x71 * var_chaste_interface__cell__sVm;
        const double var_x108 = var_x75 / pow(var_x72, 2);
        const double var_x109 = var_x107 * var_x108;
        const double var_x110 = 4.1072606286817238e-7 * var_x106 * var_x109;
        const double var_x111 = 4.5636229207574697e-8 * var_x109 * var_x70 * var_x79;
        const double var_x112 = var_x87 * var_chaste_interface__cell__sVm;
        const double var_x113 = var_x112 * var_x75 / pow(var_x88, 2);
        const double var_x114 = 0.013143234011781513 * var_x113 * var_x70 * var_x97;
        const double var_x115 = var_x82 * var_x93;
        const double var_x116 = 0.11828910610603366 * var_x113 * var_x115;
        const double var_x117 = var_x107 * var_x77;
        const double var_x118 = 3.4227171905681023e-8 * var_x117 * var_chaste_interface__cell__sNasl;
        const double var_x119 = var_x112 * var_x96;
        const double var_x120 = 0.0044818427980174965 * var_x119 * var_chaste_interface__cell__sCasl;
        const double var_x121 = var_x112 * var_x91;
        const double var_x122 = 0.040336585182157478 * var_x121 * var_chaste_interface__cell__sCaj;
        const double var_x123 = var_x107 * var_x83;
        const double var_x124 = 3.0804454715112929e-7 * var_x123 * var_chaste_interface__cell__sNaj;
        const double var_x125 = 1 / var_chaste_interface__cell__sNaj;
        const double var_x126 = -26.712338705498265 * log(140.0 * var_x125) + var_chaste_interface__cell__sVm;
        const double var_x127 = NV_Ith_S(mParameters, 1) * var_chaste_interface__cell__sh;
        const double var_x128 = var_x127 * pow(var_chaste_interface__cell__sm, 2) * var_chaste_interface__cell__sj;
        const double var_x129 = var_x126 * var_x128;
        const double var_x130 = 1 / var_chaste_interface__cell__sNasl;
        const double var_x131 = -26.712338705498265 * log(140.0 * var_x130) + var_chaste_interface__cell__sVm;
        const double var_x132 = var_x128 * var_x131;
        const double var_x133 = 0.11 * var_x126;
        const double var_x134 = 0.89000000000000001 * var_x131;
        const double var_x135 = var_x127 * var_x34;
        const double var_x136 = var_x74 * var_chaste_interface__cell__sVm;
        const double var_x137 = var_x136 * var_x73;
        const double var_x138 = var_x70 * var_x80;
        const double var_x139 = var_x82 * var_x85;
        const double var_x140 = var_x136 * var_x89;
        const double var_x141 = var_x82 * var_x94;
        const double var_x142 = var_x70 * var_x98;
        const double var_x143 = var_x100 * var_x103;
        const double var_x144 = NV_Ith_S(mParameters, 0) * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd;
        const double var_x145 = var_x144 * var_x73;
        const double var_x146 = var_x144 * var_x89;
        const double var_x147 = var_x90 * var_chaste_interface__cell__sVm;
        const double var_x148 = var_x101 * var_chaste_interface__cell__sVm;
        const double var_x149 = -1.2922640787046284 - 0.015599999999999999 * var_chaste_interface__cell__sVm;
        const double var_x150 = -9.4766032438339423 - 0.1144 * var_chaste_interface__cell__sVm;
        const double var_x151 = 0.001754199282790071 * var_x125;
        const double var_x152 = 1 / var_x28;
        const double var_x153 = var_x152 / (pow((6.8301345536507063e-5 + var_x23), 2) * pow(var_chaste_interface__cell__sNaj, 5));
        const double var_x154 = pow(var_chaste_interface__cell__sNaj, 2);
        const double var_x155 = var_x43 * var_x65;
        const double var_x156 = var_x155 * var_x47 / pow((0.0035899999999999999 + 0.244140625 * var_x49 + 3.0636589236596063e-6 * var_x39 + var_chaste_interface__cell__sCaj), 2);
        const double var_x157 = var_x154 * var_x156;
        const double var_x158 = var_x154 * var_x40 * var_x52;
        const double var_x159 = 2.9383572576048089 * var_x125 * var_x36;
        const double var_x160 = 8.228590279882795e-6 * var_x123;
        const double var_x161 = 0.014193066924392391 * var_x130;
        const double var_x162 = var_x152 / (pow((6.8301345536507063e-5 + var_x31), 2) * pow(var_chaste_interface__cell__sNasl, 5));
        const double var_x163 = pow(var_chaste_interface__cell__sNasl, 2);
        const double var_x164 = var_x43 * var_x68;
        const double var_x165 = var_x164 * var_x57 / pow((0.0035899999999999999 + 0.244140625 * var_x59 + 3.0636589236596063e-6 * var_x54 + var_chaste_interface__cell__sCasl), 2);
        const double var_x166 = var_x163 * var_x165;
        const double var_x167 = 23.773981447893455 * var_x130 * var_x36;
        const double var_x168 = var_x163 * var_x40 * var_x62;
        const double var_x169 = 9.1428780887586595e-7 * var_x117;
        const double var_x170 = 0.00080995817805876559 * var_x3;
        const double var_x171 = 5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001);
        const double var_x172 = 0.011844800000000001 * pow(var_chaste_interface__cell__sCaj, 2.2000000000000002) / pow(var_x171, 2);
        const double var_x173 = 0.011844800000000001 * pow(var_chaste_interface__cell__sCaj, 0.60000000000000009) / var_x171;
        const double var_x174 = 61.507432902288166 + var_chaste_interface__cell__sVm;
        const double var_x175 = var_x37 * var_x52;
        const double var_x176 = var_x156 * (-3413921.875 - 373215529.24791086 * var_chaste_interface__cell__sCaj);
        const double var_x177 = var_x155 * var_x50 / (pow(var_x46, 2) * pow(var_chaste_interface__cell__sCaj, 3));
        const double var_x178 = 0.53874226280448645 * var_x121;
        const double var_x179 = 0.0065532979861118307 * var_x5;
        const double var_x180 = 5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001);
        const double var_x181 = 0.095835200000000009 * pow(var_chaste_interface__cell__sCasl, 2.2000000000000002) / pow(var_x180, 2);
        const double var_x182 = 0.095835200000000009 * pow(var_chaste_interface__cell__sCasl, 0.60000000000000009) / var_x180;
        const double var_x183 = var_x37 * var_x62;
        const double var_x184 = var_x165 * (-3413921.875 - 373215529.24791086 * var_chaste_interface__cell__sCasl);
        const double var_x185 = var_x164 * var_x60 / (pow(var_x56, 2) * pow(var_chaste_interface__cell__sCasl, 3));
        const double var_x186 = 0.059860251422720709 * var_x119;
        const double var_x187 = exp(-0.0089012876052174655 * pow((-1 + 0.2073398299813394 * var_chaste_interface__cell__sVm), 2));
        const double var_x188 = exp(-8.682389366752302 * pow((1 + 0.021838829438742085 * var_chaste_interface__cell__sVm), 2));
        const double var_x189 = exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__sVm);
        const double var_x190 = 1.0 + var_x189;
        const double var_x191 = 0.12920000000000001 * var_x188;
        const double var_x192 = 0.064869999999999997 * var_x187;
        const double var_x193 = 1 / (var_x191 + var_x192);
        const double var_x194 = exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm);
        const double var_x195 = 1.0 + var_x194;
        const double var_x196 = 1 / pow(var_x195, 2);
        const double var_x197 = var_chaste_interface__cell__sVm >= -40.0;
        const double var_x198 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__sVm);
        const double var_x199 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__sVm);
        const double var_x200 = 1.0 + var_x199;
        const double var_x201 = exp(0.34849999999999998 * var_chaste_interface__cell__sVm);
        const double var_x202 = exp(0.079000000000000001 * var_chaste_interface__cell__sVm);
        const double var_x203 = ((var_x197) ? (0) : (0.057000000000000002 * var_x198));
        const double var_x204 = ((var_x197) ? (5.9230769230769234 / var_x200) : (310000.0 * var_x201 + 2.7000000000000002 * var_x202));
        const double var_x205 = 0.26917900403768508 * var_x194 / pow(var_x195, 3);
        const double var_x206 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__sVm);
        const double var_x207 = 1.0 + var_x206;
        const double var_x208 = 1 / var_x207;
        const double var_x209 = exp(0.24440000000000001 * var_chaste_interface__cell__sVm);
        const double var_x210 = exp(-0.043909999999999998 * var_chaste_interface__cell__sVm);
        const double var_x211 = -25428.0 * var_x209 - 6.9480000000000002e-6 * var_x210;
        const double var_x212 = var_x208 * var_x211;
        const double var_x213 = 37.780000000000001 + var_chaste_interface__cell__sVm;
        const double var_x214 = exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__sVm);
        const double var_x215 = 1.0 + var_x214;
        const double var_x216 = exp(0.057000000000000002 * var_chaste_interface__cell__sVm);
        const double var_x217 = var_x216 / var_x215;
        const double var_x218 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__sVm);
        const double var_x219 = 1.0 + var_x218;
        const double var_x220 = exp(-0.01052 * var_chaste_interface__cell__sVm);
        const double var_x221 = var_x220 / var_x219;
        const double var_x222 = ((var_x197) ? (0) : (var_x212 * var_x213));
        const double var_x223 = ((var_x197) ? (0.59999999999999998 * var_x217) : (0.024240000000000001 * var_x221));
        const double var_x224 = exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm);
        const double var_x225 = 1.0 - var_x224;
        const double var_x226 = 1 / var_x225;
        const double var_x227 = 1.0 + var_x224;
        const double var_x228 = 1 / var_x227;
        const double var_x229 = -var_chaste_interface__cell__sd + var_x228;
        const double var_x230 = var_x226 * var_x229;
        const double var_x231 = 0.035000000000000003 * var_x227;
        const double var_x232 = 5.0 + var_chaste_interface__cell__sVm;
        const double var_x233 = var_x226 * var_x232;
        const double var_x234 = 0.0058333333333333336 * var_x224;
        const double var_x235 = var_x232 * var_x234;
        const double var_x236 = 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__sVm), 2));
        const double var_x237 = 0.050000000000000003 * var_chaste_interface__cell__sVm;
        const double var_x238 = exp(2.5 - var_x237);
        const double var_x239 = 1.0 + var_x238;
        const double var_x240 = 0.1111111111111111 * var_chaste_interface__cell__sVm;
        const double var_x241 = exp(3.8888888888888888 + var_x240);
        const double var_x242 = 1.0 + var_x241;
        const double var_x243 = exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__sVm);
        const double var_x244 = 1.0 + var_x243;
        const double var_x245 = 1 / var_x244;
        const double var_x246 = 1 / (0.5 + 9.0 * var_x245);
        const double var_x247 = exp(1.4615384615384615 - 0.076923076923076927 * var_chaste_interface__cell__sVm);
        const double var_x248 = 1.0 + var_x247;
        const double var_x249 = 0.076923076923076927 * var_x247 / pow(var_x248, 2);
        const double var_x250 = 1 / var_x248;
        const double var_x251 = exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__sVm);
        const double var_x252 = 1.0 + var_x251;
        const double var_x253 = 1 / var_x252;
        const double var_x254 = 1 / (30.0 + 800.0 * var_x253);
        const double var_x255 = 0.20000000000000001 * var_chaste_interface__cell__sVm;
        const double var_x256 = exp(3.8999999999999999 + var_x255);
        const double var_x257 = 1.0 + var_x256;
        const double var_x258 = 0.20000000000000001 * var_x256 / pow(var_x257, 2);
        const double var_x259 = 1 / var_x257;
        const double var_x260 = exp(-0.81000000000000005 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__sVm), 2));
        const double var_x261 = 1 / (0.5 + 8.5 * var_x260);
        const double var_x262 = exp(-7.2727272727272725 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__sVm), 2));
        const double var_x263 = 1 / (7.0 + 85.0 * var_x262);
        const double var_x264 = exp(2.0 + var_x237);
        const double var_x265 = 1.0 + var_x264;
        const double var_x266 = 1 / var_x265;
        const double var_x267 = exp(1.2222222222222223 + var_x240);
        const double var_x268 = 1.0 + var_x267;
        const double var_x269 = 1 / var_x268;
        const double var_x270 = exp(-2.4444444444444446 - var_x240);
        const double var_x271 = 1.0 + var_x270;
        const double var_x272 = 1 / var_x271;
        const double var_x273 = var_x269 * var_x272;
        const double var_x274 = exp(-2.0 - var_x255);
        const double var_x275 = 1.0 + var_x274;
        const double var_x276 = 1 / (230.0 * var_x266 + 3300.0 * var_x273);
        const double var_x277 = exp(-0.26666666666666666 - 0.070175438596491224 * var_chaste_interface__cell__sVm);
        const double var_x278 = 1.0 + var_x277;
        const double var_x279 = exp(-0.17252124645892353 - 0.070821529745042494 * var_chaste_interface__cell__sVm);
        const double var_x280 = 0.00100999899000101 * var_x279;
        const double var_x281 = 1 / var_chaste_interface__cell__sCa_sr;
        const double var_x282 = pow(var_x281, 2.5);
        const double var_x283 = 1.0 + 0.13584112963311223 * var_x282;
        const double var_x284 = 1 / var_x283;
        const double var_x285 = 7.0 * var_x284;
        const double var_x286 = -7.5 + var_x285;
        const double var_x287 = var_x286 * var_chaste_interface__cell__sCaj;
        const double var_x288 = 1 / (15.0 - 14.0 * var_x284);
        const double var_x289 = 10.0 * var_x288 * var_x44;
        const double var_x290 = -var_x289;
        const double var_x291 = var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRr;
        const double var_x292 = var_x281 * var_x282 / pow(var_x283, 2);
        const double var_x293 = 2.3772197685794643 * var_x292;
        const double var_x294 = 0.21130842387373014 * var_x292 * var_x44 / pow((1 - 0.93333333333333335 * var_x284), 2);
        const double var_x295 = var_x294 * var_chaste_interface__cell__sRyRr;
        const double var_x296 = 20.0 * var_x288;
        const double var_x297 = var_x291 * var_x296;
        const double var_x298 = var_x293 * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo;
        const double var_x299 = 7.5 - var_x285;
        const double var_x300 = 1.0 - var_chaste_interface__cell__sRyRi - var_chaste_interface__cell__sRyRo - var_chaste_interface__cell__sRyRr;
        const double var_x301 = 0.0001 * var_chaste_interface__cell__sNaj;
        const double var_x302 = 0.0001 * var_chaste_interface__cell__sNaBj;
        const double var_x303 = 0.0001 * var_chaste_interface__cell__sNasl;
        const double var_x304 = 0.0001 * var_chaste_interface__cell__sNaBsl;
        const double var_x305 = 32.700000000000003 * var_chaste_interface__cell__sCai;
        const double var_x306 = 32.700000000000003 * var_chaste_interface__cell__sTnCL;
        const double var_x307 = 2.3700000000000001 * var_chaste_interface__cell__sCai;
        const double var_x308 = -var_x307;
        const double var_x309 = 2.3700000000000001 * var_chaste_interface__cell__sTnCHc;
        const double var_x310 = 2.3700000000000001 * var_chaste_interface__cell__sTnCHm;
        const double var_x311 = 34.0 * var_chaste_interface__cell__sCai;
        const double var_x312 = 34.0 * var_chaste_interface__cell__sCaM;
        const double var_x313 = 13.800000000000001 * var_chaste_interface__cell__sCai;
        const double var_x314 = -var_x313;
        const double var_x315 = 13.800000000000001 * var_chaste_interface__cell__sMyoc;
        const double var_x316 = 13.800000000000001 * var_chaste_interface__cell__sMyom;
        const double var_x317 = 100.0 * var_chaste_interface__cell__sCai;
        const double var_x318 = 100.0 * var_chaste_interface__cell__sSRB;
        const double var_x319 = 100.0 * var_chaste_interface__cell__sCaj;
        const double var_x320 = -var_x319;
        const double var_x321 = 100.0 * var_chaste_interface__cell__sSLLj;
        const double var_x322 = 100.0 * var_chaste_interface__cell__sCasl;
        const double var_x323 = -var_x322;
        const double var_x324 = 100.0 * var_chaste_interface__cell__sSLLsl;
        const double var_x325 = 100.0 * var_chaste_interface__cell__sSLHj;
        const double var_x326 = 100.0 * var_chaste_interface__cell__sSLHsl;
        const double var_x327 = 100.0 * var_chaste_interface__cell__sCa_sr;
        const double var_x328 = 100.0 * var_chaste_interface__cell__sCsqnb;
        const double var_x329 = 25.0 * var_chaste_interface__cell__sRyRo;
        const double var_x330 = pow(var_chaste_interface__cell__sCa_sr, 1.7869999999999999);
        const double var_x331 = 0.38742512113256738 * var_x330;
        const double var_x332 = pow(var_chaste_interface__cell__sCai, 1.7869999999999999);
        const double var_x333 = 2814485.1633595936 * var_x332;
        const double var_x334 = 1 / (1.0 + var_x331 + var_x333);
        const double var_x335 = pow(var_chaste_interface__cell__sCa_sr, 0.78699999999999992);
        const double var_x336 = var_x334 * var_x335;
        const double var_x337 = (var_x333 - var_x331) / pow((3.5530476870814998e-7 + var_x332 + 1.3765399305573384e-7 * var_x330), 2);
        const double var_x338 = var_x335 * var_x337;
        const double var_x339 = pow(var_chaste_interface__cell__sCai, 0.78699999999999992);
        const double var_x340 = var_x334 * var_x339;
        const double var_x341 = var_x337 * var_x339;
        const double var_x342 = 1 / M_PI;
        const double var_x343 = 0.25275361828036119 * var_x342;
        const double var_x344 = var_x342 * var_x35;
        const double var_x345 = 0.027802898010839731 * var_x126;
        const double var_x346 = var_x135 * var_x342;
        const double var_x347 = var_x137 * var_x342;
        const double var_x348 = 2.7730746221159819e-6 * var_x106;
        const double var_x349 = var_x145 * var_x342;
        const double var_x350 = var_x104 * var_x342;
        const double var_x351 = 3.2338348512952546 * var_x342;
        const double var_x352 = 0.0068117100126557344 * var_x342;
        const double var_x353 = 0.0060624219112636038 * var_x131;
        const double var_x354 = 8.3038178962250779e-9 * var_x79;
        const double var_x355 = var_x354 * var_x70;
        const double var_x356 = 0.23994917636495411 * var_x342;
        const double var_x357 = 0.1263768091401806 * var_x342;
        const double var_x358 = var_x140 * var_x342;
        const double var_x359 = 0.19966137279235072 * var_x115;
        const double var_x360 = var_x146 * var_x342;
        const double var_x361 = var_x147 * var_x342;
        const double var_x362 = 1623.3766233766235 * var_chaste_interface__cell__sRyRo;
        const double var_x363 = 145.53234034920845 * var_x342;
        const double var_x364 = 0.0034058550063278672 * var_x342;
        const double var_x365 = 0.00059787488852820563 * var_x97;
        const double var_x366 = var_x365 * var_x70;
        const double var_x367 = 0.54535393106272634 * var_x342;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.010148299999999999 + var_x110 + var_x111 + var_x114 + var_x116 - var_x118 - var_x120 - var_x122 - var_x124 - var_x81 - var_x86 - var_x95 - var_x99 - 1.0 * var_x36 - 0.002 / var_x1 - 0.0035000000000000001 * var_x2 - 0.495 * var_x53 - 0.15495652173913044 * var_x30 - 1.2537391304347827 * var_x32 - 0.006029375 / var_x4 - 4.0049999999999999 * var_x63 - 0.0043287860817742326 * var_x67 - 0.035023814661627878 * var_x69 - 0.048783124999999997 / var_x6 - var_x101 * var_x103 - var_x18 * var_x21 - 0.1144 * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof - 0.015599999999999999 * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos - 0.35699999999999998 * var_x17 * var_x9 - 0.00073930691316271028 * var_x104 * var_x105 + 0.085144499999999998 * var_x17 * var_x22 * var_x33 - 0.00033444816053511704 * var_x0 * var_x22 / pow(var_x1, 2) + 8.2145212573634477e-6 * var_x100 * var_x105 * var_x108 * var_chaste_interface__cell__sVm + 0.0014583333333333334 * var_x18 * var_x19 * var_x22 / pow(var_x20, 2) - 0.34313725490196073 * var_x22 * var_x9 * (0.24326999999999999 * var_x33 - var_x12 * (0.061749999999999999 * var_x14 + 0.039456396800000001 * var_x13) - 0.51429999999999998 * var_x10 * var_x15 / pow(var_x11, 2)) / pow((var_x9 + 0.98039215686274506 * var_x16), 2));
        IJth(rJacobian, 1, 0) = 59.906641489902128 * (-var_chaste_interface__cell__sm + 1 / pow(var_x190, 2)) * (-var_x191 * (-0.3792264410025028 - 0.0082818615637148471 * var_chaste_interface__cell__sVm) - var_x192 * (0.0036911829173615863 - 0.00076532923851577563 * var_chaste_interface__cell__sVm)) / pow((var_x188 + 0.5020897832817337 * var_x187), 2) + 0.22148394241417499 * var_x189 * var_x193 / pow(var_x190, 3);
        IJth(rJacobian, 2, 0) = (var_x196 - var_chaste_interface__cell__sh) * (((var_x197) ? (0) : (-0.008382352941176471 * var_x198)) + ((var_x197) ? (0.53361053361053368 * var_x199 / pow(var_x200, 2)) : (108035.0 * var_x201 + 0.21330000000000002 * var_x202))) - var_x205 * (var_x203 + var_x204);
        IJth(rJacobian, 3, 0) = (var_x196 - var_chaste_interface__cell__sj) * (((var_x197) ? (0) : (var_x212 + var_x208 * var_x213 * (3.0508668000000001e-7 * var_x210 - 6214.6032000000005 * var_x209) - 0.311 * var_x206 * var_x211 * var_x213 / pow(var_x207, 2))) + ((var_x197) ? (0.034200000000000001 * var_x217 + 0.059999999999999998 * var_x214 * var_x216 / pow(var_x215, 2)) : (-0.00025500480000000003 * var_x221 + 0.0033402720000000005 * var_x218 * var_x220 / pow(var_x219, 2)))) - var_x205 * (var_x222 + var_x223);
        IJth(rJacobian, 4, 0) = var_x230 * var_x231 - var_x230 * var_x235 + var_x228 * var_x233 * var_x234 - var_x227 * var_x229 * var_x235 / pow(var_x225, 2);
        IJth(rJacobian, 5, 0) = (0.02 + var_x236) * (0.029999999999999999 * var_x238 / pow(var_x239, 2) - 0.1111111111111111 * var_x241 / pow(var_x242, 2)) + var_x236 * (-0.032935010000000001 - 0.0022713799999999999 * var_chaste_interface__cell__sVm) * (-var_chaste_interface__cell__sf + 1 / var_x242 + 0.59999999999999998 / var_x239);
        IJth(rJacobian, 8, 0) = var_x246 * var_x249 + 0.0074074074074074077 * var_x243 * (var_x250 - var_chaste_interface__cell__sxtos) / (pow(var_x244, 2) * pow((0.055555555555555552 + var_x245), 2));
        IJth(rJacobian, 9, 0) = -var_x254 * var_x258 + 0.000125 * var_x251 * (var_x259 - var_chaste_interface__cell__sytos) / (pow(var_x252, 2) * pow((0.037499999999999999 + var_x253), 2));
        IJth(rJacobian, 10, 0) = var_x249 * var_x261 - 0.11764705882352941 * var_x260 * (-0.035999999999999997 - 0.00080000000000000004 * var_chaste_interface__cell__sVm) * (var_x250 - var_chaste_interface__cell__sxtof) / pow((0.058823529411764705 + var_x260), 2);
        IJth(rJacobian, 11, 0) = -var_x258 * var_x263 - 0.011764705882352941 * var_x262 * (-0.36363636363636365 - 0.0090909090909090905 * var_chaste_interface__cell__sVm) * (var_x259 - var_chaste_interface__cell__sytof) / pow((0.082352941176470587 + var_x262), 2);
        IJth(rJacobian, 12, 0) = 9.1827364554637282e-8 * (-var_chaste_interface__cell__sxkr + 1 / var_x275) * (11.5 * var_x264 / pow(var_x265, 2) + 366.66666666666669 * var_x267 * var_x272 / pow(var_x268, 2) - 366.66666666666669 * var_x269 * var_x270 / pow(var_x271, 2)) / pow((var_x273 + 0.069696969696969702 * var_x266), 2) + 0.20000000000000001 * var_x274 * var_x276 / pow(var_x275, 2);
        IJth(rJacobian, 13, 0) = -7.1529673512819408e-5 * var_x279 * (-var_chaste_interface__cell__sxks + 1 / var_x278) + 0.070175438596491224 * var_x277 * (0.00100999899000101 + var_x280) / pow(var_x278, 2);
        IJth(rJacobian, 32, 0) = -var_x343 * (6.567e-5 + var_x124 + var_x86 - var_x110 + 0.11 * var_x36 + 1.4850000000000001 * var_x53 + 0.012986358245322698 * var_x67 + 0.46486956521739131 * var_x30);
        IJth(rJacobian, 33, 0) = -var_x352 * (0.00053133 + var_x118 + var_x81 - var_x111 + 0.89000000000000001 * var_x36 + 12.015000000000001 * var_x63 + 0.10507144398488363 * var_x69 + 3.7612173913043478 * var_x32);
        IJth(rJacobian, 35, 0) = -var_x357 * (6.0643000000000002e-5 + var_x122 + var_x95 - var_x116 - 0.98999999999999999 * var_x53 - 0.0086575721635484652 * var_x67);
        IJth(rJacobian, 36, 0) = -var_x364 * (0.00049065700000000003 + var_x120 + var_x99 - var_x114 - 0.070047629323255756 * var_x69 - 8.0099999999999998 * var_x63);
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (-0.33000000000000002 * var_x129 - 2.6699999999999999 * var_x132);
        IJth(rJacobian, 1, 1) = -var_x193;
        IJth(rJacobian, 32, 1) = -0.083408694032519187 * var_x129 * var_x342;
        IJth(rJacobian, 33, 1) = -0.01818726573379081 * var_x132 * var_x342;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x133 * var_x35 - var_x134 * var_x35);
        IJth(rJacobian, 2, 2) = -var_x203 - var_x204;
        IJth(rJacobian, 32, 2) = -var_x344 * var_x345;
        IJth(rJacobian, 33, 2) = -var_x344 * var_x353;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x133 * var_x135 - var_x134 * var_x135);
        IJth(rJacobian, 3, 3) = -var_x222 - var_x223;
        IJth(rJacobian, 32, 3) = -var_x345 * var_x346;
        IJth(rJacobian, 33, 3) = -var_x346 * var_x353;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x137 * var_x138 - var_x137 * var_x139 - var_x137 * var_x143 - var_x140 * var_x141 - var_x140 * var_x142);
        IJth(rJacobian, 4, 4) = -var_x231 * var_x233;
        IJth(rJacobian, 32, 4) = -var_x347 * var_x348;
        IJth(rJacobian, 33, 4) = -var_x347 * var_x355;
        IJth(rJacobian, 35, 4) = -var_x358 * var_x359;
        IJth(rJacobian, 36, 4) = -var_x358 * var_x366;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x138 * var_x145 - var_x139 * var_x145 - var_x141 * var_x146 - var_x142 * var_x146 - var_x143 * var_x145);
        IJth(rJacobian, 5, 5) = -0.02 - var_x236;
        IJth(rJacobian, 32, 5) = -var_x348 * var_x349;
        IJth(rJacobian, 33, 5) = -var_x349 * var_x355;
        IJth(rJacobian, 35, 5) = -var_x359 * var_x360;
        IJth(rJacobian, 36, 5) = -var_x360 * var_x366;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (0.00019748616671718712 * var_x148 + var_x104 * var_x85 + var_x147 * var_x94);
        IJth(rJacobian, 6, 6) = -0.011900000000000001 - 1.7 * var_chaste_interface__cell__sCaj;
        IJth(rJacobian, 32, 6) = 2.7730746221159819e-6 * var_x350 * var_x84;
        IJth(rJacobian, 35, 6) = 0.19966137279235072 * var_x361 * var_x93;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (2.1942907413020785e-5 * var_x148 + var_x104 * var_x80 + var_x147 * var_x98);
        IJth(rJacobian, 7, 7) = -0.011900000000000001 - 1.7 * var_chaste_interface__cell__sCasl;
        IJth(rJacobian, 33, 7) = var_x350 * var_x354;
        IJth(rJacobian, 36, 7) = var_x361 * var_x365;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x149 * var_chaste_interface__cell__sytos);
        IJth(rJacobian, 8, 8) = -var_x246;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (var_x149 * var_chaste_interface__cell__sxtos);
        IJth(rJacobian, 9, 9) = -var_x254;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (var_x150 * var_chaste_interface__cell__sytof);
        IJth(rJacobian, 10, 10) = -var_x261;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (var_x150 * var_chaste_interface__cell__sxtof);
        IJth(rJacobian, 11, 11) = -var_x263;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x21 * var_x22 * NV_Ith_S(mParameters, 2));
        IJth(rJacobian, 12, 12) = -var_x276;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0070000000000000001 * (-26.712338705498265 * log(7.9662000000000006 / (120.0 + 0.018329999999999999 * var_chaste_interface__cell__sNai)) + var_chaste_interface__cell__sVm) * var_chaste_interface__cell__sxks);
        IJth(rJacobian, 13, 13) = -0.00100999899000101 - var_x280;
        IJth(rJacobian, 14, 14) = -0.0050000000000000001 + var_x287 + var_x290;
        IJth(rJacobian, 15, 14) = var_x289;
        IJth(rJacobian, 16, 14) = var_x290;
        IJth(rJacobian, 14, 15) = 0.055;
        IJth(rJacobian, 15, 15) = -0.059999999999999998 + var_x287;
        IJth(rJacobian, 16, 15) = var_x290 + var_x299 * var_chaste_interface__cell__sCaj;
        IJth(rJacobian, 31, 15) = 25.0 * var_chaste_interface__cell__sCaj - 25.0 * var_chaste_interface__cell__sCa_sr;
        IJth(rJacobian, 35, 15) = 1623.3766233766235 * var_chaste_interface__cell__sCa_sr - 1623.3766233766235 * var_chaste_interface__cell__sCaj;
        IJth(rJacobian, 14, 16) = -0.0050000000000000001;
        IJth(rJacobian, 15, 16) = 0.0050000000000000001;
        IJth(rJacobian, 16, 16) = -0.065000000000000002 + var_x290;
        IJth(rJacobian, 17, 17) = -0.001 - var_x301;
        IJth(rJacobian, 32, 17) = 0.001 + var_x301;
        IJth(rJacobian, 18, 18) = -0.001 - var_x303;
        IJth(rJacobian, 33, 18) = 0.001 + var_x303;
        IJth(rJacobian, 19, 19) = -0.019599999999999999 - var_x305;
        IJth(rJacobian, 37, 19) = 0.019599999999999999 + var_x305;
        IJth(rJacobian, 20, 20) = -3.1999999999999999e-5 + var_x308;
        IJth(rJacobian, 21, 20) = -0.0030000000000000001;
        IJth(rJacobian, 37, 20) = 0.003032 + var_x307;
        IJth(rJacobian, 20, 21) = var_x308;
        IJth(rJacobian, 21, 21) = -0.0063300000000000006;
        IJth(rJacobian, 37, 21) = 0.0063300000000000006 + var_x307;
        IJth(rJacobian, 22, 22) = -0.23799999999999999 - var_x311;
        IJth(rJacobian, 37, 22) = 0.23799999999999999 + var_x311;
        IJth(rJacobian, 23, 23) = -0.00046000000000000001 + var_x314;
        IJth(rJacobian, 24, 23) = -0.015699999999999999;
        IJth(rJacobian, 37, 23) = 0.016159999999999997 + var_x313;
        IJth(rJacobian, 23, 24) = var_x314;
        IJth(rJacobian, 24, 24) = -0.015757;
        IJth(rJacobian, 37, 24) = 0.015757 + var_x313;
        IJth(rJacobian, 25, 25) = -0.059999999999999998 - var_x317;
        IJth(rJacobian, 37, 25) = 0.059999999999999998 + var_x317;
        IJth(rJacobian, 26, 26) = -1.3 + var_x320;
        IJth(rJacobian, 35, 26) = 1.3 + var_x319;
        IJth(rJacobian, 27, 27) = -1.3 + var_x323;
        IJth(rJacobian, 36, 27) = 1.3 + var_x322;
        IJth(rJacobian, 28, 28) = -0.029999999999999999 + var_x320;
        IJth(rJacobian, 35, 28) = 0.029999999999999999 + var_x319;
        IJth(rJacobian, 29, 29) = -0.029999999999999999 + var_x323;
        IJth(rJacobian, 36, 29) = 0.029999999999999999 + var_x322;
        IJth(rJacobian, 30, 30) = -65.0 - var_x327;
        IJth(rJacobian, 31, 30) = 65.0 + var_x327;
        IJth(rJacobian, 14, 31) = -var_x295 + var_x291 * var_x293;
        IJth(rJacobian, 15, 31) = var_x295 + var_x298;
        IJth(rJacobian, 16, 31) = -var_x298 + var_x294 * var_x300;
        IJth(rJacobian, 30, 31) = 260.0 - var_x328;
        IJth(rJacobian, 31, 31) = -260.00009932 + var_x328 - var_x329 - 4.6421953480341129e-16 * var_x338 - 0.0036772346118413473 * var_x336;
        IJth(rJacobian, 35, 31) = 0.0064493506493506492 + var_x362;
        IJth(rJacobian, 37, 31) = 2.4996436489414456e-17 * var_x338 + 0.00019800494063761101 * var_x336;
        IJth(rJacobian, 0, 32) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x151 - var_x159 - var_x160 + 1.6579932586131617e-12 * var_x157 - 4.2334955737758471e-5 * var_x153 - 2.673 * var_x158);
        IJth(rJacobian, 17, 32) = 0.0007561 - var_x302;
        IJth(rJacobian, 32, 32) = -0.0007561 + var_x302 - var_x351 - var_x343 * (var_x151 + var_x159 + var_x160 + 8.0190000000000001 * var_x158 + 0.0001270048672132754 * var_x153 - 4.973979775839485e-12 * var_x157);
        IJth(rJacobian, 33, 32) = 0.087151849242407126 * var_x342;
        IJth(rJacobian, 35, 32) = -var_x357 * (3.3159865172263233e-12 * var_x157 - 5.3460000000000001 * var_x158);
        IJth(rJacobian, 0, 33) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x161 - var_x167 - var_x169 + 1.3414672728779216e-11 * var_x166 - 21.626999999999999 * var_x168 - 0.00034252827824186399 * var_x162);
        IJth(rJacobian, 18, 33) = 0.000165 - var_x304;
        IJth(rJacobian, 32, 33) = var_x351;
        IJth(rJacobian, 33, 33) = -0.000165 + var_x304 - 7.8855000811034159 * var_x342 - var_x352 * (var_x161 + var_x167 + var_x169 + 0.001027584834725592 * var_x162 + 64.881 * var_x168 - 4.0244018186337653e-11 * var_x166);
        IJth(rJacobian, 34, 33) = var_x356;
        IJth(rJacobian, 36, 33) = -var_x364 * (2.6829345457558432e-11 * var_x166 - 43.253999999999998 * var_x168);
        IJth(rJacobian, 0, 34) = mSetVoltageDerivativeToZero ? 0.0 : (-9.4804976667914707e-7 * var_x2 * (15.063643895458311 + 0.002300971605031257 * var_chaste_interface__cell__sNai) / pow((1 + 0.00015275 * var_chaste_interface__cell__sNai), 2));
        IJth(rJacobian, 33, 34) = 7.7983482318610085 * var_x342;
        IJth(rJacobian, 34, 34) = -var_x356;
        IJth(rJacobian, 0, 35) = mSetVoltageDerivativeToZero ? 0.0 : (var_x172 - var_x170 - var_x173 - var_x178 + 1358280.0 * var_x175 - 6.5741102771804265e-14 * var_x176 - 2.2274999999999996e-8 * var_x177 - 0.00060293750000000007 * var_x174 * var_x45 / pow(var_x4, 2));
        IJth(rJacobian, 6, 35) = 1.7 - 1.7 * var_chaste_interface__cell__sfcaBj;
        IJth(rJacobian, 14, 35) = -var_x297 + var_x286 * var_chaste_interface__cell__sRyRr;
        IJth(rJacobian, 15, 35) = var_x297 + var_x286 * var_chaste_interface__cell__sRyRo;
        IJth(rJacobian, 16, 35) = var_x299 * var_chaste_interface__cell__sRyRo + var_x296 * var_x300 * var_chaste_interface__cell__sCaj;
        IJth(rJacobian, 26, 35) = 55.473098330241186 - var_x321;
        IJth(rJacobian, 28, 35) = 19.897959183673468 - var_x325;
        IJth(rJacobian, 31, 35) = 9.9320000000000005e-5 + var_x329;
        IJth(rJacobian, 32, 35) = -var_x343 * (1.9722330831541279e-13 * var_x176 + 6.6824999999999991e-8 * var_x177 - 4074840.0 * var_x175);
        IJth(rJacobian, 35, 35) = -75.377506864564012 + var_x321 + var_x325 - var_x362 - var_x363 - var_x357 * (var_x170 + var_x173 + var_x178 - var_x172 + 2716560.0 * var_x175 - 1.3148220554360853e-13 * var_x176 - 4.4549999999999992e-8 * var_x177);
        IJth(rJacobian, 36, 35) = 3.9220965724111685 * var_x342;
        IJth(rJacobian, 0, 36) = mSetVoltageDerivativeToZero ? 0.0 : (var_x181 - var_x179 - var_x182 - var_x186 + 10989720.0 * var_x183 - 5.3190528606277995e-13 * var_x184 - 1.8022499999999996e-7 * var_x185 - 0.0048783125000000007 * var_x174 * var_x55 / pow(var_x6, 2));
        IJth(rJacobian, 7, 36) = 1.7 - 1.7 * var_chaste_interface__cell__sfcaBsl;
        IJth(rJacobian, 27, 36) = 121.55000000000001 - var_x324;
        IJth(rJacobian, 29, 36) = 43.550000000000004 - var_x326;
        IJth(rJacobian, 33, 36) = -var_x352 * (5.4067499999999991e-7 * var_x185 + 1.5957158581883399e-12 * var_x184 - 32969160.0 * var_x183);
        IJth(rJacobian, 35, 36) = var_x363;
        IJth(rJacobian, 36, 36) = -165.10000000000002 + var_x324 + var_x326 - 21.646099331949777 * var_x342 - var_x364 * (var_x179 + var_x182 + var_x186 - var_x181 + 21979440.0 * var_x183 - 1.0638105721255599e-12 * var_x184 - 3.6044999999999992e-7 * var_x185);
        IJth(rJacobian, 37, 36) = var_x367;
        IJth(rJacobian, 19, 37) = 2.2890000000000006 - var_x306;
        IJth(rJacobian, 20, 37) = 0.33180000000000004 - var_x309 - var_x310;
        IJth(rJacobian, 22, 37) = 0.81600000000000006 - var_x312;
        IJth(rJacobian, 23, 37) = 1.9320000000000004 - var_x315 - var_x316;
        IJth(rJacobian, 25, 37) = 1.71 - var_x318;
        IJth(rJacobian, 31, 37) = 26713.606559545973 * var_x340 - 3.3723651925989277e-9 * var_x341;
        IJth(rJacobian, 36, 37) = 17.724002759538607 * var_x342;
        IJth(rJacobian, 37, 37) = -7.0788000000000011 + var_x306 + var_x309 + var_x310 + var_x312 + var_x315 + var_x316 + var_x318 - var_x367 + 1.8158889498609611e-10 * var_x341 - 1438.4249685909372 * var_x340;
    }

    N_Vector Cellgrandi2010ssFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__cell__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__cell__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__cell__time;
        NV_Ith_S(dqs, 1) = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellgrandi2010ssFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "grandi2010";
    this->mFreeVariableName = "cell__time";
    this->mFreeVariableUnits = "ms";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-81.3842590704928);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cell__sm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00384941567866232);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("cell__sh");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.623723834301669);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("cell__sj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.622080736932815);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("cell__sd");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.95884913218079e-06);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("cell__sf");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.995094078386247);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("cell__sfcaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0246274349529557);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("cell__sfcaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0150911724206476);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("cell__sxtos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442853722673121);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("cell__sytos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.789013894749951);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("cell__sxtof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442846429332686);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("cell__sytof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999995784674368);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("cell__sxkr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020160578118589);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("cell__sxks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00430143235332308);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("cell__sRyRr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893326456705696);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("cell__sRyRo");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.56436968249499e-07);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("cell__sRyRi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.03266331737064e-08);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("cell__sNaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.41097946062695);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("cell__sNaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.744248540671373);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("cell__sTnCL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00904644567707666);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("cell__sTnCHc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1183943202639);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("cell__sTnCHm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0101423649465603);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("cell__sCaM");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000299824763475116);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("cell__sMyoc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00201443980536826);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("cell__sMyom");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.137467597337588);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("cell__sSRB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00220110816535249);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("cell__sSLLj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00739549938515031);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("cell__sSLLsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00979616077807075);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("cell__sSLHj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0735225248399363);

    // NV_Ith_S(rY, 29):
    this->mVariableNames.push_back("cell__sSLHsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.113642236788144);

    // NV_Ith_S(rY, 30):
    this->mVariableNames.push_back("cell__sCsqnb");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.20762712858574);

    // NV_Ith_S(rY, 31):
    this->mVariableNames.push_back("cell__sCa_sr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.563755421404699);

    // NV_Ith_S(rY, 32):
    this->mVariableNames.push_back("cell__sNaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21411036389602);

    // NV_Ith_S(rY, 33):
    this->mVariableNames.push_back("cell__sNasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21322794157889);

    // NV_Ith_S(rY, 34):
    this->mVariableNames.push_back("cell__sNai");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21340895351653);

    // NV_Ith_S(rY, 35):
    this->mVariableNames.push_back("cell__sCaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175648385857736);

    // NV_Ith_S(rY, 36):
    this->mVariableNames.push_back("cell__sCasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000105614570409386);

    // NV_Ith_S(rY, 37):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.85230799863012e-05);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cell__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellgrandi2010ssFromCellMLCvode)
#endif // CHASTE_CVODE
