#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: decker_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "decker_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celldecker_2009FromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // ms
        const double var_chaste_interface__membrane__stim_offset = 0; // ms
        const double var_chaste_interface__membrane__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Celldecker_2009FromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Celldecker_2009FromCellMLCvode::Celldecker_2009FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                48,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldecker_2009FromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 0.00015552; // (var_ICaL__PCa) [L_per_F_ms]
        NV_Ith_S(this->mParameters, 1) = 9.0749999999999993; // (var_INa__g_Na) [mS_per_uF]
        NV_Ith_S(this->mParameters, 2) = 0.013854200000000001; // (var_IKr__gKr_max) [mS_per_uF]
    }

    Celldecker_2009FromCellMLCvode::~Celldecker_2009FromCellMLCvode()
    {
    }
    
    double Celldecker_2009FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = NV_Ith_S(rY, 37);
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = NV_Ith_S(rY, 40);
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = NV_Ith_S(rY, 41);
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 42);
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = NV_Ith_S(rY, 43);
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 44);
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 46);
        // Units: mM; Initial value: 145.5689
        
        const double var_ICaL__gamma_Cai = 1.0; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICab__PCab = 1.9950840000000001e-7; // L_per_F_ms
        const double var_ICab__gamma_Ca_i = 1.0; // dimensionless
        const double var_ICab__gamma_Ca_o = 0.34100000000000003; // dimensionless
        const double var_IClb__gClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKp__gKp = 0.0027599999999999999; // mS_per_uF
        const double var_IKs__OKs = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2; // dimensionless
        const double var_IKs__gKs = 0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INaCa__KmCa_act = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__Vmax = 4.5; // uA_per_uF
        const double var_INaCa__denom_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_i, 2); // dimensionless
        const double var_INaCa__denom_ss_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_ss_sr, 2); // dimensionless
        const double var_INaCa__eta = 0.27000000000000002; // dimensionless
        const double var_INaCa__ksat = 0.32000000000000001; // dimensionless
        const double var_INaK__V_half = -92.0; // mV
        const double var_INaK__ibarnak = 1.3999999999999999; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 2.6000000000000001; // mM
        const double var_INaK__sigma = 1.0; // dimensionless
        const double var_INaL__gNaL = 0.0064999999999999997; // mS_per_uF
        const double var_INab__PNab = 3.2000000000000001e-9; // L_per_F_ms
        const double var_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_IpCa__gpCa = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__gpCa / (var_chaste_interface__Ca__Ca_i + var_IpCa__KmpCa); // uA_per_uF
        const double var_Ito1__gto1 = 0.4975; // mS_per_uF
        const double var_Ito2__PCl = 8.9999999999999996e-7; // L_per_F_ms
        const double var_Ito2__kCa_ito2 = 0.40000000000000002; // mM_per_ms
        const double var_Ito2__KCa_ito2 = 1.0 - 1.0 / (1.0 + pow(var_chaste_interface__Irel__Irel, 2) / pow(var_Ito2__kCa_ito2, 2)); // dimensionless
        const double var_Ito2__zCl = -1.0; // dimensionless
        const double var_INaK__PNa = pow(var_chaste_interface__Na__Na_i, 3) / pow((var_INaK__kmnai + var_chaste_interface__Na__Na_i), 3); // dimensionless
        const double var_IKp__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_r_gate__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1__rto1 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // dimensionless
        const double var_membrane__i_Stim = 0.0; // uA_per_uF
        const double var_model_parameters__Ca_o = 1.8; // mM
        const double var_INaCa__denom_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_i + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_i / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_INaCa__denom_ss_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_ss_sr / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_model_parameters__Cl_o = 100.0; // mM
        const double var_model_parameters__F = 96487.0; // C_per_mole
        const double var_model_parameters__K_o = 5.4000000000000004; // mM
        const double var_IK1__gK1 = 0.21516574145596759 * sqrt(var_model_parameters__K_o); // mS_per_uF
        const double var_IKr__gKr = 0.43033148291193518 * sqrt(var_model_parameters__K_o) * NV_Ith_S(mParameters, 2); // mS_per_uF
        const double var_INaK__PK = var_model_parameters__K_o / (var_INaK__kmko + var_model_parameters__K_o); // dimensionless
        const double var_model_parameters__Na_o = 140.0; // mM
        const double var_INaCa__denom_4 = pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_INaCa__denom_ss_4 = pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_ss_sr, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_model_parameters__R = 8314.0; // J_per_kmole_K
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__ICaL_max = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICaL__gamma_Cao * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_ss_CaL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_ICaL__ICaL = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * var_ICaL__ICaL_max; // uA_per_uF
        const double var_ICab__ICab = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICab__gamma_Ca_o * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_i * var_ICab__gamma_Ca_i * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICab__PCab * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_INaCa__denom_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__denom_ss_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__num = 0.80000000000000004 * (pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa = var_INaCa__num / ((var_INaCa__denom_3 + var_INaCa__denom_4) * var_INaCa__denom_1 * var_INaCa__denom_2); // uA_per_uF
        const double var_INaCa__num_ss = 0.20000000000000001 * (pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa_ss_sr = var_INaCa__num_ss / ((var_INaCa__denom_ss_3 + var_INaCa__denom_ss_4) * var_INaCa__denom_ss_1 * var_INaCa__denom_ss_2); // uA_per_uF
        const double var_INaK__phi = (-var_INaK__V_half + var_chaste_interface__membrane__Vm) * var_INaK__sigma * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INaK__fv = 1 / (1.0 + exp(-var_INaK__phi)); // dimensionless
        const double var_INaK__INaK = var_INaK__PK * var_INaK__PNa * var_INaK__fv * var_INaK__ibarnak; // uA_per_uF
        const double var_INab__phi = var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INab__INab = (-var_model_parameters__Na_o + var_chaste_interface__Na__Na_i * exp(var_INab__phi)) * var_INab__PNab * var_INab__phi * var_model_parameters__F / (-1.0 + exp(var_INab__phi)); // uA_per_uF
        const double var_Ito2__Ito2_max = pow(var_Ito2__zCl, 2) * pow(var_model_parameters__F, 2) * (-var_model_parameters__Cl_o * exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + var_chaste_interface__Cl__Cl_i) * var_Ito2__PCl * var_chaste_interface__membrane__Vm / ((1.0 - exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_Ito2__Ito2 = var_Ito2__Ito2_max * var_Ito2__KCa_ito2 * var_chaste_interface__Ito2_i2f_gate__i2f; // uA_per_uF
        const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_reversal_potentials__ECl = -var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cl_o / var_chaste_interface__Cl__Cl_i) / var_model_parameters__F; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__membrane__Vm) * var_IClb__gClb; // uA_per_uF
        const double var_membrane__clont = var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__K_o / var_chaste_interface__K__K_i) / var_model_parameters__F; // mV
        const double var_IK1_K1_gate__alpha_k1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)); // dimensionless
        const double var_IK1_K1_gate__beta_k1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IK1_K1_gate__K1 = var_IK1_K1_gate__alpha_k1 / (var_IK1_K1_gate__alpha_k1 + var_IK1_K1_gate__beta_k1); // dimensionless
        const double var_IK1__IK1 = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IK1__gK1 * var_IK1_K1_gate__K1; // uA_per_uF
        const double var_IKp__IKp = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKp__Kp * var_IKp__gKp; // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKr__gKr * var_IKr_r_gate__r * var_chaste_interface__IKr_xr_gate__xr; // uA_per_uF
        const double var_Ito1__Ito1 = pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_Ito1__gto1 * var_Ito1__rto1 * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s; // uA_per_uF
        const double var_reversal_potentials__ENa = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Na_o / var_chaste_interface__Na__Na_i) / var_model_parameters__F; // mV
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_INaL__gNaL * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = var_model_parameters__R * var_model_parameters__T * log((var_model_parameters__Na_o * var_reversal_potentials__prnak + var_model_parameters__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_model_parameters__F; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__membrane__Vm) * var_IKs__OKs * var_IKs__gKs; // uA_per_uF
        const double var_membrane__kiont = -2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim; // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_membrane__caiont + var_membrane__clont + var_membrane__kiont + var_membrane__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldecker_2009FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__C1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C6 = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C10 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__C = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__CI = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__INa_m_gate__m = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = NV_Ith_S(rY, 37);
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = NV_Ith_S(rY, 38);
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = NV_Ith_S(rY, 39);
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = NV_Ith_S(rY, 40);
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = NV_Ith_S(rY, 41);
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 42);
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = NV_Ith_S(rY, 43);
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 44);
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__Cl__Cl_ss = NV_Ith_S(rY, 45);
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 46);
        // Units: mM; Initial value: 145.5689
        double var_chaste_interface__CaMK_active__CaMK_trap = NV_Ith_S(rY, 47);
        // Units: dimensionless; Initial value: 0.0018861341

        // Mathematics
        double d_dt_chaste_interface_var_membrane__Vm;
        const double var_CT_K_Cl__CT_K_Cl_max = 1.77e-5; // mM_per_ms
        const double var_CT_Na_Cl__CT_Na_Cl_max = 2.4610800000000002e-5; // mM_per_ms
        const double var_Ca__BSLmax = 1.1240000000000001; // mM
        const double var_Ca__BSRmax = 0.047; // mM
        const double var_Ca__KmBSL = 0.0086999999999999994; // mM
        const double var_Ca__KmBSR = 0.00087000000000000001; // mM
        const double var_Ca__bss = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss_CaL + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss_CaL + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__bss_sr = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss_sr + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss_sr + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__cmdn_bar = 0.050000000000000003; // mM
        const double var_Ca__csqnbar = 10.0; // mM
        const double var_Ca__km_cmdn = 0.0023800000000000002; // mM
        const double var_Ca__km_trpn = 0.00050000000000000001; // mM
        const double var_Ca__kmcsqn = 0.80000000000000004; // mM
        const double var_Ca__bcsqn = 1 / (1.0 + var_Ca__csqnbar * var_Ca__kmcsqn / pow((var_chaste_interface__Ca__Ca_JSR + var_Ca__kmcsqn), 2)); // dimensionless
        const double var_Ca__tau_diff = 0.20000000000000001; // ms
        const double var_Ca__Idiff = (-var_chaste_interface__Ca__Ca_i + var_chaste_interface__Ca__Ca_ss_sr) / var_Ca__tau_diff; // mM_per_ms
        const double var_Ca__tau_diff_ss = 2.0; // ms
        const double var_Ca__Idiff_ss = (-var_chaste_interface__Ca__Ca_ss_CaL + var_chaste_interface__Ca__Ca_ss_sr) / var_Ca__tau_diff_ss; // mM_per_ms
        const double var_Ca__trpn_bar = 0.070000000000000007; // mM
        const double var_Ca__bmyo = 1 / (1.0 + var_Ca__cmdn_bar * var_Ca__km_cmdn / pow((var_chaste_interface__Ca__Ca_i + var_Ca__km_cmdn), 2) + var_Ca__km_trpn * var_Ca__trpn_bar / pow((var_chaste_interface__Ca__Ca_i + var_Ca__km_trpn), 2)); // dimensionless
        const double var_CaMK_active__CaMK_0 = 0.050000000000000003; // dimensionless
        const double var_CaMK_active__Km = 0.0015; // mM
        const double var_CaMK_active__CaMK_active = (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) * var_CaMK_active__CaMK_0 / (1.0 + var_CaMK_active__Km / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_CaMK_active__alpha_CaMK = 0.050000000000000003; // per_ms
        const double var_CaMK_active__beta_CaMK = 0.00068000000000000005; // per_ms
        const double var_Cl__Idiff_Cl = (-var_chaste_interface__Cl__Cl_i + var_chaste_interface__Cl__Cl_ss) / var_Ca__tau_diff; // mM_per_ms
        const double d_dt_chaste_interface_var_CaMK_active__CaMK_trap = -var_chaste_interface__CaMK_active__CaMK_trap * var_CaMK_active__beta_CaMK + (-var_chaste_interface__CaMK_active__CaMK_trap + var_CaMK_active__CaMK_active) * var_CaMK_active__CaMK_active * var_CaMK_active__alpha_CaMK; // 1 / ms
        const double var_ICaL__IV_beta_infinity_star = 25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // dimensionless
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__gamma_Cai = 1.0; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__theta = 1.0; // per_ms
        const double var_ICaL__theta_I = 9.9999999999999995e-7; // per_ms
        const double var_ICab__PCab = 1.9950840000000001e-7; // L_per_F_ms
        const double var_ICab__gamma_Ca_i = 1.0; // dimensionless
        const double var_ICab__gamma_Ca_o = 0.34100000000000003; // dimensionless
        const double var_IClb__gClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKp__gKp = 0.0027599999999999999; // mS_per_uF
        const double var_IKs__OKs = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2; // dimensionless
        const double var_IKs__gKs = 0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_IKs__theta = 0.089538000000000006; // per_ms
        const double var_INaCa__KmCa_act = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__Vmax = 4.5; // uA_per_uF
        const double var_INaCa__denom_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_i, 2); // dimensionless
        const double var_INaCa__denom_ss_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_ss_sr, 2); // dimensionless
        const double var_INaCa__eta = 0.27000000000000002; // dimensionless
        const double var_INaCa__ksat = 0.32000000000000001; // dimensionless
        const double var_INaK__V_half = -92.0; // mV
        const double var_INaK__ibarnak = 1.3999999999999999; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 2.6000000000000001; // mM
        const double var_INaK__sigma = 1.0; // dimensionless
        const double var_INaL__gNaL = 0.0064999999999999997; // mS_per_uF
        const double var_INaL_hL_gate__tau_hL = 600.0; // ms
        const double var_INab__PNab = 3.2000000000000001e-9; // L_per_F_ms
        const double var_Ileak__nsrbar = 15.0; // mM
        const double var_Ileak__Ileak = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_NSR / var_Ileak__nsrbar; // mM_per_ms
        const double var_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_IpCa__gpCa = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__gpCa / (var_chaste_interface__Ca__Ca_i + var_IpCa__KmpCa); // uA_per_uF
        const double var_Irel__K_beta = 0.28000000000000003; // mM
        const double var_Irel__Krel_infinity = 1.0; // mM
        const double var_Irel__Krel_tau = 0.0123; // mM
        const double var_Irel__beta_0 = 4.75; // ms
        const double var_Irel__delta_beta_0 = 1.0; // dimensionless
        const double var_Irel__h_beta = 10.0; // dimensionless
        const double var_Irel__delta_beta_CaMK = var_Irel__delta_beta_0 / (1.0 + pow((var_Irel__K_beta / var_CaMK_active__CaMK_active), var_Irel__h_beta)); // dimensionless
        const double var_Irel__beta_tau = (1.0 + var_Irel__delta_beta_CaMK) * var_Irel__beta_0; // ms
        const double var_Irel__h_rel = 8.0; // dimensionless
        const double var_Irel__kappa = 0.1125; // mM_per_uA_per_uF_per_ms_per_ms
        const double var_Irel__alpha_rel = var_Irel__beta_tau * var_Irel__kappa; // mM_per_uA_per_uF_per_ms
        const double var_Irel__tau_rel = var_Irel__beta_tau / (1.0 + var_Irel__Krel_tau / var_chaste_interface__Ca__Ca_JSR); // ms
        const double var_Ito1__gto1 = 0.4975; // mS_per_uF
        const double var_Ito2__PCl = 8.9999999999999996e-7; // L_per_F_ms
        const double var_Ito2__kCa_ito2 = 0.40000000000000002; // mM_per_ms
        const double var_Ito2__KCa_ito2 = 1.0 - 1.0 / (1.0 + pow(var_chaste_interface__Irel__Irel, 2) / pow(var_Ito2__kCa_ito2, 2)); // dimensionless
        const double var_Ito2__zCl = -1.0; // dimensionless
        const double var_Ito2_i2f_gate__tau_i2f = 8.0; // ms
        const double var_Itr__tautr = 25.0; // ms
        const double var_Itr__Itr = (-var_chaste_interface__Ca__Ca_JSR + var_chaste_interface__Ca__Ca_NSR) / var_Itr__tautr; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_JSR = (-var_chaste_interface__Irel__Irel + var_Itr__Itr) * var_Ca__bcsqn; // mM / ms
        const double var_Iup__delta_iupCaMK_bar = 0.75; // dimensionless
        const double var_Iup__delta_kmPLB_bar = 0.00017000000000000001; // mM
        const double var_Iup__iupbar = 0.0043750000000000004; // mM_per_ms
        const double var_Iup__kmCaMK = 0.14999999999999999; // mM
        const double var_Iup__delta_iupCaMK = var_CaMK_active__CaMK_active * var_Iup__delta_iupCaMK_bar / (var_CaMK_active__CaMK_active + var_Iup__kmCaMK); // dimensionless
        const double var_Iup__delta_kmPLB = var_CaMK_active__CaMK_active * var_Iup__delta_kmPLB_bar / (var_CaMK_active__CaMK_active + var_Iup__kmCaMK); // mM
        const double var_Iup__kmup = 0.00092000000000000003; // mM
        const double var_Iup__Iup = (1.0 + var_Iup__delta_iupCaMK) * var_chaste_interface__Ca__Ca_i * var_Iup__iupbar / (-var_Iup__delta_kmPLB + var_chaste_interface__Ca__Ca_i + var_Iup__kmup); // mM_per_ms
        const double var_INaK__PNa = pow(var_chaste_interface__Na__Na_i, 3) / pow((var_INaK__kmnai + var_chaste_interface__Na__Na_i), 3); // dimensionless
        const double var_Na__Idiff_Na = (-var_chaste_interface__Na__Na_i + var_chaste_interface__Na__Na_ss_sr) / var_Ca__tau_diff; // mM_per_ms
        const double var_cell_geometry__a = 0.0011000000000000001; // cm
        const double var_cell_geometry__l = 0.01; // cm
        const double var_cell_geometry__ageo = 2.0 * M_PI * pow(var_cell_geometry__a, 2) + 2.0 * M_PI * var_cell_geometry__a * var_cell_geometry__l; // cm2
        const double var_cell_geometry__Acap = 2.0 * var_cell_geometry__ageo; // cm2
        const double var_cell_geometry__vcell = 1000.0 * M_PI * pow(var_cell_geometry__a, 2) * var_cell_geometry__l; // uL
        const double var_cell_geometry__Vjsr = 0.0047999999999999996 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vnsr = 0.055199999999999999 * var_cell_geometry__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = -var_Ileak__Ileak - var_Itr__Itr * var_cell_geometry__Vjsr / var_cell_geometry__Vnsr + var_Iup__Iup; // mM / ms
        const double var_cell_geometry__Vss_CaL = 0.002 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_beta_star = 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * var_ICaL__IV_beta_infinity_star); // dimensionless
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + var_ICaL__IV_beta_star); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C = (-var_ICaL__alpha - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__C + var_chaste_interface__ICaL__CI * var_ICaL__x + var_chaste_interface__ICaL__C_star * var_ICaL__theta + var_chaste_interface__ICaL__O * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O = (-var_ICaL__beta - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__C * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__x + var_chaste_interface__ICaL__O_star * var_ICaL__theta; // 1 / ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C_star = (-var_ICaL__alpha - var_ICaL__theta - var_ICaL__y_star) * var_chaste_interface__ICaL__C_star + var_chaste_interface__ICaL__C * var_ICaL__delta + var_chaste_interface__ICaL__CI_star * var_ICaL__x_star + var_chaste_interface__ICaL__O_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O_star = (-var_ICaL__beta - var_ICaL__theta - var_ICaL__y_star) * var_chaste_interface__ICaL__O_star + var_chaste_interface__ICaL__C_star * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__delta + var_chaste_interface__ICaL__OI_star * var_ICaL__x_star; // 1 / ms
        const double var_ICaL__delta_I = var_ICaL__delta * var_ICaL__theta_I * var_ICaL__x * var_ICaL__y_star / (var_ICaL__theta * var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__CI = (-var_ICaL__alpha - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__CI + var_chaste_interface__ICaL__C * var_ICaL__y + var_chaste_interface__ICaL__CI_star * var_ICaL__theta_I + var_chaste_interface__ICaL__OI * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__CI_star = (-var_ICaL__alpha - var_ICaL__theta_I - var_ICaL__x_star) * var_chaste_interface__ICaL__CI_star + var_chaste_interface__ICaL__CI * var_ICaL__delta_I + var_chaste_interface__ICaL__C_star * var_ICaL__y_star + var_chaste_interface__ICaL__OI_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI = (-var_ICaL__beta - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__OI + var_chaste_interface__ICaL__CI * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__y + var_chaste_interface__ICaL__OI_star * var_ICaL__theta_I; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI_star = (-var_ICaL__beta - var_ICaL__theta_I - var_ICaL__x_star) * var_chaste_interface__ICaL__OI_star + var_chaste_interface__ICaL__CI_star * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__delta_I + var_chaste_interface__ICaL__O_star * var_ICaL__y_star; // 1 / ms
        const double var_IKp__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_r_gate__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_xr_gate__tau_xr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__membrane__Vm) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__membrane__Vm) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm))); // ms
        const double var_IKr_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double d_dt_chaste_interface_var_IKr_xr_gate__xr = (-var_chaste_interface__IKr_xr_gate__xr + var_IKr_xr_gate__xr_infinity) / var_IKr_xr_gate__tau_xr; // 1 / ms
        const double var_INaL_hL_gate__hL_infinity = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double d_dt_chaste_interface_var_INaL_hL_gate__hL = (-var_chaste_interface__INaL_hL_gate__hL + var_INaL_hL_gate__hL_infinity) / var_INaL_hL_gate__tau_hL; // 1 / ms
        const double var_INaL_mL_gate__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_INaL_mL_gate__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_INaL_mL_gate__mL = (1.0 - var_chaste_interface__INaL_mL_gate__mL) * var_INaL_mL_gate__amL - var_INaL_mL_gate__bmL * var_chaste_interface__INaL_mL_gate__mL; // 1 / ms
        const double var_INa_h_gate__ah = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm))); // per_ms
        const double var_INa_h_gate__bh = ((var_chaste_interface__membrane__Vm >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__Vm) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__Vm))); // per_ms
        const double d_dt_chaste_interface_var_INa_h_gate__h = (1.0 - var_chaste_interface__INa_h_gate__h) * var_INa_h_gate__ah - var_INa_h_gate__bh * var_chaste_interface__INa_h_gate__h; // 1 / ms
        const double var_INa_j_gate__aj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__membrane__Vm) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__Vm) - 6.9480000000000006e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm)))); // per_ms
        const double var_INa_j_gate__bj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__Vm))) : (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm)))); // per_ms
        const double d_dt_chaste_interface_var_INa_j_gate__j = (1.0 - var_chaste_interface__INa_j_gate__j) * var_INa_j_gate__aj - var_INa_j_gate__bj * var_chaste_interface__INa_j_gate__j; // 1 / ms
        const double var_INa_m_gate__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_INa_m_gate__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_INa_m_gate__m = (1.0 - var_chaste_interface__INa_m_gate__m) * var_INa_m_gate__am - var_INa_m_gate__bm * var_chaste_interface__INa_m_gate__m; // 1 / ms
        const double var_Ito1__rto1 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // dimensionless
        const double var_Ito1_a_gate__a_infinity = 1 / (1.0 + exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1_a_gate__alpha_a = 0.82719827942757873 / (1.0 + exp(0.62658348478969694 - 0.034035137876343539 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_a_gate__beta_a = 3.5 / (1.0 + exp(3.403513787634354 + 0.034035137876343539 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_a_gate__tau_a = 1 / (var_Ito1_a_gate__alpha_a + var_Ito1_a_gate__beta_a); // ms
        const double d_dt_chaste_interface_var_Ito1_a_gate__a = (-var_chaste_interface__Ito1_a_gate__a + var_Ito1_a_gate__a_infinity) / var_Ito1_a_gate__tau_a; // 1 / ms
        const double var_Ito1_i1f_gate__alpha_i1f = 0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_i1f_gate__beta_i1f = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_ms
        const double d_dt_chaste_interface_var_Ito1_i1f_gate__i1f = (1.0 - var_chaste_interface__Ito1_i1f_gate__i1f) * var_Ito1_i1f_gate__alpha_i1f - var_Ito1_i1f_gate__beta_i1f * var_chaste_interface__Ito1_i1f_gate__i1f; // 1 / ms
        const double var_Ito1_i1s_gate__alpha_i1s = 0.0040000000000000001 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_i1s_gate__beta_i1s = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_ms
        const double d_dt_chaste_interface_var_Ito1_i1s_gate__i1s = (1.0 - var_chaste_interface__Ito1_i1s_gate__i1s) * var_Ito1_i1s_gate__alpha_i1s - var_Ito1_i1s_gate__beta_i1s * var_chaste_interface__Ito1_i1s_gate__i1s; // 1 / ms
        const double var_Ito2_i2f_gate__alpha_i2f = 0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito2_i2f_gate__beta_i2f = 0.20000000000000001 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito2_i2f_gate__i2f_infinity = var_Ito2_i2f_gate__alpha_i2f / (var_Ito2_i2f_gate__alpha_i2f + var_Ito2_i2f_gate__beta_i2f); // dimensionless
        const double d_dt_chaste_interface_var_Ito2_i2f_gate__i2f = (-var_chaste_interface__Ito2_i2f_gate__i2f + var_Ito2_i2f_gate__i2f_infinity) / var_Ito2_i2f_gate__tau_i2f; // 1 / ms
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_model_parameters__Ca_o = 1.8; // mM
        const double var_INaCa__denom_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_i + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_i / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_INaCa__denom_ss_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_ss_sr / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_model_parameters__Cl_o = 100.0; // mM
        const double var_model_parameters__F = 96487.0; // C_per_mole
        const double var_cell_geometry__AF = var_cell_geometry__Acap / var_model_parameters__F; // uF_mole_per_C
        const double var_model_parameters__K_o = 5.4000000000000004; // mM
        const double var_IK1__gK1 = 0.21516574145596759 * sqrt(var_model_parameters__K_o); // mS_per_uF
        const double var_IKr__gKr = 0.43033148291193518 * sqrt(var_model_parameters__K_o) * NV_Ith_S(mParameters, 2); // mS_per_uF
        const double var_INaK__PK = var_model_parameters__K_o / (var_INaK__kmko + var_model_parameters__K_o); // dimensionless
        const double var_model_parameters__Na_o = 140.0; // mM
        const double var_INaCa__denom_4 = pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_INaCa__denom_ss_4 = pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_ss_sr, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_model_parameters__R = 8314.0; // J_per_kmole_K
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__ICaL_max = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICaL__gamma_Cao * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_ss_CaL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_ICaL__ICaL = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * var_ICaL__ICaL_max; // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_CaL = (var_Ca__Idiff_ss * var_cell_geometry__Vss_sr / var_cell_geometry__Vss_CaL - 0.5 * var_ICaL__ICaL * var_cell_geometry__AF / var_cell_geometry__Vss_CaL) * var_Ca__bss; // mM / ms
        const double var_ICab__ICab = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICab__gamma_Ca_o * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_i * var_ICab__gamma_Ca_i * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICab__PCab * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_IKs__alpha = 0.014864 * exp(0.029877000000000001 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.055461000000000003 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1 = var_chaste_interface__IKs__C2 * var_IKs__beta - 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.42625000000000002 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__eta = 0.07732 * exp(-0.064726000000000006 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.24465000000000001 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__C10 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C10 + var_chaste_interface__IKs__C11 * var_IKs__beta + var_chaste_interface__IKs__C7 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C11 = (-var_IKs__alpha - var_IKs__beta - var_IKs__gamma - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C11 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__beta + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C13 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C12 = (-2.0 * var_IKs__beta - 2.0 * var_IKs__delta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C12 + var_chaste_interface__IKs__C11 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C14 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C13 = (-var_IKs__alpha - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C13 + var_chaste_interface__IKs__C11 * var_IKs__gamma + var_chaste_interface__IKs__C14 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C14 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C14 + var_chaste_interface__IKs__C13 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__gamma + 4.0 * var_chaste_interface__IKs__C15 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C15 = (-var_IKs__theta - 4.0 * var_IKs__delta) * var_chaste_interface__IKs__C15 + var_chaste_interface__IKs__C14 * var_IKs__gamma + var_chaste_interface__IKs__O1 * var_IKs__eta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C2 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C2 + var_chaste_interface__IKs__C6 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__beta + 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C3 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C3 + var_chaste_interface__IKs__C7 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C2 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C4 = (-var_IKs__alpha - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C4 + var_chaste_interface__IKs__C8 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__alpha + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C5 = (-4.0 * var_IKs__beta - 4.0 * var_IKs__gamma) * var_chaste_interface__IKs__C5 + var_chaste_interface__IKs__C4 * var_IKs__alpha + var_chaste_interface__IKs__C9 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C6 = (-var_IKs__delta - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C6 + var_chaste_interface__IKs__C2 * var_IKs__gamma + var_chaste_interface__IKs__C7 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C7 = (-var_IKs__beta - var_IKs__delta - var_IKs__gamma - 2.0 * var_IKs__alpha) * var_chaste_interface__IKs__C7 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__gamma + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__beta + 3.0 * var_chaste_interface__IKs__C6 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C8 = (-var_IKs__alpha - var_IKs__delta - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C8 + 2.0 * var_chaste_interface__IKs__C11 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C7 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C9 = (-var_IKs__delta - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C9 + var_chaste_interface__IKs__C8 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__delta + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__gamma; // 1 / ms
        const double var_IKs__omega = 0.79405000000000003 * exp(-0.080173999999999995 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__psi = 0.58638000000000001 * exp(0.28205999999999998 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1 = (-var_IKs__eta - var_IKs__psi) * var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__C15 * var_IKs__theta + var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2 = var_chaste_interface__IKs__O1 * var_IKs__psi - var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double var_INaCa__denom_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__denom_ss_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__num = 0.80000000000000004 * (pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa = var_INaCa__num / ((var_INaCa__denom_3 + var_INaCa__denom_4) * var_INaCa__denom_1 * var_INaCa__denom_2); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup__Iup + var_Ileak__Ileak) * var_cell_geometry__Vnsr / var_cell_geometry__Vmyo + var_Ca__Idiff * var_cell_geometry__Vss_CaL / var_cell_geometry__Vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell_geometry__AF / var_cell_geometry__Vmyo) * var_Ca__bmyo; // mM / ms
        const double var_INaCa__num_ss = 0.20000000000000001 * (pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa_ss_sr = var_INaCa__num_ss / ((var_INaCa__denom_ss_3 + var_INaCa__denom_ss_4) * var_INaCa__denom_ss_1 * var_INaCa__denom_ss_2); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_sr = (-var_Ca__Idiff - var_Ca__Idiff_ss + var_chaste_interface__Irel__Irel * var_cell_geometry__Vjsr / var_cell_geometry__Vss_sr + var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr) * var_Ca__bss_sr; // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_ss_sr = -var_Na__Idiff_Na - 3.0 * var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_INaK__phi = (-var_INaK__V_half + var_chaste_interface__membrane__Vm) * var_INaK__sigma * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INaK__fv = 1 / (1.0 + exp(-var_INaK__phi)); // dimensionless
        const double var_INaK__INaK = var_INaK__PK * var_INaK__PNa * var_INaK__fv * var_INaK__ibarnak; // uA_per_uF
        const double var_INab__phi = var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INab__INab = (-var_model_parameters__Na_o + var_chaste_interface__Na__Na_i * exp(var_INab__phi)) * var_INab__PNab * var_INab__phi * var_model_parameters__F / (-1.0 + exp(var_INab__phi)); // uA_per_uF
        const double var_Irel__rel_infinity = var_ICaL__ICaL * var_Irel__alpha_rel / (1.0 + pow((var_Irel__Krel_infinity / var_chaste_interface__Ca__Ca_JSR), var_Irel__h_rel)); // mM_per_ms
        const double d_dt_chaste_interface_var_Irel__Irel = (-var_chaste_interface__Irel__Irel - var_Irel__rel_infinity) / var_Irel__tau_rel; // mM_per_ms / ms
        const double var_Ito2__Ito2_max = pow(var_Ito2__zCl, 2) * pow(var_model_parameters__F, 2) * (-var_model_parameters__Cl_o * exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + var_chaste_interface__Cl__Cl_i) * var_Ito2__PCl * var_chaste_interface__membrane__Vm / ((1.0 - exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_Ito2__Ito2 = var_Ito2__Ito2_max * var_Ito2__KCa_ito2 * var_chaste_interface__Ito2_i2f_gate__i2f; // uA_per_uF
        const double d_dt_chaste_interface_var_Cl__Cl_ss = -var_Cl__Idiff_Cl + var_Ito2__Ito2 * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_reversal_potentials__ECl = -var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cl_o / var_chaste_interface__Cl__Cl_i) / var_model_parameters__F; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__membrane__Vm) * var_IClb__gClb; // uA_per_uF
        const double var_reversal_potentials__EK = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__K_o / var_chaste_interface__K__K_i) / var_model_parameters__F; // mV
        const double var_CT_K_Cl__CT_K_Cl = (-var_reversal_potentials__ECl + var_reversal_potentials__EK) * var_CT_K_Cl__CT_K_Cl_max / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_IK1_K1_gate__alpha_k1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)); // dimensionless
        const double var_IK1_K1_gate__beta_k1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IK1_K1_gate__K1 = var_IK1_K1_gate__alpha_k1 / (var_IK1_K1_gate__alpha_k1 + var_IK1_K1_gate__beta_k1); // dimensionless
        const double var_IK1__IK1 = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IK1__gK1 * var_IK1_K1_gate__K1; // uA_per_uF
        const double var_IKp__IKp = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKp__Kp * var_IKp__gKp; // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKr__gKr * var_IKr_r_gate__r * var_chaste_interface__IKr_xr_gate__xr; // uA_per_uF
        const double var_Ito1__Ito1 = pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_Ito1__gto1 * var_Ito1__rto1 * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s; // uA_per_uF
        const double var_reversal_potentials__ENa = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Na_o / var_chaste_interface__Na__Na_i) / var_model_parameters__F; // mV
        const double var_CT_Na_Cl__CT_Na_Cl = pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) * var_CT_Na_Cl__CT_Na_Cl_max / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_Cl__Idiff_Cl * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo + var_IClb__IClb * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_INaL__gNaL * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = var_Na__Idiff_Na * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo - (3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = var_model_parameters__R * var_model_parameters__T * log((var_model_parameters__Na_o * var_reversal_potentials__prnak + var_model_parameters__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_model_parameters__F; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__membrane__Vm) * var_IKs__OKs * var_IKs__gKs; // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -(-2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__Vm = 0.0;
        }
        else
        {
            const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
            const double var_membrane__clont = var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
            const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab; // uA_per_uF
            const double var_membrane__kiont = -2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim; // uA_per_uF
            d_dt_chaste_interface_var_membrane__Vm = -var_membrane__caiont - var_membrane__clont - var_membrane__kiont - var_membrane__naiont; // mV / ms
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__Vm;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_Ca__Ca_i;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_IKs__C1;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_IKs__C2;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_IKs__C3;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_IKs__C4;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_IKs__C5;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_IKs__C6;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_IKs__C7;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_IKs__C8;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_IKs__C9;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_IKs__C10;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_IKs__C11;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_IKs__C12;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_IKs__C13;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_IKs__C14;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_IKs__C15;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_IKs__O1;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_IKs__O2;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_ICaL__C;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_ICaL__O;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_ICaL__C_star;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_ICaL__O_star;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_ICaL__CI;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_ICaL__OI;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_ICaL__CI_star;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_ICaL__OI_star;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_INa_m_gate__m;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_INa_h_gate__h;
        NV_Ith_S(rDY,29) = d_dt_chaste_interface_var_INa_j_gate__j;
        NV_Ith_S(rDY,30) = d_dt_chaste_interface_var_INaL_mL_gate__mL;
        NV_Ith_S(rDY,31) = d_dt_chaste_interface_var_INaL_hL_gate__hL;
        NV_Ith_S(rDY,32) = d_dt_chaste_interface_var_IKr_xr_gate__xr;
        NV_Ith_S(rDY,33) = d_dt_chaste_interface_var_Ito1_a_gate__a;
        NV_Ith_S(rDY,34) = d_dt_chaste_interface_var_Ito1_i1f_gate__i1f;
        NV_Ith_S(rDY,35) = d_dt_chaste_interface_var_Ito1_i1s_gate__i1s;
        NV_Ith_S(rDY,36) = d_dt_chaste_interface_var_Ito2_i2f_gate__i2f;
        NV_Ith_S(rDY,37) = d_dt_chaste_interface_var_Irel__Irel;
        NV_Ith_S(rDY,38) = d_dt_chaste_interface_var_Ca__Ca_JSR;
        NV_Ith_S(rDY,39) = d_dt_chaste_interface_var_Ca__Ca_NSR;
        NV_Ith_S(rDY,40) = d_dt_chaste_interface_var_Ca__Ca_ss_sr;
        NV_Ith_S(rDY,41) = d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
        NV_Ith_S(rDY,42) = d_dt_chaste_interface_var_Na__Na_i;
        NV_Ith_S(rDY,43) = d_dt_chaste_interface_var_Na__Na_ss_sr;
        NV_Ith_S(rDY,44) = d_dt_chaste_interface_var_Cl__Cl_i;
        NV_Ith_S(rDY,45) = d_dt_chaste_interface_var_Cl__Cl_ss;
        NV_Ith_S(rDY,46) = d_dt_chaste_interface_var_K__K_i;
        NV_Ith_S(rDY,47) = d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
    }

    void Celldecker_2009FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = NV_Ith_S(rY, 1);
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__C1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C6 = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C10 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__C = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__CI = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__INa_m_gate__m = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = NV_Ith_S(rY, 37);
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = NV_Ith_S(rY, 38);
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = NV_Ith_S(rY, 39);
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = NV_Ith_S(rY, 40);
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = NV_Ith_S(rY, 41);
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 42);
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = NV_Ith_S(rY, 43);
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = NV_Ith_S(rY, 44);
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = NV_Ith_S(rY, 46);
        // Units: mM; Initial value: 145.5689
        double var_chaste_interface__CaMK_active__CaMK_trap = NV_Ith_S(rY, 47);
        // Units: dimensionless; Initial value: 0.0018861341
        
        const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm);
        const double var_x1 = 1.0 + var_x0;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = 1 / var_chaste_interface__Ca__Ca_i;
        const double var_x4 = pow(var_x3, 1.3999999999999999);
        const double var_x5 = 1.0 + 6.4818210260626455e-7 * var_x4;
        const double var_x6 = 1 / var_x5;
        const double var_x7 = -0.082600000000000007 - 0.04956 * var_x6;
        const double var_x8 = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2;
        const double var_x9 = var_x7 * var_x8;
        const double var_x10 = pow(var_chaste_interface__INaL_mL_gate__mL, 3);
        const double var_x11 = 0.0064999999999999997 * var_x10;
        const double var_x12 = 0.037436659501656748 * var_chaste_interface__membrane__Vm;
        const double var_x13 = exp(var_x12);
        const double var_x14 = -1.0 + var_x13;
        const double var_x15 = 1 / var_x14;
        const double var_x16 = var_x13 * var_chaste_interface__Na__Na_i;
        const double var_x17 = -140.0 + var_x16;
        const double var_x18 = var_x15 * var_x17;
        const double var_x19 = 1 / var_chaste_interface__K__K_i;
        const double var_x20 = log(5.4000000000000004 * var_x19);
        const double var_x21 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * var_x20);
        const double var_x22 = 1.0 + var_x21;
        const double var_x23 = 1 / var_x22;
        const double var_x24 = exp(-2.4444678999999998 + 13.737871029257827 * var_x20 - 0.51429999999999998 * var_chaste_interface__membrane__Vm);
        const double var_x25 = 1.0 + var_x24;
        const double var_x26 = 1 / var_x25;
        const double var_x27 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * var_x20);
        const double var_x28 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * var_x20);
        const double var_x29 = var_x28 + 0.49124000000000001 * var_x27;
        const double var_x30 = var_x26 * var_x29;
        const double var_x31 = 1 / (var_x30 + 1.02 * var_x23);
        const double var_x32 = var_x23 * var_x31;
        const double var_x33 = exp(0.074873319003313496 * var_chaste_interface__membrane__Vm);
        const double var_x34 = -1.0 + var_x33;
        const double var_x35 = 1 / var_x34;
        const double var_x36 = var_x33;
        const double var_x37 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_i;
        const double var_x38 = var_x35 * var_x37;
        const double var_x39 = 26.711785007306684 * var_x20;
        const double var_x40 = -var_x39 + var_chaste_interface__membrane__Vm;
        const double var_x41 = var_x0 * var_x40 / pow(var_x1, 2);
        const double var_x42 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm);
        const double var_x43 = 1.0 + var_x42;
        const double var_x44 = NV_Ith_S(mParameters, 2) / var_x43;
        const double var_x45 = 1.0 * var_x44;
        const double var_x46 = pow(var_chaste_interface__INa_m_gate__m, 3);
        const double var_x47 = var_x46 * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa_j_gate__j;
        const double var_x48 = var_x47 * var_chaste_interface__INa_h_gate__h;
        const double var_x49 = var_x33 * var_chaste_interface__membrane__Vm;
        const double var_x50 = var_x49 / pow(var_x34, 2);
        const double var_x51 = var_x37 * var_x50;
        const double var_x52 = var_x13 * var_chaste_interface__membrane__Vm;
        const double var_x53 = var_x17 * var_x52 / pow(var_x14, 2);
        const double var_x54 = var_x21 / pow(var_x22, 2);
        const double var_x55 = var_x31 * var_x40;
        const double var_x56 = var_x54 * var_x55;
        const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
        const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
        const double var_x59 = 1 / var_x58;
        const double var_x60 = var_x59;
        const double var_x61 = pow(var_chaste_interface__Na__Na_i, 3);
        const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
        const double var_x63 = var_x61 * var_x62;
        const double var_x64 = var_x57 * var_chaste_interface__Ca__Ca_i;
        const double var_x65 = 1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
        const double var_x66 = 1 / var_x65;
        const double var_x67 = 1 / (13227.9606 + 8.4084932990912282 * var_x61 + 4344355.375 * var_chaste_interface__Ca__Ca_i);
        const double var_x68 = var_x66 * var_x67;
        const double var_x69 = var_x68 * (0.065499179464098653 * var_x63 + 269964.43697145121 * var_x64);
        const double var_x70 = pow(var_chaste_interface__Na__Na_ss_sr, 3);
        const double var_x71 = var_x62 * var_x70;
        const double var_x72 = var_x57 * var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x73 = pow(var_chaste_interface__Ca__Ca_ss_sr, (-2));
        const double var_x74 = 1.0 + 1.5624999999999999e-8 * var_x73;
        const double var_x75 = 1 / var_x74;
        const double var_x76 = 1 / (13227.9606 + 8.4084932990912282 * var_x70 + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr);
        const double var_x77 = var_x75 * var_x76;
        const double var_x78 = var_x77 * (0.016374794866024663 * var_x71 + 67491.109242862804 * var_x72);
        const double var_x79 = pow(var_chaste_interface__Ito1_a_gate__a, 3);
        const double var_x80 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm);
        const double var_x81 = var_x79 * var_x80 * var_chaste_interface__Ito1_i1s_gate__i1s;
        const double var_x82 = 0.4975 * var_x81;
        const double var_x83 = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * NV_Ith_S(mParameters, 0);
        const double var_x84 = 14448.603861345418 * var_x83;
        const double var_x85 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x86 = var_x35 * var_x85;
        const double var_x87 = var_x84 * var_x86;
        const double var_x88 = var_x35 * var_x49;
        const double var_x89 = var_x88 * var_chaste_interface__Ca__Ca_i;
        const double var_x90 = var_x15 * var_x16 * var_chaste_interface__membrane__Vm;
        const double var_x91 = var_x24 * var_x29 / pow(var_x25, 2);
        const double var_x92 = 0.24326999999999999 * var_x54 - 0.51429999999999998 * var_x91 - var_x26 * (0.061749999999999999 * var_x28 + 0.039456396800000001 * var_x27);
        const double var_x93 = var_x23 * var_x40 / pow((var_x23 + 0.98039215686274506 * var_x30), 2);
        const double var_x94 = 0.49019607843137253 * var_x93;
        const double var_x95 = 1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i;
        const double var_x96 = pow(var_x95, (-3));
        const double var_x97 = exp(-3.4441726741524206 - var_x12);
        const double var_x98 = 1.0 + var_x97;
        const double var_x99 = var_x61 * var_x96 * var_x97 / pow(var_x98, 2);
        const double var_x100 = 1.0 - var_x13;
        const double var_x101 = 1 / var_x100;
        const double var_x102 = pow(var_chaste_interface__Irel__Irel, 2);
        const double var_x103 = 1.0 - 1.0 / (1.0 + 6.2499999999999991 * var_x102);
        const double var_x104 = -100.0 * var_x13 + var_chaste_interface__Cl__Cl_i;
        const double var_x105 = var_x101 * var_x103 * var_x104;
        const double var_x106 = 0.0032509358688027189 * var_x105;
        const double var_x107 = var_x103 * var_chaste_interface__Ito2_i2f_gate__i2f;
        const double var_x108 = var_x101 * var_x107;
        const double var_x109 = var_x108 * var_x52;
        const double var_x110 = var_x40 * var_x42 * NV_Ith_S(mParameters, 2) * var_chaste_interface__IKr_xr_gate__xr / pow(var_x43, 2);
        const double var_x111 = var_x40 * var_chaste_interface__Ito1_i1f_gate__i1f;
        const double var_x112 = var_x111 * var_x81;
        const double var_x113 = 6.4800000000000004 * var_x63 - 9878400.0 * var_x64;
        const double var_x114 = var_x113 * var_x68;
        const double var_x115 = var_x57 / pow(var_x58, 2);
        const double var_x116 = 0.0087452036595870152 * var_x115;
        const double var_x117 = 1.6200000000000001 * var_x71 - 2469600.0 * var_x72;
        const double var_x118 = var_x117 * var_x77;
        const double var_x119 = 1081.8149260630225 * var_x83;
        const double var_x120 = var_x50 * var_x85;
        const double var_x121 = var_x119 * var_x120;
        const double var_x122 = var_x104 * var_x107 * var_x52 / pow(var_x100, 2);
        const double var_x123 = var_x88 * var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x124 = var_x119 * var_x123;
        const double var_x125 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
        const double var_x126 = 1 / var_x125;
        const double var_x127 = pow(var_x125, (-2));
        const double var_x128 = var_x127 * var_chaste_interface__Ca__Ca_i;
        const double var_x129 = var_x57 * var_x59;
        const double var_x130 = var_x129 * var_x68;
        const double var_x131 = 2.3018374734134173e-7 * var_x59;
        const double var_x132 = var_x113 * var_x66 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x61 + var_chaste_interface__Ca__Ca_i), 2);
        const double var_x133 = 3.1249999999999999e-8 * var_x59;
        const double var_x134 = var_x113 * var_x67 / (pow(var_x65, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
        const double var_x135 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
        const double var_x136 = -26.711785007306684 * log(7.9662000000000006 / var_x135) + var_chaste_interface__membrane__Vm;
        const double var_x137 = var_x136 * var_x3 * var_x4 * var_x8 / pow(var_x5, 2);
        const double var_x138 = var_x136 * var_x7;
        const double var_x139 = var_x86 * var_chaste_interface__membrane__Vm;
        const double var_x140 = var_x139 * NV_Ith_S(mParameters, 0);
        const double var_x141 = 14448.603861345418 * var_x140;
        const double var_x142 = -var_x141;
        const double var_x143 = 1 / var_chaste_interface__Na__Na_i;
        const double var_x144 = log(140.0 * var_x143);
        const double var_x145 = -26.711785007306684 * var_x144 + var_chaste_interface__membrane__Vm;
        const double var_x146 = var_x145 * NV_Ith_S(mParameters, 1) * var_chaste_interface__INa_h_gate__h;
        const double var_x147 = var_x146 * pow(var_chaste_interface__INa_m_gate__m, 2) * var_chaste_interface__INa_j_gate__j;
        const double var_x148 = var_x145 * var_x47;
        const double var_x149 = var_x146 * var_x46;
        const double var_x150 = var_x145 * pow(var_chaste_interface__INaL_mL_gate__mL, 2) * var_chaste_interface__INaL_hL_gate__hL;
        const double var_x151 = var_x111 * var_x80;
        const double var_x152 = var_x151 * pow(var_chaste_interface__Ito1_a_gate__a, 2) * var_chaste_interface__Ito1_i1s_gate__i1s;
        const double var_x153 = var_x151 * var_x79;
        const double var_x154 = var_x101 * var_x104 * var_chaste_interface__Irel__Irel * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / pow((0.16000000000000003 + var_x102), 2);
        const double var_x155 = var_x129 * var_x77;
        const double var_x156 = var_x117 * var_x75 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x70 + var_chaste_interface__Ca__Ca_ss_sr), 2);
        const double var_x157 = var_x117 * var_x76 / (pow(var_x74, 2) * pow(var_chaste_interface__Ca__Ca_ss_sr, 3));
        const double var_x158 = var_x84 * var_x88;
        const double var_x159 = 1 / var_x98;
        const double var_x160 = var_x159 * var_x61 / pow(var_x95, 4);
        const double var_x161 = pow(var_chaste_interface__Na__Na_i, 2);
        const double var_x162 = var_x159 * var_x161 * var_x96;
        const double var_x163 = var_x15 * var_x52;
        const double var_x164 = var_x10 * var_x143 * var_chaste_interface__INaL_hL_gate__hL;
        const double var_x165 = (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x135, 2);
        const double var_x166 = var_x165 * var_x9;
        const double var_x167 = var_x132 * var_x59;
        const double var_x168 = var_x161 * var_x167;
        const double var_x169 = var_x143 * var_x48;
        const double var_x170 = var_x59 * var_x62;
        const double var_x171 = var_x161 * var_x170 * var_x68;
        const double var_x172 = pow(var_chaste_interface__Na__Na_ss_sr, 2);
        const double var_x173 = var_x156 * var_x59;
        const double var_x174 = var_x172 * var_x173;
        const double var_x175 = var_x170 * var_x172 * var_x77;
        const double var_x176 = 1 / var_chaste_interface__Cl__Cl_i;
        const double var_x177 = var_x108 * var_chaste_interface__membrane__Vm;
        const double var_x178 = var_x19 * var_x2;
        const double var_x179 = var_x19 * var_x32;
        const double var_x180 = var_x19 * var_x54;
        const double var_x181 = 6.4981759387274964 * var_x180 - var_x26 * (1.0539507884845836 * var_x19 * var_x27 + 1.6494527242011876 * var_x19 * var_x28) - 13.737871029257827 * var_x19 * var_x91;
        const double var_x182 = var_x19 * var_x44 * var_chaste_interface__IKr_xr_gate__xr;
        const double var_x183 = var_x180 * var_x55;
        const double var_x184 = var_x19 * var_x81 * var_chaste_interface__Ito1_i1f_gate__i1f;
        const double var_x185 = 8.8930116629204303e-8 * var_x38;
        const double var_x186 = 6.1700941025231664e-5 * var_x59;
        const double var_x187 = var_x114 * var_x115;
        const double var_x188 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
        const double var_x189 = 1.0 + 0.00011900000000000002 / pow(var_x188, 2) + 3.5000000000000004e-5 * var_x127;
        const double var_x190 = 1 / var_x189;
        const double var_x191 = var_x190;
        const double var_x192 = 1.7739020544754105e-6 * var_x126;
        const double var_x193 = 1.0 - var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x194 = 1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x195 = 1 / var_x194;
        const double var_x196 = 0.050000000000000003 * var_x195;
        const double var_x197 = var_x193 * var_x196;
        const double var_x198 = 0.14999999999999999 + var_x197 + var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x199 = 1 / var_x198;
        const double var_x200 = var_x197 + var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x201 = var_x199 * var_x200;
        const double var_x202 = 0.00092000000000000003 - 0.00017000000000000001 * var_x201 + var_chaste_interface__Ca__Ca_i;
        const double var_x203 = 1 / var_x202;
        const double var_x204 = 1.0 + 0.75 * var_x201;
        const double var_x205 = var_x203 * var_x204;
        const double var_x206 = 0.00035619469026548675 * var_x205;
        const double var_x207 = 0.00035619469026548675 * var_chaste_interface__Ca__Ca_i;
        const double var_x208 = var_x204 / pow(var_x202, 2);
        const double var_x209 = var_x207 * var_x208;
        const double var_x210 = var_x134 * var_x59;
        const double var_x211 = var_x193 * var_x73 / pow(var_x194, 2);
        const double var_x212 = var_x199 * var_x211;
        const double var_x213 = var_x200 / pow(var_x198, 2);
        const double var_x214 = var_x211 * var_x213;
        const double var_x215 = 5.6250000000000005e-5 * var_x212 - 5.6250000000000005e-5 * var_x214;
        const double var_x216 = var_x203 * var_x207;
        const double var_x217 = 1.2750000000000002e-8 * var_x212 - 1.2750000000000002e-8 * var_x214;
        const double var_x218 = 1 - var_x196;
        const double var_x219 = var_x199 * var_x218;
        const double var_x220 = var_x213 * (-1.0 + var_x196);
        const double var_x221 = 0.75 * var_x219 + 0.75 * var_x220;
        const double var_x222 = 0.00017000000000000001 * var_x219 + 0.00017000000000000001 * var_x220;
        const double var_x223 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
        const double var_x224 = 6.6501243234553463e-5 * var_x223 * var_chaste_interface__IKs__C1;
        const double var_x225 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
        const double var_x226 = 0.00017437799625617966 * var_x225;
        const double var_x227 = 0.059456000000000002 * var_x223;
        const double var_x228 = 0.083986000000000005 * var_x225;
        const double var_x229 = 4.9875932425915097e-5 * var_x223;
        const double var_x230 = -var_x229;
        const double var_x231 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
        const double var_x232 = 0.0001337287885861198 * var_x231;
        const double var_x233 = var_x226 - var_x232;
        const double var_x234 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
        const double var_x235 = 4.9743928555749341e-5 * var_x234;
        const double var_x236 = 0.00034875599251235932 * var_x225;
        const double var_x237 = 0.044592 * var_x223;
        const double var_x238 = -var_x237;
        const double var_x239 = 0.014600999999999999 * var_x231;
        const double var_x240 = -var_x228 - var_x239;
        const double var_x241 = 0.16797200000000001 * var_x225;
        const double var_x242 = 0.0031172999999999999 * var_x234;
        const double var_x243 = 3.3250621617276731e-5 * var_x223;
        const double var_x244 = -var_x243;
        const double var_x245 = 0.00026745757717223961 * var_x231;
        const double var_x246 = var_x236 - var_x245;
        const double var_x247 = 0.0005231339887685389 * var_x225;
        const double var_x248 = 0.029728000000000001 * var_x223;
        const double var_x249 = -var_x248;
        const double var_x250 = 0.029201999999999999 * var_x231;
        const double var_x251 = -var_x241 - var_x250;
        const double var_x252 = 0.25195800000000002 * var_x225;
        const double var_x253 = 1.6625310808638366e-5 * var_x223;
        const double var_x254 = -var_x253;
        const double var_x255 = 0.00040118636575835941 * var_x231;
        const double var_x256 = var_x247 - var_x255;
        const double var_x257 = 0.00069751198502471864 * var_x225;
        const double var_x258 = 0.014864 * var_x223;
        const double var_x259 = -var_x258;
        const double var_x260 = 0.043802999999999995 * var_x231;
        const double var_x261 = -var_x252 - var_x260;
        const double var_x262 = 0.33594400000000002 * var_x225;
        const double var_x263 = 0.00053491515434447921 * var_x231;
        const double var_x264 = 0.058403999999999998 * var_x231;
        const double var_x265 = -var_x242;
        const double var_x266 = 9.9487857111498683e-5 * var_x234;
        const double var_x267 = 0.0062345999999999999 * var_x234;
        const double var_x268 = -var_x267;
        const double var_x269 = 0.00014923178566724802 * var_x234;
        const double var_x270 = 0.0093518999999999998 * var_x234;
        const double var_x271 = -var_x270;
        const double var_x272 = 0.00019897571422299737 * var_x234 * var_chaste_interface__IKs__C15;
        const double var_x273 = 0.0124692 * var_x234;
        const double var_x274 = exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm);
        const double var_x275 = 0.00018735604223495543 * var_x274;
        const double var_x276 = 0.07732 * var_x274;
        const double var_x277 = exp(0.0105593841790373 * var_chaste_interface__membrane__Vm);
        const double var_x278 = 0.0061918116949038924 * var_x277;
        const double var_x279 = exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm);
        const double var_x280 = 0.0023832987830122916 * var_x279 * var_chaste_interface__IKs__O2;
        const double var_x281 = 0.58638000000000001 * var_x277;
        const double var_x282 = 0.79405000000000003 * var_x279;
        const double var_x283 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
        const double var_x284 = 1.0 + var_x283;
        const double var_x285 = 1 / var_x284;
        const double var_x286 = 0.80000000000000004 * var_x285;
        const double var_x287 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
        const double var_x288 = 1.0 + var_x287;
        const double var_x289 = var_x287 / pow(var_x288, 2);
        const double var_x290 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
        const double var_x291 = 1.0 + var_x290;
        const double var_x292 = -0.0038918839011179407 * var_x290 / pow(var_x291, 2);
        const double var_x293 = var_x292 + 0.0030285935177480471 * var_x289;
        const double var_x294 = 0.040277106492669565 / var_x291;
        const double var_x295 = 1 / var_x288;
        const double var_x296 = var_x294 + 0.032730010146303147 * var_x295;
        const double var_x297 = var_x283 / pow(var_x284, 2);
        const double var_x298 = 0.26666666666666666 * var_x296 * var_x297;
        const double var_x299 = -var_x298 + var_x293 * (-0.80000000000000004 + var_x286);
        const double var_x300 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
        const double var_x301 = 1.0 + var_x300;
        const double var_x302 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x303 = 1.0 + var_x302;
        const double var_x304 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
        const double var_x305 = var_x304 / var_x303;
        const double var_x306 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x305);
        const double var_x307 = 0.10582010582010583 * var_x300 * var_x306 / pow(var_x301, 2);
        const double var_x308 = 1 / var_x301;
        const double var_x309 = 1.5624999999999998 * (-0.041599999999999998 * var_x305 + 0.10560000000000001 * var_x302 * var_x304 / pow(var_x303, 2)) / pow((0.73749999999999993 + var_x305), 2);
        const double var_x310 = var_x308 * var_x309;
        const double var_x311 = -var_x307 - var_x310;
        const double var_x312 = 0.20000000000000001 + var_x286;
        const double var_x313 = var_x293 * var_x312;
        const double var_x314 = var_x308;
        const double var_x315 = 1.0 - var_x314;
        const double var_x316 = var_x309 * var_x315;
        const double var_x317 = var_x306 * var_x314;
        const double var_x318 = -var_x317;
        const double var_x319 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
        const double var_x320 = 1 / var_x319;
        const double var_x321 = 3.0 * var_x320;
        const double var_x322 = -var_x286;
        const double var_x323 = 0.80000000000000004 + var_x322;
        const double var_x324 = var_x296 * var_x323;
        const double var_x325 = -var_x321 - var_x324;
        const double var_x326 = var_x306 * var_x315;
        const double var_x327 = var_x296 * var_x312;
        const double var_x328 = 1 / (pow(var_x319, 2) * pow(var_chaste_interface__Ca__Ca_ss_CaL, 5));
        const double var_x329 = 9.7200000000000016e-10 * var_x328;
        const double var_x330 = var_x329 * var_chaste_interface__ICaL__C;
        const double var_x331 = var_x307 - var_x316;
        const double var_x332 = -var_x326;
        const double var_x333 = var_x329 * var_chaste_interface__ICaL__O;
        const double var_x334 = 0.99990000999900008 * var_x285;
        const double var_x335 = -0.99990000999900008 + var_x334;
        const double var_x336 = 1 / (25.0 - 17.5 * var_x320);
        const double var_x337 = var_x292 + 0.092532617747756077 * var_x289 * var_x336;
        const double var_x338 = var_x294 + var_x295 * var_x336;
        const double var_x339 = 0.33330000333300003 * var_x297 * var_x338;
        const double var_x340 = -var_x339 + var_x335 * var_x337;
        const double var_x341 = 9.9990000999900015e-5 + var_x334;
        const double var_x342 = var_x337 * var_x341;
        const double var_x343 = -var_x334;
        const double var_x344 = 0.99990000999900008 + var_x343;
        const double var_x345 = var_x338 * var_x344;
        const double var_x346 = -1.0 - var_x345;
        const double var_x347 = var_x338 * var_x341;
        const double var_x348 = 9.0720000000000001e-12 * var_x295 * var_x328 / pow((1 - 0.69999999999999996 * var_x320), 2);
        const double var_x349 = var_x341 * var_x348;
        const double var_x350 = var_x335 * var_x348;
        const double var_x351 = 1 / var_x323;
        const double var_x352 = 1 / var_x341;
        const double var_x353 = var_x320 * var_x344 * var_x351 * var_x352;
        const double var_x354 = 7.9999999999999996e-7 * var_x297 * var_x353;
        const double var_x355 = var_x312 * var_x351 * var_x352;
        const double var_x356 = var_x297 * var_x320;
        const double var_x357 = 9.9990000999900006e-7 * var_x355 * var_x356;
        const double var_x358 = var_x312 * var_x344 * var_x356;
        const double var_x359 = 1.2499999999999999e-6 * var_x352 * var_x358 / pow((1 - var_x285), 2);
        const double var_x360 = 1.0001e-6 * var_x351 * var_x358 / pow((0.0001 + var_x285), 2);
        const double var_x361 = var_x298 + var_x354 + var_x359 - var_x357 - var_x360 + var_x293 * (-0.20000000000000001 + var_x322);
        const double var_x362 = var_x293 * var_x323;
        const double var_x363 = 3.0000000000000001e-6 * var_x312 * var_x353;
        const double var_x364 = -var_x327 - var_x363;
        const double var_x365 = 9.7200000000000002e-16 * var_x328 * var_x344 * var_x355;
        const double var_x366 = var_x365 * var_chaste_interface__ICaL__CI;
        const double var_x367 = var_x365 * var_chaste_interface__ICaL__OI;
        const double var_x368 = -9.9990000999900015e-5 + var_x343;
        const double var_x369 = var_x339 + var_x337 * var_x368;
        const double var_x370 = var_x337 * var_x344;
        const double var_x371 = -9.9999999999999995e-7 - var_x347;
        const double var_x372 = var_x344 * var_x348;
        const double var_x373 = var_x348 * var_x368;
        const double var_x374 = 1.0 - var_chaste_interface__INa_m_gate__m;
        const double var_x375 = -0.10000000000000001 * var_chaste_interface__membrane__Vm;
        const double var_x376 = exp(-4.7130000000000001 + var_x375);
        const double var_x377 = 1.0 - var_x376;
        const double var_x378 = 0.32000000000000001 / var_x377;
        const double var_x379 = exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm);
        const double var_x380 = 0.0072727272727272727 * var_x379;
        const double var_x381 = 47.130000000000003 + var_chaste_interface__membrane__Vm;
        const double var_x382 = 0.032000000000000001 * var_x376 * var_x381 / pow(var_x377, 2);
        const double var_x383 = -0.080000000000000002 * var_x379 - var_x378 * var_x381;
        const double var_x384 = var_chaste_interface__membrane__Vm >= -40.0;
        const double var_x385 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm);
        const double var_x386 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm);
        const double var_x387 = 1.0 + var_x386;
        const double var_x388 = exp(0.079000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x389 = exp(0.34999999999999998 * var_chaste_interface__membrane__Vm);
        const double var_x390 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm);
        const double var_x391 = 1.0 + var_x390;
        const double var_x392 = 1 / var_x391;
        const double var_x393 = exp(0.24440000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x394 = exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm);
        const double var_x395 = -127140.0 * var_x393 - 6.9480000000000006e-5 * var_x394;
        const double var_x396 = var_x392 * var_x395;
        const double var_x397 = 37.780000000000001 + var_chaste_interface__membrane__Vm;
        const double var_x398 = exp(-3.2000000000000002 + var_x375);
        const double var_x399 = 1.0 + var_x398;
        const double var_x400 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm);
        const double var_x401 = var_x400 / var_x399;
        const double var_x402 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x403 = 1.0 + var_x402;
        const double var_x404 = exp(-0.01052 * var_chaste_interface__membrane__Vm);
        const double var_x405 = var_x404 / var_x403;
        const double var_x406 = 1.0 - var_chaste_interface__INaL_mL_gate__mL;
        const double var_x407 = exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm);
        const double var_x408 = exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm);
        const double var_x409 = 1.0 + var_x408;
        const double var_x410 = exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm);
        const double var_x411 = -1.0 + var_x410;
        const double var_x412 = 0.00029999999999999997 / var_x411;
        const double var_x413 = exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x414 = 1.0 - var_x413;
        const double var_x415 = 0.00059999999999999995 / var_x414;
        const double var_x416 = -1.7383999999999999 + var_chaste_interface__membrane__Vm;
        const double var_x417 = 38.360799999999998 + var_chaste_interface__membrane__Vm;
        const double var_x418 = var_x412 * var_x417;
        const double var_x419 = var_x415 * var_x416;
        const double var_x420 = exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm);
        const double var_x421 = 1.0 + var_x420;
        const double var_x422 = 0.034035137876343539 * var_chaste_interface__membrane__Vm;
        const double var_x423 = exp(0.62658348478969694 - var_x422);
        const double var_x424 = 1.0 + var_x423;
        const double var_x425 = exp(3.403513787634354 + var_x422);
        const double var_x426 = 1.0 + var_x425;
        const double var_x427 = 3.5 / var_x426;
        const double var_x428 = 0.82719827942757873 / var_x424;
        const double var_x429 = 0.20000000000000001 * var_chaste_interface__membrane__Vm;
        const double var_x430 = exp(11.6 + var_x429);
        const double var_x431 = 1.0 + var_x430;
        const double var_x432 = var_x430 / pow(var_x431, 2);
        const double var_x433 = 0.0050000000000000001 * var_x432;
        const double var_x434 = exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm);
        const double var_x435 = 1.0 + var_x434;
        const double var_x436 = var_x434 / pow(var_x435, 2);
        const double var_x437 = 0.011343308638950427 * var_x436;
        const double var_x438 = 1 / var_x431;
        const double var_x439 = 0.025000000000000001 * var_x438;
        const double var_x440 = 1 / var_x435;
        const double var_x441 = -0.10208977775055385 * var_x440;
        const double var_x442 = exp(12.0 + var_x429);
        const double var_x443 = 1.0 + var_x442;
        const double var_x444 = 1 / var_chaste_interface__Ca__Ca_JSR;
        const double var_x445 = pow(var_x444, 8.0);
        const double var_x446 = 1.0 + var_x445;
        const double var_x447 = 1 / var_x446;
        const double var_x448 = 1 / var_x200;
        const double var_x449 = pow(var_x448, 10.0);
        const double var_x450 = 1.0 + 2.9619676669542428e-6 * var_x449;
        const double var_x451 = 1 / var_x450;
        const double var_x452 = 0.53437500000000004 + 0.53437500000000004 * var_x451;
        const double var_x453 = var_x447 * var_x452;
        const double var_x454 = var_x453 * var_x87;
        const double var_x455 = 1 / (4.75 + 4.75 * var_x451);
        const double var_x456 = 1.0 + 0.0123 * var_x444;
        const double var_x457 = var_x455 * var_x456;
        const double var_x458 = var_x453 * var_x457;
        const double var_x459 = -var_x141 * var_x458;
        const double var_x460 = -var_chaste_interface__Irel__Irel;
        const double var_x461 = var_x460 - var_x454 * var_chaste_interface__membrane__Vm;
        const double var_x462 = var_x139 * var_x457 * var_x83;
        const double var_x463 = var_x456 * var_x461 / pow((1 + var_x451), 2);
        const double var_x464 = var_x448 * var_x449 / pow(var_x450, 2);
        const double var_x465 = var_x211 * var_x464;
        const double var_x466 = var_x447 * var_x462;
        const double var_x467 = var_x464 * (-1 + var_x196);
        const double var_x468 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR;
        const double var_x469 = pow(var_x468, (-2));
        const double var_x470 = 1 / (1.0 + 8.0 * var_x469);
        const double var_x471 = 0.040000000000000001 * var_x470;
        const double var_x472 = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_i;
        const double var_x473 = var_x208 * var_x472;
        const double var_x474 = var_x203 * var_x472;
        const double var_x475 = 0.0020916619007553534 * var_x59;
        const double var_x476 = var_x115 * var_x118;
        const double var_x477 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x478 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x479 = 1.0 + 0.0097788000000000007 / pow(var_x477, 2) + 4.0890000000000003e-5 / pow(var_x478, 2);
        const double var_x480 = 1 / var_x479;
        const double var_x481 = var_x480;
        const double var_x482 = var_x157 * var_x59;
        const double var_x483 = 151.10797107941448 * var_x83;
        const double var_x484 = 11.313955322572472 * var_x83;
        const double var_x485 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x486 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x487 = 1.0 + 0.0097788000000000007 / pow(var_x485, 2) + 4.0890000000000003e-5 / pow(var_x486, 2);
        const double var_x488 = 1 / var_x487;
        const double var_x489 = var_x488;
        const double var_x490 = -151.10797107941448 * var_x140 * var_x488;
        const double var_x491 = 4.0105611666400582e-7 * var_x10;
        const double var_x492 = log(100.0 * var_x176);
        const double var_x493 = var_x144 + var_x492;
        const double var_x494 = pow(var_x493, 4);
        const double var_x495 = 7.2087469970547496e-9 * pow(var_x493, 7) / pow((1 + 0.0085573053764671191 * var_x494), 2);
        const double var_x496 = 50.118419258935766 * pow(var_x493, 3) / (59494197.640692554 + 509110.01733929582 * var_x494);
        const double var_x497 = var_x143 * var_x495 - var_x143 * var_x496;
        const double var_x498 = var_x176 * var_x495 - var_x176 * var_x496;
        const double var_x499 = var_x39 + 26.711785007306684 * var_x492;
        const double var_x500 = 0.00047279859462932828 / (87.825100000000006 + var_x499);
        const double var_x501 = 6.1296950776416711e-8 * var_x499 / pow((1 + 0.30414750461208334 * var_x20 + 0.30414750461208334 * var_x492), 2);
        const double var_x502 = var_x176 * var_x501 - var_x176 * var_x500;
        const double var_x503 = var_x19 * var_x501 - var_x19 * var_x500;
        const double var_x504 = 6.799858698573652e-6 * var_x105;
        const double var_x505 = -5.0964977286841363e-6 - 3.0578986372104813e-6 * var_x6;
        const double var_x506 = var_x505 * var_x8;
        const double var_x507 = 6.1700941025231664e-5 * var_x44;
        const double var_x508 = 3.0696218160052752e-5 * var_x81;
        const double var_x509 = 3.0245559326093954e-5 * var_x93;
        const double var_x510 = var_x136 * var_x505;
        const double var_x511 = var_x165 * var_x506;
        const double var_x512 = 0.0025000000000000005 * var_x195;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00022499999999999999 + var_x121 + var_x9 - var_x124 - var_x48 - var_x87 + 0.012170417918209005 * var_x109 + 0.064935064935064929 * var_x110 + 0.00021583116499495196 * var_x51 + 4.3272597042520909e-7 * var_x53 + 0.12163499999999999 * var_x56 - 0.0027599999999999999 * var_x2 - 0.00012170417918209004 * var_x122 - 1.1558883089076335e-5 * var_x18 - 0.00021583116499495196 * var_x89 - 4.3272597042520909e-7 * var_x90 - 0.00090454545454545453 * var_x112 - 0.51000000000000001 * var_x32 - 0.00233372538501551 * var_x99 - 0.0028826178386108462 * var_x38 - 0.00046153846153846147 * var_x41 - var_x106 * var_chaste_interface__Ito2_i2f_gate__i2f - var_x11 * var_chaste_interface__INaL_hL_gate__hL - var_x114 * var_x116 - var_x116 * var_x118 - var_x45 * var_chaste_interface__IKr_xr_gate__xr - var_x60 * var_x69 - var_x60 * var_x78 - var_x82 * var_chaste_interface__Ito1_i1f_gate__i1f - var_x92 * var_x94);
        IJth(rJacobian, 1, 0) = var_x191 * (-var_x185 + 6.6584929913802883e-9 * var_x51 + 5.3958729525381867e-7 * var_x187 - 6.6584929913802883e-9 * var_x89 + var_x186 * var_x69);
        IJth(rJacobian, 2, 0) = -var_x224 - var_x226 * var_chaste_interface__IKs__C2;
        IJth(rJacobian, 3, 0) = var_x224 + (var_x230 + var_x233) * var_chaste_interface__IKs__C2 - var_x235 * var_chaste_interface__IKs__C6 - var_x236 * var_chaste_interface__IKs__C3;
        IJth(rJacobian, 4, 0) = var_x229 * var_chaste_interface__IKs__C2 + (var_x244 + var_x246) * var_chaste_interface__IKs__C3 - var_x235 * var_chaste_interface__IKs__C7 - var_x247 * var_chaste_interface__IKs__C4;
        IJth(rJacobian, 5, 0) = var_x243 * var_chaste_interface__IKs__C3 + (var_x254 + var_x256) * var_chaste_interface__IKs__C4 - var_x235 * var_chaste_interface__IKs__C8 - var_x257 * var_chaste_interface__IKs__C5;
        IJth(rJacobian, 6, 0) = var_x253 * var_chaste_interface__IKs__C4 + (var_x257 - var_x263) * var_chaste_interface__IKs__C5 - var_x235 * var_chaste_interface__IKs__C9;
        IJth(rJacobian, 7, 0) = var_x232 * var_chaste_interface__IKs__C2 + (var_x230 + var_x235) * var_chaste_interface__IKs__C6 - var_x226 * var_chaste_interface__IKs__C7;
        IJth(rJacobian, 8, 0) = var_x229 * var_chaste_interface__IKs__C6 + var_x245 * var_chaste_interface__IKs__C3 + (var_x233 + var_x235 + var_x244) * var_chaste_interface__IKs__C7 - var_x236 * var_chaste_interface__IKs__C8 - var_x266 * var_chaste_interface__IKs__C10;
        IJth(rJacobian, 9, 0) = var_x243 * var_chaste_interface__IKs__C7 + var_x255 * var_chaste_interface__IKs__C4 + (var_x235 + var_x246 + var_x254) * var_chaste_interface__IKs__C8 - var_x247 * var_chaste_interface__IKs__C9 - var_x266 * var_chaste_interface__IKs__C11;
        IJth(rJacobian, 10, 0) = var_x253 * var_chaste_interface__IKs__C8 + var_x263 * var_chaste_interface__IKs__C5 + (var_x235 + var_x256) * var_chaste_interface__IKs__C9 - var_x266 * var_chaste_interface__IKs__C12;
        IJth(rJacobian, 11, 0) = var_x232 * var_chaste_interface__IKs__C7 + (var_x244 + var_x266) * var_chaste_interface__IKs__C10 - var_x226 * var_chaste_interface__IKs__C11;
        IJth(rJacobian, 12, 0) = var_x243 * var_chaste_interface__IKs__C10 + var_x245 * var_chaste_interface__IKs__C8 + (var_x233 + var_x254 + var_x266) * var_chaste_interface__IKs__C11 - var_x236 * var_chaste_interface__IKs__C12 - var_x269 * var_chaste_interface__IKs__C13;
        IJth(rJacobian, 13, 0) = var_x253 * var_chaste_interface__IKs__C11 + var_x255 * var_chaste_interface__IKs__C9 + (var_x246 + var_x266) * var_chaste_interface__IKs__C12 - var_x269 * var_chaste_interface__IKs__C14;
        IJth(rJacobian, 14, 0) = var_x232 * var_chaste_interface__IKs__C11 + (var_x254 + var_x269) * var_chaste_interface__IKs__C13 - var_x226 * var_chaste_interface__IKs__C14;
        IJth(rJacobian, 15, 0) = -var_x272 + var_x245 * var_chaste_interface__IKs__C12 + var_x253 * var_chaste_interface__IKs__C13 + (var_x233 + var_x269) * var_chaste_interface__IKs__C14;
        IJth(rJacobian, 16, 0) = var_x272 + var_x232 * var_chaste_interface__IKs__C14 - var_x275 * var_chaste_interface__IKs__O1;
        IJth(rJacobian, 17, 0) = -var_x280 + (var_x275 - var_x278) * var_chaste_interface__IKs__O1;
        IJth(rJacobian, 18, 0) = var_x280 + var_x278 * var_chaste_interface__IKs__O1;
        IJth(rJacobian, 19, 0) = var_x313 * var_chaste_interface__ICaL__CI + var_x316 * var_chaste_interface__ICaL__O + (var_x299 + var_x311) * var_chaste_interface__ICaL__C - var_x298 * var_chaste_interface__ICaL__CI - var_x307 * var_chaste_interface__ICaL__O;
        IJth(rJacobian, 20, 0) = var_x307 * var_chaste_interface__ICaL__C + var_x310 * var_chaste_interface__ICaL__C + var_x313 * var_chaste_interface__ICaL__OI + (var_x299 + var_x331) * var_chaste_interface__ICaL__O - var_x298 * var_chaste_interface__ICaL__OI;
        IJth(rJacobian, 21, 0) = var_x316 * var_chaste_interface__ICaL__O_star + var_x342 * var_chaste_interface__ICaL__CI_star + (var_x311 + var_x340) * var_chaste_interface__ICaL__C_star - var_x307 * var_chaste_interface__ICaL__O_star - var_x339 * var_chaste_interface__ICaL__CI_star;
        IJth(rJacobian, 22, 0) = var_x307 * var_chaste_interface__ICaL__C_star + var_x310 * var_chaste_interface__ICaL__C_star + var_x342 * var_chaste_interface__ICaL__OI_star + (var_x331 + var_x340) * var_chaste_interface__ICaL__O_star - var_x339 * var_chaste_interface__ICaL__OI_star;
        IJth(rJacobian, 23, 0) = var_x298 * var_chaste_interface__ICaL__C + var_x316 * var_chaste_interface__ICaL__OI + var_x362 * var_chaste_interface__ICaL__C + (var_x311 + var_x361) * var_chaste_interface__ICaL__CI - var_x307 * var_chaste_interface__ICaL__OI;
        IJth(rJacobian, 24, 0) = var_x298 * var_chaste_interface__ICaL__O + var_x307 * var_chaste_interface__ICaL__CI + var_x310 * var_chaste_interface__ICaL__CI + var_x362 * var_chaste_interface__ICaL__O + (var_x331 + var_x361) * var_chaste_interface__ICaL__OI;
        IJth(rJacobian, 25, 0) = var_x316 * var_chaste_interface__ICaL__OI_star + var_x339 * var_chaste_interface__ICaL__C_star + var_x357 * var_chaste_interface__ICaL__CI + var_x360 * var_chaste_interface__ICaL__CI + var_x370 * var_chaste_interface__ICaL__C_star + (var_x311 + var_x369) * var_chaste_interface__ICaL__CI_star - var_x307 * var_chaste_interface__ICaL__OI_star - var_x354 * var_chaste_interface__ICaL__CI - var_x359 * var_chaste_interface__ICaL__CI;
        IJth(rJacobian, 26, 0) = var_x307 * var_chaste_interface__ICaL__CI_star + var_x310 * var_chaste_interface__ICaL__CI_star + var_x339 * var_chaste_interface__ICaL__O_star + var_x357 * var_chaste_interface__ICaL__OI + var_x360 * var_chaste_interface__ICaL__OI + var_x370 * var_chaste_interface__ICaL__O_star + (var_x331 + var_x369) * var_chaste_interface__ICaL__OI_star - var_x354 * var_chaste_interface__ICaL__OI - var_x359 * var_chaste_interface__ICaL__OI;
        IJth(rJacobian, 27, 0) = var_x374 * var_x378 + var_x380 * var_chaste_interface__INa_m_gate__m - var_x374 * var_x382;
        IJth(rJacobian, 28, 0) = (1.0 - var_chaste_interface__INa_h_gate__h) * ((var_x384) ? (0) : (-0.019852941176470591 * var_x385)) - ((var_x384) ? (0.693000693000693 * var_x386 / pow(var_x387, 2)) : (0.28123999999999999 * var_x388 + 108500.0 * var_x389)) * var_chaste_interface__INa_h_gate__h;
        IJth(rJacobian, 29, 0) = (1.0 - var_chaste_interface__INa_j_gate__j) * ((var_x384) ? (0) : (var_x396 + var_x392 * var_x397 * (3.0508668000000001e-6 * var_x394 - 31073.016 * var_x393) - 0.311 * var_x390 * var_x395 * var_x397 / pow(var_x391, 2))) - ((var_x384) ? (-7.6049999999999996e-8 * var_x401 + 0.029999999999999999 * var_x398 * var_x400 / pow(var_x399, 2)) : (-0.001275024 * var_x405 + 0.016701360000000002 * var_x402 * var_x404 / pow(var_x403, 2))) * var_chaste_interface__INa_j_gate__j;
        IJth(rJacobian, 30, 0) = var_x378 * var_x406 + var_x380 * var_chaste_interface__INaL_mL_gate__mL - var_x382 * var_x406;
        IJth(rJacobian, 31, 0) = -0.00027322404371584699 * var_x407 / pow((1.0 + var_x407), 2);
        IJth(rJacobian, 32, 0) = (-var_chaste_interface__IKr_xr_gate__xr + 1 / var_x409) * (var_x412 + var_x415 - 8.1600000000000005e-5 * var_x413 * var_x416 / pow(var_x414, 2) - 4.566e-5 * var_x410 * var_x417 / pow(var_x411, 2)) + 0.23529411764705882 * var_x408 * (var_x418 + var_x419) / pow(var_x409, 2);
        IJth(rJacobian, 33, 0) = (-var_chaste_interface__Ito1_a_gate__a + 1 / var_x421) * (0.028153807491391791 * var_x423 / pow(var_x424, 2) - 0.11912298256720238 * var_x425 / pow(var_x426, 2)) + 0.14019346698443852 * var_x420 * (var_x427 + var_x428) / pow(var_x421, 2);
        IJth(rJacobian, 34, 0) = -var_x433 * (1.0 - var_chaste_interface__Ito1_i1f_gate__i1f) - var_x437 * var_chaste_interface__Ito1_i1f_gate__i1f;
        IJth(rJacobian, 35, 0) = -var_x437 * var_chaste_interface__Ito1_i1s_gate__i1s - 0.00080000000000000004 * var_x442 * (1.0 - var_chaste_interface__Ito1_i1s_gate__i1s) / pow(var_x443, 2);
        IJth(rJacobian, 36, 0) = -0.00062500000000000001 * var_x432 / (var_x439 + 0.20000000000000001 * var_x440) + 0.078125 * var_x438 * (var_x433 - 0.022222222222222223 * var_x436) / pow((var_x440 + 0.125 * var_x438), 2);
        IJth(rJacobian, 37, 0) = var_x457 * (-var_x454 + var_x121 * var_x453 - var_x124 * var_x453);
        IJth(rJacobian, 40, 0) = var_x481 * (1.8292009309104452e-5 * var_x476 + var_x475 * var_x78);
        IJth(rJacobian, 41, 0) = var_x489 * (var_x120 * var_x484 - var_x123 * var_x484 - var_x483 * var_x86);
        IJth(rJacobian, 42, 0) = 2.6699599581291967e-11 * var_x53 - 7.1319396379664657e-10 * var_x18 - 6.1700941025231664e-5 * var_x48 - 1.6187618857614559e-6 * var_x187 - 4.3197915704978414e-7 * var_x99 - 2.6699599581291967e-11 * var_x90 - var_x491 * var_chaste_interface__INaL_hL_gate__hL - 0.00018510282307569501 * var_x59 * var_x69;
        IJth(rJacobian, 43, 0) = -5.4876027927313356e-5 * var_x476 - 0.0062749857022660607 * var_x59 * var_x78;
        IJth(rJacobian, 44, 0) = 1.3882711730677125e-8;
        IJth(rJacobian, 45, 0) = 2.5456399475788057e-7 * var_x122 - 2.5456399475788059e-5 * var_x109 + var_x504 * var_chaste_interface__Ito2_i2f_gate__i2f;
        IJth(rJacobian, 46, 0) = var_x506 + 7.5049939616040537e-6 * var_x56 + 4.00655461202803e-6 * var_x110 + 2.8798610469985608e-7 * var_x99 - 2.8477357396260765e-8 * var_x41 - 3.1467479922868152e-5 * var_x32 - 1.7029459722963939e-7 * var_x2 - 5.5811305745550463e-8 * var_x112 - var_x507 * var_chaste_interface__IKr_xr_gate__xr - var_x508 * var_chaste_interface__Ito1_i1f_gate__i1f - var_x509 * var_x92;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (0.057500000000000002 * var_x128 + 9878400.0 * var_x130 - 0.057500000000000002 * var_x126 - 0.0028826178386108462 * var_x88 - 4.4973467007233054e-8 * var_x137 + var_x131 * var_x132 - var_x133 * var_x134);
        IJth(rJacobian, 1, 1) = var_x191 * (-0.014749262536873154 + var_x209 - var_x192 - var_x206 + 1.9281544070384897e-12 * var_x210 + 1.7739020544754105e-6 * var_x128 - 609.50657582364852 * var_x130 - 1.4202553819674954e-11 * var_x167 - 8.8930116629204303e-8 * var_x88) + (0.00023800000000000004 / pow(var_x188, 3) + 7.0000000000000007e-5 / pow(var_x125, 3)) * (2.3746312684365782e-5 * var_chaste_interface__Ca__Ca_NSR + 0.014749262536873154 * var_chaste_interface__Ca__Ca_ss_sr - 0.014749262536873154 * var_chaste_interface__Ca__Ca_i + var_x114 * var_x186 - var_x185 * var_chaste_interface__membrane__Vm - var_x192 * var_chaste_interface__Ca__Ca_i - var_x206 * var_chaste_interface__Ca__Ca_i) / pow(var_x189, 2);
        IJth(rJacobian, 39, 1) = -var_x473 + 0.0043750000000000004 * var_x205;
        IJth(rJacobian, 40, 1) = 5.0 * var_x480;
        IJth(rJacobian, 42, 1) = 4.2607661459024858e-11 * var_x167 + 1828.5197274709456 * var_x130 - 5.784463221115469e-12 * var_x210;
        IJth(rJacobian, 46, 1) = -2.774905235513489e-12 * var_x137;
        IJth(rJacobian, 2, 2) = -var_x227;
        IJth(rJacobian, 3, 2) = var_x227;
        IJth(rJacobian, 2, 3) = var_x228;
        IJth(rJacobian, 3, 3) = var_x238 + var_x240;
        IJth(rJacobian, 4, 3) = var_x237;
        IJth(rJacobian, 7, 3) = var_x239;
        IJth(rJacobian, 3, 4) = var_x241;
        IJth(rJacobian, 4, 4) = var_x249 + var_x251;
        IJth(rJacobian, 5, 4) = var_x248;
        IJth(rJacobian, 8, 4) = var_x250;
        IJth(rJacobian, 4, 5) = var_x252;
        IJth(rJacobian, 5, 5) = var_x259 + var_x261;
        IJth(rJacobian, 6, 5) = var_x258;
        IJth(rJacobian, 9, 5) = var_x260;
        IJth(rJacobian, 5, 6) = var_x262;
        IJth(rJacobian, 6, 6) = -var_x262 - var_x264;
        IJth(rJacobian, 10, 6) = var_x264;
        IJth(rJacobian, 3, 7) = var_x242;
        IJth(rJacobian, 7, 7) = var_x238 + var_x265;
        IJth(rJacobian, 8, 7) = var_x237;
        IJth(rJacobian, 4, 8) = var_x242;
        IJth(rJacobian, 7, 8) = var_x228;
        IJth(rJacobian, 8, 8) = var_x240 + var_x249 + var_x265;
        IJth(rJacobian, 9, 8) = var_x248;
        IJth(rJacobian, 11, 8) = var_x239;
        IJth(rJacobian, 5, 9) = var_x242;
        IJth(rJacobian, 8, 9) = var_x241;
        IJth(rJacobian, 9, 9) = var_x251 + var_x259 + var_x265;
        IJth(rJacobian, 10, 9) = var_x258;
        IJth(rJacobian, 12, 9) = var_x250;
        IJth(rJacobian, 6, 10) = var_x242;
        IJth(rJacobian, 9, 10) = var_x252;
        IJth(rJacobian, 10, 10) = var_x261 + var_x265;
        IJth(rJacobian, 13, 10) = var_x260;
        IJth(rJacobian, 8, 11) = var_x267;
        IJth(rJacobian, 11, 11) = var_x249 + var_x268;
        IJth(rJacobian, 12, 11) = var_x248;
        IJth(rJacobian, 9, 12) = var_x267;
        IJth(rJacobian, 11, 12) = var_x228;
        IJth(rJacobian, 12, 12) = var_x240 + var_x259 + var_x268;
        IJth(rJacobian, 13, 12) = var_x258;
        IJth(rJacobian, 14, 12) = var_x239;
        IJth(rJacobian, 10, 13) = var_x267;
        IJth(rJacobian, 12, 13) = var_x241;
        IJth(rJacobian, 13, 13) = var_x251 + var_x268;
        IJth(rJacobian, 15, 13) = var_x250;
        IJth(rJacobian, 12, 14) = var_x270;
        IJth(rJacobian, 14, 14) = var_x259 + var_x271;
        IJth(rJacobian, 15, 14) = var_x258;
        IJth(rJacobian, 13, 15) = var_x270;
        IJth(rJacobian, 14, 15) = var_x228;
        IJth(rJacobian, 15, 15) = var_x240 + var_x271;
        IJth(rJacobian, 16, 15) = var_x239;
        IJth(rJacobian, 15, 16) = var_x273;
        IJth(rJacobian, 16, 16) = -0.089538000000000006 - var_x273;
        IJth(rJacobian, 17, 16) = 0.089538000000000006;
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (var_x138);
        IJth(rJacobian, 16, 17) = var_x276;
        IJth(rJacobian, 17, 17) = -var_x276 - var_x281;
        IJth(rJacobian, 18, 17) = var_x281;
        IJth(rJacobian, 46, 17) = var_x510;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (var_x138);
        IJth(rJacobian, 17, 18) = var_x282;
        IJth(rJacobian, 18, 18) = -var_x282;
        IJth(rJacobian, 46, 18) = var_x510;
        IJth(rJacobian, 19, 19) = var_x318 + var_x325;
        IJth(rJacobian, 20, 19) = var_x317;
        IJth(rJacobian, 21, 19) = var_x321;
        IJth(rJacobian, 23, 19) = var_x324;
        IJth(rJacobian, 0, 20) = mSetVoltageDerivativeToZero ? 0.0 : (var_x142);
        IJth(rJacobian, 19, 20) = var_x326;
        IJth(rJacobian, 20, 20) = var_x325 + var_x332;
        IJth(rJacobian, 22, 20) = var_x321;
        IJth(rJacobian, 24, 20) = var_x324;
        IJth(rJacobian, 37, 20) = var_x459;
        IJth(rJacobian, 41, 20) = var_x490;
        IJth(rJacobian, 19, 21) = 1.0;
        IJth(rJacobian, 21, 21) = var_x318 + var_x346;
        IJth(rJacobian, 22, 21) = var_x317;
        IJth(rJacobian, 25, 21) = var_x345;
        IJth(rJacobian, 0, 22) = mSetVoltageDerivativeToZero ? 0.0 : (var_x142);
        IJth(rJacobian, 20, 22) = 1.0;
        IJth(rJacobian, 21, 22) = var_x326;
        IJth(rJacobian, 22, 22) = var_x332 + var_x346;
        IJth(rJacobian, 26, 22) = var_x345;
        IJth(rJacobian, 37, 22) = var_x459;
        IJth(rJacobian, 41, 22) = var_x490;
        IJth(rJacobian, 19, 23) = var_x327;
        IJth(rJacobian, 23, 23) = var_x318 + var_x364;
        IJth(rJacobian, 24, 23) = var_x317;
        IJth(rJacobian, 25, 23) = var_x363;
        IJth(rJacobian, 20, 24) = var_x327;
        IJth(rJacobian, 23, 24) = var_x326;
        IJth(rJacobian, 24, 24) = var_x332 + var_x364;
        IJth(rJacobian, 26, 24) = var_x363;
        IJth(rJacobian, 21, 25) = var_x347;
        IJth(rJacobian, 23, 25) = 9.9999999999999995e-7;
        IJth(rJacobian, 25, 25) = var_x318 + var_x371;
        IJth(rJacobian, 26, 25) = var_x317;
        IJth(rJacobian, 22, 26) = var_x347;
        IJth(rJacobian, 24, 26) = 9.9999999999999995e-7;
        IJth(rJacobian, 25, 26) = var_x326;
        IJth(rJacobian, 26, 26) = var_x332 + var_x371;
        IJth(rJacobian, 0, 27) = mSetVoltageDerivativeToZero ? 0.0 : (-3 * var_x147);
        IJth(rJacobian, 27, 27) = var_x383;
        IJth(rJacobian, 42, 27) = -0.00018510282307569501 * var_x147;
        IJth(rJacobian, 0, 28) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x148);
        IJth(rJacobian, 28, 28) = -((var_x384) ? (0) : (0.13500000000000001 * var_x385)) - ((var_x384) ? (7.6923076923076916 / var_x387) : (310000.0 * var_x389 + 3.5600000000000001 * var_x388));
        IJth(rJacobian, 42, 28) = -6.1700941025231664e-5 * var_x148;
        IJth(rJacobian, 0, 29) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x149);
        IJth(rJacobian, 29, 29) = -((var_x384) ? (0) : (var_x396 * var_x397)) - ((var_x384) ? (0.29999999999999999 * var_x401) : (0.1212 * var_x405));
        IJth(rJacobian, 42, 29) = -6.1700941025231664e-5 * var_x149;
        IJth(rJacobian, 0, 30) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0195 * var_x150);
        IJth(rJacobian, 30, 30) = var_x383;
        IJth(rJacobian, 42, 30) = -1.2031683499920175e-6 * var_x150;
        IJth(rJacobian, 0, 31) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x11 * var_x145);
        IJth(rJacobian, 31, 31) = -0.0016666666666666668;
        IJth(rJacobian, 42, 31) = -var_x145 * var_x491;
        IJth(rJacobian, 0, 32) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x40 * var_x45);
        IJth(rJacobian, 32, 32) = -var_x418 - var_x419;
        IJth(rJacobian, 46, 32) = -var_x40 * var_x507;
        IJth(rJacobian, 0, 33) = mSetVoltageDerivativeToZero ? 0.0 : (-1.4924999999999999 * var_x152);
        IJth(rJacobian, 33, 33) = -var_x427 - var_x428;
        IJth(rJacobian, 46, 33) = -9.2088654480158264e-5 * var_x152;
        IJth(rJacobian, 0, 34) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x40 * var_x82);
        IJth(rJacobian, 34, 34) = var_x441 - var_x439;
        IJth(rJacobian, 46, 34) = -var_x40 * var_x508;
        IJth(rJacobian, 0, 35) = mSetVoltageDerivativeToZero ? 0.0 : (-0.4975 * var_x153);
        IJth(rJacobian, 35, 35) = var_x441 - 0.0040000000000000001 / var_x443;
        IJth(rJacobian, 46, 35) = -3.0696218160052752e-5 * var_x153;
        IJth(rJacobian, 0, 36) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x106 * var_chaste_interface__membrane__Vm);
        IJth(rJacobian, 36, 36) = -0.125;
        IJth(rJacobian, 45, 36) = var_x504 * var_chaste_interface__membrane__Vm;
        IJth(rJacobian, 0, 37) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0010402994780168702 * var_x154);
        IJth(rJacobian, 37, 37) = -var_x457;
        IJth(rJacobian, 38, 37) = -1.0 * var_x470;
        IJth(rJacobian, 40, 37) = 0.23999999999999996 * var_x480;
        IJth(rJacobian, 45, 37) = 2.175954783543569e-6 * var_x154;
        IJth(rJacobian, 37, 38) = -0.0123 * var_x455 * var_x461 / pow(var_chaste_interface__Ca__Ca_JSR, 2) - 115588.83089076335 * var_x444 * var_x445 * var_x452 * var_x462 / pow(var_x446, 2);
        IJth(rJacobian, 38, 38) = -var_x471 + 0.25 * (var_x460 + 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR) / (pow(var_x468, 3) * pow((0.125 + var_x469), 2));
        IJth(rJacobian, 39, 38) = 0.0034782608695652171;
        IJth(rJacobian, 1, 39) = 2.3746312684365782e-5 * var_x190;
        IJth(rJacobian, 38, 39) = var_x471;
        IJth(rJacobian, 39, 39) = -0.0037699275362318837;
        IJth(rJacobian, 0, 40) = mSetVoltageDerivativeToZero ? 0.0 : (2469600.0 * var_x155 + var_x131 * var_x156 - var_x133 * var_x157);
        IJth(rJacobian, 1, 40) = var_x191 * (0.014749262536873154 - var_x209 * var_x217 - var_x215 * var_x216);
        IJth(rJacobian, 37, 40) = -4.6767910530856466e-10 * var_x463 * var_x465 - 1.7151953595372529e-5 * var_x465 * var_x466;
        IJth(rJacobian, 39, 40) = var_x215 * var_x474 + var_x217 * var_x473;
        IJth(rJacobian, 40, 40) = var_x481 * (-5.5 + 6.53644343986048e-11 * var_x482 - 4.8146657448698097e-10 * var_x173 - 5165.5682301054212 * var_x155) + (0.019557600000000001 / pow(var_x477, 3) + 8.1780000000000006e-5 / pow(var_x478, 3)) * (0.5 * var_chaste_interface__Ca__Ca_ss_CaL + 0.23999999999999996 * var_chaste_interface__Irel__Irel + 5.0 * var_chaste_interface__Ca__Ca_i - 5.5 * var_chaste_interface__Ca__Ca_ss_sr + var_x118 * var_x475) / pow(var_x479, 2);
        IJth(rJacobian, 41, 40) = 5.0 * var_x488;
        IJth(rJacobian, 43, 40) = 15496.704690316265 * var_x155 + 1.4443997234609428e-9 * var_x173 - 1.960933031958144e-10 * var_x482;
        IJth(rJacobian, 47, 40) = 3.7500000000000005e-6 * var_x200 * var_x211 + 1.8750000000000003e-7 * var_x73 * pow(var_x193, 2) / pow(var_x194, 3);
        IJth(rJacobian, 0, 41) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x158);
        IJth(rJacobian, 19, 41) = -var_x330;
        IJth(rJacobian, 20, 41) = -var_x333;
        IJth(rJacobian, 21, 41) = var_x330 + var_x349 * var_chaste_interface__ICaL__CI_star + var_x350 * var_chaste_interface__ICaL__C_star;
        IJth(rJacobian, 22, 41) = var_x333 + var_x349 * var_chaste_interface__ICaL__OI_star + var_x350 * var_chaste_interface__ICaL__O_star;
        IJth(rJacobian, 23, 41) = -var_x366;
        IJth(rJacobian, 24, 41) = -var_x367;
        IJth(rJacobian, 25, 41) = var_x366 + var_x372 * var_chaste_interface__ICaL__C_star + var_x373 * var_chaste_interface__ICaL__CI_star;
        IJth(rJacobian, 26, 41) = var_x367 + var_x372 * var_chaste_interface__ICaL__O_star + var_x373 * var_chaste_interface__ICaL__OI_star;
        IJth(rJacobian, 37, 41) = -var_x158 * var_x458;
        IJth(rJacobian, 40, 41) = 0.5 * var_x480;
        IJth(rJacobian, 41, 41) = var_x489 * (-5.0 - var_x483 * var_x88) + (0.019557600000000001 / pow(var_x485, 3) + 8.1780000000000006e-5 / pow(var_x486, 3)) * (5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_ss_CaL - var_x139 * var_x483) / pow(var_x487, 2);
        IJth(rJacobian, 0, 42) = mSetVoltageDerivativeToZero ? 0.0 : (0.071928427789186525 * var_x160 + 1.3365608910938003e-12 * var_x168 + 3.900466760223035 * var_x166 - 26.711785007306684 * var_x169 - 19.440000000000001 * var_x171 - 0.18701391225188496 * var_x162 - 1.1558883089076335e-5 * var_x163 - 0.17362660254749343 * var_x164);
        IJth(rJacobian, 1, 42) = var_x191 * (0.0011994662935305037 * var_x171 - 8.2467064718009662e-17 * var_x168);
        IJth(rJacobian, 42, 42) = -0.14749262536873156 + var_x497 + 2.4740119415402899e-16 * var_x168 + 1.3314155043174696e-5 * var_x160 - 3.4616803112254212e-5 * var_x162 - 7.1319396379664657e-10 * var_x163 - 0.0016481422714144972 * var_x169 - 1.0712924764194231e-5 * var_x164 - 0.0035983988805915112 * var_x171;
        IJth(rJacobian, 43, 42) = 5.0;
        IJth(rJacobian, 44, 42) = var_x497;
        IJth(rJacobian, 46, 42) = 2.3077868741502807e-5 * var_x162 + 3.900466760223035 * var_x511 - 8.8761033621164642e-6 * var_x160;
        IJth(rJacobian, 0, 43) = mSetVoltageDerivativeToZero ? 0.0 : (1.3365608910938003e-12 * var_x174 - 4.8600000000000003 * var_x175);
        IJth(rJacobian, 40, 43) = var_x481 * (0.010165476837671019 * var_x175 - 2.7956334939405277e-15 * var_x174);
        IJth(rJacobian, 42, 43) = 0.14749262536873156;
        IJth(rJacobian, 43, 43) = -5.0 + 8.386900481821583e-15 * var_x174 - 0.030496430513013057 * var_x175;
        IJth(rJacobian, 0, 44) = mSetVoltageDerivativeToZero ? 0.0 : (0.0060101516266440041 * var_x176 - 0.0032509358688027189 * var_x177);
        IJth(rJacobian, 42, 44) = var_x498;
        IJth(rJacobian, 44, 44) = -0.14749262536873156 + var_x498 + var_x502 - 3.7083201106826184e-7 * var_x176;
        IJth(rJacobian, 45, 44) = 5.0 + 6.799858698573652e-6 * var_x177;
        IJth(rJacobian, 46, 44) = var_x502;
        IJth(rJacobian, 44, 45) = 0.14749262536873156;
        IJth(rJacobian, 45, 45) = -5.0;
        IJth(rJacobian, 0, 46) = mSetVoltageDerivativeToZero ? 0.0 : (212.7914217252065 * var_x166 + 3.2490879693637482 * var_x183 - 13.289113041135074 * var_x184 - 0.073724526620166445 * var_x178 - 26.711785007306684 * var_x182 - 13.623010353726409 * var_x179 - var_x181 * var_x94);
        IJth(rJacobian, 44, 46) = var_x503;
        IJth(rJacobian, 46, 46) = var_x503 + 212.7914217252065 * var_x511 + 0.00020047178518350236 * var_x183 - 4.5488726691040119e-6 * var_x178 - 0.00081995078002871237 * var_x184 - 0.0016481422714144972 * var_x182 - 0.0008405525584213936 * var_x179 - var_x181 * var_x509;
        IJth(rJacobian, 1, 47) = var_x191 * (-var_x209 * var_x222 - var_x216 * var_x221);
        IJth(rJacobian, 37, 47) = 0.22869271460496704 * var_x466 * var_x467 + 6.2357214041141957e-6 * var_x463 * var_x467;
        IJth(rJacobian, 39, 47) = var_x221 * var_x474 + var_x222 * var_x473;
        IJth(rJacobian, 47, 47) = -0.00068000000000000005 - var_x200 * var_x512 + var_x193 * var_x218 * var_x512;
    }

    N_Vector Celldecker_2009FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 1) = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldecker_2009FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "decker_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.472528);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(7.09945e-05);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("IKs__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.476653873938053);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("IKs__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2551771850026437);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("IKs__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05122852186842027);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("IKs__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004570874421666423);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("IKs__C5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001529389211563687);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("IKs__C6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1328281770413747);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("IKs__C7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05333228495514583);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("IKs__C8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007137874613383642);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("IKs__C9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0003184390970637536);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("IKs__C10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01388061042363991);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("IKs__C11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003715500164470033);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("IKs__C12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002486371465457659);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("IKs__C13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006446803014431032);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("IKs__C14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.628258026770862e-05);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("IKs__C15");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.122823524761588e-05);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("IKs__O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.051906959485266e-05);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("IKs__O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.372219883411999e-06);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("ICaL__C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999613782488198);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("ICaL__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.27419494597377e-05);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("ICaL__C_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.936477396599124e-11);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("ICaL__O_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.350122566369778e-15);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("ICaL__CI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.587938121237188e-05);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("ICaL__OI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.611420243201921e-10);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("ICaL__CI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("ICaL__OI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("INa_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("INa_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913109066867);

    // NV_Ith_S(rY, 29):
    this->mVariableNames.push_back("INa_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9970771239754529);

    // NV_Ith_S(rY, 30):
    this->mVariableNames.push_back("INaL_mL_gate__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // NV_Ith_S(rY, 31):
    this->mVariableNames.push_back("INaL_hL_gate__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3593255076983574);

    // NV_Ith_S(rY, 32):
    this->mVariableNames.push_back("IKr_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.235996442041028e-08);

    // NV_Ith_S(rY, 33):
    this->mVariableNames.push_back("Ito1_a_gate__a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.773318268499115e-05);

    // NV_Ith_S(rY, 34):
    this->mVariableNames.push_back("Ito1_i1f_gate__i1f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9979722);

    // NV_Ith_S(rY, 35):
    this->mVariableNames.push_back("Ito1_i1s_gate__i1s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9874435);

    // NV_Ith_S(rY, 36):
    this->mVariableNames.push_back("Ito2_i2f_gate__i2f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9960352);

    // NV_Ith_S(rY, 37):
    this->mVariableNames.push_back("Irel__Irel");
    this->mVariableUnits.push_back("mM_per_ms");
    this->mInitialConditions.push_back(0.00107332);

    // NV_Ith_S(rY, 38):
    this->mVariableNames.push_back("Ca__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.917692717);

    // NV_Ith_S(rY, 39):
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.929835335);

    // NV_Ith_S(rY, 40):
    this->mVariableNames.push_back("Ca__Ca_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.04757e-05);

    // NV_Ith_S(rY, 41):
    this->mVariableNames.push_back("Ca__Ca_ss_CaL");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.61545e-05);

    // NV_Ith_S(rY, 42):
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935575);

    // NV_Ith_S(rY, 43):
    this->mVariableNames.push_back("Na__Na_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935607);

    // NV_Ith_S(rY, 44):
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // NV_Ith_S(rY, 45):
    this->mVariableNames.push_back("Cl__Cl_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // NV_Ith_S(rY, 46):
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(145.5689);

    // NV_Ith_S(rY, 47):
    this->mVariableNames.push_back("CaMK_active__CaMK_trap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018861341);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("L_per_F_ms");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldecker_2009FromCellMLCvode)
#endif // CHASTE_CVODE
