#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: courtemanche_ramirez_nattel_model_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "courtemanche_ramirez_nattel_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.002 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                21,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 100.0; // (var_membrane__Cm) [picoF]
    }

    Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::~Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode()
    {
    }
    
    double Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.18
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.002908
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.9649
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9775
        double var_chaste_interface__transient_outward_K_current_oa_gate__oa = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.03043
        double var_chaste_interface__transient_outward_K_current_oi_gate__oi = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9992
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.004966
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.296e-05
        double var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.01869
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0001367
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9996
        double var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.7755
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 11.17
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 0.0001013
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 139.0
        
        const double var_L_type_Ca_channel__g_Ca_L = 0.12375; // nanoS_per_picoF
        const double var_Na_Ca_exchanger_current__I_NaCa_max = 1600.0; // picoA_per_picoF
        const double var_Na_Ca_exchanger_current__K_mCa = 1.3799999999999999; // millimolar
        const double var_Na_Ca_exchanger_current__K_mNa = 87.5; // millimolar
        const double var_Na_Ca_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_Na_Ca_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_background_currents__g_B_Ca = 0.0011310000000000001; // nanoS_per_picoF
        const double var_background_currents__g_B_Na = 0.00067443750000000002; // nanoS_per_picoF
        const double var_fast_sodium_current__g_Na = 7.7999999999999998; // nanoS_per_picoF
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-65.0 + var_chaste_interface__membrane__V) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f * NV_Ith_S(mParameters, 0); // picoA
        const double var_rapid_delayed_rectifier_K_current__g_Kr = 0.029411764999999999; // nanoS_per_picoF
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 0.27500000000000002; // picoA_per_picoF
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * NV_Ith_S(mParameters, 0) * var_sarcolemmal_calcium_pump_current__i_CaP_max / (0.00050000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_slow_delayed_rectifier_K_current__g_Ks = 0.12941175999999999; // nanoS_per_picoF
        const double var_sodium_potassium_pump__Km_K_o = 1.5; // millimolar
        const double var_sodium_potassium_pump__Km_Na_i = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.59933873999999998; // picoA_per_picoF
        const double var_standard_ionic_concentrations__Ca_o = 1.8; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca * NV_Ith_S(mParameters, 0); // picoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(var_Na_Ca_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger_current__I_NaCa_max * NV_Ith_S(mParameters, 0) / ((1.0 + var_Na_Ca_exchanger_current__K_sat * exp((-1.0 + var_Na_Ca_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger_current__K_mNa, 3) + pow(var_standard_ionic_concentrations__Na_o, 3)) * (var_Na_Ca_exchanger_current__K_mCa + var_standard_ionic_concentrations__Ca_o)); // picoA
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na * NV_Ith_S(mParameters, 0); // picoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j * NV_Ith_S(mParameters, 0); // picoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = NV_Ith_S(mParameters, 0) * var_sodium_potassium_pump__f_NaK * var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__Km_Na_i / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__Km_K_o + var_standard_ionic_concentrations__K_o)); // picoA
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_K_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_rapid_delayed_rectifier_K_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr / (1.0 + exp(0.66964285714285721 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // picoA
        const double var_slow_delayed_rectifier_K_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs, 2) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_slow_delayed_rectifier_K_current__g_Ks; // picoA
        const double var_time_independent_potassium_current__g_K1 = 0.089999999999999997; // nanoS_per_picoF
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_time_independent_potassium_current__g_K1 / (1.0 + exp(5.6000000000000005 + 0.070000000000000007 * var_chaste_interface__membrane__V)); // picoA
        const double var_transient_outward_K_current__g_to = 0.16520000000000001; // nanoS_per_picoF
        const double var_transient_outward_K_current__i_to = pow(var_chaste_interface__transient_outward_K_current_oa_gate__oa, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_transient_outward_K_current__g_to * var_chaste_interface__transient_outward_K_current_oi_gate__oi; // picoA
        const double var_ultrarapid_delayed_rectifier_K_current__g_Kur = 0.0050000000000000001 + 0.050000000000000003 / (1.0 + exp(1.1538461538461537 - 0.076923076923076927 * var_chaste_interface__membrane__V)); // nanoS_per_picoF
        const double var_ultrarapid_delayed_rectifier_K_current__i_Kur = pow(var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_ultrarapid_delayed_rectifier_K_current__g_Kur * var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * (var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_fast_sodium_current__i_Na + var_rapid_delayed_rectifier_K_current__i_Kr + var_sarcolemmal_calcium_pump_current__i_CaP + var_slow_delayed_rectifier_K_current__i_Ks + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_K_current__i_to + var_ultrarapid_delayed_rectifier_K_current__i_Kur) * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.18
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.002908
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.9649
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9775
        double var_chaste_interface__transient_outward_K_current_oa_gate__oa = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.03043
        double var_chaste_interface__transient_outward_K_current_oi_gate__oi = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9992
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.004966
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.296e-05
        double var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.01869
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0001367
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9996
        double var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.7755
        double var_chaste_interface__Ca_release_current_from_JSR_u_gate__u = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 2.35e-112
        double var_chaste_interface__Ca_release_current_from_JSR_v_gate__v = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca_release_current_from_JSR_w_gate__w = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.9992
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 11.17
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 0.0001013
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 139.0
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 1.488
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 1.488

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Ca_buffers__CMDN_max = 0.050000000000000003; // millimolar
        const double var_Ca_buffers__CSQN_max = 10.0; // millimolar
        const double var_Ca_buffers__Km_CMDN = 0.0023800000000000002; // millimolar
        const double var_Ca_buffers__Km_CSQN = 0.80000000000000004; // millimolar
        const double var_Ca_buffers__Km_TRPN = 0.00050000000000000001; // millimolar
        const double var_Ca_buffers__TRPN_max = 0.070000000000000007; // millimolar
        const double var_Ca_leak_current_by_the_NSR__Ca_up_max = 15.0; // millimolar
        const double var_Ca_release_current_from_JSR__K_rel = 30.0; // per_millisecond
        const double var_Ca_release_current_from_JSR_u_gate__tau_u = 8.0; // millisecond
        const double var_Ca_uptake_current_by_the_NSR__I_up_max = 0.0050000000000000001; // millimolar_per_millisecond
        const double var_Ca_uptake_current_by_the_NSR__K_up = 0.00092000000000000003; // millimolar
        const double var_L_type_Ca_channel__g_Ca_L = 0.12375; // nanoS_per_picoF
        const double var_L_type_Ca_channel_f_Ca_gate__tau_f_Ca = 2.0; // millisecond
        const double var_Na_Ca_exchanger_current__I_NaCa_max = 1600.0; // picoA_per_picoF
        const double var_Na_Ca_exchanger_current__K_mCa = 1.3799999999999999; // millimolar
        const double var_Na_Ca_exchanger_current__K_mNa = 87.5; // millimolar
        const double var_Na_Ca_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_Na_Ca_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_background_currents__g_B_Ca = 0.0011310000000000001; // nanoS_per_picoF
        const double var_background_currents__g_B_K = 0; // nanoS_per_picoF
        const double var_background_currents__g_B_Na = 0.00067443750000000002; // nanoS_per_picoF
        const double var_fast_sodium_current__g_Na = 7.7999999999999998; // nanoS_per_picoF
        const double var_Ca_uptake_current_by_the_NSR__i_up = var_Ca_uptake_current_by_the_NSR__I_up_max / (1.0 + var_Ca_uptake_current_by_the_NSR__K_up / var_chaste_interface__intracellular_ion_concentrations__Ca_i); // millimolar_per_millisecond
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca_infinity = 1 / (1.0 + 2857.1428571428573 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // dimensionless
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_Ca_gate__f_Ca = (-var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca + var_L_type_Ca_channel_f_Ca_gate__f_Ca_infinity) / var_L_type_Ca_channel_f_Ca_gate__tau_f_Ca; // 1 / millisecond
        const double var_intracellular_ion_concentrations__B2 = 1.0 + var_Ca_buffers__CMDN_max * var_Ca_buffers__Km_CMDN / pow((var_Ca_buffers__Km_CMDN + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2) + var_Ca_buffers__Km_TRPN * var_Ca_buffers__TRPN_max / pow((var_Ca_buffers__Km_TRPN + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2); // dimensionless
        const double var_Ca_release_current_from_JSR__i_rel = pow(var_chaste_interface__Ca_release_current_from_JSR_u_gate__u, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) * var_Ca_release_current_from_JSR__K_rel * var_chaste_interface__Ca_release_current_from_JSR_v_gate__v * var_chaste_interface__Ca_release_current_from_JSR_w_gate__w; // millimolar_per_millisecond
        const double var_Ca_leak_current_by_the_NSR__i_up_leak = var_Ca_uptake_current_by_the_NSR__I_up_max * var_chaste_interface__intracellular_ion_concentrations__Ca_up / var_Ca_leak_current_by_the_NSR__Ca_up_max; // millimolar_per_millisecond
        const double var_intracellular_ion_concentrations__V_cell = 20100.0; // micrometre_3
        const double var_intracellular_ion_concentrations__V_i = 0.68000000000000005 * var_intracellular_ion_concentrations__V_cell; // micrometre_3
        const double var_intracellular_ion_concentrations__V_rel = 0.0047999999999999996 * var_intracellular_ion_concentrations__V_cell; // micrometre_3
        const double var_intracellular_ion_concentrations__V_up = 0.055199999999999999 * var_intracellular_ion_concentrations__V_cell; // micrometre_3
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_Ca_release_current_from_JSR_w_gate__tau_w = ((fabs(-7.9000000000000004 + var_chaste_interface__membrane__V) < 1.0e-10) ? (0.92307692307692313) : (6.0 * (1.0 - exp(1.5800000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V)) / ((1.0 + 0.29999999999999999 * exp(1.5800000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V)) * (-7.9000000000000004 + var_chaste_interface__membrane__V)))); // millisecond
        const double var_Ca_release_current_from_JSR_w_gate__w_infinity = 1.0 - 1 / (1.0 + exp(2.3529411764705883 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_Ca_release_current_from_JSR_w_gate__w = (-var_chaste_interface__Ca_release_current_from_JSR_w_gate__w + var_Ca_release_current_from_JSR_w_gate__w_infinity) / var_Ca_release_current_from_JSR_w_gate__tau_w; // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = (-65.0 + var_chaste_interface__membrane__V) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f * NV_Ith_S(mParameters, 0); // picoA
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = ((fabs(10.0 + var_chaste_interface__membrane__V) < 1.0e-10) ? (4.5789999999999997 / (1.0 + exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V))) : (28.571428571428569 * (1.0 - exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V)) / ((1.0 + exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__membrane__V)))); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = (-var_chaste_interface__L_type_Ca_channel_d_gate__d + var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__f_infinity = exp(-4.057971014492753 - 0.14492753623188406 * var_chaste_interface__membrane__V) / (1.0 + exp(-4.057971014492753 - 0.14492753623188406 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f = 9.0 / (0.02 + 0.019699999999999999 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2))); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = (-var_chaste_interface__L_type_Ca_channel_f_gate__f + var_L_type_Ca_channel_f_gate__f_infinity) / var_L_type_Ca_channel_f_gate__tau_f; // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__h_inf = var_fast_sodium_current_h_gate__alpha_h / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__j_inf = var_fast_sodium_current_j_gate__alpha_j / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // dimensionless
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (-var_chaste_interface__fast_sodium_current_j_gate__j + var_fast_sodium_current_j_gate__j_inf) / var_fast_sodium_current_j_gate__tau_j; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_chaste_interface__membrane__V == (-47.130000000000003)) ? (3.2000000000000002) : (0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current_m_gate__m_inf = var_fast_sodium_current_m_gate__alpha_m / (var_fast_sodium_current_m_gate__alpha_m + var_fast_sodium_current_m_gate__beta_m); // dimensionless
        const double var_fast_sodium_current_m_gate__tau_m = 1 / (var_fast_sodium_current_m_gate__alpha_m + var_fast_sodium_current_m_gate__beta_m); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (-var_chaste_interface__fast_sodium_current_m_gate__m + var_fast_sodium_current_m_gate__m_inf) / var_fast_sodium_current_m_gate__tau_m; // 1 / millisecond
        const double var_rapid_delayed_rectifier_K_current__g_Kr = 0.029411764999999999; // nanoS_per_picoF
        const double var_rapid_delayed_rectifier_K_current_xr_gate__alpha_xr = ((fabs(14.1 + var_chaste_interface__membrane__V) < 1.0e-10) ? (0.0015) : (0.00029999999999999997 * (14.1 + var_chaste_interface__membrane__V) / (1.0 - exp(-2.8199999999999998 - 0.20000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_rapid_delayed_rectifier_K_current_xr_gate__beta_xr = ((fabs(-3.3328000000000002 + var_chaste_interface__membrane__V) < 1.0e-10) ? (0.00037836118) : (7.3898000000000003e-5 * (-3.3328000000000002 + var_chaste_interface__membrane__V) / (-1.0 + exp(-0.65046743564221166 + 0.19517145812596365 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_rapid_delayed_rectifier_K_current_xr_gate__tau_xr = 1 / (var_rapid_delayed_rectifier_K_current_xr_gate__alpha_xr + var_rapid_delayed_rectifier_K_current_xr_gate__beta_xr); // millisecond
        const double var_rapid_delayed_rectifier_K_current_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.1692307692307691 - 0.15384615384615385 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_K_current_xr_gate__xr = (-var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr + var_rapid_delayed_rectifier_K_current_xr_gate__xr_infinity) / var_rapid_delayed_rectifier_K_current_xr_gate__tau_xr; // 1 / millisecond
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 0.27500000000000002; // picoA_per_picoF
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * NV_Ith_S(mParameters, 0) * var_sarcolemmal_calcium_pump_current__i_CaP_max / (0.00050000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_slow_delayed_rectifier_K_current__g_Ks = 0.12941175999999999; // nanoS_per_picoF
        const double var_slow_delayed_rectifier_K_current_xs_gate__alpha_xs = ((fabs(-19.899999999999999 + var_chaste_interface__membrane__V) < 1.0e-10) ? (0.00068000000000000005) : (4.0000000000000003e-5 * (-19.899999999999999 + var_chaste_interface__membrane__V) / (1.0 - exp(1.1705882352941175 - 0.058823529411764705 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_slow_delayed_rectifier_K_current_xs_gate__beta_xs = ((fabs(-19.899999999999999 + var_chaste_interface__membrane__V) < 1.0e-10) ? (0.00031500000000000001) : (3.4999999999999997e-5 * (-19.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.2111111111111108 + 0.1111111111111111 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_slow_delayed_rectifier_K_current_xs_gate__tau_xs = 0.5 / (var_slow_delayed_rectifier_K_current_xs_gate__alpha_xs + var_slow_delayed_rectifier_K_current_xs_gate__beta_xs); // millisecond
        const double var_slow_delayed_rectifier_K_current_xs_gate__xs_infinity = pow((1.0 + exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V)), (-0.5)); // dimensionless
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_K_current_xs_gate__xs = (-var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs + var_slow_delayed_rectifier_K_current_xs_gate__xs_infinity) / var_slow_delayed_rectifier_K_current_xs_gate__tau_xs; // 1 / millisecond
        const double var_sodium_potassium_pump__Km_K_o = 1.5; // millimolar
        const double var_sodium_potassium_pump__Km_Na_i = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.59933873999999998; // picoA_per_picoF
        const double var_standard_ionic_concentrations__Ca_o = 1.8; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca * NV_Ith_S(mParameters, 0); // picoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(var_Na_Ca_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger_current__I_NaCa_max * NV_Ith_S(mParameters, 0) / ((1.0 + var_Na_Ca_exchanger_current__K_sat * exp((-1.0 + var_Na_Ca_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger_current__K_mNa, 3) + pow(var_standard_ionic_concentrations__Na_o, 3)) * (var_Na_Ca_exchanger_current__K_mCa + var_standard_ionic_concentrations__Ca_o)); // picoA
        const double var_Ca_release_current_from_JSR__Fn = 9.9999999999999998e-13 * var_Ca_release_current_from_JSR__i_rel * var_intracellular_ion_concentrations__V_rel - 4.9999999999999999e-13 * (0.5 * var_L_type_Ca_channel__i_Ca_L - 0.20000000000000001 * var_Na_Ca_exchanger_current__i_NaCa) / var_membrane__F; // dimensionless
        const double var_Ca_release_current_from_JSR_u_gate__u_infinity = 1 / (1.0 + exp(250.0 - 731528895391368.0 * var_Ca_release_current_from_JSR__Fn)); // dimensionless
        const double var_Ca_release_current_from_JSR_v_gate__tau_v = 1.9099999999999999 + 2.0899999999999999 / (1.0 + exp(250.0 - 731528895391368.0 * var_Ca_release_current_from_JSR__Fn)); // millisecond
        const double var_Ca_release_current_from_JSR_v_gate__v_infinity = 1.0 - 1 / (1.0 + exp(50.0 - 731528895391368.0 * var_Ca_release_current_from_JSR__Fn)); // dimensionless
        const double d_dt_chaste_interface_var_Ca_release_current_from_JSR_u_gate__u = (-var_chaste_interface__Ca_release_current_from_JSR_u_gate__u + var_Ca_release_current_from_JSR_u_gate__u_infinity) / var_Ca_release_current_from_JSR_u_gate__tau_u; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_release_current_from_JSR_v_gate__v = (-var_chaste_interface__Ca_release_current_from_JSR_v_gate__v + var_Ca_release_current_from_JSR_v_gate__v_infinity) / var_Ca_release_current_from_JSR_v_gate__tau_v; // 1 / millisecond
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na * NV_Ith_S(mParameters, 0); // picoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j * NV_Ith_S(mParameters, 0); // picoA
        const double var_intracellular_ion_concentrations__B1 = ((-var_Ca_uptake_current_by_the_NSR__i_up + var_Ca_leak_current_by_the_NSR__i_up_leak) * var_intracellular_ion_concentrations__V_up + var_Ca_release_current_from_JSR__i_rel * var_intracellular_ion_concentrations__V_rel) / var_intracellular_ion_concentrations__V_i + 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_background_currents__i_B_Ca - var_sarcolemmal_calcium_pump_current__i_CaP + 2.0 * var_Na_Ca_exchanger_current__i_NaCa) / (var_intracellular_ion_concentrations__V_i * var_membrane__F); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = var_intracellular_ion_concentrations__B1 / var_intracellular_ion_concentrations__B2; // millimolar / millisecond
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = NV_Ith_S(mParameters, 0) * var_sodium_potassium_pump__f_NaK * var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__Km_Na_i / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__Km_K_o + var_standard_ionic_concentrations__K_o)); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = (-var_background_currents__i_B_Na - var_fast_sodium_current__i_Na - 3.0 * var_Na_Ca_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_i * var_membrane__F); // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_K = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K * NV_Ith_S(mParameters, 0); // picoA
        const double var_rapid_delayed_rectifier_K_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_rapid_delayed_rectifier_K_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr / (1.0 + exp(0.66964285714285721 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // picoA
        const double var_slow_delayed_rectifier_K_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs, 2) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_slow_delayed_rectifier_K_current__g_Ks; // picoA
        const double var_time_independent_potassium_current__g_K1 = 0.089999999999999997; // nanoS_per_picoF
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_time_independent_potassium_current__g_K1 / (1.0 + exp(5.6000000000000005 + 0.070000000000000007 * var_chaste_interface__membrane__V)); // picoA
        const double var_transfer_current_from_NSR_to_JSR__tau_tr = 180.0; // millisecond
        const double var_transfer_current_from_NSR_to_JSR__i_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_rel + var_chaste_interface__intracellular_ion_concentrations__Ca_up) / var_transfer_current_from_NSR_to_JSR__tau_tr; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel = (-var_Ca_release_current_from_JSR__i_rel + var_transfer_current_from_NSR_to_JSR__i_tr) / (1.0 + var_Ca_buffers__CSQN_max * var_Ca_buffers__Km_CSQN / pow((var_Ca_buffers__Km_CSQN + var_chaste_interface__intracellular_ion_concentrations__Ca_rel), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up = -var_Ca_leak_current_by_the_NSR__i_up_leak - var_intracellular_ion_concentrations__V_rel * var_transfer_current_from_NSR_to_JSR__i_tr / var_intracellular_ion_concentrations__V_up + var_Ca_uptake_current_by_the_NSR__i_up; // millimolar / millisecond
        const double var_transient_outward_K_current__K_Q10 = 3.0; // dimensionless
        const double var_transient_outward_K_current__g_to = 0.16520000000000001; // nanoS_per_picoF
        const double var_transient_outward_K_current_oa_gate__alpha_oa = 0.65000000000000002 / (exp(0.50847457627118642 - 0.016949152542372881 * var_chaste_interface__membrane__V) + exp(-1.1764705882352942 - 0.11764705882352941 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_transient_outward_K_current_oa_gate__beta_oa = 0.65000000000000002 / (2.5 + exp(4.8235294117647056 + 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_transient_outward_K_current_oa_gate__oa_infinity = 1 / (1.0 + exp(-1.1670467502850628 - 0.057012542759407071 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_transient_outward_K_current_oa_gate__tau_oa = 1 / ((var_transient_outward_K_current_oa_gate__alpha_oa + var_transient_outward_K_current_oa_gate__beta_oa) * var_transient_outward_K_current__K_Q10); // millisecond
        const double d_dt_chaste_interface_var_transient_outward_K_current_oa_gate__oa = (-var_chaste_interface__transient_outward_K_current_oa_gate__oa + var_transient_outward_K_current_oa_gate__oa_infinity) / var_transient_outward_K_current_oa_gate__tau_oa; // 1 / millisecond
        const double var_transient_outward_K_current_oi_gate__alpha_oi = 1 / (18.530000000000001 + exp(10.383561643835618 + 0.091324200913242018 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_transient_outward_K_current_oi_gate__beta_oi = 1 / (35.560000000000002 + exp(-0.16935483870967738 - 0.13440860215053763 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_transient_outward_K_current__i_to = pow(var_chaste_interface__transient_outward_K_current_oa_gate__oa, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_transient_outward_K_current__g_to * var_chaste_interface__transient_outward_K_current_oi_gate__oi; // picoA
        const double var_transient_outward_K_current_oi_gate__oi_infinity = 1 / (1.0 + exp(8.1320754716981138 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_transient_outward_K_current_oi_gate__tau_oi = 1 / ((var_transient_outward_K_current_oi_gate__alpha_oi + var_transient_outward_K_current_oi_gate__beta_oi) * var_transient_outward_K_current__K_Q10); // millisecond
        const double d_dt_chaste_interface_var_transient_outward_K_current_oi_gate__oi = (-var_chaste_interface__transient_outward_K_current_oi_gate__oi + var_transient_outward_K_current_oi_gate__oi_infinity) / var_transient_outward_K_current_oi_gate__tau_oi; // 1 / millisecond
        const double var_ultrarapid_delayed_rectifier_K_current__g_Kur = 0.0050000000000000001 + 0.050000000000000003 / (1.0 + exp(1.1538461538461537 - 0.076923076923076927 * var_chaste_interface__membrane__V)); // nanoS_per_picoF
        const double var_ultrarapid_delayed_rectifier_K_current_ua_gate__alpha_ua = 0.65000000000000002 / (exp(0.50847457627118642 - 0.016949152542372881 * var_chaste_interface__membrane__V) + exp(-1.1764705882352942 - 0.11764705882352941 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ua_gate__beta_ua = 0.65000000000000002 / (2.5 + exp(4.8235294117647056 + 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ua_gate__tau_ua = 1 / ((var_ultrarapid_delayed_rectifier_K_current_ua_gate__alpha_ua + var_ultrarapid_delayed_rectifier_K_current_ua_gate__beta_ua) * var_transient_outward_K_current__K_Q10); // millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ua_gate__ua_infinity = 1 / (1.0 + exp(-3.15625 - 0.10416666666666667 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_ultrarapid_delayed_rectifier_K_current_ua_gate__ua = (-var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua + var_ultrarapid_delayed_rectifier_K_current_ua_gate__ua_infinity) / var_ultrarapid_delayed_rectifier_K_current_ua_gate__tau_ua; // 1 / millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ui_gate__alpha_ui = 1 / (21.0 + exp(6.6071428571428568 - 0.035714285714285712 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ui_gate__beta_ui = 1 / exp(9.875 - 0.0625 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ui_gate__tau_ui = 1 / ((var_ultrarapid_delayed_rectifier_K_current_ui_gate__alpha_ui + var_ultrarapid_delayed_rectifier_K_current_ui_gate__beta_ui) * var_transient_outward_K_current__K_Q10); // millisecond
        const double var_ultrarapid_delayed_rectifier_K_current__i_Kur = pow(var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 0) * var_ultrarapid_delayed_rectifier_K_current__g_Kur * var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui; // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = (-var_background_currents__i_B_K - var_rapid_delayed_rectifier_K_current__i_Kr - var_slow_delayed_rectifier_K_current__i_Ks - var_time_independent_potassium_current__i_K1 - var_transient_outward_K_current__i_to - var_ultrarapid_delayed_rectifier_K_current__i_Kur + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_i * var_membrane__F); // millimolar / millisecond
        const double var_ultrarapid_delayed_rectifier_K_current_ui_gate__ui_infinity = 1 / (1.0 + exp(-3.6189956331877728 + 0.036390101892285295 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_ultrarapid_delayed_rectifier_K_current_ui_gate__ui = (-var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui + var_ultrarapid_delayed_rectifier_K_current_ui_gate__ui_infinity) / var_ultrarapid_delayed_rectifier_K_current_ui_gate__tau_ui; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
            const double var_membrane__i_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_membrane__i_st = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_st_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
            d_dt_chaste_interface_var_membrane__V = (-var_L_type_Ca_channel__i_Ca_L - var_Na_Ca_exchanger_current__i_NaCa - var_background_currents__i_B_Ca - var_background_currents__i_B_Na - var_fast_sodium_current__i_Na - var_membrane__i_st - var_rapid_delayed_rectifier_K_current__i_Kr - var_sarcolemmal_calcium_pump_current__i_CaP - var_slow_delayed_rectifier_K_current__i_Ks - var_sodium_potassium_pump__i_NaK - var_time_independent_potassium_current__i_K1 - var_transient_outward_K_current__i_to - var_ultrarapid_delayed_rectifier_K_current__i_Kur) / NV_Ith_S(mParameters, 0); // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_transient_outward_K_current_oa_gate__oa;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_transient_outward_K_current_oi_gate__oi;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_ultrarapid_delayed_rectifier_K_current_ua_gate__ua;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_ultrarapid_delayed_rectifier_K_current_ui_gate__ui;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_rapid_delayed_rectifier_K_current_xr_gate__xr;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_slow_delayed_rectifier_K_current_xs_gate__xs;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_L_type_Ca_channel_f_Ca_gate__f_Ca;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_Ca_release_current_from_JSR_u_gate__u;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_Ca_release_current_from_JSR_v_gate__v;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_Ca_release_current_from_JSR_w_gate__w;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up;
    }

    void Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -81.18
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.002908
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.9649
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9775
        double var_chaste_interface__transient_outward_K_current_oa_gate__oa = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.03043
        double var_chaste_interface__transient_outward_K_current_oi_gate__oi = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.9992
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.004966
        double var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.296e-05
        double var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.01869
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0001367
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9996
        double var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.7755
        double var_chaste_interface__Ca_release_current_from_JSR_u_gate__u = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 2.35e-112
        double var_chaste_interface__Ca_release_current_from_JSR_v_gate__v = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca_release_current_from_JSR_w_gate__w = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.9992
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 11.17
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 0.0001013
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 139.0
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = NV_Ith_S(rY, 19);
        // Units: millimolar; Initial value: 1.488
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = NV_Ith_S(rY, 20);
        // Units: millimolar; Initial value: 1.488
        
        const double var_x0 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x1 = pow(var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs, 2) * NV_Ith_S(mParameters, 0);
        const double var_x2 = exp(5.6000000000000005 + 0.070000000000000007 * var_chaste_interface__membrane__V);
        const double var_x3 = 1.0 + var_x2;
        const double var_x4 = NV_Ith_S(mParameters, 0) / var_x3;
        const double var_x5 = pow(var_chaste_interface__transient_outward_K_current_oa_gate__oa, 3);
        const double var_x6 = 0.16520000000000001 * var_x5;
        const double var_x7 = NV_Ith_S(mParameters, 0) * var_chaste_interface__transient_outward_K_current_oi_gate__oi;
        const double var_x8 = exp(0.66964285714285721 + 0.044642857142857144 * var_chaste_interface__membrane__V);
        const double var_x9 = 1.0 + var_x8;
        const double var_x10 = 1 / var_x9;
        const double var_x11 = 0.029411764999999999 * var_x10;
        const double var_x12 = NV_Ith_S(mParameters, 0) * var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr;
        const double var_x13 = exp(-0.024332874996168673 * var_chaste_interface__membrane__V);
        const double var_x14 = var_x13 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x15 = exp(0.013102317305629283 * var_chaste_interface__membrane__V);
        const double var_x16 = var_x15 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
        const double var_x17 = 1.0 + 0.10000000000000001 * var_x13;
        const double var_x18 = NV_Ith_S(mParameters, 0) / var_x17;
        const double var_x19 = var_x18 * (66769.408989486838 * var_x14 + 0.023584171150132709 * var_x16);
        const double var_x20 = pow(var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua, 3);
        const double var_x21 = exp(1.1538461538461537 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x22 = 1.0 + var_x21;
        const double var_x23 = 0.0050000000000000001 + 0.050000000000000003 / var_x22;
        const double var_x24 = var_x20 * var_x23;
        const double var_x25 = NV_Ith_S(mParameters, 0) * var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui;
        const double var_x26 = var_x24 * var_x25;
        const double var_x27 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
        const double var_x28 = -26.712831923985377 * log(5.4000000000000004 * var_x27) + var_chaste_interface__membrane__V;
        const double var_x29 = var_x28 * NV_Ith_S(mParameters, 0);
        const double var_x30 = var_x2 * var_x29 / pow(var_x3, 2);
        const double var_x31 = var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x32 = var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca * NV_Ith_S(mParameters, 0);
        const double var_x33 = var_x31 * var_x32;
        const double var_x34 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
        const double var_x35 = 7.7999999999999998 * var_x34;
        const double var_x36 = var_x35 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x37 = var_chaste_interface__fast_sodium_current_j_gate__j * NV_Ith_S(mParameters, 0);
        const double var_x38 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
        const double var_x39 = pow(var_x38, 1.5);
        const double var_x40 = exp(-0.0037435192301797956 * var_chaste_interface__membrane__V);
        const double var_x41 = exp(2.0802377414561666);
        const double var_x42 = exp(-0.037435192301797954 * var_chaste_interface__membrane__V);
        const double var_x43 = 1.0 + 0.1245 * var_x40 + 0.036499999999999998 * var_x42 * (-0.14285714285714285 + 0.14285714285714285 * var_x41);
        const double var_x44 = (0.00046606814415738453 * var_x40 + 0.037435192301797954 * var_x42 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x41)) * NV_Ith_S(mParameters, 0) / (pow(var_x43, 2) * (1.0 + 31.622776601683793 * var_x39));
        const double var_x45 = 1.8 * var_x16 - 2744000.0 * var_x14;
        const double var_x46 = var_x13 * var_x45 * NV_Ith_S(mParameters, 0) / pow(var_x17, 2);
        const double var_x47 = var_x12 * var_x28 * var_x8 / pow(var_x9, 2);
        const double var_x48 = var_x20 * var_x21 * var_x25 * var_x28 / pow(var_x22, 2);
        const double var_x49 = -26.712831923985377 * log(140.0 * var_x38) + var_chaste_interface__membrane__V;
        const double var_x50 = var_x49 * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x51 = var_x50 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 2) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x52 = var_x28 * pow(var_chaste_interface__transient_outward_K_current_oa_gate__oa, 2);
        const double var_x53 = var_x23 * var_x28 * pow(var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua, 2);
        const double var_x54 = var_x24 * var_x28;
        const double var_x55 = var_x28 * var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs;
        const double var_x56 = 8.0437499999999993 - 0.12375 * var_chaste_interface__membrane__V;
        const double var_x57 = var_x56 * var_chaste_interface__L_type_Ca_channel_f_Ca_gate__f_Ca;
        const double var_x58 = var_x38 * NV_Ith_S(mParameters, 0);
        const double var_x59 = var_x15 * var_x18 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2);
        const double var_x60 = var_x34 * var_x58 * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x61 = var_x39 * var_x58 / (var_x43 * pow((0.031622776601683791 + var_x39), 2));
        const double var_x62 = 0.00050000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x63 = NV_Ith_S(mParameters, 0) / var_x62;
        const double var_x64 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x65 = var_x64 * NV_Ith_S(mParameters, 0);
        const double var_x66 = pow(var_x62, (-2));
        const double var_x67 = var_x66 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * NV_Ith_S(mParameters, 0);
        const double var_x68 = var_x13 * var_x18;
        const double var_x69 = var_x1 * var_x27;
        const double var_x70 = var_x27 * var_x4;
        const double var_x71 = var_x10 * var_x12 * var_x27;
        const double var_x72 = var_x27 * var_x5 * var_x7;
        const double var_x73 = var_x26 * var_x27;
        const double var_x74 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x75 = 0.080000000000000002 * var_x74;
        const double var_x76 = var_chaste_interface__membrane__V == (-47.130000000000003);
        const double var_x77 = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_x78 = -0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x79 = exp(-4.7130000000000001 + var_x78);
        const double var_x80 = 1.0 - var_x79;
        const double var_x81 = 0.32000000000000001 / var_x80;
        const double var_x82 = ((var_x76) ? (3.2000000000000002) : (var_x77 * var_x81));
        const double var_x83 = var_x75 + var_x82;
        const double var_x84 = 1 / var_x83;
        const double var_x85 = ((var_x76) ? (0) : (var_x81 - 0.032000000000000001 * var_x77 * var_x79 / pow(var_x80, 2)));
        const double var_x86 = 0.0072727272727272727 * var_x74;
        const double var_x87 = var_x82;
        const double var_x88 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x89 = var_chaste_interface__membrane__V < -40.0;
        const double var_x90 = ((var_x89) ? (0.13500000000000001 * var_x88) : (0));
        const double var_x91 = exp(0.34999999999999998 * var_chaste_interface__membrane__V);
        const double var_x92 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
        const double var_x93 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
        const double var_x94 = 1.0 + var_x93;
        const double var_x95 = ((var_x89) ? (310000.0 * var_x91 + 3.5600000000000001 * var_x92) : (7.6923076923076916 / var_x94));
        const double var_x96 = var_x90 + var_x95;
        const double var_x97 = 1 / var_x96;
        const double var_x98 = ((var_x89) ? (-0.019852941176470591 * var_x88) : (0));
        const double var_x99 = ((var_x89) ? (0.28123999999999999 * var_x92 + 108500.0 * var_x91) : (0.693000693000693 * var_x93 / pow(var_x94, 2)));
        const double var_x100 = var_x90;
        const double var_x101 = var_x95;
        const double var_x102 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
        const double var_x103 = 1.0 + var_x102;
        const double var_x104 = exp(-0.01052 * var_chaste_interface__membrane__V);
        const double var_x105 = var_x104 / var_x103;
        const double var_x106 = exp(-3.2000000000000002 + var_x78);
        const double var_x107 = 1.0 + var_x106;
        const double var_x108 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V);
        const double var_x109 = var_x108 / var_x107;
        const double var_x110 = ((var_x89) ? (0.1212 * var_x105) : (0.29999999999999999 * var_x109));
        const double var_x111 = 37.780000000000001 + var_chaste_interface__membrane__V;
        const double var_x112 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
        const double var_x113 = 1.0 + var_x112;
        const double var_x114 = 1 / var_x113;
        const double var_x115 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
        const double var_x116 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
        const double var_x117 = -127140.0 * var_x115 - 3.4740000000000003e-5 * var_x116;
        const double var_x118 = var_x114 * var_x117;
        const double var_x119 = ((var_x89) ? (var_x111 * var_x118) : (0));
        const double var_x120 = var_x110 + var_x119;
        const double var_x121 = 1 / var_x120;
        const double var_x122 = ((var_x89) ? (-0.001275024 * var_x105 + 0.016701360000000002 * var_x102 * var_x104 / pow(var_x103, 2)) : (-7.6049999999999996e-8 * var_x109 + 0.029999999999999999 * var_x106 * var_x108 / pow(var_x107, 2)));
        const double var_x123 = ((var_x89) ? (var_x118 + var_x111 * var_x114 * (1.5254334000000001e-6 * var_x116 - 31073.016 * var_x115) - 0.311 * var_x111 * var_x112 * var_x117 / pow(var_x113, 2)) : (0));
        const double var_x124 = var_x110;
        const double var_x125 = var_x119;
        const double var_x126 = exp(-1.1670467502850628 - 0.057012542759407071 * var_chaste_interface__membrane__V);
        const double var_x127 = 1.0 + var_x126;
        const double var_x128 = exp(0.50847457627118642 - 0.016949152542372881 * var_chaste_interface__membrane__V);
        const double var_x129 = exp(-1.1764705882352942 - 0.11764705882352941 * var_chaste_interface__membrane__V);
        const double var_x130 = var_x128 + var_x129;
        const double var_x131 = 0.058823529411764705 * var_chaste_interface__membrane__V;
        const double var_x132 = exp(4.8235294117647056 + var_x131);
        const double var_x133 = 1.9500000000000002 * (0.016949152542372881 * var_x128 + 0.11764705882352941 * var_x129) / pow(var_x130, 2) - 0.018352941176470589 * var_x132 / pow((1 + 0.40000000000000002 * var_x132), 2);
        const double var_x134 = 1.9500000000000002 / (2.5 + var_x132);
        const double var_x135 = 1.9500000000000002 / var_x130;
        const double var_x136 = var_x134 + var_x135;
        const double var_x137 = -var_x134 - var_x135;
        const double var_x138 = exp(8.1320754716981138 + 0.18867924528301888 * var_chaste_interface__membrane__V);
        const double var_x139 = 1.0 + var_x138;
        const double var_x140 = exp(-0.16935483870967738 - 0.13440860215053763 * var_chaste_interface__membrane__V);
        const double var_x141 = exp(10.383561643835618 + 0.091324200913242018 * var_chaste_interface__membrane__V);
        const double var_x142 = 3.0 / (35.560000000000002 + var_x140);
        const double var_x143 = 3.0 / (18.530000000000001 + var_x141);
        const double var_x144 = exp(-3.15625 - 0.10416666666666667 * var_chaste_interface__membrane__V);
        const double var_x145 = 1.0 + var_x144;
        const double var_x146 = exp(-3.6189956331877728 + 0.036390101892285295 * var_chaste_interface__membrane__V);
        const double var_x147 = 1.0 + var_x146;
        const double var_x148 = 1 / exp(9.875 - 0.0625 * var_chaste_interface__membrane__V);
        const double var_x149 = exp(6.6071428571428568 - 0.035714285714285712 * var_chaste_interface__membrane__V);
        const double var_x150 = 3.0 / (21.0 + var_x149);
        const double var_x151 = 3.0 * var_x148;
        const double var_x152 = exp(-2.1692307692307691 - 0.15384615384615385 * var_chaste_interface__membrane__V);
        const double var_x153 = 1.0 + var_x152;
        const double var_x154 = 14.1 + var_chaste_interface__membrane__V;
        const double var_x155 = fabs(var_x154) < 1.0e-10;
        const double var_x156 = -0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x157 = exp(-2.8199999999999998 + var_x156);
        const double var_x158 = 1.0 - var_x157;
        const double var_x159 = 0.00029999999999999997 / var_x158;
        const double var_x160 = -3.3328000000000002 + var_chaste_interface__membrane__V;
        const double var_x161 = fabs(var_x160) < 1.0e-10;
        const double var_x162 = exp(-0.65046743564221166 + 0.19517145812596365 * var_chaste_interface__membrane__V);
        const double var_x163 = -1.0 + var_x162;
        const double var_x164 = 7.3898000000000003e-5 / var_x163;
        const double var_x165 = ((var_x155) ? (0.0015) : (var_x154 * var_x159));
        const double var_x166 = ((var_x161) ? (0.00037836118) : (var_x160 * var_x164));
        const double var_x167 = exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V);
        const double var_x168 = 1.0 + var_x167;
        const double var_x169 = -19.899999999999999 + var_chaste_interface__membrane__V;
        const double var_x170 = fabs(var_x169) < 1.0e-10;
        const double var_x171 = exp(-2.2111111111111108 + 0.1111111111111111 * var_chaste_interface__membrane__V);
        const double var_x172 = -1.0 + var_x171;
        const double var_x173 = 3.4999999999999997e-5 / var_x172;
        const double var_x174 = -var_x131;
        const double var_x175 = exp(1.1705882352941175 + var_x174);
        const double var_x176 = 1.0 - var_x175;
        const double var_x177 = 4.0000000000000003e-5 / var_x176;
        const double var_x178 = 2.0 * ((var_x170) ? (0.00068000000000000005) : (var_x169 * var_x177));
        const double var_x179 = 2.0 * ((var_x170) ? (0.00031500000000000001) : (var_x169 * var_x173));
        const double var_x180 = exp(-1.25 - 0.125 * var_chaste_interface__membrane__V);
        const double var_x181 = 1.0 + var_x180;
        const double var_x182 = exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V);
        const double var_x183 = 10.0 + var_chaste_interface__membrane__V;
        const double var_x184 = fabs(var_x183) < 1.0e-10;
        const double var_x185 = 1.0 - var_x182;
        const double var_x186 = 1 / var_x185;
        const double var_x187 = 1.0 + var_x182;
        const double var_x188 = 0.035000000000000003 * var_x186 * var_x187;
        const double var_x189 = 0.005608974358974359 * var_x182 * var_x183;
        const double var_x190 = ((var_x184) ? (0.21838829438742086 + 0.21838829438742086 * var_x182) : (var_x183 * var_x188));
        const double var_x191 = 0.0021888888888888887 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_x192 = exp(-4.057971014492753 - 0.14492753623188406 * var_chaste_interface__membrane__V);
        const double var_x193 = 1.0 + var_x192;
        const double var_x194 = var_x192 / var_x193;
        const double var_x195 = 0.23455745922671672 * var_x33;
        const double var_x196 = var_x195 - 2.7189219554066812e-7 * var_x46 - 0.00011173862339878819 * var_x19;
        const double var_x197 = var_x18 * var_x45;
        const double var_x198 = -var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_rel;
        const double var_x199 = pow(var_chaste_interface__Ca_release_current_from_JSR_u_gate__u, 2);
        const double var_x200 = var_x199 * var_chaste_interface__Ca_release_current_from_JSR_w_gate__w;
        const double var_x201 = var_x200 * var_chaste_interface__Ca_release_current_from_JSR_v_gate__v;
        const double var_x202 = 2117337.2348207757 * var_x201;
        const double var_x203 = -65.0 + var_chaste_interface__membrane__V;
        const double var_x204 = -0.00011173862339878819 * var_x197 + var_x195 * var_x203 - var_x198 * var_x202;
        const double var_x205 = exp(250.0 + var_x204);
        const double var_x206 = 1.0 + var_x205;
        const double var_x207 = var_x205 / pow(var_x206, 2);
        const double var_x208 = 0.125 * var_x207;
        const double var_x209 = var_x32 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x210 = -15.246234849736588 + 0.23455745922671672 * var_chaste_interface__membrane__V;
        const double var_x211 = var_x208 * var_x210;
        const double var_x212 = var_x32 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x213 = var_x31 * NV_Ith_S(mParameters, 0);
        const double var_x214 = var_x198 * var_chaste_interface__Ca_release_current_from_JSR_v_gate__v;
        const double var_x215 = var_x214 * var_chaste_interface__Ca_release_current_from_JSR_u_gate__u * var_chaste_interface__Ca_release_current_from_JSR_w_gate__w;
        const double var_x216 = var_x198 * var_x200;
        const double var_x217 = 264667.15435259696 * var_x207;
        const double var_x218 = var_x199 * var_x214;
        const double var_x219 = var_x202 + 306.61078260627482 * var_x68;
        const double var_x220 = 1 / var_x206;
        const double var_x221 = 1 / (1.9099999999999999 + 2.0899999999999999 * var_x220);
        const double var_x222 = exp(50.0 + var_x204);
        const double var_x223 = 1.0 + var_x222;
        const double var_x224 = var_x222 / pow(var_x223, 2);
        const double var_x225 = var_x221 * var_x224;
        const double var_x226 = var_x207 * (1.0 - 1 / var_x223 - var_chaste_interface__Ca_release_current_from_JSR_v_gate__v) / pow((0.9138755980861244 + var_x220), 2);
        const double var_x227 = 0.47846889952153115 * var_x226;
        const double var_x228 = var_x210 * var_x225;
        const double var_x229 = var_x210 * var_x227;
        const double var_x230 = 1013080.0166606582 * var_x226;
        const double var_x231 = exp(2.3529411764705883 + var_x174);
        const double var_x232 = 1.0 + var_x231;
        const double var_x233 = -7.9000000000000004 + var_chaste_interface__membrane__V;
        const double var_x234 = fabs(var_x233) < 1.0e-10;
        const double var_x235 = exp(1.5800000000000001 + var_x156);
        const double var_x236 = 1.0 - var_x235;
        const double var_x237 = 1 / var_x236;
        const double var_x238 = 1.0 + 0.29999999999999999 * var_x235;
        const double var_x239 = 0.16666666666666666 * var_x237 * var_x238;
        const double var_x240 = var_x233 * var_x235;
        const double var_x241 = ((var_x234) ? (1.0833333333333333) : (var_x233 * var_x239));
        const double var_x242 = 5.9145564270171174e-6 * var_x34;
        const double var_x243 = var_x242 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x244 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x245 = 1.0 + 0.00011900000000000002 / pow(var_x244, 2) + 3.5000000000000004e-5 * var_x66;
        const double var_x246 = 1 / var_x245;
        const double var_x247 = 4.2880534095874102e-10 * NV_Ith_S(mParameters, 0);
        const double var_x248 = 4.6918356272010785e-8 * var_x33;
        const double var_x249 = var_x246 * (3.0496931576807009e-6 - 4.6918356272010785e-8 * var_chaste_interface__membrane__V);
        const double var_x250 = 0.21176470588235291 * var_x246;
        const double var_x251 = 1.0 + 0.00092000000000000003 * var_x64;
        const double var_x252 = 1 / (pow(var_x251, 2) * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 2));
        const double var_x253 = 1.0426301393780176e-7 * var_x63;
        const double var_x254 = 0.21176470588235291 * var_x201;
        const double var_x255 = 1.2526727201836255e-7 * var_x5;
        const double var_x256 = 2.2302249193675268e-8 * var_x10;
        const double var_x257 = 0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_rel;
        const double var_x258 = pow(var_x257, (-2));
        const double var_x259 = 1 / (1.0 + 8.0 * var_x258);
        const double var_x260 = 30.0 * var_x259;
        const double var_x261 = 30.0 * var_x201;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-var_x26 + 0.0063 * var_x30 + 0.0013130252232142858 * var_x47 - 0.12941175999999999 * var_x1 - 0.089999999999999997 * var_x4 - 0.12375 * var_x33 - 0.0018054375000000002 * NV_Ith_S(mParameters, 0) - 0.46904770956521741 * var_x44 - 0.00014738024843876965 * var_x19 - 3.5861851621648651e-7 * var_x46 - 0.0038461538461538464 * var_x48 - var_x11 * var_x12 - var_x36 * var_x37 - var_x6 * var_x7));
        IJth(rJacobian, 1, 0) = (var_x75 + var_x87) * (var_x84 * var_x85 + var_x82 * (var_x86 - var_x85) / pow(var_x83, 2)) + (-var_x86 + var_x85) * (-var_chaste_interface__fast_sodium_current_m_gate__m + var_x82 * var_x84);
        IJth(rJacobian, 2, 0) = (var_x100 + var_x101) * (var_x97 * var_x98 + var_x90 * (-var_x98 - var_x99) / pow(var_x96, 2)) + (-var_chaste_interface__fast_sodium_current_h_gate__h + var_x90 * var_x97) * (var_x98 + var_x99);
        IJth(rJacobian, 3, 0) = (var_x124 + var_x125) * (var_x121 * var_x123 + var_x119 * (-var_x122 - var_x123) / pow(var_x120, 2)) + (-var_chaste_interface__fast_sodium_current_j_gate__j + var_x119 * var_x121) * (var_x122 + var_x123);
        IJth(rJacobian, 4, 0) = var_x133 * (1 / var_x127 - var_chaste_interface__transient_outward_K_current_oa_gate__oa) + 0.057012542759407071 * var_x126 * var_x136 / pow(var_x127, 2);
        IJth(rJacobian, 5, 0) = (1 / var_x139 - var_chaste_interface__transient_outward_K_current_oi_gate__oi) * (0.00031887818877678569 * var_x140 / pow((1 + 0.028121484814398197 * var_x140), 2) - 0.00079791438902835471 * var_x141 / pow((1 + 0.053966540744738258 * var_x141), 2)) - 0.18867924528301888 * var_x138 * (var_x142 + var_x143) / pow(var_x139, 2);
        IJth(rJacobian, 6, 0) = var_x133 * (1 / var_x145 - var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ua_gate__ua) + 0.10416666666666667 * var_x136 * var_x144 / pow(var_x145, 2);
        IJth(rJacobian, 7, 0) = (1 / var_x147 - var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui) * (0.1875 * var_x148 + 0.00024295432458697764 * var_x149 / pow((1 + 0.047619047619047616 * var_x149), 2)) - 0.036390101892285295 * var_x146 * (var_x150 + var_x151) / pow(var_x147, 2);
        IJth(rJacobian, 8, 0) = (1 / var_x153 - var_chaste_interface__rapid_delayed_rectifier_K_current_xr_gate__xr) * (((var_x155) ? (0) : (var_x159 - 5.9999999999999995e-5 * var_x154 * var_x157 / pow(var_x158, 2))) + ((var_x161) ? (0) : (var_x164 - 1.4422780412592461e-5 * var_x160 * var_x162 / pow(var_x163, 2)))) + 0.15384615384615385 * var_x152 * (var_x165 + var_x166) / pow(var_x153, 2);
        IJth(rJacobian, 9, 0) = (pow(var_x168, (-0.5)) - var_chaste_interface__slow_delayed_rectifier_K_current_xs_gate__xs) * (2.0 * ((var_x170) ? (0) : (var_x173 - 3.8888888888888887e-6 * var_x169 * var_x171 / pow(var_x172, 2))) + 2.0 * ((var_x170) ? (0) : (var_x177 - 2.3529411764705885e-6 * var_x169 * var_x175 / pow(var_x176, 2)))) + 0.03937007874015748 * var_x167 * pow(var_x168, (-1.5)) * (var_x178 + var_x179);
        IJth(rJacobian, 10, 0) = (1 / var_x181 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * ((var_x184) ? (-0.034998124100548214 * var_x182) : (var_x188 - var_x186 * var_x189 - var_x187 * var_x189 / pow(var_x185, 2))) + 0.125 * var_x180 * var_x190 / pow(var_x181, 2);
        IJth(rJacobian, 11, 0) = (0.0022222222222222222 + var_x191) * (-0.14492753623188406 * var_x194 + 0.14492753623188406 * pow(var_x192, 2) / pow(var_x193, 2)) + var_x191 * (-0.022713800000000003 - 0.0022713799999999999 * var_chaste_interface__membrane__V) * (var_x194 - var_chaste_interface__L_type_Ca_channel_f_gate__f);
        IJth(rJacobian, 13, 0) = -var_x196 * var_x208;
        IJth(rJacobian, 14, 0) = var_x196 * var_x225 + var_x196 * var_x227;
        IJth(rJacobian, 15, 0) = (1.0 - 1 / var_x232 - var_chaste_interface__Ca_release_current_from_JSR_w_gate__w) * ((var_x234) ? (0) : (var_x239 - 0.01 * var_x237 * var_x240 - 0.033333333333333333 * var_x238 * var_x240 / pow(var_x236, 2))) - 0.058823529411764705 * var_x231 * var_x241 / pow(var_x232, 2);
        IJth(rJacobian, 16, 0) = -3.3526492139188636e-10 * var_x19 - 8.1579594228290865e-13 * var_x46 - 5.1141008336491763e-10 * NV_Ith_S(mParameters, 0) - 1.0670035173794672e-6 * var_x44 - var_x243 * var_x37;
        IJth(rJacobian, 17, 0) = var_x246 * (-var_x247 - var_x248 + 2.7193198076096957e-13 * var_x46 + 1.1175497379729545e-10 * var_x19);
        IJth(rJacobian, 18, 0) = 7.1133567825297815e-7 * var_x44 + 9.9563612471764592e-10 * var_x47 + 4.7771417295138258e-9 * var_x30 - 6.8244881850197507e-8 * var_x4 - 2.9164479423161327e-9 * var_x48 - 9.8129891902512382e-8 * var_x1 - 7.5827646500219453e-7 * var_x26 - var_x12 * var_x256 - var_x255 * var_x7;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (-23.399999999999999 * var_x51);
        IJth(rJacobian, 1, 1) = -var_x75 - var_x87;
        IJth(rJacobian, 16, 1) = -1.7743669281051352e-5 * var_x51 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x35 * var_x50);
        IJth(rJacobian, 2, 2) = -var_x100 - var_x101;
        IJth(rJacobian, 16, 2) = -var_x242 * var_x50 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x36 * var_x49);
        IJth(rJacobian, 3, 3) = -var_x124 - var_x125;
        IJth(rJacobian, 16, 3) = -var_x243 * var_x49 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-0.49560000000000004 * var_x52 * var_chaste_interface__transient_outward_K_current_oi_gate__oi);
        IJth(rJacobian, 4, 4) = var_x137;
        IJth(rJacobian, 18, 4) = -3.7580181605508762e-7 * var_x52 * var_x7;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x28 * var_x6);
        IJth(rJacobian, 5, 5) = -var_x142 - var_x143;
        IJth(rJacobian, 18, 5) = -var_x255 * var_x29;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (-3 * var_x53 * var_chaste_interface__ultrarapid_delayed_rectifier_K_current_ui_gate__ui);
        IJth(rJacobian, 6, 6) = var_x137;
        IJth(rJacobian, 18, 6) = -2.2748293950065834e-6 * var_x25 * var_x53;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x54);
        IJth(rJacobian, 7, 7) = -var_x150 - var_x151;
        IJth(rJacobian, 18, 7) = -7.5827646500219453e-7 * var_x54 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x11 * var_x28);
        IJth(rJacobian, 8, 8) = -var_x165 - var_x166;
        IJth(rJacobian, 18, 8) = -var_x256 * var_x29;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-0.25882351999999997 * var_x55);
        IJth(rJacobian, 9, 9) = -var_x178 - var_x179;
        IJth(rJacobian, 18, 9) = -1.9625978380502476e-7 * var_x55 * NV_Ith_S(mParameters, 0);
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (var_x57 * var_chaste_interface__L_type_Ca_channel_f_gate__f);
        IJth(rJacobian, 10, 10) = -var_x190;
        IJth(rJacobian, 13, 10) = -var_x209 * var_x211;
        IJth(rJacobian, 14, 10) = var_x209 * var_x228 + var_x209 * var_x229;
        IJth(rJacobian, 17, 10) = var_x209 * var_x249;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (var_x57 * var_chaste_interface__L_type_Ca_channel_d_gate__d);
        IJth(rJacobian, 11, 11) = -0.0022222222222222222 - var_x191;
        IJth(rJacobian, 13, 11) = -var_x211 * var_x212;
        IJth(rJacobian, 14, 11) = var_x212 * var_x228 + var_x212 * var_x229;
        IJth(rJacobian, 17, 11) = var_x212 * var_x249;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (var_x31 * var_x56);
        IJth(rJacobian, 12, 12) = -0.5;
        IJth(rJacobian, 13, 12) = -var_x211 * var_x213;
        IJth(rJacobian, 14, 12) = var_x213 * var_x228 + var_x213 * var_x229;
        IJth(rJacobian, 17, 12) = var_x213 * var_x249;
        IJth(rJacobian, 13, 13) = -0.125 + 529334.30870519392 * var_x207 * var_x215;
        IJth(rJacobian, 14, 13) = -4234674.4696415514 * var_x215 * var_x225 - 2026160.0333213164 * var_x215 * var_x226;
        IJth(rJacobian, 17, 13) = 0.42352941176470582 * var_x215 * var_x246;
        IJth(rJacobian, 19, 13) = -60.0 * var_x215 * var_x259;
        IJth(rJacobian, 13, 14) = var_x216 * var_x217;
        IJth(rJacobian, 14, 14) = var_x221 * (-1 - 2117337.2348207757 * var_x216 * var_x224) - var_x216 * var_x230;
        IJth(rJacobian, 17, 14) = var_x216 * var_x250;
        IJth(rJacobian, 19, 14) = -var_x216 * var_x260;
        IJth(rJacobian, 13, 15) = var_x217 * var_x218;
        IJth(rJacobian, 14, 15) = -var_x218 * var_x230 - 2117337.2348207757 * var_x218 * var_x225;
        IJth(rJacobian, 15, 15) = -var_x241;
        IJth(rJacobian, 17, 15) = var_x218 * var_x250;
        IJth(rJacobian, 19, 15) = -var_x218 * var_x260;
        IJth(rJacobian, 0, 16) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-208.36008900708595 * var_x60 - 0.00079585334156935614 * var_x59 - 0.018016135580732888 * var_x58 - 0.022248886402668498 * var_x61));
        IJth(rJacobian, 13, 16) = 7.5423570794182034e-5 * var_x207 * var_x59;
        IJth(rJacobian, 14, 16) = -0.00028870266332701257 * var_x226 * var_x59 - 0.00060338856635345627 * var_x225 * var_x59;
        IJth(rJacobian, 16, 16) = -1.3661211601158392e-8 * var_x58 - 1.8104305755161864e-9 * var_x59 - 0.00015799455173983574 * var_x60 - 5.0612420794952582e-8 * var_x61;
        IJth(rJacobian, 17, 16) = 6.0347685850539541e-10 * var_x246 * var_x59;
        IJth(rJacobian, 18, 16) = 3.3741613863301722e-8 * var_x61;
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (0.27500000000000002 * var_x67 + 404.41140171598391 * var_x68 - 0.27500000000000002 * var_x63 - 0.015106106453013732 * var_x65));
        IJth(rJacobian, 12, 17) = -0.000175 / pow((0.00035 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
        IJth(rJacobian, 13, 17) = -var_x208 * var_x219;
        IJth(rJacobian, 14, 17) = var_x219 * var_x225 + var_x219 * var_x227;
        IJth(rJacobian, 16, 17) = 0.00091996694429933613 * var_x68;
        IJth(rJacobian, 17, 17) = var_x246 * (-var_x253 - var_x254 + 1.0426301393780176e-7 * var_x67 - 0.00030665564809977873 * var_x68 - 3.7341176470588232e-7 * var_x252 - 5.7273025005690459e-9 * var_x65) + (0.00023800000000000004 / pow(var_x244, 3) + 7.0000000000000007e-5 / pow(var_x62, 3)) * (2.7058823529411762e-5 * var_chaste_interface__intracellular_ion_concentrations__Ca_up + 1.1175497379729545e-10 * var_x197 - 0.00040588235294117644 / var_x251 + var_x198 * var_x254 - var_x203 * var_x248 - var_x247 * (-13.356415961992688 * log(1.8 * var_x64) + var_chaste_interface__membrane__V) - var_x253 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) / pow(var_x245, 2);
        IJth(rJacobian, 19, 17) = var_x259 * var_x261;
        IJth(rJacobian, 20, 17) = 4.6e-6 * var_x252;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (var_x0 * (-3.4569545938671333 * var_x69 - 2.4041548731586837 * var_x70 - 0.78567153503275577 * var_x71 - 26.712831923985377 * var_x73 - 4.4129598338423843 * var_x72));
        IJth(rJacobian, 18, 18) = -2.0255711761517402e-5 * var_x73 - 3.346243583002675e-6 * var_x72 - 5.9575623423748584e-7 * var_x71 - 2.621327309110667e-6 * var_x69 - 1.8230140585365661e-6 * var_x70;
        IJth(rJacobian, 13, 19) = var_x201 * var_x217;
        IJth(rJacobian, 14, 19) = -var_x201 * var_x230 - var_x202 * var_x225;
        IJth(rJacobian, 17, 19) = var_x246 * var_x254;
        IJth(rJacobian, 19, 19) = var_x259 * (-0.0055555555555555558 - var_x261) + 0.25 * (0.0055555555555555558 * var_chaste_interface__intracellular_ion_concentrations__Ca_up - 0.0055555555555555558 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel - var_x198 * var_x261) / (pow(var_x257, 3) * pow((0.125 + var_x258), 2));
        IJth(rJacobian, 20, 19) = 0.00048309178743961351;
        IJth(rJacobian, 17, 20) = 2.7058823529411762e-5 * var_x246;
        IJth(rJacobian, 19, 20) = 0.0055555555555555558 * var_x259;
        IJth(rJacobian, 20, 20) = -0.00081642512077294684;
    }

    N_Vector Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__i_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(3);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 1) = var_membrane__Cm_converted;
        NV_Ith_S(dqs, 2) = var_membrane__i_st_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "courtemanche_ramirez_nattel_model_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-81.18);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002908);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9649);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9775);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("transient_outward_K_current_oa_gate__oa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03043);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("transient_outward_K_current_oi_gate__oi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9992);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("ultrarapid_delayed_rectifier_K_current_ua_gate__ua");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004966);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("ultrarapid_delayed_rectifier_K_current_ui_gate__ui");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("rapid_delayed_rectifier_K_current_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.296e-05);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("slow_delayed_rectifier_K_current_xs_gate__xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01869);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001367);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9996);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("L_type_Ca_channel_f_Ca_gate__f_Ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7755);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("Ca_release_current_from_JSR_u_gate__u");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.35e-112);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("Ca_release_current_from_JSR_v_gate__v");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("Ca_release_current_from_JSR_w_gate__w");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9992);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(11.17);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0001013);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.0);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.488);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.488);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellcourtemanche_ramirez_nattel_model_1998FromCellMLCvode)
#endif // CHASTE_CVODE
