#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: bondarenko_model_2004_apex
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "bondarenko_model_2004_apex.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellbondarenko_model_2004_apexFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // millisecond
        const double var_chaste_interface__membrane__stim_period = 71.430000000000007; // millisecond
        const double var_chaste_interface__membrane__stim_start = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellbondarenko_model_2004_apexFromCellMLCvode::Cellbondarenko_model_2004_apexFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                41,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
    }

    Cellbondarenko_model_2004_apexFromCellMLCvode::~Cellbondarenko_model_2004_apexFromCellMLCvode()
    {
    }
    
    double Cellbondarenko_model_2004_apexFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = NV_Ith_S(rY, 18);
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = NV_Ith_S(rY, 27);
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = NV_Ith_S(rY, 37);
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
        const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
        const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_calcium_current__i_CaL + var_calcium_activated_chloride_current__i_ClCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa + var_fast_sodium_current__i_Na + var_fast_transient_outward_potassium_current__i_Kto_f + var_non_inactivating_steady_state_potassium_current__i_Kss + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_slow_transient_outward_potassium_current__i_Kto_s + var_sodium_background_current__i_Nab + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_time_independent_potassium_current__i_K1 + var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellbondarenko_model_2004_apexFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = NV_Ith_S(rY, 2);
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = NV_Ith_S(rY, 3);
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = NV_Ith_S(rY, 4);
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = NV_Ith_S(rY, 6);
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = NV_Ith_S(rY, 7);
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__ryanodine_receptors__P_O1 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.00016774
        double var_chaste_interface__L_type_calcium_current__O = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 1.85106e-14
        double var_chaste_interface__sodium_concentration__Nai = NV_Ith_S(rY, 18);
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.34278
        double var_chaste_interface__potassium_concentration__Ki = NV_Ith_S(rY, 27);
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = NV_Ith_S(rY, 37);
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = NV_Ith_S(rY, 38);
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = NV_Ith_S(rY, 39);
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = NV_Ith_S(rY, 40);
        // Units: dimensionless; Initial value: 3.19129e-05

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__Kpc_half = 20.0; // micromolar
        const double var_L_type_calcium_current__Kpc_max = 0.23324; // per_millisecond
        const double var_L_type_calcium_current__Kpcb = 0.00050000000000000001; // per_millisecond
        const double var_L_type_calcium_current__C1 = 1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2; // dimensionless
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_L_type_calcium_current__i_CaL_max = 7.0; // picoA_per_picoF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_buffering__HTRPN_tot = 140.0; // micromolar
        const double var_calcium_buffering__LTRPN_tot = 70.0; // micromolar
        const double var_calcium_concentration__CMDN_tot = 50.0; // micromolar
        const double var_calcium_concentration__CSQN_tot = 15000.0; // micromolar
        const double var_L_type_calcium_current__gamma = var_L_type_calcium_current__Kpc_max * var_chaste_interface__calcium_concentration__Cass / (var_L_type_calcium_current__Kpc_half + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_calcium_concentration__Km_CMDN = 0.23799999999999999; // micromolar
        const double var_calcium_concentration__Bi = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cai + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Bss = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cass + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Km_CSQN = 800.0; // micromolar
        const double var_calcium_concentration__BJSR = 1 / (1.0 + var_calcium_concentration__CSQN_tot * var_calcium_concentration__Km_CSQN / pow((var_chaste_interface__calcium_concentration__CaJSR + var_calcium_concentration__Km_CSQN), 2)); // dimensionless
        const double var_calcium_fluxes__Km_up = 0.5; // micromolar
        const double var_calcium_fluxes__k_minus_htrpn = 3.1999999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__k_minus_ltrpn = 0.019599999999999999; // per_millisecond
        const double var_calcium_fluxes__k_plus_htrpn = 0.0023700000000000001; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn; // micromolar / millisecond
        const double var_calcium_fluxes__k_plus_ltrpn = 0.0327; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar / millisecond
        const double var_calcium_fluxes__J_trpn = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn - var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_tr = 20.0; // millisecond
        const double var_calcium_fluxes__J_tr = (-var_chaste_interface__calcium_concentration__CaJSR + var_chaste_interface__calcium_concentration__CaNSR) / var_calcium_fluxes__tau_tr; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_xfer = 8.0; // millisecond
        const double var_calcium_fluxes__J_xfer = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__Cass) / var_calcium_fluxes__tau_xfer; // micromolar_per_millisecond
        const double var_calcium_fluxes__v1 = 4.5; // per_millisecond
        const double var_calcium_fluxes__v2 = 1.7399999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__J_leak = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__CaNSR) * var_calcium_fluxes__v2; // micromolar_per_millisecond
        const double var_calcium_fluxes__v3 = 0.45000000000000001; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_fluxes__v3 / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_fluxes__Km_up, 2)); // micromolar_per_millisecond
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Acap = 0.00015339999999999999; // cm2
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__Cm = 1.0; // microF_per_cm2
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = -var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__beta + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta + 4.0 * var_L_type_calcium_current__C1 * var_L_type_calcium_current__alpha - 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha + 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = -var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha + 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta + 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta - 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf + 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta + 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta - 1.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf + 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma - 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O + 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta - 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O; // 1 / millisecond
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.10000000000000001 * var_L_type_calcium_current__i_CaL * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)) / var_L_type_calcium_current__i_CaL_max; // 1 / millisecond
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 + var_fast_sodium_current__C_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = var_fast_sodium_current__C_Na3 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na3; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5; // 1 / millisecond
        const double var_fast_transient_outward_potassium_current__alpha_a = 0.18064 * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_transient_outward_potassium_current__alpha_i = 0.00015200000000000001 * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_transient_outward_potassium_current__beta_a = 0.39560000000000001 * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f = (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ato_f) * var_fast_transient_outward_potassium_current__alpha_a - var_chaste_interface__fast_transient_outward_potassium_current__ato_f * var_fast_transient_outward_potassium_current__beta_a; // 1 / millisecond
        const double var_fast_transient_outward_potassium_current__beta_i = 0.00095 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f = (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ito_f) * var_fast_transient_outward_potassium_current__alpha_i - var_fast_transient_outward_potassium_current__beta_i * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // 1 / millisecond
        const double var_membrane__VJSR = 1.1999999999999999e-7; // microlitre
        const double var_membrane__VNSR = 2.0980000000000001e-6; // microlitre
        const double var_membrane__Vmyo = 2.584e-5; // microlitre
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = (-var_calcium_fluxes__J_leak + var_calcium_fluxes__J_up) * var_membrane__Vmyo / var_membrane__VNSR - var_calcium_fluxes__J_tr * var_membrane__VJSR / var_membrane__VNSR; // micromolar / millisecond
        const double var_membrane__Vss = 1.4849999999999999e-9; // microlitre
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_non_inactivating_steady_state_potassium_current__tau_Kss = 13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V); // millisecond
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__C_K0 = 1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a0 = 0.022348 * exp(0.01176 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a0 = 0.047002000000000002 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1; // 1 / millisecond
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__kb = 0.036777999999999998; // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__kf = 0.023761000000000001; // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = var_rapid_delayed_rectifier_potassium_current__C_K0 * var_rapid_delayed_rectifier_potassium_current__alpha_a0 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__beta_a0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf + var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb; // 1 / millisecond
        const double var_calcium_fluxes__J_rel = (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR * var_calcium_fluxes__v1; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (-var_calcium_fluxes__J_rel + var_calcium_fluxes__J_tr) * var_calcium_concentration__BJSR; // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (var_calcium_fluxes__J_rel * var_membrane__VJSR / var_membrane__Vss - var_calcium_fluxes__J_xfer * var_membrane__Vmyo / var_membrane__Vss - 0.5 * var_L_type_calcium_current__i_CaL * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vss)) * var_calcium_concentration__Bss; // micromolar / millisecond
        const double var_ryanodine_receptors__P_C1 = 1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2; // dimensionless
        const double var_ryanodine_receptors__k_minus_a = 0.071249999999999994; // per_millisecond
        const double var_ryanodine_receptors__k_minus_b = 0.96499999999999997; // per_millisecond
        const double var_ryanodine_receptors__k_minus_c = 0.00080000000000000004; // per_millisecond
        const double var_ryanodine_receptors__k_plus_a = 0.0060749999999999997; // micromolar4_per_millisecond
        const double var_ryanodine_receptors__k_plus_b = 0.0040499999999999998; // micromolar3_per_millisecond
        const double var_ryanodine_receptors__k_plus_c = 0.0089999999999999993; // per_millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c - var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c; // 1 / millisecond
        const double var_ryanodine_receptors__m = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_ryanodine_receptors__n = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c + var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_minus_a - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__n) * var_ryanodine_receptors__P_C1 * var_ryanodine_receptors__k_plus_a - pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__alpha_n = 4.8133299999999997e-6 * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_delayed_rectifier_potassium_current__beta_n = 9.5333299999999997e-5 * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs = (1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs) * var_slow_delayed_rectifier_potassium_current__alpha_n - var_slow_delayed_rectifier_potassium_current__beta_n * var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss = (-var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss + var_slow_transient_outward_potassium_current__ass) / var_non_inactivating_steady_state_potassium_current__tau_Kss; // 1 / millisecond
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__tau_ta_s = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ato_s + var_slow_transient_outward_potassium_current__ass) / var_slow_transient_outward_potassium_current__tau_ta_s; // 1 / millisecond
        const double var_slow_transient_outward_potassium_current__tau_ti_s = 270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ito_s + var_slow_transient_outward_potassium_current__iss) / var_slow_transient_outward_potassium_current__tau_ti_s; // 1 / millisecond
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (-var_calcium_fluxes__J_trpn - var_calcium_fluxes__J_up - 0.5 * (-2.0 * var_sodium_calcium_exchange_current__i_NaCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo) + var_calcium_fluxes__J_leak + var_calcium_fluxes__J_xfer) * var_calcium_concentration__Bi; // micromolar / millisecond
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = (-var_fast_sodium_current__i_Na - var_sodium_background_current__i_Nab - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = (-var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur + 2.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur + var_slow_transient_outward_potassium_current__ass) / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur; // 1 / millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur = 1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur + var_slow_transient_outward_potassium_current__iss) / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
            const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
            const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
            const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
            const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
            const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_membrane__i_stim = var_membrane__i_stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
            d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_activated_chloride_current__i_ClCa - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_membrane__i_stim - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_calcium_concentration__Cai;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_calcium_concentration__Cass;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_calcium_concentration__CaJSR;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_calcium_concentration__CaNSR;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_L_type_calcium_current__O;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_L_type_calcium_current__C2;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_L_type_calcium_current__C3;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_L_type_calcium_current__C4;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_L_type_calcium_current__I1;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_L_type_calcium_current__I2;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_L_type_calcium_current__I3;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_sodium_concentration__Nai;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_fast_sodium_current__O_Na;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_potassium_concentration__Ki;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f;
        NV_Ith_S(rDY,29) = d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f;
        NV_Ith_S(rDY,30) = d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s;
        NV_Ith_S(rDY,31) = d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s;
        NV_Ith_S(rDY,32) = d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs;
        NV_Ith_S(rDY,33) = d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur;
        NV_Ith_S(rDY,34) = d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
        NV_Ith_S(rDY,35) = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss;
        NV_Ith_S(rDY,36) = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
        NV_Ith_S(rDY,37) = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
        NV_Ith_S(rDY,38) = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
        NV_Ith_S(rDY,39) = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
        NV_Ith_S(rDY,40) = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;
    }

    void Cellbondarenko_model_2004_apexFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = NV_Ith_S(rY, 1);
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = NV_Ith_S(rY, 2);
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = NV_Ith_S(rY, 3);
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = NV_Ith_S(rY, 4);
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = NV_Ith_S(rY, 6);
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = NV_Ith_S(rY, 7);
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__ryanodine_receptors__P_O1 = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.00016774
        double var_chaste_interface__L_type_calcium_current__O = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 1.85106e-14
        double var_chaste_interface__sodium_concentration__Nai = NV_Ith_S(rY, 18);
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = NV_Ith_S(rY, 23);
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = NV_Ith_S(rY, 24);
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.34278
        double var_chaste_interface__potassium_concentration__Ki = NV_Ith_S(rY, 27);
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = NV_Ith_S(rY, 29);
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = NV_Ith_S(rY, 30);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = NV_Ith_S(rY, 31);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = NV_Ith_S(rY, 32);
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = NV_Ith_S(rY, 33);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = NV_Ith_S(rY, 34);
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = NV_Ith_S(rY, 35);
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = NV_Ith_S(rY, 36);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = NV_Ith_S(rY, 37);
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = NV_Ith_S(rY, 38);
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = NV_Ith_S(rY, 39);
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = NV_Ith_S(rY, 40);
        // Units: dimensionless; Initial value: 3.19129e-05
        
        const double var_x0 = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2);
        const double var_x1 = 1 / var_chaste_interface__potassium_concentration__Ki;
        const double var_x2 = log(5400.0 * var_x1);
        const double var_x3 = exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * var_x2);
        const double var_x4 = 1.0 + var_x3;
        const double var_x5 = 1 / var_x4;
        const double var_x6 = var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss;
        const double var_x7 = var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
        const double var_x8 = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3);
        const double var_x9 = 0.40670000000000001 * var_x8;
        const double var_x10 = exp(-0.025317124991725771 * var_chaste_interface__membrane__V);
        const double var_x11 = 1.0 + 0.10000000000000001 * var_x10;
        const double var_x12 = 1 / var_x11;
        const double var_x13 = exp(0.013632298072467722 * var_chaste_interface__membrane__V);
        const double var_x14 = var_x13 * pow(var_chaste_interface__sodium_concentration__Nai, 3);
        const double var_x15 = var_x10 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x16 = var_x12 * (24.5381365304419 * var_x14 + 69470190977295.516 * var_x15);
        const double var_x17 = -25.674321243523316 * var_x2 + var_chaste_interface__membrane__V;
        const double var_x18 = var_x17 * var_x3 / pow(var_x4, 2);
        const double var_x19 = exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V);
        const double var_x20 = 1.0 + var_x19;
        const double var_x21 = 1 / var_x20;
        const double var_x22 = var_x21 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x23 = 1 / (10.0 + var_chaste_interface__calcium_concentration__Cai);
        const double var_x24 = 2.0 * var_x23;
        const double var_x25 = 1800.0 * var_x14 - 2744000000000000.0 * var_x15;
        const double var_x26 = var_x10 * var_x25 / pow(var_x11, 2);
        const double var_x27 = 1 / var_chaste_interface__sodium_concentration__Nai;
        const double var_x28 = pow(var_x27, 1.5);
        const double var_x29 = exp(-0.0038949423064193493 * var_chaste_interface__membrane__V);
        const double var_x30 = exp(2.0802377414561666);
        const double var_x31 = exp(-0.038949423064193495 * var_chaste_interface__membrane__V);
        const double var_x32 = 1.0 + 0.1245 * var_x29 + 0.036499999999999998 * var_x31 * (-0.14285714285714285 + 0.14285714285714285 * var_x30);
        const double var_x33 = (0.00048492031714920898 * var_x29 + 0.038949423064193495 * var_x31 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x30)) / (pow(var_x32, 2) * (1.0 + 3043189.1166997822 * var_x28));
        const double var_x34 = 40.0 + var_chaste_interface__membrane__V;
        const double var_x35 = 1 / var_chaste_interface__calcium_concentration__Cai;
        const double var_x36 = pow(var_chaste_interface__calcium_concentration__Cai, 2);
        const double var_x37 = 0.25 + var_x36;
        const double var_x38 = pow(var_chaste_interface__calcium_concentration__Cai, 3) / pow(var_x37, 2);
        const double var_x39 = var_x10 * var_x12;
        const double var_x40 = 1 / var_x37;
        const double var_x41 = var_x40 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x42 = var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki;
        const double var_x43 = (7.1123755334281649e-6 * var_chaste_interface__sodium_concentration__Nai + 7.9026394815868502e-7 * var_chaste_interface__potassium_concentration__Ki) / pow(var_x42, 2);
        const double var_x44 = var_x12 * var_x13 * pow(var_chaste_interface__sodium_concentration__Nai, 2);
        const double var_x45 = var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai;
        const double var_x46 = (2.4715768660405338e-6 * var_chaste_interface__sodium_concentration__Nai + 0.00012110726643598615 * var_chaste_interface__potassium_concentration__Ki) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K / pow(var_x45, 2);
        const double var_x47 = var_x43 * var_chaste_interface__fast_sodium_current__O_Na;
        const double var_x48 = var_x27 * var_x28 / (var_x32 * pow((3.2860264730588296e-7 + var_x28), 2));
        const double var_x49 = log(140600.0 / var_x42);
        const double var_x50 = var_x0 * var_x1;
        const double var_x51 = var_x1 * var_x5;
        const double var_x52 = var_x1 * var_x7;
        const double var_x53 = var_x1 * var_x6;
        const double var_x54 = var_x1 * var_x8 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f;
        const double var_x55 = var_x1 * var_x18;
        const double var_x56 = var_x17 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 2) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f;
        const double var_x57 = var_x17 * var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs;
        const double var_x58 = 4.1078913989637309 * var_x2 - 0.16 * var_chaste_interface__membrane__V;
        const double var_x59 = 1.2837160621761659 * var_x2 - 0.050000000000000003 * var_chaste_interface__membrane__V;
        const double var_x60 = log(8257.1428571428569 / var_x45);
        const double var_x61 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai;
        const double var_x62 = pow(var_x61, (-2));
        const double var_x63 = 1 / (1.0 + 11.899999999999999 * var_x62);
        const double var_x64 = 0.0327 * var_chaste_interface__calcium_buffering__LTRPN_Ca;
        const double var_x65 = 0.0023700000000000001 * var_chaste_interface__calcium_buffering__HTRPN_Ca;
        const double var_x66 = 0.0327 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x67 = 0.0023700000000000001 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x68 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass;
        const double var_x69 = pow(var_x68, (-2));
        const double var_x70 = 1 / (1.0 + 11.899999999999999 * var_x69);
        const double var_x71 = 92.541511836848613 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x72 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x73 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x74 = var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x75 = var_x74 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x76 = var_x70 * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x77 = 363.63636363636363 * var_chaste_interface__calcium_concentration__CaJSR - 363.63636363636363 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x78 = var_x76 * var_x77;
        const double var_x79 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x80 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x81 = 1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR;
        const double var_x82 = pow(var_x81, (-2));
        const double var_x83 = 1 / (1.0 + 18.75 * var_x82);
        const double var_x84 = var_x83 * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x85 = 4.5 * var_chaste_interface__calcium_concentration__Cass - 4.5 * var_chaste_interface__calcium_concentration__CaJSR;
        const double var_x86 = var_x84 * var_x85;
        const double var_x87 = 0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x88 = exp(-0.038580246913580245 * pow((-1 + var_x87), 2));
        const double var_x89 = var_x88 * (0.15561 - 0.00247 * var_chaste_interface__membrane__V);
        const double var_x90 = pow(var_chaste_interface__calcium_concentration__Cass, 3.0);
        const double var_x91 = 0.012149999999999999 * pow(var_chaste_interface__calcium_concentration__Cass, 2.0) * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x92 = 0.0040499999999999998 * var_x90;
        const double var_x93 = -0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0);
        const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x95 = 0.015384615384615385 * var_x94 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x96 = -0.28999999999999998 - 0.02 * var_chaste_interface__membrane__V;
        const double var_x97 = exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2));
        const double var_x98 = 0.013000000000000001 * var_x97;
        const double var_x99 = var_x96 * var_x98;
        const double var_x100 = var_x99 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
        const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x104 = 1.0 + 0.12 * var_x103;
        const double var_x105 = var_x103 / var_x104;
        const double var_x106 = var_x105 * (var_x101 * (-8.0 - var_x87) - var_x102 * (-0.10000000000000001 - 0.0050000000000000001 * var_chaste_interface__membrane__V));
        const double var_x107 = var_x106 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x108 = 0.40000000000000002 * var_x107;
        const double var_x109 = 1.0 + var_x101 - var_x102;
        const double var_x110 = var_x105 * var_x109;
        const double var_x111 = 4.0000000000000003e-5 * var_x110;
        const double var_x112 = var_x111 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x113 = var_x110 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x114 = 0.040000000000000001 * var_x113;
        const double var_x115 = 0.00040000000000000002 * var_x106;
        const double var_x116 = var_x115 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x117 = var_x109 * pow(var_x103, 2) / pow(var_x104, 2);
        const double var_x118 = 4.7999999999999998e-6 * var_x117;
        const double var_x119 = var_x118 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x120 = var_x117 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x121 = 0.0048000000000000004 * var_x120;
        const double var_x122 = 1 / (20.0 + var_chaste_interface__calcium_concentration__Cass);
        const double var_x123 = 0.23324 * var_x122;
        const double var_x124 = var_x123 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x125 = var_chaste_interface__calcium_concentration__Cass / pow((1 + 0.050000000000000003 * var_chaste_interface__calcium_concentration__Cass), 2);
        const double var_x126 = 0.00058310000000000002 * var_x125;
        const double var_x127 = var_x126 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x128 = 0.20000000000000001 * var_x94;
        const double var_x129 = var_x123 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x130 = -var_x129;
        const double var_x131 = 0.40000000000000002 * var_x110;
        const double var_x132 = 0.00040000000000000002 * var_x110;
        const double var_x133 = 0.0076923076923076927 * var_x94 * var_chaste_interface__L_type_calcium_current__C3;
        const double var_x134 = 1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2;
        const double var_x135 = 0.0144 * var_x117 * var_chaste_interface__L_type_calcium_current__C2;
        const double var_x136 = 1.2000000000000002 * var_x106 * var_chaste_interface__L_type_calcium_current__C2;
        const double var_x137 = 0.12000000000000001 * var_x110 * var_chaste_interface__L_type_calcium_current__C2;
        const double var_x138 = -1.6000000000000001 * var_x110;
        const double var_x139 = 0.10000000000000001 * var_x94;
        const double var_x140 = 0.011538461538461539 * var_x94 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x141 = 0.0096000000000000009 * var_x117 * var_chaste_interface__L_type_calcium_current__C3;
        const double var_x142 = 0.80000000000000004 * var_x106 * var_chaste_interface__L_type_calcium_current__C3;
        const double var_x143 = 0.080000000000000002 * var_x110 * var_chaste_interface__L_type_calcium_current__C3;
        const double var_x144 = 0.80000000000000004 * var_x110;
        const double var_x145 = 0.15000000000000002 * var_x94;
        const double var_x146 = 7.6923076923076936e-6 * var_x94 * var_chaste_interface__L_type_calcium_current__I3;
        const double var_x147 = 3.0769230769230774e-5 * var_x94 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x148 = var_x94 * var_chaste_interface__L_type_calcium_current__I1;
        const double var_x149 = 0.026000000000000002 * var_x97;
        const double var_x150 = var_x96 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x151 = var_x149 * var_x150;
        const double var_x152 = var_x122 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x153 = 3.0321199999999999 * var_x150 * var_x152 * var_x97;
        const double var_x154 = 1.1195520000000001e-5 * var_x120 * var_x152;
        const double var_x155 = 0.00093296000000000004 * var_x152;
        const double var_x156 = var_x107 * var_x155;
        const double var_x157 = 9.3296000000000009e-5 * var_x113 * var_x152;
        const double var_x158 = 13.0 - 13.0 * var_x97;
        const double var_x159 = var_x158 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x160 = var_x123 * var_x159;
        const double var_x161 = var_x126 * var_x159;
        const double var_x162 = 0.00093296000000000004 * var_x113 * var_x122;
        const double var_x163 = 2.3324000000000003e-6 * var_x113 * var_x125;
        const double var_x164 = var_x129 * var_x158;
        const double var_x165 = var_x110 * var_x155;
        const double var_x166 = 0.00040000000000000002 * var_x94;
        const double var_x167 = 0.0001 * var_x94;
        const double var_x168 = var_x99 * var_chaste_interface__L_type_calcium_current__I1;
        const double var_x169 = 0.026000000000000002 * var_x97;
        const double var_x170 = var_x94 * (-0.026000000000000002 + var_x169);
        const double var_x171 = var_x111 * var_chaste_interface__L_type_calcium_current__I3;
        const double var_x172 = var_x115 * var_chaste_interface__L_type_calcium_current__I3;
        const double var_x173 = var_x118 * var_chaste_interface__L_type_calcium_current__I3;
        const double var_x174 = var_x123 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x175 = var_x126 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x176 = 0.013000000000000001 - var_x98;
        const double var_x177 = -var_x132;
        const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
        const double var_x179 = exp(0.36945812807881773 + var_x178);
        const double var_x180 = 0.01083743842364532 * var_x179 * var_chaste_interface__fast_sodium_current__O_Na;
        const double var_x181 = exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V);
        const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
        const double var_x183 = (0.0085583333333333327 * var_x181 + 0.0016666666666666668 * var_x182) / pow((var_x182 + 0.4108 * var_x181), 2);
        const double var_x184 = 60.832000000000001 * var_x183 * var_chaste_interface__fast_sodium_current__C_Na1;
        const double var_x185 = exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V);
        const double var_x186 = var_x185 / pow((1 + 0.47846713846216332 * var_x185), 2);
        const double var_x187 = 0.073163809141391992 * var_x186 * var_chaste_interface__fast_sodium_current__O_Na;
        const double var_x188 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
        const double var_x189 = 0.008539999999999999 + var_x188;
        const double var_x190 = 1 / var_x189;
        const double var_x191 = 1 / (0.39395599999999997 + 0.188495 * var_x185);
        const double var_x192 = 1 / (0.25 * var_x182 + 0.1027 * var_x181);
        const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
        const double var_x194 = exp(-0.90909090909090906 + var_x193);
        const double var_x195 = 1 / var_x179;
        const double var_x196 = var_x191 * var_x192 * var_x194 * var_x195;
        const double var_x197 = var_x190 * var_x196;
        const double var_x198 = 9.7514961527500711e-7 * var_x197 * var_chaste_interface__fast_sodium_current__IF_Na;
        const double var_x199 = 3.317429681310359e-6 * var_x196 * var_chaste_interface__fast_sodium_current__IF_Na / pow((1 + 0.0023419203747072604 * var_chaste_interface__membrane__V), 2);
        const double var_x200 = var_x186 * var_chaste_interface__fast_sodium_current__IF_Na;
        const double var_x201 = var_x190 * var_x194 * var_x195;
        const double var_x202 = 8.8508255294954831e-7 * var_x192 * var_x200 * var_x201;
        const double var_x203 = 0.00019355636363636362 * var_x183 * var_x191 * var_x201 * var_chaste_interface__fast_sodium_current__IF_Na;
        const double var_x204 = var_x191;
        const double var_x205 = 0.22 * var_x179;
        const double var_x206 = 3.802 * var_x192;
        const double var_x207 = 1.2097272727272726e-5 * var_x197;
        const double var_x208 = 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__C_Na1;
        const double var_x209 = -var_x208;
        const double var_x210 = exp(0.12315270935960591 + var_x178);
        const double var_x211 = 0.009852216748768473 * var_x210;
        const double var_x212 = var_x211 * var_chaste_interface__fast_sodium_current__C_Na1;
        const double var_x213 = 9.0909090909090901e-8 * var_x194;
        const double var_x214 = var_x213 * var_chaste_interface__fast_sodium_current__IF_Na;
        const double var_x215 = exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V);
        const double var_x216 = 71.871455576559541 * (0.0068466666666666667 * var_x215 + 0.0015333333333333334 * var_x182) / pow((var_x182 + 0.44652173913043475 * var_x215), 2);
        const double var_x217 = var_x216 * var_chaste_interface__fast_sodium_current__C_Na2;
        const double var_x218 = 0.20000000000000001 * var_x210;
        const double var_x219 = -var_x218;
        const double var_x220 = -0.008539999999999999 - var_x188;
        const double var_x221 = 3.802 / (0.1027 * var_x215 + 0.23000000000000001 * var_x182);
        const double var_x222 = 6.9999999999999997e-7 * var_x194;
        const double var_x223 = 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__C_Na2;
        const double var_x224 = -var_x223;
        const double var_x225 = exp(-0.12315270935960591 + var_x178);
        const double var_x226 = 0.0094433497536945809 * var_x225;
        const double var_x227 = var_x213 * var_chaste_interface__fast_sodium_current__IC_Na2;
        const double var_x228 = exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V);
        const double var_x229 = 95.049999999999997 * (0.0013333333333333335 * var_x182 + 0.0060411764705882356 * var_x228) / pow((var_x182 + 0.51349999999999996 * var_x228), 2);
        const double var_x230 = 3.802 / (0.20000000000000001 * var_x182 + 0.1027 * var_x228);
        const double var_x231 = -var_x230;
        const double var_x232 = 0.19170000000000001 * var_x225;
        const double var_x233 = -var_x221 - var_x232;
        const double var_x234 = var_x220 + var_x231;
        const double var_x235 = var_x213 * var_chaste_interface__fast_sodium_current__I1_Na;
        const double var_x236 = 1.818181818181818e-9 * var_x194 * var_chaste_interface__fast_sodium_current__I2_Na;
        const double var_x237 = 7.3163809141391995e-5 * var_x200;
        const double var_x238 = 7.7014535938307356e-7 * var_x186 * var_chaste_interface__fast_sodium_current__I1_Na;
        const double var_x239 = -var_x222;
        const double var_x240 = 1.0526315789473684e-5 * var_x191;
        const double var_x241 = 1.4e-8 * var_x194;
        const double var_x242 = 0.001 * var_x191;
        const double var_x243 = var_x211 * var_chaste_interface__fast_sodium_current__IF_Na;
        const double var_x244 = var_x216 * var_chaste_interface__fast_sodium_current__IC_Na2;
        const double var_x245 = var_x226 * var_chaste_interface__fast_sodium_current__IC_Na2;
        const double var_x246 = var_x229 * var_chaste_interface__fast_sodium_current__IC_Na3;
        const double var_x247 = 0.025019562392723654 * var_x8;
        const double var_x248 = 0.25271120029236765 * var_x2 - 0.0098429554532475649 * var_chaste_interface__membrane__V;
        const double var_x249 = 0.078972250091364882 * var_x2 - 0.003075923579139864 * var_chaste_interface__membrane__V;
        const double var_x250 = exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V);
        const double var_x251 = exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V);
        const double var_x252 = 0.14285714285714285 * var_chaste_interface__membrane__V;
        const double var_x253 = exp(4.7857142857142856 + var_x252);
        const double var_x254 = 1.0 + 0.051334999999999999 * var_x253;
        const double var_x255 = var_x253 / var_x254;
        const double var_x256 = 1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ito_f;
        const double var_x257 = -var_x252;
        const double var_x258 = exp(-4.7857142857142856 + var_x257);
        const double var_x259 = 1.0 + 0.0067083000000000004 * var_x258;
        const double var_x260 = exp(-1.9285714285714286 + var_x257);
        const double var_x261 = var_x260 / var_x259;
        const double var_x262 = exp(-2.9220779220779218 + var_x193);
        const double var_x263 = 1.0 + var_x262;
        const double var_x264 = 1 / var_x263;
        const double var_x265 = exp(-0.062899999999999998 * var_chaste_interface__membrane__V);
        const double var_x266 = 0.0073216139155926159 * var_x265 / pow((1 + 0.23955296404275997 * var_x265), 2);
        const double var_x267 = 1 / (2.0579999999999998 + 0.49299999999999999 * var_x265);
        const double var_x268 = 0.12987012987012986 * var_x262 / pow(var_x263, 2);
        const double var_x269 = var_x267 * var_x268;
        const double var_x270 = -var_x267;
        const double var_x271 = exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V);
        const double var_x272 = 1.0 + var_x271;
        const double var_x273 = 1 / var_x272;
        const double var_x274 = 1 / (270.0 + 1050.0 * var_x273);
        const double var_x275 = var_x271 / pow(var_x272, 2);
        const double var_x276 = 0.17543859649122806 * var_x275;
        const double var_x277 = var_x273;
        const double var_x278 = 1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs;
        const double var_x279 = exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V);
        const double var_x280 = 1.0 - var_x279;
        const double var_x281 = 4.8133299999999997e-6 / var_x280;
        const double var_x282 = exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V);
        const double var_x283 = 26.5 + var_chaste_interface__membrane__V;
        const double var_x284 = 1 / (1200.0 - 170.0 * var_x273);
        const double var_x285 = exp(-0.086199999999999999 * var_chaste_interface__membrane__V);
        const double var_x286 = 1 / (13.17 + 39.299999999999997 * var_x285);
        const double var_x287 = exp(0.038198000000000003 * var_chaste_interface__membrane__V);
        const double var_x288 = 0.00052457313400000008 * var_x287 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2;
        const double var_x289 = exp(-0.041779999999999998 * var_chaste_interface__membrane__V);
        const double var_x290 = 2.8786419999999997e-6 * var_x289 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K;
        const double var_x291 = exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V);
        const double var_x292 = 0.0021243940109999999 * var_x291 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K;
        const double var_x293 = exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V);
        const double var_x294 = 0.00021232196 * var_x293 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K;
        const double var_x295 = 6.8899999999999994e-5 * var_x289;
        const double var_x296 = 0.090820999999999999 * var_x291;
        const double var_x297 = 0.013733 * var_x287;
        const double var_x298 = 0.0064970000000000002 * var_x293;
        const double var_x299 = exp(0.01176 * var_chaste_interface__membrane__V);
        const double var_x300 = exp(-0.063100000000000003 * var_chaste_interface__membrane__V);
        const double var_x301 = -0.022348 * var_x299;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.002967 + 0.025339071657754012 * var_x18 - 13.0 * var_chaste_interface__fast_sodium_current__O_Na - 0.1729 * var_chaste_interface__L_type_calcium_current__O - 0.0057499999999999999 * var_x0 - 0.050000000000000003 * var_x6 - 0.078 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K - 0.16 * var_x7 - 6.8281768329957496e-20 * var_x26 - 0.68869565217391304 * var_x33 - 2.6970585464294846e-17 * var_x16 - 0.28280213903743318 * var_x5 - var_x22 * var_x24 - var_x9 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 0.25641025641025644 * var_x19 * var_x23 * var_x34 * var_chaste_interface__calcium_concentration__Cai / pow(var_x20, 2));
        IJth(rJacobian, 1, 0) = var_x63 * (-1.12886395354433e-5 + 1.6591891954566281e-18 * var_x16 + 4.2005900246296372e-21 * var_x26);
        IJth(rJacobian, 2, 0) = -var_x70 * var_x71;
        IJth(rJacobian, 5, 0) = -0.00247 * var_x88 * var_chaste_interface__L_type_calcium_current__O + var_x89 * (0.015432098765432098 - 0.0030864197530864196 * var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O;
        IJth(rJacobian, 11, 0) = var_x100 + var_x108 + var_x112 + var_x114 + var_x116 + var_x95 - var_x119 - var_x121;
        IJth(rJacobian, 12, 0) = var_x135 - var_x133 - var_x136 - var_x137 + 1.6000000000000001 * var_x106 * var_x134 + 0.16 * var_x110 * var_x134 + 0.0038461538461538464 * var_x94 * var_chaste_interface__L_type_calcium_current__C2 - 0.019200000000000002 * var_x117 * var_x134;
        IJth(rJacobian, 13, 0) = var_x133 + var_x136 + var_x137 + var_x141 - var_x135 - var_x140 - var_x142 - var_x143;
        IJth(rJacobian, 14, 0) = var_x121 + var_x140 + var_x142 + var_x143 + var_x151 + var_x153 + var_x154 - var_x108 - var_x114 - var_x141 - var_x146 - var_x147 - var_x156 - var_x157 - var_x95 - 7.6923076923076936e-8 * var_x148;
        IJth(rJacobian, 15, 0) = var_x156 + var_x157 + var_x168 + var_x171 + var_x172 - var_x154 - var_x173 - 0.076923076923076927 * var_x170 * var_chaste_interface__L_type_calcium_current__I1 + var_x148 * var_x169 * var_x96;
        IJth(rJacobian, 16, 0) = var_x119 + var_x147 - var_x100 - var_x112 - var_x116 - var_x151;
        IJth(rJacobian, 17, 0) = var_x146 + var_x173 - var_x153 - var_x168 - var_x171 - var_x172;
        IJth(rJacobian, 18, 0) = -0.00015994802611527293 - 0.12710251172237072 * var_x33 - 4.9775675863698838e-18 * var_x16 - 0.79974013057636462 * var_chaste_interface__fast_sodium_current__O_Na - 1.2601770073888912e-20 * var_x26;
        IJth(rJacobian, 19, 0) = var_x180 + var_x184 + var_x202 + var_x203 - var_x187 - var_x198 - var_x199;
        IJth(rJacobian, 20, 0) = var_x209 + var_x212 + var_x217 - var_x180 - var_x184 - var_x214;
        IJth(rJacobian, 21, 0) = var_x224 - var_x212 - var_x217 - var_x227 + var_x226 * var_chaste_interface__fast_sodium_current__C_Na2 + var_x229 * (1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na);
        IJth(rJacobian, 22, 0) = var_x235 + var_x237 - var_x236 - var_x238;
        IJth(rJacobian, 23, 0) = var_x236 + var_x238;
        IJth(rJacobian, 24, 0) = var_x187 + var_x198 + var_x199 + var_x208 + var_x214 + var_x243 + var_x244 - var_x202 - var_x203 - var_x235 - var_x237;
        IJth(rJacobian, 25, 0) = var_x223 + var_x227 + var_x245 + var_x246 - var_x243 - var_x244;
        IJth(rJacobian, 26, 0) = 2.0000000000000002e-5 + var_x209 + var_x224 - var_x245 - var_x246 - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__I1_Na - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__I2_Na - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__IC_Na2 - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__IC_Na3 - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__IF_Na - 2.0000000000000002e-5 * var_chaste_interface__fast_sodium_current__O_Na + var_x213 * var_chaste_interface__fast_sodium_current__IC_Na3;
        IJth(rJacobian, 27, 0) = 0.084735007814913818 * var_x33 + 0.0015588209597120041 * var_x18 - 0.0047984407834581883 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K - 0.017397555353928618 * var_x5 - 0.00035373121160108434 * var_x0 - 0.0098429554532475649 * var_x7 - 0.003075923579139864 * var_x6 - var_x247 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f;
        IJth(rJacobian, 28, 0) = 0.035770000000000003 * var_x250 * (0.18064 - 0.18064 * var_chaste_interface__fast_transient_outward_potassium_current__ato_f) + 0.024673572000000001 * var_x251 * var_chaste_interface__fast_transient_outward_potassium_current__ato_f;
        IJth(rJacobian, 29, 0) = -0.00013571428571428572 * var_x255 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 2.1714285714285715e-5 * var_x256 * var_x261 + 6.9668928571428572e-6 * pow(var_x253, 2) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f / pow(var_x254, 2) + 1.4566594285714287e-7 * var_x256 * var_x258 * var_x260 / pow(var_x259, 2);
        IJth(rJacobian, 30, 0) = var_x269 + var_x266 * (var_x264 - var_chaste_interface__slow_transient_outward_potassium_current__ato_s);
        IJth(rJacobian, 31, 0) = -var_x274 * var_x276 + 0.00016708437761069341 * var_x275 * (var_x277 - var_chaste_interface__slow_transient_outward_potassium_current__ito_s) / pow((0.25714285714285712 + var_x273), 2);
        IJth(rJacobian, 32, 0) = var_x278 * var_x281 + 3.6226653999999999e-6 * var_x282 * var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs - 6.1610624e-7 * var_x278 * var_x279 * var_x283 / pow(var_x280, 2);
        IJth(rJacobian, 33, 0) = var_x269 + var_x266 * (var_x264 - var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur);
        IJth(rJacobian, 34, 0) = -var_x276 * var_x284 - 2.0711500974658867e-5 * var_x275 * (var_x277 - var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur) / pow((1 - 0.14166666666666666 * var_x273), 2);
        IJth(rJacobian, 35, 0) = var_x268 * var_x286 + 0.0021933842239185751 * var_x285 * (var_x264 - var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss) / pow((0.33511450381679392 + var_x285), 2);
        IJth(rJacobian, 37, 0) = var_x288 + var_x290 - var_x292 - var_x294;
        IJth(rJacobian, 38, 0) = 0.01176 * var_x299 * (0.022348 - 0.022348 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - 0.022348 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - 0.022348 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - 0.022348 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K) + 0.0029658262000000005 * var_x300 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1;
        IJth(rJacobian, 39, 0) = -var_x288 - var_x290;
        IJth(rJacobian, 40, 0) = var_x292 + var_x294;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (2.0 * var_x38 + 0.074007286514025064 * var_x39 - 2.0 * var_x41 - 0.0047112379481865285 * var_x35 - var_x21 * var_x24 * var_x34 + 0.02 * var_x22 * var_x34 / pow((1 + 0.10000000000000001 * var_chaste_interface__calcium_concentration__Cai), 2));
        IJth(rJacobian, 1, 1) = var_x63 * (-2.7458174 + var_x64 + var_x65 + 0.96151847158279735 * var_x38 - 0.0045528151523329874 * var_x39 - 0.96151847158279735 * var_x41 - 0.00014491407891765456 * var_x35) + 0.16806722689075632 * (0.125 * var_chaste_interface__calcium_concentration__Cass + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR + 0.00014491407891765456 * log(1800.0 * var_x35) - 0.1250174 * var_chaste_interface__calcium_concentration__Cai - 1.12886395354433e-5 * var_chaste_interface__membrane__V - var_x66 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) - var_x67 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) + 1.6591891954566281e-18 * var_x12 * var_x25 - 0.48075923579139868 * var_x36 * var_x40) / (pow(var_x61, 3) * pow((0.084033613445378158 + var_x62), 2));
        IJth(rJacobian, 2, 1) = 2175.0841750841751 * var_x70;
        IJth(rJacobian, 4, 1) = 0.0002143069590085796 + 11.084842707340323 * var_x41 - 11.084842707340323 * var_x38;
        IJth(rJacobian, 6, 1) = 2.2890000000000001 - var_x64;
        IJth(rJacobian, 7, 1) = 0.33180000000000004 - var_x65;
        IJth(rJacobian, 18, 1) = 0.013658445456998961 * var_x39;
        IJth(rJacobian, 1, 2) = 0.125 * var_x63;
        IJth(rJacobian, 2, 2) = var_x70 * (-2175.0841750841751 + (-var_x72 - var_x73) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.16806722689075632 * (363.63636363636363 * var_x75 + 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cai - 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cass - var_x71 * (-63.0 + var_chaste_interface__membrane__V)) / (pow(var_x68, 3) * pow((0.084033613445378158 + var_x69), 2));
        IJth(rJacobian, 3, 2) = var_x84 * (var_x79 + var_x80);
        IJth(rJacobian, 8, 2) = -var_x91 + 0.024299999999999999 * var_x90 * (1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2);
        IJth(rJacobian, 9, 2) = var_x91;
        IJth(rJacobian, 11, 2) = var_x127 - var_x124;
        IJth(rJacobian, 14, 2) = var_x161 + var_x163 - var_x160 - var_x162;
        IJth(rJacobian, 15, 2) = var_x124 + var_x162 - var_x127 - var_x163;
        IJth(rJacobian, 16, 2) = var_x175 - var_x174;
        IJth(rJacobian, 17, 2) = var_x160 + var_x174 - var_x161 - var_x175;
        IJth(rJacobian, 2, 3) = var_x76 * (var_x72 + var_x73);
        IJth(rJacobian, 3, 3) = var_x83 * (-0.050000000000000003 + (-var_x79 - var_x80) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.00013333333333333334 * (0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 4.5 * var_x75 - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR) / (pow(var_x81, 3) * pow((0.053333333333333337 + var_x82), 2));
        IJth(rJacobian, 4, 3) = 0.0028598665395614866;
        IJth(rJacobian, 1, 4) = 1.7399999999999999e-5 * var_x63;
        IJth(rJacobian, 3, 4) = 0.050000000000000003 * var_x83;
        IJth(rJacobian, 4, 4) = -0.0030741734985700662;
        IJth(rJacobian, 2, 5) = var_x70 * var_x74 * var_x77;
        IJth(rJacobian, 3, 5) = var_x74 * var_x83 * var_x85;
        IJth(rJacobian, 5, 5) = -0.040000000000000001;
        IJth(rJacobian, 1, 6) = var_x63 * (0.019599999999999999 + var_x66);
        IJth(rJacobian, 6, 6) = -0.019599999999999999 - var_x66;
        IJth(rJacobian, 1, 7) = var_x63 * (3.1999999999999999e-5 + var_x67);
        IJth(rJacobian, 7, 7) = -3.1999999999999999e-5 - var_x67;
        IJth(rJacobian, 2, 8) = var_x78;
        IJth(rJacobian, 3, 8) = var_x86;
        IJth(rJacobian, 8, 8) = -0.080249999999999988 + var_x93 - var_x92;
        IJth(rJacobian, 9, 8) = var_x92;
        IJth(rJacobian, 10, 8) = 0.0089999999999999993;
        IJth(rJacobian, 2, 9) = var_x78;
        IJth(rJacobian, 3, 9) = var_x86;
        IJth(rJacobian, 8, 9) = 0.96499999999999997 + var_x93;
        IJth(rJacobian, 9, 9) = -0.96499999999999997;
        IJth(rJacobian, 8, 10) = 0.00080000000000000004 + var_x93;
        IJth(rJacobian, 10, 10) = -0.00080000000000000004;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (10.8927 - 0.1729 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 2, 11) = var_x70 * (5830.115245721463 - 92.541511836848613 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 5, 11) = var_x89;
        IJth(rJacobian, 11, 11) = -0.013000000000000001 + var_x130 + var_x98 - var_x128;
        IJth(rJacobian, 12, 11) = var_x138;
        IJth(rJacobian, 14, 11) = var_x128;
        IJth(rJacobian, 15, 11) = var_x129;
        IJth(rJacobian, 16, 11) = var_x176;
        IJth(rJacobian, 12, 12) = -0.050000000000000003 * var_x94 - 4.4000000000000004 * var_x110;
        IJth(rJacobian, 13, 12) = 1.2000000000000002 * var_x110;
        IJth(rJacobian, 12, 13) = var_x138 + var_x139;
        IJth(rJacobian, 13, 13) = -var_x139 - var_x144;
        IJth(rJacobian, 14, 13) = var_x144;
        IJth(rJacobian, 11, 14) = var_x131;
        IJth(rJacobian, 12, 14) = var_x138;
        IJth(rJacobian, 13, 14) = var_x145;
        IJth(rJacobian, 14, 14) = -0.026000000000000002 + var_x149 - var_x131 - var_x145 - var_x164 - var_x165;
        IJth(rJacobian, 15, 14) = var_x165;
        IJth(rJacobian, 16, 14) = 0.026000000000000002 - var_x149;
        IJth(rJacobian, 17, 14) = var_x164;
        IJth(rJacobian, 11, 15) = 0.00050000000000000001;
        IJth(rJacobian, 12, 15) = var_x138;
        IJth(rJacobian, 14, 15) = 1.0000000000000002e-6 * var_x94;
        IJth(rJacobian, 15, 15) = -0.0135 + var_x170 + var_x98;
        IJth(rJacobian, 17, 15) = var_x176;
        IJth(rJacobian, 11, 16) = var_x132;
        IJth(rJacobian, 12, 16) = var_x138;
        IJth(rJacobian, 14, 16) = var_x166;
        IJth(rJacobian, 16, 16) = var_x130 + var_x177 - var_x166;
        IJth(rJacobian, 17, 16) = var_x129;
        IJth(rJacobian, 12, 17) = var_x138;
        IJth(rJacobian, 14, 17) = var_x167;
        IJth(rJacobian, 15, 17) = var_x132;
        IJth(rJacobian, 16, 17) = 0.00050000000000000001;
        IJth(rJacobian, 17, 17) = -0.00050000000000000001 + var_x177 - var_x167;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (-3.3946082173859908e-7 * var_x48 - 9385.5048737823836 * var_x43 - 1.4564116150719218e-13 * var_x44 - 337.46387724285864 * var_x46 - 46927524.368911915 * var_x47);
        IJth(rJacobian, 1, 18) = 8.9596216554657907e-15 * var_x44 * var_x63;
        IJth(rJacobian, 18, 18) = -577.38191486798689 * var_x43 - 6.2649332746797061e-8 * var_x48 - 2886909.5743399346 * var_x47 - 2.6878864966397372e-14 * var_x44;
        IJth(rJacobian, 27, 18) = 4.1766221831198043e-8 * var_x48 - 20.760261942385391 * var_x46;
        IJth(rJacobian, 0, 19) = mSetVoltageDerivativeToZero ? 0.0 : (333.76617616580313 * var_x49 - 13.0 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 18, 19) = 20.532785023754869 * var_x49 - 0.79974013057636462 * var_chaste_interface__membrane__V;
        IJth(rJacobian, 19, 19) = -var_x204 - var_x205;
        IJth(rJacobian, 20, 19) = var_x205;
        IJth(rJacobian, 21, 19) = var_x231;
        IJth(rJacobian, 24, 19) = var_x204;
        IJth(rJacobian, 26, 19) = var_x220;
        IJth(rJacobian, 19, 20) = var_x206;
        IJth(rJacobian, 20, 20) = var_x219 + var_x220 - var_x206;
        IJth(rJacobian, 21, 20) = var_x218 + var_x231;
        IJth(rJacobian, 24, 20) = var_x189;
        IJth(rJacobian, 26, 20) = var_x220;
        IJth(rJacobian, 20, 21) = var_x221;
        IJth(rJacobian, 21, 21) = var_x233 + var_x234;
        IJth(rJacobian, 25, 21) = var_x189;
        IJth(rJacobian, 26, 21) = var_x220;
        IJth(rJacobian, 21, 22) = var_x231;
        IJth(rJacobian, 22, 22) = var_x239 - var_x240;
        IJth(rJacobian, 23, 22) = var_x240;
        IJth(rJacobian, 24, 22) = var_x222;
        IJth(rJacobian, 26, 22) = var_x220;
        IJth(rJacobian, 21, 23) = var_x231;
        IJth(rJacobian, 22, 23) = var_x241;
        IJth(rJacobian, 23, 23) = -var_x241;
        IJth(rJacobian, 26, 23) = var_x220;
        IJth(rJacobian, 19, 24) = var_x207;
        IJth(rJacobian, 20, 24) = var_x222;
        IJth(rJacobian, 21, 24) = var_x231;
        IJth(rJacobian, 22, 24) = var_x242;
        IJth(rJacobian, 24, 24) = var_x219 + var_x239 - var_x207 - var_x242;
        IJth(rJacobian, 25, 24) = var_x218;
        IJth(rJacobian, 26, 24) = var_x220;
        IJth(rJacobian, 21, 25) = var_x222 + var_x231;
        IJth(rJacobian, 24, 25) = var_x221;
        IJth(rJacobian, 25, 25) = var_x233 + var_x239;
        IJth(rJacobian, 26, 25) = var_x220 + var_x232;
        IJth(rJacobian, 21, 26) = var_x231;
        IJth(rJacobian, 25, 26) = var_x230;
        IJth(rJacobian, 26, 26) = var_x234 + var_x239;
        IJth(rJacobian, 0, 27) = mSetVoltageDerivativeToZero ? 0.0 : (0.65056346575383339 * var_x55 - 4.1078913989637309 * var_x52 - 1042.8338748647093 * var_x43 - 0.14762734715025908 * var_x50 - 7.2607529660026051 * var_x51 - 16535.729984900074 * var_x46 - 5214169.374323546 * var_x47 - 1.2837160621761659 * var_x53 - 10.441746449740933 * var_x54);
        IJth(rJacobian, 18, 27) = -64.153546096442994 * var_x43 - 320767.73048221495 * var_x47;
        IJth(rJacobian, 27, 27) = 0.040021670080783313 * var_x55 - 0.0090818087605069615 * var_x50 - 0.078972250091364882 * var_x53 - 0.642360282243162 * var_x54 - 0.25271120029236765 * var_x52 - 0.44667042500874232 * var_x51 - 1017.2528351768841 * var_x46;
        IJth(rJacobian, 0, 28) = mSetVoltageDerivativeToZero ? 0.0 : (-1.2201 * var_x56);
        IJth(rJacobian, 27, 28) = -0.075058687178170963 * var_x56;
        IJth(rJacobian, 28, 28) = -0.18064 * var_x250 - 0.39560000000000001 * var_x251;
        IJth(rJacobian, 0, 29) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x17 * var_x9);
        IJth(rJacobian, 27, 29) = -var_x17 * var_x247;
        IJth(rJacobian, 29, 29) = -0.00015200000000000001 * var_x261 - 0.00095 * var_x255;
        IJth(rJacobian, 30, 30) = var_x270;
        IJth(rJacobian, 31, 31) = -var_x274;
        IJth(rJacobian, 0, 32) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0115 * var_x57);
        IJth(rJacobian, 27, 32) = -0.00070746242320216869 * var_x57;
        IJth(rJacobian, 32, 32) = -9.5333299999999997e-5 * var_x282 - var_x281 * var_x283;
        IJth(rJacobian, 0, 33) = mSetVoltageDerivativeToZero ? 0.0 : (var_x58 * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur);
        IJth(rJacobian, 27, 33) = var_x248 * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
        IJth(rJacobian, 33, 33) = var_x270;
        IJth(rJacobian, 0, 34) = mSetVoltageDerivativeToZero ? 0.0 : (var_x58 * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur);
        IJth(rJacobian, 27, 34) = var_x248 * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur;
        IJth(rJacobian, 34, 34) = -var_x284;
        IJth(rJacobian, 0, 35) = mSetVoltageDerivativeToZero ? 0.0 : (var_x59 * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss);
        IJth(rJacobian, 27, 35) = var_x249 * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss;
        IJth(rJacobian, 35, 35) = -var_x286;
        IJth(rJacobian, 0, 36) = mSetVoltageDerivativeToZero ? 0.0 : (var_x59 * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss);
        IJth(rJacobian, 27, 36) = var_x249 * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss;
        IJth(rJacobian, 0, 37) = mSetVoltageDerivativeToZero ? 0.0 : (2.0025970569948188 * var_x60 - 0.078 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 27, 37) = 0.12319671014252923 * var_x60 - 0.0047984407834581883 * var_chaste_interface__membrane__V;
        IJth(rJacobian, 37, 37) = -var_x295 - var_x296;
        IJth(rJacobian, 38, 37) = var_x301;
        IJth(rJacobian, 39, 37) = var_x295;
        IJth(rJacobian, 40, 37) = var_x296;
        IJth(rJacobian, 38, 38) = -0.023761000000000001 + var_x301 - 0.047002000000000002 * var_x300;
        IJth(rJacobian, 39, 38) = 0.023761000000000001;
        IJth(rJacobian, 37, 39) = var_x297;
        IJth(rJacobian, 38, 39) = 0.036777999999999998 + var_x301;
        IJth(rJacobian, 39, 39) = -0.036777999999999998 - var_x297;
        IJth(rJacobian, 37, 40) = var_x298;
        IJth(rJacobian, 38, 40) = var_x301;
        IJth(rJacobian, 40, 40) = -var_x298;
    }

    N_Vector Cellbondarenko_model_2004_apexFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 1) = var_membrane__i_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "bondarenko_model_2004_apex";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-82.4202);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("calcium_concentration__Cai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("calcium_concentration__Cass");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("calcium_concentration__CaJSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("calcium_concentration__CaNSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("calcium_fluxes__P_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("calcium_buffering__LTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(11.2684);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("calcium_buffering__HTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(125.29);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("ryanodine_receptors__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.49102e-05);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("ryanodine_receptors__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.51726e-11);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("ryanodine_receptors__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016774);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("L_type_calcium_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.30308e-19);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("L_type_calcium_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000124216);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("L_type_calcium_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.78679e-09);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("L_type_calcium_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.19816e-13);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("L_type_calcium_current__I1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.97923e-19);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("L_type_calcium_current__I2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.45847e-14);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("L_type_calcium_current__I3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.85106e-14);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("sodium_concentration__Nai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(14237.1);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("fast_sodium_current__O_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.13483e-07);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("fast_sodium_current__C_Na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000279132);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("fast_sodium_current__C_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020752);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("fast_sodium_current__I1_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.73345e-07);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("fast_sodium_current__I2_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.55787e-09);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("fast_sodium_current__IF_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000153176);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("fast_sodium_current__IC_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113879);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("fast_sodium_current__IC_Na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.34278);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("potassium_concentration__Ki");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(143720.0);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ato_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00265563);

    // NV_Ith_S(rY, 29):
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ito_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999977);

    // NV_Ith_S(rY, 30):
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ato_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // NV_Ith_S(rY, 31):
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ito_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // NV_Ith_S(rY, 32):
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current__nKs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000262753);

    // NV_Ith_S(rY, 33):
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__aur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // NV_Ith_S(rY, 34):
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__iur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // NV_Ith_S(rY, 35):
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__aKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // NV_Ith_S(rY, 36):
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__iKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 37):
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__O_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175298);

    // NV_Ith_S(rY, 38):
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000992513);

    // NV_Ith_S(rY, 39):
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000641229);

    // NV_Ith_S(rY, 40):
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__I_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.19129e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0002;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellbondarenko_model_2004_apexFromCellMLCvode)
#endif // CHASTE_CVODE
