#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: aslanidi_model_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "aslanidi_model_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellaslanidi_model_2009FromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * NV_Ith_S(mParameters, 0); // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -1.9999999999999998e-5 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 0.20000000000000001; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 10.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellaslanidi_model_2009FromCellMLCvode::Cellaslanidi_model_2009FromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellaslanidi_model_2009FromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 5.0000000000000002e-5; // (var_membrane__Cm) [nanoF]
    }

    Cellaslanidi_model_2009FromCellMLCvode::~Cellaslanidi_model_2009FromCellMLCvode()
    {
    }
    
    double Cellaslanidi_model_2009FromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 5.0
        
        const double var_Ca_independent_transient_outward_K_current__g_to = 0.050001999999999998; // nanoS
        const double var_L_type_Ca_channel__E_Ca_app = 50.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.0040000000000000001; // nanoS
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 2.0000000000000002e-5; // picoA_per_millimolar_4
        const double var_T_type_Ca_channel__E_Ca_T = 38.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.0060000000000000001; // nanoS
        const double var_background_currents__g_B_Ca = 3.1000000000000001e-5; // nanoS
        const double var_background_currents__g_B_Na = 6.3999999999999997e-5; // nanoS
        const double var_cleft_space_ion_concentrations__Ca_c = 2.5; // millimolar
        const double var_cleft_space_ion_concentrations__Na_c = 140.0; // millimolar
        const double var_delayed_rectifier_K_current__g_Kr = 0.0035000000000000001; // nanoS
        const double var_delayed_rectifier_K_current__g_Ks = 0.0025000000000000001; // nanoS
        const double var_environment__CT = 1.0; // dimensionless
        const double var_environment__PM = 0; // dimensionless
        const double var_inward_rectifier__KmK1 = 0.58999999999999997; // millimolar
        const double var_inward_rectifier__g_K1 = 0.0050800000000000003; // nanoS
        const double var_inward_rectifier__shiftK1 = -3.6000000000000001; // millivolt
        const double var_inward_rectifier__steepK1 = 1.393; // dimensionless
        const double var_membrane__Cm_converted = 0.001 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 308.0; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (0.16799999999999998 + 0.0023999999999999998 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V))); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (0.20000000000000001 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (0.34999999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : ((0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r))); // picoA
        const double var_L_type_Ca_channel__d_prime = 1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (1.8 * (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (2.1000000000000001 * (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L) : ((-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_background_currents__E_Ca) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (3.0000000000000001e-5 * var_chaste_interface__membrane__V - 3.0000000000000001e-5 * var_background_currents__E_Ca) : ((-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_current__g_Kr * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_current__g_Ks * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (2.5 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))) : (pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 0.0095090000000000001; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (3.0000000000000001e-5 * var_chaste_interface__membrane__V - 3.0000000000000001e-5 * var_sodium_current__E_Na) : ((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na))); // picoA
        const double var_sodium_current__P_Na = 1.3999999999999999e-6; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 0.064409999999999995; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * (var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellaslanidi_model_2009FromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__intracellular_Ca_buffering__O_C = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.029108
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.014071
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.693565
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 5.0
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.465921
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.002262
        double var_chaste_interface__Ca_handling_by_the_SR__F3 = NV_Ith_S(rY, 28);
        // Units: dimensionless; Initial value: 0.612697

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Ca_handling_by_the_SR__I_up_max = 2.7999999999999998; // picoA
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double var_Ca_handling_by_the_SR__Vol_rel = 4.3999999999999997e-8; // nanolitre
        const double var_Ca_handling_by_the_SR__Vol_up = 3.9690000000000001e-7; // nanolitre
        const double var_Ca_handling_by_the_SR__alpha_rel = 200.0; // picoA_per_millimolar
        const double var_Ca_handling_by_the_SR__k_F3 = 0.81499999999999995; // per_second
        const double var_Ca_handling_by_the_SR__k_cyca = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_srca = 0.5; // millimolar
        const double var_Ca_handling_by_the_SR__k_xcs = 0.40000000000000002; // dimensionless
        const double var_Ca_handling_by_the_SR__tau_tr = 0.01; // second
        const double var_Ca_independent_transient_outward_K_current__g_to = 0.050001999999999998; // nanoS
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__E_Ca_app = 50.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.0040000000000000001; // nanoS
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 2.0000000000000002e-5; // picoA_per_millimolar_4
        const double var_T_type_Ca_channel__E_Ca_T = 38.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.0060000000000000001; // nanoS
        const double var_background_currents__g_B_Ca = 3.1000000000000001e-5; // nanoS
        const double var_background_currents__g_B_Na = 6.3999999999999997e-5; // nanoS
        const double var_cleft_space_ion_concentrations__Ca_c = 2.5; // millimolar
        const double var_cleft_space_ion_concentrations__Na_c = 140.0; // millimolar
        const double var_cleft_space_ion_concentrations__Vol_c = 2.5000000000000002e-6; // nanolitre
        const double var_delayed_rectifier_K_current__g_Kr = 0.0035000000000000001; // nanoS
        const double var_delayed_rectifier_K_current__g_Ks = 0.0025000000000000001; // nanoS
        const double var_environment__CT = 1.0; // dimensionless
        const double var_environment__PM = 0; // dimensionless
        const double var_intracellular_Ca_buffering__Mg_i = 2.5; // millimolar
        const double var_intracellular_Ca_buffering__O_TMgMg_orig_deriv = -666.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 2000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_intracellular_Ca_buffering__Mg_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 0.001 * var_intracellular_Ca_buffering__O_TMgMg_orig_deriv; // 1 / millisecond
        const double var_Ca_handling_by_the_SR__i_rel = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) * var_Ca_handling_by_the_SR__alpha_rel / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = (var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_Ca_handling_by_the_SR__k_cyca - pow(var_Ca_handling_by_the_SR__k_xcs, 2) * var_chaste_interface__Ca_handling_by_the_SR__Ca_up / var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__I_up_max / ((var_Ca_handling_by_the_SR__k_cyca + var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_Ca_handling_by_the_SR__k_cyca + (var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__k_xcs / var_Ca_handling_by_the_SR__k_srca); // picoA
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F3_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact - var_chaste_interface__Ca_handling_by_the_SR__F3 * var_Ca_handling_by_the_SR__k_F3; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3 = 0.001 * var_Ca_handling_by_the_SR__F3_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOCdt = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_intracellular_Ca_buffering__O_C_orig_deriv = var_intracellular_Ca_buffering__dOCdt; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__O_C_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOTCdt = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_intracellular_Ca_buffering__O_TC_orig_deriv = var_intracellular_Ca_buffering__dOTCdt; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__O_TC_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOTMgCdt = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_intracellular_Ca_buffering__O_TMgC_orig_deriv = var_intracellular_Ca_buffering__dOTMgCdt; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // 1 / millisecond
        const double var_intracellular_ion_concentrations__Vol_Ca = 5.8839999999999999e-6; // nanolitre
        const double var_intracellular_ion_concentrations__Vol_i = 1.26e-5; // nanolitre
        const double var_inward_rectifier__KmK1 = 0.58999999999999997; // millimolar
        const double var_inward_rectifier__g_K1 = 0.0050800000000000003; // nanoS
        const double var_inward_rectifier__shiftK1 = -3.6000000000000001; // millivolt
        const double var_inward_rectifier__steepK1 = 1.393; // dimensionless
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_Ca_handling_by_the_SR__i_tr = 2.0 * (-var_chaste_interface__Ca_handling_by_the_SR__Ca_rel + var_chaste_interface__Ca_handling_by_the_SR__Ca_up) * var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F / var_Ca_handling_by_the_SR__tau_tr; // picoA
        const double var_Ca_handling_by_the_SR__Ca_rel_orig_deriv = -31.0 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv + 0.5 * (-var_Ca_handling_by_the_SR__i_rel + var_Ca_handling_by_the_SR__i_tr) / (var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F); // millimolar / second
        const double var_Ca_handling_by_the_SR__Ca_up_orig_deriv = 0.5 * (-var_Ca_handling_by_the_SR__i_tr + var_Ca_handling_by_the_SR__i_up) / (var_Ca_handling_by_the_SR__Vol_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.001 * var_Ca_handling_by_the_SR__Ca_rel_orig_deriv; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.001 * var_Ca_handling_by_the_SR__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 308.0; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_handling_by_the_SR__r_act = 240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F1_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F3 * var_Ca_handling_by_the_SR__k_F3 - var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / second
        const double var_Ca_handling_by_the_SR__F2_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / second
        const double var_Ca_independent_transient_outward_K_current__i_sus = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (0.16799999999999998 + 0.0023999999999999998 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V))); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (0.20000000000000001 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (0.34999999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : ((0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_Ca_independent_transient_outward_K_current__g_to * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r))); // picoA
        const double var_Ca_independent_transient_outward_K_current_r_gate__alpha_r = 386.60000000000002 * exp(0.083333333333333329 * var_chaste_interface__membrane__V); // per_second
        const double var_Ca_independent_transient_outward_K_current_r_gate__beta_r = 8.0109999999999992 * exp(-0.1388888888888889 * var_chaste_interface__membrane__V); // per_second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-2.6628794603230959 - 0.17752529735487307 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.00040000000000000002 + 1 / (var_Ca_independent_transient_outward_K_current_r_gate__alpha_r + var_Ca_independent_transient_outward_K_current_r_gate__beta_r); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s1_gate__s1_infinity = 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s1_gate__tau_s1 = 0.020400000000000001 + 0.54659999999999997 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s1_gate__s1_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 + var_Ca_independent_transient_outward_K_current_s1_gate__s1_infinity) / var_Ca_independent_transient_outward_K_current_s1_gate__tau_s1; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s2_gate__s2_infinity = 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s2_gate__tau_s2 = 5.75 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)) + 0.45000000000000001 / (1.0 + exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s2_gate__s2_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 + var_Ca_independent_transient_outward_K_current_s2_gate__s2_infinity) / var_Ca_independent_transient_outward_K_current_s2_gate__tau_s2; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s3_gate__s3_infinity = 0.39975990396158467 + 0.60024009603841544 / (1.0 + exp(1.8506208911614319 + 0.036523009495982472 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s3_gate__tau_s3 = 0.5 + 7.5 / (1.0 + exp(46.0 + 2.0 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s3_gate__s3_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 + var_Ca_independent_transient_outward_K_current_s3_gate__s3_infinity) / var_Ca_independent_transient_outward_K_current_s3_gate__tau_s3; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.001 * var_Ca_handling_by_the_SR__F1_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_Ca_handling_by_the_SR__F2_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1 = 0.001 * var_Ca_independent_transient_outward_K_current_s1_gate__s1_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2 = 0.001 * var_Ca_independent_transient_outward_K_current_s2_gate__s2_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3 = 0.001 * var_Ca_independent_transient_outward_K_current_s3_gate__s3_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__d_prime = 1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (1.8 * (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (2.1000000000000001 * (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L) : ((-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * (var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel__d_prime) * var_L_type_Ca_channel__g_Ca_L))); // picoA
        const double var_L_type_Ca_channel_d_L_gate__E0_alpha_d_L = 45.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_L_gate__E0_beta_d_L = 5.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_L_gate__E10 = 10.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_L_gate__alpha_d_L = -50.0 * var_L_type_Ca_channel_d_L_gate__E10 / (-1.0 + exp(-0.20798668885191349 * var_L_type_Ca_channel_d_L_gate__E10)) - 16.719999999999999 * var_L_type_Ca_channel_d_L_gate__E0_alpha_d_L / (-1.0 + exp(-0.40000000000000002 * var_L_type_Ca_channel_d_L_gate__E0_alpha_d_L)); // per_second
        const double var_L_type_Ca_channel_d_L_gate__beta_d_L = 4.4800000000000004 * var_L_type_Ca_channel_d_L_gate__E0_beta_d_L / (-1.0 + exp(0.40000000000000002 * var_L_type_Ca_channel_d_L_gate__E0_beta_d_L)); // per_second
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-0.14393939393939395 - 0.15151515151515152 * var_L_type_Ca_channel_d_L_gate__E10)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 1 / (var_L_type_Ca_channel_d_L_gate__alpha_d_L + var_L_type_Ca_channel_d_L_gate__beta_d_L); // second
        const double var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + var_L_type_Ca_channel_d_L_gate__d_L_infinity) / var_L_type_Ca_channel_d_L_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_L_gate__E0_f_L = 18.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_f_L_gate__alpha_f_L = 8.4900000000000002 * var_L_type_Ca_channel_f_L_gate__E0_f_L / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double var_L_type_Ca_channel_f_L_gate__beta_f_L = 67.921999999999997 / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double var_L_type_Ca_channel_f_L_gate__f_L_infinity = var_L_type_Ca_channel_f_L_gate__alpha_f_L / (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L); // dimensionless
        const double var_L_type_Ca_channel_f_L_gate__tau_f_L = 1 / (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L); // second
        const double var_L_type_Ca_channel_f_L_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel_f_L_gate__f_L_infinity) / var_L_type_Ca_channel_f_L_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L = 0.001 * var_L_type_Ca_channel_f_L_gate__f_L_orig_deriv; // 1 / millisecond
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_T_type_Ca_channel_d_T_gate__E0_d_T = 23.300000000000001 + var_chaste_interface__membrane__V; // millivolt
        const double var_T_type_Ca_channel_d_T_gate__alpha_d_T = 674.173 * exp(0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T); // per_second
        const double var_T_type_Ca_channel_d_T_gate__beta_d_T = 674.173 * exp(-0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T); // per_second
        const double var_T_type_Ca_channel_d_T_gate__d_T_infinity = 1 / (1.0 + exp(0.049180327868852458 - 0.16393442622950821 * var_T_type_Ca_channel_d_T_gate__E0_d_T)); // dimensionless
        const double var_T_type_Ca_channel_d_T_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_T_gate__alpha_d_T + var_T_type_Ca_channel_d_T_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_T_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T + var_T_type_Ca_channel_d_T_gate__d_T_infinity) / var_T_type_Ca_channel_d_T_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T = 0.001 * var_T_type_Ca_channel_d_T_gate__d_T_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_T_gate__E0_f_T = 75.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_T_type_Ca_channel_f_T_gate__alpha_f_T = 9.6370000000000005 * exp(-0.012004801920768308 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double var_T_type_Ca_channel_f_T_gate__beta_f_T = 9.6370000000000005 * exp(0.065019505851755519 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double var_T_type_Ca_channel_f_T_gate__f_T_infinity = var_T_type_Ca_channel_f_T_gate__alpha_f_T / (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T); // dimensionless
        const double var_T_type_Ca_channel_f_T_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_T_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T + var_T_type_Ca_channel_f_T_gate__f_T_infinity) / var_T_type_Ca_channel_f_T_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T = 0.001 * var_T_type_Ca_channel_f_T_gate__f_T_orig_deriv; // 1 / millisecond
        const double var_background_currents__i_B_Ca = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_background_currents__E_Ca) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (3.0000000000000001e-5 * var_chaste_interface__membrane__V - 3.0000000000000001e-5 * var_background_currents__E_Ca) : ((-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_current__g_Kr * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_current__g_Ks * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_delayed_rectifier_K_current_pa_gate__alpha_p_a = 9.0 * exp(0.03941508020968823 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_pa_gate__beta_p_a = 1.3 * exp(-0.076769537847382163 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_pa_gate__p_a_infinity = 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_current_pa_gate__tau_p_a = 1 / (var_delayed_rectifier_K_current_pa_gate__alpha_p_a + var_delayed_rectifier_K_current_pa_gate__beta_p_a); // second
        const double var_delayed_rectifier_K_current_pa_gate__p_a_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a + var_delayed_rectifier_K_current_pa_gate__p_a_infinity) / var_delayed_rectifier_K_current_pa_gate__tau_p_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a = 0.001 * var_delayed_rectifier_K_current_pa_gate__p_a_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_current_pi_gate__alpha_p_i = 100.0 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_pi_gate__beta_p_i = 656.0 * exp(0.009420009985210585 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_pi_gate__p_i_infinity = 1 / (1.0 + exp(2.539728728905752 + 0.05358970648917756 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_current_pi_gate__tau_p_i = 1 / (var_delayed_rectifier_K_current_pi_gate__alpha_p_i + var_delayed_rectifier_K_current_pi_gate__beta_p_i); // second
        const double var_delayed_rectifier_K_current_pi_gate__p_i_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i + var_delayed_rectifier_K_current_pi_gate__p_i_infinity) / var_delayed_rectifier_K_current_pi_gate__tau_p_i; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i = 0.001 * var_delayed_rectifier_K_current_pi_gate__p_i_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_current_z_gate__alpha_z = 1.6599999999999999 * exp(0.014398433450440593 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_z_gate__beta_z = 0.29999999999999999 * exp(-0.045816915605241454 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifier_K_current_z_gate__tau_z = 0.059999999999999998 + 1 / (var_delayed_rectifier_K_current_z_gate__alpha_z + var_delayed_rectifier_K_current_z_gate__beta_z); // second
        const double var_delayed_rectifier_K_current_z_gate__z_infinity = 1 / (1.0 + exp(0.065217391304347824 - 0.072463768115942032 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_current_z_gate__z_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_current_z_gate__z + var_delayed_rectifier_K_current_z_gate__z_infinity) / var_delayed_rectifier_K_current_z_gate__tau_z; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z = 0.001 * var_delayed_rectifier_K_current_z_gate__z_orig_deriv; // 1 / millisecond
        const double var_inward_rectifier__i_K1 = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (2.5 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))) : (pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp((-var_Ca_independent_transient_outward_K_current__E_K - var_inward_rectifier__shiftK1 + var_chaste_interface__membrane__V) * var_inward_rectifier__steepK1 * var_membrane__F / (var_membrane__R * var_membrane__T))) * pow((var_chaste_interface__cleft_space_ion_concentrations__K_c + var_inward_rectifier__KmK1), 3))))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 0.0095090000000000001; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = -0.044999999999999998 * var_intracellular_Ca_buffering__dOCdt - 0.080000000000000002 * var_intracellular_Ca_buffering__dOTCdt - 0.16 * var_intracellular_Ca_buffering__dOTMgCdt + 0.5 * (-var_Ca_handling_by_the_SR__i_up - var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_background_currents__i_B_Ca - var_sarcolemmal_calcium_pump_current__i_CaP + 2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_Ca_handling_by_the_SR__i_rel) / (var_intracellular_ion_concentrations__Vol_Ca * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (((var_environment__CT == 1.0) && (var_environment__PM == 0)) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (((var_environment__CT == 0) && (var_environment__PM == 1.0)) ? (3.0000000000000001e-5 * var_chaste_interface__membrane__V - 3.0000000000000001e-5 * var_sodium_current__E_Na) : ((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na))); // picoA
        const double var_sodium_current__P_Na = 1.3999999999999999e-6; // nanolitre_per_second
        const double var_sodium_current_h1_gate__alpha_h = 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h1_gate__beta_h = 1491.0 / (1.0 + 323.30000000000001 * exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h1_gate__h_infinity = var_sodium_current_h1_gate__alpha_h / (var_sodium_current_h1_gate__alpha_h + var_sodium_current_h1_gate__beta_h); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00014999999999999999 + 0.029999999999999999 / (1.0 + exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h1_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h1_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * var_sodium_current_h1_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h2_gate__tau_h2 = 0.00044999999999999999 + 0.12 / (1.0 + exp(30.0 + 0.5 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h2_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * var_sodium_current_h2_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__E0_m = 44.399999999999999 + var_chaste_interface__membrane__V; // millivolt
        const double var_sodium_current_m_gate__alpha_m = -460.0 * var_sodium_current_m_gate__E0_m / (-1.0 + exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m)); // per_second
        const double var_sodium_current_m_gate__beta_m = 18400.0 * exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m); // per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__sodium_current_m_gate__m) * var_sodium_current_m_gate__alpha_m - var_sodium_current_m_gate__beta_m * var_chaste_interface__sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK_max = 0.064409999999999995; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_cleft_space_ion_concentrations__K_c_orig_deriv = (-2.0 * var_sodium_potassium_pump__i_p + var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.001 * var_cleft_space_ion_concentrations__K_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_sus - var_Ca_independent_transient_outward_K_current__i_to - var_delayed_rectifier_K_current__i_Kr - var_delayed_rectifier_K_current__i_Ks - var_inward_rectifier__i_K1 + 2.0 * var_sodium_potassium_pump__i_p) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_p) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__Cm_converted = 0.001 * NV_Ith_S(mParameters, 0); // uF
            const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane__i_Stim = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
            const double var_membrane__V_orig_deriv = -1.0 * (var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_membrane__i_Stim + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / NV_Ith_S(mParameters, 0); // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        NV_Ith_S(rDY,26) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        NV_Ith_S(rDY,27) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
        NV_Ith_S(rDY,28) = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3;
    }

    void Cellaslanidi_model_2009FromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time_converted, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__intracellular_Ca_buffering__O_C = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.029108
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 0.014071
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.693565
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = NV_Ith_S(rY, 22);
        // Units: millimolar; Initial value: 5.0
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = NV_Ith_S(rY, 25);
        // Units: dimensionless; Initial value: 0.465921
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = NV_Ith_S(rY, 26);
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = NV_Ith_S(rY, 27);
        // Units: dimensionless; Initial value: 0.002262
        
        const double var_x0 = 0.083333333333333329 * var_chaste_interface__membrane__V;
        const double var_x1 = exp(1.9166666666666667 - var_x0);
        const double var_x2 = 1.0 + var_x1;
        const double var_x3 = 1 / var_x2;
        const double var_x4 = var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T;
        const double var_x5 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
        const double var_x6 = 1 / (1.0 + 0.00074999999999999991 * var_x5 + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
        const double var_x7 = exp(0.016955889611951675 * var_chaste_interface__membrane__V);
        const double var_x8 = var_x5 * var_x7;
        const double var_x9 = exp(-0.02072386508127427 * var_chaste_interface__membrane__V);
        const double var_x10 = var_x9 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x11 = var_x6 * (0.042389724029879193 * var_x8 + 56866.285783016596 * var_x10);
        const double var_x12 = var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
        const double var_x13 = var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L;
        const double var_x14 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6);
        const double var_x15 = 0.00400016 + 0.0060002399999999996 * var_x14;
        const double var_x16 = 0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3);
        const double var_x17 = var_x16 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        const double var_x18 = var_x15 * var_x17;
        const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3);
        const double var_x20 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
        const double var_x21 = log(var_x20 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
        const double var_x22 = exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * var_x21);
        const double var_x23 = 1.0 + var_x22;
        const double var_x24 = 1 / var_x23;
        const double var_x25 = 0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
        const double var_x26 = pow(var_x25, (-3));
        const double var_x27 = var_x24 * var_x26;
        const double var_x28 = var_x19 * var_x27;
        const double var_x29 = -0.36000000000000004 + 0.0072000000000000007 * var_chaste_interface__membrane__V;
        const double var_x30 = 0.083333333333333329 * var_x1 / pow(var_x2, 2);
        const double var_x31 = 0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1;
        const double var_x32 = 0.037679754693225945 * var_chaste_interface__membrane__V;
        const double var_x33 = exp(var_x32);
        const double var_x34 = -1.0 + var_x33;
        const double var_x35 = 1 / var_x34;
        const double var_x36 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
        const double var_x37 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
        const double var_x38 = exp(var_x32 - 1.0 * log(140.0 * var_x37));
        const double var_x39 = -1.0 + var_x38;
        const double var_x40 = var_x35 * var_x36 * var_x39;
        const double var_x41 = var_x31 * var_x40;
        const double var_x42 = 0.026849797106057973 * var_x36;
        const double var_x43 = var_x31 * var_x35 * var_chaste_interface__membrane__V;
        const double var_x44 = var_x38 * var_x43;
        const double var_x45 = -26.53945091048535 * var_x21 + var_chaste_interface__membrane__V;
        const double var_x46 = var_x22 * var_x26 * var_x45 / pow(var_x23, 2);
        const double var_x47 = var_x19 * var_x46;
        const double var_x48 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
        const double var_x49 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
        const double var_x50 = 1 / var_x49;
        const double var_x51 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
        const double var_x52 = 1 / (36.4828726939094 + var_x51);
        const double var_x53 = var_x51 * var_x52 * var_chaste_interface__cleft_space_ion_concentrations__K_c;
        const double var_x54 = var_x48 * var_x50 * var_x53 / pow((1 + 0.66666666666666663 * var_x48), 2);
        const double var_x55 = var_x31 * var_x33 * var_x39 * var_chaste_interface__membrane__V / pow(var_x34, 2);
        const double var_x56 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x57 = 0.001 * var_x56;
        const double var_x58 = var_x39 * var_x43 * pow(var_chaste_interface__sodium_current_m_gate__m, 2);
        const double var_x59 = var_x40 * var_chaste_interface__membrane__V;
        const double var_x60 = var_x56 * var_x59;
        const double var_x61 = 0.001 * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L;
        const double var_x62 = var_x29 * var_x56;
        const double var_x63 = 0.001 * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L;
        const double var_x64 = 0.001 * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T;
        const double var_x65 = var_x56 * (-0.22800000000000001 + 0.0060000000000000001 * var_chaste_interface__membrane__V);
        const double var_x66 = 0.001 * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T;
        const double var_x67 = var_x16 * var_x45;
        const double var_x68 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 2);
        const double var_x69 = var_x45 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
        const double var_x70 = var_x15 * var_x56 * var_x69;
        const double var_x71 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 2);
        const double var_x72 = var_x17 * var_x45 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 5);
        const double var_x73 = 0.001 * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
        const double var_x74 = var_x56 * (0.0035000000000000001 * var_chaste_interface__membrane__V - 0.092888078186698725 * var_x21);
        const double var_x75 = 0.001 * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a;
        const double var_x76 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2);
        const double var_x77 = var_x6 * var_x7 * var_x76;
        const double var_x78 = (2.5 * var_x8 - 2744000.0 * var_x10) / pow((0.0012147716229348883 + 9.1107871720116623e-7 * var_x5 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
        const double var_x79 = var_x76 * var_x78;
        const double var_x80 = 1 / (1.5 + var_x48);
        const double var_x81 = var_x50 * var_x80;
        const double var_x82 = var_x52 * var_x81;
        const double var_x83 = var_x82 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 0.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c;
        const double var_x84 = var_x81 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2.0) * var_chaste_interface__cleft_space_ion_concentrations__K_c / pow((1 + 0.027410122234342148 * var_x51), 2);
        const double var_x85 = var_x36 * var_x44;
        const double var_x86 = var_x37 * var_x85;
        const double var_x87 = 0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x88 = 1 / var_x87;
        const double var_x89 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x90 = var_chaste_interface__intracellular_ion_concentrations__Ca_i / pow(var_x87, 2);
        const double var_x91 = var_x6 * var_x9;
        const double var_x92 = 0.066348627276213379 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z;
        const double var_x93 = 0.092888078186698725 * var_x12;
        const double var_x94 = var_x20 * var_x28;
        const double var_x95 = 26.53945091048535 * var_x18;
        const double var_x96 = var_x20 * var_x47;
        const double var_x97 = 1 / var_chaste_interface__cleft_space_ion_concentrations__K_c;
        const double var_x98 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 2);
        const double var_x99 = var_x27 * var_x98;
        const double var_x100 = 0.03048 * var_x45;
        const double var_x101 = var_x51 * var_x82;
        const double var_x102 = var_x19 * var_x24 / pow(var_x25, 4);
        const double var_x103 = var_x46 * var_x98;
        const double var_x104 = var_x53 * var_x80 / pow(var_x49, 2);
        const double var_x105 = exp(-3.5035114021936398 - 0.078907914463820727 * var_chaste_interface__membrane__V);
        const double var_x106 = 1.0 - var_chaste_interface__sodium_current_m_gate__m;
        const double var_x107 = -1.0 + var_x105;
        const double var_x108 = 0.46000000000000002 / var_x107;
        const double var_x109 = 44.399999999999999 + var_chaste_interface__membrane__V;
        const double var_x110 = exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V);
        const double var_x111 = 1 / (1.0 + 323.30000000000001 * var_x110);
        const double var_x112 = exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V);
        const double var_x113 = 44.899999999999999 * var_x112;
        const double var_x114 = 1 / (var_x113 + 1491.0 * var_x111);
        const double var_x115 = 8.0610412926391373 * var_x112;
        const double var_x116 = -var_x114 * var_x115 + 2.019719479407183e-5 * var_x112 * (var_x115 - 0.35750508923240704 * var_x110 / pow((0.0030931023816888337 + var_x110), 2)) / pow((var_x111 + 0.030114017437961098 * var_x112), 2);
        const double var_x117 = exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V);
        const double var_x118 = 1.0 + var_x117;
        const double var_x119 = 1 / var_x118;
        const double var_x120 = 0.001 / (0.00014999999999999999 + 0.029999999999999999 * var_x119);
        const double var_x121 = var_x113 * var_x114;
        const double var_x122 = exp(30.0 + 0.5 * var_chaste_interface__membrane__V);
        const double var_x123 = 1.0 + var_x122;
        const double var_x124 = 1 / var_x123;
        const double var_x125 = 0.001 / (0.00044999999999999999 + 0.12 * var_x124);
        const double var_x126 = exp(-1.6590909090909092 - 0.15151515151515152 * var_chaste_interface__membrane__V);
        const double var_x127 = 1.0 + var_x126;
        const double var_x128 = 0.40000000000000002 * var_chaste_interface__membrane__V;
        const double var_x129 = exp(2.0 + var_x128);
        const double var_x130 = -1.0 + var_x129;
        const double var_x131 = 1 / var_x130;
        const double var_x132 = 4.4800000000000004 * var_x131;
        const double var_x133 = exp(-2.0798668885191347 - 0.20798668885191349 * var_chaste_interface__membrane__V);
        const double var_x134 = -1.0 + var_x133;
        const double var_x135 = 1 / var_x134;
        const double var_x136 = 50.0 * var_x135;
        const double var_x137 = exp(-18.0 - var_x128);
        const double var_x138 = -1.0 + var_x137;
        const double var_x139 = 1 / var_x138;
        const double var_x140 = 16.719999999999999 * var_x139;
        const double var_x141 = 10.0 + var_chaste_interface__membrane__V;
        const double var_x142 = 45.0 + var_chaste_interface__membrane__V;
        const double var_x143 = 5.0 + var_chaste_interface__membrane__V;
        const double var_x144 = 0.25 * var_chaste_interface__membrane__V;
        const double var_x145 = exp(-4.5 - var_x144);
        const double var_x146 = 1.0 + var_x145;
        const double var_x147 = 1 / var_x146;
        const double var_x148 = 18.0 + var_chaste_interface__membrane__V;
        const double var_x149 = exp(4.5 + var_x144);
        const double var_x150 = -1.0 + var_x149;
        const double var_x151 = 1 / var_x150;
        const double var_x152 = 8.4900000000000002 * var_x151;
        const double var_x153 = 67.921999999999997 * var_x147 + var_x148 * var_x152;
        const double var_x154 = 1 / var_x153;
        const double var_x155 = 0.008490000000000001 * var_x151;
        const double var_x156 = var_x154 * var_x155;
        const double var_x157 = var_x148 * var_x151;
        const double var_x158 = 16.980499999999999 * var_x145 / pow(var_x146, 2);
        const double var_x159 = var_x148 * var_x149 / pow(var_x150, 2);
        const double var_x160 = 2.1225000000000001 * var_x159;
        const double var_x161 = exp(-3.7704918032786887 - 0.16393442622950821 * var_chaste_interface__membrane__V);
        const double var_x162 = 1.0 + var_x161;
        const double var_x163 = 0.033333333333333333 * var_chaste_interface__membrane__V;
        const double var_x164 = exp(0.77666666666666673 + var_x163);
        const double var_x165 = exp(-0.77666666666666673 - var_x163);
        const double var_x166 = exp(4.876462938881664 + 0.065019505851755519 * var_chaste_interface__membrane__V);
        const double var_x167 = exp(-0.9003601440576231 - 0.012004801920768308 * var_chaste_interface__membrane__V);
        const double var_x168 = 9.6370000000000005 * var_x166 + 9.6370000000000005 * var_x167;
        const double var_x169 = 1 / var_x168;
        const double var_x170 = 0.11569027611044419 * var_x167;
        const double var_x171 = 0.62659297789336799 * var_x166;
        const double var_x172 = 0.0096369999999999997 * var_x167;
        const double var_x173 = exp(-2.6628794603230959 - 0.17752529735487307 * var_chaste_interface__membrane__V);
        const double var_x174 = 1.0 + var_x173;
        const double var_x175 = exp(-0.1388888888888889 * var_chaste_interface__membrane__V);
        const double var_x176 = exp(var_x0);
        const double var_x177 = 0.00040000000000000002 + 1 / (8.0109999999999992 * var_x175 + 386.60000000000002 * var_x176);
        const double var_x178 = 1 / var_x177;
        const double var_x179 = exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V);
        const double var_x180 = 1.0 + var_x179;
        const double var_x181 = 1 / var_x180;
        const double var_x182 = 1 / (0.020400000000000001 + 0.54659999999999997 * var_x181);
        const double var_x183 = exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V);
        const double var_x184 = 1.0 + var_x183;
        const double var_x185 = 0.000141643059490085 * var_x183 / pow(var_x184, 2);
        const double var_x186 = 1 / var_x184;
        const double var_x187 = var_x179 / pow(var_x180, 2);
        const double var_x188 = exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V);
        const double var_x189 = 1.0 + var_x188;
        const double var_x190 = 1 / var_x189;
        const double var_x191 = 1 / (5.75 * var_x181 + 0.45000000000000001 * var_x190);
        const double var_x192 = exp(46.0 + 2.0 * var_chaste_interface__membrane__V);
        const double var_x193 = 1.0 + var_x192;
        const double var_x194 = 1 / var_x193;
        const double var_x195 = 1 / (0.5 + 7.5 * var_x194);
        const double var_x196 = exp(1.8506208911614319 + 0.036523009495982472 * var_chaste_interface__membrane__V);
        const double var_x197 = 1.0 + var_x196;
        const double var_x198 = exp(0.065217391304347824 - 0.072463768115942032 * var_chaste_interface__membrane__V);
        const double var_x199 = 1.0 + var_x198;
        const double var_x200 = exp(-0.045816915605241454 * var_chaste_interface__membrane__V);
        const double var_x201 = exp(0.014398433450440593 * var_chaste_interface__membrane__V);
        const double var_x202 = 0.059999999999999998 + 1 / (0.29999999999999999 * var_x200 + 1.6599999999999999 * var_x201);
        const double var_x203 = 1 / var_x202;
        const double var_x204 = exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V);
        const double var_x205 = 1.0 + var_x204;
        const double var_x206 = exp(0.03941508020968823 * var_chaste_interface__membrane__V);
        const double var_x207 = exp(-0.076769537847382163 * var_chaste_interface__membrane__V);
        const double var_x208 = exp(0.009420009985210585 * var_chaste_interface__membrane__V);
        const double var_x209 = exp(-0.018299935950224173 * var_chaste_interface__membrane__V);
        const double var_x210 = exp(2.539728728905752 + 0.05358970648917756 * var_chaste_interface__membrane__V);
        const double var_x211 = 1.0 + var_x210;
        const double var_x212 = 0.00031705239460620043 - 6.3410478921240078e-6 * var_chaste_interface__membrane__V;
        const double var_x213 = 0.00020079984991726025 - 5.2842065767700066e-6 * var_chaste_interface__membrane__V;
        const double var_x214 = 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x215 = 1 / (1.3999999999999999 + var_x214 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up);
        const double var_x216 = (var_x214 - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / pow((0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
        const double var_x217 = 0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2;
        const double var_x218 = pow(var_x217, (-2));
        const double var_x219 = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2);
        const double var_x220 = var_x218 * var_x219;
        const double var_x221 = 0.17614021922566689 * var_x220;
        const double var_x222 = 32.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x223 = -var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel;
        const double var_x224 = 0.35228043845133378 * var_x223;
        const double var_x225 = var_x218 * var_chaste_interface__Ca_handling_by_the_SR__F2;
        const double var_x226 = var_x219 / pow(var_x217, 3);
        const double var_x227 = -3.290319067574035e-6 - 4.9354786013610522e-6 * var_x14;
        const double var_x228 = var_x17 * var_x227;
        const double var_x229 = var_x227 * var_x69;
        const double var_x230 = 1.77 * var_x68;
        const double var_x231 = 1.23 * var_x71;
        const double var_x232 = 7.6404797510100245e-5 * var_x21 - 2.8789140275661778e-6 * var_chaste_interface__membrane__V;
        const double var_x233 = 5.4574855364357316e-5 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z;
        const double var_x234 = 7.6404797510100245e-5 * var_x12;
        const double var_x235 = 26.53945091048535 * var_x228;
        const double var_x236 = 2.5071228445776315e-5 * var_x45;
        const double var_x237 = -200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x238 = 1.6583208100573134e-5 + 2.4874812150859699e-5 * var_x14;
        const double var_x239 = var_x17 * var_x238;
        const double var_x240 = var_x238 * var_x69;
        const double var_x241 = 1.4509726698933535e-5 * var_chaste_interface__membrane__V - 0.00038508017945090519 * var_x21;
        const double var_x242 = 0.00027505727103636083 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z;
        const double var_x243 = 0.00038508017945090519 * var_x12;
        const double var_x244 = 26.53945091048535 * var_x239;
        const double var_x245 = 0.00012635899136671262 * var_x45;
        const double var_x246 = 23.554751134632365 * var_x220;
        const double var_x247 = 47.109502269264731 * var_x223;
        const double var_x248 = exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V);
        const double var_x249 = 0.019200000000000002 * var_x248 * var_chaste_interface__Ca_handling_by_the_SR__F1;
        const double var_x250 = 0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x251 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4);
        const double var_x252 = var_x251 / pow(var_x250, 5);
        const double var_x253 = 0.81520000000000004 * var_x252;
        const double var_x254 = pow(var_x250, (-4));
        const double var_x255 = var_x254 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 3);
        const double var_x256 = 0.81520000000000004 * var_x255;
        const double var_x257 = 0.23999999999999999 * var_x248;
        const double var_x258 = var_x251 * var_x254;
        const double var_x259 = 0.20380000000000001 * var_x258;
        const double var_x260 = 1.3584000000000001 * var_x252;
        const double var_x261 = 1.3584000000000001 * var_x255;
        const double var_x262 = 0.33960000000000001 * var_x258;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.0014400000000000001 + var_x18 + 0.0060000000000000001 * var_x4 + 0.0025000000000000001 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 0.010160000000000001 * var_x28 + 2.0000000000000002e-5 * var_x11 + 0.0035000000000000001 * var_x12 + 0.0011450666666666667 * var_x54 + 0.71257887225271721 * var_x41 + 0.0072000000000000007 * var_x13 + 0.0072000000000000007 * var_x3 - 0.00053327704660266365 * var_x47 + var_x29 * var_x30 + var_x42 * var_x44 - var_x42 * var_x55));
        IJth(rJacobian, 1, 0) = -var_x106 * var_x108 + 1.4519056261343013 * var_x105 * var_chaste_interface__sodium_current_m_gate__m - 0.036297640653357534 * var_x105 * var_x106 * var_x109 / pow(var_x107, 2);
        IJth(rJacobian, 2, 0) = var_x116 * var_x120 + 0.0055555555555555558 * var_x117 * (var_x121 - var_chaste_interface__sodium_current_h1_gate__h1) / (pow(var_x118, 2) * pow((0.0050000000000000001 + var_x119), 2));
        IJth(rJacobian, 3, 0) = var_x116 * var_x125 + 0.0041666666666666666 * var_x122 * (var_x121 - var_chaste_interface__sodium_current_h2_gate__h2) / (pow(var_x123, 2) * pow((0.0037499999999999999 + var_x124), 2));
        IJth(rJacobian, 4, 0) = (-var_x63 + 0.001 / var_x127) * (var_x132 - var_x136 - var_x140 - 10.399334442595674 * var_x133 * var_x141 / pow(var_x134, 2) - 6.6879999999999997 * var_x137 * var_x142 / pow(var_x138, 2) - 1.7920000000000003 * var_x129 * var_x143 / pow(var_x130, 2)) + 0.00015151515151515152 * var_x126 * (var_x132 * var_x143 - var_x136 * var_x141 - var_x140 * var_x142) / pow(var_x127, 2);
        IJth(rJacobian, 5, 0) = var_x153 * (var_x156 - 0.0021225000000000003 * var_x154 * var_x159 + 1.8402920895651027e-6 * var_x157 * (var_x160 - var_x152 - var_x158) / pow((var_x147 + 0.1249963193074409 * var_x157), 2)) + (-var_x61 + var_x148 * var_x156) * (var_x152 + var_x158 - var_x160);
        IJth(rJacobian, 6, 0) = (-var_x66 + 0.001 / var_x162) * (22.472433333333335 * var_x164 - 22.472433333333335 * var_x165) + 0.0001639344262295082 * var_x161 * (674.173 * var_x164 + 674.173 * var_x165) / pow(var_x162, 2);
        IJth(rJacobian, 7, 0) = var_x168 * (-0.00011569027611044419 * var_x167 * var_x169 + 0.00010376673238559718 * var_x167 * (var_x170 - var_x171) / pow((var_x166 + var_x167), 2)) + (var_x171 - var_x170) * (-var_x64 + var_x169 * var_x172);
        IJth(rJacobian, 8, 0) = 0.00017752529735487306 * var_x173 * var_x178 / pow(var_x174, 2) - 6.6907730760079843e-9 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + 1 / var_x174) * (1.1126388888888887 * var_x175 - 32.216666666666669 * var_x176) / (pow(var_x177, 2) * pow((var_x176 + 0.020721676151060523 * var_x175), 2));
        IJth(rJacobian, 9, 0) = -var_x182 * var_x185 + 0.018294914013904134 * var_x187 * (var_x186 - var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1) / pow((0.037321624588364438 + var_x181), 2);
        IJth(rJacobian, 10, 0) = -var_x185 * var_x191 + 3.0245746691871456e-5 * (var_x186 - var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2) * (57.5 * var_x187 - 0.032211882605583393 * var_x188 / pow(var_x189, 2)) / pow((var_x181 + 0.078260869565217397 * var_x190), 2);
        IJth(rJacobian, 11, 0) = -2.1922574727480476e-5 * var_x195 * var_x196 / pow(var_x197, 2) + 0.00026666666666666668 * var_x192 * (0.39975990396158467 - var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 + 0.60024009603841544 / var_x197) / (pow(var_x193, 2) * pow((0.066666666666666666 + var_x194), 2));
        IJth(rJacobian, 12, 0) = 7.2463768115942027e-5 * var_x198 * var_x203 / pow(var_x199, 2) - 0.00036289737262302222 * (-var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 1 / var_x199) * (0.013745074681572435 * var_x200 - 0.023901399527731383 * var_x201) / (pow(var_x202, 2) * pow((var_x201 + 0.18072289156626506 * var_x200), 2));
        IJth(rJacobian, 13, 0) = (-var_x75 + 0.001 / var_x205) * (0.35473572188719404 * var_x206 - 0.099800399201596807 * var_x207) + 0.00013513513513513514 * var_x204 * (9.0 * var_x206 + 1.3 * var_x207) / pow(var_x205, 2);
        IJth(rJacobian, 14, 0) = (-var_x73 + 0.001 / var_x211) * (6.1795265502981431 * var_x208 - 1.8299935950224173 * var_x209) - 5.3589706489177562e-5 * var_x210 * (100.0 * var_x209 + 656.0 * var_x208) / pow(var_x211, 2);
        IJth(rJacobian, 15, 0) = -1.6450937300378158e-8 - 2.2085216435981733e-5 * var_x85 - 4.9352811901134478e-8 * var_x11 - 0.00058612951745018135 * var_x41 - 2.8256129907129523e-6 * var_x54 + 2.2085216435981733e-5 * var_x36 * var_x55;
        IJth(rJacobian, 16, 0) = -1.7614021922566692e-8 + 3.5228043845133383e-8 * var_x11 - 5.2842065767700066e-6 * var_x4 - 6.3410478921240078e-6 * var_x13 - 6.3410478921240078e-6 * var_x3 + var_x212 * var_x30;
        IJth(rJacobian, 17, 0) = -1.151565611026471e-6 + var_x228 + 4.3864536286956306e-7 * var_x47 + 1.8837419938086349e-6 * var_x54 - 2.0563671625472697e-6 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z - 8.3570761485921043e-6 * var_x28 - 2.8789140275661778e-6 * var_x12;
        IJth(rJacobian, 22, 0) = 5.8038906795734136e-6 + var_x239 + 1.4509726698933535e-5 * var_x12 + 1.0364090499238238e-5 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 4.2119663788904201e-5 * var_x28 - 9.4940596487955185e-6 * var_x54 - 2.2107726288625975e-6 * var_x47;
        IJth(rJacobian, 26, 0) = -var_x249;
        IJth(rJacobian, 27, 0) = var_x249;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0021377366167581514 * var_x56 * var_x58);
        IJth(rJacobian, 1, 1) = -18.399999999999999 * var_x105 + var_x108 * var_x109;
        IJth(rJacobian, 15, 1) = -0.001758388552350544 * var_x58;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00045248758388047544 * var_x60);
        IJth(rJacobian, 2, 2) = -var_x120;
        IJth(rJacobian, 15, 2) = -0.0003721922435808652 * var_x59;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00026009128837224178 * var_x60);
        IJth(rJacobian, 3, 3) = -var_x125;
        IJth(rJacobian, 15, 3) = -0.0002139372738693162 * var_x59;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x61 * var_x62);
        IJth(rJacobian, 4, 4) = 0.016719999999999999 * var_x139 * var_x142 + 0.050000000000000003 * var_x135 * var_x141 - 0.0044800000000000005 * var_x131 * var_x143;
        IJth(rJacobian, 16, 4) = var_x212 * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x62 * var_x63);
        IJth(rJacobian, 5, 5) = -0.067921999999999996 * var_x147 - var_x148 * var_x155;
        IJth(rJacobian, 16, 5) = var_x212 * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x64 * var_x65);
        IJth(rJacobian, 6, 6) = -0.67417300000000002 * var_x164 - 0.67417300000000002 * var_x165;
        IJth(rJacobian, 16, 6) = var_x213 * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x65 * var_x66);
        IJth(rJacobian, 7, 7) = -var_x172 - 0.0096369999999999997 * var_x166;
        IJth(rJacobian, 16, 7) = var_x213 * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x15 * var_x57 * var_x67);
        IJth(rJacobian, 8, 8) = -0.001 * var_x178;
        IJth(rJacobian, 17, 8) = var_x227 * var_x67;
        IJth(rJacobian, 22, 8) = var_x238 * var_x67;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0017699999999999999 * var_x68 * var_x70);
        IJth(rJacobian, 9, 9) = -0.001 * var_x182;
        IJth(rJacobian, 17, 9) = var_x229 * var_x230;
        IJth(rJacobian, 22, 9) = var_x230 * var_x240;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00123 * var_x70 * var_x71);
        IJth(rJacobian, 10, 10) = -0.001 * var_x191;
        IJth(rJacobian, 17, 10) = var_x229 * var_x231;
        IJth(rJacobian, 22, 10) = var_x231 * var_x240;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (-3.600144e-5 * var_x56 * var_x72);
        IJth(rJacobian, 11, 11) = -0.001 * var_x195;
        IJth(rJacobian, 17, 11) = -2.9612871608166312e-5 * var_x72;
        IJth(rJacobian, 22, 11) = 0.00014924887290515819 * var_x72;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.0025000000000000001 * var_chaste_interface__membrane__V - 0.066348627276213379 * var_x21));
        IJth(rJacobian, 12, 12) = -0.001 * var_x203;
        IJth(rJacobian, 17, 12) = 5.4574855364357316e-5 * var_x21 - 2.0563671625472697e-6 * var_chaste_interface__membrane__V;
        IJth(rJacobian, 22, 12) = 1.0364090499238238e-5 * var_chaste_interface__membrane__V - 0.00027505727103636083 * var_x21;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x73 * var_x74);
        IJth(rJacobian, 13, 13) = -0.0089999999999999993 * var_x206 - 0.0012999999999999999 * var_x207;
        IJth(rJacobian, 17, 13) = var_x232 * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
        IJth(rJacobian, 22, 13) = var_x241 * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
        IJth(rJacobian, 0, 14) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x74 * var_x75);
        IJth(rJacobian, 14, 14) = -0.65600000000000003 * var_x208 - 0.10000000000000001 * var_x209;
        IJth(rJacobian, 17, 14) = var_x232 * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a;
        IJth(rJacobian, 22, 14) = var_x241 * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a;
        IJth(rJacobian, 0, 15) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.00015000000000000001 * var_x77 + 0.00053078901820970701 * var_x37 + 0.154584 * var_x83 + 0.71257887225271721 * var_x86 - 6.640515431495382e-14 * var_x79 - 0.0001161412471825695 * var_x84));
        IJth(rJacobian, 15, 15) = 2.8659485630822583e-7 * var_x84 + 1.638640545085862e-16 * var_x79 - 0.00038145775374624855 * var_x83 - 4.3659884291485854e-7 * var_x37 - 0.00058612951745018135 * var_x86 - 3.701460892585086e-7 * var_x77;
        IJth(rJacobian, 16, 15) = 2.6421032883850034e-7 * var_x77 - 1.1696618438750204e-16 * var_x79;
        IJth(rJacobian, 17, 15) = 0.00025430516916416572 * var_x83 - 1.9106323753881723e-7 * var_x84;
        IJth(rJacobian, 22, 15) = 9.6295871719563877e-7 * var_x84 - 0.0012816980525873951 * var_x83;
        IJth(rJacobian, 0, 16) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.0095090000000000001 * var_x88 + 0.0002653945091048535 * var_x89 - 0.0095090000000000001 * var_x90 - 2.4295432458697768e-8 * var_x78 - 54.880000000000003 * var_x91));
        IJth(rJacobian, 15, 16) = 5.9952395409541403e-11 * var_x78 + 0.13542411585671302 * var_x91;
        IJth(rJacobian, 16, 16) = -47.271999999999998 - var_x221 + 8.3745867230843319e-6 * var_x90 + 6.2720000000000002 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 9.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 7.3978892074780085e-7 * var_x216 - 8.3745867230843319e-6 * var_x88 - 0.096665752311045988 * var_x91 - 8.2198768971977874 * var_x215 - 4.2794027994574083e-11 * var_x78 - 2.3373323507508574e-7 * var_x89;
        IJth(rJacobian, 18, 16) = 200.0 - 200.0 * var_chaste_interface__intracellular_Ca_buffering__O_C;
        IJth(rJacobian, 19, 16) = 78.400000000000006 - 78.400000000000006 * var_chaste_interface__intracellular_Ca_buffering__O_TC;
        IJth(rJacobian, 20, 16) = 200.0 - 200.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC - 200.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg;
        IJth(rJacobian, 23, 16) = var_x246;
        IJth(rJacobian, 24, 16) = 121.85879481761599 * var_x215 - 1.0967291533585437e-5 * var_x216;
        IJth(rJacobian, 26, 16) = (var_x253 - var_x256) * var_chaste_interface__Ca_handling_by_the_SR__F1;
        IJth(rJacobian, 27, 16) = (var_x256 - var_x253) * var_chaste_interface__Ca_handling_by_the_SR__F1 + (var_x260 - var_x261) * var_chaste_interface__Ca_handling_by_the_SR__F2;
        IJth(rJacobian, 28, 16) = (var_x261 - var_x260) * var_chaste_interface__Ca_handling_by_the_SR__F2;
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.26964082125053118 * var_x94 - 0.014152880000000001 * var_x96 + var_x20 * var_x92 + var_x20 * var_x93 + var_x20 * var_x95));
        IJth(rJacobian, 17, 17) = 1.1641407074988802e-5 * var_x96 - 0.00022179221220074814 * var_x94 + var_x20 * var_x235 - var_x20 * var_x233 - var_x20 * var_x234;
        IJth(rJacobian, 22, 17) = 0.0011178327494917705 * var_x94 - 5.8672691657943555e-5 * var_x96 + var_x20 * var_x242 + var_x20 * var_x243 + var_x20 * var_x244;
        IJth(rJacobian, 16, 18) = 0.021419999999999998 + 9.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        IJth(rJacobian, 18, 18) = -0.47599999999999998 + var_x237;
        IJth(rJacobian, 16, 19) = 0.031359999999999999 + 6.2720000000000002 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        IJth(rJacobian, 19, 19) = -0.39200000000000002 - 78.400000000000006 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        IJth(rJacobian, 16, 20) = 0.0010559999999999999 + var_x222;
        IJth(rJacobian, 20, 20) = -0.0066 + var_x237;
        IJth(rJacobian, 21, 20) = -5.0;
        IJth(rJacobian, 16, 21) = var_x222;
        IJth(rJacobian, 20, 21) = var_x237;
        IJth(rJacobian, 21, 21) = -5.6660000000000004;
        IJth(rJacobian, 0, 22) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x57 * (0.10305599999999999 * var_x101 + 0.014152880000000001 * var_x103 - 0.26964082125053118 * var_x99 - 0.10305599999999999 * var_x104 + var_x100 * var_x99 - var_x100 * var_x102 - var_x92 * var_x97 - var_x93 * var_x97 - var_x95 * var_x97));
        IJth(rJacobian, 15, 22) = 0.00025430516916416572 * var_x104 - 0.00025430516916416572 * var_x101;
        IJth(rJacobian, 17, 22) = 0.00016953677944277714 * var_x101 + 0.00022179221220074814 * var_x99 - 1.1641407074988802e-5 * var_x103 - 0.00016953677944277714 * var_x104 + var_x102 * var_x236 + var_x233 * var_x97 + var_x234 * var_x97 - var_x235 * var_x97 - var_x236 * var_x99;
        IJth(rJacobian, 22, 22) = 0.00085446536839159674 * var_x104 + 5.8672691657943555e-5 * var_x103 - 0.0011178327494917705 * var_x99 - 0.00085446536839159674 * var_x101 + var_x245 * var_x99 - var_x102 * var_x245 - var_x242 * var_x97 - var_x243 * var_x97 - var_x244 * var_x97;
        IJth(rJacobian, 16, 23) = var_x221;
        IJth(rJacobian, 23, 23) = -14.98 - var_x246 + 14.880000000000001 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse;
        IJth(rJacobian, 24, 23) = 0.011085915847820609;
        IJth(rJacobian, 25, 23) = 0.47999999999999998 - 0.47999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse;
        IJth(rJacobian, 16, 24) = 1.7754934097947219e-10 * var_x216 + 0.00078910818213098765 * var_x215;
        IJth(rJacobian, 23, 24) = 0.099999999999999992;
        IJth(rJacobian, 24, 24) = -0.011085915847820609 - 2.6321499680605046e-9 * var_x216 - 0.011698444302491135 * var_x215;
        IJth(rJacobian, 23, 25) = 12.4 + 14.880000000000001 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel;
        IJth(rJacobian, 25, 25) = -0.40000000000000002 - 0.47999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel;
        IJth(rJacobian, 26, 26) = -var_x257 - var_x259;
        IJth(rJacobian, 27, 26) = var_x257 + var_x259;
        IJth(rJacobian, 16, 27) = var_x224 * var_x225 - var_x224 * var_x226;
        IJth(rJacobian, 23, 27) = var_x226 * var_x247 - var_x225 * var_x247;
        IJth(rJacobian, 27, 27) = -0.033960000000000004 - var_x262;
        IJth(rJacobian, 28, 27) = 0.033960000000000004 + var_x262;
        IJth(rJacobian, 26, 28) = 0.00081499999999999997;
        IJth(rJacobian, 28, 28) = -0.00081499999999999997;
    }

    N_Vector Cellaslanidi_model_2009FromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * NV_Ith_S(mParameters, 0); // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(3);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        NV_Ith_S(dqs, 1) = var_membrane__Cm_converted;
        NV_Ith_S(dqs, 2) = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellaslanidi_model_2009FromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "aslanidi_model_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.0);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01309);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.706);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.61493);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3e-05);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("L_type_Ca_channel_f_L_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99981);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("T_type_Ca_channel_d_T_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00046);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("T_type_Ca_channel_f_T_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.30752);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6e-05);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s1_gate__s1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5753);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s2_gate__s2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.39871);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s3_gate__s3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.57363);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("delayed_rectifier_K_current_z_gate__z");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02032);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("delayed_rectifier_K_current_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("delayed_rectifier_K_current_pi_gate__p_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.76898);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.4);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.1e-05);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(100.0);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.029108);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.014071);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.214036);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.693565);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.0);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.726776);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.730866);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.465921);

    // NV_Ith_S(rY, 26):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.288039);

    // NV_Ith_S(rY, 27):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002262);

    // NV_Ith_S(rY, 28):
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.612697);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellaslanidi_model_2009FromCellMLCvode)
#endif // CHASTE_CVODE
