#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: iribe_model_2006
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "iribe_model_2006_without_otherwise_section.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane_potential__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_chaste_interface__membrane_potential__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane_potential__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane_potential__stim_start_converted = 0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane_potential__stim_amplitude_converted),
                var_chaste_interface__membrane_potential__stim_duration_converted,
                var_chaste_interface__membrane_potential__stim_period_converted,
                var_chaste_interface__membrane_potential__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                23,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        NV_Ith_S(this->mParameters, 0) = 0.25; // (var_L_type_Ca_channel__P_Ca_L_Ca) [nanoA_per_millimolar]
        NV_Ith_S(this->mParameters, 1) = 9.5000000000000005e-5; // (var_cell_parameters__Cm) [microF]
        NV_Ith_S(this->mParameters, 2) = 1.0; // (var_time_dependent_rectifier_potassium_current__i_Kmax) [nanoA]
        NV_Ith_S(this->mParameters, 3) = 2.5; // (var_fast_sodium_current__g_Na) [microS]
        NV_Ith_S(this->mParameters, 4) = 0; // (var_fast_sodium_current__perc_reduced_inact_for_IpNa) [dimensionless]
        NV_Ith_S(this->mParameters, 5) = 0; // (var_fast_sodium_current__shift_INa_inact) [millivolt]
        NV_Ith_S(this->mParameters, 6) = 0.00050000000000000001; // (var_sodium_calcium_exchanger__i_NaCa_max) [nanoA_per_millimolar4]
    }

    Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::~Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode()
    {
    }
    
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 138.22
        
        const double var_calcium_background_current__g_b_Ca = 0.00025000000000000001; // microS
        const double var_cell_parameters__Ca_o = 2.0; // millimolar
        const double var_cell_parameters__F = 96485.341499999995; // coulomb_per_mole
        const double var_cell_parameters__K_o = 4.0; // millimolar
        const double var_cell_parameters__Na_o = 140.0; // millimolar
        const double var_cell_parameters__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_cell_parameters__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 4.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Ca_o * exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 0.002 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__K_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.01 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Na_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_L_type_Ca_channel__i_Ca_L / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_potassium_background_current__g_b_K = 0.00059999999999999995; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_cell_parameters__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane_potential__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_cell_parameters__F; // millivolt
        const double var_potassium_background_current__i_b_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_reversal_potentials__E_Na = var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_cell_parameters__F; // millivolt
        const double var_reversal_potentials__E_mh = var_cell_parameters__R * var_cell_parameters__T * log((var_cell_parameters__Na_o + 0.12 * var_cell_parameters__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_cell_parameters__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane_potential__V) * NV_Ith_S(mParameters, 3) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_fast_sodium_current__i_Na_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_fast_sodium_current__i_Na / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_sodium_background_current__g_b_Na = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane_potential__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * var_cell_parameters__Ca_o * exp(var_cell_parameters__F * var_chaste_interface__membrane_potential__V * var_sodium_calcium_exchanger__gamma / (var_cell_parameters__R * var_cell_parameters__T)) - pow(var_cell_parameters__Na_o, 3) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 6) / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_calcium_exchanger__i_NaCa / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 21.699999999999999; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 1.3600000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_cell_parameters__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_cell_parameters__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + 0.1245 * exp(-0.10000000000000001 * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)))); // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-var_cell_parameters__K_o * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * NV_Ith_S(mParameters, 2) * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_time_dependent_rectifier_potassium_current__i_K / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 1.0; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_cell_parameters__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * (var_cell_parameters__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        const double var_chaste_interface__i_ionic = ((var_L_type_Ca_channel__i_Ca_L_converted + var_fast_sodium_current__i_Na_converted + var_sodium_calcium_exchanger__i_NaCa_converted + var_time_dependent_rectifier_potassium_current__i_K_converted) * NV_Ith_S(mParameters, 1) + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_calcium_background_current__i_b_Ca + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_potassium_background_current__i_b_K + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_background_current__i_b_Na + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_potassium_pump__i_NaK + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_time_independent_potassium_current__i_K1 + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_transient_outward_current__i_to) / NV_Ith_S(mParameters, 1); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__CaMKII_factor__F_CaMK = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__RyR__F_SRCa_RyR = NV_Ith_S(rY, 10);
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__RyR__F_1 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.5268
        double var_chaste_interface__RyR__F_2 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__calmodulin__Cmdn_Ca = NV_Ith_S(rY, 13);
        // Units: millimolar; Initial value: 3.9636e-06
        double var_chaste_interface__troponin__Trpn_Ca = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.24886
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 138.22
        double var_chaste_interface__Force__N_0 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.00015349

        // Mathematics
        double d_dt_chaste_interface_var_membrane_potential__V;
        const double var_CaMKII_factor__Tau_CaMK = 0.80000000000000004; // second
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double var_Force__SL = 2.1499999999999999; // micrometre
        const double var_Force__SL_norm = -2.4285714285714288 + 1.4285714285714286 * var_Force__SL; // dimensionless
        const double var_Force__N_tm = 3.5 + 2.5 * var_Force__SL_norm; // dimensionless
        const double var_Force__beta_tm = 40.0; // per_second
        const double var_Force__f_XB = 10.0; // per_second
        const double var_Force__f_01 = 3.0 * var_Force__f_XB; // per_second
        const double var_Force__f_12 = 10.0 * var_Force__f_XB; // per_second
        const double var_Force__f_23 = 7.0 * var_Force__f_XB; // per_second
        const double var_Force__g_XB = 30.0; // per_second
        const double var_Force__g_01 = (2.0 - var_Force__SL_norm) * var_Force__g_XB; // per_second
        const double var_Force__g_12 = 2.0 * (2.0 - var_Force__SL_norm) * var_Force__g_XB; // per_second
        const double var_Force__g_23 = 3.0 * (2.0 - var_Force__SL_norm) * var_Force__g_XB; // per_second
        const double var_Force__P_2_orig_deriv = (-var_Force__f_23 - var_Force__g_12) * var_chaste_interface__Force__P_2 + var_chaste_interface__Force__P_1 * var_Force__f_12 + var_chaste_interface__Force__P_3 * var_Force__g_23; // 1 / second
        const double d_dt_chaste_interface_var_Force__P_2 = 0.001 * var_Force__P_2_orig_deriv; // 1 / millisecond
        const double var_Force__P_3_orig_deriv = var_chaste_interface__Force__P_2 * var_Force__f_23 - var_chaste_interface__Force__P_3 * var_Force__g_23; // 1 / second
        const double d_dt_chaste_interface_var_Force__P_3 = 0.001 * var_Force__P_3_orig_deriv; // 1 / millisecond
        const double var_Force__phi_SL = (((var_Force__SL >= 1.7) && (var_Force__SL <= 2.0)) ? (-0.4285714285714286 + 0.7142857142857143 * var_Force__SL) : (((var_Force__SL <= 2.2000000000000002) && (var_Force__SL > 2.0)) ? (1.0) : (((var_Force__SL <= 2.2999999999999998) && (var_Force__SL > 2.2000000000000002)) ? (2.5714285714285716 - 0.7142857142857143 * var_Force__SL) : (NAN)))); // dimensionless
        const double var_Force__sigma_paths = 6.0 * pow(var_Force__g_XB, 3) + 6.0 * pow(var_Force__g_XB, 2) * var_Force__f_01 + var_Force__f_01 * var_Force__f_12 * var_Force__f_23 + 3.0 * var_Force__f_01 * var_Force__f_12 * var_Force__g_XB; // dimensionless
        const double var_Force__P_1_max = 6.0 * pow(var_Force__g_XB, 2) * var_Force__f_01 / var_Force__sigma_paths; // dimensionless
        const double var_Force__P_2_max = 3.0 * var_Force__f_01 * var_Force__f_12 * var_Force__g_XB / var_Force__sigma_paths; // dimensionless
        const double var_Force__P_3_max = var_Force__f_01 * var_Force__f_12 * var_Force__f_23 / var_Force__sigma_paths; // dimensionless
        const double var_Force__Force_max = 2.0 * var_Force__P_2_max + 3.0 * var_Force__P_3_max + var_Force__P_1_max; // dimensionless
        const double var_Force__Force_norm = (2.0 * var_chaste_interface__Force__P_2 + 3.0 * var_chaste_interface__Force__P_3 + var_Force__N_1 + var_chaste_interface__Force__P_1) * var_Force__phi_SL / var_Force__Force_max; // dimensionless
        const double var_L_type_Ca_channel_d_gate__speed_d = 3.0; // dimensionless
        const double var_L_type_Ca_channel_f_gate__speed_f = 0.5; // dimensionless
        const double var_RyR__F_3 = 1.0 - var_chaste_interface__RyR__F_1 - var_chaste_interface__RyR__F_2; // dimensionless
        const double var_RyR__F_rel = pow(var_chaste_interface__RyR__F_2, 2) / pow((0.25 + var_chaste_interface__RyR__F_2), 2); // dimensionless
        const double var_RyR__K_leak_rate = 0; // per_second
        const double var_RyR__K_rel_max = 500.0; // per_second
        const double var_RyR__K_rel = var_chaste_interface__RyR__F_SRCa_RyR * var_RyR__K_rel_max / (0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR); // per_second
        const double var_RyR__N_CaMK = 2.0408163265306123 * pow(var_chaste_interface__CaMKII_factor__F_CaMK, 2); // dimensionless
        const double var_RyR__Tau_SRCa_RyR = 0.050000000000000003; // second
        const double var_RyR__gain_k1 = 1.0; // dimensionless
        const double var_RyR__gain_k2 = 1.0; // dimensionless
        const double var_RyR__gain_k3 = 1.0; // dimensionless
        const double var_RyR__gain_k4 = 1.0; // dimensionless
        const double var_RyR__k_3 = 1.885 * pow((4.5454545454545459 * var_chaste_interface__RyR__F_SRCa_RyR), var_RyR__N_CaMK) * var_RyR__gain_k3; // per_second
        const double var_RyR__k_4 = 1.8 * var_RyR__gain_k4; // per_second
        const double var_SERCA__V_max_f = 0.29199999999999998; // millimolar_per_second
        const double var_SERCA__V_max_r = 0.39100000000000001; // millimolar_per_second
        const double var_RyR__F_SRCa_RyR_orig_deriv = (-var_chaste_interface__RyR__F_SRCa_RyR + var_chaste_interface__SR_calcium_concentration__Ca_SR) / var_RyR__Tau_SRCa_RyR; // millimolar / second
        const double d_dt_chaste_interface_var_RyR__F_SRCa_RyR = 0.001 * var_RyR__F_SRCa_RyR_orig_deriv; // millimolar / millisecond
        const double var_RyR__k_2 = 450.0 * var_RyR__gain_k2 / (1.0 + 0.35999999999999999 / var_chaste_interface__SR_calcium_concentration__Ca_SR); // per_second
        const double var_SERCA__r_b = 0.37180249851279007 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2); // dimensionless
        const double var_calcium_background_current__g_b_Ca = 0.00025000000000000001; // microS
        const double var_CaMKII_factor__Inf_CaMK = 20000.0 * var_chaste_interface__calmodulin__Cmdn_Ca; // dimensionless
        const double var_CaMKII_factor__F_CaMK_orig_deriv = (-var_chaste_interface__CaMKII_factor__F_CaMK + var_CaMKII_factor__Inf_CaMK) / var_CaMKII_factor__Tau_CaMK; // 1 / second
        const double d_dt_chaste_interface_var_CaMKII_factor__F_CaMK = 0.001 * var_CaMKII_factor__F_CaMK_orig_deriv; // 1 / millisecond
        const double var_calmodulin__Cmdn_tot = 0.02; // millimolar
        const double var_calmodulin__alpha_cmdn = 10000.0; // per_millimolar_per_second
        const double var_calmodulin__beta_cmdn = 500.0; // per_second
        const double var_cell_parameters__Ca_o = 2.0; // millimolar
        const double var_cell_parameters__F = 96485.341499999995; // coulomb_per_mole
        const double var_cell_parameters__K_o = 4.0; // millimolar
        const double var_cell_parameters__Na_o = 140.0; // millimolar
        const double var_cell_parameters__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_cell_parameters__T = 310.0; // kelvin
        const double var_cell_parameters__v_SR = 3.3477000000000002e-6; // microlitre
        const double var_cell_parameters__v_i = 1.6404000000000001e-5; // microlitre
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_RyR__j_rel = (-var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_chaste_interface__SR_calcium_concentration__Ca_SR) * (var_RyR__F_rel * var_RyR__K_rel + var_RyR__K_leak_rate); // millimolar_per_second
        const double var_SERCA__f_b = 17361111.111111112 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2); // dimensionless
        const double var_SERCA__j_up = (-var_SERCA__V_max_r * var_SERCA__r_b + var_chaste_interface__CaMKII_factor__F_CaMK * var_SERCA__V_max_f * var_SERCA__f_b) / (1.0 + var_SERCA__f_b + var_SERCA__r_b); // millimolar_per_second
        const double var_SR_calcium_concentration__Ca_SR_orig_deriv = -var_RyR__j_rel + var_SERCA__j_up * var_cell_parameters__v_i / var_cell_parameters__v_SR; // millimolar / second
        const double d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR = 0.001 * var_SR_calcium_concentration__Ca_SR_orig_deriv; // millimolar / millisecond
        const double var_calmodulin__Cmdn_Ca_orig_deriv = -var_chaste_interface__calmodulin__Cmdn_Ca * var_calmodulin__beta_cmdn + (-var_chaste_interface__calmodulin__Cmdn_Ca + var_calmodulin__Cmdn_tot) * var_calmodulin__alpha_cmdn * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_calmodulin__Cmdn_Ca = 0.001 * var_calmodulin__Cmdn_Ca_orig_deriv; // millimolar / millisecond
        const double var_calmodulin__dCmdn_Ca_dtime = -var_chaste_interface__calmodulin__Cmdn_Ca * var_calmodulin__beta_cmdn + (-var_chaste_interface__calmodulin__Cmdn_Ca + var_calmodulin__Cmdn_tot) * var_calmodulin__alpha_cmdn * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar_per_second
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 4.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Ca_o * exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 0.002 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__K_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.01 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Na_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_L_type_Ca_channel_d_gate__E0_d = 19.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double var_L_type_Ca_channel_d_gate__alpha_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (120.0 * var_L_type_Ca_channel_d_gate__speed_d) : (30.0 * var_L_type_Ca_channel_d_gate__E0_d * var_L_type_Ca_channel_d_gate__speed_d / (1.0 - exp(-0.25 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (120.0 * var_L_type_Ca_channel_d_gate__speed_d) : (-12.0 * var_L_type_Ca_channel_d_gate__E0_d * var_L_type_Ca_channel_d_gate__speed_d / (1.0 - exp(0.10000000000000001 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__alpha_d - var_L_type_Ca_channel_d_gate__beta_d * var_chaste_interface__L_type_Ca_channel_d_gate__d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__E0_f = 34.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double var_L_type_Ca_channel_f_gate__alpha_f = ((fabs(var_L_type_Ca_channel_f_gate__E0_f) < 1.0000000000000001e-5) ? (25.0 * var_L_type_Ca_channel_f_gate__speed_f) : (6.25 * var_L_type_Ca_channel_f_gate__E0_f * var_L_type_Ca_channel_f_gate__speed_f / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_gate__E0_f)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f = 50.0 * var_L_type_Ca_channel_f_gate__speed_f / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_gate__E0_f)); // per_second
        const double var_L_type_Ca_channel_f_gate__f_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__alpha_f - var_L_type_Ca_channel_f_gate__beta_f * var_chaste_interface__L_type_Ca_channel_f_gate__f; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * var_L_type_Ca_channel_f_gate__f_orig_deriv; // 1 / millisecond
        const double var_RyR__k_1 = (30625000.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) - 245.0 * var_L_type_Ca_channel__i_Ca_L) * var_RyR__gain_k1; // per_second
        const double var_RyR__F_1_orig_deriv = var_RyR__F_3 * var_RyR__k_3 - var_chaste_interface__RyR__F_1 * var_RyR__k_1 - var_chaste_interface__RyR__F_1 * var_RyR__k_4; // 1 / second
        const double d_dt_chaste_interface_var_RyR__F_1 = 0.001 * var_RyR__F_1_orig_deriv; // 1 / millisecond
        const double var_RyR__F_2_orig_deriv = var_chaste_interface__RyR__F_1 * var_RyR__k_1 - var_chaste_interface__RyR__F_2 * var_RyR__k_2; // 1 / second
        const double d_dt_chaste_interface_var_RyR__F_2 = 0.001 * var_RyR__F_2_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * NV_Ith_S(mParameters, 5) - 0.125 * var_chaste_interface__membrane_potential__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * NV_Ith_S(mParameters, 5) - 0.10000000000000001 * var_chaste_interface__membrane_potential__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_inf = 0.01 * NV_Ith_S(mParameters, 4) + (1.0 - 0.01 * NV_Ith_S(mParameters, 4)) * var_fast_sodium_current_h_gate__alpha_h / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane_potential__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_potassium_background_current__g_b_K = 0.00059999999999999995; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_cell_parameters__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane_potential__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_cell_parameters__F; // millivolt
        const double var_potassium_background_current__i_b_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_reversal_potentials__E_Na = var_cell_parameters__R * var_cell_parameters__T * log(var_cell_parameters__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_cell_parameters__F; // millivolt
        const double var_reversal_potentials__E_mh = var_cell_parameters__R * var_cell_parameters__T * log((var_cell_parameters__Na_o + 0.12 * var_cell_parameters__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_cell_parameters__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane_potential__V) * NV_Ith_S(mParameters, 3) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__g_b_Na = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane_potential__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * var_cell_parameters__Ca_o * exp(var_cell_parameters__F * var_chaste_interface__membrane_potential__V * var_sodium_calcium_exchanger__gamma / (var_cell_parameters__R * var_cell_parameters__T)) - pow(var_cell_parameters__Na_o, 3) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 6) / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 21.699999999999999; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 1.3600000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_cell_parameters__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_cell_parameters__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + 0.1245 * exp(-0.10000000000000001 * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)))); // nanoA
        const double var_intracellular_sodium_concentration__Na_i_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L_Na - var_fast_sodium_current__i_Na - var_sodium_background_current__i_b_Na - 3.0 * var_sodium_calcium_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_cell_parameters__F * var_cell_parameters__v_i); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = 0.001 * var_intracellular_sodium_concentration__Na_i_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_rectifier_potassium_current_x_gate__alpha_x = 0.5 * exp(4.1300000000000008 + 0.082600000000000007 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(2.8500000000000001 + 0.057000000000000002 * var_chaste_interface__membrane_potential__V)); // per_second
        const double var_time_dependent_rectifier_potassium_current_x_gate__beta_x = 1.3 * exp(-1.2 - 0.059999999999999998 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.80000000000000004 - 0.040000000000000001 * var_chaste_interface__membrane_potential__V)); // per_second
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-var_cell_parameters__K_o * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * NV_Ith_S(mParameters, 2) * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_rectifier_potassium_current_x_gate__x_orig_deriv = (1.0 - var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x) * var_time_dependent_rectifier_potassium_current_x_gate__alpha_x - var_time_dependent_rectifier_potassium_current_x_gate__beta_x * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // 1 / second
        const double d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x = 0.001 * var_time_dependent_rectifier_potassium_current_x_gate__x_orig_deriv; // 1 / millisecond
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 1.0; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_cell_parameters__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * (var_cell_parameters__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current_r_gate__r_orig_deriv = 333.0 / (1.0 + exp(-0.80000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane_potential__V)) - 333.0 * var_chaste_interface__transient_outward_current_r_gate__r; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = 0.001 * var_transient_outward_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double var_transient_outward_current_s_gate__alpha_s = 0.033000000000000002 * exp(-0.058823529411764705 * var_chaste_interface__membrane_potential__V); // per_second
        const double var_transient_outward_current_s_gate__beta_s = 33.0 / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane_potential__V)); // per_second
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        const double var_intracellular_potassium_concentration__K_i_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L_K - var_potassium_background_current__i_b_K - var_time_dependent_rectifier_potassium_current__i_K - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_cell_parameters__F * var_cell_parameters__v_i); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.001 * var_intracellular_potassium_concentration__K_i_orig_deriv; // millimolar / millisecond
        const double var_transient_outward_current_s_gate__s_orig_deriv = (1.0 - var_chaste_interface__transient_outward_current_s_gate__s) * var_transient_outward_current_s_gate__alpha_s - var_transient_outward_current_s_gate__beta_s * var_chaste_interface__transient_outward_current_s_gate__s; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = 0.001 * var_transient_outward_current_s_gate__s_orig_deriv; // 1 / millisecond
        const double var_troponin__Trpn_tot = 0.070000000000000007; // millimolar
        const double var_troponin__alpha_trpn = 80000.0; // per_millimolar_per_second
        const double var_troponin__beta_trpn = 200.0; // per_second
        const double var_Force__K_tm = 1 / (1.0 + var_troponin__beta_trpn / ((0.0016999999999999999 - 0.00089999999999999998 * var_Force__SL_norm) * var_troponin__alpha_trpn)); // dimensionless
        const double var_Force__alpha_tm = pow((var_chaste_interface__troponin__Trpn_Ca / (var_Force__K_tm * var_troponin__Trpn_tot)), var_Force__N_tm) * var_Force__beta_tm; // per_second
        const double var_Force__N_0_orig_deriv = var_Force__N_1 * var_Force__g_01 + var_chaste_interface__Force__P_0 * var_Force__beta_tm - var_chaste_interface__Force__N_0 * var_Force__alpha_tm; // 1 / second
        const double d_dt_chaste_interface_var_Force__N_0 = 0.001 * var_Force__N_0_orig_deriv; // 1 / millisecond
        const double var_Force__P_0_orig_deriv = (-var_Force__beta_tm - var_Force__f_01) * var_chaste_interface__Force__P_0 + var_chaste_interface__Force__N_0 * var_Force__alpha_tm + var_chaste_interface__Force__P_1 * var_Force__g_01; // 1 / second
        const double d_dt_chaste_interface_var_Force__P_0 = 0.001 * var_Force__P_0_orig_deriv; // 1 / millisecond
        const double var_Force__P_1_orig_deriv = (-var_Force__beta_tm - var_Force__f_12 - var_Force__g_01) * var_chaste_interface__Force__P_1 + var_Force__N_1 * var_Force__alpha_tm + var_chaste_interface__Force__P_0 * var_Force__f_01 + var_chaste_interface__Force__P_2 * var_Force__g_12; // 1 / second
        const double d_dt_chaste_interface_var_Force__P_1 = 0.001 * var_Force__P_1_orig_deriv; // 1 / millisecond
        const double var_troponin__Trpn_Ca_orig_deriv = (-var_chaste_interface__troponin__Trpn_Ca + var_troponin__Trpn_tot) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_troponin__alpha_trpn - 0.33333333333333331 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca * var_troponin__beta_trpn; // millimolar / second
        const double d_dt_chaste_interface_var_troponin__Trpn_Ca = 0.001 * var_troponin__Trpn_Ca_orig_deriv; // millimolar / millisecond
        const double var_troponin__dTrpn_Ca_dtime = (-var_chaste_interface__troponin__Trpn_Ca + var_troponin__Trpn_tot) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_troponin__alpha_trpn - 0.33333333333333331 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca * var_troponin__beta_trpn; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Ca_i_orig_deriv = -var_SERCA__j_up - var_calmodulin__dCmdn_Ca_dtime - var_troponin__dTrpn_Ca_dtime + var_RyR__j_rel * var_cell_parameters__v_SR / var_cell_parameters__v_i + 0.5 * (-var_L_type_Ca_channel__i_Ca_L_Ca - var_calcium_background_current__i_b_Ca + 2.0 * var_sodium_calcium_exchanger__i_NaCa) / (var_cell_parameters__F * var_cell_parameters__v_i); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.001 * var_intracellular_calcium_concentration__Ca_i_orig_deriv; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane_potential__V = 0.0;
        }
        else
        {
            const double var_membrane_potential__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane_potential__i_Stim = 1000.0 * NV_Ith_S(mParameters, 1) * var_membrane_potential__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
            const double var_membrane_potential__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_membrane_potential__i_Stim + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_potassium_pump__i_NaK + var_time_dependent_rectifier_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / NV_Ith_S(mParameters, 1); // millivolt / second
            d_dt_chaste_interface_var_membrane_potential__V = 0.001 * var_membrane_potential__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane_potential__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_CaMKII_factor__F_CaMK;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_RyR__F_SRCa_RyR;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_RyR__F_1;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_RyR__F_2;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_calmodulin__Cmdn_Ca;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_troponin__Trpn_Ca;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_Force__N_0;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_Force__P_0;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_Force__P_1;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_Force__P_2;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_Force__P_3;
    }

    N_Vector Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = NV_Ith_S(rY, 16);
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 138.22
        
        // Mathematics
        const double var_cell_parameters__Ca_o = 2.0; // millimolar
        const double var_cell_parameters__F = 96485.341499999995; // coulomb_per_mole
        const double var_cell_parameters__K_o = 4.0; // millimolar
        const double var_cell_parameters__Na_o = 140.0; // millimolar
        const double var_cell_parameters__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_cell_parameters__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 4.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Ca_o * exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 0.002 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__K_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.01 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Na_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_L_type_Ca_channel__i_Ca_L / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_membrane_potential__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_reversal_potentials__E_mh = var_cell_parameters__R * var_cell_parameters__T * log((var_cell_parameters__Na_o + 0.12 * var_cell_parameters__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_cell_parameters__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane_potential__V) * NV_Ith_S(mParameters, 3) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_fast_sodium_current__i_Na_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_fast_sodium_current__i_Na / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * var_cell_parameters__Ca_o * exp(var_cell_parameters__F * var_chaste_interface__membrane_potential__V * var_sodium_calcium_exchanger__gamma / (var_cell_parameters__R * var_cell_parameters__T)) - pow(var_cell_parameters__Na_o, 3) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T))) * NV_Ith_S(mParameters, 6) / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_calcium_exchanger__i_NaCa / NV_Ith_S(mParameters, 1); // uA_per_cm2
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-var_cell_parameters__K_o * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * NV_Ith_S(mParameters, 2) * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_time_dependent_rectifier_potassium_current__i_K / NV_Ith_S(mParameters, 1); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(6);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        NV_Ith_S(dqs, 1) = var_L_type_Ca_channel__i_Ca_L_converted;
        NV_Ith_S(dqs, 2) = var_time_dependent_rectifier_potassium_current__i_K_converted;
        NV_Ith_S(dqs, 3) = var_fast_sodium_current__i_Na_converted;
        NV_Ith_S(dqs, 4) = var_sodium_calcium_exchanger__i_NaCa_converted;
        NV_Ith_S(dqs, 5) = var_membrane_potential__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "iribe_model_2006";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-92.849333);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.91e-06);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("membrane_fast_sodium_current_m_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0013809);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("membrane_fast_sodium_current_h_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99569);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("time_dependent_rectifier_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.051127);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.95854);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5185e-08);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("membrane_L_type_calcium_current_d_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.7908e-08);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("CaMKII_factor__F_CaMK");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.028);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("RyR__F_SRCa_RyR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.25089);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("RyR__F_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5268);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("RyR__F_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.7508e-06);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("calmodulin__Cmdn_Ca");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.9636e-06);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("troponin__Trpn_Ca");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00027661);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("SR_calcium_concentration__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.24886);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.8041);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("cytosolic_potassium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(138.22);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("Force__N_0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99917);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("Force__P_0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.8593e-05);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("Force__P_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00013331);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("Force__P_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00023505);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("Force__P_3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00015349);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("nanoA_per_millimolar");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("nanoA");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("microS");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_reduced_inactivation");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_shift_inactivation");
    this->mParameterUnits.push_back("millivolt");

    // mParameters[6]:
    this->mParameterNames.push_back("membrane_sodium_calcium_exchanger_current_conductance");
    this->mParameterUnits.push_back("nanoA_per_millimolar4");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [4]:
    this->mDerivedQuantityNames.push_back("membrane_sodium_calcium_exchanger_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [5]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celliribe_model_2006_without_otherwise_sectionFromCellMLCvode)

#endif // CHASTE_CVODE
