#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: mahajan_shiferaw_model_2008
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "mahajan_2008.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellmahajan_2008FromCellMLCvodeDataClamp::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -14.999999999999998 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 400.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellmahajan_2008FromCellMLCvodeDataClamp::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellmahajan_2008FromCellMLCvodeDataClamp::Cellmahajan_2008FromCellMLCvodeDataClamp(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCellWithDataClamp(
                pOdeSolver,
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmahajan_2008FromCellMLCvodeDataClamp>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        NV_Ith_S(this->mParameters, 0) = 1.0; // (var_IKr__ScaleFactorGkr) [dimensionless]
        NV_Ith_S(this->mParameters, 1) = 1.0; // (var_IKs__ScaleFactorGks) [dimensionless]
        NV_Ith_S(this->mParameters, 2) = 1.0; // (var_Ito__ScaleFactorIto) [dimensionless]
        NV_Ith_S(this->mParameters, 3) = 182.0; // (var_ICaL__gca) [mmole_per_coulomb_cm]
        NV_Ith_S(this->mParameters, 4) = 0.0; // (var_membrane_data_clamp_current_conductance) [dimensionless]
        NV_Ith_S(this->mParameters, 5) = 12.0; // (var_INa__gna) [uS_per_nF]
        NV_Ith_S(this->mParameters, 6) = 0.012500000000000001; // (var_IKr__gkr) [uS_per_nF]
    }

    Cellmahajan_2008FromCellMLCvodeDataClamp::~Cellmahajan_2008FromCellMLCvodeDataClamp()
    {
    }
    
    double Cellmahajan_2008FromCellMLCvodeDataClamp::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 20);
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = NV_Ith_S(rY, 22);
        // Units: uM; Initial value: 0.226941113355
        
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
        const double var_IKs__gks = 0.1386; // uS_per_nF
        const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
        const double var_Ito__gtos = 0.11; // uS_per_nF
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = NV_Ith_S(mParameters, 3) * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double var_cell__i_Stim = 0.0; // nA_per_nF
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__K_i = 140.0; // mM
        const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
        const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
        const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
        const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 0) * NV_Ith_S(mParameters, 6) * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
        const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
        const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * NV_Ith_S(mParameters, 2) * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
        const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 5) * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 1) * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
        const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
        const double var_chaste_interface__i_ionic = -0.99999999999999989 * HeartConfig::Instance()->GetCapacitance() * var_cell__Itotal; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmahajan_2008FromCellMLCvodeDataClamp::EvaluateYDerivatives(double var_chaste_interface__Environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = NV_Ith_S(rY, 15);
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Irel__Ca_JSR = NV_Ith_S(rY, 18);
        // Units: uM; Initial value: 97.505463697266
        double var_chaste_interface__Irel__xir = NV_Ith_S(rY, 19);
        // Units: uM_per_ms; Initial value: 0.006679257264
        double var_chaste_interface__Na__Na_i = NV_Ith_S(rY, 20);
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_dyad = NV_Ith_S(rY, 21);
        // Units: uM; Initial value: 1.716573130685
        double var_chaste_interface__Ca__Ca_submem = NV_Ith_S(rY, 22);
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__Ca_NSR = NV_Ith_S(rY, 23);
        // Units: uM; Initial value: 104.450004990523
        double var_chaste_interface__Ca__tropi = NV_Ith_S(rY, 24);
        // Units: uM; Initial value: 22.171689894953
        double var_chaste_interface__Ca__trops = NV_Ith_S(rY, 25);
        // Units: uM; Initial value: 19.864701949854

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__bcal = 24.0; // uM
        const double var_Ca__bmem = 15.0; // uM
        const double var_Ca__bsar = 42.0; // uM
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Ca__kmem = 0.29999999999999999; // uM
        const double var_Ca__ksar = 13.0; // uM
        const double var_Ca__mempxi = var_Ca__bmem * var_Ca__kmem / pow((var_Ca__Ca_i + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__mempxs = var_Ca__bmem * var_Ca__kmem / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__sarpxi = var_Ca__bsar * var_Ca__ksar / pow((var_Ca__Ca_i + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__sarpxs = var_Ca__bsar * var_Ca__ksar / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__srkd = 0.59999999999999998; // uM
        const double var_Ca__srmax = 47.0; // uM
        const double var_Ca__spxi = var_Ca__srkd * var_Ca__srmax / pow((var_Ca__Ca_i + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__spxs = var_Ca__srkd * var_Ca__srmax / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__taud = 4.0; // ms
        const double var_Ca__jd = (-var_Ca__Ca_i + var_chaste_interface__Ca__Ca_submem) / var_Ca__taud; // uM_per_ms
        const double var_Ca__taups = 0.5; // ms
        const double var_Ca__xkcal = 7.0; // uM
        const double var_Ca__bpxi = var_Ca__bcal * var_Ca__xkcal / pow((var_Ca__Ca_i + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__bpxs = var_Ca__bcal * var_Ca__xkcal / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__dciib = 1 / (1.0 + var_Ca__bpxi + var_Ca__mempxi + var_Ca__sarpxi + var_Ca__spxi); // dimensionless
        const double var_Ca__dcsib = 1 / (1.0 + var_Ca__bpxs + var_Ca__mempxs + var_Ca__sarpxs + var_Ca__spxs); // dimensionless
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbi = -var_chaste_interface__Ca__tropi * var_Ca__xkoff + (-var_chaste_interface__Ca__tropi + var_Ca__btrop) * var_Ca__Ca_i * var_Ca__xkon; // uM_per_ms
        const double var_Ca__xbs = -var_chaste_interface__Ca__trops * var_Ca__xkoff + (-var_chaste_interface__Ca__trops + var_Ca__btrop) * var_chaste_interface__Ca__Ca_submem * var_Ca__xkon; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__tropi = var_Ca__xbi; // uM / ms
        const double d_dt_chaste_interface_var_Ca__trops = var_Ca__xbs; // uM / ms
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__cpt = 6.0936500000000002; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__k1 = 0.024167999999999999 * var_ICaL__fca; // per_ms
        const double var_ICaL__k1t = 0.00413; // per_ms
        const double var_ICaL__k2 = 0.000103615; // per_ms
        const double var_ICaL__k2t = 0.0022399999999999998; // per_ms
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__r1 = 0.29999999999999999; // per_ms
        const double var_ICaL__r2 = 3.0; // per_ms
        const double var_ICaL__s1 = 0.018268800000000002 * var_ICaL__fca; // per_ms
        const double var_ICaL__s1t = 0.0019499999999999999; // per_ms
        const double var_ICaL__s2 = var_ICaL__k2 * var_ICaL__r1 * var_ICaL__s1 / (var_ICaL__k1 * var_ICaL__r2); // per_ms
        const double var_ICaL__s2t = var_ICaL__k2t * var_ICaL__r1 * var_ICaL__s1t / (var_ICaL__k1t * var_ICaL__r2); // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__tca = 78.032899999999998; // ms
        const double var_ICaL__tau_ca = 0.10000000000000001 + var_ICaL__tca / (1.0 + pow(var_chaste_interface__Ca__Ca_dyad, 4) / pow(var_ICaL__cpt, 4)); // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ileak_Iup_Ixfer__cup = 0.5; // uM
        const double var_Ileak_Iup_Ixfer__gleak = 2.069e-5; // per_ms
        const double var_Ileak_Iup_Ixfer__kj = 50.0; // uM
        const double var_Ileak_Iup_Ixfer__jleak = pow(var_chaste_interface__Ca__Ca_NSR, 2) * (-var_Ca__Ca_i + 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR) * var_Ileak_Iup_Ixfer__gleak / (pow(var_chaste_interface__Ca__Ca_NSR, 2) + pow(var_Ileak_Iup_Ixfer__kj, 2)); // uM_per_ms
        const double var_Ileak_Iup_Ixfer__vup = 0.40000000000000002; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__jup = pow(var_Ca__Ca_i, 2) * var_Ileak_Iup_Ixfer__vup / (pow(var_Ca__Ca_i, 2) + pow(var_Ileak_Iup_Ixfer__cup, 2)); // uM_per_ms
        const double var_Ca__Ca_i_orig_deriv = (-var_Ca__xbi - var_Ileak_Iup_Ixfer__jup + var_Ca__jd + var_Ileak_Iup_Ixfer__jleak) * var_Ca__dciib; // uM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_i_converted = 0.001 * var_Ca__Ca_i_orig_deriv; // millimolar / ms
        const double var_Irel__av = 11.300000000000001; // per_ms
        const double var_Irel__ax = 0.35759999999999997; // per_mV
        const double var_Irel__ay = 0.050000000000000003; // per_mV
        const double var_Irel__cstar = 90.0; // uM
        const double var_Irel__bv = -50.0 + (1.0 - var_Irel__av) * var_Irel__cstar; // uM_per_ms
        const double var_Irel__Qr0 = (((var_chaste_interface__Irel__Ca_JSR > 50.0) && (var_chaste_interface__Irel__Ca_JSR < var_Irel__cstar)) ? (-50.0 + var_chaste_interface__Irel__Ca_JSR) : ((var_chaste_interface__Irel__Ca_JSR >= var_Irel__cstar) ? (var_chaste_interface__Irel__Ca_JSR * var_Irel__av + var_Irel__bv) : (0))); // uM_per_ms
        const double var_Irel__Qr = var_chaste_interface__Ca__Ca_NSR * var_Irel__Qr0 / var_Irel__cstar; // uM_per_ms
        const double var_Irel__gbarsr = 26841.799999999999; // dimensionless
        const double var_Irel__gdyad = 9000.0; // mmole_per_coulomb_cm
        const double var_Irel__gryr = 2.5807899999999999; // per_ms
        const double var_Irel__taua = 100.0; // ms
        const double d_dt_chaste_interface_var_Irel__Ca_JSR = (-var_chaste_interface__Irel__Ca_JSR + var_chaste_interface__Ca__Ca_NSR) / var_Irel__taua; // uM / ms
        const double var_Irel__taur = 30.0; // ms
        const double var_Ca__dCa_JSR = -var_Ileak_Iup_Ixfer__jleak - var_chaste_interface__Irel__xir + var_Ileak_Iup_Ixfer__jup; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = var_Ca__dCa_JSR; // uM / ms
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__k3t = var_ICaL__k3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c1 = var_ICaL__alpha * var_chaste_interface__ICaL__c2 + var_ICaL__k2 * var_chaste_interface__ICaL__xi1ca + var_ICaL__k2t * var_chaste_interface__ICaL__xi1ba + var_ICaL__po * var_ICaL__r2 - (var_ICaL__beta + var_ICaL__k1 + var_ICaL__k1t + var_ICaL__r1) * var_chaste_interface__ICaL__c1; // 1 / ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauba = 450.0 + (-450.0 + var_ICaL__recov) * var_ICaL__Pr; // ms
        const double var_ICaL__k5t = (1.0 - var_ICaL__Ps) / var_ICaL__tauba; // per_ms
        const double var_ICaL__k6t = var_ICaL__Ps / var_ICaL__tauba; // per_ms
        const double var_ICaL__k4t = var_ICaL__alpha * var_ICaL__k1t * var_ICaL__k3t * var_ICaL__k5t / (var_ICaL__beta * var_ICaL__k2t * var_ICaL__k6t); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ba = var_chaste_interface__ICaL__c1 * var_ICaL__k1t + var_ICaL__k4t * var_chaste_interface__ICaL__xi2ba + var_ICaL__po * var_ICaL__s1t - (var_ICaL__k2t + var_ICaL__k3t + var_ICaL__s2t) * var_chaste_interface__ICaL__xi1ba; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__xi2ba = var_chaste_interface__ICaL__c2 * var_ICaL__k6t + var_ICaL__k3t * var_chaste_interface__ICaL__xi1ba - (var_ICaL__k4t + var_ICaL__k5t) * var_chaste_interface__ICaL__xi2ba; // 1 / ms
        const double var_ICaL__tauca = (-var_ICaL__tau_ca + var_ICaL__recov) * var_ICaL__Pr + var_ICaL__tau_ca; // ms
        const double var_ICaL__k5 = (1.0 - var_ICaL__Ps) / var_ICaL__tauca; // per_ms
        const double var_ICaL__k6 = var_ICaL__Ps * var_ICaL__fca / var_ICaL__tauca; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c2 = var_ICaL__beta * var_chaste_interface__ICaL__c1 + var_ICaL__k5 * var_chaste_interface__ICaL__xi2ca + var_ICaL__k5t * var_chaste_interface__ICaL__xi2ba - (var_ICaL__alpha + var_ICaL__k6 + var_ICaL__k6t) * var_chaste_interface__ICaL__c2; // 1 / ms
        const double var_ICaL__k4 = var_ICaL__alpha * var_ICaL__k1 * var_ICaL__k3 * var_ICaL__k5 / (var_ICaL__beta * var_ICaL__k2 * var_ICaL__k6); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ca = var_chaste_interface__ICaL__c1 * var_ICaL__k1 + var_ICaL__k4 * var_chaste_interface__ICaL__xi2ca + var_ICaL__po * var_ICaL__s1 - (var_ICaL__k2 + var_ICaL__k3 + var_ICaL__s2) * var_chaste_interface__ICaL__xi1ca; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__xi2ca = var_chaste_interface__ICaL__c2 * var_ICaL__k6 + var_ICaL__k3 * var_chaste_interface__ICaL__xi1ca - (var_ICaL__k4 + var_ICaL__k5) * var_chaste_interface__ICaL__xi2ca; // 1 / ms
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = NV_Ith_S(mParameters, 3) * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__xkrinf = 1 / (1.0 + exp(-6.666666666666667 - 0.13333333333333333 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr__xkrv1 = ((fabs(7.0 + var_chaste_interface__cell__V) > 0.001) ? (0.0013799999999999999 * (7.0 + var_chaste_interface__cell__V) / (1.0 - exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V))) : (0.011219512195121951)); // per_ms
        const double var_IKr__xkrv2 = ((fabs(10.0 + var_chaste_interface__cell__V) > 0.001) ? (0.00060999999999999997 * (10.0 + var_chaste_interface__cell__V) / (-1.0 + exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V))) : (0.0042068965517241376)); // per_ms
        const double var_IKr__taukr = 1 / (var_IKr__xkrv1 + var_IKr__xkrv2); // ms
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + var_IKr__xkrinf) / var_IKr__taukr; // 1 / ms
        const double var_IKs__tauxs1 = ((fabs(30.0 + var_chaste_interface__cell__V) < 0.014556040756914121) ? (417.94625266107982) : (1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))))); // ms
        const double var_IKs__tauxs2 = 4.0 * var_IKs__tauxs1; // ms
        const double var_IKs__xs1ss = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xs1ss) / var_IKs__tauxs1; // 1 / ms
        const double var_IKs__xs2ss = var_IKs__xs1ss; // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs2 = (-var_chaste_interface__IKs__xs2 + var_IKs__xs2ss) / var_IKs__tauxs2; // 1 / ms
        const double var_INa__ah = ((var_chaste_interface__cell__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)); // per_ms
        const double var_INa__aj = ((var_chaste_interface__cell__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))) : (0)); // per_ms
        const double var_INa__am = ((fabs(47.130000000000003 + var_chaste_interface__cell__V) > 0.001) ? (0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (3.2000000000000002)); // per_ms
        const double var_INa__bh = ((var_chaste_interface__cell__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xh = (1.0 - var_chaste_interface__INa__xh) * var_INa__ah - var_INa__bh * var_chaste_interface__INa__xh; // 1 / ms
        const double var_INa__bj = ((var_chaste_interface__cell__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xj = (1.0 - var_chaste_interface__INa__xj) * var_INa__aj - var_INa__bj * var_chaste_interface__INa__xj; // 1 / ms
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double d_dt_chaste_interface_var_INa__xm = (1.0 - var_chaste_interface__INa__xm) * var_INa__am - var_INa__bm * var_chaste_interface__INa__xm; // 1 / ms
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_submem = (-var_Ca__xbs + 50.0 * var_INaCa__jNaCa + 50.0 * var_chaste_interface__Irel__xir - 50.0 * var_Ca__jd - 50.0 * var_ICaL__jca) * var_Ca__dcsib; // uM / ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Irel__sparkV = exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay)); // dimensionless
        const double var_Irel__spark_rate = var_ICaL__po * var_Irel__gryr * var_Irel__sparkV * fabs(var_ICaL__rxa); // per_ms
        const double d_dt_chaste_interface_var_Irel__xir = var_Irel__Qr * var_Irel__spark_rate - (1.0 - var_Ca__dCa_JSR * var_Irel__taur / var_chaste_interface__Ca__Ca_NSR) * var_chaste_interface__Irel__xir / var_Irel__taur; // uM_per_ms / ms
        const double var_Irel__xicap = var_ICaL__po * var_Irel__gdyad * fabs(var_ICaL__rxa); // uM_per_ms
        const double var_Irel__xirp = var_ICaL__po * var_Irel__Qr * var_Irel__gbarsr * fabs(var_ICaL__rxa) * exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax)); // uM_per_ms
        const double var_Irel__xiryr = var_Irel__xicap + var_Irel__xirp; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_dyad = -(-var_chaste_interface__Ca__Ca_submem + var_chaste_interface__Ca__Ca_dyad) / var_Ca__taups + var_Irel__xiryr; // uM / ms
        const double var_Ito__rt1 = -0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt3 = 6.0 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt4 = -0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2); // dimensionless
        const double var_Ito__rt5 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__txf = 1.5 + 3.5 * exp(var_Ito__rt4); // ms
        const double var_Ito__txs = 0.5 + 9.0 / (1.0 + exp(-var_Ito__rt1)); // ms
        const double var_Ito__tyf = 20.0 + 20.0 / (1.0 + exp(var_Ito__rt5)); // ms
        const double var_Ito__tys = 30.0 + 3000.0 / (1.0 + exp(var_Ito__rt3)); // ms
        const double var_Ito__xtos_inf = 1 / (1.0 + exp(var_Ito__rt1)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtos = (-var_chaste_interface__Ito__xtos + var_Ito__xtos_inf) / var_Ito__txs; // 1 / ms
        const double var_Ito__xtof_inf = var_Ito__xtos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtof = (-var_chaste_interface__Ito__xtof + var_Ito__xtof_inf) / var_Ito__txf; // 1 / ms
        const double var_Ito__ytos_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytos = (-var_chaste_interface__Ito__ytos + var_Ito__ytos_inf) / var_Ito__tys; // 1 / ms
        const double var_Ito__ytof_inf = var_Ito__ytos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytof = (-var_chaste_interface__Ito__ytof + var_Ito__ytof_inf) / var_Ito__tyf; // 1 / ms
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 5) * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double d_dt_chaste_interface_var_Na__Na_i = 0.001 * (-var_INa__xina - 3.0 * var_INaCa__xiNaCa - 3.0 * var_INaK__xiNaK) / var_cell__wca; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
            const double var_IKs__gks = 0.1386; // uS_per_nF
            const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
            const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
            const double var_Ito__gtos = 0.11; // uS_per_nF
            const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
            const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
            const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
            const double var_cell__i_Stim = 1.0000000000000002 * var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nA_per_nF
            const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
            const double var_reversal_potentials__K_i = 140.0; // mM
            const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
            const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
            const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
            const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
            const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
            const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 0) * NV_Ith_S(mParameters, 6) * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
            const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
            const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * NV_Ith_S(mParameters, 2) * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
            const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
            const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
            const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
            const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 1) * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
            const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
            // Special handling of data clamp current here
            // (we want to save expense of calling the interpolation method if possible.)
            double var_chaste_interface__membrane_data_clamp_current = 0.0;
            if (mDataClampIsOn)
            {
                var_chaste_interface__membrane_data_clamp_current = (-GetExperimentalVoltageAtTimeT(var_chaste_interface__Environment__time) + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 4); // uA_per_cm2
            }
            d_dt_chaste_interface_var_cell__V = var_cell__Itotal + var_chaste_interface__membrane_data_clamp_current; // mV / ms
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_cell__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_Ca__Ca_i_converted;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_INa__xm;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_INa__xh;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_INa__xj;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_ICaL__c1;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_ICaL__c2;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_ICaL__xi1ca;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_ICaL__xi1ba;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_ICaL__xi2ca;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_ICaL__xi2ba;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_IKr__xr;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_IKs__xs1;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_IKs__xs2;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_Ito__xtos;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_Ito__ytos;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_Ito__xtof;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_Ito__ytof;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_Irel__Ca_JSR;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_Irel__xir;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_Na__Na_i;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_Ca__Ca_dyad;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_Ca__Ca_submem;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_Ca__Ca_NSR;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_Ca__tropi;
        NV_Ith_S(rDY,25) = d_dt_chaste_interface_var_Ca__trops;
    }

    N_Vector Cellmahajan_2008FromCellMLCvodeDataClamp::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000256752008084
        
        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        // Special handling of data clamp current here
        // (we want to save expense of calling the interpolation method if possible.)
        double var_chaste_interface__membrane_data_clamp_current = 0.0;
        if (mDataClampIsOn)
        {
            var_chaste_interface__membrane_data_clamp_current = (-GetExperimentalVoltageAtTimeT(var_chaste_interface__Environment__time) + var_chaste_interface__cell__V) * NV_Ith_S(mParameters, 4); // uA_per_cm2
        }

        N_Vector dqs = N_VNew_Serial(4);
        NV_Ith_S(dqs, 0) = var_chaste_interface__Environment__time;
        NV_Ith_S(dqs, 1) = var_chaste_interface__Ca__Ca_i_converted;
        NV_Ith_S(dqs, 2) = var_chaste_interface__membrane_data_clamp_current;
        NV_Ith_S(dqs, 3) = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmahajan_2008FromCellMLCvodeDataClamp>::Initialise(void)
{
    this->mSystemName = "mahajan_shiferaw_model_2008";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.169816169406);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000256752008084);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("INa__xm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001075453357);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("INa__xh");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.990691306716);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("INa__xj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.993888937283);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("ICaL__c1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.8211252e-05);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("ICaL__c2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.979322592773);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("ICaL__xi1ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001208153482);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("ICaL__xi1ba");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.3616596e-05);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("ICaL__xi2ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004173008466);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("ICaL__xi2ba");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015242594688);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007074239331);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.048267587131);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.105468807033);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("Ito__xtos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00364776906);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("Ito__ytos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.174403618112);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("Ito__xtof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003643592594);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("Ito__ytof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.993331326442);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("Irel__Ca_JSR");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(97.505463697266);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("Irel__xir");
    this->mVariableUnits.push_back("uM_per_ms");
    this->mInitialConditions.push_back(0.006679257264);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(11.441712311614);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("Ca__Ca_dyad");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(1.716573130685);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("Ca__Ca_submem");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(0.226941113355);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(104.450004990523);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("Ca__tropi");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(22.171689894953);

    // NV_Ith_S(rY, 25):
    this->mVariableNames.push_back("Ca__trops");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(19.864701949854);

    // mParameters[0]:
    this->mParameterNames.push_back("ScaleFactorGkr");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("ScaleFactorGks");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("ScaleFactorIto");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("mmole_per_coulomb_cm");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_data_clamp_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("uS_per_nF");

    // mParameters[6]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("uS_per_nF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_data_clamp_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmahajan_2008FromCellMLCvodeDataClamp)

#endif // CHASTE_CVODE
