//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: winslow_model_1999
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "winslow_model_1999.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellwinslow_model_1999FromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -21.126799999999999 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellwinslow_model_1999FromCellMLBackwardEuler::Cellwinslow_model_1999FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<25>(
                33,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellwinslow_model_1999FromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellwinslow_model_1999FromCellMLBackwardEuler::~Cellwinslow_model_1999FromCellMLBackwardEuler()
    {
    }
    
    double Cellwinslow_model_1999FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr = rY[4];
        // Units: dimensionless; Initial value: 0.51
        double var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks = rY[5];
        // Units: dimensionless; Initial value: 0.264
        double var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 = rY[6];
        // Units: dimensionless; Initial value: 2.63
        double var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 = rY[7];
        // Units: dimensionless; Initial value: 0.99
        double var_chaste_interface__L_type_Ca_current__O = rY[8];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_current__O_Ca = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[27];
        // Units: millimolar; Initial value: 10.0
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[28];
        // Units: millimolar; Initial value: 8e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[29];
        // Units: millimolar; Initial value: 157.8
        
        const double var_L_type_Ca_current__P_Ca = 0.00031250000000000001; // cm_per_second
        const double var_L_type_Ca_current__P_K = 5.7899999999999998e-7; // cm_per_second
        const double var_L_type_Ca_current__i_Ca_half = -0.26500000000000001; // microA_per_microF
        const double var_Na_Ca_exchanger__K_NaCa = 0.29999999999999999; // microA_per_microF
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // millimolar
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // millimolar
        const double var_Na_Ca_exchanger__K_sat = 0.20000000000000001; // dimensionless
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.00038420000000000001; // milliS_per_microF
        const double var_fast_sodium_current__g_Na = 12.800000000000001; // milliS_per_microF
        const double var_membrane__F = 96.485341500000004; // coulomb_per_millimole
        const double var_membrane__R = 8.3144720000000003; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_plateau_potassium_current__g_Kp = 0.0022160000000000001; // milliS_per_microF
        const double var_plateau_potassium_current_Kp_gate__Kp_V = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__R_V = 1 / (1.0 + 1.4944999999999999 * exp(0.044600000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__g_Kr = 0.0033999999999999998; // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.050000000000000003; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 5.0000000000000002e-5; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__intracellular_ion_concentrations__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__intracellular_ion_concentrations__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_slow_activating_delayed_rectifiyer_K_current__g_Ks = 0.0027133999999999999; // milliS_per_microF
        const double var_sodium_background_current__g_Nab = 0.0030999999999999999; // milliS_per_microF
        const double var_sodium_potassium_pump__I_NaK = 0.69299999999999995; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_standard_ionic_concentrations__Cao = 2.0; // millimolar
        const double var_L_type_Ca_current__i_Ca_max = 4000.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_standard_ionic_concentrations__Cao) * var_L_type_Ca_current__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca = (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__i_Ca_max * var_chaste_interface__L_type_Ca_current_y_gate__y; // microA_per_microF
        const double var_L_type_Ca_current__p_prime_k = var_L_type_Ca_current__P_K / (1.0 + var_L_type_Ca_current__i_Ca_max / var_L_type_Ca_current__i_Ca_half); // cm_per_second
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Cao / var_chaste_interface__intracellular_ion_concentrations__Cai) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_standard_ionic_concentrations__Ko = 4.0; // millimolar
        const double var_L_type_Ca_current__i_Ca_K = pow(var_membrane__F, 2) * (-var_standard_ionic_concentrations__Ko + var_chaste_interface__intracellular_ion_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__p_prime_k * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ko / var_chaste_interface__intracellular_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_plateau_potassium_current__i_Kp = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__g_Kp * var_plateau_potassium_current_Kp_gate__Kp_V; // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__f_Ko = 0.5 * sqrt(var_standard_ionic_concentrations__Ko); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__i_Kr = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_rapid_activating_delayed_rectifiyer_K_current__R_V * var_rapid_activating_delayed_rectifiyer_K_current__f_Ko * var_rapid_activating_delayed_rectifiyer_K_current__g_Kr * var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr; // microA_per_microF
        const double var_standard_ionic_concentrations__Nao = 138.0; // millimolar
        const double var_Na_Ca_exchanger__i_NaCa = 5000.0 * (pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * var_standard_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_standard_ionic_concentrations__Nao, 3) * var_chaste_interface__intracellular_ion_concentrations__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + var_Na_Ca_exchanger__K_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_standard_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_standard_ionic_concentrations__Cao)); // microA_per_microF
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Nao / var_chaste_interface__intracellular_ion_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_slow_activating_delayed_rectifiyer_K_current__E_Ks = var_membrane__R * var_membrane__T * log((var_standard_ionic_concentrations__Ko + 0.018329999999999999 * var_standard_ionic_concentrations__Nao) / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.018329999999999999 * var_chaste_interface__intracellular_ion_concentrations__Nai)) / var_membrane__F; // millivolt
        const double var_slow_activating_delayed_rectifiyer_K_current__i_Ks = pow(var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks, 2) * (-var_slow_activating_delayed_rectifiyer_K_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_activating_delayed_rectifiyer_K_current__g_Ks; // microA_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK * var_standard_ionic_concentrations__Ko / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__intracellular_ion_concentrations__Nai), 1.5)) * (var_sodium_potassium_pump__K_mKo + var_standard_ionic_concentrations__Ko)); // microA_per_microF
        const double var_time_independent_potassium_current__K_mK1 = 13.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 2.7999999999999998; // milliS_per_microF
        const double var_time_independent_potassium_current_K1_gate__K1_infinity_V = 1 / (2.0 + exp(1.5 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_standard_ionic_concentrations__Ko * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity_V / (var_standard_ionic_concentrations__Ko + var_time_independent_potassium_current__K_mK1); // microA_per_microF
        const double var_transient_outward_potassium_current__g_to1 = 0.23815; // milliS_per_microF
        const double var_transient_outward_potassium_current__i_to1 = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_potassium_current__g_to1 * var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 * var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1; // microA_per_microF
        const double var_chaste_interface__i_ionic = (var_L_type_Ca_current__i_Ca + var_L_type_Ca_current__i_Ca_K + var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_plateau_potassium_current__i_Kp + var_rapid_activating_delayed_rectifiyer_K_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_activating_delayed_rectifiyer_K_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_potassium_current__i_to1) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellwinslow_model_1999FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[25], double rResidual[25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_Ca_current__C0 = rCurrentGuess[0];
        double var_chaste_interface__L_type_Ca_current__C1 = rCurrentGuess[1];
        double var_chaste_interface__L_type_Ca_current__C2 = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_current__C3 = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_current__C4 = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_current__C_Ca0 = rCurrentGuess[5];
        double var_chaste_interface__L_type_Ca_current__C_Ca1 = rCurrentGuess[6];
        double var_chaste_interface__L_type_Ca_current__C_Ca2 = rCurrentGuess[7];
        double var_chaste_interface__L_type_Ca_current__C_Ca3 = rCurrentGuess[8];
        double var_chaste_interface__L_type_Ca_current__C_Ca4 = rCurrentGuess[9];
        double var_chaste_interface__L_type_Ca_current__O = rCurrentGuess[10];
        double var_chaste_interface__L_type_Ca_current__O_Ca = rCurrentGuess[11];
        double var_chaste_interface__RyR_channel__P_C1 = rCurrentGuess[12];
        double var_chaste_interface__RyR_channel__P_C2 = rCurrentGuess[13];
        double var_chaste_interface__RyR_channel__P_O1 = rCurrentGuess[14];
        double var_chaste_interface__RyR_channel__P_O2 = rCurrentGuess[15];
        double var_chaste_interface__fast_sodium_current_m_gate__m = rCurrentGuess[16];
        double var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa = rCurrentGuess[17];
        double var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa = rCurrentGuess[18];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rCurrentGuess[19];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rCurrentGuess[20];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rCurrentGuess[21];
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rCurrentGuess[22];
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rCurrentGuess[24];
        
        //output_equations
        const double var_L_type_Ca_current__P_Ca = 0.00031250000000000001; // cm_per_second
        const double var_L_type_Ca_current__a = 2.0; // dimensionless
        const double var_L_type_Ca_current__b = 2.0; // dimensionless
        const double var_L_type_Ca_current__f = 300.0; // per_second
        const double var_L_type_Ca_current__fprime = 7.0; // per_second
        const double var_L_type_Ca_current__g = 2000.0; // per_second
        const double var_L_type_Ca_current__O_orig_deriv = var_chaste_interface__L_type_Ca_current__C4 * var_L_type_Ca_current__f - var_chaste_interface__L_type_Ca_current__O * var_L_type_Ca_current__g; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__O = 0.001 * var_L_type_Ca_current__O_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__gprime = 7000.0; // per_second
        const double var_L_type_Ca_current__O_Ca_orig_deriv = var_chaste_interface__L_type_Ca_current__C_Ca4 * var_L_type_Ca_current__fprime - var_chaste_interface__L_type_Ca_current__O_Ca * var_L_type_Ca_current__gprime; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__O_Ca = 0.001 * var_L_type_Ca_current__O_Ca_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__omega = 10.0; // per_second
        const double var_Na_Ca_exchanger__K_NaCa = 0.29999999999999999; // microA_per_microF
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // millimolar
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // millimolar
        const double var_Na_Ca_exchanger__K_sat = 0.20000000000000001; // dimensionless
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_RyR_channel__k_a_minus = 576.0; // per_second
        const double var_RyR_channel__k_a_plus = 12150000000000.0; // millimolar4_per_second
        const double var_RyR_channel__k_b_minus = 1930.0; // per_second
        const double var_RyR_channel__k_b_plus = 4050000000.0; // millimolar3_per_second
        const double var_RyR_channel__k_c_minus = 0.80000000000000004; // per_second
        const double var_RyR_channel__k_c_plus = 100.0; // per_second
        const double var_RyR_channel__P_C2_orig_deriv = var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_c_plus - var_chaste_interface__RyR_channel__P_C2 * var_RyR_channel__k_c_minus; // 1 / second
        const double d_dt_chaste_interface_var_RyR_channel__P_C2 = 0.001 * var_RyR_channel__P_C2_orig_deriv; // 1 / millisecond
        const double var_RyR_channel__m = 3.0; // dimensionless
        const double var_RyR_channel__n = 4.0; // dimensionless
        const double var_RyR_channel__v1 = 1800.0; // per_second
        const double var_SERCA2a_pump__K_SR = 1.0; // dimensionless
        const double var_SERCA2a_pump__K_fb = 0.00016799999999999999; // millimolar
        const double var_SERCA2a_pump__K_rb = 3.29; // millimolar
        const double var_SERCA2a_pump__N_fb = 1.2; // dimensionless
        const double var_SERCA2a_pump__N_rb = 1.0; // dimensionless
        const double var_SERCA2a_pump__Vmaxf = 0.081299999999999997; // millimolar_per_second
        const double var_SERCA2a_pump__Vmaxr = 0.318; // millimolar_per_second
        const double var_calcium_background_current__g_Cab = 0.00038420000000000001; // milliS_per_microF
        const double var_intracellular_Ca_fluxes__HTRPN_tot = 0.14000000000000001; // dimensionless
        const double var_intracellular_Ca_fluxes__LTRPN_tot = 0.070000000000000007; // dimensionless
        const double var_intracellular_Ca_fluxes__k_htrpn_minus = 0.066000000000000003; // per_second
        const double var_intracellular_Ca_fluxes__k_htrpn_plus = 20000.0; // per_millimolar_second
        const double var_intracellular_Ca_fluxes__k_ltrpn_minus = 40.0; // per_second
        const double var_intracellular_Ca_fluxes__k_ltrpn_plus = 40000.0; // per_millimolar_second
        const double var_intracellular_Ca_fluxes__tau_tr = 0.00057470000000000004; // second
        const double var_intracellular_Ca_fluxes__tau_xfer = 0.026700000000000002; // second
        const double var_intracellular_ion_concentrations__A_cap = 0.00015339999999999999; // cm2
        const double var_intracellular_ion_concentrations__CMDN_tot = 0.050000000000000003; // millimolar
        const double var_intracellular_ion_concentrations__CSQN_tot = 15.0; // millimolar
        const double var_SERCA2a_pump__rb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_NSR / var_SERCA2a_pump__K_rb), var_SERCA2a_pump__N_rb); // dimensionless
        const double var_intracellular_Ca_fluxes__J_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_chaste_interface__intracellular_ion_concentrations__Ca_NSR) / var_intracellular_Ca_fluxes__tau_tr; // millimolar_per_second
        const double var_L_type_Ca_current__gamma = 103.75 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss; // per_second
        const double var_RyR_channel__J_rel = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__RyR_channel__P_O1 + var_chaste_interface__RyR_channel__P_O2) * var_RyR_channel__v1; // millimolar_per_second
        const double var_RyR_channel__P_C1_orig_deriv = var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_a_minus - pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, var_RyR_channel__n) * var_chaste_interface__RyR_channel__P_C1 * var_RyR_channel__k_a_plus; // 1 / second
        const double d_dt_chaste_interface_var_RyR_channel__P_C1 = 0.001 * var_RyR_channel__P_C1_orig_deriv; // 1 / millisecond
        const double var_RyR_channel__P_O1_orig_deriv = var_chaste_interface__RyR_channel__P_C2 * var_RyR_channel__k_c_minus + var_chaste_interface__RyR_channel__P_O2 * var_RyR_channel__k_b_minus - var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_a_minus - var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_c_plus + pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, var_RyR_channel__n) * var_chaste_interface__RyR_channel__P_C1 * var_RyR_channel__k_a_plus - pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, var_RyR_channel__m) * var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_RyR_channel__P_O1 = 0.001 * var_RyR_channel__P_O1_orig_deriv; // 1 / millisecond
        const double var_RyR_channel__P_O2_orig_deriv = -var_chaste_interface__RyR_channel__P_O2 * var_RyR_channel__k_b_minus + pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, var_RyR_channel__m) * var_chaste_interface__RyR_channel__P_O1 * var_RyR_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_RyR_channel__P_O2 = 0.001 * var_RyR_channel__P_O2_orig_deriv; // 1 / millisecond
        const double var_SERCA2a_pump__fb = pow((var_chaste_interface__intracellular_ion_concentrations__Cai / var_SERCA2a_pump__K_fb), var_SERCA2a_pump__N_fb); // dimensionless
        const double var_SERCA2a_pump__J_up = (var_SERCA2a_pump__Vmaxf * var_SERCA2a_pump__fb - var_SERCA2a_pump__Vmaxr * var_SERCA2a_pump__rb) * var_SERCA2a_pump__K_SR / (1.0 + var_SERCA2a_pump__fb + var_SERCA2a_pump__rb); // millimolar_per_second
        const double var_intracellular_Ca_fluxes__HTRPNCa_orig_deriv = -var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa * var_intracellular_Ca_fluxes__k_htrpn_minus + (1.0 - var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa) * var_intracellular_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_Ca_fluxes__HTRPNCa = 0.001 * var_intracellular_Ca_fluxes__HTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_intracellular_Ca_fluxes__J_HTRPNCa = var_intracellular_Ca_fluxes__HTRPNCa_orig_deriv; // millimolar_per_second
        const double var_intracellular_Ca_fluxes__J_xfer = (-var_chaste_interface__intracellular_ion_concentrations__Cai + var_chaste_interface__intracellular_ion_concentrations__Ca_ss) / var_intracellular_Ca_fluxes__tau_xfer; // millimolar_per_second
        const double var_intracellular_Ca_fluxes__LTRPNCa_orig_deriv = -var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa * var_intracellular_Ca_fluxes__k_ltrpn_minus + (1.0 - var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa) * var_intracellular_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_Ca_fluxes__LTRPNCa = 0.001 * var_intracellular_Ca_fluxes__LTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_intracellular_Ca_fluxes__J_LTRPNCa = var_intracellular_Ca_fluxes__LTRPNCa_orig_deriv; // millimolar_per_second
        const double var_intracellular_Ca_fluxes__J_trpn = var_intracellular_Ca_fluxes__HTRPN_tot * var_intracellular_Ca_fluxes__J_HTRPNCa + var_intracellular_Ca_fluxes__J_LTRPNCa * var_intracellular_Ca_fluxes__LTRPN_tot; // millimolar_per_second
        const double var_intracellular_ion_concentrations__EGTA_tot = 0; // millimolar
        const double var_intracellular_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_intracellular_ion_concentrations__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_intracellular_ion_concentrations__K_mEGTA = 0.00014999999999999999; // millimolar
        const double var_intracellular_ion_concentrations__Ki_orig_deriv = 0; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = 0.001 * var_intracellular_ion_concentrations__Ki_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Nai_orig_deriv = 0; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = 0.001 * var_intracellular_ion_concentrations__Nai_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__V_JSR = 1.6e-7; // micro_litre
        const double var_intracellular_ion_concentrations__V_NSR = 2.0999999999999998e-6; // micro_litre
        const double var_intracellular_ion_concentrations__V_SS = 1.2e-9; // micro_litre
        const double var_intracellular_ion_concentrations__V_myo = 2.584e-5; // micro_litre
        const double var_intracellular_ion_concentrations__Ca_NSR_orig_deriv = var_SERCA2a_pump__J_up * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_NSR - var_intracellular_Ca_fluxes__J_tr * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_NSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.001 * var_intracellular_ion_concentrations__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_JSR = 1 / (1.0 + var_intracellular_ion_concentrations__CSQN_tot * var_intracellular_ion_concentrations__K_mCSQN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_intracellular_ion_concentrations__K_mCSQN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__Ca_JSR_orig_deriv = (-var_RyR_channel__J_rel + var_intracellular_Ca_fluxes__J_tr) * var_intracellular_ion_concentrations__beta_JSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * var_intracellular_ion_concentrations__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_SS = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_intracellular_ion_concentrations__K_mCMDN), 2) + var_intracellular_ion_concentrations__EGTA_tot * var_intracellular_ion_concentrations__K_mEGTA / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_intracellular_ion_concentrations__K_mEGTA), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__beta_i = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Cai + var_intracellular_ion_concentrations__K_mCMDN), 2) + var_intracellular_ion_concentrations__EGTA_tot * var_intracellular_ion_concentrations__K_mEGTA / pow((var_chaste_interface__intracellular_ion_concentrations__Cai + var_intracellular_ion_concentrations__K_mEGTA), 2)); // dimensionless
        const double var_membrane__F = 96.485341500000004; // coulomb_per_millimole
        const double var_membrane__R = 8.3144720000000003; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__alpha = 400.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_L_type_Ca_current__alpha_a = var_L_type_Ca_current__a * var_L_type_Ca_current__alpha; // per_second
        const double var_L_type_Ca_current__beta = 50.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_second
        const double var_L_type_Ca_current__C0_orig_deriv = var_chaste_interface__L_type_Ca_current__C1 * var_L_type_Ca_current__beta + var_chaste_interface__L_type_Ca_current__C_Ca0 * var_L_type_Ca_current__omega - (4.0 * var_L_type_Ca_current__alpha + var_L_type_Ca_current__gamma) * var_chaste_interface__L_type_Ca_current__C0; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C0 = 0.001 * var_L_type_Ca_current__C0_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C1_orig_deriv = -(3.0 * var_L_type_Ca_current__alpha + var_L_type_Ca_current__a * var_L_type_Ca_current__gamma + var_L_type_Ca_current__beta) * var_chaste_interface__L_type_Ca_current__C1 + 2.0 * var_chaste_interface__L_type_Ca_current__C2 * var_L_type_Ca_current__beta + 4.0 * var_chaste_interface__L_type_Ca_current__C0 * var_L_type_Ca_current__alpha + var_chaste_interface__L_type_Ca_current__C_Ca1 * var_L_type_Ca_current__omega / var_L_type_Ca_current__b; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C1 = 0.001 * var_L_type_Ca_current__C1_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C2_orig_deriv = -(2.0 * var_L_type_Ca_current__alpha + 2.0 * var_L_type_Ca_current__beta + pow(var_L_type_Ca_current__a, 2) * var_L_type_Ca_current__gamma) * var_chaste_interface__L_type_Ca_current__C2 + 3.0 * var_chaste_interface__L_type_Ca_current__C1 * var_L_type_Ca_current__alpha + 3.0 * var_chaste_interface__L_type_Ca_current__C3 * var_L_type_Ca_current__beta + var_chaste_interface__L_type_Ca_current__C_Ca2 * var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 2); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C2 = 0.001 * var_L_type_Ca_current__C2_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C3_orig_deriv = -(3.0 * var_L_type_Ca_current__beta + pow(var_L_type_Ca_current__a, 3) * var_L_type_Ca_current__gamma + var_L_type_Ca_current__alpha) * var_chaste_interface__L_type_Ca_current__C3 + 2.0 * var_chaste_interface__L_type_Ca_current__C2 * var_L_type_Ca_current__alpha + 4.0 * var_chaste_interface__L_type_Ca_current__C4 * var_L_type_Ca_current__beta + var_chaste_interface__L_type_Ca_current__C_Ca3 * var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 3); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C3 = 0.001 * var_L_type_Ca_current__C3_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C4_orig_deriv = var_chaste_interface__L_type_Ca_current__C3 * var_L_type_Ca_current__alpha + var_chaste_interface__L_type_Ca_current__O * var_L_type_Ca_current__g - (4.0 * var_L_type_Ca_current__beta + pow(var_L_type_Ca_current__a, 4) * var_L_type_Ca_current__gamma + var_L_type_Ca_current__f) * var_chaste_interface__L_type_Ca_current__C4 + var_chaste_interface__L_type_Ca_current__C_Ca4 * var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 4); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C4 = 0.001 * var_L_type_Ca_current__C4_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__beta_b = var_L_type_Ca_current__beta / var_L_type_Ca_current__b; // per_second
        const double var_L_type_Ca_current__C_Ca0_orig_deriv = var_chaste_interface__L_type_Ca_current__C0 * var_L_type_Ca_current__gamma + var_chaste_interface__L_type_Ca_current__C_Ca1 * var_L_type_Ca_current__beta_b - (4.0 * var_L_type_Ca_current__alpha_a + var_L_type_Ca_current__omega) * var_chaste_interface__L_type_Ca_current__C_Ca0; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca0 = 0.001 * var_L_type_Ca_current__C_Ca0_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C_Ca1_orig_deriv = -(3.0 * var_L_type_Ca_current__alpha_a + var_L_type_Ca_current__omega / var_L_type_Ca_current__b + var_L_type_Ca_current__beta_b) * var_chaste_interface__L_type_Ca_current__C_Ca1 + 2.0 * var_chaste_interface__L_type_Ca_current__C_Ca2 * var_L_type_Ca_current__beta_b + 4.0 * var_chaste_interface__L_type_Ca_current__C_Ca0 * var_L_type_Ca_current__alpha_a + var_chaste_interface__L_type_Ca_current__C1 * var_L_type_Ca_current__a * var_L_type_Ca_current__gamma; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca1 = 0.001 * var_L_type_Ca_current__C_Ca1_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C_Ca2_orig_deriv = -(2.0 * var_L_type_Ca_current__alpha_a + 2.0 * var_L_type_Ca_current__beta_b + var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 2)) * var_chaste_interface__L_type_Ca_current__C_Ca2 + 3.0 * var_chaste_interface__L_type_Ca_current__C_Ca1 * var_L_type_Ca_current__alpha_a + 3.0 * var_chaste_interface__L_type_Ca_current__C_Ca3 * var_L_type_Ca_current__beta_b + pow(var_L_type_Ca_current__a, 2) * var_chaste_interface__L_type_Ca_current__C2 * var_L_type_Ca_current__gamma; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca2 = 0.001 * var_L_type_Ca_current__C_Ca2_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C_Ca3_orig_deriv = -(3.0 * var_L_type_Ca_current__beta_b + var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 3) + var_L_type_Ca_current__alpha_a) * var_chaste_interface__L_type_Ca_current__C_Ca3 + 2.0 * var_chaste_interface__L_type_Ca_current__C_Ca2 * var_L_type_Ca_current__alpha_a + 4.0 * var_chaste_interface__L_type_Ca_current__C_Ca4 * var_L_type_Ca_current__beta_b + pow(var_L_type_Ca_current__a, 3) * var_chaste_interface__L_type_Ca_current__C3 * var_L_type_Ca_current__gamma; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca3 = 0.001 * var_L_type_Ca_current__C_Ca3_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_current__C_Ca4_orig_deriv = var_chaste_interface__L_type_Ca_current__C_Ca3 * var_L_type_Ca_current__alpha_a + var_chaste_interface__L_type_Ca_current__O_Ca * var_L_type_Ca_current__gprime - (4.0 * var_L_type_Ca_current__beta_b + var_L_type_Ca_current__omega / pow(var_L_type_Ca_current__b, 4) + var_L_type_Ca_current__fprime) * var_chaste_interface__L_type_Ca_current__C_Ca4 + pow(var_L_type_Ca_current__a, 4) * var_chaste_interface__L_type_Ca_current__C4 * var_L_type_Ca_current__gamma; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca4 = 0.001 * var_L_type_Ca_current__C_Ca4_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 47.130000000000003 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((fabs(var_fast_sodium_current_m_gate__E0_m) < 1.0000000000000001e-5) ? (1000.0 / (0.10000000000000001 - 0.0050000000000000001 * var_fast_sodium_current_m_gate__E0_m)) : (320.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 80.0 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = ((var_chaste_interface__membrane__V >= -90.0) ? ((1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m) : (0)); // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.050000000000000003; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 5.0000000000000002e-5; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__intracellular_ion_concentrations__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__intracellular_ion_concentrations__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_standard_ionic_concentrations__Cao = 2.0; // millimolar
        const double var_L_type_Ca_current__i_Ca_max = 4000.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_standard_ionic_concentrations__Cao) * var_L_type_Ca_current__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca = (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__i_Ca_max * var_chaste_interface__L_type_Ca_current_y_gate__y; // microA_per_microF
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Cao / var_chaste_interface__intracellular_ion_concentrations__Cai) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_intracellular_ion_concentrations__Ca_ss_orig_deriv = (var_RyR_channel__J_rel * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_SS - var_intracellular_Ca_fluxes__J_xfer * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_SS - 0.5 * var_L_type_Ca_current__i_Ca * var_intracellular_ion_concentrations__A_cap / (var_intracellular_ion_concentrations__V_SS * var_membrane__F)) * var_intracellular_ion_concentrations__beta_SS; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * var_intracellular_ion_concentrations__Ca_ss_orig_deriv; // millimolar / millisecond
        const double var_standard_ionic_concentrations__Nao = 138.0; // millimolar
        const double var_Na_Ca_exchanger__i_NaCa = 5000.0 * (pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * var_standard_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_standard_ionic_concentrations__Nao, 3) * var_chaste_interface__intracellular_ion_concentrations__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + var_Na_Ca_exchanger__K_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_standard_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_standard_ionic_concentrations__Cao)); // microA_per_microF
        const double var_intracellular_ion_concentrations__Cai_orig_deriv = (-var_SERCA2a_pump__J_up - var_intracellular_Ca_fluxes__J_trpn + 0.5 * (-var_calcium_background_current__i_Ca_b - var_sarcolemmal_calcium_pump__i_p_Ca + 2.0 * var_Na_Ca_exchanger__i_NaCa) * var_intracellular_ion_concentrations__A_cap / (var_intracellular_ion_concentrations__V_myo * var_membrane__F) + var_intracellular_Ca_fluxes__J_xfer) * var_intracellular_ion_concentrations__beta_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = 0.001 * var_intracellular_ion_concentrations__Cai_orig_deriv; // millimolar / millisecond
        
        rResidual[16] = rCurrentGuess[16] - rY[1] - mDt*d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        rResidual[10] = rCurrentGuess[10] - rY[8] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__O;
        rResidual[11] = rCurrentGuess[11] - rY[9] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__O_Ca;
        rResidual[0] = rCurrentGuess[0] - rY[10] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C0;
        rResidual[1] = rCurrentGuess[1] - rY[11] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C1;
        rResidual[2] = rCurrentGuess[2] - rY[12] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C2;
        rResidual[3] = rCurrentGuess[3] - rY[13] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C3;
        rResidual[4] = rCurrentGuess[4] - rY[14] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C4;
        rResidual[5] = rCurrentGuess[5] - rY[15] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C_Ca0;
        rResidual[6] = rCurrentGuess[6] - rY[16] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C_Ca1;
        rResidual[7] = rCurrentGuess[7] - rY[17] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C_Ca2;
        rResidual[8] = rCurrentGuess[8] - rY[18] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C_Ca3;
        rResidual[9] = rCurrentGuess[9] - rY[19] - mDt*d_dt_chaste_interface_var_L_type_Ca_current__C_Ca4;
        rResidual[14] = rCurrentGuess[14] - rY[21] - mDt*d_dt_chaste_interface_var_RyR_channel__P_O1;
        rResidual[15] = rCurrentGuess[15] - rY[22] - mDt*d_dt_chaste_interface_var_RyR_channel__P_O2;
        rResidual[12] = rCurrentGuess[12] - rY[23] - mDt*d_dt_chaste_interface_var_RyR_channel__P_C1;
        rResidual[13] = rCurrentGuess[13] - rY[24] - mDt*d_dt_chaste_interface_var_RyR_channel__P_C2;
        rResidual[17] = rCurrentGuess[17] - rY[25] - mDt*d_dt_chaste_interface_var_intracellular_Ca_fluxes__HTRPNCa;
        rResidual[18] = rCurrentGuess[18] - rY[26] - mDt*d_dt_chaste_interface_var_intracellular_Ca_fluxes__LTRPNCa;
        rResidual[24] = rCurrentGuess[24] - rY[27] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
        rResidual[22] = rCurrentGuess[22] - rY[28] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
        rResidual[23] = rCurrentGuess[23] - rY[29] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
        rResidual[21] = rCurrentGuess[21] - rY[30] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        rResidual[19] = rCurrentGuess[19] - rY[31] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        rResidual[20] = rCurrentGuess[20] - rY[32] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }

    void Cellwinslow_model_1999FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[25], double rJacobian[25][25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        
        double var_chaste_interface__L_type_Ca_current__C0 = rCurrentGuess[0];
        double var_chaste_interface__L_type_Ca_current__C1 = rCurrentGuess[1];
        double var_chaste_interface__L_type_Ca_current__C2 = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_current__C3 = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_current__C4 = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_current__O = rCurrentGuess[10];
        double var_chaste_interface__L_type_Ca_current__O_Ca = rCurrentGuess[11];
        double var_chaste_interface__RyR_channel__P_C1 = rCurrentGuess[12];
        double var_chaste_interface__RyR_channel__P_O1 = rCurrentGuess[14];
        double var_chaste_interface__RyR_channel__P_O2 = rCurrentGuess[15];
        double var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa = rCurrentGuess[17];
        double var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa = rCurrentGuess[18];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rCurrentGuess[19];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rCurrentGuess[20];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rCurrentGuess[21];
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rCurrentGuess[22];
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rCurrentGuess[24];
        
        const double var_x0 = exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x1 = 1.6000000000000001 * var_x0;
        const double var_x2 = -var_x1;
        const double var_x3 = 0.10375 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x4 = exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x5 = 0.050000000000000003 * var_x4;
        const double var_x6 = 0.10375 * var_chaste_interface__L_type_Ca_current__C0;
        const double var_x7 = 1.2 * var_x0;
        const double var_x8 = -var_x5;
        const double var_x9 = 0.20749999999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x10 = 0.10000000000000001 * var_x4;
        const double var_x11 = 0.20749999999999999 * var_chaste_interface__L_type_Ca_current__C1;
        const double var_x12 = -var_x10;
        const double var_x13 = 0.80000000000000004 * var_x0;
        const double var_x14 = -var_x13;
        const double var_x15 = 0.41499999999999998 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x16 = 0.14999999999999999 * var_x4;
        const double var_x17 = 0.41499999999999998 * var_chaste_interface__L_type_Ca_current__C2;
        const double var_x18 = 0.40000000000000002 * var_x0;
        const double var_x19 = 0.82999999999999996 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x20 = 0.20000000000000001 * var_x4;
        const double var_x21 = 0.82999999999999996 * var_chaste_interface__L_type_Ca_current__C3;
        const double var_x22 = 1.6599999999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x23 = 1.6599999999999999 * var_chaste_interface__L_type_Ca_current__C4;
        const double var_x24 = 3.2000000000000002 * var_x0;
        const double var_x25 = 0.025000000000000001 * var_x4;
        const double var_x26 = 2.3999999999999999 * var_x0;
        const double var_x27 = 0.074999999999999997 * var_x4;
        const double var_x28 = 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0);
        const double var_x29 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0);
        const double var_x30 = 48600000000.0 * var_x29 * var_chaste_interface__RyR_channel__P_C1;
        const double var_x31 = 4050000.0 * var_x29;
        const double var_x32 = 12150000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 2.0) * var_chaste_interface__RyR_channel__P_O1;
        const double var_x33 = -80.0 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x34 = var_chaste_interface__membrane__V >= -90.0;
        const double var_x35 = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_x36 = 0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR;
        const double var_x37 = pow(var_x36, (-2));
        const double var_x38 = 1 / (1.0 + 12.0 * var_x37);
        const double var_x39 = 0.001 * var_x38;
        const double var_x40 = var_x39 * (1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR);
        const double var_x41 = 1800.0 * var_chaste_interface__RyR_channel__P_O1;
        const double var_x42 = 1800.0 * var_chaste_interface__RyR_channel__P_O2;
        const double var_x43 = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__RyR_channel__P_O1 + var_chaste_interface__RyR_channel__P_O2);
        const double var_x44 = pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 1.2);
        const double var_x45 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0);
        const double var_x46 = 1 / (1.0 + 33855.471141425078 * var_x44 + 0.303951367781155 * var_x45);
        const double var_x47 = 2752.4498037978587 * var_x44 - 0.096656534954407292 * var_x45;
        const double var_x48 = var_x47 / pow((2.9537323401073989e-5 + var_x44 + 8.9779098483507565e-6 * var_x45), 2);
        const double var_x49 = pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 0.19999999999999996);
        const double var_x50 = var_x46 * var_x49;
        const double var_x51 = var_x48 * var_x49;
        const double var_x52 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x53 = 1.0 + 0.00011900000000000002 / pow(var_x52, 2);
        const double var_x54 = 1 / var_x53;
        const double var_x55 = exp(0.074867781645490947 * var_chaste_interface__membrane__V);
        const double var_x56 = (-0.68200000000000005 + 0.001 * var_x55) * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / (-1.0 + var_x55);
        const double var_x57 = -2.9908119021922683 * var_x54 * var_x56;
        const double var_x58 = 0.001 * var_x54;
        const double var_x59 = var_x58 * (240000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 240000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss);
        const double var_x60 = 240000.0 * var_chaste_interface__RyR_channel__P_O1;
        const double var_x61 = 240000.0 * var_chaste_interface__RyR_channel__P_O2;
        const double var_x62 = 2800.0000000000005 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        const double var_x63 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Cai;
        const double var_x64 = 1.0 + 0.00011900000000000002 / pow(var_x63, 2);
        const double var_x65 = 1 / var_x64;
        const double var_x66 = 0.001 * var_x65;
        const double var_x67 = 5.0000000000000002e-5 + var_chaste_interface__intracellular_ion_concentrations__Cai;
        const double var_x68 = 0.0015381954438488301 / var_x67;
        const double var_x69 = 1 / var_chaste_interface__intracellular_ion_concentrations__Cai;
        const double var_x70 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
        const double var_x71 = 1 / (1.0 + 0.20000000000000001 * var_x70);
        const double var_x72 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
        
        
        rJacobian[0][0] = 1.0 - (mDt * (var_x2 - var_x3));
        rJacobian[0][1] = -(mDt * (var_x5));
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = -(mDt * (0.01));
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = 0.0;
        rJacobian[0][15] = 0.0;
        rJacobian[0][16] = 0.0;
        rJacobian[0][17] = 0.0;
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = -(mDt * (-var_x6));
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = 0.0;
        rJacobian[0][24] = 0.0;
        rJacobian[1][0] = -(mDt * (var_x1));
        rJacobian[1][1] = 1.0 - (mDt * (var_x8 - var_x7 - var_x9));
        rJacobian[1][2] = -(mDt * (var_x10));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = -(mDt * (0.0050000000000000001));
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = 0.0;
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = -(mDt * (-var_x11));
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (var_x7));
        rJacobian[2][2] = 1.0 - (mDt * (var_x12 + var_x14 - var_x15));
        rJacobian[2][3] = -(mDt * (var_x16));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = -(mDt * (0.0025000000000000001));
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = 0.0;
        rJacobian[2][15] = 0.0;
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = -(mDt * (-var_x17));
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = -(mDt * (var_x13));
        rJacobian[3][3] = 1.0 - (mDt * (-var_x16 - var_x18 - var_x19));
        rJacobian[3][4] = -(mDt * (var_x20));
        rJacobian[3][5] = 0.0;
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = -(mDt * (0.00125));
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = 0.0;
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = -(mDt * (-var_x21));
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (var_x18));
        rJacobian[4][4] = 1.0 - (mDt * (-0.29999999999999999 - var_x20 - var_x22));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = -(mDt * (0.00062500000000000001));
        rJacobian[4][10] = -(mDt * (2.0));
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = 0.0;
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = 0.0;
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = -(mDt * (-var_x23));
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[5][0] = -(mDt * (var_x3));
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-0.01 - var_x24));
        rJacobian[5][6] = -(mDt * (var_x25));
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = 0.0;
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = -(mDt * (var_x6));
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = -(mDt * (var_x9));
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = -(mDt * (var_x24));
        rJacobian[6][6] = 1.0 - (mDt * (-0.0050000000000000001 - var_x25 - var_x26));
        rJacobian[6][7] = -(mDt * (var_x5));
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = -(mDt * (var_x11));
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = -(mDt * (var_x15));
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = -(mDt * (var_x26));
        rJacobian[7][7] = 1.0 - (mDt * (-0.0025000000000000001 + var_x2 + var_x8));
        rJacobian[7][8] = -(mDt * (var_x27));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = -(mDt * (var_x17));
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = -(mDt * (var_x19));
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = -(mDt * (var_x1));
        rJacobian[8][8] = 1.0 - (mDt * (-0.00125 + var_x14 - var_x27));
        rJacobian[8][9] = -(mDt * (var_x10));
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = 0.0;
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = -(mDt * (var_x21));
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = -(mDt * (var_x22));
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = -(mDt * (var_x13));
        rJacobian[9][9] = 1.0 - (mDt * (-0.0076249999999999998 + var_x12));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = -(mDt * (7.0));
        rJacobian[9][12] = 0.0;
        rJacobian[9][13] = 0.0;
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = 0.0;
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = -(mDt * (var_x23));
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = -(mDt * (0.29999999999999999));
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (-2.0));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = 0.0;
        rJacobian[10][15] = 0.0;
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = -(mDt * (0.0070000000000000001));
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (-7.0));
        rJacobian[11][12] = 0.0;
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = 0.0;
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = 0.0;
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (-var_x28));
        rJacobian[12][13] = 0.0;
        rJacobian[12][14] = -(mDt * (0.57599999999999996));
        rJacobian[12][15] = 0.0;
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = 0.0;
        rJacobian[12][21] = -(mDt * (-var_x30));
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = 0.0;
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = 0.0;
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = 0.0;
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = 0.0;
        rJacobian[13][13] = 1.0 - (mDt * (-0.00080000000000000004));
        rJacobian[13][14] = -(mDt * (0.10000000000000001));
        rJacobian[13][15] = 0.0;
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = 0.0;
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = -(mDt * (var_x28));
        rJacobian[14][13] = -(mDt * (0.00080000000000000004));
        rJacobian[14][14] = 1.0 - (mDt * (-0.67600000000000005 - var_x31));
        rJacobian[14][15] = -(mDt * (1.9299999999999999));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = 0.0;
        rJacobian[14][21] = -(mDt * (var_x30 - var_x32));
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = 0.0;
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = 0.0;
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = 0.0;
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = 0.0;
        rJacobian[15][12] = 0.0;
        rJacobian[15][13] = 0.0;
        rJacobian[15][14] = -(mDt * (var_x31));
        rJacobian[15][15] = 1.0 - (mDt * (-1.9299999999999999));
        rJacobian[15][16] = 0.0;
        rJacobian[15][17] = 0.0;
        rJacobian[15][18] = 0.0;
        rJacobian[15][19] = 0.0;
        rJacobian[15][20] = 0.0;
        rJacobian[15][21] = -(mDt * (var_x32));
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = 0.0;
        rJacobian[16][0] = 0.0;
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = 0.0;
        rJacobian[16][5] = 0.0;
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = 0.0;
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = 0.0;
        rJacobian[16][16] = 1.0 - (mDt * (0.001 * (((var_x34) && (fabs(var_x35) < 1.0000000000000001e-5)) ? (var_x33 - 1000.0 / (-0.13565000000000002 - 0.0050000000000000001 * var_chaste_interface__membrane__V)) : ((var_x34) ? (var_x33 - 320.0 * var_x35 / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V))) : (0)))));
        rJacobian[16][17] = 0.0;
        rJacobian[16][18] = 0.0;
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = 0.0;
        rJacobian[16][21] = 0.0;
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = 0.0;
        rJacobian[16][24] = 0.0;
        rJacobian[17][0] = 0.0;
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = 0.0;
        rJacobian[17][5] = 0.0;
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = 0.0;
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = 0.0;
        rJacobian[17][16] = 0.0;
        rJacobian[17][17] = 1.0 - (mDt * (-6.6000000000000005e-5 - 20.0 * var_chaste_interface__intracellular_ion_concentrations__Cai));
        rJacobian[17][18] = 0.0;
        rJacobian[17][19] = 0.0;
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = 0.0;
        rJacobian[17][22] = -(mDt * (20.0 - 20.0 * var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa));
        rJacobian[17][23] = 0.0;
        rJacobian[17][24] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = 0.0;
        rJacobian[18][15] = 0.0;
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = 0.0;
        rJacobian[18][18] = 1.0 - (mDt * (-0.040000000000000001 - 40.0 * var_chaste_interface__intracellular_ion_concentrations__Cai));
        rJacobian[18][19] = 0.0;
        rJacobian[18][20] = 0.0;
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = -(mDt * (40.0 - 40.0 * var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa));
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = -(mDt * (var_x40));
        rJacobian[19][15] = -(mDt * (var_x40));
        rJacobian[19][16] = 0.0;
        rJacobian[19][17] = 0.0;
        rJacobian[19][18] = 0.0;
        rJacobian[19][19] = 1.0 - (mDt * (var_x39 * (-1740.0382808421784 - var_x41 - var_x42) + 0.00016666666666666666 * (1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR - 1800.0 * var_x43 - 1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) / (pow(var_x36, 3) * pow((0.083333333333333329 + var_x37), 2))));
        rJacobian[19][20] = -(mDt * (1.7400382808421784 * var_x38));
        rJacobian[19][21] = -(mDt * (var_x39 * (var_x41 + var_x42)));
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = 0.0;
        rJacobian[19][24] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = 0.0;
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = 0.0;
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = 0.0;
        rJacobian[20][19] = -(mDt * (0.13257434520702313));
        rJacobian[20][20] = 1.0 - (mDt * (-0.13257434520702313 - 0.0011893356491532784 * var_x46 - 3.2630189260961817e-12 * var_x48));
        rJacobian[20][21] = 0.0;
        rJacobian[20][22] = -(mDt * (40.641887388649529 * var_x50 - 4.361396781050011e-7 * var_x51));
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = -(mDt * (var_x57));
        rJacobian[21][11] = -(mDt * (var_x57));
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = -(mDt * (var_x59));
        rJacobian[21][15] = -(mDt * (var_x59));
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = 0.0;
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = -(mDt * (var_x58 * (var_x60 + var_x61)));
        rJacobian[21][20] = 0.0;
        rJacobian[21][21] = 1.0 - (mDt * (var_x58 * (-806491.88514357049 - var_x60 - var_x61) + 2.3800000000000004e-7 * (806491.88514357049 * var_chaste_interface__intracellular_ion_concentrations__Cai + 240000.0 * var_x43 - 806491.88514357049 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 2990.8119021922685 * var_x56 * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca)) / (pow(var_x52, 3) * pow(var_x53, 2))));
        rJacobian[21][22] = -(mDt * (806.49188514357047 * var_x54));
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = 0.0;
        rJacobian[22][11] = 0.0;
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = 0.0;
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = -(mDt * (var_x66 * (0.0092400000000000017 + var_x62)));
        rJacobian[22][18] = -(mDt * (var_x66 * (2.8000000000000003 + var_x62)));
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = -(mDt * (var_x66 * (0.096656534954407292 * var_x46 + 2.651834266564234e-10 * var_x48)));
        rJacobian[22][21] = -(mDt * (0.037453183520599252 * var_x65));
        rJacobian[22][22] = 1.0 - (mDt * (var_x66 * (-5637.4531835205999 - var_x68 + 3.5444788081288787e-5 * var_x51 + 2800.0000000000005 * var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa + 2800.0000000000005 * var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa - 0.00015787156411954756 * var_x69 - 3302.9397645574304 * var_x50 + 0.0015381954438488301 * var_chaste_interface__intracellular_ion_concentrations__Cai / pow(var_x67, 2) - 21.758727097510118 * var_x70 * var_x71) + 2.3800000000000004e-7 * (2.8000000000000003 * var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa + 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss + 0.0092400000000000017 * var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa + 0.00015787156411954756 * log(2.0 * var_x69) - 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Cai - 1.181949379053441e-5 * var_chaste_interface__membrane__V - var_x62 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa) - var_x62 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa) - var_x68 * var_chaste_interface__intracellular_ion_concentrations__Cai + 8.279349689624225e-6 * var_x71 * (2.0 * var_x72 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) - 2628072.0 * var_x70 * var_chaste_interface__intracellular_ion_concentrations__Cai) - 1.0 * var_x46 * var_x47) / (pow(var_x63, 3) * pow(var_x64, 2))));
        rJacobian[22][23] = 0.0;
        rJacobian[22][24] = -(mDt * (4.9676098137745351e-8 * var_x65 * var_x71 * var_x72 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2)));
        rJacobian[23][0] = 0.0;
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = 0.0;
        rJacobian[23][11] = 0.0;
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = 0.0;
        rJacobian[23][16] = 0.0;
        rJacobian[23][17] = 0.0;
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = 0.0;
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = 0.0;
        rJacobian[23][23] = 1.0;
        rJacobian[23][24] = 0.0;
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = 0.0;
        rJacobian[24][16] = 0.0;
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = 0.0;
        rJacobian[24][23] = 0.0;
        rJacobian[24][24] = 1.0;
    }

    void Cellwinslow_model_1999FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr = rY[4];
        // Units: dimensionless; Initial value: 0.51
        double var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks = rY[5];
        // Units: dimensionless; Initial value: 0.264
        double var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 = rY[6];
        // Units: dimensionless; Initial value: 2.63
        double var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 = rY[7];
        // Units: dimensionless; Initial value: 0.99
        double var_chaste_interface__L_type_Ca_current__O = rY[8];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_current__O_Ca = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[27];
        // Units: millimolar; Initial value: 10.0
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[28];
        // Units: millimolar; Initial value: 8e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[29];
        // Units: millimolar; Initial value: 157.8
        
        const double var_L_type_Ca_current__P_Ca = 0.00031250000000000001; // cm_per_second
        const double var_L_type_Ca_current__P_K = 5.7899999999999998e-7; // cm_per_second
        const double var_L_type_Ca_current__i_Ca_half = -0.26500000000000001; // microA_per_microF
        const double var_Na_Ca_exchanger__K_NaCa = 0.29999999999999999; // microA_per_microF
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // millimolar
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // millimolar
        const double var_Na_Ca_exchanger__K_sat = 0.20000000000000001; // dimensionless
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.00038420000000000001; // milliS_per_microF
        const double var_fast_sodium_current__g_Na = 12.800000000000001; // milliS_per_microF
        const double var_membrane__C_sc = 0.001; // microF_per_cm2
        const double var_membrane__F = 96.485341500000004; // coulomb_per_millimole
        const double var_membrane__R = 8.3144720000000003; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_plateau_potassium_current__g_Kp = 0.0022160000000000001; // milliS_per_microF
        const double var_plateau_potassium_current_Kp_gate__Kp_V = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__R_V = 1 / (1.0 + 1.4944999999999999 * exp(0.044600000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__g_Kr = 0.0033999999999999998; // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.050000000000000003; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 5.0000000000000002e-5; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__intracellular_ion_concentrations__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__intracellular_ion_concentrations__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_slow_activating_delayed_rectifiyer_K_current__g_Ks = 0.0027133999999999999; // milliS_per_microF
        const double var_sodium_background_current__g_Nab = 0.0030999999999999999; // milliS_per_microF
        const double var_sodium_potassium_pump__I_NaK = 0.69299999999999995; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_standard_ionic_concentrations__Cao = 2.0; // millimolar
        const double var_L_type_Ca_current__i_Ca_max = 4000.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_standard_ionic_concentrations__Cao) * var_L_type_Ca_current__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca = (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__i_Ca_max * var_chaste_interface__L_type_Ca_current_y_gate__y; // microA_per_microF
        const double var_L_type_Ca_current__p_prime_k = var_L_type_Ca_current__P_K / (1.0 + var_L_type_Ca_current__i_Ca_max / var_L_type_Ca_current__i_Ca_half); // cm_per_second
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Cao / var_chaste_interface__intracellular_ion_concentrations__Cai) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_standard_ionic_concentrations__Ko = 4.0; // millimolar
        const double var_L_type_Ca_current__i_Ca_K = pow(var_membrane__F, 2) * (-var_standard_ionic_concentrations__Ko + var_chaste_interface__intracellular_ion_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__p_prime_k * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ko / var_chaste_interface__intracellular_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_plateau_potassium_current__i_Kp = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__g_Kp * var_plateau_potassium_current_Kp_gate__Kp_V; // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__f_Ko = 0.5 * sqrt(var_standard_ionic_concentrations__Ko); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current__i_Kr = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_rapid_activating_delayed_rectifiyer_K_current__R_V * var_rapid_activating_delayed_rectifiyer_K_current__f_Ko * var_rapid_activating_delayed_rectifiyer_K_current__g_Kr * var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr; // microA_per_microF
        const double var_standard_ionic_concentrations__Nao = 138.0; // millimolar
        const double var_Na_Ca_exchanger__i_NaCa = 5000.0 * (pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * var_standard_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_standard_ionic_concentrations__Nao, 3) * var_chaste_interface__intracellular_ion_concentrations__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + var_Na_Ca_exchanger__K_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_standard_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_standard_ionic_concentrations__Cao)); // microA_per_microF
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Nao / var_chaste_interface__intracellular_ion_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_slow_activating_delayed_rectifiyer_K_current__E_Ks = var_membrane__R * var_membrane__T * log((var_standard_ionic_concentrations__Ko + 0.018329999999999999 * var_standard_ionic_concentrations__Nao) / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.018329999999999999 * var_chaste_interface__intracellular_ion_concentrations__Nai)) / var_membrane__F; // millivolt
        const double var_slow_activating_delayed_rectifiyer_K_current__i_Ks = pow(var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks, 2) * (-var_slow_activating_delayed_rectifiyer_K_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_activating_delayed_rectifiyer_K_current__g_Ks; // microA_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK * var_standard_ionic_concentrations__Ko / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__intracellular_ion_concentrations__Nai), 1.5)) * (var_sodium_potassium_pump__K_mKo + var_standard_ionic_concentrations__Ko)); // microA_per_microF
        const double var_time_independent_potassium_current__K_mK1 = 13.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 2.7999999999999998; // milliS_per_microF
        const double var_time_independent_potassium_current_K1_gate__K1_infinity_V = 1 / (2.0 + exp(1.5 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_standard_ionic_concentrations__Ko * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity_V / (var_standard_ionic_concentrations__Ko + var_time_independent_potassium_current__K_mK1); // microA_per_microF
        const double var_transient_outward_potassium_current__g_to1 = 0.23815; // milliS_per_microF
        const double var_transient_outward_potassium_current__i_to1 = (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_potassium_current__g_to1 * var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 * var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1; // microA_per_microF
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_current__i_Ca + var_L_type_Ca_current__i_Ca_K + var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_membrane__i_Stim + var_plateau_potassium_current__i_Kp + var_rapid_activating_delayed_rectifiyer_K_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_activating_delayed_rectifiyer_K_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_potassium_current__i_to1) / var_membrane__C_sc; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellwinslow_model_1999FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr = rY[4];
        // Units: dimensionless; Initial value: 0.51
        double var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks = rY[5];
        // Units: dimensionless; Initial value: 0.264
        double var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 = rY[6];
        // Units: dimensionless; Initial value: 2.63
        double var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 = rY[7];
        // Units: dimensionless; Initial value: 0.99
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        
        const double var_L_type_Ca_current_y_gate__tau_y = 0.02 + 0.59999999999999998 / (1.0 + exp(2.1052631578947367 + 0.10526315789473684 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_y_gate__y_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(2.5 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (135.0 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0));
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (3560.0 * exp(0.079000000000000001 * var_chaste_interface__membrane__V) + 310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V)) : (7692.3076923076924 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? (1000.0 * (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0));
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (121.2 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (300.0 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V))));
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K12 = exp(-5.4950000000000001 + 0.1691 * var_chaste_interface__membrane__V);
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K21 = exp(-7.6769999999999996 - 0.012800000000000001 * var_chaste_interface__membrane__V);
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr_inf = var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K12 / (var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K12 + var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K21);
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_factor = 1.0;
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_X_kr = 0.001 / (var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K12 + var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__K21) + 0.027 * var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_factor;
        const double var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks_infinity = 1 / (1.0 + exp(1.8161764705882353 - 0.073529411764705885 * var_chaste_interface__membrane__V));
        const double var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__tau_X_ks = 0.001 / (0.00013100000000000001 * (-10.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-0.68699999999999994 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (-10.0 + var_chaste_interface__membrane__V) / (1.0 - exp(1.48 - 0.14799999999999999 * var_chaste_interface__membrane__V)));
        const double var_transient_outward_potassium_current_X_to1_gate__alpha_X_to1 = 45.159999999999997 * exp(0.035770000000000003 * var_chaste_interface__membrane__V);
        const double var_transient_outward_potassium_current_X_to1_gate__beta_X_to1 = 98.900000000000006 * exp(-0.062370000000000002 * var_chaste_interface__membrane__V);
        const double var_transient_outward_potassium_current_Y_to1_gate__alpha_Y_to1 = 5.415 * exp(-6.7000000000000002 - 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(-6.7000000000000002 - 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_transient_outward_potassium_current_Y_to1_gate__beta_Y_to1 = 5.415 * exp(6.7000000000000002 + 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(6.7000000000000002 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        
        
        rY[20] = (var_chaste_interface__L_type_Ca_current_y_gate__y + ((0.001 * var_L_type_Ca_current_y_gate__y_infinity / var_L_type_Ca_current_y_gate__tau_y) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_current_y_gate__tau_y) * mDt));
        rY[2] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((0.001 * var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_h_gate__alpha_h - 0.001 * var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[3] = (var_chaste_interface__fast_sodium_current_j_gate__j + ((0.001 * var_fast_sodium_current_j_gate__alpha_j) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_j_gate__alpha_j - 0.001 * var_fast_sodium_current_j_gate__beta_j) * mDt));
        rY[4] = (var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr + ((0.001 * var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr_inf / var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_X_kr) * mDt)) / (1.0 - ((-0.001 / var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_X_kr) * mDt));
        rY[5] = (var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks + ((0.001 * var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks_infinity / var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__tau_X_ks) * mDt)) / (1.0 - ((-0.001 / var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__tau_X_ks) * mDt));
        rY[6] = (var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 + ((0.001 * var_transient_outward_potassium_current_X_to1_gate__alpha_X_to1) * mDt)) / (1.0 - ((-0.001 * var_transient_outward_potassium_current_X_to1_gate__alpha_X_to1 - 0.001 * var_transient_outward_potassium_current_X_to1_gate__beta_X_to1) * mDt));
        rY[7] = (var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 + ((0.001 * var_transient_outward_potassium_current_Y_to1_gate__alpha_Y_to1) * mDt)) / (1.0 - ((-0.001 * var_transient_outward_potassium_current_Y_to1_gate__alpha_Y_to1 - 0.001 * var_transient_outward_potassium_current_Y_to1_gate__beta_Y_to1) * mDt));
        
        double _guess[25] = {rY[10],rY[11],rY[12],rY[13],rY[14],rY[15],rY[16],rY[17],rY[18],rY[19],rY[8],rY[9],rY[23],rY[24],rY[21],rY[22],rY[1],rY[25],rY[26],rY[31],rY[32],rY[30],rY[28],rY[29],rY[27]};
        CardiacNewtonSolver<25,Cellwinslow_model_1999FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<25,Cellwinslow_model_1999FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[10] = _guess[0];
        rY[11] = _guess[1];
        rY[12] = _guess[2];
        rY[13] = _guess[3];
        rY[14] = _guess[4];
        rY[15] = _guess[5];
        rY[16] = _guess[6];
        rY[17] = _guess[7];
        rY[18] = _guess[8];
        rY[19] = _guess[9];
        rY[8] = _guess[10];
        rY[9] = _guess[11];
        rY[23] = _guess[12];
        rY[24] = _guess[13];
        rY[21] = _guess[14];
        rY[22] = _guess[15];
        rY[1] = _guess[16];
        rY[25] = _guess[17];
        rY[26] = _guess[18];
        rY[31] = _guess[19];
        rY[32] = _guess[20];
        rY[30] = _guess[21];
        rY[28] = _guess[22];
        rY[29] = _guess[23];
        rY[27] = _guess[24];
    }

    std::vector<double> Cellwinslow_model_1999FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellwinslow_model_1999FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "winslow_model_1999";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-96.1638);

    // rY[1]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0328302);

    // rY[2]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.988354);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99254);

    // rY[4]:
    this->mVariableNames.push_back("rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.51);

    // rY[5]:
    this->mVariableNames.push_back("slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.264);

    // rY[6]:
    this->mVariableNames.push_back("transient_outward_potassium_current_X_to1_gate__X_to1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.63);

    // rY[7]:
    this->mVariableNames.push_back("transient_outward_potassium_current_Y_to1_gate__Y_to1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.84546e-21);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_current__O_Ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_current__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.997208);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_current__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.38897e-05);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.535e-09);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.63909e-14);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.56337e-20);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00272826);

    // rY[16]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.99215e-07);

    // rY[17]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.71989e-11);

    // rY[18]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.87031e-15);

    // rY[19]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.59752e-20);

    // rY[20]:
    this->mVariableNames.push_back("L_type_Ca_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.798);

    // rY[21]:
    this->mVariableNames.push_back("RyR_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("RyR_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[23]:
    this->mVariableNames.push_back("RyR_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.47);

    // rY[24]:
    this->mVariableNames.push_back("RyR_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.53);

    // rY[25]:
    this->mVariableNames.push_back("intracellular_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.98);

    // rY[26]:
    this->mVariableNames.push_back("intracellular_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.078);

    // rY[27]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.0);

    // rY[28]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Cai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8e-05);

    // rY[29]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(157.8);

    // rY[30]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00011);

    // rY[31]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.257);

    // rY[32]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.257);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellwinslow_model_1999FromCellMLBackwardEuler)

