//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: viswanathan_model_1999_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "viswanathan_model_1999_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -25.5 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::Cellviswanathan_model_1999_epiFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<12>(
                25,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellviswanathan_model_1999_epiFromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.001; // (var_membrane__Cm) [microF]
    }

    Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::~Cellviswanathan_model_1999_epiFromCellMLBackwardEuler()
    {
    }
    
    double Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__calcium_dynamics__Cai = rY[1];
        // Units: millimolar; Initial value: 0.00035237
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = rY[7];
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = rY[8];
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = rY[9];
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = rY[10];
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = rY[11];
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = rY[12];
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = rY[13];
        // Units: dimensionless; Initial value: 0.985232
        double var_chaste_interface__ionic_concentrations__Nai = rY[23];
        // Units: millimolar; Initial value: 15.6748357
        double var_chaste_interface__ionic_concentrations__Ki = rY[24];
        // Units: millimolar; Initial value: 137.6244
        
        const double var_ATP_sensitive_potassium_current__ATPi = 3.0; // millimolar
        const double var_ATP_sensitive_potassium_current__hATP = 2.0; // dimensionless
        const double var_ATP_sensitive_potassium_current__kATP = 0.00025000000000000001; // millimolar
        const double var_ATP_sensitive_potassium_current__nATP = 0.23999999999999999; // dimensionless
        const double var_ATP_sensitive_potassium_current__nicholsarea = 5.0000000000000002e-5; // dimensionless
        const double var_ATP_sensitive_potassium_current__g_K_ATP = 0.000193 / var_ATP_sensitive_potassium_current__nicholsarea; // milliS_per_microF
        const double var_ATP_sensitive_potassium_current__pATP = 1 / (1.0 + pow((var_ATP_sensitive_potassium_current__ATPi / var_ATP_sensitive_potassium_current__kATP), var_ATP_sensitive_potassium_current__hATP)); // dimensionless
        const double var_L_type_Ca_channel__P_Ca = 0.00054000000000000001; // cm_per_second
        const double var_L_type_Ca_channel__P_K = 1.9299999999999999e-7; // cm_per_second
        const double var_L_type_Ca_channel__P_Na = 6.75e-7; // cm_per_second
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // millimolar
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // millimolar
        const double var_Na_Ca_exchanger__d_NaCa = 0.001; // millimolar
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_T_type_Ca_channel__g_CaT = 0.050000000000000003; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.003016; // milliS_per_microF
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + var_chaste_interface__calcium_dynamics__Cai / var_L_type_Ca_channel_f_Ca_gate__Km_Ca); // dimensionless
        const double var_calcium_dynamics__Cao = 1.8; // millimolar
        const double var_fast_sodium_current__g_Na = 16.0; // milliS_per_microF
        const double var_ionic_concentrations__Ko = 4.5; // millimolar
        const double var_ATP_sensitive_potassium_current__GKbaraATP = pow((0.25 * var_ionic_concentrations__Ko), var_ATP_sensitive_potassium_current__nATP) * var_ATP_sensitive_potassium_current__g_K_ATP * var_ATP_sensitive_potassium_current__pATP; // milliS_per_microF
        const double var_ionic_concentrations__Nao = 132.0; // millimolar
        const double var_membrane__F = 96485.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Cao / var_chaste_interface__calcium_dynamics__Cai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * var_calcium_dynamics__Cao + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__calcium_dynamics__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // microA_per_microF
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai) * (1.0 + (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao + pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai) * var_Na_Ca_exchanger__d_NaCa)); // microA_per_microF
        const double var_T_type_Ca_channel__i_Ca_T = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_CaT * var_chaste_interface__T_type_Ca_channel_g_gate__g; // microA_per_microF
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // millimolar
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 0; // cm_per_second
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // microA_per_microF
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.0055199999999999997; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__Rect = 1 / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.011248864963317985 * sqrt(var_ionic_concentrations__Ko); // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 1.1499999999999999; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_dynamics__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_dynamics__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_slow_delayed_rectifier_potassium_current__PNaK = 0.018329999999999999; // dimensionless
        const double var_slow_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_slow_delayed_rectifier_potassium_current__PNaK + var_ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_slow_delayed_rectifier_potassium_current__PNaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.433 + 0.25979999999999998 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__calcium_dynamics__Cai, 1.3999999999999999)); // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = (-var_slow_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2; // microA_per_microF
        const double var_sodium_background_current__g_Nab = 0.0040000000000000001; // milliS_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__I_NaK = 2.0; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow(var_sodium_potassium_pump__K_mNai, 2) / pow(var_chaste_interface__ionic_concentrations__Nai, 2)) * (var_ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // microA_per_microF
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_ATP_sensitive_potassium_current__i_K_ATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_ATP_sensitive_potassium_current__GKbaraATP; // microA_per_microF
        const double var_plateau_potassium_current__i_Kp = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // microA_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifier_potassium_current__Rect * var_rapid_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr; // microA_per_microF
        const double var_time_independent_potassium_current__g_K1 = 0.3227486121839514 * sqrt(var_ionic_concentrations__Ko); // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1020.0 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K)); // per_second
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = 1000.0 * (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_second
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_microF
        const double var_transient_outward_current__g_to = 0; // milliS_per_microF
        const double var_transient_outward_current__rvdv = exp(0.01 * var_chaste_interface__membrane__V); // dimensionless
        const double var_transient_outward_current__i_to = pow(var_chaste_interface__transient_outward_current_zdv_gate__zdv, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_transient_outward_current__rvdv * var_chaste_interface__transient_outward_current_ydv_gate__ydv; // microA_per_microF
        const double var_chaste_interface__i_ionic = -(var_ATP_sensitive_potassium_current__i_K_ATP + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_non_specific_calcium_activated_current__i_ns_Ca + var_plateau_potassium_current__i_Kp + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[12], double rResidual[12])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = rY[7];
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = rY[8];
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = rY[9];
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = rY[10];
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = rY[11];
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = rY[12];
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = rY[13];
        // Units: dimensionless; Initial value: 0.985232
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__calcium_dynamics__APtrack = rCurrentGuess[0];
        double var_chaste_interface__calcium_dynamics__APtrack2 = rCurrentGuess[1];
        double var_chaste_interface__calcium_dynamics__APtrack3 = rCurrentGuess[2];
        double var_chaste_interface__calcium_dynamics__Ca_JSR = rCurrentGuess[3];
        double var_chaste_interface__calcium_dynamics__Ca_NSR = rCurrentGuess[4];
        double var_chaste_interface__calcium_dynamics__Cai = rCurrentGuess[5];
        double var_chaste_interface__calcium_dynamics__Cainfluxtrack = rCurrentGuess[6];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack = rCurrentGuess[7];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack2 = rCurrentGuess[8];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack3 = rCurrentGuess[9];
        double var_chaste_interface__ionic_concentrations__Ki = rCurrentGuess[10];
        double var_chaste_interface__ionic_concentrations__Nai = rCurrentGuess[11];
        
        //output_equations
        const double var_ATP_sensitive_potassium_current__ATPi = 3.0; // millimolar
        const double var_ATP_sensitive_potassium_current__hATP = 2.0; // dimensionless
        const double var_ATP_sensitive_potassium_current__kATP = 0.00025000000000000001; // millimolar
        const double var_ATP_sensitive_potassium_current__nATP = 0.23999999999999999; // dimensionless
        const double var_ATP_sensitive_potassium_current__nicholsarea = 5.0000000000000002e-5; // dimensionless
        const double var_ATP_sensitive_potassium_current__g_K_ATP = 0.000193 / var_ATP_sensitive_potassium_current__nicholsarea; // milliS_per_microF
        const double var_ATP_sensitive_potassium_current__pATP = 1 / (1.0 + pow((var_ATP_sensitive_potassium_current__ATPi / var_ATP_sensitive_potassium_current__kATP), var_ATP_sensitive_potassium_current__hATP)); // dimensionless
        const double var_L_type_Ca_channel__P_Ca = 0.00054000000000000001; // cm_per_second
        const double var_L_type_Ca_channel__P_K = 1.9299999999999999e-7; // cm_per_second
        const double var_L_type_Ca_channel__P_Na = 6.75e-7; // cm_per_second
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // millimolar
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // millimolar
        const double var_Na_Ca_exchanger__d_NaCa = 0.001; // millimolar
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_T_type_Ca_channel__g_CaT = 0.050000000000000003; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.003016; // milliS_per_microF
        const double var_calcium_dynamics__APtrack2_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001)) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack2) : (-500.0 * var_chaste_interface__calcium_dynamics__APtrack2)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack2 = 0.001 * var_calcium_dynamics__APtrack2_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__APtrack3_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001)) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack3) : (-10.0 * var_chaste_interface__calcium_dynamics__APtrack3)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack3 = 0.001 * var_calcium_dynamics__APtrack3_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__CMDN_max = 0.050000000000000003; // millimolar
        const double var_calcium_dynamics__CSQN_max = 10.0; // millimolar
        const double var_calcium_dynamics__CSQNthresh = 0.69999999999999996; // millimolar
        const double var_calcium_dynamics__Ca_NSR_max = 15.0; // millimolar
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + var_chaste_interface__calcium_dynamics__Cai / var_L_type_Ca_channel_f_Ca_gate__Km_Ca); // dimensionless
        const double var_calcium_dynamics__Cao = 1.8; // millimolar
        const double var_calcium_dynamics__G_rel_max = 60000.0; // per_second
        const double var_calcium_dynamics__G_rel_overload = 4000.0; // per_second
        const double var_calcium_dynamics__I_up = 5.0; // millimolar_per_second
        const double var_calcium_dynamics__K_leak = var_calcium_dynamics__I_up / var_calcium_dynamics__Ca_NSR_max; // per_second
        const double var_calcium_dynamics__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_calcium_dynamics__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_calcium_dynamics__K_mTn = 0.00050000000000000001; // millimolar
        const double var_calcium_dynamics__K_mrel = 0.00080000000000000004; // millimolar
        const double var_calcium_dynamics__K_mup = 0.00092000000000000003; // millimolar
        const double var_calcium_dynamics__Logicthresh = 0.97999999999999998; // dimensionless
        const double var_calcium_dynamics__OVRLDtrack2_orig_deriv = (((var_calcium_dynamics__Logicthresh > var_chaste_interface__calcium_dynamics__OVRLDtrack2) && (var_calcium_dynamics__Logicthresh < var_chaste_interface__calcium_dynamics__OVRLDtrack)) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (-500.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack2 = 0.001 * var_calcium_dynamics__OVRLDtrack2_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__OVRLDtrack3_orig_deriv = (((var_calcium_dynamics__Logicthresh > var_chaste_interface__calcium_dynamics__OVRLDtrack3) && (var_calcium_dynamics__Logicthresh < var_chaste_interface__calcium_dynamics__OVRLDtrack)) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack3) : (-10.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack3)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack3 = 0.001 * var_calcium_dynamics__OVRLDtrack3_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__OVRLDtrack_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack3 < 0.37) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.37) && (var_calcium_dynamics__CSQNthresh < 1 / (1.0 + var_calcium_dynamics__K_mCSQN / var_chaste_interface__calcium_dynamics__Ca_JSR))) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack) : (-500.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack = 0.001 * var_calcium_dynamics__OVRLDtrack_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__Tn_max = 0.070000000000000007; // millimolar
        const double var_calcium_dynamics__delta_Ca_ith = 0.00018000000000000001; // millimolar
        const double var_calcium_dynamics__G_rel = ((var_chaste_interface__calcium_dynamics__Cainfluxtrack > var_calcium_dynamics__delta_Ca_ith) ? ((1.0 - var_chaste_interface__calcium_dynamics__APtrack2) * (-var_calcium_dynamics__delta_Ca_ith + var_chaste_interface__calcium_dynamics__Cainfluxtrack) * var_chaste_interface__calcium_dynamics__APtrack2 * var_calcium_dynamics__G_rel_max / (-var_calcium_dynamics__delta_Ca_ith + var_chaste_interface__calcium_dynamics__Cainfluxtrack + var_calcium_dynamics__K_mrel)) : ((var_chaste_interface__calcium_dynamics__OVRLDtrack2 > 0) ? ((1.0 - var_chaste_interface__calcium_dynamics__OVRLDtrack2) * var_calcium_dynamics__G_rel_overload * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0))); // per_second
        const double var_calcium_dynamics__i_leak = var_chaste_interface__calcium_dynamics__Ca_NSR * var_calcium_dynamics__K_leak; // millimolar_per_second
        const double var_calcium_dynamics__i_rel = (-var_chaste_interface__calcium_dynamics__Cai + var_chaste_interface__calcium_dynamics__Ca_JSR) * var_calcium_dynamics__G_rel; // millimolar_per_second
        const double var_calcium_dynamics__i_up = var_chaste_interface__calcium_dynamics__Cai * var_calcium_dynamics__I_up / (var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mup); // millimolar_per_second
        const double var_calcium_dynamics__tau_tr = 0.17999999999999999; // second
        const double var_calcium_dynamics__i_tr = (-var_chaste_interface__calcium_dynamics__Ca_JSR + var_chaste_interface__calcium_dynamics__Ca_NSR) / var_calcium_dynamics__tau_tr; // millimolar_per_second
        const double var_calcium_dynamics__Ca_JSR_orig_deriv = (-var_calcium_dynamics__i_rel + var_calcium_dynamics__i_tr) / (1.0 + var_calcium_dynamics__CSQN_max * var_calcium_dynamics__K_mCSQN / pow((var_chaste_interface__calcium_dynamics__Ca_JSR + var_calcium_dynamics__K_mCSQN), 2)); // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_JSR = 0.001 * var_calcium_dynamics__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_fast_sodium_current__g_Na = 16.0; // milliS_per_microF
        const double var_ionic_concentrations__A_cap = 1.434e-7; // mm2
        const double var_ionic_concentrations__Ko = 4.5; // millimolar
        const double var_ATP_sensitive_potassium_current__GKbaraATP = pow((0.25 * var_ionic_concentrations__Ko), var_ATP_sensitive_potassium_current__nATP) * var_ATP_sensitive_potassium_current__g_K_ATP * var_ATP_sensitive_potassium_current__pATP; // milliS_per_microF
        const double var_ionic_concentrations__Nao = 132.0; // millimolar
        const double var_ionic_concentrations__preplength = 0.001; // mm
        const double var_ionic_concentrations__radius = 0.00011; // mm
        const double var_ionic_concentrations__volume = M_PI * pow(var_ionic_concentrations__radius, 2) * var_ionic_concentrations__preplength; // micro_litre
        const double var_ionic_concentrations__V_myo = 0.68000000000000005 * var_ionic_concentrations__volume; // micro_litre
        const double var_calcium_dynamics__V_JSR = 0.0070588235294117632 * var_ionic_concentrations__V_myo; // micro_litre
        const double var_calcium_dynamics__V_NSR = 0.081176470588235281 * var_ionic_concentrations__V_myo; // micro_litre
        const double var_calcium_dynamics__Ca_NSR_orig_deriv = -var_calcium_dynamics__i_leak - var_calcium_dynamics__V_JSR * var_calcium_dynamics__i_tr / var_calcium_dynamics__V_NSR + var_calcium_dynamics__i_up; // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_NSR = 0.001 * var_calcium_dynamics__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_membrane__F = 96485.0; // coulomb_per_mole
        const double var_membrane__I_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__I_st = var_membrane__I_st_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Cao / var_chaste_interface__calcium_dynamics__Cai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * var_calcium_dynamics__Cao + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__calcium_dynamics__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // microA_per_microF
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai) * (1.0 + (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao + pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai) * var_Na_Ca_exchanger__d_NaCa)); // microA_per_microF
        const double var_T_type_Ca_channel__i_Ca_T = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_CaT * var_chaste_interface__T_type_Ca_channel_g_gate__g; // microA_per_microF
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // millimolar
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 0; // cm_per_second
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // microA_per_microF
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.0055199999999999997; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__Rect = 1 / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.011248864963317985 * sqrt(var_ionic_concentrations__Ko); // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 1.1499999999999999; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_dynamics__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_dynamics__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_calcium_dynamics__Cai_orig_deriv = ((-var_calcium_dynamics__i_up + var_calcium_dynamics__i_leak) * var_calcium_dynamics__V_NSR / var_ionic_concentrations__V_myo + var_calcium_dynamics__V_JSR * var_calcium_dynamics__i_rel / var_ionic_concentrations__V_myo - 0.5 * (-var_Na_Ca_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F)) / (1.0 + var_calcium_dynamics__CMDN_max * var_calcium_dynamics__K_mCMDN / pow((var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mCMDN), 2) + var_calcium_dynamics__K_mTn * var_calcium_dynamics__Tn_max / pow((var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mTn), 2)); // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Cai = 0.001 * var_calcium_dynamics__Cai_orig_deriv; // millimolar / millisecond
        const double var_calcium_dynamics__Cainfluxtrack_orig_deriv = ((var_chaste_interface__calcium_dynamics__APtrack > 0.20000000000000001) ? (-0.5 * (-var_Na_Ca_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F)) : ((var_chaste_interface__calcium_dynamics__APtrack2 > 0.01) ? (0) : (-500.0 * var_chaste_interface__calcium_dynamics__Cainfluxtrack))); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Cainfluxtrack = 0.001 * var_calcium_dynamics__Cainfluxtrack_orig_deriv; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__PNaK = 0.018329999999999999; // dimensionless
        const double var_slow_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_slow_delayed_rectifier_potassium_current__PNaK + var_ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_slow_delayed_rectifier_potassium_current__PNaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.433 + 0.25979999999999998 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__calcium_dynamics__Cai, 1.3999999999999999)); // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = (-var_slow_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2; // microA_per_microF
        const double var_sodium_background_current__g_Nab = 0.0040000000000000001; // milliS_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__I_NaK = 2.0; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow(var_sodium_potassium_pump__K_mNai, 2) / pow(var_chaste_interface__ionic_concentrations__Nai, 2)) * (var_ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // microA_per_microF
        const double var_ionic_concentrations__Nai_orig_deriv = (-var_L_type_Ca_channel__i_CaNa - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = 0.001 * var_ionic_concentrations__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_ATP_sensitive_potassium_current__i_K_ATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_ATP_sensitive_potassium_current__GKbaraATP; // microA_per_microF
        const double var_plateau_potassium_current__i_Kp = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // microA_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifier_potassium_current__Rect * var_rapid_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr; // microA_per_microF
        const double var_time_independent_potassium_current__g_K1 = 0.3227486121839514 * sqrt(var_ionic_concentrations__Ko); // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1020.0 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K)); // per_second
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = 1000.0 * (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_second
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_microF
        const double var_transient_outward_current__g_to = 0; // milliS_per_microF
        const double var_transient_outward_current__rvdv = exp(0.01 * var_chaste_interface__membrane__V); // dimensionless
        const double var_transient_outward_current__i_to = pow(var_chaste_interface__transient_outward_current_zdv_gate__zdv, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_transient_outward_current__rvdv * var_chaste_interface__transient_outward_current_ydv_gate__ydv; // microA_per_microF
        const double var_ionic_concentrations__Ki_orig_deriv = (-var_ATP_sensitive_potassium_current__i_K_ATP - var_L_type_Ca_channel__i_CaK - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to + 2.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = 0.001 * var_ionic_concentrations__Ki_orig_deriv; // millimolar / millisecond
        const double var_membrane__dVdt = -1.0 * (var_ATP_sensitive_potassium_current__i_K_ATP + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_membrane__I_st + var_non_specific_calcium_activated_current__i_ns_Ca + var_plateau_potassium_current__i_Kp + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // dimensionless
        const double var_calcium_dynamics__APtrack_orig_deriv = ((var_membrane__dVdt > 150000.0) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack) : (-500.0 * var_chaste_interface__calcium_dynamics__APtrack)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack = 0.001 * var_calcium_dynamics__APtrack_orig_deriv; // 1 / millisecond
        
        rResidual[5] = rCurrentGuess[5] - rY[1] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Cai;
        rResidual[3] = rCurrentGuess[3] - rY[14] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Ca_JSR;
        rResidual[4] = rCurrentGuess[4] - rY[15] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Ca_NSR;
        rResidual[0] = rCurrentGuess[0] - rY[16] - mDt*d_dt_chaste_interface_var_calcium_dynamics__APtrack;
        rResidual[1] = rCurrentGuess[1] - rY[17] - mDt*d_dt_chaste_interface_var_calcium_dynamics__APtrack2;
        rResidual[2] = rCurrentGuess[2] - rY[18] - mDt*d_dt_chaste_interface_var_calcium_dynamics__APtrack3;
        rResidual[6] = rCurrentGuess[6] - rY[19] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Cainfluxtrack;
        rResidual[7] = rCurrentGuess[7] - rY[20] - mDt*d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack;
        rResidual[8] = rCurrentGuess[8] - rY[21] - mDt*d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack2;
        rResidual[9] = rCurrentGuess[9] - rY[22] - mDt*d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack3;
        rResidual[11] = rCurrentGuess[11] - rY[23] - mDt*d_dt_chaste_interface_var_ionic_concentrations__Nai;
        rResidual[10] = rCurrentGuess[10] - rY[24] - mDt*d_dt_chaste_interface_var_ionic_concentrations__Ki;
    }

    void Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[12], double rJacobian[12][12])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = rY[7];
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = rY[8];
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = rY[9];
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = rY[10];
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = rY[11];
        // Units: dimensionless; Initial value: 0.0631269
        
        double var_chaste_interface__calcium_dynamics__APtrack = rCurrentGuess[0];
        double var_chaste_interface__calcium_dynamics__APtrack2 = rCurrentGuess[1];
        double var_chaste_interface__calcium_dynamics__APtrack3 = rCurrentGuess[2];
        double var_chaste_interface__calcium_dynamics__Ca_JSR = rCurrentGuess[3];
        double var_chaste_interface__calcium_dynamics__Ca_NSR = rCurrentGuess[4];
        double var_chaste_interface__calcium_dynamics__Cai = rCurrentGuess[5];
        double var_chaste_interface__calcium_dynamics__Cainfluxtrack = rCurrentGuess[6];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack = rCurrentGuess[7];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack2 = rCurrentGuess[8];
        double var_chaste_interface__calcium_dynamics__OVRLDtrack3 = rCurrentGuess[9];
        double var_chaste_interface__ionic_concentrations__Ki = rCurrentGuess[10];
        double var_chaste_interface__ionic_concentrations__Nai = rCurrentGuess[11];
        
        const double var_x0 = 1 / var_chaste_interface__ionic_concentrations__Nai;
        const double var_x1 = log(132.0 * var_x0);
        const double var_x2 = 1 / var_chaste_interface__ionic_concentrations__Ki;
        const double var_x3 = log(4.5 * var_x2);
        const double var_x4 = pow(var_chaste_interface__ionic_concentrations__Nai, (-2));
        const double var_x5 = 0.037435883507802616 * var_chaste_interface__membrane__V;
        const double var_x6 = 1 / (1.0 + 0.1245 * exp(-0.003743588350780262 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(1.961367013372957)) * exp(-var_x5));
        const double var_x7 = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V));
        const double var_x8 = -26.712338705498265 * var_x3 + var_chaste_interface__membrane__V;
        const double var_x9 = pow(var_chaste_interface__ionic_concentrations__Nai, 3.0);
        const double var_x10 = 0.018717941753901308 * var_chaste_interface__membrane__V;
        const double var_x11 = exp(var_x10);
        const double var_x12 = exp(-var_x10);
        const double var_x13 = 1.8 * var_x11 * var_x9 - 2299968.0 * var_x12 * var_chaste_interface__calcium_dynamics__Cai;
        const double var_x14 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x15 = 1 / (1.0 + 2299.9679999999998 * var_chaste_interface__calcium_dynamics__Cai + 0.0018000000000000002 * var_x9);
        const double var_x16 = var_x14 * var_x15;
        const double var_x17 = 0.002 * var_x13 * var_x16;
        const double var_x18 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3708927812613361 * var_x3);
        const double var_x19 = 1.0 + var_x18;
        const double var_x20 = 1 / var_x19;
        const double var_x21 = exp(-2.4444678999999998 + 13.738155796237757 * var_x3 - 0.51429999999999998 * var_chaste_interface__membrane__V);
        const double var_x22 = 1.0 + var_x21;
        const double var_x23 = 1 / var_x22;
        const double var_x24 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1455350448256207 * var_x3);
        const double var_x25 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6494869150645177 * var_x3);
        const double var_x26 = var_x25 + 0.49124000000000001 * var_x24;
        const double var_x27 = var_x23 * var_x26;
        const double var_x28 = 1 / (1000.0 * var_x27 + 1020.0 * var_x20);
        const double var_x29 = var_x20 * var_x28;
        const double var_x30 = var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V));
        const double var_x31 = 1 / var_chaste_interface__calcium_dynamics__Cai;
        const double var_x32 = pow(var_x31, 1.3999999999999999);
        const double var_x33 = 1.0 + 6.4818210260626455e-7 * var_x32;
        const double var_x34 = 0.25979999999999998 / var_x33;
        const double var_x35 = 0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki;
        const double var_x36 = var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2;
        const double var_x37 = var_x36 * (-26.712338705498265 * log(6.9195599999999997 / var_x35) + var_chaste_interface__membrane__V);
        const double var_x38 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x39 = exp(var_x5);
        const double var_x40 = 0.75 * var_x39;
        const double var_x41 = -99.0 + var_x40 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x42 = 1 / (-1.0 + var_x39);
        const double var_x43 = var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_chaste_interface__membrane__V;
        const double var_x44 = var_x43 / (1.0 + 1666.6666666666667 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x45 = var_x42 * var_x44;
        const double var_x46 = -3.375 + var_x40 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x47 = log(1.8 * var_x31);
        const double var_x48 = 0.00050000000000000001 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x49 = 1.1499999999999999 / var_x48;
        const double var_x50 = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * var_chaste_interface__T_type_Ca_channel_g_gate__g;
        const double var_x51 = exp(0.074871767015605231 * var_chaste_interface__membrane__V);
        const double var_x52 = 1 / (-1.0 + var_x51);
        const double var_x53 = var_x52 * (-0.61380000000000001 + var_x51 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x54 = 7.8019226357407252 * var_x44;
        const double var_x55 = -0.040282206767891383 * var_x47 + var_x49 * var_chaste_interface__calcium_dynamics__Cai + var_x53 * var_x54 + 0.050000000000000003 * var_x50 * (-13.356169352749133 * var_x47 + var_chaste_interface__membrane__V);
        const double var_x56 = (var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001);
        const double var_x57 = 1.0 - var_chaste_interface__calcium_dynamics__APtrack2;
        const double var_x58 = 0.00062 + var_chaste_interface__calcium_dynamics__Cainfluxtrack;
        const double var_x59 = 1 / var_x58;
        const double var_x60 = -0.00018000000000000001 + var_chaste_interface__calcium_dynamics__Cainfluxtrack;
        const double var_x61 = 60000.0 * var_x59 * var_x60;
        const double var_x62 = var_x57 * var_x61;
        const double var_x63 = var_chaste_interface__calcium_dynamics__Cainfluxtrack > 0.00018000000000000001;
        const double var_x64 = ((var_x63) ? (var_x62 - var_x61 * var_chaste_interface__calcium_dynamics__APtrack2) : (0));
        const double var_x65 = 0.80000000000000004 + var_chaste_interface__calcium_dynamics__Ca_JSR;
        const double var_x66 = pow(var_x65, (-2));
        const double var_x67 = 1 / (1.0 + 8.0 * var_x66);
        const double var_x68 = 0.001 * var_x67;
        const double var_x69 = var_x68 * (-var_chaste_interface__calcium_dynamics__Ca_JSR + var_chaste_interface__calcium_dynamics__Cai);
        const double var_x70 = var_chaste_interface__calcium_dynamics__OVRLDtrack2 > 0;
        const double var_x71 = ((var_x63) ? (var_x62 * var_chaste_interface__calcium_dynamics__APtrack2) : ((var_x70) ? (4000.0 * (1.0 - var_chaste_interface__calcium_dynamics__OVRLDtrack2) * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0)));
        const double var_x72 = var_x71 * (-var_chaste_interface__calcium_dynamics__Cai + var_chaste_interface__calcium_dynamics__Ca_JSR);
        const double var_x73 = 60000.0 * var_x57 * var_chaste_interface__calcium_dynamics__APtrack2;
        const double var_x74 = ((var_x63) ? (var_x59 * var_x73 - var_x60 * var_x73 / pow(var_x58, 2)) : (0));
        const double var_x75 = ((var_x63) ? (0) : ((var_x70) ? (4000.0 - 8000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0)));
        const double var_x76 = 0.00092000000000000003 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x77 = 1 / var_x76;
        const double var_x78 = var_chaste_interface__calcium_dynamics__Cai / pow(var_x76, 2);
        const double var_x79 = 0.0023800000000000002 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x80 = pow(var_x48, (-2));
        const double var_x81 = 1.0 + 0.00011900000000000002 / pow(var_x79, 2) + 3.5000000000000004e-5 * var_x80;
        const double var_x82 = 1 / var_x81;
        const double var_x83 = 0.001 * var_x82;
        const double var_x84 = var_x83 * (0.0070588235294117632 * var_chaste_interface__calcium_dynamics__Ca_JSR - 0.0070588235294117632 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x85 = 0.40588235294117642 * var_x77;
        const double var_x86 = var_x12 * var_x16;
        const double var_x87 = var_x13 * var_x15 / pow((0.0068999999999999999 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x88 = var_x13 * var_x14 / pow((0.00043478865792915378 + 7.8261958427247687e-7 * var_x9 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x89 = var_x43 / pow((0.00059999999999999995 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x90 = 1 / M_PI;
        const double var_x91 = 0.090316078310111333 * var_x90;
        const double var_x92 = -var_x91 * (var_x49 + 4599.9359999999997 * var_x86 + 0.040282206767891383 * var_x31 + 1.38e-5 * var_x87 + 8.6957731585830757e-7 * var_x88 + 0.6678084676374566 * var_x31 * var_x50 - 1.1499999999999999 * var_x80 * var_chaste_interface__calcium_dynamics__Cai - 0.0046811535814444347 * var_x53 * var_x89 + var_x51 * var_x52 * var_x54);
        const double var_x93 = pow(var_chaste_interface__ionic_concentrations__Nai, 2.0);
        const double var_x94 = var_x88 * var_x93;
        const double var_x95 = var_x11 * var_x16 * var_x93;
        const double var_x96 = 2.0416447122894152e-12 * var_x94 - 0.010800000000000001 * var_x95;
        const double var_x97 = var_chaste_interface__calcium_dynamics__APtrack > 0.20000000000000001;
        const double var_x98 = var_chaste_interface__calcium_dynamics__OVRLDtrack > 0.97999999999999998;
        const double var_x99 = var_x42 * var_x89;
        const double var_x100 = 0.00018063215662022267 * var_x90;
        const double var_x101 = var_x18 * var_x2 / pow(var_x19, 2);
        const double var_x102 = var_x36 * (-0.433 - var_x34) * (0.14451785951707913 * var_chaste_interface__ionic_concentrations__Ki + 0.0026490123649480601 * var_chaste_interface__ionic_concentrations__Nai) / pow(var_x35, 2);
        const double var_x103 = var_x39 * var_x45;
        const double var_x104 = var_x6 / (pow((0.01 + var_x4), 2) * pow(var_chaste_interface__ionic_concentrations__Nai, 3));
        
        
        rJacobian[0][0] = 1.0 - (mDt * (0.001 * (((var_x17 + var_x55 + 0.0070160275741043606 * var_chaste_interface__membrane__V - 0.10684935482199306 * var_x1 - 7.3656881518639831e-7 * var_x3 + var_x37 * (0.433 + var_x34) + GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) / HeartConfig::Instance()->GetCapacitance() + 16.0 * var_x38 * (-26.712338705498265 * var_x1 + var_chaste_interface__membrane__V) + 1.5 * var_x6 / (1.0 + 100.0 * var_x4) + 0.0055199999999999997 * var_x7 * var_x8 + 0.0024381008236689767 * var_x41 * var_x45 + 0.00069711623550831479 * var_x45 * var_x46 + 698.34626081908675 * var_x29 * var_x8 + 0.023862446088641735 * var_x30 * var_x8) / mParameters[0] < -150000.0) ? (-100500.0) : (-500.0))));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (0.001 * ((var_x56) ? (-100500.0) : (-500.0))));
        rJacobian[1][2] = 0.0;
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = 0.0;
        rJacobian[2][2] = 1.0 - (mDt * (0.001 * ((var_x56) ? (-100500.0) : (-10.0))));
        rJacobian[2][3] = 0.0;
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = -(mDt * (var_x64 * var_x69));
        rJacobian[3][2] = 0.0;
        rJacobian[3][3] = 1.0 - (mDt * (var_x68 * (-5.5555555555555554 - var_x71) + 0.00025000000000000001 * (-var_x72 + 5.5555555555555554 * var_chaste_interface__calcium_dynamics__Ca_NSR - 5.5555555555555554 * var_chaste_interface__calcium_dynamics__Ca_JSR) / (pow(var_x65, 3) * pow((0.125 + var_x66), 2))));
        rJacobian[3][4] = -(mDt * (0.0055555555555555558 * var_x67));
        rJacobian[3][5] = -(mDt * (var_x68 * var_x71));
        rJacobian[3][6] = -(mDt * (var_x69 * var_x74));
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = -(mDt * (var_x69 * var_x75));
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (0.00048309178743961351));
        rJacobian[4][4] = 1.0 - (mDt * (-0.00081642512077294684));
        rJacobian[4][5] = -(mDt * (0.0050000000000000001 * var_x77 - 0.0050000000000000001 * var_x78));
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = -(mDt * (var_x64 * var_x84));
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (7.0588235294117632e-6 * var_x71 * var_x82));
        rJacobian[5][4] = -(mDt * (2.7058823529411762e-5 * var_x82));
        rJacobian[5][5] = 1.0 - (mDt * (var_x83 * (var_x92 - var_x85 + 0.40588235294117642 * var_x78 - 0.0070588235294117632 * var_x71) + 0.001 * (0.00023800000000000004 / pow(var_x79, 3) + 7.0000000000000007e-5 / pow(var_x48, 3)) * (0.027058823529411764 * var_chaste_interface__calcium_dynamics__Ca_NSR + 0.0070588235294117632 * var_x72 - var_x85 * var_chaste_interface__calcium_dynamics__Cai - var_x91 * (var_x55 - var_x17 + 0.003016 * var_chaste_interface__membrane__V)) / pow(var_x81, 2)));
        rJacobian[5][6] = -(mDt * (var_x74 * var_x84));
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = -(mDt * (var_x75 * var_x84));
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = -(mDt * (-9.0316078310111333e-5 * var_x82 * var_x90 * var_x96));
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = -(mDt * (0.001 * ((var_x97) ? (var_x92) : (0))));
        rJacobian[6][6] = 1.0 - (mDt * (0.001 * (((var_x97) || (var_chaste_interface__calcium_dynamics__APtrack2 > 0.01)) ? (0) : (-500.0))));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = -(mDt * (0.001 * ((var_x97) ? (-var_x91 * var_x96) : (0))));
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (0.001 * (((var_chaste_interface__calcium_dynamics__APtrack3 < 0.37) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.37) && (1 / (1.0 + 0.80000000000000004 / var_chaste_interface__calcium_dynamics__Ca_JSR) > 0.69999999999999996)) ? (-50000.0) : (-500.0))));
        rJacobian[7][8] = 0.0;
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = 0.0;
        rJacobian[8][8] = 1.0 - (mDt * (0.001 * (((var_x98) && (var_chaste_interface__calcium_dynamics__OVRLDtrack2 < 0.97999999999999998)) ? (-50000.0) : (-500.0))));
        rJacobian[8][9] = 0.0;
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (0.001 * (((var_x98) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.97999999999999998)) ? (-50000.0) : (-10.0))));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = -(mDt * (var_x100 * (4.1826974130498884e-7 * var_x46 * var_x99 - 2.3575679435995052e-7 * var_x31 * var_x32 * var_x37 / pow(var_x33, 2))));
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (var_x100 * (184.83763041301756 * var_x102 - 0.00052283717663123607 * var_x103 - 7.3656881518639831e-7 * var_x2 - 18654.461852717679 * var_x2 * var_x29 - 0.63742174226149029 * var_x2 * var_x30 - 0.14745210965435041 * var_x2 * var_x7 + 4449.089151873166 * var_x101 * var_x28 * var_x8 - 0.00067122862439358594 * var_x20 * var_x8 * (6498.310636886562 * var_x101 - 1000.0 * var_x23 * (1.053972635420138 * var_x2 * var_x24 + 1.6494869150645177 * var_x2 * var_x25) - 13738.155796237757 * var_x2 * var_x21 * var_x26 / pow(var_x22, 2)) / pow((var_x20 + 0.98039215686274506 * var_x27), 2))));
        rJacobian[10][11] = -(mDt * (var_x100 * (3.3880737654706117 * var_x102 + 0.059999999999999998 * var_x104)));
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = -(mDt * (var_x100 * (2.6087319475749228e-6 * var_x88 + 4.1400000000000003e-5 * var_x87 + 13799.808000000001 * var_x86 + 1.4628604942013857e-6 * var_x41 * var_x99)));
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (var_x100 * (6.124934136868245e-12 * var_x94 - 0.032399999999999998 * var_x95 - 0.10684935482199306 * var_x0 - 0.0018285756177517324 * var_x103 - 0.089999999999999997 * var_x104 - 427.39741928797224 * var_x0 * var_x38)));
    }

    void Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__calcium_dynamics__Cai = rY[1];
        // Units: millimolar; Initial value: 0.00035237
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = rY[7];
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = rY[8];
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = rY[9];
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = rY[10];
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = rY[11];
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = rY[12];
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = rY[13];
        // Units: dimensionless; Initial value: 0.985232
        double var_chaste_interface__ionic_concentrations__Nai = rY[23];
        // Units: millimolar; Initial value: 15.6748357
        double var_chaste_interface__ionic_concentrations__Ki = rY[24];
        // Units: millimolar; Initial value: 137.6244
        
        const double var_ATP_sensitive_potassium_current__ATPi = 3.0; // millimolar
        const double var_ATP_sensitive_potassium_current__hATP = 2.0; // dimensionless
        const double var_ATP_sensitive_potassium_current__kATP = 0.00025000000000000001; // millimolar
        const double var_ATP_sensitive_potassium_current__nATP = 0.23999999999999999; // dimensionless
        const double var_ATP_sensitive_potassium_current__nicholsarea = 5.0000000000000002e-5; // dimensionless
        const double var_ATP_sensitive_potassium_current__g_K_ATP = 0.000193 / var_ATP_sensitive_potassium_current__nicholsarea; // milliS_per_microF
        const double var_ATP_sensitive_potassium_current__pATP = 1 / (1.0 + pow((var_ATP_sensitive_potassium_current__ATPi / var_ATP_sensitive_potassium_current__kATP), var_ATP_sensitive_potassium_current__hATP)); // dimensionless
        const double var_L_type_Ca_channel__P_Ca = 0.00054000000000000001; // cm_per_second
        const double var_L_type_Ca_channel__P_K = 1.9299999999999999e-7; // cm_per_second
        const double var_L_type_Ca_channel__P_Na = 6.75e-7; // cm_per_second
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // millimolar
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // millimolar
        const double var_Na_Ca_exchanger__d_NaCa = 0.001; // millimolar
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_T_type_Ca_channel__g_CaT = 0.050000000000000003; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.003016; // milliS_per_microF
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + var_chaste_interface__calcium_dynamics__Cai / var_L_type_Ca_channel_f_Ca_gate__Km_Ca); // dimensionless
        const double var_calcium_dynamics__Cao = 1.8; // millimolar
        const double var_fast_sodium_current__g_Na = 16.0; // milliS_per_microF
        const double var_ionic_concentrations__Ko = 4.5; // millimolar
        const double var_ATP_sensitive_potassium_current__GKbaraATP = pow((0.25 * var_ionic_concentrations__Ko), var_ATP_sensitive_potassium_current__nATP) * var_ATP_sensitive_potassium_current__g_K_ATP * var_ATP_sensitive_potassium_current__pATP; // milliS_per_microF
        const double var_ionic_concentrations__Nao = 132.0; // millimolar
        const double var_membrane__F = 96485.0; // coulomb_per_mole
        const double var_membrane__I_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__I_st = var_membrane__I_st_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Cao / var_chaste_interface__calcium_dynamics__Cai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * var_calcium_dynamics__Cao + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__calcium_dynamics__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // microA_per_microF
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai) * (1.0 + (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao + pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai) * var_Na_Ca_exchanger__d_NaCa)); // microA_per_microF
        const double var_T_type_Ca_channel__i_Ca_T = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_CaT * var_chaste_interface__T_type_Ca_channel_g_gate__g; // microA_per_microF
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // millimolar
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 0; // cm_per_second
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // microA_per_microF
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.0055199999999999997; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__Rect = 1 / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.011248864963317985 * sqrt(var_ionic_concentrations__Ko); // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 1.1499999999999999; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_dynamics__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_dynamics__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_slow_delayed_rectifier_potassium_current__PNaK = 0.018329999999999999; // dimensionless
        const double var_slow_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_slow_delayed_rectifier_potassium_current__PNaK + var_ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_slow_delayed_rectifier_potassium_current__PNaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.433 + 0.25979999999999998 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__calcium_dynamics__Cai, 1.3999999999999999)); // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = (-var_slow_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2; // microA_per_microF
        const double var_sodium_background_current__g_Nab = 0.0040000000000000001; // milliS_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__I_NaK = 2.0; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow(var_sodium_potassium_pump__K_mNai, 2) / pow(var_chaste_interface__ionic_concentrations__Nai, 2)) * (var_ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // microA_per_microF
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_ATP_sensitive_potassium_current__i_K_ATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_ATP_sensitive_potassium_current__GKbaraATP; // microA_per_microF
        const double var_plateau_potassium_current__i_Kp = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // microA_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifier_potassium_current__Rect * var_rapid_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr; // microA_per_microF
        const double var_time_independent_potassium_current__g_K1 = 0.3227486121839514 * sqrt(var_ionic_concentrations__Ko); // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1020.0 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K)); // per_second
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = 1000.0 * (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_second
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_microF
        const double var_transient_outward_current__g_to = 0; // milliS_per_microF
        const double var_transient_outward_current__rvdv = exp(0.01 * var_chaste_interface__membrane__V); // dimensionless
        const double var_transient_outward_current__i_to = pow(var_chaste_interface__transient_outward_current_zdv_gate__zdv, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_transient_outward_current__rvdv * var_chaste_interface__transient_outward_current_ydv_gate__ydv; // microA_per_microF
        const double var_membrane__dVdt = -1.0 * (var_ATP_sensitive_potassium_current__i_K_ATP + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_membrane__I_st + var_non_specific_calcium_activated_current__i_ns_Ca + var_plateau_potassium_current__i_Kp + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // dimensionless
        const double var_membrane__V_orig_deriv = var_membrane__dVdt; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = rY[7];
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = rY[8];
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = rY[9];
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = rY[10];
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = rY[11];
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = rY[12];
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = rY[13];
        // Units: dimensionless; Initial value: 0.985232
        
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5;
        const double var_L_type_Ca_channel_d_gate__E0_d = 10.0 + var_chaste_interface__membrane__V;
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-0.16025641025641024 * var_L_type_Ca_channel_d_gate__E0_d));
        const double var_L_type_Ca_channel_d_gate__tau_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (0.0045787545787545781) : (0.028571428571428571 * (1.0 - exp(-0.16025641025641024 * var_L_type_Ca_channel_d_gate__E0_d)) * var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__E0_d));
        const double var_L_type_Ca_channel_d_gate__alpha_d = var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__tau_d;
        const double var_L_type_Ca_channel_d_gate__beta_d = (1.0 - var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d;
        const double var_L_type_Ca_channel_f_gate__f_infinity = 1 / (1.0 + exp(4.0 + 0.125 * var_chaste_interface__membrane__V)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_gate__tau_f = 0.001 / (0.02 + 0.019699999999999999 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2)));
        const double var_L_type_Ca_channel_f_gate__alpha_f = var_L_type_Ca_channel_f_gate__f_infinity / var_L_type_Ca_channel_f_gate__tau_f;
        const double var_L_type_Ca_channel_f_gate__beta_f = (1.0 - var_L_type_Ca_channel_f_gate__f_infinity) / var_L_type_Ca_channel_f_gate__tau_f;
        const double var_T_type_Ca_channel_b_gate__b_inf = 1 / (1.0 + exp(-1.2962962962962963 - 0.092592592592592587 * var_chaste_interface__membrane__V));
        const double var_T_type_Ca_channel_b_gate__tau_b = 0.0037000000000000002 + 0.0061000000000000004 / (1.0 + exp(5.5555555555555554 + 0.22222222222222221 * var_chaste_interface__membrane__V));
        const double var_T_type_Ca_channel_g_gate__g_inf = 1 / (1.0 + exp(10.714285714285715 + 0.17857142857142858 * var_chaste_interface__membrane__V));
        const double var_T_type_Ca_channel_g_gate__tau_g = ((var_chaste_interface__membrane__V <= 0) ? (0.012 - 0.00087500000000000002 * var_chaste_interface__membrane__V) : (0.012));
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (135.0 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0));
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (3560.0 * exp(0.079000000000000001 * var_chaste_interface__membrane__V) + 310000000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V)) : (7692.3076923076933 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? (1000.0 * (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0));
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (121.2 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (300.0 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_m_gate__E0_m = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m <= fabs(var_fast_sodium_current_m_gate__E0_m)) ? (320.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m))) : (3200.0));
        const double var_fast_sodium_current_m_gate__beta_m = 80.0 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_rapid_delayed_rectifier_potassium_current_xr_gate__tau_xr = 0.001 / (0.00060999999999999997 * (38.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(5.6404999999999994 + 0.14499999999999999 * var_chaste_interface__membrane__V)) + 0.0013799999999999999 * (14.199999999999999 + var_chaste_interface__membrane__V) / (1.0 - exp(-1.7465999999999999 - 0.123 * var_chaste_interface__membrane__V)));
        const double var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.8666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V));
        const double var_slow_delayed_rectifier_potassium_current_xs1_gate__tau_xs1 = 0.001 / (0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V)));
        const double var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__membrane__V));
        const double var_slow_delayed_rectifier_potassium_current_xs2_gate__tau_xs2 = 0.0040000000000000001 / (0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V)));
        const double var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_ydv_gate__alpha_ydv = 15.0 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_ydv_gate__beta_ydv = 100.0 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_ydv_gate__tau_ydv = 1 / (var_transient_outward_current_ydv_gate__alpha_ydv + var_transient_outward_current_ydv_gate__beta_ydv);
        const double var_transient_outward_current_ydv_gate__ydv_ss = var_transient_outward_current_ydv_gate__alpha_ydv / (var_transient_outward_current_ydv_gate__alpha_ydv + var_transient_outward_current_ydv_gate__beta_ydv);
        const double var_transient_outward_current_zdv_gate__alpha_zdv = 10000.0 * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_zdv_gate__beta_zdv = 10000.0 * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_zdv_gate__tau_zdv = 1 / (var_transient_outward_current_zdv_gate__alpha_zdv + var_transient_outward_current_zdv_gate__beta_zdv);
        const double var_transient_outward_current_zdv_gate__zdv_ss = var_transient_outward_current_zdv_gate__alpha_zdv / (var_transient_outward_current_zdv_gate__alpha_zdv + var_transient_outward_current_zdv_gate__beta_zdv);
        
        
        rY[5] = (var_chaste_interface__L_type_Ca_channel_d_gate__d + ((0.001 * var_L_type_Ca_channel_d_gate__alpha_d) * mDt)) / (1.0 - ((-0.001 * var_L_type_Ca_channel_d_gate__alpha_d - 0.001 * var_L_type_Ca_channel_d_gate__beta_d) * mDt));
        rY[6] = (var_chaste_interface__L_type_Ca_channel_f_gate__f + ((0.001 * var_L_type_Ca_channel_f_gate__alpha_f) * mDt)) / (1.0 - ((-0.001 * var_L_type_Ca_channel_f_gate__alpha_f - 0.001 * var_L_type_Ca_channel_f_gate__beta_f) * mDt));
        rY[7] = (var_chaste_interface__T_type_Ca_channel_b_gate__b + ((0.001 * var_T_type_Ca_channel_b_gate__b_inf / var_T_type_Ca_channel_b_gate__tau_b) * mDt)) / (1.0 - ((-0.001 / var_T_type_Ca_channel_b_gate__tau_b) * mDt));
        rY[8] = (var_chaste_interface__T_type_Ca_channel_g_gate__g + ((0.001 * var_T_type_Ca_channel_g_gate__g_inf / var_T_type_Ca_channel_g_gate__tau_g) * mDt)) / (1.0 - ((-0.001 / var_T_type_Ca_channel_g_gate__tau_g) * mDt));
        rY[3] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((0.001 * var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_h_gate__alpha_h - 0.001 * var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[4] = (var_chaste_interface__fast_sodium_current_j_gate__j + ((0.001 * var_fast_sodium_current_j_gate__alpha_j) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_j_gate__alpha_j - 0.001 * var_fast_sodium_current_j_gate__beta_j) * mDt));
        rY[2] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((0.001 * var_fast_sodium_current_m_gate__alpha_m) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_m_gate__alpha_m - 0.001 * var_fast_sodium_current_m_gate__beta_m) * mDt));
        rY[9] = (var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr + ((0.001 * var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_infinity / var_rapid_delayed_rectifier_potassium_current_xr_gate__tau_xr) * mDt)) / (1.0 - ((-0.001 / var_rapid_delayed_rectifier_potassium_current_xr_gate__tau_xr) * mDt));
        rY[10] = (var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 + ((0.001 * var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_infinity / var_slow_delayed_rectifier_potassium_current_xs1_gate__tau_xs1) * mDt)) / (1.0 - ((-0.001 / var_slow_delayed_rectifier_potassium_current_xs1_gate__tau_xs1) * mDt));
        rY[11] = (var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 + ((0.001 * var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_infinity / var_slow_delayed_rectifier_potassium_current_xs2_gate__tau_xs2) * mDt)) / (1.0 - ((-0.001 / var_slow_delayed_rectifier_potassium_current_xs2_gate__tau_xs2) * mDt));
        rY[13] = (var_chaste_interface__transient_outward_current_ydv_gate__ydv + ((0.001 * var_transient_outward_current_ydv_gate__ydv_ss / var_transient_outward_current_ydv_gate__tau_ydv) * mDt)) / (1.0 - ((-0.001 / var_transient_outward_current_ydv_gate__tau_ydv) * mDt));
        rY[12] = (var_chaste_interface__transient_outward_current_zdv_gate__zdv + ((0.001 * var_transient_outward_current_zdv_gate__zdv_ss / var_transient_outward_current_zdv_gate__tau_zdv) * mDt)) / (1.0 - ((-0.001 / var_transient_outward_current_zdv_gate__tau_zdv) * mDt));
        
        double _guess[12] = {rY[16],rY[17],rY[18],rY[14],rY[15],rY[1],rY[19],rY[20],rY[21],rY[22],rY[24],rY[23]};
        CardiacNewtonSolver<12,Cellviswanathan_model_1999_epiFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<12,Cellviswanathan_model_1999_epiFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[16] = _guess[0];
        rY[17] = _guess[1];
        rY[18] = _guess[2];
        rY[14] = _guess[3];
        rY[15] = _guess[4];
        rY[1] = _guess[5];
        rY[19] = _guess[6];
        rY[20] = _guess[7];
        rY[21] = _guess[8];
        rY[22] = _guess[9];
        rY[24] = _guess[10];
        rY[23] = _guess[11];
    }

    std::vector<double> Cellviswanathan_model_1999_epiFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__I_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__I_st_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellviswanathan_model_1999_epiFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "viswanathan_model_1999_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-88.984);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00035237);

    // rY[2]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00079287);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9938);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99573);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.18355e-06);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9974388);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_b_gate__b");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000967785);

    // rY[8]:
    this->mVariableNames.push_back("T_type_Ca_channel_g_gate__g");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.95331988);

    // rY[9]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00032151644);

    // rY[10]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current_xs1_gate__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0272635);

    // rY[11]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current_xs2_gate__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0631269);

    // rY[12]:
    this->mVariableNames.push_back("transient_outward_current_zdv_gate__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.011528);

    // rY[13]:
    this->mVariableNames.push_back("transient_outward_current_ydv_gate__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.985232);

    // rY[14]:
    this->mVariableNames.push_back("calcium_dynamics__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.817895);

    // rY[15]:
    this->mVariableNames.push_back("calcium_dynamics__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.797668);

    // rY[16]:
    this->mVariableNames.push_back("calcium_dynamics__APtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.814e-87);

    // rY[17]:
    this->mVariableNames.push_back("calcium_dynamics__APtrack2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.1084e-86);

    // rY[18]:
    this->mVariableNames.push_back("calcium_dynamics__APtrack3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01925);

    // rY[19]:
    this->mVariableNames.push_back("calcium_dynamics__Cainfluxtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.784e-87);

    // rY[20]:
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[21]:
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[23]:
    this->mVariableNames.push_back("ionic_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(15.6748357);

    // rY[24]:
    this->mVariableNames.push_back("ionic_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(137.6244);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellviswanathan_model_1999_epiFromCellMLBackwardEuler)

