//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: stewart_zhang_model_2008
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "stewart_zhang_model_2008_ss.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    double Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<7>(
                20,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler>::Instance();
        Init();
        
        this->mParameters[0] = 3.9799999999999998e-5; // (var_L_type_Ca_current__g_CaL) [litre_per_farad_second]
        this->mParameters[1] = 130.5744; // (var_fast_sodium_current__g_Na) [nanoS_per_picoF]
        this->mParameters[2] = 0; // (var_fast_sodium_current__perc_reduced_inact_for_IpNa) [dimensionless]
        this->mParameters[3] = 0; // (var_fast_sodium_current__shift_INa_inact) [millivolt]
        this->mParameters[4] = 0.091800000000000007; // (var_rapid_time_dependent_potassium_current__g_Kr) [nanoS_per_picoF]
        this->mParameters[5] = 1000.0; // (var_sodium_calcium_exchanger_current__K_NaCa) [picoA_per_picoF]
    }

    Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::~Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler()
    {
    }
    
    double Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.000101878186157052
        double var_chaste_interface__hyperpolarization_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0457562667986602
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[5];
        // Units: dimensionless; Initial value: 0.00953708522974789
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = rY[12];
        // Units: dimensionless; Initial value: 0.999955429598213
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[13];
        // Units: dimensionless; Initial value: 0.96386101799501
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[14];
        // Units: dimensionless; Initial value: 0.00103618091196912
        double var_chaste_interface__calcium_dynamics__Ca_ss = rY[16];
        // Units: millimolar; Initial value: 0.000446818714055411
        double var_chaste_interface__sodium_dynamics__Na_i = rY[18];
        // Units: millimolar; Initial value: 8.80420286531673
        double var_chaste_interface__potassium_dynamics__K_i = rY[19];
        // Units: millimolar; Initial value: 136.781894160227
        
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.12379999999999999; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_hyperpolarization_activated_current__g_f_K = 0.0234346; // nanoS_per_picoF
        const double var_hyperpolarization_activated_current__g_f_Na = 0.014565399999999999; // nanoS_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 0.065000000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_L_type_Ca_current__i_CaL_converted = HeartConfig::Instance()->GetCapacitance() * var_L_type_Ca_current__i_CaL; // uA_per_cm2
        const double var_inward_rectifier_potassium_current__xK1_inf = 1 / (1.0 + exp(7.5440000000000005 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_hyperpolarization_activated_current__i_f_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_K * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__i_K1 = (-8.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr_converted = HeartConfig::Instance()->GetCapacitance() * var_rapid_time_dependent_potassium_current__i_Kr; // uA_per_cm2
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.23519999999999999; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_fast_sodium_current__i_Na_converted = HeartConfig::Instance()->GetCapacitance() * var_fast_sodium_current__i_Na; // uA_per_cm2
        const double var_hyperpolarization_activated_current__i_f_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_Na * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_hyperpolarization_activated_current__i_f = var_hyperpolarization_activated_current__i_f_K + var_hyperpolarization_activated_current__i_f_Na; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[5] / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa_converted = HeartConfig::Instance()->GetCapacitance() * var_sodium_calcium_exchanger_current__i_NaCa; // uA_per_cm2
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 2.7240000000000002; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_sustained_outward_current__a = 1 / (1.0 + exp(0.29411764705882354 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_current__g_sus = 0.022700000000000001; // nanoS_per_picoF
        const double var_sustained_outward_current__i_sus = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_current__a * var_sustained_outward_current__g_sus; // picoA_per_picoF
        const double var_transient_outward_current__g_to = 0.081839999999999996; // nanoS_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_calcium_background_current__i_b_Ca + HeartConfig::Instance()->GetCapacitance() * var_calcium_pump_current__i_p_Ca + HeartConfig::Instance()->GetCapacitance() * var_hyperpolarization_activated_current__i_f + HeartConfig::Instance()->GetCapacitance() * var_inward_rectifier_potassium_current__i_K1 + HeartConfig::Instance()->GetCapacitance() * var_potassium_pump_current__i_p_K + HeartConfig::Instance()->GetCapacitance() * var_slow_time_dependent_potassium_current__i_Ks + HeartConfig::Instance()->GetCapacitance() * var_sodium_background_current__i_b_Na + HeartConfig::Instance()->GetCapacitance() * var_sodium_potassium_pump_current__i_NaK + HeartConfig::Instance()->GetCapacitance() * var_sustained_outward_current__i_sus + HeartConfig::Instance()->GetCapacitance() * var_transient_outward_current__i_to + var_L_type_Ca_current__i_CaL_converted + var_fast_sodium_current__i_Na_converted + var_rapid_time_dependent_potassium_current__i_Kr_converted + var_sodium_calcium_exchanger_current__i_NaCa_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[7], double rResidual[7])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__hyperpolarization_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0457562667986602
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[5];
        // Units: dimensionless; Initial value: 0.00953708522974789
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[13];
        // Units: dimensionless; Initial value: 0.96386101799501
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[14];
        // Units: dimensionless; Initial value: 0.00103618091196912
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = rCurrentGuess[0];
        double var_chaste_interface__calcium_dynamics__Ca_SR = rCurrentGuess[1];
        double var_chaste_interface__calcium_dynamics__Ca_i = rCurrentGuess[2];
        double var_chaste_interface__calcium_dynamics__Ca_ss = rCurrentGuess[3];
        double var_chaste_interface__calcium_dynamics__R_prime = rCurrentGuess[4];
        double var_chaste_interface__potassium_dynamics__K_i = rCurrentGuess[5];
        double var_chaste_interface__sodium_dynamics__Na_i = rCurrentGuess[6];
        
        //output_equations
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Buf_c = 0.20000000000000001; // millimolar
        const double var_calcium_dynamics__Buf_sr = 10.0; // millimolar
        const double var_calcium_dynamics__Buf_ss = 0.40000000000000002; // millimolar
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_L_type_Ca_current_fCass_gate__fCass_inf = 0.40000000000000002 + 0.59999999999999998 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2)); // dimensionless
        const double var_L_type_Ca_current_fCass_gate__tau_fCass = 2.0 + 80.0 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_fCass_gate__fCass = (-var_chaste_interface__L_type_Ca_current_fCass_gate__fCass + var_L_type_Ca_current_fCass_gate__fCass_inf) / var_L_type_Ca_current_fCass_gate__tau_fCass; // 1 / millisecond
        const double var_calcium_dynamics__EC = 1.5; // millimolar
        const double var_calcium_dynamics__K_buf_c = 0.001; // millimolar
        const double var_calcium_dynamics__Ca_i_bufc = 1 / (1.0 + var_calcium_dynamics__Buf_c * var_calcium_dynamics__K_buf_c / pow((var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_dynamics__K_buf_c), 2)); // dimensionless
        const double var_calcium_dynamics__K_buf_sr = 0.29999999999999999; // millimolar
        const double var_calcium_dynamics__Ca_sr_bufsr = 1 / (1.0 + var_calcium_dynamics__Buf_sr * var_calcium_dynamics__K_buf_sr / pow((var_chaste_interface__calcium_dynamics__Ca_SR + var_calcium_dynamics__K_buf_sr), 2)); // dimensionless
        const double var_calcium_dynamics__K_buf_ss = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__Ca_ss_bufss = 1 / (1.0 + var_calcium_dynamics__Buf_ss * var_calcium_dynamics__K_buf_ss / pow((var_chaste_interface__calcium_dynamics__Ca_ss + var_calcium_dynamics__K_buf_ss), 2)); // dimensionless
        const double var_calcium_dynamics__K_up = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__V_leak = 0.00036000000000000002; // per_millisecond
        const double var_calcium_dynamics__V_rel = 0.10199999999999999; // per_millisecond
        const double var_calcium_dynamics__V_sr = 0.0010939999999999999; // micrometre3
        const double var_calcium_dynamics__V_ss = 5.4679999999999998e-5; // micrometre3
        const double var_calcium_dynamics__V_xfer = 0.0038; // per_millisecond
        const double var_calcium_dynamics__Vmax_up = 0.0063749999999999996; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_leak = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__V_leak; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_up = var_calcium_dynamics__Vmax_up / (1.0 + pow(var_calcium_dynamics__K_up, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2)); // millimolar_per_millisecond
        const double var_calcium_dynamics__i_xfer = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_ss) * var_calcium_dynamics__V_xfer; // millimolar_per_millisecond
        const double var_calcium_dynamics__k1_prime = 0.14999999999999999; // per_millimolar2_per_millisecond
        const double var_calcium_dynamics__k2_prime = 0.044999999999999998; // per_millimolar_per_millisecond
        const double var_calcium_dynamics__k3 = 0.059999999999999998; // per_millisecond
        const double var_calcium_dynamics__k4 = 0.0050000000000000001; // per_millisecond
        const double var_calcium_dynamics__max_sr = 2.5; // dimensionless
        const double var_calcium_dynamics__min_sr = 1.0; // dimensionless
        const double var_calcium_dynamics__kcasr = -(-var_calcium_dynamics__min_sr + var_calcium_dynamics__max_sr) / (1.0 + pow(var_calcium_dynamics__EC, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2)) + var_calcium_dynamics__max_sr; // dimensionless
        const double var_calcium_dynamics__k1 = var_calcium_dynamics__k1_prime / var_calcium_dynamics__kcasr; // per_millimolar2_per_millisecond
        const double var_calcium_dynamics__O = pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2) * var_chaste_interface__calcium_dynamics__R_prime * var_calcium_dynamics__k1 / (pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2) * var_calcium_dynamics__k1 + var_calcium_dynamics__k3); // dimensionless
        const double var_calcium_dynamics__i_rel = (-var_chaste_interface__calcium_dynamics__Ca_ss + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__O * var_calcium_dynamics__V_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_SR = (-var_calcium_dynamics__i_leak - var_calcium_dynamics__i_rel + var_calcium_dynamics__i_up) * var_calcium_dynamics__Ca_sr_bufsr; // millimolar / millisecond
        const double var_calcium_dynamics__k2 = var_calcium_dynamics__k2_prime * var_calcium_dynamics__kcasr; // per_millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__R_prime = (1.0 - var_chaste_interface__calcium_dynamics__R_prime) * var_calcium_dynamics__k4 - var_chaste_interface__calcium_dynamics__Ca_ss * var_chaste_interface__calcium_dynamics__R_prime * var_calcium_dynamics__k2; // 1 / millisecond
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.12379999999999999; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_hyperpolarization_activated_current__g_f_K = 0.0234346; // nanoS_per_picoF
        const double var_hyperpolarization_activated_current__g_f_Na = 0.014565399999999999; // nanoS_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 0.065000000000000002; // nanoS_per_picoF
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__xK1_inf = 1 / (1.0 + exp(7.5440000000000005 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_ss = (var_calcium_dynamics__V_sr * var_calcium_dynamics__i_rel / var_calcium_dynamics__V_ss - var_calcium_dynamics__i_xfer * var_membrane__V_c / var_calcium_dynamics__V_ss - 0.5 * var_L_type_Ca_current__i_CaL * var_membrane__Cm / (var_calcium_dynamics__V_ss * var_membrane__F)) * var_calcium_dynamics__Ca_ss_bufss; // millimolar / millisecond
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_hyperpolarization_activated_current__i_f_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_K * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__i_K1 = (-8.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.23519999999999999; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_hyperpolarization_activated_current__i_f_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_Na * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[5] / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_i = ((-var_calcium_dynamics__i_up + var_calcium_dynamics__i_leak) * var_calcium_dynamics__V_sr / var_membrane__V_c - 0.5 * (-2.0 * var_sodium_calcium_exchanger_current__i_NaCa + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c) + var_calcium_dynamics__i_xfer) * var_calcium_dynamics__Ca_i_bufc; // millimolar / millisecond
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 2.7240000000000002; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_dynamics__Na_i = -1.0 * (3.0 * var_sodium_calcium_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump_current__i_NaK + var_fast_sodium_current__i_Na + var_hyperpolarization_activated_current__i_f_Na + var_sodium_background_current__i_b_Na) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        const double var_sustained_outward_current__a = 1 / (1.0 + exp(0.29411764705882354 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_current__g_sus = 0.022700000000000001; // nanoS_per_picoF
        const double var_sustained_outward_current__i_sus = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_current__a * var_sustained_outward_current__g_sus; // picoA_per_picoF
        const double var_transient_outward_current__g_to = 0.081839999999999996; // nanoS_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_dynamics__K_i = -1.0 * (-2.0 * var_sodium_potassium_pump_current__i_NaK + var_hyperpolarization_activated_current__i_f_K + var_inward_rectifier_potassium_current__i_K1 + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sustained_outward_current__i_sus + var_transient_outward_current__i_to) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        
        rResidual[2] = rCurrentGuess[2] - rY[1] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Ca_i;
        rResidual[0] = rCurrentGuess[0] - rY[12] - mDt*d_dt_chaste_interface_var_L_type_Ca_current_fCass_gate__fCass;
        rResidual[1] = rCurrentGuess[1] - rY[15] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Ca_SR;
        rResidual[3] = rCurrentGuess[3] - rY[16] - mDt*d_dt_chaste_interface_var_calcium_dynamics__Ca_ss;
        rResidual[4] = rCurrentGuess[4] - rY[17] - mDt*d_dt_chaste_interface_var_calcium_dynamics__R_prime;
        rResidual[6] = rCurrentGuess[6] - rY[18] - mDt*d_dt_chaste_interface_var_sodium_dynamics__Na_i;
        rResidual[5] = rCurrentGuess[5] - rY[19] - mDt*d_dt_chaste_interface_var_potassium_dynamics__K_i;
    }

    void Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[7], double rJacobian[7][7])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__hyperpolarization_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0457562667986602
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[5];
        // Units: dimensionless; Initial value: 0.00953708522974789
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[13];
        // Units: dimensionless; Initial value: 0.96386101799501
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[14];
        // Units: dimensionless; Initial value: 0.00103618091196912
        
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = rCurrentGuess[0];
        double var_chaste_interface__calcium_dynamics__Ca_SR = rCurrentGuess[1];
        double var_chaste_interface__calcium_dynamics__Ca_i = rCurrentGuess[2];
        double var_chaste_interface__calcium_dynamics__Ca_ss = rCurrentGuess[3];
        double var_chaste_interface__calcium_dynamics__R_prime = rCurrentGuess[4];
        double var_chaste_interface__potassium_dynamics__K_i = rCurrentGuess[5];
        double var_chaste_interface__sodium_dynamics__Na_i = rCurrentGuess[6];
        
        const double var_x0 = pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2);
        const double var_x1 = 1 / (1.0 + 399.99999999999994 * var_x0);
        const double var_x2 = 1 / (2.0 + 80.0 * var_x1);
        const double var_x3 = var_chaste_interface__calcium_dynamics__Ca_ss / pow((0.0025000000000000005 + var_x0), 2);
        const double var_x4 = pow(var_chaste_interface__calcium_dynamics__Ca_SR, (-2));
        const double var_x5 = 1 / (1.0 + 2.25 * var_x4);
        const double var_x6 = 1 / (2.5 - 1.5 * var_x5);
        const double var_x7 = var_x0 * var_x6;
        const double var_x8 = 1 / (0.059999999999999998 + 0.14999999999999999 * var_x7);
        const double var_x9 = var_x8 * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x10 = var_x7 * var_x9;
        const double var_x11 = 0.015299999999999998 * var_x10;
        const double var_x12 = 1 / (pow((0.44444444444444442 + var_x4), 2) * pow(var_chaste_interface__calcium_dynamics__Ca_SR, 3));
        const double var_x13 = -var_chaste_interface__calcium_dynamics__Ca_ss + var_chaste_interface__calcium_dynamics__Ca_SR;
        const double var_x14 = var_x13 / pow((1 - 0.59999999999999998 * var_x5), 2);
        const double var_x15 = var_x0 * var_x12 * var_x14 * var_x9;
        const double var_x16 = var_x12 * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x17 = var_x14 / pow((0.40000000000000002 + var_x7), 2);
        const double var_x18 = var_x16 * var_x17 * var_x6 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 4);
        const double var_x19 = 0.29999999999999999 + var_chaste_interface__calcium_dynamics__Ca_SR;
        const double var_x20 = pow(var_x19, (-2));
        const double var_x21 = 1 / (1.0 + 3.0 * var_x20);
        const double var_x22 = var_x21;
        const double var_x23 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2);
        const double var_x24 = 1 / var_x23;
        const double var_x25 = 1 / (pow(var_x23, 2) * pow(var_chaste_interface__calcium_dynamics__Ca_i, 3));
        const double var_x26 = var_x17 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 3) * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x27 = var_x13 * var_x6 * var_x9 * var_chaste_interface__calcium_dynamics__Ca_ss;
        const double var_x28 = var_x13 * var_x7 * var_x8;
        const double var_x29 = 0.001 + var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x30 = 1.0 + 0.00020000000000000001 / pow(var_x29, 2);
        const double var_x31 = 1 / var_x30;
        const double var_x32 = 0.00050000000000000001 + var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x33 = 7.2352122917848019e-6 / var_x32;
        const double var_x34 = 1 / var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x35 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
        const double var_x36 = mParameters[5] / (1.0 + 0.10000000000000001 * var_x35);
        const double var_x37 = var_x35 * var_x36;
        const double var_x38 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
        const double var_x39 = var_x36 * var_x38 * pow(var_chaste_interface__sodium_dynamics__Na_i, 2);
        const double var_x40 = 0.00025000000000000001 + var_chaste_interface__calcium_dynamics__Ca_ss;
        const double var_x41 = 1.0 + 0.0001 / pow(var_x40, 2);
        const double var_x42 = 1 / var_x41;
        const double var_x43 = exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__membrane__V);
        const double var_x44 = (-15.0 + var_chaste_interface__membrane__V) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_f_gate__f / (-1.0 + var_x43);
        const double var_x45 = 253.30174843481757 * var_x44 * (-2.0 + 0.25 * var_x43 * var_chaste_interface__calcium_dynamics__Ca_ss);
        const double var_x46 = 0.30611192392099484 * var_x10;
        const double var_x47 = var_x42;
        const double var_x48 = -0.11249999999999999 + 0.067500000000000004 * var_x5;
        const double var_x49 = 1 / var_chaste_interface__potassium_dynamics__K_i;
        const double var_x50 = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (0.0031249999999999997 * var_chaste_interface__sodium_dynamics__Na_i + 0.10416666666666667 * var_chaste_interface__potassium_dynamics__K_i) / pow((0.029999999999999999 * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i), 2);
        const double var_x51 = 1 / (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane__V));
        const double var_x52 = var_x51 / (40.0 + var_chaste_interface__sodium_dynamics__Na_i);
        const double var_x53 = var_x51 * var_chaste_interface__sodium_dynamics__Na_i / pow((1 + 0.025000000000000001 * var_chaste_interface__sodium_dynamics__Na_i), 2);
        const double var_x54 = 1 / var_chaste_interface__sodium_dynamics__Na_i;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-var_x2));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = -(mDt * (-0.0030000000000000001 * var_x2 * var_x3 + 6.2500000000000001e-5 * var_x3 * (0.40000000000000002 - var_chaste_interface__L_type_Ca_current_fCass_gate__fCass + 0.59999999999999998 * var_x1) / pow((0.025000000000000001 + var_x1), 2)));
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (var_x22 * (-0.00036000000000000002 - var_x11 + 0.021759999999999998 * var_x18 - 0.0032639999999999995 * var_x15) + 0.66666666666666674 * (0.00036000000000000002 * var_chaste_interface__calcium_dynamics__Ca_i + 0.0063749999999999996 * var_x24 - 0.00036000000000000002 * var_chaste_interface__calcium_dynamics__Ca_SR - var_x11 * var_x13) / (pow(var_x19, 3) * pow((0.33333333333333337 + var_x20), 2))));
        rJacobian[1][2] = -(mDt * (var_x22 * (0.00036000000000000002 + 7.96875e-10 * var_x25)));
        rJacobian[1][3] = -(mDt * (var_x22 * (var_x11 + 0.032639999999999995 * var_x26 - 0.030599999999999995 * var_x27)));
        rJacobian[1][4] = -(mDt * (-0.015299999999999998 * var_x21 * var_x28));
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (2.40087783467447e-5 * var_x31));
        rJacobian[2][2] = 1.0 - (mDt * (var_x31 * (-0.0038240087783467445 - var_x33 - 6.9488744729986565e-5 * var_x37 - 5.3144431236283834e-11 * var_x25 - 4.6212277808973232e-7 * var_x34 + 7.2352122917848019e-6 * var_chaste_interface__calcium_dynamics__Ca_i / pow(var_x32, 2)) + 0.00040000000000000002 * (0.0038 * var_chaste_interface__calcium_dynamics__Ca_ss + 2.40087783467447e-5 * var_chaste_interface__calcium_dynamics__Ca_SR + 4.6212277808973232e-7 * log(2.0 * var_x34) - 0.0038240087783467445 * var_chaste_interface__calcium_dynamics__Ca_i - 3.4598107243429746e-8 * var_chaste_interface__membrane__V - 0.00042515544989027063 * var_x24 - var_x33 * var_chaste_interface__calcium_dynamics__Ca_i + 1.0129554625362472e-11 * var_x36 * (2.0 * var_x38 * pow(var_chaste_interface__sodium_dynamics__Na_i, 3) - 6860000.0 * var_x35 * var_chaste_interface__calcium_dynamics__Ca_i)) / (pow(var_x29, 3) * pow(var_x30, 2))));
        rJacobian[2][3] = -(mDt * (0.0038 * var_x31));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = -(mDt * (6.0777327752174832e-11 * var_x31 * var_x39));
        rJacobian[3][0] = -(mDt * (-var_x42 * var_x45));
        rJacobian[3][1] = -(mDt * (var_x47 * (var_x46 + 0.065303877103145572 * var_x15 - 0.43535918068763713 * var_x18)));
        rJacobian[3][2] = -(mDt * (1.1399999999999999 * var_x42));
        rJacobian[3][3] = 1.0 - (mDt * (var_x47 * (-1.1399999999999999 - var_x46 + 0.61222384784198969 * var_x27 - 0.65303877103145569 * var_x26 - 63.325437108704392 * var_x43 * var_x44 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass) + 0.00020000000000000001 * (1.1399999999999999 * var_chaste_interface__calcium_dynamics__Ca_i - 1.1399999999999999 * var_chaste_interface__calcium_dynamics__Ca_ss + var_x13 * var_x46 - var_x45 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass) / (pow(var_x40, 3) * pow(var_x41, 2))));
        rJacobian[3][4] = -(mDt * (0.30611192392099484 * var_x28 * var_x42));
        rJacobian[3][5] = 0.0;
        rJacobian[3][6] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = -(mDt * (0.059999999999999998 * var_x16 * var_chaste_interface__calcium_dynamics__Ca_ss));
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (var_x48 * var_chaste_interface__calcium_dynamics__R_prime));
        rJacobian[4][4] = 1.0 - (mDt * (-0.0050000000000000001 + var_x48 * var_chaste_interface__calcium_dynamics__Ca_ss));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-0.0070502450209754628 * var_x50 - 7.3173394969065143e-5 * var_x49 * var_chaste_interface__hyperpolarization_activated_current_y_gate__y - 7.0879642315114355e-5 * var_x49 / (1.0 + exp(0.29411764705882354 - 0.058823529411764705 * var_chaste_interface__membrane__V)) - 4.5587787568311439e-5 * var_x49 / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)) - 0.00020295932821508516 * var_x49 / (1.0 + exp(7.5440000000000005 + 0.10000000000000001 * var_chaste_interface__membrane__V)) - 0.00025554140647880875 * var_x49 * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s - 0.0031224512033090025 * var_x49 * mParameters[4] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2));
        rJacobian[5][6] = -(mDt * (0.00053729341037579627 * var_x52 - 3.3580838148487267e-7 * var_x53 - 0.00021150735062926387 * var_x50));
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = -(mDt * (0.00020846623418995967 * var_x37));
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (5.0371257222730904e-7 * var_x53 - 1.823319832565245e-10 * var_x39 - 9.0551084895961074e-7 * var_x54 - 0.00080594011556369446 * var_x52 - 4.5479750756676942e-5 * var_x54 * var_chaste_interface__hyperpolarization_activated_current_y_gate__y - 0.0031224512033090025 * var_x54 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j));
    }

    void Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.000101878186157052
        double var_chaste_interface__hyperpolarization_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0457562667986602
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[5];
        // Units: dimensionless; Initial value: 0.00953708522974789
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = rY[12];
        // Units: dimensionless; Initial value: 0.999955429598213
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[13];
        // Units: dimensionless; Initial value: 0.96386101799501
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[14];
        // Units: dimensionless; Initial value: 0.00103618091196912
        double var_chaste_interface__calcium_dynamics__Ca_ss = rY[16];
        // Units: millimolar; Initial value: 0.000446818714055411
        double var_chaste_interface__sodium_dynamics__Na_i = rY[18];
        // Units: millimolar; Initial value: 8.80420286531673
        double var_chaste_interface__potassium_dynamics__K_i = rY[19];
        // Units: millimolar; Initial value: 136.781894160227
        
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.12379999999999999; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_hyperpolarization_activated_current__g_f_K = 0.0234346; // nanoS_per_picoF
        const double var_hyperpolarization_activated_current__g_f_Na = 0.014565399999999999; // nanoS_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 0.065000000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__xK1_inf = 1 / (1.0 + exp(7.5440000000000005 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_hyperpolarization_activated_current__i_f_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_K * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__i_K1 = (-8.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.23519999999999999; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_hyperpolarization_activated_current__i_f_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarization_activated_current__g_f_Na * var_chaste_interface__hyperpolarization_activated_current_y_gate__y; // picoA_per_picoF
        const double var_hyperpolarization_activated_current__i_f = var_hyperpolarization_activated_current__i_f_K + var_hyperpolarization_activated_current__i_f_Na; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[5] / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 2.7240000000000002; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_sustained_outward_current__a = 1 / (1.0 + exp(0.29411764705882354 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_current__g_sus = 0.022700000000000001; // nanoS_per_picoF
        const double var_sustained_outward_current__i_sus = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_current__a * var_sustained_outward_current__g_sus; // picoA_per_picoF
        const double var_transient_outward_current__g_to = 0.081839999999999996; // nanoS_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double d_dt_chaste_interface_var_membrane__V = -1.0 * var_L_type_Ca_current__i_CaL - 1.0 * var_calcium_background_current__i_b_Ca - 1.0 * var_calcium_pump_current__i_p_Ca - 1.0 * var_fast_sodium_current__i_Na - 1.0 * var_hyperpolarization_activated_current__i_f - 1.0 * var_inward_rectifier_potassium_current__i_K1 - 1.0 * var_potassium_pump_current__i_p_K - 1.0 * var_rapid_time_dependent_potassium_current__i_Kr - 1.0 * var_slow_time_dependent_potassium_current__i_Ks - 1.0 * var_sodium_background_current__i_b_Na - 1.0 * var_sodium_calcium_exchanger_current__i_NaCa - 1.0 * var_sodium_potassium_pump_current__i_NaK - 1.0 * var_sustained_outward_current__i_sus - 1.0 * var_transient_outward_current__i_to; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__hyperpolarization_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0457562667986602
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[5];
        // Units: dimensionless; Initial value: 0.00953708522974789
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[13];
        // Units: dimensionless; Initial value: 0.96386101799501
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[14];
        // Units: dimensionless; Initial value: 0.00103618091196912
        
        const double var_L_type_Ca_current_d_gate__alpha_d = 0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_d_gate__beta_d = 1.3999999999999999 / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_d_gate__d_inf = 1 / (1.0 + exp(-1.0666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_d_gate__gamma_d = 1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_d_gate__tau_d = var_L_type_Ca_current_d_gate__alpha_d * var_L_type_Ca_current_d_gate__beta_d + var_L_type_Ca_current_d_gate__gamma_d;
        const double var_L_type_Ca_current_f2_gate__f2_inf = 0.33000000000000002 + 0.67000000000000004 / (1.0 + exp(5.0 + 0.14285714285714285 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_f2_gate__tau_f2 = 80.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 31.0 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 562.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2));
        const double var_L_type_Ca_current_f_gate__f_inf = 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_current_f_gate__tau_f = 20.0 + 200.0 / (1.0 + exp(1.3 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 180.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 1102.5 * exp(-3.2400000000000002 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2));
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.057000000000000002 * exp(-11.764705882352942 + 0.14705882352941177 * mParameters[3] - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0));
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__membrane__V - 0.34849999999999998 * mParameters[3]) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__membrane__V - 0.079000000000000001 * mParameters[3])) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 + 0.0900900900900901 * mParameters[3] - 0.0900900900900901 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_h_gate__h_inf = 0.01 * mParameters[2] + (1.0 - 0.01 * mParameters[2]) / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V - 0.13458950201884254 * mParameters[3])), 2);
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h);
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V - 0.24440000000000001 * mParameters[3]) - 6.9480000000000002e-6 * exp(0.043909999999999998 * mParameters[3] - 0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V - 0.311 * mParameters[3]))) : (0));
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.024240000000000001 * exp(0.01052 * mParameters[3] - 0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 + 0.13780000000000001 * mParameters[3] - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__membrane__V - 0.057000000000000002 * mParameters[3]) / (1.0 + exp(-3.2000000000000002 + 0.10000000000000001 * mParameters[3] - 0.10000000000000001 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_j_gate__j_inf = 0.01 * mParameters[2] + (1.0 - 0.01 * mParameters[2]) / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V - 0.13458950201884254 * mParameters[3])), 2);
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j);
        const double var_fast_sodium_current_m_gate__alpha_m = 1 / (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__beta_m = 0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__m_inf = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__membrane__V)), 2);
        const double var_fast_sodium_current_m_gate__tau_m = var_fast_sodium_current_m_gate__alpha_m * var_fast_sodium_current_m_gate__beta_m;
        const double var_hyperpolarization_activated_current_y_gate__alpha_y = exp(-2.8999999999999999 - 0.040000000000000001 * var_chaste_interface__membrane__V);
        const double var_hyperpolarization_activated_current_y_gate__beta_y = exp(3.6000000000000001 + 0.11 * var_chaste_interface__membrane__V);
        const double var_hyperpolarization_activated_current_y_gate__tau_y = 4000.0 / (var_hyperpolarization_activated_current_y_gate__alpha_y + var_hyperpolarization_activated_current_y_gate__beta_y);
        const double var_hyperpolarization_activated_current_y_gate__y_inf = 1 / (1.0 + exp(11.852941176470587 + 0.14705882352941177 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 = 450.0 / (1.0 + exp(-4.5 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1 = 6.0 / (1.0 + exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1 = var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 * var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1;
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf = 1 / (1.0 + exp(-3.7142857142857144 - 0.14285714285714285 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 = 3.0 / (1.0 + exp(-3.0 - 0.050000000000000003 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2 = 1.1200000000000001 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V));
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2 = var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 * var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2;
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf = 1 / (1.0 + exp(3.6666666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V));
        const double var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs = 1400.0 / sqrt(1.0 + exp(0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V));
        const double var_slow_time_dependent_potassium_current_Xs_gate__beta_xs = 1 / (1.0 + exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__membrane__V));
        const double var_slow_time_dependent_potassium_current_Xs_gate__tau_xs = 80.0 + var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs * var_slow_time_dependent_potassium_current_Xs_gate__beta_xs;
        const double var_slow_time_dependent_potassium_current_Xs_gate__xs_inf = 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_r_gate__r_inf = 1 / (1.0 + exp(1.5384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_r_gate__tau_r = 7.2999999999999998 + 10.449999999999999 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_transient_outward_current_s_gate__s_inf = 1 / (1.0 + exp(2.0769230769230771 + 0.076923076923076927 * var_chaste_interface__membrane__V));
        const double var_transient_outward_current_s_gate__tau_s = 42.0 + 5.0 / (1.0 + exp(-8.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + 85.0 * exp(-1.953125 * pow((1 + 0.040000000000000001 * var_chaste_interface__membrane__V), 2));
        
        
        rY[2] = (var_chaste_interface__hyperpolarization_activated_current_y_gate__y + ((var_hyperpolarization_activated_current_y_gate__y_inf / var_hyperpolarization_activated_current_y_gate__tau_y) * mDt)) / (1.0 - ((-1 / var_hyperpolarization_activated_current_y_gate__tau_y) * mDt));
        rY[9] = (var_chaste_interface__L_type_Ca_current_d_gate__d + ((var_L_type_Ca_current_d_gate__d_inf / var_L_type_Ca_current_d_gate__tau_d) * mDt)) / (1.0 - ((-1 / var_L_type_Ca_current_d_gate__tau_d) * mDt));
        rY[11] = (var_chaste_interface__L_type_Ca_current_f2_gate__f2 + ((var_L_type_Ca_current_f2_gate__f2_inf / var_L_type_Ca_current_f2_gate__tau_f2) * mDt)) / (1.0 - ((-1 / var_L_type_Ca_current_f2_gate__tau_f2) * mDt));
        rY[10] = (var_chaste_interface__L_type_Ca_current_f_gate__f + ((var_L_type_Ca_current_f_gate__f_inf / var_L_type_Ca_current_f_gate__tau_f) * mDt)) / (1.0 - ((-1 / var_L_type_Ca_current_f_gate__tau_f) * mDt));
        rY[7] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((var_fast_sodium_current_h_gate__h_inf / var_fast_sodium_current_h_gate__tau_h) * mDt)) / (1.0 - ((-1 / var_fast_sodium_current_h_gate__tau_h) * mDt));
        rY[8] = (var_chaste_interface__fast_sodium_current_j_gate__j + ((var_fast_sodium_current_j_gate__j_inf / var_fast_sodium_current_j_gate__tau_j) * mDt)) / (1.0 - ((-1 / var_fast_sodium_current_j_gate__tau_j) * mDt));
        rY[6] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((var_fast_sodium_current_m_gate__m_inf / var_fast_sodium_current_m_gate__tau_m) * mDt)) / (1.0 - ((-1 / var_fast_sodium_current_m_gate__tau_m) * mDt));
        rY[3] = (var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 + ((var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf / var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1) * mDt)) / (1.0 - ((-1 / var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1) * mDt));
        rY[4] = (var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 + ((var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf / var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2) * mDt)) / (1.0 - ((-1 / var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2) * mDt));
        rY[5] = (var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs + ((var_slow_time_dependent_potassium_current_Xs_gate__xs_inf / var_slow_time_dependent_potassium_current_Xs_gate__tau_xs) * mDt)) / (1.0 - ((-1 / var_slow_time_dependent_potassium_current_Xs_gate__tau_xs) * mDt));
        rY[14] = (var_chaste_interface__transient_outward_current_r_gate__r + ((var_transient_outward_current_r_gate__r_inf / var_transient_outward_current_r_gate__tau_r) * mDt)) / (1.0 - ((-1 / var_transient_outward_current_r_gate__tau_r) * mDt));
        rY[13] = (var_chaste_interface__transient_outward_current_s_gate__s + ((var_transient_outward_current_s_gate__s_inf / var_transient_outward_current_s_gate__tau_s) * mDt)) / (1.0 - ((-1 / var_transient_outward_current_s_gate__tau_s) * mDt));
        
        double _guess[7] = {rY[12],rY[15],rY[1],rY[16],rY[17],rY[19],rY[18]};
        CardiacNewtonSolver<7,Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<7,Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[12] = _guess[0];
        rY[15] = _guess[1];
        rY[1] = _guess[2];
        rY[16] = _guess[3];
        rY[17] = _guess[4];
        rY[19] = _guess[5];
        rY[18] = _guess[6];
    }

    std::vector<double> Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1370441635924
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.000101878186157052
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[3];
        // Units: dimensionless; Initial value: 0.00550281999719088
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[4];
        // Units: dimensionless; Initial value: 0.313213286437995
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[6];
        // Units: dimensionless; Initial value: 0.0417391656294997
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[7];
        // Units: dimensionless; Initial value: 0.190678733735145
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[8];
        // Units: dimensionless; Initial value: 0.238219836154029
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[9];
        // Units: dimensionless; Initial value: 0.000287906256206415
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[10];
        // Units: dimensionless; Initial value: 0.989328560287987
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = rY[11];
        // Units: dimensionless; Initial value: 0.995474890442185
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = rY[12];
        // Units: dimensionless; Initial value: 0.999955429598213
        double var_chaste_interface__calcium_dynamics__Ca_ss = rY[16];
        // Units: millimolar; Initial value: 0.000446818714055411
        double var_chaste_interface__sodium_dynamics__Na_i = rY[18];
        // Units: millimolar; Initial value: 8.80420286531673
        double var_chaste_interface__potassium_dynamics__K_i = rY[19];
        // Units: millimolar; Initial value: 136.781894160227
        

        // Mathematics
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_L_type_Ca_current__i_CaL_converted = HeartConfig::Instance()->GetCapacitance() * var_L_type_Ca_current__i_CaL; // uA_per_cm2
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr_converted = HeartConfig::Instance()->GetCapacitance() * var_rapid_time_dependent_potassium_current__i_Kr; // uA_per_cm2
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_fast_sodium_current__i_Na_converted = HeartConfig::Instance()->GetCapacitance() * var_fast_sodium_current__i_Na; // uA_per_cm2
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[5] / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa_converted = HeartConfig::Instance()->GetCapacitance() * var_sodium_calcium_exchanger_current__i_NaCa; // uA_per_cm2

        std::vector<double> dqs(5);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_L_type_Ca_current__i_CaL_converted;
        dqs[2] = var_fast_sodium_current__i_Na_converted;
        dqs[3] = var_rapid_time_dependent_potassium_current__i_Kr_converted;
        dqs[4] = var_sodium_calcium_exchanger_current__i_NaCa_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "stewart_zhang_model_2008";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-69.1370441635924);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000101878186157052);

    // rY[2]:
    this->mVariableNames.push_back("hyperpolarization_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0457562667986602);

    // rY[3]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr1_gate__Xr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00550281999719088);

    // rY[4]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr2_gate__Xr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.313213286437995);

    // rY[5]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_Xs_gate__Xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00953708522974789);

    // rY[6]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_m_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0417391656294997);

    // rY[7]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_h_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.190678733735145);

    // rY[8]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_j_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.238219836154029);

    // rY[9]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_d_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000287906256206415);

    // rY[10]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.989328560287987);

    // rY[11]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f2_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.995474890442185);

    // rY[12]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_fCa2_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999955429598213);

    // rY[13]:
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.96386101799501);

    // rY[14]:
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00103618091196912);

    // rY[15]:
    this->mVariableNames.push_back("calcium_dynamics__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.10836886659417);

    // rY[16]:
    this->mVariableNames.push_back("dyadic_space_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000446818714055411);

    // rY[17]:
    this->mVariableNames.push_back("calcium_dynamics__R_prime");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991580051907845);

    // rY[18]:
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.80420286531673);

    // rY[19]:
    this->mVariableNames.push_back("cytosolic_potassium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(136.781894160227);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("litre_per_farad_second");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_reduced_inactivation");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_shift_inactivation");
    this->mParameterUnits.push_back("millivolt");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_sodium_calcium_exchanger_current_conductance");
    this->mParameterUnits.push_back("picoA_per_picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_rapid_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [4]:
    this->mDerivedQuantityNames.push_back("membrane_sodium_calcium_exchanger_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellstewart_zhang_model_2008_ssFromCellMLBackwardEuler)

