//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: pandit_model_2001_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "pandit_model_2001_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellpandit_model_2001_epiFromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00059999999999999995 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 5.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellpandit_model_2001_epiFromCellMLBackwardEuler::Cellpandit_model_2001_epiFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<13>(
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.0001; // (var_membrane__Cm) [microF]
    }

    Cellpandit_model_2001_epiFromCellMLBackwardEuler::~Cellpandit_model_2001_epiFromCellMLBackwardEuler()
    {
    }
    
    double Cellpandit_model_2001_epiFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B + var_hyperpolarisation_activated_current__i_f + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_Ca_P + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_steady_state_outward_K_current__i_ss) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellpandit_model_2001_epiFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[13], double rResidual[13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rCurrentGuess[0];
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = rCurrentGuess[1];
        double var_chaste_interface__SR_Ca_release_channel__P_C2 = rCurrentGuess[2];
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = rCurrentGuess[3];
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = rCurrentGuess[4];
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = rCurrentGuess[5];
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = rCurrentGuess[6];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rCurrentGuess[7];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rCurrentGuess[8];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rCurrentGuess[9];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rCurrentGuess[10];
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rCurrentGuess[11];
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rCurrentGuess[12];
        
        //output_equations
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact = 0.0089999999999999993; // second
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_SERCA2a_pump__K_SR = 1.0; // dimensionless
        const double var_SERCA2a_pump__K_fb = 0.00016799999999999999; // millimolar
        const double var_SERCA2a_pump__K_rb = 3.29; // millimolar
        const double var_SERCA2a_pump__N_fb = 1.2; // dimensionless
        const double var_SERCA2a_pump__N_rb = 1.0; // dimensionless
        const double var_SERCA2a_pump__Vmaxf = 0.040000000000000001; // millimolar_per_second
        const double var_SERCA2a_pump__Vmaxr = 0.90000000000000002; // millimolar_per_second
        const double var_SR_Ca_release_channel__k_a_minus = 576.0; // per_second
        const double var_SR_Ca_release_channel__k_a_plus = 12150000000000.0; // per_second
        const double var_SR_Ca_release_channel__k_b_minus = 1930.0; // per_second
        const double var_SR_Ca_release_channel__k_b_plus = 4050000000.0; // per_second
        const double var_SR_Ca_release_channel__k_c_minus = 0.80000000000000004; // per_second
        const double var_SR_Ca_release_channel__k_c_plus = 100.0; // per_second
        const double var_SR_Ca_release_channel__P_C2_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus - var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2 = 0.001 * var_SR_Ca_release_channel__P_C2_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__m = 3.0; // dimensionless
        const double var_SR_Ca_release_channel__n = 4.0; // dimensionless
        const double var_SR_Ca_release_channel__v1 = 1800.0; // per_second
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_intracellular_and_SR_Ca_fluxes__HTRPN_tot = 0.14000000000000001; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__LTRPN_tot = 0.070000000000000007; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus = 0.066000000000000003; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus = 200000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus = 40.0; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus = 40000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__tau_tr = 0.00057470000000000004; // second
        const double var_intracellular_and_SR_Ca_fluxes__tau_xfer = 0.026700000000000002; // second
        const double var_intracellular_ion_concentrations__CMDN_tot = 0.050000000000000003; // millimolar
        const double var_intracellular_ion_concentrations__CSQN_tot = 15.0; // millimolar
        const double var_SERCA2a_pump__rb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_NSR / var_SERCA2a_pump__K_rb), var_SERCA2a_pump__N_rb); // dimensionless
        const double var_intracellular_and_SR_Ca_fluxes__J_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_chaste_interface__intracellular_ion_concentrations__Ca_NSR) / var_intracellular_and_SR_Ca_fluxes__tau_tr; // millimolar_per_second
        const double var_SERCA2a_pump__fb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_SERCA2a_pump__K_fb), var_SERCA2a_pump__N_fb); // dimensionless
        const double var_SERCA2a_pump__J_up = (var_SERCA2a_pump__Vmaxf * var_SERCA2a_pump__fb - var_SERCA2a_pump__Vmaxr * var_SERCA2a_pump__rb) * var_SERCA2a_pump__K_SR / (1.0 + var_SERCA2a_pump__fb + var_SERCA2a_pump__rb); // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_trpn = var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa + var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity = 1 / (1.0 + 100.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss); // dimensionless
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact + var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity) / var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact = 0.001 * var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__J_rel = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2) * var_SR_Ca_release_channel__v1; // millimolar_per_second
        const double var_SR_Ca_release_channel__P_C1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1 = 0.001 * var_SR_Ca_release_channel__P_C1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus + var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1 = 0.001 * var_SR_Ca_release_channel__P_O1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O2_orig_deriv = -var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2 = 0.001 * var_SR_Ca_release_channel__P_O2_orig_deriv; // 1 / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_xfer = (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_ss) / var_intracellular_and_SR_Ca_fluxes__tau_xfer; // millimolar_per_second
        const double var_intracellular_ion_concentrations__EGTA_tot = 10.0; // millimolar
        const double var_intracellular_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_intracellular_ion_concentrations__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_intracellular_ion_concentrations__K_mEGTA = 0.00014999999999999999; // millimolar
        const double var_intracellular_ion_concentrations__V_JSR = 5.6000000000000004e-7; // micro_litre
        const double var_intracellular_ion_concentrations__V_NSR = 5.04e-6; // micro_litre
        const double var_intracellular_ion_concentrations__V_SS = 1.2e-8; // micro_litre
        const double var_intracellular_ion_concentrations__V_myo = 9.3600000000000002e-6; // micro_litre
        const double var_intracellular_ion_concentrations__Ca_NSR_orig_deriv = var_SERCA2a_pump__J_up * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_NSR - var_intracellular_and_SR_Ca_fluxes__J_tr * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_NSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.001 * var_intracellular_ion_concentrations__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_JSR = 1 / (1.0 + var_intracellular_ion_concentrations__CSQN_tot * var_intracellular_ion_concentrations__K_mCSQN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_intracellular_ion_concentrations__K_mCSQN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__Ca_JSR_orig_deriv = (-var_SR_Ca_release_channel__J_rel + var_intracellular_and_SR_Ca_fluxes__J_tr) * var_intracellular_ion_concentrations__beta_JSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * var_intracellular_ion_concentrations__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_SS = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_intracellular_ion_concentrations__K_mCMDN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__beta_i = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mCMDN), 2) + var_intracellular_ion_concentrations__EGTA_tot * var_intracellular_ion_concentrations__K_mEGTA / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mEGTA), 2)); // dimensionless
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_intracellular_ion_concentrations__Ca_ss_orig_deriv = (var_SR_Ca_release_channel__J_rel * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_SS - var_intracellular_and_SR_Ca_fluxes__J_xfer * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L / (var_intracellular_ion_concentrations__V_SS * var_membrane__F)) * var_intracellular_ion_concentrations__beta_SS; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * var_intracellular_ion_concentrations__Ca_ss_orig_deriv; // millimolar / millisecond
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = (-var_SERCA2a_pump__J_up - var_intracellular_and_SR_Ca_fluxes__J_trpn - 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_Ca_P) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F) + var_intracellular_and_SR_Ca_fluxes__J_xfer) * var_intracellular_ion_concentrations__beta_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_hyperpolarisation_activated_current__i_f_Na - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_background_currents__i_B_K - var_hyperpolarisation_activated_current__i_f_K - var_inward_rectifier__i_K1 - var_steady_state_outward_K_current__i_ss + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        
        rResidual[0] = rCurrentGuess[0] - rY[7] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        rResidual[3] = rCurrentGuess[3] - rY[14] - mDt*d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1;
        rResidual[4] = rCurrentGuess[4] - rY[15] - mDt*d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2;
        rResidual[1] = rCurrentGuess[1] - rY[16] - mDt*d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1;
        rResidual[2] = rCurrentGuess[2] - rY[17] - mDt*d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2;
        rResidual[5] = rCurrentGuess[5] - rY[18] - mDt*d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa;
        rResidual[6] = rCurrentGuess[6] - rY[19] - mDt*d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa;
        rResidual[12] = rCurrentGuess[12] - rY[20] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rResidual[9] = rCurrentGuess[9] - rY[21] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rResidual[11] = rCurrentGuess[11] - rY[22] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rResidual[10] = rCurrentGuess[10] - rY[23] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        rResidual[7] = rCurrentGuess[7] - rY[24] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        rResidual[8] = rCurrentGuess[8] - rY[25] - mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }

    void Cellpandit_model_2001_epiFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[13], double rJacobian[13][13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rCurrentGuess[0];
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = rCurrentGuess[1];
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = rCurrentGuess[3];
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = rCurrentGuess[4];
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = rCurrentGuess[5];
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = rCurrentGuess[6];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rCurrentGuess[7];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rCurrentGuess[8];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rCurrentGuess[9];
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rCurrentGuess[10];
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rCurrentGuess[11];
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rCurrentGuess[12];
        
        const double var_x0 = 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0);
        const double var_x1 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0);
        const double var_x2 = 48600000000.0 * var_x1 * var_chaste_interface__SR_Ca_release_channel__P_C1;
        const double var_x3 = 4050000.0 * var_x1;
        const double var_x4 = 12150000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 2.0) * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x5 = 40.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa;
        const double var_x6 = 0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR;
        const double var_x7 = pow(var_x6, (-2));
        const double var_x8 = 1 / (1.0 + 12.0 * var_x7);
        const double var_x9 = 0.001 * var_x8;
        const double var_x10 = var_x9 * (1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 1800.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR);
        const double var_x11 = 1800.0 * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x12 = 1800.0 * var_chaste_interface__SR_Ca_release_channel__P_O2;
        const double var_x13 = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2);
        const double var_x14 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2);
        const double var_x15 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0);
        const double var_x16 = 1 / (1.0 + 33855.471141425078 * var_x14 + 0.303951367781155 * var_x15);
        const double var_x17 = 1354.2188456570032 * var_x14 - 0.2735562310030395 * var_x15;
        const double var_x18 = var_x17 / pow((2.9537323401073989e-5 + var_x14 + 8.9779098483507565e-6 * var_x15), 2);
        const double var_x19 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 0.19999999999999996);
        const double var_x20 = var_x16 * var_x19;
        const double var_x21 = var_x18 * var_x19;
        const double var_x22 = 200000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x23 = 0.00014999999999999999 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x24 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x25 = 1.0 + 0.0014999999999999998 / pow(var_x23, 2) + 0.00011900000000000002 / pow(var_x24, 2);
        const double var_x26 = 1 / var_x25;
        const double var_x27 = 0.001 * var_x26;
        const double var_x28 = 40000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x29 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x30 = 0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x31 = 0.0022145492519739826 / var_x30;
        const double var_x32 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
        const double var_x33 = 0.018714999999999999 * var_chaste_interface__membrane__V;
        const double var_x34 = exp(var_x33);
        const double var_x35 = exp(-var_x33);
        const double var_x36 = 1.2 * var_x32 * var_x34 - 2744000.0 * var_x35 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        const double var_x37 = var_x36 / pow((0.0036443148688046646 + 4.3731778425655972e-7 * var_x32 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
        const double var_x38 = 1 / (1.0 + 0.00012 * var_x32 + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
        const double var_x39 = var_x35 * var_x38;
        const double var_x40 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2);
        const double var_x41 = var_x34 * var_x38 * var_x40;
        const double var_x42 = var_x37 * var_x40;
        const double var_x43 = 0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss;
        const double var_x44 = 1.0 + 0.00011900000000000002 / pow(var_x43, 2);
        const double var_x45 = 1 / var_x44;
        const double var_x46 = 0.001 * var_x45;
        const double var_x47 = var_x46 * (84000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 84000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss);
        const double var_x48 = 84000.0 * var_chaste_interface__SR_Ca_release_channel__P_O1;
        const double var_x49 = 84000.0 * var_chaste_interface__SR_Ca_release_channel__P_O2;
        const double var_x50 = 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        const double var_x51 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
        const double var_x52 = log(5.4000000000000004 * var_x51);
        const double var_x53 = exp(-0.10977188457982838 + 0.06345195640452507 * var_chaste_interface__membrane__V - 1.613 * var_x52);
        const double var_x54 = 1.0 + var_x53;
        const double var_x55 = var_x51 / (1.0 + exp(-35.49354838709678));
        const double var_x56 = exp(4.5158823529411762 + 1.4953416461467837 * var_x52 - 0.058823529411764705 * var_chaste_interface__membrane__V);
        const double var_x57 = 0.040000000000000001 * var_chaste_interface__membrane__V;
        const double var_x58 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
        const double var_x59 = pow(var_x58, 1.5);
        const double var_x60 = var_x58 * var_x59 / (pow((0.031622776601683791 + var_x59), 2) * (1.0 + 0.1245 * exp(-0.0039337852699643568 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.039337852699643565 * var_chaste_interface__membrane__V)));
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.11111111111111112));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = -(mDt * (-0.0011111111111111113 / pow((0.01 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss), 2)));
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (-var_x0));
        rJacobian[1][2] = 0.0;
        rJacobian[1][3] = -(mDt * (0.57599999999999996));
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = -(mDt * (-var_x2));
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = 0.0;
        rJacobian[2][2] = 1.0 - (mDt * (-0.00080000000000000004));
        rJacobian[2][3] = -(mDt * (0.10000000000000001));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = -(mDt * (var_x0));
        rJacobian[3][2] = -(mDt * (0.00080000000000000004));
        rJacobian[3][3] = 1.0 - (mDt * (-0.67600000000000005 - var_x3));
        rJacobian[3][4] = -(mDt * (1.9299999999999999));
        rJacobian[3][5] = 0.0;
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = -(mDt * (var_x2 - var_x4));
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (var_x3));
        rJacobian[4][4] = 1.0 - (mDt * (-1.9299999999999999));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = -(mDt * (var_x4));
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-6.6000000000000005e-5 - 200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = -(mDt * (28.000000000000004 - 200.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa));
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.040000000000000001 - 40.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = -(mDt * (2.8000000000000003 - var_x5));
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = -(mDt * (var_x10));
        rJacobian[7][4] = -(mDt * (var_x10));
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (var_x9 * (-1740.0382808421784 - var_x11 - var_x12) + 0.00016666666666666666 * (1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR - 1800.0 * var_x13 - 1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) / (pow(var_x6, 3) * pow((0.083333333333333329 + var_x7), 2))));
        rJacobian[7][8] = -(mDt * (1.7400382808421784 * var_x8));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = -(mDt * (var_x9 * (var_x11 + var_x12)));
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = -(mDt * (0.19333758676024207));
        rJacobian[8][8] = 1.0 - (mDt * (-0.19333758676024207 - 4.9248350664764349e-13 * var_x18 - 0.00050803300043421621 * var_x16));
        rJacobian[8][9] = -(mDt * (3.0179734274641783 * var_x20 - 6.5826035008107738e-8 * var_x21));
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = -(mDt * (var_x27 * (0.066000000000000003 + var_x22)));
        rJacobian[9][6] = -(mDt * (var_x27 * (40.0 + var_x28)));
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = -(mDt * (var_x27 * (0.2735562310030395 * var_x16 + 2.651834266564234e-10 * var_x18)));
        rJacobian[9][9] = 1.0 - (mDt * (var_x27 * (-30837.453183520603 - var_x31 + 40000.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + 200000.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 3.5444788081288787e-5 * var_x21 - 4.0288009715211813e-8 * var_x37 - 0.00022799730679188537 * var_x29 - 30.33500195190371 * var_x39 - 1625.0626147884036 * var_x20 + 0.0022145492519739826 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / pow(var_x30, 2)) + 0.001 * (0.0029999999999999996 / pow(var_x23, 3) + 0.00023800000000000004 / pow(var_x24, 3)) * (var_x5 + 0.066000000000000003 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 0.00022799730679188537 * log(1.2 * var_x29) + 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 1.7937848940989261e-5 * var_chaste_interface__membrane__V - var_x22 * (0.14000000000000001 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa) - var_x28 * (0.070000000000000007 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa) - var_x31 * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 1.1055029865854122e-5 * var_x36 * var_x38 - 1.0 * var_x16 * var_x17) / pow(var_x25, 2)));
        rJacobian[9][10] = -(mDt * (0.037453183520599252 * var_x26));
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = -(mDt * (var_x27 * (3.9798107517074834e-5 * var_x41 - 5.2855989422289547e-14 * var_x42)));
        rJacobian[10][0] = -(mDt * (var_x46 * (870.15176483187713 - 13.386950228182727 * var_chaste_interface__membrane__V) * (0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12) * var_chaste_interface__L_type_Ca_channel_d_gate__d));
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = -(mDt * (var_x47));
        rJacobian[10][4] = -(mDt * (var_x47));
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = -(mDt * (var_x46 * (var_x48 + var_x49)));
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = -(mDt * (29.213483146067414 * var_x45));
        rJacobian[10][10] = 1.0 - (mDt * (var_x46 * (-29213.483146067414 - var_x48 - var_x49) + 2.3800000000000004e-7 * (29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 84000.0 * var_x13 - 29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 13.386950228182727 * (-65.0 + var_chaste_interface__membrane__V) * ((0.10000000000000001 - var_x50) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + var_x50) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_chaste_interface__L_type_Ca_channel_d_gate__d) / (pow(var_x43, 3) * pow(var_x44, 2))));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (-3.8843985601580465e-6 * var_x51 - 3.2651466157850246e-5 * var_x51 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00067554757567966038 * var_x55 / var_x54 + 25.420807984495319 * var_x51 * (-3.4336586151856603e-5 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s - 4.4180257576880957e-6 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r - 0.00019703470957323427 * var_x51 * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss + 4.286481532120841e-5 * var_x53 * var_x55 * (-1.73 - 25.420807984495319 * var_x52 + var_chaste_interface__membrane__V) / pow(var_x54, 2) - 1.6557538619599519e-7 * var_x51 * var_x56 * (10.0 + 48.0 / (exp(1.48 + var_x57) + exp(-1.48 - var_x57))) / pow((1.0 + var_x56), 2)));
        rJacobian[11][12] = -(mDt * (6.5767488669640998e-6 * var_x60));
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = 0.0;
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = -(mDt * (0.091005005855711127 * var_x39 + 1.2086402914563544e-10 * var_x37));
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (1.5856796826686865e-16 * var_x42 - 2.2560474246135324e-6 * var_x58 - 1.193943225512245e-7 * var_x41 - 9.8651233004461501e-6 * var_x60 - 8.1628665394625614e-6 * var_x58 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.022518252522655345 * var_x58 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j));
    }

    void Cellpandit_model_2001_epiFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_membrane__V_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_L_type_Ca_channel__i_Ca_L - var_Na_Ca_ion_exchanger_current__i_NaCa - var_background_currents__i_B - var_hyperpolarisation_activated_current__i_f - var_inward_rectifier__i_K1 - var_membrane__i_Stim - var_sarcolemmal_calcium_pump_current__i_Ca_P - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK - var_steady_state_outward_K_current__i_ss) / mParameters[0]; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellpandit_model_2001_epiFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-0.92819614711033271 - 0.087565674255691769 * var_chaste_interface__membrane__V));
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 1 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V));
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.035000000000000003 + 0.34999999999999998 * exp(-21.777777777777779 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2));
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V));
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow = 0.035000000000000003 + 3.7000000000000002 * exp(-5.4444444444444446 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2));
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-3.0600000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_d_gate__tau_d = 0.00025000000000000001 + 0.0010499999999999999 * exp(-0.64800000000000002 * pow((-1 + 0.055555555555555552 * var_chaste_interface__membrane__V), 2)) + 0.0030500000000000002 * exp(-0.22049999999999997 * pow((1 + 0.14285714285714285 * var_chaste_interface__membrane__V), 2));
        const double var_L_type_Ca_channel_f_11_gate__f_11_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_11_gate__tau_f_11 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.040000000000000001 / (1.0 + exp(1.0 - 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.105 * exp(-14.0625 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2));
        const double var_L_type_Ca_channel_f_12_gate__f_12_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_12_gate__tau_f_12 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.080000000000000002 / (1.0 + exp(-11.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.041000000000000002 * exp(-15.340277777777779 * pow((1 + 0.021276595744680851 * var_chaste_interface__membrane__V), 2));
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (0.56230000000000002 * exp(-5.6377730796335452 - 0.070472163495419307 * var_chaste_interface__membrane__V) + 0.11885 * exp(2.8198801550934083 + 0.035248501938667604 * var_chaste_interface__membrane__V));
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(13.225190839694655 + 0.095419847328244267 * var_chaste_interface__membrane__V));
        const double var_sodium_current_h_gate__h_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V));
        const double var_sodium_current_h_gate__tau_h = ((var_chaste_interface__membrane__V >= -40.0) ? (0.00045370000000000002 + 0.00045370000000000002 * exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)) : (0.00349 / (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V))));
        const double var_sodium_current_j_gate__j_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V));
        const double var_sodium_current_j_gate__tau_j = ((var_chaste_interface__membrane__V >= -40.0) ? (0.01163 * (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)) / exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V)) : (0.00349 / (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V)) + (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V)))));
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-6.9230769230769234 - 0.15384615384615385 * var_chaste_interface__membrane__V));
        const double var_sodium_current_m_gate__tau_m = 0.0013600000000000001 / (0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V) + 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V)));
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity = 1 / (1.0 + exp(-0.97292724196277491 - 0.084602368866328256 * var_chaste_interface__membrane__V));
        const double var_steady_state_outward_K_current_r_ss_gate__tau_r_ss = 10.0 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity = 1 / (1.0 + exp(8.4951456310679614 + 0.097087378640776698 * var_chaste_interface__membrane__V));
        const double var_steady_state_outward_K_current_s_ss_gate__tau_s_ss = 2.1000000000000001;
        
        
        rY[8] = (var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + ((0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_infinity / var_Ca_independent_transient_outward_K_current_r_gate__tau_r) * mDt)) / (1.0 - ((-0.001 / var_Ca_independent_transient_outward_K_current_r_gate__tau_r) * mDt));
        rY[9] = (var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + ((0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_infinity / var_Ca_independent_transient_outward_K_current_s_gate__tau_s) * mDt)) / (1.0 - ((-0.001 / var_Ca_independent_transient_outward_K_current_s_gate__tau_s) * mDt));
        rY[10] = (var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow + ((0.001 * var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity / var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow) * mDt)) / (1.0 - ((-0.001 / var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow) * mDt));
        rY[4] = (var_chaste_interface__L_type_Ca_channel_d_gate__d + ((0.001 * var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__tau_d) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_channel_d_gate__tau_d) * mDt));
        rY[5] = (var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 + ((0.001 * var_L_type_Ca_channel_f_11_gate__f_11_infinity / var_L_type_Ca_channel_f_11_gate__tau_f_11) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_channel_f_11_gate__tau_f_11) * mDt));
        rY[6] = (var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + ((0.001 * var_L_type_Ca_channel_f_12_gate__f_12_infinity / var_L_type_Ca_channel_f_12_gate__tau_f_12) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_channel_f_12_gate__tau_f_12) * mDt));
        rY[13] = (var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + ((0.001 * var_hyperpolarisation_activated_current_y_gate__y_infinity / var_hyperpolarisation_activated_current_y_gate__tau_y) * mDt)) / (1.0 - ((-0.001 / var_hyperpolarisation_activated_current_y_gate__tau_y) * mDt));
        rY[2] = (var_chaste_interface__sodium_current_h_gate__h + ((0.001 * var_sodium_current_h_gate__h_infinity / var_sodium_current_h_gate__tau_h) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_h_gate__tau_h) * mDt));
        rY[3] = (var_chaste_interface__sodium_current_j_gate__j + ((0.001 * var_sodium_current_j_gate__j_infinity / var_sodium_current_j_gate__tau_j) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_j_gate__tau_j) * mDt));
        rY[1] = (var_chaste_interface__sodium_current_m_gate__m + ((0.001 * var_sodium_current_m_gate__m_infinity / var_sodium_current_m_gate__tau_m) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_m_gate__tau_m) * mDt));
        rY[11] = (var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss + ((0.001 * var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity / var_steady_state_outward_K_current_r_ss_gate__tau_r_ss) * mDt)) / (1.0 - ((-0.001 / var_steady_state_outward_K_current_r_ss_gate__tau_r_ss) * mDt));
        rY[12] = (var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss + ((0.001 * var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity / var_steady_state_outward_K_current_s_ss_gate__tau_s_ss) * mDt)) / (1.0 - ((-0.001 / var_steady_state_outward_K_current_s_ss_gate__tau_s_ss) * mDt));
        
        double _guess[13] = {rY[7],rY[16],rY[17],rY[14],rY[15],rY[18],rY[19],rY[24],rY[25],rY[21],rY[23],rY[22],rY[20]};
        CardiacNewtonSolver<13,Cellpandit_model_2001_epiFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<13,Cellpandit_model_2001_epiFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[7] = _guess[0];
        rY[16] = _guess[1];
        rY[17] = _guess[2];
        rY[14] = _guess[3];
        rY[15] = _guess[4];
        rY[18] = _guess[5];
        rY[19] = _guess[6];
        rY[24] = _guess[7];
        rY[25] = _guess[8];
        rY[21] = _guess[9];
        rY[23] = _guess[10];
        rY[22] = _guess[11];
        rY[20] = _guess[12];
    }

    std::vector<double> Cellpandit_model_2001_epiFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "pandit_model_2001_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.50146);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004164108);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6735613);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6729362);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.171081e-06);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_11_gate__f_11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_12_gate__f_12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_inact_gate__Ca_inact");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913102);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002191519);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9842542);

    // rY[10]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_slow_gate__s_slow");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6421196);

    // rY[11]:
    this->mVariableNames.push_back("steady_state_outward_K_current_r_ss_gate__r_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002907171);

    // rY[12]:
    this->mVariableNames.push_back("steady_state_outward_K_current_s_ss_gate__s_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3142767);

    // rY[13]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003578708);

    // rY[14]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004327548);

    // rY[15]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.06254e-10);

    // rY[16]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6348229);

    // rY[17]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3647471);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1394301);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0051619);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.73519);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.901351e-05);

    // rY[22]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.2751);

    // rY[23]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.737212e-05);

    // rY[24]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06607948);

    // rY[25]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06600742);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellpandit_model_2001_epiFromCellMLBackwardEuler)
