//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: NN_SAN_model_1984
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_noble_SAN_model_1984.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    double Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<7>(
                15,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler>::Instance();
        Init();
        
        this->mParameters[0] = 0.0060000000000000001; // (var_membrane__C) [microF]
    }

    Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::~Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler()
    {
    }
    
    double Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.8e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__extracellular_potassium_concentration__Kc = rY[13];
        // Units: millimolar; Initial value: 3.0
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[14];
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.01; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 1.25; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 6.0; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 6.0; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 7.5; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.070000000000000007; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 50.0; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_chaste_interface__extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 20.0; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.75; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_chaste_interface__extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_f + var_second_inward_current__i_si + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_p + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[7], double rResidual[7])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.785
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__extracellular_potassium_concentration__Kc = rCurrentGuess[0];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[1];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[2];
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rCurrentGuess[3];
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rCurrentGuess[4];
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rCurrentGuess[5];
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rCurrentGuess[6];
        
        //output_equations
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.01; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kb = 3.0; // millimolar
        const double var_extracellular_potassium_concentration__V_e = 0.00016076999999999999; // micrometre3
        const double var_extracellular_potassium_concentration__pf = 1.0; // per_second
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 1.25; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 6.0; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 6.0; // microS
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.080000000000000002; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.080000000000000002; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_intracellular_calcium_concentration__V_up = 0.050000000000000003 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_rel + var_intracellular_calcium_concentration__i_tr) / (var_intracellular_calcium_concentration__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_tr + var_intracellular_calcium_concentration__i_up) / (var_intracellular_calcium_concentration__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_second_inward_current__P_si = 7.5; // nanoA_per_millimolar
        const double var_second_inward_current_f2_gate__K_mf2 = 0.00050000000000000001; // millimolar
        const double var_second_inward_current_f2_gate__alpha_f2 = 10.0; // per_second
        const double var_second_inward_current_f2_gate__beta_f2 = var_chaste_interface__intracellular_calcium_concentration__Cai * var_second_inward_current_f2_gate__alpha_f2 / var_second_inward_current_f2_gate__K_mf2; // per_second
        const double var_second_inward_current_f2_gate__f2_orig_deriv = -(var_second_inward_current_f2_gate__alpha_f2 + var_second_inward_current_f2_gate__beta_f2) * var_chaste_interface__second_inward_current_f2_gate__f2 + var_second_inward_current_f2_gate__alpha_f2; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.001 * var_second_inward_current_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_intracellular_calcium_concentration__Cai_orig_deriv = -0.5 * (-var_intracellular_calcium_concentration__i_rel - 2.0 * var_Na_Ca_exchanger__i_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_calcium_background_current__i_Ca_b + var_intracellular_calcium_concentration__i_up + var_second_inward_current__i_siCa) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.001 * var_intracellular_calcium_concentration__Cai_orig_deriv; // millimolar / millisecond
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_sodium_background_current__g_Nab = 0.070000000000000007; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 50.0; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_chaste_interface__extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Nai_orig_deriv = -1.0 * (3.0 * var_sodium_potassium_pump__i_p + var_Na_Ca_exchanger__i_NaCa * var_Na_Ca_exchanger__n_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_fNa + var_second_inward_current__i_siNa + var_sodium_background_current__i_Na_b) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = 0.001 * var_intracellular_sodium_concentration__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K_max = 20.0; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.75; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_chaste_interface__extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_extracellular_potassium_concentration__i_mK = -2.0 * var_sodium_potassium_pump__i_p + var_hyperpolarising_activated_current__i_fK + var_second_inward_current__i_siK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // nanoA
        const double var_extracellular_potassium_concentration__Kc_orig_deriv = -(-var_extracellular_potassium_concentration__Kb + var_chaste_interface__extracellular_potassium_concentration__Kc) * var_extracellular_potassium_concentration__pf + var_extracellular_potassium_concentration__i_mK / (var_extracellular_potassium_concentration__V_e * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_extracellular_potassium_concentration__Kc = 0.001 * var_extracellular_potassium_concentration__Kc_orig_deriv; // millimolar / millisecond
        const double var_intracellular_potassium_concentration__Ki_orig_deriv = -1.0 * var_extracellular_potassium_concentration__i_mK / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.001 * var_intracellular_potassium_concentration__Ki_orig_deriv; // millimolar / millisecond
        
        rResidual[3] = rCurrentGuess[3] - rY[1] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        rResidual[6] = rCurrentGuess[6] - rY[8] - mDt*d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
        rResidual[5] = rCurrentGuess[5] - rY[9] - mDt*d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
        rResidual[2] = rCurrentGuess[2] - rY[10] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        rResidual[1] = rCurrentGuess[1] - rY[11] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        rResidual[0] = rCurrentGuess[0] - rY[13] - mDt*d_dt_chaste_interface_var_extracellular_potassium_concentration__Kc;
        rResidual[4] = rCurrentGuess[4] - rY[14] - mDt*d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;
    }

    void Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[7], double rJacobian[7][7])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.785
        
        double var_chaste_interface__extracellular_potassium_concentration__Kc = rCurrentGuess[0];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[1];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[2];
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rCurrentGuess[3];
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rCurrentGuess[4];
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rCurrentGuess[5];
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rCurrentGuess[6];
        
        const double var_x0 = -0.037433890822745473 * var_chaste_interface__membrane__V;
        const double var_x1 = exp(var_x0);
        const double var_x2 = 9.2094906201727277e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x3 = 0.074867781645490947 * var_chaste_interface__membrane__V;
        const double var_x4 = var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki;
        const double var_x5 = log(var_x4);
        const double var_x6 = exp(0.74867781645490938 + var_x3 - 2.0 * var_x5);
        const double var_x7 = 1.0 + var_x6;
        const double var_x8 = 1 / var_x7;
        const double var_x9 = 1 / (10.0 + var_chaste_interface__extracellular_potassium_concentration__Kc);
        const double var_x10 = var_x8 * var_x9;
        const double var_x11 = 0.0012916056731812832 * var_x10;
        const double var_x12 = var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (45.0 + var_chaste_interface__extracellular_potassium_concentration__Kc);
        const double var_x13 = 0.010332845385450266 * var_x12;
        const double var_x14 = -26.713760659695652 * var_x5 + var_chaste_interface__membrane__V;
        const double var_x15 = var_x10 * var_x14;
        const double var_x16 = var_x12 * var_x14;
        const double var_x17 = 1.0 + var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x18 = 1 / var_x17;
        const double var_x19 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai);
        const double var_x20 = var_x18 * var_x19;
        const double var_x21 = 0.0064466434341209095 * var_x20;
        const double var_x22 = var_x14 * var_x6 * var_x9 / pow(var_x7, 2);
        const double var_x23 = 9.6699651511813646e-5 * var_x22;
        const double var_x24 = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai;
        const double var_x25 = var_x19 * var_x24 / pow(var_x17, 2);
        const double var_x26 = var_x14 * var_chaste_interface__extracellular_potassium_concentration__Kc;
        const double var_x27 = var_x26 * var_x8 / pow((1 + 0.10000000000000001 * var_chaste_interface__extracellular_potassium_concentration__Kc), 2);
        const double var_x28 = var_chaste_interface__hyperpolarising_activated_current_y_gate__y / pow((1 + 0.022222222222222223 * var_chaste_interface__extracellular_potassium_concentration__Kc), 2);
        const double var_x29 = var_x26 * var_x28;
        const double var_x30 = exp(1.8716945411372736 + var_x0);
        const double var_x31 = var_x30 * var_chaste_interface__second_inward_current_f2_gate__f2;
        const double var_x32 = (-50.0 + var_chaste_interface__membrane__V) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f_gate__f;
        const double var_x33 = var_x32 / (1.0 - var_x30);
        const double var_x34 = 1.8099220986453831e-7 * var_x33;
        const double var_x35 = exp(1.8716945411372736);
        const double var_x36 = var_x35 * var_chaste_interface__second_inward_current_f2_gate__f2;
        const double var_x37 = var_x18 * var_x24 / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Nai), 2);
        const double var_x38 = var_x33 * (var_x35 * var_chaste_interface__intracellular_potassium_concentration__Ki - var_x30 * var_chaste_interface__extracellular_potassium_concentration__Kc);
        const double var_x39 = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x40 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
        const double var_x41 = 3.9999999999999998e-6 + var_x40;
        const double var_x42 = 1 / var_x41;
        const double var_x43 = var_x40 * var_x42;
        const double var_x44 = 0.19999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x45 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 3.0) / pow(var_x41, 2);
        const double var_x46 = var_x42 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 1.0);
        const double var_x47 = 0.002 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x48 = 0.0040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x49 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
        const double var_x50 = 1 / (1.0 + 0.00020000000000000001 * var_x49 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x51 = 0.018716945411372737 * var_chaste_interface__membrane__V;
        const double var_x52 = exp(var_x51);
        const double var_x53 = exp(-var_x51);
        const double var_x54 = 2.0 * var_x49 * var_x52 - 2744000.0 * var_x53 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        const double var_x55 = var_x50 * var_x54 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x56 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x57 = var_x50 * var_x56;
        const double var_x58 = var_x53 * var_x57;
        const double var_x59 = var_x54 * var_x56 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x49 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x60 = exp(3.7433890822745473);
        const double var_x61 = exp(3.7433890822745473 - var_x3);
        const double var_x62 = 4.0200601101640967e-6 * var_x32 / (1.0 - var_x61);
        const double var_x63 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 2.0);
        const double var_x64 = var_x52 * var_x57 * var_x63;
        const double var_x65 = var_x59 * var_x63;
        const double var_x66 = 1.0227707011477466e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x67 = 0.00014344077153110256 * var_x10;
        const double var_x68 = 0.0011475261722488205 * var_x12;
        const double var_x69 = 0.00071593949080342272 * var_x20;
        const double var_x70 = 1.073909236205134e-5 * var_x22;
        const double var_x71 = 2.0100300550820484e-8 * var_x33;
        const double var_x72 = -var_x36 * var_x71;
        const double var_x73 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x74 = 2.8688154306220512e-5 * var_x73;
        const double var_x75 = 0.0010739092362051341 * var_x20;
        const double var_x76 = 1 / var_chaste_interface__intracellular_sodium_concentration__Nai;
        const double var_x77 = -26.713760659695652 * log(140.0 * var_x76) + var_chaste_interface__membrane__V;
        const double var_x78 = 1 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki);
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.001 + var_x23 - var_x11 - var_x13 + 4.8349825755906823e-5 * var_x15 + 0.00038679860604725458 * var_x16 + 0.0064466434341209095 * var_x25 - 4.8349825755906825e-7 * var_x27 - 1.9101165730728621e-7 * var_x29 - var_x1 * var_x2 - var_x21 * var_chaste_interface__intracellular_sodium_concentration__Nai - var_x31 * var_x34));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = -(mDt * (var_x2 + var_x11 * var_x4 + var_x13 * var_x4 + var_x34 * var_x36 - var_x23 * var_x4));
        rJacobian[0][5] = -(mDt * (4.0291521463255683e-6 * var_x37 - var_x21 * var_chaste_interface__extracellular_potassium_concentration__Kc));
        rJacobian[0][6] = -(mDt * (1.8099220986453831e-7 * var_x38));
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (-var_x39 - 0.099999999999999992 * var_x43));
        rJacobian[1][2] = -(mDt * (var_x39));
        rJacobian[1][3] = -(mDt * (var_x44 * var_x45 - var_x44 * var_x46));
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (var_x47));
        rJacobian[2][2] = 1.0 - (mDt * (-var_x47 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Cai));
        rJacobian[2][3] = -(mDt * (3.9999999999999996 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Ca_up));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = -(mDt * (0.002 * var_x43));
        rJacobian[3][2] = -(mDt * (0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Cai));
        rJacobian[3][3] = 1.0 - (mDt * (-0.19999999999999998 + 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 9.8799649730872331e-11 * var_x55 - 4.7813590510367518e-7 / var_chaste_interface__intracellular_calcium_concentration__Cai - 0.039290759255291838 * var_x58 - 5.2182178629987073e-11 * var_x59 + var_x46 * var_x48 - var_x45 * var_x48 - var_x60 * var_x62 * var_chaste_interface__second_inward_current_f2_gate__f2));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (8.5912738896410719e-8 * var_x64 - 1.1410097368072975e-16 * var_x65));
        rJacobian[3][6] = -(mDt * (-var_x62 * (-2.0 * var_x61 + var_x60 * var_chaste_interface__intracellular_calcium_concentration__Cai)));
        rJacobian[4][0] = -(mDt * (var_x67 + var_x68 - var_x70 + 2.1213021949731043e-8 * var_x29 + 5.3695461810256699e-8 * var_x27 - 5.3695461810256699e-6 * var_x15 - 4.2956369448205359e-5 * var_x16 - 0.00071593949080342272 * var_x25 + var_x1 * var_x66 + var_x31 * var_x71 + var_x69 * var_chaste_interface__intracellular_sodium_concentration__Nai));
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (var_x72 - var_x66 + var_x4 * var_x70 - var_x4 * var_x67 - var_x4 * var_x68));
        rJacobian[4][5] = -(mDt * (-4.4746218175213919e-7 * var_x37 + var_x69 * var_chaste_interface__extracellular_potassium_concentration__Kc));
        rJacobian[4][6] = -(mDt * (-2.0100300550820484e-8 * var_x38));
        rJacobian[5][0] = -(mDt * (0.0010739092362051341 * var_x25 + var_x74 / (140.0 + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) - var_x75 * var_chaste_interface__intracellular_sodium_concentration__Nai - 4.2956369448205359e-5 * var_x12 * var_x77 + 2.1213021949731043e-8 * var_x28 * var_x77 * var_chaste_interface__extracellular_potassium_concentration__Kc));
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (1.5654653588996123e-10 * var_x59 + 2.9639894919261698e-10 * var_x55 + 0.11787227776587551 * var_x58));
        rJacobian[5][4] = -(mDt * (-var_x74 * var_x78));
        rJacobian[5][5] = 1.0 - (mDt * (var_x72 + 6.7119327262820874e-7 * var_x37 + 3.4230292104218926e-16 * var_x65 - 2.5773821668923216e-7 * var_x64 - 1.3387805342902908e-5 * var_x76 - var_x75 * var_chaste_interface__extracellular_potassium_concentration__Kc - 0.0002390679525518376 * var_x73 * var_x78 - var_x68 * var_x76 * var_chaste_interface__extracellular_potassium_concentration__Kc));
        rJacobian[5][6] = -(mDt * (-var_x71 * (-140.0 * var_x30 + var_x35 * var_chaste_interface__intracellular_sodium_concentration__Nai)));
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = -(mDt * (-20.0 * var_chaste_interface__second_inward_current_f2_gate__f2));
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.01 - 20.0 * var_chaste_interface__intracellular_calcium_concentration__Cai));
    }

    void Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.8e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__extracellular_potassium_concentration__Kc = rY[13];
        // Units: millimolar; Initial value: 3.0
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[14];
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.01; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 1.25; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 6.0; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 6.0; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_chaste_interface__extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_chaste_interface__extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (var_chaste_interface__extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 7.5; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.070000000000000007; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 50.0; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_chaste_interface__extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_chaste_interface__extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 20.0; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.75; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_chaste_interface__extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -60.0
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.007
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.54
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.076
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.015
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0011
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.785
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.785
        
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5;
        const double var_hyperpolarising_activated_current_y_gate__delta_y = 1.0000000000000001e-5;
        const double var_hyperpolarising_activated_current_y_gate__speed_y = 2.0;
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V);
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V;
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m))));
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
        const double var_hyperpolarising_activated_current_y_gate__E0_y = 52.0 + var_chaste_interface__membrane__V;
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.050000000000000003 * exp(-0.067000000000000004 * var_hyperpolarising_activated_current_y_gate__E0_y);
        const double var_hyperpolarising_activated_current_y_gate__beta_y = ((var_hyperpolarising_activated_current_y_gate__delta_y > fabs(var_hyperpolarising_activated_current_y_gate__E0_y)) ? (2.5) : (var_hyperpolarising_activated_current_y_gate__E0_y / (1.0 - 1.0 * exp(-0.20000000000000001 * var_hyperpolarising_activated_current_y_gate__E0_y))));
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V;
        const double var_intracellular_calcium_concentration__alpha_p = 0.625 * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p));
        const double var_intracellular_calcium_concentration__beta_p = 5.0 / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p));
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V;
        const double var_second_inward_current_d_gate__delta_d = 0.0001;
        const double var_second_inward_current_d_gate__alpha_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d))));
        const double var_second_inward_current_d_gate__beta_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d))));
        const double var_second_inward_current_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V;
        const double var_second_inward_current_f_gate__beta_f = 50.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V));
        const double var_second_inward_current_f_gate__delta_f = 0.0001;
        const double var_second_inward_current_f_gate__alpha_f = ((var_second_inward_current_f_gate__delta_f > fabs(var_second_inward_current_f_gate__E0_f)) ? (25.0) : (6.25 * var_second_inward_current_f_gate__E0_f / (-1.0 + exp(0.25 * var_second_inward_current_f_gate__E0_f))));
        const double var_time_dependent_potassium_current_x_gate__E0_x = 22.0 + var_chaste_interface__membrane__V;
        const double var_time_dependent_potassium_current_x_gate__delta_x = 0.0001;
        const double var_time_dependent_potassium_current_x_gate__alpha_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (0.5 * var_time_dependent_potassium_current_x_gate__E0_x / (1.0 - exp(-0.20000000000000001 * var_time_dependent_potassium_current_x_gate__E0_x))));
        const double var_time_dependent_potassium_current_x_gate__beta_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (0.17799999999999999 * var_time_dependent_potassium_current_x_gate__E0_x / (-1.0 + exp(0.066666666666666666 * var_time_dependent_potassium_current_x_gate__E0_x))));
        
        
        rY[5] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((0.001 * var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_h_gate__alpha_h - 0.001 * var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[4] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((0.001 * var_fast_sodium_current_m_gate__alpha_m) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_m_gate__alpha_m - 0.001 * var_fast_sodium_current_m_gate__beta_m) * mDt));
        rY[2] = (var_chaste_interface__hyperpolarising_activated_current_y_gate__y + ((0.001 * var_hyperpolarising_activated_current_y_gate__alpha_y * var_hyperpolarising_activated_current_y_gate__speed_y) * mDt)) / (1.0 - ((-0.001 * var_hyperpolarising_activated_current_y_gate__alpha_y * var_hyperpolarising_activated_current_y_gate__speed_y - 0.001 * var_hyperpolarising_activated_current_y_gate__beta_y * var_hyperpolarising_activated_current_y_gate__speed_y) * mDt));
        rY[12] = (var_chaste_interface__intracellular_calcium_concentration__p + ((0.001 * var_intracellular_calcium_concentration__alpha_p) * mDt)) / (1.0 - ((-0.001 * var_intracellular_calcium_concentration__alpha_p - 0.001 * var_intracellular_calcium_concentration__beta_p) * mDt));
        rY[6] = (var_chaste_interface__second_inward_current_d_gate__d + ((0.001 * var_second_inward_current_d_gate__alpha_d) * mDt)) / (1.0 - ((-0.001 * var_second_inward_current_d_gate__alpha_d - 0.001 * var_second_inward_current_d_gate__beta_d) * mDt));
        rY[7] = (var_chaste_interface__second_inward_current_f_gate__f + ((0.001 * var_second_inward_current_f_gate__alpha_f) * mDt)) / (1.0 - ((-0.001 * var_second_inward_current_f_gate__alpha_f - 0.001 * var_second_inward_current_f_gate__beta_f) * mDt));
        rY[3] = (var_chaste_interface__time_dependent_potassium_current_x_gate__x + ((0.001 * var_time_dependent_potassium_current_x_gate__alpha_x) * mDt)) / (1.0 - ((-0.001 * var_time_dependent_potassium_current_x_gate__alpha_x - 0.001 * var_time_dependent_potassium_current_x_gate__beta_x) * mDt));
        
        double _guess[7] = {rY[13],rY[11],rY[10],rY[1],rY[14],rY[9],rY[8]};
        CardiacNewtonSolver<7,Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<7,Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[13] = _guess[0];
        rY[11] = _guess[1];
        rY[10] = _guess[2];
        rY[1] = _guess[3];
        rY[14] = _guess[4];
        rY[9] = _guess[5];
        rY[8] = _guess[6];
    }

    std::vector<double> Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "NN_SAN_model_1984";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-60.0);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.8e-05);

    // rY[2]:
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007);

    // rY[3]:
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.54);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.076);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015);

    // rY[6]:
    this->mVariableNames.push_back("second_inward_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0011);

    // rY[7]:
    this->mVariableNames.push_back("second_inward_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // rY[8]:
    this->mVariableNames.push_back("second_inward_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // rY[9]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.5);

    // rY[10]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.98);

    // rY[11]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.55);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__p");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.785);

    // rY[13]:
    this->mVariableNames.push_back("extracellular_potassium_concentration__Kc");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.0);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_noble_SAN_model_1984FromCellMLBackwardEuler)
