//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: Noble_SAN_model_1989
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_SAN_model_1989.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    double Cellnoble_SAN_model_1989FromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnoble_SAN_model_1989FromCellMLBackwardEuler::Cellnoble_SAN_model_1989FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<6>(
                14,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLBackwardEuler>::Instance();
        Init();
        
        this->mParameters[0] = 6.0000000000000002e-5; // (var_membrane__C) [microF]
    }

    Cellnoble_SAN_model_1989FromCellMLBackwardEuler::~Cellnoble_SAN_model_1989FromCellMLBackwardEuler()
    {
    }
    
    double Cellnoble_SAN_model_1989FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_f + var_second_inward_current__i_si + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_p + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_SAN_model_1989FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[6], double rResidual[6])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[0];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[1];
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rCurrentGuess[2];
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rCurrentGuess[3];
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rCurrentGuess[4];
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rCurrentGuess[5];
        
        //output_equations
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_intracellular_calcium_concentration__V_up = 0.050000000000000003 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_rel + var_intracellular_calcium_concentration__i_tr) / (var_intracellular_calcium_concentration__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_tr + var_intracellular_calcium_concentration__i_up) / (var_intracellular_calcium_concentration__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current_f2_gate__K_mf2 = 0.00050000000000000001; // millimolar
        const double var_second_inward_current_f2_gate__alpha_f2 = 10.0; // per_second
        const double var_second_inward_current_f2_gate__beta_f2 = var_chaste_interface__intracellular_calcium_concentration__Cai * var_second_inward_current_f2_gate__alpha_f2 / var_second_inward_current_f2_gate__K_mf2; // per_second
        const double var_second_inward_current_f2_gate__f2_orig_deriv = -(var_second_inward_current_f2_gate__alpha_f2 + var_second_inward_current_f2_gate__beta_f2) * var_chaste_interface__second_inward_current_f2_gate__f2 + var_second_inward_current_f2_gate__alpha_f2; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.001 * var_second_inward_current_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_intracellular_calcium_concentration__Cai_orig_deriv = -0.5 * (-var_intracellular_calcium_concentration__i_rel - 2.0 * var_Na_Ca_exchanger__i_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_calcium_background_current__i_Ca_b + var_intracellular_calcium_concentration__i_up + var_second_inward_current__i_siCa) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.001 * var_intracellular_calcium_concentration__Cai_orig_deriv; // millimolar / millisecond
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Nai_orig_deriv = -1.0 * (3.0 * var_sodium_potassium_pump__i_p + var_Na_Ca_exchanger__i_NaCa * var_Na_Ca_exchanger__n_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_fNa + var_second_inward_current__i_siNa + var_sodium_background_current__i_Na_b) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = 0.001 * var_intracellular_sodium_concentration__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_intracellular_potassium_concentration__i_mK = -2.0 * var_sodium_potassium_pump__i_p + var_hyperpolarising_activated_current__i_fK + var_second_inward_current__i_siK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // nanoA
        const double var_intracellular_potassium_concentration__Ki_orig_deriv = -1.0 * var_intracellular_potassium_concentration__i_mK / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.001 * var_intracellular_potassium_concentration__Ki_orig_deriv; // millimolar / millisecond
        
        rResidual[2] = rCurrentGuess[2] - rY[1] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        rResidual[5] = rCurrentGuess[5] - rY[8] - mDt*d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
        rResidual[4] = rCurrentGuess[4] - rY[9] - mDt*d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
        rResidual[1] = rCurrentGuess[1] - rY[10] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        rResidual[0] = rCurrentGuess[0] - rY[11] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        rResidual[3] = rCurrentGuess[3] - rY[13] - mDt*d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;
    }

    void Cellnoble_SAN_model_1989FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[6], double rJacobian[6][6])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[0];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[1];
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rCurrentGuess[2];
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rCurrentGuess[3];
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rCurrentGuess[4];
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rCurrentGuess[5];
        
        const double var_x0 = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x1 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
        const double var_x2 = 3.9999999999999998e-6 + var_x1;
        const double var_x3 = 1 / var_x2;
        const double var_x4 = var_x1 * var_x3;
        const double var_x5 = 0.19999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x6 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 3.0) / pow(var_x2, 2);
        const double var_x7 = var_x3 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 1.0);
        const double var_x8 = 0.002 * var_chaste_interface__intracellular_calcium_concentration__p;
        const double var_x9 = 0.0040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
        const double var_x10 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
        const double var_x11 = 1 / (1.0 + 0.00020000000000000001 * var_x10 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x12 = 0.018716945411372737 * var_chaste_interface__membrane__V;
        const double var_x13 = exp(var_x12);
        const double var_x14 = exp(-var_x12);
        const double var_x15 = 2.0 * var_x10 * var_x13 - 2744000.0 * var_x14 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        const double var_x16 = var_x11 * var_x15 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x17 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
        const double var_x18 = var_x11 * var_x17;
        const double var_x19 = var_x14 * var_x18;
        const double var_x20 = var_x15 * var_x17 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x10 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
        const double var_x21 = exp(3.7433890822745473);
        const double var_x22 = 0.074867781645490947 * var_chaste_interface__membrane__V;
        const double var_x23 = exp(3.7433890822745473 - var_x22);
        const double var_x24 = (-50.0 + var_chaste_interface__membrane__V) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f_gate__f;
        const double var_x25 = 1.1761547293737243e-5 * var_x24 / (1.0 - var_x23);
        const double var_x26 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 2.0);
        const double var_x27 = var_x13 * var_x18 * var_x26;
        const double var_x28 = var_x20 * var_x26;
        const double var_x29 = 1 / var_chaste_interface__intracellular_potassium_concentration__Ki;
        const double var_x30 = 0.00013114584825700806 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
        const double var_x31 = log(3.0 * var_x29);
        const double var_x32 = exp(0.74867781645490938 + var_x22 - 2.0 * var_x31);
        const double var_x33 = 1.0 + var_x32;
        const double var_x34 = exp(1.8716945411372736);
        const double var_x35 = exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V);
        const double var_x36 = 5.8807736468686208e-8 * var_x24 / (1.0 - var_x35);
        const double var_x37 = -var_x34 * var_x36 * var_chaste_interface__second_inward_current_f2_gate__f2;
        const double var_x38 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai);
        const double var_x39 = var_chaste_interface__intracellular_sodium_concentration__Nai / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Nai), 2);
        const double var_x40 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (0.0008549444286121402 * var_chaste_interface__intracellular_potassium_concentration__Ki + 0.0071245369051011684 * var_chaste_interface__intracellular_sodium_concentration__Nai) * var_chaste_interface__fast_sodium_current_h_gate__h / pow((var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki), 2);
        const double var_x41 = 1 / var_chaste_interface__intracellular_sodium_concentration__Nai;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-var_x0 - 0.099999999999999992 * var_x4));
        rJacobian[0][1] = -(mDt * (var_x0));
        rJacobian[0][2] = -(mDt * (var_x5 * var_x6 - var_x5 * var_x7));
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[1][0] = -(mDt * (var_x8));
        rJacobian[1][1] = 1.0 - (mDt * (-var_x8 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Cai));
        rJacobian[1][2] = -(mDt * (3.9999999999999996 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Ca_up));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[2][0] = -(mDt * (0.002 * var_x4));
        rJacobian[2][1] = -(mDt * (0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Cai));
        rJacobian[2][2] = 1.0 - (mDt * (-0.19999999999999998 + 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 1.8066221665073799e-10 * var_x16 - 0.071845959781105084 * var_x19 - 9.5418840923404938e-11 * var_x20 - 8.7430565504672044e-7 / var_chaste_interface__intracellular_calcium_concentration__Cai + var_x7 * var_x9 - var_x6 * var_x9 - var_x21 * var_x25 * var_chaste_interface__second_inward_current_f2_gate__f2));
        rJacobian[2][3] = 0.0;
        rJacobian[2][4] = -(mDt * (1.5709757969629391e-7 * var_x27 - 2.0864178044476298e-16 * var_x28));
        rJacobian[2][5] = -(mDt * (-var_x25 * (-2.0 * var_x23 + var_x21 * var_chaste_interface__intracellular_calcium_concentration__Cai)));
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = 0.0;
        rJacobian[3][3] = 1.0 - (mDt * (var_x37 - 7.4808371283949473e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x - var_x29 * var_x30 - 6.0528853041696024e-5 * var_x29 / var_x33 + 4.5316609527777084e-6 * var_x29 * var_x32 * (-26.713760659695652 * var_x31 + var_chaste_interface__membrane__V) / pow(var_x33, 2)));
        rJacobian[3][4] = -(mDt * (0.0008836738857916531 * var_x38 - 5.5229617861978321e-7 * var_x39));
        rJacobian[3][5] = -(mDt * (-var_x36 * (-3.0 * var_x35 + var_x34 * var_chaste_interface__intracellular_potassium_concentration__Ki)));
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = -(mDt * (0.21553787934331523 * var_x19 + 5.4198664995221396e-10 * var_x16 + 2.862565227702148e-10 * var_x20));
        rJacobian[4][3] = -(mDt * (-0.00736305250454146 * var_x40));
        rJacobian[4][4] = 1.0 - (mDt * (var_x37 + 8.2844426792967482e-7 * var_x39 + 6.2592534133428895e-16 * var_x28 - 4.7129273908888172e-7 * var_x27 - 0.0013255108286874798 * var_x38 - 0.061358770871178837 * var_x40 - 2.4480558341308171e-5 * var_x41 - var_x30 * var_x41));
        rJacobian[4][5] = -(mDt * (-var_x36 * (-140.0 * var_x35 + var_x34 * var_chaste_interface__intracellular_sodium_concentration__Nai)));
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = -(mDt * (-20.0 * var_chaste_interface__second_inward_current_f2_gate__f2));
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-0.01 - 20.0 * var_chaste_interface__intracellular_calcium_concentration__Cai));
    }

    void Cellnoble_SAN_model_1989FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellnoble_SAN_model_1989FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5;
        const double var_hyperpolarising_activated_current_y_gate__speed_y = 2.0;
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V);
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V;
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m))));
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.014 * exp(-0.0625 * var_chaste_interface__membrane__V);
        const double var_hyperpolarising_activated_current_y_gate__beta_y = 9.75 * exp(0.052631578947368418 * var_chaste_interface__membrane__V);
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V;
        const double var_intracellular_calcium_concentration__alpha_p = 0.625 * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p));
        const double var_intracellular_calcium_concentration__beta_p = 5.0 / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p));
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V;
        const double var_second_inward_current_d_gate__delta_d = 0.0001;
        const double var_second_inward_current_d_gate__alpha_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d))));
        const double var_second_inward_current_d_gate__beta_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d))));
        const double var_second_inward_current_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V;
        const double var_second_inward_current_f_gate__beta_f = 50.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V));
        const double var_second_inward_current_f_gate__delta_f = 0.0001;
        const double var_second_inward_current_f_gate__alpha_f = ((var_second_inward_current_f_gate__delta_f > fabs(var_second_inward_current_f_gate__E0_f)) ? (25.0) : (6.25 * var_second_inward_current_f_gate__E0_f / (-1.0 + exp(0.25 * var_second_inward_current_f_gate__E0_f))));
        const double var_time_dependent_potassium_current_x_gate__alpha_x = 2.1000000000000001 * exp(0.035714285714285712 * var_chaste_interface__membrane__V);
        const double var_time_dependent_potassium_current_x_gate__beta_x = 0.95999999999999996 * exp(-0.041666666666666664 * var_chaste_interface__membrane__V);
        
        
        rY[5] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((0.001 * var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_h_gate__alpha_h - 0.001 * var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[4] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((0.001 * var_fast_sodium_current_m_gate__alpha_m) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_m_gate__alpha_m - 0.001 * var_fast_sodium_current_m_gate__beta_m) * mDt));
        rY[2] = (var_chaste_interface__hyperpolarising_activated_current_y_gate__y + ((0.001 * var_hyperpolarising_activated_current_y_gate__alpha_y * var_hyperpolarising_activated_current_y_gate__speed_y) * mDt)) / (1.0 - ((-0.001 * var_hyperpolarising_activated_current_y_gate__alpha_y * var_hyperpolarising_activated_current_y_gate__speed_y - 0.001 * var_hyperpolarising_activated_current_y_gate__beta_y * var_hyperpolarising_activated_current_y_gate__speed_y) * mDt));
        rY[12] = (var_chaste_interface__intracellular_calcium_concentration__p + ((0.001 * var_intracellular_calcium_concentration__alpha_p) * mDt)) / (1.0 - ((-0.001 * var_intracellular_calcium_concentration__alpha_p - 0.001 * var_intracellular_calcium_concentration__beta_p) * mDt));
        rY[6] = (var_chaste_interface__second_inward_current_d_gate__d + ((0.001 * var_second_inward_current_d_gate__alpha_d) * mDt)) / (1.0 - ((-0.001 * var_second_inward_current_d_gate__alpha_d - 0.001 * var_second_inward_current_d_gate__beta_d) * mDt));
        rY[7] = (var_chaste_interface__second_inward_current_f_gate__f + ((0.001 * var_second_inward_current_f_gate__alpha_f) * mDt)) / (1.0 - ((-0.001 * var_second_inward_current_f_gate__alpha_f - 0.001 * var_second_inward_current_f_gate__beta_f) * mDt));
        rY[3] = (var_chaste_interface__time_dependent_potassium_current_x_gate__x + ((0.001 * var_time_dependent_potassium_current_x_gate__alpha_x) * mDt)) / (1.0 - ((-0.001 * var_time_dependent_potassium_current_x_gate__alpha_x - 0.001 * var_time_dependent_potassium_current_x_gate__beta_x) * mDt));
        
        double _guess[6] = {rY[11],rY[10],rY[1],rY[13],rY[9],rY[8]};
        CardiacNewtonSolver<6,Cellnoble_SAN_model_1989FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<6,Cellnoble_SAN_model_1989FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[11] = _guess[0];
        rY[10] = _guess[1];
        rY[1] = _guess[2];
        rY[13] = _guess[3];
        rY[9] = _guess[4];
        rY[8] = _guess[5];
    }

    std::vector<double> Cellnoble_SAN_model_1989FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "Noble_SAN_model_1989";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-69.1865);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.6e-05);

    // rY[2]:
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0822);

    // rY[3]:
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1231);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0365);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1969);

    // rY[6]:
    this->mVariableNames.push_back("second_inward_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[7]:
    this->mVariableNames.push_back("second_inward_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9997);

    // rY[8]:
    this->mVariableNames.push_back("second_inward_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5765);

    // rY[9]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.5);

    // rY[10]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.3909);

    // rY[11]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.2207);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__p");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.237);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_SAN_model_1989FromCellMLBackwardEuler)
