//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: matsuoka_model_2003
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "matsuoka_model_2003.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellmatsuoka_model_2003FromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 400.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellmatsuoka_model_2003FromCellMLBackwardEuler::Cellmatsuoka_model_2003FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<25>(
                37,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 132.0; // (var_membrane__Cm) [picoF]
    }

    Cellmatsuoka_model_2003FromCellMLBackwardEuler::~Cellmatsuoka_model_2003FromCellMLBackwardEuler()
    {
    }
    
    double Cellmatsuoka_model_2003FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * mParameters[0] * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * mParameters[0] * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * mParameters[0] * var_sodium_potassium_pump__P_NaK; // picoA
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * mParameters[0] * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
        const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmatsuoka_model_2003FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[25], double rResidual[25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__ATP_production__ATPi = rCurrentGuess[0];
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rCurrentGuess[1];
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rCurrentGuess[5];
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rCurrentGuess[6];
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rCurrentGuess[7];
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rCurrentGuess[8];
        double var_chaste_interface__NL_model__pCB = rCurrentGuess[9];
        double var_chaste_interface__NL_model__pCa = rCurrentGuess[10];
        double var_chaste_interface__NL_model__pCaCB = rCurrentGuess[11];
        double var_chaste_interface__RyR_channel__p_close_RyR = rCurrentGuess[12];
        double var_chaste_interface__RyR_channel__p_open_RyR = rCurrentGuess[13];
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rCurrentGuess[14];
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rCurrentGuess[15];
        double var_chaste_interface__internal_ion_concentrations__Ki = rCurrentGuess[16];
        double var_chaste_interface__internal_ion_concentrations__Nai = rCurrentGuess[17];
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rCurrentGuess[18];
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rCurrentGuess[19];
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rCurrentGuess[20];
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rCurrentGuess[21];
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rCurrentGuess[22];
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rCurrentGuess[23];
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rCurrentGuess[24];
        
        //output_equations
        const double var_ATP_production__Adenosine_Total = 5.0; // millimolar
        const double var_ATP_production__ProducingRate_Max = 0.0030000000000000001; // per_millisecond
        const double var_Ca_concentrations_in_SR__CSQN_max = 10.0; // millimolar
        const double var_Ca_concentrations_in_SR__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_Ca_concentrations_in_SR__V_rel = 160.0; // micrometre3
        const double var_Ca_concentrations_in_SR__V_up = 400.0; // micrometre3
        const double var_Ca_concentrations_in_SR__b1 = -var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + var_Ca_concentrations_in_SR__CSQN_max + var_Ca_concentrations_in_SR__K_mCSQN; // millimolar
        const double var_Ca_concentrations_in_SR__c1 = var_chaste_interface__Ca_concentrations_in_SR__Ca_Total * var_Ca_concentrations_in_SR__K_mCSQN; // millimolar2
        const double var_Ca_concentrations_in_SR__Carel = sqrt(0.25 * pow(var_Ca_concentrations_in_SR__b1, 2) + var_Ca_concentrations_in_SR__c1) - 0.5 * var_Ca_concentrations_in_SR__b1; // millimolar
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C = 0.0041999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa = 0.00029999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_U = 0.14299999999999999; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_C = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa / (var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_C); // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP = 0.001; // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI = 0.0040000000000000001; // per_millisecond
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double var_NL_model__B = 1.2; // per_millisecond
        const double var_NL_model__L = 0.96237999754118841; // micrometre
        const double var_NL_model__L_a = 1.1699999999999999; // micrometre
        const double var_NL_model__EffFraction = exp(-20.0 * pow((-var_NL_model__L_a + var_NL_model__L), 2)); // dimensionless
        const double var_NL_model__T_t = 0.070000000000000007; // millimolar
        const double var_NL_model__Y_1 = 39.0; // per_millimolar_millisecond
        const double var_NL_model__Y_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Y_3 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Y_4 = 0.12; // per_millisecond
        const double var_NL_model__Y_d = 0.027; // millisecond_per_micrometre2
        const double var_NL_model__Z_1 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Z_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Z_3 = 1560.0; // per_millimolar_millisecond
        const double var_NL_model__h = -var_chaste_interface__NL_model__X + var_NL_model__L; // micrometre
        const double var_NL_model__h_c = 0.0050000000000000001; // micrometre
        const double d_dt_chaste_interface_var_NL_model__X = (-var_NL_model__h_c + var_NL_model__h) * var_NL_model__B; // micrometre / millisecond
        const double var_NL_model__Q_d = var_NL_model__Y_4 * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_d1 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_a = -var_NL_model__Z_2 * var_chaste_interface__NL_model__pCaCB + var_NL_model__EffFraction * var_NL_model__Y_2 * var_chaste_interface__NL_model__pCa; // per_millisecond
        const double var_NL_model__Q_d2 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_NL_model__dATPdt = -0.40000000000000002 * var_NL_model__T_t * var_chaste_interface__NL_model__pCaCB; // millimolar_per_millisecond
        const double var_NL_model__p = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB; // dimensionless
        const double var_RyR_channel__Diadid_Factor = -150.0; // per_picoA_millisecond
        const double var_RyR_channel__P_RyR = 62000.0; // picoA_per_millimolar
        const double var_RyR_channel__k2 = 0.080000000000000002 / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // per_millisecond
        const double var_RyR_channel__k3 = 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2); // per_millisecond
        const double var_RyR_channel__k4 = 0.00084900000000000004; // per_millisecond
        const double var_SR_L_current__P_SR_L = 459.0; // picoA_per_millimolar
        const double var_SR_T_current__P_SR_T = 386.0; // picoA_per_millimolar
        const double var_SR_T_current__i_SR_T = (-var_Ca_concentrations_in_SR__Carel + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_T_current__P_SR_T; // picoA
        const double var_SR_calcium_pump__Km_ATP = 0.10000000000000001; // millimolar
        const double var_SR_calcium_pump__Km_CaCyto = 0.00080000000000000004; // millimolar
        const double var_SR_calcium_pump__Km_CaSR = 0.080000000000000002; // millimolar
        const double var_SR_calcium_pump__i_max = 162500.0; // picoA
        const double var_SR_calcium_pump__k1 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + var_SR_calcium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__k3 = 1.0; // per_millisecond
        const double var_SR_calcium_pump__k4 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaSR / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_SR_calcium_pump__p_E1 = 1.0 - var_SR_calcium_pump__p_E1Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__beta_y = var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca + var_SR_calcium_pump__k3 * var_SR_calcium_pump__p_E1; // per_millisecond
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__Vi = 8000.0; // micrometre3
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_NL_model__Q_b = -var_NL_model__Z_1 * var_chaste_interface__NL_model__pCa + var_NL_model__Y_1 * var_NL_model__p * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond
        const double var_NL_model__Q_r = var_NL_model__Y_3 * var_chaste_interface__NL_model__pCaCB - var_NL_model__Z_3 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -var_NL_model__Q_d - var_NL_model__Q_d1 + var_NL_model__Q_r; // 1 / millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond
        const double var_NL_model__dCaidt = (-var_NL_model__Q_b + var_NL_model__Q_d2 + var_NL_model__Q_r) * var_NL_model__T_t; // millimolar_per_millisecond
        const double var_RyR_channel__i_RyR = (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_RyR_channel__P_RyR * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = (-var_internal_ion_concentrations__Cai + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_L_current__P_SR_L; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaCyto / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = (var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) * var_SR_calcium_pump__i_max; // picoA
        const double var_SR_calcium_pump__p_E2 = 1.0 - var_SR_calcium_pump__p_E2Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__alpha_y = var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k4 * var_SR_calcium_pump__p_E2; // per_millisecond
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump_y_gate__alpha_y - var_SR_calcium_pump_y_gate__beta_y * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 0.5 * (-var_RyR_channel__i_RyR + var_SR_T_current__i_SR_T) / (var_Ca_concentrations_in_SR__V_rel * var_membrane__F); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = 0.5 * (-var_SR_L_current__i_SR_L - var_SR_T_current__i_SR_T - var_SR_calcium_pump__i_SR_U) / (var_Ca_concentrations_in_SR__V_up * var_membrane__F); // millimolar / millisecond
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP = 0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic = var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_Ca_dependent_gate__k_C_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffC = var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffU = (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + var_L_type_Ca_channel_Ca_dependent_gate__CaEffC; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = var_L_type_Ca_channel_Ca_dependent_gate__CaEffU * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // 1 / millisecond
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) + var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic * var_RyR_channel__Diadid_Factor; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR) * var_RyR_channel__k3 - (var_RyR_channel__k1 + var_RyR_channel__k4) * var_chaste_interface__RyR_channel__p_close_RyR; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - var_RyR_channel__k2 * var_chaste_interface__RyR_channel__p_open_RyR; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_ext = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_ext_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * mParameters[0] * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 = 3.7000000000000002 * var_internal_ion_concentrations__Cai; // per_millisecond
        const double var_slow_time_dependent_potassium_current_y2_gate__beta_y2 = 0.004444; // per_millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 - var_slow_time_dependent_potassium_current_y2_gate__beta_y2 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k3 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__k4 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Ca = 1 / (1.0 + (1.0 + pow(var_chaste_interface__internal_ion_concentrations__Nai, 3) / pow(var_sodium_calcium_exchanger__Km_Nai, 3)) * var_sodium_calcium_exchanger__Km_Cai / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Ca = 1 / (1.0 + (1.0 + pow(var_external_ion_concentrations__Nao, 3) / pow(var_sodium_calcium_exchanger__Km_Nao, 3)) * var_sodium_calcium_exchanger__Km_Cao / var_external_ion_concentrations__Cao); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger_y_gate__alpha_y = var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na + var_sodium_calcium_exchanger__k4 * var_sodium_calcium_exchanger__p_E2Ca; // per_millisecond
        const double var_sodium_calcium_exchanger_y_gate__beta_y = var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na + var_sodium_calcium_exchanger__k3 * var_sodium_calcium_exchanger__p_E1Ca; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger_y_gate__alpha_y - var_sodium_calcium_exchanger_y_gate__beta_y * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * mParameters[0] * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_internal_ion_concentrations__i_net_Ca = -2.0 * var_sodium_calcium_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaL_Ca + var_T_type_Ca_channel__i_Ca_T + var_background_Cab_current__i_Cab; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.5 * (-var_internal_ion_concentrations__i_net_Ca + var_RyR_channel__i_RyR + var_SR_L_current__i_SR_L + var_SR_calcium_pump__i_SR_U) / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dCaidt; // millimolar / millisecond
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current_voltage_dependent_gate__k_AI_AP = 8.7499999999999999e-5; // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + var_sodium_current_voltage_dependent_gate__k_AI_AP * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_RP = 0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = var_sodium_current_voltage_dependent_gate__k_AI_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_AI_AP + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_RP * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__k3 = 0.01; // per_millisecond
        const double var_sodium_potassium_pump__k4 = 0.16500000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ki / var_chaste_interface__internal_ion_concentrations__Ki), 1.1200000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Nai / var_sodium_potassium_pump__Km_Nai), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ko / var_external_ion_concentrations__Ko), 1.1200000000000001) * (1.0 + pow((var_sodium_potassium_pump__Nao_Eff / var_sodium_potassium_pump__Km_Nao), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump_y_gate__alpha_y = var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k4 * var_sodium_potassium_pump__p_E2K; // per_millisecond
        const double var_sodium_potassium_pump_y_gate__beta_y = var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na + var_sodium_potassium_pump__k3 * var_sodium_potassium_pump__p_E1K; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump_y_gate__alpha_y - var_sodium_potassium_pump_y_gate__beta_y * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * mParameters[0] * var_sodium_potassium_pump__P_NaK; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = (-var_chaste_interface__ATP_production__ATPi + var_ATP_production__Adenosine_Total) * var_ATP_production__ProducingRate_Max - var_sodium_potassium_pump__i_NaK / (var_internal_ion_concentrations__Vi * var_membrane__F) + 0.25 * var_SR_calcium_pump__i_SR_U / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dATPdt; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * mParameters[0] * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current_y_gate__alpha_y = 1 / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current_y_gate__beta_y = pow(var_time_independent_potassium_current__fO, 4) / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) * var_time_independent_potassium_current_y_gate__alpha_y - var_time_independent_potassium_current_y_gate__beta_y * var_chaste_interface__time_independent_potassium_current_y_gate__y; // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_K = -2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_K + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC_K + var_background_lCa_current__i_lCa_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks_K + var_sodium_current__i_Na_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to_K; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = (-var_internal_ion_concentrations__i_net_K - var_membrane__i_ext) / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_Na = 3.0 * var_sodium_calcium_exchanger__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_Na + var_background_NSC_current__i_bNSC_Na + var_background_lCa_current__i_lCa_Na + var_slow_time_dependent_potassium_current__i_Ks_Na + var_sodium_current__i_Na_Na + var_transient_outward_current__i_to_Na; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -var_internal_ion_concentrations__i_net_Na / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond
        
        rResidual[17] = rCurrentGuess[17] - rY[1] - mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
        rResidual[16] = rCurrentGuess[16] - rY[2] - mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
        rResidual[15] = rCurrentGuess[15] - rY[3] - mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
        rResidual[0] = rCurrentGuess[0] - rY[4] - mDt*d_dt_chaste_interface_var_ATP_production__ATPi;
        rResidual[21] = rCurrentGuess[21] - rY[5] - mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
        rResidual[22] = rCurrentGuess[22] - rY[6] - mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
        rResidual[20] = rCurrentGuess[20] - rY[7] - mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
        rResidual[7] = rCurrentGuess[7] - rY[9] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        rResidual[8] = rCurrentGuess[8] - rY[10] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        rResidual[6] = rCurrentGuess[6] - rY[11] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
        rResidual[4] = rCurrentGuess[4] - rY[12] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
        rResidual[5] = rCurrentGuess[5] - rY[13] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        rResidual[3] = rCurrentGuess[3] - rY[14] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
        rResidual[24] = rCurrentGuess[24] - rY[18] - mDt*d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
        rResidual[18] = rCurrentGuess[18] - rY[23] - mDt*d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
        rResidual[19] = rCurrentGuess[19] - rY[26] - mDt*d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
        rResidual[23] = rCurrentGuess[23] - rY[27] - mDt*d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
        rResidual[14] = rCurrentGuess[14] - rY[28] - mDt*d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
        rResidual[13] = rCurrentGuess[13] - rY[29] - mDt*d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
        rResidual[12] = rCurrentGuess[12] - rY[30] - mDt*d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
        rResidual[1] = rCurrentGuess[1] - rY[31] - mDt*d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
        rResidual[2] = rCurrentGuess[2] - rY[32] - mDt*d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
        rResidual[10] = rCurrentGuess[10] - rY[33] - mDt*d_dt_chaste_interface_var_NL_model__pCa;
        rResidual[11] = rCurrentGuess[11] - rY[34] - mDt*d_dt_chaste_interface_var_NL_model__pCaCB;
        rResidual[9] = rCurrentGuess[9] - rY[35] - mDt*d_dt_chaste_interface_var_NL_model__pCB;
    }

    void Cellmatsuoka_model_2003FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[25], double rJacobian[25][25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        double var_chaste_interface__ATP_production__ATPi = rCurrentGuess[0];
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rCurrentGuess[1];
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rCurrentGuess[5];
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rCurrentGuess[7];
        double var_chaste_interface__NL_model__pCB = rCurrentGuess[9];
        double var_chaste_interface__NL_model__pCa = rCurrentGuess[10];
        double var_chaste_interface__NL_model__pCaCB = rCurrentGuess[11];
        double var_chaste_interface__RyR_channel__p_close_RyR = rCurrentGuess[12];
        double var_chaste_interface__RyR_channel__p_open_RyR = rCurrentGuess[13];
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rCurrentGuess[14];
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rCurrentGuess[15];
        double var_chaste_interface__internal_ion_concentrations__Ki = rCurrentGuess[16];
        double var_chaste_interface__internal_ion_concentrations__Nai = rCurrentGuess[17];
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rCurrentGuess[18];
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rCurrentGuess[19];
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rCurrentGuess[21];
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rCurrentGuess[23];
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rCurrentGuess[24];
        
        const double var_x0 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
        const double var_x1 = -0.026190000000000001 + 0.5 * var_x0 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = 1.0 + 0.00080000000000000004 * var_x2;
        const double var_x4 = 1 / var_x3;
        const double var_x5 = 1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y;
        const double var_x6 = 1 / var_chaste_interface__ATP_production__ATPi;
        const double var_x7 = 1.0 + 0.10000000000000001 * var_x6;
        const double var_x8 = pow(var_chaste_interface__ATP_production__ATPi, 2);
        const double var_x9 = 1 / var_x8;
        const double var_x10 = var_x4 * var_x5 * var_x9 / pow(var_x7, 2);
        const double var_x11 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
        const double var_x12 = pow(var_x11, 1.0600000000000001);
        const double var_x13 = var_x12 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
        const double var_x14 = 1 / (1.0 + 4.4045579125871104 * var_x13);
        const double var_x15 = 1.0 + 0.094 * var_x6;
        const double var_x16 = var_x14 * var_x9 * var_chaste_interface__sodium_potassium_pump_y_gate__y / pow(var_x15, 2);
        const double var_x17 = var_x16 * mParameters[0];
        const double var_x18 = 1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup;
        const double var_x19 = var_chaste_interface__SR_calcium_pump_y_gate__y / (pow(var_x18, 2) * pow(var_chaste_interface__Ca_concentrations_in_SR__Caup, 2));
        const double var_x20 = 1 / var_x18;
        const double var_x21 = 1 / var_x7;
        const double var_x22 = var_x21 * var_x4;
        const double var_x23 = -0.052380000000000003 + var_x0 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x24 = pow(var_x23, 2);
        const double var_x25 = (-0.047620000000000003 + var_chaste_interface__internal_ion_concentrations__Ca_Total) / var_x0;
        const double var_x26 = 0.5 * var_x25;
        const double var_x27 = (-0.5 - var_x26) / var_x24;
        const double var_x28 = var_x27 / pow(var_x3, 2);
        const double var_x29 = var_x21 * var_x28;
        const double var_x30 = var_x29 * var_x5;
        const double var_x31 = 1 / var_x15;
        const double var_x32 = var_x31 / pow((0.22703754152993499 + var_x13), 2);
        const double var_x33 = var_x12 * var_x32 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 0.12000000000000011);
        const double var_x34 = mParameters[0] * var_chaste_interface__sodium_potassium_pump_y_gate__y;
        const double var_x35 = var_x33 * var_x34;
        const double var_x36 = var_x11 * var_x13 * var_x32;
        const double var_x37 = var_x34 * var_x36;
        const double var_x38 = exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm);
        const double var_x39 = 1 / (1.0 + 14.894617648090152 * pow(1 / var_x38, 1.0600000000000001));
        const double var_x40 = var_x14 * var_x31;
        const double var_x41 = 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total;
        const double var_x42 = sqrt(pow((1 - var_x41), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total);
        const double var_x43 = (-0.078875171467764058 + 0.0085733882030178329 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total) / var_x42;
        const double var_x44 = var_chaste_interface__membrane__Vm == 0;
        const double var_x45 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
        const double var_x46 = exp(-var_x45);
        const double var_x47 = var_x45 / (1.0 - var_x46);
        const double var_x48 = ((var_x44) ? (-1.8) : (var_x47 * (var_x1 - 1.8 * var_x46)));
        const double var_x49 = 6.9539999999999997 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x50 = var_x49 * (var_x1 - 0.020279999999999996 * var_x48);
        const double var_x51 = -var_x50;
        const double var_x52 = 0.14102711999999998 * var_x48;
        const double var_x53 = 0.5 + var_x26;
        const double var_x54 = ((var_x44) ? (0) : (var_x47 * var_x53));
        const double var_x55 = (3.4769999999999999 + 3.4769999999999999 * var_x25 - 0.14102711999999998 * var_x54) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x56 = 6.9539999999999997 * var_x1 * (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL);
        const double var_x57 = var_x52 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U;
        const double var_x58 = var_x53 * (6.9539999999999997 - var_x49);
        const double var_x59 = 0.01 * var_chaste_interface__membrane__Vm;
        const double var_x60 = 0.13513513513513511 * var_chaste_interface__membrane__Vm;
        const double var_x61 = 1 / (2.0 * exp(-var_x59) + 0.0018 * exp(-var_x60));
        const double var_x62 = -1.0 * var_x61;
        const double var_x63 = 11.0 * exp(var_x59) + 2200000.0 * exp(var_x60);
        const double var_x64 = 0.015384615384615385 * var_chaste_interface__membrane__Vm;
        const double var_x65 = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(var_x64));
        const double var_x66 = var_x65;
        const double var_x67 = 1.5 * exp(-var_x64) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm);
        const double var_x68 = 1 / var_x67;
        const double var_x69 = -0.040000000000000001 + 0.040000000000000001 / (1.0 + 0.25 * var_x61 * var_x63 * var_x65 * var_x67);
        const double var_x70 = 780.0 * var_x0;
        const double var_x71 = 780.0 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x72 = pow((0.95737999754118841 - var_chaste_interface__NL_model__X), 2);
        const double var_x73 = -0.038879999999999998 * var_x72;
        const double var_x74 = 780.0 * var_x25;
        const double var_x75 = -19.5 * var_x0 - 19.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x76 = 0.0038999999999999998 * exp(-0.86212130841993795);
        const double var_x77 = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB;
        const double var_x78 = var_x48 * var_chaste_interface__RyR_channel__p_close_RyR;
        const double var_x79 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        const double var_x80 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
        const double var_x81 = var_x79 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (pow((0.36443148688046656 + var_x80), 2) * pow(var_chaste_interface__ATP_production__ATPi, 4));
        const double var_x82 = 11.08600583090379 * var_x78 * var_x81;
        const double var_x83 = -1 + var_x41 + var_x42;
        const double var_x84 = var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / (1.0 + 2.7439999999999993 * var_x80);
        const double var_x85 = var_x84 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        const double var_x86 = 10.139999999999999 * var_x85;
        const double var_x87 = var_x78 * var_x86;
        const double var_x88 = var_x79 * var_x84;
        const double var_x89 = 10.139999999999999 * var_x78 * var_x88;
        const double var_x90 = 70000.0 * var_x24;
        const double var_x91 = pow(var_x83, 2);
        const double var_x92 = -0.010993320000000001 * var_x91;
        const double var_x93 = var_x79 * var_x86;
        const double var_x94 = var_x48 * var_x93;
        const double var_x95 = 70000.0 * var_x23 * (2 + 2 * var_x25);
        const double var_x96 = var_x54 * var_x93;
        const double var_x97 = 1.0 + 0.35999999999999999 / (-5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * var_x42);
        const double var_x98 = -var_x87;
        const double var_x99 = 0.0056432648230274225 * var_x48;
        const double var_x100 = -var_x85 * var_x99;
        const double var_x101 = -0.069398700000000008 + 1.3650000000000002 * var_x0 + 1.3650000000000002 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x102 = var_x79 * var_x85;
        const double var_x103 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
        const double var_x104 = 1 / var_x103;
        const double var_x105 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
        const double var_x106 = -17.978260869565219 + 362.31884057971018 * var_x0 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        const double var_x107 = var_x104 * var_x106;
        const double var_x108 = var_x105 / pow((0.0014927113702623907 + var_x107), 2);
        const double var_x109 = var_x104 * var_x108 * (362.31884057971018 + 362.31884057971018 * var_x25);
        const double var_x110 = mParameters[0] * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
        const double var_x111 = var_x109 * var_x110;
        const double var_x112 = var_x106 * var_x108 / pow(var_chaste_interface__internal_ion_concentrations__Nai, 4);
        const double var_x113 = var_x110 * var_x112;
        const double var_x114 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm);
        const double var_x115 = var_x105 / (1.0 + 669.921875 * var_x107);
        const double var_x116 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
        const double var_x117 = log(5.4000000000000004 * var_x116);
        const double var_x118 = 0.037435192301797954 * var_chaste_interface__membrane__Vm;
        const double var_x119 = exp(-var_x118);
        const double var_x120 = 1 / (1.0 - var_x119);
        const double var_x121 = var_x118 * var_x120;
        const double var_x122 = ((var_x44) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (var_x121 * (-5.4000000000000004 * var_x119 + var_chaste_interface__internal_ion_concentrations__Ki)));
        const double var_x123 = 4.1195833208100184e-6 * var_x122;
        const double var_x124 = -var_x123 * var_x85;
        const double var_x125 = 1.0 + 1.3823999999999997e-8 / pow(var_x23, 3);
        const double var_x126 = 1.9700124473113906e-15 * (-3 - 3 * var_x25) / (pow(var_x125, 2) * pow(var_x23, 4));
        const double var_x127 = var_x120 * var_chaste_interface__membrane__Vm;
        const double var_x128 = (3.0 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm));
        const double var_x129 = ((var_x44) ? (1) : (var_x121));
        const double var_x130 = 1.4250668745018745e-7 / var_x125;
        const double var_x131 = 0.00037051738737048736 * var_chaste_interface__sodium_current_ultra_slow_gate__y;
        const double var_x132 = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2);
        const double var_x133 = var_x132 * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2);
        const double var_x134 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_chaste_interface__transient_outward_current_y2_gate__y2;
        const double var_x135 = exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.80138495771956131 * var_x117);
        const double var_x136 = 1.0 + var_x135;
        const double var_x137 = pow(var_x136, (-4));
        const double var_x138 = exp(0.47999999999999998 + 1.282215932351298 * var_x117 - 0.048000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x139 = pow(var_x138, 4);
        const double var_x140 = exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 1.7096212431350641 * var_x117);
        const double var_x141 = 1.0 + var_x140;
        const double var_x142 = pow(var_x141, 4);
        const double var_x143 = var_x142;
        const double var_x144 = exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.40069247885978065 * var_x117);
        const double var_x145 = 1.0 + var_x144;
        const double var_x146 = exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.93494911733948827 * var_x117);
        const double var_x147 = var_x146 / var_x145;
        const double var_x148 = var_x138 / var_x136;
        const double var_x149 = var_x141 * var_x148;
        const double var_x150 = var_x149 + 0.25 * var_x147;
        const double var_x151 = pow(var_x150, (-5));
        const double var_x152 = var_x116 * var_x147;
        const double var_x153 = pow(var_x145, (-2));
        const double var_x154 = var_x116 * var_x153;
        const double var_x155 = var_x144 * var_x146 * var_x154;
        const double var_x156 = var_x116 * var_x149;
        const double var_x157 = var_x116 * var_x140 * var_x148;
        const double var_x158 = 3.2055398308782452 * var_x116 * var_x135;
        const double var_x159 = pow(var_x136, (-2));
        const double var_x160 = var_x141 * var_x159;
        const double var_x161 = var_x138 * var_x160;
        const double var_x162 = var_x151 * (0.40069247885978065 * var_x155 + 5.1288637294051922 * var_x156 - 6.8384849725402566 * var_x157 - 0.93494911733948827 * var_x152 + var_x158 * var_x161);
        const double var_x163 = var_x137 * var_x139 * var_x143 * var_x162;
        const double var_x164 = pow(var_x150, (-4));
        const double var_x165 = var_x137 * var_x139 * var_x164;
        const double var_x166 = var_x116 * var_x165;
        const double var_x167 = 5.1288637294051922 * var_x142 * var_x166;
        const double var_x168 = pow(var_x141, 3);
        const double var_x169 = 6.8384849725402566 * var_x140 * var_x166 * var_x168;
        const double var_x170 = var_x139 * var_x142 * var_x158 * var_x164 / pow(var_x136, 5);
        const double var_x171 = pow(var_x141, 2);
        const double var_x172 = pow(var_x138, 2);
        const double var_x173 = pow(var_x146, 2);
        const double var_x174 = 0.125 * var_x153;
        const double var_x175 = pow(var_x136, (-3));
        const double var_x176 = pow(var_x138, 3);
        const double var_x177 = var_x175 * var_x176;
        const double var_x178 = var_x168 * var_x177;
        const double var_x179 = var_x147 * var_x178;
        const double var_x180 = var_x179 * (0.30051935914483546 * var_x155 + 3.8466477970538944 * var_x156 - 5.1288637294051922 * var_x157 - 0.70121183800461617 * var_x152 + 2.4041548731586837 * var_x116 * var_x135 * var_x161);
        const double var_x181 = var_x164 * var_x172 * var_x173;
        const double var_x182 = var_x171 * var_x181;
        const double var_x183 = var_x159 * var_x182;
        const double var_x184 = 1 / (0.75 * var_x147 + 3.0 * var_x149);
        const double var_x185 = 2.0 * var_x184;
        const double var_x186 = pow(var_x150, (-3));
        const double var_x187 = var_x152 * var_x184 * var_x186;
        const double var_x188 = (3.9659488542057145e-5 * var_x117 - 1.4846605801628617e-6 * var_chaste_interface__membrane__Vm) * mParameters[0];
        const double var_x189 = var_x116 * mParameters[0];
        const double var_x190 = var_x143 * var_x165;
        const double var_x191 = var_x190 + var_x174 * var_x183 + var_x179 * var_x185 * var_x186;
        const double var_x192 = ((var_x44) ? (-140.0) : (var_x121 * (-140.0 * var_x119 + var_chaste_interface__internal_ion_concentrations__Nai)));
        const double var_x193 = 2.0880079845201463e-7 * var_x192;
        const double var_x194 = -var_x193 * var_x85;
        const double var_x195 = ((var_x44) ? (0) : (var_x121));
        const double var_x196 = 0.0037051738737048732 * var_chaste_interface__sodium_current_ultra_slow_gate__y;
        const double var_x197 = 1.0 + 0.0014927113702623907 * var_x103;
        const double var_x198 = 1.0 + 0.0013799999999999999 * var_x197 * var_x2;
        const double var_x199 = pow(var_x198, (-2));
        const double var_x200 = exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm);
        const double var_x201 = exp(-0.125 * var_chaste_interface__membrane__Vm);
        const double var_x202 = 1 / (5.0 * var_x200 + 0.0001027 * var_x201);
        const double var_x203 = -1.0 * var_x202;
        const double var_x204 = exp(0.00125 * var_chaste_interface__membrane__Vm);
        const double var_x205 = 1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * var_x204;
        const double var_x206 = 1.25 / var_x200;
        const double var_x207 = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * var_x204);
        const double var_x208 = var_x207;
        const double var_x209 = 0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * var_x201;
        const double var_x210 = 1 / var_x209;
        const double var_x211 = -0.01 + 0.01 / (1.0 + 7.0000000000000007e-5 * var_x200 * var_x202 * var_x205 * var_x207 * var_x209);
        const double var_x212 = pow(var_x116, 1.1200000000000001);
        const double var_x213 = var_x212 * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001));
        const double var_x214 = pow((0.020000293738509214 + var_x213), (-2));
        const double var_x215 = exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.08904277307995126 * var_x117);
        const double var_x216 = exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 3.142686108704162 * var_x117);
        const double var_x217 = exp(10.659340659340661 + 2.9354760356027887 * var_x117 - 0.10989010989010989 * var_chaste_interface__membrane__Vm);
        const double var_x218 = exp(0.19400000000000001 + 0.053425663847970754 * var_x117 - 0.002 * var_chaste_interface__membrane__Vm);
        const double var_x219 = 1 / (0.00013999999999999999 * var_x217 + 0.20000000000000001 * var_x218);
        const double var_x220 = var_x219 * var_chaste_interface__time_independent_potassium_current_y_gate__y;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.0030000000000000001 - 9.4621849436243545e-7 * var_x17 - 0.005263031070603514 * var_x10));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = -(mDt * (4.2104248564828106e-5 * var_x19));
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = -(mDt * (-0.028000000000000004));
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = -(mDt * (0.00052630310706035135 * var_x20 + 0.052630310706035133 * var_x22));
        rJacobian[0][15] = -(mDt * (0.00016841699425931242 * var_x30));
        rJacobian[0][16] = -(mDt * (5.1193597651771573e-8 * var_x35));
        rJacobian[0][17] = -(mDt * (-2.4225185952427261e-6 * var_x37));
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = 0.0;
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = -(mDt * ((-1.0882328859832496e-6 * var_x39 - 1.0066154195345059e-5 * var_x40) * mParameters[0]));
        rJacobian[0][24] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (-0.0062508615177014034 - 0.067509304391175154 * var_x43 + (-1.0040243888535934 - 10.843463399618807 * var_x43) * var_chaste_interface__RyR_channel__p_open_RyR));
        rJacobian[1][2] = -(mDt * (0.012501723035402807));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = -(mDt * (10.790872602130657 + 1.0040243888535934 * var_x0 + 1.0040243888535934 * var_chaste_interface__internal_ion_concentrations__Ca_Total - 1.0040243888535934 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total - 10.843463399618807 * var_x42));
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = -(mDt * ((1.0040243888535934 + 1.0040243888535934 * var_x25) * var_chaste_interface__RyR_channel__p_open_RyR));
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = 0.0;
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[2][0] = -(mDt * (0.21052124282414053 * var_x10));
        rJacobian[2][1] = -(mDt * (0.0025003446070805614 + 0.027003721756470062 * var_x43));
        rJacobian[2][2] = 1.0 - (mDt * (-0.010947104626855308 - 0.0016841699425931243 * var_x19));
        rJacobian[2][3] = 0.0;
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = -(mDt * (-0.021052124282414052 * var_x20 - 2.1052124282414053 * var_x22));
        rJacobian[2][15] = -(mDt * (0.0029732077063470926 + 0.0029732077063470926 * var_x25 - 0.0067366797703724973 * var_x30));
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = 0.0;
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = 0.0;
        rJacobian[3][3] = 1.0 - (mDt * (-0.1472 + var_x51));
        rJacobian[3][4] = -(mDt * (0.3458));
        rJacobian[3][5] = -(mDt * (-0.0041999999999999997));
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = -(mDt * ((0.18212526000000001 + var_x52 - 3.4769999999999999 * var_x0 - 3.4769999999999999 * var_chaste_interface__internal_ion_concentrations__Ca_Total) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C));
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = -(mDt * (-var_x55 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C));
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = 0.0;
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (0.14299999999999999));
        rJacobian[4][4] = 1.0 - (mDt * (-0.34999999999999998 + var_x51 - var_x56));
        rJacobian[4][5] = -(mDt * (2.0019999999999998));
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = -(mDt * (var_x57));
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = 0.0;
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = -(mDt * ((-var_x55 - var_x58) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U));
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = 0.0;
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (-0.00029999999999999997));
        rJacobian[5][4] = -(mDt * (-0.00029999999999999997 + var_x50 + var_x56));
        rJacobian[5][5] = 1.0 - (mDt * (-2.3523000000000001));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = -(mDt * (-var_x57));
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = -(mDt * ((var_x55 + var_x58) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U));
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = 0.0;
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.001 + var_x62 - 1.0 / var_x63));
        rJacobian[6][7] = -(mDt * (0.0040000000000000001 + var_x62));
        rJacobian[6][8] = -(mDt * (var_x62));
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = 0.0;
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = -(mDt * (0.001));
        rJacobian[7][7] = 1.0 - (mDt * (-0.0040000000000000001 - var_x66));
        rJacobian[7][8] = -(mDt * (var_x68));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = 0.0;
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = -(mDt * (var_x69));
        rJacobian[8][7] = -(mDt * (var_x66 + var_x69));
        rJacobian[8][8] = 1.0 - (mDt * (-0.040000000000000001 - var_x68));
        rJacobian[8][9] = 0.0;
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = 0.0;
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = 0.0;
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (40.736400000000003 + var_x73 - var_x70 - var_x71));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = -(mDt * (0.029999999999999999));
        rJacobian[9][12] = 0.0;
        rJacobian[9][13] = 0.0;
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = -(mDt * ((-780.0 - var_x74) * var_chaste_interface__NL_model__pCB));
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = 0.0;
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = -(mDt * (1.0214100000000002 + var_x75));
        rJacobian[10][10] = 1.0 - (mDt * (0.99141000000000001 + var_x75 - var_x76));
        rJacobian[10][11] = -(mDt * (1.0253100000000002 + var_x75));
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = 0.0;
        rJacobian[10][15] = -(mDt * (var_x77 * (19.5 + 19.5 * var_x25)));
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = -(mDt * (-40.856400000000001 + var_x70 + var_x71));
        rJacobian[11][10] = -(mDt * (var_x76));
        rJacobian[11][11] = 1.0 - (mDt * (-0.0339 + var_x73));
        rJacobian[11][12] = 0.0;
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = -(mDt * ((780.0 + var_x74) * var_chaste_interface__NL_model__pCB));
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[12][0] = -(mDt * (var_x82));
        rJacobian[12][1] = -(mDt * (0.010993320000000001 * var_x83 * (0.18518518518518517 + 2 * var_x43) * (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR)));
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = -(mDt * (var_x87));
        rJacobian[12][5] = -(mDt * (var_x87));
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = -(mDt * (var_x89));
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (-0.00084900000000000004 + var_x92 + var_x94 - var_x90));
        rJacobian[12][13] = -(mDt * (var_x92));
        rJacobian[12][14] = 0.0;
        rJacobian[12][15] = -(mDt * ((var_x96 - var_x95) * var_chaste_interface__RyR_channel__p_close_RyR));
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = 0.0;
        rJacobian[12][21] = 0.0;
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[13][0] = -(mDt * (-var_x82));
        rJacobian[13][1] = -(mDt * (0.00098765432098765434 * (-0.5 - 5.4000000000000004 * var_x43) * var_chaste_interface__RyR_channel__p_open_RyR / (var_x91 * pow(var_x97, 2))));
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = -(mDt * (var_x98));
        rJacobian[13][5] = -(mDt * (var_x98));
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = -(mDt * (-var_x89));
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = 0.0;
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = -(mDt * (var_x90 - var_x94));
        rJacobian[13][13] = 1.0 - (mDt * (-0.080000000000000002 / var_x97));
        rJacobian[13][14] = 0.0;
        rJacobian[13][15] = -(mDt * ((var_x95 - var_x96) * var_chaste_interface__RyR_channel__p_close_RyR));
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[14][0] = -(mDt * (0.10000000000000001 * var_x10));
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = -(mDt * (0.079200000000000007 * var_x19));
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = 0.0;
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = 0.0;
        rJacobian[14][13] = 0.0;
        rJacobian[14][14] = 1.0 - (mDt * (-1.01 + 0.01 * var_x4 + 0.98999999999999999 * var_x20 - 1.0 * var_x22));
        rJacobian[14][15] = -(mDt * (var_x5 * (3.2000000000000005e-5 * var_x28 - 0.0032000000000000002 * var_x29)));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = 0.0;
        rJacobian[14][21] = 0.0;
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[15][0] = -(mDt * (-0.010526062141207028 * var_x10 - 0.0061697501709483491 * var_x48 * var_x81));
        rJacobian[15][1] = -(mDt * ((0.020080487777071866 + 0.21686926799237616 * var_x43) * var_chaste_interface__RyR_channel__p_open_RyR));
        rJacobian[15][2] = -(mDt * (0.00029732077063470926 + 8.4208497129656211e-5 * var_x19));
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = -(mDt * (var_x100));
        rJacobian[15][5] = -(mDt * (var_x100));
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = -(mDt * (-var_x88 * var_x99));
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = -(mDt * (2.7884493000000004 - 53.235000000000007 * var_x0 - 53.235000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total));
        rJacobian[15][10] = -(mDt * (var_x101));
        rJacobian[15][11] = -(mDt * (var_x101 + 0.0027216000000000002 * var_x72));
        rJacobian[15][12] = 0.0;
        rJacobian[15][13] = -(mDt * (-0.21581745204261313 + 0.020080487777071866 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 0.21686926799237616 * var_x42 - 0.020080487777071866 * var_x0 - 0.020080487777071866 * var_chaste_interface__internal_ion_concentrations__Ca_Total));
        rJacobian[15][14] = -(mDt * (0.0010526062141207027 * var_x20 + 0.10526062141207027 * var_x22));
        rJacobian[15][15] = 1.0 - (mDt * (-0.00014866038531735463 + 0.00033683398851862484 * var_x30 - 0.00014866038531735463 * var_x25 - 2.591030680912499e-8 * var_x54 - 1.3169385562319573e-8 * var_x111 + var_x77 * (-1.3650000000000002 - 1.3650000000000002 * var_x25) + (-54.600000000000009 - 54.600000000000009 * var_x25) * var_chaste_interface__NL_model__pCB + (-0.020080487777071866 - 0.020080487777071866 * var_x25) * var_chaste_interface__RyR_channel__p_open_RyR - 0.0056432648230274225 * var_x102 * var_x54 - 0.00039642769417961232 * var_x54 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2));
        rJacobian[15][16] = 0.0;
        rJacobian[15][17] = -(mDt * (3.9508156686958718e-8 * var_x113));
        rJacobian[15][18] = 0.0;
        rJacobian[15][19] = -(mDt * ((8.8224594685070574e-6 * var_x115 + 5.6460672083658019e-6 * var_x114) * mParameters[0]));
        rJacobian[15][20] = 0.0;
        rJacobian[15][21] = 0.0;
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = 0.0;
        rJacobian[16][0] = -(mDt * (1.8924369887248709e-6 * var_x17 - 4.5039176247922949e-6 * var_x122 * var_x81 + 1.710660339589889e-6 * (-26.712831923985377 * var_x117 + var_chaste_interface__membrane__Vm) * var_chaste_interface__ATP_production__ATPi / pow((0.010000000000000002 + var_x8), 2)));
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = -(mDt * (var_x124));
        rJacobian[16][5] = -(mDt * (var_x124));
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = -(mDt * (-var_x123 * var_x88));
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = -(mDt * (var_x122 * var_x126));
        rJacobian[16][16] = 1.0 - (mDt * (-1.0238719530354315e-7 * var_x35 - 1.2955153404562495e-6 * ((var_chaste_interface__membrane__Vm == (-3.0)) ? (5.3564032599450697e-5 * var_x127) : ((var_x44) ? (0.00011 * var_x128) : (4.1178711531977753e-6 * var_x127 * var_x128))) - 1.9950936243026244e-7 * var_x129 - var_x129 * var_x130 - 4.1195833208100184e-6 * var_x102 * var_x129 - 6.5293973158994975e-6 * var_x129 * var_x133 - 0.0022848291065246224 * var_x116 / (1.0 + 99.999999999999986 * var_x8) - 4.2752006235056235e-8 * var_x129 * var_x134 + var_x188 * (var_x163 + var_x169 - var_x167 - var_x170 + 0.22222222222222221 * var_x151 * var_x180 - 0.086816703752952459 * var_x154 * var_x183 - 5.823397359428812 * var_x178 * var_x187 + var_x164 * var_x180 * var_x185 + 10.257727458810384 * var_x140 * var_x171 * var_x177 * var_x187 + 0.42740531078376603 * var_x140 * var_x154 * var_x160 * var_x181 - 0.10017311971494516 * var_x116 * var_x144 * var_x183 / pow(var_x145, 3) - 0.20034623942989033 * var_x135 * var_x154 * var_x175 * var_x182 - 0.80138495771956131 * var_x155 * var_x178 * var_x184 * var_x186 - 4.8083097463173674 * var_x135 * var_x137 * var_x168 * var_x176 * var_x187 + var_x159 * var_x162 * var_x171 * var_x172 * var_x173 * var_x174) * var_chaste_interface__time_independent_potassium_current_y_gate__y - var_x129 * var_x131 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 26.712831923985377 * var_x189 * (-4.477301016616798e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 - 6.7159515249251966e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 - 3.9659488542057145e-5 * var_x189 * var_x191 * var_chaste_interface__time_independent_potassium_current_y_gate__y));
        rJacobian[16][17] = -(mDt * (4.8450371904854522e-6 * var_x37));
        rJacobian[16][18] = -(mDt * (-5.8764575843095472e-6 * var_x122 * var_x132));
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = 0.0;
        rJacobian[16][21] = -(mDt * (-var_x122 * var_x131));
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = -(mDt * ((2.1764657719664992e-6 * var_x39 + 2.0132308390690117e-5 * var_x40) * mParameters[0]));
        rJacobian[16][24] = -(mDt * (var_x188 * var_x191));
        rJacobian[17][0] = -(mDt * (-2.8386554830873062e-6 * var_x17 - 2.2828075632508891e-7 * var_x192 * var_x81));
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = -(mDt * (var_x194));
        rJacobian[17][5] = -(mDt * (var_x194));
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = -(mDt * (-var_x193 * var_x88));
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = -(mDt * (3.9508156686958718e-8 * var_x111 + var_x126 * var_x192));
        rJacobian[17][16] = -(mDt * (1.5358079295531472e-7 * var_x35));
        rJacobian[17][17] = 1.0 - (mDt * (-7.2675557857281787e-6 * var_x37 - 1.1852447006087616e-7 * var_x113 - 4.9877340607565601e-7 * var_x195 - var_x130 * var_x195 - 3.8476805611550606e-9 * var_x134 * var_x195 - 2.0880079845201463e-7 * var_x102 * var_x195 - 2.6117589263597991e-7 * var_x133 * var_x195 - var_x195 * var_x196 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na));
        rJacobian[17][18] = -(mDt * (-2.3505830337238192e-7 * var_x132 * var_x192));
        rJacobian[17][19] = -(mDt * ((-1.6938201625097406e-5 * var_x114 - 2.6467378405521174e-5 * var_x115) * mParameters[0]));
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = -(mDt * (-var_x192 * var_x196));
        rJacobian[17][22] = 0.0;
        rJacobian[17][23] = -(mDt * ((-3.2646986579497488e-6 * var_x39 - 3.0198462586035172e-5 * var_x40) * mParameters[0]));
        rJacobian[17][24] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = 0.0;
        rJacobian[18][15] = -(mDt * ((1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * (1.8500000000000001 + 1.8500000000000001 * var_x25)));
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = 0.0;
        rJacobian[18][18] = 1.0 - (mDt * (0.092459000000000013 - 1.8500000000000001 * var_x0 - 1.8500000000000001 * var_chaste_interface__internal_ion_concentrations__Ca_Total));
        rJacobian[18][19] = 0.0;
        rJacobian[18][20] = 0.0;
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = 0.0;
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = 0.0;
        rJacobian[19][15] = -(mDt * ((0.0014927113702623907 * var_x109 + 0.0055199999999999997 * var_x197 * var_x199 * var_x27) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y));
        rJacobian[19][16] = 0.0;
        rJacobian[19][17] = -(mDt * ((-0.0044781341107871719 * var_x112 + 6.1798250728862972e-6 * var_x199 * var_x2 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 2)) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y));
        rJacobian[19][18] = 0.0;
        rJacobian[19][19] = 1.0 - (mDt * (-0.20379327210477693 - 1.0 * var_x115 - 1.0 / var_x198 - 0.6399652192815608 * var_x114));
        rJacobian[19][20] = 0.0;
        rJacobian[19][21] = 0.0;
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = 0.0;
        rJacobian[19][24] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = 0.0;
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = 0.0;
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = 0.0;
        rJacobian[20][19] = 0.0;
        rJacobian[20][20] = 1.0 - (mDt * (-8.7499999999999999e-5 + var_x203 - 1.0 / var_x205));
        rJacobian[20][21] = -(mDt * (var_x203 + var_x206));
        rJacobian[20][22] = -(mDt * (var_x203));
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = 0.0;
        rJacobian[21][11] = 0.0;
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = 0.0;
        rJacobian[21][15] = 0.0;
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = 0.0;
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = 0.0;
        rJacobian[21][20] = -(mDt * (8.7499999999999999e-5));
        rJacobian[21][21] = 1.0 - (mDt * (-var_x206 - var_x208));
        rJacobian[21][22] = -(mDt * (var_x210));
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = 0.0;
        rJacobian[22][11] = 0.0;
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = 0.0;
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = 0.0;
        rJacobian[22][18] = 0.0;
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = -(mDt * (var_x211));
        rJacobian[22][21] = -(mDt * (var_x208 + var_x211));
        rJacobian[22][22] = 1.0 - (mDt * (-0.01 - var_x210));
        rJacobian[22][23] = 0.0;
        rJacobian[22][24] = 0.0;
        rJacobian[23][0] = -(mDt * (-0.034779999999999998 * var_x16));
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = 0.0;
        rJacobian[23][11] = 0.0;
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = 0.0;
        rJacobian[23][16] = -(mDt * ((0.0018817147803989289 * var_x33 - 0.00022400328987130325 * var_x116 * var_x213 * var_x214) * var_chaste_interface__sodium_potassium_pump_y_gate__y));
        rJacobian[23][17] = -(mDt * ((-0.089044123788040511 * var_x36 + 4.8132665714837462e-5 * var_x212 * var_x214 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 0.060000000000000053)) * var_chaste_interface__sodium_potassium_pump_y_gate__y));
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = 0.0;
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = 0.0;
        rJacobian[23][23] = 1.0 - (mDt * (-0.37 * var_x40 - 0.01 / (1.0 + 49.999265664512095 * var_x213) - 0.040000000000000001 * var_x39 - 0.16500000000000001 / (1.0331690520373935 + 0.069365261764196454 * pow(var_x38, 1.0600000000000001))));
        rJacobian[23][24] = 0.0;
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = 0.0;
        rJacobian[24][16] = -(mDt * (var_x167 * var_x220 + var_x170 * var_x220 - var_x163 * var_x220 - var_x169 * var_x220 + 1.5624999999999999e-8 * (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) * (-0.62329941155965873 * var_x116 * var_x215 - 25141.488869633296 * var_x116 * var_x216) / pow((var_x216 + 0.00087500000000000002 * var_x215), 2) - 24.999999999999996 * var_x142 * var_x165 * (0.010685132769594151 * var_x116 * var_x218 + 0.00041096664498439041 * var_x116 * var_x217) * var_chaste_interface__time_independent_potassium_current_y_gate__y / pow((var_x218 + 0.00069999999999999988 * var_x217), 2)));
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = 0.0;
        rJacobian[24][23] = 0.0;
        rJacobian[24][24] = 1.0 - (mDt * (-1.0 / (7.0 * var_x215 + 8000.0 * var_x216) - var_x190 * var_x219));
    }

    void Cellmatsuoka_model_2003FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_ext = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_ext_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * mParameters[0] * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * mParameters[0] * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * mParameters[0] * var_sodium_potassium_pump__P_NaK; // picoA
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * mParameters[0] * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
        const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
        const double d_dt_chaste_interface_var_membrane__Vm = (-var_membrane__i_ext - var_membrane__i_tot) / mParameters[0]; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__Vm;
    }
    
    void Cellmatsuoka_model_2003FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        const double var_NL_model__B = 1.2;
        const double var_NL_model__L = 0.96237999754118841;
        const double var_NL_model__h_c = 0.0050000000000000001;
        const double var_L_type_Ca_channel_ultra_slow_gate__alpha_y = 1 / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm));
        const double var_L_type_Ca_channel_ultra_slow_gate__beta_y = 1 / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm));
        const double var_T_type_Ca_channel_y1_gate__alpha_y1 = 1 / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_T_type_Ca_channel_y1_gate__beta_y1 = 1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm));
        const double var_T_type_Ca_channel_y2_gate__alpha_y2 = 1 / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm));
        const double var_T_type_Ca_channel_y2_gate__beta_y2 = 1 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm));
        const double var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm));
        const double var_rapid_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
        const double var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 = 1 / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm));
        const double var_rapid_time_dependent_potassium_current_y2_gate__beta_y2 = 1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
        const double var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 = 1 / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm));
        const double var_rapid_time_dependent_potassium_current_y3_gate__beta_y3 = 1 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm));
        const double var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm));
        const double var_slow_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm));
        const double var_sodium_current_ultra_slow_gate__alpha_y = 1 / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_sodium_current_ultra_slow_gate__beta_y = 1 / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_transient_outward_current_y1_gate__alpha_y1 = 1 / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_transient_outward_current_y1_gate__beta_y1 = 1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm));
        const double var_transient_outward_current_y2_gate__alpha_y2 = 0.0038 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm));
        const double var_transient_outward_current_y2_gate__beta_y2 = 0.0038 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm));
        
        
        rY[15] = (var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y + ((var_L_type_Ca_channel_ultra_slow_gate__alpha_y) * mDt)) / (1.0 - ((-var_L_type_Ca_channel_ultra_slow_gate__alpha_y - var_L_type_Ca_channel_ultra_slow_gate__beta_y) * mDt));
        rY[36] = (var_chaste_interface__NL_model__X + ((var_NL_model__B * var_NL_model__L - var_NL_model__B * var_NL_model__h_c) * mDt)) / (1.0 - ((-var_NL_model__B) * mDt));
        rY[16] = (var_chaste_interface__T_type_Ca_channel_y1_gate__y1 + ((var_T_type_Ca_channel_y1_gate__alpha_y1) * mDt)) / (1.0 - ((-var_T_type_Ca_channel_y1_gate__alpha_y1 - var_T_type_Ca_channel_y1_gate__beta_y1) * mDt));
        rY[17] = (var_chaste_interface__T_type_Ca_channel_y2_gate__y2 + ((var_T_type_Ca_channel_y2_gate__alpha_y2) * mDt)) / (1.0 - ((-var_T_type_Ca_channel_y2_gate__alpha_y2 - var_T_type_Ca_channel_y2_gate__beta_y2) * mDt));
        rY[19] = (var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 + ((var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1) * mDt)) / (1.0 - ((-var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 - var_rapid_time_dependent_potassium_current_y1_gate__beta_y1) * mDt));
        rY[20] = (var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + ((var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2) * mDt)) / (1.0 - ((-var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 - var_rapid_time_dependent_potassium_current_y2_gate__beta_y2) * mDt));
        rY[21] = (var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 + ((var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3) * mDt)) / (1.0 - ((-var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 - var_rapid_time_dependent_potassium_current_y3_gate__beta_y3) * mDt));
        rY[22] = (var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 + ((var_slow_time_dependent_potassium_current_y1_gate__alpha_y1) * mDt)) / (1.0 - ((-var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 - var_slow_time_dependent_potassium_current_y1_gate__beta_y1) * mDt));
        rY[8] = (var_chaste_interface__sodium_current_ultra_slow_gate__y + ((var_sodium_current_ultra_slow_gate__alpha_y) * mDt)) / (1.0 - ((-var_sodium_current_ultra_slow_gate__alpha_y - var_sodium_current_ultra_slow_gate__beta_y) * mDt));
        rY[24] = (var_chaste_interface__transient_outward_current_y1_gate__y1 + ((var_transient_outward_current_y1_gate__alpha_y1) * mDt)) / (1.0 - ((-var_transient_outward_current_y1_gate__alpha_y1 - var_transient_outward_current_y1_gate__beta_y1) * mDt));
        rY[25] = (var_chaste_interface__transient_outward_current_y2_gate__y2 + ((var_transient_outward_current_y2_gate__alpha_y2) * mDt)) / (1.0 - ((-var_transient_outward_current_y2_gate__alpha_y2 - var_transient_outward_current_y2_gate__beta_y2) * mDt));
        
        double _guess[25] = {rY[4],rY[31],rY[32],rY[14],rY[12],rY[13],rY[11],rY[9],rY[10],rY[35],rY[33],rY[34],rY[30],rY[29],rY[28],rY[3],rY[2],rY[1],rY[23],rY[26],rY[7],rY[5],rY[6],rY[27],rY[18]};
        CardiacNewtonSolver<25,Cellmatsuoka_model_2003FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<25,Cellmatsuoka_model_2003FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[4] = _guess[0];
        rY[31] = _guess[1];
        rY[32] = _guess[2];
        rY[14] = _guess[3];
        rY[12] = _guess[4];
        rY[13] = _guess[5];
        rY[11] = _guess[6];
        rY[9] = _guess[7];
        rY[10] = _guess[8];
        rY[35] = _guess[9];
        rY[33] = _guess[10];
        rY[34] = _guess[11];
        rY[30] = _guess[12];
        rY[29] = _guess[13];
        rY[28] = _guess[14];
        rY[3] = _guess[15];
        rY[2] = _guess[16];
        rY[1] = _guess[17];
        rY[23] = _guess[18];
        rY[26] = _guess[19];
        rY[7] = _guess[20];
        rY[5] = _guess[21];
        rY[6] = _guess[22];
        rY[27] = _guess[23];
        rY[18] = _guess[24];
    }

    std::vector<double> Cellmatsuoka_model_2003FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        

        // Mathematics
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(4);
        dqs[0] = var_internal_ion_concentrations__Cai;
        dqs[1] = var_chaste_interface__environment__time;
        dqs[2] = var_membrane__Cm_converted;
        dqs[3] = var_membrane__i_ext_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "matsuoka_model_2003";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.95752434460744);

    // rY[1]:
    this->mVariableNames.push_back("internal_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.925761439682025);

    // rY[2]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(143.1837333000449);

    // rY[3]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00040180173572968586);

    // rY[4]:
    this->mVariableNames.push_back("ATP_production__ATPi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.657102729020499);

    // rY[5]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.779648367445368e-05);

    // rY[6]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_RP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3556412697995689);

    // rY[7]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AI_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.40285968661346977);

    // rY[8]:
    this->mVariableNames.push_back("sodium_current_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5861887862983165);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5445004166497696e-06);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9968480629364956);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000877325391245903);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_U");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.17246483915629204);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_UCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.098246017787626e-05);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4250747299372254);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9985266538252986);

    // rY[16]:
    this->mVariableNames.push_back("T_type_Ca_channel_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.6882718240109127e-05);

    // rY[17]:
    this->mVariableNames.push_back("T_type_Ca_channel_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8585352091865849);

    // rY[18]:
    this->mVariableNames.push_back("time_independent_potassium_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6080573900752752);

    // rY[19]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018339931180983765);

    // rY[20]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.20443083454225305);

    // rY[21]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y3_gate__y3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.967887666264921);

    // rY[22]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09738789658609195);

    // rY[23]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09745345578743213);

    // rY[24]:
    this->mVariableNames.push_back("transient_outward_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007956883250874798);

    // rY[25]:
    this->mVariableNames.push_back("transient_outward_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999125083105881);

    // rY[26]:
    this->mVariableNames.push_back("sodium_calcium_exchanger_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9891789193465331);

    // rY[27]:
    this->mVariableNames.push_back("sodium_potassium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5910747147428818);

    // rY[28]:
    this->mVariableNames.push_back("SR_calcium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46108441538480216);

    // rY[29]:
    this->mVariableNames.push_back("RyR_channel__p_open_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00034314360001543243);

    // rY[30]:
    this->mVariableNames.push_back("RyR_channel__p_close_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.19135178123107768);

    // rY[31]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.455741736977666);

    // rY[32]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.611712901567567);

    // rY[33]:
    this->mVariableNames.push_back("NL_model__pCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02490898775497523);

    // rY[34]:
    this->mVariableNames.push_back("NL_model__pCaCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001990153835322864);

    // rY[35]:
    this->mVariableNames.push_back("NL_model__pCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00042941813853474524);

    // rY[36]:
    this->mVariableNames.push_back("NL_model__X");
    this->mVariableUnits.push_back("micrometre");
    this->mInitialConditions.push_back(0.9573749975411884);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmatsuoka_model_2003FromCellMLBackwardEuler)
