//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: jafri_rice_winslow_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "jafri_rice_winslow_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = 51.628900000000009; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 1.0; // ms
        const double var_chaste_interface__membrane__stim_period = 500.0; // ms
        const double var_chaste_interface__membrane__stim_start = 100.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<25>(
                31,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::~Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler()
    {
    }
    
    double Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double var_chaste_interface__i_ionic = 100.00000000000001 * var_L_type_Ca_channel__i_Ca_L_Ca + 100.00000000000001 * var_L_type_Ca_channel__i_Ca_L_K + 100.00000000000001 * var_Na_Ca_exchanger__i_NaCa + 100.00000000000001 * var_calcium_background_current__i_Ca_b + 100.00000000000001 * var_fast_sodium_current__i_Na + 100.00000000000001 * var_non_specific_calcium_activated_current__i_ns_Ca + 100.00000000000001 * var_plateau_potassium_current__i_Kp + 100.00000000000001 * var_sarcolemmal_calcium_pump__i_p_Ca + 100.00000000000001 * var_sodium_background_current__i_Na_b + 100.00000000000001 * var_sodium_potassium_pump__i_NaK + 100.00000000000001 * var_time_dependent_potassium_current__i_K + 100.00000000000001 * var_time_independent_potassium_current__i_K1; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[25], double rResidual[25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_Ca_channel__C0 = rCurrentGuess[0];
        double var_chaste_interface__L_type_Ca_channel__C1 = rCurrentGuess[1];
        double var_chaste_interface__L_type_Ca_channel__C2 = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_channel__C3 = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_channel__C4 = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rCurrentGuess[5];
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rCurrentGuess[6];
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rCurrentGuess[7];
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rCurrentGuess[8];
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rCurrentGuess[9];
        double var_chaste_interface__L_type_Ca_channel__O = rCurrentGuess[10];
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rCurrentGuess[11];
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rCurrentGuess[12];
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rCurrentGuess[13];
        double var_chaste_interface__calcium_subsystem__Ca_SS = rCurrentGuess[14];
        double var_chaste_interface__calcium_subsystem__Cai = rCurrentGuess[15];
        double var_chaste_interface__calcium_subsystem__HTRPNCa = rCurrentGuess[16];
        double var_chaste_interface__calcium_subsystem__LTRPNCa = rCurrentGuess[17];
        double var_chaste_interface__calcium_subsystem__P_C1 = rCurrentGuess[18];
        double var_chaste_interface__calcium_subsystem__P_C2 = rCurrentGuess[19];
        double var_chaste_interface__calcium_subsystem__P_O1 = rCurrentGuess[20];
        double var_chaste_interface__calcium_subsystem__P_O2 = rCurrentGuess[21];
        double var_chaste_interface__ionic_concentrations__Ki = rCurrentGuess[22];
        double var_chaste_interface__ionic_concentrations__Ko = rCurrentGuess[23];
        double var_chaste_interface__ionic_concentrations__Nai = rCurrentGuess[24];
        
        //output_equations
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__f = 0.29999999999999999; // per_ms
        const double var_L_type_Ca_channel__f_ = 0; // per_ms
        const double var_L_type_Ca_channel__g = 2.0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O = var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__f - var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g; // 1 / ms
        const double var_L_type_Ca_channel__g_ = 0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca = var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__f_ - var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_; // 1 / ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__CMDN_tot = 0.050000000000000003; // mM
        const double var_calcium_subsystem__CSQN_tot = 15.0; // mM
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_calcium_subsystem__HTRPN_tot = 0.14000000000000001; // mM
        const double var_calcium_subsystem__K_mCMDN = 0.0023800000000000002; // mM
        const double var_calcium_subsystem__B_SS = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Ca_SS + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__Bi = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Cai + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__K_mCSQN = 0.80000000000000004; // mM
        const double var_calcium_subsystem__B_JSR = 1 / (1.0 + var_calcium_subsystem__CSQN_tot * var_calcium_subsystem__K_mCSQN / pow((var_chaste_interface__calcium_subsystem__Ca_JSR + var_calcium_subsystem__K_mCSQN), 2)); // dimensionless
        const double var_calcium_subsystem__K_mup = 0.00050000000000000001; // mM
        const double var_calcium_subsystem__LTRPN_tot = 0.070000000000000007; // mM
        const double var_calcium_subsystem__RyR_open = var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2; // dimensionless
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_calcium_subsystem__V_JSR = 0.00464 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_NSR = 0.081000000000000003 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_SS = 5.8279999999999998e-5 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__k_a_minus = 0.14249999999999999; // per_ms
        const double var_calcium_subsystem__k_a_plus = 12150000000.0; // per_mM4_per_ms
        const double var_calcium_subsystem__k_b_minus = 1.9299999999999999; // per_ms
        const double var_calcium_subsystem__k_b_plus = 40500000.0; // per_mM3_per_ms
        const double var_calcium_subsystem__k_c_minus = 0.00080000000000000004; // per_ms
        const double var_calcium_subsystem__k_c_plus = 0.017999999999999999; // per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C2 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus - var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus; // 1 / ms
        const double var_calcium_subsystem__k_htrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_calcium_subsystem__k_htrpn_plus = 20.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_htrpn = -var_chaste_interface__calcium_subsystem__HTRPNCa * var_calcium_subsystem__k_htrpn_minus + (-var_chaste_interface__calcium_subsystem__HTRPNCa + var_calcium_subsystem__HTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_htrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa = var_calcium_subsystem__J_htrpn; // mM / ms
        const double var_calcium_subsystem__k_ltrpn_minus = 0.040000000000000001; // per_ms
        const double var_calcium_subsystem__k_ltrpn_plus = 40.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_ltrpn = -var_chaste_interface__calcium_subsystem__LTRPNCa * var_calcium_subsystem__k_ltrpn_minus + (-var_chaste_interface__calcium_subsystem__LTRPNCa + var_calcium_subsystem__LTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_ltrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa = var_calcium_subsystem__J_ltrpn; // mM / ms
        const double var_calcium_subsystem__J_trpn = var_calcium_subsystem__J_htrpn + var_calcium_subsystem__J_ltrpn; // mM_per_ms
        const double var_calcium_subsystem__mCa = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O2 = -var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms
        const double var_calcium_subsystem__nCa = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C1 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus; // 1 / ms
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O1 = var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus + var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms
        const double var_calcium_subsystem__tau_tr = 34.479999999999997; // ms
        const double var_calcium_subsystem__J_tr = (-var_chaste_interface__calcium_subsystem__Ca_JSR + var_chaste_interface__calcium_subsystem__Ca_NSR) / var_calcium_subsystem__tau_tr; // mM_per_ms
        const double var_calcium_subsystem__tau_xfer = 3.125; // ms
        const double var_calcium_subsystem__J_xfer = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_SS) / var_calcium_subsystem__tau_xfer; // mM_per_ms
        const double var_calcium_subsystem__v1 = 1.8; // per_ms
        const double var_calcium_subsystem__J_rel = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * var_calcium_subsystem__RyR_open * var_calcium_subsystem__v1; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR = (-var_calcium_subsystem__J_rel + var_calcium_subsystem__J_tr) * var_calcium_subsystem__B_JSR; // mM / ms
        const double var_calcium_subsystem__v2 = 5.8e-5; // per_ms
        const double var_calcium_subsystem__J_leak = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_NSR) * var_calcium_subsystem__v2; // mM_per_ms
        const double var_calcium_subsystem__v3 = 0.0018; // mM_per_ms
        const double var_calcium_subsystem__J_up = pow(var_chaste_interface__calcium_subsystem__Cai, 2) * var_calcium_subsystem__v3 / (pow(var_chaste_interface__calcium_subsystem__Cai, 2) + pow(var_calcium_subsystem__K_mup, 2)); // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR = (-var_calcium_subsystem__J_leak + var_calcium_subsystem__J_up) * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_NSR - var_calcium_subsystem__J_tr * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_NSR; // mM / ms
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C0 = var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__omega - (4.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C0; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C1 = -(3.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__beta) * var_chaste_interface__L_type_Ca_channel__C1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__beta + 4.0 * var_chaste_interface__L_type_Ca_channel__C0 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C2 = -(2.0 * var_L_type_Ca_channel__alpha + 2.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 2) * var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__alpha + 3.0 * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2); // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C3 = -(3.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 3) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__alpha) * var_chaste_interface__L_type_Ca_channel__C3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__alpha + 4.0 * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3); // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C4 = var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g - (4.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 4) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__f) * var_chaste_interface__L_type_Ca_channel__C4 + var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4); // 1 / ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0 = var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__gamma + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__beta_b - (4.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega) * var_chaste_interface__L_type_Ca_channel__C_Ca0; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1 = -(3.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b + var_L_type_Ca_channel__beta_b) * var_chaste_interface__L_type_Ca_channel__C_Ca1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__beta_b + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2 = -(2.0 * var_L_type_Ca_channel__alpha_a + 2.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2)) * var_chaste_interface__L_type_Ca_channel__C_Ca2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__alpha_a + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 2) * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3 = -(3.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3) + var_L_type_Ca_channel__alpha_a) * var_chaste_interface__L_type_Ca_channel__C_Ca3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__alpha_a + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 3) * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4 = var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_ - (4.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4) + var_L_type_Ca_channel__f_) * var_chaste_interface__L_type_Ca_channel__C_Ca4 + pow(var_L_type_Ca_channel__a, 4) * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_SS = (var_calcium_subsystem__J_rel * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_SS - var_calcium_subsystem__J_xfer * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca * var_calcium_subsystem__Am / (var_calcium_subsystem__V_SS * var_membrane__F)) * var_calcium_subsystem__B_SS; // mM / ms
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Cai = (-var_calcium_subsystem__J_trpn - var_calcium_subsystem__J_up - 0.5 * (-2.0 * var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F) + var_calcium_subsystem__J_leak + var_calcium_subsystem__J_xfer) * var_calcium_subsystem__Bi; // mM / ms
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = (-var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = (-var_L_type_Ca_channel__i_Ca_L_K - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + 2.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms
        const double d_dt_chaste_interface_var_ionic_concentrations__Ko = (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K + var_non_specific_calcium_activated_current__i_ns_K + var_plateau_potassium_current__i_Kp + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms
        
        rResidual[10] = rCurrentGuess[10] - rY[4] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__O;
        rResidual[11] = rCurrentGuess[11] - rY[5] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca;
        rResidual[0] = rCurrentGuess[0] - rY[6] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C0;
        rResidual[1] = rCurrentGuess[1] - rY[7] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C1;
        rResidual[2] = rCurrentGuess[2] - rY[8] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C2;
        rResidual[3] = rCurrentGuess[3] - rY[9] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C3;
        rResidual[4] = rCurrentGuess[4] - rY[10] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C4;
        rResidual[5] = rCurrentGuess[5] - rY[11] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0;
        rResidual[6] = rCurrentGuess[6] - rY[12] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1;
        rResidual[7] = rCurrentGuess[7] - rY[13] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2;
        rResidual[8] = rCurrentGuess[8] - rY[14] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3;
        rResidual[9] = rCurrentGuess[9] - rY[15] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4;
        rResidual[15] = rCurrentGuess[15] - rY[18] - mDt*d_dt_chaste_interface_var_calcium_subsystem__Cai;
        rResidual[14] = rCurrentGuess[14] - rY[19] - mDt*d_dt_chaste_interface_var_calcium_subsystem__Ca_SS;
        rResidual[20] = rCurrentGuess[20] - rY[20] - mDt*d_dt_chaste_interface_var_calcium_subsystem__P_O1;
        rResidual[21] = rCurrentGuess[21] - rY[21] - mDt*d_dt_chaste_interface_var_calcium_subsystem__P_O2;
        rResidual[18] = rCurrentGuess[18] - rY[22] - mDt*d_dt_chaste_interface_var_calcium_subsystem__P_C1;
        rResidual[19] = rCurrentGuess[19] - rY[23] - mDt*d_dt_chaste_interface_var_calcium_subsystem__P_C2;
        rResidual[12] = rCurrentGuess[12] - rY[24] - mDt*d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR;
        rResidual[13] = rCurrentGuess[13] - rY[25] - mDt*d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR;
        rResidual[16] = rCurrentGuess[16] - rY[26] - mDt*d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa;
        rResidual[17] = rCurrentGuess[17] - rY[27] - mDt*d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa;
        rResidual[24] = rCurrentGuess[24] - rY[28] - mDt*d_dt_chaste_interface_var_ionic_concentrations__Nai;
        rResidual[22] = rCurrentGuess[22] - rY[29] - mDt*d_dt_chaste_interface_var_ionic_concentrations__Ki;
        rResidual[23] = rCurrentGuess[23] - rY[30] - mDt*d_dt_chaste_interface_var_ionic_concentrations__Ko;
    }

    void Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[25], double rJacobian[25][25])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        
        double var_chaste_interface__L_type_Ca_channel__C0 = rCurrentGuess[0];
        double var_chaste_interface__L_type_Ca_channel__C1 = rCurrentGuess[1];
        double var_chaste_interface__L_type_Ca_channel__C2 = rCurrentGuess[2];
        double var_chaste_interface__L_type_Ca_channel__C3 = rCurrentGuess[3];
        double var_chaste_interface__L_type_Ca_channel__C4 = rCurrentGuess[4];
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rCurrentGuess[5];
        double var_chaste_interface__L_type_Ca_channel__O = rCurrentGuess[10];
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rCurrentGuess[11];
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rCurrentGuess[12];
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rCurrentGuess[13];
        double var_chaste_interface__calcium_subsystem__Ca_SS = rCurrentGuess[14];
        double var_chaste_interface__calcium_subsystem__Cai = rCurrentGuess[15];
        double var_chaste_interface__calcium_subsystem__HTRPNCa = rCurrentGuess[16];
        double var_chaste_interface__calcium_subsystem__LTRPNCa = rCurrentGuess[17];
        double var_chaste_interface__calcium_subsystem__P_C1 = rCurrentGuess[18];
        double var_chaste_interface__calcium_subsystem__P_O1 = rCurrentGuess[20];
        double var_chaste_interface__calcium_subsystem__P_O2 = rCurrentGuess[21];
        double var_chaste_interface__ionic_concentrations__Ki = rCurrentGuess[22];
        double var_chaste_interface__ionic_concentrations__Ko = rCurrentGuess[23];
        double var_chaste_interface__ionic_concentrations__Nai = rCurrentGuess[24];
        
        const double var_x0 = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x1 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x2 = 1.6000000000000001 * var_x1;
        const double var_x3 = -var_x2;
        const double var_x4 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x5 = 0.050000000000000003 * var_x4;
        const double var_x6 = 0.375 * var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x7 = -var_x5;
        const double var_x8 = 1.2000000000000002 * var_x1;
        const double var_x9 = 0.10000000000000001 * var_x4;
        const double var_x10 = 0.375 * var_chaste_interface__L_type_Ca_channel__C1;
        const double var_x11 = 0.75 * var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x12 = -var_x9;
        const double var_x13 = 0.80000000000000004 * var_x1;
        const double var_x14 = -var_x13;
        const double var_x15 = 0.15000000000000002 * var_x4;
        const double var_x16 = 0.75 * var_chaste_interface__L_type_Ca_channel__C2;
        const double var_x17 = 1.5 * var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x18 = 0.40000000000000002 * var_x1;
        const double var_x19 = 0.20000000000000001 * var_x4;
        const double var_x20 = 1.5 * var_chaste_interface__L_type_Ca_channel__C3;
        const double var_x21 = 3.0 * var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x22 = 3.0 * var_chaste_interface__L_type_Ca_channel__C4;
        const double var_x23 = 3.2000000000000002 * var_x1;
        const double var_x24 = 0.025000000000000001 * var_x4;
        const double var_x25 = 2.4000000000000004 * var_x1;
        const double var_x26 = 0.075000000000000011 * var_x4;
        const double var_x27 = 1.8 * var_chaste_interface__calcium_subsystem__P_O1;
        const double var_x28 = 1.8 * var_chaste_interface__calcium_subsystem__P_O2;
        const double var_x29 = 0.80000000000000004 + var_chaste_interface__calcium_subsystem__Ca_JSR;
        const double var_x30 = pow(var_x29, (-2));
        const double var_x31 = 1 / (1.0 + 12.0 * var_x30);
        const double var_x32 = var_x31;
        const double var_x33 = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * (var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2);
        const double var_x34 = var_x32 * (1.8 * var_chaste_interface__calcium_subsystem__Ca_SS - 1.8 * var_chaste_interface__calcium_subsystem__Ca_JSR);
        const double var_x35 = pow(var_chaste_interface__calcium_subsystem__Cai, 2);
        const double var_x36 = 2.4999999999999999e-7 + var_x35;
        const double var_x37 = 1 / var_x36;
        const double var_x38 = var_x37 * var_chaste_interface__calcium_subsystem__Cai;
        const double var_x39 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
        const double var_x40 = var_x39 / pow(var_x36, 2);
        const double var_x41 = 0.0023800000000000002 + var_chaste_interface__calcium_subsystem__Ca_SS;
        const double var_x42 = 1.0 + 0.00011900000000000002 / pow(var_x41, 2);
        const double var_x43 = 1 / var_x42;
        const double var_x44 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
        const double var_x45 = (-0.61380000000000001 + 0.001 * var_x44) * var_chaste_interface__membrane__V / (-1.0 + var_x44);
        const double var_x46 = 25.859308321022734 * var_x45 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
        const double var_x47 = -var_x43 * var_x46;
        const double var_x48 = 143.30816746739879 * var_chaste_interface__calcium_subsystem__P_O1;
        const double var_x49 = 143.30816746739879 * var_chaste_interface__calcium_subsystem__P_O2;
        const double var_x50 = var_x43;
        const double var_x51 = var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca;
        const double var_x52 = var_x50 * (143.30816746739879 * var_chaste_interface__calcium_subsystem__Ca_JSR - 143.30816746739879 * var_chaste_interface__calcium_subsystem__Ca_SS);
        const double var_x53 = 0.0023800000000000002 + var_chaste_interface__calcium_subsystem__Cai;
        const double var_x54 = 1.0 + 0.00011900000000000002 / pow(var_x53, 2);
        const double var_x55 = 1 / var_x54;
        const double var_x56 = 20.0 * var_chaste_interface__calcium_subsystem__HTRPNCa;
        const double var_x57 = 40.0 * var_chaste_interface__calcium_subsystem__LTRPNCa;
        const double var_x58 = 0.00050000000000000001 + var_chaste_interface__calcium_subsystem__Cai;
        const double var_x59 = 3.5281248386597142e-5 / var_x58;
        const double var_x60 = 1 / var_chaste_interface__calcium_subsystem__Cai;
        const double var_x61 = exp(-0.024422646794659157 * var_chaste_interface__membrane__V);
        const double var_x62 = 1 / (1.0 + 0.10000000000000001 * var_x61);
        const double var_x63 = var_x61 * var_x62;
        const double var_x64 = var_x55;
        const double var_x65 = exp(0.013150655966354929 * var_chaste_interface__membrane__V);
        const double var_x66 = 20.0 * var_chaste_interface__calcium_subsystem__Cai;
        const double var_x67 = 40.0 * var_chaste_interface__calcium_subsystem__Cai;
        const double var_x68 = var_x62 * var_x65 * pow(var_chaste_interface__ionic_concentrations__Nai, 2);
        const double var_x69 = pow(var_chaste_interface__calcium_subsystem__Ca_SS, 3.0);
        const double var_x70 = 48600000000.0 * var_x69 * var_chaste_interface__calcium_subsystem__P_C1;
        const double var_x71 = 12150000000.0 * pow(var_chaste_interface__calcium_subsystem__Ca_SS, 4.0);
        const double var_x72 = 121500000.0 * pow(var_chaste_interface__calcium_subsystem__Ca_SS, 2.0) * var_chaste_interface__calcium_subsystem__P_O1;
        const double var_x73 = 40500000.0 * var_x69;
        const double var_x74 = 0.037573302761014088 * var_chaste_interface__membrane__V;
        const double var_x75 = exp(var_x74);
        const double var_x76 = 2.2327118354803037e-8 * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((1.0 - 107.25680748803607 * var_x45) * (-1.0 + var_x75));
        const double var_x77 = var_x76 * (-var_chaste_interface__ionic_concentrations__Ko + var_x75 * var_chaste_interface__ionic_concentrations__Ki);
        const double var_x78 = -var_x77;
        const double var_x79 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
        const double var_x80 = 140.0 + var_chaste_interface__ionic_concentrations__Ko;
        const double var_x81 = log(var_x79 * var_x80);
        const double var_x82 = exp(var_x74 - 1.0 * var_x81);
        const double var_x83 = 0.75 * var_x82;
        const double var_x84 = var_x83 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x85 = var_x84 - 0.75 * var_chaste_interface__ionic_concentrations__Ko;
        const double var_x86 = -1.0 + var_x82;
        const double var_x87 = 1 / var_x86;
        const double var_x88 = -26.614641953637257 * var_x81 + var_chaste_interface__membrane__V;
        const double var_x89 = 1.0 + 1.7279999999999996e-9 / var_x39;
        const double var_x90 = 2.0255161771477306e-16 * var_x87 * var_x88 / (pow(var_x89, 2) * pow(var_chaste_interface__calcium_subsystem__Cai, 4));
        const double var_x91 = var_x85 * var_x90;
        const double var_x92 = 1 / var_chaste_interface__ionic_concentrations__Ki;
        const double var_x93 = 1.3521568226207399e-5 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V));
        const double var_x94 = var_x92 * var_x93;
        const double var_x95 = 1 / (0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki);
        const double var_x96 = sqrt(var_chaste_interface__ionic_concentrations__Ko);
        const double var_x97 = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V));
        const double var_x98 = 7.9270016169768288e-5 * var_x96 * var_x97;
        const double var_x99 = var_x95 * var_x98;
        const double var_x100 = 1 / var_x89;
        const double var_x101 = var_x100 * var_x87;
        const double var_x102 = 3.9072457120905308e-8 * var_x88;
        const double var_x103 = var_x101 * var_x102;
        const double var_x104 = var_x103 * (var_x83 + var_x79 * var_x84);
        const double var_x105 = log(var_x92 * var_chaste_interface__ionic_concentrations__Ko);
        const double var_x106 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3475921059424856 * var_x105);
        const double var_x107 = 1.0 + var_x106;
        const double var_x108 = 1 / var_x107;
        const double var_x109 = 0.0005376025032790136 * var_x108;
        const double var_x110 = exp(-2.4444678999999998 + 13.687910356755641 * var_x105 - 0.51429999999999998 * var_chaste_interface__membrane__V);
        const double var_x111 = 1.0 + var_x110;
        const double var_x112 = 1 / var_x111;
        const double var_x113 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1376880417161446 * var_x105);
        const double var_x114 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6434541406371006 * var_x105);
        const double var_x115 = var_x114 + 0.49124000000000001 * var_x113;
        const double var_x116 = var_x112 * var_x115;
        const double var_x117 = 1 / (var_x116 + 1.02 * var_x108);
        const double var_x118 = var_x117 * var_x92 * var_x96;
        const double var_x119 = var_x109 * var_x118;
        const double var_x120 = 1.0501178736126389 * var_x113;
        const double var_x121 = 1.6434541406371006 * var_x114;
        const double var_x122 = var_x106 / pow(var_x107, 2);
        const double var_x123 = 6.4745439480613349 * var_x122;
        const double var_x124 = 13.687910356755641 * var_x110 * var_x115 / pow(var_x111, 2);
        const double var_x125 = -26.614641953637257 * var_x105 + var_chaste_interface__membrane__V;
        const double var_x126 = var_x108 * var_x125;
        const double var_x127 = 1.9415130354461213e-5 * var_x126 * var_x96 / pow((var_x108 + 0.98039215686274506 * var_x116), 2);
        const double var_x128 = var_x127 * (var_x123 * var_x92 - var_x112 * (var_x120 * var_x92 + var_x121 * var_x92) - var_x124 * var_x92);
        const double var_x129 = 0.00012821819703204474 * var_x122 * var_x125;
        const double var_x130 = var_x118 * var_x129;
        const double var_x131 = var_x51 * var_x76;
        const double var_x132 = var_x131 * var_x75;
        const double var_x133 = 1.0398994565217392e-6 * var_x101;
        const double var_x134 = var_x79 * var_x85;
        const double var_x135 = var_x133 * var_x134;
        const double var_x136 = var_x100 * var_x102 * var_x82 / pow(var_x86, 2);
        const double var_x137 = var_x134 * var_x136;
        const double var_x138 = var_x137 - var_x135;
        const double var_x139 = 1 / var_chaste_interface__ionic_concentrations__Ko;
        const double var_x140 = var_x139 * var_x93;
        const double var_x141 = 1 / (1.5 + var_chaste_interface__ionic_concentrations__Ko);
        const double var_x142 = 1 / var_chaste_interface__ionic_concentrations__Nai;
        const double var_x143 = pow(var_x142, 1.5);
        const double var_x144 = 1 / (1.0 + 0.1245 * exp(-0.0037573302761014088 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-var_x74));
        const double var_x145 = var_x144 / (1.0 + 31.622776601683793 * var_x143);
        const double var_x146 = var_x141 * var_x145;
        const double var_x147 = 0.00015953260140026533 * var_x146;
        const double var_x148 = 1 / var_x96;
        const double var_x149 = var_x117 * var_x148;
        const double var_x150 = var_x109 * var_x149;
        const double var_x151 = 1 / var_x80;
        const double var_x152 = var_x133 * var_x151;
        const double var_x153 = var_x152 * var_x85;
        const double var_x154 = 2.5661999999999998 + var_chaste_interface__ionic_concentrations__Ko;
        const double var_x155 = var_x98 / var_x154;
        const double var_x156 = 1.0099750810390723e-5 * var_x126 * var_x149;
        const double var_x157 = var_x103 * (-0.75 - var_x151 * var_x84);
        const double var_x158 = var_x145 * var_chaste_interface__ionic_concentrations__Ko / pow((1 + 0.66666666666666663 * var_chaste_interface__ionic_concentrations__Ko), 2);
        const double var_x159 = 7.090337840011793e-5 * var_x158;
        const double var_x160 = 1.4892181587085931e-6 * var_x148 * var_x97 * (-26.614641953637257 * log(var_x154 * var_x95) + var_chaste_interface__membrane__V);
        const double var_x161 = var_x129 * var_x149;
        const double var_x162 = var_x127 * (var_x124 * var_x139 - var_x112 * (-var_x120 * var_x139 - var_x121 * var_x139) - var_x123 * var_x139);
        const double var_x163 = var_x136 * var_x151;
        const double var_x164 = var_x163 * var_x85;
        const double var_x165 = 1.4530193963918526e-6 * var_x95 * var_x96 * var_x97;
        const double var_x166 = var_x141 * var_x142 * var_x143 * var_x144 * var_chaste_interface__ionic_concentrations__Ko / pow((0.031622776601683791 + var_x143), 2);
        const double var_x167 = 7.5672957221490862e-6 * var_x166;
        const double var_x168 = 2.9304342840678981e-8 * var_x101 * var_x82 * var_x88;
        const double var_x169 = var_x168 * var_x79;
        const double var_x170 = var_x169 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x171 = var_x135 - var_x137;
        const double var_x172 = var_x83 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x173 = -105.0 + var_x172;
        const double var_x174 = var_x173 * var_x79;
        const double var_x175 = var_x136 * var_x174 - var_x133 * var_x174;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (var_x3 - var_x0));
        rJacobian[0][1] = -(mDt * (var_x5));
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = -(mDt * (0.01));
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = -(mDt * (-0.1875 * var_chaste_interface__L_type_Ca_channel__C0));
        rJacobian[0][15] = 0.0;
        rJacobian[0][16] = 0.0;
        rJacobian[0][17] = 0.0;
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = 0.0;
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = 0.0;
        rJacobian[0][24] = 0.0;
        rJacobian[1][0] = -(mDt * (var_x2));
        rJacobian[1][1] = 1.0 - (mDt * (var_x7 - var_x6 - var_x8));
        rJacobian[1][2] = -(mDt * (var_x9));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = -(mDt * (0.0050000000000000001));
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = -(mDt * (-var_x10));
        rJacobian[1][15] = 0.0;
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = 0.0;
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (var_x8));
        rJacobian[2][2] = 1.0 - (mDt * (var_x12 + var_x14 - var_x11));
        rJacobian[2][3] = -(mDt * (var_x15));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = -(mDt * (0.0025000000000000001));
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = -(mDt * (-var_x16));
        rJacobian[2][15] = 0.0;
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = 0.0;
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = -(mDt * (var_x13));
        rJacobian[3][3] = 1.0 - (mDt * (-var_x15 - var_x17 - var_x18));
        rJacobian[3][4] = -(mDt * (var_x19));
        rJacobian[3][5] = 0.0;
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = -(mDt * (0.00125));
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = -(mDt * (-var_x20));
        rJacobian[3][15] = 0.0;
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = 0.0;
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (var_x18));
        rJacobian[4][4] = 1.0 - (mDt * (-0.29999999999999999 - var_x19 - var_x21));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = -(mDt * (0.00062500000000000001));
        rJacobian[4][10] = -(mDt * (2.0));
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = 0.0;
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = -(mDt * (-var_x22));
        rJacobian[4][15] = 0.0;
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = 0.0;
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-0.01 + var_x0 - var_x23));
        rJacobian[5][6] = -(mDt * (var_x24));
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = -(mDt * (0.1875 * var_chaste_interface__L_type_Ca_channel__C_Ca0));
        rJacobian[5][15] = 0.0;
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = 0.0;
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = -(mDt * (var_x6));
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = -(mDt * (var_x23));
        rJacobian[6][6] = 1.0 - (mDt * (-0.0050000000000000001 - var_x24 - var_x25));
        rJacobian[6][7] = -(mDt * (var_x5));
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = -(mDt * (var_x10));
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = 0.0;
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = -(mDt * (var_x11));
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = -(mDt * (var_x25));
        rJacobian[7][7] = 1.0 - (mDt * (-0.0025000000000000001 + var_x3 + var_x7));
        rJacobian[7][8] = -(mDt * (var_x26));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = -(mDt * (var_x16));
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = 0.0;
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = -(mDt * (var_x17));
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = -(mDt * (var_x2));
        rJacobian[8][8] = 1.0 - (mDt * (-0.00125 + var_x14 - var_x26));
        rJacobian[8][9] = -(mDt * (var_x9));
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = 0.0;
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = -(mDt * (var_x20));
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = 0.0;
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = -(mDt * (var_x21));
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = -(mDt * (var_x13));
        rJacobian[9][9] = 1.0 - (mDt * (-0.00062500000000000001 + var_x12));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = 0.0;
        rJacobian[9][13] = 0.0;
        rJacobian[9][14] = -(mDt * (var_x22));
        rJacobian[9][15] = 0.0;
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = 0.0;
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = -(mDt * (0.29999999999999999));
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (-2.0));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = 0.0;
        rJacobian[10][15] = 0.0;
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0;
        rJacobian[11][12] = 0.0;
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = 0.0;
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = 0.0;
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (var_x32 * (-0.029002320185614851 - var_x27 - var_x28) + 0.16666666666666666 * (0.029002320185614851 * var_chaste_interface__calcium_subsystem__Ca_NSR - 1.8 * var_x33 - 0.029002320185614851 * var_chaste_interface__calcium_subsystem__Ca_JSR) / (pow(var_x29, 3) * pow((0.083333333333333329 + var_x30), 2))));
        rJacobian[12][13] = -(mDt * (0.029002320185614851 * var_x31));
        rJacobian[12][14] = -(mDt * (var_x32 * (var_x27 + var_x28)));
        rJacobian[12][15] = 0.0;
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = -(mDt * (var_x34));
        rJacobian[12][21] = -(mDt * (var_x34));
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = 0.0;
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = 0.0;
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = 0.0;
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = -(mDt * (0.0016613674772994187));
        rJacobian[13][13] = 1.0 - (mDt * (-0.0023774168600154679));
        rJacobian[13][14] = 0.0;
        rJacobian[13][15] = -(mDt * (0.00071604938271604935 + 0.044444444444444439 * var_x38 - 0.044444444444444439 * var_x40));
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = -(mDt * (var_x47));
        rJacobian[14][11] = -(mDt * (var_x47));
        rJacobian[14][12] = -(mDt * (var_x50 * (var_x48 + var_x49)));
        rJacobian[14][13] = 0.0;
        rJacobian[14][14] = 1.0 - (mDt * (var_x50 * (-5490.7343857240912 - var_x48 - var_x49) + 0.00023800000000000004 * (143.30816746739879 * var_x33 + 5490.7343857240912 * var_chaste_interface__calcium_subsystem__Cai - 5490.7343857240912 * var_chaste_interface__calcium_subsystem__Ca_SS - var_x46 * var_x51) / (pow(var_x41, 3) * pow(var_x42, 2))));
        rJacobian[14][15] = -(mDt * (5490.7343857240912 * var_x43));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = -(mDt * (var_x52));
        rJacobian[14][21] = -(mDt * (var_x52));
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = 0.0;
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = 0.0;
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = 0.0;
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = 0.0;
        rJacobian[15][12] = 0.0;
        rJacobian[15][13] = -(mDt * (5.8e-5 * var_x55));
        rJacobian[15][14] = -(mDt * (0.32000000000000001 * var_x55));
        rJacobian[15][15] = 1.0 - (mDt * (var_x64 * (-5.9200580000000009 + var_x56 + var_x57 - var_x59 + 0.0035999999999999999 * var_x40 - 0.0035999999999999999 * var_x38 - 0.077544234316921451 * var_x63 - 2.4626237783962268e-6 * var_x60 + 3.5281248386597142e-5 * var_chaste_interface__calcium_subsystem__Cai / pow(var_x58, 2)) + 0.00023800000000000004 * (5.8e-5 * var_chaste_interface__calcium_subsystem__Ca_NSR + 6.6000000000000005e-5 * var_chaste_interface__calcium_subsystem__HTRPNCa + 0.040000000000000001 * var_chaste_interface__calcium_subsystem__LTRPNCa + 0.32000000000000001 * var_chaste_interface__calcium_subsystem__Ca_SS + 2.4626237783962268e-6 * log(1.8 * var_x60) - 0.32005800000000001 * var_chaste_interface__calcium_subsystem__Cai - 1.8505781762430779e-7 * var_chaste_interface__membrane__V - var_x59 * var_chaste_interface__calcium_subsystem__Cai - var_x66 * (0.14000000000000001 - var_chaste_interface__calcium_subsystem__HTRPNCa) - var_x67 * (0.070000000000000007 - var_chaste_interface__calcium_subsystem__LTRPNCa) + 2.8259560611122977e-8 * var_x62 * (1.8 * var_x65 * pow(var_chaste_interface__ionic_concentrations__Nai, 3) - 2744000.0 * var_x61 * var_chaste_interface__calcium_subsystem__Cai) - 0.0018 * var_x35 * var_x37) / (pow(var_x53, 3) * pow(var_x54, 2))));
        rJacobian[15][16] = -(mDt * (var_x64 * (6.6000000000000005e-5 + var_x66)));
        rJacobian[15][17] = -(mDt * (var_x64 * (0.040000000000000001 + var_x67)));
        rJacobian[15][18] = 0.0;
        rJacobian[15][19] = 0.0;
        rJacobian[15][20] = 0.0;
        rJacobian[15][21] = 0.0;
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = -(mDt * (1.5260162730006407e-7 * var_x55 * var_x68));
        rJacobian[16][0] = 0.0;
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = 0.0;
        rJacobian[16][5] = 0.0;
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = 0.0;
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = -(mDt * (2.8000000000000003 - var_x56));
        rJacobian[16][16] = 1.0 - (mDt * (-6.6000000000000005e-5 - var_x66));
        rJacobian[16][17] = 0.0;
        rJacobian[16][18] = 0.0;
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = 0.0;
        rJacobian[16][21] = 0.0;
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = 0.0;
        rJacobian[16][24] = 0.0;
        rJacobian[17][0] = 0.0;
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = 0.0;
        rJacobian[17][5] = 0.0;
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = 0.0;
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = -(mDt * (2.8000000000000003 - var_x57));
        rJacobian[17][16] = 0.0;
        rJacobian[17][17] = 1.0 - (mDt * (-0.040000000000000001 - var_x67));
        rJacobian[17][18] = 0.0;
        rJacobian[17][19] = 0.0;
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = 0.0;
        rJacobian[17][22] = 0.0;
        rJacobian[17][23] = 0.0;
        rJacobian[17][24] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = -(mDt * (-var_x70));
        rJacobian[18][15] = 0.0;
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = 0.0;
        rJacobian[18][18] = 1.0 - (mDt * (-var_x71));
        rJacobian[18][19] = 0.0;
        rJacobian[18][20] = -(mDt * (0.14249999999999999));
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = 0.0;
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = 0.0;
        rJacobian[19][15] = 0.0;
        rJacobian[19][16] = 0.0;
        rJacobian[19][17] = 0.0;
        rJacobian[19][18] = 0.0;
        rJacobian[19][19] = 1.0 - (mDt * (-0.00080000000000000004));
        rJacobian[19][20] = -(mDt * (0.017999999999999999));
        rJacobian[19][21] = 0.0;
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = 0.0;
        rJacobian[19][24] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = -(mDt * (var_x70 - var_x72));
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = 0.0;
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = -(mDt * (var_x71));
        rJacobian[20][19] = -(mDt * (0.00080000000000000004));
        rJacobian[20][20] = 1.0 - (mDt * (-0.16049999999999998 - var_x73));
        rJacobian[20][21] = -(mDt * (1.9299999999999999));
        rJacobian[20][22] = 0.0;
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = 0.0;
        rJacobian[21][11] = 0.0;
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = -(mDt * (var_x72));
        rJacobian[21][15] = 0.0;
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = 0.0;
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = 0.0;
        rJacobian[21][20] = -(mDt * (var_x73));
        rJacobian[21][21] = 1.0 - (mDt * (-1.9299999999999999));
        rJacobian[21][22] = 0.0;
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = -(mDt * (var_x78));
        rJacobian[22][11] = -(mDt * (var_x78));
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = -(mDt * (-var_x91));
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = 0.0;
        rJacobian[22][18] = 0.0;
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = 0.0;
        rJacobian[22][21] = 0.0;
        rJacobian[22][22] = 1.0 - (mDt * (var_x130 + var_x138 - var_x104 - var_x119 - var_x128 - var_x132 - var_x94 - var_x99));
        rJacobian[22][23] = -(mDt * (var_x131 + var_x140 + var_x147 + var_x150 + var_x153 + var_x155 - var_x156 - var_x157 - var_x159 - var_x160 - var_x161 - var_x162 - var_x164));
        rJacobian[22][24] = -(mDt * (var_x138 + var_x167 - var_x165 - var_x170));
        rJacobian[23][0] = 0.0;
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = -(mDt * (var_x77));
        rJacobian[23][11] = -(mDt * (var_x77));
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = -(mDt * (var_x91));
        rJacobian[23][16] = 0.0;
        rJacobian[23][17] = 0.0;
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = 0.0;
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = -(mDt * (var_x104 + var_x119 + var_x128 + var_x132 + var_x171 + var_x94 + var_x99 - var_x130));
        rJacobian[23][23] = 1.0 - (mDt * (var_x156 + var_x157 + var_x159 + var_x160 + var_x161 + var_x162 + var_x164 - var_x131 - var_x140 - var_x147 - var_x150 - var_x153 - var_x155));
        rJacobian[23][24] = -(mDt * (var_x165 + var_x170 + var_x171 - var_x167));
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = -(mDt * (0.23263270295076435 * var_x63 - var_x173 * var_x90));
        rJacobian[24][16] = 0.0;
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = -(mDt * (var_x175 - var_x169 * var_chaste_interface__ionic_concentrations__Nai));
        rJacobian[24][23] = -(mDt * (0.00010635506760017689 * var_x158 - 0.000239298902100398 * var_x146 + var_x152 * var_x173 - var_x163 * var_x173 + var_x151 * var_x168 * var_chaste_interface__ionic_concentrations__Nai));
        rJacobian[24][24] = 1.0 - (mDt * (var_x175 - 1.1350943583223629e-5 * var_x166 - 4.5780488190019227e-7 * var_x68 - 2.3025858935932891e-6 * var_x142 - var_x103 * (var_x83 + var_x172 * var_x79) - 0.020902907402832696 * var_x142 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j));
    }

    void Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__Cm = 0.01; // uF_per_mm2
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__I_stim = 0.0099999999999999985 * var_membrane__I_stim_converted; // uA_per_mm2
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_membrane__V = (-var_L_type_Ca_channel__i_Ca_L_Ca - var_L_type_Ca_channel__i_Ca_L_K - var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Ca - var_plateau_potassium_current__i_Kp - var_sarcolemmal_calcium_pump__i_p_Ca - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_NaK - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + var_membrane__I_stim) / var_membrane__Cm; // mV / ms
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        
        const double var_L_type_Ca_channel_y_gate__tau_y = 20.0 + 600.0 / (1.0 + exp(3.1578947368421053 + 0.10526315789473684 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_y_gate__y_infinity = 1 / (1.0 + exp(7.333333333333333 + 0.13333333333333333 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(3.5 - 0.16666666666666666 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0));
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0));
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V))));
        const double var_fast_sodium_current_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_time_dependent_potassium_current_X_gate__alpha_X = 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V));
        const double var_time_dependent_potassium_current_X_gate__beta_X = 0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V));
        
        
        rY[16] = (var_chaste_interface__L_type_Ca_channel_y_gate__y + ((var_L_type_Ca_channel_y_gate__y_infinity / var_L_type_Ca_channel_y_gate__tau_y) * mDt)) / (1.0 - ((-1 / var_L_type_Ca_channel_y_gate__tau_y) * mDt));
        rY[2] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[3] = (var_chaste_interface__fast_sodium_current_j_gate__j + ((var_fast_sodium_current_j_gate__alpha_j) * mDt)) / (1.0 - ((-var_fast_sodium_current_j_gate__alpha_j - var_fast_sodium_current_j_gate__beta_j) * mDt));
        rY[1] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((var_fast_sodium_current_m_gate__alpha_m) * mDt)) / (1.0 - ((-var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m) * mDt));
        rY[17] = (var_chaste_interface__time_dependent_potassium_current_X_gate__X + ((var_time_dependent_potassium_current_X_gate__alpha_X) * mDt)) / (1.0 - ((-var_time_dependent_potassium_current_X_gate__alpha_X - var_time_dependent_potassium_current_X_gate__beta_X) * mDt));
        
        double _guess[25] = {rY[6],rY[7],rY[8],rY[9],rY[10],rY[11],rY[12],rY[13],rY[14],rY[15],rY[4],rY[5],rY[24],rY[25],rY[19],rY[18],rY[26],rY[27],rY[22],rY[23],rY[20],rY[21],rY[29],rY[30],rY[28]};
        CardiacNewtonSolver<25,Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<25,Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[6] = _guess[0];
        rY[7] = _guess[1];
        rY[8] = _guess[2];
        rY[9] = _guess[3];
        rY[10] = _guess[4];
        rY[11] = _guess[5];
        rY[12] = _guess[6];
        rY[13] = _guess[7];
        rY[14] = _guess[8];
        rY[15] = _guess[9];
        rY[4] = _guess[10];
        rY[5] = _guess[11];
        rY[24] = _guess[12];
        rY[25] = _guess[13];
        rY[19] = _guess[14];
        rY[18] = _guess[15];
        rY[26] = _guess[16];
        rY[27] = _guess[17];
        rY[22] = _guess[18];
        rY[23] = _guess[19];
        rY[20] = _guess[20];
        rY[21] = _guess[21];
        rY[29] = _guess[22];
        rY[30] = _guess[23];
        rY[28] = _guess[24];
    }

    std::vector<double> Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__I_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "jafri_rice_winslow_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-84.1638);

    // rY[1]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0328302);

    // rY[2]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.988354);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99254);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.84546e-21);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel__O_Ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.997208);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.38897e-05);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_channel__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.535e-09);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.63909e-14);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.56337e-20);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00272826);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.99215e-07);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.71989e-11);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.87031e-15);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.59752e-20);

    // rY[16]:
    this->mVariableNames.push_back("L_type_Ca_channel_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998983);

    // rY[17]:
    this->mVariableNames.push_back("time_dependent_potassium_current_X_gate__X");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000928836);

    // rY[18]:
    this->mVariableNames.push_back("calcium_subsystem__Cai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.94893e-11);

    // rY[19]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_SS");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.000136058);

    // rY[20]:
    this->mVariableNames.push_back("calcium_subsystem__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00119168);

    // rY[21]:
    this->mVariableNames.push_back("calcium_subsystem__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.30613e-09);

    // rY[22]:
    this->mVariableNames.push_back("calcium_subsystem__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.762527);

    // rY[23]:
    this->mVariableNames.push_back("calcium_subsystem__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.236283);

    // rY[24]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.17504);

    // rY[25]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.243891);

    // rY[26]:
    this->mVariableNames.push_back("calcium_subsystem__HTRPNCa");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.13598);

    // rY[27]:
    this->mVariableNames.push_back("calcium_subsystem__LTRPNCa");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00635);

    // rY[28]:
    this->mVariableNames.push_back("ionic_concentrations__Nai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(10.2042);

    // rY[29]:
    this->mVariableNames.push_back("ionic_concentrations__Ki");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(143.727);

    // rY[30]:
    this->mVariableNames.push_back("ionic_concentrations__Ko");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(5.4);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celljafri_rice_winslow_model_1998FromCellMLBackwardEuler)
