//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: iyer_model_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "iyer_model_2004.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"


    Celliyer_model_2004FromCellMLBackwardEuler::Celliyer_model_2004FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<65>(
                67,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celliyer_model_2004FromCellMLBackwardEuler>::Instance();
        Init();
        
    }

    Celliyer_model_2004FromCellMLBackwardEuler::~Celliyer_model_2004FromCellMLBackwardEuler()
    {
    }
    
    double Celliyer_model_2004FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double var_I_stimulus__i_Stim = 0.0; // uA_per_uF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celliyer_model_2004FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[65], double rResidual[65])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rCurrentGuess[0];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rCurrentGuess[1];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rCurrentGuess[2];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rCurrentGuess[3];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rCurrentGuess[4];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rCurrentGuess[5];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = rCurrentGuess[6];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rCurrentGuess[7];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rCurrentGuess[8];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rCurrentGuess[9];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = rCurrentGuess[10];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rCurrentGuess[11];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rCurrentGuess[12];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rCurrentGuess[13];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = rCurrentGuess[14];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rCurrentGuess[15];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = rCurrentGuess[16];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rCurrentGuess[17];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rCurrentGuess[18];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rCurrentGuess[19];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = rCurrentGuess[20];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rCurrentGuess[21];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rCurrentGuess[22];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rCurrentGuess[23];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = rCurrentGuess[24];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rCurrentGuess[25];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rCurrentGuess[26];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rCurrentGuess[27];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rCurrentGuess[28];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rCurrentGuess[29];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rCurrentGuess[30];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = rCurrentGuess[31];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rCurrentGuess[32];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rCurrentGuess[33];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rCurrentGuess[34];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = rCurrentGuess[35];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rCurrentGuess[36];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = rCurrentGuess[37];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = rCurrentGuess[38];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rCurrentGuess[39];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rCurrentGuess[40];
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rCurrentGuess[41];
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rCurrentGuess[42];
        double var_chaste_interface__IKr__C1Herg = rCurrentGuess[43];
        double var_chaste_interface__IKr__C2Herg = rCurrentGuess[44];
        double var_chaste_interface__IKr__C3Herg = rCurrentGuess[45];
        double var_chaste_interface__IKr__IHerg = rCurrentGuess[46];
        double var_chaste_interface__IKr__OHerg = rCurrentGuess[47];
        double var_chaste_interface__IKs__C0ks = rCurrentGuess[48];
        double var_chaste_interface__IKs__C1ks = rCurrentGuess[49];
        double var_chaste_interface__IKs__O1ks = rCurrentGuess[50];
        double var_chaste_interface__IKs__O2ks = rCurrentGuess[51];
        double var_chaste_interface__INa__na1 = rCurrentGuess[52];
        double var_chaste_interface__INa__na10 = rCurrentGuess[53];
        double var_chaste_interface__INa__na11 = rCurrentGuess[54];
        double var_chaste_interface__INa__na12 = rCurrentGuess[55];
        double var_chaste_interface__INa__na13 = rCurrentGuess[56];
        double var_chaste_interface__INa__na2 = rCurrentGuess[57];
        double var_chaste_interface__INa__na3 = rCurrentGuess[58];
        double var_chaste_interface__INa__na4 = rCurrentGuess[59];
        double var_chaste_interface__INa__na5 = rCurrentGuess[60];
        double var_chaste_interface__INa__na6 = rCurrentGuess[61];
        double var_chaste_interface__INa__na7 = rCurrentGuess[62];
        double var_chaste_interface__INa__na8 = rCurrentGuess[63];
        double var_chaste_interface__INa__na9 = rCurrentGuess[64];
        
        //output_equations
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR = 1.6e-7; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR = 2.0999999999999998e-6; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS = 1.2e-9; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo); // F_M_per_coulomb
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS); // F_M_per_coulomb
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 = 2.1203537909499999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14 = 54749.19473332601; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 = 524.57620667900005; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43 = 142.93664535100001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL = 0.29999999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL = 4.0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus = 0.57599999999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus = 0.012149999999999999; // per_uM4_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus = 1.9299999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus = 0.0040499999999999998; // per_uM3_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus = 0.00080000000000000004; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus = 0.10000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus - var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop = 3.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR = -var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus + pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop = 4.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus - pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR = -var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // per_ms
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR = 1.2; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb = 0.00016799999999999999; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb = 3.29; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb = 1.2; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb = 1.0; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr = 0.57469999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer = 26.699999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1 = 1.8; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf = 7.4800000000000002e-5; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr = 0.00031799999999999998; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup = (var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf - var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR / (1.0 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb); // mM_per_ms
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot = 0.050000000000000003; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot = 15.0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot = 0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot = 0.14000000000000001; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN = 0.0023800000000000002; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN = 0.80000000000000004; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA = 0.00014999999999999999; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot = 0.070000000000000007; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus = 20.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus = 0.040000000000000001; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus = 40.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // mM_per_ms
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = (-var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 * var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup - var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn - 0.5 * (-2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL - var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // 1 / ms
        const double var_IKr__A0_HERG = 0.017147641733086; // per_ms
        const double var_IKr__A1_HERG = 0.039693283811409998; // per_ms
        const double var_IKr__A2_HERG = 0.020574486059770001; // per_ms
        const double var_IKr__A3_HERG = 0.00134366604423; // per_ms
        const double var_IKr__A4_HERG = 0.10666316491288; // per_ms
        const double var_IKr__A5_HERG = 0.0064639391004900001; // per_ms
        const double var_IKr__A6_HERG = 8.0393744030000006e-5; // per_ms
        const double var_IKr__B0_HERG = 0.033046080388350003; // per_mV
        const double var_IKr__B1_HERG = -0.043060541639799998; // per_mV
        const double var_IKr__B2_HERG = 0.026174127151180001; // per_mV
        const double var_IKr__B3_HERG = -0.026913854983990002; // per_mV
        const double var_IKr__B4_HERG = 0.0056890885971700002; // per_mV
        const double var_IKr__B5_HERG = -0.045366429595429997; // per_mV
        const double var_IKr__B6_HERG = 6.9808923999999997e-7; // per_mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C1H_to_C2H = var_IKr__A0_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B0_HERG); // per_ms
        const double var_IKr__C2H_to_C1H = var_IKr__A1_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B1_HERG); // per_ms
        const double d_dt_chaste_interface_var_IKr__C1Herg = var_IKr__C2H_to_C1H * var_chaste_interface__IKr__C2Herg - var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg; // 1 / ms
        const double var_IKr__C2H_to_C3H = 0.026083620433370001 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_C2H = 0.14832978132145 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_IH = var_IKr__A6_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B6_HERG); // per_ms
        const double var_IKr__C3H_to_OH = var_IKr__A2_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B2_HERG); // per_ms
        const double var_IKr__IH_to_OH = var_IKr__A5_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B5_HERG); // per_ms
        const double var_IKr__OH_to_C3H = var_IKr__A3_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B3_HERG); // per_ms
        const double var_IKr__OH_to_IH = var_IKr__A4_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B4_HERG); // per_ms
        const double var_IKr__IH_to_C3H = var_IKr__C3H_to_IH * var_IKr__IH_to_OH * var_IKr__OH_to_C3H / (var_IKr__C3H_to_OH * var_IKr__OH_to_IH); // per_ms
        const double var_IKr__a1_C2 = var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg + var_IKr__C3H_to_C2H * var_chaste_interface__IKr__C3Herg; // per_ms
        const double var_IKr__a1_C3 = var_IKr__C2H_to_C3H * var_chaste_interface__IKr__C2Herg + var_IKr__IH_to_C3H * var_chaste_interface__IKr__IHerg + var_IKr__OH_to_C3H * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a1_I = var_IKr__C3H_to_IH * var_chaste_interface__IKr__C3Herg + var_IKr__OH_to_IH * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a1_O = var_IKr__C3H_to_OH * var_chaste_interface__IKr__C3Herg + var_IKr__IH_to_OH * var_chaste_interface__IKr__IHerg; // per_ms
        const double var_IKr__a2_C2 = (var_IKr__C2H_to_C1H + var_IKr__C2H_to_C3H) * var_chaste_interface__IKr__C2Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C2Herg = -var_IKr__a2_C2 + var_IKr__a1_C2; // 1 / ms
        const double var_IKr__a2_C3 = (var_IKr__C3H_to_C2H + var_IKr__C3H_to_IH + var_IKr__C3H_to_OH) * var_chaste_interface__IKr__C3Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C3Herg = -var_IKr__a2_C3 + var_IKr__a1_C3; // 1 / ms
        const double var_IKr__a2_I = (var_IKr__IH_to_C3H + var_IKr__IH_to_OH) * var_chaste_interface__IKr__IHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__IHerg = -var_IKr__a2_I + var_IKr__a1_I; // 1 / ms
        const double var_IKr__a2_O = (var_IKr__OH_to_C3H + var_IKr__OH_to_IH) * var_chaste_interface__IKr__OHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__OHerg = -var_IKr__a2_O + var_IKr__a1_O; // 1 / ms
        const double var_IKs__C0ks_C1ks = 0.0079560079800399999; // per_ms
        const double var_IKs__C1ks_C0ks = 0.21625575895849999 * exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C0ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_C0ks - var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks; // 1 / ms
        const double var_IKs__C1ks_O1ks = 0.039667206760709998; // per_ms
        const double var_IKs__O1ks_C1ks = 0.0070080662892900002 * exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1ks = var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks + var_chaste_interface__IKs__O1ks * var_IKs__O1ks_C1ks - (var_IKs__C1ks_C0ks + var_IKs__C1ks_O1ks) * var_chaste_interface__IKs__C1ks; // 1 / ms
        const double var_IKs__O1ks_O2ks = 0.00767254363063 * exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_IKs__O2ks_O1ks = 0.0037973799836799999 * exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_O1ks + var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks - (var_IKs__O1ks_C1ks + var_IKs__O1ks_O2ks) * var_chaste_interface__IKs__O1ks; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2ks = var_chaste_interface__IKs__O1ks * var_IKs__O1ks_O2ks - var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks; // 1 / ms
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__Delta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(229.20500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 133689.93040909999 / var_INa__RTNa - 1.55804214553883 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__DeltaDelta = var_INa__KToverH * var_INa__Temp_Scale * exp(-130.63900000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 55700.662465830697 / var_INa__RTNa - 3.6498167292707802 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__GammaGamma = var_INa__KToverH * var_INa__Temp_Scale * exp(116431.14214234801 / var_INa__RTNa - 578.31700000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas + 0.76412601174570705 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__Of = var_INa__KToverH * var_INa__Temp_Scale * exp(1.51 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 97657.849713701493 / var_INa__RTNa + 0.068486199310068496 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__On = var_INa__KToverH * var_INa__Temp_Scale * exp(39.295000000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 62123.078438048098 / var_INa__RTNa + 0.28881604274323203 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__epsilon = var_INa__KToverH * var_INa__Temp_Scale * exp(70.078000000000003 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 85800.367557832593 / var_INa__RTNa); // per_ms
        const double var_INa__gamma1 = var_INa__KToverH * var_INa__Temp_Scale * exp(529.952 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 196336.57573592299 / var_INa__RTNa + 2.7808491859604501 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k1213 = var_INa__GammaGamma; // per_ms
        const double var_INa__k1312 = var_INa__DeltaDelta; // per_ms
        const double var_INa__k136 = var_INa__Of; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k56 = var_INa__gamma1; // per_ms
        const double var_INa__k613 = var_INa__On; // per_ms
        const double var_INa__k65 = var_INa__Delta1; // per_ms
        const double var_INa__k67 = var_INa__epsilon; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__mu = var_INa__KToverH * var_INa__Temp_Scale * exp(193.26499999999999 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121322.14327524199 / var_INa__RTNa - 1.74290267020903 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k75 = var_INa__mu; // per_ms
        const double d_dt_chaste_interface_var_INa__na13 = var_INa__k1213 * var_chaste_interface__INa__na12 + var_INa__k613 * var_chaste_interface__INa__na6 - (var_INa__k1312 + var_INa__k136) * var_chaste_interface__INa__na13; // 1 / ms
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = (-var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms
        const double d_dt_chaste_interface_var_INa__na1 = (-var_INa__k12 - var_INa__k18) * var_chaste_interface__INa__na1 + var_INa__k21 * var_chaste_interface__INa__na2 + var_INa__k81 * var_chaste_interface__INa__na8; // 1 / ms
        const double var_INa__omega_na = var_INa__KToverH * var_INa__Temp_Scale * exp(225.17500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121955.166154864 / var_INa__RTNa); // per_ms
        const double var_INa__k76 = var_INa__omega_na; // per_ms
        const double d_dt_chaste_interface_var_INa__na6 = var_INa__k136 * var_chaste_interface__INa__na13 + var_INa__k56 * var_chaste_interface__INa__na5 + var_INa__k76 * var_chaste_interface__INa__na7 - (var_INa__k613 + var_INa__k65 + var_INa__k67) * var_chaste_interface__INa__na6; // 1 / ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k1011 = var_INa__k34 * var_INa__parameter_a; // per_ms
        const double var_INa__k109 = var_INa__k32 / var_INa__parameter_a; // per_ms
        const double var_INa__k1110 = var_INa__k43 / var_INa__parameter_a; // per_ms
        const double var_INa__k1112 = var_INa__k45 * var_INa__parameter_a; // per_ms
        const double var_INa__k1211 = var_INa__k54 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k512 = var_INa__k411 * var_INa__parameter_a; // per_ms
        const double var_INa__k89 = var_INa__k12 * var_INa__parameter_a; // per_ms
        const double var_INa__k910 = var_INa__k23 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na2 = var_INa__k12 * var_chaste_interface__INa__na1 + var_INa__k32 * var_chaste_interface__INa__na3 + var_INa__k92 * var_chaste_interface__INa__na9 - (var_INa__k21 + var_INa__k23 + var_INa__k29) * var_chaste_interface__INa__na2; // 1 / ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na10 = var_INa__k1110 * var_chaste_interface__INa__na11 + var_INa__k310 * var_chaste_interface__INa__na3 + var_INa__k910 * var_chaste_interface__INa__na9 - (var_INa__k1011 + var_INa__k103 + var_INa__k109) * var_chaste_interface__INa__na10; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na3 = var_INa__k103 * var_chaste_interface__INa__na10 + var_INa__k23 * var_chaste_interface__INa__na2 + var_INa__k43 * var_chaste_interface__INa__na4 - (var_INa__k310 + var_INa__k32 + var_INa__k34) * var_chaste_interface__INa__na3; // 1 / ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na11 = var_INa__k1011 * var_chaste_interface__INa__na10 + var_INa__k1211 * var_chaste_interface__INa__na12 + var_INa__k411 * var_chaste_interface__INa__na4 - (var_INa__k1110 + var_INa__k1112 + var_INa__k114) * var_chaste_interface__INa__na11; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na4 = var_INa__k114 * var_chaste_interface__INa__na11 + var_INa__k34 * var_chaste_interface__INa__na3 + var_INa__k54 * var_chaste_interface__INa__na5 - (var_INa__k411 + var_INa__k43 + var_INa__k45) * var_chaste_interface__INa__na4; // 1 / ms
        const double var_INa__k125 = var_INa__k114 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na12 = var_INa__k1112 * var_chaste_interface__INa__na11 + var_INa__k1312 * var_chaste_interface__INa__na13 + var_INa__k512 * var_chaste_interface__INa__na5 - (var_INa__k1211 + var_INa__k1213 + var_INa__k125) * var_chaste_interface__INa__na12; // 1 / ms
        const double var_INa__k98 = var_INa__k21 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na8 = var_INa__k18 * var_chaste_interface__INa__na1 + var_INa__k98 * var_chaste_interface__INa__na9 - (var_INa__k81 + var_INa__k89) * var_chaste_interface__INa__na8; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na9 = var_INa__k109 * var_chaste_interface__INa__na10 + var_INa__k29 * var_chaste_interface__INa__na2 + var_INa__k89 * var_chaste_interface__INa__na8 - (var_INa__k910 + var_INa__k92 + var_INa__k98) * var_chaste_interface__INa__na9; // 1 / ms
        const double var_INa__rho = var_INa__KToverH * var_INa__Temp_Scale * exp(338.91500000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 147813.99000503501 / var_INa__RTNa + 2.1360043702125999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k57 = var_INa__rho; // per_ms
        const double d_dt_chaste_interface_var_INa__na5 = var_INa__k125 * var_chaste_interface__INa__na12 + var_INa__k45 * var_chaste_interface__INa__na4 + var_INa__k65 * var_chaste_interface__INa__na6 + var_INa__k75 * var_chaste_interface__INa__na7 - (var_INa__k512 + var_INa__k54 + var_INa__k56 + var_INa__k57) * var_chaste_interface__INa__na5; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na7 = var_INa__k57 * var_chaste_interface__INa__na5 + var_INa__k67 * var_chaste_interface__INa__na6 - (var_INa__k75 + var_INa__k76) * var_chaste_interface__INa__na7; // 1 / ms
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = (-var_COMPUTE_ICa_ICaK__ICaK - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 - var_I_stimulus__i_Stim + 2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms
        
        rResidual[5] = rCurrentGuess[5] - rY[1] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
        rResidual[4] = rCurrentGuess[4] - rY[2] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
        rResidual[3] = rCurrentGuess[3] - rY[3] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        rResidual[2] = rCurrentGuess[2] - rY[4] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        rResidual[0] = rCurrentGuess[0] - rY[5] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR;
        rResidual[1] = rCurrentGuess[1] - rY[6] - mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR;
        rResidual[42] = rCurrentGuess[42] - rY[7] - mDt*d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa;
        rResidual[41] = rCurrentGuess[41] - rY[8] - mDt*d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa;
        rResidual[37] = rCurrentGuess[37] - rY[9] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR;
        rResidual[40] = rCurrentGuess[40] - rY[10] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
        rResidual[38] = rCurrentGuess[38] - rY[11] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR;
        rResidual[39] = rCurrentGuess[39] - rY[12] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
        rResidual[26] = rCurrentGuess[26] - rY[13] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0;
        rResidual[27] = rCurrentGuess[27] - rY[14] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1;
        rResidual[28] = rCurrentGuess[28] - rY[15] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2;
        rResidual[29] = rCurrentGuess[29] - rY[16] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3;
        rResidual[30] = rCurrentGuess[30] - rY[17] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4;
        rResidual[31] = rCurrentGuess[31] - rY[18] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0;
        rResidual[32] = rCurrentGuess[32] - rY[19] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1;
        rResidual[33] = rCurrentGuess[33] - rY[20] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2;
        rResidual[34] = rCurrentGuess[34] - rY[21] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3;
        rResidual[35] = rCurrentGuess[35] - rY[22] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4;
        rResidual[36] = rCurrentGuess[36] - rY[23] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open;
        rResidual[16] = rCurrentGuess[16] - rY[25] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43;
        rResidual[17] = rCurrentGuess[17] - rY[26] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43;
        rResidual[18] = rCurrentGuess[18] - rY[27] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43;
        rResidual[19] = rCurrentGuess[19] - rY[28] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43;
        rResidual[25] = rCurrentGuess[25] - rY[29] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43;
        rResidual[20] = rCurrentGuess[20] - rY[30] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43;
        rResidual[21] = rCurrentGuess[21] - rY[31] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43;
        rResidual[22] = rCurrentGuess[22] - rY[32] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43;
        rResidual[23] = rCurrentGuess[23] - rY[33] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43;
        rResidual[24] = rCurrentGuess[24] - rY[34] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43;
        rResidual[6] = rCurrentGuess[6] - rY[35] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14;
        rResidual[7] = rCurrentGuess[7] - rY[36] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14;
        rResidual[8] = rCurrentGuess[8] - rY[37] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14;
        rResidual[9] = rCurrentGuess[9] - rY[38] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14;
        rResidual[15] = rCurrentGuess[15] - rY[39] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
        rResidual[10] = rCurrentGuess[10] - rY[40] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14;
        rResidual[11] = rCurrentGuess[11] - rY[41] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14;
        rResidual[12] = rCurrentGuess[12] - rY[42] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14;
        rResidual[13] = rCurrentGuess[13] - rY[43] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14;
        rResidual[14] = rCurrentGuess[14] - rY[44] - mDt*d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14;
        rResidual[52] = rCurrentGuess[52] - rY[45] - mDt*d_dt_chaste_interface_var_INa__na1;
        rResidual[57] = rCurrentGuess[57] - rY[46] - mDt*d_dt_chaste_interface_var_INa__na2;
        rResidual[58] = rCurrentGuess[58] - rY[47] - mDt*d_dt_chaste_interface_var_INa__na3;
        rResidual[59] = rCurrentGuess[59] - rY[48] - mDt*d_dt_chaste_interface_var_INa__na4;
        rResidual[60] = rCurrentGuess[60] - rY[49] - mDt*d_dt_chaste_interface_var_INa__na5;
        rResidual[61] = rCurrentGuess[61] - rY[50] - mDt*d_dt_chaste_interface_var_INa__na6;
        rResidual[62] = rCurrentGuess[62] - rY[51] - mDt*d_dt_chaste_interface_var_INa__na7;
        rResidual[63] = rCurrentGuess[63] - rY[52] - mDt*d_dt_chaste_interface_var_INa__na8;
        rResidual[64] = rCurrentGuess[64] - rY[53] - mDt*d_dt_chaste_interface_var_INa__na9;
        rResidual[53] = rCurrentGuess[53] - rY[54] - mDt*d_dt_chaste_interface_var_INa__na10;
        rResidual[54] = rCurrentGuess[54] - rY[55] - mDt*d_dt_chaste_interface_var_INa__na11;
        rResidual[55] = rCurrentGuess[55] - rY[56] - mDt*d_dt_chaste_interface_var_INa__na12;
        rResidual[56] = rCurrentGuess[56] - rY[57] - mDt*d_dt_chaste_interface_var_INa__na13;
        rResidual[43] = rCurrentGuess[43] - rY[58] - mDt*d_dt_chaste_interface_var_IKr__C1Herg;
        rResidual[44] = rCurrentGuess[44] - rY[59] - mDt*d_dt_chaste_interface_var_IKr__C2Herg;
        rResidual[45] = rCurrentGuess[45] - rY[60] - mDt*d_dt_chaste_interface_var_IKr__C3Herg;
        rResidual[47] = rCurrentGuess[47] - rY[61] - mDt*d_dt_chaste_interface_var_IKr__OHerg;
        rResidual[46] = rCurrentGuess[46] - rY[62] - mDt*d_dt_chaste_interface_var_IKr__IHerg;
        rResidual[48] = rCurrentGuess[48] - rY[63] - mDt*d_dt_chaste_interface_var_IKs__C0ks;
        rResidual[49] = rCurrentGuess[49] - rY[64] - mDt*d_dt_chaste_interface_var_IKs__C1ks;
        rResidual[50] = rCurrentGuess[50] - rY[65] - mDt*d_dt_chaste_interface_var_IKs__O1ks;
        rResidual[51] = rCurrentGuess[51] - rY[66] - mDt*d_dt_chaste_interface_var_IKs__O2ks;
    }

    void Celliyer_model_2004FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[65], double rJacobian[65][65])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rCurrentGuess[0];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rCurrentGuess[1];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rCurrentGuess[2];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rCurrentGuess[3];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rCurrentGuess[4];
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rCurrentGuess[5];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rCurrentGuess[15];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rCurrentGuess[25];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rCurrentGuess[26];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rCurrentGuess[27];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rCurrentGuess[28];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rCurrentGuess[29];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rCurrentGuess[30];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rCurrentGuess[36];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = rCurrentGuess[37];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rCurrentGuess[39];
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rCurrentGuess[40];
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rCurrentGuess[41];
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rCurrentGuess[42];
        double var_chaste_interface__IKr__OHerg = rCurrentGuess[47];
        double var_chaste_interface__IKs__O1ks = rCurrentGuess[50];
        double var_chaste_interface__IKs__O2ks = rCurrentGuess[51];
        double var_chaste_interface__INa__na6 = rCurrentGuess[61];
        double var_chaste_interface__INa__na7 = rCurrentGuess[62];
        
        const double var_x0 = 1.8 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
        const double var_x1 = 1.8 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
        const double var_x2 = 0.80000000000000004 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR;
        const double var_x3 = pow(var_x2, (-2));
        const double var_x4 = 1 / (1.0 + 12.0 * var_x3);
        const double var_x5 = var_x4;
        const double var_x6 = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR);
        const double var_x7 = var_x5 * (1.8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS - 1.8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR);
        const double var_x8 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai, 1.2);
        const double var_x9 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR, 1.0);
        const double var_x10 = 1 / (1.0 + 33855.471141425078 * var_x8 + 0.303951367781155 * var_x9);
        const double var_x11 = 2.532389241378596 * var_x8 - 9.6656534954407287e-5 * var_x9;
        const double var_x12 = var_x11 / pow((2.9537323401073989e-5 + var_x8 + 8.9779098483507565e-6 * var_x9), 2);
        const double var_x13 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai, 0.19999999999999996);
        const double var_x14 = var_x10 * var_x13;
        const double var_x15 = var_x12 * var_x13;
        const double var_x16 = 240.0 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
        const double var_x17 = 240.0 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
        const double var_x18 = 0.0023800000000000002 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x19 = 1.0 + 0.00011900000000000002 / pow(var_x18, 2);
        const double var_x20 = 1 / var_x19;
        const double var_x21 = var_x20;
        const double var_x22 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
        const double var_x23 = exp(0.074874401101778759 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x24 = (-0.68200000000000005 + 0.001 * var_x23) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / (-1.0 + var_x23);
        const double var_x25 = 16.54232713906077 * var_x24;
        const double var_x26 = var_x21 * (240.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR - 240.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS);
        const double var_x27 = 0.0023800000000000002 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        const double var_x28 = 1.0 + 0.00011900000000000002 / pow(var_x27, 2);
        const double var_x29 = 1 / var_x28;
        const double var_x30 = var_x29;
        const double var_x31 = 0.00050000000000000001 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        const double var_x32 = 1.5379617895699322e-6 / var_x31;
        const double var_x33 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        const double var_x34 = exp(-0.024334180358078095 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x35 = 1 / (1.0 + 0.20000000000000001 * var_x34);
        const double var_x36 = var_x34 * var_x35;
        const double var_x37 = exp(0.013103020192811281 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x38 = 2.8000000000000003 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        const double var_x39 = var_x35 * var_x37 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 2);
        const double var_x40 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
        const double var_x41 = log(4.0 * var_x40);
        const double var_x42 = exp(0.047170872694120618 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V - 1.26 * var_x41);
        const double var_x43 = 0.93999999999999995 + var_x42;
        const double var_x44 = exp(0.03743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x45 = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / (-1.0 + var_x44);
        const double var_x46 = 9.2470395326765519e-9 * var_x45;
        const double var_x47 = var_x44 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
        const double var_x48 = 24.975247492871414 * var_x24;
        const double var_x49 = 7.1159095070575419e-7 * var_x45 / (1.0 - 3.773584905660377 * ((var_x48 >= 0) ? (0) : (var_x48)));
        const double var_x50 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
        const double var_x51 = pow(var_x50, 1.5);
        const double var_x52 = var_x50 * var_x51 / (pow((0.011180339887498949 + var_x51), 2) * (1.0 + 0.1245 * exp(-0.003743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0505200594353643)) * exp(-0.049791476732682874 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)));
        const double var_x53 = -4.0 + var_x44 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
        const double var_x54 = 5.7513555333045694e-6 * var_x41 - 2.1531465053979051e-7 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        const double var_x55 = 1.8494079065353104e-10 * var_x45;
        const double var_x56 = 0.092547526753060952 * log(138.0 * var_x50) - 0.0034647203195431429 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        const double var_x57 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x58 = 7.3600965821599997 * var_x57;
        const double var_x59 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x60 = 0.010817483399999999 * var_x59;
        const double var_x61 = 5.5200724366199996 * var_x57;
        const double var_x62 = 0.021634966799999999 * var_x59;
        const double var_x63 = 3.6800482910799999 * var_x57;
        const double var_x64 = 0.032452450199999996 * var_x59;
        const double var_x65 = 1.8400241455399999 * var_x57;
        const double var_x66 = 0.043269933599999998 * var_x59;
        const double var_x67 = 7.4298590445392074 * var_x57;
        const double var_x68 = 0.020618446856331008 * var_x59;
        const double var_x69 = 6.4033407827395079 * var_x57;
        const double var_x70 = 0.00064791916666788224 * var_x59;
        const double var_x71 = 2.0082338973371909 * var_x57;
        const double var_x72 = 0.00060572898292340319 * var_x59;
        const double var_x73 = 6.1053726595326019 * var_x57;
        const double var_x74 = 0.00074179401705723523 * var_x59;
        const double var_x75 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x76 = 2.1748319999999999 * var_x75;
        const double var_x77 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x78 = 0.00081948199999999996 * var_x77;
        const double var_x79 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x80 = 0.080185000000000006 * var_x79;
        const double var_x81 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x82 = 0.049842400000000002 * var_x81;
        const double var_x83 = 1.6311239999999998 * var_x75;
        const double var_x84 = 0.0015517711151999999 * var_x77;
        const double var_x85 = 0.16037000000000001 * var_x79;
        const double var_x86 = 0.0073584627104531205 * var_x81;
        const double var_x87 = 1.0874159999999999 * var_x75;
        const double var_x88 = 0.011656842546537791 * var_x77;
        const double var_x89 = 0.24055500000000002 * var_x79;
        const double var_x90 = 0.0031906751727717496 * var_x81;
        const double var_x91 = 0.54370799999999997 * var_x75;
        const double var_x92 = 0.12994884875097448 * var_x77;
        const double var_x93 = 0.0017334521172801731 * var_x81;
        const double var_x94 = 0.32074000000000003 * var_x79;
        const double var_x95 = 14.731181055359999 * var_x75;
        const double var_x96 = 0.042345268272074361 * var_x79;
        const double var_x97 = 3.7617634137599998 * var_x75;
        const double var_x98 = 0.021348622729620501 * var_x79;
        const double var_x99 = 2.0015500855706554 * var_x75;
        const double var_x100 = 0.021578581001175438 * var_x79;
        const double var_x101 = 9.9194413744637924 * var_x75;
        const double var_x102 = 0.35582999726621212 * var_x79;
        const double var_x103 = 9.5014602960251466e-5 * var_x81;
        const double var_x104 = 0.11713400800552819 * var_x77;
        const double var_x105 = 0.055397999999999996 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0;
        const double var_x106 = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x107 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x108 = 7.9871999999999996 * var_x107;
        const double var_x109 = -var_x108;
        const double var_x110 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x111 = 0.088200000000000001 * var_x110;
        const double var_x112 = 0.11079599999999999 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1;
        const double var_x113 = 5.9903999999999993 * var_x107;
        const double var_x114 = 0.11079599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x115 = -var_x111;
        const double var_x116 = 0.1764 * var_x110;
        const double var_x117 = 0.22159199999999998 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2;
        const double var_x118 = 0.22159199999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x119 = -var_x116;
        const double var_x120 = 3.9935999999999998 * var_x107;
        const double var_x121 = -var_x120;
        const double var_x122 = 0.2646 * var_x110;
        const double var_x123 = 0.44318399999999997 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3;
        const double var_x124 = 0.44318399999999997 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x125 = 1.9967999999999999 * var_x107;
        const double var_x126 = 0.3528 * var_x110;
        const double var_x127 = 0.88636799999999993 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4;
        const double var_x128 = 0.88636799999999993 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        const double var_x129 = 15.974399999999999 * var_x107;
        const double var_x130 = 0.0441 * var_x110;
        const double var_x131 = 11.980799999999999 * var_x107;
        const double var_x132 = 0.1323 * var_x110;
        const double var_x133 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS, 3.0);
        const double var_x134 = 48600000000.0 * var_x133 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR;
        const double var_x135 = 12150000000.0 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS, 4.0);
        const double var_x136 = 12150000.0 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS, 2.0) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
        const double var_x137 = 4050000.0 * var_x133;
        const double var_x138 = 0.091225454037165171 * exp(0.033046080388350003 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x139 = 0.21116826991639448 * exp(-0.043060541639799998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x140 = exp(0.026174127151180001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x141 = 0.10945626585855089 * var_x140;
        const double var_x142 = exp(6.9808923999999997e-7 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x143 = 0.00042769471831999382 * var_x142;
        const double var_x144 = exp(0.0056890885971700002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x145 = exp(-0.045366429595429997 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x146 = exp(-0.026913854983990002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x147 = 1.6926962184371784e-6 * var_x142 * var_x145 * var_x146 / (var_x140 * var_x144);
        const double var_x148 = 0.0071483033566472664 * var_x146;
        const double var_x149 = 0.034388156021070745 * var_x145;
        const double var_x150 = 0.56744803744318484 * var_x144;
        const double var_x151 = 0.21625575895849999 * exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x152 = 0.0070080662892900002 * exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x153 = 0.00767254363063 * exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x154 = 0.0037973799836799999 * exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x155 = exp(-23.156677820503301);
        const double var_x156 = 8513540195.0827656 * var_x155;
        const double var_x157 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x158 = 34054160780.331062 * var_x157;
        const double var_x159 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x160 = 8513540195.0827656 * var_x159;
        const double var_x161 = exp(-24.35183300086069);
        const double var_x162 = 8513540195.0827656 * var_x161;
        const double var_x163 = 4340999166.2352047 * var_x161;
        const double var_x164 = 23845170420.535503 * var_x157;
        const double var_x165 = 12158498408.695736 * var_x159;
        const double var_x166 = 18237747613.043602 * var_x159;
        const double var_x167 = 16696701353.239271 * var_x155;
        const double var_x168 = 35767755630.803253 * var_x157;
        const double var_x169 = 11922585210.267752 * var_x157;
        const double var_x170 = 3099769910.3661275 * var_x161;
        const double var_x171 = 24316996817.391472 * var_x159;
        const double var_x172 = 23382498943.197018 * var_x155;
        const double var_x173 = 2213447441.3051791 * var_x161;
        const double var_x174 = 8513540195.0827656 * exp(-21.949261959797553 + 0.030147161449011892 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x175 = 8513540195.0827656 * exp(-38.483942906307405 - 0.14399668707161886 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x176 = 32745465422.278648 * var_x155;
        const double var_x177 = 8513540195.0827656 * exp(-39.744904705650839 + 0.0027019947965296331 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x178 = 8513540195.0827656 * exp(-20.6726464954126 + 0.011394696340402199 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x179 = 11922585210.267752 * var_x155;
        const double var_x180 = 25540620585.248295 * var_x157;
        const double var_x181 = 17027080390.165531 * var_x159;
        const double var_x182 = 6079249204.347868 * var_x161;
        const double var_x183 = 17027080390.165531 * var_x157;
        const double var_x184 = 25540620585.248295 * var_x159;
        const double var_x185 = 8513540195.0827656 * var_x157;
        const double var_x186 = 34054160780.331062 * var_x159;
        const double var_x187 = 8513540195.0827656 * exp(-16.535928437145476 + 0.1097131992444229 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x188 = 8513540195.0827656 * exp(-19.672905196314268 + 0.084272054104636354 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x189 = 8513540195.0827656 * exp(-27.092641999412571 - 0.061469636400174388 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x190 = 8513540195.0827656 * exp(-26.358496255772213 - 0.068762962366201316 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
        const double var_x191 = 8513540195.0827656 * exp(-26.650781465416159);
        const double var_x192 = 8513540195.0827656 * exp(-22.779658962607588);
        const double var_x193 = 47690340841.071007 * var_x157;
        const double var_x194 = 6079249204.347868 * var_x159;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (var_x5 * (-1.7400382808421786 - var_x0 - var_x1) + 0.16666666666666666 * (1.7400382808421786 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR - 1.8 * var_x6 - 1.7400382808421786 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) / (pow(var_x2, 3) * pow((0.083333333333333329 + var_x3), 2))));
        rJacobian[0][1] = -(mDt * (1.7400382808421786 * var_x4));
        rJacobian[0][2] = -(mDt * (var_x5 * (var_x0 + var_x1)));
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = 0.0;
        rJacobian[0][15] = 0.0;
        rJacobian[0][16] = 0.0;
        rJacobian[0][17] = 0.0;
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = 0.0;
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = 0.0;
        rJacobian[0][24] = 0.0;
        rJacobian[0][25] = 0.0;
        rJacobian[0][26] = 0.0;
        rJacobian[0][27] = 0.0;
        rJacobian[0][28] = 0.0;
        rJacobian[0][29] = 0.0;
        rJacobian[0][30] = 0.0;
        rJacobian[0][31] = 0.0;
        rJacobian[0][32] = 0.0;
        rJacobian[0][33] = 0.0;
        rJacobian[0][34] = 0.0;
        rJacobian[0][35] = 0.0;
        rJacobian[0][36] = 0.0;
        rJacobian[0][37] = 0.0;
        rJacobian[0][38] = 0.0;
        rJacobian[0][39] = -(mDt * (var_x7));
        rJacobian[0][40] = -(mDt * (var_x7));
        rJacobian[0][41] = 0.0;
        rJacobian[0][42] = 0.0;
        rJacobian[0][43] = 0.0;
        rJacobian[0][44] = 0.0;
        rJacobian[0][45] = 0.0;
        rJacobian[0][46] = 0.0;
        rJacobian[0][47] = 0.0;
        rJacobian[0][48] = 0.0;
        rJacobian[0][49] = 0.0;
        rJacobian[0][50] = 0.0;
        rJacobian[0][51] = 0.0;
        rJacobian[0][52] = 0.0;
        rJacobian[0][53] = 0.0;
        rJacobian[0][54] = 0.0;
        rJacobian[0][55] = 0.0;
        rJacobian[0][56] = 0.0;
        rJacobian[0][57] = 0.0;
        rJacobian[0][58] = 0.0;
        rJacobian[0][59] = 0.0;
        rJacobian[0][60] = 0.0;
        rJacobian[0][61] = 0.0;
        rJacobian[0][62] = 0.0;
        rJacobian[0][63] = 0.0;
        rJacobian[0][64] = 0.0;
        rJacobian[1][0] = -(mDt * (0.13257434520702313));
        rJacobian[1][1] = 1.0 - (mDt * (-0.13257434520702313 - 3.9156227113154178e-9 * var_x12 - 0.001427202778983934 * var_x10));
        rJacobian[1][2] = 0.0;
        rJacobian[1][3] = -(mDt * (44.871043198095713 * var_x14 - 0.00052336761372600129 * var_x15));
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = 0.0;
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = 0.0;
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[1][25] = 0.0;
        rJacobian[1][26] = 0.0;
        rJacobian[1][27] = 0.0;
        rJacobian[1][28] = 0.0;
        rJacobian[1][29] = 0.0;
        rJacobian[1][30] = 0.0;
        rJacobian[1][31] = 0.0;
        rJacobian[1][32] = 0.0;
        rJacobian[1][33] = 0.0;
        rJacobian[1][34] = 0.0;
        rJacobian[1][35] = 0.0;
        rJacobian[1][36] = 0.0;
        rJacobian[1][37] = 0.0;
        rJacobian[1][38] = 0.0;
        rJacobian[1][39] = 0.0;
        rJacobian[1][40] = 0.0;
        rJacobian[1][41] = 0.0;
        rJacobian[1][42] = 0.0;
        rJacobian[1][43] = 0.0;
        rJacobian[1][44] = 0.0;
        rJacobian[1][45] = 0.0;
        rJacobian[1][46] = 0.0;
        rJacobian[1][47] = 0.0;
        rJacobian[1][48] = 0.0;
        rJacobian[1][49] = 0.0;
        rJacobian[1][50] = 0.0;
        rJacobian[1][51] = 0.0;
        rJacobian[1][52] = 0.0;
        rJacobian[1][53] = 0.0;
        rJacobian[1][54] = 0.0;
        rJacobian[1][55] = 0.0;
        rJacobian[1][56] = 0.0;
        rJacobian[1][57] = 0.0;
        rJacobian[1][58] = 0.0;
        rJacobian[1][59] = 0.0;
        rJacobian[1][60] = 0.0;
        rJacobian[1][61] = 0.0;
        rJacobian[1][62] = 0.0;
        rJacobian[1][63] = 0.0;
        rJacobian[1][64] = 0.0;
        rJacobian[2][0] = -(mDt * (var_x21 * (var_x16 + var_x17)));
        rJacobian[2][1] = 0.0;
        rJacobian[2][2] = 1.0 - (mDt * (var_x21 * (-806.49188514357058 - var_x16 - var_x17) + 0.00023800000000000004 * (806.49188514357058 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + 240.0 * var_x6 - 806.49188514357058 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS - var_x22 * var_x25) / (pow(var_x18, 3) * pow(var_x19, 2))));
        rJacobian[2][3] = -(mDt * (806.49188514357058 * var_x20));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = 0.0;
        rJacobian[2][15] = 0.0;
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = 0.0;
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[2][25] = 0.0;
        rJacobian[2][26] = 0.0;
        rJacobian[2][27] = 0.0;
        rJacobian[2][28] = 0.0;
        rJacobian[2][29] = 0.0;
        rJacobian[2][30] = 0.0;
        rJacobian[2][31] = 0.0;
        rJacobian[2][32] = 0.0;
        rJacobian[2][33] = 0.0;
        rJacobian[2][34] = 0.0;
        rJacobian[2][35] = 0.0;
        rJacobian[2][36] = -(mDt * (-var_x20 * var_x25 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa));
        rJacobian[2][37] = 0.0;
        rJacobian[2][38] = 0.0;
        rJacobian[2][39] = -(mDt * (var_x26));
        rJacobian[2][40] = -(mDt * (var_x26));
        rJacobian[2][41] = 0.0;
        rJacobian[2][42] = 0.0;
        rJacobian[2][43] = 0.0;
        rJacobian[2][44] = 0.0;
        rJacobian[2][45] = 0.0;
        rJacobian[2][46] = 0.0;
        rJacobian[2][47] = 0.0;
        rJacobian[2][48] = 0.0;
        rJacobian[2][49] = 0.0;
        rJacobian[2][50] = 0.0;
        rJacobian[2][51] = 0.0;
        rJacobian[2][52] = 0.0;
        rJacobian[2][53] = 0.0;
        rJacobian[2][54] = 0.0;
        rJacobian[2][55] = 0.0;
        rJacobian[2][56] = 0.0;
        rJacobian[2][57] = 0.0;
        rJacobian[2][58] = 0.0;
        rJacobian[2][59] = 0.0;
        rJacobian[2][60] = 0.0;
        rJacobian[2][61] = 0.0;
        rJacobian[2][62] = 0.0;
        rJacobian[2][63] = 0.0;
        rJacobian[2][64] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = -(mDt * (var_x30 * (3.1822011198770807e-10 * var_x12 + 0.00011598784194528874 * var_x10)));
        rJacobian[3][2] = -(mDt * (0.037453183520599252 * var_x29));
        rJacobian[3][3] = 1.0 - (mDt * (var_x30 * (-5.6374531835205994 - var_x32 + 2.8000000000000003 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa + 2.8000000000000003 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa + 4.2533745697546539e-5 * var_x15 - 0.03190795213912849 * var_x36 - 3.1566725655651652e-8 * var_x33 - 3.6466405075851775 * var_x14 + 1.5379617895699322e-6 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / pow(var_x31, 2)) + 0.00023800000000000004 * (0.0028000000000000004 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa + 9.2400000000000013e-6 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa + 3.1566725655651652e-8 * log(2.0 * var_x33) + 0.037453183520599252 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS - 0.037453183520599252 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai - 2.3635396782110715e-9 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V - var_x32 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai - var_x38 * (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) - var_x38 * (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) + 1.2141201663854144e-8 * var_x35 * (2.0 * var_x37 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) - 2628072.0 * var_x34 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai) - 1.2 * var_x10 * var_x11) / (pow(var_x27, 3) * pow(var_x28, 2))));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (7.2847209983124865e-8 * var_x29 * var_x39));
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = 0.0;
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = 0.0;
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[3][25] = 0.0;
        rJacobian[3][26] = 0.0;
        rJacobian[3][27] = 0.0;
        rJacobian[3][28] = 0.0;
        rJacobian[3][29] = 0.0;
        rJacobian[3][30] = 0.0;
        rJacobian[3][31] = 0.0;
        rJacobian[3][32] = 0.0;
        rJacobian[3][33] = 0.0;
        rJacobian[3][34] = 0.0;
        rJacobian[3][35] = 0.0;
        rJacobian[3][36] = 0.0;
        rJacobian[3][37] = 0.0;
        rJacobian[3][38] = 0.0;
        rJacobian[3][39] = 0.0;
        rJacobian[3][40] = 0.0;
        rJacobian[3][41] = -(mDt * (var_x30 * (9.2400000000000013e-6 + var_x38)));
        rJacobian[3][42] = -(mDt * (var_x30 * (0.0028000000000000004 + var_x38)));
        rJacobian[3][43] = 0.0;
        rJacobian[3][44] = 0.0;
        rJacobian[3][45] = 0.0;
        rJacobian[3][46] = 0.0;
        rJacobian[3][47] = 0.0;
        rJacobian[3][48] = 0.0;
        rJacobian[3][49] = 0.0;
        rJacobian[3][50] = 0.0;
        rJacobian[3][51] = 0.0;
        rJacobian[3][52] = 0.0;
        rJacobian[3][53] = 0.0;
        rJacobian[3][54] = 0.0;
        rJacobian[3][55] = 0.0;
        rJacobian[3][56] = 0.0;
        rJacobian[3][57] = 0.0;
        rJacobian[3][58] = 0.0;
        rJacobian[3][59] = 0.0;
        rJacobian[3][60] = 0.0;
        rJacobian[3][61] = 0.0;
        rJacobian[3][62] = 0.0;
        rJacobian[3][63] = 0.0;
        rJacobian[3][64] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (-var_x46 * var_x47 - 0.00012738562343605624 * var_x40 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 - 3.0564346548418563e-5 * var_x40 * var_chaste_interface__IKr__OHerg - 5.7513555333045694e-6 * var_x40 * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) - 0.00041181390311704753 * var_x40 / var_x43 - var_x22 * var_x44 * var_x49 + 1.9425621197603171e-5 * var_x40 * var_x42 * (-26.71139896373057 * var_x41 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / pow(var_x43, 2)));
        rJacobian[4][5] = -(mDt * (3.58204897197986e-6 * var_x52));
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = 0.0;
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = -(mDt * (-var_x46 * var_x53));
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = 0.0;
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[4][25] = -(mDt * (0.00012738562343605624 * var_x41 - 4.7689611318757119e-6 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V));
        rJacobian[4][26] = 0.0;
        rJacobian[4][27] = 0.0;
        rJacobian[4][28] = 0.0;
        rJacobian[4][29] = 0.0;
        rJacobian[4][30] = 0.0;
        rJacobian[4][31] = 0.0;
        rJacobian[4][32] = 0.0;
        rJacobian[4][33] = 0.0;
        rJacobian[4][34] = 0.0;
        rJacobian[4][35] = 0.0;
        rJacobian[4][36] = -(mDt * (-var_x49 * var_x53 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa));
        rJacobian[4][37] = 0.0;
        rJacobian[4][38] = 0.0;
        rJacobian[4][39] = 0.0;
        rJacobian[4][40] = 0.0;
        rJacobian[4][41] = 0.0;
        rJacobian[4][42] = 0.0;
        rJacobian[4][43] = 0.0;
        rJacobian[4][44] = 0.0;
        rJacobian[4][45] = 0.0;
        rJacobian[4][46] = 0.0;
        rJacobian[4][47] = -(mDt * (3.0564346548418563e-5 * var_x41 - 1.1442435714400293e-6 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V));
        rJacobian[4][48] = 0.0;
        rJacobian[4][49] = 0.0;
        rJacobian[4][50] = -(mDt * (var_x54));
        rJacobian[4][51] = -(mDt * (var_x54));
        rJacobian[4][52] = 0.0;
        rJacobian[4][53] = 0.0;
        rJacobian[4][54] = 0.0;
        rJacobian[4][55] = 0.0;
        rJacobian[4][56] = 0.0;
        rJacobian[4][57] = 0.0;
        rJacobian[4][58] = 0.0;
        rJacobian[4][59] = 0.0;
        rJacobian[4][60] = 0.0;
        rJacobian[4][61] = 0.0;
        rJacobian[4][62] = 0.0;
        rJacobian[4][63] = 0.0;
        rJacobian[4][64] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (0.095723856417385469 * var_x36));
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-5.3730734579697901e-6 * var_x52 - 1.6432444380870198e-6 * var_x50 - 2.1854162994937459e-7 * var_x39 - var_x47 * var_x55 - 0.092547526753060952 * var_x50 * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7)));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = -(mDt * (-var_x55 * (-138.0 + var_x44 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai)));
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = 0.0;
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[5][25] = 0.0;
        rJacobian[5][26] = 0.0;
        rJacobian[5][27] = 0.0;
        rJacobian[5][28] = 0.0;
        rJacobian[5][29] = 0.0;
        rJacobian[5][30] = 0.0;
        rJacobian[5][31] = 0.0;
        rJacobian[5][32] = 0.0;
        rJacobian[5][33] = 0.0;
        rJacobian[5][34] = 0.0;
        rJacobian[5][35] = 0.0;
        rJacobian[5][36] = 0.0;
        rJacobian[5][37] = 0.0;
        rJacobian[5][38] = 0.0;
        rJacobian[5][39] = 0.0;
        rJacobian[5][40] = 0.0;
        rJacobian[5][41] = 0.0;
        rJacobian[5][42] = 0.0;
        rJacobian[5][43] = 0.0;
        rJacobian[5][44] = 0.0;
        rJacobian[5][45] = 0.0;
        rJacobian[5][46] = 0.0;
        rJacobian[5][47] = 0.0;
        rJacobian[5][48] = 0.0;
        rJacobian[5][49] = 0.0;
        rJacobian[5][50] = 0.0;
        rJacobian[5][51] = 0.0;
        rJacobian[5][52] = 0.0;
        rJacobian[5][53] = 0.0;
        rJacobian[5][54] = 0.0;
        rJacobian[5][55] = 0.0;
        rJacobian[5][56] = 0.0;
        rJacobian[5][57] = 0.0;
        rJacobian[5][58] = 0.0;
        rJacobian[5][59] = 0.0;
        rJacobian[5][60] = 0.0;
        rJacobian[5][61] = -(mDt * (var_x56));
        rJacobian[5][62] = -(mDt * (var_x56));
        rJacobian[5][63] = 0.0;
        rJacobian[5][64] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-2.44936e-6 - var_x58));
        rJacobian[6][7] = -(mDt * (var_x60));
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = -(mDt * (0.00305767916));
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = 0.0;
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[6][25] = 0.0;
        rJacobian[6][26] = 0.0;
        rJacobian[6][27] = 0.0;
        rJacobian[6][28] = 0.0;
        rJacobian[6][29] = 0.0;
        rJacobian[6][30] = 0.0;
        rJacobian[6][31] = 0.0;
        rJacobian[6][32] = 0.0;
        rJacobian[6][33] = 0.0;
        rJacobian[6][34] = 0.0;
        rJacobian[6][35] = 0.0;
        rJacobian[6][36] = 0.0;
        rJacobian[6][37] = 0.0;
        rJacobian[6][38] = 0.0;
        rJacobian[6][39] = 0.0;
        rJacobian[6][40] = 0.0;
        rJacobian[6][41] = 0.0;
        rJacobian[6][42] = 0.0;
        rJacobian[6][43] = 0.0;
        rJacobian[6][44] = 0.0;
        rJacobian[6][45] = 0.0;
        rJacobian[6][46] = 0.0;
        rJacobian[6][47] = 0.0;
        rJacobian[6][48] = 0.0;
        rJacobian[6][49] = 0.0;
        rJacobian[6][50] = 0.0;
        rJacobian[6][51] = 0.0;
        rJacobian[6][52] = 0.0;
        rJacobian[6][53] = 0.0;
        rJacobian[6][54] = 0.0;
        rJacobian[6][55] = 0.0;
        rJacobian[6][56] = 0.0;
        rJacobian[6][57] = 0.0;
        rJacobian[6][58] = 0.0;
        rJacobian[6][59] = 0.0;
        rJacobian[6][60] = 0.0;
        rJacobian[6][61] = 0.0;
        rJacobian[6][62] = 0.0;
        rJacobian[6][63] = 0.0;
        rJacobian[6][64] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = -(mDt * (var_x58));
        rJacobian[7][7] = 1.0 - (mDt * (-1.2850585364284256e-6 - var_x60 - var_x61));
        rJacobian[7][8] = -(mDt * (var_x62));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = -(mDt * (0.0030289691634726814));
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = 0.0;
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[7][25] = 0.0;
        rJacobian[7][26] = 0.0;
        rJacobian[7][27] = 0.0;
        rJacobian[7][28] = 0.0;
        rJacobian[7][29] = 0.0;
        rJacobian[7][30] = 0.0;
        rJacobian[7][31] = 0.0;
        rJacobian[7][32] = 0.0;
        rJacobian[7][33] = 0.0;
        rJacobian[7][34] = 0.0;
        rJacobian[7][35] = 0.0;
        rJacobian[7][36] = 0.0;
        rJacobian[7][37] = 0.0;
        rJacobian[7][38] = 0.0;
        rJacobian[7][39] = 0.0;
        rJacobian[7][40] = 0.0;
        rJacobian[7][41] = 0.0;
        rJacobian[7][42] = 0.0;
        rJacobian[7][43] = 0.0;
        rJacobian[7][44] = 0.0;
        rJacobian[7][45] = 0.0;
        rJacobian[7][46] = 0.0;
        rJacobian[7][47] = 0.0;
        rJacobian[7][48] = 0.0;
        rJacobian[7][49] = 0.0;
        rJacobian[7][50] = 0.0;
        rJacobian[7][51] = 0.0;
        rJacobian[7][52] = 0.0;
        rJacobian[7][53] = 0.0;
        rJacobian[7][54] = 0.0;
        rJacobian[7][55] = 0.0;
        rJacobian[7][56] = 0.0;
        rJacobian[7][57] = 0.0;
        rJacobian[7][58] = 0.0;
        rJacobian[7][59] = 0.0;
        rJacobian[7][60] = 0.0;
        rJacobian[7][61] = 0.0;
        rJacobian[7][62] = 0.0;
        rJacobian[7][63] = 0.0;
        rJacobian[7][64] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = -(mDt * (var_x61));
        rJacobian[8][8] = 1.0 - (mDt * (-4.290998044504021e-5 - var_x62 - var_x63));
        rJacobian[8][9] = -(mDt * (var_x64));
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = -(mDt * (0.0026111571690401588));
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = 0.0;
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[8][25] = 0.0;
        rJacobian[8][26] = 0.0;
        rJacobian[8][27] = 0.0;
        rJacobian[8][28] = 0.0;
        rJacobian[8][29] = 0.0;
        rJacobian[8][30] = 0.0;
        rJacobian[8][31] = 0.0;
        rJacobian[8][32] = 0.0;
        rJacobian[8][33] = 0.0;
        rJacobian[8][34] = 0.0;
        rJacobian[8][35] = 0.0;
        rJacobian[8][36] = 0.0;
        rJacobian[8][37] = 0.0;
        rJacobian[8][38] = 0.0;
        rJacobian[8][39] = 0.0;
        rJacobian[8][40] = 0.0;
        rJacobian[8][41] = 0.0;
        rJacobian[8][42] = 0.0;
        rJacobian[8][43] = 0.0;
        rJacobian[8][44] = 0.0;
        rJacobian[8][45] = 0.0;
        rJacobian[8][46] = 0.0;
        rJacobian[8][47] = 0.0;
        rJacobian[8][48] = 0.0;
        rJacobian[8][49] = 0.0;
        rJacobian[8][50] = 0.0;
        rJacobian[8][51] = 0.0;
        rJacobian[8][52] = 0.0;
        rJacobian[8][53] = 0.0;
        rJacobian[8][54] = 0.0;
        rJacobian[8][55] = 0.0;
        rJacobian[8][56] = 0.0;
        rJacobian[8][57] = 0.0;
        rJacobian[8][58] = 0.0;
        rJacobian[8][59] = 0.0;
        rJacobian[8][60] = 0.0;
        rJacobian[8][61] = 0.0;
        rJacobian[8][62] = 0.0;
        rJacobian[8][63] = 0.0;
        rJacobian[8][64] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = -(mDt * (var_x63));
        rJacobian[9][9] = 1.0 - (mDt * (-0.0022989390350036006 - var_x64 - var_x65));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = 0.0;
        rJacobian[9][13] = -(mDt * (0.0047848930796401661));
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = -(mDt * (var_x66));
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = 0.0;
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[9][25] = 0.0;
        rJacobian[9][26] = 0.0;
        rJacobian[9][27] = 0.0;
        rJacobian[9][28] = 0.0;
        rJacobian[9][29] = 0.0;
        rJacobian[9][30] = 0.0;
        rJacobian[9][31] = 0.0;
        rJacobian[9][32] = 0.0;
        rJacobian[9][33] = 0.0;
        rJacobian[9][34] = 0.0;
        rJacobian[9][35] = 0.0;
        rJacobian[9][36] = 0.0;
        rJacobian[9][37] = 0.0;
        rJacobian[9][38] = 0.0;
        rJacobian[9][39] = 0.0;
        rJacobian[9][40] = 0.0;
        rJacobian[9][41] = 0.0;
        rJacobian[9][42] = 0.0;
        rJacobian[9][43] = 0.0;
        rJacobian[9][44] = 0.0;
        rJacobian[9][45] = 0.0;
        rJacobian[9][46] = 0.0;
        rJacobian[9][47] = 0.0;
        rJacobian[9][48] = 0.0;
        rJacobian[9][49] = 0.0;
        rJacobian[9][50] = 0.0;
        rJacobian[9][51] = 0.0;
        rJacobian[9][52] = 0.0;
        rJacobian[9][53] = 0.0;
        rJacobian[9][54] = 0.0;
        rJacobian[9][55] = 0.0;
        rJacobian[9][56] = 0.0;
        rJacobian[9][57] = 0.0;
        rJacobian[9][58] = 0.0;
        rJacobian[9][59] = 0.0;
        rJacobian[9][60] = 0.0;
        rJacobian[9][61] = 0.0;
        rJacobian[9][62] = 0.0;
        rJacobian[9][63] = 0.0;
        rJacobian[9][64] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = -(mDt * (2.44936e-6));
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (-0.00305767916 - var_x67));
        rJacobian[10][11] = -(mDt * (var_x68));
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = 0.0;
        rJacobian[10][15] = 0.0;
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[10][25] = 0.0;
        rJacobian[10][26] = 0.0;
        rJacobian[10][27] = 0.0;
        rJacobian[10][28] = 0.0;
        rJacobian[10][29] = 0.0;
        rJacobian[10][30] = 0.0;
        rJacobian[10][31] = 0.0;
        rJacobian[10][32] = 0.0;
        rJacobian[10][33] = 0.0;
        rJacobian[10][34] = 0.0;
        rJacobian[10][35] = 0.0;
        rJacobian[10][36] = 0.0;
        rJacobian[10][37] = 0.0;
        rJacobian[10][38] = 0.0;
        rJacobian[10][39] = 0.0;
        rJacobian[10][40] = 0.0;
        rJacobian[10][41] = 0.0;
        rJacobian[10][42] = 0.0;
        rJacobian[10][43] = 0.0;
        rJacobian[10][44] = 0.0;
        rJacobian[10][45] = 0.0;
        rJacobian[10][46] = 0.0;
        rJacobian[10][47] = 0.0;
        rJacobian[10][48] = 0.0;
        rJacobian[10][49] = 0.0;
        rJacobian[10][50] = 0.0;
        rJacobian[10][51] = 0.0;
        rJacobian[10][52] = 0.0;
        rJacobian[10][53] = 0.0;
        rJacobian[10][54] = 0.0;
        rJacobian[10][55] = 0.0;
        rJacobian[10][56] = 0.0;
        rJacobian[10][57] = 0.0;
        rJacobian[10][58] = 0.0;
        rJacobian[10][59] = 0.0;
        rJacobian[10][60] = 0.0;
        rJacobian[10][61] = 0.0;
        rJacobian[10][62] = 0.0;
        rJacobian[10][63] = 0.0;
        rJacobian[10][64] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = -(mDt * (1.2850585364284256e-6));
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = -(mDt * (var_x67));
        rJacobian[11][11] = 1.0 - (mDt * (-0.0030289691634726814 - var_x68 - var_x69));
        rJacobian[11][12] = -(mDt * (var_x70));
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = 0.0;
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[11][25] = 0.0;
        rJacobian[11][26] = 0.0;
        rJacobian[11][27] = 0.0;
        rJacobian[11][28] = 0.0;
        rJacobian[11][29] = 0.0;
        rJacobian[11][30] = 0.0;
        rJacobian[11][31] = 0.0;
        rJacobian[11][32] = 0.0;
        rJacobian[11][33] = 0.0;
        rJacobian[11][34] = 0.0;
        rJacobian[11][35] = 0.0;
        rJacobian[11][36] = 0.0;
        rJacobian[11][37] = 0.0;
        rJacobian[11][38] = 0.0;
        rJacobian[11][39] = 0.0;
        rJacobian[11][40] = 0.0;
        rJacobian[11][41] = 0.0;
        rJacobian[11][42] = 0.0;
        rJacobian[11][43] = 0.0;
        rJacobian[11][44] = 0.0;
        rJacobian[11][45] = 0.0;
        rJacobian[11][46] = 0.0;
        rJacobian[11][47] = 0.0;
        rJacobian[11][48] = 0.0;
        rJacobian[11][49] = 0.0;
        rJacobian[11][50] = 0.0;
        rJacobian[11][51] = 0.0;
        rJacobian[11][52] = 0.0;
        rJacobian[11][53] = 0.0;
        rJacobian[11][54] = 0.0;
        rJacobian[11][55] = 0.0;
        rJacobian[11][56] = 0.0;
        rJacobian[11][57] = 0.0;
        rJacobian[11][58] = 0.0;
        rJacobian[11][59] = 0.0;
        rJacobian[11][60] = 0.0;
        rJacobian[11][61] = 0.0;
        rJacobian[11][62] = 0.0;
        rJacobian[11][63] = 0.0;
        rJacobian[11][64] = 0.0;
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = 0.0;
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = -(mDt * (4.290998044504021e-5));
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = -(mDt * (var_x69));
        rJacobian[12][12] = 1.0 - (mDt * (-0.0026111571690401588 - var_x70 - var_x71));
        rJacobian[12][13] = -(mDt * (var_x72));
        rJacobian[12][14] = 0.0;
        rJacobian[12][15] = 0.0;
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = 0.0;
        rJacobian[12][21] = 0.0;
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[12][25] = 0.0;
        rJacobian[12][26] = 0.0;
        rJacobian[12][27] = 0.0;
        rJacobian[12][28] = 0.0;
        rJacobian[12][29] = 0.0;
        rJacobian[12][30] = 0.0;
        rJacobian[12][31] = 0.0;
        rJacobian[12][32] = 0.0;
        rJacobian[12][33] = 0.0;
        rJacobian[12][34] = 0.0;
        rJacobian[12][35] = 0.0;
        rJacobian[12][36] = 0.0;
        rJacobian[12][37] = 0.0;
        rJacobian[12][38] = 0.0;
        rJacobian[12][39] = 0.0;
        rJacobian[12][40] = 0.0;
        rJacobian[12][41] = 0.0;
        rJacobian[12][42] = 0.0;
        rJacobian[12][43] = 0.0;
        rJacobian[12][44] = 0.0;
        rJacobian[12][45] = 0.0;
        rJacobian[12][46] = 0.0;
        rJacobian[12][47] = 0.0;
        rJacobian[12][48] = 0.0;
        rJacobian[12][49] = 0.0;
        rJacobian[12][50] = 0.0;
        rJacobian[12][51] = 0.0;
        rJacobian[12][52] = 0.0;
        rJacobian[12][53] = 0.0;
        rJacobian[12][54] = 0.0;
        rJacobian[12][55] = 0.0;
        rJacobian[12][56] = 0.0;
        rJacobian[12][57] = 0.0;
        rJacobian[12][58] = 0.0;
        rJacobian[12][59] = 0.0;
        rJacobian[12][60] = 0.0;
        rJacobian[12][61] = 0.0;
        rJacobian[12][62] = 0.0;
        rJacobian[12][63] = 0.0;
        rJacobian[12][64] = 0.0;
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = 0.0;
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = 0.0;
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = -(mDt * (0.0022989390350036006));
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = -(mDt * (var_x71));
        rJacobian[13][13] = 1.0 - (mDt * (-0.0047848930796401661 - var_x72 - var_x73));
        rJacobian[13][14] = -(mDt * (var_x74));
        rJacobian[13][15] = 0.0;
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[13][25] = 0.0;
        rJacobian[13][26] = 0.0;
        rJacobian[13][27] = 0.0;
        rJacobian[13][28] = 0.0;
        rJacobian[13][29] = 0.0;
        rJacobian[13][30] = 0.0;
        rJacobian[13][31] = 0.0;
        rJacobian[13][32] = 0.0;
        rJacobian[13][33] = 0.0;
        rJacobian[13][34] = 0.0;
        rJacobian[13][35] = 0.0;
        rJacobian[13][36] = 0.0;
        rJacobian[13][37] = 0.0;
        rJacobian[13][38] = 0.0;
        rJacobian[13][39] = 0.0;
        rJacobian[13][40] = 0.0;
        rJacobian[13][41] = 0.0;
        rJacobian[13][42] = 0.0;
        rJacobian[13][43] = 0.0;
        rJacobian[13][44] = 0.0;
        rJacobian[13][45] = 0.0;
        rJacobian[13][46] = 0.0;
        rJacobian[13][47] = 0.0;
        rJacobian[13][48] = 0.0;
        rJacobian[13][49] = 0.0;
        rJacobian[13][50] = 0.0;
        rJacobian[13][51] = 0.0;
        rJacobian[13][52] = 0.0;
        rJacobian[13][53] = 0.0;
        rJacobian[13][54] = 0.0;
        rJacobian[13][55] = 0.0;
        rJacobian[13][56] = 0.0;
        rJacobian[13][57] = 0.0;
        rJacobian[13][58] = 0.0;
        rJacobian[13][59] = 0.0;
        rJacobian[13][60] = 0.0;
        rJacobian[13][61] = 0.0;
        rJacobian[13][62] = 0.0;
        rJacobian[13][63] = 0.0;
        rJacobian[13][64] = 0.0;
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = 0.0;
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = 0.0;
        rJacobian[14][13] = -(mDt * (var_x73));
        rJacobian[14][14] = 1.0 - (mDt * (-0.0014420608358145942 - var_x74));
        rJacobian[14][15] = -(mDt * (0.1341004876120194));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = 0.0;
        rJacobian[14][21] = 0.0;
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[14][25] = 0.0;
        rJacobian[14][26] = 0.0;
        rJacobian[14][27] = 0.0;
        rJacobian[14][28] = 0.0;
        rJacobian[14][29] = 0.0;
        rJacobian[14][30] = 0.0;
        rJacobian[14][31] = 0.0;
        rJacobian[14][32] = 0.0;
        rJacobian[14][33] = 0.0;
        rJacobian[14][34] = 0.0;
        rJacobian[14][35] = 0.0;
        rJacobian[14][36] = 0.0;
        rJacobian[14][37] = 0.0;
        rJacobian[14][38] = 0.0;
        rJacobian[14][39] = 0.0;
        rJacobian[14][40] = 0.0;
        rJacobian[14][41] = 0.0;
        rJacobian[14][42] = 0.0;
        rJacobian[14][43] = 0.0;
        rJacobian[14][44] = 0.0;
        rJacobian[14][45] = 0.0;
        rJacobian[14][46] = 0.0;
        rJacobian[14][47] = 0.0;
        rJacobian[14][48] = 0.0;
        rJacobian[14][49] = 0.0;
        rJacobian[14][50] = 0.0;
        rJacobian[14][51] = 0.0;
        rJacobian[14][52] = 0.0;
        rJacobian[14][53] = 0.0;
        rJacobian[14][54] = 0.0;
        rJacobian[14][55] = 0.0;
        rJacobian[14][56] = 0.0;
        rJacobian[14][57] = 0.0;
        rJacobian[14][58] = 0.0;
        rJacobian[14][59] = 0.0;
        rJacobian[14][60] = 0.0;
        rJacobian[14][61] = 0.0;
        rJacobian[14][62] = 0.0;
        rJacobian[14][63] = 0.0;
        rJacobian[14][64] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = 0.0;
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = 0.0;
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = -(mDt * (var_x65));
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = 0.0;
        rJacobian[15][12] = 0.0;
        rJacobian[15][13] = 0.0;
        rJacobian[15][14] = -(mDt * (0.0014420608358145942));
        rJacobian[15][15] = 1.0 - (mDt * (-0.1341004876120194 - var_x66));
        rJacobian[15][16] = 0.0;
        rJacobian[15][17] = 0.0;
        rJacobian[15][18] = 0.0;
        rJacobian[15][19] = 0.0;
        rJacobian[15][20] = 0.0;
        rJacobian[15][21] = 0.0;
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = 0.0;
        rJacobian[15][25] = 0.0;
        rJacobian[15][26] = 0.0;
        rJacobian[15][27] = 0.0;
        rJacobian[15][28] = 0.0;
        rJacobian[15][29] = 0.0;
        rJacobian[15][30] = 0.0;
        rJacobian[15][31] = 0.0;
        rJacobian[15][32] = 0.0;
        rJacobian[15][33] = 0.0;
        rJacobian[15][34] = 0.0;
        rJacobian[15][35] = 0.0;
        rJacobian[15][36] = 0.0;
        rJacobian[15][37] = 0.0;
        rJacobian[15][38] = 0.0;
        rJacobian[15][39] = 0.0;
        rJacobian[15][40] = 0.0;
        rJacobian[15][41] = 0.0;
        rJacobian[15][42] = 0.0;
        rJacobian[15][43] = 0.0;
        rJacobian[15][44] = 0.0;
        rJacobian[15][45] = 0.0;
        rJacobian[15][46] = 0.0;
        rJacobian[15][47] = 0.0;
        rJacobian[15][48] = 0.0;
        rJacobian[15][49] = 0.0;
        rJacobian[15][50] = 0.0;
        rJacobian[15][51] = 0.0;
        rJacobian[15][52] = 0.0;
        rJacobian[15][53] = 0.0;
        rJacobian[15][54] = 0.0;
        rJacobian[15][55] = 0.0;
        rJacobian[15][56] = 0.0;
        rJacobian[15][57] = 0.0;
        rJacobian[15][58] = 0.0;
        rJacobian[15][59] = 0.0;
        rJacobian[15][60] = 0.0;
        rJacobian[15][61] = 0.0;
        rJacobian[15][62] = 0.0;
        rJacobian[15][63] = 0.0;
        rJacobian[15][64] = 0.0;
        rJacobian[16][0] = 0.0;
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = 0.0;
        rJacobian[16][5] = 0.0;
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = 0.0;
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = 0.0;
        rJacobian[16][16] = 1.0 - (mDt * (-var_x76 - var_x78));
        rJacobian[16][17] = -(mDt * (var_x80));
        rJacobian[16][18] = 0.0;
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = -(mDt * (var_x82));
        rJacobian[16][21] = 0.0;
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = 0.0;
        rJacobian[16][24] = 0.0;
        rJacobian[16][25] = 0.0;
        rJacobian[16][26] = 0.0;
        rJacobian[16][27] = 0.0;
        rJacobian[16][28] = 0.0;
        rJacobian[16][29] = 0.0;
        rJacobian[16][30] = 0.0;
        rJacobian[16][31] = 0.0;
        rJacobian[16][32] = 0.0;
        rJacobian[16][33] = 0.0;
        rJacobian[16][34] = 0.0;
        rJacobian[16][35] = 0.0;
        rJacobian[16][36] = 0.0;
        rJacobian[16][37] = 0.0;
        rJacobian[16][38] = 0.0;
        rJacobian[16][39] = 0.0;
        rJacobian[16][40] = 0.0;
        rJacobian[16][41] = 0.0;
        rJacobian[16][42] = 0.0;
        rJacobian[16][43] = 0.0;
        rJacobian[16][44] = 0.0;
        rJacobian[16][45] = 0.0;
        rJacobian[16][46] = 0.0;
        rJacobian[16][47] = 0.0;
        rJacobian[16][48] = 0.0;
        rJacobian[16][49] = 0.0;
        rJacobian[16][50] = 0.0;
        rJacobian[16][51] = 0.0;
        rJacobian[16][52] = 0.0;
        rJacobian[16][53] = 0.0;
        rJacobian[16][54] = 0.0;
        rJacobian[16][55] = 0.0;
        rJacobian[16][56] = 0.0;
        rJacobian[16][57] = 0.0;
        rJacobian[16][58] = 0.0;
        rJacobian[16][59] = 0.0;
        rJacobian[16][60] = 0.0;
        rJacobian[16][61] = 0.0;
        rJacobian[16][62] = 0.0;
        rJacobian[16][63] = 0.0;
        rJacobian[16][64] = 0.0;
        rJacobian[17][0] = 0.0;
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = 0.0;
        rJacobian[17][5] = 0.0;
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = 0.0;
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = 0.0;
        rJacobian[17][16] = -(mDt * (var_x76));
        rJacobian[17][17] = 1.0 - (mDt * (-var_x80 - var_x83 - var_x84));
        rJacobian[17][18] = -(mDt * (var_x85));
        rJacobian[17][19] = 0.0;
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = -(mDt * (var_x86));
        rJacobian[17][22] = 0.0;
        rJacobian[17][23] = 0.0;
        rJacobian[17][24] = 0.0;
        rJacobian[17][25] = 0.0;
        rJacobian[17][26] = 0.0;
        rJacobian[17][27] = 0.0;
        rJacobian[17][28] = 0.0;
        rJacobian[17][29] = 0.0;
        rJacobian[17][30] = 0.0;
        rJacobian[17][31] = 0.0;
        rJacobian[17][32] = 0.0;
        rJacobian[17][33] = 0.0;
        rJacobian[17][34] = 0.0;
        rJacobian[17][35] = 0.0;
        rJacobian[17][36] = 0.0;
        rJacobian[17][37] = 0.0;
        rJacobian[17][38] = 0.0;
        rJacobian[17][39] = 0.0;
        rJacobian[17][40] = 0.0;
        rJacobian[17][41] = 0.0;
        rJacobian[17][42] = 0.0;
        rJacobian[17][43] = 0.0;
        rJacobian[17][44] = 0.0;
        rJacobian[17][45] = 0.0;
        rJacobian[17][46] = 0.0;
        rJacobian[17][47] = 0.0;
        rJacobian[17][48] = 0.0;
        rJacobian[17][49] = 0.0;
        rJacobian[17][50] = 0.0;
        rJacobian[17][51] = 0.0;
        rJacobian[17][52] = 0.0;
        rJacobian[17][53] = 0.0;
        rJacobian[17][54] = 0.0;
        rJacobian[17][55] = 0.0;
        rJacobian[17][56] = 0.0;
        rJacobian[17][57] = 0.0;
        rJacobian[17][58] = 0.0;
        rJacobian[17][59] = 0.0;
        rJacobian[17][60] = 0.0;
        rJacobian[17][61] = 0.0;
        rJacobian[17][62] = 0.0;
        rJacobian[17][63] = 0.0;
        rJacobian[17][64] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = 0.0;
        rJacobian[18][15] = 0.0;
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = -(mDt * (var_x83));
        rJacobian[18][18] = 1.0 - (mDt * (-var_x85 - var_x87 - var_x88));
        rJacobian[18][19] = -(mDt * (var_x89));
        rJacobian[18][20] = 0.0;
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = -(mDt * (var_x90));
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[18][25] = 0.0;
        rJacobian[18][26] = 0.0;
        rJacobian[18][27] = 0.0;
        rJacobian[18][28] = 0.0;
        rJacobian[18][29] = 0.0;
        rJacobian[18][30] = 0.0;
        rJacobian[18][31] = 0.0;
        rJacobian[18][32] = 0.0;
        rJacobian[18][33] = 0.0;
        rJacobian[18][34] = 0.0;
        rJacobian[18][35] = 0.0;
        rJacobian[18][36] = 0.0;
        rJacobian[18][37] = 0.0;
        rJacobian[18][38] = 0.0;
        rJacobian[18][39] = 0.0;
        rJacobian[18][40] = 0.0;
        rJacobian[18][41] = 0.0;
        rJacobian[18][42] = 0.0;
        rJacobian[18][43] = 0.0;
        rJacobian[18][44] = 0.0;
        rJacobian[18][45] = 0.0;
        rJacobian[18][46] = 0.0;
        rJacobian[18][47] = 0.0;
        rJacobian[18][48] = 0.0;
        rJacobian[18][49] = 0.0;
        rJacobian[18][50] = 0.0;
        rJacobian[18][51] = 0.0;
        rJacobian[18][52] = 0.0;
        rJacobian[18][53] = 0.0;
        rJacobian[18][54] = 0.0;
        rJacobian[18][55] = 0.0;
        rJacobian[18][56] = 0.0;
        rJacobian[18][57] = 0.0;
        rJacobian[18][58] = 0.0;
        rJacobian[18][59] = 0.0;
        rJacobian[18][60] = 0.0;
        rJacobian[18][61] = 0.0;
        rJacobian[18][62] = 0.0;
        rJacobian[18][63] = 0.0;
        rJacobian[18][64] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = 0.0;
        rJacobian[19][15] = 0.0;
        rJacobian[19][16] = 0.0;
        rJacobian[19][17] = 0.0;
        rJacobian[19][18] = -(mDt * (var_x87));
        rJacobian[19][19] = 1.0 - (mDt * (-var_x89 - var_x91 - var_x92));
        rJacobian[19][20] = 0.0;
        rJacobian[19][21] = 0.0;
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = -(mDt * (var_x93));
        rJacobian[19][24] = 0.0;
        rJacobian[19][25] = -(mDt * (var_x94));
        rJacobian[19][26] = 0.0;
        rJacobian[19][27] = 0.0;
        rJacobian[19][28] = 0.0;
        rJacobian[19][29] = 0.0;
        rJacobian[19][30] = 0.0;
        rJacobian[19][31] = 0.0;
        rJacobian[19][32] = 0.0;
        rJacobian[19][33] = 0.0;
        rJacobian[19][34] = 0.0;
        rJacobian[19][35] = 0.0;
        rJacobian[19][36] = 0.0;
        rJacobian[19][37] = 0.0;
        rJacobian[19][38] = 0.0;
        rJacobian[19][39] = 0.0;
        rJacobian[19][40] = 0.0;
        rJacobian[19][41] = 0.0;
        rJacobian[19][42] = 0.0;
        rJacobian[19][43] = 0.0;
        rJacobian[19][44] = 0.0;
        rJacobian[19][45] = 0.0;
        rJacobian[19][46] = 0.0;
        rJacobian[19][47] = 0.0;
        rJacobian[19][48] = 0.0;
        rJacobian[19][49] = 0.0;
        rJacobian[19][50] = 0.0;
        rJacobian[19][51] = 0.0;
        rJacobian[19][52] = 0.0;
        rJacobian[19][53] = 0.0;
        rJacobian[19][54] = 0.0;
        rJacobian[19][55] = 0.0;
        rJacobian[19][56] = 0.0;
        rJacobian[19][57] = 0.0;
        rJacobian[19][58] = 0.0;
        rJacobian[19][59] = 0.0;
        rJacobian[19][60] = 0.0;
        rJacobian[19][61] = 0.0;
        rJacobian[19][62] = 0.0;
        rJacobian[19][63] = 0.0;
        rJacobian[19][64] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = 0.0;
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = -(mDt * (var_x78));
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = 0.0;
        rJacobian[20][19] = 0.0;
        rJacobian[20][20] = 1.0 - (mDt * (-var_x82 - var_x95));
        rJacobian[20][21] = -(mDt * (var_x96));
        rJacobian[20][22] = 0.0;
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[20][25] = 0.0;
        rJacobian[20][26] = 0.0;
        rJacobian[20][27] = 0.0;
        rJacobian[20][28] = 0.0;
        rJacobian[20][29] = 0.0;
        rJacobian[20][30] = 0.0;
        rJacobian[20][31] = 0.0;
        rJacobian[20][32] = 0.0;
        rJacobian[20][33] = 0.0;
        rJacobian[20][34] = 0.0;
        rJacobian[20][35] = 0.0;
        rJacobian[20][36] = 0.0;
        rJacobian[20][37] = 0.0;
        rJacobian[20][38] = 0.0;
        rJacobian[20][39] = 0.0;
        rJacobian[20][40] = 0.0;
        rJacobian[20][41] = 0.0;
        rJacobian[20][42] = 0.0;
        rJacobian[20][43] = 0.0;
        rJacobian[20][44] = 0.0;
        rJacobian[20][45] = 0.0;
        rJacobian[20][46] = 0.0;
        rJacobian[20][47] = 0.0;
        rJacobian[20][48] = 0.0;
        rJacobian[20][49] = 0.0;
        rJacobian[20][50] = 0.0;
        rJacobian[20][51] = 0.0;
        rJacobian[20][52] = 0.0;
        rJacobian[20][53] = 0.0;
        rJacobian[20][54] = 0.0;
        rJacobian[20][55] = 0.0;
        rJacobian[20][56] = 0.0;
        rJacobian[20][57] = 0.0;
        rJacobian[20][58] = 0.0;
        rJacobian[20][59] = 0.0;
        rJacobian[20][60] = 0.0;
        rJacobian[20][61] = 0.0;
        rJacobian[20][62] = 0.0;
        rJacobian[20][63] = 0.0;
        rJacobian[20][64] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = 0.0;
        rJacobian[21][11] = 0.0;
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = 0.0;
        rJacobian[21][15] = 0.0;
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = -(mDt * (var_x84));
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = 0.0;
        rJacobian[21][20] = -(mDt * (var_x95));
        rJacobian[21][21] = 1.0 - (mDt * (-var_x86 - var_x96 - var_x97));
        rJacobian[21][22] = -(mDt * (var_x98));
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[21][25] = 0.0;
        rJacobian[21][26] = 0.0;
        rJacobian[21][27] = 0.0;
        rJacobian[21][28] = 0.0;
        rJacobian[21][29] = 0.0;
        rJacobian[21][30] = 0.0;
        rJacobian[21][31] = 0.0;
        rJacobian[21][32] = 0.0;
        rJacobian[21][33] = 0.0;
        rJacobian[21][34] = 0.0;
        rJacobian[21][35] = 0.0;
        rJacobian[21][36] = 0.0;
        rJacobian[21][37] = 0.0;
        rJacobian[21][38] = 0.0;
        rJacobian[21][39] = 0.0;
        rJacobian[21][40] = 0.0;
        rJacobian[21][41] = 0.0;
        rJacobian[21][42] = 0.0;
        rJacobian[21][43] = 0.0;
        rJacobian[21][44] = 0.0;
        rJacobian[21][45] = 0.0;
        rJacobian[21][46] = 0.0;
        rJacobian[21][47] = 0.0;
        rJacobian[21][48] = 0.0;
        rJacobian[21][49] = 0.0;
        rJacobian[21][50] = 0.0;
        rJacobian[21][51] = 0.0;
        rJacobian[21][52] = 0.0;
        rJacobian[21][53] = 0.0;
        rJacobian[21][54] = 0.0;
        rJacobian[21][55] = 0.0;
        rJacobian[21][56] = 0.0;
        rJacobian[21][57] = 0.0;
        rJacobian[21][58] = 0.0;
        rJacobian[21][59] = 0.0;
        rJacobian[21][60] = 0.0;
        rJacobian[21][61] = 0.0;
        rJacobian[21][62] = 0.0;
        rJacobian[21][63] = 0.0;
        rJacobian[21][64] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = 0.0;
        rJacobian[22][11] = 0.0;
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = 0.0;
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = 0.0;
        rJacobian[22][18] = -(mDt * (var_x88));
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = 0.0;
        rJacobian[22][21] = -(mDt * (var_x97));
        rJacobian[22][22] = 1.0 - (mDt * (-var_x90 - var_x98 - var_x99));
        rJacobian[22][23] = -(mDt * (var_x100));
        rJacobian[22][24] = 0.0;
        rJacobian[22][25] = 0.0;
        rJacobian[22][26] = 0.0;
        rJacobian[22][27] = 0.0;
        rJacobian[22][28] = 0.0;
        rJacobian[22][29] = 0.0;
        rJacobian[22][30] = 0.0;
        rJacobian[22][31] = 0.0;
        rJacobian[22][32] = 0.0;
        rJacobian[22][33] = 0.0;
        rJacobian[22][34] = 0.0;
        rJacobian[22][35] = 0.0;
        rJacobian[22][36] = 0.0;
        rJacobian[22][37] = 0.0;
        rJacobian[22][38] = 0.0;
        rJacobian[22][39] = 0.0;
        rJacobian[22][40] = 0.0;
        rJacobian[22][41] = 0.0;
        rJacobian[22][42] = 0.0;
        rJacobian[22][43] = 0.0;
        rJacobian[22][44] = 0.0;
        rJacobian[22][45] = 0.0;
        rJacobian[22][46] = 0.0;
        rJacobian[22][47] = 0.0;
        rJacobian[22][48] = 0.0;
        rJacobian[22][49] = 0.0;
        rJacobian[22][50] = 0.0;
        rJacobian[22][51] = 0.0;
        rJacobian[22][52] = 0.0;
        rJacobian[22][53] = 0.0;
        rJacobian[22][54] = 0.0;
        rJacobian[22][55] = 0.0;
        rJacobian[22][56] = 0.0;
        rJacobian[22][57] = 0.0;
        rJacobian[22][58] = 0.0;
        rJacobian[22][59] = 0.0;
        rJacobian[22][60] = 0.0;
        rJacobian[22][61] = 0.0;
        rJacobian[22][62] = 0.0;
        rJacobian[22][63] = 0.0;
        rJacobian[22][64] = 0.0;
        rJacobian[23][0] = 0.0;
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = 0.0;
        rJacobian[23][11] = 0.0;
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = 0.0;
        rJacobian[23][16] = 0.0;
        rJacobian[23][17] = 0.0;
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = -(mDt * (var_x92));
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = -(mDt * (var_x99));
        rJacobian[23][23] = 1.0 - (mDt * (-var_x100 - var_x101 - var_x93));
        rJacobian[23][24] = -(mDt * (var_x102));
        rJacobian[23][25] = 0.0;
        rJacobian[23][26] = 0.0;
        rJacobian[23][27] = 0.0;
        rJacobian[23][28] = 0.0;
        rJacobian[23][29] = 0.0;
        rJacobian[23][30] = 0.0;
        rJacobian[23][31] = 0.0;
        rJacobian[23][32] = 0.0;
        rJacobian[23][33] = 0.0;
        rJacobian[23][34] = 0.0;
        rJacobian[23][35] = 0.0;
        rJacobian[23][36] = 0.0;
        rJacobian[23][37] = 0.0;
        rJacobian[23][38] = 0.0;
        rJacobian[23][39] = 0.0;
        rJacobian[23][40] = 0.0;
        rJacobian[23][41] = 0.0;
        rJacobian[23][42] = 0.0;
        rJacobian[23][43] = 0.0;
        rJacobian[23][44] = 0.0;
        rJacobian[23][45] = 0.0;
        rJacobian[23][46] = 0.0;
        rJacobian[23][47] = 0.0;
        rJacobian[23][48] = 0.0;
        rJacobian[23][49] = 0.0;
        rJacobian[23][50] = 0.0;
        rJacobian[23][51] = 0.0;
        rJacobian[23][52] = 0.0;
        rJacobian[23][53] = 0.0;
        rJacobian[23][54] = 0.0;
        rJacobian[23][55] = 0.0;
        rJacobian[23][56] = 0.0;
        rJacobian[23][57] = 0.0;
        rJacobian[23][58] = 0.0;
        rJacobian[23][59] = 0.0;
        rJacobian[23][60] = 0.0;
        rJacobian[23][61] = 0.0;
        rJacobian[23][62] = 0.0;
        rJacobian[23][63] = 0.0;
        rJacobian[23][64] = 0.0;
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = 0.0;
        rJacobian[24][16] = 0.0;
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = 0.0;
        rJacobian[24][23] = -(mDt * (var_x101));
        rJacobian[24][24] = 1.0 - (mDt * (-var_x102 - var_x103));
        rJacobian[24][25] = -(mDt * (var_x104));
        rJacobian[24][26] = 0.0;
        rJacobian[24][27] = 0.0;
        rJacobian[24][28] = 0.0;
        rJacobian[24][29] = 0.0;
        rJacobian[24][30] = 0.0;
        rJacobian[24][31] = 0.0;
        rJacobian[24][32] = 0.0;
        rJacobian[24][33] = 0.0;
        rJacobian[24][34] = 0.0;
        rJacobian[24][35] = 0.0;
        rJacobian[24][36] = 0.0;
        rJacobian[24][37] = 0.0;
        rJacobian[24][38] = 0.0;
        rJacobian[24][39] = 0.0;
        rJacobian[24][40] = 0.0;
        rJacobian[24][41] = 0.0;
        rJacobian[24][42] = 0.0;
        rJacobian[24][43] = 0.0;
        rJacobian[24][44] = 0.0;
        rJacobian[24][45] = 0.0;
        rJacobian[24][46] = 0.0;
        rJacobian[24][47] = 0.0;
        rJacobian[24][48] = 0.0;
        rJacobian[24][49] = 0.0;
        rJacobian[24][50] = 0.0;
        rJacobian[24][51] = 0.0;
        rJacobian[24][52] = 0.0;
        rJacobian[24][53] = 0.0;
        rJacobian[24][54] = 0.0;
        rJacobian[24][55] = 0.0;
        rJacobian[24][56] = 0.0;
        rJacobian[24][57] = 0.0;
        rJacobian[24][58] = 0.0;
        rJacobian[24][59] = 0.0;
        rJacobian[24][60] = 0.0;
        rJacobian[24][61] = 0.0;
        rJacobian[24][62] = 0.0;
        rJacobian[24][63] = 0.0;
        rJacobian[24][64] = 0.0;
        rJacobian[25][0] = 0.0;
        rJacobian[25][1] = 0.0;
        rJacobian[25][2] = 0.0;
        rJacobian[25][3] = 0.0;
        rJacobian[25][4] = 0.0;
        rJacobian[25][5] = 0.0;
        rJacobian[25][6] = 0.0;
        rJacobian[25][7] = 0.0;
        rJacobian[25][8] = 0.0;
        rJacobian[25][9] = 0.0;
        rJacobian[25][10] = 0.0;
        rJacobian[25][11] = 0.0;
        rJacobian[25][12] = 0.0;
        rJacobian[25][13] = 0.0;
        rJacobian[25][14] = 0.0;
        rJacobian[25][15] = 0.0;
        rJacobian[25][16] = 0.0;
        rJacobian[25][17] = 0.0;
        rJacobian[25][18] = 0.0;
        rJacobian[25][19] = -(mDt * (var_x91));
        rJacobian[25][20] = 0.0;
        rJacobian[25][21] = 0.0;
        rJacobian[25][22] = 0.0;
        rJacobian[25][23] = 0.0;
        rJacobian[25][24] = -(mDt * (var_x103));
        rJacobian[25][25] = 1.0 - (mDt * (-var_x104 - var_x94));
        rJacobian[25][26] = 0.0;
        rJacobian[25][27] = 0.0;
        rJacobian[25][28] = 0.0;
        rJacobian[25][29] = 0.0;
        rJacobian[25][30] = 0.0;
        rJacobian[25][31] = 0.0;
        rJacobian[25][32] = 0.0;
        rJacobian[25][33] = 0.0;
        rJacobian[25][34] = 0.0;
        rJacobian[25][35] = 0.0;
        rJacobian[25][36] = 0.0;
        rJacobian[25][37] = 0.0;
        rJacobian[25][38] = 0.0;
        rJacobian[25][39] = 0.0;
        rJacobian[25][40] = 0.0;
        rJacobian[25][41] = 0.0;
        rJacobian[25][42] = 0.0;
        rJacobian[25][43] = 0.0;
        rJacobian[25][44] = 0.0;
        rJacobian[25][45] = 0.0;
        rJacobian[25][46] = 0.0;
        rJacobian[25][47] = 0.0;
        rJacobian[25][48] = 0.0;
        rJacobian[25][49] = 0.0;
        rJacobian[25][50] = 0.0;
        rJacobian[25][51] = 0.0;
        rJacobian[25][52] = 0.0;
        rJacobian[25][53] = 0.0;
        rJacobian[25][54] = 0.0;
        rJacobian[25][55] = 0.0;
        rJacobian[25][56] = 0.0;
        rJacobian[25][57] = 0.0;
        rJacobian[25][58] = 0.0;
        rJacobian[25][59] = 0.0;
        rJacobian[25][60] = 0.0;
        rJacobian[25][61] = 0.0;
        rJacobian[25][62] = 0.0;
        rJacobian[25][63] = 0.0;
        rJacobian[25][64] = 0.0;
        rJacobian[26][0] = 0.0;
        rJacobian[26][1] = 0.0;
        rJacobian[26][2] = -(mDt * (-var_x105));
        rJacobian[26][3] = 0.0;
        rJacobian[26][4] = 0.0;
        rJacobian[26][5] = 0.0;
        rJacobian[26][6] = 0.0;
        rJacobian[26][7] = 0.0;
        rJacobian[26][8] = 0.0;
        rJacobian[26][9] = 0.0;
        rJacobian[26][10] = 0.0;
        rJacobian[26][11] = 0.0;
        rJacobian[26][12] = 0.0;
        rJacobian[26][13] = 0.0;
        rJacobian[26][14] = 0.0;
        rJacobian[26][15] = 0.0;
        rJacobian[26][16] = 0.0;
        rJacobian[26][17] = 0.0;
        rJacobian[26][18] = 0.0;
        rJacobian[26][19] = 0.0;
        rJacobian[26][20] = 0.0;
        rJacobian[26][21] = 0.0;
        rJacobian[26][22] = 0.0;
        rJacobian[26][23] = 0.0;
        rJacobian[26][24] = 0.0;
        rJacobian[26][25] = 0.0;
        rJacobian[26][26] = 1.0 - (mDt * (var_x109 - var_x106));
        rJacobian[26][27] = -(mDt * (var_x111));
        rJacobian[26][28] = 0.0;
        rJacobian[26][29] = 0.0;
        rJacobian[26][30] = 0.0;
        rJacobian[26][31] = -(mDt * (0.0025000000000000001));
        rJacobian[26][32] = 0.0;
        rJacobian[26][33] = 0.0;
        rJacobian[26][34] = 0.0;
        rJacobian[26][35] = 0.0;
        rJacobian[26][36] = 0.0;
        rJacobian[26][37] = 0.0;
        rJacobian[26][38] = 0.0;
        rJacobian[26][39] = 0.0;
        rJacobian[26][40] = 0.0;
        rJacobian[26][41] = 0.0;
        rJacobian[26][42] = 0.0;
        rJacobian[26][43] = 0.0;
        rJacobian[26][44] = 0.0;
        rJacobian[26][45] = 0.0;
        rJacobian[26][46] = 0.0;
        rJacobian[26][47] = 0.0;
        rJacobian[26][48] = 0.0;
        rJacobian[26][49] = 0.0;
        rJacobian[26][50] = 0.0;
        rJacobian[26][51] = 0.0;
        rJacobian[26][52] = 0.0;
        rJacobian[26][53] = 0.0;
        rJacobian[26][54] = 0.0;
        rJacobian[26][55] = 0.0;
        rJacobian[26][56] = 0.0;
        rJacobian[26][57] = 0.0;
        rJacobian[26][58] = 0.0;
        rJacobian[26][59] = 0.0;
        rJacobian[26][60] = 0.0;
        rJacobian[26][61] = 0.0;
        rJacobian[26][62] = 0.0;
        rJacobian[26][63] = 0.0;
        rJacobian[26][64] = 0.0;
        rJacobian[27][0] = 0.0;
        rJacobian[27][1] = 0.0;
        rJacobian[27][2] = -(mDt * (-var_x112));
        rJacobian[27][3] = 0.0;
        rJacobian[27][4] = 0.0;
        rJacobian[27][5] = 0.0;
        rJacobian[27][6] = 0.0;
        rJacobian[27][7] = 0.0;
        rJacobian[27][8] = 0.0;
        rJacobian[27][9] = 0.0;
        rJacobian[27][10] = 0.0;
        rJacobian[27][11] = 0.0;
        rJacobian[27][12] = 0.0;
        rJacobian[27][13] = 0.0;
        rJacobian[27][14] = 0.0;
        rJacobian[27][15] = 0.0;
        rJacobian[27][16] = 0.0;
        rJacobian[27][17] = 0.0;
        rJacobian[27][18] = 0.0;
        rJacobian[27][19] = 0.0;
        rJacobian[27][20] = 0.0;
        rJacobian[27][21] = 0.0;
        rJacobian[27][22] = 0.0;
        rJacobian[27][23] = 0.0;
        rJacobian[27][24] = 0.0;
        rJacobian[27][25] = 0.0;
        rJacobian[27][26] = -(mDt * (var_x108));
        rJacobian[27][27] = 1.0 - (mDt * (var_x115 - var_x113 - var_x114));
        rJacobian[27][28] = -(mDt * (var_x116));
        rJacobian[27][29] = 0.0;
        rJacobian[27][30] = 0.0;
        rJacobian[27][31] = 0.0;
        rJacobian[27][32] = -(mDt * (0.00125));
        rJacobian[27][33] = 0.0;
        rJacobian[27][34] = 0.0;
        rJacobian[27][35] = 0.0;
        rJacobian[27][36] = 0.0;
        rJacobian[27][37] = 0.0;
        rJacobian[27][38] = 0.0;
        rJacobian[27][39] = 0.0;
        rJacobian[27][40] = 0.0;
        rJacobian[27][41] = 0.0;
        rJacobian[27][42] = 0.0;
        rJacobian[27][43] = 0.0;
        rJacobian[27][44] = 0.0;
        rJacobian[27][45] = 0.0;
        rJacobian[27][46] = 0.0;
        rJacobian[27][47] = 0.0;
        rJacobian[27][48] = 0.0;
        rJacobian[27][49] = 0.0;
        rJacobian[27][50] = 0.0;
        rJacobian[27][51] = 0.0;
        rJacobian[27][52] = 0.0;
        rJacobian[27][53] = 0.0;
        rJacobian[27][54] = 0.0;
        rJacobian[27][55] = 0.0;
        rJacobian[27][56] = 0.0;
        rJacobian[27][57] = 0.0;
        rJacobian[27][58] = 0.0;
        rJacobian[27][59] = 0.0;
        rJacobian[27][60] = 0.0;
        rJacobian[27][61] = 0.0;
        rJacobian[27][62] = 0.0;
        rJacobian[27][63] = 0.0;
        rJacobian[27][64] = 0.0;
        rJacobian[28][0] = 0.0;
        rJacobian[28][1] = 0.0;
        rJacobian[28][2] = -(mDt * (-var_x117));
        rJacobian[28][3] = 0.0;
        rJacobian[28][4] = 0.0;
        rJacobian[28][5] = 0.0;
        rJacobian[28][6] = 0.0;
        rJacobian[28][7] = 0.0;
        rJacobian[28][8] = 0.0;
        rJacobian[28][9] = 0.0;
        rJacobian[28][10] = 0.0;
        rJacobian[28][11] = 0.0;
        rJacobian[28][12] = 0.0;
        rJacobian[28][13] = 0.0;
        rJacobian[28][14] = 0.0;
        rJacobian[28][15] = 0.0;
        rJacobian[28][16] = 0.0;
        rJacobian[28][17] = 0.0;
        rJacobian[28][18] = 0.0;
        rJacobian[28][19] = 0.0;
        rJacobian[28][20] = 0.0;
        rJacobian[28][21] = 0.0;
        rJacobian[28][22] = 0.0;
        rJacobian[28][23] = 0.0;
        rJacobian[28][24] = 0.0;
        rJacobian[28][25] = 0.0;
        rJacobian[28][26] = 0.0;
        rJacobian[28][27] = -(mDt * (var_x113));
        rJacobian[28][28] = 1.0 - (mDt * (var_x119 + var_x121 - var_x118));
        rJacobian[28][29] = -(mDt * (var_x122));
        rJacobian[28][30] = 0.0;
        rJacobian[28][31] = 0.0;
        rJacobian[28][32] = 0.0;
        rJacobian[28][33] = -(mDt * (0.00062500000000000001));
        rJacobian[28][34] = 0.0;
        rJacobian[28][35] = 0.0;
        rJacobian[28][36] = 0.0;
        rJacobian[28][37] = 0.0;
        rJacobian[28][38] = 0.0;
        rJacobian[28][39] = 0.0;
        rJacobian[28][40] = 0.0;
        rJacobian[28][41] = 0.0;
        rJacobian[28][42] = 0.0;
        rJacobian[28][43] = 0.0;
        rJacobian[28][44] = 0.0;
        rJacobian[28][45] = 0.0;
        rJacobian[28][46] = 0.0;
        rJacobian[28][47] = 0.0;
        rJacobian[28][48] = 0.0;
        rJacobian[28][49] = 0.0;
        rJacobian[28][50] = 0.0;
        rJacobian[28][51] = 0.0;
        rJacobian[28][52] = 0.0;
        rJacobian[28][53] = 0.0;
        rJacobian[28][54] = 0.0;
        rJacobian[28][55] = 0.0;
        rJacobian[28][56] = 0.0;
        rJacobian[28][57] = 0.0;
        rJacobian[28][58] = 0.0;
        rJacobian[28][59] = 0.0;
        rJacobian[28][60] = 0.0;
        rJacobian[28][61] = 0.0;
        rJacobian[28][62] = 0.0;
        rJacobian[28][63] = 0.0;
        rJacobian[28][64] = 0.0;
        rJacobian[29][0] = 0.0;
        rJacobian[29][1] = 0.0;
        rJacobian[29][2] = -(mDt * (-var_x123));
        rJacobian[29][3] = 0.0;
        rJacobian[29][4] = 0.0;
        rJacobian[29][5] = 0.0;
        rJacobian[29][6] = 0.0;
        rJacobian[29][7] = 0.0;
        rJacobian[29][8] = 0.0;
        rJacobian[29][9] = 0.0;
        rJacobian[29][10] = 0.0;
        rJacobian[29][11] = 0.0;
        rJacobian[29][12] = 0.0;
        rJacobian[29][13] = 0.0;
        rJacobian[29][14] = 0.0;
        rJacobian[29][15] = 0.0;
        rJacobian[29][16] = 0.0;
        rJacobian[29][17] = 0.0;
        rJacobian[29][18] = 0.0;
        rJacobian[29][19] = 0.0;
        rJacobian[29][20] = 0.0;
        rJacobian[29][21] = 0.0;
        rJacobian[29][22] = 0.0;
        rJacobian[29][23] = 0.0;
        rJacobian[29][24] = 0.0;
        rJacobian[29][25] = 0.0;
        rJacobian[29][26] = 0.0;
        rJacobian[29][27] = 0.0;
        rJacobian[29][28] = -(mDt * (var_x120));
        rJacobian[29][29] = 1.0 - (mDt * (-var_x122 - var_x124 - var_x125));
        rJacobian[29][30] = -(mDt * (var_x126));
        rJacobian[29][31] = 0.0;
        rJacobian[29][32] = 0.0;
        rJacobian[29][33] = 0.0;
        rJacobian[29][34] = -(mDt * (0.00031250000000000001));
        rJacobian[29][35] = 0.0;
        rJacobian[29][36] = 0.0;
        rJacobian[29][37] = 0.0;
        rJacobian[29][38] = 0.0;
        rJacobian[29][39] = 0.0;
        rJacobian[29][40] = 0.0;
        rJacobian[29][41] = 0.0;
        rJacobian[29][42] = 0.0;
        rJacobian[29][43] = 0.0;
        rJacobian[29][44] = 0.0;
        rJacobian[29][45] = 0.0;
        rJacobian[29][46] = 0.0;
        rJacobian[29][47] = 0.0;
        rJacobian[29][48] = 0.0;
        rJacobian[29][49] = 0.0;
        rJacobian[29][50] = 0.0;
        rJacobian[29][51] = 0.0;
        rJacobian[29][52] = 0.0;
        rJacobian[29][53] = 0.0;
        rJacobian[29][54] = 0.0;
        rJacobian[29][55] = 0.0;
        rJacobian[29][56] = 0.0;
        rJacobian[29][57] = 0.0;
        rJacobian[29][58] = 0.0;
        rJacobian[29][59] = 0.0;
        rJacobian[29][60] = 0.0;
        rJacobian[29][61] = 0.0;
        rJacobian[29][62] = 0.0;
        rJacobian[29][63] = 0.0;
        rJacobian[29][64] = 0.0;
        rJacobian[30][0] = 0.0;
        rJacobian[30][1] = 0.0;
        rJacobian[30][2] = -(mDt * (-var_x127));
        rJacobian[30][3] = 0.0;
        rJacobian[30][4] = 0.0;
        rJacobian[30][5] = 0.0;
        rJacobian[30][6] = 0.0;
        rJacobian[30][7] = 0.0;
        rJacobian[30][8] = 0.0;
        rJacobian[30][9] = 0.0;
        rJacobian[30][10] = 0.0;
        rJacobian[30][11] = 0.0;
        rJacobian[30][12] = 0.0;
        rJacobian[30][13] = 0.0;
        rJacobian[30][14] = 0.0;
        rJacobian[30][15] = 0.0;
        rJacobian[30][16] = 0.0;
        rJacobian[30][17] = 0.0;
        rJacobian[30][18] = 0.0;
        rJacobian[30][19] = 0.0;
        rJacobian[30][20] = 0.0;
        rJacobian[30][21] = 0.0;
        rJacobian[30][22] = 0.0;
        rJacobian[30][23] = 0.0;
        rJacobian[30][24] = 0.0;
        rJacobian[30][25] = 0.0;
        rJacobian[30][26] = 0.0;
        rJacobian[30][27] = 0.0;
        rJacobian[30][28] = 0.0;
        rJacobian[30][29] = -(mDt * (var_x125));
        rJacobian[30][30] = 1.0 - (mDt * (-0.29999999999999999 - var_x126 - var_x128));
        rJacobian[30][31] = 0.0;
        rJacobian[30][32] = 0.0;
        rJacobian[30][33] = 0.0;
        rJacobian[30][34] = 0.0;
        rJacobian[30][35] = -(mDt * (0.00015625));
        rJacobian[30][36] = -(mDt * (4.0));
        rJacobian[30][37] = 0.0;
        rJacobian[30][38] = 0.0;
        rJacobian[30][39] = 0.0;
        rJacobian[30][40] = 0.0;
        rJacobian[30][41] = 0.0;
        rJacobian[30][42] = 0.0;
        rJacobian[30][43] = 0.0;
        rJacobian[30][44] = 0.0;
        rJacobian[30][45] = 0.0;
        rJacobian[30][46] = 0.0;
        rJacobian[30][47] = 0.0;
        rJacobian[30][48] = 0.0;
        rJacobian[30][49] = 0.0;
        rJacobian[30][50] = 0.0;
        rJacobian[30][51] = 0.0;
        rJacobian[30][52] = 0.0;
        rJacobian[30][53] = 0.0;
        rJacobian[30][54] = 0.0;
        rJacobian[30][55] = 0.0;
        rJacobian[30][56] = 0.0;
        rJacobian[30][57] = 0.0;
        rJacobian[30][58] = 0.0;
        rJacobian[30][59] = 0.0;
        rJacobian[30][60] = 0.0;
        rJacobian[30][61] = 0.0;
        rJacobian[30][62] = 0.0;
        rJacobian[30][63] = 0.0;
        rJacobian[30][64] = 0.0;
        rJacobian[31][0] = 0.0;
        rJacobian[31][1] = 0.0;
        rJacobian[31][2] = -(mDt * (var_x105));
        rJacobian[31][3] = 0.0;
        rJacobian[31][4] = 0.0;
        rJacobian[31][5] = 0.0;
        rJacobian[31][6] = 0.0;
        rJacobian[31][7] = 0.0;
        rJacobian[31][8] = 0.0;
        rJacobian[31][9] = 0.0;
        rJacobian[31][10] = 0.0;
        rJacobian[31][11] = 0.0;
        rJacobian[31][12] = 0.0;
        rJacobian[31][13] = 0.0;
        rJacobian[31][14] = 0.0;
        rJacobian[31][15] = 0.0;
        rJacobian[31][16] = 0.0;
        rJacobian[31][17] = 0.0;
        rJacobian[31][18] = 0.0;
        rJacobian[31][19] = 0.0;
        rJacobian[31][20] = 0.0;
        rJacobian[31][21] = 0.0;
        rJacobian[31][22] = 0.0;
        rJacobian[31][23] = 0.0;
        rJacobian[31][24] = 0.0;
        rJacobian[31][25] = 0.0;
        rJacobian[31][26] = -(mDt * (var_x106));
        rJacobian[31][27] = 0.0;
        rJacobian[31][28] = 0.0;
        rJacobian[31][29] = 0.0;
        rJacobian[31][30] = 0.0;
        rJacobian[31][31] = 1.0 - (mDt * (-0.0025000000000000001 - var_x129));
        rJacobian[31][32] = -(mDt * (var_x130));
        rJacobian[31][33] = 0.0;
        rJacobian[31][34] = 0.0;
        rJacobian[31][35] = 0.0;
        rJacobian[31][36] = 0.0;
        rJacobian[31][37] = 0.0;
        rJacobian[31][38] = 0.0;
        rJacobian[31][39] = 0.0;
        rJacobian[31][40] = 0.0;
        rJacobian[31][41] = 0.0;
        rJacobian[31][42] = 0.0;
        rJacobian[31][43] = 0.0;
        rJacobian[31][44] = 0.0;
        rJacobian[31][45] = 0.0;
        rJacobian[31][46] = 0.0;
        rJacobian[31][47] = 0.0;
        rJacobian[31][48] = 0.0;
        rJacobian[31][49] = 0.0;
        rJacobian[31][50] = 0.0;
        rJacobian[31][51] = 0.0;
        rJacobian[31][52] = 0.0;
        rJacobian[31][53] = 0.0;
        rJacobian[31][54] = 0.0;
        rJacobian[31][55] = 0.0;
        rJacobian[31][56] = 0.0;
        rJacobian[31][57] = 0.0;
        rJacobian[31][58] = 0.0;
        rJacobian[31][59] = 0.0;
        rJacobian[31][60] = 0.0;
        rJacobian[31][61] = 0.0;
        rJacobian[31][62] = 0.0;
        rJacobian[31][63] = 0.0;
        rJacobian[31][64] = 0.0;
        rJacobian[32][0] = 0.0;
        rJacobian[32][1] = 0.0;
        rJacobian[32][2] = -(mDt * (var_x112));
        rJacobian[32][3] = 0.0;
        rJacobian[32][4] = 0.0;
        rJacobian[32][5] = 0.0;
        rJacobian[32][6] = 0.0;
        rJacobian[32][7] = 0.0;
        rJacobian[32][8] = 0.0;
        rJacobian[32][9] = 0.0;
        rJacobian[32][10] = 0.0;
        rJacobian[32][11] = 0.0;
        rJacobian[32][12] = 0.0;
        rJacobian[32][13] = 0.0;
        rJacobian[32][14] = 0.0;
        rJacobian[32][15] = 0.0;
        rJacobian[32][16] = 0.0;
        rJacobian[32][17] = 0.0;
        rJacobian[32][18] = 0.0;
        rJacobian[32][19] = 0.0;
        rJacobian[32][20] = 0.0;
        rJacobian[32][21] = 0.0;
        rJacobian[32][22] = 0.0;
        rJacobian[32][23] = 0.0;
        rJacobian[32][24] = 0.0;
        rJacobian[32][25] = 0.0;
        rJacobian[32][26] = 0.0;
        rJacobian[32][27] = -(mDt * (var_x114));
        rJacobian[32][28] = 0.0;
        rJacobian[32][29] = 0.0;
        rJacobian[32][30] = 0.0;
        rJacobian[32][31] = -(mDt * (var_x129));
        rJacobian[32][32] = 1.0 - (mDt * (-0.00125 - var_x130 - var_x131));
        rJacobian[32][33] = -(mDt * (var_x111));
        rJacobian[32][34] = 0.0;
        rJacobian[32][35] = 0.0;
        rJacobian[32][36] = 0.0;
        rJacobian[32][37] = 0.0;
        rJacobian[32][38] = 0.0;
        rJacobian[32][39] = 0.0;
        rJacobian[32][40] = 0.0;
        rJacobian[32][41] = 0.0;
        rJacobian[32][42] = 0.0;
        rJacobian[32][43] = 0.0;
        rJacobian[32][44] = 0.0;
        rJacobian[32][45] = 0.0;
        rJacobian[32][46] = 0.0;
        rJacobian[32][47] = 0.0;
        rJacobian[32][48] = 0.0;
        rJacobian[32][49] = 0.0;
        rJacobian[32][50] = 0.0;
        rJacobian[32][51] = 0.0;
        rJacobian[32][52] = 0.0;
        rJacobian[32][53] = 0.0;
        rJacobian[32][54] = 0.0;
        rJacobian[32][55] = 0.0;
        rJacobian[32][56] = 0.0;
        rJacobian[32][57] = 0.0;
        rJacobian[32][58] = 0.0;
        rJacobian[32][59] = 0.0;
        rJacobian[32][60] = 0.0;
        rJacobian[32][61] = 0.0;
        rJacobian[32][62] = 0.0;
        rJacobian[32][63] = 0.0;
        rJacobian[32][64] = 0.0;
        rJacobian[33][0] = 0.0;
        rJacobian[33][1] = 0.0;
        rJacobian[33][2] = -(mDt * (var_x117));
        rJacobian[33][3] = 0.0;
        rJacobian[33][4] = 0.0;
        rJacobian[33][5] = 0.0;
        rJacobian[33][6] = 0.0;
        rJacobian[33][7] = 0.0;
        rJacobian[33][8] = 0.0;
        rJacobian[33][9] = 0.0;
        rJacobian[33][10] = 0.0;
        rJacobian[33][11] = 0.0;
        rJacobian[33][12] = 0.0;
        rJacobian[33][13] = 0.0;
        rJacobian[33][14] = 0.0;
        rJacobian[33][15] = 0.0;
        rJacobian[33][16] = 0.0;
        rJacobian[33][17] = 0.0;
        rJacobian[33][18] = 0.0;
        rJacobian[33][19] = 0.0;
        rJacobian[33][20] = 0.0;
        rJacobian[33][21] = 0.0;
        rJacobian[33][22] = 0.0;
        rJacobian[33][23] = 0.0;
        rJacobian[33][24] = 0.0;
        rJacobian[33][25] = 0.0;
        rJacobian[33][26] = 0.0;
        rJacobian[33][27] = 0.0;
        rJacobian[33][28] = -(mDt * (var_x118));
        rJacobian[33][29] = 0.0;
        rJacobian[33][30] = 0.0;
        rJacobian[33][31] = 0.0;
        rJacobian[33][32] = -(mDt * (var_x131));
        rJacobian[33][33] = 1.0 - (mDt * (-0.00062500000000000001 + var_x109 + var_x115));
        rJacobian[33][34] = -(mDt * (var_x132));
        rJacobian[33][35] = 0.0;
        rJacobian[33][36] = 0.0;
        rJacobian[33][37] = 0.0;
        rJacobian[33][38] = 0.0;
        rJacobian[33][39] = 0.0;
        rJacobian[33][40] = 0.0;
        rJacobian[33][41] = 0.0;
        rJacobian[33][42] = 0.0;
        rJacobian[33][43] = 0.0;
        rJacobian[33][44] = 0.0;
        rJacobian[33][45] = 0.0;
        rJacobian[33][46] = 0.0;
        rJacobian[33][47] = 0.0;
        rJacobian[33][48] = 0.0;
        rJacobian[33][49] = 0.0;
        rJacobian[33][50] = 0.0;
        rJacobian[33][51] = 0.0;
        rJacobian[33][52] = 0.0;
        rJacobian[33][53] = 0.0;
        rJacobian[33][54] = 0.0;
        rJacobian[33][55] = 0.0;
        rJacobian[33][56] = 0.0;
        rJacobian[33][57] = 0.0;
        rJacobian[33][58] = 0.0;
        rJacobian[33][59] = 0.0;
        rJacobian[33][60] = 0.0;
        rJacobian[33][61] = 0.0;
        rJacobian[33][62] = 0.0;
        rJacobian[33][63] = 0.0;
        rJacobian[33][64] = 0.0;
        rJacobian[34][0] = 0.0;
        rJacobian[34][1] = 0.0;
        rJacobian[34][2] = -(mDt * (var_x123));
        rJacobian[34][3] = 0.0;
        rJacobian[34][4] = 0.0;
        rJacobian[34][5] = 0.0;
        rJacobian[34][6] = 0.0;
        rJacobian[34][7] = 0.0;
        rJacobian[34][8] = 0.0;
        rJacobian[34][9] = 0.0;
        rJacobian[34][10] = 0.0;
        rJacobian[34][11] = 0.0;
        rJacobian[34][12] = 0.0;
        rJacobian[34][13] = 0.0;
        rJacobian[34][14] = 0.0;
        rJacobian[34][15] = 0.0;
        rJacobian[34][16] = 0.0;
        rJacobian[34][17] = 0.0;
        rJacobian[34][18] = 0.0;
        rJacobian[34][19] = 0.0;
        rJacobian[34][20] = 0.0;
        rJacobian[34][21] = 0.0;
        rJacobian[34][22] = 0.0;
        rJacobian[34][23] = 0.0;
        rJacobian[34][24] = 0.0;
        rJacobian[34][25] = 0.0;
        rJacobian[34][26] = 0.0;
        rJacobian[34][27] = 0.0;
        rJacobian[34][28] = 0.0;
        rJacobian[34][29] = -(mDt * (var_x124));
        rJacobian[34][30] = 0.0;
        rJacobian[34][31] = 0.0;
        rJacobian[34][32] = 0.0;
        rJacobian[34][33] = -(mDt * (var_x108));
        rJacobian[34][34] = 1.0 - (mDt * (-0.00031250000000000001 + var_x121 - var_x132));
        rJacobian[34][35] = -(mDt * (var_x116));
        rJacobian[34][36] = 0.0;
        rJacobian[34][37] = 0.0;
        rJacobian[34][38] = 0.0;
        rJacobian[34][39] = 0.0;
        rJacobian[34][40] = 0.0;
        rJacobian[34][41] = 0.0;
        rJacobian[34][42] = 0.0;
        rJacobian[34][43] = 0.0;
        rJacobian[34][44] = 0.0;
        rJacobian[34][45] = 0.0;
        rJacobian[34][46] = 0.0;
        rJacobian[34][47] = 0.0;
        rJacobian[34][48] = 0.0;
        rJacobian[34][49] = 0.0;
        rJacobian[34][50] = 0.0;
        rJacobian[34][51] = 0.0;
        rJacobian[34][52] = 0.0;
        rJacobian[34][53] = 0.0;
        rJacobian[34][54] = 0.0;
        rJacobian[34][55] = 0.0;
        rJacobian[34][56] = 0.0;
        rJacobian[34][57] = 0.0;
        rJacobian[34][58] = 0.0;
        rJacobian[34][59] = 0.0;
        rJacobian[34][60] = 0.0;
        rJacobian[34][61] = 0.0;
        rJacobian[34][62] = 0.0;
        rJacobian[34][63] = 0.0;
        rJacobian[34][64] = 0.0;
        rJacobian[35][0] = 0.0;
        rJacobian[35][1] = 0.0;
        rJacobian[35][2] = -(mDt * (var_x127));
        rJacobian[35][3] = 0.0;
        rJacobian[35][4] = 0.0;
        rJacobian[35][5] = 0.0;
        rJacobian[35][6] = 0.0;
        rJacobian[35][7] = 0.0;
        rJacobian[35][8] = 0.0;
        rJacobian[35][9] = 0.0;
        rJacobian[35][10] = 0.0;
        rJacobian[35][11] = 0.0;
        rJacobian[35][12] = 0.0;
        rJacobian[35][13] = 0.0;
        rJacobian[35][14] = 0.0;
        rJacobian[35][15] = 0.0;
        rJacobian[35][16] = 0.0;
        rJacobian[35][17] = 0.0;
        rJacobian[35][18] = 0.0;
        rJacobian[35][19] = 0.0;
        rJacobian[35][20] = 0.0;
        rJacobian[35][21] = 0.0;
        rJacobian[35][22] = 0.0;
        rJacobian[35][23] = 0.0;
        rJacobian[35][24] = 0.0;
        rJacobian[35][25] = 0.0;
        rJacobian[35][26] = 0.0;
        rJacobian[35][27] = 0.0;
        rJacobian[35][28] = 0.0;
        rJacobian[35][29] = 0.0;
        rJacobian[35][30] = -(mDt * (var_x128));
        rJacobian[35][31] = 0.0;
        rJacobian[35][32] = 0.0;
        rJacobian[35][33] = 0.0;
        rJacobian[35][34] = -(mDt * (var_x120));
        rJacobian[35][35] = 1.0 - (mDt * (-0.00015625 + var_x119));
        rJacobian[35][36] = 0.0;
        rJacobian[35][37] = 0.0;
        rJacobian[35][38] = 0.0;
        rJacobian[35][39] = 0.0;
        rJacobian[35][40] = 0.0;
        rJacobian[35][41] = 0.0;
        rJacobian[35][42] = 0.0;
        rJacobian[35][43] = 0.0;
        rJacobian[35][44] = 0.0;
        rJacobian[35][45] = 0.0;
        rJacobian[35][46] = 0.0;
        rJacobian[35][47] = 0.0;
        rJacobian[35][48] = 0.0;
        rJacobian[35][49] = 0.0;
        rJacobian[35][50] = 0.0;
        rJacobian[35][51] = 0.0;
        rJacobian[35][52] = 0.0;
        rJacobian[35][53] = 0.0;
        rJacobian[35][54] = 0.0;
        rJacobian[35][55] = 0.0;
        rJacobian[35][56] = 0.0;
        rJacobian[35][57] = 0.0;
        rJacobian[35][58] = 0.0;
        rJacobian[35][59] = 0.0;
        rJacobian[35][60] = 0.0;
        rJacobian[35][61] = 0.0;
        rJacobian[35][62] = 0.0;
        rJacobian[35][63] = 0.0;
        rJacobian[35][64] = 0.0;
        rJacobian[36][0] = 0.0;
        rJacobian[36][1] = 0.0;
        rJacobian[36][2] = 0.0;
        rJacobian[36][3] = 0.0;
        rJacobian[36][4] = 0.0;
        rJacobian[36][5] = 0.0;
        rJacobian[36][6] = 0.0;
        rJacobian[36][7] = 0.0;
        rJacobian[36][8] = 0.0;
        rJacobian[36][9] = 0.0;
        rJacobian[36][10] = 0.0;
        rJacobian[36][11] = 0.0;
        rJacobian[36][12] = 0.0;
        rJacobian[36][13] = 0.0;
        rJacobian[36][14] = 0.0;
        rJacobian[36][15] = 0.0;
        rJacobian[36][16] = 0.0;
        rJacobian[36][17] = 0.0;
        rJacobian[36][18] = 0.0;
        rJacobian[36][19] = 0.0;
        rJacobian[36][20] = 0.0;
        rJacobian[36][21] = 0.0;
        rJacobian[36][22] = 0.0;
        rJacobian[36][23] = 0.0;
        rJacobian[36][24] = 0.0;
        rJacobian[36][25] = 0.0;
        rJacobian[36][26] = 0.0;
        rJacobian[36][27] = 0.0;
        rJacobian[36][28] = 0.0;
        rJacobian[36][29] = 0.0;
        rJacobian[36][30] = -(mDt * (0.29999999999999999));
        rJacobian[36][31] = 0.0;
        rJacobian[36][32] = 0.0;
        rJacobian[36][33] = 0.0;
        rJacobian[36][34] = 0.0;
        rJacobian[36][35] = 0.0;
        rJacobian[36][36] = 1.0 - (mDt * (-4.0));
        rJacobian[36][37] = 0.0;
        rJacobian[36][38] = 0.0;
        rJacobian[36][39] = 0.0;
        rJacobian[36][40] = 0.0;
        rJacobian[36][41] = 0.0;
        rJacobian[36][42] = 0.0;
        rJacobian[36][43] = 0.0;
        rJacobian[36][44] = 0.0;
        rJacobian[36][45] = 0.0;
        rJacobian[36][46] = 0.0;
        rJacobian[36][47] = 0.0;
        rJacobian[36][48] = 0.0;
        rJacobian[36][49] = 0.0;
        rJacobian[36][50] = 0.0;
        rJacobian[36][51] = 0.0;
        rJacobian[36][52] = 0.0;
        rJacobian[36][53] = 0.0;
        rJacobian[36][54] = 0.0;
        rJacobian[36][55] = 0.0;
        rJacobian[36][56] = 0.0;
        rJacobian[36][57] = 0.0;
        rJacobian[36][58] = 0.0;
        rJacobian[36][59] = 0.0;
        rJacobian[36][60] = 0.0;
        rJacobian[36][61] = 0.0;
        rJacobian[36][62] = 0.0;
        rJacobian[36][63] = 0.0;
        rJacobian[36][64] = 0.0;
        rJacobian[37][0] = 0.0;
        rJacobian[37][1] = 0.0;
        rJacobian[37][2] = -(mDt * (-var_x134));
        rJacobian[37][3] = 0.0;
        rJacobian[37][4] = 0.0;
        rJacobian[37][5] = 0.0;
        rJacobian[37][6] = 0.0;
        rJacobian[37][7] = 0.0;
        rJacobian[37][8] = 0.0;
        rJacobian[37][9] = 0.0;
        rJacobian[37][10] = 0.0;
        rJacobian[37][11] = 0.0;
        rJacobian[37][12] = 0.0;
        rJacobian[37][13] = 0.0;
        rJacobian[37][14] = 0.0;
        rJacobian[37][15] = 0.0;
        rJacobian[37][16] = 0.0;
        rJacobian[37][17] = 0.0;
        rJacobian[37][18] = 0.0;
        rJacobian[37][19] = 0.0;
        rJacobian[37][20] = 0.0;
        rJacobian[37][21] = 0.0;
        rJacobian[37][22] = 0.0;
        rJacobian[37][23] = 0.0;
        rJacobian[37][24] = 0.0;
        rJacobian[37][25] = 0.0;
        rJacobian[37][26] = 0.0;
        rJacobian[37][27] = 0.0;
        rJacobian[37][28] = 0.0;
        rJacobian[37][29] = 0.0;
        rJacobian[37][30] = 0.0;
        rJacobian[37][31] = 0.0;
        rJacobian[37][32] = 0.0;
        rJacobian[37][33] = 0.0;
        rJacobian[37][34] = 0.0;
        rJacobian[37][35] = 0.0;
        rJacobian[37][36] = 0.0;
        rJacobian[37][37] = 1.0 - (mDt * (-var_x135));
        rJacobian[37][38] = 0.0;
        rJacobian[37][39] = -(mDt * (0.57599999999999996));
        rJacobian[37][40] = 0.0;
        rJacobian[37][41] = 0.0;
        rJacobian[37][42] = 0.0;
        rJacobian[37][43] = 0.0;
        rJacobian[37][44] = 0.0;
        rJacobian[37][45] = 0.0;
        rJacobian[37][46] = 0.0;
        rJacobian[37][47] = 0.0;
        rJacobian[37][48] = 0.0;
        rJacobian[37][49] = 0.0;
        rJacobian[37][50] = 0.0;
        rJacobian[37][51] = 0.0;
        rJacobian[37][52] = 0.0;
        rJacobian[37][53] = 0.0;
        rJacobian[37][54] = 0.0;
        rJacobian[37][55] = 0.0;
        rJacobian[37][56] = 0.0;
        rJacobian[37][57] = 0.0;
        rJacobian[37][58] = 0.0;
        rJacobian[37][59] = 0.0;
        rJacobian[37][60] = 0.0;
        rJacobian[37][61] = 0.0;
        rJacobian[37][62] = 0.0;
        rJacobian[37][63] = 0.0;
        rJacobian[37][64] = 0.0;
        rJacobian[38][0] = 0.0;
        rJacobian[38][1] = 0.0;
        rJacobian[38][2] = 0.0;
        rJacobian[38][3] = 0.0;
        rJacobian[38][4] = 0.0;
        rJacobian[38][5] = 0.0;
        rJacobian[38][6] = 0.0;
        rJacobian[38][7] = 0.0;
        rJacobian[38][8] = 0.0;
        rJacobian[38][9] = 0.0;
        rJacobian[38][10] = 0.0;
        rJacobian[38][11] = 0.0;
        rJacobian[38][12] = 0.0;
        rJacobian[38][13] = 0.0;
        rJacobian[38][14] = 0.0;
        rJacobian[38][15] = 0.0;
        rJacobian[38][16] = 0.0;
        rJacobian[38][17] = 0.0;
        rJacobian[38][18] = 0.0;
        rJacobian[38][19] = 0.0;
        rJacobian[38][20] = 0.0;
        rJacobian[38][21] = 0.0;
        rJacobian[38][22] = 0.0;
        rJacobian[38][23] = 0.0;
        rJacobian[38][24] = 0.0;
        rJacobian[38][25] = 0.0;
        rJacobian[38][26] = 0.0;
        rJacobian[38][27] = 0.0;
        rJacobian[38][28] = 0.0;
        rJacobian[38][29] = 0.0;
        rJacobian[38][30] = 0.0;
        rJacobian[38][31] = 0.0;
        rJacobian[38][32] = 0.0;
        rJacobian[38][33] = 0.0;
        rJacobian[38][34] = 0.0;
        rJacobian[38][35] = 0.0;
        rJacobian[38][36] = 0.0;
        rJacobian[38][37] = 0.0;
        rJacobian[38][38] = 1.0 - (mDt * (-0.00080000000000000004));
        rJacobian[38][39] = -(mDt * (0.10000000000000001));
        rJacobian[38][40] = 0.0;
        rJacobian[38][41] = 0.0;
        rJacobian[38][42] = 0.0;
        rJacobian[38][43] = 0.0;
        rJacobian[38][44] = 0.0;
        rJacobian[38][45] = 0.0;
        rJacobian[38][46] = 0.0;
        rJacobian[38][47] = 0.0;
        rJacobian[38][48] = 0.0;
        rJacobian[38][49] = 0.0;
        rJacobian[38][50] = 0.0;
        rJacobian[38][51] = 0.0;
        rJacobian[38][52] = 0.0;
        rJacobian[38][53] = 0.0;
        rJacobian[38][54] = 0.0;
        rJacobian[38][55] = 0.0;
        rJacobian[38][56] = 0.0;
        rJacobian[38][57] = 0.0;
        rJacobian[38][58] = 0.0;
        rJacobian[38][59] = 0.0;
        rJacobian[38][60] = 0.0;
        rJacobian[38][61] = 0.0;
        rJacobian[38][62] = 0.0;
        rJacobian[38][63] = 0.0;
        rJacobian[38][64] = 0.0;
        rJacobian[39][0] = 0.0;
        rJacobian[39][1] = 0.0;
        rJacobian[39][2] = -(mDt * (var_x134 - var_x136));
        rJacobian[39][3] = 0.0;
        rJacobian[39][4] = 0.0;
        rJacobian[39][5] = 0.0;
        rJacobian[39][6] = 0.0;
        rJacobian[39][7] = 0.0;
        rJacobian[39][8] = 0.0;
        rJacobian[39][9] = 0.0;
        rJacobian[39][10] = 0.0;
        rJacobian[39][11] = 0.0;
        rJacobian[39][12] = 0.0;
        rJacobian[39][13] = 0.0;
        rJacobian[39][14] = 0.0;
        rJacobian[39][15] = 0.0;
        rJacobian[39][16] = 0.0;
        rJacobian[39][17] = 0.0;
        rJacobian[39][18] = 0.0;
        rJacobian[39][19] = 0.0;
        rJacobian[39][20] = 0.0;
        rJacobian[39][21] = 0.0;
        rJacobian[39][22] = 0.0;
        rJacobian[39][23] = 0.0;
        rJacobian[39][24] = 0.0;
        rJacobian[39][25] = 0.0;
        rJacobian[39][26] = 0.0;
        rJacobian[39][27] = 0.0;
        rJacobian[39][28] = 0.0;
        rJacobian[39][29] = 0.0;
        rJacobian[39][30] = 0.0;
        rJacobian[39][31] = 0.0;
        rJacobian[39][32] = 0.0;
        rJacobian[39][33] = 0.0;
        rJacobian[39][34] = 0.0;
        rJacobian[39][35] = 0.0;
        rJacobian[39][36] = 0.0;
        rJacobian[39][37] = -(mDt * (var_x135));
        rJacobian[39][38] = -(mDt * (0.00080000000000000004));
        rJacobian[39][39] = 1.0 - (mDt * (-0.67599999999999993 - var_x137));
        rJacobian[39][40] = -(mDt * (1.9299999999999999));
        rJacobian[39][41] = 0.0;
        rJacobian[39][42] = 0.0;
        rJacobian[39][43] = 0.0;
        rJacobian[39][44] = 0.0;
        rJacobian[39][45] = 0.0;
        rJacobian[39][46] = 0.0;
        rJacobian[39][47] = 0.0;
        rJacobian[39][48] = 0.0;
        rJacobian[39][49] = 0.0;
        rJacobian[39][50] = 0.0;
        rJacobian[39][51] = 0.0;
        rJacobian[39][52] = 0.0;
        rJacobian[39][53] = 0.0;
        rJacobian[39][54] = 0.0;
        rJacobian[39][55] = 0.0;
        rJacobian[39][56] = 0.0;
        rJacobian[39][57] = 0.0;
        rJacobian[39][58] = 0.0;
        rJacobian[39][59] = 0.0;
        rJacobian[39][60] = 0.0;
        rJacobian[39][61] = 0.0;
        rJacobian[39][62] = 0.0;
        rJacobian[39][63] = 0.0;
        rJacobian[39][64] = 0.0;
        rJacobian[40][0] = 0.0;
        rJacobian[40][1] = 0.0;
        rJacobian[40][2] = -(mDt * (var_x136));
        rJacobian[40][3] = 0.0;
        rJacobian[40][4] = 0.0;
        rJacobian[40][5] = 0.0;
        rJacobian[40][6] = 0.0;
        rJacobian[40][7] = 0.0;
        rJacobian[40][8] = 0.0;
        rJacobian[40][9] = 0.0;
        rJacobian[40][10] = 0.0;
        rJacobian[40][11] = 0.0;
        rJacobian[40][12] = 0.0;
        rJacobian[40][13] = 0.0;
        rJacobian[40][14] = 0.0;
        rJacobian[40][15] = 0.0;
        rJacobian[40][16] = 0.0;
        rJacobian[40][17] = 0.0;
        rJacobian[40][18] = 0.0;
        rJacobian[40][19] = 0.0;
        rJacobian[40][20] = 0.0;
        rJacobian[40][21] = 0.0;
        rJacobian[40][22] = 0.0;
        rJacobian[40][23] = 0.0;
        rJacobian[40][24] = 0.0;
        rJacobian[40][25] = 0.0;
        rJacobian[40][26] = 0.0;
        rJacobian[40][27] = 0.0;
        rJacobian[40][28] = 0.0;
        rJacobian[40][29] = 0.0;
        rJacobian[40][30] = 0.0;
        rJacobian[40][31] = 0.0;
        rJacobian[40][32] = 0.0;
        rJacobian[40][33] = 0.0;
        rJacobian[40][34] = 0.0;
        rJacobian[40][35] = 0.0;
        rJacobian[40][36] = 0.0;
        rJacobian[40][37] = 0.0;
        rJacobian[40][38] = 0.0;
        rJacobian[40][39] = -(mDt * (var_x137));
        rJacobian[40][40] = 1.0 - (mDt * (-1.9299999999999999));
        rJacobian[40][41] = 0.0;
        rJacobian[40][42] = 0.0;
        rJacobian[40][43] = 0.0;
        rJacobian[40][44] = 0.0;
        rJacobian[40][45] = 0.0;
        rJacobian[40][46] = 0.0;
        rJacobian[40][47] = 0.0;
        rJacobian[40][48] = 0.0;
        rJacobian[40][49] = 0.0;
        rJacobian[40][50] = 0.0;
        rJacobian[40][51] = 0.0;
        rJacobian[40][52] = 0.0;
        rJacobian[40][53] = 0.0;
        rJacobian[40][54] = 0.0;
        rJacobian[40][55] = 0.0;
        rJacobian[40][56] = 0.0;
        rJacobian[40][57] = 0.0;
        rJacobian[40][58] = 0.0;
        rJacobian[40][59] = 0.0;
        rJacobian[40][60] = 0.0;
        rJacobian[40][61] = 0.0;
        rJacobian[40][62] = 0.0;
        rJacobian[40][63] = 0.0;
        rJacobian[40][64] = 0.0;
        rJacobian[41][0] = 0.0;
        rJacobian[41][1] = 0.0;
        rJacobian[41][2] = 0.0;
        rJacobian[41][3] = -(mDt * (20.0 - 20.0 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa));
        rJacobian[41][4] = 0.0;
        rJacobian[41][5] = 0.0;
        rJacobian[41][6] = 0.0;
        rJacobian[41][7] = 0.0;
        rJacobian[41][8] = 0.0;
        rJacobian[41][9] = 0.0;
        rJacobian[41][10] = 0.0;
        rJacobian[41][11] = 0.0;
        rJacobian[41][12] = 0.0;
        rJacobian[41][13] = 0.0;
        rJacobian[41][14] = 0.0;
        rJacobian[41][15] = 0.0;
        rJacobian[41][16] = 0.0;
        rJacobian[41][17] = 0.0;
        rJacobian[41][18] = 0.0;
        rJacobian[41][19] = 0.0;
        rJacobian[41][20] = 0.0;
        rJacobian[41][21] = 0.0;
        rJacobian[41][22] = 0.0;
        rJacobian[41][23] = 0.0;
        rJacobian[41][24] = 0.0;
        rJacobian[41][25] = 0.0;
        rJacobian[41][26] = 0.0;
        rJacobian[41][27] = 0.0;
        rJacobian[41][28] = 0.0;
        rJacobian[41][29] = 0.0;
        rJacobian[41][30] = 0.0;
        rJacobian[41][31] = 0.0;
        rJacobian[41][32] = 0.0;
        rJacobian[41][33] = 0.0;
        rJacobian[41][34] = 0.0;
        rJacobian[41][35] = 0.0;
        rJacobian[41][36] = 0.0;
        rJacobian[41][37] = 0.0;
        rJacobian[41][38] = 0.0;
        rJacobian[41][39] = 0.0;
        rJacobian[41][40] = 0.0;
        rJacobian[41][41] = 1.0 - (mDt * (-6.6000000000000005e-5 - 20.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai));
        rJacobian[41][42] = 0.0;
        rJacobian[41][43] = 0.0;
        rJacobian[41][44] = 0.0;
        rJacobian[41][45] = 0.0;
        rJacobian[41][46] = 0.0;
        rJacobian[41][47] = 0.0;
        rJacobian[41][48] = 0.0;
        rJacobian[41][49] = 0.0;
        rJacobian[41][50] = 0.0;
        rJacobian[41][51] = 0.0;
        rJacobian[41][52] = 0.0;
        rJacobian[41][53] = 0.0;
        rJacobian[41][54] = 0.0;
        rJacobian[41][55] = 0.0;
        rJacobian[41][56] = 0.0;
        rJacobian[41][57] = 0.0;
        rJacobian[41][58] = 0.0;
        rJacobian[41][59] = 0.0;
        rJacobian[41][60] = 0.0;
        rJacobian[41][61] = 0.0;
        rJacobian[41][62] = 0.0;
        rJacobian[41][63] = 0.0;
        rJacobian[41][64] = 0.0;
        rJacobian[42][0] = 0.0;
        rJacobian[42][1] = 0.0;
        rJacobian[42][2] = 0.0;
        rJacobian[42][3] = -(mDt * (40.0 - 40.0 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa));
        rJacobian[42][4] = 0.0;
        rJacobian[42][5] = 0.0;
        rJacobian[42][6] = 0.0;
        rJacobian[42][7] = 0.0;
        rJacobian[42][8] = 0.0;
        rJacobian[42][9] = 0.0;
        rJacobian[42][10] = 0.0;
        rJacobian[42][11] = 0.0;
        rJacobian[42][12] = 0.0;
        rJacobian[42][13] = 0.0;
        rJacobian[42][14] = 0.0;
        rJacobian[42][15] = 0.0;
        rJacobian[42][16] = 0.0;
        rJacobian[42][17] = 0.0;
        rJacobian[42][18] = 0.0;
        rJacobian[42][19] = 0.0;
        rJacobian[42][20] = 0.0;
        rJacobian[42][21] = 0.0;
        rJacobian[42][22] = 0.0;
        rJacobian[42][23] = 0.0;
        rJacobian[42][24] = 0.0;
        rJacobian[42][25] = 0.0;
        rJacobian[42][26] = 0.0;
        rJacobian[42][27] = 0.0;
        rJacobian[42][28] = 0.0;
        rJacobian[42][29] = 0.0;
        rJacobian[42][30] = 0.0;
        rJacobian[42][31] = 0.0;
        rJacobian[42][32] = 0.0;
        rJacobian[42][33] = 0.0;
        rJacobian[42][34] = 0.0;
        rJacobian[42][35] = 0.0;
        rJacobian[42][36] = 0.0;
        rJacobian[42][37] = 0.0;
        rJacobian[42][38] = 0.0;
        rJacobian[42][39] = 0.0;
        rJacobian[42][40] = 0.0;
        rJacobian[42][41] = 0.0;
        rJacobian[42][42] = 1.0 - (mDt * (-0.040000000000000001 - 40.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai));
        rJacobian[42][43] = 0.0;
        rJacobian[42][44] = 0.0;
        rJacobian[42][45] = 0.0;
        rJacobian[42][46] = 0.0;
        rJacobian[42][47] = 0.0;
        rJacobian[42][48] = 0.0;
        rJacobian[42][49] = 0.0;
        rJacobian[42][50] = 0.0;
        rJacobian[42][51] = 0.0;
        rJacobian[42][52] = 0.0;
        rJacobian[42][53] = 0.0;
        rJacobian[42][54] = 0.0;
        rJacobian[42][55] = 0.0;
        rJacobian[42][56] = 0.0;
        rJacobian[42][57] = 0.0;
        rJacobian[42][58] = 0.0;
        rJacobian[42][59] = 0.0;
        rJacobian[42][60] = 0.0;
        rJacobian[42][61] = 0.0;
        rJacobian[42][62] = 0.0;
        rJacobian[42][63] = 0.0;
        rJacobian[42][64] = 0.0;
        rJacobian[43][0] = 0.0;
        rJacobian[43][1] = 0.0;
        rJacobian[43][2] = 0.0;
        rJacobian[43][3] = 0.0;
        rJacobian[43][4] = 0.0;
        rJacobian[43][5] = 0.0;
        rJacobian[43][6] = 0.0;
        rJacobian[43][7] = 0.0;
        rJacobian[43][8] = 0.0;
        rJacobian[43][9] = 0.0;
        rJacobian[43][10] = 0.0;
        rJacobian[43][11] = 0.0;
        rJacobian[43][12] = 0.0;
        rJacobian[43][13] = 0.0;
        rJacobian[43][14] = 0.0;
        rJacobian[43][15] = 0.0;
        rJacobian[43][16] = 0.0;
        rJacobian[43][17] = 0.0;
        rJacobian[43][18] = 0.0;
        rJacobian[43][19] = 0.0;
        rJacobian[43][20] = 0.0;
        rJacobian[43][21] = 0.0;
        rJacobian[43][22] = 0.0;
        rJacobian[43][23] = 0.0;
        rJacobian[43][24] = 0.0;
        rJacobian[43][25] = 0.0;
        rJacobian[43][26] = 0.0;
        rJacobian[43][27] = 0.0;
        rJacobian[43][28] = 0.0;
        rJacobian[43][29] = 0.0;
        rJacobian[43][30] = 0.0;
        rJacobian[43][31] = 0.0;
        rJacobian[43][32] = 0.0;
        rJacobian[43][33] = 0.0;
        rJacobian[43][34] = 0.0;
        rJacobian[43][35] = 0.0;
        rJacobian[43][36] = 0.0;
        rJacobian[43][37] = 0.0;
        rJacobian[43][38] = 0.0;
        rJacobian[43][39] = 0.0;
        rJacobian[43][40] = 0.0;
        rJacobian[43][41] = 0.0;
        rJacobian[43][42] = 0.0;
        rJacobian[43][43] = 1.0 - (mDt * (-var_x138));
        rJacobian[43][44] = -(mDt * (var_x139));
        rJacobian[43][45] = 0.0;
        rJacobian[43][46] = 0.0;
        rJacobian[43][47] = 0.0;
        rJacobian[43][48] = 0.0;
        rJacobian[43][49] = 0.0;
        rJacobian[43][50] = 0.0;
        rJacobian[43][51] = 0.0;
        rJacobian[43][52] = 0.0;
        rJacobian[43][53] = 0.0;
        rJacobian[43][54] = 0.0;
        rJacobian[43][55] = 0.0;
        rJacobian[43][56] = 0.0;
        rJacobian[43][57] = 0.0;
        rJacobian[43][58] = 0.0;
        rJacobian[43][59] = 0.0;
        rJacobian[43][60] = 0.0;
        rJacobian[43][61] = 0.0;
        rJacobian[43][62] = 0.0;
        rJacobian[43][63] = 0.0;
        rJacobian[43][64] = 0.0;
        rJacobian[44][0] = 0.0;
        rJacobian[44][1] = 0.0;
        rJacobian[44][2] = 0.0;
        rJacobian[44][3] = 0.0;
        rJacobian[44][4] = 0.0;
        rJacobian[44][5] = 0.0;
        rJacobian[44][6] = 0.0;
        rJacobian[44][7] = 0.0;
        rJacobian[44][8] = 0.0;
        rJacobian[44][9] = 0.0;
        rJacobian[44][10] = 0.0;
        rJacobian[44][11] = 0.0;
        rJacobian[44][12] = 0.0;
        rJacobian[44][13] = 0.0;
        rJacobian[44][14] = 0.0;
        rJacobian[44][15] = 0.0;
        rJacobian[44][16] = 0.0;
        rJacobian[44][17] = 0.0;
        rJacobian[44][18] = 0.0;
        rJacobian[44][19] = 0.0;
        rJacobian[44][20] = 0.0;
        rJacobian[44][21] = 0.0;
        rJacobian[44][22] = 0.0;
        rJacobian[44][23] = 0.0;
        rJacobian[44][24] = 0.0;
        rJacobian[44][25] = 0.0;
        rJacobian[44][26] = 0.0;
        rJacobian[44][27] = 0.0;
        rJacobian[44][28] = 0.0;
        rJacobian[44][29] = 0.0;
        rJacobian[44][30] = 0.0;
        rJacobian[44][31] = 0.0;
        rJacobian[44][32] = 0.0;
        rJacobian[44][33] = 0.0;
        rJacobian[44][34] = 0.0;
        rJacobian[44][35] = 0.0;
        rJacobian[44][36] = 0.0;
        rJacobian[44][37] = 0.0;
        rJacobian[44][38] = 0.0;
        rJacobian[44][39] = 0.0;
        rJacobian[44][40] = 0.0;
        rJacobian[44][41] = 0.0;
        rJacobian[44][42] = 0.0;
        rJacobian[44][43] = -(mDt * (var_x138));
        rJacobian[44][44] = 1.0 - (mDt * (-0.13876486073161204 - var_x139));
        rJacobian[44][45] = -(mDt * (0.78911443677844384));
        rJacobian[44][46] = 0.0;
        rJacobian[44][47] = 0.0;
        rJacobian[44][48] = 0.0;
        rJacobian[44][49] = 0.0;
        rJacobian[44][50] = 0.0;
        rJacobian[44][51] = 0.0;
        rJacobian[44][52] = 0.0;
        rJacobian[44][53] = 0.0;
        rJacobian[44][54] = 0.0;
        rJacobian[44][55] = 0.0;
        rJacobian[44][56] = 0.0;
        rJacobian[44][57] = 0.0;
        rJacobian[44][58] = 0.0;
        rJacobian[44][59] = 0.0;
        rJacobian[44][60] = 0.0;
        rJacobian[44][61] = 0.0;
        rJacobian[44][62] = 0.0;
        rJacobian[44][63] = 0.0;
        rJacobian[44][64] = 0.0;
        rJacobian[45][0] = 0.0;
        rJacobian[45][1] = 0.0;
        rJacobian[45][2] = 0.0;
        rJacobian[45][3] = 0.0;
        rJacobian[45][4] = 0.0;
        rJacobian[45][5] = 0.0;
        rJacobian[45][6] = 0.0;
        rJacobian[45][7] = 0.0;
        rJacobian[45][8] = 0.0;
        rJacobian[45][9] = 0.0;
        rJacobian[45][10] = 0.0;
        rJacobian[45][11] = 0.0;
        rJacobian[45][12] = 0.0;
        rJacobian[45][13] = 0.0;
        rJacobian[45][14] = 0.0;
        rJacobian[45][15] = 0.0;
        rJacobian[45][16] = 0.0;
        rJacobian[45][17] = 0.0;
        rJacobian[45][18] = 0.0;
        rJacobian[45][19] = 0.0;
        rJacobian[45][20] = 0.0;
        rJacobian[45][21] = 0.0;
        rJacobian[45][22] = 0.0;
        rJacobian[45][23] = 0.0;
        rJacobian[45][24] = 0.0;
        rJacobian[45][25] = 0.0;
        rJacobian[45][26] = 0.0;
        rJacobian[45][27] = 0.0;
        rJacobian[45][28] = 0.0;
        rJacobian[45][29] = 0.0;
        rJacobian[45][30] = 0.0;
        rJacobian[45][31] = 0.0;
        rJacobian[45][32] = 0.0;
        rJacobian[45][33] = 0.0;
        rJacobian[45][34] = 0.0;
        rJacobian[45][35] = 0.0;
        rJacobian[45][36] = 0.0;
        rJacobian[45][37] = 0.0;
        rJacobian[45][38] = 0.0;
        rJacobian[45][39] = 0.0;
        rJacobian[45][40] = 0.0;
        rJacobian[45][41] = 0.0;
        rJacobian[45][42] = 0.0;
        rJacobian[45][43] = 0.0;
        rJacobian[45][44] = -(mDt * (0.13876486073161204));
        rJacobian[45][45] = 1.0 - (mDt * (-0.78911443677844384 - var_x141 - var_x143));
        rJacobian[45][46] = -(mDt * (var_x147));
        rJacobian[45][47] = -(mDt * (var_x148));
        rJacobian[45][48] = 0.0;
        rJacobian[45][49] = 0.0;
        rJacobian[45][50] = 0.0;
        rJacobian[45][51] = 0.0;
        rJacobian[45][52] = 0.0;
        rJacobian[45][53] = 0.0;
        rJacobian[45][54] = 0.0;
        rJacobian[45][55] = 0.0;
        rJacobian[45][56] = 0.0;
        rJacobian[45][57] = 0.0;
        rJacobian[45][58] = 0.0;
        rJacobian[45][59] = 0.0;
        rJacobian[45][60] = 0.0;
        rJacobian[45][61] = 0.0;
        rJacobian[45][62] = 0.0;
        rJacobian[45][63] = 0.0;
        rJacobian[45][64] = 0.0;
        rJacobian[46][0] = 0.0;
        rJacobian[46][1] = 0.0;
        rJacobian[46][2] = 0.0;
        rJacobian[46][3] = 0.0;
        rJacobian[46][4] = 0.0;
        rJacobian[46][5] = 0.0;
        rJacobian[46][6] = 0.0;
        rJacobian[46][7] = 0.0;
        rJacobian[46][8] = 0.0;
        rJacobian[46][9] = 0.0;
        rJacobian[46][10] = 0.0;
        rJacobian[46][11] = 0.0;
        rJacobian[46][12] = 0.0;
        rJacobian[46][13] = 0.0;
        rJacobian[46][14] = 0.0;
        rJacobian[46][15] = 0.0;
        rJacobian[46][16] = 0.0;
        rJacobian[46][17] = 0.0;
        rJacobian[46][18] = 0.0;
        rJacobian[46][19] = 0.0;
        rJacobian[46][20] = 0.0;
        rJacobian[46][21] = 0.0;
        rJacobian[46][22] = 0.0;
        rJacobian[46][23] = 0.0;
        rJacobian[46][24] = 0.0;
        rJacobian[46][25] = 0.0;
        rJacobian[46][26] = 0.0;
        rJacobian[46][27] = 0.0;
        rJacobian[46][28] = 0.0;
        rJacobian[46][29] = 0.0;
        rJacobian[46][30] = 0.0;
        rJacobian[46][31] = 0.0;
        rJacobian[46][32] = 0.0;
        rJacobian[46][33] = 0.0;
        rJacobian[46][34] = 0.0;
        rJacobian[46][35] = 0.0;
        rJacobian[46][36] = 0.0;
        rJacobian[46][37] = 0.0;
        rJacobian[46][38] = 0.0;
        rJacobian[46][39] = 0.0;
        rJacobian[46][40] = 0.0;
        rJacobian[46][41] = 0.0;
        rJacobian[46][42] = 0.0;
        rJacobian[46][43] = 0.0;
        rJacobian[46][44] = 0.0;
        rJacobian[46][45] = -(mDt * (var_x143));
        rJacobian[46][46] = 1.0 - (mDt * (-var_x147 - var_x149));
        rJacobian[46][47] = -(mDt * (var_x150));
        rJacobian[46][48] = 0.0;
        rJacobian[46][49] = 0.0;
        rJacobian[46][50] = 0.0;
        rJacobian[46][51] = 0.0;
        rJacobian[46][52] = 0.0;
        rJacobian[46][53] = 0.0;
        rJacobian[46][54] = 0.0;
        rJacobian[46][55] = 0.0;
        rJacobian[46][56] = 0.0;
        rJacobian[46][57] = 0.0;
        rJacobian[46][58] = 0.0;
        rJacobian[46][59] = 0.0;
        rJacobian[46][60] = 0.0;
        rJacobian[46][61] = 0.0;
        rJacobian[46][62] = 0.0;
        rJacobian[46][63] = 0.0;
        rJacobian[46][64] = 0.0;
        rJacobian[47][0] = 0.0;
        rJacobian[47][1] = 0.0;
        rJacobian[47][2] = 0.0;
        rJacobian[47][3] = 0.0;
        rJacobian[47][4] = 0.0;
        rJacobian[47][5] = 0.0;
        rJacobian[47][6] = 0.0;
        rJacobian[47][7] = 0.0;
        rJacobian[47][8] = 0.0;
        rJacobian[47][9] = 0.0;
        rJacobian[47][10] = 0.0;
        rJacobian[47][11] = 0.0;
        rJacobian[47][12] = 0.0;
        rJacobian[47][13] = 0.0;
        rJacobian[47][14] = 0.0;
        rJacobian[47][15] = 0.0;
        rJacobian[47][16] = 0.0;
        rJacobian[47][17] = 0.0;
        rJacobian[47][18] = 0.0;
        rJacobian[47][19] = 0.0;
        rJacobian[47][20] = 0.0;
        rJacobian[47][21] = 0.0;
        rJacobian[47][22] = 0.0;
        rJacobian[47][23] = 0.0;
        rJacobian[47][24] = 0.0;
        rJacobian[47][25] = 0.0;
        rJacobian[47][26] = 0.0;
        rJacobian[47][27] = 0.0;
        rJacobian[47][28] = 0.0;
        rJacobian[47][29] = 0.0;
        rJacobian[47][30] = 0.0;
        rJacobian[47][31] = 0.0;
        rJacobian[47][32] = 0.0;
        rJacobian[47][33] = 0.0;
        rJacobian[47][34] = 0.0;
        rJacobian[47][35] = 0.0;
        rJacobian[47][36] = 0.0;
        rJacobian[47][37] = 0.0;
        rJacobian[47][38] = 0.0;
        rJacobian[47][39] = 0.0;
        rJacobian[47][40] = 0.0;
        rJacobian[47][41] = 0.0;
        rJacobian[47][42] = 0.0;
        rJacobian[47][43] = 0.0;
        rJacobian[47][44] = 0.0;
        rJacobian[47][45] = -(mDt * (var_x141));
        rJacobian[47][46] = -(mDt * (var_x149));
        rJacobian[47][47] = 1.0 - (mDt * (-var_x148 - var_x150));
        rJacobian[47][48] = 0.0;
        rJacobian[47][49] = 0.0;
        rJacobian[47][50] = 0.0;
        rJacobian[47][51] = 0.0;
        rJacobian[47][52] = 0.0;
        rJacobian[47][53] = 0.0;
        rJacobian[47][54] = 0.0;
        rJacobian[47][55] = 0.0;
        rJacobian[47][56] = 0.0;
        rJacobian[47][57] = 0.0;
        rJacobian[47][58] = 0.0;
        rJacobian[47][59] = 0.0;
        rJacobian[47][60] = 0.0;
        rJacobian[47][61] = 0.0;
        rJacobian[47][62] = 0.0;
        rJacobian[47][63] = 0.0;
        rJacobian[47][64] = 0.0;
        rJacobian[48][0] = 0.0;
        rJacobian[48][1] = 0.0;
        rJacobian[48][2] = 0.0;
        rJacobian[48][3] = 0.0;
        rJacobian[48][4] = 0.0;
        rJacobian[48][5] = 0.0;
        rJacobian[48][6] = 0.0;
        rJacobian[48][7] = 0.0;
        rJacobian[48][8] = 0.0;
        rJacobian[48][9] = 0.0;
        rJacobian[48][10] = 0.0;
        rJacobian[48][11] = 0.0;
        rJacobian[48][12] = 0.0;
        rJacobian[48][13] = 0.0;
        rJacobian[48][14] = 0.0;
        rJacobian[48][15] = 0.0;
        rJacobian[48][16] = 0.0;
        rJacobian[48][17] = 0.0;
        rJacobian[48][18] = 0.0;
        rJacobian[48][19] = 0.0;
        rJacobian[48][20] = 0.0;
        rJacobian[48][21] = 0.0;
        rJacobian[48][22] = 0.0;
        rJacobian[48][23] = 0.0;
        rJacobian[48][24] = 0.0;
        rJacobian[48][25] = 0.0;
        rJacobian[48][26] = 0.0;
        rJacobian[48][27] = 0.0;
        rJacobian[48][28] = 0.0;
        rJacobian[48][29] = 0.0;
        rJacobian[48][30] = 0.0;
        rJacobian[48][31] = 0.0;
        rJacobian[48][32] = 0.0;
        rJacobian[48][33] = 0.0;
        rJacobian[48][34] = 0.0;
        rJacobian[48][35] = 0.0;
        rJacobian[48][36] = 0.0;
        rJacobian[48][37] = 0.0;
        rJacobian[48][38] = 0.0;
        rJacobian[48][39] = 0.0;
        rJacobian[48][40] = 0.0;
        rJacobian[48][41] = 0.0;
        rJacobian[48][42] = 0.0;
        rJacobian[48][43] = 0.0;
        rJacobian[48][44] = 0.0;
        rJacobian[48][45] = 0.0;
        rJacobian[48][46] = 0.0;
        rJacobian[48][47] = 0.0;
        rJacobian[48][48] = 1.0 - (mDt * (-0.0079560079800399999));
        rJacobian[48][49] = -(mDt * (var_x151));
        rJacobian[48][50] = 0.0;
        rJacobian[48][51] = 0.0;
        rJacobian[48][52] = 0.0;
        rJacobian[48][53] = 0.0;
        rJacobian[48][54] = 0.0;
        rJacobian[48][55] = 0.0;
        rJacobian[48][56] = 0.0;
        rJacobian[48][57] = 0.0;
        rJacobian[48][58] = 0.0;
        rJacobian[48][59] = 0.0;
        rJacobian[48][60] = 0.0;
        rJacobian[48][61] = 0.0;
        rJacobian[48][62] = 0.0;
        rJacobian[48][63] = 0.0;
        rJacobian[48][64] = 0.0;
        rJacobian[49][0] = 0.0;
        rJacobian[49][1] = 0.0;
        rJacobian[49][2] = 0.0;
        rJacobian[49][3] = 0.0;
        rJacobian[49][4] = 0.0;
        rJacobian[49][5] = 0.0;
        rJacobian[49][6] = 0.0;
        rJacobian[49][7] = 0.0;
        rJacobian[49][8] = 0.0;
        rJacobian[49][9] = 0.0;
        rJacobian[49][10] = 0.0;
        rJacobian[49][11] = 0.0;
        rJacobian[49][12] = 0.0;
        rJacobian[49][13] = 0.0;
        rJacobian[49][14] = 0.0;
        rJacobian[49][15] = 0.0;
        rJacobian[49][16] = 0.0;
        rJacobian[49][17] = 0.0;
        rJacobian[49][18] = 0.0;
        rJacobian[49][19] = 0.0;
        rJacobian[49][20] = 0.0;
        rJacobian[49][21] = 0.0;
        rJacobian[49][22] = 0.0;
        rJacobian[49][23] = 0.0;
        rJacobian[49][24] = 0.0;
        rJacobian[49][25] = 0.0;
        rJacobian[49][26] = 0.0;
        rJacobian[49][27] = 0.0;
        rJacobian[49][28] = 0.0;
        rJacobian[49][29] = 0.0;
        rJacobian[49][30] = 0.0;
        rJacobian[49][31] = 0.0;
        rJacobian[49][32] = 0.0;
        rJacobian[49][33] = 0.0;
        rJacobian[49][34] = 0.0;
        rJacobian[49][35] = 0.0;
        rJacobian[49][36] = 0.0;
        rJacobian[49][37] = 0.0;
        rJacobian[49][38] = 0.0;
        rJacobian[49][39] = 0.0;
        rJacobian[49][40] = 0.0;
        rJacobian[49][41] = 0.0;
        rJacobian[49][42] = 0.0;
        rJacobian[49][43] = 0.0;
        rJacobian[49][44] = 0.0;
        rJacobian[49][45] = 0.0;
        rJacobian[49][46] = 0.0;
        rJacobian[49][47] = 0.0;
        rJacobian[49][48] = -(mDt * (0.0079560079800399999));
        rJacobian[49][49] = 1.0 - (mDt * (-0.039667206760709998 - var_x151));
        rJacobian[49][50] = -(mDt * (var_x152));
        rJacobian[49][51] = 0.0;
        rJacobian[49][52] = 0.0;
        rJacobian[49][53] = 0.0;
        rJacobian[49][54] = 0.0;
        rJacobian[49][55] = 0.0;
        rJacobian[49][56] = 0.0;
        rJacobian[49][57] = 0.0;
        rJacobian[49][58] = 0.0;
        rJacobian[49][59] = 0.0;
        rJacobian[49][60] = 0.0;
        rJacobian[49][61] = 0.0;
        rJacobian[49][62] = 0.0;
        rJacobian[49][63] = 0.0;
        rJacobian[49][64] = 0.0;
        rJacobian[50][0] = 0.0;
        rJacobian[50][1] = 0.0;
        rJacobian[50][2] = 0.0;
        rJacobian[50][3] = 0.0;
        rJacobian[50][4] = 0.0;
        rJacobian[50][5] = 0.0;
        rJacobian[50][6] = 0.0;
        rJacobian[50][7] = 0.0;
        rJacobian[50][8] = 0.0;
        rJacobian[50][9] = 0.0;
        rJacobian[50][10] = 0.0;
        rJacobian[50][11] = 0.0;
        rJacobian[50][12] = 0.0;
        rJacobian[50][13] = 0.0;
        rJacobian[50][14] = 0.0;
        rJacobian[50][15] = 0.0;
        rJacobian[50][16] = 0.0;
        rJacobian[50][17] = 0.0;
        rJacobian[50][18] = 0.0;
        rJacobian[50][19] = 0.0;
        rJacobian[50][20] = 0.0;
        rJacobian[50][21] = 0.0;
        rJacobian[50][22] = 0.0;
        rJacobian[50][23] = 0.0;
        rJacobian[50][24] = 0.0;
        rJacobian[50][25] = 0.0;
        rJacobian[50][26] = 0.0;
        rJacobian[50][27] = 0.0;
        rJacobian[50][28] = 0.0;
        rJacobian[50][29] = 0.0;
        rJacobian[50][30] = 0.0;
        rJacobian[50][31] = 0.0;
        rJacobian[50][32] = 0.0;
        rJacobian[50][33] = 0.0;
        rJacobian[50][34] = 0.0;
        rJacobian[50][35] = 0.0;
        rJacobian[50][36] = 0.0;
        rJacobian[50][37] = 0.0;
        rJacobian[50][38] = 0.0;
        rJacobian[50][39] = 0.0;
        rJacobian[50][40] = 0.0;
        rJacobian[50][41] = 0.0;
        rJacobian[50][42] = 0.0;
        rJacobian[50][43] = 0.0;
        rJacobian[50][44] = 0.0;
        rJacobian[50][45] = 0.0;
        rJacobian[50][46] = 0.0;
        rJacobian[50][47] = 0.0;
        rJacobian[50][48] = 0.0;
        rJacobian[50][49] = -(mDt * (0.039667206760709998));
        rJacobian[50][50] = 1.0 - (mDt * (-var_x152 - var_x153));
        rJacobian[50][51] = -(mDt * (var_x154));
        rJacobian[50][52] = 0.0;
        rJacobian[50][53] = 0.0;
        rJacobian[50][54] = 0.0;
        rJacobian[50][55] = 0.0;
        rJacobian[50][56] = 0.0;
        rJacobian[50][57] = 0.0;
        rJacobian[50][58] = 0.0;
        rJacobian[50][59] = 0.0;
        rJacobian[50][60] = 0.0;
        rJacobian[50][61] = 0.0;
        rJacobian[50][62] = 0.0;
        rJacobian[50][63] = 0.0;
        rJacobian[50][64] = 0.0;
        rJacobian[51][0] = 0.0;
        rJacobian[51][1] = 0.0;
        rJacobian[51][2] = 0.0;
        rJacobian[51][3] = 0.0;
        rJacobian[51][4] = 0.0;
        rJacobian[51][5] = 0.0;
        rJacobian[51][6] = 0.0;
        rJacobian[51][7] = 0.0;
        rJacobian[51][8] = 0.0;
        rJacobian[51][9] = 0.0;
        rJacobian[51][10] = 0.0;
        rJacobian[51][11] = 0.0;
        rJacobian[51][12] = 0.0;
        rJacobian[51][13] = 0.0;
        rJacobian[51][14] = 0.0;
        rJacobian[51][15] = 0.0;
        rJacobian[51][16] = 0.0;
        rJacobian[51][17] = 0.0;
        rJacobian[51][18] = 0.0;
        rJacobian[51][19] = 0.0;
        rJacobian[51][20] = 0.0;
        rJacobian[51][21] = 0.0;
        rJacobian[51][22] = 0.0;
        rJacobian[51][23] = 0.0;
        rJacobian[51][24] = 0.0;
        rJacobian[51][25] = 0.0;
        rJacobian[51][26] = 0.0;
        rJacobian[51][27] = 0.0;
        rJacobian[51][28] = 0.0;
        rJacobian[51][29] = 0.0;
        rJacobian[51][30] = 0.0;
        rJacobian[51][31] = 0.0;
        rJacobian[51][32] = 0.0;
        rJacobian[51][33] = 0.0;
        rJacobian[51][34] = 0.0;
        rJacobian[51][35] = 0.0;
        rJacobian[51][36] = 0.0;
        rJacobian[51][37] = 0.0;
        rJacobian[51][38] = 0.0;
        rJacobian[51][39] = 0.0;
        rJacobian[51][40] = 0.0;
        rJacobian[51][41] = 0.0;
        rJacobian[51][42] = 0.0;
        rJacobian[51][43] = 0.0;
        rJacobian[51][44] = 0.0;
        rJacobian[51][45] = 0.0;
        rJacobian[51][46] = 0.0;
        rJacobian[51][47] = 0.0;
        rJacobian[51][48] = 0.0;
        rJacobian[51][49] = 0.0;
        rJacobian[51][50] = -(mDt * (var_x153));
        rJacobian[51][51] = 1.0 - (mDt * (-var_x154));
        rJacobian[51][52] = 0.0;
        rJacobian[51][53] = 0.0;
        rJacobian[51][54] = 0.0;
        rJacobian[51][55] = 0.0;
        rJacobian[51][56] = 0.0;
        rJacobian[51][57] = 0.0;
        rJacobian[51][58] = 0.0;
        rJacobian[51][59] = 0.0;
        rJacobian[51][60] = 0.0;
        rJacobian[51][61] = 0.0;
        rJacobian[51][62] = 0.0;
        rJacobian[51][63] = 0.0;
        rJacobian[51][64] = 0.0;
        rJacobian[52][0] = 0.0;
        rJacobian[52][1] = 0.0;
        rJacobian[52][2] = 0.0;
        rJacobian[52][3] = 0.0;
        rJacobian[52][4] = 0.0;
        rJacobian[52][5] = 0.0;
        rJacobian[52][6] = 0.0;
        rJacobian[52][7] = 0.0;
        rJacobian[52][8] = 0.0;
        rJacobian[52][9] = 0.0;
        rJacobian[52][10] = 0.0;
        rJacobian[52][11] = 0.0;
        rJacobian[52][12] = 0.0;
        rJacobian[52][13] = 0.0;
        rJacobian[52][14] = 0.0;
        rJacobian[52][15] = 0.0;
        rJacobian[52][16] = 0.0;
        rJacobian[52][17] = 0.0;
        rJacobian[52][18] = 0.0;
        rJacobian[52][19] = 0.0;
        rJacobian[52][20] = 0.0;
        rJacobian[52][21] = 0.0;
        rJacobian[52][22] = 0.0;
        rJacobian[52][23] = 0.0;
        rJacobian[52][24] = 0.0;
        rJacobian[52][25] = 0.0;
        rJacobian[52][26] = 0.0;
        rJacobian[52][27] = 0.0;
        rJacobian[52][28] = 0.0;
        rJacobian[52][29] = 0.0;
        rJacobian[52][30] = 0.0;
        rJacobian[52][31] = 0.0;
        rJacobian[52][32] = 0.0;
        rJacobian[52][33] = 0.0;
        rJacobian[52][34] = 0.0;
        rJacobian[52][35] = 0.0;
        rJacobian[52][36] = 0.0;
        rJacobian[52][37] = 0.0;
        rJacobian[52][38] = 0.0;
        rJacobian[52][39] = 0.0;
        rJacobian[52][40] = 0.0;
        rJacobian[52][41] = 0.0;
        rJacobian[52][42] = 0.0;
        rJacobian[52][43] = 0.0;
        rJacobian[52][44] = 0.0;
        rJacobian[52][45] = 0.0;
        rJacobian[52][46] = 0.0;
        rJacobian[52][47] = 0.0;
        rJacobian[52][48] = 0.0;
        rJacobian[52][49] = 0.0;
        rJacobian[52][50] = 0.0;
        rJacobian[52][51] = 0.0;
        rJacobian[52][52] = 1.0 - (mDt * (-var_x156 - var_x158));
        rJacobian[52][53] = 0.0;
        rJacobian[52][54] = 0.0;
        rJacobian[52][55] = 0.0;
        rJacobian[52][56] = 0.0;
        rJacobian[52][57] = -(mDt * (var_x160));
        rJacobian[52][58] = 0.0;
        rJacobian[52][59] = 0.0;
        rJacobian[52][60] = 0.0;
        rJacobian[52][61] = 0.0;
        rJacobian[52][62] = 0.0;
        rJacobian[52][63] = -(mDt * (var_x162));
        rJacobian[52][64] = 0.0;
        rJacobian[53][0] = 0.0;
        rJacobian[53][1] = 0.0;
        rJacobian[53][2] = 0.0;
        rJacobian[53][3] = 0.0;
        rJacobian[53][4] = 0.0;
        rJacobian[53][5] = 0.0;
        rJacobian[53][6] = 0.0;
        rJacobian[53][7] = 0.0;
        rJacobian[53][8] = 0.0;
        rJacobian[53][9] = 0.0;
        rJacobian[53][10] = 0.0;
        rJacobian[53][11] = 0.0;
        rJacobian[53][12] = 0.0;
        rJacobian[53][13] = 0.0;
        rJacobian[53][14] = 0.0;
        rJacobian[53][15] = 0.0;
        rJacobian[53][16] = 0.0;
        rJacobian[53][17] = 0.0;
        rJacobian[53][18] = 0.0;
        rJacobian[53][19] = 0.0;
        rJacobian[53][20] = 0.0;
        rJacobian[53][21] = 0.0;
        rJacobian[53][22] = 0.0;
        rJacobian[53][23] = 0.0;
        rJacobian[53][24] = 0.0;
        rJacobian[53][25] = 0.0;
        rJacobian[53][26] = 0.0;
        rJacobian[53][27] = 0.0;
        rJacobian[53][28] = 0.0;
        rJacobian[53][29] = 0.0;
        rJacobian[53][30] = 0.0;
        rJacobian[53][31] = 0.0;
        rJacobian[53][32] = 0.0;
        rJacobian[53][33] = 0.0;
        rJacobian[53][34] = 0.0;
        rJacobian[53][35] = 0.0;
        rJacobian[53][36] = 0.0;
        rJacobian[53][37] = 0.0;
        rJacobian[53][38] = 0.0;
        rJacobian[53][39] = 0.0;
        rJacobian[53][40] = 0.0;
        rJacobian[53][41] = 0.0;
        rJacobian[53][42] = 0.0;
        rJacobian[53][43] = 0.0;
        rJacobian[53][44] = 0.0;
        rJacobian[53][45] = 0.0;
        rJacobian[53][46] = 0.0;
        rJacobian[53][47] = 0.0;
        rJacobian[53][48] = 0.0;
        rJacobian[53][49] = 0.0;
        rJacobian[53][50] = 0.0;
        rJacobian[53][51] = 0.0;
        rJacobian[53][52] = 0.0;
        rJacobian[53][53] = 1.0 - (mDt * (-var_x163 - var_x164 - var_x165));
        rJacobian[53][54] = -(mDt * (var_x166));
        rJacobian[53][55] = 0.0;
        rJacobian[53][56] = 0.0;
        rJacobian[53][57] = 0.0;
        rJacobian[53][58] = -(mDt * (var_x167));
        rJacobian[53][59] = 0.0;
        rJacobian[53][60] = 0.0;
        rJacobian[53][61] = 0.0;
        rJacobian[53][62] = 0.0;
        rJacobian[53][63] = 0.0;
        rJacobian[53][64] = -(mDt * (var_x168));
        rJacobian[54][0] = 0.0;
        rJacobian[54][1] = 0.0;
        rJacobian[54][2] = 0.0;
        rJacobian[54][3] = 0.0;
        rJacobian[54][4] = 0.0;
        rJacobian[54][5] = 0.0;
        rJacobian[54][6] = 0.0;
        rJacobian[54][7] = 0.0;
        rJacobian[54][8] = 0.0;
        rJacobian[54][9] = 0.0;
        rJacobian[54][10] = 0.0;
        rJacobian[54][11] = 0.0;
        rJacobian[54][12] = 0.0;
        rJacobian[54][13] = 0.0;
        rJacobian[54][14] = 0.0;
        rJacobian[54][15] = 0.0;
        rJacobian[54][16] = 0.0;
        rJacobian[54][17] = 0.0;
        rJacobian[54][18] = 0.0;
        rJacobian[54][19] = 0.0;
        rJacobian[54][20] = 0.0;
        rJacobian[54][21] = 0.0;
        rJacobian[54][22] = 0.0;
        rJacobian[54][23] = 0.0;
        rJacobian[54][24] = 0.0;
        rJacobian[54][25] = 0.0;
        rJacobian[54][26] = 0.0;
        rJacobian[54][27] = 0.0;
        rJacobian[54][28] = 0.0;
        rJacobian[54][29] = 0.0;
        rJacobian[54][30] = 0.0;
        rJacobian[54][31] = 0.0;
        rJacobian[54][32] = 0.0;
        rJacobian[54][33] = 0.0;
        rJacobian[54][34] = 0.0;
        rJacobian[54][35] = 0.0;
        rJacobian[54][36] = 0.0;
        rJacobian[54][37] = 0.0;
        rJacobian[54][38] = 0.0;
        rJacobian[54][39] = 0.0;
        rJacobian[54][40] = 0.0;
        rJacobian[54][41] = 0.0;
        rJacobian[54][42] = 0.0;
        rJacobian[54][43] = 0.0;
        rJacobian[54][44] = 0.0;
        rJacobian[54][45] = 0.0;
        rJacobian[54][46] = 0.0;
        rJacobian[54][47] = 0.0;
        rJacobian[54][48] = 0.0;
        rJacobian[54][49] = 0.0;
        rJacobian[54][50] = 0.0;
        rJacobian[54][51] = 0.0;
        rJacobian[54][52] = 0.0;
        rJacobian[54][53] = -(mDt * (var_x164));
        rJacobian[54][54] = 1.0 - (mDt * (-var_x166 - var_x169 - var_x170));
        rJacobian[54][55] = -(mDt * (var_x171));
        rJacobian[54][56] = 0.0;
        rJacobian[54][57] = 0.0;
        rJacobian[54][58] = 0.0;
        rJacobian[54][59] = -(mDt * (var_x172));
        rJacobian[54][60] = 0.0;
        rJacobian[54][61] = 0.0;
        rJacobian[54][62] = 0.0;
        rJacobian[54][63] = 0.0;
        rJacobian[54][64] = 0.0;
        rJacobian[55][0] = 0.0;
        rJacobian[55][1] = 0.0;
        rJacobian[55][2] = 0.0;
        rJacobian[55][3] = 0.0;
        rJacobian[55][4] = 0.0;
        rJacobian[55][5] = 0.0;
        rJacobian[55][6] = 0.0;
        rJacobian[55][7] = 0.0;
        rJacobian[55][8] = 0.0;
        rJacobian[55][9] = 0.0;
        rJacobian[55][10] = 0.0;
        rJacobian[55][11] = 0.0;
        rJacobian[55][12] = 0.0;
        rJacobian[55][13] = 0.0;
        rJacobian[55][14] = 0.0;
        rJacobian[55][15] = 0.0;
        rJacobian[55][16] = 0.0;
        rJacobian[55][17] = 0.0;
        rJacobian[55][18] = 0.0;
        rJacobian[55][19] = 0.0;
        rJacobian[55][20] = 0.0;
        rJacobian[55][21] = 0.0;
        rJacobian[55][22] = 0.0;
        rJacobian[55][23] = 0.0;
        rJacobian[55][24] = 0.0;
        rJacobian[55][25] = 0.0;
        rJacobian[55][26] = 0.0;
        rJacobian[55][27] = 0.0;
        rJacobian[55][28] = 0.0;
        rJacobian[55][29] = 0.0;
        rJacobian[55][30] = 0.0;
        rJacobian[55][31] = 0.0;
        rJacobian[55][32] = 0.0;
        rJacobian[55][33] = 0.0;
        rJacobian[55][34] = 0.0;
        rJacobian[55][35] = 0.0;
        rJacobian[55][36] = 0.0;
        rJacobian[55][37] = 0.0;
        rJacobian[55][38] = 0.0;
        rJacobian[55][39] = 0.0;
        rJacobian[55][40] = 0.0;
        rJacobian[55][41] = 0.0;
        rJacobian[55][42] = 0.0;
        rJacobian[55][43] = 0.0;
        rJacobian[55][44] = 0.0;
        rJacobian[55][45] = 0.0;
        rJacobian[55][46] = 0.0;
        rJacobian[55][47] = 0.0;
        rJacobian[55][48] = 0.0;
        rJacobian[55][49] = 0.0;
        rJacobian[55][50] = 0.0;
        rJacobian[55][51] = 0.0;
        rJacobian[55][52] = 0.0;
        rJacobian[55][53] = 0.0;
        rJacobian[55][54] = -(mDt * (var_x169));
        rJacobian[55][55] = 1.0 - (mDt * (-var_x171 - var_x173 - var_x174));
        rJacobian[55][56] = -(mDt * (var_x175));
        rJacobian[55][57] = 0.0;
        rJacobian[55][58] = 0.0;
        rJacobian[55][59] = 0.0;
        rJacobian[55][60] = -(mDt * (var_x176));
        rJacobian[55][61] = 0.0;
        rJacobian[55][62] = 0.0;
        rJacobian[55][63] = 0.0;
        rJacobian[55][64] = 0.0;
        rJacobian[56][0] = 0.0;
        rJacobian[56][1] = 0.0;
        rJacobian[56][2] = 0.0;
        rJacobian[56][3] = 0.0;
        rJacobian[56][4] = 0.0;
        rJacobian[56][5] = 0.0;
        rJacobian[56][6] = 0.0;
        rJacobian[56][7] = 0.0;
        rJacobian[56][8] = 0.0;
        rJacobian[56][9] = 0.0;
        rJacobian[56][10] = 0.0;
        rJacobian[56][11] = 0.0;
        rJacobian[56][12] = 0.0;
        rJacobian[56][13] = 0.0;
        rJacobian[56][14] = 0.0;
        rJacobian[56][15] = 0.0;
        rJacobian[56][16] = 0.0;
        rJacobian[56][17] = 0.0;
        rJacobian[56][18] = 0.0;
        rJacobian[56][19] = 0.0;
        rJacobian[56][20] = 0.0;
        rJacobian[56][21] = 0.0;
        rJacobian[56][22] = 0.0;
        rJacobian[56][23] = 0.0;
        rJacobian[56][24] = 0.0;
        rJacobian[56][25] = 0.0;
        rJacobian[56][26] = 0.0;
        rJacobian[56][27] = 0.0;
        rJacobian[56][28] = 0.0;
        rJacobian[56][29] = 0.0;
        rJacobian[56][30] = 0.0;
        rJacobian[56][31] = 0.0;
        rJacobian[56][32] = 0.0;
        rJacobian[56][33] = 0.0;
        rJacobian[56][34] = 0.0;
        rJacobian[56][35] = 0.0;
        rJacobian[56][36] = 0.0;
        rJacobian[56][37] = 0.0;
        rJacobian[56][38] = 0.0;
        rJacobian[56][39] = 0.0;
        rJacobian[56][40] = 0.0;
        rJacobian[56][41] = 0.0;
        rJacobian[56][42] = 0.0;
        rJacobian[56][43] = 0.0;
        rJacobian[56][44] = 0.0;
        rJacobian[56][45] = 0.0;
        rJacobian[56][46] = 0.0;
        rJacobian[56][47] = 0.0;
        rJacobian[56][48] = 0.0;
        rJacobian[56][49] = 0.0;
        rJacobian[56][50] = 0.0;
        rJacobian[56][51] = 0.0;
        rJacobian[56][52] = 0.0;
        rJacobian[56][53] = 0.0;
        rJacobian[56][54] = 0.0;
        rJacobian[56][55] = -(mDt * (var_x174));
        rJacobian[56][56] = 1.0 - (mDt * (-var_x175 - var_x177));
        rJacobian[56][57] = 0.0;
        rJacobian[56][58] = 0.0;
        rJacobian[56][59] = 0.0;
        rJacobian[56][60] = 0.0;
        rJacobian[56][61] = -(mDt * (var_x178));
        rJacobian[56][62] = 0.0;
        rJacobian[56][63] = 0.0;
        rJacobian[56][64] = 0.0;
        rJacobian[57][0] = 0.0;
        rJacobian[57][1] = 0.0;
        rJacobian[57][2] = 0.0;
        rJacobian[57][3] = 0.0;
        rJacobian[57][4] = 0.0;
        rJacobian[57][5] = 0.0;
        rJacobian[57][6] = 0.0;
        rJacobian[57][7] = 0.0;
        rJacobian[57][8] = 0.0;
        rJacobian[57][9] = 0.0;
        rJacobian[57][10] = 0.0;
        rJacobian[57][11] = 0.0;
        rJacobian[57][12] = 0.0;
        rJacobian[57][13] = 0.0;
        rJacobian[57][14] = 0.0;
        rJacobian[57][15] = 0.0;
        rJacobian[57][16] = 0.0;
        rJacobian[57][17] = 0.0;
        rJacobian[57][18] = 0.0;
        rJacobian[57][19] = 0.0;
        rJacobian[57][20] = 0.0;
        rJacobian[57][21] = 0.0;
        rJacobian[57][22] = 0.0;
        rJacobian[57][23] = 0.0;
        rJacobian[57][24] = 0.0;
        rJacobian[57][25] = 0.0;
        rJacobian[57][26] = 0.0;
        rJacobian[57][27] = 0.0;
        rJacobian[57][28] = 0.0;
        rJacobian[57][29] = 0.0;
        rJacobian[57][30] = 0.0;
        rJacobian[57][31] = 0.0;
        rJacobian[57][32] = 0.0;
        rJacobian[57][33] = 0.0;
        rJacobian[57][34] = 0.0;
        rJacobian[57][35] = 0.0;
        rJacobian[57][36] = 0.0;
        rJacobian[57][37] = 0.0;
        rJacobian[57][38] = 0.0;
        rJacobian[57][39] = 0.0;
        rJacobian[57][40] = 0.0;
        rJacobian[57][41] = 0.0;
        rJacobian[57][42] = 0.0;
        rJacobian[57][43] = 0.0;
        rJacobian[57][44] = 0.0;
        rJacobian[57][45] = 0.0;
        rJacobian[57][46] = 0.0;
        rJacobian[57][47] = 0.0;
        rJacobian[57][48] = 0.0;
        rJacobian[57][49] = 0.0;
        rJacobian[57][50] = 0.0;
        rJacobian[57][51] = 0.0;
        rJacobian[57][52] = -(mDt * (var_x158));
        rJacobian[57][53] = 0.0;
        rJacobian[57][54] = 0.0;
        rJacobian[57][55] = 0.0;
        rJacobian[57][56] = 0.0;
        rJacobian[57][57] = 1.0 - (mDt * (-var_x160 - var_x179 - var_x180));
        rJacobian[57][58] = -(mDt * (var_x181));
        rJacobian[57][59] = 0.0;
        rJacobian[57][60] = 0.0;
        rJacobian[57][61] = 0.0;
        rJacobian[57][62] = 0.0;
        rJacobian[57][63] = 0.0;
        rJacobian[57][64] = -(mDt * (var_x182));
        rJacobian[58][0] = 0.0;
        rJacobian[58][1] = 0.0;
        rJacobian[58][2] = 0.0;
        rJacobian[58][3] = 0.0;
        rJacobian[58][4] = 0.0;
        rJacobian[58][5] = 0.0;
        rJacobian[58][6] = 0.0;
        rJacobian[58][7] = 0.0;
        rJacobian[58][8] = 0.0;
        rJacobian[58][9] = 0.0;
        rJacobian[58][10] = 0.0;
        rJacobian[58][11] = 0.0;
        rJacobian[58][12] = 0.0;
        rJacobian[58][13] = 0.0;
        rJacobian[58][14] = 0.0;
        rJacobian[58][15] = 0.0;
        rJacobian[58][16] = 0.0;
        rJacobian[58][17] = 0.0;
        rJacobian[58][18] = 0.0;
        rJacobian[58][19] = 0.0;
        rJacobian[58][20] = 0.0;
        rJacobian[58][21] = 0.0;
        rJacobian[58][22] = 0.0;
        rJacobian[58][23] = 0.0;
        rJacobian[58][24] = 0.0;
        rJacobian[58][25] = 0.0;
        rJacobian[58][26] = 0.0;
        rJacobian[58][27] = 0.0;
        rJacobian[58][28] = 0.0;
        rJacobian[58][29] = 0.0;
        rJacobian[58][30] = 0.0;
        rJacobian[58][31] = 0.0;
        rJacobian[58][32] = 0.0;
        rJacobian[58][33] = 0.0;
        rJacobian[58][34] = 0.0;
        rJacobian[58][35] = 0.0;
        rJacobian[58][36] = 0.0;
        rJacobian[58][37] = 0.0;
        rJacobian[58][38] = 0.0;
        rJacobian[58][39] = 0.0;
        rJacobian[58][40] = 0.0;
        rJacobian[58][41] = 0.0;
        rJacobian[58][42] = 0.0;
        rJacobian[58][43] = 0.0;
        rJacobian[58][44] = 0.0;
        rJacobian[58][45] = 0.0;
        rJacobian[58][46] = 0.0;
        rJacobian[58][47] = 0.0;
        rJacobian[58][48] = 0.0;
        rJacobian[58][49] = 0.0;
        rJacobian[58][50] = 0.0;
        rJacobian[58][51] = 0.0;
        rJacobian[58][52] = 0.0;
        rJacobian[58][53] = -(mDt * (var_x163));
        rJacobian[58][54] = 0.0;
        rJacobian[58][55] = 0.0;
        rJacobian[58][56] = 0.0;
        rJacobian[58][57] = -(mDt * (var_x180));
        rJacobian[58][58] = 1.0 - (mDt * (-var_x167 - var_x181 - var_x183));
        rJacobian[58][59] = -(mDt * (var_x184));
        rJacobian[58][60] = 0.0;
        rJacobian[58][61] = 0.0;
        rJacobian[58][62] = 0.0;
        rJacobian[58][63] = 0.0;
        rJacobian[58][64] = 0.0;
        rJacobian[59][0] = 0.0;
        rJacobian[59][1] = 0.0;
        rJacobian[59][2] = 0.0;
        rJacobian[59][3] = 0.0;
        rJacobian[59][4] = 0.0;
        rJacobian[59][5] = 0.0;
        rJacobian[59][6] = 0.0;
        rJacobian[59][7] = 0.0;
        rJacobian[59][8] = 0.0;
        rJacobian[59][9] = 0.0;
        rJacobian[59][10] = 0.0;
        rJacobian[59][11] = 0.0;
        rJacobian[59][12] = 0.0;
        rJacobian[59][13] = 0.0;
        rJacobian[59][14] = 0.0;
        rJacobian[59][15] = 0.0;
        rJacobian[59][16] = 0.0;
        rJacobian[59][17] = 0.0;
        rJacobian[59][18] = 0.0;
        rJacobian[59][19] = 0.0;
        rJacobian[59][20] = 0.0;
        rJacobian[59][21] = 0.0;
        rJacobian[59][22] = 0.0;
        rJacobian[59][23] = 0.0;
        rJacobian[59][24] = 0.0;
        rJacobian[59][25] = 0.0;
        rJacobian[59][26] = 0.0;
        rJacobian[59][27] = 0.0;
        rJacobian[59][28] = 0.0;
        rJacobian[59][29] = 0.0;
        rJacobian[59][30] = 0.0;
        rJacobian[59][31] = 0.0;
        rJacobian[59][32] = 0.0;
        rJacobian[59][33] = 0.0;
        rJacobian[59][34] = 0.0;
        rJacobian[59][35] = 0.0;
        rJacobian[59][36] = 0.0;
        rJacobian[59][37] = 0.0;
        rJacobian[59][38] = 0.0;
        rJacobian[59][39] = 0.0;
        rJacobian[59][40] = 0.0;
        rJacobian[59][41] = 0.0;
        rJacobian[59][42] = 0.0;
        rJacobian[59][43] = 0.0;
        rJacobian[59][44] = 0.0;
        rJacobian[59][45] = 0.0;
        rJacobian[59][46] = 0.0;
        rJacobian[59][47] = 0.0;
        rJacobian[59][48] = 0.0;
        rJacobian[59][49] = 0.0;
        rJacobian[59][50] = 0.0;
        rJacobian[59][51] = 0.0;
        rJacobian[59][52] = 0.0;
        rJacobian[59][53] = 0.0;
        rJacobian[59][54] = -(mDt * (var_x170));
        rJacobian[59][55] = 0.0;
        rJacobian[59][56] = 0.0;
        rJacobian[59][57] = 0.0;
        rJacobian[59][58] = -(mDt * (var_x183));
        rJacobian[59][59] = 1.0 - (mDt * (-var_x172 - var_x184 - var_x185));
        rJacobian[59][60] = -(mDt * (var_x186));
        rJacobian[59][61] = 0.0;
        rJacobian[59][62] = 0.0;
        rJacobian[59][63] = 0.0;
        rJacobian[59][64] = 0.0;
        rJacobian[60][0] = 0.0;
        rJacobian[60][1] = 0.0;
        rJacobian[60][2] = 0.0;
        rJacobian[60][3] = 0.0;
        rJacobian[60][4] = 0.0;
        rJacobian[60][5] = 0.0;
        rJacobian[60][6] = 0.0;
        rJacobian[60][7] = 0.0;
        rJacobian[60][8] = 0.0;
        rJacobian[60][9] = 0.0;
        rJacobian[60][10] = 0.0;
        rJacobian[60][11] = 0.0;
        rJacobian[60][12] = 0.0;
        rJacobian[60][13] = 0.0;
        rJacobian[60][14] = 0.0;
        rJacobian[60][15] = 0.0;
        rJacobian[60][16] = 0.0;
        rJacobian[60][17] = 0.0;
        rJacobian[60][18] = 0.0;
        rJacobian[60][19] = 0.0;
        rJacobian[60][20] = 0.0;
        rJacobian[60][21] = 0.0;
        rJacobian[60][22] = 0.0;
        rJacobian[60][23] = 0.0;
        rJacobian[60][24] = 0.0;
        rJacobian[60][25] = 0.0;
        rJacobian[60][26] = 0.0;
        rJacobian[60][27] = 0.0;
        rJacobian[60][28] = 0.0;
        rJacobian[60][29] = 0.0;
        rJacobian[60][30] = 0.0;
        rJacobian[60][31] = 0.0;
        rJacobian[60][32] = 0.0;
        rJacobian[60][33] = 0.0;
        rJacobian[60][34] = 0.0;
        rJacobian[60][35] = 0.0;
        rJacobian[60][36] = 0.0;
        rJacobian[60][37] = 0.0;
        rJacobian[60][38] = 0.0;
        rJacobian[60][39] = 0.0;
        rJacobian[60][40] = 0.0;
        rJacobian[60][41] = 0.0;
        rJacobian[60][42] = 0.0;
        rJacobian[60][43] = 0.0;
        rJacobian[60][44] = 0.0;
        rJacobian[60][45] = 0.0;
        rJacobian[60][46] = 0.0;
        rJacobian[60][47] = 0.0;
        rJacobian[60][48] = 0.0;
        rJacobian[60][49] = 0.0;
        rJacobian[60][50] = 0.0;
        rJacobian[60][51] = 0.0;
        rJacobian[60][52] = 0.0;
        rJacobian[60][53] = 0.0;
        rJacobian[60][54] = 0.0;
        rJacobian[60][55] = -(mDt * (var_x173));
        rJacobian[60][56] = 0.0;
        rJacobian[60][57] = 0.0;
        rJacobian[60][58] = 0.0;
        rJacobian[60][59] = -(mDt * (var_x185));
        rJacobian[60][60] = 1.0 - (mDt * (-var_x176 - var_x186 - var_x187 - var_x188));
        rJacobian[60][61] = -(mDt * (var_x189));
        rJacobian[60][62] = -(mDt * (var_x190));
        rJacobian[60][63] = 0.0;
        rJacobian[60][64] = 0.0;
        rJacobian[61][0] = 0.0;
        rJacobian[61][1] = 0.0;
        rJacobian[61][2] = 0.0;
        rJacobian[61][3] = 0.0;
        rJacobian[61][4] = 0.0;
        rJacobian[61][5] = 0.0;
        rJacobian[61][6] = 0.0;
        rJacobian[61][7] = 0.0;
        rJacobian[61][8] = 0.0;
        rJacobian[61][9] = 0.0;
        rJacobian[61][10] = 0.0;
        rJacobian[61][11] = 0.0;
        rJacobian[61][12] = 0.0;
        rJacobian[61][13] = 0.0;
        rJacobian[61][14] = 0.0;
        rJacobian[61][15] = 0.0;
        rJacobian[61][16] = 0.0;
        rJacobian[61][17] = 0.0;
        rJacobian[61][18] = 0.0;
        rJacobian[61][19] = 0.0;
        rJacobian[61][20] = 0.0;
        rJacobian[61][21] = 0.0;
        rJacobian[61][22] = 0.0;
        rJacobian[61][23] = 0.0;
        rJacobian[61][24] = 0.0;
        rJacobian[61][25] = 0.0;
        rJacobian[61][26] = 0.0;
        rJacobian[61][27] = 0.0;
        rJacobian[61][28] = 0.0;
        rJacobian[61][29] = 0.0;
        rJacobian[61][30] = 0.0;
        rJacobian[61][31] = 0.0;
        rJacobian[61][32] = 0.0;
        rJacobian[61][33] = 0.0;
        rJacobian[61][34] = 0.0;
        rJacobian[61][35] = 0.0;
        rJacobian[61][36] = 0.0;
        rJacobian[61][37] = 0.0;
        rJacobian[61][38] = 0.0;
        rJacobian[61][39] = 0.0;
        rJacobian[61][40] = 0.0;
        rJacobian[61][41] = 0.0;
        rJacobian[61][42] = 0.0;
        rJacobian[61][43] = 0.0;
        rJacobian[61][44] = 0.0;
        rJacobian[61][45] = 0.0;
        rJacobian[61][46] = 0.0;
        rJacobian[61][47] = 0.0;
        rJacobian[61][48] = 0.0;
        rJacobian[61][49] = 0.0;
        rJacobian[61][50] = 0.0;
        rJacobian[61][51] = 0.0;
        rJacobian[61][52] = 0.0;
        rJacobian[61][53] = 0.0;
        rJacobian[61][54] = 0.0;
        rJacobian[61][55] = 0.0;
        rJacobian[61][56] = -(mDt * (var_x177));
        rJacobian[61][57] = 0.0;
        rJacobian[61][58] = 0.0;
        rJacobian[61][59] = 0.0;
        rJacobian[61][60] = -(mDt * (var_x187));
        rJacobian[61][61] = 1.0 - (mDt * (-var_x178 - var_x189 - var_x191));
        rJacobian[61][62] = -(mDt * (var_x192));
        rJacobian[61][63] = 0.0;
        rJacobian[61][64] = 0.0;
        rJacobian[62][0] = 0.0;
        rJacobian[62][1] = 0.0;
        rJacobian[62][2] = 0.0;
        rJacobian[62][3] = 0.0;
        rJacobian[62][4] = 0.0;
        rJacobian[62][5] = 0.0;
        rJacobian[62][6] = 0.0;
        rJacobian[62][7] = 0.0;
        rJacobian[62][8] = 0.0;
        rJacobian[62][9] = 0.0;
        rJacobian[62][10] = 0.0;
        rJacobian[62][11] = 0.0;
        rJacobian[62][12] = 0.0;
        rJacobian[62][13] = 0.0;
        rJacobian[62][14] = 0.0;
        rJacobian[62][15] = 0.0;
        rJacobian[62][16] = 0.0;
        rJacobian[62][17] = 0.0;
        rJacobian[62][18] = 0.0;
        rJacobian[62][19] = 0.0;
        rJacobian[62][20] = 0.0;
        rJacobian[62][21] = 0.0;
        rJacobian[62][22] = 0.0;
        rJacobian[62][23] = 0.0;
        rJacobian[62][24] = 0.0;
        rJacobian[62][25] = 0.0;
        rJacobian[62][26] = 0.0;
        rJacobian[62][27] = 0.0;
        rJacobian[62][28] = 0.0;
        rJacobian[62][29] = 0.0;
        rJacobian[62][30] = 0.0;
        rJacobian[62][31] = 0.0;
        rJacobian[62][32] = 0.0;
        rJacobian[62][33] = 0.0;
        rJacobian[62][34] = 0.0;
        rJacobian[62][35] = 0.0;
        rJacobian[62][36] = 0.0;
        rJacobian[62][37] = 0.0;
        rJacobian[62][38] = 0.0;
        rJacobian[62][39] = 0.0;
        rJacobian[62][40] = 0.0;
        rJacobian[62][41] = 0.0;
        rJacobian[62][42] = 0.0;
        rJacobian[62][43] = 0.0;
        rJacobian[62][44] = 0.0;
        rJacobian[62][45] = 0.0;
        rJacobian[62][46] = 0.0;
        rJacobian[62][47] = 0.0;
        rJacobian[62][48] = 0.0;
        rJacobian[62][49] = 0.0;
        rJacobian[62][50] = 0.0;
        rJacobian[62][51] = 0.0;
        rJacobian[62][52] = 0.0;
        rJacobian[62][53] = 0.0;
        rJacobian[62][54] = 0.0;
        rJacobian[62][55] = 0.0;
        rJacobian[62][56] = 0.0;
        rJacobian[62][57] = 0.0;
        rJacobian[62][58] = 0.0;
        rJacobian[62][59] = 0.0;
        rJacobian[62][60] = -(mDt * (var_x188));
        rJacobian[62][61] = -(mDt * (var_x191));
        rJacobian[62][62] = 1.0 - (mDt * (-var_x190 - var_x192));
        rJacobian[62][63] = 0.0;
        rJacobian[62][64] = 0.0;
        rJacobian[63][0] = 0.0;
        rJacobian[63][1] = 0.0;
        rJacobian[63][2] = 0.0;
        rJacobian[63][3] = 0.0;
        rJacobian[63][4] = 0.0;
        rJacobian[63][5] = 0.0;
        rJacobian[63][6] = 0.0;
        rJacobian[63][7] = 0.0;
        rJacobian[63][8] = 0.0;
        rJacobian[63][9] = 0.0;
        rJacobian[63][10] = 0.0;
        rJacobian[63][11] = 0.0;
        rJacobian[63][12] = 0.0;
        rJacobian[63][13] = 0.0;
        rJacobian[63][14] = 0.0;
        rJacobian[63][15] = 0.0;
        rJacobian[63][16] = 0.0;
        rJacobian[63][17] = 0.0;
        rJacobian[63][18] = 0.0;
        rJacobian[63][19] = 0.0;
        rJacobian[63][20] = 0.0;
        rJacobian[63][21] = 0.0;
        rJacobian[63][22] = 0.0;
        rJacobian[63][23] = 0.0;
        rJacobian[63][24] = 0.0;
        rJacobian[63][25] = 0.0;
        rJacobian[63][26] = 0.0;
        rJacobian[63][27] = 0.0;
        rJacobian[63][28] = 0.0;
        rJacobian[63][29] = 0.0;
        rJacobian[63][30] = 0.0;
        rJacobian[63][31] = 0.0;
        rJacobian[63][32] = 0.0;
        rJacobian[63][33] = 0.0;
        rJacobian[63][34] = 0.0;
        rJacobian[63][35] = 0.0;
        rJacobian[63][36] = 0.0;
        rJacobian[63][37] = 0.0;
        rJacobian[63][38] = 0.0;
        rJacobian[63][39] = 0.0;
        rJacobian[63][40] = 0.0;
        rJacobian[63][41] = 0.0;
        rJacobian[63][42] = 0.0;
        rJacobian[63][43] = 0.0;
        rJacobian[63][44] = 0.0;
        rJacobian[63][45] = 0.0;
        rJacobian[63][46] = 0.0;
        rJacobian[63][47] = 0.0;
        rJacobian[63][48] = 0.0;
        rJacobian[63][49] = 0.0;
        rJacobian[63][50] = 0.0;
        rJacobian[63][51] = 0.0;
        rJacobian[63][52] = -(mDt * (var_x156));
        rJacobian[63][53] = 0.0;
        rJacobian[63][54] = 0.0;
        rJacobian[63][55] = 0.0;
        rJacobian[63][56] = 0.0;
        rJacobian[63][57] = 0.0;
        rJacobian[63][58] = 0.0;
        rJacobian[63][59] = 0.0;
        rJacobian[63][60] = 0.0;
        rJacobian[63][61] = 0.0;
        rJacobian[63][62] = 0.0;
        rJacobian[63][63] = 1.0 - (mDt * (-var_x162 - var_x193));
        rJacobian[63][64] = -(mDt * (var_x194));
        rJacobian[64][0] = 0.0;
        rJacobian[64][1] = 0.0;
        rJacobian[64][2] = 0.0;
        rJacobian[64][3] = 0.0;
        rJacobian[64][4] = 0.0;
        rJacobian[64][5] = 0.0;
        rJacobian[64][6] = 0.0;
        rJacobian[64][7] = 0.0;
        rJacobian[64][8] = 0.0;
        rJacobian[64][9] = 0.0;
        rJacobian[64][10] = 0.0;
        rJacobian[64][11] = 0.0;
        rJacobian[64][12] = 0.0;
        rJacobian[64][13] = 0.0;
        rJacobian[64][14] = 0.0;
        rJacobian[64][15] = 0.0;
        rJacobian[64][16] = 0.0;
        rJacobian[64][17] = 0.0;
        rJacobian[64][18] = 0.0;
        rJacobian[64][19] = 0.0;
        rJacobian[64][20] = 0.0;
        rJacobian[64][21] = 0.0;
        rJacobian[64][22] = 0.0;
        rJacobian[64][23] = 0.0;
        rJacobian[64][24] = 0.0;
        rJacobian[64][25] = 0.0;
        rJacobian[64][26] = 0.0;
        rJacobian[64][27] = 0.0;
        rJacobian[64][28] = 0.0;
        rJacobian[64][29] = 0.0;
        rJacobian[64][30] = 0.0;
        rJacobian[64][31] = 0.0;
        rJacobian[64][32] = 0.0;
        rJacobian[64][33] = 0.0;
        rJacobian[64][34] = 0.0;
        rJacobian[64][35] = 0.0;
        rJacobian[64][36] = 0.0;
        rJacobian[64][37] = 0.0;
        rJacobian[64][38] = 0.0;
        rJacobian[64][39] = 0.0;
        rJacobian[64][40] = 0.0;
        rJacobian[64][41] = 0.0;
        rJacobian[64][42] = 0.0;
        rJacobian[64][43] = 0.0;
        rJacobian[64][44] = 0.0;
        rJacobian[64][45] = 0.0;
        rJacobian[64][46] = 0.0;
        rJacobian[64][47] = 0.0;
        rJacobian[64][48] = 0.0;
        rJacobian[64][49] = 0.0;
        rJacobian[64][50] = 0.0;
        rJacobian[64][51] = 0.0;
        rJacobian[64][52] = 0.0;
        rJacobian[64][53] = -(mDt * (var_x165));
        rJacobian[64][54] = 0.0;
        rJacobian[64][55] = 0.0;
        rJacobian[64][56] = 0.0;
        rJacobian[64][57] = -(mDt * (var_x179));
        rJacobian[64][58] = 0.0;
        rJacobian[64][59] = 0.0;
        rJacobian[64][60] = 0.0;
        rJacobian[64][61] = 0.0;
        rJacobian[64][62] = 0.0;
        rJacobian[64][63] = -(mDt * (var_x193));
        rJacobian[64][64] = 1.0 - (mDt * (-var_x168 - var_x182 - var_x194));
    }

    void Celliyer_model_2004FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // mV / ms
        
        rY[0] += mDt*d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
    }
    
    void Celliyer_model_2004FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf = 0.81999999999999995;
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa = 1 / (0.0033633620945199998 / (0.5 + exp(-0.18053804430634462 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)) + 0.0077904657073700001 * exp(-0.02019777813343069 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V));
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf = 1.0 - var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf / (1.0 + exp(3.6538461538461537 + 0.12820512820512822 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V));
        
        
        rY[24] = (var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa + ((var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa) * mDt)) / (1.0 - ((-1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa) * mDt));
        
        double _guess[65] = {rY[5],rY[6],rY[4],rY[3],rY[2],rY[1],rY[35],rY[36],rY[37],rY[38],rY[40],rY[41],rY[42],rY[43],rY[44],rY[39],rY[25],rY[26],rY[27],rY[28],rY[30],rY[31],rY[32],rY[33],rY[34],rY[29],rY[13],rY[14],rY[15],rY[16],rY[17],rY[18],rY[19],rY[20],rY[21],rY[22],rY[23],rY[9],rY[11],rY[12],rY[10],rY[8],rY[7],rY[58],rY[59],rY[60],rY[62],rY[61],rY[63],rY[64],rY[65],rY[66],rY[45],rY[54],rY[55],rY[56],rY[57],rY[46],rY[47],rY[48],rY[49],rY[50],rY[51],rY[52],rY[53]};
        CardiacNewtonSolver<65,Celliyer_model_2004FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<65,Celliyer_model_2004FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[5] = _guess[0];
        rY[6] = _guess[1];
        rY[4] = _guess[2];
        rY[3] = _guess[3];
        rY[2] = _guess[4];
        rY[1] = _guess[5];
        rY[35] = _guess[6];
        rY[36] = _guess[7];
        rY[37] = _guess[8];
        rY[38] = _guess[9];
        rY[40] = _guess[10];
        rY[41] = _guess[11];
        rY[42] = _guess[12];
        rY[43] = _guess[13];
        rY[44] = _guess[14];
        rY[39] = _guess[15];
        rY[25] = _guess[16];
        rY[26] = _guess[17];
        rY[27] = _guess[18];
        rY[28] = _guess[19];
        rY[30] = _guess[20];
        rY[31] = _guess[21];
        rY[32] = _guess[22];
        rY[33] = _guess[23];
        rY[34] = _guess[24];
        rY[29] = _guess[25];
        rY[13] = _guess[26];
        rY[14] = _guess[27];
        rY[15] = _guess[28];
        rY[16] = _guess[29];
        rY[17] = _guess[30];
        rY[18] = _guess[31];
        rY[19] = _guess[32];
        rY[20] = _guess[33];
        rY[21] = _guess[34];
        rY[22] = _guess[35];
        rY[23] = _guess[36];
        rY[9] = _guess[37];
        rY[11] = _guess[38];
        rY[12] = _guess[39];
        rY[10] = _guess[40];
        rY[8] = _guess[41];
        rY[7] = _guess[42];
        rY[58] = _guess[43];
        rY[59] = _guess[44];
        rY[60] = _guess[45];
        rY[62] = _guess[46];
        rY[61] = _guess[47];
        rY[63] = _guess[48];
        rY[64] = _guess[49];
        rY[65] = _guess[50];
        rY[66] = _guess[51];
        rY[45] = _guess[52];
        rY[54] = _guess[53];
        rY[55] = _guess[54];
        rY[56] = _guess[55];
        rY[57] = _guess[56];
        rY[46] = _guess[57];
        rY[47] = _guess[58];
        rY[48] = _guess[59];
        rY[49] = _guess[60];
        rY[50] = _guess[61];
        rY[51] = _guess[62];
        rY[52] = _guess[63];
        rY[53] = _guess[64];
    }

    std::vector<double> Celliyer_model_2004FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_I_stimulus__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celliyer_model_2004FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "iyer_model_2004";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-90.65755929);

    // rY[1]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.798304162);

    // rY[2]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(125.5589432);

    // rY[3]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(8.601192016e-05);

    // rY[4]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.0001420215245);

    // rY[5]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.2852239446);

    // rY[6]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.2855294915);

    // rY[7]:
    this->mVariableNames.push_back("COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.08046584973);

    // rY[8]:
    this->mVariableNames.push_back("COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9772152481);

    // rY[9]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4448038946);

    // rY[10]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.97392006e-09);

    // rY[11]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.554535924);

    // rY[12]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006601783287);

    // rY[13]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8621934054);

    // rY[14]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01141398211);

    // rY[15]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.666325225e-05);

    // rY[16]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.25021357e-07);

    // rY[17]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.034426748e-10);

    // rY[18]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1198547081);

    // rY[19]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.006346794302);

    // rY[20]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001260326488);

    // rY[21]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.112315238e-06);

    // rY[22]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.681315892e-09);

    // rY[23]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.757981563e-12);

    // rY[24]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9997157074);

    // rY[25]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9513721351);

    // rY[26]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02668288089);

    // rY[27]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002806380358);

    // rY[28]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.311837579e-06);

    // rY[29]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.29955624e-09);

    // rY[30]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01513025204);

    // rY[31]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005442964601);

    // rY[32]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0009918373359);

    // rY[33]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.514386057e-05);

    // rY[34]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.742677382e-06);

    // rY[35]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5977099765);

    // rY[36]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1730990528);

    // rY[37]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01881072386);

    // rY[38]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000916070135);

    // rY[39]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.975541357e-05);

    // rY[40]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03539084346);

    // rY[41]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005428824353);

    // rY[42]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02287858869);

    // rY[43]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03233800003);

    // rY[44]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1134082058);

    // rY[45]:
    this->mVariableNames.push_back("INa__na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1437575649);

    // rY[46]:
    this->mVariableNames.push_back("INa__na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0417776208);

    // rY[47]:
    this->mVariableNames.push_back("INa__na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004552898364);

    // rY[48]:
    this->mVariableNames.push_back("INa__na4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000220520743);

    // rY[49]:
    this->mVariableNames.push_back("INa__na5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.005266484e-06);

    // rY[50]:
    this->mVariableNames.push_back("INa__na6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.57442749e-08);

    // rY[51]:
    this->mVariableNames.push_back("INa__na7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.856607179e-09);

    // rY[52]:
    this->mVariableNames.push_back("INa__na8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4749950008);

    // rY[53]:
    this->mVariableNames.push_back("INa__na9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2707214097);

    // rY[54]:
    this->mVariableNames.push_back("INa__na10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05786120057);

    // rY[55]:
    this->mVariableNames.push_back("INa__na11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005496292279);

    // rY[56]:
    this->mVariableNames.push_back("INa__na12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001957874519);

    // rY[57]:
    this->mVariableNames.push_back("INa__na13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417679396);

    // rY[58]:
    this->mVariableNames.push_back("IKr__C1Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.996697338);

    // rY[59]:
    this->mVariableNames.push_back("IKr__C2Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004340879648);

    // rY[60]:
    this->mVariableNames.push_back("IKr__C3Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.634099755e-05);

    // rY[61]:
    this->mVariableNames.push_back("IKr__OHerg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.511789113e-06);

    // rY[62]:
    this->mVariableNames.push_back("IKr__IHerg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.533347007e-06);

    // rY[63]:
    this->mVariableNames.push_back("IKs__C0ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9645606295);

    // rY[64]:
    this->mVariableNames.push_back("IKs__C1ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03542613568);

    // rY[65]:
    this->mVariableNames.push_back("IKs__O1ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.491710696e-07);

    // rY[66]:
    this->mVariableNames.push_back("IKs__O2ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.298547822e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celliyer_model_2004FromCellMLBackwardEuler)
