//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: hund_rudy_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "hund_rudy_2004_a.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellhund_rudy_2004_aFromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellhund_rudy_2004_aFromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellhund_rudy_2004_aFromCellMLBackwardEuler::Cellhund_rudy_2004_aFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<13>(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_ICaL__G_CaL_mult) [dimensionless]
        this->mParameters[1] = 1.0; // (var_INa__G_Na_mult) [dimensionless]
        this->mParameters[2] = 1.0; // (var_IKr__G_Kr_mult) [dimensionless]
    }

    Cellhund_rudy_2004_aFromCellMLBackwardEuler::~Cellhund_rudy_2004_aFromCellMLBackwardEuler()
    {
    }
    
    double Cellhund_rudy_2004_aFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__Cl_o = 100.0; // mM
        const double var_Environment__F = 96485.0; // C_per_mole
        const double var_Environment__FonRT = 0.0374358835078; // per_mV
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 140.0; // mM
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__gacai = 1.0; // dimensionless
        const double var_ICaL__gacao = 0.34100000000000003; // dimensionless
        const double var_ICaL__pca = 0.000243; // L_per_F_ms
        const double var_IClb__GClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKr__gkr = 0.0059618984305585326 * sqrt(var_Environment__K_o); // mS_per_uF
        const double var_IKs__gks = 0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INa__GNa = ((var_Environment__tissue == 0) ? (8.25) : (33.0)); // mS_per_uF
        const double var_INa__gNa = pow(var_chaste_interface__INa__m, 3) * var_INa__GNa * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mS_per_uF
        const double var_INaCa__KmCa = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__NCXmax = 4.5; // uA_per_uF
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__allo = 1 / (1.0 + pow(var_INaCa__KmCa, 2) / pow(var_INaCa__ca_i_NaCa, 2)); // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__ibarnak = 0.61875000000000002; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 10.0; // mM
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INal__GNaL = 0.0064999999999999997; // mS_per_uF
        const double var_IpCa__ibarpca = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__kmpca = 0.00050000000000000001; // mM
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__ibarpca / (var_chaste_interface__Ca__Ca_i + var_IpCa__kmpca); // uA_per_uF
        const double var_Ito__gitodv = 0.19; // mS_per_uF
        const double var_Ito2__PCl = 3.9999999999999998e-7; // L_per_F_ms
        const double var_INaCa__denom2 = pow(var_INaCa__KmNao, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_INaCa__ca_i_NaCa / var_INaCa__KmCai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__denom3 = pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o + pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_ICaL__ibarca = 4.0 * (-15.0 + var_chaste_interface__cell__V) * (-var_Environment__Ca_o * var_ICaL__gacao + var_chaste_interface__Ca__Ca_ss * var_ICaL__gacai * exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)) * var_Environment__F * var_Environment__FonRT * mParameters[0] * var_ICaL__pca / (-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICab__ICab = 7.9803360000000004e-7 * (-0.34100000000000003 * var_Environment__Ca_o + var_chaste_interface__Ca__Ca_i * exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)) * var_Environment__F * var_Environment__FonRT * var_chaste_interface__cell__V / (-1.0 + exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__denom1 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__num = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(var_Environment__FonRT * var_INaCa__eta * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__INaCa = var_INaCa__NCXmax * var_INaCa__allo * var_INaCa__num / ((var_INaCa__denom2 + var_INaCa__denom3) * var_INaCa__denom1); // uA_per_uF
        const double var_INaK__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__INaK = var_Environment__K_o * var_INaK__fnak * var_INaK__ibarnak / ((1.0 + pow(var_INaK__kmnai, 2) / pow(var_chaste_interface__Na__Na_i, 2)) * (var_Environment__K_o + var_INaK__kmko)); // uA_per_uF
        const double var_Ito__rv = exp(0.0033333333333333335 * var_chaste_interface__cell__V); // dimensionless
        const double var_Ito2__Ito2_max = (-var_Environment__Cl_o * exp(var_Environment__FonRT * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_Environment__F * var_Environment__FonRT * var_Ito2__PCl * var_chaste_interface__cell__V / (1.0 - exp(var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Ito2__Ito2 = var_chaste_interface__Ito2__AA * var_Ito2__Ito2_max; // uA_per_uF
        const double var_cell__caiont = -2.0 * var_INaCa__INaCa + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_cell__i_Stim = 0.0; // uA_per_uF
        const double var_reversal_potentials__ECl = -log(var_Environment__Cl_o / var_chaste_interface__Cl__Cl_i) / var_Environment__FonRT; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__cell__V) * var_IClb__GClb; // uA_per_uF
        const double var_cell__clont = 0.5 * var_cell__i_Stim + var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = log(var_Environment__K_o / var_chaste_interface__K__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__ak1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)); // per_ms
        const double var_IK1__bk1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__IK1 = 0.21516574145596759 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_IK1__ak1 / (var_IK1__ak1 + var_IK1__bk1); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_IKr__gkr * var_IKr__r * var_chaste_interface__IKr__xr; // uA_per_uF
        const double var_Ito__Ito = pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_Ito__gitodv * var_Ito__rv * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv; // uA_per_uF
        const double var_reversal_potentials__ENa = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__INa = (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * mParameters[1] * var_INa__gNa; // uA_per_uF
        const double var_INal__INal = pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_INal__GNaL * var_chaste_interface__INal__hL; // uA_per_uF
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INal__INal; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = log((var_Environment__Na_o * var_reversal_potentials__prnak + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__cell__V) * var_IKs__gks * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito__Ito; // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_cell__caiont + var_cell__clont + var_cell__kiont + var_cell__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellhund_rudy_2004_aFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__Environment__time, const double rCurrentGuess[13], double rResidual[13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__Ca__Ca_i = rCurrentGuess[0];
        double var_chaste_interface__Ca__Ca_jsr = rCurrentGuess[1];
        double var_chaste_interface__Ca__Ca_nsr = rCurrentGuess[2];
        double var_chaste_interface__Ca__Ca_ss = rCurrentGuess[3];
        double var_chaste_interface__Cl__Cl_i = rCurrentGuess[4];
        double var_chaste_interface__ICaL__fca = rCurrentGuess[5];
        double var_chaste_interface__ICaL__fca2 = rCurrentGuess[6];
        double var_chaste_interface__Irel__CaMKtrap = rCurrentGuess[7];
        double var_chaste_interface__Irel__ri = rCurrentGuess[8];
        double var_chaste_interface__Irel__ro = rCurrentGuess[9];
        double var_chaste_interface__Ito2__AA = rCurrentGuess[10];
        double var_chaste_interface__K__K_i = rCurrentGuess[11];
        double var_chaste_interface__Na__Na_i = rCurrentGuess[12];
        
        //output_equations
        const double var_Ca__BSLmax = 1.1240000000000001; // mM
        const double var_Ca__BSRmax = 0.047; // mM
        const double var_Ca__KmBSL = 0.0086999999999999994; // mM
        const double var_Ca__KmBSR = 0.00087000000000000001; // mM
        const double var_Ca__bss = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__cbar = 0.050000000000000003; // mM
        const double var_Ca__csqnbar = 10.0; // mM
        const double var_Ca__kmc = 0.0023800000000000002; // mM
        const double var_Ca__kmcsqn = 0.80000000000000004; // mM
        const double var_Ca__bcsqn = 1 / (1.0 + var_Ca__csqnbar * var_Ca__kmcsqn / pow((var_chaste_interface__Ca__Ca_jsr + var_Ca__kmcsqn), 2)); // dimensionless
        const double var_Ca__kmt = 0.00050000000000000001; // mM
        const double var_Ca__tbar = 0.070000000000000007; // mM
        const double var_Ca__bmyo = 1 / (1.0 + var_Ca__cbar * var_Ca__kmc / pow((var_chaste_interface__Ca__Ca_i + var_Ca__kmc), 2) + var_Ca__kmt * var_Ca__tbar / pow((var_chaste_interface__Ca__Ca_i + var_Ca__kmt), 2)); // dimensionless
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__Cl_o = 100.0; // mM
        const double var_Environment__F = 96485.0; // C_per_mole
        const double var_Environment__FonRT = 0.0374358835078; // per_mV
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 140.0; // mM
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__gacai = 1.0; // dimensionless
        const double var_ICaL__gacao = 0.34100000000000003; // dimensionless
        const double var_ICaL__pca = 0.000243; // L_per_F_ms
        const double var_IClb__GClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKr__gkr = 0.0059618984305585326 * sqrt(var_Environment__K_o); // mS_per_uF
        const double var_IKs__gks = 0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INa__GNa = ((var_Environment__tissue == 0) ? (8.25) : (33.0)); // mS_per_uF
        const double var_INa__gNa = pow(var_chaste_interface__INa__m, 3) * var_INa__GNa * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mS_per_uF
        const double var_INaCa__KmCa = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__NCXmax = 4.5; // uA_per_uF
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__allo = 1 / (1.0 + pow(var_INaCa__KmCa, 2) / pow(var_INaCa__ca_i_NaCa, 2)); // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__ibarnak = 0.61875000000000002; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 10.0; // mM
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INal__GNaL = 0.0064999999999999997; // mS_per_uF
        const double var_Idiff_Itr__idiff = 5.0 * var_chaste_interface__Ca__Ca_ss - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_Idiff_Itr__itr = 0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr; // mM_per_ms
        const double var_IpCa__ibarpca = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__kmpca = 0.00050000000000000001; // mM
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__ibarpca / (var_chaste_interface__Ca__Ca_i + var_IpCa__kmpca); // uA_per_uF
        const double var_Irel__CaMK0 = 0.050000000000000003; // dimensionless
        const double var_Irel__Km = 0.0015; // mM
        const double var_Irel__CaMKbound = (1.0 - var_chaste_interface__Irel__CaMKtrap) * var_Irel__CaMK0 / (1.0 + var_Irel__Km / var_chaste_interface__Ca__Ca_ss); // dimensionless
        const double var_Irel__CaMKactive = var_Irel__CaMKbound + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double d_dt_chaste_interface_var_Irel__CaMKtrap = -0.00068000000000000005 * var_chaste_interface__Irel__CaMKtrap + 0.050000000000000003 * (-var_chaste_interface__Irel__CaMKtrap + var_Irel__CaMKactive) * var_Irel__CaMKactive; // 1 / ms
        const double var_ICaL__taufca = 0.5 + 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive); // ms
        const double var_Irel__KmCaMK = 0.14999999999999999; // dimensionless
        const double var_Irel__dro_inf = pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) / (pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) + 1644.6531773416521 * pow((var_chaste_interface__Ca__Ca_ss / (0.0028 + var_chaste_interface__Ca__Ca_ss)), 1.8999999999999999)); // dimensionless
        const double var_Irel__dtau_rel_max = 10.0; // ms
        const double var_Irel__dtau_rel = var_Irel__CaMKactive * var_Irel__dtau_rel_max / (var_Irel__CaMKactive + var_Irel__KmCaMK); // ms
        const double var_Ito__gitodv = 0.19; // mS_per_uF
        const double var_Ito2__Kmto2 = 0.1502; // mM
        const double var_Ito2__AAss = 1 / (1.0 + var_Ito2__Kmto2 / var_chaste_interface__Ca__Ca_ss); // dimensionless
        const double d_dt_chaste_interface_var_Ito2__AA = var_Ito2__AAss - 1.0 * var_chaste_interface__Ito2__AA; // 1 / ms
        const double var_Ito2__PCl = 3.9999999999999998e-7; // L_per_F_ms
        const double var_Iup_Ileak__Kmup = 0.00092000000000000003; // mM
        const double var_Iup_Ileak__dJupmax = 0.75; // dimensionless
        const double var_Iup_Ileak__dJup = var_Irel__CaMKactive * var_Iup_Ileak__dJupmax / (var_Irel__CaMKactive + var_Irel__KmCaMK); // dimensionless
        const double var_Iup_Ileak__dKmPLBmax = 0.00017000000000000001; // mM
        const double var_Iup_Ileak__dKmPLB = var_Irel__CaMKactive * var_Iup_Ileak__dKmPLBmax / (var_Irel__CaMKactive + var_Irel__KmCaMK); // mM
        const double var_Iup_Ileak__iupmax = 0.0043750000000000004; // mM_per_ms
        const double var_Iup_Ileak__iup = (1.0 + var_Iup_Ileak__dJup) * var_chaste_interface__Ca__Ca_i * var_Iup_Ileak__iupmax / (-var_Iup_Ileak__dKmPLB + var_chaste_interface__Ca__Ca_i + var_Iup_Ileak__Kmup); // mM_per_ms
        const double var_Iup_Ileak__nsrmax = 15.0; // mM
        const double var_Iup_Ileak__ileak = var_chaste_interface__Ca__Ca_nsr * var_Iup_Ileak__iupmax / var_Iup_Ileak__nsrmax; // mM_per_ms
        const double var_K__CTKClmax = 7.0755999999999996e-6; // mM_per_ms
        const double var_Na__CTNaClmax = 9.8442999999999999e-6; // mM_per_ms
        const double var_INaCa__denom2 = pow(var_INaCa__KmNao, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_INaCa__ca_i_NaCa / var_INaCa__KmCai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__denom3 = pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o + pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_ICaL__ibarca = 4.0 * (-15.0 + var_chaste_interface__cell__V) * (-var_Environment__Ca_o * var_ICaL__gacao + var_chaste_interface__Ca__Ca_ss * var_ICaL__gacai * exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)) * var_Environment__F * var_Environment__FonRT * mParameters[0] * var_ICaL__pca / (-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICaL__fca2ss = 1 / (1.0 - 100.0 * var_ICaL__ICaL); // dimensionless
        const double var_ICaL__fcass = 0.14999999999999999 + 0.55000000000000004 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 0.29999999999999999 / (1.0 - 20.0 * var_ICaL__ICaL); // dimensionless
        const double d_dt_chaste_interface_var_ICaL__fca = (-var_chaste_interface__ICaL__fca + var_ICaL__fcass) / var_ICaL__taufca; // 1 / ms
        const double var_ICaL__taufca2 = 125.0 + 300.0 / (1.0 + exp(-4.375 - 25.0 * var_ICaL__ICaL)); // ms
        const double d_dt_chaste_interface_var_ICaL__fca2 = (-var_chaste_interface__ICaL__fca2 + var_ICaL__fca2ss) / var_ICaL__taufca2; // 1 / ms
        const double var_ICab__ICab = 7.9803360000000004e-7 * (-0.34100000000000003 * var_Environment__Ca_o + var_chaste_interface__Ca__Ca_i * exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)) * var_Environment__F * var_Environment__FonRT * var_chaste_interface__cell__V / (-1.0 + exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__denom1 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__num = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(var_Environment__FonRT * var_INaCa__eta * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__INaCa = var_INaCa__NCXmax * var_INaCa__allo * var_INaCa__num / ((var_INaCa__denom2 + var_INaCa__denom3) * var_INaCa__denom1); // uA_per_uF
        const double var_INaK__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__INaK = var_Environment__K_o * var_INaK__fnak * var_INaK__ibarnak / ((1.0 + pow(var_INaK__kmnai, 2) / pow(var_chaste_interface__Na__Na_i, 2)) * (var_Environment__K_o + var_INaK__kmko)); // uA_per_uF
        const double var_Irel__cafac = 1 / (1.0 + exp(3.3333333333333335 + 66.666666666666671 * var_ICaL__ICaL)); // dimensionless
        const double var_Irel__riss = 1 / (1.0 + exp(-16.0 + 80.0 * var_Irel__cafac + 40000.0 * var_chaste_interface__Ca__Ca_ss)); // dimensionless
        const double var_Irel__ross = var_Irel__dro_inf / (1.0 + 1 / pow(var_ICaL__ICaL, 2)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__ro = 0.33333333333333331 * var_Irel__ross - 0.33333333333333331 * var_chaste_interface__Irel__ro; // 1 / ms
        const double var_Irel__tauri = 3.0 + (350.0 - var_Irel__dtau_rel) / (1.0 + exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_Irel__cafac)) + var_Irel__dtau_rel; // ms
        const double d_dt_chaste_interface_var_Irel__ri = (-var_chaste_interface__Irel__ri + var_Irel__riss) / var_Irel__tauri; // 1 / ms
        const double var_Irel__vg = ((var_Environment__tissue == 0) ? (1 / (1.0 + exp(2.6000000000000001 + 0.20000000000000001 * var_ICaL__ibarca))) : (1.0)); // dimensionless
        const double var_Irel__Grel = 3000.0 * var_Irel__vg; // per_ms
        const double var_Irel__irelcicr = (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * var_Irel__Grel * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_jsr = (-var_Irel__irelcicr + var_Idiff_Itr__itr) * var_Ca__bcsqn; // mM / ms
        const double var_Ito__rv = exp(0.0033333333333333335 * var_chaste_interface__cell__V); // dimensionless
        const double var_Ito2__Ito2_max = (-var_Environment__Cl_o * exp(var_Environment__FonRT * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_Environment__F * var_Environment__FonRT * var_Ito2__PCl * var_chaste_interface__cell__V / (1.0 - exp(var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Ito2__Ito2 = var_chaste_interface__Ito2__AA * var_Ito2__Ito2_max; // uA_per_uF
        const double var_cell__a = 0.0011000000000000001; // cm
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell__l = 0.01; // cm
        const double var_cell__ageo = 2.0 * M_PI * pow(var_cell__a, 2) + 2.0 * M_PI * var_cell__a * var_cell__l; // cm2
        const double var_cell__Acap = 2.0 * var_cell__ageo; // uF
        const double var_cell__AF = var_cell__Acap / var_Environment__F; // uF_mole_per_C
        const double var_cell__vcell = 1000.0 * M_PI * pow(var_cell__a, 2) * var_cell__l; // uL
        const double var_cell__vjsr = 0.0047999999999999996 * var_cell__vcell; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_cell__vnsr = 0.055199999999999999 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_nsr = -var_Iup_Ileak__ileak - var_Idiff_Itr__itr * var_cell__vjsr / var_cell__vnsr + var_Iup_Ileak__iup; // mM / ms
        const double var_cell__vss = 0.02 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup_Ileak__iup + var_Iup_Ileak__ileak) * var_cell__vnsr / var_cell__vmyo + var_Idiff_Itr__idiff * var_cell__vss / var_cell__vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell__AF / var_cell__vmyo) * var_Ca__bmyo; // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (-var_Idiff_Itr__idiff + var_Irel__irelcicr * var_cell__vjsr / var_cell__vss - 0.5 * var_ICaL__ICaL * var_cell__AF / var_cell__vss) * var_Ca__bss; // mM / ms
        const double var_reversal_potentials__ECl = -log(var_Environment__Cl_o / var_chaste_interface__Cl__Cl_i) / var_Environment__FonRT; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__cell__V) * var_IClb__GClb; // uA_per_uF
        const double var_cell__clont = 0.5 * var_cell__i_Stim + var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = log(var_Environment__K_o / var_chaste_interface__K__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__ak1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)); // per_ms
        const double var_IK1__bk1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__IK1 = 0.21516574145596759 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_IK1__ak1 / (var_IK1__ak1 + var_IK1__bk1); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_IKr__gkr * var_IKr__r * var_chaste_interface__IKr__xr; // uA_per_uF
        const double var_Ito__Ito = pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_Ito__gitodv * var_Ito__rv * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv; // uA_per_uF
        const double var_K__CTKCl = (-var_reversal_potentials__ECl + var_reversal_potentials__EK) * var_K__CTKClmax / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_reversal_potentials__ENa = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__INa = (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * mParameters[1] * var_INa__gNa; // uA_per_uF
        const double var_INal__INal = pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_INal__GNaL * var_chaste_interface__INal__hL; // uA_per_uF
        const double var_Na__CTNaCl = pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) * var_Na__CTNaClmax / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_cell__AF * var_cell__clont / var_cell__vmyo + var_K__CTKCl + var_Na__CTNaCl; // mM / ms
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INal__INal; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = -var_cell__AF * var_cell__naiont / var_cell__vmyo + var_Na__CTNaCl; // mM / ms
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = log((var_Environment__Na_o * var_reversal_potentials__prnak + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__cell__V) * var_IKs__gks * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito__Ito; // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -var_cell__AF * var_cell__kiont / var_cell__vmyo + var_K__CTKCl; // mM / ms
        
        rResidual[0] = rCurrentGuess[0] - rY[1] - mDt*d_dt_chaste_interface_var_Ca__Ca_i;
        rResidual[5] = rCurrentGuess[5] - rY[8] - mDt*d_dt_chaste_interface_var_ICaL__fca;
        rResidual[6] = rCurrentGuess[6] - rY[9] - mDt*d_dt_chaste_interface_var_ICaL__fca2;
        rResidual[10] = rCurrentGuess[10] - rY[17] - mDt*d_dt_chaste_interface_var_Ito2__AA;
        rResidual[7] = rCurrentGuess[7] - rY[20] - mDt*d_dt_chaste_interface_var_Irel__CaMKtrap;
        rResidual[9] = rCurrentGuess[9] - rY[21] - mDt*d_dt_chaste_interface_var_Irel__ro;
        rResidual[8] = rCurrentGuess[8] - rY[22] - mDt*d_dt_chaste_interface_var_Irel__ri;
        rResidual[12] = rCurrentGuess[12] - rY[23] - mDt*d_dt_chaste_interface_var_Na__Na_i;
        rResidual[11] = rCurrentGuess[11] - rY[24] - mDt*d_dt_chaste_interface_var_K__K_i;
        rResidual[4] = rCurrentGuess[4] - rY[25] - mDt*d_dt_chaste_interface_var_Cl__Cl_i;
        rResidual[1] = rCurrentGuess[1] - rY[26] - mDt*d_dt_chaste_interface_var_Ca__Ca_jsr;
        rResidual[2] = rCurrentGuess[2] - rY[27] - mDt*d_dt_chaste_interface_var_Ca__Ca_nsr;
        rResidual[3] = rCurrentGuess[3] - rY[28] - mDt*d_dt_chaste_interface_var_Ca__Ca_ss;
    }

    void Cellhund_rudy_2004_aFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__Environment__time, const double rCurrentGuess[13], double rJacobian[13][13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        
        double var_chaste_interface__Ca__Ca_i = rCurrentGuess[0];
        double var_chaste_interface__Ca__Ca_jsr = rCurrentGuess[1];
        double var_chaste_interface__Ca__Ca_nsr = rCurrentGuess[2];
        double var_chaste_interface__Ca__Ca_ss = rCurrentGuess[3];
        double var_chaste_interface__Cl__Cl_i = rCurrentGuess[4];
        double var_chaste_interface__ICaL__fca = rCurrentGuess[5];
        double var_chaste_interface__ICaL__fca2 = rCurrentGuess[6];
        double var_chaste_interface__Irel__CaMKtrap = rCurrentGuess[7];
        double var_chaste_interface__Irel__ri = rCurrentGuess[8];
        double var_chaste_interface__Irel__ro = rCurrentGuess[9];
        double var_chaste_interface__Ito2__AA = rCurrentGuess[10];
        double var_chaste_interface__K__K_i = rCurrentGuess[11];
        double var_chaste_interface__Na__Na_i = rCurrentGuess[12];
        
        const double var_x0 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
        const double var_x1 = 1.768721357868101e-6 / var_x0;
        const double var_x2 = pow(var_x0, (-2));
        const double var_x3 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
        const double var_x4 = 1 / var_chaste_interface__Ca__Ca_ss;
        const double var_x5 = 1.0 + 0.0015 * var_x4;
        const double var_x6 = 1 / var_x5;
        const double var_x7 = 0.050000000000000003 * var_x6;
        const double var_x8 = var_x3 * var_x7 + var_chaste_interface__Irel__CaMKtrap;
        const double var_x9 = 0.14999999999999999 + var_x8;
        const double var_x10 = 1 / var_x9;
        const double var_x11 = var_x10 * var_x8;
        const double var_x12 = 0.00092000000000000003 - 0.00017000000000000001 * var_x11 + var_chaste_interface__Ca__Ca_i;
        const double var_x13 = 1 / var_x12;
        const double var_x14 = 1.0 + 0.75 * var_x11;
        const double var_x15 = var_x13 * var_x14;
        const double var_x16 = 0.00035514705882352943 * var_x15;
        const double var_x17 = 0.00035514705882352943 * var_chaste_interface__Ca__Ca_i;
        const double var_x18 = var_x14 / pow(var_x12, 2);
        const double var_x19 = var_x17 * var_x18;
        const double var_x20 = 0.074871767015599999 * var_chaste_interface__cell__V;
        const double var_x21 = exp(var_x20);
        const double var_x22 = 8.8666719524733664e-8 * var_chaste_interface__cell__V / (-1.0 + var_x21);
        const double var_x23 = pow(var_chaste_interface__Na__Na_i, 3);
        const double var_x24 = exp(0.01310255922773 * var_chaste_interface__cell__V);
        const double var_x25 = exp(-0.024333324280070002 * var_chaste_interface__cell__V);
        const double var_x26 = 1.8 * var_x23 * var_x24 - 4116000.0 * var_x25 * var_chaste_interface__Ca__Ca_i;
        const double var_x27 = 1 / (1.0 + 0.27000000000000002 * var_x25);
        const double var_x28 = 1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2);
        const double var_x29 = var_x27 / var_x28;
        const double var_x30 = var_x26 * var_x29;
        const double var_x31 = var_x30 / pow((0.0020299076937277489 + 1.2903323313862536e-6 * var_x23 + var_chaste_interface__Ca__Ca_i), 2);
        const double var_x32 = 1 / (13227.9606 + 8.4084932990912282 * var_x23 + 6516533.0625 * var_chaste_interface__Ca__Ca_i);
        const double var_x33 = var_x29 * var_x32;
        const double var_x34 = var_x25 * var_x33;
        const double var_x35 = var_x26 * var_x27 * var_x32 / (pow(var_x28, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
        const double var_x36 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
        const double var_x37 = 1.0 + 0.00011900000000000002 / pow(var_x36, 2) + 3.5000000000000004e-5 * var_x2;
        const double var_x38 = 1 / var_x37;
        const double var_x39 = var_x38;
        const double var_x40 = pow(var_chaste_interface__Ca__Ca_ss, (-2));
        const double var_x41 = var_x3 * var_x40 / pow(var_x5, 2);
        const double var_x42 = var_x10 * var_x41;
        const double var_x43 = var_x8 / pow(var_x9, 2);
        const double var_x44 = var_x41 * var_x43;
        const double var_x45 = 5.6250000000000005e-5 * var_x42 - 5.6250000000000005e-5 * var_x44;
        const double var_x46 = var_x13 * var_x17;
        const double var_x47 = 1.2750000000000002e-8 * var_x42 - 1.2750000000000002e-8 * var_x44;
        const double var_x48 = 1 - var_x7;
        const double var_x49 = var_x10 * var_x48;
        const double var_x50 = var_x43 * (-1 + var_x7);
        const double var_x51 = 0.75 * var_x49 + 0.75 * var_x50;
        const double var_x52 = 0.00017000000000000001 * var_x49 + 0.00017000000000000001 * var_x50;
        const double var_x53 = pow(var_chaste_interface__Na__Na_i, 2);
        const double var_x54 = var_x24 * var_x33 * var_x53;
        const double var_x55 = var_x31 * var_x53;
        const double var_x56 = exp(-1.1230765052339999 + var_x20);
        const double var_x57 = -0.61380000000000001 + var_x56 * var_chaste_interface__Ca__Ca_ss;
        const double var_x58 = -1.0 + var_x56;
        const double var_x59 = (-15.0 + var_chaste_interface__cell__V) * mParameters[0] / var_x58;
        const double var_x60 = var_x57 * var_x59;
        const double var_x61 = exp(2.6000000000000001 + 0.70217303721661617 * var_x60);
        const double var_x62 = 1.0 + var_x61;
        const double var_x63 = 1 / var_x62;
        const double var_x64 = var_x63 * var_chaste_interface__Irel__ro;
        const double var_x65 = var_x64 * var_chaste_interface__Irel__ri;
        const double var_x66 = 3000.0 * var_x65;
        const double var_x67 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr;
        const double var_x68 = pow(var_x67, (-2));
        const double var_x69 = 1 / (1.0 + 8.0 * var_x68);
        const double var_x70 = var_x69;
        const double var_x71 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr;
        const double var_x72 = var_x71 * var_chaste_interface__Irel__ri;
        const double var_x73 = var_x56 * var_x59;
        const double var_x74 = var_x61 * var_x72 * var_x73 * var_chaste_interface__Irel__ro / pow(var_x62, 2);
        const double var_x75 = var_x64 * var_x71;
        const double var_x76 = 3000.0 * var_x69;
        const double var_x77 = var_x63 * var_x72;
        const double var_x78 = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_i;
        const double var_x79 = var_x18 * var_x78;
        const double var_x80 = var_x13 * var_x78;
        const double var_x81 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss;
        const double var_x82 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss;
        const double var_x83 = 1.0 + 0.0097788000000000007 / pow(var_x81, 2) + 4.0890000000000003e-5 / pow(var_x82, 2);
        const double var_x84 = 1 / var_x83;
        const double var_x85 = 719.99999999999989 * var_x65;
        const double var_x86 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
        const double var_x87 = var_x86 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2;
        const double var_x88 = var_x73 * var_x87;
        const double var_x89 = var_x60 * var_x87;
        const double var_x90 = var_x60 * var_x86 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2;
        const double var_x91 = var_x90 * var_chaste_interface__ICaL__fca2;
        const double var_x92 = 0.0036718475849305066 * var_x84;
        const double var_x93 = var_x90 * var_chaste_interface__ICaL__fca;
        const double var_x94 = 719.99999999999989 * var_x84;
        const double var_x95 = 1 / var_chaste_interface__Cl__Cl_i;
        const double var_x96 = 0.0374358835078 * var_chaste_interface__cell__V;
        const double var_x97 = exp(var_x96);
        const double var_x98 = 8.8885199344722979e-8 * var_chaste_interface__cell__V / (1.0 - var_x97);
        const double var_x99 = log(100.0 * var_x95);
        const double var_x100 = 1 / var_chaste_interface__K__K_i;
        const double var_x101 = log(5.4000000000000004 * var_x100);
        const double var_x102 = 26.712338705500134 * var_x101;
        const double var_x103 = var_x102 + 26.712338705500134 * var_x99;
        const double var_x104 = 0.00018900582374463672 / (87.825100000000006 + var_x103);
        const double var_x105 = 2.4504050574883893e-8 * var_x103 / pow((1 + 0.30415380916731244 * var_x101 + 0.30415380916731244 * var_x99), 2);
        const double var_x106 = var_x105 * var_x95 - var_x104 * var_x95;
        const double var_x107 = 1 / var_chaste_interface__Na__Na_i;
        const double var_x108 = var_x99 + log(140.0 * var_x107);
        const double var_x109 = pow(var_x108, 4);
        const double var_x110 = 2.8839711417381356e-9 * pow(var_x108, 7) / pow((1 + 0.008558014922736952 * var_x109), 2);
        const double var_x111 = 20.048989239405216 * pow(var_x108, 3) / (59494197.640692554 + 509152.23122530844 * var_x109);
        const double var_x112 = var_x110 * var_x95 - var_x111 * var_x95;
        const double var_x113 = var_x100 * var_x105 - var_x100 * var_x104;
        const double var_x114 = var_x107 * var_x110 - var_x107 * var_x111;
        const double var_x115 = 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss);
        const double var_x116 = 10.0 * var_x11;
        const double var_x117 = 1 / (0.5 + var_x116 + var_x115);
        const double var_x118 = pow((0.0030000000000000001 + var_chaste_interface__Ca__Ca_ss), (-2));
        const double var_x119 = -var_x89;
        const double var_x120 = 0.0042724511494942495 / pow((0.0142415038316475 + var_x119), 2);
        const double var_x121 = 0.00075000000000000002 * var_x44 - 0.00075000000000000002 * var_x42;
        const double var_x122 = 0.01 * (0.14999999999999999 - var_chaste_interface__ICaL__fca + 0.55000000000000004 * var_x115 + 0.29999999999999999 / (1.0 - 70.217303721661608 * var_x89)) / pow((0.050000000000000003 + var_x11 + 0.10000000000000001 * var_x115), 2);
        const double var_x123 = -10.0 * var_x49 - 10.0 * var_x50;
        const double var_x124 = exp(-4.375 - 87.77162965207701 * var_x89);
        const double var_x125 = 1.0 + var_x124;
        const double var_x126 = 1 / var_x125;
        const double var_x127 = 1 / (125.0 + 300.0 * var_x126);
        const double var_x128 = 0.0028483007663294996 / pow((0.0028483007663294996 + var_x119), 2);
        const double var_x129 = var_x127 * var_x128;
        const double var_x130 = 0.2925720988402567 * var_x124 * (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 351.08651860830804 * var_x89)) / (pow(var_x125, 2) * pow((0.41666666666666669 + var_x126), 2));
        const double var_x131 = 0.0025000000000000005 * var_x6;
        const double var_x132 = exp(3.3333333333333335 + 234.05767907220539 * var_x89);
        const double var_x133 = 1.0 + var_x132;
        const double var_x134 = 1 / var_x133;
        const double var_x135 = exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_x134);
        const double var_x136 = 1.0 + var_x135;
        const double var_x137 = 1 / var_x136;
        const double var_x138 = var_x132 / pow(var_x133, 2);
        const double var_x139 = var_x138 * var_x88;
        const double var_x140 = 350.0 - var_x116;
        const double var_x141 = var_x135 * var_x140 / pow(var_x136, 2);
        const double var_x142 = var_x137 * var_x140;
        const double var_x143 = exp(-16.0 + 80.0 * var_x134 + 40000.0 * var_chaste_interface__Ca__Ca_ss);
        const double var_x144 = 1.0 + var_x143;
        const double var_x145 = (-var_chaste_interface__Irel__ri + 1 / var_x144) / pow((0.29999999999999999 + var_x11 + 0.10000000000000001 * var_x142), 2);
        const double var_x146 = 0.01 * var_x145;
        const double var_x147 = 1 / (3.0 + var_x116 + var_x142);
        const double var_x148 = var_x143 * var_x147 / pow(var_x144, 2);
        const double var_x149 = var_x138 * var_x91;
        const double var_x150 = 18724.614325776431 * var_x148;
        const double var_x151 = 35.108651860830804 * var_x141 * var_x145;
        const double var_x152 = var_x138 * var_x93;
        const double var_x153 = pow(var_chaste_interface__ICaL__fca, (-2));
        const double var_x154 = pow((-1 + 0.066666666666666666 * var_chaste_interface__cell__V), (-2));
        const double var_x155 = pow(var_x58, 2);
        const double var_x156 = pow(var_x57, (-2));
        const double var_x157 = pow(mParameters[0], (-2));
        const double var_x158 = pow(var_chaste_interface__ICaL__d, (-2 * var_chaste_interface__ICaL__dp));
        const double var_x159 = pow(var_chaste_interface__ICaL__f, (-2));
        const double var_x160 = pow(var_chaste_interface__ICaL__f2, (-2));
        const double var_x161 = pow(var_chaste_interface__ICaL__fca2, (-2));
        const double var_x162 = var_x154 * var_x155 * var_x156 * var_x157 * var_x158 * var_x159 * var_x160 * var_x161;
        const double var_x163 = 1.0 + 0.00036056965579880955 * var_x153 * var_x162;
        const double var_x164 = 1 / var_x163;
        const double var_x165 = pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999);
        const double var_x166 = 0.0028 + var_chaste_interface__Ca__Ca_ss;
        const double var_x167 = 1 / var_x166;
        const double var_x168 = pow((var_x167 * var_chaste_interface__Ca__Ca_ss), 1.8999999999999999);
        const double var_x169 = 1 / (var_x165 + 1644.6531773416521 * var_x168);
        const double var_x170 = var_x164 / pow((var_x168 + 0.00060803092942449902 * var_x165), 2);
        const double var_x171 = 0.00024037977053253972 * var_x165 * var_x169 / pow(var_x163, 2);
        const double var_x172 = var_x153 * var_x154 * var_x155 * var_x157 * var_x158 * var_x159 * var_x160 * var_x171;
        const double var_x173 = 1 / var_chaste_interface__Ca__Ca_i;
        const double var_x174 = pow(var_x173, 1.3999999999999999);
        const double var_x175 = 1.0 + 6.4818210260626455e-7 * var_x174;
        const double var_x176 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
        const double var_x177 = var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2;
        const double var_x178 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * var_x101);
        const double var_x179 = 1.0 + var_x178;
        const double var_x180 = 1 / var_x179;
        const double var_x181 = exp(-2.4444678999999998 + 13.738155796238718 * var_x101 - 0.51429999999999998 * var_chaste_interface__cell__V);
        const double var_x182 = 1.0 + var_x181;
        const double var_x183 = 1 / var_x182;
        const double var_x184 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * var_x101);
        const double var_x185 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * var_x101);
        const double var_x186 = var_x184 + 0.49124000000000001 * var_x185;
        const double var_x187 = var_x183 * var_x186;
        const double var_x188 = var_x100 / (var_x187 + 1.02 * var_x180);
        const double var_x189 = -var_x102 + var_chaste_interface__cell__V;
        const double var_x190 = var_x178 / pow(var_x179, 2);
        const double var_x191 = var_x177 * (-1.5317126959137754e-6 - 9.1902761754826519e-7 / var_x175) * (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x176, 2);
        const double var_x192 = 1 / (var_x23 * pow((0.01 + 1 / var_x53), 2) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-var_x96)));
        
        
        rJacobian[0][0] = 1.0 - (mDt * (var_x39 * (-0.14705882352941174 + var_x19 - var_x1 - var_x16 + 3.8450464301480458e-12 * var_x35 - 4.2483225407660435e-11 * var_x31 - 1139.4871996672337 * var_x34 - var_x21 * var_x22 + 1.768721357868101e-6 * var_x2 * var_chaste_interface__Ca__Ca_i) + (0.00023800000000000004 / pow(var_x36, 3) + 7.0000000000000007e-5 / pow(var_x0, 3)) * (0.14705882352941174 * var_chaste_interface__Ca__Ca_ss + 2.3676470588235295e-5 * var_chaste_interface__Ca__Ca_nsr - 0.14705882352941174 * var_chaste_interface__Ca__Ca_i - var_x1 * var_chaste_interface__Ca__Ca_i - var_x16 * var_chaste_interface__Ca__Ca_i - var_x22 * (-0.61380000000000001 + var_x21 * var_chaste_interface__Ca__Ca_i) + 0.00027684334297065928 * var_x30 * var_x32) / pow(var_x37, 2)));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = -(mDt * (2.3676470588235295e-5 * var_x38));
        rJacobian[0][3] = -(mDt * (var_x39 * (0.14705882352941174 - var_x19 * var_x47 - var_x45 * var_x46)));
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = -(mDt * (var_x39 * (-var_x19 * var_x52 - var_x46 * var_x51)));
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = -(mDt * (var_x39 * (0.0014949540520415602 * var_x54 - 1.6445243785522266e-16 * var_x55)));
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (var_x70 * (-0.0083333333333333332 - var_x66) + 0.25 * (0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr - var_x66 * var_x71) / (pow(var_x67, 3) * pow((0.125 + var_x68), 2))));
        rJacobian[1][2] = -(mDt * (0.0083333333333333332 * var_x69));
        rJacobian[1][3] = -(mDt * (var_x70 * (var_x66 + 2106.5191116498486 * var_x74)));
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = -(mDt * (-var_x75 * var_x76));
        rJacobian[1][9] = -(mDt * (-var_x76 * var_x77));
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[2][0] = -(mDt * (-var_x79 + 0.0043750000000000004 * var_x15));
        rJacobian[2][1] = -(mDt * (0.00072463768115942019));
        rJacobian[2][2] = 1.0 - (mDt * (-0.0010163043478260869));
        rJacobian[2][3] = -(mDt * (var_x45 * var_x80 + var_x47 * var_x79));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = -(mDt * (var_x51 * var_x80 + var_x52 * var_x79));
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[3][0] = -(mDt * (5.0 * var_x84));
        rJacobian[3][1] = -(mDt * (var_x84 * var_x85));
        rJacobian[3][2] = 0.0;
        rJacobian[3][3] = 1.0 - (mDt * (var_x84 * (-5.0 - var_x85 - 0.0036718475849305066 * var_x88 - 505.56458679596358 * var_x74) + (0.019557600000000001 / pow(var_x81, 3) + 8.1780000000000006e-5 / pow(var_x82, 3)) * (5.0 * var_chaste_interface__Ca__Ca_i - 5.0 * var_chaste_interface__Ca__Ca_ss - 0.0036718475849305066 * var_x89 + var_x71 * var_x85) / pow(var_x83, 2)));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (-var_x91 * var_x92));
        rJacobian[3][6] = -(mDt * (-var_x92 * var_x93));
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = -(mDt * (var_x75 * var_x94));
        rJacobian[3][9] = -(mDt * (var_x77 * var_x94));
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (var_x106 + var_x112 - 3.6975665728975948e-7 * var_x95 + var_x98 * var_chaste_interface__Ito2__AA));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = -(mDt * (var_x98 * (-100.0 * var_x97 + var_chaste_interface__Cl__Cl_i)));
        rJacobian[4][11] = -(mDt * (var_x113));
        rJacobian[4][12] = -(mDt * (var_x114));
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (var_x117 * (-0.0016500000000000002 * var_x118 + var_x120 * var_x88) + var_x122 * (var_x121 + 0.0030000000000000001 * var_x118)));
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (var_x117 * (-1 + var_x120 * var_x91)));
        rJacobian[5][6] = -(mDt * (var_x117 * var_x120 * var_x93));
        rJacobian[5][7] = -(mDt * (var_x122 * var_x123));
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = -(mDt * (var_x129 * var_x88 - var_x130 * var_x88));
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = -(mDt * (var_x129 * var_x91 - var_x130 * var_x91));
        rJacobian[6][6] = 1.0 - (mDt * (var_x127 * (-1 + var_x128 * var_x93) - var_x130 * var_x93));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = -(mDt * (3.7500000000000005e-6 * var_x41 * var_x8 + 1.8750000000000003e-7 * var_x40 * pow(var_x3, 2) / pow(var_x5, 3)));
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (-0.00068000000000000005 - var_x131 * var_x8 + var_x131 * var_x3 * var_x48));
        rJacobian[7][8] = 0.0;
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = -(mDt * (var_x146 * (var_x121 + var_x141 * (5000.0 - 3510.8651860830805 * var_x139) - var_x121 * var_x137) - 1.0 * var_x148 * (40000.0 - 18724.614325776431 * var_x139)));
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = -(mDt * (var_x149 * var_x150 - var_x149 * var_x151));
        rJacobian[8][6] = -(mDt * (var_x150 * var_x152 - var_x151 * var_x152));
        rJacobian[8][7] = -(mDt * (var_x146 * (var_x123 - var_x123 * var_x137)));
        rJacobian[8][8] = 1.0 - (mDt * (-var_x147));
        rJacobian[8][9] = 0.0;
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = -(mDt * (-2.3414435371998602e-7 * var_x170 * pow(var_chaste_interface__Ca__Ca_jsr, 2.7999999999999998) + 0.6333333333333333 * var_x164 * var_x169 * pow(var_chaste_interface__Ca__Ca_jsr, 0.89999999999999991)));
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = -(mDt * (var_x161 * var_x172 * var_x56 / pow(var_x57, 3) - 0.00020267697647483301 * var_x165 * var_x166 * var_x168 * var_x170 * var_x4 * (1.8999999999999999 * var_x167 - 1.8999999999999999 * var_chaste_interface__Ca__Ca_ss / pow(var_x166, 2))));
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = -(mDt * (var_x162 * var_x171 / pow(var_chaste_interface__ICaL__fca, 3)));
        rJacobian[9][6] = -(mDt * (var_x156 * var_x172 / pow(var_chaste_interface__ICaL__fca2, 3)));
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (-0.33333333333333331));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = -(mDt * (0.1502 * var_x40 / pow((1.0 + 0.1502 * var_x4), 2)));
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (-1.0));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = 0.0;
        rJacobian[11][0] = -(mDt * (-8.3397615489392458e-13 * var_x173 * var_x174 * var_x177 * (-26.712338705500134 * log(7.9662000000000006 / var_x176) + var_chaste_interface__cell__V) / pow(var_x175, 2)));
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = -(mDt * (var_x106));
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (var_x113 + 212.79583259575517 * var_x191 - 4.535681662754383e-6 * var_x100 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) - 0.0008381150898567882 * var_x180 * var_x188 + 0.00019989044893084398 * var_x188 * var_x189 * var_x190 - 2.2767478584105716e-5 * var_x100 * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) - 3.0157226903121925e-5 * var_x180 * var_x189 * (-var_x183 * (1.6494869150646332 * var_x100 * var_x184 + 1.0539726354202117 * var_x100 * var_x185) + 6.4983106368870169 * var_x100 * var_x190 - 13.738155796238718 * var_x100 * var_x181 * var_x186 / pow(var_x182, 2)) / pow((var_x180 + 0.98039215686274506 * var_x187), 2) - 0.00031223895504468581 * var_x100 * pow(var_chaste_interface__Ito__ydv, 3) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V)));
        rJacobian[11][12] = -(mDt * (3.9005476114801918 * var_x191 + 1.191630041482403e-6 * var_x192));
        rJacobian[12][0] = -(mDt * (1.274496762229813e-10 * var_x31 + 3418.461599001701 * var_x34 - 1.1535139290444137e-11 * var_x35));
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = -(mDt * (var_x112));
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (var_x114 + 4.9335731356566794e-16 * var_x55 - 1.7874450622236046e-6 * var_x192 - 0.0044848621561246801 * var_x54 - 1.068185898837083e-5 * var_x107 * pow(var_chaste_interface__INal__mL, 3) * var_chaste_interface__INal__hL - 0.013557744100624516 * var_x107 * pow(var_chaste_interface__INa__m, 3) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J));
    }

    void Cellhund_rudy_2004_aFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__Environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__Cl_o = 100.0; // mM
        const double var_Environment__F = 96485.0; // C_per_mole
        const double var_Environment__FonRT = 0.0374358835078; // per_mV
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 140.0; // mM
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__gacai = 1.0; // dimensionless
        const double var_ICaL__gacao = 0.34100000000000003; // dimensionless
        const double var_ICaL__pca = 0.000243; // L_per_F_ms
        const double var_IClb__GClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKr__gkr = 0.0059618984305585326 * sqrt(var_Environment__K_o); // mS_per_uF
        const double var_IKs__gks = 0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INa__GNa = ((var_Environment__tissue == 0) ? (8.25) : (33.0)); // mS_per_uF
        const double var_INa__gNa = pow(var_chaste_interface__INa__m, 3) * var_INa__GNa * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mS_per_uF
        const double var_INaCa__KmCa = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__NCXmax = 4.5; // uA_per_uF
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__allo = 1 / (1.0 + pow(var_INaCa__KmCa, 2) / pow(var_INaCa__ca_i_NaCa, 2)); // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__ibarnak = 0.61875000000000002; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 10.0; // mM
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INal__GNaL = 0.0064999999999999997; // mS_per_uF
        const double var_IpCa__ibarpca = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__kmpca = 0.00050000000000000001; // mM
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__ibarpca / (var_chaste_interface__Ca__Ca_i + var_IpCa__kmpca); // uA_per_uF
        const double var_Ito__gitodv = 0.19; // mS_per_uF
        const double var_Ito2__PCl = 3.9999999999999998e-7; // L_per_F_ms
        const double var_INaCa__denom2 = pow(var_INaCa__KmNao, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_INaCa__ca_i_NaCa / var_INaCa__KmCai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__denom3 = pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o + pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_ICaL__ibarca = 4.0 * (-15.0 + var_chaste_interface__cell__V) * (-var_Environment__Ca_o * var_ICaL__gacao + var_chaste_interface__Ca__Ca_ss * var_ICaL__gacai * exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)) * var_Environment__F * var_Environment__FonRT * mParameters[0] * var_ICaL__pca / (-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__cell__V) * var_Environment__FonRT)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICab__ICab = 7.9803360000000004e-7 * (-0.34100000000000003 * var_Environment__Ca_o + var_chaste_interface__Ca__Ca_i * exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)) * var_Environment__F * var_Environment__FonRT * var_chaste_interface__cell__V / (-1.0 + exp(2.0 * var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__denom1 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__num = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(var_Environment__FonRT * var_INaCa__eta * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_INaCa__ca_i_NaCa * exp((-1.0 + var_INaCa__eta) * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__INaCa = var_INaCa__NCXmax * var_INaCa__allo * var_INaCa__num / ((var_INaCa__denom2 + var_INaCa__denom3) * var_INaCa__denom1); // uA_per_uF
        const double var_INaK__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__INaK = var_Environment__K_o * var_INaK__fnak * var_INaK__ibarnak / ((1.0 + pow(var_INaK__kmnai, 2) / pow(var_chaste_interface__Na__Na_i, 2)) * (var_Environment__K_o + var_INaK__kmko)); // uA_per_uF
        const double var_Ito__rv = exp(0.0033333333333333335 * var_chaste_interface__cell__V); // dimensionless
        const double var_Ito2__Ito2_max = (-var_Environment__Cl_o * exp(var_Environment__FonRT * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_Environment__F * var_Environment__FonRT * var_Ito2__PCl * var_chaste_interface__cell__V / (1.0 - exp(var_Environment__FonRT * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Ito2__Ito2 = var_chaste_interface__Ito2__AA * var_Ito2__Ito2_max; // uA_per_uF
        const double var_cell__caiont = -2.0 * var_INaCa__INaCa + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_reversal_potentials__ECl = -log(var_Environment__Cl_o / var_chaste_interface__Cl__Cl_i) / var_Environment__FonRT; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__cell__V) * var_IClb__GClb; // uA_per_uF
        const double var_cell__clont = 0.5 * var_cell__i_Stim + var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = log(var_Environment__K_o / var_chaste_interface__K__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__ak1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)); // per_ms
        const double var_IK1__bk1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__IK1 = 0.21516574145596759 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_IK1__ak1 / (var_IK1__ak1 + var_IK1__bk1); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_IKr__gkr * var_IKr__r * var_chaste_interface__IKr__xr; // uA_per_uF
        const double var_Ito__Ito = pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_Ito__gitodv * var_Ito__rv * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv; // uA_per_uF
        const double var_reversal_potentials__ENa = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__INa = (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * mParameters[1] * var_INa__gNa; // uA_per_uF
        const double var_INal__INal = pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_INal__GNaL * var_chaste_interface__INal__hL; // uA_per_uF
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INal__INal; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = log((var_Environment__Na_o * var_reversal_potentials__prnak + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__cell__V) * var_IKs__gks * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito__Ito; // uA_per_uF
        const double d_dt_chaste_interface_var_cell__V = -var_cell__caiont - var_cell__clont - var_cell__kiont - var_cell__naiont; // mV / ms
        
        rY[0] += mDt*d_dt_chaste_interface_var_cell__V;
    }
    
    void Cellhund_rudy_2004_aFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__Environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        
        const double var_ICaL__dpss = 9.0 - 8.0 / (1.0 + exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V));
        const double var_ICaL__dss = 1 / (1.0 + exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V));
        const double var_ICaL__f2ss = 0.23000000000000001 + 0.77000000000000002 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V));
        const double var_ICaL__fss = 0.29999999999999999 + 0.69999999999999996 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V));
        const double var_ICaL__taud = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V));
        const double var_ICaL__tauf = 1 / (0.052900000000000003 + 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2)));
        const double var_ICaL__tauf2 = 1 / (0.0054000000000000003 + 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2)));
        const double var_IKr__tauxr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__cell__V) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__cell__V) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V)));
        const double var_IKr__xrss = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V));
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V)));
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V));
        const double var_INa__ah = ((var_chaste_interface__cell__V >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)));
        const double var_INa__aj = ((var_chaste_interface__cell__V >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))));
        const double var_INa__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V));
        const double var_INa__bh = ((var_chaste_interface__cell__V >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)));
        const double var_INa__bj = ((var_chaste_interface__cell__V >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))));
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V);
        const double var_INal__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V));
        const double var_INal__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V);
        const double var_INal__hLss = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V));
        const double var_Ito__ay = 25.0 * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V));
        const double var_Ito__ay2 = 0.029999999999999999 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V));
        const double var_Ito__ay3 = 0.0022499999999999998 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V));
        const double var_Ito__by = 25.0 * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V));
        const double var_Ito__by2 = 0.20000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V));
        const double var_Ito__by3 = 0.10000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V));
        
        
        rY[5] = (var_chaste_interface__ICaL__d + ((var_ICaL__dss / var_ICaL__taud) * mDt)) / (1.0 - ((-1 / var_ICaL__taud) * mDt));
        rY[6] = (var_chaste_interface__ICaL__dp + ((0.10000000000000001 * var_ICaL__dpss) * mDt)) / (1.0 - ((-0.10000000000000001) * mDt));
        rY[7] = (var_chaste_interface__ICaL__f + ((var_ICaL__fss / var_ICaL__tauf) * mDt)) / (1.0 - ((-1 / var_ICaL__tauf) * mDt));
        rY[10] = (var_chaste_interface__ICaL__f2 + ((var_ICaL__f2ss / var_ICaL__tauf2) * mDt)) / (1.0 - ((-1 / var_ICaL__tauf2) * mDt));
        rY[11] = (var_chaste_interface__IKr__xr + ((var_IKr__xrss / var_IKr__tauxr) * mDt)) / (1.0 - ((-1 / var_IKr__tauxr) * mDt));
        rY[12] = (var_chaste_interface__IKs__xs1 + ((var_IKs__xss / var_IKs__tauxs) * mDt)) / (1.0 - ((-1 / var_IKs__tauxs) * mDt));
        rY[13] = (var_chaste_interface__IKs__xs2 + ((0.5 * var_IKs__xss / var_IKs__tauxs) * mDt)) / (1.0 - ((-0.5 / var_IKs__tauxs) * mDt));
        rY[2] = (var_chaste_interface__INa__H + ((var_INa__ah) * mDt)) / (1.0 - ((-var_INa__ah - var_INa__bh) * mDt));
        rY[4] = (var_chaste_interface__INa__J + ((var_INa__aj) * mDt)) / (1.0 - ((-var_INa__aj - var_INa__bj) * mDt));
        rY[3] = (var_chaste_interface__INa__m + ((var_INa__am) * mDt)) / (1.0 - ((-var_INa__am - var_INa__bm) * mDt));
        rY[19] = (var_chaste_interface__INal__hL + ((0.0016666666666666668 * var_INal__hLss) * mDt)) / (1.0 - ((-0.0016666666666666668) * mDt));
        rY[18] = (var_chaste_interface__INal__mL + ((var_INal__amL) * mDt)) / (1.0 - ((-var_INal__amL - var_INal__bmL) * mDt));
        rY[14] = (var_chaste_interface__Ito__ydv + ((var_Ito__ay) * mDt)) / (1.0 - ((-var_Ito__ay - var_Ito__by) * mDt));
        rY[15] = (var_chaste_interface__Ito__ydv2 + ((var_Ito__ay2) * mDt)) / (1.0 - ((-var_Ito__ay2 - var_Ito__by2) * mDt));
        rY[16] = (var_chaste_interface__Ito__zdv + ((var_Ito__ay3) * mDt)) / (1.0 - ((-var_Ito__ay3 - var_Ito__by3) * mDt));
        
        double _guess[13] = {rY[1],rY[26],rY[27],rY[28],rY[25],rY[8],rY[9],rY[20],rY[22],rY[21],rY[17],rY[24],rY[23]};
        CardiacNewtonSolver<13,Cellhund_rudy_2004_aFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<13,Cellhund_rudy_2004_aFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__Environment__time, _guess);
        rY[1] = _guess[0];
        rY[26] = _guess[1];
        rY[27] = _guess[2];
        rY[28] = _guess[3];
        rY[25] = _guess[4];
        rY[8] = _guess[5];
        rY[9] = _guess[6];
        rY[20] = _guess[7];
        rY[22] = _guess[8];
        rY[21] = _guess[9];
        rY[17] = _guess[10];
        rY[24] = _guess[11];
        rY[23] = _guess[12];
    }

    std::vector<double> Cellhund_rudy_2004_aFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__Environment__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "hund_rudy_2004";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-85.781844107117);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012131666);

    // rY[2]:
    this->mVariableNames.push_back("INa__H");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.987317750543);

    // rY[3]:
    this->mVariableNames.push_back("INa__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[4]:
    this->mVariableNames.push_back("INa__J");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991924983076);

    // rY[5]:
    this->mVariableNames.push_back("ICaL__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.64013e-06);

    // rY[6]:
    this->mVariableNames.push_back("ICaL__dp");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.98230672628);

    // rY[7]:
    this->mVariableNames.push_back("ICaL__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999961508634);

    // rY[8]:
    this->mVariableNames.push_back("ICaL__fca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.97836624923);

    // rY[9]:
    this->mVariableNames.push_back("ICaL__fca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893052931249);

    // rY[10]:
    this->mVariableNames.push_back("ICaL__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.992234519148);

    // rY[11]:
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.24074e-06);

    // rY[12]:
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019883138161);

    // rY[13]:
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019890650554);

    // rY[14]:
    this->mVariableNames.push_back("Ito__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.013970786703);

    // rY[15]:
    this->mVariableNames.push_back("Ito__ydv2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99996472752);

    // rY[16]:
    this->mVariableNames.push_back("Ito__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.829206149767);

    // rY[17]:
    this->mVariableNames.push_back("Ito2__AA");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000816605172);

    // rY[18]:
    this->mVariableNames.push_back("INal__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[19]:
    this->mVariableNames.push_back("INal__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.26130711759);

    // rY[20]:
    this->mVariableNames.push_back("Irel__CaMKtrap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.021123704774);

    // rY[21]:
    this->mVariableNames.push_back("Irel__ro");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("Irel__ri");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.862666650318);

    // rY[23]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(12.972433387269);

    // rY[24]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(135.469546216758);

    // rY[25]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(15.59207157178);

    // rY[26]:
    this->mVariableNames.push_back("Ca__Ca_jsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.737580994071);

    // rY[27]:
    this->mVariableNames.push_back("Ca__Ca_nsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.832822335168);

    // rY[28]:
    this->mVariableNames.push_back("Ca__Ca_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012271265);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellhund_rudy_2004_aFromCellMLBackwardEuler)
