//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: espinosa_model_1998_normal
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "espinosa_model_1998_normal.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellespinosa_model_1998_normalFromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0018000000000000002 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellespinosa_model_1998_normalFromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellespinosa_model_1998_normalFromCellMLBackwardEuler::Cellespinosa_model_1998_normalFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<13>(
                21,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellespinosa_model_1998_normalFromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 9.5000000000000005e-5; // (var_membrane__Cm) [microF]
    }

    Cellespinosa_model_1998_normalFromCellMLBackwardEuler::~Cellespinosa_model_1998_normalFromCellMLBackwardEuler()
    {
    }
    
    double Cellespinosa_model_1998_normalFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.27784
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 7.07933e-05
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[2];
        // Units: dimensionless; Initial value: 2.3455e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[3];
        // Units: dimensionless; Initial value: 0.003956
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[4];
        // Units: dimensionless; Initial value: 0.9759885
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.06884e-12
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9999977
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[7];
        // Units: dimensionless; Initial value: 0.994096
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[8];
        // Units: dimensionless; Initial value: 0.4387865
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.954689
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[10];
        // Units: dimensionless; Initial value: 2.4223e-05
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[13];
        // Units: millimolar; Initial value: 6.835
        double var_chaste_interface__extracellular_potassium_concentration__K_o = rY[14];
        // Units: millimolar; Initial value: 5.3201028
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[15];
        // Units: millimolar; Initial value: 140.1333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[16];
        // Units: millimolar; Initial value: 0.0008364
        
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.0030000000000000001; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.059999999999999998; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_extracellular_calcium_concentration__Ca_o = 2.5; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 148.5; // millimolar
        const double var_fast_sodium_current__g_Na = 0.59999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_potassium_background_current__g_bk = 0.0040000000000000001; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_potassium_background_current__i_b_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_bk; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_chaste_interface__extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__g_bna = 0.0001; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0050000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00020000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_chaste_interface__extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 1.5; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__K_o * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.12; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.6699999999999999 * (10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.080000000000000002; // microS
        const double var_transient_outward_current__g_tos = 0.14999999999999999; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellespinosa_model_1998_normalFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[13], double rResidual[13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.27784
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[2];
        // Units: dimensionless; Initial value: 2.3455e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[3];
        // Units: dimensionless; Initial value: 0.003956
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[4];
        // Units: dimensionless; Initial value: 0.9759885
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.06884e-12
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9999977
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.954689
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[10];
        // Units: dimensionless; Initial value: 2.4223e-05
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rCurrentGuess[0];
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rCurrentGuess[1];
        double var_chaste_interface__calcium_release__ActFrac = rCurrentGuess[2];
        double var_chaste_interface__calcium_release__ProdFrac = rCurrentGuess[3];
        double var_chaste_interface__extracellular_potassium_concentration__K_o = rCurrentGuess[4];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rCurrentGuess[5];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rCurrentGuess[6];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rCurrentGuess[7];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rCurrentGuess[8];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[9];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[10];
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rCurrentGuess[11];
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rCurrentGuess[12];
        
        //output_equations
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__Km_f2 = 100000.0; // millimolar
        const double var_L_type_Ca_channel__Km_f2ds = 0.001; // millimolar
        const double var_L_type_Ca_channel__P_CaK = 0.0030000000000000001; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.059999999999999998; // nanoA_per_millimolar
        const double var_L_type_Ca_channel__R_decay = 20.0; // per_second
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_calcium_release__K_leak_rate = 0.050000000000000003; // per_second
        const double var_calcium_release__K_m_Ca_cyt = 0.00050000000000000001; // millimolar
        const double var_calcium_release__K_m_Ca_ds = 0.01; // millimolar
        const double var_calcium_release__K_m_rel = 250.0; // per_second
        const double var_calcium_release__PrecFrac = 1.0 - var_chaste_interface__calcium_release__ActFrac - var_chaste_interface__calcium_release__ProdFrac; // dimensionless
        const double var_extracellular_calcium_concentration__Ca_o = 2.5; // millimolar
        const double var_extracellular_potassium_concentration__K_b = 5.4000000000000004; // millimolar
        const double var_extracellular_potassium_concentration__pf = 0.69999999999999996; // per_second
        const double var_extracellular_sodium_concentration__Na_o = 148.5; // millimolar
        const double var_fast_sodium_current__g_Na = 0.59999999999999998; // microS
        const double var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds - var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_L_type_Ca_channel__Km_f2ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds)) * var_L_type_Ca_channel__R_decay; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds = 0.001 * var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv; // 1 / millisecond
        const double var_calcium_release__CadsReg = var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_calcium_release__K_m_Ca_ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds); // dimensionless
        const double var_L_type_Ca_channel_f2_gate__f2_orig_deriv = 1.0 - 1.0 * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 - 1.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_L_type_Ca_channel__Km_f2 + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2 = 0.001 * var_L_type_Ca_channel_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_calcium_release__CaiReg = var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_calcium_release__K_m_Ca_cyt + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // dimensionless
        const double var_calcium_release__RegBindSite = (1.0 - var_calcium_release__CaiReg) * var_calcium_release__CadsReg + var_calcium_release__CaiReg; // dimensionless
        const double var_calcium_release__ActRate = 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__InactRate = 60.0 + 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__i_rel = (pow(var_chaste_interface__calcium_release__ActFrac, 2) * var_calcium_release__K_m_rel / pow((0.25 + var_chaste_interface__calcium_release__ActFrac), 2) + var_calcium_release__K_leak_rate) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_calcium_translocation__i_trans = 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Calmod = 0.02; // millimolar
        const double var_intracellular_calcium_concentration__Kdecay = 10.0; // per_second
        const double var_intracellular_calcium_concentration__Trop = 0.050000000000000003; // millimolar
        const double var_intracellular_calcium_concentration__V_ds_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = -var_calcium_release__i_rel + var_calcium_translocation__i_trans * var_intracellular_calcium_concentration__V_up_ratio / var_intracellular_calcium_concentration__V_rel_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__alpha_Calmod = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__alpha_Trop = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__beta_Calmod = 50.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod * var_intracellular_calcium_concentration__beta_Calmod + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod + var_intracellular_calcium_concentration__Calmod) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Calmod; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod = 0.001 * var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__beta_Trop = 200.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Trop_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Trop * var_intracellular_calcium_concentration__beta_Trop + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Trop + var_intracellular_calcium_concentration__Trop) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Trop; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop = 0.001 * var_intracellular_calcium_concentration__Ca_Trop_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__length = 74.0; // micrometre
        const double var_intracellular_calcium_concentration__radius = 12.0; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926539999999e-9 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_e = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_e_ratio; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_calcium_release__SpeedRel = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0)); // dimensionless
        const double var_calcium_release__ActFrac_orig_deriv = var_calcium_release__ActRate * var_calcium_release__PrecFrac * var_calcium_release__SpeedRel - var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ActFrac = 0.001 * var_calcium_release__ActFrac_orig_deriv; // 1 / millisecond
        const double var_calcium_release__ProdFrac_orig_deriv = -1.0 * var_chaste_interface__calcium_release__ProdFrac * var_calcium_release__SpeedRel + var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ProdFrac = 0.001 * var_calcium_release__ProdFrac_orig_deriv; // 1 / millisecond
        const double var_intracellular_calcium_concentration__Ca_ds_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca_ds / (var_intracellular_calcium_concentration__V_ds_ratio * var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds = 0.001 * var_intracellular_calcium_concentration__Ca_ds_orig_deriv; // millimolar / millisecond
        const double var_potassium_background_current__g_bk = 0.0040000000000000001; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_potassium_background_current__i_b_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_bk; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_chaste_interface__extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sarcoplasmic_reticulum_calcium_pump__K_cyca = 0.00029999999999999997; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_srca = 0.5; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_xcs = 0.40000000000000002; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_1 = var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs / var_sarcoplasmic_reticulum_calcium_pump__K_srca; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_2 = var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 + var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs + var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_sarcoplasmic_reticulum_calcium_pump__K_cyca; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__alpha_up = 0.40000000000000002; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__beta_up = 0.029999999999999999; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__i_up = var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_sarcoplasmic_reticulum_calcium_pump__alpha_up / var_sarcoplasmic_reticulum_calcium_pump__K_2 - var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 * var_sarcoplasmic_reticulum_calcium_pump__beta_up / var_sarcoplasmic_reticulum_calcium_pump__K_2; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = -var_calcium_translocation__i_trans + var_intracellular_calcium_concentration__V_i_ratio * var_sarcoplasmic_reticulum_calcium_pump__i_up / var_intracellular_calcium_concentration__V_up_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_sodium_background_current__g_bna = 0.0001; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0050000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00020000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_intracellular_calcium_concentration__Ca_i_orig_deriv = -var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv - var_intracellular_calcium_concentration__Ca_Trop_orig_deriv - var_sarcoplasmic_reticulum_calcium_pump__i_up + var_calcium_release__i_rel * var_intracellular_calcium_concentration__V_rel_ratio / var_intracellular_calcium_concentration__V_i_ratio + var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay * var_intracellular_calcium_concentration__V_ds_ratio - 0.5 * (-2.0 * var_sodium_calcium_exchanger__i_NaCa_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_calcium_background_current__i_b_Ca) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.001 * var_intracellular_calcium_concentration__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_chaste_interface__extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Na_i_orig_deriv = -1.0 * (3.0 * var_sodium_calcium_exchanger__i_NaCa_cyt + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_fast_sodium_current__i_Na + var_sodium_background_current__i_b_Na) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = 0.001 * var_intracellular_sodium_concentration__Na_i_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K_max = 1.5; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__K_o * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.12; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.6699999999999999 * (10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.080000000000000002; // microS
        const double var_transient_outward_current__g_tos = 0.14999999999999999; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_extracellular_potassium_concentration__K_o_orig_deriv = -(-var_extracellular_potassium_concentration__K_b + var_chaste_interface__extracellular_potassium_concentration__K_o) * var_extracellular_potassium_concentration__pf + (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_potassium_background_current__i_b_K + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / (var_intracellular_calcium_concentration__V_e * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_extracellular_potassium_concentration__K_o = 0.001 * var_extracellular_potassium_concentration__K_o_orig_deriv; // millimolar / millisecond
        const double var_intracellular_potassium_concentration__K_i_orig_deriv = -1.0 * (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_potassium_background_current__i_b_K + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.001 * var_intracellular_potassium_concentration__K_i_orig_deriv; // millimolar / millisecond
        
        rResidual[8] = rCurrentGuess[8] - rY[1] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
        rResidual[0] = rCurrentGuess[0] - rY[7] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2;
        rResidual[1] = rCurrentGuess[1] - rY[8] - mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds;
        rResidual[2] = rCurrentGuess[2] - rY[11] - mDt*d_dt_chaste_interface_var_calcium_release__ActFrac;
        rResidual[3] = rCurrentGuess[3] - rY[12] - mDt*d_dt_chaste_interface_var_calcium_release__ProdFrac;
        rResidual[12] = rCurrentGuess[12] - rY[13] - mDt*d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
        rResidual[4] = rCurrentGuess[4] - rY[14] - mDt*d_dt_chaste_interface_var_extracellular_potassium_concentration__K_o;
        rResidual[11] = rCurrentGuess[11] - rY[15] - mDt*d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
        rResidual[7] = rCurrentGuess[7] - rY[16] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds;
        rResidual[10] = rCurrentGuess[10] - rY[17] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        rResidual[9] = rCurrentGuess[9] - rY[18] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        rResidual[5] = rCurrentGuess[5] - rY[19] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod;
        rResidual[6] = rCurrentGuess[6] - rY[20] - mDt*d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop;
    }

    void Cellespinosa_model_1998_normalFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[13], double rJacobian[13][13])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.27784
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[2];
        // Units: dimensionless; Initial value: 2.3455e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[3];
        // Units: dimensionless; Initial value: 0.003956
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[4];
        // Units: dimensionless; Initial value: 0.9759885
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.06884e-12
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9999977
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.954689
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[10];
        // Units: dimensionless; Initial value: 2.4223e-05
        
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rCurrentGuess[1];
        double var_chaste_interface__calcium_release__ActFrac = rCurrentGuess[2];
        double var_chaste_interface__calcium_release__ProdFrac = rCurrentGuess[3];
        double var_chaste_interface__extracellular_potassium_concentration__K_o = rCurrentGuess[4];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rCurrentGuess[5];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rCurrentGuess[6];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rCurrentGuess[7];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rCurrentGuess[8];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rCurrentGuess[9];
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rCurrentGuess[10];
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rCurrentGuess[11];
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rCurrentGuess[12];
        
        const double var_x0 = 0.001 + var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
        const double var_x1 = 0.00050000000000000001 + var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = var_x2 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x4 = 0.01 + var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
        const double var_x5 = 1 / var_x4;
        const double var_x6 = 1.0 - var_x3;
        const double var_x7 = var_x5 * var_x6;
        const double var_x8 = var_x3 + var_x7 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
        const double var_x9 = 0.5 * pow(var_x8, 2);
        const double var_x10 = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0));
        const double var_x11 = -var_x10 * var_x9;
        const double var_x12 = 1.0 - var_chaste_interface__calcium_release__ActFrac - var_chaste_interface__calcium_release__ProdFrac;
        const double var_x13 = 2 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
        const double var_x14 = 0.5 * var_x10 * var_x8;
        const double var_x15 = var_x14 * (2 * var_x7 - var_x13 * var_x6 / pow(var_x4, 2));
        const double var_x16 = var_x15 * var_chaste_interface__calcium_release__ActFrac;
        const double var_x17 = var_chaste_interface__intracellular_calcium_concentration__Ca_i / pow(var_x1, 2);
        const double var_x18 = var_x14 * (-2 * var_x17 + 2 * var_x2 + var_x13 * var_x5 * (var_x17 - var_x2));
        const double var_x19 = var_x18 * var_chaste_interface__calcium_release__ActFrac;
        const double var_x20 = exp(1.8716945411372736);
        const double var_x21 = -0.037433890822745473 * var_chaste_interface__membrane__V;
        const double var_x22 = exp(1.8716945411372736 + var_x21);
        const double var_x23 = (-50.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x24 = var_x23 / (1.0 - var_x22);
        const double var_x25 = var_x24 * (var_x20 * var_chaste_interface__intracellular_potassium_concentration__K_i - var_x22 * var_chaste_interface__extracellular_potassium_concentration__K_o);
        const double var_x26 = 1 / var_chaste_interface__extracellular_potassium_concentration__K_o;
        const double var_x27 = exp(var_x21);
        const double var_x28 = 8.2927354147114596e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x29 = 1 / var_chaste_interface__intracellular_potassium_concentration__K_i;
        const double var_x30 = var_x29 * var_chaste_interface__extracellular_potassium_concentration__K_o;
        const double var_x31 = log(var_x30);
        const double var_x32 = exp(0.6251459767398494 + 0.062514597673984929 * var_chaste_interface__membrane__V - 1.6699999999999999 * var_x31);
        const double var_x33 = 1.0 + var_x32;
        const double var_x34 = 1 / var_x33;
        const double var_x35 = 1 / (10.0 + var_chaste_interface__extracellular_potassium_concentration__K_o);
        const double var_x36 = var_x34 * var_x35;
        const double var_x37 = 0.0024811376697271795 * var_x36;
        const double var_x38 = -26.713760659695652 * var_x31 + var_chaste_interface__membrane__V;
        const double var_x39 = var_x36 * var_x38;
        const double var_x40 = 26.713760659695652 * var_chaste_interface__transient_outward_current_r_gate__r;
        const double var_x41 = var_x40 * (9.2878636644768338e-6 + 5.2631227432035395e-5 * var_chaste_interface__transient_outward_current_s_gate__s);
        const double var_x42 = 1.0 + var_chaste_interface__extracellular_potassium_concentration__K_o;
        const double var_x43 = 1 / var_x42;
        const double var_x44 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Na_i);
        const double var_x45 = var_x43 * var_x44;
        const double var_x46 = 0.001083584094188964 * var_x45;
        const double var_x47 = var_chaste_interface__extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i;
        const double var_x48 = var_x44 * var_x47 / pow(var_x42, 2);
        const double var_x49 = var_x32 * var_x35 * var_x38 / pow(var_x33, 2);
        const double var_x50 = 0.00015510732319676314 * var_x49;
        const double var_x51 = var_x34 * var_x38 * var_chaste_interface__extracellular_potassium_concentration__K_o / pow((1 + 0.10000000000000001 * var_chaste_interface__extracellular_potassium_concentration__K_o), 2);
        const double var_x52 = var_x24 * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds;
        const double var_x53 = 5.2152131158885572e-9 * var_x52;
        const double var_x54 = var_x43 * var_x47 / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i), 2);
        const double var_x55 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x56 = -var_x55;
        const double var_x57 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod;
        const double var_x58 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_Trop;
        const double var_x59 = exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V);
        const double var_x60 = exp(3.7433890822745473);
        const double var_x61 = 2.8382112195311879e-5 * var_x23 / (1.0 - var_x59);
        const double var_x62 = 0.25 + var_chaste_interface__calcium_release__ActFrac;
        const double var_x63 = pow(var_x62, (-2));
        const double var_x64 = var_x63 * var_chaste_interface__calcium_release__ActFrac;
        const double var_x65 = pow(var_chaste_interface__calcium_release__ActFrac, 2);
        const double var_x66 = var_x65 / pow(var_x62, 3);
        const double var_x67 = 0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x68 = 1 / var_x67;
        const double var_x69 = pow(var_x67, (-2));
        const double var_x70 = var_x69 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x71 = var_x69 * var_chaste_interface__intracellular_calcium_concentration__Ca_up;
        const double var_x72 = 0.018716945411372737 * var_chaste_interface__membrane__V;
        const double var_x73 = exp(-var_x72);
        const double var_x74 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
        const double var_x75 = pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3.0);
        const double var_x76 = 1 / (1.0 + 0.012500000000000001 * var_x75 + 16373.795625000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
        const double var_x77 = var_x74 * var_x76;
        const double var_x78 = var_x73 * var_x77;
        const double var_x79 = exp(var_x72);
        const double var_x80 = 2.5 * var_x75 * var_x79 - 3274759.125 * var_x73 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
        const double var_x81 = var_x74 * var_x80 / pow((6.1073194200199382e-5 + 7.6341492750249225e-7 * var_x75 + var_chaste_interface__intracellular_calcium_concentration__Ca_i), 2);
        const double var_x82 = var_x76 * var_x80 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Ca_i), 2);
        const double var_x83 = var_x63 * var_x65;
        const double var_x84 = pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 2.0);
        const double var_x85 = var_x77 * var_x79 * var_x84;
        const double var_x86 = var_x81 * var_x84;
        const double var_x87 = 6.769579930376702e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
        const double var_x88 = 0.0020254185058997385 * var_x36;
        const double var_x89 = 0.00088455844423588909 * var_x45;
        const double var_x90 = var_x40 * (-7.5819295220219063e-6 - 4.2964267291457472e-5 * var_chaste_interface__transient_outward_current_s_gate__s);
        const double var_x91 = 0.00012661822301776582 * var_x49;
        const double var_x92 = 4.2573168292967824e-9 * var_x52;
        const double var_x93 = 1.419105609765594e-8 * var_x24;
        const double var_x94 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x95 = 0.001215251103539843 * var_x94;
        const double var_x96 = 0.0013268376663538336 * var_x45;
        const double var_x97 = 1 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i);
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.001));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = -(mDt * (-0.001 / (100000.0 + var_chaste_interface__intracellular_calcium_concentration__Ca_i) + 1.0e-13 * var_chaste_interface__intracellular_calcium_concentration__Ca_i / pow((1 + 1.0000000000000001e-5 * var_chaste_interface__intracellular_calcium_concentration__Ca_i), 2)));
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (-0.02));
        rJacobian[1][2] = 0.0;
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = -(mDt * (-0.02 / var_x0 + 0.02 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds / pow(var_x0, 2)));
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = 0.0;
        rJacobian[2][2] = 1.0 - (mDt * (var_x11 + var_x10 * (-0.059999999999999998 - var_x9)));
        rJacobian[2][3] = -(mDt * (var_x11));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = -(mDt * (-var_x16 + var_x12 * var_x15));
        rJacobian[2][8] = -(mDt * (-var_x19 + var_x12 * var_x18));
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = -(mDt * (var_x10 * (0.059999999999999998 + var_x9)));
        rJacobian[3][3] = 1.0 - (mDt * (-0.001 * var_x10));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = 0.0;
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = -(mDt * (var_x16));
        rJacobian[3][8] = -(mDt * (var_x19));
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = -(mDt * (5.2152131158885572e-9 * var_x25));
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (-0.00069999999999999999 + var_x50 - var_x37 + 0.001083584094188964 * var_x48 + 9.2878636644768344e-5 * var_x39 - 8.2704588990905987e-5 * var_x26 - 9.2878636644768348e-7 * var_x51 - var_x22 * var_x53 - var_x26 * var_x41 - var_x27 * var_x28 - var_x46 * var_chaste_interface__intracellular_sodium_concentration__Na_i));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = -(mDt * (var_x28 + 8.2704588990905987e-5 * var_x29 + var_x20 * var_x53 + var_x29 * var_x41 + var_x30 * var_x37 - var_x30 * var_x50));
        rJacobian[4][12] = -(mDt * (6.7724005886810246e-7 * var_x54 - var_x46 * var_chaste_interface__extracellular_potassium_concentration__K_o));
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = 0.0;
        rJacobian[5][5] = 1.0 - (mDt * (-0.050000000000000003 + var_x56));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = -(mDt * (2.0 - var_x57));
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.20000000000000001 + var_x56));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = -(mDt * (5.0 - var_x58));
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = -(mDt * (-var_x61 * (-2.5 * var_x59 + var_x60 * var_chaste_interface__intracellular_calcium_concentration__Ca_i)));
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (-0.01));
        rJacobian[7][8] = -(mDt * (-var_x60 * var_x61 * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds));
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = -(mDt * ((0.10204081632653063 * var_x64 - 0.10204081632653063 * var_x66) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel));
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = -(mDt * (0.050000000000000003 + var_x55));
        rJacobian[8][6] = -(mDt * (0.20000000000000001 + var_x55));
        rJacobian[8][7] = -(mDt * (0.001));
        rJacobian[8][8] = 1.0 - (mDt * (-7.0 + var_x57 + var_x58 + 0.00040000000000000002 * var_x70 - 0.00040000000000000002 * var_x68 - 1.0549054718227806e-6 / var_chaste_interface__intracellular_calcium_concentration__Ca_i - 0.41340273157434632 * var_x78 - 7.7098266909426358e-12 * var_x81 - 8.7104997313748673e-10 * var_x82 - 7.1999999999999991e-9 * var_x71));
        rJacobian[8][9] = -(mDt * (1.0204081632653063e-5 + 0.051020408163265314 * var_x83));
        rJacobian[8][10] = -(mDt * (9.5999999999999999e-8 * var_x70 + 7.1999999999999991e-9 * var_x68 - 1.7279999999999999e-12 * var_x71));
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = -(mDt * (9.4679344906248566e-7 * var_x85 - 1.7657390352968255e-17 * var_x86));
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = -(mDt * ((0.5 * var_x66 - 0.5 * var_x64) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel));
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (-0.0050499999999999998 - 0.25 * var_x83));
        rJacobian[9][10] = -(mDt * (0.0050000000000000001));
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = -(mDt * (0.019599999999999999 * var_x68 + 3.5279999999999993e-7 * var_x71 - 0.019599999999999999 * var_x70));
        rJacobian[10][9] = -(mDt * (0.050000000000000003));
        rJacobian[10][10] = 1.0 - (mDt * (-0.050000000000000003 + 8.4671999999999982e-11 * var_x71 - 3.5279999999999993e-7 * var_x68 - 4.7039999999999993e-6 * var_x70));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = -(mDt * (-4.2573168292967824e-9 * var_x25));
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = -(mDt * (var_x88 - var_x91 + 7.5819295220219063e-7 * var_x51 + 6.7513950196657958e-5 * var_x26 - 0.00088455844423588909 * var_x48 - 7.5819295220219067e-5 * var_x39 + var_x22 * var_x92 + var_x27 * var_x87 + var_x89 * var_chaste_interface__intracellular_sodium_concentration__Na_i - var_x26 * var_x90));
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (-var_x87 - 6.7513950196657958e-5 * var_x29 + var_x29 * var_x90 + var_x30 * var_x91 - var_x20 * var_x92 - var_x30 * var_x88));
        rJacobian[11][12] = -(mDt * (-5.5284902764743069e-7 * var_x54 + var_x89 * var_chaste_interface__extracellular_potassium_concentration__K_o));
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = -(mDt * (-var_x93 * (-148.5 * var_x22 + var_x20 * var_chaste_interface__intracellular_sodium_concentration__Na_i)));
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = -(mDt * (0.0013268376663538336 * var_x48 + var_x95 / (148.5 + 0.12 * var_chaste_interface__extracellular_potassium_concentration__K_o) - var_x96 * var_chaste_interface__intracellular_sodium_concentration__Na_i));
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = -(mDt * (2.3129480072827907e-11 * var_x81 + 1.240208194723039 * var_x78 + 2.6131499194124605e-9 * var_x82));
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = -(mDt * (-var_x95 * var_x97));
        rJacobian[12][12] = 1.0 - (mDt * (8.2927354147114598e-7 * var_x54 + 5.2972171058904767e-17 * var_x86 - 2.8403803471874568e-6 * var_x85 - 1.6878487549164488e-6 / var_chaste_interface__intracellular_sodium_concentration__Na_i - var_x96 * var_chaste_interface__extracellular_potassium_concentration__K_o - 0.010127092529498692 * var_x94 * var_x97 - var_x20 * var_x93 * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds));
    }

    void Cellespinosa_model_1998_normalFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.27784
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 7.07933e-05
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[2];
        // Units: dimensionless; Initial value: 2.3455e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[3];
        // Units: dimensionless; Initial value: 0.003956
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[4];
        // Units: dimensionless; Initial value: 0.9759885
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.06884e-12
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9999977
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[7];
        // Units: dimensionless; Initial value: 0.994096
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[8];
        // Units: dimensionless; Initial value: 0.4387865
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.954689
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[10];
        // Units: dimensionless; Initial value: 2.4223e-05
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[13];
        // Units: millimolar; Initial value: 6.835
        double var_chaste_interface__extracellular_potassium_concentration__K_o = rY[14];
        // Units: millimolar; Initial value: 5.3201028
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[15];
        // Units: millimolar; Initial value: 140.1333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[16];
        // Units: millimolar; Initial value: 0.0008364
        
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.0030000000000000001; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.059999999999999998; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_extracellular_calcium_concentration__Ca_o = 2.5; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 148.5; // millimolar
        const double var_fast_sodium_current__g_Na = 0.59999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_chaste_interface__extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
        const double var_potassium_background_current__g_bk = 0.0040000000000000001; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_potassium_background_current__i_b_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_bk; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_chaste_interface__extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__g_bna = 0.0001; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0050000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00020000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_chaste_interface__extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 1.5; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_chaste_interface__extracellular_potassium_concentration__K_o * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.12; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.6699999999999999 * (10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.080000000000000002; // microS
        const double var_transient_outward_current__g_tos = 0.14999999999999999; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_membrane__i_Stim + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellespinosa_model_1998_normalFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.27784
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[2];
        // Units: dimensionless; Initial value: 2.3455e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[3];
        // Units: dimensionless; Initial value: 0.003956
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[4];
        // Units: dimensionless; Initial value: 0.9759885
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 3.06884e-12
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.9999977
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.954689
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[10];
        // Units: dimensionless; Initial value: 2.4223e-05
        
        const double var_L_type_Ca_channel_d_gate__speed_d = 10.0;
        const double var_L_type_Ca_channel_f_gate__delta_f = 0.0001;
        const double var_L_type_Ca_channel_f_gate__speed_f = 2.0;
        const double var_fast_sodium_current_h_gate__shift_h = 0;
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5;
        const double var_L_type_Ca_channel_d_gate__E0_d = 4.0 + var_chaste_interface__membrane__V;
        const double var_L_type_Ca_channel_d_gate__alpha_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (30.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(-0.33333333333333331 * var_L_type_Ca_channel_d_gate__E0_d))));
        const double var_L_type_Ca_channel_d_gate__beta_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (12.0 * var_L_type_Ca_channel_d_gate__E0_d / (-1.0 + exp(0.13333333333333333 * var_L_type_Ca_channel_d_gate__E0_d))));
        const double var_L_type_Ca_channel_f_gate__E0_f = 24.0 + var_chaste_interface__membrane__V;
        const double var_L_type_Ca_channel_f_gate__alpha_f = ((var_L_type_Ca_channel_f_gate__delta_f > fabs(var_L_type_Ca_channel_f_gate__E0_f)) ? (25.0) : (6.25 * var_L_type_Ca_channel_f_gate__E0_f / (-1.0 + exp(0.18181818181818182 * var_L_type_Ca_channel_f_gate__E0_f))));
        const double var_L_type_Ca_channel_f_gate__beta_f = 12.0 / (1.0 + exp(-6.1818181818181817 - 0.18181818181818182 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * var_fast_sodium_current_h_gate__shift_h - 0.125 * var_chaste_interface__membrane__V);
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * var_fast_sodium_current_h_gate__shift_h - 0.10000000000000001 * var_chaste_interface__membrane__V));
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V;
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m))));
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
        const double var_time_dependent_potassium_current_x_gate__E0_x = -18.0 + var_chaste_interface__membrane__V;
        const double var_time_dependent_potassium_current_x_gate__delta_x = 0.0001;
        const double var_time_dependent_potassium_current_x_gate__alpha_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (1.5 * var_time_dependent_potassium_current_x_gate__E0_x / (1.0 - exp(-0.20000000000000001 * var_time_dependent_potassium_current_x_gate__E0_x))));
        const double var_time_dependent_potassium_current_x_gate__beta_x = ((var_time_dependent_potassium_current_x_gate__delta_x > fabs(var_time_dependent_potassium_current_x_gate__E0_x)) ? (2.5) : (0.53400000000000003 * var_time_dependent_potassium_current_x_gate__E0_x / (-1.0 + exp(0.066666666666666666 * var_time_dependent_potassium_current_x_gate__E0_x))));
        const double var_transient_outward_current_s_gate__alpha_s = 0.0085800000000000008 * exp(-0.067226890756302518 * var_chaste_interface__membrane__V);
        const double var_transient_outward_current_s_gate__beta_s = 8.5800000000000001 / (1.0 + exp(-1.4285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V));
        
        
        rY[5] = (var_chaste_interface__L_type_Ca_channel_d_gate__d + ((0.001 * var_L_type_Ca_channel_d_gate__alpha_d * var_L_type_Ca_channel_d_gate__speed_d) * mDt)) / (1.0 - ((-0.001 * var_L_type_Ca_channel_d_gate__alpha_d * var_L_type_Ca_channel_d_gate__speed_d - 0.001 * var_L_type_Ca_channel_d_gate__beta_d * var_L_type_Ca_channel_d_gate__speed_d) * mDt));
        rY[6] = (var_chaste_interface__L_type_Ca_channel_f_gate__f + ((0.001 * var_L_type_Ca_channel_f_gate__alpha_f * var_L_type_Ca_channel_f_gate__speed_f) * mDt)) / (1.0 - ((-0.001 * var_L_type_Ca_channel_f_gate__alpha_f * var_L_type_Ca_channel_f_gate__speed_f - 0.001 * var_L_type_Ca_channel_f_gate__beta_f * var_L_type_Ca_channel_f_gate__speed_f) * mDt));
        rY[4] = (var_chaste_interface__fast_sodium_current_h_gate__h + ((0.001 * var_fast_sodium_current_h_gate__alpha_h) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_h_gate__alpha_h - 0.001 * var_fast_sodium_current_h_gate__beta_h) * mDt));
        rY[3] = (var_chaste_interface__fast_sodium_current_m_gate__m + ((0.001 * var_fast_sodium_current_m_gate__alpha_m) * mDt)) / (1.0 - ((-0.001 * var_fast_sodium_current_m_gate__alpha_m - 0.001 * var_fast_sodium_current_m_gate__beta_m) * mDt));
        rY[2] = (var_chaste_interface__time_dependent_potassium_current_x_gate__x + ((0.001 * var_time_dependent_potassium_current_x_gate__alpha_x) * mDt)) / (1.0 - ((-0.001 * var_time_dependent_potassium_current_x_gate__alpha_x - 0.001 * var_time_dependent_potassium_current_x_gate__beta_x) * mDt));
        rY[10] = (var_chaste_interface__transient_outward_current_r_gate__r + ((0.33300000000000002 / (1.0 + exp(2.0 - 0.10000000000000001 * var_chaste_interface__membrane__V))) * mDt)) / (1.0 - ((-0.33300000000000002) * mDt));
        rY[9] = (var_chaste_interface__transient_outward_current_s_gate__s + ((0.001 * var_transient_outward_current_s_gate__alpha_s) * mDt)) / (1.0 - ((-0.001 * var_transient_outward_current_s_gate__alpha_s - 0.001 * var_transient_outward_current_s_gate__beta_s) * mDt));
        
        double _guess[13] = {rY[7],rY[8],rY[11],rY[12],rY[14],rY[19],rY[20],rY[16],rY[1],rY[18],rY[17],rY[15],rY[13]};
        CardiacNewtonSolver<13,Cellespinosa_model_1998_normalFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<13,Cellespinosa_model_1998_normalFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[7] = _guess[0];
        rY[8] = _guess[1];
        rY[11] = _guess[2];
        rY[12] = _guess[3];
        rY[14] = _guess[4];
        rY[19] = _guess[5];
        rY[20] = _guess[6];
        rY[16] = _guess[7];
        rY[1] = _guess[8];
        rY[18] = _guess[9];
        rY[17] = _guess[10];
        rY[15] = _guess[11];
        rY[13] = _guess[12];
    }

    std::vector<double> Cellespinosa_model_1998_normalFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellespinosa_model_1998_normalFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "espinosa_model_1998_normal";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-86.27784);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.07933e-05);

    // rY[2]:
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.3455e-06);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003956);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9759885);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.06884e-12);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999977);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.994096);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_channel_f2ds_gate__f2ds");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4387865);

    // rY[9]:
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.954689);

    // rY[10]:
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.4223e-05);

    // rY[11]:
    this->mVariableNames.push_back("calcium_release__ActFrac");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113161);

    // rY[12]:
    this->mVariableNames.push_back("calcium_release__ProdFrac");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9402563);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(6.835);

    // rY[14]:
    this->mVariableNames.push_back("extracellular_potassium_concentration__K_o");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.3201028);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.1333);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_ds");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0008364);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.479749);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.43984);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_Calmod");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0024448);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_Trop");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0017012);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellespinosa_model_1998_normalFromCellMLBackwardEuler)
