//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: demir_model_1994
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "demir_model_1994.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    double Celldemir_model_1994FromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldemir_model_1994FromCellMLBackwardEuler::Celldemir_model_1994FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<16>(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldemir_model_1994FromCellMLBackwardEuler>::Instance();
        Init();
        
        this->mParameters[0] = 5.5000000000000002e-5; // (var_membrane__Cm) [microF]
    }

    Celldemir_model_1994FromCellMLBackwardEuler::~Celldemir_model_1994FromCellMLBackwardEuler()
    {
    }
    
    double Celldemir_model_1994FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f + var_linear_background_current__i_B + var_sodium_calcium_pump__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldemir_model_1994FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[16], double rResidual[16])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rCurrentGuess[0];
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rCurrentGuess[1];
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rCurrentGuess[2];
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rCurrentGuess[3];
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rCurrentGuess[4];
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rCurrentGuess[5];
        double var_chaste_interface__cleft_space_equations__Ca_c = rCurrentGuess[6];
        double var_chaste_interface__cleft_space_equations__K_c = rCurrentGuess[7];
        double var_chaste_interface__cleft_space_equations__Na_c = rCurrentGuess[8];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rCurrentGuess[9];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rCurrentGuess[10];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rCurrentGuess[11];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rCurrentGuess[12];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rCurrentGuess[13];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rCurrentGuess[14];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rCurrentGuess[15];
        
        //output_equations
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_SR_Ca_uptake_and_release__alpha_rel = 0.5; // nanoA_per_millimolar
        const double var_SR_Ca_uptake_and_release__alpha_up = 0.080000000000000002; // nanoA
        const double var_SR_Ca_uptake_and_release__beta_up = 0.071999999999999995; // nanoA
        const double var_SR_Ca_uptake_and_release__i_rel = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel * var_SR_Ca_uptake_and_release__alpha_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__k_SRCa = 22.0; // millimolar
        const double var_SR_Ca_uptake_and_release__k_cyca = 5.0000000000000002e-5; // millimolar
        const double var_SR_Ca_uptake_and_release__k_rel = 0.0040000000000000001; // millimolar
        const double var_SR_Ca_uptake_and_release__k_xcs = 0.90000000000000002; // dimensionless
        const double var_SR_Ca_uptake_and_release__K1 = var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs / var_SR_Ca_uptake_and_release__k_SRCa; // dimensionless
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv = var_SR_Ca_uptake_and_release__phi_Calse; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse = 0.001 * var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__Ca_b = 2.0; // millimolar
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_equations__Na_b = 140.0; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_cleft_space_equations__V_c = 0.13600000000000001 * var_cleft_space_equations__Vol; // microLitre
        const double var_cleft_space_equations__tau_p = 0.01; // second
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_SR_Ca_uptake_and_release__K2 = var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 + var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs + var_SR_Ca_uptake_and_release__k_cyca + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // millimolar
        const double var_SR_Ca_uptake_and_release__i_up = (var_SR_Ca_uptake_and_release__alpha_up * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 * var_SR_Ca_uptake_and_release__beta_up) / var_SR_Ca_uptake_and_release__K2; // nanoA
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F3_orig_deriv = -0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 + var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3 = 0.001 * var_SR_Ca_uptake_and_release__F3_orig_deriv; // 1 / millisecond
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__Mg_i = 2.5; // millimolar
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_SR_Ca_uptake_and_release__V_rel = 0.0012960000000000001 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_SR_Ca_uptake_and_release__V_up = 0.01166 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_C; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_C = 0.089999999999999997 * var_intracellular_concentrations_and_buffer_equations__phi_C; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_TC = 0.031 * var_intracellular_concentrations_and_buffer_equations__phi_TC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_TMgC = 0.062 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_B = var_intracellular_concentrations_and_buffer_equations__F_C + var_intracellular_concentrations_and_buffer_equations__F_TC + var_intracellular_concentrations_and_buffer_equations__F_TMgC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgM = -429.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop + 1290.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_intracellular_concentrations_and_buffer_equations__Mg_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgM; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv; // 1 / millisecond
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_SR_Ca_uptake_and_release__i_tr = 31.162355874104083 * (-var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel + var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) * var_SR_Ca_uptake_and_release__V_up * var_membrane__F; // nanoA
        const double var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv = -11.48 * var_SR_Ca_uptake_and_release__phi_Calse + 0.5 * (-var_SR_Ca_uptake_and_release__i_rel + var_SR_Ca_uptake_and_release__i_tr) / (var_SR_Ca_uptake_and_release__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel = 0.001 * var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_SR_Ca_uptake_and_release__Ca_up_orig_deriv = 0.5 * (-var_SR_Ca_uptake_and_release__i_tr + var_SR_Ca_uptake_and_release__i_up) / (var_SR_Ca_uptake_and_release__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up = 0.001 * var_SR_Ca_uptake_and_release__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F1_orig_deriv = 0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 - var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1 = 0.001 * var_SR_Ca_uptake_and_release__F1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__F2_orig_deriv = var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act - var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2 = 0.001 * var_SR_Ca_uptake_and_release__F2_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_cleft_space_equations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Ca_c + var_cleft_space_equations__Ca_b) / var_cleft_space_equations__tau_p + 0.5 * (-2.0 * var_sodium_calcium_pump__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_linear_background_current__i_B_Ca) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Ca_c = 0.001 * var_cleft_space_equations__Ca_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv = -var_intracellular_concentrations_and_buffer_equations__phi_B + 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_SR_Ca_uptake_and_release__i_up - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_linear_background_current__i_B_Ca + 2.0 * var_sodium_calcium_pump__i_NaCa + var_SR_Ca_uptake_and_release__i_rel) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_cleft_space_equations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__K_c + var_cleft_space_equations__K_b) / var_cleft_space_equations__tau_p + (-2.0 * var_sodium_potassium_pump__i_NaK + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f_K + var_linear_background_current__i_B_K) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__K_c = 0.001 * var_cleft_space_equations__K_c_orig_deriv; // millimolar / millisecond
        const double var_cleft_space_equations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Na_c + var_cleft_space_equations__Na_b) / var_cleft_space_equations__tau_p + (3.0 * var_sodium_calcium_pump__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_hyperpolarisation_activated_current__i_f_Na + var_linear_background_current__i_B_Na + var_sodium_current__i_Na) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Na_c = 0.001 * var_cleft_space_equations__Na_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv = (-var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f_K - var_linear_background_current__i_B_K + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv = (-var_hyperpolarisation_activated_current__i_f_Na - var_linear_background_current__i_B_Na - var_sodium_current__i_Na - 3.0 * var_sodium_calcium_pump__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv; // millimolar / millisecond
        
        rResidual[12] = rCurrentGuess[12] - rY[1] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
        rResidual[15] = rCurrentGuess[15] - rY[12] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
        rResidual[13] = rCurrentGuess[13] - rY[13] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
        rResidual[9] = rCurrentGuess[9] - rY[14] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
        rResidual[11] = rCurrentGuess[11] - rY[15] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
        rResidual[10] = rCurrentGuess[10] - rY[16] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
        rResidual[14] = rCurrentGuess[14] - rY[17] - mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
        rResidual[8] = rCurrentGuess[8] - rY[18] - mDt*d_dt_chaste_interface_var_cleft_space_equations__Na_c;
        rResidual[6] = rCurrentGuess[6] - rY[19] - mDt*d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
        rResidual[7] = rCurrentGuess[7] - rY[20] - mDt*d_dt_chaste_interface_var_cleft_space_equations__K_c;
        rResidual[2] = rCurrentGuess[2] - rY[21] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
        rResidual[1] = rCurrentGuess[1] - rY[22] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
        rResidual[0] = rCurrentGuess[0] - rY[23] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
        rResidual[3] = rCurrentGuess[3] - rY[24] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
        rResidual[4] = rCurrentGuess[4] - rY[25] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
        rResidual[5] = rCurrentGuess[5] - rY[26] - mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;
    }

    void Celldemir_model_1994FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time_converted, const double rCurrentGuess[16], double rJacobian[16][16])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rCurrentGuess[0];
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rCurrentGuess[1];
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rCurrentGuess[2];
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rCurrentGuess[3];
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rCurrentGuess[4];
        double var_chaste_interface__cleft_space_equations__Ca_c = rCurrentGuess[6];
        double var_chaste_interface__cleft_space_equations__K_c = rCurrentGuess[7];
        double var_chaste_interface__cleft_space_equations__Na_c = rCurrentGuess[8];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rCurrentGuess[9];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rCurrentGuess[10];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rCurrentGuess[11];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rCurrentGuess[12];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rCurrentGuess[13];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rCurrentGuess[14];
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rCurrentGuess[15];
        
        const double var_x0 = 0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2;
        const double var_x1 = pow(var_x0, (-2));
        const double var_x2 = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2);
        const double var_x3 = var_x1 * var_x2;
        const double var_x4 = 2.4589804690256458 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel;
        const double var_x5 = var_x2 / pow(var_x0, 3);
        const double var_x6 = var_x1 * var_chaste_interface__SR_Ca_uptake_and_release__F2;
        const double var_x7 = 9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x8 = 1 / var_x7;
        const double var_x9 = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / pow(var_x7, 2);
        const double var_x10 = 0.23999999999999999 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V);
        const double var_x11 = 0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x12 = pow(var_x11, (-4));
        const double var_x13 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4);
        const double var_x14 = 0.23999999999999999 * var_x12 * var_x13;
        const double var_x15 = -var_x14;
        const double var_x16 = 0.95999999999999996 * var_x13 / pow(var_x11, 5);
        const double var_x17 = 0.95999999999999996 * var_x12 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 3);
        const double var_x18 = var_x16 - var_x17;
        const double var_x19 = var_x17 - var_x16;
        const double var_x20 = 1 / var_chaste_interface__cleft_space_equations__Ca_c;
        const double var_x21 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
        const double var_x22 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
        const double var_x23 = var_x22 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x24 = var_x21 * var_chaste_interface__cleft_space_equations__Ca_c;
        const double var_x25 = 1.0 + 0.0001 * var_x23 + 0.0001 * var_x24;
        const double var_x26 = 0.018714999999999999 * var_chaste_interface__membrane__V;
        const double var_x27 = exp(var_x26);
        const double var_x28 = exp(-var_x26);
        const double var_x29 = (var_x24 * var_x27 - var_x23 * var_x28) / pow(var_x25, 2);
        const double var_x30 = 2.7196856284372237e-11 * var_x29;
        const double var_x31 = 1 / var_x25;
        const double var_x32 = 2.7196856284372236e-7 * var_x31;
        const double var_x33 = var_x21 * var_x27;
        const double var_x34 = 8.1590568853116704e-7 * var_x31;
        const double var_x35 = pow(var_chaste_interface__cleft_space_equations__Na_c, 2) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x36 = var_x28 * var_x35;
        const double var_x37 = 8.159056885311671e-11 * var_x29;
        const double var_x38 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x39 = 0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x40 = 1 / var_x39;
        const double var_x41 = var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / pow(var_x39, 2);
        const double var_x42 = var_x22 * var_x28;
        const double var_x43 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 2);
        const double var_x44 = var_x43 * var_chaste_interface__cleft_space_equations__Ca_c;
        const double var_x45 = var_x27 * var_x44;
        const double var_x46 = 1 / var_chaste_interface__cleft_space_equations__K_c;
        const double var_x47 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
        const double var_x48 = 0.010911506218902908 * var_x47;
        const double var_x49 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
        const double var_x50 = pow(var_x49, (-3));
        const double var_x51 = 0.00018782211067427598 * var_x50;
        const double var_x52 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
        const double var_x53 = 1 / (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V));
        const double var_x54 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
        const double var_x55 = var_x21 * var_x53 * var_x54;
        const double var_x56 = var_x55 / pow(var_x52, 3);
        const double var_x57 = pow(var_x52, (-2));
        const double var_x58 = var_x53 * var_x57;
        const double var_x59 = var_x21 * var_x58 * var_chaste_interface__cleft_space_equations__K_c;
        const double var_x60 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i;
        const double var_x61 = var_x55 * var_x57 / pow(var_x49, 4);
        const double var_x62 = var_x43 * var_x50 * var_x54 * var_x58;
        const double var_x63 = 0.00028173316601141397 * var_x50;
        const double var_x64 = 1 / var_chaste_interface__cleft_space_equations__Na_c;
        const double var_x65 = 2.447717065593501e-6 * var_x31;
        const double var_x66 = 2.4477170655935014e-10 * var_x29;
        const double var_x67 = 0.037433890822745473 * var_chaste_interface__membrane__V;
        const double var_x68 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
        const double var_x69 = var_x68 * var_chaste_interface__cleft_space_equations__Na_c;
        const double var_x70 = exp(var_x67 - 1.0 * log(var_x69));
        const double var_x71 = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(var_x67));
        const double var_x72 = var_x71 * (-1.0 + var_x70);
        const double var_x73 = var_x70 * var_x71;
        const double var_x74 = 0.27076272189238759 * var_x73;
        const double var_x75 = -129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x76 = 0.0031868386878572369 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel;
        const double var_x77 = 7.9543493648916641e-8 * var_x31;
        const double var_x78 = 7.9543493648916639e-12 * var_x29;
        const double var_x79 = 2.3863048094674991e-7 * var_x31;
        const double var_x80 = 2.3863048094674993e-11 * var_x29;
        const double var_x81 = 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        const double var_x82 = 0.0031913222489694526 * var_x47;
        const double var_x83 = 5.493291839075599e-5 * var_x50;
        const double var_x84 = 2.3863048094674993e-11 * var_x29;
        const double var_x85 = 2.3863048094674991e-7 * var_x31;
        const double var_x86 = 8.2399377586133985e-5 * var_x50;
        const double var_x87 = 7.158914428402498e-11 * var_x29;
        const double var_x88 = 7.1589144284024978e-7 * var_x31;
        const double var_x89 = 0.079190817585730572 * var_x73;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.64100000000000001 - 0.77000000000000002 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel));
        rJacobian[0][1] = -(mDt * (0.77000000000000002 - 0.77000000000000002 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse));
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = 0.0;
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = 0.0;
        rJacobian[0][15] = 0.0;
        rJacobian[1][0] = -(mDt * (7.3586800000000006 + 8.8396000000000008 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel));
        rJacobian[1][1] = 1.0 - (mDt * (-8.979782511378108 + 8.8396000000000008 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse - 1.2294902345128229 * var_x3));
        rJacobian[1][2] = -(mDt * (0.14018251137810708));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = -(mDt * (var_x4 * var_x5 - var_x4 * var_x6));
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (0.015581177937052042));
        rJacobian[2][2] = 1.0 - (mDt * (-0.015581177937052042 - 4.0251665946738841e-8 * var_x8 - 5.5905091592692838e-7 * var_x9));
        rJacobian[2][3] = 0.0;
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = 0.0;
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = -(mDt * (0.021865102489586532 * var_x8 - 0.27331378111983162 * var_x9));
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = 0.0;
        rJacobian[2][15] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = 0.0;
        rJacobian[3][3] = 1.0 - (mDt * (var_x15 - var_x10));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (0.00095999999999999992));
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = -(mDt * (var_x18 * var_chaste_interface__SR_Ca_uptake_and_release__F1));
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = -(mDt * (var_x10 + var_x14));
        rJacobian[4][4] = 1.0 - (mDt * (-0.040000000000000001 + var_x15));
        rJacobian[4][5] = 0.0;
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = -(mDt * (var_x18 * var_chaste_interface__SR_Ca_uptake_and_release__F2 + var_x19 * var_chaste_interface__SR_Ca_uptake_and_release__F1));
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = 0.0;
        rJacobian[5][4] = -(mDt * (0.040000000000000001 + var_x14));
        rJacobian[5][5] = 1.0 - (mDt * (-0.00095999999999999992));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = -(mDt * (var_x19 * var_chaste_interface__SR_Ca_uptake_and_release__F2));
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.099999999999999992 - 5.2976168399354324e-6 * var_x20 + var_x21 * var_x30 - var_x32 * var_x33));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = -(mDt * (var_x34 * var_x36 + var_x35 * var_x37));
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = -(mDt * (5.2976168399354324e-6 * var_x38 + 0.00031261130080073693 * var_x40 - 0.00031261130080073693 * var_x41 + var_x22 * var_x30 + var_x32 * var_x42));
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = -(mDt * (var_x37 * var_x44 - var_x34 * var_x45));
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (-0.099999999999999992 - 4.040160535071638e-5 * var_x46 + var_x51 * var_x56 - var_x46 * var_x48 - var_x51 * var_x59));
        rJacobian[7][8] = 0.0;
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = -(mDt * (4.040160535071638e-5 * var_x60 + var_x48 * var_x60));
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = -(mDt * (5.1599480954471424e-5 * var_x61 - 0.00028173316601141397 * var_x62));
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = -(mDt * (var_x33 * var_x34 - var_x21 * var_x37));
        rJacobian[8][7] = -(mDt * (var_x59 * var_x63 - var_x56 * var_x63));
        rJacobian[8][8] = 1.0 - (mDt * (-0.099999999999999992 - var_x74 + 0.27076272189238759 * var_x72 - 9.3144911471392233e-5 * var_x64 - var_x35 * var_x66 - var_x36 * var_x65));
        rJacobian[8][9] = 0.0;
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = 0.0;
        rJacobian[8][12] = -(mDt * (-var_x22 * var_x37 - var_x34 * var_x42));
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = -(mDt * (9.3144911471392233e-5 * var_x68 + 0.00042259974901712096 * var_x62 - 7.739922143170714e-5 * var_x61 + var_x45 * var_x65 + var_x69 * var_x74 - var_x44 * var_x66));
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (-0.307 + var_x75));
        rJacobian[9][10] = 0.0;
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = -(mDt * (129.0 - 129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod));
        rJacobian[9][13] = 0.0;
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = 0.0;
        rJacobian[10][10] = 1.0 - (mDt * (-0.0042500000000000003 + var_x75));
        rJacobian[10][11] = 0.0;
        rJacobian[10][12] = -(mDt * (129.0 - 129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - 129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop));
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = -(mDt * (var_x75));
        rJacobian[10][15] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = 0.0;
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = 0.0;
        rJacobian[11][11] = 1.0 - (mDt * (-0.252 - 50.5 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i));
        rJacobian[11][12] = -(mDt * (50.5 - 50.5 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop));
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = 0.0;
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = -(mDt * (0.0015934193439286184 * var_x3));
        rJacobian[12][2] = -(mDt * (4.6933442493897489e-10 * var_x8 + 6.5185336797079855e-9 * var_x9));
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = -(mDt * (var_x6 * var_x76 - var_x5 * var_x76));
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = -(mDt * (1.5494105166262771e-6 * var_x20 + var_x33 * var_x77 - var_x21 * var_x78));
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = -(mDt * (-var_x35 * var_x80 - var_x36 * var_x79));
        rJacobian[12][9] = -(mDt * (0.027629999999999998 + 11.609999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i));
        rJacobian[12][10] = -(mDt * (0.00026350000000000001 + var_x81));
        rJacobian[12][11] = -(mDt * (0.0078120000000000004 + 1.5654999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i));
        rJacobian[12][12] = 1.0 - (mDt * (-21.173500000000001 + 9.1430401954624137e-5 * var_x41 + 11.609999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 1.5654999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 0.0031868386878572369 * var_x9 + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop - 9.1430401954624137e-5 * var_x40 - 0.00025494709502857897 * var_x8 - 1.5494105166262771e-6 * var_x38 - var_x22 * var_x78 - var_x42 * var_x77));
        rJacobian[12][13] = 0.0;
        rJacobian[12][14] = -(mDt * (var_x81));
        rJacobian[12][15] = -(mDt * (var_x45 * var_x79 - var_x44 * var_x80));
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = 0.0;
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = -(mDt * (1.1816383500424576e-5 * var_x46 + var_x46 * var_x82 + var_x59 * var_x83 - var_x56 * var_x83));
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = 0.0;
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = 0.0;
        rJacobian[13][13] = 1.0 - (mDt * (-1.1816383500424576e-5 * var_x60 - var_x60 * var_x82));
        rJacobian[13][14] = 0.0;
        rJacobian[13][15] = -(mDt * (8.2399377586133985e-5 * var_x62 - 1.5091461096361535e-5 * var_x61));
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = -(mDt * (-3.2250000000000001));
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = 0.0;
        rJacobian[14][13] = 0.0;
        rJacobian[14][14] = 1.0 - (mDt * (-3.6539999999999999));
        rJacobian[14][15] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = 0.0;
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = -(mDt * (var_x21 * var_x84 - var_x33 * var_x85));
        rJacobian[15][7] = -(mDt * (var_x56 * var_x86 - var_x59 * var_x86));
        rJacobian[15][8] = -(mDt * (var_x89 + 2.7242382709912566e-5 * var_x64 - 0.079190817585730572 * var_x72 + var_x35 * var_x87 + var_x36 * var_x88));
        rJacobian[15][9] = 0.0;
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = 0.0;
        rJacobian[15][12] = -(mDt * (var_x22 * var_x84 + var_x42 * var_x85));
        rJacobian[15][13] = 0.0;
        rJacobian[15][14] = 0.0;
        rJacobian[15][15] = 1.0 - (mDt * (2.2637191644542304e-5 * var_x61 - 0.00012359906637920097 * var_x62 - 2.7242382709912566e-5 * var_x68 + var_x44 * var_x87 - var_x45 * var_x88 - var_x69 * var_x89));
    }

    void Celldemir_model_1994FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f - var_linear_background_current__i_B - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / second
        const double d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Celldemir_model_1994FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = -28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_d_gate__beta_d_L = 11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 1 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L);
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = 3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_gate__beta_f_L = 30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V));
        const double var_L_type_Ca_channel_f_gate__tau_f_L = 1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L);
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V);
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V);
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V));
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T);
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = 15.300000000000001 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V);
        const double var_T_type_Ca_channel_f_gate__beta_f_T = 15.0 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V);
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V));
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T);
        const double var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity = 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V));
        const double var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a = 1 / (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__V) + 2.1099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__V));
        const double var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i = 100.0 * exp(-0.0183 * var_chaste_interface__membrane__V);
        const double var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i = 656.0 * exp(0.0094199999999999996 * var_chaste_interface__membrane__V);
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (1.6483000000000001 * exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V) + 14.01055 / (0.69999999999999996 + exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V)));
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(8.0222222222222221 + 0.1111111111111111 * var_chaste_interface__membrane__V));
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V);
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V));
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1);
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity;
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1);
        const double var_sodium_current_h_gate__tau_h2 = 20.0 * var_sodium_current_h_gate__tau_h1;
        const double var_sodium_current_m_gate__alpha_m = -824.0 * (51.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V));
        const double var_sodium_current_m_gate__beta_m = 32960.0 * exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V);
        const double var_sodium_current_m_gate__m_infinity = var_sodium_current_m_gate__alpha_m / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m);
        const double var_sodium_current_m_gate__tau_m = 1.5e-5 + 1 / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m);
        
        
        rY[5] = (var_chaste_interface__L_type_Ca_channel_d_gate__d_L + ((0.001 * var_L_type_Ca_channel_d_gate__d_L_infinity / var_L_type_Ca_channel_d_gate__tau_d_L) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_channel_d_gate__tau_d_L) * mDt));
        rY[6] = (var_chaste_interface__L_type_Ca_channel_f_gate__f_L + ((0.001 * var_L_type_Ca_channel_f_gate__f_L_infinity / var_L_type_Ca_channel_f_gate__tau_f_L) * mDt)) / (1.0 - ((-0.001 / var_L_type_Ca_channel_f_gate__tau_f_L) * mDt));
        rY[7] = (var_chaste_interface__T_type_Ca_channel_d_gate__d_T + ((0.001 * var_T_type_Ca_channel_d_gate__d_T_infinity / var_T_type_Ca_channel_d_gate__tau_d_T) * mDt)) / (1.0 - ((-0.001 / var_T_type_Ca_channel_d_gate__tau_d_T) * mDt));
        rY[8] = (var_chaste_interface__T_type_Ca_channel_f_gate__f_T + ((0.001 * var_T_type_Ca_channel_f_gate__f_T_infinity / var_T_type_Ca_channel_f_gate__tau_f_T) * mDt)) / (1.0 - ((-0.001 / var_T_type_Ca_channel_f_gate__tau_f_T) * mDt));
        rY[9] = (var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a + ((0.001 * var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity / var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a) * mDt)) / (1.0 - ((-0.001 / var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a) * mDt));
        rY[10] = (var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i + ((0.001 * var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i) * mDt)) / (1.0 - ((-0.001 * var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i - 0.001 * var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i) * mDt));
        rY[11] = (var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + ((0.001 * var_hyperpolarisation_activated_current_y_gate__y_infinity / var_hyperpolarisation_activated_current_y_gate__tau_y) * mDt)) / (1.0 - ((-0.001 / var_hyperpolarisation_activated_current_y_gate__tau_y) * mDt));
        rY[3] = (var_chaste_interface__sodium_current_h_gate__h1 + ((0.001 * var_sodium_current_h_gate__h1_infinity / var_sodium_current_h_gate__tau_h1) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_h_gate__tau_h1) * mDt));
        rY[4] = (var_chaste_interface__sodium_current_h_gate__h2 + ((0.001 * var_sodium_current_h_gate__h2_infinity / var_sodium_current_h_gate__tau_h2) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_h_gate__tau_h2) * mDt));
        rY[2] = (var_chaste_interface__sodium_current_m_gate__m + ((0.001 * var_sodium_current_m_gate__m_infinity / var_sodium_current_m_gate__tau_m) * mDt)) / (1.0 - ((-0.001 / var_sodium_current_m_gate__tau_m) * mDt));
        
        double _guess[16] = {rY[23],rY[22],rY[21],rY[24],rY[25],rY[26],rY[19],rY[20],rY[18],rY[14],rY[16],rY[15],rY[1],rY[13],rY[17],rY[12]};
        CardiacNewtonSolver<16,Celldemir_model_1994FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<16,Celldemir_model_1994FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time_converted, _guess);
        rY[23] = _guess[0];
        rY[22] = _guess[1];
        rY[21] = _guess[2];
        rY[24] = _guess[3];
        rY[25] = _guess[4];
        rY[26] = _guess[5];
        rY[19] = _guess[6];
        rY[20] = _guess[7];
        rY[18] = _guess[8];
        rY[14] = _guess[9];
        rY[16] = _guess[10];
        rY[15] = _guess[11];
        rY[1] = _guess[12];
        rY[13] = _guess[13];
        rY[17] = _guess[14];
        rY[12] = _guess[15];
    }

    std::vector<double> Celldemir_model_1994FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldemir_model_1994FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "demir_model_1994";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-49.54105);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0003787018);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.250113);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001386897);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002065463);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002572773);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.98651);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02012114);

    // rY[8]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1945111);

    // rY[9]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_a_gate__P_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02302278);

    // rY[10]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_i_gate__P_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3777728);

    // rY[11]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09227776);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.701621);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.7347);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Calmod");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1411678);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.07331396);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7618549);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2097049);

    // rY[18]:
    this->mVariableNames.push_back("cleft_space_equations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.9988);

    // rY[19]:
    this->mVariableNames.push_back("cleft_space_equations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.00474);

    // rY[20]:
    this->mVariableNames.push_back("cleft_space_equations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.389014);

    // rY[21]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.95311);

    // rY[22]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.85024);

    // rY[23]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9528726);

    // rY[24]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1133251);

    // rY[25]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007594214);

    // rY[26]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8859153);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldemir_model_1994FromCellMLBackwardEuler)
