//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: decker_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "decker_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Celldecker_2009FromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // ms
        const double var_chaste_interface__membrane__stim_offset = 0; // ms
        const double var_chaste_interface__membrane__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Celldecker_2009FromCellMLBackwardEuler::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldecker_2009FromCellMLBackwardEuler::Celldecker_2009FromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<37>(
                48,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldecker_2009FromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.00015552; // (var_ICaL__PCa) [L_per_F_ms]
        this->mParameters[1] = 9.0749999999999993; // (var_INa__g_Na) [mS_per_uF]
        this->mParameters[2] = 0.013854200000000001; // (var_IKr__gKr_max) [mS_per_uF]
    }

    Celldecker_2009FromCellMLBackwardEuler::~Celldecker_2009FromCellMLBackwardEuler()
    {
    }
    
    double Celldecker_2009FromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        const double var_ICaL__gamma_Cai = 1.0; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICab__PCab = 1.9950840000000001e-7; // L_per_F_ms
        const double var_ICab__gamma_Ca_i = 1.0; // dimensionless
        const double var_ICab__gamma_Ca_o = 0.34100000000000003; // dimensionless
        const double var_IClb__gClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKp__gKp = 0.0027599999999999999; // mS_per_uF
        const double var_IKs__OKs = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2; // dimensionless
        const double var_IKs__gKs = 0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INaCa__KmCa_act = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__Vmax = 4.5; // uA_per_uF
        const double var_INaCa__denom_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_i, 2); // dimensionless
        const double var_INaCa__denom_ss_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_ss_sr, 2); // dimensionless
        const double var_INaCa__eta = 0.27000000000000002; // dimensionless
        const double var_INaCa__ksat = 0.32000000000000001; // dimensionless
        const double var_INaK__V_half = -92.0; // mV
        const double var_INaK__ibarnak = 1.3999999999999999; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 2.6000000000000001; // mM
        const double var_INaK__sigma = 1.0; // dimensionless
        const double var_INaL__gNaL = 0.0064999999999999997; // mS_per_uF
        const double var_INab__PNab = 3.2000000000000001e-9; // L_per_F_ms
        const double var_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_IpCa__gpCa = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__gpCa / (var_chaste_interface__Ca__Ca_i + var_IpCa__KmpCa); // uA_per_uF
        const double var_Ito1__gto1 = 0.4975; // mS_per_uF
        const double var_Ito2__PCl = 8.9999999999999996e-7; // L_per_F_ms
        const double var_Ito2__kCa_ito2 = 0.40000000000000002; // mM_per_ms
        const double var_Ito2__KCa_ito2 = 1.0 - 1.0 / (1.0 + pow(var_chaste_interface__Irel__Irel, 2) / pow(var_Ito2__kCa_ito2, 2)); // dimensionless
        const double var_Ito2__zCl = -1.0; // dimensionless
        const double var_INaK__PNa = pow(var_chaste_interface__Na__Na_i, 3) / pow((var_INaK__kmnai + var_chaste_interface__Na__Na_i), 3); // dimensionless
        const double var_IKp__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_r_gate__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1__rto1 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // dimensionless
        const double var_membrane__i_Stim = 0.0; // uA_per_uF
        const double var_model_parameters__Ca_o = 1.8; // mM
        const double var_INaCa__denom_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_i + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_i / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_INaCa__denom_ss_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_ss_sr / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_model_parameters__Cl_o = 100.0; // mM
        const double var_model_parameters__F = 96487.0; // C_per_mole
        const double var_model_parameters__K_o = 5.4000000000000004; // mM
        const double var_IK1__gK1 = 0.21516574145596759 * sqrt(var_model_parameters__K_o); // mS_per_uF
        const double var_IKr__gKr = 0.43033148291193518 * sqrt(var_model_parameters__K_o) * mParameters[2]; // mS_per_uF
        const double var_INaK__PK = var_model_parameters__K_o / (var_INaK__kmko + var_model_parameters__K_o); // dimensionless
        const double var_model_parameters__Na_o = 140.0; // mM
        const double var_INaCa__denom_4 = pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_INaCa__denom_ss_4 = pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_ss_sr, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_model_parameters__R = 8314.0; // J_per_kmole_K
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__ICaL_max = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICaL__gamma_Cao * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_ss_CaL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * mParameters[0] * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_ICaL__ICaL = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * var_ICaL__ICaL_max; // uA_per_uF
        const double var_ICab__ICab = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICab__gamma_Ca_o * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_i * var_ICab__gamma_Ca_i * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICab__PCab * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_INaCa__denom_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__denom_ss_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__num = 0.80000000000000004 * (pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa = var_INaCa__num / ((var_INaCa__denom_3 + var_INaCa__denom_4) * var_INaCa__denom_1 * var_INaCa__denom_2); // uA_per_uF
        const double var_INaCa__num_ss = 0.20000000000000001 * (pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa_ss_sr = var_INaCa__num_ss / ((var_INaCa__denom_ss_3 + var_INaCa__denom_ss_4) * var_INaCa__denom_ss_1 * var_INaCa__denom_ss_2); // uA_per_uF
        const double var_INaK__phi = (-var_INaK__V_half + var_chaste_interface__membrane__Vm) * var_INaK__sigma * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INaK__fv = 1 / (1.0 + exp(-var_INaK__phi)); // dimensionless
        const double var_INaK__INaK = var_INaK__PK * var_INaK__PNa * var_INaK__fv * var_INaK__ibarnak; // uA_per_uF
        const double var_INab__phi = var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INab__INab = (-var_model_parameters__Na_o + var_chaste_interface__Na__Na_i * exp(var_INab__phi)) * var_INab__PNab * var_INab__phi * var_model_parameters__F / (-1.0 + exp(var_INab__phi)); // uA_per_uF
        const double var_Ito2__Ito2_max = pow(var_Ito2__zCl, 2) * pow(var_model_parameters__F, 2) * (-var_model_parameters__Cl_o * exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + var_chaste_interface__Cl__Cl_i) * var_Ito2__PCl * var_chaste_interface__membrane__Vm / ((1.0 - exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_Ito2__Ito2 = var_Ito2__Ito2_max * var_Ito2__KCa_ito2 * var_chaste_interface__Ito2_i2f_gate__i2f; // uA_per_uF
        const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_reversal_potentials__ECl = -var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cl_o / var_chaste_interface__Cl__Cl_i) / var_model_parameters__F; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__membrane__Vm) * var_IClb__gClb; // uA_per_uF
        const double var_membrane__clont = var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__K_o / var_chaste_interface__K__K_i) / var_model_parameters__F; // mV
        const double var_IK1_K1_gate__alpha_k1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)); // dimensionless
        const double var_IK1_K1_gate__beta_k1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IK1_K1_gate__K1 = var_IK1_K1_gate__alpha_k1 / (var_IK1_K1_gate__alpha_k1 + var_IK1_K1_gate__beta_k1); // dimensionless
        const double var_IK1__IK1 = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IK1__gK1 * var_IK1_K1_gate__K1; // uA_per_uF
        const double var_IKp__IKp = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKp__Kp * var_IKp__gKp; // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKr__gKr * var_IKr_r_gate__r * var_chaste_interface__IKr_xr_gate__xr; // uA_per_uF
        const double var_Ito1__Ito1 = pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_Ito1__gto1 * var_Ito1__rto1 * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s; // uA_per_uF
        const double var_reversal_potentials__ENa = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Na_o / var_chaste_interface__Na__Na_i) / var_model_parameters__F; // mV
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_INaL__gNaL * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = var_model_parameters__R * var_model_parameters__T * log((var_model_parameters__Na_o * var_reversal_potentials__prnak + var_model_parameters__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_model_parameters__F; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__membrane__Vm) * var_IKs__OKs * var_IKs__gKs; // uA_per_uF
        const double var_membrane__kiont = -2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim; // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_membrane__caiont + var_membrane__clont + var_membrane__kiont + var_membrane__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldecker_2009FromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[37], double rResidual[37])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__CaMK_active__CaMK_trap = rCurrentGuess[0];
        double var_chaste_interface__Ca__Ca_JSR = rCurrentGuess[1];
        double var_chaste_interface__Ca__Ca_NSR = rCurrentGuess[2];
        double var_chaste_interface__Ca__Ca_i = rCurrentGuess[3];
        double var_chaste_interface__Ca__Ca_ss_CaL = rCurrentGuess[4];
        double var_chaste_interface__Ca__Ca_ss_sr = rCurrentGuess[5];
        double var_chaste_interface__Cl__Cl_i = rCurrentGuess[6];
        double var_chaste_interface__Cl__Cl_ss = rCurrentGuess[7];
        double var_chaste_interface__ICaL__C = rCurrentGuess[8];
        double var_chaste_interface__ICaL__CI = rCurrentGuess[9];
        double var_chaste_interface__ICaL__CI_star = rCurrentGuess[10];
        double var_chaste_interface__ICaL__C_star = rCurrentGuess[11];
        double var_chaste_interface__ICaL__O = rCurrentGuess[12];
        double var_chaste_interface__ICaL__OI = rCurrentGuess[13];
        double var_chaste_interface__ICaL__OI_star = rCurrentGuess[14];
        double var_chaste_interface__ICaL__O_star = rCurrentGuess[15];
        double var_chaste_interface__IKs__C1 = rCurrentGuess[16];
        double var_chaste_interface__IKs__C10 = rCurrentGuess[17];
        double var_chaste_interface__IKs__C11 = rCurrentGuess[18];
        double var_chaste_interface__IKs__C12 = rCurrentGuess[19];
        double var_chaste_interface__IKs__C13 = rCurrentGuess[20];
        double var_chaste_interface__IKs__C14 = rCurrentGuess[21];
        double var_chaste_interface__IKs__C15 = rCurrentGuess[22];
        double var_chaste_interface__IKs__C2 = rCurrentGuess[23];
        double var_chaste_interface__IKs__C3 = rCurrentGuess[24];
        double var_chaste_interface__IKs__C4 = rCurrentGuess[25];
        double var_chaste_interface__IKs__C5 = rCurrentGuess[26];
        double var_chaste_interface__IKs__C6 = rCurrentGuess[27];
        double var_chaste_interface__IKs__C7 = rCurrentGuess[28];
        double var_chaste_interface__IKs__C8 = rCurrentGuess[29];
        double var_chaste_interface__IKs__C9 = rCurrentGuess[30];
        double var_chaste_interface__IKs__O1 = rCurrentGuess[31];
        double var_chaste_interface__IKs__O2 = rCurrentGuess[32];
        double var_chaste_interface__Irel__Irel = rCurrentGuess[33];
        double var_chaste_interface__K__K_i = rCurrentGuess[34];
        double var_chaste_interface__Na__Na_i = rCurrentGuess[35];
        double var_chaste_interface__Na__Na_ss_sr = rCurrentGuess[36];
        
        //output_equations
        const double var_CT_K_Cl__CT_K_Cl_max = 1.77e-5; // mM_per_ms
        const double var_CT_Na_Cl__CT_Na_Cl_max = 2.4610800000000002e-5; // mM_per_ms
        const double var_Ca__BSLmax = 1.1240000000000001; // mM
        const double var_Ca__BSRmax = 0.047; // mM
        const double var_Ca__KmBSL = 0.0086999999999999994; // mM
        const double var_Ca__KmBSR = 0.00087000000000000001; // mM
        const double var_Ca__bss = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss_CaL + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss_CaL + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__bss_sr = 1 / (1.0 + var_Ca__BSLmax * var_Ca__KmBSL / pow((var_chaste_interface__Ca__Ca_ss_sr + var_Ca__KmBSL), 2) + var_Ca__BSRmax * var_Ca__KmBSR / pow((var_chaste_interface__Ca__Ca_ss_sr + var_Ca__KmBSR), 2)); // dimensionless
        const double var_Ca__cmdn_bar = 0.050000000000000003; // mM
        const double var_Ca__csqnbar = 10.0; // mM
        const double var_Ca__km_cmdn = 0.0023800000000000002; // mM
        const double var_Ca__km_trpn = 0.00050000000000000001; // mM
        const double var_Ca__kmcsqn = 0.80000000000000004; // mM
        const double var_Ca__bcsqn = 1 / (1.0 + var_Ca__csqnbar * var_Ca__kmcsqn / pow((var_chaste_interface__Ca__Ca_JSR + var_Ca__kmcsqn), 2)); // dimensionless
        const double var_Ca__tau_diff = 0.20000000000000001; // ms
        const double var_Ca__Idiff = (-var_chaste_interface__Ca__Ca_i + var_chaste_interface__Ca__Ca_ss_sr) / var_Ca__tau_diff; // mM_per_ms
        const double var_Ca__tau_diff_ss = 2.0; // ms
        const double var_Ca__Idiff_ss = (-var_chaste_interface__Ca__Ca_ss_CaL + var_chaste_interface__Ca__Ca_ss_sr) / var_Ca__tau_diff_ss; // mM_per_ms
        const double var_Ca__trpn_bar = 0.070000000000000007; // mM
        const double var_Ca__bmyo = 1 / (1.0 + var_Ca__cmdn_bar * var_Ca__km_cmdn / pow((var_chaste_interface__Ca__Ca_i + var_Ca__km_cmdn), 2) + var_Ca__km_trpn * var_Ca__trpn_bar / pow((var_chaste_interface__Ca__Ca_i + var_Ca__km_trpn), 2)); // dimensionless
        const double var_CaMK_active__CaMK_0 = 0.050000000000000003; // dimensionless
        const double var_CaMK_active__Km = 0.0015; // mM
        const double var_CaMK_active__CaMK_active = (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) * var_CaMK_active__CaMK_0 / (1.0 + var_CaMK_active__Km / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_CaMK_active__alpha_CaMK = 0.050000000000000003; // per_ms
        const double var_CaMK_active__beta_CaMK = 0.00068000000000000005; // per_ms
        const double var_Cl__Idiff_Cl = (-var_chaste_interface__Cl__Cl_i + var_chaste_interface__Cl__Cl_ss) / var_Ca__tau_diff; // mM_per_ms
        const double d_dt_chaste_interface_var_CaMK_active__CaMK_trap = -var_chaste_interface__CaMK_active__CaMK_trap * var_CaMK_active__beta_CaMK + (-var_chaste_interface__CaMK_active__CaMK_trap + var_CaMK_active__CaMK_active) * var_CaMK_active__CaMK_active * var_CaMK_active__alpha_CaMK; // 1 / ms
        const double var_ICaL__IV_beta_infinity_star = 25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // dimensionless
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__gamma_Cai = 1.0; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__theta = 1.0; // per_ms
        const double var_ICaL__theta_I = 9.9999999999999995e-7; // per_ms
        const double var_ICab__PCab = 1.9950840000000001e-7; // L_per_F_ms
        const double var_ICab__gamma_Ca_i = 1.0; // dimensionless
        const double var_ICab__gamma_Ca_o = 0.34100000000000003; // dimensionless
        const double var_IClb__gClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKp__gKp = 0.0027599999999999999; // mS_per_uF
        const double var_IKs__OKs = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2; // dimensionless
        const double var_IKs__gKs = 0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_IKs__theta = 0.089538000000000006; // per_ms
        const double var_INaCa__KmCa_act = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__Vmax = 4.5; // uA_per_uF
        const double var_INaCa__denom_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_i, 2); // dimensionless
        const double var_INaCa__denom_ss_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_ss_sr, 2); // dimensionless
        const double var_INaCa__eta = 0.27000000000000002; // dimensionless
        const double var_INaCa__ksat = 0.32000000000000001; // dimensionless
        const double var_INaK__V_half = -92.0; // mV
        const double var_INaK__ibarnak = 1.3999999999999999; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 2.6000000000000001; // mM
        const double var_INaK__sigma = 1.0; // dimensionless
        const double var_INaL__gNaL = 0.0064999999999999997; // mS_per_uF
        const double var_INab__PNab = 3.2000000000000001e-9; // L_per_F_ms
        const double var_Ileak__nsrbar = 15.0; // mM
        const double var_Ileak__Ileak = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_NSR / var_Ileak__nsrbar; // mM_per_ms
        const double var_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_IpCa__gpCa = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__gpCa / (var_chaste_interface__Ca__Ca_i + var_IpCa__KmpCa); // uA_per_uF
        const double var_Irel__K_beta = 0.28000000000000003; // mM
        const double var_Irel__Krel_infinity = 1.0; // mM
        const double var_Irel__Krel_tau = 0.0123; // mM
        const double var_Irel__beta_0 = 4.75; // ms
        const double var_Irel__delta_beta_0 = 1.0; // dimensionless
        const double var_Irel__h_beta = 10.0; // dimensionless
        const double var_Irel__delta_beta_CaMK = var_Irel__delta_beta_0 / (1.0 + pow((var_Irel__K_beta / var_CaMK_active__CaMK_active), var_Irel__h_beta)); // dimensionless
        const double var_Irel__beta_tau = (1.0 + var_Irel__delta_beta_CaMK) * var_Irel__beta_0; // ms
        const double var_Irel__h_rel = 8.0; // dimensionless
        const double var_Irel__kappa = 0.1125; // mM_per_uA_per_uF_per_ms_per_ms
        const double var_Irel__alpha_rel = var_Irel__beta_tau * var_Irel__kappa; // mM_per_uA_per_uF_per_ms
        const double var_Irel__tau_rel = var_Irel__beta_tau / (1.0 + var_Irel__Krel_tau / var_chaste_interface__Ca__Ca_JSR); // ms
        const double var_Ito1__gto1 = 0.4975; // mS_per_uF
        const double var_Ito2__PCl = 8.9999999999999996e-7; // L_per_F_ms
        const double var_Ito2__kCa_ito2 = 0.40000000000000002; // mM_per_ms
        const double var_Ito2__KCa_ito2 = 1.0 - 1.0 / (1.0 + pow(var_chaste_interface__Irel__Irel, 2) / pow(var_Ito2__kCa_ito2, 2)); // dimensionless
        const double var_Ito2__zCl = -1.0; // dimensionless
        const double var_Itr__tautr = 25.0; // ms
        const double var_Itr__Itr = (-var_chaste_interface__Ca__Ca_JSR + var_chaste_interface__Ca__Ca_NSR) / var_Itr__tautr; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_JSR = (-var_chaste_interface__Irel__Irel + var_Itr__Itr) * var_Ca__bcsqn; // mM / ms
        const double var_Iup__delta_iupCaMK_bar = 0.75; // dimensionless
        const double var_Iup__delta_kmPLB_bar = 0.00017000000000000001; // mM
        const double var_Iup__iupbar = 0.0043750000000000004; // mM_per_ms
        const double var_Iup__kmCaMK = 0.14999999999999999; // mM
        const double var_Iup__delta_iupCaMK = var_CaMK_active__CaMK_active * var_Iup__delta_iupCaMK_bar / (var_CaMK_active__CaMK_active + var_Iup__kmCaMK); // dimensionless
        const double var_Iup__delta_kmPLB = var_CaMK_active__CaMK_active * var_Iup__delta_kmPLB_bar / (var_CaMK_active__CaMK_active + var_Iup__kmCaMK); // mM
        const double var_Iup__kmup = 0.00092000000000000003; // mM
        const double var_Iup__Iup = (1.0 + var_Iup__delta_iupCaMK) * var_chaste_interface__Ca__Ca_i * var_Iup__iupbar / (-var_Iup__delta_kmPLB + var_chaste_interface__Ca__Ca_i + var_Iup__kmup); // mM_per_ms
        const double var_INaK__PNa = pow(var_chaste_interface__Na__Na_i, 3) / pow((var_INaK__kmnai + var_chaste_interface__Na__Na_i), 3); // dimensionless
        const double var_Na__Idiff_Na = (-var_chaste_interface__Na__Na_i + var_chaste_interface__Na__Na_ss_sr) / var_Ca__tau_diff; // mM_per_ms
        const double var_cell_geometry__a = 0.0011000000000000001; // cm
        const double var_cell_geometry__l = 0.01; // cm
        const double var_cell_geometry__ageo = 2.0 * M_PI * pow(var_cell_geometry__a, 2) + 2.0 * M_PI * var_cell_geometry__a * var_cell_geometry__l; // cm2
        const double var_cell_geometry__Acap = 2.0 * var_cell_geometry__ageo; // cm2
        const double var_cell_geometry__vcell = 1000.0 * M_PI * pow(var_cell_geometry__a, 2) * var_cell_geometry__l; // uL
        const double var_cell_geometry__Vjsr = 0.0047999999999999996 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vnsr = 0.055199999999999999 * var_cell_geometry__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = -var_Ileak__Ileak - var_Itr__Itr * var_cell_geometry__Vjsr / var_cell_geometry__Vnsr + var_Iup__Iup; // mM / ms
        const double var_cell_geometry__Vss_CaL = 0.002 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_beta_star = 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * var_ICaL__IV_beta_infinity_star); // dimensionless
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + var_ICaL__IV_beta_star); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C = (-var_ICaL__alpha - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__C + var_chaste_interface__ICaL__CI * var_ICaL__x + var_chaste_interface__ICaL__C_star * var_ICaL__theta + var_chaste_interface__ICaL__O * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O = (-var_ICaL__beta - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__C * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__x + var_chaste_interface__ICaL__O_star * var_ICaL__theta; // 1 / ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C_star = (-var_ICaL__alpha - var_ICaL__theta - var_ICaL__y_star) * var_chaste_interface__ICaL__C_star + var_chaste_interface__ICaL__C * var_ICaL__delta + var_chaste_interface__ICaL__CI_star * var_ICaL__x_star + var_chaste_interface__ICaL__O_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O_star = (-var_ICaL__beta - var_ICaL__theta - var_ICaL__y_star) * var_chaste_interface__ICaL__O_star + var_chaste_interface__ICaL__C_star * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__delta + var_chaste_interface__ICaL__OI_star * var_ICaL__x_star; // 1 / ms
        const double var_ICaL__delta_I = var_ICaL__delta * var_ICaL__theta_I * var_ICaL__x * var_ICaL__y_star / (var_ICaL__theta * var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__CI = (-var_ICaL__alpha - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__CI + var_chaste_interface__ICaL__C * var_ICaL__y + var_chaste_interface__ICaL__CI_star * var_ICaL__theta_I + var_chaste_interface__ICaL__OI * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__CI_star = (-var_ICaL__alpha - var_ICaL__theta_I - var_ICaL__x_star) * var_chaste_interface__ICaL__CI_star + var_chaste_interface__ICaL__CI * var_ICaL__delta_I + var_chaste_interface__ICaL__C_star * var_ICaL__y_star + var_chaste_interface__ICaL__OI_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI = (-var_ICaL__beta - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__OI + var_chaste_interface__ICaL__CI * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__y + var_chaste_interface__ICaL__OI_star * var_ICaL__theta_I; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI_star = (-var_ICaL__beta - var_ICaL__theta_I - var_ICaL__x_star) * var_chaste_interface__ICaL__OI_star + var_chaste_interface__ICaL__CI_star * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__delta_I + var_chaste_interface__ICaL__O_star * var_ICaL__y_star; // 1 / ms
        const double var_IKp__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_r_gate__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1__rto1 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // dimensionless
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_model_parameters__Ca_o = 1.8; // mM
        const double var_INaCa__denom_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_i + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_i / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_INaCa__denom_ss_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_ss_sr / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_model_parameters__Cl_o = 100.0; // mM
        const double var_model_parameters__F = 96487.0; // C_per_mole
        const double var_cell_geometry__AF = var_cell_geometry__Acap / var_model_parameters__F; // uF_mole_per_C
        const double var_model_parameters__K_o = 5.4000000000000004; // mM
        const double var_IK1__gK1 = 0.21516574145596759 * sqrt(var_model_parameters__K_o); // mS_per_uF
        const double var_IKr__gKr = 0.43033148291193518 * sqrt(var_model_parameters__K_o) * mParameters[2]; // mS_per_uF
        const double var_INaK__PK = var_model_parameters__K_o / (var_INaK__kmko + var_model_parameters__K_o); // dimensionless
        const double var_model_parameters__Na_o = 140.0; // mM
        const double var_INaCa__denom_4 = pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_INaCa__denom_ss_4 = pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_ss_sr, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_model_parameters__R = 8314.0; // J_per_kmole_K
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__ICaL_max = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICaL__gamma_Cao * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_ss_CaL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * mParameters[0] * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_ICaL__ICaL = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * var_ICaL__ICaL_max; // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_CaL = (var_Ca__Idiff_ss * var_cell_geometry__Vss_sr / var_cell_geometry__Vss_CaL - 0.5 * var_ICaL__ICaL * var_cell_geometry__AF / var_cell_geometry__Vss_CaL) * var_Ca__bss; // mM / ms
        const double var_ICab__ICab = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICab__gamma_Ca_o * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_i * var_ICab__gamma_Ca_i * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICab__PCab * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_IKs__alpha = 0.014864 * exp(0.029877000000000001 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.055461000000000003 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1 = var_chaste_interface__IKs__C2 * var_IKs__beta - 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.42625000000000002 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__eta = 0.07732 * exp(-0.064726000000000006 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.24465000000000001 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__C10 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C10 + var_chaste_interface__IKs__C11 * var_IKs__beta + var_chaste_interface__IKs__C7 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C11 = (-var_IKs__alpha - var_IKs__beta - var_IKs__gamma - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C11 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__beta + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C13 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C12 = (-2.0 * var_IKs__beta - 2.0 * var_IKs__delta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C12 + var_chaste_interface__IKs__C11 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C14 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C13 = (-var_IKs__alpha - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C13 + var_chaste_interface__IKs__C11 * var_IKs__gamma + var_chaste_interface__IKs__C14 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C14 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C14 + var_chaste_interface__IKs__C13 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__gamma + 4.0 * var_chaste_interface__IKs__C15 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C15 = (-var_IKs__theta - 4.0 * var_IKs__delta) * var_chaste_interface__IKs__C15 + var_chaste_interface__IKs__C14 * var_IKs__gamma + var_chaste_interface__IKs__O1 * var_IKs__eta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C2 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C2 + var_chaste_interface__IKs__C6 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__beta + 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C3 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C3 + var_chaste_interface__IKs__C7 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C2 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C4 = (-var_IKs__alpha - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C4 + var_chaste_interface__IKs__C8 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__alpha + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C5 = (-4.0 * var_IKs__beta - 4.0 * var_IKs__gamma) * var_chaste_interface__IKs__C5 + var_chaste_interface__IKs__C4 * var_IKs__alpha + var_chaste_interface__IKs__C9 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C6 = (-var_IKs__delta - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C6 + var_chaste_interface__IKs__C2 * var_IKs__gamma + var_chaste_interface__IKs__C7 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C7 = (-var_IKs__beta - var_IKs__delta - var_IKs__gamma - 2.0 * var_IKs__alpha) * var_chaste_interface__IKs__C7 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__gamma + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__beta + 3.0 * var_chaste_interface__IKs__C6 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C8 = (-var_IKs__alpha - var_IKs__delta - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C8 + 2.0 * var_chaste_interface__IKs__C11 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C7 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C9 = (-var_IKs__delta - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C9 + var_chaste_interface__IKs__C8 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__delta + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__gamma; // 1 / ms
        const double var_IKs__omega = 0.79405000000000003 * exp(-0.080173999999999995 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double var_IKs__psi = 0.58638000000000001 * exp(0.28205999999999998 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1 = (-var_IKs__eta - var_IKs__psi) * var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__C15 * var_IKs__theta + var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2 = var_chaste_interface__IKs__O1 * var_IKs__psi - var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double var_INaCa__denom_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__denom_ss_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__num = 0.80000000000000004 * (pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa = var_INaCa__num / ((var_INaCa__denom_3 + var_INaCa__denom_4) * var_INaCa__denom_1 * var_INaCa__denom_2); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup__Iup + var_Ileak__Ileak) * var_cell_geometry__Vnsr / var_cell_geometry__Vmyo + var_Ca__Idiff * var_cell_geometry__Vss_CaL / var_cell_geometry__Vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell_geometry__AF / var_cell_geometry__Vmyo) * var_Ca__bmyo; // mM / ms
        const double var_INaCa__num_ss = 0.20000000000000001 * (pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa_ss_sr = var_INaCa__num_ss / ((var_INaCa__denom_ss_3 + var_INaCa__denom_ss_4) * var_INaCa__denom_ss_1 * var_INaCa__denom_ss_2); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_sr = (-var_Ca__Idiff - var_Ca__Idiff_ss + var_chaste_interface__Irel__Irel * var_cell_geometry__Vjsr / var_cell_geometry__Vss_sr + var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr) * var_Ca__bss_sr; // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_ss_sr = -var_Na__Idiff_Na - 3.0 * var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_INaK__phi = (-var_INaK__V_half + var_chaste_interface__membrane__Vm) * var_INaK__sigma * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INaK__fv = 1 / (1.0 + exp(-var_INaK__phi)); // dimensionless
        const double var_INaK__INaK = var_INaK__PK * var_INaK__PNa * var_INaK__fv * var_INaK__ibarnak; // uA_per_uF
        const double var_INab__phi = var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INab__INab = (-var_model_parameters__Na_o + var_chaste_interface__Na__Na_i * exp(var_INab__phi)) * var_INab__PNab * var_INab__phi * var_model_parameters__F / (-1.0 + exp(var_INab__phi)); // uA_per_uF
        const double var_Irel__rel_infinity = var_ICaL__ICaL * var_Irel__alpha_rel / (1.0 + pow((var_Irel__Krel_infinity / var_chaste_interface__Ca__Ca_JSR), var_Irel__h_rel)); // mM_per_ms
        const double d_dt_chaste_interface_var_Irel__Irel = (-var_chaste_interface__Irel__Irel - var_Irel__rel_infinity) / var_Irel__tau_rel; // mM_per_ms / ms
        const double var_Ito2__Ito2_max = pow(var_Ito2__zCl, 2) * pow(var_model_parameters__F, 2) * (-var_model_parameters__Cl_o * exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + var_chaste_interface__Cl__Cl_i) * var_Ito2__PCl * var_chaste_interface__membrane__Vm / ((1.0 - exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_Ito2__Ito2 = var_Ito2__Ito2_max * var_Ito2__KCa_ito2 * var_chaste_interface__Ito2_i2f_gate__i2f; // uA_per_uF
        const double d_dt_chaste_interface_var_Cl__Cl_ss = -var_Cl__Idiff_Cl + var_Ito2__Ito2 * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_reversal_potentials__ECl = -var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cl_o / var_chaste_interface__Cl__Cl_i) / var_model_parameters__F; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__membrane__Vm) * var_IClb__gClb; // uA_per_uF
        const double var_reversal_potentials__EK = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__K_o / var_chaste_interface__K__K_i) / var_model_parameters__F; // mV
        const double var_CT_K_Cl__CT_K_Cl = (-var_reversal_potentials__ECl + var_reversal_potentials__EK) * var_CT_K_Cl__CT_K_Cl_max / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_IK1_K1_gate__alpha_k1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)); // dimensionless
        const double var_IK1_K1_gate__beta_k1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IK1_K1_gate__K1 = var_IK1_K1_gate__alpha_k1 / (var_IK1_K1_gate__alpha_k1 + var_IK1_K1_gate__beta_k1); // dimensionless
        const double var_IK1__IK1 = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IK1__gK1 * var_IK1_K1_gate__K1; // uA_per_uF
        const double var_IKp__IKp = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKp__Kp * var_IKp__gKp; // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKr__gKr * var_IKr_r_gate__r * var_chaste_interface__IKr_xr_gate__xr; // uA_per_uF
        const double var_Ito1__Ito1 = pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_Ito1__gto1 * var_Ito1__rto1 * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s; // uA_per_uF
        const double var_reversal_potentials__ENa = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Na_o / var_chaste_interface__Na__Na_i) / var_model_parameters__F; // mV
        const double var_CT_Na_Cl__CT_Na_Cl = pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) * var_CT_Na_Cl__CT_Na_Cl_max / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_Cl__Idiff_Cl * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo + var_IClb__IClb * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_INaL__gNaL * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = var_Na__Idiff_Na * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo - (3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = var_model_parameters__R * var_model_parameters__T * log((var_model_parameters__Na_o * var_reversal_potentials__prnak + var_model_parameters__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_model_parameters__F; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__membrane__Vm) * var_IKs__OKs * var_IKs__gKs; // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -(-2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl; // mM / ms
        
        rResidual[3] = rCurrentGuess[3] - rY[1] - mDt*d_dt_chaste_interface_var_Ca__Ca_i;
        rResidual[16] = rCurrentGuess[16] - rY[2] - mDt*d_dt_chaste_interface_var_IKs__C1;
        rResidual[23] = rCurrentGuess[23] - rY[3] - mDt*d_dt_chaste_interface_var_IKs__C2;
        rResidual[24] = rCurrentGuess[24] - rY[4] - mDt*d_dt_chaste_interface_var_IKs__C3;
        rResidual[25] = rCurrentGuess[25] - rY[5] - mDt*d_dt_chaste_interface_var_IKs__C4;
        rResidual[26] = rCurrentGuess[26] - rY[6] - mDt*d_dt_chaste_interface_var_IKs__C5;
        rResidual[27] = rCurrentGuess[27] - rY[7] - mDt*d_dt_chaste_interface_var_IKs__C6;
        rResidual[28] = rCurrentGuess[28] - rY[8] - mDt*d_dt_chaste_interface_var_IKs__C7;
        rResidual[29] = rCurrentGuess[29] - rY[9] - mDt*d_dt_chaste_interface_var_IKs__C8;
        rResidual[30] = rCurrentGuess[30] - rY[10] - mDt*d_dt_chaste_interface_var_IKs__C9;
        rResidual[17] = rCurrentGuess[17] - rY[11] - mDt*d_dt_chaste_interface_var_IKs__C10;
        rResidual[18] = rCurrentGuess[18] - rY[12] - mDt*d_dt_chaste_interface_var_IKs__C11;
        rResidual[19] = rCurrentGuess[19] - rY[13] - mDt*d_dt_chaste_interface_var_IKs__C12;
        rResidual[20] = rCurrentGuess[20] - rY[14] - mDt*d_dt_chaste_interface_var_IKs__C13;
        rResidual[21] = rCurrentGuess[21] - rY[15] - mDt*d_dt_chaste_interface_var_IKs__C14;
        rResidual[22] = rCurrentGuess[22] - rY[16] - mDt*d_dt_chaste_interface_var_IKs__C15;
        rResidual[31] = rCurrentGuess[31] - rY[17] - mDt*d_dt_chaste_interface_var_IKs__O1;
        rResidual[32] = rCurrentGuess[32] - rY[18] - mDt*d_dt_chaste_interface_var_IKs__O2;
        rResidual[8] = rCurrentGuess[8] - rY[19] - mDt*d_dt_chaste_interface_var_ICaL__C;
        rResidual[12] = rCurrentGuess[12] - rY[20] - mDt*d_dt_chaste_interface_var_ICaL__O;
        rResidual[11] = rCurrentGuess[11] - rY[21] - mDt*d_dt_chaste_interface_var_ICaL__C_star;
        rResidual[15] = rCurrentGuess[15] - rY[22] - mDt*d_dt_chaste_interface_var_ICaL__O_star;
        rResidual[9] = rCurrentGuess[9] - rY[23] - mDt*d_dt_chaste_interface_var_ICaL__CI;
        rResidual[13] = rCurrentGuess[13] - rY[24] - mDt*d_dt_chaste_interface_var_ICaL__OI;
        rResidual[10] = rCurrentGuess[10] - rY[25] - mDt*d_dt_chaste_interface_var_ICaL__CI_star;
        rResidual[14] = rCurrentGuess[14] - rY[26] - mDt*d_dt_chaste_interface_var_ICaL__OI_star;
        rResidual[33] = rCurrentGuess[33] - rY[37] - mDt*d_dt_chaste_interface_var_Irel__Irel;
        rResidual[1] = rCurrentGuess[1] - rY[38] - mDt*d_dt_chaste_interface_var_Ca__Ca_JSR;
        rResidual[2] = rCurrentGuess[2] - rY[39] - mDt*d_dt_chaste_interface_var_Ca__Ca_NSR;
        rResidual[5] = rCurrentGuess[5] - rY[40] - mDt*d_dt_chaste_interface_var_Ca__Ca_ss_sr;
        rResidual[4] = rCurrentGuess[4] - rY[41] - mDt*d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
        rResidual[35] = rCurrentGuess[35] - rY[42] - mDt*d_dt_chaste_interface_var_Na__Na_i;
        rResidual[36] = rCurrentGuess[36] - rY[43] - mDt*d_dt_chaste_interface_var_Na__Na_ss_sr;
        rResidual[6] = rCurrentGuess[6] - rY[44] - mDt*d_dt_chaste_interface_var_Cl__Cl_i;
        rResidual[7] = rCurrentGuess[7] - rY[45] - mDt*d_dt_chaste_interface_var_Cl__Cl_ss;
        rResidual[34] = rCurrentGuess[34] - rY[46] - mDt*d_dt_chaste_interface_var_K__K_i;
        rResidual[0] = rCurrentGuess[0] - rY[47] - mDt*d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
    }

    void Celldecker_2009FromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[37], double rJacobian[37][37])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        
        double var_chaste_interface__CaMK_active__CaMK_trap = rCurrentGuess[0];
        double var_chaste_interface__Ca__Ca_JSR = rCurrentGuess[1];
        double var_chaste_interface__Ca__Ca_NSR = rCurrentGuess[2];
        double var_chaste_interface__Ca__Ca_i = rCurrentGuess[3];
        double var_chaste_interface__Ca__Ca_ss_CaL = rCurrentGuess[4];
        double var_chaste_interface__Ca__Ca_ss_sr = rCurrentGuess[5];
        double var_chaste_interface__Cl__Cl_i = rCurrentGuess[6];
        double var_chaste_interface__ICaL__C = rCurrentGuess[8];
        double var_chaste_interface__ICaL__CI = rCurrentGuess[9];
        double var_chaste_interface__ICaL__CI_star = rCurrentGuess[10];
        double var_chaste_interface__ICaL__C_star = rCurrentGuess[11];
        double var_chaste_interface__ICaL__O = rCurrentGuess[12];
        double var_chaste_interface__ICaL__OI = rCurrentGuess[13];
        double var_chaste_interface__ICaL__OI_star = rCurrentGuess[14];
        double var_chaste_interface__ICaL__O_star = rCurrentGuess[15];
        double var_chaste_interface__IKs__O1 = rCurrentGuess[31];
        double var_chaste_interface__IKs__O2 = rCurrentGuess[32];
        double var_chaste_interface__Irel__Irel = rCurrentGuess[33];
        double var_chaste_interface__K__K_i = rCurrentGuess[34];
        double var_chaste_interface__Na__Na_i = rCurrentGuess[35];
        double var_chaste_interface__Na__Na_ss_sr = rCurrentGuess[36];
        
        const double var_x0 = 1.0 - var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x1 = 1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = 0.050000000000000003 * var_x2;
        const double var_x4 = var_x0 * var_x3;
        const double var_x5 = var_x4 + var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x6 = 0.0025000000000000005 * var_x2;
        const double var_x7 = 1 - var_x3;
        const double var_x8 = pow(var_chaste_interface__Ca__Ca_ss_sr, (-2));
        const double var_x9 = var_x0 * var_x8 / pow(var_x1, 2);
        const double var_x10 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR;
        const double var_x11 = pow(var_x10, (-2));
        const double var_x12 = 1 / (1.0 + 8.0 * var_x11);
        const double var_x13 = 0.040000000000000001 * var_x12;
        const double var_x14 = -var_chaste_interface__Irel__Irel;
        const double var_x15 = 0.14999999999999999 + var_x4 + var_chaste_interface__CaMK_active__CaMK_trap;
        const double var_x16 = 1 / var_x15;
        const double var_x17 = var_x16 * var_x7;
        const double var_x18 = var_x5 / pow(var_x15, 2);
        const double var_x19 = var_x18 * (-1.0 + var_x3);
        const double var_x20 = 0.75 * var_x17 + 0.75 * var_x19;
        const double var_x21 = var_x16 * var_x5;
        const double var_x22 = 0.00092000000000000003 - 0.00017000000000000001 * var_x21 + var_chaste_interface__Ca__Ca_i;
        const double var_x23 = 1 / var_x22;
        const double var_x24 = 0.0043750000000000004 * var_chaste_interface__Ca__Ca_i;
        const double var_x25 = var_x23 * var_x24;
        const double var_x26 = 0.00017000000000000001 * var_x17 + 0.00017000000000000001 * var_x19;
        const double var_x27 = 1.0 + 0.75 * var_x21;
        const double var_x28 = var_x27 / pow(var_x22, 2);
        const double var_x29 = var_x24 * var_x28;
        const double var_x30 = var_x23 * var_x27;
        const double var_x31 = var_x16 * var_x9;
        const double var_x32 = var_x18 * var_x9;
        const double var_x33 = 5.6250000000000005e-5 * var_x31 - 5.6250000000000005e-5 * var_x32;
        const double var_x34 = 1.2750000000000002e-8 * var_x31 - 1.2750000000000002e-8 * var_x32;
        const double var_x35 = 0.00035619469026548675 * var_chaste_interface__Ca__Ca_i;
        const double var_x36 = var_x23 * var_x35;
        const double var_x37 = var_x28 * var_x35;
        const double var_x38 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
        const double var_x39 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
        const double var_x40 = pow(var_x39, (-2));
        const double var_x41 = 1.0 + 0.00011900000000000002 / pow(var_x38, 2) + 3.5000000000000004e-5 * var_x40;
        const double var_x42 = 1 / var_x41;
        const double var_x43 = var_x42;
        const double var_x44 = 1.7739020544754105e-6 / var_x39;
        const double var_x45 = 0.00035619469026548675 * var_x30;
        const double var_x46 = exp(0.074873319003313496 * var_chaste_interface__membrane__Vm);
        const double var_x47 = var_chaste_interface__membrane__Vm / (-1.0 + var_x46);
        const double var_x48 = 8.8930116629204303e-8 * var_x47;
        const double var_x49 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
        const double var_x50 = pow(var_chaste_interface__Na__Na_i, 3);
        const double var_x51 = 1 / (13227.9606 + 8.4084932990912282 * var_x50 + 4344355.375 * var_chaste_interface__Ca__Ca_i);
        const double var_x52 = 1 / (1.0 + 0.32000000000000001 * var_x49);
        const double var_x53 = 1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
        const double var_x54 = var_x52 / var_x53;
        const double var_x55 = var_x51 * var_x54;
        const double var_x56 = var_x49 * var_x55;
        const double var_x57 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
        const double var_x58 = 6.4800000000000004 * var_x50 * var_x57 - 9878400.0 * var_x49 * var_chaste_interface__Ca__Ca_i;
        const double var_x59 = var_x54 * var_x58 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x50 + var_chaste_interface__Ca__Ca_i), 2);
        const double var_x60 = var_x51 * var_x52 * var_x58 / (pow(var_x53, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
        const double var_x61 = var_x46;
        const double var_x62 = pow(var_chaste_interface__Na__Na_i, 2);
        const double var_x63 = var_x55 * var_x57 * var_x62;
        const double var_x64 = var_x59 * var_x62;
        const double var_x65 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x66 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x67 = 1.0 + 0.0097788000000000007 / pow(var_x65, 2) + 4.0890000000000003e-5 / pow(var_x66, 2);
        const double var_x68 = 1 / var_x67;
        const double var_x69 = var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star;
        const double var_x70 = var_x47 * mParameters[0];
        const double var_x71 = 151.10797107941448 * var_x70;
        const double var_x72 = var_x69 * var_x71;
        const double var_x73 = -0.61380000000000001 + var_x61 * var_chaste_interface__Ca__Ca_ss_CaL;
        const double var_x74 = -var_x68 * var_x71 * var_x73;
        const double var_x75 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x76 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x77 = 1.0 + 0.0097788000000000007 / pow(var_x75, 2) + 4.0890000000000003e-5 / pow(var_x76, 2);
        const double var_x78 = 1 / var_x77;
        const double var_x79 = pow(var_chaste_interface__Na__Na_ss_sr, 3);
        const double var_x80 = 1.6200000000000001 * var_x57 * var_x79 - 2469600.0 * var_x49 * var_chaste_interface__Ca__Ca_ss_sr;
        const double var_x81 = 1.0 + 1.5624999999999999e-8 * var_x8;
        const double var_x82 = var_x52 / var_x81;
        const double var_x83 = var_x80 * var_x82;
        const double var_x84 = var_x83 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x79 + var_chaste_interface__Ca__Ca_ss_sr), 2);
        const double var_x85 = 1 / (13227.9606 + 8.4084932990912282 * var_x79 + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr);
        const double var_x86 = var_x82 * var_x85;
        const double var_x87 = var_x49 * var_x86;
        const double var_x88 = var_x52 * var_x80 * var_x85 / (pow(var_x81, 2) * pow(var_chaste_interface__Ca__Ca_ss_sr, 3));
        const double var_x89 = var_x78;
        const double var_x90 = pow(var_chaste_interface__Na__Na_ss_sr, 2);
        const double var_x91 = var_x57 * var_x86 * var_x90;
        const double var_x92 = var_x84 * var_x90;
        const double var_x93 = 1 / var_chaste_interface__Cl__Cl_i;
        const double var_x94 = log(100.0 * var_x93);
        const double var_x95 = 1 / var_chaste_interface__K__K_i;
        const double var_x96 = log(5.4000000000000004 * var_x95);
        const double var_x97 = 26.711785007306684 * var_x96;
        const double var_x98 = var_x97 + 26.711785007306684 * var_x94;
        const double var_x99 = 0.00047279859462932828 / (87.825100000000006 + var_x98);
        const double var_x100 = 6.1296950776416711e-8 * var_x98 / pow((1 + 0.30414750461208334 * var_x94 + 0.30414750461208334 * var_x96), 2);
        const double var_x101 = var_x100 * var_x93 - var_x93 * var_x99;
        const double var_x102 = 1 / var_chaste_interface__Na__Na_i;
        const double var_x103 = var_x94 + log(140.0 * var_x102);
        const double var_x104 = pow(var_x103, 4);
        const double var_x105 = 7.2087469970547496e-9 * pow(var_x103, 7) / pow((1 + 0.0085573053764671191 * var_x104), 2);
        const double var_x106 = 50.118419258935766 * pow(var_x103, 3) / (59494197.640692554 + 509110.01733929582 * var_x104);
        const double var_x107 = var_x105 * var_x93 - var_x106 * var_x93;
        const double var_x108 = var_x100 * var_x95 - var_x95 * var_x99;
        const double var_x109 = var_x102 * var_x105 - var_x102 * var_x106;
        const double var_x110 = pow(var_chaste_interface__Irel__Irel, 2);
        const double var_x111 = 0.037436659501656748 * var_chaste_interface__membrane__Vm;
        const double var_x112 = exp(var_x111);
        const double var_x113 = var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - var_x112);
        const double var_x114 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
        const double var_x115 = 1 / (pow(var_x114, 2) * pow(var_chaste_interface__Ca__Ca_ss_CaL, 5));
        const double var_x116 = 9.7200000000000016e-10 * var_x115;
        const double var_x117 = var_x116 * var_chaste_interface__ICaL__C;
        const double var_x118 = 1 / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)));
        const double var_x119 = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm));
        const double var_x120 = var_x118 * var_x119;
        const double var_x121 = -var_x120;
        const double var_x122 = 1 / var_x114;
        const double var_x123 = 3.0 * var_x122;
        const double var_x124 = 1 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm));
        const double var_x125 = 0.80000000000000004 * var_x124;
        const double var_x126 = 0.80000000000000004 - var_x125;
        const double var_x127 = 0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm));
        const double var_x128 = 1 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm));
        const double var_x129 = var_x127 + 0.032730010146303147 * var_x128;
        const double var_x130 = var_x126 * var_x129;
        const double var_x131 = -var_x123 - var_x130;
        const double var_x132 = 0.20000000000000001 + var_x125;
        const double var_x133 = var_x129 * var_x132;
        const double var_x134 = var_x118 * (1.0 - var_x119);
        const double var_x135 = 0.99990000999900008 * var_x124;
        const double var_x136 = -var_x135;
        const double var_x137 = 0.99990000999900008 + var_x136;
        const double var_x138 = 9.9990000999900015e-5 + var_x135;
        const double var_x139 = var_x132 * var_x137 / (var_x126 * var_x138);
        const double var_x140 = 9.7200000000000002e-16 * var_x115 * var_x139;
        const double var_x141 = var_x140 * var_chaste_interface__ICaL__CI;
        const double var_x142 = 3.0000000000000001e-6 * var_x122 * var_x139;
        const double var_x143 = -var_x133 - var_x142;
        const double var_x144 = 9.0720000000000001e-12 * var_x115 * var_x128 / pow((1 - 0.69999999999999996 * var_x122), 2);
        const double var_x145 = var_x144 * var_chaste_interface__ICaL__C_star;
        const double var_x146 = -9.9990000999900015e-5 + var_x136;
        const double var_x147 = var_x144 * var_chaste_interface__ICaL__CI_star;
        const double var_x148 = var_x127 + var_x128 / (25.0 - 17.5 * var_x122);
        const double var_x149 = var_x138 * var_x148;
        const double var_x150 = -9.9999999999999995e-7 - var_x149;
        const double var_x151 = var_x137 * var_x148;
        const double var_x152 = -0.99990000999900008 + var_x135;
        const double var_x153 = -1.0 - var_x151;
        const double var_x154 = var_x116 * var_chaste_interface__ICaL__O;
        const double var_x155 = -var_x134;
        const double var_x156 = var_x140 * var_chaste_interface__ICaL__OI;
        const double var_x157 = var_x144 * var_chaste_interface__ICaL__O_star;
        const double var_x158 = var_x144 * var_chaste_interface__ICaL__OI_star;
        const double var_x159 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
        const double var_x160 = 0.059456000000000002 * var_x159;
        const double var_x161 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
        const double var_x162 = 0.083986000000000005 * var_x161;
        const double var_x163 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
        const double var_x164 = 0.0062345999999999999 * var_x163;
        const double var_x165 = -var_x164;
        const double var_x166 = 0.029728000000000001 * var_x159;
        const double var_x167 = -var_x166;
        const double var_x168 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
        const double var_x169 = 0.014600999999999999 * var_x168;
        const double var_x170 = 0.014864 * var_x159;
        const double var_x171 = -var_x170;
        const double var_x172 = -var_x162 - var_x169;
        const double var_x173 = 0.16797200000000001 * var_x161;
        const double var_x174 = 0.0093518999999999998 * var_x163;
        const double var_x175 = 0.029201999999999999 * var_x168;
        const double var_x176 = -var_x173 - var_x175;
        const double var_x177 = 0.043802999999999995 * var_x168;
        const double var_x178 = -var_x174;
        const double var_x179 = 0.0124692 * var_x163;
        const double var_x180 = 0.07732 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm);
        const double var_x181 = 0.044592 * var_x159;
        const double var_x182 = -var_x181;
        const double var_x183 = 0.0031172999999999999 * var_x163;
        const double var_x184 = 0.25195800000000002 * var_x161;
        const double var_x185 = -var_x177 - var_x184;
        const double var_x186 = 0.33594400000000002 * var_x161;
        const double var_x187 = 0.058403999999999998 * var_x168;
        const double var_x188 = -var_x183;
        const double var_x189 = 0.58638000000000001 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm);
        const double var_x190 = 0.79405000000000003 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm);
        const double var_x191 = 1 / var_x5;
        const double var_x192 = pow(var_x191, 10.0);
        const double var_x193 = 1.0 + 2.9619676669542428e-6 * var_x192;
        const double var_x194 = var_x191 * var_x192 / pow(var_x193, 2);
        const double var_x195 = var_x194 * (-1 + var_x3);
        const double var_x196 = 1 / var_chaste_interface__Ca__Ca_JSR;
        const double var_x197 = 1.0 + 0.0123 * var_x196;
        const double var_x198 = 1 / var_x193;
        const double var_x199 = 0.53437500000000004 + 0.53437500000000004 * var_x198;
        const double var_x200 = var_x199 * var_x69 * var_x70 * var_x73;
        const double var_x201 = pow(var_x196, 8.0);
        const double var_x202 = 1.0 + var_x201;
        const double var_x203 = 1 / var_x202;
        const double var_x204 = 14448.603861345418 * var_x203;
        const double var_x205 = var_x14 - var_x200 * var_x204;
        const double var_x206 = var_x197 * var_x205 / pow((1 + var_x198), 2);
        const double var_x207 = 1 / (4.75 + 4.75 * var_x198);
        const double var_x208 = var_x197 * var_x207;
        const double var_x209 = var_x208 * var_x70 * var_x73;
        const double var_x210 = var_x203 * var_x209 * var_x69;
        const double var_x211 = var_x199 * var_x204;
        const double var_x212 = var_x194 * var_x9;
        const double var_x213 = -var_x209 * var_x211;
        const double var_x214 = 1 / var_chaste_interface__Ca__Ca_i;
        const double var_x215 = pow(var_x214, 1.3999999999999999);
        const double var_x216 = 1.0 + 6.4818210260626455e-7 * var_x215;
        const double var_x217 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
        const double var_x218 = -26.711785007306684 * log(7.9662000000000006 / var_x217) + var_chaste_interface__membrane__Vm;
        const double var_x219 = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2;
        const double var_x220 = -5.0964977286841363e-6 - 3.0578986372104813e-6 / var_x216;
        const double var_x221 = var_x218 * var_x220;
        const double var_x222 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * var_x96);
        const double var_x223 = 1.0 + var_x222;
        const double var_x224 = 1 / var_x223;
        const double var_x225 = exp(-2.4444678999999998 + 13.737871029257827 * var_x96 - 0.51429999999999998 * var_chaste_interface__membrane__Vm);
        const double var_x226 = 1.0 + var_x225;
        const double var_x227 = 1 / var_x226;
        const double var_x228 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * var_x96);
        const double var_x229 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * var_x96);
        const double var_x230 = var_x229 + 0.49124000000000001 * var_x228;
        const double var_x231 = var_x227 * var_x230;
        const double var_x232 = var_x95 / (var_x231 + 1.02 * var_x224);
        const double var_x233 = var_x219 * var_x220 * (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x217, 2);
        const double var_x234 = -var_x97 + var_chaste_interface__membrane__Vm;
        const double var_x235 = var_x222 / pow(var_x223, 2);
        const double var_x236 = 1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i;
        const double var_x237 = 1 / (1.0 + exp(-3.4441726741524206 - var_x111));
        const double var_x238 = var_x237 * var_x62 / pow(var_x236, 3);
        const double var_x239 = var_x237 * var_x50 / pow(var_x236, 4);
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.00068000000000000005 - var_x5 * var_x6 + var_x0 * var_x6 * var_x7));
        rJacobian[0][1] = 0.0;
        rJacobian[0][2] = 0.0;
        rJacobian[0][3] = 0.0;
        rJacobian[0][4] = 0.0;
        rJacobian[0][5] = -(mDt * (3.7500000000000005e-6 * var_x5 * var_x9 + 1.8750000000000003e-7 * var_x8 * pow(var_x0, 2) / pow(var_x1, 3)));
        rJacobian[0][6] = 0.0;
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = 0.0;
        rJacobian[0][15] = 0.0;
        rJacobian[0][16] = 0.0;
        rJacobian[0][17] = 0.0;
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = 0.0;
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = 0.0;
        rJacobian[0][24] = 0.0;
        rJacobian[0][25] = 0.0;
        rJacobian[0][26] = 0.0;
        rJacobian[0][27] = 0.0;
        rJacobian[0][28] = 0.0;
        rJacobian[0][29] = 0.0;
        rJacobian[0][30] = 0.0;
        rJacobian[0][31] = 0.0;
        rJacobian[0][32] = 0.0;
        rJacobian[0][33] = 0.0;
        rJacobian[0][34] = 0.0;
        rJacobian[0][35] = 0.0;
        rJacobian[0][36] = 0.0;
        rJacobian[1][0] = 0.0;
        rJacobian[1][1] = 1.0 - (mDt * (-var_x13 + 0.25 * (var_x14 + 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR) / (pow(var_x10, 3) * pow((0.125 + var_x11), 2))));
        rJacobian[1][2] = -(mDt * (var_x13));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = 0.0;
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = 0.0;
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[1][25] = 0.0;
        rJacobian[1][26] = 0.0;
        rJacobian[1][27] = 0.0;
        rJacobian[1][28] = 0.0;
        rJacobian[1][29] = 0.0;
        rJacobian[1][30] = 0.0;
        rJacobian[1][31] = 0.0;
        rJacobian[1][32] = 0.0;
        rJacobian[1][33] = -(mDt * (-1.0 * var_x12));
        rJacobian[1][34] = 0.0;
        rJacobian[1][35] = 0.0;
        rJacobian[1][36] = 0.0;
        rJacobian[2][0] = -(mDt * (var_x20 * var_x25 + var_x26 * var_x29));
        rJacobian[2][1] = -(mDt * (0.0034782608695652171));
        rJacobian[2][2] = 1.0 - (mDt * (-0.0037699275362318837));
        rJacobian[2][3] = -(mDt * (-var_x29 + 0.0043750000000000004 * var_x30));
        rJacobian[2][4] = 0.0;
        rJacobian[2][5] = -(mDt * (var_x25 * var_x33 + var_x29 * var_x34));
        rJacobian[2][6] = 0.0;
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = 0.0;
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = 0.0;
        rJacobian[2][15] = 0.0;
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = 0.0;
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[2][25] = 0.0;
        rJacobian[2][26] = 0.0;
        rJacobian[2][27] = 0.0;
        rJacobian[2][28] = 0.0;
        rJacobian[2][29] = 0.0;
        rJacobian[2][30] = 0.0;
        rJacobian[2][31] = 0.0;
        rJacobian[2][32] = 0.0;
        rJacobian[2][33] = 0.0;
        rJacobian[2][34] = 0.0;
        rJacobian[2][35] = 0.0;
        rJacobian[2][36] = 0.0;
        rJacobian[3][0] = -(mDt * (var_x43 * (-var_x20 * var_x36 - var_x26 * var_x37)));
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = -(mDt * (2.3746312684365782e-5 * var_x42));
        rJacobian[3][3] = 1.0 - (mDt * (var_x43 * (-0.014749262536873154 + var_x37 - var_x44 - var_x45 + 1.9281544070384897e-12 * var_x60 - 609.50657582364852 * var_x56 - 1.4202553819674954e-11 * var_x59 - var_x46 * var_x48 + 1.7739020544754105e-6 * var_x40 * var_chaste_interface__Ca__Ca_i) + (0.00023800000000000004 / pow(var_x38, 3) + 7.0000000000000007e-5 / pow(var_x39, 3)) * (2.3746312684365782e-5 * var_chaste_interface__Ca__Ca_NSR + 0.014749262536873154 * var_chaste_interface__Ca__Ca_ss_sr - 0.014749262536873154 * var_chaste_interface__Ca__Ca_i - var_x44 * var_chaste_interface__Ca__Ca_i - var_x45 * var_chaste_interface__Ca__Ca_i - var_x48 * (-0.61380000000000001 + var_x61 * var_chaste_interface__Ca__Ca_i) + 6.1700941025231664e-5 * var_x55 * var_x58) / pow(var_x41, 2)));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (var_x43 * (0.014749262536873154 - var_x33 * var_x36 - var_x34 * var_x37)));
        rJacobian[3][6] = 0.0;
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = 0.0;
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = 0.0;
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = 0.0;
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[3][25] = 0.0;
        rJacobian[3][26] = 0.0;
        rJacobian[3][27] = 0.0;
        rJacobian[3][28] = 0.0;
        rJacobian[3][29] = 0.0;
        rJacobian[3][30] = 0.0;
        rJacobian[3][31] = 0.0;
        rJacobian[3][32] = 0.0;
        rJacobian[3][33] = 0.0;
        rJacobian[3][34] = 0.0;
        rJacobian[3][35] = -(mDt * (var_x43 * (0.0011994662935305037 * var_x63 - 8.2467064718009662e-17 * var_x64)));
        rJacobian[3][36] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = 0.0;
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (var_x68 * (-5.0 - var_x46 * var_x72) + (0.019557600000000001 / pow(var_x65, 3) + 8.1780000000000006e-5 / pow(var_x66, 3)) * (5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_ss_CaL - var_x72 * var_x73) / pow(var_x67, 2)));
        rJacobian[4][5] = -(mDt * (5.0 * var_x68));
        rJacobian[4][6] = 0.0;
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = -(mDt * (var_x74));
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = -(mDt * (var_x74));
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = 0.0;
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[4][25] = 0.0;
        rJacobian[4][26] = 0.0;
        rJacobian[4][27] = 0.0;
        rJacobian[4][28] = 0.0;
        rJacobian[4][29] = 0.0;
        rJacobian[4][30] = 0.0;
        rJacobian[4][31] = 0.0;
        rJacobian[4][32] = 0.0;
        rJacobian[4][33] = 0.0;
        rJacobian[4][34] = 0.0;
        rJacobian[4][35] = 0.0;
        rJacobian[4][36] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = 0.0;
        rJacobian[5][3] = -(mDt * (5.0 * var_x78));
        rJacobian[5][4] = -(mDt * (0.5 * var_x78));
        rJacobian[5][5] = 1.0 - (mDt * (var_x89 * (-5.5 + 6.53644343986048e-11 * var_x88 - 4.8146657448698097e-10 * var_x84 - 5165.5682301054212 * var_x87) + (0.019557600000000001 / pow(var_x75, 3) + 8.1780000000000006e-5 / pow(var_x76, 3)) * (0.5 * var_chaste_interface__Ca__Ca_ss_CaL + 0.23999999999999996 * var_chaste_interface__Irel__Irel + 5.0 * var_chaste_interface__Ca__Ca_i - 5.5 * var_chaste_interface__Ca__Ca_ss_sr + 0.0020916619007553534 * var_x83 * var_x85) / pow(var_x77, 2)));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = 0.0;
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = 0.0;
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = 0.0;
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[5][25] = 0.0;
        rJacobian[5][26] = 0.0;
        rJacobian[5][27] = 0.0;
        rJacobian[5][28] = 0.0;
        rJacobian[5][29] = 0.0;
        rJacobian[5][30] = 0.0;
        rJacobian[5][31] = 0.0;
        rJacobian[5][32] = 0.0;
        rJacobian[5][33] = -(mDt * (0.23999999999999996 * var_x78));
        rJacobian[5][34] = 0.0;
        rJacobian[5][35] = 0.0;
        rJacobian[5][36] = -(mDt * (var_x89 * (0.010165476837671019 * var_x91 - 2.7956334939405277e-15 * var_x92)));
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = 0.0;
        rJacobian[6][3] = 0.0;
        rJacobian[6][4] = 0.0;
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.14749262536873156 + var_x101 + var_x107 - 3.7083201106826184e-7 * var_x93));
        rJacobian[6][7] = -(mDt * (0.14749262536873156));
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = 0.0;
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = 0.0;
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[6][25] = 0.0;
        rJacobian[6][26] = 0.0;
        rJacobian[6][27] = 0.0;
        rJacobian[6][28] = 0.0;
        rJacobian[6][29] = 0.0;
        rJacobian[6][30] = 0.0;
        rJacobian[6][31] = 0.0;
        rJacobian[6][32] = 0.0;
        rJacobian[6][33] = 0.0;
        rJacobian[6][34] = -(mDt * (var_x108));
        rJacobian[6][35] = -(mDt * (var_x109));
        rJacobian[6][36] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = -(mDt * (5.0 + 6.799858698573652e-6 * var_x113 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * var_x110))));
        rJacobian[7][7] = 1.0 - (mDt * (-5.0));
        rJacobian[7][8] = 0.0;
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = 0.0;
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = 0.0;
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[7][25] = 0.0;
        rJacobian[7][26] = 0.0;
        rJacobian[7][27] = 0.0;
        rJacobian[7][28] = 0.0;
        rJacobian[7][29] = 0.0;
        rJacobian[7][30] = 0.0;
        rJacobian[7][31] = 0.0;
        rJacobian[7][32] = 0.0;
        rJacobian[7][33] = -(mDt * (2.175954783543569e-6 * var_x113 * (-100.0 * var_x112 + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Irel__Irel / pow((0.16000000000000003 + var_x110), 2)));
        rJacobian[7][34] = 0.0;
        rJacobian[7][35] = 0.0;
        rJacobian[7][36] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = -(mDt * (-var_x117));
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = 0.0;
        rJacobian[8][8] = 1.0 - (mDt * (var_x121 + var_x131));
        rJacobian[8][9] = -(mDt * (var_x133));
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = -(mDt * (1.0));
        rJacobian[8][12] = -(mDt * (var_x134));
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = 0.0;
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[8][25] = 0.0;
        rJacobian[8][26] = 0.0;
        rJacobian[8][27] = 0.0;
        rJacobian[8][28] = 0.0;
        rJacobian[8][29] = 0.0;
        rJacobian[8][30] = 0.0;
        rJacobian[8][31] = 0.0;
        rJacobian[8][32] = 0.0;
        rJacobian[8][33] = 0.0;
        rJacobian[8][34] = 0.0;
        rJacobian[8][35] = 0.0;
        rJacobian[8][36] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = -(mDt * (-var_x141));
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = -(mDt * (var_x130));
        rJacobian[9][9] = 1.0 - (mDt * (var_x121 + var_x143));
        rJacobian[9][10] = -(mDt * (9.9999999999999995e-7));
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = 0.0;
        rJacobian[9][13] = -(mDt * (var_x134));
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = 0.0;
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = 0.0;
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[9][25] = 0.0;
        rJacobian[9][26] = 0.0;
        rJacobian[9][27] = 0.0;
        rJacobian[9][28] = 0.0;
        rJacobian[9][29] = 0.0;
        rJacobian[9][30] = 0.0;
        rJacobian[9][31] = 0.0;
        rJacobian[9][32] = 0.0;
        rJacobian[9][33] = 0.0;
        rJacobian[9][34] = 0.0;
        rJacobian[9][35] = 0.0;
        rJacobian[9][36] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = -(mDt * (var_x141 + var_x137 * var_x145 + var_x146 * var_x147));
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = -(mDt * (var_x142));
        rJacobian[10][10] = 1.0 - (mDt * (var_x121 + var_x150));
        rJacobian[10][11] = -(mDt * (var_x151));
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = -(mDt * (var_x134));
        rJacobian[10][15] = 0.0;
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[10][25] = 0.0;
        rJacobian[10][26] = 0.0;
        rJacobian[10][27] = 0.0;
        rJacobian[10][28] = 0.0;
        rJacobian[10][29] = 0.0;
        rJacobian[10][30] = 0.0;
        rJacobian[10][31] = 0.0;
        rJacobian[10][32] = 0.0;
        rJacobian[10][33] = 0.0;
        rJacobian[10][34] = 0.0;
        rJacobian[10][35] = 0.0;
        rJacobian[10][36] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = -(mDt * (var_x117 + var_x138 * var_x147 + var_x145 * var_x152));
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = 0.0;
        rJacobian[11][8] = -(mDt * (var_x123));
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = -(mDt * (var_x149));
        rJacobian[11][11] = 1.0 - (mDt * (var_x121 + var_x153));
        rJacobian[11][12] = 0.0;
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = -(mDt * (var_x134));
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[11][25] = 0.0;
        rJacobian[11][26] = 0.0;
        rJacobian[11][27] = 0.0;
        rJacobian[11][28] = 0.0;
        rJacobian[11][29] = 0.0;
        rJacobian[11][30] = 0.0;
        rJacobian[11][31] = 0.0;
        rJacobian[11][32] = 0.0;
        rJacobian[11][33] = 0.0;
        rJacobian[11][34] = 0.0;
        rJacobian[11][35] = 0.0;
        rJacobian[11][36] = 0.0;
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = -(mDt * (-var_x154));
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = 0.0;
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = -(mDt * (var_x120));
        rJacobian[12][9] = 0.0;
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = 0.0;
        rJacobian[12][12] = 1.0 - (mDt * (var_x131 + var_x155));
        rJacobian[12][13] = -(mDt * (var_x133));
        rJacobian[12][14] = 0.0;
        rJacobian[12][15] = -(mDt * (1.0));
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = 0.0;
        rJacobian[12][21] = 0.0;
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[12][25] = 0.0;
        rJacobian[12][26] = 0.0;
        rJacobian[12][27] = 0.0;
        rJacobian[12][28] = 0.0;
        rJacobian[12][29] = 0.0;
        rJacobian[12][30] = 0.0;
        rJacobian[12][31] = 0.0;
        rJacobian[12][32] = 0.0;
        rJacobian[12][33] = 0.0;
        rJacobian[12][34] = 0.0;
        rJacobian[12][35] = 0.0;
        rJacobian[12][36] = 0.0;
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = -(mDt * (-var_x156));
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = 0.0;
        rJacobian[13][7] = 0.0;
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = -(mDt * (var_x120));
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = -(mDt * (var_x130));
        rJacobian[13][13] = 1.0 - (mDt * (var_x143 + var_x155));
        rJacobian[13][14] = -(mDt * (9.9999999999999995e-7));
        rJacobian[13][15] = 0.0;
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[13][25] = 0.0;
        rJacobian[13][26] = 0.0;
        rJacobian[13][27] = 0.0;
        rJacobian[13][28] = 0.0;
        rJacobian[13][29] = 0.0;
        rJacobian[13][30] = 0.0;
        rJacobian[13][31] = 0.0;
        rJacobian[13][32] = 0.0;
        rJacobian[13][33] = 0.0;
        rJacobian[13][34] = 0.0;
        rJacobian[13][35] = 0.0;
        rJacobian[13][36] = 0.0;
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = -(mDt * (var_x156 + var_x137 * var_x157 + var_x146 * var_x158));
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = -(mDt * (var_x120));
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = 0.0;
        rJacobian[14][13] = -(mDt * (var_x142));
        rJacobian[14][14] = 1.0 - (mDt * (var_x150 + var_x155));
        rJacobian[14][15] = -(mDt * (var_x151));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = 0.0;
        rJacobian[14][21] = 0.0;
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[14][25] = 0.0;
        rJacobian[14][26] = 0.0;
        rJacobian[14][27] = 0.0;
        rJacobian[14][28] = 0.0;
        rJacobian[14][29] = 0.0;
        rJacobian[14][30] = 0.0;
        rJacobian[14][31] = 0.0;
        rJacobian[14][32] = 0.0;
        rJacobian[14][33] = 0.0;
        rJacobian[14][34] = 0.0;
        rJacobian[14][35] = 0.0;
        rJacobian[14][36] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = -(mDt * (var_x154 + var_x138 * var_x158 + var_x152 * var_x157));
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = 0.0;
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = 0.0;
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = -(mDt * (var_x120));
        rJacobian[15][12] = -(mDt * (var_x123));
        rJacobian[15][13] = 0.0;
        rJacobian[15][14] = -(mDt * (var_x149));
        rJacobian[15][15] = 1.0 - (mDt * (var_x153 + var_x155));
        rJacobian[15][16] = 0.0;
        rJacobian[15][17] = 0.0;
        rJacobian[15][18] = 0.0;
        rJacobian[15][19] = 0.0;
        rJacobian[15][20] = 0.0;
        rJacobian[15][21] = 0.0;
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = 0.0;
        rJacobian[15][25] = 0.0;
        rJacobian[15][26] = 0.0;
        rJacobian[15][27] = 0.0;
        rJacobian[15][28] = 0.0;
        rJacobian[15][29] = 0.0;
        rJacobian[15][30] = 0.0;
        rJacobian[15][31] = 0.0;
        rJacobian[15][32] = 0.0;
        rJacobian[15][33] = 0.0;
        rJacobian[15][34] = 0.0;
        rJacobian[15][35] = 0.0;
        rJacobian[15][36] = 0.0;
        rJacobian[16][0] = 0.0;
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = 0.0;
        rJacobian[16][5] = 0.0;
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = 0.0;
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = 0.0;
        rJacobian[16][16] = 1.0 - (mDt * (-var_x160));
        rJacobian[16][17] = 0.0;
        rJacobian[16][18] = 0.0;
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = 0.0;
        rJacobian[16][21] = 0.0;
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = -(mDt * (var_x162));
        rJacobian[16][24] = 0.0;
        rJacobian[16][25] = 0.0;
        rJacobian[16][26] = 0.0;
        rJacobian[16][27] = 0.0;
        rJacobian[16][28] = 0.0;
        rJacobian[16][29] = 0.0;
        rJacobian[16][30] = 0.0;
        rJacobian[16][31] = 0.0;
        rJacobian[16][32] = 0.0;
        rJacobian[16][33] = 0.0;
        rJacobian[16][34] = 0.0;
        rJacobian[16][35] = 0.0;
        rJacobian[16][36] = 0.0;
        rJacobian[17][0] = 0.0;
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = 0.0;
        rJacobian[17][5] = 0.0;
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = 0.0;
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = 0.0;
        rJacobian[17][16] = 0.0;
        rJacobian[17][17] = 1.0 - (mDt * (var_x165 + var_x167));
        rJacobian[17][18] = -(mDt * (var_x162));
        rJacobian[17][19] = 0.0;
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = 0.0;
        rJacobian[17][22] = 0.0;
        rJacobian[17][23] = 0.0;
        rJacobian[17][24] = 0.0;
        rJacobian[17][25] = 0.0;
        rJacobian[17][26] = 0.0;
        rJacobian[17][27] = 0.0;
        rJacobian[17][28] = -(mDt * (var_x169));
        rJacobian[17][29] = 0.0;
        rJacobian[17][30] = 0.0;
        rJacobian[17][31] = 0.0;
        rJacobian[17][32] = 0.0;
        rJacobian[17][33] = 0.0;
        rJacobian[17][34] = 0.0;
        rJacobian[17][35] = 0.0;
        rJacobian[17][36] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = 0.0;
        rJacobian[18][15] = 0.0;
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = -(mDt * (var_x166));
        rJacobian[18][18] = 1.0 - (mDt * (var_x165 + var_x171 + var_x172));
        rJacobian[18][19] = -(mDt * (var_x173));
        rJacobian[18][20] = -(mDt * (var_x174));
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = 0.0;
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[18][25] = 0.0;
        rJacobian[18][26] = 0.0;
        rJacobian[18][27] = 0.0;
        rJacobian[18][28] = 0.0;
        rJacobian[18][29] = -(mDt * (var_x175));
        rJacobian[18][30] = 0.0;
        rJacobian[18][31] = 0.0;
        rJacobian[18][32] = 0.0;
        rJacobian[18][33] = 0.0;
        rJacobian[18][34] = 0.0;
        rJacobian[18][35] = 0.0;
        rJacobian[18][36] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = 0.0;
        rJacobian[19][15] = 0.0;
        rJacobian[19][16] = 0.0;
        rJacobian[19][17] = 0.0;
        rJacobian[19][18] = -(mDt * (var_x170));
        rJacobian[19][19] = 1.0 - (mDt * (var_x165 + var_x176));
        rJacobian[19][20] = 0.0;
        rJacobian[19][21] = -(mDt * (var_x174));
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = 0.0;
        rJacobian[19][24] = 0.0;
        rJacobian[19][25] = 0.0;
        rJacobian[19][26] = 0.0;
        rJacobian[19][27] = 0.0;
        rJacobian[19][28] = 0.0;
        rJacobian[19][29] = 0.0;
        rJacobian[19][30] = -(mDt * (var_x177));
        rJacobian[19][31] = 0.0;
        rJacobian[19][32] = 0.0;
        rJacobian[19][33] = 0.0;
        rJacobian[19][34] = 0.0;
        rJacobian[19][35] = 0.0;
        rJacobian[19][36] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = 0.0;
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = 0.0;
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = -(mDt * (var_x169));
        rJacobian[20][19] = 0.0;
        rJacobian[20][20] = 1.0 - (mDt * (var_x171 + var_x178));
        rJacobian[20][21] = -(mDt * (var_x162));
        rJacobian[20][22] = 0.0;
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[20][25] = 0.0;
        rJacobian[20][26] = 0.0;
        rJacobian[20][27] = 0.0;
        rJacobian[20][28] = 0.0;
        rJacobian[20][29] = 0.0;
        rJacobian[20][30] = 0.0;
        rJacobian[20][31] = 0.0;
        rJacobian[20][32] = 0.0;
        rJacobian[20][33] = 0.0;
        rJacobian[20][34] = 0.0;
        rJacobian[20][35] = 0.0;
        rJacobian[20][36] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = 0.0;
        rJacobian[21][11] = 0.0;
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = 0.0;
        rJacobian[21][15] = 0.0;
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = 0.0;
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = -(mDt * (var_x175));
        rJacobian[21][20] = -(mDt * (var_x170));
        rJacobian[21][21] = 1.0 - (mDt * (var_x172 + var_x178));
        rJacobian[21][22] = -(mDt * (var_x179));
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[21][25] = 0.0;
        rJacobian[21][26] = 0.0;
        rJacobian[21][27] = 0.0;
        rJacobian[21][28] = 0.0;
        rJacobian[21][29] = 0.0;
        rJacobian[21][30] = 0.0;
        rJacobian[21][31] = 0.0;
        rJacobian[21][32] = 0.0;
        rJacobian[21][33] = 0.0;
        rJacobian[21][34] = 0.0;
        rJacobian[21][35] = 0.0;
        rJacobian[21][36] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = 0.0;
        rJacobian[22][11] = 0.0;
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = 0.0;
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = 0.0;
        rJacobian[22][18] = 0.0;
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = 0.0;
        rJacobian[22][21] = -(mDt * (var_x169));
        rJacobian[22][22] = 1.0 - (mDt * (-0.089538000000000006 - var_x179));
        rJacobian[22][23] = 0.0;
        rJacobian[22][24] = 0.0;
        rJacobian[22][25] = 0.0;
        rJacobian[22][26] = 0.0;
        rJacobian[22][27] = 0.0;
        rJacobian[22][28] = 0.0;
        rJacobian[22][29] = 0.0;
        rJacobian[22][30] = 0.0;
        rJacobian[22][31] = -(mDt * (var_x180));
        rJacobian[22][32] = 0.0;
        rJacobian[22][33] = 0.0;
        rJacobian[22][34] = 0.0;
        rJacobian[22][35] = 0.0;
        rJacobian[22][36] = 0.0;
        rJacobian[23][0] = 0.0;
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = 0.0;
        rJacobian[23][11] = 0.0;
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = 0.0;
        rJacobian[23][16] = -(mDt * (var_x160));
        rJacobian[23][17] = 0.0;
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = 0.0;
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = 0.0;
        rJacobian[23][23] = 1.0 - (mDt * (var_x172 + var_x182));
        rJacobian[23][24] = -(mDt * (var_x173));
        rJacobian[23][25] = 0.0;
        rJacobian[23][26] = 0.0;
        rJacobian[23][27] = -(mDt * (var_x183));
        rJacobian[23][28] = 0.0;
        rJacobian[23][29] = 0.0;
        rJacobian[23][30] = 0.0;
        rJacobian[23][31] = 0.0;
        rJacobian[23][32] = 0.0;
        rJacobian[23][33] = 0.0;
        rJacobian[23][34] = 0.0;
        rJacobian[23][35] = 0.0;
        rJacobian[23][36] = 0.0;
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = 0.0;
        rJacobian[24][16] = 0.0;
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = 0.0;
        rJacobian[24][23] = -(mDt * (var_x181));
        rJacobian[24][24] = 1.0 - (mDt * (var_x167 + var_x176));
        rJacobian[24][25] = -(mDt * (var_x184));
        rJacobian[24][26] = 0.0;
        rJacobian[24][27] = 0.0;
        rJacobian[24][28] = -(mDt * (var_x183));
        rJacobian[24][29] = 0.0;
        rJacobian[24][30] = 0.0;
        rJacobian[24][31] = 0.0;
        rJacobian[24][32] = 0.0;
        rJacobian[24][33] = 0.0;
        rJacobian[24][34] = 0.0;
        rJacobian[24][35] = 0.0;
        rJacobian[24][36] = 0.0;
        rJacobian[25][0] = 0.0;
        rJacobian[25][1] = 0.0;
        rJacobian[25][2] = 0.0;
        rJacobian[25][3] = 0.0;
        rJacobian[25][4] = 0.0;
        rJacobian[25][5] = 0.0;
        rJacobian[25][6] = 0.0;
        rJacobian[25][7] = 0.0;
        rJacobian[25][8] = 0.0;
        rJacobian[25][9] = 0.0;
        rJacobian[25][10] = 0.0;
        rJacobian[25][11] = 0.0;
        rJacobian[25][12] = 0.0;
        rJacobian[25][13] = 0.0;
        rJacobian[25][14] = 0.0;
        rJacobian[25][15] = 0.0;
        rJacobian[25][16] = 0.0;
        rJacobian[25][17] = 0.0;
        rJacobian[25][18] = 0.0;
        rJacobian[25][19] = 0.0;
        rJacobian[25][20] = 0.0;
        rJacobian[25][21] = 0.0;
        rJacobian[25][22] = 0.0;
        rJacobian[25][23] = 0.0;
        rJacobian[25][24] = -(mDt * (var_x166));
        rJacobian[25][25] = 1.0 - (mDt * (var_x171 + var_x185));
        rJacobian[25][26] = -(mDt * (var_x186));
        rJacobian[25][27] = 0.0;
        rJacobian[25][28] = 0.0;
        rJacobian[25][29] = -(mDt * (var_x183));
        rJacobian[25][30] = 0.0;
        rJacobian[25][31] = 0.0;
        rJacobian[25][32] = 0.0;
        rJacobian[25][33] = 0.0;
        rJacobian[25][34] = 0.0;
        rJacobian[25][35] = 0.0;
        rJacobian[25][36] = 0.0;
        rJacobian[26][0] = 0.0;
        rJacobian[26][1] = 0.0;
        rJacobian[26][2] = 0.0;
        rJacobian[26][3] = 0.0;
        rJacobian[26][4] = 0.0;
        rJacobian[26][5] = 0.0;
        rJacobian[26][6] = 0.0;
        rJacobian[26][7] = 0.0;
        rJacobian[26][8] = 0.0;
        rJacobian[26][9] = 0.0;
        rJacobian[26][10] = 0.0;
        rJacobian[26][11] = 0.0;
        rJacobian[26][12] = 0.0;
        rJacobian[26][13] = 0.0;
        rJacobian[26][14] = 0.0;
        rJacobian[26][15] = 0.0;
        rJacobian[26][16] = 0.0;
        rJacobian[26][17] = 0.0;
        rJacobian[26][18] = 0.0;
        rJacobian[26][19] = 0.0;
        rJacobian[26][20] = 0.0;
        rJacobian[26][21] = 0.0;
        rJacobian[26][22] = 0.0;
        rJacobian[26][23] = 0.0;
        rJacobian[26][24] = 0.0;
        rJacobian[26][25] = -(mDt * (var_x170));
        rJacobian[26][26] = 1.0 - (mDt * (-var_x186 - var_x187));
        rJacobian[26][27] = 0.0;
        rJacobian[26][28] = 0.0;
        rJacobian[26][29] = 0.0;
        rJacobian[26][30] = -(mDt * (var_x183));
        rJacobian[26][31] = 0.0;
        rJacobian[26][32] = 0.0;
        rJacobian[26][33] = 0.0;
        rJacobian[26][34] = 0.0;
        rJacobian[26][35] = 0.0;
        rJacobian[26][36] = 0.0;
        rJacobian[27][0] = 0.0;
        rJacobian[27][1] = 0.0;
        rJacobian[27][2] = 0.0;
        rJacobian[27][3] = 0.0;
        rJacobian[27][4] = 0.0;
        rJacobian[27][5] = 0.0;
        rJacobian[27][6] = 0.0;
        rJacobian[27][7] = 0.0;
        rJacobian[27][8] = 0.0;
        rJacobian[27][9] = 0.0;
        rJacobian[27][10] = 0.0;
        rJacobian[27][11] = 0.0;
        rJacobian[27][12] = 0.0;
        rJacobian[27][13] = 0.0;
        rJacobian[27][14] = 0.0;
        rJacobian[27][15] = 0.0;
        rJacobian[27][16] = 0.0;
        rJacobian[27][17] = 0.0;
        rJacobian[27][18] = 0.0;
        rJacobian[27][19] = 0.0;
        rJacobian[27][20] = 0.0;
        rJacobian[27][21] = 0.0;
        rJacobian[27][22] = 0.0;
        rJacobian[27][23] = -(mDt * (var_x169));
        rJacobian[27][24] = 0.0;
        rJacobian[27][25] = 0.0;
        rJacobian[27][26] = 0.0;
        rJacobian[27][27] = 1.0 - (mDt * (var_x182 + var_x188));
        rJacobian[27][28] = -(mDt * (var_x162));
        rJacobian[27][29] = 0.0;
        rJacobian[27][30] = 0.0;
        rJacobian[27][31] = 0.0;
        rJacobian[27][32] = 0.0;
        rJacobian[27][33] = 0.0;
        rJacobian[27][34] = 0.0;
        rJacobian[27][35] = 0.0;
        rJacobian[27][36] = 0.0;
        rJacobian[28][0] = 0.0;
        rJacobian[28][1] = 0.0;
        rJacobian[28][2] = 0.0;
        rJacobian[28][3] = 0.0;
        rJacobian[28][4] = 0.0;
        rJacobian[28][5] = 0.0;
        rJacobian[28][6] = 0.0;
        rJacobian[28][7] = 0.0;
        rJacobian[28][8] = 0.0;
        rJacobian[28][9] = 0.0;
        rJacobian[28][10] = 0.0;
        rJacobian[28][11] = 0.0;
        rJacobian[28][12] = 0.0;
        rJacobian[28][13] = 0.0;
        rJacobian[28][14] = 0.0;
        rJacobian[28][15] = 0.0;
        rJacobian[28][16] = 0.0;
        rJacobian[28][17] = -(mDt * (var_x164));
        rJacobian[28][18] = 0.0;
        rJacobian[28][19] = 0.0;
        rJacobian[28][20] = 0.0;
        rJacobian[28][21] = 0.0;
        rJacobian[28][22] = 0.0;
        rJacobian[28][23] = 0.0;
        rJacobian[28][24] = -(mDt * (var_x175));
        rJacobian[28][25] = 0.0;
        rJacobian[28][26] = 0.0;
        rJacobian[28][27] = -(mDt * (var_x181));
        rJacobian[28][28] = 1.0 - (mDt * (var_x167 + var_x172 + var_x188));
        rJacobian[28][29] = -(mDt * (var_x173));
        rJacobian[28][30] = 0.0;
        rJacobian[28][31] = 0.0;
        rJacobian[28][32] = 0.0;
        rJacobian[28][33] = 0.0;
        rJacobian[28][34] = 0.0;
        rJacobian[28][35] = 0.0;
        rJacobian[28][36] = 0.0;
        rJacobian[29][0] = 0.0;
        rJacobian[29][1] = 0.0;
        rJacobian[29][2] = 0.0;
        rJacobian[29][3] = 0.0;
        rJacobian[29][4] = 0.0;
        rJacobian[29][5] = 0.0;
        rJacobian[29][6] = 0.0;
        rJacobian[29][7] = 0.0;
        rJacobian[29][8] = 0.0;
        rJacobian[29][9] = 0.0;
        rJacobian[29][10] = 0.0;
        rJacobian[29][11] = 0.0;
        rJacobian[29][12] = 0.0;
        rJacobian[29][13] = 0.0;
        rJacobian[29][14] = 0.0;
        rJacobian[29][15] = 0.0;
        rJacobian[29][16] = 0.0;
        rJacobian[29][17] = 0.0;
        rJacobian[29][18] = -(mDt * (var_x164));
        rJacobian[29][19] = 0.0;
        rJacobian[29][20] = 0.0;
        rJacobian[29][21] = 0.0;
        rJacobian[29][22] = 0.0;
        rJacobian[29][23] = 0.0;
        rJacobian[29][24] = 0.0;
        rJacobian[29][25] = -(mDt * (var_x177));
        rJacobian[29][26] = 0.0;
        rJacobian[29][27] = 0.0;
        rJacobian[29][28] = -(mDt * (var_x166));
        rJacobian[29][29] = 1.0 - (mDt * (var_x171 + var_x176 + var_x188));
        rJacobian[29][30] = -(mDt * (var_x184));
        rJacobian[29][31] = 0.0;
        rJacobian[29][32] = 0.0;
        rJacobian[29][33] = 0.0;
        rJacobian[29][34] = 0.0;
        rJacobian[29][35] = 0.0;
        rJacobian[29][36] = 0.0;
        rJacobian[30][0] = 0.0;
        rJacobian[30][1] = 0.0;
        rJacobian[30][2] = 0.0;
        rJacobian[30][3] = 0.0;
        rJacobian[30][4] = 0.0;
        rJacobian[30][5] = 0.0;
        rJacobian[30][6] = 0.0;
        rJacobian[30][7] = 0.0;
        rJacobian[30][8] = 0.0;
        rJacobian[30][9] = 0.0;
        rJacobian[30][10] = 0.0;
        rJacobian[30][11] = 0.0;
        rJacobian[30][12] = 0.0;
        rJacobian[30][13] = 0.0;
        rJacobian[30][14] = 0.0;
        rJacobian[30][15] = 0.0;
        rJacobian[30][16] = 0.0;
        rJacobian[30][17] = 0.0;
        rJacobian[30][18] = 0.0;
        rJacobian[30][19] = -(mDt * (var_x164));
        rJacobian[30][20] = 0.0;
        rJacobian[30][21] = 0.0;
        rJacobian[30][22] = 0.0;
        rJacobian[30][23] = 0.0;
        rJacobian[30][24] = 0.0;
        rJacobian[30][25] = 0.0;
        rJacobian[30][26] = -(mDt * (var_x187));
        rJacobian[30][27] = 0.0;
        rJacobian[30][28] = 0.0;
        rJacobian[30][29] = -(mDt * (var_x170));
        rJacobian[30][30] = 1.0 - (mDt * (var_x185 + var_x188));
        rJacobian[30][31] = 0.0;
        rJacobian[30][32] = 0.0;
        rJacobian[30][33] = 0.0;
        rJacobian[30][34] = 0.0;
        rJacobian[30][35] = 0.0;
        rJacobian[30][36] = 0.0;
        rJacobian[31][0] = 0.0;
        rJacobian[31][1] = 0.0;
        rJacobian[31][2] = 0.0;
        rJacobian[31][3] = 0.0;
        rJacobian[31][4] = 0.0;
        rJacobian[31][5] = 0.0;
        rJacobian[31][6] = 0.0;
        rJacobian[31][7] = 0.0;
        rJacobian[31][8] = 0.0;
        rJacobian[31][9] = 0.0;
        rJacobian[31][10] = 0.0;
        rJacobian[31][11] = 0.0;
        rJacobian[31][12] = 0.0;
        rJacobian[31][13] = 0.0;
        rJacobian[31][14] = 0.0;
        rJacobian[31][15] = 0.0;
        rJacobian[31][16] = 0.0;
        rJacobian[31][17] = 0.0;
        rJacobian[31][18] = 0.0;
        rJacobian[31][19] = 0.0;
        rJacobian[31][20] = 0.0;
        rJacobian[31][21] = 0.0;
        rJacobian[31][22] = -(mDt * (0.089538000000000006));
        rJacobian[31][23] = 0.0;
        rJacobian[31][24] = 0.0;
        rJacobian[31][25] = 0.0;
        rJacobian[31][26] = 0.0;
        rJacobian[31][27] = 0.0;
        rJacobian[31][28] = 0.0;
        rJacobian[31][29] = 0.0;
        rJacobian[31][30] = 0.0;
        rJacobian[31][31] = 1.0 - (mDt * (-var_x180 - var_x189));
        rJacobian[31][32] = -(mDt * (var_x190));
        rJacobian[31][33] = 0.0;
        rJacobian[31][34] = 0.0;
        rJacobian[31][35] = 0.0;
        rJacobian[31][36] = 0.0;
        rJacobian[32][0] = 0.0;
        rJacobian[32][1] = 0.0;
        rJacobian[32][2] = 0.0;
        rJacobian[32][3] = 0.0;
        rJacobian[32][4] = 0.0;
        rJacobian[32][5] = 0.0;
        rJacobian[32][6] = 0.0;
        rJacobian[32][7] = 0.0;
        rJacobian[32][8] = 0.0;
        rJacobian[32][9] = 0.0;
        rJacobian[32][10] = 0.0;
        rJacobian[32][11] = 0.0;
        rJacobian[32][12] = 0.0;
        rJacobian[32][13] = 0.0;
        rJacobian[32][14] = 0.0;
        rJacobian[32][15] = 0.0;
        rJacobian[32][16] = 0.0;
        rJacobian[32][17] = 0.0;
        rJacobian[32][18] = 0.0;
        rJacobian[32][19] = 0.0;
        rJacobian[32][20] = 0.0;
        rJacobian[32][21] = 0.0;
        rJacobian[32][22] = 0.0;
        rJacobian[32][23] = 0.0;
        rJacobian[32][24] = 0.0;
        rJacobian[32][25] = 0.0;
        rJacobian[32][26] = 0.0;
        rJacobian[32][27] = 0.0;
        rJacobian[32][28] = 0.0;
        rJacobian[32][29] = 0.0;
        rJacobian[32][30] = 0.0;
        rJacobian[32][31] = -(mDt * (var_x189));
        rJacobian[32][32] = 1.0 - (mDt * (-var_x190));
        rJacobian[32][33] = 0.0;
        rJacobian[32][34] = 0.0;
        rJacobian[32][35] = 0.0;
        rJacobian[32][36] = 0.0;
        rJacobian[33][0] = -(mDt * (0.22869271460496704 * var_x195 * var_x210 + 6.2357214041141957e-6 * var_x195 * var_x206));
        rJacobian[33][1] = -(mDt * (-0.0123 * var_x205 * var_x207 / pow(var_chaste_interface__Ca__Ca_JSR, 2) - 115588.83089076335 * var_x196 * var_x200 * var_x201 * var_x208 / pow(var_x202, 2)));
        rJacobian[33][2] = 0.0;
        rJacobian[33][3] = 0.0;
        rJacobian[33][4] = -(mDt * (-var_x208 * var_x211 * var_x46 * var_x69 * var_x70));
        rJacobian[33][5] = -(mDt * (-4.6767910530856466e-10 * var_x206 * var_x212 - 1.7151953595372529e-5 * var_x210 * var_x212));
        rJacobian[33][6] = 0.0;
        rJacobian[33][7] = 0.0;
        rJacobian[33][8] = 0.0;
        rJacobian[33][9] = 0.0;
        rJacobian[33][10] = 0.0;
        rJacobian[33][11] = 0.0;
        rJacobian[33][12] = -(mDt * (var_x213));
        rJacobian[33][13] = 0.0;
        rJacobian[33][14] = 0.0;
        rJacobian[33][15] = -(mDt * (var_x213));
        rJacobian[33][16] = 0.0;
        rJacobian[33][17] = 0.0;
        rJacobian[33][18] = 0.0;
        rJacobian[33][19] = 0.0;
        rJacobian[33][20] = 0.0;
        rJacobian[33][21] = 0.0;
        rJacobian[33][22] = 0.0;
        rJacobian[33][23] = 0.0;
        rJacobian[33][24] = 0.0;
        rJacobian[33][25] = 0.0;
        rJacobian[33][26] = 0.0;
        rJacobian[33][27] = 0.0;
        rJacobian[33][28] = 0.0;
        rJacobian[33][29] = 0.0;
        rJacobian[33][30] = 0.0;
        rJacobian[33][31] = 0.0;
        rJacobian[33][32] = 0.0;
        rJacobian[33][33] = 1.0 - (mDt * (-var_x208));
        rJacobian[33][34] = 0.0;
        rJacobian[33][35] = 0.0;
        rJacobian[33][36] = 0.0;
        rJacobian[34][0] = 0.0;
        rJacobian[34][1] = 0.0;
        rJacobian[34][2] = 0.0;
        rJacobian[34][3] = -(mDt * (-2.774905235513489e-12 * var_x214 * var_x215 * var_x218 * var_x219 / pow(var_x216, 2)));
        rJacobian[34][4] = 0.0;
        rJacobian[34][5] = 0.0;
        rJacobian[34][6] = -(mDt * (var_x101));
        rJacobian[34][7] = 0.0;
        rJacobian[34][8] = 0.0;
        rJacobian[34][9] = 0.0;
        rJacobian[34][10] = 0.0;
        rJacobian[34][11] = 0.0;
        rJacobian[34][12] = 0.0;
        rJacobian[34][13] = 0.0;
        rJacobian[34][14] = 0.0;
        rJacobian[34][15] = 0.0;
        rJacobian[34][16] = 0.0;
        rJacobian[34][17] = 0.0;
        rJacobian[34][18] = 0.0;
        rJacobian[34][19] = 0.0;
        rJacobian[34][20] = 0.0;
        rJacobian[34][21] = 0.0;
        rJacobian[34][22] = 0.0;
        rJacobian[34][23] = 0.0;
        rJacobian[34][24] = 0.0;
        rJacobian[34][25] = 0.0;
        rJacobian[34][26] = 0.0;
        rJacobian[34][27] = 0.0;
        rJacobian[34][28] = 0.0;
        rJacobian[34][29] = 0.0;
        rJacobian[34][30] = 0.0;
        rJacobian[34][31] = -(mDt * (var_x221));
        rJacobian[34][32] = -(mDt * (var_x221));
        rJacobian[34][33] = 0.0;
        rJacobian[34][34] = 1.0 - (mDt * (var_x108 + 212.7914217252065 * var_x233 - 4.5488726691040119e-6 * var_x95 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)) - 0.0008405525584213936 * var_x224 * var_x232 + 0.00020047178518350236 * var_x232 * var_x234 * var_x235 - 3.0245559326093954e-5 * var_x224 * var_x234 * (-var_x227 * (1.0539507884845836 * var_x228 * var_x95 + 1.6494527242011876 * var_x229 * var_x95) + 6.4981759387274964 * var_x235 * var_x95 - 13.737871029257827 * var_x225 * var_x230 * var_x95 / pow(var_x226, 2)) / pow((var_x224 + 0.98039215686274506 * var_x231), 2) - 0.0016481422714144972 * var_x95 * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)) - 0.00081995078002871237 * var_x95 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm)));
        rJacobian[34][35] = -(mDt * (2.3077868741502807e-5 * var_x238 + 3.900466760223035 * var_x233 - 8.8761033621164642e-6 * var_x239));
        rJacobian[34][36] = 0.0;
        rJacobian[35][0] = 0.0;
        rJacobian[35][1] = 0.0;
        rJacobian[35][2] = 0.0;
        rJacobian[35][3] = -(mDt * (4.2607661459024858e-11 * var_x59 + 1828.5197274709456 * var_x56 - 5.784463221115469e-12 * var_x60));
        rJacobian[35][4] = 0.0;
        rJacobian[35][5] = 0.0;
        rJacobian[35][6] = -(mDt * (var_x107));
        rJacobian[35][7] = 0.0;
        rJacobian[35][8] = 0.0;
        rJacobian[35][9] = 0.0;
        rJacobian[35][10] = 0.0;
        rJacobian[35][11] = 0.0;
        rJacobian[35][12] = 0.0;
        rJacobian[35][13] = 0.0;
        rJacobian[35][14] = 0.0;
        rJacobian[35][15] = 0.0;
        rJacobian[35][16] = 0.0;
        rJacobian[35][17] = 0.0;
        rJacobian[35][18] = 0.0;
        rJacobian[35][19] = 0.0;
        rJacobian[35][20] = 0.0;
        rJacobian[35][21] = 0.0;
        rJacobian[35][22] = 0.0;
        rJacobian[35][23] = 0.0;
        rJacobian[35][24] = 0.0;
        rJacobian[35][25] = 0.0;
        rJacobian[35][26] = 0.0;
        rJacobian[35][27] = 0.0;
        rJacobian[35][28] = 0.0;
        rJacobian[35][29] = 0.0;
        rJacobian[35][30] = 0.0;
        rJacobian[35][31] = 0.0;
        rJacobian[35][32] = 0.0;
        rJacobian[35][33] = 0.0;
        rJacobian[35][34] = 0.0;
        rJacobian[35][35] = 1.0 - (mDt * (-0.14749262536873156 + var_x109 + 2.4740119415402899e-16 * var_x64 + 1.3314155043174696e-5 * var_x239 - 3.4616803112254212e-5 * var_x238 - 0.0035983988805915112 * var_x63 - 7.1319396379664657e-10 * var_x112 * var_chaste_interface__membrane__Vm / (-1.0 + var_x112) - 1.0712924764194231e-5 * var_x102 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * var_chaste_interface__INaL_hL_gate__hL - 0.0016481422714144972 * var_x102 * pow(var_chaste_interface__INa_m_gate__m, 3) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j));
        rJacobian[35][36] = -(mDt * (0.14749262536873156));
        rJacobian[36][0] = 0.0;
        rJacobian[36][1] = 0.0;
        rJacobian[36][2] = 0.0;
        rJacobian[36][3] = 0.0;
        rJacobian[36][4] = 0.0;
        rJacobian[36][5] = -(mDt * (15496.704690316265 * var_x87 + 1.4443997234609428e-9 * var_x84 - 1.960933031958144e-10 * var_x88));
        rJacobian[36][6] = 0.0;
        rJacobian[36][7] = 0.0;
        rJacobian[36][8] = 0.0;
        rJacobian[36][9] = 0.0;
        rJacobian[36][10] = 0.0;
        rJacobian[36][11] = 0.0;
        rJacobian[36][12] = 0.0;
        rJacobian[36][13] = 0.0;
        rJacobian[36][14] = 0.0;
        rJacobian[36][15] = 0.0;
        rJacobian[36][16] = 0.0;
        rJacobian[36][17] = 0.0;
        rJacobian[36][18] = 0.0;
        rJacobian[36][19] = 0.0;
        rJacobian[36][20] = 0.0;
        rJacobian[36][21] = 0.0;
        rJacobian[36][22] = 0.0;
        rJacobian[36][23] = 0.0;
        rJacobian[36][24] = 0.0;
        rJacobian[36][25] = 0.0;
        rJacobian[36][26] = 0.0;
        rJacobian[36][27] = 0.0;
        rJacobian[36][28] = 0.0;
        rJacobian[36][29] = 0.0;
        rJacobian[36][30] = 0.0;
        rJacobian[36][31] = 0.0;
        rJacobian[36][32] = 0.0;
        rJacobian[36][33] = 0.0;
        rJacobian[36][34] = 0.0;
        rJacobian[36][35] = -(mDt * (5.0));
        rJacobian[36][36] = 1.0 - (mDt * (-5.0 + 8.386900481821583e-15 * var_x92 - 0.030496430513013057 * var_x91));
    }

    void Celldecker_2009FromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        const double var_ICaL__gamma_Cai = 1.0; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICab__PCab = 1.9950840000000001e-7; // L_per_F_ms
        const double var_ICab__gamma_Ca_i = 1.0; // dimensionless
        const double var_ICab__gamma_Ca_o = 0.34100000000000003; // dimensionless
        const double var_IClb__gClb = 0.00022499999999999999; // mS_per_uF
        const double var_IKp__gKp = 0.0027599999999999999; // mS_per_uF
        const double var_IKs__OKs = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2; // dimensionless
        const double var_IKs__gKs = 0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999)); // mS_per_uF
        const double var_INaCa__KmCa_act = 0.000125; // mM
        const double var_INaCa__KmCai = 0.0035999999999999999; // mM
        const double var_INaCa__KmCao = 1.3; // mM
        const double var_INaCa__KmNai = 12.300000000000001; // mM
        const double var_INaCa__KmNao = 87.5; // mM
        const double var_INaCa__Vmax = 4.5; // uA_per_uF
        const double var_INaCa__denom_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_i, 2); // dimensionless
        const double var_INaCa__denom_ss_1 = 1.0 + pow(var_INaCa__KmCa_act, 2) / pow(var_chaste_interface__Ca__Ca_ss_sr, 2); // dimensionless
        const double var_INaCa__eta = 0.27000000000000002; // dimensionless
        const double var_INaCa__ksat = 0.32000000000000001; // dimensionless
        const double var_INaK__V_half = -92.0; // mV
        const double var_INaK__ibarnak = 1.3999999999999999; // uA_per_uF
        const double var_INaK__kmko = 1.5; // mM
        const double var_INaK__kmnai = 2.6000000000000001; // mM
        const double var_INaK__sigma = 1.0; // dimensionless
        const double var_INaL__gNaL = 0.0064999999999999997; // mS_per_uF
        const double var_INab__PNab = 3.2000000000000001e-9; // L_per_F_ms
        const double var_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_IpCa__gpCa = 0.057500000000000002; // uA_per_uF
        const double var_IpCa__IpCa = var_chaste_interface__Ca__Ca_i * var_IpCa__gpCa / (var_chaste_interface__Ca__Ca_i + var_IpCa__KmpCa); // uA_per_uF
        const double var_Ito1__gto1 = 0.4975; // mS_per_uF
        const double var_Ito2__PCl = 8.9999999999999996e-7; // L_per_F_ms
        const double var_Ito2__kCa_ito2 = 0.40000000000000002; // mM_per_ms
        const double var_Ito2__KCa_ito2 = 1.0 - 1.0 / (1.0 + pow(var_chaste_interface__Irel__Irel, 2) / pow(var_Ito2__kCa_ito2, 2)); // dimensionless
        const double var_Ito2__zCl = -1.0; // dimensionless
        const double var_INaK__PNa = pow(var_chaste_interface__Na__Na_i, 3) / pow((var_INaK__kmnai + var_chaste_interface__Na__Na_i), 3); // dimensionless
        const double var_IKp__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IKr_r_gate__r = 1 / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1__rto1 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // dimensionless
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_model_parameters__Ca_o = 1.8; // mM
        const double var_INaCa__denom_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_i + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_i / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_INaCa__denom_ss_3 = pow(var_INaCa__KmNao, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_INaCa__KmCao + pow(var_INaCa__KmNai, 3) * (1.0 + var_chaste_interface__Ca__Ca_ss_sr / var_INaCa__KmCai) * var_model_parameters__Ca_o; // mM4
        const double var_model_parameters__Cl_o = 100.0; // mM
        const double var_model_parameters__F = 96487.0; // C_per_mole
        const double var_model_parameters__K_o = 5.4000000000000004; // mM
        const double var_IK1__gK1 = 0.21516574145596759 * sqrt(var_model_parameters__K_o); // mS_per_uF
        const double var_IKr__gKr = 0.43033148291193518 * sqrt(var_model_parameters__K_o) * mParameters[2]; // mS_per_uF
        const double var_INaK__PK = var_model_parameters__K_o / (var_INaK__kmko + var_model_parameters__K_o); // dimensionless
        const double var_model_parameters__Na_o = 140.0; // mM
        const double var_INaCa__denom_4 = pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_INaCa__denom_ss_4 = pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o + pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr + pow(var_model_parameters__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_ss_sr, 3) / pow(var_INaCa__KmNai, 3)) * var_INaCa__KmCai; // mM4
        const double var_model_parameters__R = 8314.0; // J_per_kmole_K
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__ICaL_max = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICaL__gamma_Cao * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_ss_CaL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * mParameters[0] * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_ICaL__ICaL = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * var_ICaL__ICaL_max; // uA_per_uF
        const double var_ICab__ICab = 4.0 * pow(var_model_parameters__F, 2) * (-var_ICab__gamma_Ca_o * var_model_parameters__Ca_o + var_chaste_interface__Ca__Ca_i * var_ICab__gamma_Ca_i * exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICab__PCab * var_chaste_interface__membrane__Vm / ((-1.0 + exp(2.0 * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_INaCa__denom_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__denom_ss_2 = 1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)); // dimensionless
        const double var_INaCa__num = 0.80000000000000004 * (pow(var_chaste_interface__Na__Na_i, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_i * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa = var_INaCa__num / ((var_INaCa__denom_3 + var_INaCa__denom_4) * var_INaCa__denom_1 * var_INaCa__denom_2); // uA_per_uF
        const double var_INaCa__num_ss = 0.20000000000000001 * (pow(var_chaste_interface__Na__Na_ss_sr, 3) * var_model_parameters__Ca_o * exp(var_INaCa__eta * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(var_model_parameters__Na_o, 3) * var_chaste_interface__Ca__Ca_ss_sr * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_INaCa__Vmax; // mM4_uA_per_uF
        const double var_INaCa__INaCa_ss_sr = var_INaCa__num_ss / ((var_INaCa__denom_ss_3 + var_INaCa__denom_ss_4) * var_INaCa__denom_ss_1 * var_INaCa__denom_ss_2); // uA_per_uF
        const double var_INaK__phi = (-var_INaK__V_half + var_chaste_interface__membrane__Vm) * var_INaK__sigma * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INaK__fv = 1 / (1.0 + exp(-var_INaK__phi)); // dimensionless
        const double var_INaK__INaK = var_INaK__PK * var_INaK__PNa * var_INaK__fv * var_INaK__ibarnak; // uA_per_uF
        const double var_INab__phi = var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T); // dimensionless
        const double var_INab__INab = (-var_model_parameters__Na_o + var_chaste_interface__Na__Na_i * exp(var_INab__phi)) * var_INab__PNab * var_INab__phi * var_model_parameters__F / (-1.0 + exp(var_INab__phi)); // uA_per_uF
        const double var_Ito2__Ito2_max = pow(var_Ito2__zCl, 2) * pow(var_model_parameters__F, 2) * (-var_model_parameters__Cl_o * exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + var_chaste_interface__Cl__Cl_i) * var_Ito2__PCl * var_chaste_interface__membrane__Vm / ((1.0 - exp(var_chaste_interface__membrane__Vm * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_model_parameters__R * var_model_parameters__T); // uA_per_uF
        const double var_Ito2__Ito2 = var_Ito2__Ito2_max * var_Ito2__KCa_ito2 * var_chaste_interface__Ito2_i2f_gate__i2f; // uA_per_uF
        const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + var_ICaL__ICaL + var_ICab__ICab + var_IpCa__IpCa; // uA_per_uF
        const double var_reversal_potentials__ECl = -var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cl_o / var_chaste_interface__Cl__Cl_i) / var_model_parameters__F; // mV
        const double var_IClb__IClb = (-var_reversal_potentials__ECl + var_chaste_interface__membrane__Vm) * var_IClb__gClb; // uA_per_uF
        const double var_membrane__clont = var_IClb__IClb + var_Ito2__Ito2; // uA_per_uF
        const double var_reversal_potentials__EK = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__K_o / var_chaste_interface__K__K_i) / var_model_parameters__F; // mV
        const double var_IK1_K1_gate__alpha_k1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)); // dimensionless
        const double var_IK1_K1_gate__beta_k1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_IK1_K1_gate__K1 = var_IK1_K1_gate__alpha_k1 / (var_IK1_K1_gate__alpha_k1 + var_IK1_K1_gate__beta_k1); // dimensionless
        const double var_IK1__IK1 = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IK1__gK1 * var_IK1_K1_gate__K1; // uA_per_uF
        const double var_IKp__IKp = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKp__Kp * var_IKp__gKp; // uA_per_uF
        const double var_IKr__IKr = (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_IKr__gKr * var_IKr_r_gate__r * var_chaste_interface__IKr_xr_gate__xr; // uA_per_uF
        const double var_Ito1__Ito1 = pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_Ito1__gto1 * var_Ito1__rto1 * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s; // uA_per_uF
        const double var_reversal_potentials__ENa = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Na_o / var_chaste_interface__Na__Na_i) / var_model_parameters__F; // mV
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_INaL__gNaL * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab; // uA_per_uF
        const double var_reversal_potentials__prnak = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__EKs = var_model_parameters__R * var_model_parameters__T * log((var_model_parameters__Na_o * var_reversal_potentials__prnak + var_model_parameters__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prnak + var_chaste_interface__K__K_i)) / var_model_parameters__F; // mV
        const double var_IKs__IKs = (-var_reversal_potentials__EKs + var_chaste_interface__membrane__Vm) * var_IKs__OKs * var_IKs__gKs; // uA_per_uF
        const double var_membrane__kiont = -2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim; // uA_per_uF
        const double d_dt_chaste_interface_var_membrane__Vm = -var_membrane__caiont - var_membrane__clont - var_membrane__kiont - var_membrane__naiont; // mV / ms
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__Vm;
    }
    
    void Celldecker_2009FromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        
        const double var_INaL_hL_gate__tau_hL = 600.0;
        const double var_Ito2_i2f_gate__tau_i2f = 8.0;
        const double var_IKr_xr_gate__tau_xr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__membrane__Vm) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__membrane__Vm) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm)));
        const double var_IKr_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm));
        const double var_INaL_hL_gate__hL_infinity = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm));
        const double var_INaL_mL_gate__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_INaL_mL_gate__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm);
        const double var_INa_h_gate__ah = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm)));
        const double var_INa_h_gate__bh = ((var_chaste_interface__membrane__Vm >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__Vm) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__Vm)));
        const double var_INa_j_gate__aj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__membrane__Vm) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__Vm) - 6.9480000000000006e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm))));
        const double var_INa_j_gate__bj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__Vm))) : (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm))));
        const double var_INa_m_gate__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_INa_m_gate__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm);
        const double var_Ito1_a_gate__a_infinity = 1 / (1.0 + exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_a_gate__alpha_a = 0.82719827942757873 / (1.0 + exp(0.62658348478969694 - 0.034035137876343539 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_a_gate__beta_a = 3.5 / (1.0 + exp(3.403513787634354 + 0.034035137876343539 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_a_gate__tau_a = 1 / (var_Ito1_a_gate__alpha_a + var_Ito1_a_gate__beta_a);
        const double var_Ito1_i1f_gate__alpha_i1f = 0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_i1f_gate__beta_i1f = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_i1s_gate__alpha_i1s = 0.0040000000000000001 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_Ito1_i1s_gate__beta_i1s = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm));
        const double var_Ito2_i2f_gate__alpha_i2f = 0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm));
        const double var_Ito2_i2f_gate__beta_i2f = 0.20000000000000001 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm));
        const double var_Ito2_i2f_gate__i2f_infinity = var_Ito2_i2f_gate__alpha_i2f / (var_Ito2_i2f_gate__alpha_i2f + var_Ito2_i2f_gate__beta_i2f);
        
        
        rY[32] = (var_chaste_interface__IKr_xr_gate__xr + ((var_IKr_xr_gate__xr_infinity / var_IKr_xr_gate__tau_xr) * mDt)) / (1.0 - ((-1 / var_IKr_xr_gate__tau_xr) * mDt));
        rY[31] = (var_chaste_interface__INaL_hL_gate__hL + ((var_INaL_hL_gate__hL_infinity / var_INaL_hL_gate__tau_hL) * mDt)) / (1.0 - ((-1 / var_INaL_hL_gate__tau_hL) * mDt));
        rY[30] = (var_chaste_interface__INaL_mL_gate__mL + ((var_INaL_mL_gate__amL) * mDt)) / (1.0 - ((-var_INaL_mL_gate__amL - var_INaL_mL_gate__bmL) * mDt));
        rY[28] = (var_chaste_interface__INa_h_gate__h + ((var_INa_h_gate__ah) * mDt)) / (1.0 - ((-var_INa_h_gate__ah - var_INa_h_gate__bh) * mDt));
        rY[29] = (var_chaste_interface__INa_j_gate__j + ((var_INa_j_gate__aj) * mDt)) / (1.0 - ((-var_INa_j_gate__aj - var_INa_j_gate__bj) * mDt));
        rY[27] = (var_chaste_interface__INa_m_gate__m + ((var_INa_m_gate__am) * mDt)) / (1.0 - ((-var_INa_m_gate__am - var_INa_m_gate__bm) * mDt));
        rY[33] = (var_chaste_interface__Ito1_a_gate__a + ((var_Ito1_a_gate__a_infinity / var_Ito1_a_gate__tau_a) * mDt)) / (1.0 - ((-1 / var_Ito1_a_gate__tau_a) * mDt));
        rY[34] = (var_chaste_interface__Ito1_i1f_gate__i1f + ((var_Ito1_i1f_gate__alpha_i1f) * mDt)) / (1.0 - ((-var_Ito1_i1f_gate__alpha_i1f - var_Ito1_i1f_gate__beta_i1f) * mDt));
        rY[35] = (var_chaste_interface__Ito1_i1s_gate__i1s + ((var_Ito1_i1s_gate__alpha_i1s) * mDt)) / (1.0 - ((-var_Ito1_i1s_gate__alpha_i1s - var_Ito1_i1s_gate__beta_i1s) * mDt));
        rY[36] = (var_chaste_interface__Ito2_i2f_gate__i2f + ((var_Ito2_i2f_gate__i2f_infinity / var_Ito2_i2f_gate__tau_i2f) * mDt)) / (1.0 - ((-1 / var_Ito2_i2f_gate__tau_i2f) * mDt));
        
        double _guess[37] = {rY[47],rY[38],rY[39],rY[1],rY[41],rY[40],rY[44],rY[45],rY[19],rY[23],rY[25],rY[21],rY[20],rY[24],rY[26],rY[22],rY[2],rY[11],rY[12],rY[13],rY[14],rY[15],rY[16],rY[3],rY[4],rY[5],rY[6],rY[7],rY[8],rY[9],rY[10],rY[17],rY[18],rY[37],rY[46],rY[42],rY[43]};
        CardiacNewtonSolver<37,Celldecker_2009FromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<37,Celldecker_2009FromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[47] = _guess[0];
        rY[38] = _guess[1];
        rY[39] = _guess[2];
        rY[1] = _guess[3];
        rY[41] = _guess[4];
        rY[40] = _guess[5];
        rY[44] = _guess[6];
        rY[45] = _guess[7];
        rY[19] = _guess[8];
        rY[23] = _guess[9];
        rY[25] = _guess[10];
        rY[21] = _guess[11];
        rY[20] = _guess[12];
        rY[24] = _guess[13];
        rY[26] = _guess[14];
        rY[22] = _guess[15];
        rY[2] = _guess[16];
        rY[11] = _guess[17];
        rY[12] = _guess[18];
        rY[13] = _guess[19];
        rY[14] = _guess[20];
        rY[15] = _guess[21];
        rY[16] = _guess[22];
        rY[3] = _guess[23];
        rY[4] = _guess[24];
        rY[5] = _guess[25];
        rY[6] = _guess[26];
        rY[7] = _guess[27];
        rY[8] = _guess[28];
        rY[9] = _guess[29];
        rY[10] = _guess[30];
        rY[17] = _guess[31];
        rY[18] = _guess[32];
        rY[37] = _guess[33];
        rY[46] = _guess[34];
        rY[42] = _guess[35];
        rY[43] = _guess[36];
    }

    std::vector<double> Celldecker_2009FromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldecker_2009FromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "decker_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.472528);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(7.09945e-05);

    // rY[2]:
    this->mVariableNames.push_back("IKs__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.476653873938053);

    // rY[3]:
    this->mVariableNames.push_back("IKs__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2551771850026437);

    // rY[4]:
    this->mVariableNames.push_back("IKs__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05122852186842027);

    // rY[5]:
    this->mVariableNames.push_back("IKs__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004570874421666423);

    // rY[6]:
    this->mVariableNames.push_back("IKs__C5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001529389211563687);

    // rY[7]:
    this->mVariableNames.push_back("IKs__C6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1328281770413747);

    // rY[8]:
    this->mVariableNames.push_back("IKs__C7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05333228495514583);

    // rY[9]:
    this->mVariableNames.push_back("IKs__C8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007137874613383642);

    // rY[10]:
    this->mVariableNames.push_back("IKs__C9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0003184390970637536);

    // rY[11]:
    this->mVariableNames.push_back("IKs__C10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01388061042363991);

    // rY[12]:
    this->mVariableNames.push_back("IKs__C11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003715500164470033);

    // rY[13]:
    this->mVariableNames.push_back("IKs__C12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002486371465457659);

    // rY[14]:
    this->mVariableNames.push_back("IKs__C13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006446803014431032);

    // rY[15]:
    this->mVariableNames.push_back("IKs__C14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.628258026770862e-05);

    // rY[16]:
    this->mVariableNames.push_back("IKs__C15");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.122823524761588e-05);

    // rY[17]:
    this->mVariableNames.push_back("IKs__O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.051906959485266e-05);

    // rY[18]:
    this->mVariableNames.push_back("IKs__O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.372219883411999e-06);

    // rY[19]:
    this->mVariableNames.push_back("ICaL__C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999613782488198);

    // rY[20]:
    this->mVariableNames.push_back("ICaL__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.27419494597377e-05);

    // rY[21]:
    this->mVariableNames.push_back("ICaL__C_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.936477396599124e-11);

    // rY[22]:
    this->mVariableNames.push_back("ICaL__O_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.350122566369778e-15);

    // rY[23]:
    this->mVariableNames.push_back("ICaL__CI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.587938121237188e-05);

    // rY[24]:
    this->mVariableNames.push_back("ICaL__OI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.611420243201921e-10);

    // rY[25]:
    this->mVariableNames.push_back("ICaL__CI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[26]:
    this->mVariableNames.push_back("ICaL__OI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[27]:
    this->mVariableNames.push_back("INa_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[28]:
    this->mVariableNames.push_back("INa_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913109066867);

    // rY[29]:
    this->mVariableNames.push_back("INa_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9970771239754529);

    // rY[30]:
    this->mVariableNames.push_back("INaL_mL_gate__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[31]:
    this->mVariableNames.push_back("INaL_hL_gate__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3593255076983574);

    // rY[32]:
    this->mVariableNames.push_back("IKr_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.235996442041028e-08);

    // rY[33]:
    this->mVariableNames.push_back("Ito1_a_gate__a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.773318268499115e-05);

    // rY[34]:
    this->mVariableNames.push_back("Ito1_i1f_gate__i1f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9979722);

    // rY[35]:
    this->mVariableNames.push_back("Ito1_i1s_gate__i1s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9874435);

    // rY[36]:
    this->mVariableNames.push_back("Ito2_i2f_gate__i2f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9960352);

    // rY[37]:
    this->mVariableNames.push_back("Irel__Irel");
    this->mVariableUnits.push_back("mM_per_ms");
    this->mInitialConditions.push_back(0.00107332);

    // rY[38]:
    this->mVariableNames.push_back("Ca__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.917692717);

    // rY[39]:
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.929835335);

    // rY[40]:
    this->mVariableNames.push_back("Ca__Ca_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.04757e-05);

    // rY[41]:
    this->mVariableNames.push_back("Ca__Ca_ss_CaL");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.61545e-05);

    // rY[42]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935575);

    // rY[43]:
    this->mVariableNames.push_back("Na__Na_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935607);

    // rY[44]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[45]:
    this->mVariableNames.push_back("Cl__Cl_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[46]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(145.5689);

    // rY[47]:
    this->mVariableNames.push_back("CaMK_active__CaMK_trap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018861341);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("L_per_F_ms");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldecker_2009FromCellMLBackwardEuler)
