//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: bondarenko_model_2004_apex
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "bondarenko_model_2004_apex.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"
#include "CardiacNewtonSolver.hpp"

    boost::shared_ptr<RegularStimulus> Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // millisecond
        const double var_chaste_interface__membrane__stim_period = 71.430000000000007; // millisecond
        const double var_chaste_interface__membrane__stim_start = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::Cellbondarenko_model_2004_apexFromCellMLBackwardEuler(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractBackwardEulerCardiacCell<32>(
                41,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLBackwardEuler>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::~Cellbondarenko_model_2004_apexFromCellMLBackwardEuler()
    {
    }
    
    double Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
        const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
        const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_calcium_current__i_CaL + var_calcium_activated_chloride_current__i_ClCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa + var_fast_sodium_current__i_Na + var_fast_transient_outward_potassium_current__i_Kto_f + var_non_inactivating_steady_state_potassium_current__i_Kss + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_slow_transient_outward_potassium_current__i_Kto_s + var_sodium_background_current__i_Nab + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_time_independent_potassium_current__i_K1 + var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::ComputeResidual(double var_chaste_interface__environment__time, const double rCurrentGuess[32], double rResidual[32])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        
        //output_nonlinear_state_assignments
        double var_chaste_interface__L_type_calcium_current__C2 = rCurrentGuess[0];
        double var_chaste_interface__L_type_calcium_current__C3 = rCurrentGuess[1];
        double var_chaste_interface__L_type_calcium_current__C4 = rCurrentGuess[2];
        double var_chaste_interface__L_type_calcium_current__I1 = rCurrentGuess[3];
        double var_chaste_interface__L_type_calcium_current__I2 = rCurrentGuess[4];
        double var_chaste_interface__L_type_calcium_current__I3 = rCurrentGuess[5];
        double var_chaste_interface__L_type_calcium_current__O = rCurrentGuess[6];
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rCurrentGuess[7];
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rCurrentGuess[8];
        double var_chaste_interface__calcium_concentration__CaJSR = rCurrentGuess[9];
        double var_chaste_interface__calcium_concentration__CaNSR = rCurrentGuess[10];
        double var_chaste_interface__calcium_concentration__Cai = rCurrentGuess[11];
        double var_chaste_interface__calcium_concentration__Cass = rCurrentGuess[12];
        double var_chaste_interface__calcium_fluxes__P_RyR = rCurrentGuess[13];
        double var_chaste_interface__fast_sodium_current__C_Na1 = rCurrentGuess[14];
        double var_chaste_interface__fast_sodium_current__C_Na2 = rCurrentGuess[15];
        double var_chaste_interface__fast_sodium_current__I1_Na = rCurrentGuess[16];
        double var_chaste_interface__fast_sodium_current__I2_Na = rCurrentGuess[17];
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rCurrentGuess[18];
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rCurrentGuess[19];
        double var_chaste_interface__fast_sodium_current__IF_Na = rCurrentGuess[20];
        double var_chaste_interface__fast_sodium_current__O_Na = rCurrentGuess[21];
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rCurrentGuess[22];
        double var_chaste_interface__potassium_concentration__Ki = rCurrentGuess[23];
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rCurrentGuess[24];
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rCurrentGuess[25];
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rCurrentGuess[26];
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rCurrentGuess[27];
        double var_chaste_interface__ryanodine_receptors__P_C2 = rCurrentGuess[28];
        double var_chaste_interface__ryanodine_receptors__P_O1 = rCurrentGuess[29];
        double var_chaste_interface__ryanodine_receptors__P_O2 = rCurrentGuess[30];
        double var_chaste_interface__sodium_concentration__Nai = rCurrentGuess[31];
        
        //output_equations
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__Kpc_half = 20.0; // micromolar
        const double var_L_type_calcium_current__Kpc_max = 0.23324; // per_millisecond
        const double var_L_type_calcium_current__Kpcb = 0.00050000000000000001; // per_millisecond
        const double var_L_type_calcium_current__C1 = 1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2; // dimensionless
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_L_type_calcium_current__i_CaL_max = 7.0; // picoA_per_picoF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_buffering__HTRPN_tot = 140.0; // micromolar
        const double var_calcium_buffering__LTRPN_tot = 70.0; // micromolar
        const double var_calcium_concentration__CMDN_tot = 50.0; // micromolar
        const double var_calcium_concentration__CSQN_tot = 15000.0; // micromolar
        const double var_L_type_calcium_current__gamma = var_L_type_calcium_current__Kpc_max * var_chaste_interface__calcium_concentration__Cass / (var_L_type_calcium_current__Kpc_half + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_calcium_concentration__Km_CMDN = 0.23799999999999999; // micromolar
        const double var_calcium_concentration__Bi = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cai + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Bss = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cass + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Km_CSQN = 800.0; // micromolar
        const double var_calcium_concentration__BJSR = 1 / (1.0 + var_calcium_concentration__CSQN_tot * var_calcium_concentration__Km_CSQN / pow((var_chaste_interface__calcium_concentration__CaJSR + var_calcium_concentration__Km_CSQN), 2)); // dimensionless
        const double var_calcium_fluxes__Km_up = 0.5; // micromolar
        const double var_calcium_fluxes__k_minus_htrpn = 3.1999999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__k_minus_ltrpn = 0.019599999999999999; // per_millisecond
        const double var_calcium_fluxes__k_plus_htrpn = 0.0023700000000000001; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn; // micromolar / millisecond
        const double var_calcium_fluxes__k_plus_ltrpn = 0.0327; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar / millisecond
        const double var_calcium_fluxes__J_trpn = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn - var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_tr = 20.0; // millisecond
        const double var_calcium_fluxes__J_tr = (-var_chaste_interface__calcium_concentration__CaJSR + var_chaste_interface__calcium_concentration__CaNSR) / var_calcium_fluxes__tau_tr; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_xfer = 8.0; // millisecond
        const double var_calcium_fluxes__J_xfer = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__Cass) / var_calcium_fluxes__tau_xfer; // micromolar_per_millisecond
        const double var_calcium_fluxes__v1 = 4.5; // per_millisecond
        const double var_calcium_fluxes__v2 = 1.7399999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__J_leak = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__CaNSR) * var_calcium_fluxes__v2; // micromolar_per_millisecond
        const double var_calcium_fluxes__v3 = 0.45000000000000001; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_fluxes__v3 / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_fluxes__Km_up, 2)); // micromolar_per_millisecond
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Acap = 0.00015339999999999999; // cm2
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__Cm = 1.0; // microF_per_cm2
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = -var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__beta + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta + 4.0 * var_L_type_calcium_current__C1 * var_L_type_calcium_current__alpha - 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha + 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = -var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha + 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta + 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta - 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf + 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta + 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta - 1.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf + 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma - 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O + 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta - 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O; // 1 / millisecond
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.10000000000000001 * var_L_type_calcium_current__i_CaL * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)) / var_L_type_calcium_current__i_CaL_max; // 1 / millisecond
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 + var_fast_sodium_current__C_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = var_fast_sodium_current__C_Na3 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na3; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5; // 1 / millisecond
        const double var_membrane__VJSR = 1.1999999999999999e-7; // microlitre
        const double var_membrane__VNSR = 2.0980000000000001e-6; // microlitre
        const double var_membrane__Vmyo = 2.584e-5; // microlitre
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = (-var_calcium_fluxes__J_leak + var_calcium_fluxes__J_up) * var_membrane__Vmyo / var_membrane__VNSR - var_calcium_fluxes__J_tr * var_membrane__VJSR / var_membrane__VNSR; // micromolar / millisecond
        const double var_membrane__Vss = 1.4849999999999999e-9; // microlitre
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__C_K0 = 1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a0 = 0.022348 * exp(0.01176 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a0 = 0.047002000000000002 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1; // 1 / millisecond
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__kb = 0.036777999999999998; // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__kf = 0.023761000000000001; // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = var_rapid_delayed_rectifier_potassium_current__C_K0 * var_rapid_delayed_rectifier_potassium_current__alpha_a0 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__beta_a0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf + var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb; // 1 / millisecond
        const double var_calcium_fluxes__J_rel = (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR * var_calcium_fluxes__v1; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (-var_calcium_fluxes__J_rel + var_calcium_fluxes__J_tr) * var_calcium_concentration__BJSR; // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (var_calcium_fluxes__J_rel * var_membrane__VJSR / var_membrane__Vss - var_calcium_fluxes__J_xfer * var_membrane__Vmyo / var_membrane__Vss - 0.5 * var_L_type_calcium_current__i_CaL * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vss)) * var_calcium_concentration__Bss; // micromolar / millisecond
        const double var_ryanodine_receptors__P_C1 = 1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2; // dimensionless
        const double var_ryanodine_receptors__k_minus_a = 0.071249999999999994; // per_millisecond
        const double var_ryanodine_receptors__k_minus_b = 0.96499999999999997; // per_millisecond
        const double var_ryanodine_receptors__k_minus_c = 0.00080000000000000004; // per_millisecond
        const double var_ryanodine_receptors__k_plus_a = 0.0060749999999999997; // micromolar4_per_millisecond
        const double var_ryanodine_receptors__k_plus_b = 0.0040499999999999998; // micromolar3_per_millisecond
        const double var_ryanodine_receptors__k_plus_c = 0.0089999999999999993; // per_millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c - var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c; // 1 / millisecond
        const double var_ryanodine_receptors__m = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_ryanodine_receptors__n = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c + var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_minus_a - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__n) * var_ryanodine_receptors__P_C1 * var_ryanodine_receptors__k_plus_a - pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (-var_calcium_fluxes__J_trpn - var_calcium_fluxes__J_up - 0.5 * (-2.0 * var_sodium_calcium_exchange_current__i_NaCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo) + var_calcium_fluxes__J_leak + var_calcium_fluxes__J_xfer) * var_calcium_concentration__Bi; // micromolar / millisecond
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = (-var_fast_sodium_current__i_Na - var_sodium_background_current__i_Nab - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = (-var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur + 2.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        
        rResidual[11] = rCurrentGuess[11] - rY[1] - mDt*d_dt_chaste_interface_var_calcium_concentration__Cai;
        rResidual[12] = rCurrentGuess[12] - rY[2] - mDt*d_dt_chaste_interface_var_calcium_concentration__Cass;
        rResidual[9] = rCurrentGuess[9] - rY[3] - mDt*d_dt_chaste_interface_var_calcium_concentration__CaJSR;
        rResidual[10] = rCurrentGuess[10] - rY[4] - mDt*d_dt_chaste_interface_var_calcium_concentration__CaNSR;
        rResidual[13] = rCurrentGuess[13] - rY[5] - mDt*d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
        rResidual[8] = rCurrentGuess[8] - rY[6] - mDt*d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
        rResidual[7] = rCurrentGuess[7] - rY[7] - mDt*d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
        rResidual[29] = rCurrentGuess[29] - rY[8] - mDt*d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
        rResidual[30] = rCurrentGuess[30] - rY[9] - mDt*d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
        rResidual[28] = rCurrentGuess[28] - rY[10] - mDt*d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
        rResidual[6] = rCurrentGuess[6] - rY[11] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__O;
        rResidual[0] = rCurrentGuess[0] - rY[12] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__C2;
        rResidual[1] = rCurrentGuess[1] - rY[13] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__C3;
        rResidual[2] = rCurrentGuess[2] - rY[14] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__C4;
        rResidual[3] = rCurrentGuess[3] - rY[15] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__I1;
        rResidual[4] = rCurrentGuess[4] - rY[16] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__I2;
        rResidual[5] = rCurrentGuess[5] - rY[17] - mDt*d_dt_chaste_interface_var_L_type_calcium_current__I3;
        rResidual[31] = rCurrentGuess[31] - rY[18] - mDt*d_dt_chaste_interface_var_sodium_concentration__Nai;
        rResidual[21] = rCurrentGuess[21] - rY[19] - mDt*d_dt_chaste_interface_var_fast_sodium_current__O_Na;
        rResidual[14] = rCurrentGuess[14] - rY[20] - mDt*d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
        rResidual[15] = rCurrentGuess[15] - rY[21] - mDt*d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
        rResidual[16] = rCurrentGuess[16] - rY[22] - mDt*d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
        rResidual[17] = rCurrentGuess[17] - rY[23] - mDt*d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
        rResidual[20] = rCurrentGuess[20] - rY[24] - mDt*d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
        rResidual[18] = rCurrentGuess[18] - rY[25] - mDt*d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
        rResidual[19] = rCurrentGuess[19] - rY[26] - mDt*d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
        rResidual[23] = rCurrentGuess[23] - rY[27] - mDt*d_dt_chaste_interface_var_potassium_concentration__Ki;
        rResidual[22] = rCurrentGuess[22] - rY[36] - mDt*d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
        rResidual[27] = rCurrentGuess[27] - rY[37] - mDt*d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
        rResidual[24] = rCurrentGuess[24] - rY[38] - mDt*d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
        rResidual[25] = rCurrentGuess[25] - rY[39] - mDt*d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
        rResidual[26] = rCurrentGuess[26] - rY[40] - mDt*d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;
    }

    void Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::ComputeJacobian(double var_chaste_interface__environment__time, const double rCurrentGuess[32], double rJacobian[32][32])
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        
        double var_chaste_interface__L_type_calcium_current__C4 = rCurrentGuess[2];
        double var_chaste_interface__L_type_calcium_current__I2 = rCurrentGuess[4];
        double var_chaste_interface__L_type_calcium_current__O = rCurrentGuess[6];
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rCurrentGuess[7];
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rCurrentGuess[8];
        double var_chaste_interface__calcium_concentration__CaJSR = rCurrentGuess[9];
        double var_chaste_interface__calcium_concentration__CaNSR = rCurrentGuess[10];
        double var_chaste_interface__calcium_concentration__Cai = rCurrentGuess[11];
        double var_chaste_interface__calcium_concentration__Cass = rCurrentGuess[12];
        double var_chaste_interface__calcium_fluxes__P_RyR = rCurrentGuess[13];
        double var_chaste_interface__fast_sodium_current__O_Na = rCurrentGuess[21];
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rCurrentGuess[22];
        double var_chaste_interface__potassium_concentration__Ki = rCurrentGuess[23];
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rCurrentGuess[27];
        double var_chaste_interface__ryanodine_receptors__P_C2 = rCurrentGuess[28];
        double var_chaste_interface__ryanodine_receptors__P_O1 = rCurrentGuess[29];
        double var_chaste_interface__ryanodine_receptors__P_O2 = rCurrentGuess[30];
        double var_chaste_interface__sodium_concentration__Nai = rCurrentGuess[31];
        
        const double var_x0 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x1 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
        const double var_x2 = var_x1 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) / (1.0 + 0.12 * var_x1);
        const double var_x3 = 0.10000000000000001 * var_x0;
        const double var_x4 = -1.6000000000000001 * var_x2;
        const double var_x5 = 0.80000000000000004 * var_x2;
        const double var_x6 = 0.15000000000000002 * var_x0;
        const double var_x7 = exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2));
        const double var_x8 = 0.026000000000000002 * var_x7;
        const double var_x9 = 13.0 - 13.0 * var_x7;
        const double var_x10 = 1 / (20.0 + var_chaste_interface__calcium_concentration__Cass);
        const double var_x11 = 0.23324 * var_x10;
        const double var_x12 = var_x11 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x13 = var_x12 * var_x9;
        const double var_x14 = 0.40000000000000002 * var_x2;
        const double var_x15 = 0.00093296000000000004 * var_x10 * var_x2;
        const double var_x16 = var_x15 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x17 = 0.00040000000000000002 * var_x0;
        const double var_x18 = 0.0001 * var_x0;
        const double var_x19 = 0.20000000000000001 * var_x0;
        const double var_x20 = var_x9 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x21 = var_x11 * var_x20;
        const double var_x22 = var_chaste_interface__calcium_concentration__Cass / pow((1 + 0.050000000000000003 * var_chaste_interface__calcium_concentration__Cass), 2);
        const double var_x23 = 0.00058310000000000002 * var_x22;
        const double var_x24 = var_x20 * var_x23;
        const double var_x25 = var_x15 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x26 = 2.3324000000000003e-6 * var_x2 * var_x22 * var_chaste_interface__L_type_calcium_current__C4;
        const double var_x27 = 0.013000000000000001 * var_x7;
        const double var_x28 = 0.00040000000000000002 * var_x2;
        const double var_x29 = var_x11 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x30 = var_x23 * var_chaste_interface__L_type_calcium_current__O;
        const double var_x31 = -var_x12;
        const double var_x32 = -var_x28;
        const double var_x33 = 0.013000000000000001 - var_x27;
        const double var_x34 = var_x11 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x35 = var_x23 * var_chaste_interface__L_type_calcium_current__I2;
        const double var_x36 = 0.0023700000000000001 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x37 = 0.0023700000000000001 * var_chaste_interface__calcium_buffering__HTRPN_Ca;
        const double var_x38 = 0.0327 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x39 = 0.0327 * var_chaste_interface__calcium_buffering__LTRPN_Ca;
        const double var_x40 = 1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR;
        const double var_x41 = pow(var_x40, (-2));
        const double var_x42 = 1 / (1.0 + 18.75 * var_x41);
        const double var_x43 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x44 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x45 = var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x46 = var_x45 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x47 = var_x42 * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x48 = 4.5 * var_chaste_interface__calcium_concentration__Cass - 4.5 * var_chaste_interface__calcium_concentration__CaJSR;
        const double var_x49 = var_x47 * var_x48;
        const double var_x50 = pow(var_chaste_interface__calcium_concentration__Cai, 2);
        const double var_x51 = 0.25 + var_x50;
        const double var_x52 = 1 / var_x51;
        const double var_x53 = var_x52 * var_chaste_interface__calcium_concentration__Cai;
        const double var_x54 = pow(var_chaste_interface__calcium_concentration__Cai, 3) / pow(var_x51, 2);
        const double var_x55 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai;
        const double var_x56 = pow(var_x55, (-2));
        const double var_x57 = 1 / (1.0 + 11.899999999999999 * var_x56);
        const double var_x58 = 1 / var_chaste_interface__calcium_concentration__Cai;
        const double var_x59 = exp(-0.025317124991725771 * var_chaste_interface__membrane__V);
        const double var_x60 = 1 / (1.0 + 0.10000000000000001 * var_x59);
        const double var_x61 = var_x59 * var_x60;
        const double var_x62 = exp(0.013632298072467722 * var_chaste_interface__membrane__V);
        const double var_x63 = var_x60 * var_x62 * pow(var_chaste_interface__sodium_concentration__Nai, 2);
        const double var_x64 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass;
        const double var_x65 = pow(var_x64, (-2));
        const double var_x66 = 1 / (1.0 + 11.899999999999999 * var_x65);
        const double var_x67 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x68 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O2;
        const double var_x69 = var_x66 * var_chaste_interface__calcium_fluxes__P_RyR;
        const double var_x70 = 363.63636363636363 * var_chaste_interface__calcium_concentration__CaJSR - 363.63636363636363 * var_chaste_interface__calcium_concentration__Cass;
        const double var_x71 = var_x69 * var_x70;
        const double var_x72 = -0.04926108374384236 * var_chaste_interface__membrane__V;
        const double var_x73 = 0.20000000000000001 * exp(0.12315270935960591 + var_x72);
        const double var_x74 = -var_x73;
        const double var_x75 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
        const double var_x76 = 1 / (0.25 * var_x75 + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V));
        const double var_x77 = 3.802 * var_x76;
        const double var_x78 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
        const double var_x79 = -0.008539999999999999 - var_x78;
        const double var_x80 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * var_x75);
        const double var_x81 = exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V);
        const double var_x82 = 6.9999999999999997e-7 * var_x81;
        const double var_x83 = exp(0.36945812807881773 + var_x72);
        const double var_x84 = 0.22 * var_x83;
        const double var_x85 = 3.802 / (0.20000000000000001 * var_x75 + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V));
        const double var_x86 = -var_x85;
        const double var_x87 = 0.19170000000000001 * exp(-0.12315270935960591 + var_x72);
        const double var_x88 = -var_x80 - var_x87;
        const double var_x89 = var_x79 + var_x86;
        const double var_x90 = -var_x82;
        const double var_x91 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V));
        const double var_x92 = 1.0526315789473684e-5 * var_x91;
        const double var_x93 = 1.4e-8 * var_x81;
        const double var_x94 = 0.001 * var_x91;
        const double var_x95 = 0.008539999999999999 + var_x78;
        const double var_x96 = 1.2097272727272726e-5 * var_x76 * var_x81 * var_x91 / (var_x83 * var_x95);
        const double var_x97 = var_x91;
        const double var_x98 = 1 / var_chaste_interface__potassium_concentration__Ki;
        const double var_x99 = log(5400.0 * var_x98);
        const double var_x100 = exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * var_x99);
        const double var_x101 = 1.0 + var_x100;
        const double var_x102 = var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai;
        const double var_x103 = (2.4715768660405338e-6 * var_chaste_interface__sodium_concentration__Nai + 0.00012110726643598615 * var_chaste_interface__potassium_concentration__Ki) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K / pow(var_x102, 2);
        const double var_x104 = 1 / var_chaste_interface__sodium_concentration__Nai;
        const double var_x105 = pow(var_x104, 1.5);
        const double var_x106 = var_x104 * var_x105 / (pow((3.2860264730588296e-7 + var_x105), 2) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V)));
        const double var_x107 = -0.022348 * exp(0.01176 * var_chaste_interface__membrane__V);
        const double var_x108 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V);
        const double var_x109 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V);
        const double var_x110 = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V);
        const double var_x111 = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V);
        const double var_x112 = pow(var_chaste_interface__calcium_concentration__Cass, 3.0);
        const double var_x113 = 0.012149999999999999 * pow(var_chaste_interface__calcium_concentration__Cass, 2.0) * var_chaste_interface__ryanodine_receptors__P_O1;
        const double var_x114 = -0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0);
        const double var_x115 = 0.0040499999999999998 * var_x112;
        const double var_x116 = var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki;
        const double var_x117 = (7.1123755334281649e-6 * var_chaste_interface__sodium_concentration__Nai + 7.9026394815868502e-7 * var_chaste_interface__potassium_concentration__Ki) / pow(var_x116, 2);
        const double var_x118 = var_x117 * var_chaste_interface__fast_sodium_current__O_Na;
        
        
        rJacobian[0][0] = 1.0 - (mDt * (-0.050000000000000003 * var_x0 - 4.4000000000000004 * var_x2));
        rJacobian[0][1] = -(mDt * (var_x3 + var_x4));
        rJacobian[0][2] = -(mDt * (var_x4));
        rJacobian[0][3] = -(mDt * (var_x4));
        rJacobian[0][4] = -(mDt * (var_x4));
        rJacobian[0][5] = -(mDt * (var_x4));
        rJacobian[0][6] = -(mDt * (var_x4));
        rJacobian[0][7] = 0.0;
        rJacobian[0][8] = 0.0;
        rJacobian[0][9] = 0.0;
        rJacobian[0][10] = 0.0;
        rJacobian[0][11] = 0.0;
        rJacobian[0][12] = 0.0;
        rJacobian[0][13] = 0.0;
        rJacobian[0][14] = 0.0;
        rJacobian[0][15] = 0.0;
        rJacobian[0][16] = 0.0;
        rJacobian[0][17] = 0.0;
        rJacobian[0][18] = 0.0;
        rJacobian[0][19] = 0.0;
        rJacobian[0][20] = 0.0;
        rJacobian[0][21] = 0.0;
        rJacobian[0][22] = 0.0;
        rJacobian[0][23] = 0.0;
        rJacobian[0][24] = 0.0;
        rJacobian[0][25] = 0.0;
        rJacobian[0][26] = 0.0;
        rJacobian[0][27] = 0.0;
        rJacobian[0][28] = 0.0;
        rJacobian[0][29] = 0.0;
        rJacobian[0][30] = 0.0;
        rJacobian[0][31] = 0.0;
        rJacobian[1][0] = -(mDt * (1.2000000000000002 * var_x2));
        rJacobian[1][1] = 1.0 - (mDt * (-var_x3 - var_x5));
        rJacobian[1][2] = -(mDt * (var_x6));
        rJacobian[1][3] = 0.0;
        rJacobian[1][4] = 0.0;
        rJacobian[1][5] = 0.0;
        rJacobian[1][6] = 0.0;
        rJacobian[1][7] = 0.0;
        rJacobian[1][8] = 0.0;
        rJacobian[1][9] = 0.0;
        rJacobian[1][10] = 0.0;
        rJacobian[1][11] = 0.0;
        rJacobian[1][12] = 0.0;
        rJacobian[1][13] = 0.0;
        rJacobian[1][14] = 0.0;
        rJacobian[1][15] = 0.0;
        rJacobian[1][16] = 0.0;
        rJacobian[1][17] = 0.0;
        rJacobian[1][18] = 0.0;
        rJacobian[1][19] = 0.0;
        rJacobian[1][20] = 0.0;
        rJacobian[1][21] = 0.0;
        rJacobian[1][22] = 0.0;
        rJacobian[1][23] = 0.0;
        rJacobian[1][24] = 0.0;
        rJacobian[1][25] = 0.0;
        rJacobian[1][26] = 0.0;
        rJacobian[1][27] = 0.0;
        rJacobian[1][28] = 0.0;
        rJacobian[1][29] = 0.0;
        rJacobian[1][30] = 0.0;
        rJacobian[1][31] = 0.0;
        rJacobian[2][0] = 0.0;
        rJacobian[2][1] = -(mDt * (var_x5));
        rJacobian[2][2] = 1.0 - (mDt * (-0.026000000000000002 + var_x8 - var_x13 - var_x14 - var_x16 - var_x6));
        rJacobian[2][3] = -(mDt * (1.0000000000000002e-6 * var_x0));
        rJacobian[2][4] = -(mDt * (var_x17));
        rJacobian[2][5] = -(mDt * (var_x18));
        rJacobian[2][6] = -(mDt * (var_x19));
        rJacobian[2][7] = 0.0;
        rJacobian[2][8] = 0.0;
        rJacobian[2][9] = 0.0;
        rJacobian[2][10] = 0.0;
        rJacobian[2][11] = 0.0;
        rJacobian[2][12] = -(mDt * (var_x24 + var_x26 - var_x21 - var_x25));
        rJacobian[2][13] = 0.0;
        rJacobian[2][14] = 0.0;
        rJacobian[2][15] = 0.0;
        rJacobian[2][16] = 0.0;
        rJacobian[2][17] = 0.0;
        rJacobian[2][18] = 0.0;
        rJacobian[2][19] = 0.0;
        rJacobian[2][20] = 0.0;
        rJacobian[2][21] = 0.0;
        rJacobian[2][22] = 0.0;
        rJacobian[2][23] = 0.0;
        rJacobian[2][24] = 0.0;
        rJacobian[2][25] = 0.0;
        rJacobian[2][26] = 0.0;
        rJacobian[2][27] = 0.0;
        rJacobian[2][28] = 0.0;
        rJacobian[2][29] = 0.0;
        rJacobian[2][30] = 0.0;
        rJacobian[2][31] = 0.0;
        rJacobian[3][0] = 0.0;
        rJacobian[3][1] = 0.0;
        rJacobian[3][2] = -(mDt * (var_x16));
        rJacobian[3][3] = 1.0 - (mDt * (-0.0135 + var_x27 + var_x0 * (-0.026000000000000002 + 0.026000000000000002 * var_x7)));
        rJacobian[3][4] = 0.0;
        rJacobian[3][5] = -(mDt * (var_x28));
        rJacobian[3][6] = -(mDt * (var_x12));
        rJacobian[3][7] = 0.0;
        rJacobian[3][8] = 0.0;
        rJacobian[3][9] = 0.0;
        rJacobian[3][10] = 0.0;
        rJacobian[3][11] = 0.0;
        rJacobian[3][12] = -(mDt * (var_x25 + var_x29 - var_x26 - var_x30));
        rJacobian[3][13] = 0.0;
        rJacobian[3][14] = 0.0;
        rJacobian[3][15] = 0.0;
        rJacobian[3][16] = 0.0;
        rJacobian[3][17] = 0.0;
        rJacobian[3][18] = 0.0;
        rJacobian[3][19] = 0.0;
        rJacobian[3][20] = 0.0;
        rJacobian[3][21] = 0.0;
        rJacobian[3][22] = 0.0;
        rJacobian[3][23] = 0.0;
        rJacobian[3][24] = 0.0;
        rJacobian[3][25] = 0.0;
        rJacobian[3][26] = 0.0;
        rJacobian[3][27] = 0.0;
        rJacobian[3][28] = 0.0;
        rJacobian[3][29] = 0.0;
        rJacobian[3][30] = 0.0;
        rJacobian[3][31] = 0.0;
        rJacobian[4][0] = 0.0;
        rJacobian[4][1] = 0.0;
        rJacobian[4][2] = -(mDt * (0.026000000000000002 - var_x8));
        rJacobian[4][3] = 0.0;
        rJacobian[4][4] = 1.0 - (mDt * (var_x31 + var_x32 - var_x17));
        rJacobian[4][5] = -(mDt * (0.00050000000000000001));
        rJacobian[4][6] = -(mDt * (var_x33));
        rJacobian[4][7] = 0.0;
        rJacobian[4][8] = 0.0;
        rJacobian[4][9] = 0.0;
        rJacobian[4][10] = 0.0;
        rJacobian[4][11] = 0.0;
        rJacobian[4][12] = -(mDt * (var_x35 - var_x34));
        rJacobian[4][13] = 0.0;
        rJacobian[4][14] = 0.0;
        rJacobian[4][15] = 0.0;
        rJacobian[4][16] = 0.0;
        rJacobian[4][17] = 0.0;
        rJacobian[4][18] = 0.0;
        rJacobian[4][19] = 0.0;
        rJacobian[4][20] = 0.0;
        rJacobian[4][21] = 0.0;
        rJacobian[4][22] = 0.0;
        rJacobian[4][23] = 0.0;
        rJacobian[4][24] = 0.0;
        rJacobian[4][25] = 0.0;
        rJacobian[4][26] = 0.0;
        rJacobian[4][27] = 0.0;
        rJacobian[4][28] = 0.0;
        rJacobian[4][29] = 0.0;
        rJacobian[4][30] = 0.0;
        rJacobian[4][31] = 0.0;
        rJacobian[5][0] = 0.0;
        rJacobian[5][1] = 0.0;
        rJacobian[5][2] = -(mDt * (var_x13));
        rJacobian[5][3] = -(mDt * (var_x33));
        rJacobian[5][4] = -(mDt * (var_x12));
        rJacobian[5][5] = 1.0 - (mDt * (-0.00050000000000000001 + var_x32 - var_x18));
        rJacobian[5][6] = 0.0;
        rJacobian[5][7] = 0.0;
        rJacobian[5][8] = 0.0;
        rJacobian[5][9] = 0.0;
        rJacobian[5][10] = 0.0;
        rJacobian[5][11] = 0.0;
        rJacobian[5][12] = -(mDt * (var_x21 + var_x34 - var_x24 - var_x35));
        rJacobian[5][13] = 0.0;
        rJacobian[5][14] = 0.0;
        rJacobian[5][15] = 0.0;
        rJacobian[5][16] = 0.0;
        rJacobian[5][17] = 0.0;
        rJacobian[5][18] = 0.0;
        rJacobian[5][19] = 0.0;
        rJacobian[5][20] = 0.0;
        rJacobian[5][21] = 0.0;
        rJacobian[5][22] = 0.0;
        rJacobian[5][23] = 0.0;
        rJacobian[5][24] = 0.0;
        rJacobian[5][25] = 0.0;
        rJacobian[5][26] = 0.0;
        rJacobian[5][27] = 0.0;
        rJacobian[5][28] = 0.0;
        rJacobian[5][29] = 0.0;
        rJacobian[5][30] = 0.0;
        rJacobian[5][31] = 0.0;
        rJacobian[6][0] = 0.0;
        rJacobian[6][1] = 0.0;
        rJacobian[6][2] = -(mDt * (var_x14));
        rJacobian[6][3] = -(mDt * (0.00050000000000000001));
        rJacobian[6][4] = -(mDt * (var_x28));
        rJacobian[6][5] = 0.0;
        rJacobian[6][6] = 1.0 - (mDt * (-0.013000000000000001 + var_x27 + var_x31 - var_x19));
        rJacobian[6][7] = 0.0;
        rJacobian[6][8] = 0.0;
        rJacobian[6][9] = 0.0;
        rJacobian[6][10] = 0.0;
        rJacobian[6][11] = 0.0;
        rJacobian[6][12] = -(mDt * (var_x30 - var_x29));
        rJacobian[6][13] = 0.0;
        rJacobian[6][14] = 0.0;
        rJacobian[6][15] = 0.0;
        rJacobian[6][16] = 0.0;
        rJacobian[6][17] = 0.0;
        rJacobian[6][18] = 0.0;
        rJacobian[6][19] = 0.0;
        rJacobian[6][20] = 0.0;
        rJacobian[6][21] = 0.0;
        rJacobian[6][22] = 0.0;
        rJacobian[6][23] = 0.0;
        rJacobian[6][24] = 0.0;
        rJacobian[6][25] = 0.0;
        rJacobian[6][26] = 0.0;
        rJacobian[6][27] = 0.0;
        rJacobian[6][28] = 0.0;
        rJacobian[6][29] = 0.0;
        rJacobian[6][30] = 0.0;
        rJacobian[6][31] = 0.0;
        rJacobian[7][0] = 0.0;
        rJacobian[7][1] = 0.0;
        rJacobian[7][2] = 0.0;
        rJacobian[7][3] = 0.0;
        rJacobian[7][4] = 0.0;
        rJacobian[7][5] = 0.0;
        rJacobian[7][6] = 0.0;
        rJacobian[7][7] = 1.0 - (mDt * (-3.1999999999999999e-5 - var_x36));
        rJacobian[7][8] = 0.0;
        rJacobian[7][9] = 0.0;
        rJacobian[7][10] = 0.0;
        rJacobian[7][11] = -(mDt * (0.33180000000000004 - var_x37));
        rJacobian[7][12] = 0.0;
        rJacobian[7][13] = 0.0;
        rJacobian[7][14] = 0.0;
        rJacobian[7][15] = 0.0;
        rJacobian[7][16] = 0.0;
        rJacobian[7][17] = 0.0;
        rJacobian[7][18] = 0.0;
        rJacobian[7][19] = 0.0;
        rJacobian[7][20] = 0.0;
        rJacobian[7][21] = 0.0;
        rJacobian[7][22] = 0.0;
        rJacobian[7][23] = 0.0;
        rJacobian[7][24] = 0.0;
        rJacobian[7][25] = 0.0;
        rJacobian[7][26] = 0.0;
        rJacobian[7][27] = 0.0;
        rJacobian[7][28] = 0.0;
        rJacobian[7][29] = 0.0;
        rJacobian[7][30] = 0.0;
        rJacobian[7][31] = 0.0;
        rJacobian[8][0] = 0.0;
        rJacobian[8][1] = 0.0;
        rJacobian[8][2] = 0.0;
        rJacobian[8][3] = 0.0;
        rJacobian[8][4] = 0.0;
        rJacobian[8][5] = 0.0;
        rJacobian[8][6] = 0.0;
        rJacobian[8][7] = 0.0;
        rJacobian[8][8] = 1.0 - (mDt * (-0.019599999999999999 - var_x38));
        rJacobian[8][9] = 0.0;
        rJacobian[8][10] = 0.0;
        rJacobian[8][11] = -(mDt * (2.2890000000000001 - var_x39));
        rJacobian[8][12] = 0.0;
        rJacobian[8][13] = 0.0;
        rJacobian[8][14] = 0.0;
        rJacobian[8][15] = 0.0;
        rJacobian[8][16] = 0.0;
        rJacobian[8][17] = 0.0;
        rJacobian[8][18] = 0.0;
        rJacobian[8][19] = 0.0;
        rJacobian[8][20] = 0.0;
        rJacobian[8][21] = 0.0;
        rJacobian[8][22] = 0.0;
        rJacobian[8][23] = 0.0;
        rJacobian[8][24] = 0.0;
        rJacobian[8][25] = 0.0;
        rJacobian[8][26] = 0.0;
        rJacobian[8][27] = 0.0;
        rJacobian[8][28] = 0.0;
        rJacobian[8][29] = 0.0;
        rJacobian[8][30] = 0.0;
        rJacobian[8][31] = 0.0;
        rJacobian[9][0] = 0.0;
        rJacobian[9][1] = 0.0;
        rJacobian[9][2] = 0.0;
        rJacobian[9][3] = 0.0;
        rJacobian[9][4] = 0.0;
        rJacobian[9][5] = 0.0;
        rJacobian[9][6] = 0.0;
        rJacobian[9][7] = 0.0;
        rJacobian[9][8] = 0.0;
        rJacobian[9][9] = 1.0 - (mDt * (var_x42 * (-0.050000000000000003 + (-var_x43 - var_x44) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.00013333333333333334 * (0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 4.5 * var_x46 - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR) / (pow(var_x40, 3) * pow((0.053333333333333337 + var_x41), 2))));
        rJacobian[9][10] = -(mDt * (0.050000000000000003 * var_x42));
        rJacobian[9][11] = 0.0;
        rJacobian[9][12] = -(mDt * (var_x47 * (var_x43 + var_x44)));
        rJacobian[9][13] = -(mDt * (var_x42 * var_x45 * var_x48));
        rJacobian[9][14] = 0.0;
        rJacobian[9][15] = 0.0;
        rJacobian[9][16] = 0.0;
        rJacobian[9][17] = 0.0;
        rJacobian[9][18] = 0.0;
        rJacobian[9][19] = 0.0;
        rJacobian[9][20] = 0.0;
        rJacobian[9][21] = 0.0;
        rJacobian[9][22] = 0.0;
        rJacobian[9][23] = 0.0;
        rJacobian[9][24] = 0.0;
        rJacobian[9][25] = 0.0;
        rJacobian[9][26] = 0.0;
        rJacobian[9][27] = 0.0;
        rJacobian[9][28] = 0.0;
        rJacobian[9][29] = -(mDt * (var_x49));
        rJacobian[9][30] = -(mDt * (var_x49));
        rJacobian[9][31] = 0.0;
        rJacobian[10][0] = 0.0;
        rJacobian[10][1] = 0.0;
        rJacobian[10][2] = 0.0;
        rJacobian[10][3] = 0.0;
        rJacobian[10][4] = 0.0;
        rJacobian[10][5] = 0.0;
        rJacobian[10][6] = 0.0;
        rJacobian[10][7] = 0.0;
        rJacobian[10][8] = 0.0;
        rJacobian[10][9] = -(mDt * (0.0028598665395614866));
        rJacobian[10][10] = 1.0 - (mDt * (-0.0030741734985700662));
        rJacobian[10][11] = -(mDt * (0.0002143069590085796 + 11.084842707340323 * var_x53 - 11.084842707340323 * var_x54));
        rJacobian[10][12] = 0.0;
        rJacobian[10][13] = 0.0;
        rJacobian[10][14] = 0.0;
        rJacobian[10][15] = 0.0;
        rJacobian[10][16] = 0.0;
        rJacobian[10][17] = 0.0;
        rJacobian[10][18] = 0.0;
        rJacobian[10][19] = 0.0;
        rJacobian[10][20] = 0.0;
        rJacobian[10][21] = 0.0;
        rJacobian[10][22] = 0.0;
        rJacobian[10][23] = 0.0;
        rJacobian[10][24] = 0.0;
        rJacobian[10][25] = 0.0;
        rJacobian[10][26] = 0.0;
        rJacobian[10][27] = 0.0;
        rJacobian[10][28] = 0.0;
        rJacobian[10][29] = 0.0;
        rJacobian[10][30] = 0.0;
        rJacobian[10][31] = 0.0;
        rJacobian[11][0] = 0.0;
        rJacobian[11][1] = 0.0;
        rJacobian[11][2] = 0.0;
        rJacobian[11][3] = 0.0;
        rJacobian[11][4] = 0.0;
        rJacobian[11][5] = 0.0;
        rJacobian[11][6] = 0.0;
        rJacobian[11][7] = -(mDt * (var_x57 * (3.1999999999999999e-5 + var_x36)));
        rJacobian[11][8] = -(mDt * (var_x57 * (0.019599999999999999 + var_x38)));
        rJacobian[11][9] = 0.0;
        rJacobian[11][10] = -(mDt * (1.7399999999999999e-5 * var_x57));
        rJacobian[11][11] = 1.0 - (mDt * (var_x57 * (-2.7458174 + var_x37 + var_x39 + 0.96151847158279735 * var_x54 - 0.0045528151523329874 * var_x61 - 0.96151847158279735 * var_x53 - 0.00014491407891765456 * var_x58) + 0.16806722689075632 * (0.125 * var_chaste_interface__calcium_concentration__Cass + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR + 0.00014491407891765456 * log(1800.0 * var_x58) - 0.1250174 * var_chaste_interface__calcium_concentration__Cai - 1.12886395354433e-5 * var_chaste_interface__membrane__V - var_x36 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) - var_x38 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) + 1.6591891954566281e-18 * var_x60 * (1800.0 * var_x62 * pow(var_chaste_interface__sodium_concentration__Nai, 3) - 2744000000000000.0 * var_x59 * var_chaste_interface__calcium_concentration__Cai) - 0.48075923579139868 * var_x50 * var_x52) / (pow(var_x55, 3) * pow((0.084033613445378158 + var_x56), 2))));
        rJacobian[11][12] = -(mDt * (0.125 * var_x57));
        rJacobian[11][13] = 0.0;
        rJacobian[11][14] = 0.0;
        rJacobian[11][15] = 0.0;
        rJacobian[11][16] = 0.0;
        rJacobian[11][17] = 0.0;
        rJacobian[11][18] = 0.0;
        rJacobian[11][19] = 0.0;
        rJacobian[11][20] = 0.0;
        rJacobian[11][21] = 0.0;
        rJacobian[11][22] = 0.0;
        rJacobian[11][23] = 0.0;
        rJacobian[11][24] = 0.0;
        rJacobian[11][25] = 0.0;
        rJacobian[11][26] = 0.0;
        rJacobian[11][27] = 0.0;
        rJacobian[11][28] = 0.0;
        rJacobian[11][29] = 0.0;
        rJacobian[11][30] = 0.0;
        rJacobian[11][31] = -(mDt * (8.9596216554657907e-15 * var_x57 * var_x63));
        rJacobian[12][0] = 0.0;
        rJacobian[12][1] = 0.0;
        rJacobian[12][2] = 0.0;
        rJacobian[12][3] = 0.0;
        rJacobian[12][4] = 0.0;
        rJacobian[12][5] = 0.0;
        rJacobian[12][6] = -(mDt * (var_x66 * (5830.115245721463 - 92.541511836848613 * var_chaste_interface__membrane__V)));
        rJacobian[12][7] = 0.0;
        rJacobian[12][8] = 0.0;
        rJacobian[12][9] = -(mDt * (var_x69 * (var_x67 + var_x68)));
        rJacobian[12][10] = 0.0;
        rJacobian[12][11] = -(mDt * (2175.0841750841751 * var_x66));
        rJacobian[12][12] = 1.0 - (mDt * (var_x66 * (-2175.0841750841751 + (-var_x67 - var_x68) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.16806722689075632 * (363.63636363636363 * var_x46 + 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cai - 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cass - 92.541511836848613 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O) / (pow(var_x64, 3) * pow((0.084033613445378158 + var_x65), 2))));
        rJacobian[12][13] = -(mDt * (var_x45 * var_x66 * var_x70));
        rJacobian[12][14] = 0.0;
        rJacobian[12][15] = 0.0;
        rJacobian[12][16] = 0.0;
        rJacobian[12][17] = 0.0;
        rJacobian[12][18] = 0.0;
        rJacobian[12][19] = 0.0;
        rJacobian[12][20] = 0.0;
        rJacobian[12][21] = 0.0;
        rJacobian[12][22] = 0.0;
        rJacobian[12][23] = 0.0;
        rJacobian[12][24] = 0.0;
        rJacobian[12][25] = 0.0;
        rJacobian[12][26] = 0.0;
        rJacobian[12][27] = 0.0;
        rJacobian[12][28] = 0.0;
        rJacobian[12][29] = -(mDt * (var_x71));
        rJacobian[12][30] = -(mDt * (var_x71));
        rJacobian[12][31] = 0.0;
        rJacobian[13][0] = 0.0;
        rJacobian[13][1] = 0.0;
        rJacobian[13][2] = 0.0;
        rJacobian[13][3] = 0.0;
        rJacobian[13][4] = 0.0;
        rJacobian[13][5] = 0.0;
        rJacobian[13][6] = -(mDt * ((0.15561 - 0.00247 * var_chaste_interface__membrane__V) * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2))));
        rJacobian[13][7] = 0.0;
        rJacobian[13][8] = 0.0;
        rJacobian[13][9] = 0.0;
        rJacobian[13][10] = 0.0;
        rJacobian[13][11] = 0.0;
        rJacobian[13][12] = 0.0;
        rJacobian[13][13] = 1.0 - (mDt * (-0.040000000000000001));
        rJacobian[13][14] = 0.0;
        rJacobian[13][15] = 0.0;
        rJacobian[13][16] = 0.0;
        rJacobian[13][17] = 0.0;
        rJacobian[13][18] = 0.0;
        rJacobian[13][19] = 0.0;
        rJacobian[13][20] = 0.0;
        rJacobian[13][21] = 0.0;
        rJacobian[13][22] = 0.0;
        rJacobian[13][23] = 0.0;
        rJacobian[13][24] = 0.0;
        rJacobian[13][25] = 0.0;
        rJacobian[13][26] = 0.0;
        rJacobian[13][27] = 0.0;
        rJacobian[13][28] = 0.0;
        rJacobian[13][29] = 0.0;
        rJacobian[13][30] = 0.0;
        rJacobian[13][31] = 0.0;
        rJacobian[14][0] = 0.0;
        rJacobian[14][1] = 0.0;
        rJacobian[14][2] = 0.0;
        rJacobian[14][3] = 0.0;
        rJacobian[14][4] = 0.0;
        rJacobian[14][5] = 0.0;
        rJacobian[14][6] = 0.0;
        rJacobian[14][7] = 0.0;
        rJacobian[14][8] = 0.0;
        rJacobian[14][9] = 0.0;
        rJacobian[14][10] = 0.0;
        rJacobian[14][11] = 0.0;
        rJacobian[14][12] = 0.0;
        rJacobian[14][13] = 0.0;
        rJacobian[14][14] = 1.0 - (mDt * (var_x74 + var_x79 - var_x77));
        rJacobian[14][15] = -(mDt * (var_x80));
        rJacobian[14][16] = 0.0;
        rJacobian[14][17] = 0.0;
        rJacobian[14][18] = 0.0;
        rJacobian[14][19] = 0.0;
        rJacobian[14][20] = -(mDt * (var_x82));
        rJacobian[14][21] = -(mDt * (var_x84));
        rJacobian[14][22] = 0.0;
        rJacobian[14][23] = 0.0;
        rJacobian[14][24] = 0.0;
        rJacobian[14][25] = 0.0;
        rJacobian[14][26] = 0.0;
        rJacobian[14][27] = 0.0;
        rJacobian[14][28] = 0.0;
        rJacobian[14][29] = 0.0;
        rJacobian[14][30] = 0.0;
        rJacobian[14][31] = 0.0;
        rJacobian[15][0] = 0.0;
        rJacobian[15][1] = 0.0;
        rJacobian[15][2] = 0.0;
        rJacobian[15][3] = 0.0;
        rJacobian[15][4] = 0.0;
        rJacobian[15][5] = 0.0;
        rJacobian[15][6] = 0.0;
        rJacobian[15][7] = 0.0;
        rJacobian[15][8] = 0.0;
        rJacobian[15][9] = 0.0;
        rJacobian[15][10] = 0.0;
        rJacobian[15][11] = 0.0;
        rJacobian[15][12] = 0.0;
        rJacobian[15][13] = 0.0;
        rJacobian[15][14] = -(mDt * (var_x73 + var_x86));
        rJacobian[15][15] = 1.0 - (mDt * (var_x88 + var_x89));
        rJacobian[15][16] = -(mDt * (var_x86));
        rJacobian[15][17] = -(mDt * (var_x86));
        rJacobian[15][18] = -(mDt * (var_x82 + var_x86));
        rJacobian[15][19] = -(mDt * (var_x86));
        rJacobian[15][20] = -(mDt * (var_x86));
        rJacobian[15][21] = -(mDt * (var_x86));
        rJacobian[15][22] = 0.0;
        rJacobian[15][23] = 0.0;
        rJacobian[15][24] = 0.0;
        rJacobian[15][25] = 0.0;
        rJacobian[15][26] = 0.0;
        rJacobian[15][27] = 0.0;
        rJacobian[15][28] = 0.0;
        rJacobian[15][29] = 0.0;
        rJacobian[15][30] = 0.0;
        rJacobian[15][31] = 0.0;
        rJacobian[16][0] = 0.0;
        rJacobian[16][1] = 0.0;
        rJacobian[16][2] = 0.0;
        rJacobian[16][3] = 0.0;
        rJacobian[16][4] = 0.0;
        rJacobian[16][5] = 0.0;
        rJacobian[16][6] = 0.0;
        rJacobian[16][7] = 0.0;
        rJacobian[16][8] = 0.0;
        rJacobian[16][9] = 0.0;
        rJacobian[16][10] = 0.0;
        rJacobian[16][11] = 0.0;
        rJacobian[16][12] = 0.0;
        rJacobian[16][13] = 0.0;
        rJacobian[16][14] = 0.0;
        rJacobian[16][15] = 0.0;
        rJacobian[16][16] = 1.0 - (mDt * (var_x90 - var_x92));
        rJacobian[16][17] = -(mDt * (var_x93));
        rJacobian[16][18] = 0.0;
        rJacobian[16][19] = 0.0;
        rJacobian[16][20] = -(mDt * (var_x94));
        rJacobian[16][21] = 0.0;
        rJacobian[16][22] = 0.0;
        rJacobian[16][23] = 0.0;
        rJacobian[16][24] = 0.0;
        rJacobian[16][25] = 0.0;
        rJacobian[16][26] = 0.0;
        rJacobian[16][27] = 0.0;
        rJacobian[16][28] = 0.0;
        rJacobian[16][29] = 0.0;
        rJacobian[16][30] = 0.0;
        rJacobian[16][31] = 0.0;
        rJacobian[17][0] = 0.0;
        rJacobian[17][1] = 0.0;
        rJacobian[17][2] = 0.0;
        rJacobian[17][3] = 0.0;
        rJacobian[17][4] = 0.0;
        rJacobian[17][5] = 0.0;
        rJacobian[17][6] = 0.0;
        rJacobian[17][7] = 0.0;
        rJacobian[17][8] = 0.0;
        rJacobian[17][9] = 0.0;
        rJacobian[17][10] = 0.0;
        rJacobian[17][11] = 0.0;
        rJacobian[17][12] = 0.0;
        rJacobian[17][13] = 0.0;
        rJacobian[17][14] = 0.0;
        rJacobian[17][15] = 0.0;
        rJacobian[17][16] = -(mDt * (var_x92));
        rJacobian[17][17] = 1.0 - (mDt * (-var_x93));
        rJacobian[17][18] = 0.0;
        rJacobian[17][19] = 0.0;
        rJacobian[17][20] = 0.0;
        rJacobian[17][21] = 0.0;
        rJacobian[17][22] = 0.0;
        rJacobian[17][23] = 0.0;
        rJacobian[17][24] = 0.0;
        rJacobian[17][25] = 0.0;
        rJacobian[17][26] = 0.0;
        rJacobian[17][27] = 0.0;
        rJacobian[17][28] = 0.0;
        rJacobian[17][29] = 0.0;
        rJacobian[17][30] = 0.0;
        rJacobian[17][31] = 0.0;
        rJacobian[18][0] = 0.0;
        rJacobian[18][1] = 0.0;
        rJacobian[18][2] = 0.0;
        rJacobian[18][3] = 0.0;
        rJacobian[18][4] = 0.0;
        rJacobian[18][5] = 0.0;
        rJacobian[18][6] = 0.0;
        rJacobian[18][7] = 0.0;
        rJacobian[18][8] = 0.0;
        rJacobian[18][9] = 0.0;
        rJacobian[18][10] = 0.0;
        rJacobian[18][11] = 0.0;
        rJacobian[18][12] = 0.0;
        rJacobian[18][13] = 0.0;
        rJacobian[18][14] = 0.0;
        rJacobian[18][15] = -(mDt * (var_x95));
        rJacobian[18][16] = 0.0;
        rJacobian[18][17] = 0.0;
        rJacobian[18][18] = 1.0 - (mDt * (var_x88 + var_x90));
        rJacobian[18][19] = -(mDt * (var_x85));
        rJacobian[18][20] = -(mDt * (var_x73));
        rJacobian[18][21] = 0.0;
        rJacobian[18][22] = 0.0;
        rJacobian[18][23] = 0.0;
        rJacobian[18][24] = 0.0;
        rJacobian[18][25] = 0.0;
        rJacobian[18][26] = 0.0;
        rJacobian[18][27] = 0.0;
        rJacobian[18][28] = 0.0;
        rJacobian[18][29] = 0.0;
        rJacobian[18][30] = 0.0;
        rJacobian[18][31] = 0.0;
        rJacobian[19][0] = 0.0;
        rJacobian[19][1] = 0.0;
        rJacobian[19][2] = 0.0;
        rJacobian[19][3] = 0.0;
        rJacobian[19][4] = 0.0;
        rJacobian[19][5] = 0.0;
        rJacobian[19][6] = 0.0;
        rJacobian[19][7] = 0.0;
        rJacobian[19][8] = 0.0;
        rJacobian[19][9] = 0.0;
        rJacobian[19][10] = 0.0;
        rJacobian[19][11] = 0.0;
        rJacobian[19][12] = 0.0;
        rJacobian[19][13] = 0.0;
        rJacobian[19][14] = -(mDt * (var_x79));
        rJacobian[19][15] = -(mDt * (var_x79));
        rJacobian[19][16] = -(mDt * (var_x79));
        rJacobian[19][17] = -(mDt * (var_x79));
        rJacobian[19][18] = -(mDt * (var_x79 + var_x87));
        rJacobian[19][19] = 1.0 - (mDt * (var_x89 + var_x90));
        rJacobian[19][20] = -(mDt * (var_x79));
        rJacobian[19][21] = -(mDt * (var_x79));
        rJacobian[19][22] = 0.0;
        rJacobian[19][23] = 0.0;
        rJacobian[19][24] = 0.0;
        rJacobian[19][25] = 0.0;
        rJacobian[19][26] = 0.0;
        rJacobian[19][27] = 0.0;
        rJacobian[19][28] = 0.0;
        rJacobian[19][29] = 0.0;
        rJacobian[19][30] = 0.0;
        rJacobian[19][31] = 0.0;
        rJacobian[20][0] = 0.0;
        rJacobian[20][1] = 0.0;
        rJacobian[20][2] = 0.0;
        rJacobian[20][3] = 0.0;
        rJacobian[20][4] = 0.0;
        rJacobian[20][5] = 0.0;
        rJacobian[20][6] = 0.0;
        rJacobian[20][7] = 0.0;
        rJacobian[20][8] = 0.0;
        rJacobian[20][9] = 0.0;
        rJacobian[20][10] = 0.0;
        rJacobian[20][11] = 0.0;
        rJacobian[20][12] = 0.0;
        rJacobian[20][13] = 0.0;
        rJacobian[20][14] = -(mDt * (var_x95));
        rJacobian[20][15] = 0.0;
        rJacobian[20][16] = -(mDt * (var_x82));
        rJacobian[20][17] = 0.0;
        rJacobian[20][18] = -(mDt * (var_x80));
        rJacobian[20][19] = 0.0;
        rJacobian[20][20] = 1.0 - (mDt * (var_x74 + var_x90 - var_x94 - var_x96));
        rJacobian[20][21] = -(mDt * (var_x97));
        rJacobian[20][22] = 0.0;
        rJacobian[20][23] = 0.0;
        rJacobian[20][24] = 0.0;
        rJacobian[20][25] = 0.0;
        rJacobian[20][26] = 0.0;
        rJacobian[20][27] = 0.0;
        rJacobian[20][28] = 0.0;
        rJacobian[20][29] = 0.0;
        rJacobian[20][30] = 0.0;
        rJacobian[20][31] = 0.0;
        rJacobian[21][0] = 0.0;
        rJacobian[21][1] = 0.0;
        rJacobian[21][2] = 0.0;
        rJacobian[21][3] = 0.0;
        rJacobian[21][4] = 0.0;
        rJacobian[21][5] = 0.0;
        rJacobian[21][6] = 0.0;
        rJacobian[21][7] = 0.0;
        rJacobian[21][8] = 0.0;
        rJacobian[21][9] = 0.0;
        rJacobian[21][10] = 0.0;
        rJacobian[21][11] = 0.0;
        rJacobian[21][12] = 0.0;
        rJacobian[21][13] = 0.0;
        rJacobian[21][14] = -(mDt * (var_x77));
        rJacobian[21][15] = 0.0;
        rJacobian[21][16] = 0.0;
        rJacobian[21][17] = 0.0;
        rJacobian[21][18] = 0.0;
        rJacobian[21][19] = 0.0;
        rJacobian[21][20] = -(mDt * (var_x96));
        rJacobian[21][21] = 1.0 - (mDt * (-var_x84 - var_x97));
        rJacobian[21][22] = 0.0;
        rJacobian[21][23] = 0.0;
        rJacobian[21][24] = 0.0;
        rJacobian[21][25] = 0.0;
        rJacobian[21][26] = 0.0;
        rJacobian[21][27] = 0.0;
        rJacobian[21][28] = 0.0;
        rJacobian[21][29] = 0.0;
        rJacobian[21][30] = 0.0;
        rJacobian[21][31] = 0.0;
        rJacobian[22][0] = 0.0;
        rJacobian[22][1] = 0.0;
        rJacobian[22][2] = 0.0;
        rJacobian[22][3] = 0.0;
        rJacobian[22][4] = 0.0;
        rJacobian[22][5] = 0.0;
        rJacobian[22][6] = 0.0;
        rJacobian[22][7] = 0.0;
        rJacobian[22][8] = 0.0;
        rJacobian[22][9] = 0.0;
        rJacobian[22][10] = 0.0;
        rJacobian[22][11] = 0.0;
        rJacobian[22][12] = 0.0;
        rJacobian[22][13] = 0.0;
        rJacobian[22][14] = 0.0;
        rJacobian[22][15] = 0.0;
        rJacobian[22][16] = 0.0;
        rJacobian[22][17] = 0.0;
        rJacobian[22][18] = 0.0;
        rJacobian[22][19] = 0.0;
        rJacobian[22][20] = 0.0;
        rJacobian[22][21] = 0.0;
        rJacobian[22][22] = 1.0;
        rJacobian[22][23] = 0.0;
        rJacobian[22][24] = 0.0;
        rJacobian[22][25] = 0.0;
        rJacobian[22][26] = 0.0;
        rJacobian[22][27] = 0.0;
        rJacobian[22][28] = 0.0;
        rJacobian[22][29] = 0.0;
        rJacobian[22][30] = 0.0;
        rJacobian[22][31] = 0.0;
        rJacobian[23][0] = 0.0;
        rJacobian[23][1] = 0.0;
        rJacobian[23][2] = 0.0;
        rJacobian[23][3] = 0.0;
        rJacobian[23][4] = 0.0;
        rJacobian[23][5] = 0.0;
        rJacobian[23][6] = 0.0;
        rJacobian[23][7] = 0.0;
        rJacobian[23][8] = 0.0;
        rJacobian[23][9] = 0.0;
        rJacobian[23][10] = 0.0;
        rJacobian[23][11] = 0.0;
        rJacobian[23][12] = 0.0;
        rJacobian[23][13] = 0.0;
        rJacobian[23][14] = 0.0;
        rJacobian[23][15] = 0.0;
        rJacobian[23][16] = 0.0;
        rJacobian[23][17] = 0.0;
        rJacobian[23][18] = 0.0;
        rJacobian[23][19] = 0.0;
        rJacobian[23][20] = 0.0;
        rJacobian[23][21] = 0.0;
        rJacobian[23][22] = -(mDt * ((0.078972250091364882 * var_x99 - 0.003075923579139864 * var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss));
        rJacobian[23][23] = 1.0 - (mDt * (-1017.2528351768841 * var_x103 - 0.0090818087605069615 * var_x98 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) - 0.44667042500874232 * var_x98 / var_x101 - 0.078972250091364882 * var_x98 * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss - 0.642360282243162 * var_x98 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 0.25271120029236765 * var_x98 * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur + 0.040021670080783313 * var_x100 * var_x98 * (-25.674321243523316 * var_x99 + var_chaste_interface__membrane__V) / pow(var_x101, 2)));
        rJacobian[23][24] = 0.0;
        rJacobian[23][25] = 0.0;
        rJacobian[23][26] = 0.0;
        rJacobian[23][27] = -(mDt * (0.12319671014252923 * log(8257.1428571428569 / var_x102) - 0.0047984407834581883 * var_chaste_interface__membrane__V));
        rJacobian[23][28] = 0.0;
        rJacobian[23][29] = 0.0;
        rJacobian[23][30] = 0.0;
        rJacobian[23][31] = -(mDt * (4.1766221831198043e-8 * var_x106 - 20.760261942385391 * var_x103));
        rJacobian[24][0] = 0.0;
        rJacobian[24][1] = 0.0;
        rJacobian[24][2] = 0.0;
        rJacobian[24][3] = 0.0;
        rJacobian[24][4] = 0.0;
        rJacobian[24][5] = 0.0;
        rJacobian[24][6] = 0.0;
        rJacobian[24][7] = 0.0;
        rJacobian[24][8] = 0.0;
        rJacobian[24][9] = 0.0;
        rJacobian[24][10] = 0.0;
        rJacobian[24][11] = 0.0;
        rJacobian[24][12] = 0.0;
        rJacobian[24][13] = 0.0;
        rJacobian[24][14] = 0.0;
        rJacobian[24][15] = 0.0;
        rJacobian[24][16] = 0.0;
        rJacobian[24][17] = 0.0;
        rJacobian[24][18] = 0.0;
        rJacobian[24][19] = 0.0;
        rJacobian[24][20] = 0.0;
        rJacobian[24][21] = 0.0;
        rJacobian[24][22] = 0.0;
        rJacobian[24][23] = 0.0;
        rJacobian[24][24] = 1.0 - (mDt * (-0.023761000000000001 + var_x107 - 0.047002000000000002 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V)));
        rJacobian[24][25] = -(mDt * (0.036777999999999998 + var_x107));
        rJacobian[24][26] = -(mDt * (var_x107));
        rJacobian[24][27] = -(mDt * (var_x107));
        rJacobian[24][28] = 0.0;
        rJacobian[24][29] = 0.0;
        rJacobian[24][30] = 0.0;
        rJacobian[24][31] = 0.0;
        rJacobian[25][0] = 0.0;
        rJacobian[25][1] = 0.0;
        rJacobian[25][2] = 0.0;
        rJacobian[25][3] = 0.0;
        rJacobian[25][4] = 0.0;
        rJacobian[25][5] = 0.0;
        rJacobian[25][6] = 0.0;
        rJacobian[25][7] = 0.0;
        rJacobian[25][8] = 0.0;
        rJacobian[25][9] = 0.0;
        rJacobian[25][10] = 0.0;
        rJacobian[25][11] = 0.0;
        rJacobian[25][12] = 0.0;
        rJacobian[25][13] = 0.0;
        rJacobian[25][14] = 0.0;
        rJacobian[25][15] = 0.0;
        rJacobian[25][16] = 0.0;
        rJacobian[25][17] = 0.0;
        rJacobian[25][18] = 0.0;
        rJacobian[25][19] = 0.0;
        rJacobian[25][20] = 0.0;
        rJacobian[25][21] = 0.0;
        rJacobian[25][22] = 0.0;
        rJacobian[25][23] = 0.0;
        rJacobian[25][24] = -(mDt * (0.023761000000000001));
        rJacobian[25][25] = 1.0 - (mDt * (-0.036777999999999998 - var_x108));
        rJacobian[25][26] = 0.0;
        rJacobian[25][27] = -(mDt * (var_x109));
        rJacobian[25][28] = 0.0;
        rJacobian[25][29] = 0.0;
        rJacobian[25][30] = 0.0;
        rJacobian[25][31] = 0.0;
        rJacobian[26][0] = 0.0;
        rJacobian[26][1] = 0.0;
        rJacobian[26][2] = 0.0;
        rJacobian[26][3] = 0.0;
        rJacobian[26][4] = 0.0;
        rJacobian[26][5] = 0.0;
        rJacobian[26][6] = 0.0;
        rJacobian[26][7] = 0.0;
        rJacobian[26][8] = 0.0;
        rJacobian[26][9] = 0.0;
        rJacobian[26][10] = 0.0;
        rJacobian[26][11] = 0.0;
        rJacobian[26][12] = 0.0;
        rJacobian[26][13] = 0.0;
        rJacobian[26][14] = 0.0;
        rJacobian[26][15] = 0.0;
        rJacobian[26][16] = 0.0;
        rJacobian[26][17] = 0.0;
        rJacobian[26][18] = 0.0;
        rJacobian[26][19] = 0.0;
        rJacobian[26][20] = 0.0;
        rJacobian[26][21] = 0.0;
        rJacobian[26][22] = 0.0;
        rJacobian[26][23] = 0.0;
        rJacobian[26][24] = 0.0;
        rJacobian[26][25] = 0.0;
        rJacobian[26][26] = 1.0 - (mDt * (-var_x110));
        rJacobian[26][27] = -(mDt * (var_x111));
        rJacobian[26][28] = 0.0;
        rJacobian[26][29] = 0.0;
        rJacobian[26][30] = 0.0;
        rJacobian[26][31] = 0.0;
        rJacobian[27][0] = 0.0;
        rJacobian[27][1] = 0.0;
        rJacobian[27][2] = 0.0;
        rJacobian[27][3] = 0.0;
        rJacobian[27][4] = 0.0;
        rJacobian[27][5] = 0.0;
        rJacobian[27][6] = 0.0;
        rJacobian[27][7] = 0.0;
        rJacobian[27][8] = 0.0;
        rJacobian[27][9] = 0.0;
        rJacobian[27][10] = 0.0;
        rJacobian[27][11] = 0.0;
        rJacobian[27][12] = 0.0;
        rJacobian[27][13] = 0.0;
        rJacobian[27][14] = 0.0;
        rJacobian[27][15] = 0.0;
        rJacobian[27][16] = 0.0;
        rJacobian[27][17] = 0.0;
        rJacobian[27][18] = 0.0;
        rJacobian[27][19] = 0.0;
        rJacobian[27][20] = 0.0;
        rJacobian[27][21] = 0.0;
        rJacobian[27][22] = 0.0;
        rJacobian[27][23] = 0.0;
        rJacobian[27][24] = 0.0;
        rJacobian[27][25] = -(mDt * (var_x108));
        rJacobian[27][26] = -(mDt * (var_x110));
        rJacobian[27][27] = 1.0 - (mDt * (-var_x109 - var_x111));
        rJacobian[27][28] = 0.0;
        rJacobian[27][29] = 0.0;
        rJacobian[27][30] = 0.0;
        rJacobian[27][31] = 0.0;
        rJacobian[28][0] = 0.0;
        rJacobian[28][1] = 0.0;
        rJacobian[28][2] = 0.0;
        rJacobian[28][3] = 0.0;
        rJacobian[28][4] = 0.0;
        rJacobian[28][5] = 0.0;
        rJacobian[28][6] = 0.0;
        rJacobian[28][7] = 0.0;
        rJacobian[28][8] = 0.0;
        rJacobian[28][9] = 0.0;
        rJacobian[28][10] = 0.0;
        rJacobian[28][11] = 0.0;
        rJacobian[28][12] = 0.0;
        rJacobian[28][13] = 0.0;
        rJacobian[28][14] = 0.0;
        rJacobian[28][15] = 0.0;
        rJacobian[28][16] = 0.0;
        rJacobian[28][17] = 0.0;
        rJacobian[28][18] = 0.0;
        rJacobian[28][19] = 0.0;
        rJacobian[28][20] = 0.0;
        rJacobian[28][21] = 0.0;
        rJacobian[28][22] = 0.0;
        rJacobian[28][23] = 0.0;
        rJacobian[28][24] = 0.0;
        rJacobian[28][25] = 0.0;
        rJacobian[28][26] = 0.0;
        rJacobian[28][27] = 0.0;
        rJacobian[28][28] = 1.0 - (mDt * (-0.00080000000000000004));
        rJacobian[28][29] = -(mDt * (0.0089999999999999993));
        rJacobian[28][30] = 0.0;
        rJacobian[28][31] = 0.0;
        rJacobian[29][0] = 0.0;
        rJacobian[29][1] = 0.0;
        rJacobian[29][2] = 0.0;
        rJacobian[29][3] = 0.0;
        rJacobian[29][4] = 0.0;
        rJacobian[29][5] = 0.0;
        rJacobian[29][6] = 0.0;
        rJacobian[29][7] = 0.0;
        rJacobian[29][8] = 0.0;
        rJacobian[29][9] = 0.0;
        rJacobian[29][10] = 0.0;
        rJacobian[29][11] = 0.0;
        rJacobian[29][12] = -(mDt * (-var_x113 + 0.024299999999999999 * var_x112 * (1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2)));
        rJacobian[29][13] = 0.0;
        rJacobian[29][14] = 0.0;
        rJacobian[29][15] = 0.0;
        rJacobian[29][16] = 0.0;
        rJacobian[29][17] = 0.0;
        rJacobian[29][18] = 0.0;
        rJacobian[29][19] = 0.0;
        rJacobian[29][20] = 0.0;
        rJacobian[29][21] = 0.0;
        rJacobian[29][22] = 0.0;
        rJacobian[29][23] = 0.0;
        rJacobian[29][24] = 0.0;
        rJacobian[29][25] = 0.0;
        rJacobian[29][26] = 0.0;
        rJacobian[29][27] = 0.0;
        rJacobian[29][28] = -(mDt * (0.00080000000000000004 + var_x114));
        rJacobian[29][29] = 1.0 - (mDt * (-0.080249999999999988 + var_x114 - var_x115));
        rJacobian[29][30] = -(mDt * (0.96499999999999997 + var_x114));
        rJacobian[29][31] = 0.0;
        rJacobian[30][0] = 0.0;
        rJacobian[30][1] = 0.0;
        rJacobian[30][2] = 0.0;
        rJacobian[30][3] = 0.0;
        rJacobian[30][4] = 0.0;
        rJacobian[30][5] = 0.0;
        rJacobian[30][6] = 0.0;
        rJacobian[30][7] = 0.0;
        rJacobian[30][8] = 0.0;
        rJacobian[30][9] = 0.0;
        rJacobian[30][10] = 0.0;
        rJacobian[30][11] = 0.0;
        rJacobian[30][12] = -(mDt * (var_x113));
        rJacobian[30][13] = 0.0;
        rJacobian[30][14] = 0.0;
        rJacobian[30][15] = 0.0;
        rJacobian[30][16] = 0.0;
        rJacobian[30][17] = 0.0;
        rJacobian[30][18] = 0.0;
        rJacobian[30][19] = 0.0;
        rJacobian[30][20] = 0.0;
        rJacobian[30][21] = 0.0;
        rJacobian[30][22] = 0.0;
        rJacobian[30][23] = 0.0;
        rJacobian[30][24] = 0.0;
        rJacobian[30][25] = 0.0;
        rJacobian[30][26] = 0.0;
        rJacobian[30][27] = 0.0;
        rJacobian[30][28] = 0.0;
        rJacobian[30][29] = -(mDt * (var_x115));
        rJacobian[30][30] = 1.0 - (mDt * (-0.96499999999999997));
        rJacobian[30][31] = 0.0;
        rJacobian[31][0] = 0.0;
        rJacobian[31][1] = 0.0;
        rJacobian[31][2] = 0.0;
        rJacobian[31][3] = 0.0;
        rJacobian[31][4] = 0.0;
        rJacobian[31][5] = 0.0;
        rJacobian[31][6] = 0.0;
        rJacobian[31][7] = 0.0;
        rJacobian[31][8] = 0.0;
        rJacobian[31][9] = 0.0;
        rJacobian[31][10] = 0.0;
        rJacobian[31][11] = -(mDt * (0.013658445456998961 * var_x61));
        rJacobian[31][12] = 0.0;
        rJacobian[31][13] = 0.0;
        rJacobian[31][14] = 0.0;
        rJacobian[31][15] = 0.0;
        rJacobian[31][16] = 0.0;
        rJacobian[31][17] = 0.0;
        rJacobian[31][18] = 0.0;
        rJacobian[31][19] = 0.0;
        rJacobian[31][20] = 0.0;
        rJacobian[31][21] = -(mDt * (20.532785023754869 * log(140600.0 / var_x116) - 0.79974013057636462 * var_chaste_interface__membrane__V));
        rJacobian[31][22] = 0.0;
        rJacobian[31][23] = -(mDt * (-64.153546096442994 * var_x117 - 320767.73048221495 * var_x118));
        rJacobian[31][24] = 0.0;
        rJacobian[31][25] = 0.0;
        rJacobian[31][26] = 0.0;
        rJacobian[31][27] = 0.0;
        rJacobian[31][28] = 0.0;
        rJacobian[31][29] = 0.0;
        rJacobian[31][30] = 0.0;
        rJacobian[31][31] = 1.0 - (mDt * (-577.38191486798689 * var_x117 - 6.2649332746797061e-8 * var_x106 - 2886909.5743399346 * var_x118 - 2.6878864966397372e-14 * var_x63));
    }

    void Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
        const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
        const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_stim = var_membrane__i_stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_activated_chloride_current__i_ClCa - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_membrane__i_stim - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur; // millivolt / millisecond
        
        rY[0] += mDt*d_dt_chaste_interface_var_membrane__V;
    }
    
    void Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        // Time units: millisecond
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        
        const double var_fast_transient_outward_potassium_current__alpha_a = 0.18064 * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V);
        const double var_fast_transient_outward_potassium_current__alpha_i = 0.00015200000000000001 * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V));
        const double var_fast_transient_outward_potassium_current__beta_a = 0.39560000000000001 * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V);
        const double var_fast_transient_outward_potassium_current__beta_i = 0.00095 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V));
        const double var_non_inactivating_steady_state_potassium_current__tau_Kss = 13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V);
        const double var_slow_delayed_rectifier_potassium_current__alpha_n = 4.8133299999999997e-6 * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V));
        const double var_slow_delayed_rectifier_potassium_current__beta_n = 9.5333299999999997e-5 * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V);
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V));
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V));
        const double var_slow_transient_outward_potassium_current__tau_ta_s = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V);
        const double var_slow_transient_outward_potassium_current__tau_ti_s = 270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V));
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V);
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur = 1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V));
        
        
        rY[28] = (var_chaste_interface__fast_transient_outward_potassium_current__ato_f + ((var_fast_transient_outward_potassium_current__alpha_a) * mDt)) / (1.0 - ((-var_fast_transient_outward_potassium_current__alpha_a - var_fast_transient_outward_potassium_current__beta_a) * mDt));
        rY[29] = (var_chaste_interface__fast_transient_outward_potassium_current__ito_f + ((var_fast_transient_outward_potassium_current__alpha_i) * mDt)) / (1.0 - ((-var_fast_transient_outward_potassium_current__alpha_i - var_fast_transient_outward_potassium_current__beta_i) * mDt));
        rY[35] = (var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss + ((var_slow_transient_outward_potassium_current__ass / var_non_inactivating_steady_state_potassium_current__tau_Kss) * mDt)) / (1.0 - ((-1 / var_non_inactivating_steady_state_potassium_current__tau_Kss) * mDt));
        rY[32] = (var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs + ((var_slow_delayed_rectifier_potassium_current__alpha_n) * mDt)) / (1.0 - ((-var_slow_delayed_rectifier_potassium_current__alpha_n - var_slow_delayed_rectifier_potassium_current__beta_n) * mDt));
        rY[30] = (var_chaste_interface__slow_transient_outward_potassium_current__ato_s + ((var_slow_transient_outward_potassium_current__ass / var_slow_transient_outward_potassium_current__tau_ta_s) * mDt)) / (1.0 - ((-1 / var_slow_transient_outward_potassium_current__tau_ta_s) * mDt));
        rY[31] = (var_chaste_interface__slow_transient_outward_potassium_current__ito_s + ((var_slow_transient_outward_potassium_current__iss / var_slow_transient_outward_potassium_current__tau_ti_s) * mDt)) / (1.0 - ((-1 / var_slow_transient_outward_potassium_current__tau_ti_s) * mDt));
        rY[33] = (var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur + ((var_slow_transient_outward_potassium_current__ass / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur) * mDt)) / (1.0 - ((-1 / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur) * mDt));
        rY[34] = (var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur + ((var_slow_transient_outward_potassium_current__iss / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur) * mDt)) / (1.0 - ((-1 / var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur) * mDt));
        
        double _guess[32] = {rY[12],rY[13],rY[14],rY[15],rY[16],rY[17],rY[11],rY[7],rY[6],rY[3],rY[4],rY[1],rY[2],rY[5],rY[20],rY[21],rY[22],rY[23],rY[25],rY[26],rY[24],rY[19],rY[36],rY[27],rY[38],rY[39],rY[40],rY[37],rY[10],rY[8],rY[9],rY[18]};
        CardiacNewtonSolver<32,Cellbondarenko_model_2004_apexFromCellMLBackwardEuler>* _p_solver = CardiacNewtonSolver<32,Cellbondarenko_model_2004_apexFromCellMLBackwardEuler>::Instance();
        _p_solver->Solve(*this, var_chaste_interface__environment__time, _guess);
        rY[12] = _guess[0];
        rY[13] = _guess[1];
        rY[14] = _guess[2];
        rY[15] = _guess[3];
        rY[16] = _guess[4];
        rY[17] = _guess[5];
        rY[11] = _guess[6];
        rY[7] = _guess[7];
        rY[6] = _guess[8];
        rY[3] = _guess[9];
        rY[4] = _guess[10];
        rY[1] = _guess[11];
        rY[2] = _guess[12];
        rY[5] = _guess[13];
        rY[20] = _guess[14];
        rY[21] = _guess[15];
        rY[22] = _guess[16];
        rY[23] = _guess[17];
        rY[25] = _guess[18];
        rY[26] = _guess[19];
        rY[24] = _guess[20];
        rY[19] = _guess[21];
        rY[36] = _guess[22];
        rY[27] = _guess[23];
        rY[38] = _guess[24];
        rY[39] = _guess[25];
        rY[40] = _guess[26];
        rY[37] = _guess[27];
        rY[10] = _guess[28];
        rY[8] = _guess[29];
        rY[9] = _guess[30];
        rY[18] = _guess[31];
    }

    std::vector<double> Cellbondarenko_model_2004_apexFromCellMLBackwardEuler::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLBackwardEuler>::Initialise(void)
{
    this->mSystemName = "bondarenko_model_2004_apex";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-82.4202);

    // rY[1]:
    this->mVariableNames.push_back("calcium_concentration__Cai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[2]:
    this->mVariableNames.push_back("calcium_concentration__Cass");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[3]:
    this->mVariableNames.push_back("calcium_concentration__CaJSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[4]:
    this->mVariableNames.push_back("calcium_concentration__CaNSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[5]:
    this->mVariableNames.push_back("calcium_fluxes__P_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("calcium_buffering__LTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(11.2684);

    // rY[7]:
    this->mVariableNames.push_back("calcium_buffering__HTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(125.29);

    // rY[8]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.49102e-05);

    // rY[9]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.51726e-11);

    // rY[10]:
    this->mVariableNames.push_back("ryanodine_receptors__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016774);

    // rY[11]:
    this->mVariableNames.push_back("L_type_calcium_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.30308e-19);

    // rY[12]:
    this->mVariableNames.push_back("L_type_calcium_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000124216);

    // rY[13]:
    this->mVariableNames.push_back("L_type_calcium_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.78679e-09);

    // rY[14]:
    this->mVariableNames.push_back("L_type_calcium_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.19816e-13);

    // rY[15]:
    this->mVariableNames.push_back("L_type_calcium_current__I1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.97923e-19);

    // rY[16]:
    this->mVariableNames.push_back("L_type_calcium_current__I2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.45847e-14);

    // rY[17]:
    this->mVariableNames.push_back("L_type_calcium_current__I3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.85106e-14);

    // rY[18]:
    this->mVariableNames.push_back("sodium_concentration__Nai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(14237.1);

    // rY[19]:
    this->mVariableNames.push_back("fast_sodium_current__O_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.13483e-07);

    // rY[20]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000279132);

    // rY[21]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020752);

    // rY[22]:
    this->mVariableNames.push_back("fast_sodium_current__I1_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.73345e-07);

    // rY[23]:
    this->mVariableNames.push_back("fast_sodium_current__I2_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.55787e-09);

    // rY[24]:
    this->mVariableNames.push_back("fast_sodium_current__IF_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000153176);

    // rY[25]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113879);

    // rY[26]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.34278);

    // rY[27]:
    this->mVariableNames.push_back("potassium_concentration__Ki");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(143720.0);

    // rY[28]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ato_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00265563);

    // rY[29]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ito_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999977);

    // rY[30]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ato_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[31]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ito_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[32]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current__nKs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000262753);

    // rY[33]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__aur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[34]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__iur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[35]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__aKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[36]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__iKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[37]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__O_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175298);

    // rY[38]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000992513);

    // rY[39]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000641229);

    // rY[40]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__I_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.19129e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0002;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellbondarenko_model_2004_apexFromCellMLBackwardEuler)
