# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_show_scaladoc.ipynb (unless otherwise specified).

__all__ = ['is_enum', 're_digits_first', 'is_doc_name', 'doc_link', 'add_doc_links', 'colab_link', 'get_nb_source_link',
           'nb_source_link', 'format_all_params', 'wrap_params', 'show_doc', 'md2html', 'get_doc_link', 'doc']

# Cell
from nbdev.imports import *
from nbconvert import HTMLExporter
from fastcore.utils import IN_NOTEBOOK

if IN_NOTEBOOK:
    from IPython.display import Markdown,display
    from IPython.core import page

# Cell
import sys
import os
import copy

# SCRIPT_DIR = os.path.dirname(os.getcwd()) + '/chisel_nbdev'
# sys.path.append(os.path.normpath(SCRIPT_DIR))
from .export_scala import *
from .export_scala import get_nbdev_module
from .sync_scala import *

# Cell
def is_enum(cls):
    "Check if `cls` is an enum or another type of class"
    return type(cls) in (enum.Enum, enum.EnumMeta)

# Cell
re_digits_first = re.compile('^[0-9]+[a-z]*_')

# Cell
def is_doc_name(name):
    "Test if `name` corresponds to a notebook that could be converted to a doc page"
    for f in Config().path("nbs_path").glob(f'*{name}.ipynb'):
        if re_digits_first.sub('', f.name) == f'{name}.ipynb': return True
    return False

# Cell
def doc_link(name, include_bt=True):
    "Create link to documentation for `name`."
    cname = f'`{name}`' if include_bt else name
    try:
        #Link to modules
        if is_doc_name(name): return f"[{cname}]({Config().doc_baseurl}{name}.html)"
        #Link to local functions
        try_local = source_nb(name, is_name=True)
        if try_local:
            page = re_digits_first.sub('', try_local).replace('.ipynb', '')
            return f'[{cname}]({Config().doc_baseurl}{page}.html#{name})'
        ##Custom links
        mod = get_nbdev_module()
        link = mod.custom_doc_links(name)
        return f'[{cname}]({link})' if link is not None else cname
    except Exception as e: print(e); return cname

# Cell
_re_backticks = re.compile(r"""
# Catches any link of the form \[`obj`\](old_link) or just `obj`,
#   to either update old links or add the link to the docs of obj
\[`      #     Opening [ and `
([^`]*)  #     Catching group with anything but a `
`\]      #     ` then closing ]
(?:      #     Beginning of non-catching group
\(       #       Opening (
[^)]*    #       Anything but a closing )
\)       #       Closing )
)        #     End of non-catching group
|        # OR
`        #     Opening `
([^`]*)  #       Anything but a `
`        #     Closing `
""", re.VERBOSE)

# Cell
def add_doc_links(text, elt=None):
    "Search for doc links for any item between backticks in `text` and insert them"
    def _replace_link(m):
        try:
            if m.group(2) in inspect.signature(elt).parameters: return f'`{m.group(2)}`'
        except: pass
        return doc_link(m.group(1) or m.group(2))
    return _re_backticks.sub(_replace_link, text)

# Cell
_re_header = re.compile(r"""
# Catches any header in markdown with the title in group 1
^\s*  # Beginning of text followed by any number of whitespace
\#+   # One # or more
\s*   # Any number of whitespace
(.*)  # Catching group with anything
$     # End of text
""", re.VERBOSE)

# Cell
def colab_link(path):
    "Get a link to the notebook at `path` on Colab"
    cfg = Config()
    res = f'https://colab.research.google.com/github/{cfg.user}/{cfg.lib_name}/blob/{cfg.branch}/{cfg.path("nbs_path").name}/{path}.ipynb'
    display(Markdown(f'[Open `{path}` in Colab]({res})'))

# Cell
def _get_sig_by_name(find_name):
    return re.compile(fr'''(abstract\s+class|case\s+class|class|object|trait|sealed\s+trait|implicit\s+def|def)\s+({find_name})''', re.MULTILINE)

# Cell
_re_get_params_list = re.compile(r'''
\((.*)\)
''', re.MULTILINE | re.VERBOSE)

# Cell
_back_trav_re = re.compile(r'\s*([^(,]+)\s*:\s*([^:]+)\s*[,)]\s*$')

def _parse_scala_paramlist(s):
    ''' matches from end  of string backwards, expecting initial parameters string to be enclosed in parens
like s = "(a: Int, b: (Int, Int))'''
    params = []
    _re = _back_trav_re

    l = copy.deepcopy(s)
    while l != "(":
        match = _back_trav_re.search(l)
        l = l[:match.span(0)[0]]
        params.append((match.group(1), match.group(2)))
    return params[::-1]

# Cell
def _split_paramlist(plist):
    ret = []
    for v,t in plist:
        typ = t.strip() # remove whitespace
        try:
            typ, default_val = typ.split('=')
            ret.append({v :(typ, default_val)})
        except ValueError:
            ret.append({v :(typ)})
    return ret


# Cell
def _get_sig_cell(fname):
    src = source_nb(fname, is_name=True, return_all=True)
    if src is None: return ''
    find_name,nb_name = src
    nb = read_nb(nb_name)
    pat = _get_sig_by_name(fname)
    for i,cell in enumerate(nb['cells']):
        if cell['cell_type'] == 'code':
            if re.search(pat, cell['source']):
                return cell['source']

# Cell
def _get_sig_params(fname:str =None, code:str =None):
    if code is None:
        code = _get_sig_cell(fname)
    plist = re.search(_re_get_params_list, code).group(0)
    if plist is None:
        return
    ps = _parse_scala_paramlist(plist)
    return _split_paramlist(ps)

# Cell
def get_nb_source_link(func, local=False):
    "Return a link to the notebook where `func` is defined."
#     func = _unwrapped_type_dispatch_func(func)
    pref = '' if local else Config().git_url.replace('github.com', 'nbviewer.jupyter.org/github')+ Config().path("nbs_path").name+'/'
    src = source_nb(func, is_name=True, return_all=True)
    if src is None: return ''
    find_name,nb_name = src
    print(find_name)
    nb = read_nb(nb_name)
#     pat = re.compile(f'^{find_name}\s+=|^(def|class)\s+{find_name}\s*\(', re.MULTILINE)
    pat = _get_sig_by_name(find_name)
    if len(find_name.split('.')) == 2:
        clas,pat = find_name.split('.') # split test.Add -> Add in situation where Add defined in > 1 modules
    for i,cell in enumerate(nb['cells']):
        if cell['cell_type'] == 'code':
            if re.search(pat, cell['source']):  break
    if re.search(pat, cell['source']) is None:
        return ''
    header_pat = re.compile(r'^\s*#+\s*(.*)$')
    while i >= 0:
        cell = nb['cells'][i]
        if cell['cell_type'] == 'markdown' and _re_header.search(cell['source']):
            title = _re_header.search(cell['source']).groups()[0]
            anchor = '-'.join([s for s in title.split(' ') if len(s) > 0])
            return f'{pref}{nb_name}#{anchor}'
        i-=1
    return f'{pref}{nb_name}'

# Cell
def nb_source_link(func, disp=True, local=True):
    "Show a relative link to the notebook where `func` is defined"
    link = get_nb_source_link(func, local=local)
    text = func if local else f'{func} (GitHub)'
    if disp: display(Markdown(f'[{text}]({link})'))
    else: return link

# Cell
def _format_param(p):
    res = ""
    "Formats function param to `param:Type=val` with font weights: param=bold, val=italic"
    for k,v in p.items():
        typ, def_val = v if type(v) == tuple else (v, None)
        res = f"**`{k}`:`{typ}`**"
        if def_val is not None: res += f"=*`{def_val}`*"

    return res

# Cell
def format_all_params(fname):
    ps = _get_sig_params(fname)
    return [_format_param(p) for p in ps]

# Cell
def wrap_params(name, ps):
    fmt_name = f"<code>{name}</code>"
    args = ""
    for p in ps:
        args += p + ','
    return fmt_name, f"{fmt_name}({args.rstrip(',')})"

# Cell
def show_doc(fname, doc_string=False, title_level=None, disp=True, default_cls_level=2):
    "Show documentation for fname"
    try:
        name, args = wrap_params(fname, format_all_params(fname))
    except AttributeError:
        # signature lacks params
        name, args = f"<code>{fname}</code>", []
    link = nb_source_link(fname, disp=disp, local=False)
    source_link = f'<a href="{link}" class="source_link" style="float:right">[source]</a>'
    title_level = title_level if title_level else default_cls_level
    doc =  f'<h{title_level} id="{fname}" class="doc_header">{name}{source_link}</h{title_level}>'
    doc += f'\n\n> {args}\n\n' if len(args) > 0 else '\n\n'
    if disp: display(Markdown(doc))
    else: return doc

# Cell
def md2html(md):
    "Convert markdown `md` to HTML code"
    import nbconvert
    if nbconvert.__version__ < '5.5.0': return HTMLExporter().markdown2html(md)
    else: return HTMLExporter().markdown2html(collections.defaultdict(lambda: collections.defaultdict(dict)), md)

# Cell
def get_doc_link(func):
    src = source_nb(func, is_name=True)
    nbdev_mod = get_nbdev_module()
    if src:
        print(src)
        page = '.'.join(src.partition('_')[-1:]).replace('.ipynb', '')
        return f'{nbdev_mod.doc_url}{page}#{func}'
    return None

# Cell
def doc(elt):
    "Show `show_doc` info in preview window when used in a notebook"
    md = show_doc(elt, disp=False)
    doc_link = get_doc_link(elt)
    if doc_link is not None:
        md += f'\n\n<a href="{doc_link}" target="_blank" rel="noreferrer noopener">Show in docs</a>'
    output = md2html(md)
    if IN_COLAB: get_ipython().run_cell_magic(u'html', u'', output)
    else:
        try: page.page({'text/html': output})
        except: display(Markdown(md))