# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._service_linker_management_client_enums import *


class AuthInfoBase(msrest.serialization.Model):
    """The authentication info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecretAuthInfo, ServicePrincipalCertificateAuthInfo, ServicePrincipalSecretAuthInfo, SystemAssignedIdentityAuthInfo, UserAssignedIdentityAuthInfo.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'secret': 'SecretAuthInfo', 'servicePrincipalCertificate': 'ServicePrincipalCertificateAuthInfo', 'servicePrincipalSecret': 'ServicePrincipalSecretAuthInfo', 'systemAssignedIdentity': 'SystemAssignedIdentityAuthInfo', 'userAssignedIdentity': 'UserAssignedIdentityAuthInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AuthInfoBase, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]


class AzureResourcePropertiesBase(msrest.serialization.Model):
    """The azure resource properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureKeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The azure resource type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'KeyVault': 'AzureKeyVaultProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AzureResourcePropertiesBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureKeyVaultProperties(AzureResourcePropertiesBase):
    """The resource properties when type is Azure Key Vault.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The azure resource type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    :ivar connect_as_kubernetes_csi_driver: True if connect via Kubernetes CSI Driver.
    :vartype connect_as_kubernetes_csi_driver: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'connect_as_kubernetes_csi_driver': {'key': 'connectAsKubernetesCsiDriver', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        connect_as_kubernetes_csi_driver: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword connect_as_kubernetes_csi_driver: True if connect via Kubernetes CSI Driver.
        :paramtype connect_as_kubernetes_csi_driver: bool
        """
        super(AzureKeyVaultProperties, self).__init__(**kwargs)
        self.type = 'KeyVault'  # type: str
        self.connect_as_kubernetes_csi_driver = connect_as_kubernetes_csi_driver


class TargetServiceBase(msrest.serialization.Model):
    """The target service properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureResource, ConfluentBootstrapServer, ConfluentSchemaRegistry.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The target service type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureResource': 'AzureResource', 'ConfluentBootstrapServer': 'ConfluentBootstrapServer', 'ConfluentSchemaRegistry': 'ConfluentSchemaRegistry'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetServiceBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureResource(TargetServiceBase):
    """The azure resource info when target service type is AzureResource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The target service type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    :ivar id: The Id of azure resource.
    :vartype id: str
    :ivar resource_properties: The azure resource connection related properties.
    :vartype resource_properties: ~azure.mgmt.servicelinker.models.AzureResourcePropertiesBase
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'resource_properties': {'key': 'resourceProperties', 'type': 'AzureResourcePropertiesBase'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resource_properties: Optional["AzureResourcePropertiesBase"] = None,
        **kwargs
    ):
        """
        :keyword id: The Id of azure resource.
        :paramtype id: str
        :keyword resource_properties: The azure resource connection related properties.
        :paramtype resource_properties: ~azure.mgmt.servicelinker.models.AzureResourcePropertiesBase
        """
        super(AzureResource, self).__init__(**kwargs)
        self.type = 'AzureResource'  # type: str
        self.id = id
        self.resource_properties = resource_properties


class ConfluentBootstrapServer(TargetServiceBase):
    """The service properties when target service type is ConfluentBootstrapServer.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The target service type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    :ivar endpoint: The endpoint of service.
    :vartype endpoint: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoint: The endpoint of service.
        :paramtype endpoint: str
        """
        super(ConfluentBootstrapServer, self).__init__(**kwargs)
        self.type = 'ConfluentBootstrapServer'  # type: str
        self.endpoint = endpoint


class ConfluentSchemaRegistry(TargetServiceBase):
    """The service properties when target service type is ConfluentSchemaRegistry.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The target service type.Constant filled by server. Possible values
     include: "AzureResource", "ConfluentBootstrapServer", "ConfluentSchemaRegistry", "KeyVault".
    :vartype type: str or ~azure.mgmt.servicelinker.models.Type
    :ivar endpoint: The endpoint of service.
    :vartype endpoint: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoint: The endpoint of service.
        :paramtype endpoint: str
        """
        super(ConfluentSchemaRegistry, self).__init__(**kwargs)
        self.type = 'ConfluentSchemaRegistry'  # type: str
        self.endpoint = endpoint


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicelinker.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.servicelinker.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicelinker.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.servicelinker.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class SecretInfoBase(msrest.serialization.Model):
    """The secret info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: KeyVaultSecretReferenceSecretInfo, KeyVaultSecretUriSecretInfo, ValueSecretInfo.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: Required. The secret type.Constant filled by server. Possible values
     include: "rawValue", "keyVaultSecretUri", "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    """

    _validation = {
        'secret_type': {'required': True},
    }

    _attribute_map = {
        'secret_type': {'key': 'secretType', 'type': 'str'},
    }

    _subtype_map = {
        'secret_type': {'keyVaultSecretReference': 'KeyVaultSecretReferenceSecretInfo', 'keyVaultSecretUri': 'KeyVaultSecretUriSecretInfo', 'rawValue': 'ValueSecretInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SecretInfoBase, self).__init__(**kwargs)
        self.secret_type = None  # type: Optional[str]


class KeyVaultSecretReferenceSecretInfo(SecretInfoBase):
    """The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: Required. The secret type.Constant filled by server. Possible values
     include: "rawValue", "keyVaultSecretUri", "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar name: Name of the Key Vault secret.
    :vartype name: str
    :ivar version: Version of the Key Vault secret.
    :vartype version: str
    """

    _validation = {
        'secret_type': {'required': True},
    }

    _attribute_map = {
        'secret_type': {'key': 'secretType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the Key Vault secret.
        :paramtype name: str
        :keyword version: Version of the Key Vault secret.
        :paramtype version: str
        """
        super(KeyVaultSecretReferenceSecretInfo, self).__init__(**kwargs)
        self.secret_type = 'keyVaultSecretReference'  # type: str
        self.name = name
        self.version = version


class KeyVaultSecretUriSecretInfo(SecretInfoBase):
    """The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret stored in user's keyvault and source is Web App, Spring Cloud or Container App.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: Required. The secret type.Constant filled by server. Possible values
     include: "rawValue", "keyVaultSecretUri", "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar value: URI to the keyvault secret.
    :vartype value: str
    """

    _validation = {
        'secret_type': {'required': True},
    }

    _attribute_map = {
        'secret_type': {'key': 'secretType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: URI to the keyvault secret.
        :paramtype value: str
        """
        super(KeyVaultSecretUriSecretInfo, self).__init__(**kwargs)
        self.secret_type = 'keyVaultSecretUri'  # type: str
        self.value = value


class LinkerList(msrest.serialization.Model):
    """The list of Linker.

    :ivar next_link: The link used to get the next page of Linker list.
    :vartype next_link: str
    :ivar value: The list of Linkers.
    :vartype value: list[~azure.mgmt.servicelinker.models.LinkerResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[LinkerResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["LinkerResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of Linker list.
        :paramtype next_link: str
        :keyword value: The list of Linkers.
        :paramtype value: list[~azure.mgmt.servicelinker.models.LinkerResource]
        """
        super(LinkerList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class LinkerPatch(msrest.serialization.Model):
    """A linker to be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Possible values include: "none", "dotnet",
     "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'target_service': {'key': 'properties.targetService', 'type': 'TargetServiceBase'},
        'auth_info': {'key': 'properties.authInfo', 'type': 'AuthInfoBase'},
        'client_type': {'key': 'properties.clientType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'v_net_solution': {'key': 'properties.vNetSolution', 'type': 'VNetSolution'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'SecretStore'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_service: Optional["TargetServiceBase"] = None,
        auth_info: Optional["AuthInfoBase"] = None,
        client_type: Optional[Union[str, "ClientType"]] = None,
        v_net_solution: Optional["VNetSolution"] = None,
        secret_store: Optional["SecretStore"] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Possible values include: "none", "dotnet",
         "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        """
        super(LinkerPatch, self).__init__(**kwargs)
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class LinkerResource(ProxyResource):
    """Linker of source and target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.servicelinker.models.SystemData
    :ivar target_service: The target service properties.
    :vartype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
    :ivar auth_info: The authentication type.
    :vartype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
    :ivar client_type: The application client type. Possible values include: "none", "dotnet",
     "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
    :vartype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar v_net_solution: The VNet solution.
    :vartype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
    :ivar secret_store: An option to store secret value in secure place.
    :vartype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
    :ivar scope: connection scope in source service.
    :vartype scope: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'target_service': {'key': 'properties.targetService', 'type': 'TargetServiceBase'},
        'auth_info': {'key': 'properties.authInfo', 'type': 'AuthInfoBase'},
        'client_type': {'key': 'properties.clientType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'v_net_solution': {'key': 'properties.vNetSolution', 'type': 'VNetSolution'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'SecretStore'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_service: Optional["TargetServiceBase"] = None,
        auth_info: Optional["AuthInfoBase"] = None,
        client_type: Optional[Union[str, "ClientType"]] = None,
        v_net_solution: Optional["VNetSolution"] = None,
        secret_store: Optional["SecretStore"] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_service: The target service properties.
        :paramtype target_service: ~azure.mgmt.servicelinker.models.TargetServiceBase
        :keyword auth_info: The authentication type.
        :paramtype auth_info: ~azure.mgmt.servicelinker.models.AuthInfoBase
        :keyword client_type: The application client type. Possible values include: "none", "dotnet",
         "java", "python", "go", "php", "ruby", "django", "nodejs", "springBoot".
        :paramtype client_type: str or ~azure.mgmt.servicelinker.models.ClientType
        :keyword v_net_solution: The VNet solution.
        :paramtype v_net_solution: ~azure.mgmt.servicelinker.models.VNetSolution
        :keyword secret_store: An option to store secret value in secure place.
        :paramtype secret_store: ~azure.mgmt.servicelinker.models.SecretStore
        :keyword scope: connection scope in source service.
        :paramtype scope: str
        """
        super(LinkerResource, self).__init__(**kwargs)
        self.system_data = None
        self.target_service = target_service
        self.auth_info = auth_info
        self.client_type = client_type
        self.provisioning_state = None
        self.v_net_solution = v_net_solution
        self.secret_store = secret_store
        self.scope = scope


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.servicelinker.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.servicelinker.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.servicelinker.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.servicelinker.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.servicelinker.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecretAuthInfo(AuthInfoBase):
    """The authentication info when authType is secret.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar name: Username or account name for secret auth.
    :vartype name: str
    :ivar secret_info: Password or key vault secret for secret auth.
    :vartype secret_info: ~azure.mgmt.servicelinker.models.SecretInfoBase
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'secret_info': {'key': 'secretInfo', 'type': 'SecretInfoBase'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        secret_info: Optional["SecretInfoBase"] = None,
        **kwargs
    ):
        """
        :keyword name: Username or account name for secret auth.
        :paramtype name: str
        :keyword secret_info: Password or key vault secret for secret auth.
        :paramtype secret_info: ~azure.mgmt.servicelinker.models.SecretInfoBase
        """
        super(SecretAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'secret'  # type: str
        self.name = name
        self.secret_info = secret_info


class SecretStore(msrest.serialization.Model):
    """An option to store secret value in secure place.

    :ivar key_vault_id: The key vault id to store secret.
    :vartype key_vault_id: str
    """

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault_id: The key vault id to store secret.
        :paramtype key_vault_id: str
        """
        super(SecretStore, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id


class ServicePrincipalCertificateAuthInfo(AuthInfoBase):
    """The authentication info when authType is servicePrincipal certificate.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar client_id: Required. Application clientId for servicePrincipal auth.
    :vartype client_id: str
    :ivar principal_id: Required. Principal Id for servicePrincipal auth.
    :vartype principal_id: str
    :ivar certificate: Required. ServicePrincipal certificate for servicePrincipal auth.
    :vartype certificate: str
    """

    _validation = {
        'auth_type': {'required': True},
        'client_id': {'required': True},
        'principal_id': {'required': True},
        'certificate': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        certificate: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. Application clientId for servicePrincipal auth.
        :paramtype client_id: str
        :keyword principal_id: Required. Principal Id for servicePrincipal auth.
        :paramtype principal_id: str
        :keyword certificate: Required. ServicePrincipal certificate for servicePrincipal auth.
        :paramtype certificate: str
        """
        super(ServicePrincipalCertificateAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'servicePrincipalCertificate'  # type: str
        self.client_id = client_id
        self.principal_id = principal_id
        self.certificate = certificate


class ServicePrincipalSecretAuthInfo(AuthInfoBase):
    """The authentication info when authType is servicePrincipal secret.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar client_id: Required. ServicePrincipal application clientId for servicePrincipal auth.
    :vartype client_id: str
    :ivar principal_id: Required. Principal Id for servicePrincipal auth.
    :vartype principal_id: str
    :ivar secret: Required. Secret for servicePrincipal auth.
    :vartype secret: str
    """

    _validation = {
        'auth_type': {'required': True},
        'client_id': {'required': True},
        'principal_id': {'required': True},
        'secret': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        principal_id: str,
        secret: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. ServicePrincipal application clientId for servicePrincipal auth.
        :paramtype client_id: str
        :keyword principal_id: Required. Principal Id for servicePrincipal auth.
        :paramtype principal_id: str
        :keyword secret: Required. Secret for servicePrincipal auth.
        :paramtype secret: str
        """
        super(ServicePrincipalSecretAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'servicePrincipalSecret'  # type: str
        self.client_id = client_id
        self.principal_id = principal_id
        self.secret = secret


class SourceConfiguration(msrest.serialization.Model):
    """A configuration item for source resource.

    :ivar name: The name of setting.
    :vartype name: str
    :ivar value: The value of setting.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of setting.
        :paramtype name: str
        :keyword value: The value of setting.
        :paramtype value: str
        """
        super(SourceConfiguration, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SourceConfigurationResult(msrest.serialization.Model):
    """Configurations for source resource, include appSettings, connectionString and serviceBindings.

    :ivar configurations: The configuration properties for source resource.
    :vartype configurations: list[~azure.mgmt.servicelinker.models.SourceConfiguration]
    """

    _attribute_map = {
        'configurations': {'key': 'configurations', 'type': '[SourceConfiguration]'},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["SourceConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword configurations: The configuration properties for source resource.
        :paramtype configurations: list[~azure.mgmt.servicelinker.models.SourceConfiguration]
        """
        super(SourceConfigurationResult, self).__init__(**kwargs)
        self.configurations = configurations


class SystemAssignedIdentityAuthInfo(AuthInfoBase):
    """The authentication info when authType is systemAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SystemAssignedIdentityAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'systemAssignedIdentity'  # type: str


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.servicelinker.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentityAuthInfo(AuthInfoBase):
    """The authentication info when authType is userAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. The authentication type.Constant filled by server. Possible values
     include: "systemAssignedIdentity", "userAssignedIdentity", "servicePrincipalSecret",
     "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar client_id: Client Id for userAssignedIdentity.
    :vartype client_id: str
    :ivar subscription_id: Subscription id for userAssignedIdentity.
    :vartype subscription_id: str
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: Client Id for userAssignedIdentity.
        :paramtype client_id: str
        :keyword subscription_id: Subscription id for userAssignedIdentity.
        :paramtype subscription_id: str
        """
        super(UserAssignedIdentityAuthInfo, self).__init__(**kwargs)
        self.auth_type = 'userAssignedIdentity'  # type: str
        self.client_id = client_id
        self.subscription_id = subscription_id


class ValidateResult(msrest.serialization.Model):
    """The validation result for a linker.

    :ivar linker_name: The linker name.
    :vartype linker_name: str
    :ivar is_connection_available: A boolean value indicating whether the connection is available
     or not.
    :vartype is_connection_available: bool
    :ivar report_start_time_utc: The start time of the validation report.
    :vartype report_start_time_utc: ~datetime.datetime
    :ivar report_end_time_utc: The end time of the validation report.
    :vartype report_end_time_utc: ~datetime.datetime
    :ivar source_id: The resource id of the linker source application.
    :vartype source_id: str
    :ivar target_id: The resource Id of target service.
    :vartype target_id: str
    :ivar auth_type: The authentication type. Possible values include: "systemAssignedIdentity",
     "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret".
    :vartype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
    :ivar validation_detail: The detail of validation result.
    :vartype validation_detail: list[~azure.mgmt.servicelinker.models.ValidationResultItem]
    """

    _attribute_map = {
        'linker_name': {'key': 'linkerName', 'type': 'str'},
        'is_connection_available': {'key': 'isConnectionAvailable', 'type': 'bool'},
        'report_start_time_utc': {'key': 'reportStartTimeUtc', 'type': 'iso-8601'},
        'report_end_time_utc': {'key': 'reportEndTimeUtc', 'type': 'iso-8601'},
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'auth_type': {'key': 'authType', 'type': 'str'},
        'validation_detail': {'key': 'validationDetail', 'type': '[ValidationResultItem]'},
    }

    def __init__(
        self,
        *,
        linker_name: Optional[str] = None,
        is_connection_available: Optional[bool] = None,
        report_start_time_utc: Optional[datetime.datetime] = None,
        report_end_time_utc: Optional[datetime.datetime] = None,
        source_id: Optional[str] = None,
        target_id: Optional[str] = None,
        auth_type: Optional[Union[str, "AuthType"]] = None,
        validation_detail: Optional[List["ValidationResultItem"]] = None,
        **kwargs
    ):
        """
        :keyword linker_name: The linker name.
        :paramtype linker_name: str
        :keyword is_connection_available: A boolean value indicating whether the connection is
         available or not.
        :paramtype is_connection_available: bool
        :keyword report_start_time_utc: The start time of the validation report.
        :paramtype report_start_time_utc: ~datetime.datetime
        :keyword report_end_time_utc: The end time of the validation report.
        :paramtype report_end_time_utc: ~datetime.datetime
        :keyword source_id: The resource id of the linker source application.
        :paramtype source_id: str
        :keyword target_id: The resource Id of target service.
        :paramtype target_id: str
        :keyword auth_type: The authentication type. Possible values include: "systemAssignedIdentity",
         "userAssignedIdentity", "servicePrincipalSecret", "servicePrincipalCertificate", "secret".
        :paramtype auth_type: str or ~azure.mgmt.servicelinker.models.AuthType
        :keyword validation_detail: The detail of validation result.
        :paramtype validation_detail: list[~azure.mgmt.servicelinker.models.ValidationResultItem]
        """
        super(ValidateResult, self).__init__(**kwargs)
        self.linker_name = linker_name
        self.is_connection_available = is_connection_available
        self.report_start_time_utc = report_start_time_utc
        self.report_end_time_utc = report_end_time_utc
        self.source_id = source_id
        self.target_id = target_id
        self.auth_type = auth_type
        self.validation_detail = validation_detail


class ValidationResultItem(msrest.serialization.Model):
    """The validation item for a linker.

    :ivar name: The validation item name.
    :vartype name: str
    :ivar description: The display name of validation item.
    :vartype description: str
    :ivar result: The result of validation. Possible values include: "success", "failed",
     "warning".
    :vartype result: str or ~azure.mgmt.servicelinker.models.ValidationResultStatus
    :ivar error_message: The error message of validation result.
    :vartype error_message: str
    :ivar error_code: The error code of validation result.
    :vartype error_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'result': {'key': 'result', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        result: Optional[Union[str, "ValidationResultStatus"]] = None,
        error_message: Optional[str] = None,
        error_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The validation item name.
        :paramtype name: str
        :keyword description: The display name of validation item.
        :paramtype description: str
        :keyword result: The result of validation. Possible values include: "success", "failed",
         "warning".
        :paramtype result: str or ~azure.mgmt.servicelinker.models.ValidationResultStatus
        :keyword error_message: The error message of validation result.
        :paramtype error_message: str
        :keyword error_code: The error code of validation result.
        :paramtype error_code: str
        """
        super(ValidationResultItem, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.result = result
        self.error_message = error_message
        self.error_code = error_code


class ValueSecretInfo(SecretInfoBase):
    """The secret info when type is rawValue. It's for scenarios that user input the secret.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_type: Required. The secret type.Constant filled by server. Possible values
     include: "rawValue", "keyVaultSecretUri", "keyVaultSecretReference".
    :vartype secret_type: str or ~azure.mgmt.servicelinker.models.SecretType
    :ivar value: The actual value of the secret.
    :vartype value: str
    """

    _validation = {
        'secret_type': {'required': True},
    }

    _attribute_map = {
        'secret_type': {'key': 'secretType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The actual value of the secret.
        :paramtype value: str
        """
        super(ValueSecretInfo, self).__init__(**kwargs)
        self.secret_type = 'rawValue'  # type: str
        self.value = value


class VNetSolution(msrest.serialization.Model):
    """The VNet solution for linker.

    :ivar type: Type of VNet solution. Possible values include: "serviceEndpoint", "privateLink".
    :vartype type: str or ~azure.mgmt.servicelinker.models.VNetSolutionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "VNetSolutionType"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of VNet solution. Possible values include: "serviceEndpoint",
         "privateLink".
        :paramtype type: str or ~azure.mgmt.servicelinker.models.VNetSolutionType
        """
        super(VNetSolution, self).__init__(**kwargs)
        self.type = type
