# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/client.ipynb (unless otherwise specified).

__all__ = ['Client', 'getCardToken']

# Cell
from .helper import Keys
from nicHelper.wrappers import add_method
from numbers import Number
import requests

# Cell

class Client:
  '''
    main client for interface with global prime pay
  '''
  def __init__(self, pub, secret, endpoint = 'https://api.globalprimepay.com'):
    '''
      input:
        pub: str:: publiceKey from web
        secret: str:: secretKey from web
      docs (https://doc.gbprimepay.com)
    '''
    self.key = Keys(pub,secret)
    self.endpoint = endpoint


# Cell
@add_method(Client)
def getCardToken(self, cardNumber, expirationMonth, expirationYear, securityCode, name, **kwargs):

  body = {
    "rememberCard": True,
    "card": {
      "number": cardNumber,
      "expirationMonth": expirationMonth,
      "expirationYear": expirationYear,
      "securityCode": securityCode,
      "name": name
    }
    ,**kwargs
  }

  headersCharge = {
    'Authorization': self.key.pubPL,
    'Content-Type': 'application/json',
  }
  baseURL = self.endpoint
  url = f'{baseURL}/v2/tokens'
  r = requests.post(url,headers = headersCharge, json = body)
  return r.json()
