
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/python/arcor2_calibration:arcor2_calibration_dist

from setuptools import setup

setup(**{
    'author': 'Robo@FIT',
    'author_email': 'imaterna@fit.vut.cz',
    'classifiers': [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Programming Language :: Python :: 3.8',
        'Natural Language :: English',
        'Topic :: Scientific/Engineering',
    ],
    'description': 'ARCOR2 Calibration',
    'license': 'LGPL',
    'long_description': """# ARCOR2 Calibration service

### Example configuration

```yaml
id: Arbitrary text
marker_size: 0.1
markers:
  10:
    pose:
      position:
        x: 0
        y: 0
        z: 0
      orientation:
        x: 0
        y: 0
        z: 0
        w: 1
```
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),

## [0.6.0] - 2021-06-11
### Changed

- Improved quality estimation (take orientation into account).
- Reject blurry images.

## [0.5.0] - 2021-05-21
### Changed
- `PUT /calibrate/camera` now returns `EstimatedPose` (pose + quality).

### Fixed
- Command line arguments fixed.
  - It is mandatory to provide `-c` (path to a configuration file) or one of `-s` (prints OpenAPI) or `-m` (start as mock).

## [0.4.0] - 2021-04-26
### Changed
- The service now requires YAML configuration file where placement of markers is specified.
- There might be 1-n markers in an arbitrary pose.
- At least one of the configured markers should be visible.
- Un-configured markers are ignored.  
- Estimated poses of the camera from multiple detected markers are so far simply averaged.
- The average is weighted according to the camera-marker distance.

## [0.3.0] - 2021-03-30
### Changed
- `PUT /calibrate/camera` now has `inverse` parameter. 

## [0.2.0] - 2021-02-08
### Changed
- Part of the code refactored into `arcor2/flask.py`.
- API for getting pixel coordinates of markers corners.
  - Approx. three times faster than camera calibration.

## [0.1.1] - 2020-12-14
### Changed
- Bump version to allow reupload to pypi

## [0.1.0] - 2020-12-14
### Changed
- Initial release of the package.
- Support for camera calibration.
- Support for robot calibration.
  - URDF model of the robot needed.
  - Requires depth camera (e.g. Kinect).
- `--mock` argument to start the service in a simulation mode.""",
    'long_description_content_type': 'text/markdown',
    'name': 'arcor2_calibration',
    'python_requires': '==3.8.*',
    'version': '0.6.0',
    'package_dir': {
        '': 'src',
    },
    'packages': (
        'arcor2_calibration',
        'arcor2_calibration.scripts',
    ),
    'namespace_packages': (
    ),
    'package_data': {
        'arcor2_calibration': (
            'VERSION',
            'py.typed',
        ),
    },
    'install_requires': (
        'Flask==2.0.1',
        'Pillow==8.2.0',
        'PyYAML==5.4.1',
        'arcor2_calibration_data~=0.4.0',
        'arcor2~=0.17.0',
        'dataclasses-jsonschema[apispec,fast-validation]==2.14.1',
        'numpy-quaternion[numba,scipy]==2021.6.9.13.34.11',
        'numpy==1.20.3',
        'open3d==0.13.0',
        'opencv-contrib-python==4.5.2.54',
        'urdfpy==0.0.22',
    ),
    'entry_points': {
        'console_scripts': [
            'arcor2_calibration=arcor2_calibration.scripts.calibration:main',
        ],
    },
})
