# mypy-boto3-ssm

[![PyPI - mypy-boto3-ssm](https://img.shields.io/pypi/v/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.SSM 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/ssm.html#SSM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SSM` service.

```bash
python -m pip install boto3-stubs[ssm]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_ssm` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_ssm import SSMClient

# Now mypy can check if your code is valid.
client: SSMClient = boto3.client("ssm")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSMClient = session.client("ssm")



# Annotated paginators are included as well

import mypy_boto3_ssm.paginator as ssm_paginators

describe_activations_paginator: ssm_paginators.DescribeActivationsPaginator = client.get_paginator("describe_activations")
describe_association_execution_targets_paginator: ssm_paginators.DescribeAssociationExecutionTargetsPaginator = client.get_paginator("describe_association_execution_targets")
describe_association_executions_paginator: ssm_paginators.DescribeAssociationExecutionsPaginator = client.get_paginator("describe_association_executions")
describe_automation_executions_paginator: ssm_paginators.DescribeAutomationExecutionsPaginator = client.get_paginator("describe_automation_executions")
describe_automation_step_executions_paginator: ssm_paginators.DescribeAutomationStepExecutionsPaginator = client.get_paginator("describe_automation_step_executions")
describe_available_patches_paginator: ssm_paginators.DescribeAvailablePatchesPaginator = client.get_paginator("describe_available_patches")
describe_effective_instance_associations_paginator: ssm_paginators.DescribeEffectiveInstanceAssociationsPaginator = client.get_paginator("describe_effective_instance_associations")
describe_effective_patches_for_patch_baseline_paginator: ssm_paginators.DescribeEffectivePatchesForPatchBaselinePaginator = client.get_paginator("describe_effective_patches_for_patch_baseline")
describe_instance_associations_status_paginator: ssm_paginators.DescribeInstanceAssociationsStatusPaginator = client.get_paginator("describe_instance_associations_status")
describe_instance_information_paginator: ssm_paginators.DescribeInstanceInformationPaginator = client.get_paginator("describe_instance_information")
describe_instance_patch_states_paginator: ssm_paginators.DescribeInstancePatchStatesPaginator = client.get_paginator("describe_instance_patch_states")
describe_instance_patch_states_for_patch_group_paginator: ssm_paginators.DescribeInstancePatchStatesForPatchGroupPaginator = client.get_paginator("describe_instance_patch_states_for_patch_group")
describe_instance_patches_paginator: ssm_paginators.DescribeInstancePatchesPaginator = client.get_paginator("describe_instance_patches")
describe_inventory_deletions_paginator: ssm_paginators.DescribeInventoryDeletionsPaginator = client.get_paginator("describe_inventory_deletions")
describe_maintenance_window_execution_task_invocations_paginator: ssm_paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPaginator = client.get_paginator("describe_maintenance_window_execution_task_invocations")
describe_maintenance_window_execution_tasks_paginator: ssm_paginators.DescribeMaintenanceWindowExecutionTasksPaginator = client.get_paginator("describe_maintenance_window_execution_tasks")
describe_maintenance_window_executions_paginator: ssm_paginators.DescribeMaintenanceWindowExecutionsPaginator = client.get_paginator("describe_maintenance_window_executions")
describe_maintenance_window_schedule_paginator: ssm_paginators.DescribeMaintenanceWindowSchedulePaginator = client.get_paginator("describe_maintenance_window_schedule")
describe_maintenance_window_targets_paginator: ssm_paginators.DescribeMaintenanceWindowTargetsPaginator = client.get_paginator("describe_maintenance_window_targets")
describe_maintenance_window_tasks_paginator: ssm_paginators.DescribeMaintenanceWindowTasksPaginator = client.get_paginator("describe_maintenance_window_tasks")
describe_maintenance_windows_paginator: ssm_paginators.DescribeMaintenanceWindowsPaginator = client.get_paginator("describe_maintenance_windows")
describe_maintenance_windows_for_target_paginator: ssm_paginators.DescribeMaintenanceWindowsForTargetPaginator = client.get_paginator("describe_maintenance_windows_for_target")
describe_parameters_paginator: ssm_paginators.DescribeParametersPaginator = client.get_paginator("describe_parameters")
describe_patch_baselines_paginator: ssm_paginators.DescribePatchBaselinesPaginator = client.get_paginator("describe_patch_baselines")
describe_patch_groups_paginator: ssm_paginators.DescribePatchGroupsPaginator = client.get_paginator("describe_patch_groups")
describe_sessions_paginator: ssm_paginators.DescribeSessionsPaginator = client.get_paginator("describe_sessions")
get_inventory_paginator: ssm_paginators.GetInventoryPaginator = client.get_paginator("get_inventory")
get_inventory_schema_paginator: ssm_paginators.GetInventorySchemaPaginator = client.get_paginator("get_inventory_schema")
get_parameter_history_paginator: ssm_paginators.GetParameterHistoryPaginator = client.get_paginator("get_parameter_history")
get_parameters_by_path_paginator: ssm_paginators.GetParametersByPathPaginator = client.get_paginator("get_parameters_by_path")
list_association_versions_paginator: ssm_paginators.ListAssociationVersionsPaginator = client.get_paginator("list_association_versions")
list_associations_paginator: ssm_paginators.ListAssociationsPaginator = client.get_paginator("list_associations")
list_command_invocations_paginator: ssm_paginators.ListCommandInvocationsPaginator = client.get_paginator("list_command_invocations")
list_commands_paginator: ssm_paginators.ListCommandsPaginator = client.get_paginator("list_commands")
list_compliance_items_paginator: ssm_paginators.ListComplianceItemsPaginator = client.get_paginator("list_compliance_items")
list_compliance_summaries_paginator: ssm_paginators.ListComplianceSummariesPaginator = client.get_paginator("list_compliance_summaries")
list_document_versions_paginator: ssm_paginators.ListDocumentVersionsPaginator = client.get_paginator("list_document_versions")
list_documents_paginator: ssm_paginators.ListDocumentsPaginator = client.get_paginator("list_documents")
list_resource_compliance_summaries_paginator: ssm_paginators.ListResourceComplianceSummariesPaginator = client.get_paginator("list_resource_compliance_summaries")
list_resource_data_sync_paginator: ssm_paginators.ListResourceDataSyncPaginator = client.get_paginator("list_resource_data_sync")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_ssm` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_ssm as ssm
from mypy_boto3_ssm import SSMClient

# with these
from mypy_boto3 import ssm
from mypy_boto3.ssm import SSMClient
```