import numpy as np
import matplotlib.pyplot as plt
from sklearn import datasets, svm, preprocessing
from sklearn_rvm import rvm

iris = datasets.load_iris()

X = iris.data
y = iris.target


X = X[y != 0, :2]
y = y[y != 0]

n_sample = len(X)

np.random.seed(0)
order = np.random.permutation(n_sample)
X = X[order]
y = y[order].astype(np.float)

le = preprocessing.LabelEncoder()
le.fit(y)
y = le.transform(y)

X_train = X[:int(.9 * n_sample)]
y_train = y[:int(.9 * n_sample)]
X_test = X[int(.9 * n_sample):]
y_test = y[int(.9 * n_sample):]


clf = RVC2()
clf.fit(X_train, y_train)

plt.figure()

plt.clf()
plt.scatter(X[:, 0], X[:, 1], c=y, zorder=10, cmap=plt.cm.Paired,
            edgecolor='k', s=20)

# Circle out the test data
plt.scatter(X_test[:, 0], X_test[:, 1], s=80, facecolors='none',
            zorder=10, edgecolor='k')

plt.axis('tight')
x_min = X[:, 0].min()
x_max = X[:, 0].max()
y_min = X[:, 1].min()
y_max = X[:, 1].max()

XX, YY = np.mgrid[x_min:x_max:200j, y_min:y_max:200j]

plt.show()




################
################
from sklearn.datasets import load_iris
iris  = load_iris()

clf = RVC2()
clf.fit(iris.data,iris.target)
clf.score(iris.data, iris.target)
