# Generated by Django 2.2.12 on 2020-09-16 11:46

from django.db import migrations


def rename_settings(apps, schema_editor):
    LocalConfig = apps.get_model("core", "LocalConfig")
    lc = LocalConfig.objects.first()
    if not lc:
        return
    stats_params = lc._parameters.pop("modoboa_stats", None)
    if stats_params:
        lc._parameters["maillog"] = stats_params
        lc.save()


def backwards(apps, schema_editor):
    LocalConfig = apps.get_model("core", "LocalConfig")
    lc = LocalConfig.objects.first()
    if not lc:
        return
    params = lc._parameters.pop("maillog", None)
    if params:
        lc._parameters["modoboa_stats"] = params
        lc.save()


class Migration(migrations.Migration):

    dependencies = [
        ('maillog', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(rename_settings, backwards),
    ]
