# Copyright 2020 The Tekton Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Tekton

    Tekton Pipeline  # noqa: E501

    The version of the OpenAPI document: v0.17.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tekton_pipeline.configuration import Configuration


class V1alpha1PipelineResourceSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'params': 'list[V1alpha1ResourceParam]',
        'secrets': 'list[V1alpha1SecretParam]',
        'type': 'str'
    }

    attribute_map = {
        'description': 'description',
        'params': 'params',
        'secrets': 'secrets',
        'type': 'type'
    }

    def __init__(self, description=None, params=None, secrets=None, type=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1PipelineResourceSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._params = None
        self._secrets = None
        self._type = None
        self.discriminator = None

        if description is not None:
            self.description = description
        self.params = params
        if secrets is not None:
            self.secrets = secrets
        self.type = type

    @property
    def description(self):
        """Gets the description of this V1alpha1PipelineResourceSpec.  # noqa: E501

        Description is a user-facing description of the resource that may be used to populate a UI.  # noqa: E501

        :return: The description of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V1alpha1PipelineResourceSpec.

        Description is a user-facing description of the resource that may be used to populate a UI.  # noqa: E501

        :param description: The description of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def params(self):
        """Gets the params of this V1alpha1PipelineResourceSpec.  # noqa: E501


        :return: The params of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :rtype: list[V1alpha1ResourceParam]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this V1alpha1PipelineResourceSpec.


        :param params: The params of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :type: list[V1alpha1ResourceParam]
        """
        if self.local_vars_configuration.client_side_validation and params is None:  # noqa: E501
            raise ValueError("Invalid value for `params`, must not be `None`")  # noqa: E501

        self._params = params

    @property
    def secrets(self):
        """Gets the secrets of this V1alpha1PipelineResourceSpec.  # noqa: E501

        Secrets to fetch to populate some of resource fields  # noqa: E501

        :return: The secrets of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :rtype: list[V1alpha1SecretParam]
        """
        return self._secrets

    @secrets.setter
    def secrets(self, secrets):
        """Sets the secrets of this V1alpha1PipelineResourceSpec.

        Secrets to fetch to populate some of resource fields  # noqa: E501

        :param secrets: The secrets of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :type: list[V1alpha1SecretParam]
        """

        self._secrets = secrets

    @property
    def type(self):
        """Gets the type of this V1alpha1PipelineResourceSpec.  # noqa: E501


        :return: The type of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this V1alpha1PipelineResourceSpec.


        :param type: The type of this V1alpha1PipelineResourceSpec.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1PipelineResourceSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1PipelineResourceSpec):
            return True

        return self.to_dict() != other.to_dict()
