"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __knownSymbol = (name, symbol) => (symbol = Symbol[name]) ? symbol : Symbol.for("Symbol." + name);
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result3 = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i3 = decorators.length - 1, decorator; i3 >= 0; i3--)
    if (decorator = decorators[i3])
      result3 = (kind ? decorator(target, key, result3) : decorator(result3)) || result3;
  if (kind && result3) __defProp(target, key, result3);
  return result3;
};
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});
var __using = (stack, value, async) => {
  if (value != null) {
    if (typeof value !== "object" && typeof value !== "function") __typeError("Object expected");
    var dispose, inner;
    if (async) dispose = value[__knownSymbol("asyncDispose")];
    if (dispose === void 0) {
      dispose = value[__knownSymbol("dispose")];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") __typeError("Object not disposable");
    if (inner) dispose = function() {
      try {
        inner.call(this);
      } catch (e3) {
        return Promise.reject(e3);
      }
    };
    stack.push([async, dispose, value]);
  } else if (async) {
    stack.push([async]);
  }
  return value;
};
var __callDispose = (stack, error5, hasError) => {
  var E2 = typeof SuppressedError === "function" ? SuppressedError : function(e3, s3, m3, _3) {
    return _3 = Error(m3), _3.name = "SuppressedError", _3.error = e3, _3.suppressed = s3, _3;
  };
  var fail = (e3) => error5 = hasError ? new E2(e3, error5, "An error was suppressed during disposal") : (hasError = true, e3);
  var next = (it) => {
    while (it = stack.pop()) {
      try {
        var result3 = it[1] && it[1].call(it[2]);
        if (it[0]) return Promise.resolve(result3).then(next, (e3) => (fail(e3), next()));
      } catch (e3) {
        fail(e3);
      }
    }
    if (hasError) throw error5;
  };
  return next();
};

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.ts
var ArtifactType;
var init_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.ts"() {
    "use strict";
    ArtifactType = /* @__PURE__ */ ((ArtifactType4) => {
      ArtifactType4["NONE"] = "none";
      ArtifactType4["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
      ArtifactType4["CDK_TREE"] = "cdk:tree";
      ArtifactType4["ASSET_MANIFEST"] = "cdk:asset-manifest";
      ArtifactType4["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
      return ArtifactType4;
    })(ArtifactType || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.ts
var ArtifactMetadataEntryType;
var init_metadata_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.ts"() {
    "use strict";
    ArtifactMetadataEntryType = /* @__PURE__ */ ((ArtifactMetadataEntryType6) => {
      ArtifactMetadataEntryType6["ASSET"] = "aws:cdk:asset";
      ArtifactMetadataEntryType6["INFO"] = "aws:cdk:info";
      ArtifactMetadataEntryType6["WARN"] = "aws:cdk:warning";
      ArtifactMetadataEntryType6["ERROR"] = "aws:cdk:error";
      ArtifactMetadataEntryType6["LOGICAL_ID"] = "aws:cdk:logicalId";
      ArtifactMetadataEntryType6["STACK_TAGS"] = "aws:cdk:stack-tags";
      ArtifactMetadataEntryType6["DO_NOT_REFACTOR"] = "aws:cdk:do-not-refactor";
      return ArtifactMetadataEntryType6;
    })(ArtifactMetadataEntryType || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.ts
var init_artifact_schema = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.ts
var ContextProvider, LoadBalancerType, LoadBalancerListenerProtocol;
var init_context_queries = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.ts"() {
    "use strict";
    ContextProvider = /* @__PURE__ */ ((ContextProvider3) => {
      ContextProvider3["AMI_PROVIDER"] = "ami";
      ContextProvider3["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
      ContextProvider3["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
      ContextProvider3["SSM_PARAMETER_PROVIDER"] = "ssm";
      ContextProvider3["VPC_PROVIDER"] = "vpc-provider";
      ContextProvider3["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
      ContextProvider3["LOAD_BALANCER_PROVIDER"] = "load-balancer";
      ContextProvider3["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
      ContextProvider3["SECURITY_GROUP_PROVIDER"] = "security-group";
      ContextProvider3["KEY_PROVIDER"] = "key-provider";
      ContextProvider3["CC_API_PROVIDER"] = "cc-api-provider";
      ContextProvider3["PLUGIN"] = "plugin";
      return ContextProvider3;
    })(ContextProvider || {});
    LoadBalancerType = /* @__PURE__ */ ((LoadBalancerType2) => {
      LoadBalancerType2["NETWORK"] = "network";
      LoadBalancerType2["APPLICATION"] = "application";
      return LoadBalancerType2;
    })(LoadBalancerType || {});
    LoadBalancerListenerProtocol = /* @__PURE__ */ ((LoadBalancerListenerProtocol2) => {
      LoadBalancerListenerProtocol2["HTTP"] = "HTTP";
      LoadBalancerListenerProtocol2["HTTPS"] = "HTTPS";
      LoadBalancerListenerProtocol2["TCP"] = "TCP";
      LoadBalancerListenerProtocol2["TLS"] = "TLS";
      LoadBalancerListenerProtocol2["UDP"] = "UDP";
      LoadBalancerListenerProtocol2["TCP_UDP"] = "TCP_UDP";
      return LoadBalancerListenerProtocol2;
    })(LoadBalancerListenerProtocol || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/interfaces.ts
var init_interfaces = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/interfaces.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.ts
var cloud_assembly_exports = {};
__export(cloud_assembly_exports, {
  ArtifactMetadataEntryType: () => ArtifactMetadataEntryType,
  ArtifactType: () => ArtifactType,
  ContextProvider: () => ContextProvider,
  LoadBalancerListenerProtocol: () => LoadBalancerListenerProtocol,
  LoadBalancerType: () => LoadBalancerType
});
var init_cloud_assembly = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.ts"() {
    "use strict";
    init_schema();
    init_metadata_schema();
    init_artifact_schema();
    init_context_queries();
    init_interfaces();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/schema.ts
var init_schema2 = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.ts
var init_docker_image_asset = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.ts
var FileAssetPackaging;
var init_file_asset = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.ts"() {
    "use strict";
    FileAssetPackaging = /* @__PURE__ */ ((FileAssetPackaging4) => {
      FileAssetPackaging4["FILE"] = "file";
      FileAssetPackaging4["ZIP_DIRECTORY"] = "zip";
      return FileAssetPackaging4;
    })(FileAssetPackaging || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.ts
var init_aws_destination = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/assets/index.ts
var assets_exports = {};
__export(assets_exports, {
  FileAssetPackaging: () => FileAssetPackaging
});
var init_assets = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/assets/index.ts"() {
    "use strict";
    init_schema2();
    init_docker_image_asset();
    init_file_asset();
    init_aws_destination();
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js
var require_helpers = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js"(exports2, module2) {
    "use strict";
    var uri = require("url");
    var ValidationError = exports2.ValidationError = function ValidationError2(message2, instance, schema, path34, name, argument) {
      if (Array.isArray(path34)) {
        this.path = path34;
        this.property = path34.reduce(function(sum3, item) {
          return sum3 + makeSuffix(item);
        }, "instance");
      } else if (path34 !== void 0) {
        this.property = path34;
      }
      if (message2) {
        this.message = message2;
      }
      if (schema) {
        var id = schema.$id || schema.id;
        this.schema = id || schema;
      }
      if (instance !== void 0) {
        this.instance = instance;
      }
      this.name = name;
      this.argument = argument;
      this.stack = this.toString();
    };
    ValidationError.prototype.toString = function toString() {
      return this.property + " " + this.message;
    };
    var ValidatorResult = exports2.ValidatorResult = function ValidatorResult2(instance, schema, options, ctx) {
      this.instance = instance;
      this.schema = schema;
      this.options = options;
      this.path = ctx.path;
      this.propertyPath = ctx.propertyPath;
      this.errors = [];
      this.throwError = options && options.throwError;
      this.throwFirst = options && options.throwFirst;
      this.throwAll = options && options.throwAll;
      this.disableFormat = options && options.disableFormat === true;
    };
    ValidatorResult.prototype.addError = function addError(detail) {
      var err;
      if (typeof detail == "string") {
        err = new ValidationError(detail, this.instance, this.schema, this.path);
      } else {
        if (!detail) throw new Error("Missing error detail");
        if (!detail.message) throw new Error("Missing error message");
        if (!detail.name) throw new Error("Missing validator type");
        err = new ValidationError(detail.message, this.instance, this.schema, this.path, detail.name, detail.argument);
      }
      this.errors.push(err);
      if (this.throwFirst) {
        throw new ValidatorResultError(this);
      } else if (this.throwError) {
        throw err;
      }
      return err;
    };
    ValidatorResult.prototype.importErrors = function importErrors(res) {
      if (typeof res == "string" || res && res.validatorType) {
        this.addError(res);
      } else if (res && res.errors) {
        this.errors = this.errors.concat(res.errors);
      }
    };
    function stringizer(v6, i3) {
      return i3 + ": " + v6.toString() + "\n";
    }
    ValidatorResult.prototype.toString = function toString(res) {
      return this.errors.map(stringizer).join("");
    };
    Object.defineProperty(ValidatorResult.prototype, "valid", { get: function() {
      return !this.errors.length;
    } });
    module2.exports.ValidatorResultError = ValidatorResultError;
    function ValidatorResultError(result3) {
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ValidatorResultError);
      }
      this.instance = result3.instance;
      this.schema = result3.schema;
      this.options = result3.options;
      this.errors = result3.errors;
    }
    ValidatorResultError.prototype = new Error();
    ValidatorResultError.prototype.constructor = ValidatorResultError;
    ValidatorResultError.prototype.name = "Validation Error";
    var SchemaError = exports2.SchemaError = function SchemaError2(msg, schema) {
      this.message = msg;
      this.schema = schema;
      Error.call(this, msg);
      Error.captureStackTrace(this, SchemaError2);
    };
    SchemaError.prototype = Object.create(
      Error.prototype,
      {
        constructor: { value: SchemaError, enumerable: false },
        name: { value: "SchemaError", enumerable: false }
      }
    );
    var SchemaContext = exports2.SchemaContext = function SchemaContext2(schema, options, path34, base, schemas) {
      this.schema = schema;
      this.options = options;
      if (Array.isArray(path34)) {
        this.path = path34;
        this.propertyPath = path34.reduce(function(sum3, item) {
          return sum3 + makeSuffix(item);
        }, "instance");
      } else {
        this.propertyPath = path34;
      }
      this.base = base;
      this.schemas = schemas;
    };
    SchemaContext.prototype.resolve = function resolve12(target) {
      return uri.resolve(this.base, target);
    };
    SchemaContext.prototype.makeChild = function makeChild(schema, propertyName) {
      var path34 = propertyName === void 0 ? this.path : this.path.concat([propertyName]);
      var id = schema.$id || schema.id;
      var base = uri.resolve(this.base, id || "");
      var ctx = new SchemaContext(schema, this.options, path34, base, Object.create(this.schemas));
      if (id && !ctx.schemas[base]) {
        ctx.schemas[base] = schema;
      }
      return ctx;
    };
    var FORMAT_REGEXPS = exports2.FORMAT_REGEXPS = {
      // 7.3.1. Dates, Times, and Duration
      "date-time": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,
      "date": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,
      "time": /^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,
      "duration": /P(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S)|\d+(D|M(\d+D)?|Y(\d+M(\d+D)?)?)(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S))?|\d+W)/i,
      // 7.3.2. Email Addresses
      // TODO: fix the email production
      "email": /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,
      "idn-email": /^("(?:[!#-\[\]-\u{10FFFF}]|\\[\t -\u{10FFFF}])*"|[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*)@([!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*|\[[!-Z\^-\u{10FFFF}]*\])$/u,
      // 7.3.3. Hostnames
      // 7.3.4. IP Addresses
      "ip-address": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      // FIXME whitespace is invalid
      "ipv6": /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,
      // 7.3.5. Resource Identifiers
      // TODO: A more accurate regular expression for "uri" goes:
      // [A-Za-z][+\-.0-9A-Za-z]*:((/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?)?#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])|/?%[0-9A-Fa-f]{2}|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*(#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?)?
      "uri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "uri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,
      "iri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "iri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~-\u{10FFFF}]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~-\u{10FFFF}])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/u,
      "uuid": /^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i,
      // 7.3.6. uri-template
      "uri-template": /(%[0-9a-f]{2}|[!#$&(-;=?@\[\]_a-z~]|\{[!#&+,./;=?@|]?(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?(,(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?)*\})*/iu,
      // 7.3.7. JSON Pointers
      "json-pointer": /^(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*$/iu,
      "relative-json-pointer": /^\d+(#|(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*)$/iu,
      // hostname regex from: http://stackoverflow.com/a/1420225/5628
      "hostname": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "host-name": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "utc-millisec": function(input) {
        return typeof input === "string" && parseFloat(input) === parseInt(input, 10) && !isNaN(input);
      },
      // 7.3.8. regex
      "regex": function(input) {
        var result3 = true;
        try {
          new RegExp(input);
        } catch (e3) {
          result3 = false;
        }
        return result3;
      },
      // Other definitions
      // "style" was removed from JSON Schema in draft-4 and is deprecated
      "style": /[\r\n\t ]*[^\r\n\t ][^:]*:[\r\n\t ]*[^\r\n\t ;]*[\r\n\t ]*;?/,
      // "color" was removed from JSON Schema in draft-4 and is deprecated
      "color": /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,
      "phone": /^\+(?:[0-9] ?){6,14}[0-9]$/,
      "alpha": /^[a-zA-Z]+$/,
      "alphanumeric": /^[a-zA-Z0-9]+$/
    };
    FORMAT_REGEXPS.regexp = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.pattern = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.ipv4 = FORMAT_REGEXPS["ip-address"];
    exports2.isFormat = function isFormat(input, format26, validator) {
      if (typeof input === "string" && FORMAT_REGEXPS[format26] !== void 0) {
        if (FORMAT_REGEXPS[format26] instanceof RegExp) {
          return FORMAT_REGEXPS[format26].test(input);
        }
        if (typeof FORMAT_REGEXPS[format26] === "function") {
          return FORMAT_REGEXPS[format26](input);
        }
      } else if (validator && validator.customFormats && typeof validator.customFormats[format26] === "function") {
        return validator.customFormats[format26](input);
      }
      return true;
    };
    var makeSuffix = exports2.makeSuffix = function makeSuffix2(key) {
      key = key.toString();
      if (!key.match(/[.\s\[\]]/) && !key.match(/^[\d]/)) {
        return "." + key;
      }
      if (key.match(/^\d+$/)) {
        return "[" + key + "]";
      }
      return "[" + JSON.stringify(key) + "]";
    };
    exports2.deepCompareStrict = function deepCompareStrict(a3, b3) {
      if (typeof a3 !== typeof b3) {
        return false;
      }
      if (Array.isArray(a3)) {
        if (!Array.isArray(b3)) {
          return false;
        }
        if (a3.length !== b3.length) {
          return false;
        }
        return a3.every(function(v6, i3) {
          return deepCompareStrict(a3[i3], b3[i3]);
        });
      }
      if (typeof a3 === "object") {
        if (!a3 || !b3) {
          return a3 === b3;
        }
        var aKeys = Object.keys(a3);
        var bKeys = Object.keys(b3);
        if (aKeys.length !== bKeys.length) {
          return false;
        }
        return aKeys.every(function(v6) {
          return deepCompareStrict(a3[v6], b3[v6]);
        });
      }
      return a3 === b3;
    };
    function deepMerger(target, dst, e3, i3) {
      if (typeof e3 === "object") {
        dst[i3] = deepMerge2(target[i3], e3);
      } else {
        if (target.indexOf(e3) === -1) {
          dst.push(e3);
        }
      }
    }
    function copyist(src, dst, key) {
      dst[key] = src[key];
    }
    function copyistWithDeepMerge(target, src, dst, key) {
      if (typeof src[key] !== "object" || !src[key]) {
        dst[key] = src[key];
      } else {
        if (!target[key]) {
          dst[key] = src[key];
        } else {
          dst[key] = deepMerge2(target[key], src[key]);
        }
      }
    }
    function deepMerge2(target, src) {
      var array = Array.isArray(src);
      var dst = array && [] || {};
      if (array) {
        target = target || [];
        dst = dst.concat(target);
        src.forEach(deepMerger.bind(null, target, dst));
      } else {
        if (target && typeof target === "object") {
          Object.keys(target).forEach(copyist.bind(null, target, dst));
        }
        Object.keys(src).forEach(copyistWithDeepMerge.bind(null, target, src, dst));
      }
      return dst;
    }
    module2.exports.deepMerge = deepMerge2;
    exports2.objectGetPath = function objectGetPath(o3, s3) {
      var parts = s3.split("/").slice(1);
      var k3;
      while (typeof (k3 = parts.shift()) == "string") {
        var n3 = decodeURIComponent(k3.replace(/~0/, "~").replace(/~1/g, "/"));
        if (!(n3 in o3)) return;
        o3 = o3[n3];
      }
      return o3;
    };
    function pathEncoder(v6) {
      return "/" + encodeURIComponent(v6).replace(/~/g, "%7E");
    }
    exports2.encodePath = function encodePointer(a3) {
      return a3.map(pathEncoder).join("");
    };
    exports2.getDecimalPlaces = function getDecimalPlaces(number) {
      var decimalPlaces = 0;
      if (isNaN(number)) return decimalPlaces;
      if (typeof number !== "number") {
        number = Number(number);
      }
      var parts = number.toString().split("e");
      if (parts.length === 2) {
        if (parts[1][0] !== "-") {
          return decimalPlaces;
        } else {
          decimalPlaces = Number(parts[1].slice(1));
        }
      }
      var decimalParts = parts[0].split(".");
      if (decimalParts.length === 2) {
        decimalPlaces += decimalParts[1].length;
      }
      return decimalPlaces;
    };
    exports2.isSchema = function isSchema(val2) {
      return typeof val2 === "object" && val2 || typeof val2 === "boolean";
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js
var require_attribute = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js"(exports2, module2) {
    "use strict";
    var helpers = require_helpers();
    var ValidatorResult = helpers.ValidatorResult;
    var SchemaError = helpers.SchemaError;
    var attribute = {};
    attribute.ignoreProperties = {
      // informative properties
      "id": true,
      "default": true,
      "description": true,
      "title": true,
      // arguments to other properties
      "additionalItems": true,
      "then": true,
      "else": true,
      // special-handled properties
      "$schema": true,
      "$ref": true,
      "extends": true
    };
    var validators = attribute.validators = {};
    validators.type = function validateType(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var types5 = Array.isArray(schema.type) ? schema.type : [schema.type];
      if (!types5.some(this.testType.bind(this, instance, schema, options, ctx))) {
        var list = types5.map(function(v6) {
          if (!v6) return;
          var id = v6.$id || v6.id;
          return id ? "<" + id + ">" : v6 + "";
        });
        result3.addError({
          name: "type",
          argument: list,
          message: "is not of a type(s) " + list
        });
      }
      return result3;
    };
    function testSchemaNoThrow(instance, options, ctx, callback, schema) {
      var throwError = options.throwError;
      var throwAll = options.throwAll;
      options.throwError = false;
      options.throwAll = false;
      var res = this.validateSchema(instance, schema, options, ctx);
      options.throwError = throwError;
      options.throwAll = throwAll;
      if (!res.valid && callback instanceof Function) {
        callback(res);
      }
      return res.valid;
    }
    validators.anyOf = function validateAnyOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      if (!Array.isArray(schema.anyOf)) {
        throw new SchemaError("anyOf must be an array");
      }
      if (!schema.anyOf.some(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      )) {
        var list = schema.anyOf.map(function(v6, i3) {
          var id = v6.$id || v6.id;
          if (id) return "<" + id + ">";
          return v6.title && JSON.stringify(v6.title) || v6["$ref"] && "<" + v6["$ref"] + ">" || "[subschema " + i3 + "]";
        });
        if (options.nestedErrors) {
          result3.importErrors(inner);
        }
        result3.addError({
          name: "anyOf",
          argument: list,
          message: "is not any of " + list.join(",")
        });
      }
      return result3;
    };
    validators.allOf = function validateAllOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.allOf)) {
        throw new SchemaError("allOf must be an array");
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var self2 = this;
      schema.allOf.forEach(function(v6, i3) {
        var valid3 = self2.validateSchema(instance, v6, options, ctx);
        if (!valid3.valid) {
          var id = v6.$id || v6.id;
          var msg = id || v6.title && JSON.stringify(v6.title) || v6["$ref"] && "<" + v6["$ref"] + ">" || "[subschema " + i3 + "]";
          result3.addError({
            name: "allOf",
            argument: { id: msg, length: valid3.errors.length, valid: valid3 },
            message: "does not match allOf schema " + msg + " with " + valid3.errors.length + " error[s]:"
          });
          result3.importErrors(valid3);
        }
      });
      return result3;
    };
    validators.oneOf = function validateOneOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.oneOf)) {
        throw new SchemaError("oneOf must be an array");
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      var count = schema.oneOf.filter(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      ).length;
      var list = schema.oneOf.map(function(v6, i3) {
        var id = v6.$id || v6.id;
        return id || v6.title && JSON.stringify(v6.title) || v6["$ref"] && "<" + v6["$ref"] + ">" || "[subschema " + i3 + "]";
      });
      if (count !== 1) {
        if (options.nestedErrors) {
          result3.importErrors(inner);
        }
        result3.addError({
          name: "oneOf",
          argument: list,
          message: "is not exactly one from " + list.join(",")
        });
      }
      return result3;
    };
    validators.if = function validateIf(instance, schema, options, ctx) {
      if (instance === void 0) return null;
      if (!helpers.isSchema(schema.if)) throw new Error('Expected "if" keyword to be a schema');
      var ifValid = testSchemaNoThrow.call(this, instance, options, ctx, null, schema.if);
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var res;
      if (ifValid) {
        if (schema.then === void 0) return;
        if (!helpers.isSchema(schema.then)) throw new Error('Expected "then" keyword to be a schema');
        res = this.validateSchema(instance, schema.then, options, ctx.makeChild(schema.then));
        result3.importErrors(res);
      } else {
        if (schema.else === void 0) return;
        if (!helpers.isSchema(schema.else)) throw new Error('Expected "else" keyword to be a schema');
        res = this.validateSchema(instance, schema.else, options, ctx.makeChild(schema.else));
        result3.importErrors(res);
      }
      return result3;
    };
    function getEnumerableProperty(object, key) {
      if (Object.hasOwnProperty.call(object, key)) return object[key];
      if (!(key in object)) return;
      while (object = Object.getPrototypeOf(object)) {
        if (Object.propertyIsEnumerable.call(object, key)) return object[key];
      }
    }
    validators.propertyNames = function validatePropertyNames(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var subschema = schema.propertyNames !== void 0 ? schema.propertyNames : {};
      if (!helpers.isSchema(subschema)) throw new SchemaError('Expected "propertyNames" to be a schema (object or boolean)');
      for (var property in instance) {
        if (getEnumerableProperty(instance, property) !== void 0) {
          var res = this.validateSchema(property, subschema, options, ctx.makeChild(subschema));
          result3.importErrors(res);
        }
      }
      return result3;
    };
    validators.properties = function validateProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var properties = schema.properties || {};
      for (var property in properties) {
        var subschema = properties[property];
        if (subschema === void 0) {
          continue;
        } else if (subschema === null) {
          throw new SchemaError('Unexpected null, expected schema in "properties"');
        }
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, subschema, options, ctx);
        }
        var prop = getEnumerableProperty(instance, property);
        var res = this.validateSchema(prop, subschema, options, ctx.makeChild(subschema, property));
        if (res.instance !== result3.instance[property]) result3.instance[property] = res.instance;
        result3.importErrors(res);
      }
      return result3;
    };
    function testAdditionalProperty(instance, schema, options, ctx, property, result3) {
      if (!this.types.object(instance)) return;
      if (schema.properties && schema.properties[property] !== void 0) {
        return;
      }
      if (schema.additionalProperties === false) {
        result3.addError({
          name: "additionalProperties",
          argument: property,
          message: "is not allowed to have the additional property " + JSON.stringify(property)
        });
      } else {
        var additionalProperties = schema.additionalProperties || {};
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, additionalProperties, options, ctx);
        }
        var res = this.validateSchema(instance[property], additionalProperties, options, ctx.makeChild(additionalProperties, property));
        if (res.instance !== result3.instance[property]) result3.instance[property] = res.instance;
        result3.importErrors(res);
      }
    }
    validators.patternProperties = function validatePatternProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var patternProperties = schema.patternProperties || {};
      for (var property in instance) {
        var test = true;
        for (var pattern in patternProperties) {
          var subschema = patternProperties[pattern];
          if (subschema === void 0) {
            continue;
          } else if (subschema === null) {
            throw new SchemaError('Unexpected null, expected schema in "patternProperties"');
          }
          try {
            var regexp = new RegExp(pattern, "u");
          } catch (_e) {
            regexp = new RegExp(pattern);
          }
          if (!regexp.test(property)) {
            continue;
          }
          test = false;
          if (typeof options.preValidateProperty == "function") {
            options.preValidateProperty(instance, property, subschema, options, ctx);
          }
          var res = this.validateSchema(instance[property], subschema, options, ctx.makeChild(subschema, property));
          if (res.instance !== result3.instance[property]) result3.instance[property] = res.instance;
          result3.importErrors(res);
        }
        if (test) {
          testAdditionalProperty.call(this, instance, schema, options, ctx, property, result3);
        }
      }
      return result3;
    };
    validators.additionalProperties = function validateAdditionalProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      if (schema.patternProperties) {
        return null;
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      for (var property in instance) {
        testAdditionalProperty.call(this, instance, schema, options, ctx, property, result3);
      }
      return result3;
    };
    validators.minProperties = function validateMinProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length >= schema.minProperties)) {
        result3.addError({
          name: "minProperties",
          argument: schema.minProperties,
          message: "does not meet minimum property length of " + schema.minProperties
        });
      }
      return result3;
    };
    validators.maxProperties = function validateMaxProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length <= schema.maxProperties)) {
        result3.addError({
          name: "maxProperties",
          argument: schema.maxProperties,
          message: "does not meet maximum property length of " + schema.maxProperties
        });
      }
      return result3;
    };
    validators.items = function validateItems(instance, schema, options, ctx) {
      var self2 = this;
      if (!this.types.array(instance)) return;
      if (schema.items === void 0) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      instance.every(function(value, i3) {
        if (Array.isArray(schema.items)) {
          var items = schema.items[i3] === void 0 ? schema.additionalItems : schema.items[i3];
        } else {
          var items = schema.items;
        }
        if (items === void 0) {
          return true;
        }
        if (items === false) {
          result3.addError({
            name: "items",
            message: "additionalItems not permitted"
          });
          return false;
        }
        var res = self2.validateSchema(value, items, options, ctx.makeChild(items, i3));
        if (res.instance !== result3.instance[i3]) result3.instance[i3] = res.instance;
        result3.importErrors(res);
        return true;
      });
      return result3;
    };
    validators.contains = function validateContains(instance, schema, options, ctx) {
      var self2 = this;
      if (!this.types.array(instance)) return;
      if (schema.contains === void 0) return;
      if (!helpers.isSchema(schema.contains)) throw new Error('Expected "contains" keyword to be a schema');
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var count = instance.some(function(value, i3) {
        var res = self2.validateSchema(value, schema.contains, options, ctx.makeChild(schema.contains, i3));
        return res.errors.length === 0;
      });
      if (count === false) {
        result3.addError({
          name: "contains",
          argument: schema.contains,
          message: "must contain an item matching given schema"
        });
      }
      return result3;
    };
    validators.minimum = function validateMinimum(instance, schema, options, ctx) {
      if (!this.types.number(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMinimum && schema.exclusiveMinimum === true) {
        if (!(instance > schema.minimum)) {
          result3.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than " + schema.minimum
          });
        }
      } else {
        if (!(instance >= schema.minimum)) {
          result3.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than or equal to " + schema.minimum
          });
        }
      }
      return result3;
    };
    validators.maximum = function validateMaximum(instance, schema, options, ctx) {
      if (!this.types.number(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMaximum && schema.exclusiveMaximum === true) {
        if (!(instance < schema.maximum)) {
          result3.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than " + schema.maximum
          });
        }
      } else {
        if (!(instance <= schema.maximum)) {
          result3.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than or equal to " + schema.maximum
          });
        }
      }
      return result3;
    };
    validators.exclusiveMinimum = function validateExclusiveMinimum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMinimum === "boolean") return;
      if (!this.types.number(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var valid3 = instance > schema.exclusiveMinimum;
      if (!valid3) {
        result3.addError({
          name: "exclusiveMinimum",
          argument: schema.exclusiveMinimum,
          message: "must be strictly greater than " + schema.exclusiveMinimum
        });
      }
      return result3;
    };
    validators.exclusiveMaximum = function validateExclusiveMaximum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean") return;
      if (!this.types.number(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var valid3 = instance < schema.exclusiveMaximum;
      if (!valid3) {
        result3.addError({
          name: "exclusiveMaximum",
          argument: schema.exclusiveMaximum,
          message: "must be strictly less than " + schema.exclusiveMaximum
        });
      }
      return result3;
    };
    var validateMultipleOfOrDivisbleBy = function validateMultipleOfOrDivisbleBy2(instance, schema, options, ctx, validationType, errorMessage) {
      if (!this.types.number(instance)) return;
      var validationArgument = schema[validationType];
      if (validationArgument == 0) {
        throw new SchemaError(validationType + " cannot be zero");
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var instanceDecimals = helpers.getDecimalPlaces(instance);
      var divisorDecimals = helpers.getDecimalPlaces(validationArgument);
      var maxDecimals = Math.max(instanceDecimals, divisorDecimals);
      var multiplier = Math.pow(10, maxDecimals);
      if (Math.round(instance * multiplier) % Math.round(validationArgument * multiplier) !== 0) {
        result3.addError({
          name: validationType,
          argument: validationArgument,
          message: errorMessage + JSON.stringify(validationArgument)
        });
      }
      return result3;
    };
    validators.multipleOf = function validateMultipleOf(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "multipleOf", "is not a multiple of (divisible by) ");
    };
    validators.divisibleBy = function validateDivisibleBy(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "divisibleBy", "is not divisible by (multiple of) ");
    };
    validators.required = function validateRequired(instance, schema, options, ctx) {
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (instance === void 0 && schema.required === true) {
        result3.addError({
          name: "required",
          message: "is required"
        });
      } else if (this.types.object(instance) && Array.isArray(schema.required)) {
        schema.required.forEach(function(n3) {
          if (getEnumerableProperty(instance, n3) === void 0) {
            result3.addError({
              name: "required",
              argument: n3,
              message: "requires property " + JSON.stringify(n3)
            });
          }
        });
      }
      return result3;
    };
    validators.pattern = function validatePattern(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var pattern = schema.pattern;
      try {
        var regexp = new RegExp(pattern, "u");
      } catch (_e) {
        regexp = new RegExp(pattern);
      }
      if (!instance.match(regexp)) {
        result3.addError({
          name: "pattern",
          argument: schema.pattern,
          message: "does not match pattern " + JSON.stringify(schema.pattern.toString())
        });
      }
      return result3;
    };
    validators.format = function validateFormat(instance, schema, options, ctx) {
      if (instance === void 0) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!result3.disableFormat && !helpers.isFormat(instance, schema.format, this)) {
        result3.addError({
          name: "format",
          argument: schema.format,
          message: "does not conform to the " + JSON.stringify(schema.format) + " format"
        });
      }
      return result3;
    };
    validators.minLength = function validateMinLength(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length >= schema.minLength)) {
        result3.addError({
          name: "minLength",
          argument: schema.minLength,
          message: "does not meet minimum length of " + schema.minLength
        });
      }
      return result3;
    };
    validators.maxLength = function validateMaxLength(instance, schema, options, ctx) {
      if (!this.types.string(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length <= schema.maxLength)) {
        result3.addError({
          name: "maxLength",
          argument: schema.maxLength,
          message: "does not meet maximum length of " + schema.maxLength
        });
      }
      return result3;
    };
    validators.minItems = function validateMinItems(instance, schema, options, ctx) {
      if (!this.types.array(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length >= schema.minItems)) {
        result3.addError({
          name: "minItems",
          argument: schema.minItems,
          message: "does not meet minimum length of " + schema.minItems
        });
      }
      return result3;
    };
    validators.maxItems = function validateMaxItems(instance, schema, options, ctx) {
      if (!this.types.array(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length <= schema.maxItems)) {
        result3.addError({
          name: "maxItems",
          argument: schema.maxItems,
          message: "does not meet maximum length of " + schema.maxItems
        });
      }
      return result3;
    };
    function testArrays(v6, i3, a3) {
      var j3, len = a3.length;
      for (j3 = i3 + 1, len; j3 < len; j3++) {
        if (helpers.deepCompareStrict(v6, a3[j3])) {
          return false;
        }
      }
      return true;
    }
    validators.uniqueItems = function validateUniqueItems(instance, schema, options, ctx) {
      if (schema.uniqueItems !== true) return;
      if (!this.types.array(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!instance.every(testArrays)) {
        result3.addError({
          name: "uniqueItems",
          message: "contains duplicate item"
        });
      }
      return result3;
    };
    validators.dependencies = function validateDependencies(instance, schema, options, ctx) {
      if (!this.types.object(instance)) return;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      for (var property in schema.dependencies) {
        if (instance[property] === void 0) {
          continue;
        }
        var dep = schema.dependencies[property];
        var childContext = ctx.makeChild(dep, property);
        if (typeof dep == "string") {
          dep = [dep];
        }
        if (Array.isArray(dep)) {
          dep.forEach(function(prop) {
            if (instance[prop] === void 0) {
              result3.addError({
                // FIXME there's two different "dependencies" errors here with slightly different outputs
                // Can we make these the same? Or should we create different error types?
                name: "dependencies",
                argument: childContext.propertyPath,
                message: "property " + prop + " not found, required by " + childContext.propertyPath
              });
            }
          });
        } else {
          var res = this.validateSchema(instance, dep, options, childContext);
          if (result3.instance !== res.instance) result3.instance = res.instance;
          if (res && res.errors.length) {
            result3.addError({
              name: "dependencies",
              argument: childContext.propertyPath,
              message: "does not meet dependency required by " + childContext.propertyPath
            });
            result3.importErrors(res);
          }
        }
      }
      return result3;
    };
    validators["enum"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema["enum"])) {
        throw new SchemaError("enum expects an array", schema);
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!schema["enum"].some(helpers.deepCompareStrict.bind(null, instance))) {
        result3.addError({
          name: "enum",
          argument: schema["enum"],
          message: "is not one of enum values: " + schema["enum"].map(String).join(",")
        });
      }
      return result3;
    };
    validators["const"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (!helpers.deepCompareStrict(schema["const"], instance)) {
        result3.addError({
          name: "const",
          argument: schema["const"],
          message: "does not exactly match expected constant: " + schema["const"]
        });
      }
      return result3;
    };
    validators.not = validators.disallow = function validateNot(instance, schema, options, ctx) {
      var self2 = this;
      if (instance === void 0) return null;
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      var notTypes = schema.not || schema.disallow;
      if (!notTypes) return null;
      if (!Array.isArray(notTypes)) notTypes = [notTypes];
      notTypes.forEach(function(type) {
        if (self2.testType(instance, schema, options, ctx, type)) {
          var id = type && (type.$id || type.id);
          var schemaId = id || type;
          result3.addError({
            name: "not",
            argument: schemaId,
            message: "is of prohibited type " + schemaId
          });
        }
      });
      return result3;
    };
    module2.exports = attribute;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js
var require_scan = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js"(exports2, module2) {
    "use strict";
    var urilib = require("url");
    var helpers = require_helpers();
    module2.exports.SchemaScanResult = SchemaScanResult;
    function SchemaScanResult(found, ref) {
      this.id = found;
      this.ref = ref;
    }
    module2.exports.scan = function scan(base, schema) {
      function scanSchema(baseuri, schema2) {
        if (!schema2 || typeof schema2 != "object") return;
        if (schema2.$ref) {
          var resolvedUri = urilib.resolve(baseuri, schema2.$ref);
          ref[resolvedUri] = ref[resolvedUri] ? ref[resolvedUri] + 1 : 0;
          return;
        }
        var id = schema2.$id || schema2.id;
        var ourBase = id ? urilib.resolve(baseuri, id) : baseuri;
        if (ourBase) {
          if (ourBase.indexOf("#") < 0) ourBase += "#";
          if (found[ourBase]) {
            if (!helpers.deepCompareStrict(found[ourBase], schema2)) {
              throw new Error("Schema <" + ourBase + "> already exists with different definition");
            }
            return found[ourBase];
          }
          found[ourBase] = schema2;
          if (ourBase[ourBase.length - 1] == "#") {
            found[ourBase.substring(0, ourBase.length - 1)] = schema2;
          }
        }
        scanArray(ourBase + "/items", Array.isArray(schema2.items) ? schema2.items : [schema2.items]);
        scanArray(ourBase + "/extends", Array.isArray(schema2.extends) ? schema2.extends : [schema2.extends]);
        scanSchema(ourBase + "/additionalItems", schema2.additionalItems);
        scanObject(ourBase + "/properties", schema2.properties);
        scanSchema(ourBase + "/additionalProperties", schema2.additionalProperties);
        scanObject(ourBase + "/definitions", schema2.definitions);
        scanObject(ourBase + "/patternProperties", schema2.patternProperties);
        scanObject(ourBase + "/dependencies", schema2.dependencies);
        scanArray(ourBase + "/disallow", schema2.disallow);
        scanArray(ourBase + "/allOf", schema2.allOf);
        scanArray(ourBase + "/anyOf", schema2.anyOf);
        scanArray(ourBase + "/oneOf", schema2.oneOf);
        scanSchema(ourBase + "/not", schema2.not);
      }
      function scanArray(baseuri, schemas) {
        if (!Array.isArray(schemas)) return;
        for (var i3 = 0; i3 < schemas.length; i3++) {
          scanSchema(baseuri + "/" + i3, schemas[i3]);
        }
      }
      function scanObject(baseuri, schemas) {
        if (!schemas || typeof schemas != "object") return;
        for (var p3 in schemas) {
          scanSchema(baseuri + "/" + p3, schemas[p3]);
        }
      }
      var found = {};
      var ref = {};
      scanSchema(base, schema);
      return new SchemaScanResult(found, ref);
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js
var require_validator = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js"(exports2, module2) {
    "use strict";
    var urilib = require("url");
    var attribute = require_attribute();
    var helpers = require_helpers();
    var scanSchema = require_scan().scan;
    var ValidatorResult = helpers.ValidatorResult;
    var ValidatorResultError = helpers.ValidatorResultError;
    var SchemaError = helpers.SchemaError;
    var SchemaContext = helpers.SchemaContext;
    var anonymousBase = "/";
    var Validator2 = function Validator3() {
      this.customFormats = Object.create(Validator3.prototype.customFormats);
      this.schemas = {};
      this.unresolvedRefs = [];
      this.types = Object.create(types5);
      this.attributes = Object.create(attribute.validators);
    };
    Validator2.prototype.customFormats = {};
    Validator2.prototype.schemas = null;
    Validator2.prototype.types = null;
    Validator2.prototype.attributes = null;
    Validator2.prototype.unresolvedRefs = null;
    Validator2.prototype.addSchema = function addSchema(schema, base) {
      var self2 = this;
      if (!schema) {
        return null;
      }
      var scan = scanSchema(base || anonymousBase, schema);
      var ourUri = base || schema.$id || schema.id;
      for (var uri in scan.id) {
        this.schemas[uri] = scan.id[uri];
      }
      for (var uri in scan.ref) {
        this.unresolvedRefs.push(uri);
      }
      this.unresolvedRefs = this.unresolvedRefs.filter(function(uri2) {
        return typeof self2.schemas[uri2] === "undefined";
      });
      return this.schemas[ourUri];
    };
    Validator2.prototype.addSubSchemaArray = function addSubSchemaArray(baseuri, schemas) {
      if (!Array.isArray(schemas)) return;
      for (var i3 = 0; i3 < schemas.length; i3++) {
        this.addSubSchema(baseuri, schemas[i3]);
      }
    };
    Validator2.prototype.addSubSchemaObject = function addSubSchemaArray(baseuri, schemas) {
      if (!schemas || typeof schemas != "object") return;
      for (var p3 in schemas) {
        this.addSubSchema(baseuri, schemas[p3]);
      }
    };
    Validator2.prototype.setSchemas = function setSchemas(schemas) {
      this.schemas = schemas;
    };
    Validator2.prototype.getSchema = function getSchema(urn) {
      return this.schemas[urn];
    };
    Validator2.prototype.validate = function validate2(instance, schema, options, ctx) {
      if (typeof schema !== "boolean" && typeof schema !== "object" || schema === null) {
        throw new SchemaError("Expected `schema` to be an object or boolean");
      }
      if (!options) {
        options = {};
      }
      var id = schema.$id || schema.id;
      var base = urilib.resolve(options.base || anonymousBase, id || "");
      if (!ctx) {
        ctx = new SchemaContext(schema, options, [], base, Object.create(this.schemas));
        if (!ctx.schemas[base]) {
          ctx.schemas[base] = schema;
        }
        var found = scanSchema(base, schema);
        for (var n3 in found.id) {
          var sch = found.id[n3];
          ctx.schemas[n3] = sch;
        }
      }
      if (options.required && instance === void 0) {
        var result3 = new ValidatorResult(instance, schema, options, ctx);
        result3.addError("is required, but is undefined");
        return result3;
      }
      var result3 = this.validateSchema(instance, schema, options, ctx);
      if (!result3) {
        throw new Error("Result undefined");
      } else if (options.throwAll && result3.errors.length) {
        throw new ValidatorResultError(result3);
      }
      return result3;
    };
    function shouldResolve(schema) {
      var ref = typeof schema === "string" ? schema : schema.$ref;
      if (typeof ref == "string") return ref;
      return false;
    }
    Validator2.prototype.validateSchema = function validateSchema(instance, schema, options, ctx) {
      var result3 = new ValidatorResult(instance, schema, options, ctx);
      if (typeof schema === "boolean") {
        if (schema === true) {
          schema = {};
        } else if (schema === false) {
          schema = { type: [] };
        }
      } else if (!schema) {
        throw new Error("schema is undefined");
      }
      if (schema["extends"]) {
        if (Array.isArray(schema["extends"])) {
          var schemaobj = { schema, ctx };
          schema["extends"].forEach(this.schemaTraverser.bind(this, schemaobj));
          schema = schemaobj.schema;
          schemaobj.schema = null;
          schemaobj.ctx = null;
          schemaobj = null;
        } else {
          schema = helpers.deepMerge(schema, this.superResolve(schema["extends"], ctx));
        }
      }
      var switchSchema = shouldResolve(schema);
      if (switchSchema) {
        var resolved = this.resolve(schema, switchSchema, ctx);
        var subctx = new SchemaContext(resolved.subschema, options, ctx.path, resolved.switchSchema, ctx.schemas);
        return this.validateSchema(instance, resolved.subschema, options, subctx);
      }
      var skipAttributes = options && options.skipAttributes || [];
      for (var key in schema) {
        if (!attribute.ignoreProperties[key] && skipAttributes.indexOf(key) < 0) {
          var validatorErr = null;
          var validator = this.attributes[key];
          if (validator) {
            validatorErr = validator.call(this, instance, schema, options, ctx);
          } else if (options.allowUnknownAttributes === false) {
            throw new SchemaError("Unsupported attribute: " + key, schema);
          }
          if (validatorErr) {
            result3.importErrors(validatorErr);
          }
        }
      }
      if (typeof options.rewrite == "function") {
        var value = options.rewrite.call(this, instance, schema, options, ctx);
        result3.instance = value;
      }
      return result3;
    };
    Validator2.prototype.schemaTraverser = function schemaTraverser(schemaobj, s3) {
      schemaobj.schema = helpers.deepMerge(schemaobj.schema, this.superResolve(s3, schemaobj.ctx));
    };
    Validator2.prototype.superResolve = function superResolve(schema, ctx) {
      var ref = shouldResolve(schema);
      if (ref) {
        return this.resolve(schema, ref, ctx).subschema;
      }
      return schema;
    };
    Validator2.prototype.resolve = function resolve12(schema, switchSchema, ctx) {
      switchSchema = ctx.resolve(switchSchema);
      if (ctx.schemas[switchSchema]) {
        return { subschema: ctx.schemas[switchSchema], switchSchema };
      }
      var parsed = urilib.parse(switchSchema);
      var fragment = parsed && parsed.hash;
      var document2 = fragment && fragment.length && switchSchema.substr(0, switchSchema.length - fragment.length);
      if (!document2 || !ctx.schemas[document2]) {
        throw new SchemaError("no such schema <" + switchSchema + ">", schema);
      }
      var subschema = helpers.objectGetPath(ctx.schemas[document2], fragment.substr(1));
      if (subschema === void 0) {
        throw new SchemaError("no such schema " + fragment + " located in <" + document2 + ">", schema);
      }
      return { subschema, switchSchema };
    };
    Validator2.prototype.testType = function validateType(instance, schema, options, ctx, type) {
      if (type === void 0) {
        return;
      } else if (type === null) {
        throw new SchemaError('Unexpected null in "type" keyword');
      }
      if (typeof this.types[type] == "function") {
        return this.types[type].call(this, instance);
      }
      if (type && typeof type == "object") {
        var res = this.validateSchema(instance, type, options, ctx);
        return res === void 0 || !(res && res.errors.length);
      }
      return true;
    };
    var types5 = Validator2.prototype.types = {};
    types5.string = function testString(instance) {
      return typeof instance == "string";
    };
    types5.number = function testNumber(instance) {
      return typeof instance == "number" && isFinite(instance);
    };
    types5.integer = function testInteger(instance) {
      return typeof instance == "number" && instance % 1 === 0;
    };
    types5.boolean = function testBoolean(instance) {
      return typeof instance == "boolean";
    };
    types5.array = function testArray(instance) {
      return Array.isArray(instance);
    };
    types5["null"] = function testNull(instance) {
      return instance === null;
    };
    types5.date = function testDate(instance) {
      return instance instanceof Date;
    };
    types5.any = function testAny(instance) {
      return true;
    };
    types5.object = function testObject(instance) {
      return instance && typeof instance === "object" && !Array.isArray(instance) && !(instance instanceof Date);
    };
    module2.exports = Validator2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js
var require_lib = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js"(exports2, module2) {
    "use strict";
    var Validator2 = module2.exports.Validator = require_validator();
    module2.exports.ValidatorResult = require_helpers().ValidatorResult;
    module2.exports.ValidatorResultError = require_helpers().ValidatorResultError;
    module2.exports.ValidationError = require_helpers().ValidationError;
    module2.exports.SchemaError = require_helpers().SchemaError;
    module2.exports.SchemaScanResult = require_scan().SchemaScanResult;
    module2.exports.scan = require_scan().scan;
    module2.exports.validate = function(instance, schema, options) {
      var v6 = new Validator2();
      return v6.validate(instance, schema, options);
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js"(exports2, module2) {
    "use strict";
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
    9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
    var RELEASE_TYPES = [
      "major",
      "premajor",
      "minor",
      "preminor",
      "patch",
      "prepatch",
      "prerelease"
    ];
    module2.exports = {
      MAX_LENGTH,
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_SAFE_INTEGER,
      RELEASE_TYPES,
      SEMVER_SPEC_VERSION,
      FLAG_INCLUDE_PRERELEASE: 1,
      FLAG_LOOSE: 2
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js"(exports2, module2) {
    "use strict";
    var debug4 = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug4;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js
var require_re = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js"(exports2, module2) {
    "use strict";
    var {
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_LENGTH
    } = require_constants();
    var debug4 = require_debug();
    exports2 = module2.exports = {};
    var re = exports2.re = [];
    var safeRe = exports2.safeRe = [];
    var src = exports2.src = [];
    var safeSrc = exports2.safeSrc = [];
    var t3 = exports2.t = {};
    var R = 0;
    var LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    var safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]
    ];
    var makeSafeRegex = (value) => {
      for (const [token, max] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
      }
      return value;
    };
    var createToken = (name, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index = R++;
      debug4(name, index, value);
      t3[name] = index;
      src[index] = value;
      safeSrc[index] = safe;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src[t3.NUMERICIDENTIFIER]})\\.(${src[t3.NUMERICIDENTIFIER]})\\.(${src[t3.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t3.NUMERICIDENTIFIERLOOSE]})\\.(${src[t3.NUMERICIDENTIFIERLOOSE]})\\.(${src[t3.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t3.NONNUMERICIDENTIFIER]}|${src[t3.NUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t3.NONNUMERICIDENTIFIER]}|${src[t3.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASE", `(?:-(${src[t3.PRERELEASEIDENTIFIER]}(?:\\.${src[t3.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t3.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t3.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src[t3.BUILDIDENTIFIER]}(?:\\.${src[t3.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t3.MAINVERSION]}${src[t3.PRERELEASE]}?${src[t3.BUILD]}?`);
    createToken("FULL", `^${src[t3.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t3.MAINVERSIONLOOSE]}${src[t3.PRERELEASELOOSE]}?${src[t3.BUILD]}?`);
    createToken("LOOSE", `^${src[t3.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t3.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t3.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t3.XRANGEIDENTIFIER]})(?:\\.(${src[t3.XRANGEIDENTIFIER]})(?:\\.(${src[t3.XRANGEIDENTIFIER]})(?:${src[t3.PRERELEASE]})?${src[t3.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t3.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t3.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t3.XRANGEIDENTIFIERLOOSE]})(?:${src[t3.PRERELEASELOOSE]})?${src[t3.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t3.GTLT]}\\s*${src[t3.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t3.GTLT]}\\s*${src[t3.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
    createToken("COERCE", `${src[t3.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src[t3.COERCEPLAIN] + `(?:${src[t3.PRERELEASE]})?(?:${src[t3.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t3.COERCE], true);
    createToken("COERCERTLFULL", src[t3.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t3.LONETILDE]}\\s+`, true);
    exports2.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t3.LONETILDE]}${src[t3.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t3.LONETILDE]}${src[t3.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t3.LONECARET]}\\s+`, true);
    exports2.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t3.LONECARET]}${src[t3.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t3.LONECARET]}${src[t3.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t3.GTLT]}\\s*(${src[t3.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t3.GTLT]}\\s*(${src[t3.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t3.GTLT]}\\s*(${src[t3.LOOSEPLAIN]}|${src[t3.XRANGEPLAIN]})`, true);
    exports2.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t3.XRANGEPLAIN]})\\s+-\\s+(${src[t3.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t3.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t3.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js"(exports2, module2) {
    "use strict";
    var looseOption = Object.freeze({ loose: true });
    var emptyOpts = Object.freeze({});
    var parseOptions = (options) => {
      if (!options) {
        return emptyOpts;
      }
      if (typeof options !== "object") {
        return looseOption;
      }
      return options;
    };
    module2.exports = parseOptions;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js"(exports2, module2) {
    "use strict";
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a3, b3) => {
      const anum = numeric.test(a3);
      const bnum = numeric.test(b3);
      if (anum && bnum) {
        a3 = +a3;
        b3 = +b3;
      }
      return a3 === b3 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a3 < b3 ? -1 : 1;
    };
    var rcompareIdentifiers = (a3, b3) => compareIdentifiers(b3, a3);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js"(exports2, module2) {
    "use strict";
    var debug4 = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { safeRe: re, t: t3 } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class _SemVer {
      constructor(version2, options) {
        options = parseOptions(options);
        if (version2 instanceof _SemVer) {
          if (version2.loose === !!options.loose && version2.includePrerelease === !!options.includePrerelease) {
            return version2;
          } else {
            version2 = version2.version;
          }
        } else if (typeof version2 !== "string") {
          throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version2}".`);
        }
        if (version2.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug4("SemVer", version2, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m3 = version2.trim().match(options.loose ? re[t3.LOOSE] : re[t3.FULL]);
        if (!m3) {
          throw new TypeError(`Invalid Version: ${version2}`);
        }
        this.raw = version2;
        this.major = +m3[1];
        this.minor = +m3[2];
        this.patch = +m3[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m3[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m3[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m3[5] ? m3[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug4("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof _SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new _SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
      }
      comparePre(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i3 = 0;
        do {
          const a3 = this.prerelease[i3];
          const b3 = other.prerelease[i3];
          debug4("prerelease compare", i3, a3, b3);
          if (a3 === void 0 && b3 === void 0) {
            return 0;
          } else if (b3 === void 0) {
            return 1;
          } else if (a3 === void 0) {
            return -1;
          } else if (a3 === b3) {
            continue;
          } else {
            return compareIdentifiers(a3, b3);
          }
        } while (++i3);
      }
      compareBuild(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        let i3 = 0;
        do {
          const a3 = this.build[i3];
          const b3 = other.build[i3];
          debug4("build compare", i3, a3, b3);
          if (a3 === void 0 && b3 === void 0) {
            return 0;
          } else if (b3 === void 0) {
            return 1;
          } else if (a3 === void 0) {
            return -1;
          } else if (a3 === b3) {
            continue;
          } else {
            return compareIdentifiers(a3, b3);
          }
        } while (++i3);
      }
      // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.
      inc(release2, identifier, identifierBase) {
        if (release2.startsWith("pre")) {
          if (!identifier && identifierBase === false) {
            throw new Error("invalid increment argument: identifier is empty");
          }
          if (identifier) {
            const match4 = `-${identifier}`.match(this.options.loose ? re[t3.PRERELEASELOOSE] : re[t3.PRERELEASE]);
            if (!match4 || match4[1] !== identifier) {
              throw new Error(`invalid identifier: ${identifier}`);
            }
          }
        }
        switch (release2) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier, identifierBase);
            this.inc("pre", identifier, identifierBase);
            break;
          // If the input is a non-prerelease version, this acts the same as
          // prepatch.
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier, identifierBase);
            }
            this.inc("pre", identifier, identifierBase);
            break;
          case "release":
            if (this.prerelease.length === 0) {
              throw new Error(`version ${this.raw} is not a prerelease`);
            }
            this.prerelease.length = 0;
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          // This probably shouldn't be used publicly.
          // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
          case "pre": {
            const base = Number(identifierBase) ? 1 : 0;
            if (this.prerelease.length === 0) {
              this.prerelease = [base];
            } else {
              let i3 = this.prerelease.length;
              while (--i3 >= 0) {
                if (typeof this.prerelease[i3] === "number") {
                  this.prerelease[i3]++;
                  i3 = -2;
                }
              }
              if (i3 === -1) {
                if (identifier === this.prerelease.join(".") && identifierBase === false) {
                  throw new Error("invalid increment argument: identifier already exists");
                }
                this.prerelease.push(base);
              }
            }
            if (identifier) {
              let prerelease = [identifier, base];
              if (identifierBase === false) {
                prerelease = [identifier];
              }
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = prerelease;
                }
              } else {
                this.prerelease = prerelease;
              }
            }
            break;
          }
          default:
            throw new Error(`invalid increment argument: ${release2}`);
        }
        this.raw = this.format();
        if (this.build.length) {
          this.raw += `+${this.build.join(".")}`;
        }
        return this;
      }
    };
    module2.exports = SemVer;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse3 = (version2, options, throwErrors = false) => {
      if (version2 instanceof SemVer) {
        return version2;
      }
      try {
        return new SemVer(version2, options);
      } catch (er) {
        if (!throwErrors) {
          return null;
        }
        throw er;
      }
    };
    module2.exports = parse3;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var valid3 = (version2, options) => {
      const v6 = parse3(version2, options);
      return v6 ? v6.version : null;
    };
    module2.exports = valid3;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var clean = (version2, options) => {
      const s3 = parse3(version2.trim().replace(/^[=v]+/, ""), options);
      return s3 ? s3.version : null;
    };
    module2.exports = clean;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var inc = (version2, release2, options, identifier, identifierBase) => {
      if (typeof options === "string") {
        identifierBase = identifier;
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer(
          version2 instanceof SemVer ? version2.version : version2,
          options
        ).inc(release2, identifier, identifierBase).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var diff = (version1, version2) => {
      const v12 = parse3(version1, null, true);
      const v22 = parse3(version2, null, true);
      const comparison = v12.compare(v22);
      if (comparison === 0) {
        return null;
      }
      const v1Higher = comparison > 0;
      const highVersion = v1Higher ? v12 : v22;
      const lowVersion = v1Higher ? v22 : v12;
      const highHasPre = !!highVersion.prerelease.length;
      const lowHasPre = !!lowVersion.prerelease.length;
      if (lowHasPre && !highHasPre) {
        if (!lowVersion.patch && !lowVersion.minor) {
          return "major";
        }
        if (lowVersion.compareMain(highVersion) === 0) {
          if (lowVersion.minor && !lowVersion.patch) {
            return "minor";
          }
          return "patch";
        }
      }
      const prefix2 = highHasPre ? "pre" : "";
      if (v12.major !== v22.major) {
        return prefix2 + "major";
      }
      if (v12.minor !== v22.minor) {
        return prefix2 + "minor";
      }
      if (v12.patch !== v22.patch) {
        return prefix2 + "patch";
      }
      return "prerelease";
    };
    module2.exports = diff;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js
var require_major = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var major6 = (a3, loose) => new SemVer(a3, loose).major;
    module2.exports = major6;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var minor = (a3, loose) => new SemVer(a3, loose).minor;
    module2.exports = minor;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var patch = (a3, loose) => new SemVer(a3, loose).patch;
    module2.exports = patch;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var prerelease = (version2, options) => {
      const parsed = parse3(version2, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compare2 = (a3, b3, loose) => new SemVer(a3, loose).compare(new SemVer(b3, loose));
    module2.exports = compare2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var rcompare = (a3, b3, loose) => compare2(b3, a3, loose);
    module2.exports = rcompare;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var compareLoose = (a3, b3) => compare2(a3, b3, true);
    module2.exports = compareLoose;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compareBuild = (a3, b3, loose) => {
      const versionA = new SemVer(a3, loose);
      const versionB = new SemVer(b3, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var sort = (list, loose) => list.sort((a3, b3) => compareBuild(a3, b3, loose));
    module2.exports = sort;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var rsort = (list, loose) => list.sort((a3, b3) => compareBuild(b3, a3, loose));
    module2.exports = rsort;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gt = (a3, b3, loose) => compare2(a3, b3, loose) > 0;
    module2.exports = gt;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lt = (a3, b3, loose) => compare2(a3, b3, loose) < 0;
    module2.exports = lt;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var eq2 = (a3, b3, loose) => compare2(a3, b3, loose) === 0;
    module2.exports = eq2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var neq = (a3, b3, loose) => compare2(a3, b3, loose) !== 0;
    module2.exports = neq;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gte = (a3, b3, loose) => compare2(a3, b3, loose) >= 0;
    module2.exports = gte;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lte2 = (a3, b3, loose) => compare2(a3, b3, loose) <= 0;
    module2.exports = lte2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js"(exports2, module2) {
    "use strict";
    var eq2 = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte2 = require_lte();
    var cmp = (a3, op, b3, loose) => {
      switch (op) {
        case "===":
          if (typeof a3 === "object") {
            a3 = a3.version;
          }
          if (typeof b3 === "object") {
            b3 = b3.version;
          }
          return a3 === b3;
        case "!==":
          if (typeof a3 === "object") {
            a3 = a3.version;
          }
          if (typeof b3 === "object") {
            b3 = b3.version;
          }
          return a3 !== b3;
        case "":
        case "=":
        case "==":
          return eq2(a3, b3, loose);
        case "!=":
          return neq(a3, b3, loose);
        case ">":
          return gt(a3, b3, loose);
        case ">=":
          return gte(a3, b3, loose);
        case "<":
          return lt(a3, b3, loose);
        case "<=":
          return lte2(a3, b3, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse3 = require_parse();
    var { safeRe: re, t: t3 } = require_re();
    var coerce2 = (version2, options) => {
      if (version2 instanceof SemVer) {
        return version2;
      }
      if (typeof version2 === "number") {
        version2 = String(version2);
      }
      if (typeof version2 !== "string") {
        return null;
      }
      options = options || {};
      let match4 = null;
      if (!options.rtl) {
        match4 = version2.match(options.includePrerelease ? re[t3.COERCEFULL] : re[t3.COERCE]);
      } else {
        const coerceRtlRegex = options.includePrerelease ? re[t3.COERCERTLFULL] : re[t3.COERCERTL];
        let next;
        while ((next = coerceRtlRegex.exec(version2)) && (!match4 || match4.index + match4[0].length !== version2.length)) {
          if (!match4 || next.index + next[0].length !== match4.index + match4[0].length) {
            match4 = next;
          }
          coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        coerceRtlRegex.lastIndex = -1;
      }
      if (match4 === null) {
        return null;
      }
      const major6 = match4[2];
      const minor = match4[3] || "0";
      const patch = match4[4] || "0";
      const prerelease = options.includePrerelease && match4[5] ? `-${match4[5]}` : "";
      const build = options.includePrerelease && match4[6] ? `+${match4[6]}` : "";
      return parse3(`${major6}.${minor}.${patch}${prerelease}${build}`, options);
    };
    module2.exports = coerce2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/lrucache.js
var require_lrucache = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/lrucache.js"(exports2, module2) {
    "use strict";
    var LRUCache2 = class {
      constructor() {
        this.max = 1e3;
        this.map = /* @__PURE__ */ new Map();
      }
      get(key) {
        const value = this.map.get(key);
        if (value === void 0) {
          return void 0;
        } else {
          this.map.delete(key);
          this.map.set(key, value);
          return value;
        }
      }
      delete(key) {
        return this.map.delete(key);
      }
      set(key, value) {
        const deleted = this.delete(key);
        if (!deleted && value !== void 0) {
          if (this.map.size >= this.max) {
            const firstKey = this.map.keys().next().value;
            this.delete(firstKey);
          }
          this.map.set(key, value);
        }
        return this;
      }
    };
    module2.exports = LRUCache2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js
var require_range = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js"(exports2, module2) {
    "use strict";
    var SPACE_CHARACTERS = /\s+/g;
    var Range = class _Range {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof _Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new _Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.formatted = void 0;
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range.trim().replace(SPACE_CHARACTERS, " ");
        this.set = this.raw.split("||").map((r3) => this.parseRange(r3.trim())).filter((c3) => c3.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c3) => !isNullSet(c3[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c3 of this.set) {
              if (c3.length === 1 && isAny(c3[0])) {
                this.set = [c3];
                break;
              }
            }
          }
        }
        this.formatted = void 0;
      }
      get range() {
        if (this.formatted === void 0) {
          this.formatted = "";
          for (let i3 = 0; i3 < this.set.length; i3++) {
            if (i3 > 0) {
              this.formatted += "||";
            }
            const comps = this.set[i3];
            for (let k3 = 0; k3 < comps.length; k3++) {
              if (k3 > 0) {
                this.formatted += " ";
              }
              this.formatted += comps[k3].toString().trim();
            }
          }
        }
        return this.formatted;
      }
      format() {
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range;
        const cached4 = cache3.get(memoKey);
        if (cached4) {
          return cached4;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t3.HYPHENRANGELOOSE] : re[t3.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug4("hyphen replace", range);
        range = range.replace(re[t3.COMPARATORTRIM], comparatorTrimReplace);
        debug4("comparator trim", range);
        range = range.replace(re[t3.TILDETRIM], tildeTrimReplace);
        debug4("tilde trim", range);
        range = range.replace(re[t3.CARETTRIM], caretTrimReplace);
        debug4("caret trim", range);
        let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug4("loose invalid filter", comp, this.options);
            return !!comp.match(re[t3.COMPARATORLOOSE]);
          });
        }
        debug4("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result3 = [...rangeMap.values()];
        cache3.set(memoKey, result3);
        return result3;
      }
      intersects(range, options) {
        if (!(range instanceof _Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version2) {
        if (!version2) {
          return false;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i3 = 0; i3 < this.set.length; i3++) {
          if (testSet(this.set[i3], version2, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lrucache();
    var cache3 = new LRU();
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug4 = require_debug();
    var SemVer = require_semver();
    var {
      safeRe: re,
      t: t3,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = require_constants();
    var isNullSet = (c3) => c3.value === "<0.0.0-0";
    var isAny = (c3) => c3.value === "";
    var isSatisfiable = (comparators, options) => {
      let result3 = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result3 && remainingComparators.length) {
        result3 = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result3;
    };
    var parseComparator = (comp, options) => {
      debug4("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug4("caret", comp);
      comp = replaceTildes(comp, options);
      debug4("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug4("xrange", comp);
      comp = replaceStars(comp, options);
      debug4("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => {
      return comp.trim().split(/\s+/).map((c3) => replaceTilde(c3, options)).join(" ");
    };
    var replaceTilde = (comp, options) => {
      const r3 = options.loose ? re[t3.TILDELOOSE] : re[t3.TILDE];
      return comp.replace(r3, (_3, M, m3, p3, pr) => {
        debug4("tilde", comp, _3, M, m3, p3, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m3)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p3)) {
          ret = `>=${M}.${m3}.0 <${M}.${+m3 + 1}.0-0`;
        } else if (pr) {
          debug4("replaceTilde pr", pr);
          ret = `>=${M}.${m3}.${p3}-${pr} <${M}.${+m3 + 1}.0-0`;
        } else {
          ret = `>=${M}.${m3}.${p3} <${M}.${+m3 + 1}.0-0`;
        }
        debug4("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => {
      return comp.trim().split(/\s+/).map((c3) => replaceCaret(c3, options)).join(" ");
    };
    var replaceCaret = (comp, options) => {
      debug4("caret", comp, options);
      const r3 = options.loose ? re[t3.CARETLOOSE] : re[t3.CARET];
      const z2 = options.includePrerelease ? "-0" : "";
      return comp.replace(r3, (_3, M, m3, p3, pr) => {
        debug4("caret", comp, _3, M, m3, p3, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m3)) {
          ret = `>=${M}.0.0${z2} <${+M + 1}.0.0-0`;
        } else if (isX(p3)) {
          if (M === "0") {
            ret = `>=${M}.${m3}.0${z2} <${M}.${+m3 + 1}.0-0`;
          } else {
            ret = `>=${M}.${m3}.0${z2} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug4("replaceCaret pr", pr);
          if (M === "0") {
            if (m3 === "0") {
              ret = `>=${M}.${m3}.${p3}-${pr} <${M}.${m3}.${+p3 + 1}-0`;
            } else {
              ret = `>=${M}.${m3}.${p3}-${pr} <${M}.${+m3 + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m3}.${p3}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug4("no pr");
          if (M === "0") {
            if (m3 === "0") {
              ret = `>=${M}.${m3}.${p3}${z2} <${M}.${m3}.${+p3 + 1}-0`;
            } else {
              ret = `>=${M}.${m3}.${p3}${z2} <${M}.${+m3 + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m3}.${p3} <${+M + 1}.0.0-0`;
          }
        }
        debug4("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug4("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c3) => replaceXRange(c3, options)).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r3 = options.loose ? re[t3.XRANGELOOSE] : re[t3.XRANGE];
      return comp.replace(r3, (ret, gtlt, M, m3, p3, pr) => {
        debug4("xRange", comp, ret, gtlt, M, m3, p3, pr);
        const xM = isX(M);
        const xm = xM || isX(m3);
        const xp = xm || isX(p3);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m3 = 0;
          }
          p3 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m3 = 0;
              p3 = 0;
            } else {
              m3 = +m3 + 1;
              p3 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m3 = +m3 + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m3}.${p3}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m3}.0${pr} <${M}.${+m3 + 1}.0-0`;
        }
        debug4("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug4("replaceStars", comp, options);
      return comp.trim().replace(re[t3.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug4("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t3.GTE0PRE : t3.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version2, options) => {
      for (let i3 = 0; i3 < set.length; i3++) {
        if (!set[i3].test(version2)) {
          return false;
        }
      }
      if (version2.prerelease.length && !options.includePrerelease) {
        for (let i3 = 0; i3 < set.length; i3++) {
          debug4(set[i3].semver);
          if (set[i3].semver === Comparator.ANY) {
            continue;
          }
          if (set[i3].semver.prerelease.length > 0) {
            const allowed = set[i3].semver;
            if (allowed.major === version2.major && allowed.minor === version2.minor && allowed.patch === version2.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js"(exports2, module2) {
    "use strict";
    var ANY = Symbol("SemVer ANY");
    var Comparator = class _Comparator {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof _Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug4("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug4("comp", this);
      }
      parse(comp) {
        const r3 = this.options.loose ? re[t3.COMPARATORLOOSE] : re[t3.COMPARATOR];
        const m3 = comp.match(r3);
        if (!m3) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m3[1] !== void 0 ? m3[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m3[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m3[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version2) {
        debug4("Comparator.test", version2, this.options.loose);
        if (this.semver === ANY || version2 === ANY) {
          return true;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version2, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof _Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        options = parseOptions(options);
        if (options.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { safeRe: re, t: t3 } = require_re();
    var cmp = require_cmp();
    var debug4 = require_debug();
    var SemVer = require_semver();
    var Range = require_range();
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var satisfies2 = (version2, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version2);
    };
    module2.exports = satisfies2;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c3) => c3.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v6) => {
        if (rangeObj.test(v6)) {
          if (!max || maxSV.compare(v6) === -1) {
            max = v6;
            maxSV = new SemVer(max, options);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v6) => {
        if (rangeObj.test(v6)) {
          if (!min || minSV.compare(v6) === 1) {
            min = v6;
            minSV = new SemVer(min, options);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i3 = 0; i3 < range.set.length; ++i3) {
        const comparators = range.set[i3];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            /* fallthrough */
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            /* istanbul ignore next */
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies2 = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte2 = require_lte();
    var gte = require_gte();
    var outside = (version2, range, hilo, options) => {
      version2 = new SemVer(version2, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte2;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies2(version2, range, options)) {
        return false;
      }
      for (let i3 = 0; i3 < range.set.length; ++i3) {
        const comparators = range.set[i3];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version2, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version2, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var gtr = (version2, range, options) => outside(version2, range, ">", options);
    module2.exports = gtr;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var ltr = (version2, range, options) => outside(version2, range, "<", options);
    module2.exports = ltr;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var intersects = (r1, r22, options) => {
      r1 = new Range(r1, options);
      r22 = new Range(r22, options);
      return r1.intersects(r22, options);
    };
    module2.exports = intersects;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js"(exports2, module2) {
    "use strict";
    var satisfies2 = require_satisfies();
    var compare2 = require_compare();
    module2.exports = (versions, range, options) => {
      const set = [];
      let first = null;
      let prev = null;
      const v6 = versions.sort((a3, b3) => compare2(a3, b3, options));
      for (const version2 of v6) {
        const included = satisfies2(version2, range, options);
        if (included) {
          prev = version2;
          if (!first) {
            first = version2;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v6[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v6[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js"(exports2, module2) {
    "use strict";
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies2 = require_satisfies();
    var compare2 = require_compare();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER: for (const simpleSub of sub.set) {
        for (const simpleDom of dom.set) {
          const isSub = simpleSubset(simpleSub, simpleDom, options);
          sawNonNull = sawNonNull || isSub !== null;
          if (isSub) {
            continue OUTER;
          }
        }
        if (sawNonNull) {
          return false;
        }
      }
      return true;
    };
    var minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")];
    var minimumVersion = [new Comparator(">=0.0.0")];
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options.includePrerelease) {
          sub = minimumVersionWithPreRelease;
        } else {
          sub = minimumVersion;
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
          return true;
        } else {
          dom = minimumVersion;
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c3 of sub) {
        if (c3.operator === ">" || c3.operator === ">=") {
          gt = higherGT(gt, c3, options);
        } else if (c3.operator === "<" || c3.operator === "<=") {
          lt = lowerLT(lt, c3, options);
        } else {
          eqSet.add(c3.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare2(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq2 of eqSet) {
        if (gt && !satisfies2(eq2, String(gt), options)) {
          return null;
        }
        if (lt && !satisfies2(eq2, String(lt), options)) {
          return null;
        }
        for (const c3 of dom) {
          if (!satisfies2(eq2, String(c3), options)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c3 of dom) {
        hasDomGT = hasDomGT || c3.operator === ">" || c3.operator === ">=";
        hasDomLT = hasDomLT || c3.operator === "<" || c3.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c3.semver.prerelease && c3.semver.prerelease.length && c3.semver.major === needDomGTPre.major && c3.semver.minor === needDomGTPre.minor && c3.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c3.operator === ">" || c3.operator === ">=") {
            higher = higherGT(gt, c3, options);
            if (higher === c3 && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies2(gt.semver, String(c3), options)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c3.semver.prerelease && c3.semver.prerelease.length && c3.semver.major === needDomLTPre.major && c3.semver.minor === needDomLTPre.minor && c3.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c3.operator === "<" || c3.operator === "<=") {
            lower = lowerLT(lt, c3, options);
            if (lower === c3 && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies2(lt.semver, String(c3), options)) {
            return false;
          }
        }
        if (!c3.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    };
    var higherGT = (a3, b3, options) => {
      if (!a3) {
        return b3;
      }
      const comp = compare2(a3.semver, b3.semver, options);
      return comp > 0 ? a3 : comp < 0 ? b3 : b3.operator === ">" && a3.operator === ">=" ? b3 : a3;
    };
    var lowerLT = (a3, b3, options) => {
      if (!a3) {
        return b3;
      }
      const comp = compare2(a3.semver, b3.semver, options);
      return comp < 0 ? a3 : comp > 0 ? b3 : b3.operator === "<" && a3.operator === "<=" ? b3 : a3;
    };
    module2.exports = subset;
  }
});

// ../@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js
var require_semver2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js"(exports2, module2) {
    "use strict";
    var internalRe = require_re();
    var constants3 = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse3 = require_parse();
    var valid3 = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major6 = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare2 = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq2 = require_eq();
    var neq = require_neq();
    var gte = require_gte();
    var lte2 = require_lte();
    var cmp = require_cmp();
    var coerce2 = require_coerce();
    var Comparator = require_comparator();
    var Range = require_range();
    var satisfies2 = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module2.exports = {
      parse: parse3,
      valid: valid3,
      clean,
      inc,
      diff,
      major: major6,
      minor,
      patch,
      prerelease,
      compare: compare2,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq: eq2,
      neq,
      gte,
      lte: lte2,
      cmp,
      coerce: coerce2,
      Comparator,
      Range,
      satisfies: satisfies2,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants3.SEMVER_SPEC_VERSION,
      RELEASE_TYPES: constants3.RELEASE_TYPES,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/cli-version.json
var require_cli_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/cli-version.json"(exports2, module2) {
    module2.exports = { version: "2.1017.1" };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/assets.schema.json
var require_assets_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/assets.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/AssetManifest",
      definitions: {
        AssetManifest: {
          description: "Definitions for the asset manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            files: {
              description: "The file assets in this manifest (Default - No files)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileAsset"
              }
            },
            dockerImages: {
              description: "The Docker image assets in this manifest (Default - No Docker images)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageAsset"
              }
            }
          },
          required: [
            "version"
          ]
        },
        FileAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            displayName: {
              description: "A display name for this asset (Default - The identifier will be used as the display name)",
              type: "string"
            },
            source: {
              $ref: "#/definitions/FileSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        FileSource: {
          description: "Describe the source of a file asset",
          type: "object",
          properties: {
            executable: {
              description: "External command which will produce the file asset to upload. (Default - Exactly one of `executable` and `path` is required.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            path: {
              description: "The filesystem object to upload\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `executable` and `path` is required.)",
              type: "string"
            },
            packaging: {
              description: "Packaging method\n\nOnly allowed when `path` is specified. (Default FILE)",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            }
          }
        },
        FileDestination: {
          description: "Where in S3 a file asset needs to be published",
          type: "object",
          properties: {
            bucketName: {
              description: "The name of the bucket",
              type: "string"
            },
            objectKey: {
              description: "The destination object key",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "bucketName",
            "objectKey"
          ]
        },
        DockerImageAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            displayName: {
              description: "A display name for this asset (Default - The identifier will be used as the display name)",
              type: "string"
            },
            source: {
              $ref: "#/definitions/DockerImageSource",
              description: "Source description for container assets"
            },
            destinations: {
              description: "Destinations for this container asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        DockerImageSource: {
          description: "Properties for how to produce a Docker image from a source",
          type: "object",
          properties: {
            directory: {
              description: "The directory containing the Docker image build instructions.\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `directory` and `executable` is required)",
              type: "string"
            },
            executable: {
              description: "A command-line executable that returns the name of a local\nDocker image on stdout after being run. (Default - Exactly one of `directory` and `executable` is required)",
              type: "array",
              items: {
                type: "string"
              }
            },
            dockerFile: {
              description: "The name of the file with build instructions\n\nOnly allowed when `directory` is set. (Default Dockerfile)",
              type: "string"
            },
            dockerBuildTarget: {
              description: "Target build stage in a Dockerfile with multiple build stages\n\nOnly allowed when `directory` is set. (Default - The last stage in the Dockerfile)",
              type: "string"
            },
            dockerBuildArgs: {
              description: "Additional build arguments\n\nOnly allowed when `directory` is set. (Default - No additional build arguments)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            dockerBuildSsh: {
              description: "SSH agent socket or keys\n\nRequires building with docker buildkit. (Default - No ssh flag is set)",
              type: "string"
            },
            dockerBuildSecrets: {
              description: "Additional build secrets\n\nOnly allowed when `directory` is set. (Default - No additional build secrets)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. _Requires Docker Engine API v1.25+_.\n\nSpecify this property to build images on a specific networking mode. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_.\n\nSpecify this property to build images on a specific platform/architecture. (Default - current machine platform)",
              type: "string"
            },
            dockerOutputs: {
              description: "Outputs (Default - no outputs are passed to the build command (default outputs are used))",
              type: "array",
              items: {
                type: "string"
              }
            },
            cacheFrom: {
              description: "Cache from options to pass to the `docker build` command. (Default - no cache from options are passed to the build command)",
              type: "array",
              items: {
                $ref: "#/definitions/DockerCacheOption"
              }
            },
            cacheTo: {
              description: "Cache to options to pass to the `docker build` command. (Default - no cache to options are passed to the build command)",
              $ref: "#/definitions/DockerCacheOption"
            },
            cacheDisabled: {
              description: "Disable the cache and pass `--no-cache` to the `docker build` command. (Default - cache is used)",
              type: "boolean"
            }
          }
        },
        DockerCacheOption: {
          description: "Options for configuring the Docker cache backend",
          type: "object",
          properties: {
            type: {
              description: "The type of cache to use.\nRefer to https://docs.docker.com/build/cache/backends/ for full list of backends. (Default - unspecified)",
              type: "string"
            },
            params: {
              description: "Any parameters to pass into the docker cache backend configuration.\nRefer to https://docs.docker.com/build/cache/backends/ for cache backend configuration. (Default {} No options provided)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        DockerImageDestination: {
          description: "Where to publish docker images",
          type: "object",
          properties: {
            repositoryName: {
              description: "Name of the ECR repository to publish to",
              type: "string"
            },
            imageTag: {
              description: "Tag of the image to publish",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "imageTag",
            "repositoryName"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json
var require_cloud_assembly_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/AssemblyManifest",
      definitions: {
        AssemblyManifest: {
          description: "A manifest which describes the cloud assembly.",
          type: "object",
          properties: {
            version: {
              description: "Protocol version",
              type: "string"
            },
            minimumCliVersion: {
              description: "Required CLI version, if available\n\nIf the manifest producer knows, it can put the minimum version of the CLI\nhere that supports reading this assembly.\n\nIf set, it can be used to show a more informative error message to users. (Default - Minimum CLI version unknown)",
              type: "string"
            },
            artifacts: {
              description: "The set of artifacts in this assembly. (Default - no artifacts.)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/ArtifactManifest"
              }
            },
            missing: {
              description: "Missing context information. If this field has values, it means that the\ncloud assembly is not complete and should not be deployed. (Default - no missing context.)",
              type: "array",
              items: {
                $ref: "#/definitions/MissingContext"
              }
            },
            runtime: {
              description: "Runtime information. (Default - no info.)",
              $ref: "#/definitions/RuntimeInfo"
            }
          },
          required: [
            "version"
          ]
        },
        ArtifactManifest: {
          description: "A manifest for a single artifact within the cloud assembly.",
          type: "object",
          properties: {
            type: {
              $ref: "#/definitions/ArtifactType",
              description: "The type of artifact."
            },
            environment: {
              description: "The environment into which this artifact is deployed. (Default - no envrionment.)",
              type: "string"
            },
            metadata: {
              description: "Associated metadata. (Default - no metadata.)",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  $ref: "#/definitions/MetadataEntry"
                }
              }
            },
            dependencies: {
              description: "IDs of artifacts that must be deployed before this artifact. (Default - no dependencies.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            properties: {
              description: "The set of properties for this artifact (depends on type) (Default - no properties.)",
              anyOf: [
                {
                  $ref: "#/definitions/AwsCloudFormationStackProperties"
                },
                {
                  $ref: "#/definitions/AssetManifestProperties"
                },
                {
                  $ref: "#/definitions/TreeArtifactProperties"
                },
                {
                  $ref: "#/definitions/NestedCloudAssemblyProperties"
                }
              ]
            },
            displayName: {
              description: `A string that can be shown to a user to uniquely identify this artifact inside a cloud assembly tree

Is used by the CLI to present a list of stacks to the user in a way that
makes sense to them. Even though the property name "display name" doesn't
imply it, this field is used to select stacks as well, so all stacks should
have a unique display name. (Default - no display name)`,
              type: "string"
            }
          },
          required: [
            "type"
          ]
        },
        ArtifactType: {
          description: "Type of cloud artifact.",
          type: "string",
          enum: [
            "none",
            "aws:cloudformation:stack",
            "cdk:tree",
            "cdk:asset-manifest",
            "cdk:cloud-assembly"
          ]
        },
        MetadataEntry: {
          description: "A metadata entry in a cloud assembly artifact.",
          type: "object",
          properties: {
            type: {
              description: "The type of the metadata entry.",
              type: "string"
            },
            data: {
              description: "The data. (Default - no data.)",
              anyOf: [
                {
                  $ref: "#/definitions/FileAssetMetadataEntry"
                },
                {
                  $ref: "#/definitions/ContainerImageAssetMetadataEntry"
                },
                {
                  type: "array",
                  items: {
                    $ref: "#/definitions/Tag"
                  }
                },
                {
                  type: [
                    "string",
                    "number",
                    "boolean"
                  ]
                },
                {
                  description: "Free form data."
                }
              ]
            },
            trace: {
              description: "A stack trace for when the entry was created. (Default - no trace.)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        FileAssetMetadataEntry: {
          description: "Metadata Entry spec for files.",
          type: "object",
          properties: {
            packaging: {
              description: "Requested packaging style",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            },
            s3BucketParameter: {
              description: "Name of parameter where S3 bucket should be passed in",
              type: "string"
            },
            s3KeyParameter: {
              description: "Name of parameter where S3 key should be passed in",
              type: "string"
            },
            artifactHashParameter: {
              description: "The name of the parameter where the hash of the bundled asset should be passed in.",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "artifactHashParameter",
            "id",
            "packaging",
            "path",
            "s3BucketParameter",
            "s3KeyParameter",
            "sourceHash"
          ]
        },
        ContainerImageAssetMetadataEntry: {
          description: "Metadata Entry spec for container images.",
          type: "object",
          properties: {
            packaging: {
              description: "Type of asset",
              type: "string",
              const: "container-image"
            },
            imageNameParameter: {
              description: 'ECR Repository name and repo digest (separated by "@sha256:") where this\nimage is stored. (Default undefined If not specified, `repositoryName` and `imageTag` are\nrequired because otherwise how will the stack know where to find the asset,\nha?)',
              type: "string"
            },
            repositoryName: {
              description: "ECR repository name, if omitted a default name based on the asset's ID is\nused instead. Specify this property if you need to statically address the\nimage, e.g. from a Kubernetes Pod. Note, this is only the repository name,\nwithout the registry and the tag parts. (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            imageTag: {
              description: "The docker image tag to use for tagging pushed images. This field is\nrequired if `imageParameterName` is ommited (otherwise, the app won't be\nable to find the image). (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            buildArgs: {
              description: "Build args to pass to the `docker build` command (Default no build args are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            buildSsh: {
              description: "SSH agent socket or keys to pass to the `docker build` command (Default no ssh arg is passed)",
              type: "string"
            },
            buildSecrets: {
              description: "Build secrets to pass to the `docker build` command (Default no build secrets are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            target: {
              description: "Docker target to build to (Default no build target)",
              type: "string"
            },
            file: {
              description: "Path to the Dockerfile (relative to the directory). (Default - no file is passed)",
              type: "string"
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_. (Default - current machine platform)",
              type: "string"
            },
            outputs: {
              description: "Outputs to pass to the `docker build` command. (Default - no outputs are passed to the build command (default outputs are used))",
              type: "array",
              items: {
                type: "string"
              }
            },
            cacheFrom: {
              description: "Cache from options to pass to the `docker build` command. (Default - no cache from options are passed to the build command)",
              type: "array",
              items: {
                $ref: "#/definitions/ContainerImageAssetCacheOption"
              }
            },
            cacheTo: {
              description: "Cache to options to pass to the `docker build` command. (Default - no cache to options are passed to the build command)",
              $ref: "#/definitions/ContainerImageAssetCacheOption"
            },
            cacheDisabled: {
              description: "Disable the cache and pass `--no-cache` to the `docker build` command. (Default - cache is used)",
              type: "boolean"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "id",
            "packaging",
            "path",
            "sourceHash"
          ]
        },
        ContainerImageAssetCacheOption: {
          description: "Options for configuring the Docker cache backend",
          type: "object",
          properties: {
            type: {
              description: "The type of cache to use.\nRefer to https://docs.docker.com/build/cache/backends/ for full list of backends. (Default - unspecified)",
              type: "string"
            },
            params: {
              description: "Any parameters to pass into the docker cache backend configuration.\nRefer to https://docs.docker.com/build/cache/backends/ for cache backend configuration. (Default {} No options provided)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        Tag: {
          description: "Metadata Entry spec for stack tag.",
          type: "object",
          properties: {
            key: {
              description: 'Tag key.\n\n(In the actual file on disk this will be cased as "Key", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            },
            value: {
              description: 'Tag value.\n\n(In the actual file on disk this will be cased as "Value", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            }
          },
          required: [
            "key",
            "value"
          ]
        },
        AwsCloudFormationStackProperties: {
          description: "Artifact properties for CloudFormation stacks.",
          type: "object",
          properties: {
            templateFile: {
              description: "A file relative to the assembly root which contains the CloudFormation template for this stack.",
              type: "string"
            },
            parameters: {
              description: "Values for CloudFormation stack parameters that should be passed when the stack is deployed. (Default - No parameters)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            tags: {
              description: "Values for CloudFormation stack tags that should be passed when the stack is deployed. (Default - No tags)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            notificationArns: {
              description: "SNS Notification ARNs that should receive CloudFormation Stack Events. (Default - No notification arns)",
              type: "array",
              items: {
                type: "string"
              }
            },
            stackName: {
              description: "The name to use for the CloudFormation stack. (Default - name derived from artifact ID)",
              type: "string"
            },
            terminationProtection: {
              description: "Whether to enable termination protection for this stack.",
              default: false,
              type: "boolean"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed to deploy the stack (Default - No role is assumed (current credentials are used))",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming role for cloudformation deployments (Default - No external ID)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `assumeRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            },
            cloudFormationExecutionRoleArn: {
              description: "The role that is passed to CloudFormation to execute the change set (Default - No role is passed (currently assumed role/credentials are used))",
              type: "string"
            },
            lookupRole: {
              description: "The role to use to look up values from the target AWS account (Default - No role is assumed (current credentials are used))",
              $ref: "#/definitions/BootstrapRole"
            },
            stackTemplateAssetObjectUrl: {
              description: "If the stack template has already been included in the asset manifest, its asset URL (Default - Not uploaded yet, upload just before deploying)",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\nOnly used if `requiresBootstrapStackVersion` is set.\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            },
            validateOnSynth: {
              description: "Whether this stack should be validated by the CLI after synthesis (Default - false)",
              type: "boolean"
            }
          },
          required: [
            "templateFile"
          ]
        },
        BootstrapRole: {
          description: "Information needed to access an IAM role created\nas part of the bootstrap process",
          type: "object",
          properties: {
            arn: {
              description: "The ARN of the IAM role created as part of bootrapping\ne.g. lookupRoleArn",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming the bootstrap role (Default - No external ID)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the role.\n\n- `RoleArn` should not be used. Use the dedicated `arn` property instead.\n- `ExternalId` should not be used. Use the dedicated `assumeRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to use this role (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "Name of SSM parameter with bootstrap stack version (Default - Discover SSM parameter by reading stack)",
              type: "string"
            }
          },
          required: [
            "arn"
          ]
        },
        AssetManifestProperties: {
          description: "Artifact properties for the Asset Manifest",
          type: "object",
          properties: {
            file: {
              description: "Filename of the asset manifest",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - Version 1 (basic modern bootstrap stack))",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        TreeArtifactProperties: {
          description: "Artifact properties for the Construct Tree Artifact",
          type: "object",
          properties: {
            file: {
              description: "Filename of the tree artifact",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        NestedCloudAssemblyProperties: {
          description: "Artifact properties for nested cloud assemblies",
          type: "object",
          properties: {
            directoryName: {
              description: "Relative path to the nested cloud assembly",
              type: "string"
            },
            displayName: {
              description: "Display name for the cloud assembly (Default - The artifact ID)",
              type: "string"
            }
          },
          required: [
            "directoryName"
          ]
        },
        MissingContext: {
          description: "Represents a missing piece of context.",
          type: "object",
          properties: {
            key: {
              description: "The missing context key.",
              type: "string"
            },
            provider: {
              $ref: "#/definitions/ContextProvider",
              description: "The provider from which we expect this context key to be obtained."
            },
            props: {
              $ref: "#/definitions/ContextQueryProperties",
              description: "A set of provider-specific options."
            }
          },
          required: [
            "key",
            "props",
            "provider"
          ]
        },
        ContextProvider: {
          description: "Identifier for the context provider",
          type: "string",
          enum: [
            "ami",
            "availability-zones",
            "hosted-zone",
            "ssm",
            "vpc-provider",
            "endpoint-service-availability-zones",
            "load-balancer",
            "load-balancer-listener",
            "security-group",
            "key-provider",
            "cc-api-provider",
            "plugin"
          ]
        },
        ContextQueryProperties: {
          anyOf: [
            {
              $ref: "#/definitions/AmiContextQuery"
            },
            {
              $ref: "#/definitions/AvailabilityZonesContextQuery"
            },
            {
              $ref: "#/definitions/HostedZoneContextQuery"
            },
            {
              $ref: "#/definitions/SSMParameterContextQuery"
            },
            {
              $ref: "#/definitions/VpcContextQuery"
            },
            {
              $ref: "#/definitions/EndpointServiceAvailabilityZonesContextQuery"
            },
            {
              $ref: "#/definitions/LoadBalancerContextQuery"
            },
            {
              $ref: "#/definitions/LoadBalancerListenerContextQuery"
            },
            {
              $ref: "#/definitions/SecurityGroupContextQuery"
            },
            {
              $ref: "#/definitions/KeyContextQuery"
            },
            {
              $ref: "#/definitions/CcApiContextQuery"
            },
            {
              $ref: "#/definitions/PluginContextQuery"
            }
          ]
        },
        AmiContextQuery: {
          description: "Query to AMI context provider",
          type: "object",
          properties: {
            owners: {
              description: "Owners to DescribeImages call (Default - All owners)",
              type: "array",
              items: {
                type: "string"
              }
            },
            filters: {
              description: "Filters to DescribeImages call",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  type: "string"
                }
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "filters",
            "region"
          ]
        },
        AvailabilityZonesContextQuery: {
          description: "Query to availability zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        HostedZoneContextQuery: {
          description: "Query to hosted zone context provider",
          type: "object",
          properties: {
            domainName: {
              description: "The domain name e.g. example.com to lookup",
              type: "string"
            },
            privateZone: {
              description: "True if the zone you want to find is a private hosted zone",
              default: false,
              type: "boolean"
            },
            vpcId: {
              description: "The VPC ID to that the private zone must be associated with\n\nIf you provide VPC ID and privateZone is false, this will return no results\nand raise an error. (Default - Required if privateZone=true)",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "domainName",
            "region"
          ]
        },
        SSMParameterContextQuery: {
          description: "Query to SSM Parameter Context Provider",
          type: "object",
          properties: {
            parameterName: {
              description: "Parameter name to query",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "parameterName",
            "region"
          ]
        },
        VpcContextQuery: {
          description: "Query input for looking up a VPC",
          type: "object",
          properties: {
            filter: {
              description: "Filters to apply to the VPC\n\nFilter parameters are the same as passed to DescribeVpcs.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            returnAsymmetricSubnets: {
              description: "Whether to populate the subnetGroups field of the `VpcContextResponse`,\nwhich contains potentially asymmetric subnet groups.",
              default: false,
              type: "boolean"
            },
            subnetGroupNameTag: {
              description: "Optional tag for subnet group name.\nIf not provided, we'll look at the aws-cdk:subnet-name tag.\nIf the subnet does not have the specified tag,\nwe'll use its type as the name. (Default 'aws-cdk:subnet-name')",
              type: "string"
            },
            returnVpnGateways: {
              description: "Whether to populate the `vpnGatewayId` field of the `VpcContextResponse`,\nwhich contains the VPN Gateway ID, if one exists. You can explicitly\ndisable this in order to avoid the lookup if you know the VPC does not have\na VPN Gatway attached. (Default true)",
              type: "boolean"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "filter",
            "region"
          ]
        },
        EndpointServiceAvailabilityZonesContextQuery: {
          description: "Query to endpoint service context provider",
          type: "object",
          properties: {
            serviceName: {
              description: "Query service name",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region",
            "serviceName"
          ]
        },
        LoadBalancerContextQuery: {
          description: "Query input for looking up a load balancer",
          type: "object",
          properties: {
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        LoadBalancerType: {
          description: "Type of load balancer",
          type: "string",
          enum: [
            "network",
            "application"
          ]
        },
        LoadBalancerListenerContextQuery: {
          description: "Query input for looking up a load balancer listener",
          type: "object",
          properties: {
            listenerArn: {
              description: "Find by listener's arn (Default - does not find by listener arn)",
              type: "string"
            },
            listenerProtocol: {
              description: "Filter by listener protocol (Default - does not filter by listener protocol)",
              enum: [
                "HTTP",
                "HTTPS",
                "TCP",
                "TCP_UDP",
                "TLS",
                "UDP"
              ],
              type: "string"
            },
            listenerPort: {
              description: "Filter listeners by listener port (Default - does not filter by a listener port)",
              type: "number"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        SecurityGroupContextQuery: {
          description: "Query input for looking up a security group",
          type: "object",
          properties: {
            securityGroupId: {
              description: "Security group id (Default - None)",
              type: "string"
            },
            securityGroupName: {
              description: "Security group name (Default - None)",
              type: "string"
            },
            vpcId: {
              description: "VPC ID (Default - None)",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        KeyContextQuery: {
          description: "Query input for looking up a KMS Key",
          type: "object",
          properties: {
            aliasName: {
              description: "Alias name used to search the Key",
              type: "string"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "aliasName",
            "region"
          ]
        },
        CcApiContextQuery: {
          description: "Query input for lookup up CloudFormation resources using CC API\n\nThe example below is required to successfully compile CDK (otherwise,\nthe CDK build will generate a synthetic example for the below, but it\ndoesn't have enough type information about the literal string union\nto generate a validly compiling example).",
          type: "object",
          properties: {
            typeName: {
              description: "The CloudFormation resource type.\nSee https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/supported-resources.html",
              type: "string"
            },
            exactIdentifier: {
              description: "Identifier of the resource to look up using `GetResource`.\n\nSpecifying exactIdentifier will return exactly one result, or throw an error\nunless `ignoreErrorOnMissingContext` is set. (Default - Either exactIdentifier or propertyMatch should be specified.)",
              type: "string"
            },
            propertyMatch: {
              description: "Returns any resources matching these properties, using `ListResources`.\n\nBy default, specifying propertyMatch will successfully return 0 or more\nresults. To throw an error if the number of results is unexpected (and\nprevent the query results from being committed to context), specify\n`expectedMatchCount`.\n\n## Notes on property completeness\n\nCloudControl API's `ListResources` may return fewer properties than\n`GetResource` would, depending on the resource implementation.\n\nThe resources that `propertyMatch` matches against will *only ever* be the\nproperties returned by the `ListResources` call. (Default - Either exactIdentifier or propertyMatch should be specified.)",
              $ref: "#/definitions/Record<string,unknown>"
            },
            propertiesToReturn: {
              description: "This is a set of properties returned from CC API that we want to return from ContextQuery.\n\nIf any properties listed here are absent from the target resource, an error will be thrown.\n\nThe returned object will always include the key `Identifier` with the CC-API returned\nfield `Identifier`.\n\n## Notes on property completeness\n\nCloudControl API's `ListResources` may return fewer properties than\n`GetResource` would, depending on the resource implementation.\n\nThe returned properties here are *currently* selected from the response\nobject that CloudControl API returns to the CDK CLI.\n\nHowever, if we find there is need to do so, we may decide to change this\nbehavior in the future: we might change it to perform an additional\n`GetResource` call for resources matched by `propertyMatch`.",
              type: "array",
              items: {
                type: "string"
              }
            },
            expectedMatchCount: {
              description: "Expected count of results if `propertyMatch` is specified.\n\nIf the expected result count does not match the actual count,\nby default an error is produced and the result is not committed to cached\ncontext, and the user can correct the situation and try again without\nhaving to manually clear out the context key using `cdk context --remove`\n\nIf the value of * `ignoreErrorOnMissingContext` is `true`, the value of\n`expectedMatchCount` is `at-least-one | exactly-one` and the number\nof found resources is 0, `dummyValue` is returned and committed to context\ninstead. (Default 'any')",
              enum: [
                "any",
                "at-least-one",
                "at-most-one",
                "exactly-one"
              ],
              type: "string"
            },
            dummyValue: {
              description: "The value to return if the resource was not found and `ignoreErrorOnMissingContext` is true.\n\nIf supplied, `dummyValue` should be an array of objects.\n\n`dummyValue` does not have to have elements, and it may have objects with\ndifferent properties than the properties in `propertiesToReturn`, but it\nwill be easiest for downstream code if the `dummyValue` conforms to\nthe expected response shape. (Default - No dummy value available)"
            },
            ignoreErrorOnMissingContext: {
              description: "Ignore an error and return the `dummyValue` instead if the resource was not found.\n\n- In case of an `exactIdentifier` lookup, return the `dummyValue` if the resource with\n  that identifier was not found.\n- In case of a `propertyMatch` lookup, return the `dummyValue` if `expectedMatchCount`\n  is `at-least-one | exactly-one` and the number of resources found was 0.\n\nif `ignoreErrorOnMissingContext` is set, `dummyValue` should be set and be an array.",
              default: false,
              type: "boolean"
            },
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            lookupRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            },
            assumeRoleAdditionalOptions: {
              description: "Additional options to pass to STS when assuming the lookup role.\n\n- `RoleArn` should not be used. Use the dedicated `lookupRoleArn` property instead.\n- `ExternalId` should not be used. Use the dedicated `lookupRoleExternalId` instead. (Default - No additional options.)",
              type: "object",
              additionalProperties: {}
            }
          },
          required: [
            "account",
            "propertiesToReturn",
            "region",
            "typeName"
          ]
        },
        "Record<string,unknown>": {
          type: "object"
        },
        PluginContextQuery: {
          description: "Query input for plugins\n\nThis alternate branch is necessary because it needs to be able to escape all type checking\nwe do on on the cloud assembly -- we cannot know the properties that will be used a priori.",
          type: "object",
          additionalProperties: {},
          properties: {
            pluginName: {
              description: "The name of the plugin",
              type: "string"
            }
          },
          required: [
            "pluginName"
          ]
        },
        RuntimeInfo: {
          description: "Information about the application's runtime components.",
          type: "object",
          properties: {
            libraries: {
              description: "The list of libraries loaded in the application, associated with their versions.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "libraries"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/integ.schema.json
var require_integ_schema = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/integ.schema.json"(exports2, module2) {
    module2.exports = {
      $ref: "#/definitions/IntegManifest",
      definitions: {
        IntegManifest: {
          description: "Definitions for the integration testing manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            enableLookups: {
              description: "Enable lookups for this test. If lookups are enabled\nthen `stackUpdateWorkflow` must be set to false.\nLookups should only be enabled when you are explicitely testing\nlookups.",
              default: false,
              type: "boolean"
            },
            synthContext: {
              description: "Additional context to use when performing\na synth. Any context provided here will override\nany default context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            testCases: {
              description: "test cases",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/TestCase"
              }
            }
          },
          required: [
            "testCases",
            "version"
          ]
        },
        TestCase: {
          description: "Represents an integration test case",
          type: "object",
          properties: {
            stacks: {
              description: "Stacks that should be tested as part of this test case\nThe stackNames will be passed as args to the cdk commands\nso dependent stacks will be automatically deployed unless\n`exclusively` is passed",
              type: "array",
              items: {
                type: "string"
              }
            },
            assertionStack: {
              description: "The node id of the stack that contains assertions.\nThis is the value that can be used to deploy the stack with the CDK CLI (Default - no assertion stack)",
              type: "string"
            },
            assertionStackName: {
              description: "The name of the stack that contains assertions (Default - no assertion stack)",
              type: "string"
            },
            stackUpdateWorkflow: {
              description: "Run update workflow on this test case\nThis should only be set to false to test scenarios\nthat are not possible to test as part of the update workflow (Default true)",
              type: "boolean"
            },
            cdkCommandOptions: {
              description: "Additional options to use for each CDK command (Default - runner default options)",
              $ref: "#/definitions/CdkCommands"
            },
            hooks: {
              description: "Additional commands to run at predefined points in the test workflow\n\ne.g. { postDeploy: ['yarn', 'test'] } (Default - no hooks)",
              $ref: "#/definitions/Hooks"
            },
            diffAssets: {
              description: "Whether or not to include asset hashes in the diff\nAsset hashes can introduces a lot of unneccessary noise into tests,\nbut there are some cases where asset hashes _should_ be included. For example\nany tests involving custom resources or bundling",
              default: false,
              type: "boolean"
            },
            allowDestroy: {
              description: "List of CloudFormation resource types in this stack that can\nbe destroyed as part of an update without failing the test.\n\nThis list should only include resources that for this specific\nintegration test we are sure will not cause errors or an outage if\ndestroyed. For example, maybe we know that a new resource will be created\nfirst before the old resource is destroyed which prevents any outage.\n\ne.g. ['AWS::IAM::Role'] (Default - do not allow destruction of any resources on update)",
              type: "array",
              items: {
                type: "string"
              }
            },
            regions: {
              description: "Limit deployment to these regions (Default - can run in any region)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "stacks"
          ]
        },
        CdkCommands: {
          description: "Options for specific cdk commands that are run\nas part of the integration test workflow",
          type: "object",
          properties: {
            deploy: {
              description: "Options to for the cdk deploy command (Default - default deploy options)",
              $ref: "#/definitions/DeployCommand"
            },
            destroy: {
              description: "Options to for the cdk destroy command (Default - default destroy options)",
              $ref: "#/definitions/DestroyCommand"
            }
          }
        },
        DeployCommand: {
          description: "Represents a cdk deploy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DeployOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DeployOptions: {
          description: "Options to use with cdk deploy",
          type: "object",
          properties: {
            exclusively: {
              description: "Only perform action on the given stack",
              default: false,
              type: "boolean"
            },
            toolkitStackName: {
              description: "Name of the toolkit stack to use/deploy (Default CDKToolkit)",
              type: "string"
            },
            reuseAssets: {
              description: "Reuse the assets with the given asset IDs (Default - do not reuse assets)",
              type: "array",
              items: {
                type: "string"
              }
            },
            changeSetName: {
              description: "Optional name to use for the CloudFormation change set.\nIf not provided, a name will be generated automatically. (Default - auto generate a name)",
              type: "string"
            },
            force: {
              description: "Always deploy, even if templates are identical.",
              default: false,
              type: "boolean"
            },
            rollback: {
              description: "Rollback failed deployments (Default true)",
              type: "boolean"
            },
            notificationArns: {
              description: "ARNs of SNS topics that CloudFormation will notify with stack related events (Default - no notifications)",
              type: "array",
              items: {
                type: "string"
              }
            },
            requireApproval: {
              description: "What kind of security changes require approval (Default RequireApproval.NEVER)",
              enum: [
                "any-change",
                "broadening",
                "never"
              ],
              type: "string"
            },
            execute: {
              description: "Whether to execute the ChangeSet\nNot providing `execute` parameter will result in execution of ChangeSet (Default true)",
              type: "boolean"
            },
            parameters: {
              description: "Additional parameters for CloudFormation at deploy time (Default [object Object])",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            usePreviousParameters: {
              description: "Use previous values for unspecified parameters\n\nIf not set, all parameters must be specified for every deployment. (Default true)",
              type: "boolean"
            },
            outputsFile: {
              description: "Path to file where stack outputs will be written after a successful deploy as JSON (Default - Outputs are not written to any file)",
              type: "string"
            },
            ci: {
              description: "Whether we are on a CI system",
              default: false,
              type: "boolean"
            },
            concurrency: {
              description: "Deploy multiple stacks in parallel (Default 1)",
              type: "number"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        DestroyCommand: {
          description: "Represents a cdk destroy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DestroyOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DestroyOptions: {
          description: "Options to use with cdk destroy",
          type: "object",
          properties: {
            force: {
              description: "Do not ask for permission before destroying stacks",
              default: false,
              type: "boolean"
            },
            exclusively: {
              description: "Only destroy the given stack",
              default: false,
              type: "boolean"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        Hooks: {
          description: "Commands to run at predefined points during the\nintegration test workflow",
          type: "object",
          properties: {
            preDeploy: {
              description: "Commands to run prior to deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDeploy: {
              description: "Commands to run prior after deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            preDestroy: {
              description: "Commands to run prior to destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDestroy: {
              description: "Commands to run after destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            }
          }
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/schema/version.json
var require_version = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/schema/version.json"(exports2, module2) {
    module2.exports = {
      schemaHash: "5dcc6511e8b96c378ad35c391cdc2dcbaa52d08a8015760692eaad73efc9a949",
      revision: 44
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/manifest.ts
var manifest_exports = {};
__export(manifest_exports, {
  Manifest: () => Manifest,
  VERSION_MISMATCH: () => VERSION_MISMATCH
});
function mapValues(xs, fn) {
  if (!xs) {
    return void 0;
  }
  const ret = {};
  for (const [k3, v6] of Object.entries(xs)) {
    ret[k3] = fn(v6);
  }
  return ret;
}
function noUndefined(xs) {
  const ret = {};
  for (const [k3, v6] of Object.entries(xs)) {
    if (v6 !== void 0) {
      ret[k3] = v6;
    }
  }
  return ret;
}
function stripEnumErrors(errors) {
  return errors.filter((e3) => typeof e3.schema === "string" || !("enum" in e3.schema));
}
var fs, jsonschema, semver, VERSION_MISMATCH, CLI_VERSION, ASSETS_SCHEMA, ASSEMBLY_SCHEMA, INTEG_SCHEMA, SCHEMA_VERSION, Manifest;
var init_manifest = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/manifest.ts"() {
    "use strict";
    fs = __toESM(require("fs"));
    jsonschema = __toESM(require_lib());
    semver = __toESM(require_semver2());
    init_cloud_assembly();
    VERSION_MISMATCH = "Cloud assembly schema version mismatch";
    CLI_VERSION = require_cli_version();
    ASSETS_SCHEMA = require_assets_schema();
    ASSEMBLY_SCHEMA = require_cloud_assembly_schema();
    INTEG_SCHEMA = require_integ_schema();
    SCHEMA_VERSION = require_version();
    Manifest = class _Manifest {
      /**
       * Validates and saves the cloud assembly manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveAssemblyManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, ASSEMBLY_SCHEMA, _Manifest.patchStackTagsOnWrite);
      }
      /**
       * Load and validates the cloud assembly manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadAssemblyManifest(filePath, options) {
        return _Manifest.loadManifest(filePath, ASSEMBLY_SCHEMA, _Manifest.patchStackTagsOnRead, options);
      }
      /**
       * Validates and saves the asset manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveAssetManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, ASSETS_SCHEMA, _Manifest.patchStackTagsOnRead);
      }
      /**
       * Load and validates the asset manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadAssetManifest(filePath) {
        return this.loadManifest(filePath, ASSETS_SCHEMA);
      }
      /**
       * Validates and saves the integ manifest to file.
       *
       * @param manifest - manifest.
       * @param filePath - output file path.
       */
      static saveIntegManifest(manifest, filePath) {
        _Manifest.saveManifest(manifest, filePath, INTEG_SCHEMA);
      }
      /**
       * Load and validates the integ manifest from file.
       *
       * @param filePath - path to the manifest file.
       */
      static loadIntegManifest(filePath) {
        const manifest = this.loadManifest(filePath, INTEG_SCHEMA);
        return {
          ...manifest,
          testCases: manifest.testCases ?? []
        };
      }
      /**
       * Fetch the current schema version number.
       */
      static version() {
        return `${SCHEMA_VERSION.revision}.0.0`;
      }
      /**
       * Return the CLI version that supports this Cloud Assembly Schema version
       */
      static cliVersion() {
        const version2 = CLI_VERSION.version;
        return version2 ? version2 : void 0;
      }
      /**
       * Deprecated
       * @deprecated use `saveAssemblyManifest()`
       */
      static save(manifest, filePath) {
        return this.saveAssemblyManifest(manifest, filePath);
      }
      /**
       * Deprecated
       * @deprecated use `loadAssemblyManifest()`
       */
      static load(filePath) {
        return this.loadAssemblyManifest(filePath);
      }
      static validate(manifest, schema, options) {
        function parseVersion(version2) {
          const ver = semver.valid(version2);
          if (!ver) {
            throw new Error(`Invalid semver string: "${version2}"`);
          }
          return ver;
        }
        const maxSupported = semver.major(parseVersion(_Manifest.version()));
        const actual = parseVersion(manifest.version);
        if (maxSupported < semver.major(actual) && !(options == null ? void 0 : options.skipVersionCheck)) {
          const cliVersion2 = manifest.minimumCliVersion;
          let cliWarning = "";
          if (cliVersion2) {
            cliWarning = `. You need at least CLI version ${cliVersion2} to read this manifest.`;
          }
          throw new Error(
            `${VERSION_MISMATCH}: Maximum schema version supported is ${maxSupported}.x.x, but found ${actual}${cliWarning}`
          );
        }
        const validator = new jsonschema.Validator();
        const result3 = validator.validate(manifest, schema, {
          // does exist but is not in the TypeScript definitions
          nestedErrors: true,
          allowUnknownAttributes: false,
          preValidateProperty: _Manifest.validateAssumeRoleAdditionalOptions
        });
        let errors = result3.errors;
        if (options == null ? void 0 : options.skipEnumCheck) {
          errors = stripEnumErrors(errors);
        }
        if (errors.length > 0) {
          throw new Error(`Invalid assembly manifest:
${errors.map((e3) => e3.stack).join("\n")}`);
        }
      }
      static saveManifest(manifest, filePath, schema, preprocess) {
        let withVersion = {
          ...manifest,
          version: _Manifest.version(),
          minimumCliVersion: _Manifest.cliVersion()
        };
        _Manifest.validate(withVersion, schema);
        if (preprocess) {
          withVersion = preprocess(withVersion);
        }
        fs.writeFileSync(filePath, JSON.stringify(withVersion, void 0, 2));
      }
      static loadManifest(filePath, schema, preprocess, options) {
        const contents = fs.readFileSync(filePath, { encoding: "utf-8" });
        let obj;
        try {
          obj = JSON.parse(contents);
        } catch (e3) {
          throw new Error(`${e3.message}, while parsing ${JSON.stringify(contents)}`);
        }
        if (preprocess) {
          obj = preprocess(obj);
        }
        _Manifest.validate(obj, schema, options);
        return obj;
      }
      /**
       * This requires some explaining...
       *
       * We previously used `{ Key, Value }` for the object that represents a stack tag. (Notice the casing)
       * @link https://github.com/aws/aws-cdk/blob/v1.27.0/packages/aws-cdk/lib/api/cxapp/stacks.ts#L427.
       *
       * When that object moved to this package, it had to be JSII compliant, which meant the property
       * names must be `camelCased`, and not `PascalCased`. This meant it no longer matches the structure in the `manifest.json` file.
       * In order to support current manifest files, we have to translate the `PascalCased` representation to the new `camelCased` one.
       *
       * Note that the serialization itself still writes `PascalCased` because it relates to how CloudFormation expects it.
       *
       * Ideally, we would start writing the `camelCased` and translate to how CloudFormation expects it when needed. But this requires nasty
       * backwards-compatibility code and it just doesn't seem to be worth the effort.
       */
      static patchStackTagsOnRead(manifest) {
        return _Manifest.replaceStackTags(
          manifest,
          (tags) => tags.map((diskTag) => ({
            key: diskTag.Key,
            value: diskTag.Value
          }))
        );
      }
      /**
       * Validates that `assumeRoleAdditionalOptions` doesn't contain nor `ExternalId` neither `RoleArn`, as they
       * should have dedicated properties preceding this (e.g `assumeRoleArn` and `assumeRoleExternalId`).
       */
      static validateAssumeRoleAdditionalOptions(instance, key, _schema, _options4, _ctx) {
        if (key !== "assumeRoleAdditionalOptions") {
          return;
        }
        const assumeRoleOptions = instance[key];
        if (assumeRoleOptions == null ? void 0 : assumeRoleOptions.RoleArn) {
          throw new Error(`RoleArn is not allowed inside '${key}'`);
        }
        if (assumeRoleOptions == null ? void 0 : assumeRoleOptions.ExternalId) {
          throw new Error(`ExternalId is not allowed inside '${key}'`);
        }
      }
      /**
       * See explanation on `patchStackTagsOnRead`
       *
       * Translate stack tags metadata if it has the "right" casing.
       */
      static patchStackTagsOnWrite(manifest) {
        return _Manifest.replaceStackTags(
          manifest,
          (tags) => tags.map(
            (memTag) => (
              // Might already be uppercased (because stack synthesis generates it in final form yet)
              "Key" in memTag ? memTag : { Key: memTag.key, Value: memTag.value }
            )
          )
        );
      }
      /**
       * Recursively replace stack tags in the stack metadata
       */
      static replaceStackTags(manifest, fn) {
        return noUndefined({
          ...manifest,
          artifacts: mapValues(manifest.artifacts, (artifact) => {
            if (artifact.type !== "aws:cloudformation:stack" /* AWS_CLOUDFORMATION_STACK */) {
              return artifact;
            }
            return noUndefined({
              ...artifact,
              metadata: mapValues(
                artifact.metadata,
                (metadataEntries) => metadataEntries.map((metadataEntry) => {
                  if (metadataEntry.type !== "aws:cdk:stack-tags" /* STACK_TAGS */ || !metadataEntry.data) {
                    return metadataEntry;
                  }
                  return {
                    ...metadataEntry,
                    data: fn(metadataEntry.data)
                  };
                })
              )
            });
          })
        });
      }
      constructor() {
      }
    };
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/schema.ts
var init_schema3 = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/schema.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/common.ts
var RequireApproval;
var init_common = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/common.ts"() {
    "use strict";
    RequireApproval = /* @__PURE__ */ ((RequireApproval5) => {
      RequireApproval5["NEVER"] = "never";
      RequireApproval5["ANYCHANGE"] = "any-change";
      RequireApproval5["BROADENING"] = "broadening";
      return RequireApproval5;
    })(RequireApproval || {});
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/deploy.ts
var init_deploy = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/deploy.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/destroy.ts
var init_destroy = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/destroy.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/index.ts
var init_commands = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/commands/index.ts"() {
    "use strict";
    init_common();
    init_deploy();
    init_destroy();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/test-case.ts
var init_test_case = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/test-case.ts"() {
    "use strict";
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/integ-tests/index.ts
var integ_tests_exports = {};
__export(integ_tests_exports, {
  RequireApproval: () => RequireApproval
});
var init_integ_tests = __esm({
  "../@aws-cdk/cloud-assembly-schema/lib/integ-tests/index.ts"() {
    "use strict";
    init_schema3();
    init_commands();
    init_test_case();
  }
});

// ../@aws-cdk/cloud-assembly-schema/lib/index.js
var require_lib2 = __commonJS({
  "../@aws-cdk/cloud-assembly-schema/lib/index.js"(exports2) {
    "use strict";
    var __createBinding3 = exports2 && exports2.__createBinding || (Object.create ? function(o3, m3, k3, k22) {
      if (k22 === void 0) k22 = k3;
      var desc = Object.getOwnPropertyDescriptor(m3, k3);
      if (!desc || ("get" in desc ? !m3.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m3[k3];
        } };
      }
      Object.defineProperty(o3, k22, desc);
    } : function(o3, m3, k3, k22) {
      if (k22 === void 0) k22 = k3;
      o3[k22] = m3[k3];
    });
    var __exportStar3 = exports2 && exports2.__exportStar || function(m3, exports3) {
      for (var p3 in m3) if (p3 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p3)) __createBinding3(exports3, m3, p3);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar3((init_cloud_assembly(), __toCommonJS(cloud_assembly_exports)), exports2);
    __exportStar3((init_assets(), __toCommonJS(assets_exports)), exports2);
    __exportStar3((init_manifest(), __toCommonJS(manifest_exports)), exports2);
    __exportStar3((init_integ_tests(), __toCommonJS(integ_tests_exports)), exports2);
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/cxapi.js
var require_cxapi = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/cxapi.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSMPARAM_NO_INVALIDATE = exports2.PROVIDER_ERROR_KEY = exports2.TOOLKIT_VERSION_ENV = exports2.CLI_VERSION_ENV = exports2.CLI_ASM_VERSION_ENV = exports2.DEFAULT_REGION_ENV = exports2.DEFAULT_ACCOUNT_ENV = exports2.CONTEXT_OVERFLOW_LOCATION_ENV = exports2.CONTEXT_ENV = exports2.OUTDIR_ENV = void 0;
    exports2.OUTDIR_ENV = "CDK_OUTDIR";
    exports2.CONTEXT_ENV = "CDK_CONTEXT_JSON";
    exports2.CONTEXT_OVERFLOW_LOCATION_ENV = "CONTEXT_OVERFLOW_LOCATION_ENV";
    exports2.DEFAULT_ACCOUNT_ENV = "CDK_DEFAULT_ACCOUNT";
    exports2.DEFAULT_REGION_ENV = "CDK_DEFAULT_REGION";
    exports2.CLI_ASM_VERSION_ENV = "CDK_CLI_ASM_VERSION";
    exports2.CLI_VERSION_ENV = "CDK_CLI_VERSION";
    exports2.TOOLKIT_VERSION_ENV = "CDK_TOOLKIT_VERSION";
    exports2.PROVIDER_ERROR_KEY = "$providerError";
    exports2.SSMPARAM_NO_INVALIDATE = "[cdk:skip]";
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/vpc.js
var require_vpc = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/vpc.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.VpcSubnetGroupType = void 0;
    var VpcSubnetGroupType2;
    (function(VpcSubnetGroupType3) {
      VpcSubnetGroupType3["PUBLIC"] = "Public";
      VpcSubnetGroupType3["PRIVATE"] = "Private";
      VpcSubnetGroupType3["ISOLATED"] = "Isolated";
    })(VpcSubnetGroupType2 || (exports2.VpcSubnetGroupType = VpcSubnetGroupType2 = {}));
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/ami.js
var require_ami = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/ami.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/load-balancer.js
var require_load_balancer = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/load-balancer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LoadBalancerIpAddressType = void 0;
    var LoadBalancerIpAddressType2;
    (function(LoadBalancerIpAddressType3) {
      LoadBalancerIpAddressType3["IPV4"] = "ipv4";
      LoadBalancerIpAddressType3["DUAL_STACK"] = "dualstack";
      LoadBalancerIpAddressType3["DUAL_STACK_WITHOUT_PUBLIC_IPV4"] = "dualstack-without-public-ipv4";
    })(LoadBalancerIpAddressType2 || (exports2.LoadBalancerIpAddressType = LoadBalancerIpAddressType2 = {}));
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/availability-zones.js
var require_availability_zones = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/availability-zones.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = void 0;
    exports2.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = "aws:cdk:availability-zones:fallback";
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/endpoint-service-availability-zones.js
var require_endpoint_service_availability_zones = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/endpoint-service-availability-zones.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = void 0;
    exports2.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones";
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/security-group.js
var require_security_group = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/security-group.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/context/key.js
var require_key = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/context/key.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../node_modules/@aws-cdk/cx-api/.warnings.jsii.js
var require_warnings_jsii = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/.warnings.jsii.js"(exports2, module2) {
    function _aws_cdk_cx_api_VpcSubnetGroupType(p3) {
    }
    function _aws_cdk_cx_api_VpcSubnet(p3) {
    }
    function _aws_cdk_cx_api_VpcSubnetGroup(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if (p3.subnets != null) {
          for (const o3 of p3.subnets)
            if (!visitedObjects.has(o3))
              _aws_cdk_cx_api_VpcSubnet(o3);
        }
        if (!visitedObjects.has(p3.type))
          _aws_cdk_cx_api_VpcSubnetGroupType(p3.type);
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_VpcContextResponse(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if (p3.subnetGroups != null) {
          for (const o3 of p3.subnetGroups)
            if (!visitedObjects.has(o3))
              _aws_cdk_cx_api_VpcSubnetGroup(o3);
        }
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_LoadBalancerIpAddressType(p3) {
    }
    function _aws_cdk_cx_api_LoadBalancerContextResponse(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if (!visitedObjects.has(p3.ipAddressType))
          _aws_cdk_cx_api_LoadBalancerIpAddressType(p3.ipAddressType);
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_LoadBalancerListenerContextResponse(p3) {
    }
    function _aws_cdk_cx_api_EndpointServiceAvailabilityZonesContextQuery(p3) {
    }
    function _aws_cdk_cx_api_SecurityGroupContextResponse(p3) {
    }
    function _aws_cdk_cx_api_KeyContextResponse(p3) {
    }
    function _aws_cdk_cx_api_AwsCloudFormationStackProperties(p3) {
    }
    function _aws_cdk_cx_api_CloudArtifact(p3) {
    }
    function _aws_cdk_cx_api_AssetManifestArtifact(p3) {
    }
    function _aws_cdk_cx_api_CloudFormationStackArtifact(p3) {
    }
    function _aws_cdk_cx_api_TreeCloudArtifact(p3) {
    }
    function _aws_cdk_cx_api_NestedCloudAssemblyArtifact(p3) {
    }
    function _aws_cdk_cx_api_CloudAssembly(p3) {
    }
    function _aws_cdk_cx_api_CloudAssemblyBuilderProps(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if (!visitedObjects.has(p3.parentBuilder))
          _aws_cdk_cx_api_CloudAssemblyBuilder(p3.parentBuilder);
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_CloudAssemblyBuilder(p3) {
    }
    function _aws_cdk_cx_api_RuntimeInfo(p3) {
    }
    function _aws_cdk_cx_api_MetadataEntry(p3) {
    }
    function _aws_cdk_cx_api_MissingContext(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if ("key" in p3)
          print2("@aws-cdk/cx-api.MissingContext#key", "moved to package 'cloud-assembly-schema'");
        if ("props" in p3)
          print2("@aws-cdk/cx-api.MissingContext#props", "moved to package 'cloud-assembly-schema'");
        if ("provider" in p3)
          print2("@aws-cdk/cx-api.MissingContext#provider", "moved to package 'cloud-assembly-schema'");
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_AssemblyBuildOptions(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if ("runtimeInfo" in p3)
          print2("@aws-cdk/cx-api.AssemblyBuildOptions#runtimeInfo", "All template modifications that should result from this should\nhave already been inserted into the template.");
        if (!visitedObjects.has(p3.runtimeInfo))
          _aws_cdk_cx_api_RuntimeInfo(p3.runtimeInfo);
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_Environment(p3) {
    }
    function _aws_cdk_cx_api_EnvironmentUtils(p3) {
    }
    function _aws_cdk_cx_api_SynthesisMessageLevel(p3) {
    }
    function _aws_cdk_cx_api_MetadataEntryResult(p3) {
    }
    function _aws_cdk_cx_api_SynthesisMessage(p3) {
      if (p3 == null)
        return;
      visitedObjects.add(p3);
      try {
        if (!visitedObjects.has(p3.level))
          _aws_cdk_cx_api_SynthesisMessageLevel(p3.level);
      } finally {
        visitedObjects.delete(p3);
      }
    }
    function _aws_cdk_cx_api_EnvironmentPlaceholders(p3) {
    }
    function _aws_cdk_cx_api_EnvironmentPlaceholderValues(p3) {
    }
    function _aws_cdk_cx_api_IEnvironmentPlaceholderProvider(p3) {
    }
    function print2(name, deprecationMessage) {
      const deprecated = process.env.JSII_DEPRECATED;
      const deprecationMode = ["warn", "fail", "quiet"].includes(deprecated) ? deprecated : "warn";
      const message2 = `${name} is deprecated.
  ${deprecationMessage.trim()}
  This API will be removed in the next major release.`;
      switch (deprecationMode) {
        case "fail":
          throw new DeprecationError(message2);
        case "warn":
          console.warn("[WARNING]", message2);
          break;
      }
    }
    function getPropertyDescriptor(obj, prop) {
      const descriptor = Object.getOwnPropertyDescriptor(obj, prop);
      if (descriptor) {
        return descriptor;
      }
      const proto = Object.getPrototypeOf(obj);
      const prototypeDescriptor = proto && getPropertyDescriptor(proto, prop);
      if (prototypeDescriptor) {
        return prototypeDescriptor;
      }
      return {};
    }
    var visitedObjects = /* @__PURE__ */ new Set();
    var DeprecationError = class extends Error {
      constructor(...args) {
        super(...args);
        Object.defineProperty(this, "name", {
          configurable: false,
          enumerable: true,
          value: "DeprecationError",
          writable: false
        });
      }
    };
    module2.exports = { print: print2, getPropertyDescriptor, DeprecationError, _aws_cdk_cx_api_VpcSubnetGroupType, _aws_cdk_cx_api_VpcSubnet, _aws_cdk_cx_api_VpcSubnetGroup, _aws_cdk_cx_api_VpcContextResponse, _aws_cdk_cx_api_LoadBalancerIpAddressType, _aws_cdk_cx_api_LoadBalancerContextResponse, _aws_cdk_cx_api_LoadBalancerListenerContextResponse, _aws_cdk_cx_api_EndpointServiceAvailabilityZonesContextQuery, _aws_cdk_cx_api_SecurityGroupContextResponse, _aws_cdk_cx_api_KeyContextResponse, _aws_cdk_cx_api_AwsCloudFormationStackProperties, _aws_cdk_cx_api_CloudArtifact, _aws_cdk_cx_api_AssetManifestArtifact, _aws_cdk_cx_api_CloudFormationStackArtifact, _aws_cdk_cx_api_TreeCloudArtifact, _aws_cdk_cx_api_NestedCloudAssemblyArtifact, _aws_cdk_cx_api_CloudAssembly, _aws_cdk_cx_api_CloudAssemblyBuilderProps, _aws_cdk_cx_api_CloudAssemblyBuilder, _aws_cdk_cx_api_RuntimeInfo, _aws_cdk_cx_api_MetadataEntry, _aws_cdk_cx_api_MissingContext, _aws_cdk_cx_api_AssemblyBuildOptions, _aws_cdk_cx_api_Environment, _aws_cdk_cx_api_EnvironmentUtils, _aws_cdk_cx_api_SynthesisMessageLevel, _aws_cdk_cx_api_MetadataEntryResult, _aws_cdk_cx_api_SynthesisMessage, _aws_cdk_cx_api_EnvironmentPlaceholders, _aws_cdk_cx_api_EnvironmentPlaceholderValues, _aws_cdk_cx_api_IEnvironmentPlaceholderProvider };
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/metadata.js
var require_metadata = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/metadata.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SynthesisMessageLevel = exports2.PATH_METADATA_KEY = void 0;
    exports2.PATH_METADATA_KEY = "aws:cdk:path";
    var SynthesisMessageLevel2;
    (function(SynthesisMessageLevel3) {
      SynthesisMessageLevel3["INFO"] = "info";
      SynthesisMessageLevel3["WARNING"] = "warning";
      SynthesisMessageLevel3["ERROR"] = "error";
    })(SynthesisMessageLevel2 || (exports2.SynthesisMessageLevel = SynthesisMessageLevel2 = {}));
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/private/error.js
var require_error = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/private/error.js"(exports2) {
    "use strict";
    var __classPrivateFieldGet2 = exports2 && exports2.__classPrivateFieldGet || function(receiver, state2, kind, f3) {
      if (kind === "a" && !f3) throw new TypeError("Private accessor was defined without a getter");
      if (typeof state2 === "function" ? receiver !== state2 || !f3 : !state2.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
      return kind === "m" ? f3 : kind === "a" ? f3.call(receiver) : f3 ? f3.value : state2.get(receiver);
    };
    var __classPrivateFieldSet2 = exports2 && exports2.__classPrivateFieldSet || function(receiver, state2, value, kind, f3) {
      if (kind === "m") throw new TypeError("Private method is not writable");
      if (kind === "a" && !f3) throw new TypeError("Private accessor was defined without a setter");
      if (typeof state2 === "function" ? receiver !== state2 || !f3 : !state2.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
      return kind === "a" ? f3.call(receiver, value) : f3 ? f3.value = value : state2.set(receiver, value), value;
    };
    var _CloudAssemblyError_time;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CloudAssemblyError = void 0;
    var ASSEMBLY_ERROR_SYMBOL2 = Symbol.for("@aws-cdk/cx-api.CloudAssemblyError");
    var CloudAssemblyError = class _CloudAssemblyError extends Error {
      /**
       * The time the error was thrown.
       */
      get time() {
        return __classPrivateFieldGet2(this, _CloudAssemblyError_time, "f");
      }
      get type() {
        return "assembly";
      }
      constructor(msg) {
        super(msg);
        _CloudAssemblyError_time.set(this, void 0);
        Object.setPrototypeOf(this, _CloudAssemblyError.prototype);
        Object.defineProperty(this, ASSEMBLY_ERROR_SYMBOL2, { value: true });
        this.name = new.target.name;
        __classPrivateFieldSet2(this, _CloudAssemblyError_time, (/* @__PURE__ */ new Date()).toISOString(), "f");
      }
    };
    exports2.CloudAssemblyError = CloudAssemblyError;
    _CloudAssemblyError_time = /* @__PURE__ */ new WeakMap();
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/cloud-artifact.js
var require_cloud_artifact = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/cloud-artifact.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CloudArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var metadata_1 = require_metadata();
    var cxschema8 = require_lib2();
    var error_1 = require_error();
    var CloudArtifact = class _CloudArtifact {
      /**
       * Returns a subclass of `CloudArtifact` based on the artifact type defined in the artifact manifest.
       *
       * @param assembly The cloud assembly from which to load the artifact
       * @param id The artifact ID
       * @param artifact The artifact manifest
       * @returns the `CloudArtifact` that matches the artifact type or `undefined` if it's an artifact type that is unrecognized by this module.
       */
      static fromManifest(assembly, id, artifact) {
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, this.fromManifest);
          }
          throw error5;
        }
        void assembly, void id, void artifact;
        throw new error_1.CloudAssemblyError("Implementation not overridden yet");
      }
      constructor(assembly, id, manifest) {
        this.assembly = assembly;
        this.id = id;
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _CloudArtifact);
          }
          throw error5;
        }
        this.manifest = manifest;
        this.messages = this.renderMessages();
        this._dependencyIDs = manifest.dependencies || [];
      }
      /**
       * Returns all the artifacts that this artifact depends on.
       */
      get dependencies() {
        if (this._deps) {
          return this._deps;
        }
        this._deps = this._dependencyIDs.map((id) => {
          const dep = this.assembly.tryGetArtifact(id);
          if (!dep) {
            throw new error_1.CloudAssemblyError(`Artifact ${this.id} depends on non-existing artifact ${id}`);
          }
          return dep;
        });
        return this._deps;
      }
      /**
       * @returns all the metadata entries of a specific type in this artifact.
       */
      findMetadataByType(type) {
        const result3 = new Array();
        for (const path34 of Object.keys(this.manifest.metadata || {})) {
          for (const entry of (this.manifest.metadata || {})[path34]) {
            if (entry.type === type) {
              result3.push({ path: path34, ...entry });
            }
          }
        }
        return result3;
      }
      renderMessages() {
        const messages = new Array();
        for (const [id, metadata] of Object.entries(this.manifest.metadata || {})) {
          for (const entry of metadata) {
            let level;
            switch (entry.type) {
              case cxschema8.ArtifactMetadataEntryType.WARN:
                level = metadata_1.SynthesisMessageLevel.WARNING;
                break;
              case cxschema8.ArtifactMetadataEntryType.ERROR:
                level = metadata_1.SynthesisMessageLevel.ERROR;
                break;
              case cxschema8.ArtifactMetadataEntryType.INFO:
                level = metadata_1.SynthesisMessageLevel.INFO;
                break;
              default:
                continue;
            }
            messages.push({ level, entry, id });
          }
        }
        return messages;
      }
      /**
       * An identifier that shows where this artifact is located in the tree
       * of nested assemblies, based on their manifests. Defaults to the normal
       * id. Should only be used in user interfaces.
       */
      get hierarchicalId() {
        return this.manifest.displayName ?? this.id;
      }
    };
    exports2.CloudArtifact = CloudArtifact;
    _a4 = JSII_RTTI_SYMBOL_1;
    CloudArtifact[_a4] = { fqn: "@aws-cdk/cx-api.CloudArtifact", version: "2.198.0" };
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/artifacts/asset-manifest-artifact.js
var require_asset_manifest_artifact = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/artifacts/asset-manifest-artifact.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AssetManifestArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs38 = require("fs");
    var path34 = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var error_1 = require_error();
    var ASSET_MANIFEST_ARTIFACT_SYM = Symbol.for("@aws-cdk/cx-api.AssetManifestArtifact");
    var AssetManifestArtifact5 = class _AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `AssetManifestArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `AssetManifestArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isAssetManifestArtifact(art) {
        return art && typeof art === "object" && art[ASSET_MANIFEST_ARTIFACT_SYM];
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _AssetManifestArtifact);
          }
          throw error5;
        }
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new error_1.CloudAssemblyError('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path34.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
      }
      /**
       * The Asset Manifest contents
       */
      get contents() {
        if (this._contents !== void 0) {
          return this._contents;
        }
        const contents = this._contents = JSON.parse(fs38.readFileSync(this.file, "utf-8"));
        return contents;
      }
    };
    exports2.AssetManifestArtifact = AssetManifestArtifact5;
    _a4 = JSII_RTTI_SYMBOL_1;
    AssetManifestArtifact5[_a4] = { fqn: "@aws-cdk/cx-api.AssetManifestArtifact", version: "2.198.0" };
    Object.defineProperty(AssetManifestArtifact5.prototype, ASSET_MANIFEST_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/environment.js
var require_environment = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/environment.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EnvironmentUtils = exports2.UNKNOWN_REGION = exports2.UNKNOWN_ACCOUNT = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var error_1 = require_error();
    var AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
    exports2.UNKNOWN_ACCOUNT = "unknown-account";
    exports2.UNKNOWN_REGION = "unknown-region";
    var EnvironmentUtils4 = class {
      static parse(environment) {
        const env2 = AWS_ENV_REGEX.exec(environment);
        if (!env2) {
          throw new error_1.CloudAssemblyError(`Unable to parse environment specification "${environment}". Expected format: aws://account/region`);
        }
        const [, account, region] = env2;
        if (!account || !region) {
          throw new error_1.CloudAssemblyError(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
      }
      /**
       * Build an environment object from an account and region
       */
      static make(account, region) {
        return { account, region, name: this.format(account, region) };
      }
      /**
       * Format an environment string from an account and region
       */
      static format(account, region) {
        return `aws://${account}/${region}`;
      }
    };
    exports2.EnvironmentUtils = EnvironmentUtils4;
    _a4 = JSII_RTTI_SYMBOL_1;
    EnvironmentUtils4[_a4] = { fqn: "@aws-cdk/cx-api.EnvironmentUtils", version: "2.198.0" };
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/artifacts/cloudformation-artifact.js
var require_cloudformation_artifact = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/artifacts/cloudformation-artifact.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CloudFormationStackArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs38 = require("fs");
    var path34 = require("path");
    var cxschema8 = require_lib2();
    var cloud_artifact_1 = require_cloud_artifact();
    var environment_1 = require_environment();
    var error_1 = require_error();
    var CLOUDFORMATION_STACK_ARTIFACT_SYM = Symbol.for("@aws-cdk/cx-api.CloudFormationStackArtifact");
    var CloudFormationStackArtifact2 = class _CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `CloudFormationStackArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `CloudFormationStackArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isCloudFormationStackArtifact(art) {
        return art && typeof art === "object" && art[CLOUDFORMATION_STACK_ARTIFACT_SYM];
      }
      constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _CloudFormationStackArtifact);
          }
          throw error5;
        }
        const properties = this.manifest.properties || {};
        if (!properties.templateFile) {
          throw new error_1.CloudAssemblyError('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
          throw new error_1.CloudAssemblyError("Invalid CloudFormation stack artifact. Missing environment");
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters ?? {};
        this.tags = properties.tags ?? this.tagsFromMetadata();
        this.notificationArns = properties.notificationArns;
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.assumeRoleAdditionalOptions = properties.assumeRoleAdditionalOptions;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema8.ArtifactMetadataEntryType.ASSET).map((e3) => e3.data);
        this.displayName = this.stackName === artifactId ? this.hierarchicalId : `${this.hierarchicalId} (${this.stackName})`;
        this.name = this.stackName;
        this.originalName = this.stackName;
      }
      /**
       * Full path to the template file
       */
      get templateFullPath() {
        return path34.join(this.assembly.directory, this.templateFile);
      }
      /**
       * The CloudFormation template for this stack.
       */
      get template() {
        if (this._template === void 0) {
          this._template = JSON.parse(fs38.readFileSync(this.templateFullPath, "utf-8"));
        }
        return this._template;
      }
      tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema8.ArtifactMetadataEntryType.STACK_TAGS)) {
          for (const tag of metadataEntry.data ?? []) {
            ret[tag.key] = tag.value;
          }
        }
        return ret;
      }
    };
    exports2.CloudFormationStackArtifact = CloudFormationStackArtifact2;
    _a4 = JSII_RTTI_SYMBOL_1;
    CloudFormationStackArtifact2[_a4] = { fqn: "@aws-cdk/cx-api.CloudFormationStackArtifact", version: "2.198.0" };
    Object.defineProperty(CloudFormationStackArtifact2.prototype, CLOUDFORMATION_STACK_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js
var require_nested_cloud_assembly_artifact = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NestedCloudAssemblyArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path34 = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var NESTED_CLOUD_ASSEMBLY_SYM = Symbol.for("@aws-cdk/cx-api.NestedCloudAssemblyArtifact");
    var NestedCloudAssemblyArtifact2 = class _NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `NestedCloudAssemblyArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `NestedCloudAssemblyArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isNestedCloudAssemblyArtifact(art) {
        return art && typeof art === "object" && art[NESTED_CLOUD_ASSEMBLY_SYM];
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _NestedCloudAssemblyArtifact);
          }
          throw error5;
        }
        const properties = this.manifest.properties || {};
        this.directoryName = properties.directoryName;
        this.displayName = properties.displayName ?? name;
      }
      /**
       * Full path to the nested assembly directory
       */
      get fullPath() {
        return path34.join(this.assembly.directory, this.directoryName);
      }
    };
    exports2.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact2;
    _a4 = JSII_RTTI_SYMBOL_1;
    NestedCloudAssemblyArtifact2[_a4] = { fqn: "@aws-cdk/cx-api.NestedCloudAssemblyArtifact", version: "2.198.0" };
    Object.defineProperty(NestedCloudAssemblyArtifact2.prototype, NESTED_CLOUD_ASSEMBLY_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/artifacts/tree-cloud-artifact.js
var require_tree_cloud_artifact = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/artifacts/tree-cloud-artifact.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TreeCloudArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cloud_artifact_1 = require_cloud_artifact();
    var error_1 = require_error();
    var TREE_CLOUD_ARTIFACT_SYM = Symbol.for("@aws-cdk/cx-api.TreeCloudArtifact");
    var TreeCloudArtifact = class _TreeCloudArtifact extends cloud_artifact_1.CloudArtifact {
      /**
       * Checks if `art` is an instance of this class.
       *
       * Use this method instead of `instanceof` to properly detect `TreeCloudArtifact`
       * instances, even when the construct library is symlinked.
       *
       * Explanation: in JavaScript, multiple copies of the `cx-api` library on
       * disk are seen as independent, completely different libraries. As a
       * consequence, the class `TreeCloudArtifact` in each copy of the `cx-api` library
       * is seen as a different class, and an instance of one class will not test as
       * `instanceof` the other class. `npm install` will not create installations
       * like this, but users may manually symlink construct libraries together or
       * use a monorepo tool: in those cases, multiple copies of the `cx-api`
       * library can be accidentally installed, and `instanceof` will behave
       * unpredictably. It is safest to avoid using `instanceof`, and using
       * this type-testing method instead.
       */
      static isTreeCloudArtifact(art) {
        return art && typeof art === "object" && art[TREE_CLOUD_ARTIFACT_SYM];
      }
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssembly(assembly);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _TreeCloudArtifact);
          }
          throw error5;
        }
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new error_1.CloudAssemblyError('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
      }
    };
    exports2.TreeCloudArtifact = TreeCloudArtifact;
    _a4 = JSII_RTTI_SYMBOL_1;
    TreeCloudArtifact[_a4] = { fqn: "@aws-cdk/cx-api.TreeCloudArtifact", version: "2.198.0" };
    Object.defineProperty(TreeCloudArtifact.prototype, TREE_CLOUD_ARTIFACT_SYM, {
      value: true,
      enumerable: false,
      writable: false
    });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/cloud-artifact-aug.js
var require_cloud_artifact_aug = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/cloud-artifact-aug.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var asset_manifest_artifact_1 = require_asset_manifest_artifact();
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
    var cloud_artifact_1 = require_cloud_artifact();
    var cxschema8 = require_lib2();
    cloud_artifact_1.CloudArtifact.fromManifest = function fromManifest(assembly, id, artifact) {
      switch (artifact.type) {
        case cxschema8.ArtifactType.AWS_CLOUDFORMATION_STACK:
          return new cloudformation_artifact_1.CloudFormationStackArtifact(assembly, id, artifact);
        case cxschema8.ArtifactType.CDK_TREE:
          return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
        case cxschema8.ArtifactType.ASSET_MANIFEST:
          return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
        case cxschema8.ArtifactType.NESTED_CLOUD_ASSEMBLY:
          return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
          return void 0;
      }
    };
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/toposort.js
var require_toposort = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/toposort.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.topologicalSort = topologicalSort;
    var error_1 = require_error();
    function topologicalSort(xs, keyFn, depFn) {
      const remaining = /* @__PURE__ */ new Map();
      for (const element of xs) {
        const key = keyFn(element);
        remaining.set(key, { key, element, dependencies: depFn(element) });
      }
      const ret = new Array();
      while (remaining.size > 0) {
        const selectable = Array.from(remaining.values()).filter((e3) => e3.dependencies.every((d3) => !remaining.has(d3)));
        selectable.sort((a3, b3) => a3.key < b3.key ? -1 : b3.key < a3.key ? 1 : 0);
        for (const selected of selectable) {
          ret.push(selected.element);
          remaining.delete(selected.key);
        }
        if (selectable.length === 0) {
          throw new error_1.CloudAssemblyError(`Could not determine ordering between: ${Array.from(remaining.keys()).join(", ")}`);
        }
      }
      return ret;
    }
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/cloud-assembly.js
var require_cloud_assembly = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/cloud-assembly.js"(exports2) {
    "use strict";
    var _a4;
    var _b2;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CloudAssemblyBuilder = exports2.CloudAssembly = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs38 = require("fs");
    var os12 = require("os");
    var path34 = require("path");
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
    var cloud_artifact_1 = require_cloud_artifact();
    var toposort_1 = require_toposort();
    var cxschema8 = require_lib2();
    var error_1 = require_error();
    var CLOUD_ASSEMBLY_SYMBOL = Symbol.for("@aws-cdk/cx-api.CloudAssembly");
    var MANIFEST_FILE = "manifest.json";
    var CloudAssembly6 = class {
      /**
       * Return whether the given object is a CloudAssembly.
       *
       * We do attribute detection since we can't reliably use 'instanceof'.
       */
      static isCloudAssembly(x3) {
        return x3 !== null && typeof x3 === "object" && CLOUD_ASSEMBLY_SYMBOL in x3;
      }
      /**
       * Reads a cloud assembly from the specified directory.
       * @param directory The root directory of the assembly.
       */
      constructor(directory, loadOptions) {
        this.directory = directory;
        this.manifest = cxschema8.Manifest.loadAssemblyManifest(path34.join(directory, MANIFEST_FILE), loadOptions);
        this.version = this.manifest.version;
        this.artifacts = this.renderArtifacts((loadOptions == null ? void 0 : loadOptions.topoSort) ?? true);
        this.runtime = this.manifest.runtime || { libraries: {} };
        Object.defineProperty(this, CLOUD_ASSEMBLY_SYMBOL, { value: true });
        this.validateDeps();
      }
      /**
       * Attempts to find an artifact with a specific identity.
       * @returns A `CloudArtifact` object or `undefined` if the artifact does not exist in this assembly.
       * @param id The artifact ID
       */
      tryGetArtifact(id) {
        return this.artifacts.find((a3) => a3.id === id);
      }
      /**
       * Returns a CloudFormation stack artifact from this assembly.
       *
       * Will only search the current assembly.
       *
       * @param stackName the name of the CloudFormation stack.
       * @throws if there is no stack artifact by that name
       * @throws if there is more than one stack with the same stack name. You can
       * use `getStackArtifact(stack.artifactId)` instead.
       * @returns a `CloudFormationStackArtifact` object.
       */
      getStackByName(stackName) {
        const artifacts = this.artifacts.filter((a3) => a3 instanceof cloudformation_artifact_1.CloudFormationStackArtifact && a3.stackName === stackName);
        if (!artifacts || artifacts.length === 0) {
          throw new error_1.CloudAssemblyError(`Unable to find stack with stack name "${stackName}"`);
        }
        if (artifacts.length > 1) {
          throw new error_1.CloudAssemblyError(`There are multiple stacks with the stack name "${stackName}" (${artifacts.map((a3) => a3.id).join(",")}). Use "getStackArtifact(id)" instead`);
        }
        return artifacts[0];
      }
      /**
       * Returns a CloudFormation stack artifact by name from this assembly.
       * @deprecated renamed to `getStackByName` (or `getStackArtifact(id)`)
       */
      getStack(stackName) {
        try {
          jsiiDeprecationWarnings.print("@aws-cdk/cx-api.CloudAssembly#getStack", "renamed to `getStackByName` (or `getStackArtifact(id)`)");
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, this.getStack);
          }
          throw error5;
        }
        return this.getStackByName(stackName);
      }
      /**
       * Returns a CloudFormation stack artifact from this assembly.
       *
       * @param artifactId the artifact id of the stack (can be obtained through `stack.artifactId`).
       * @throws if there is no stack artifact with that id
       * @returns a `CloudFormationStackArtifact` object.
       */
      getStackArtifact(artifactId) {
        const artifact = this.tryGetArtifactRecursively(artifactId);
        if (!artifact) {
          throw new error_1.CloudAssemblyError(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof cloudformation_artifact_1.CloudFormationStackArtifact)) {
          throw new error_1.CloudAssemblyError(`Artifact ${artifactId} is not a CloudFormation stack`);
        }
        return artifact;
      }
      tryGetArtifactRecursively(artifactId) {
        return this.stacksRecursively.find((a3) => a3.id === artifactId);
      }
      /**
       * Returns all the stacks, including the ones in nested assemblies
       */
      get stacksRecursively() {
        function search(stackArtifacts, assemblies) {
          if (assemblies.length === 0) {
            return stackArtifacts;
          }
          const [head, ...tail] = assemblies;
          const nestedAssemblies = head.nestedAssemblies.map((asm) => asm.nestedAssembly);
          return search(stackArtifacts.concat(head.stacks), tail.concat(nestedAssemblies));
        }
        return search([], [this]);
      }
      /**
       * Returns a nested assembly artifact.
       *
       * @param artifactId The artifact ID of the nested assembly
       */
      getNestedAssemblyArtifact(artifactId) {
        const artifact = this.tryGetArtifact(artifactId);
        if (!artifact) {
          throw new error_1.CloudAssemblyError(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact)) {
          throw new error_1.CloudAssemblyError(`Found artifact '${artifactId}' but it's not a nested cloud assembly`);
        }
        return artifact;
      }
      /**
       * Returns a nested assembly.
       *
       * @param artifactId The artifact ID of the nested assembly
       */
      getNestedAssembly(artifactId) {
        return this.getNestedAssemblyArtifact(artifactId).nestedAssembly;
      }
      /**
       * Returns the tree metadata artifact from this assembly.
       * @throws if there is no metadata artifact by that name
       * @returns a `TreeCloudArtifact` object if there is one defined in the manifest, `undefined` otherwise.
       */
      tree() {
        const trees = this.artifacts.filter((a3) => a3.manifest.type === cxschema8.ArtifactType.CDK_TREE);
        if (trees.length === 0) {
          return void 0;
        } else if (trees.length > 1) {
          throw new error_1.CloudAssemblyError(`Multiple artifacts of type ${cxschema8.ArtifactType.CDK_TREE} found in manifest`);
        }
        const tree = trees[0];
        if (!(tree instanceof tree_cloud_artifact_1.TreeCloudArtifact)) {
          throw new error_1.CloudAssemblyError('"Tree" artifact is not of expected type');
        }
        return tree;
      }
      /**
       * @returns all the CloudFormation stack artifacts that are included in this assembly.
       */
      get stacks() {
        return this.artifacts.filter(isCloudFormationStackArtifact);
        function isCloudFormationStackArtifact(x3) {
          return x3 instanceof cloudformation_artifact_1.CloudFormationStackArtifact;
        }
      }
      /**
       * The nested assembly artifacts in this assembly
       */
      get nestedAssemblies() {
        return this.artifacts.filter(isNestedCloudAssemblyArtifact);
        function isNestedCloudAssemblyArtifact(x3) {
          return x3 instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact;
        }
      }
      validateDeps() {
        for (const artifact of this.artifacts) {
          ignore(artifact.dependencies);
        }
      }
      renderArtifacts(topoSort) {
        const result3 = new Array();
        for (const [name, artifact] of Object.entries(this.manifest.artifacts || {})) {
          const cloudartifact = cloud_artifact_1.CloudArtifact.fromManifest(this, name, artifact);
          if (cloudartifact) {
            result3.push(cloudartifact);
          }
        }
        return topoSort ? (0, toposort_1.topologicalSort)(result3, (x3) => x3.id, (x3) => x3._dependencyIDs) : result3;
      }
    };
    exports2.CloudAssembly = CloudAssembly6;
    _a4 = JSII_RTTI_SYMBOL_1;
    CloudAssembly6[_a4] = { fqn: "@aws-cdk/cx-api.CloudAssembly", version: "2.198.0" };
    var CloudAssemblyBuilder2 = class _CloudAssemblyBuilder {
      /**
       * Initializes a cloud assembly builder.
       * @param outdir The output directory, uses temporary directory if undefined
       */
      constructor(outdir, props = {}) {
        this.artifacts = {};
        this.missing = new Array();
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_CloudAssemblyBuilderProps(props);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, _CloudAssemblyBuilder);
          }
          throw error5;
        }
        this.outdir = determineOutputDirectory(outdir);
        this.assetOutdir = props.assetOutdir ?? this.outdir;
        this.parentBuilder = props.parentBuilder;
        ensureDirSync(this.outdir);
      }
      /**
       * Adds an artifact into the cloud assembly.
       * @param id The ID of the artifact.
       * @param manifest The artifact manifest
       */
      addArtifact(id, manifest) {
        this.artifacts[id] = filterUndefined(manifest);
      }
      /**
       * Reports that some context is missing in order for this cloud assembly to be fully synthesized.
       * @param missing Missing context information.
       */
      addMissing(missing) {
        var _a5;
        if (this.missing.every((m3) => m3.key !== missing.key)) {
          this.missing.push(missing);
        }
        (_a5 = this.parentBuilder) == null ? void 0 : _a5.addMissing(missing);
      }
      /**
       * Finalizes the cloud assembly into the output directory returns a
       * `CloudAssembly` object that can be used to inspect the assembly.
       */
      buildAssembly(options = {}) {
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_AssemblyBuildOptions(options);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, this.buildAssembly);
          }
          throw error5;
        }
        let manifest = {
          version: cxschema8.Manifest.version(),
          artifacts: this.artifacts,
          runtime: options.runtimeInfo,
          missing: this.missing.length > 0 ? this.missing : void 0
        };
        manifest = filterUndefined(manifest);
        const manifestFilePath = path34.join(this.outdir, MANIFEST_FILE);
        cxschema8.Manifest.saveAssemblyManifest(manifest, manifestFilePath);
        fs38.writeFileSync(path34.join(this.outdir, "cdk.out"), JSON.stringify({ version: manifest.version }));
        return new CloudAssembly6(this.outdir);
      }
      /**
       * Creates a nested cloud assembly
       */
      createNestedAssembly(artifactId, displayName) {
        const directoryName = artifactId;
        const innerAsmDir = path34.join(this.outdir, directoryName);
        this.addArtifact(artifactId, {
          type: cxschema8.ArtifactType.NESTED_CLOUD_ASSEMBLY,
          properties: {
            directoryName,
            displayName
          }
        });
        return new _CloudAssemblyBuilder(innerAsmDir, {
          // Reuse the same asset output directory as the current Casm builder
          assetOutdir: this.assetOutdir,
          parentBuilder: this
        });
      }
      /**
       * Delete the cloud assembly directory
       */
      delete() {
        fs38.rmSync(this.outdir, { recursive: true, force: true });
      }
    };
    exports2.CloudAssemblyBuilder = CloudAssemblyBuilder2;
    _b2 = JSII_RTTI_SYMBOL_1;
    CloudAssemblyBuilder2[_b2] = { fqn: "@aws-cdk/cx-api.CloudAssemblyBuilder", version: "2.198.0" };
    function filterUndefined(obj) {
      if (Array.isArray(obj)) {
        return obj.filter((x3) => x3 !== void 0).map((x3) => filterUndefined(x3));
      }
      if (typeof obj === "object") {
        const ret = {};
        for (const [key, value] of Object.entries(obj)) {
          if (value === void 0) {
            continue;
          }
          ret[key] = filterUndefined(value);
        }
        return ret;
      }
      return obj;
    }
    function ignore(_x) {
      return;
    }
    function determineOutputDirectory(outdir) {
      return outdir ?? fs38.mkdtempSync(path34.join(fs38.realpathSync(os12.tmpdir()), "cdk.out"));
    }
    function ensureDirSync(dir) {
      if (fs38.existsSync(dir)) {
        if (!fs38.statSync(dir).isDirectory()) {
          throw new error_1.CloudAssemblyError(`${dir} must be a directory`);
        }
      } else {
        fs38.mkdirSync(dir, { recursive: true });
      }
    }
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact-aug.js
var require_nested_cloud_assembly_artifact_aug = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact-aug.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var cloud_assembly_1 = require_cloud_assembly();
    var cacheSym = Symbol();
    Object.defineProperty(nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact.prototype, "nestedAssembly", {
      get() {
        if (!this[cacheSym]) {
          this[cacheSym] = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this[cacheSym];
      }
    });
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/assets.js
var require_assets = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/assets.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ASSET_PREFIX_SEPARATOR = exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY = exports2.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = exports2.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = exports2.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = exports2.ASSET_RESOURCE_METADATA_PATH_KEY = exports2.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
    exports2.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = "aws:cdk:enable-asset-metadata";
    exports2.ASSET_RESOURCE_METADATA_PATH_KEY = "aws:asset:path";
    exports2.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = "aws:asset:dockerfile-path";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = "aws:asset:docker-build-args";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SECRETS_KEY = "aws:asset:docker-build-secrets";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_SSH_KEY = "aws:asset:docker-build-ssh";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = "aws:asset:docker-build-target";
    exports2.ASSET_RESOURCE_METADATA_PROPERTY_KEY = "aws:asset:property";
    exports2.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = "aws:asset:is-bundled";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_OUTPUTS_KEY = "aws:asset:docker-outputs";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_FROM_KEY = "aws:asset:docker-cache-from";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_TO_KEY = "aws:asset:docker-cache-to";
    exports2.ASSET_RESOURCE_METADATA_DOCKER_CACHE_DISABLED_KEY = "aws:asset:docker-cache-disabled";
    exports2.ASSET_PREFIX_SEPARATOR = "||";
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/private/flag-modeling.js
var require_flag_modeling = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/private/flag-modeling.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MAGIC_V2NEXT = exports2.FlagType = void 0;
    exports2.compareVersions = compareVersions;
    var FlagType;
    (function(FlagType2) {
      FlagType2[FlagType2["ApiDefault"] = 0] = "ApiDefault";
      FlagType2[FlagType2["BugFix"] = 1] = "BugFix";
      FlagType2[FlagType2["VisibleContext"] = 2] = "VisibleContext";
      FlagType2[FlagType2["Temporary"] = 3] = "Temporary";
    })(FlagType || (exports2.FlagType = FlagType = {}));
    exports2.MAGIC_V2NEXT = "V2NEXT";
    function compareVersions(a3, b3) {
      if (a3 === b3) {
        return 0;
      }
      if (a3 === void 0) {
        return -1;
      }
      if (b3 === void 0) {
        return 1;
      }
      const as = a3.split(".").map((x3) => parseInt(x3, 10));
      const bs = b3.split(".").map((x3) => parseInt(x3, 10));
      if (a3 === exports2.MAGIC_V2NEXT) {
        return bs[0] <= 2 ? 1 : -1;
      }
      if (b3 === exports2.MAGIC_V2NEXT) {
        return as[0] <= 2 ? -1 : 1;
      }
      for (let i3 = 0; i3 < Math.min(as.length, bs.length); i3++) {
        if (as[i3] < bs[i3]) {
          return -1;
        }
        if (as[i3] > bs[i3]) {
          return 1;
        }
      }
      return as.length - bs.length;
    }
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/features.js
var require_features = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/features.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LAMBDA_NODEJS_USE_LATEST_RUNTIME = exports2.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = exports2.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = exports2.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = exports2.EFS_DENY_ANONYMOUS_ACCESS = exports2.KMS_ALIAS_NAME_REF = exports2.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = exports2.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = exports2.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = exports2.ENABLE_EMR_SERVICE_POLICY_V2 = exports2.REDSHIFT_COLUMN_ID = exports2.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = exports2.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = exports2.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = exports2.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = exports2.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = exports2.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = exports2.ROUTE53_PATTERNS_USE_CERTIFICATE = exports2.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = exports2.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = exports2.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = exports2.ENABLE_PARTITION_LITERALS = exports2.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = exports2.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = exports2.S3_CREATE_DEFAULT_LOGGING_POLICY = exports2.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = exports2.VALIDATE_SNAPSHOT_REMOVAL_POLICY = exports2.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = exports2.IAM_MINIMIZE_POLICIES = exports2.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = exports2.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = exports2.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = exports2.TARGET_PARTITIONS = exports2.CHECK_SECRET_USAGE = exports2.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports2.LAMBDA_RECOGNIZE_LAYER_VERSION = exports2.LAMBDA_RECOGNIZE_VERSION_PROPS = exports2.EFS_DEFAULT_ENCRYPTION_AT_REST = exports2.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports2.RDS_LOWERCASE_DB_IDENTIFIER = exports2.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports2.S3_GRANT_WRITE_WITHOUT_ACL = exports2.KMS_DEFAULT_KEY_POLICIES = exports2.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports2.DOCKER_IGNORE_SUPPORT = exports2.STACK_RELATIVE_EXPORTS_CONTEXT = exports2.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports2.ENABLE_DIFF_NO_FAIL = exports2.ENABLE_DIFF_NO_FAIL_CONTEXT = exports2.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
    exports2.FUTURE_FLAGS = exports2.FUTURE_FLAGS_EXPIRED = exports2.CURRENT_VERSION_FLAG_DEFAULTS = exports2.CURRENTLY_RECOMMENDED_FLAGS = exports2.CURRENT_VERSION_EXPIRED_FLAGS = exports2.FLAGS = exports2.S3_PUBLIC_ACCESS_BLOCKED_BY_DEFAULT = exports2.USE_RESOURCEID_FOR_VPCV2_MIGRATION = exports2.EC2_REQUIRE_PRIVATE_SUBNETS_FOR_EGRESSONLYINTERNETGATEWAY = exports2.S3_TRUST_KEY_POLICY_FOR_SNS_SUBSCRIPTIONS = exports2.PIPELINE_REDUCE_CROSS_ACCOUNT_ACTION_ROLE_TRUST_SCOPE = exports2.LOG_USER_POOL_CLIENT_SECRET_VALUE = exports2.DYNAMODB_TABLE_RETAIN_TABLE_REPLICA = exports2.ASPECT_PRIORITIES_MUTATING = exports2.EVENTBUS_POLICY_SID_REQUIRED = exports2.PIPELINE_REDUCE_STAGE_ROLE_TRUST_SCOPE = exports2.SET_UNIQUE_REPLICATION_ROLE_NAME = exports2.LAMBDA_CREATE_NEW_POLICIES_WITH_ADDTOROLEPOLICY = exports2.ENABLE_ADDITIONAL_METADATA_COLLECTION = exports2.IAM_OIDC_REJECT_UNAUTHORIZED_CONNECTIONS = exports2.ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT = exports2.Disable_ECS_IMDS_Blocking = exports2.Enable_IMDS_Blocking_Deprecated_Feature = exports2.USER_POOL_DOMAIN_NAME_METHOD_WITHOUT_CUSTOM_RESOURCE = exports2.ASPECT_STABILIZATION = exports2.BASTION_HOST_USE_AMAZON_LINUX_2023_BY_DEFAULT = exports2.STEPFUNCTIONS_USE_DISTRIBUTED_MAP_RESULT_WRITER_V2 = exports2.STEPFUNCTIONS_TASKS_FIX_RUN_ECS_TASK_POLICY = exports2.LAMBDA_NODEJS_SDK_V3_EXCLUDE_SMITHY_PACKAGES = exports2.CFN_INCLUDE_REJECT_COMPLEX_RESOURCE_UPDATE_CREATE_POLICY_INTRINSICS = exports2.USE_CORRECT_VALUE_FOR_INSTANCE_RESOURCE_ID_PROPERTY = exports2.APPSYNC_GRAPHQLAPI_SCOPE_LAMBDA_FUNCTION_PERMISSION = exports2.EC2_SUM_TIMEOUT_ENABLED = exports2.DYNAMODB_TABLEV2_RESOURCE_POLICY_PER_REPLICA = exports2.REDUCE_EC2_FARGATE_CLOUDWATCH_PERMISSIONS = exports2.USE_NEW_S3URI_PARAMETERS_FOR_BEDROCK_INVOKE_MODEL_TASK = exports2.S3_KEEP_NOTIFICATION_IN_IMPORTED_BUCKET = exports2.LOG_API_RESPONSE_DATA_PROPERTY_TRUE_DEFAULT = exports2.ECS_REMOVE_DEFAULT_DEPLOYMENT_ALARM = exports2.EBS_DEFAULT_GP3 = exports2.EKS_NODEGROUP_NAME = exports2.PIPELINE_REDUCE_ASSET_ROLE_TRUST_SCOPE = exports2.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE = exports2.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2 = exports2.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE = exports2.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION = exports2.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = exports2.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = exports2.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = exports2.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = void 0;
    exports2.NEW_PROJECT_DEFAULT_CONTEXT = void 0;
    exports2.futureFlagDefault = futureFlagDefault2;
    var flag_modeling_1 = require_flag_modeling();
    exports2.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = "@aws-cdk/core:enableStackNameDuplicates";
    exports2.ENABLE_DIFF_NO_FAIL_CONTEXT = "aws-cdk:enableDiffNoFail";
    exports2.ENABLE_DIFF_NO_FAIL = exports2.ENABLE_DIFF_NO_FAIL_CONTEXT;
    exports2.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = "@aws-cdk/core:newStyleStackSynthesis";
    exports2.STACK_RELATIVE_EXPORTS_CONTEXT = "@aws-cdk/core:stackRelativeExports";
    exports2.DOCKER_IGNORE_SUPPORT = "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport";
    exports2.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = "@aws-cdk/aws-secretsmanager:parseOwnedSecretName";
    exports2.KMS_DEFAULT_KEY_POLICIES = "@aws-cdk/aws-kms:defaultKeyPolicies";
    exports2.S3_GRANT_WRITE_WITHOUT_ACL = "@aws-cdk/aws-s3:grantWriteWithoutAcl";
    exports2.ECS_REMOVE_DEFAULT_DESIRED_COUNT = "@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount";
    exports2.RDS_LOWERCASE_DB_IDENTIFIER = "@aws-cdk/aws-rds:lowercaseDbIdentifier";
    exports2.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId";
    exports2.EFS_DEFAULT_ENCRYPTION_AT_REST = "@aws-cdk/aws-efs:defaultEncryptionAtRest";
    exports2.LAMBDA_RECOGNIZE_VERSION_PROPS = "@aws-cdk/aws-lambda:recognizeVersionProps";
    exports2.LAMBDA_RECOGNIZE_LAYER_VERSION = "@aws-cdk/aws-lambda:recognizeLayerVersion";
    exports2.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021";
    exports2.CHECK_SECRET_USAGE = "@aws-cdk/core:checkSecretUsage";
    exports2.TARGET_PARTITIONS = "@aws-cdk/core:target-partitions";
    exports2.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = "@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver";
    exports2.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = "@aws-cdk/aws-ec2:uniqueImdsv2TemplateName";
    exports2.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = "@aws-cdk/aws-ecs:arnFormatIncludesClusterName";
    exports2.IAM_MINIMIZE_POLICIES = "@aws-cdk/aws-iam:minimizePolicies";
    exports2.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME = "@aws-cdk/aws-iam:importedRoleStackSafeDefaultPolicyName";
    exports2.VALIDATE_SNAPSHOT_REMOVAL_POLICY = "@aws-cdk/core:validateSnapshotRemovalPolicy";
    exports2.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = "@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName";
    exports2.S3_CREATE_DEFAULT_LOGGING_POLICY = "@aws-cdk/aws-s3:createDefaultLoggingPolicy";
    exports2.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = "@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption";
    exports2.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = "@aws-cdk/aws-apigateway:disableCloudWatchRole";
    exports2.ENABLE_PARTITION_LITERALS = "@aws-cdk/core:enablePartitionLiterals";
    exports2.EVENTS_TARGET_QUEUE_SAME_ACCOUNT = "@aws-cdk/aws-events:eventsTargetQueueSameAccount";
    exports2.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER = "@aws-cdk/aws-ecs:disableExplicitDeploymentControllerForCircuitBreaker";
    exports2.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY = "@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy";
    exports2.ROUTE53_PATTERNS_USE_CERTIFICATE = "@aws-cdk/aws-route53-patters:useCertificate";
    exports2.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT = "@aws-cdk/customresources:installLatestAwsSdkDefault";
    exports2.DATABASE_PROXY_UNIQUE_RESOURCE_NAME = "@aws-cdk/aws-rds:databaseProxyUniqueResourceName";
    exports2.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP = "@aws-cdk/aws-codedeploy:removeAlarmsFromDeploymentGroup";
    exports2.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID = "@aws-cdk/aws-apigateway:authorizerChangeDeploymentLogicalId";
    exports2.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA = "@aws-cdk/aws-ec2:launchTemplateDefaultUserData";
    exports2.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY = "@aws-cdk/aws-secretsmanager:useAttachedSecretResourcePolicyForSecretTargetAttachments";
    exports2.REDSHIFT_COLUMN_ID = "@aws-cdk/aws-redshift:columnId";
    exports2.ENABLE_EMR_SERVICE_POLICY_V2 = "@aws-cdk/aws-stepfunctions-tasks:enableEmrServicePolicyV2";
    exports2.EC2_RESTRICT_DEFAULT_SECURITY_GROUP = "@aws-cdk/aws-ec2:restrictDefaultSecurityGroup";
    exports2.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID = "@aws-cdk/aws-apigateway:requestValidatorUniqueId";
    exports2.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION = "@aws-cdk/core:includePrefixInUniqueNameGeneration";
    exports2.KMS_ALIAS_NAME_REF = "@aws-cdk/aws-kms:aliasNameRef";
    exports2.EFS_DENY_ANONYMOUS_ACCESS = "@aws-cdk/aws-efs:denyAnonymousAccess";
    exports2.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID = "@aws-cdk/aws-efs:mountTargetOrderInsensitiveLogicalId";
    exports2.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE = "@aws-cdk/aws-autoscaling:generateLaunchTemplateInsteadOfLaunchConfig";
    exports2.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY = "@aws-cdk/aws-opensearchservice:enableOpensearchMultiAzWithStandby";
    exports2.LAMBDA_NODEJS_USE_LATEST_RUNTIME = "@aws-cdk/aws-lambda-nodejs:useLatestRuntimeVersion";
    exports2.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS = "@aws-cdk/aws-rds:preventRenderingDeprecatedCredentials";
    exports2.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS = "@aws-cdk/aws-rds:auroraClusterChangeScopeOfInstanceParameterGroupWithEachParameters";
    exports2.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION = "@aws-cdk/aws-appsync:useArnForSourceApiAssociationIdentifier";
    exports2.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME = "@aws-cdk/aws-codepipeline-actions:useNewDefaultBranchForCodeCommitSource";
    exports2.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION = "@aws-cdk/aws-cloudwatch-actions:changeLambdaPermissionLogicalIdForLambdaAction";
    exports2.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE = "@aws-cdk/aws-codepipeline:crossAccountKeysDefaultValueToFalse";
    exports2.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2 = "@aws-cdk/aws-codepipeline:defaultPipelineTypeToV2";
    exports2.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE = "@aws-cdk/aws-kms:reduceCrossAccountRegionPolicyScope";
    exports2.PIPELINE_REDUCE_ASSET_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceAssetRoleTrustScope";
    exports2.EKS_NODEGROUP_NAME = "@aws-cdk/aws-eks:nodegroupNameAttribute";
    exports2.EBS_DEFAULT_GP3 = "@aws-cdk/aws-ec2:ebsDefaultGp3Volume";
    exports2.ECS_REMOVE_DEFAULT_DEPLOYMENT_ALARM = "@aws-cdk/aws-ecs:removeDefaultDeploymentAlarm";
    exports2.LOG_API_RESPONSE_DATA_PROPERTY_TRUE_DEFAULT = "@aws-cdk/custom-resources:logApiResponseDataPropertyTrueDefault";
    exports2.S3_KEEP_NOTIFICATION_IN_IMPORTED_BUCKET = "@aws-cdk/aws-s3:keepNotificationInImportedBucket";
    exports2.USE_NEW_S3URI_PARAMETERS_FOR_BEDROCK_INVOKE_MODEL_TASK = "@aws-cdk/aws-stepfunctions-tasks:useNewS3UriParametersForBedrockInvokeModelTask";
    exports2.REDUCE_EC2_FARGATE_CLOUDWATCH_PERMISSIONS = "@aws-cdk/aws-ecs:reduceEc2FargateCloudWatchPermissions";
    exports2.DYNAMODB_TABLEV2_RESOURCE_POLICY_PER_REPLICA = "@aws-cdk/aws-dynamodb:resourcePolicyPerReplica";
    exports2.EC2_SUM_TIMEOUT_ENABLED = "@aws-cdk/aws-ec2:ec2SumTImeoutEnabled";
    exports2.APPSYNC_GRAPHQLAPI_SCOPE_LAMBDA_FUNCTION_PERMISSION = "@aws-cdk/aws-appsync:appSyncGraphQLAPIScopeLambdaPermission";
    exports2.USE_CORRECT_VALUE_FOR_INSTANCE_RESOURCE_ID_PROPERTY = "@aws-cdk/aws-rds:setCorrectValueForDatabaseInstanceReadReplicaInstanceResourceId";
    exports2.CFN_INCLUDE_REJECT_COMPLEX_RESOURCE_UPDATE_CREATE_POLICY_INTRINSICS = "@aws-cdk/core:cfnIncludeRejectComplexResourceUpdateCreatePolicyIntrinsics";
    exports2.LAMBDA_NODEJS_SDK_V3_EXCLUDE_SMITHY_PACKAGES = "@aws-cdk/aws-lambda-nodejs:sdkV3ExcludeSmithyPackages";
    exports2.STEPFUNCTIONS_TASKS_FIX_RUN_ECS_TASK_POLICY = "@aws-cdk/aws-stepfunctions-tasks:fixRunEcsTaskPolicy";
    exports2.STEPFUNCTIONS_USE_DISTRIBUTED_MAP_RESULT_WRITER_V2 = "@aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2";
    exports2.BASTION_HOST_USE_AMAZON_LINUX_2023_BY_DEFAULT = "@aws-cdk/aws-ec2:bastionHostUseAmazonLinux2023ByDefault";
    exports2.ASPECT_STABILIZATION = "@aws-cdk/core:aspectStabilization";
    exports2.USER_POOL_DOMAIN_NAME_METHOD_WITHOUT_CUSTOM_RESOURCE = "@aws-cdk/aws-route53-targets:userPoolDomainNameMethodWithoutCustomResource";
    exports2.Enable_IMDS_Blocking_Deprecated_Feature = "@aws-cdk/aws-ecs:enableImdsBlockingDeprecatedFeature";
    exports2.Disable_ECS_IMDS_Blocking = "@aws-cdk/aws-ecs:disableEcsImdsBlocking";
    exports2.ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT = "@aws-cdk/aws-elasticloadbalancingV2:albDualstackWithoutPublicIpv4SecurityGroupRulesDefault";
    exports2.IAM_OIDC_REJECT_UNAUTHORIZED_CONNECTIONS = "@aws-cdk/aws-iam:oidcRejectUnauthorizedConnections";
    exports2.ENABLE_ADDITIONAL_METADATA_COLLECTION = "@aws-cdk/core:enableAdditionalMetadataCollection";
    exports2.LAMBDA_CREATE_NEW_POLICIES_WITH_ADDTOROLEPOLICY = "@aws-cdk/aws-lambda:createNewPoliciesWithAddToRolePolicy";
    exports2.SET_UNIQUE_REPLICATION_ROLE_NAME = "@aws-cdk/aws-s3:setUniqueReplicationRoleName";
    exports2.PIPELINE_REDUCE_STAGE_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceStageRoleTrustScope";
    exports2.EVENTBUS_POLICY_SID_REQUIRED = "@aws-cdk/aws-events:requireEventBusPolicySid";
    exports2.ASPECT_PRIORITIES_MUTATING = "@aws-cdk/core:aspectPrioritiesMutating";
    exports2.DYNAMODB_TABLE_RETAIN_TABLE_REPLICA = "@aws-cdk/aws-dynamodb:retainTableReplica";
    exports2.LOG_USER_POOL_CLIENT_SECRET_VALUE = "@aws-cdk/cognito:logUserPoolClientSecretValue";
    exports2.PIPELINE_REDUCE_CROSS_ACCOUNT_ACTION_ROLE_TRUST_SCOPE = "@aws-cdk/pipelines:reduceCrossAccountActionRoleTrustScope";
    exports2.S3_TRUST_KEY_POLICY_FOR_SNS_SUBSCRIPTIONS = "@aws-cdk/s3-notifications:addS3TrustKeyPolicyForSnsSubscriptions";
    exports2.EC2_REQUIRE_PRIVATE_SUBNETS_FOR_EGRESSONLYINTERNETGATEWAY = "@aws-cdk/aws-ec2:requirePrivateSubnetsForEgressOnlyInternetGateway";
    exports2.USE_RESOURCEID_FOR_VPCV2_MIGRATION = "@aws-cdk/aws-ec2-alpha:useResourceIdForVpcV2Migration";
    exports2.S3_PUBLIC_ACCESS_BLOCKED_BY_DEFAULT = "@aws-cdk/aws-s3:publicAccessBlockedByDefault";
    exports2.FLAGS = {
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Allow multiple stacks with the same name",
        detailsMd: `
      If this is set, multiple stacks can use the same stack name (e.g. deployed to
      different environments). This means that the name of the synthesized template
      file will be based on the construct path and not on the defined \`stackName\`
      of the stack.`,
        recommendedValue: true,
        introducedIn: { v1: "1.16.0" },
        defaults: { v2: true },
        compatibilityWithOldBehaviorMd: "Pass stack identifiers to the CLI instead of stack names."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_DIFF_NO_FAIL_CONTEXT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Make `cdk diff` not fail when there are differences",
        detailsMd: `
      Determines what status code \`cdk diff\` should return when the specified stack
      differs from the deployed stack or the local CloudFormation template:

      * \`aws-cdk:enableDiffNoFail=true\` => status code == 0
      * \`aws-cdk:enableDiffNoFail=false\` => status code == 1

      You can override this behavior with the --fail flag:

      * \`--fail\` => status code == 1
      * \`--no-fail\` => status code == 0`,
        introducedIn: { v1: "1.19.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Specify `--fail` to the CLI."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Switch to new stack synthesis method which enables CI/CD",
        detailsMd: `
      If this flag is specified, all \`Stack\`s will use the \`DefaultStackSynthesizer\` by
      default. If it is not set, they will use the \`LegacyStackSynthesizer\`.`,
        introducedIn: { v1: "1.39.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.STACK_RELATIVE_EXPORTS_CONTEXT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Name exports based on the construct paths relative to the stack, rather than the global construct path",
        detailsMd: `
      Combined with the stack name this relative construct path is good enough to
      ensure uniqueness, and makes the export names robust against refactoring
      the location of the stack in the construct tree (specifically, moving the Stack
      into a Stage).`,
        introducedIn: { v1: "1.58.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.DOCKER_IGNORE_SUPPORT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "DockerImageAsset properly supports `.dockerignore` files by default",
        detailsMd: `
      If this flag is not set, the default behavior for \`DockerImageAsset\` is to use
      glob semantics for \`.dockerignore\` files. If this flag is set, the default behavior
      is standard Docker ignore semantics.

      This is a feature flag as the old behavior was technically incorrect but
      users may have come to depend on it.`,
        introducedIn: { v1: "1.73.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Update your `.dockerignore` file to match standard Docker ignore rules, if necessary."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Fix the referencing of SecretsManager names from ARNs",
        detailsMd: `
      Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
      rather than the default full resource name, which includes the SecretsManager suffix.

      If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
      used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).`,
        introducedIn: { v1: "1.77.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Use `parseArn(secret.secretName).resourceName` to emulate the incorrect old parsing."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.KMS_DEFAULT_KEY_POLICIES]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Tighten default KMS key policies",
        detailsMd: `
      KMS Keys start with a default key policy that grants the account access to administer the key,
      mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
      policy by specifying their own.

      If this flag is not set, the default key policy depends on the setting of the \`trustAccountIdentities\`
      flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
      resembles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
      true, the policy matches what happens when this feature flag is set.

      Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
      to the key's default policy (rather than replacing it).`,
        introducedIn: { v1: "1.78.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `trustAccountIdentities: false` to `Key` construct to restore the old behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_GRANT_WRITE_WITHOUT_ACL]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Remove `PutObjectAcl` from Bucket.grantWrite",
        detailsMd: `
      Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
      as the former includes 's3:PutObjectAcl',
      which could be used to grant read/write object access to IAM principals in other accounts.
      Use a feature flag to make sure existing customers who might be relying
      on the overly-broad permissions are not broken.`,
        introducedIn: { v1: "1.85.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Call `bucket.grantPutAcl()` in addition to `bucket.grantWrite()` to grant ACL permissions."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Do not specify a default DesiredCount for ECS services",
        detailsMd: `
      ApplicationLoadBalancedServiceBase, ApplicationMultipleTargetGroupServiceBase,
      NetworkLoadBalancedServiceBase, NetworkMultipleTargetGroupServiceBase, and
      QueueProcessingServiceBase currently determine a default value for the desired count of
      a CfnService if a desiredCount is not provided. The result of this is that on every
      deployment, the service count is reset to the fixed value, even if it was autoscaled.

      If this flag is not set, the default behaviour for CfnService.desiredCount is to set a
      desiredCount of 1, if one is not provided. If true, a default will not be defined for
      CfnService.desiredCount and as such desiredCount will be undefined, if one is not provided.`,
        introducedIn: { v1: "1.92.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "You can pass `desiredCount: 1` explicitly, but you should never need this."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.RDS_LOWERCASE_DB_IDENTIFIER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Force lowercasing of RDS Cluster names in CDK",
        detailsMd: `
      Cluster names must be lowercase, and the service will lowercase the name when the cluster
      is created. However, CDK did not use to know about this, and would use the user-provided name
      referencing the cluster, which would fail if it happened to be mixed-case.

      With this flag, lowercase the name in CDK so we can reference it properly.

      Must be behind a permanent flag because changing a name from mixed case to lowercase between deployments
      would lead CloudFormation to think the name was changed and would trigger a cluster replacement
      (losing data!).`,
        introducedIn: { v1: "1.97.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Allow adding/removing multiple UsagePlanKeys independently",
        detailsMd: `
      The UsagePlanKey resource connects an ApiKey with a UsagePlan. API Gateway does not allow more than one UsagePlanKey
      for any given UsagePlan and ApiKey combination. For this reason, CloudFormation cannot replace this resource without
      either the UsagePlan or ApiKey changing.

      The feature addition to support multiple UsagePlanKey resources - 142bd0e2 - recognized this and attempted to keep
      existing UsagePlanKey logical ids unchanged.
      However, this intentionally caused the logical id of the UsagePlanKey to be sensitive to order. That is, when
      the 'first' UsagePlanKey resource is removed, the logical id of the 'second' assumes what was originally the 'first',
      which again is disallowed.

      In effect, there is no way to get out of this mess in a backwards compatible way, while supporting existing stacks.
      This flag changes the logical id layout of UsagePlanKey to not be sensitive to order.`,
        introducedIn: { v1: "1.98.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EFS_DEFAULT_ENCRYPTION_AT_REST]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Enable this feature flag to have elastic file systems encrypted at rest by default.",
        detailsMd: `
      Encryption can also be configured explicitly using the \`encrypted\` property.
      `,
        introducedIn: { v1: "1.98.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass the `encrypted: false` property to the `FileSystem` construct to disable encryption."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_RECOGNIZE_VERSION_PROPS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the  `fn.currentVersion`.",
        detailsMd: `
      The previous calculation incorrectly considered properties of the \`AWS::Lambda::Function\` resource that did
      not constitute creating a new Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: "1.106.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_RECOGNIZE_LAYER_VERSION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature flag to opt in to the updated logical id calculation for Lambda Version created using the `fn.currentVersion`.",
        detailsMd: `
      This flag correct incorporates Lambda Layer properties into the Lambda Function Version.

      See 'currentVersion' section in the aws-lambda module's README for more details.`,
        introducedIn: { v1: "1.159.0", v2: "2.27.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature flag to have cloudfront distributions use the security policy TLSv1.2_2021 by default.",
        detailsMd: `
      The security policy can also be configured explicitly using the \`minimumProtocolVersion\` property.`,
        introducedIn: { v1: "1.117.0", v2: "2.0.0" },
        defaults: { v2: true },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CHECK_SECRET_USAGE]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: "Enable this flag to make it impossible to accidentally use SecretValues in unsafe locations",
        detailsMd: `
      With this flag enabled, \`SecretValue\` instances can only be passed to
      constructs that accept \`SecretValue\`s; otherwise, \`unsafeUnwrap()\` must be
      called to use it as a regular string.`,
        introducedIn: { v1: "1.153.0", v2: "2.21.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.TARGET_PARTITIONS]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: "What regions to include in lookup tables of environment agnostic stacks",
        detailsMd: `
      Has no effect on stacks that have a defined region, but will limit the amount
      of unnecessary regions included in stacks without a known region.

      The type of this value should be a list of strings.`,
        introducedIn: { v1: "1.137.0", v2: "2.4.0" },
        recommendedValue: ["aws", "aws-cn"]
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "ECS extensions will automatically add an `awslogs` driver if no logging is specified",
        detailsMd: `
      Enable this feature flag to configure default logging behavior for the ECS Service Extensions. This will enable the
      \`awslogs\` log driver for the application container of the service to send the container logs to CloudWatch Logs.

      This is a feature flag as the new behavior provides a better default experience for the users.`,
        introducedIn: { v1: "1.140.0", v2: "2.8.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Specify a log driver explicitly."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature flag to have Launch Templates generated by the `InstanceRequireImdsv2Aspect` use unique names.",
        detailsMd: `
      Previously, the generated Launch Template names were only unique within a stack because they were based only on the
      \`Instance\` construct ID. If another stack that has an \`Instance\` with the same construct ID is deployed in the same
      account and region, the deployments would always fail as the generated Launch Template names were the same.

      The new implementation addresses this issue by generating the Launch Template name with the \`Names.uniqueId\` method.`,
        introducedIn: { v1: "1.140.0", v2: "2.8.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "ARN format used by ECS. In the new ARN format, the cluster name is part of the resource ID.",
        detailsMd: `
      If this flag is not set, the old ARN format (without cluster name) for ECS is used.
      If this flag is set, the new ARN format (with cluster name) for ECS is used.

      This is a feature flag as the old format is still valid for existing ECS clusters.

      See https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids
      `,
        introducedIn: { v2: "2.35.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.IAM_MINIMIZE_POLICIES]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: "Minimize IAM policies by combining Statements",
        detailsMd: `
      Minimize IAM policies by combining Principals, Actions and Resources of two
      Statements in the policies, as long as it doesn't change the meaning of the
      policy.`,
        introducedIn: { v1: "1.150.0", v2: "2.18.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.VALIDATE_SNAPSHOT_REMOVAL_POLICY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Error on snapshot removal policies on resources that do not support it.",
        detailsMd: `
      Makes sure we do not allow snapshot removal policy on resources that do not support it.
      If supplied on an unsupported resource, CloudFormation ignores the policy altogether.
      This flag will reduce confusion and unexpected loss of data when erroneously supplying
      the snapshot removal policy.`,
        introducedIn: { v2: "2.28.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "The old behavior was incorrect. Update your source to not specify SNAPSHOT policies on resources that do not support it."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Generate key aliases that include the stack name",
        detailsMd: `
      Enable this feature flag to have CodePipeline generate a unique cross account key alias name using the stack name.

      Previously, when creating multiple pipelines with similar naming conventions and when crossAccountKeys is true,
      the KMS key alias name created for these pipelines may be the same due to how the uniqueId is generated.

      This new implementation creates a stack safe resource name for the alias using the stack name instead of the stack ID.
      `,
        introducedIn: { v2: "2.29.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_CREATE_DEFAULT_LOGGING_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature flag to create an S3 bucket policy by default in cases where an AWS service would automatically create the Policy if one does not exist.",
        detailsMd: `
      For example, in order to send VPC flow logs to an S3 bucket, there is a specific Bucket Policy
      that needs to be attached to the bucket. If you create the bucket without a policy and then add the
      bucket as the flow log destination, the service will automatically create the bucket policy with the
      necessary permissions. If you were to then try and add your own bucket policy CloudFormation will throw
      and error indicating that a bucket policy already exists.

      In cases where we know what the required policy is we can go ahead and create the policy so we can
      remain in control of it.

      @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html#AWS-logs-infrastructure-S3
      `,
        introducedIn: { v2: "2.31.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Restrict KMS key policy for encrypted Queues a bit more",
        detailsMd: `
      Enable this feature flag to restrict the decryption of a SQS queue, which is subscribed to a SNS topic, to
      only the topic which it is subscribed to and not the whole SNS service of an account.

      Previously the decryption was only restricted to the SNS service principal. To make the SQS subscription more
      secure, it is a good practice to restrict the decryption further and only allow the connected SNS topic to decryption
      the subscribed queue.`,
        introducedIn: { v2: "2.32.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Make default CloudWatch Role behavior safe for multiple API Gateways in one environment",
        detailsMd: `
      Enable this feature flag to change the default behavior for aws-apigateway.RestApi and aws-apigateway.SpecRestApi
      to _not_ create a CloudWatch role and Account. There is only a single ApiGateway account per AWS
      environment which means that each time you create a RestApi in your account the ApiGateway account
      is overwritten. If at some point the newest RestApi is deleted, the ApiGateway Account and CloudWatch
      role will also be deleted, breaking any existing ApiGateways that were depending on them.

      When this flag is enabled you should either create the ApiGateway account and CloudWatch role
      separately _or_ only enable the cloudWatchRole on a single RestApi.
      `,
        introducedIn: { v2: "2.38.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_PARTITION_LITERALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Make ARNs concrete if AWS partition is known",
        // eslint-disable-next-line @cdklabs/no-literal-partition
        detailsMd: `
      Enable this feature flag to get partition names as string literals in Stacks with known regions defined in
      their environment, such as "aws" or "aws-cn".  Previously the CloudFormation intrinsic function
      "Ref: AWS::Partition" was used.  For example:

      \`\`\`yaml
      Principal:
        AWS:
          Fn::Join:
            - ""
            - - "arn:"
              - Ref: AWS::Partition
              - :iam::123456789876:root
      \`\`\`

      becomes:

      \`\`\`yaml
      Principal:
        AWS: "arn:aws:iam::123456789876:root"
      \`\`\`

      The intrinsic function will still be used in Stacks where no region is defined or the region's partition
      is unknown.
      `,
        introducedIn: { v2: "2.38.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EVENTS_TARGET_QUEUE_SAME_ACCOUNT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Event Rules may only push to encrypted SQS queues in the same account",
        detailsMd: `
      This flag applies to SQS Queues that are used as the target of event Rules. When enabled, only principals
      from the same account as the Rule can send messages. If a queue is unencrypted, this restriction will
      always apply, regardless of the value of this flag.
      `,
        introducedIn: { v2: "2.51.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ECS_DISABLE_EXPLICIT_DEPLOYMENT_CONTROLLER_FOR_CIRCUIT_BREAKER]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: 'Avoid setting the "ECS" deployment controller when adding a circuit breaker',
        detailsMd: `
      Enable this feature flag to avoid setting the "ECS" deployment controller when adding a circuit breaker to an
      ECS Service, as this will trigger a full replacement which fails to deploy when using set service names.
      This does not change any behaviour as the default deployment controller when it is not defined is ECS.

      This is a feature flag as the new behavior provides a better default experience for the users.
      `,
        introducedIn: { v2: "2.51.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.IAM_IMPORTED_ROLE_STACK_SAFE_DEFAULT_POLICY_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable this feature to by default create default policy names for imported roles that depend on the stack the role is in.",
        detailsMd: `
      Without this, importing the same role in multiple places could lead to the permissions given for one version of the imported role
      to overwrite permissions given to the role at a different place where it was imported. This was due to all imported instances
      of a role using the same default policy name.

      This new implementation creates default policy names based on the constructs node path in their stack.
      `,
        introducedIn: { v2: "2.60.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_SERVER_ACCESS_LOGS_USE_BUCKET_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Use S3 Bucket Policy instead of ACLs for Server Access Logging",
        detailsMd: `
      Enable this feature flag to use S3 Bucket Policy for granting permission fo Server Access Logging
      rather than using the canned \`LogDeliveryWrite\` ACL. ACLs do not work when Object Ownership is
      enabled on the bucket.

      This flag uses a Bucket Policy statement to allow Server Access Log delivery, following best
      practices for S3.

      @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html
    `,
        introducedIn: { v2: "2.60.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ROUTE53_PATTERNS_USE_CERTIFICATE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Use the official `Certificate` resource instead of `DnsValidatedCertificate`",
        detailsMd: `
      Enable this feature flag to use the official CloudFormation supported \`Certificate\` resource instead
      of the deprecated \`DnsValidatedCertificate\` construct. If this flag is enabled and you are creating
      the stack in a region other than us-east-1 then you must also set \`crossRegionReferences=true\` on the
      stack.
      `,
        introducedIn: { v2: "2.61.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Define a `DnsValidatedCertificate` explicitly and pass in the `certificate` property"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.AWS_CUSTOM_RESOURCE_LATEST_SDK_DEFAULT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Whether to install the latest SDK by default in AwsCustomResource",
        detailsMd: `
      This was originally introduced and enabled by default to not be limited by the SDK version
      that's installed on AWS Lambda. However, it creates issues for Lambdas bound to VPCs that
      do not have internet access, or in environments where 'npmjs.com' is not available.

      The recommended setting is to disable the default installation behavior, and pass the
      flag on a resource-by-resource basis to enable it if necessary.
    `,
        compatibilityWithOldBehaviorMd: "Set installLatestAwsSdk: true on all resources that need it.",
        introducedIn: { v2: "2.60.0" },
        recommendedValue: false
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.DATABASE_PROXY_UNIQUE_RESOURCE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Use unique resource name for Database Proxy",
        detailsMd: `
      If this flag is not set, the default behavior for \`DatabaseProxy\` is
      to use \`id\` of the constructor for \`dbProxyName\` when it's not specified in the argument.
      In this case, users can't deploy \`DatabaseProxy\`s that have the same \`id\` in the same region.

      If this flag is set, the default behavior is to use unique resource names for each \`DatabaseProxy\`.

      This is a feature flag as the old behavior was technically incorrect, but users may have come to depend on it.
    `,
        introducedIn: { v2: "2.65.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CODEDEPLOY_REMOVE_ALARMS_FROM_DEPLOYMENT_GROUP]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Remove CloudWatch alarms from deployment group",
        detailsMd: `
      Enable this flag to be able to remove all CloudWatch alarms from a deployment group by removing
      the alarms from the construct. If this flag is not set, removing all alarms from the construct
      will still leave the alarms configured for the deployment group.
    `,
        introducedIn: { v2: "2.65.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APIGATEWAY_AUTHORIZER_CHANGE_DEPLOYMENT_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Include authorizer configuration in the calculation of the API deployment logical ID.",
        detailsMd: `
      The logical ID of the AWS::ApiGateway::Deployment resource is calculated by hashing
      the API configuration, including methods, and resources, etc. Enable this feature flag
      to also include the configuration of any authorizer attached to the API in the
      calculation, so any changes made to an authorizer will create a new deployment.
      `,
        introducedIn: { v2: "2.66.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EC2_LAUNCH_TEMPLATE_DEFAULT_USER_DATA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Define user data for a launch template by default when a machine image is provided.",
        detailsMd: `
      The ec2.LaunchTemplate construct did not define user data when a machine image is
      provided despite the document. If this is set, a user data is automatically defined
      according to the OS of the machine image.
      `,
        recommendedValue: true,
        introducedIn: { v2: "2.67.0" }
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "SecretTargetAttachments uses the ResourcePolicy of the attached Secret.",
        detailsMd: `
      Enable this feature flag to make SecretTargetAttachments use the ResourcePolicy of the attached Secret.
      SecretTargetAttachments are created to connect a Secret to a target resource.
      In CDK code, they behave like regular Secret and can be used as a stand-in in most situations.
      Previously, adding to the ResourcePolicy of a SecretTargetAttachment did attempt to create a separate ResourcePolicy for the same Secret.
      However Secrets can only have a single ResourcePolicy, causing the CloudFormation deployment to fail.

      When enabling this feature flag for an existing Stack, ResourcePolicies created via a SecretTargetAttachment will need replacement.
      This won't be possible without intervention due to limitation outlined above.
      First remove all permissions granted to the Secret and deploy without the ResourcePolicies.
      Then you can re-add the permissions and deploy again.
      `,
        recommendedValue: true,
        introducedIn: { v2: "2.67.0" }
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.REDSHIFT_COLUMN_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Whether to use an ID to track Redshift column changes",
        detailsMd: `
      Redshift columns are identified by their \`name\`. If a column is renamed, the old column
      will be dropped and a new column will be created. This can cause data loss.

      This flag enables the use of an \`id\` attribute for Redshift columns. If this flag is enabled, the
      internal CDK architecture will track changes of Redshift columns through their \`id\`, rather
      than their \`name\`. This will prevent data loss when columns are renamed.

      **NOTE** - Enabling this flag comes at a **risk**. When enabled, update the \`id\`s of all columns,
      **however** do not change the \`names\`s of the columns. If the \`name\`s of the columns are changed during
      initial deployment, the columns will be dropped and recreated, causing data loss. After the initial deployment
      of the \`id\`s, the \`name\`s of the columns can be changed without data loss.
      `,
        introducedIn: { v2: "2.68.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_EMR_SERVICE_POLICY_V2]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Enable AmazonEMRServicePolicy_v2 managed policies",
        detailsMd: `
      If this flag is not set, the default behavior for \`EmrCreateCluster\` is
      to use \`AmazonElasticMapReduceRole\` managed policies.

      If this flag is set, the default behavior is to use the new \`AmazonEMRServicePolicy_v2\`
      managed policies.

      This is a feature flag as the old behavior will be deprecated, but some resources may require manual
      intervention since they might not have the appropriate tags propagated automatically.
      `,
        introducedIn: { v2: "2.72.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EC2_RESTRICT_DEFAULT_SECURITY_GROUP]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Restrict access to the VPC default security group",
        detailsMd: `
      Enable this feature flag to remove the default ingress/egress rules from the
      VPC default security group.

      When a VPC is created, a default security group is created as well and this cannot
      be deleted. The default security group is created with ingress/egress rules that allow
      _all_ traffic. [AWS Security best practices recommend](https://docs.aws.amazon.com/securityhub/latest/userguide/ec2-controls.html#ec2-2)
      removing these ingress/egress rules in order to restrict access to the default security group.
    `,
        introducedIn: { v2: "2.78.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: `
      To allow all ingress/egress traffic to the VPC default security group you
      can set the \`restrictDefaultSecurityGroup: false\`.
    `
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APIGATEWAY_REQUEST_VALIDATOR_UNIQUE_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Generate a unique id for each RequestValidator added to a method",
        detailsMd: `
      This flag allows multiple RequestValidators to be added to a RestApi when
      providing the \`RequestValidatorOptions\` in the \`addMethod()\` method.

      If the flag is not set then only a single RequestValidator can be added in this way.
      Any additional RequestValidators have to be created directly with \`new RequestValidator\`.
    `,
        introducedIn: { v2: "2.78.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.KMS_ALIAS_NAME_REF]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "KMS Alias name and keyArn will have implicit reference to KMS Key",
        detailsMd: `
      This flag allows an implicit dependency to be created between KMS Alias and KMS Key
      when referencing key.aliasName or key.keyArn.

      If the flag is not set then a raw string is passed as the Alias name and no
      implicit dependencies will be set.
    `,
        introducedIn: { v2: "2.83.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.AUTOSCALING_GENERATE_LAUNCH_TEMPLATE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Generate a launch template when creating an AutoScalingGroup",
        detailsMd: `
      Enable this flag to allow AutoScalingGroups to generate a launch template when being created.
      Launch configurations have been deprecated and cannot be created in AWS Accounts created after
      December 31, 2023. Existing 'AutoScalingGroup' properties used for creating a launch configuration
      will now create an equivalent 'launchTemplate'. Alternatively, users can provide an explicit
      'launchTemplate' or 'mixedInstancesPolicy'. When this flag is enabled a 'launchTemplate' will
      attempt to set user data according to the OS of the machine image if explicit user data is not
      provided.
    `,
        introducedIn: { v2: "2.88.0" },
        compatibilityWithOldBehaviorMd: `
      If backwards compatibility needs to be maintained due to an existing autoscaling group
      using a launch config, set this flag to false.
    `,
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Include the stack prefix in the stack name generation process",
        detailsMd: `
      This flag prevents the prefix of a stack from making the stack's name longer than the 128 character limit.

      If the flag is set, the prefix is included in the stack name generation process.
      If the flag is not set, then the prefix of the stack is prepended to the generated stack name.

      **NOTE** - Enabling this flag comes at a **risk**. If you have already deployed stacks, changing the status of this
      feature flag can lead to a change in stacks' name. Changing a stack name mean recreating the whole stack, which
      is not viable in some productive setups.
    `,
        introducedIn: { v2: "2.84.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EFS_DENY_ANONYMOUS_ACCESS]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "EFS denies anonymous clients accesses",
        detailsMd: `
      This flag adds the file system policy that denies anonymous clients
      access to \`efs.FileSystem\`.

      If this flag is not set, \`efs.FileSystem\` will allow all anonymous clients
      that can access over the network.`,
        introducedIn: { v2: "2.93.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "You can pass `allowAnonymousAccess: true` so allow anonymous clients access."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_OPENSEARCH_MULTIAZ_WITH_STANDBY]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Enables support for Multi-AZ with Standby deployment for opensearch domains",
        detailsMd: `
      If this is set, an opensearch domain will automatically be created with
      multi-az with standby enabled.
    `,
        introducedIn: { v2: "2.88.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `capacity.multiAzWithStandbyEnabled: false` to `Domain` construct to restore the old behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_NODEJS_USE_LATEST_RUNTIME]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Enables aws-lambda-nodejs.Function to use the latest available NodeJs runtime as the default",
        detailsMd: `
      If this is set, and a \`runtime\` prop is not passed to, Lambda NodeJs
      functions will us the latest version of the runtime provided by the Lambda
      service. Do not use this if you your lambda function is reliant on dependencies
      shipped as part of the runtime environment.
    `,
        introducedIn: { v2: "2.93.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `runtime: lambda.Runtime.NODEJS_16_X` to `Function` construct to restore the previous behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EFS_MOUNTTARGET_ORDERINSENSITIVE_LOGICAL_ID]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, mount targets will have a stable logicalId that is linked to the associated subnet.",
        detailsMd: `
      When this feature flag is enabled, each mount target will have a stable
      logicalId that is linked to the associated subnet. If the flag is set to
      false then the logicalIds of the mount targets can change if the number of
      subnets changes.

      Set this flag to false for existing mount targets.
    `,
        introducedIn: { v2: "2.93.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.AURORA_CLUSTER_CHANGE_SCOPE_OF_INSTANCE_PARAMETER_GROUP_WITH_EACH_PARAMETERS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, a scope of InstanceParameterGroup for AuroraClusterInstance with each parameters will change.",
        detailsMd: `
      When this feature flag is enabled, a scope of \`InstanceParameterGroup\` for
      \`AuroraClusterInstance\` with each parameters will change to AuroraClusterInstance
      from AuroraCluster.

      If the flag is set to false then it can only make one \`AuroraClusterInstance\`
      with each \`InstanceParameterGroup\` in the AuroraCluster.
    `,
        introducedIn: { v2: "2.97.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APPSYNC_ENABLE_USE_ARN_IDENTIFIER_SOURCE_API_ASSOCIATION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, will always use the arn for identifiers for CfnSourceApiAssociation in the GraphqlApi construct rather than id.",
        detailsMd: `
      When this feature flag is enabled, we use the IGraphqlApi ARN rather than ID when creating or updating CfnSourceApiAssociation in
      the GraphqlApi construct. Using the ARN allows the association to support an association with a source api or merged api in another account.
      Note that for existing source api associations created with this flag disabled, enabling the flag will lead to a resource replacement.
    `,
        introducedIn: { v2: "2.97.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.RDS_PREVENT_RENDERING_DEPRECATED_CREDENTIALS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, creating an RDS database cluster from a snapshot will only render credentials for snapshot credentials.",
        detailsMd: `
      The \`credentials\` property on the \`DatabaseClusterFromSnapshotProps\`
      interface was deprecated with the new \`snapshotCredentials\` property being
      recommended. Before deprecating \`credentials\`, a secret would be generated
      while rendering credentials if the \`credentials\` property was undefined or
      if a secret wasn't provided via the \`credentials\` property. This behavior
      is replicated with the new \`snapshotCredentials\` property, but the original
      \`credentials\` secret can still be created resulting in an extra database
      secret.

      Set this flag to prevent rendering deprecated \`credentials\` and creating an
      extra database secret when only using \`snapshotCredentials\` to create an RDS
      database cluster from a snapshot.
    `,
        introducedIn: { v2: "2.98.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CODECOMMIT_SOURCE_ACTION_DEFAULT_BRANCH_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the CodeCommit source action is using the default branch name 'main'.",
        detailsMd: `
      When setting up a CodeCommit source action for the source stage of a pipeline, please note that the
      default branch is 'master'.
      However, with the activation of this feature flag, the default branch is updated to 'main'.
    `,
        introducedIn: { v2: "2.103.1" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_PERMISSION_LOGICAL_ID_FOR_LAMBDA_ACTION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the logical ID of a Lambda permission for a Lambda action includes an alarm ID.",
        detailsMd: `
      When this feature flag is enabled, a logical ID of \`LambdaPermission\` for a
      \`LambdaAction\` will include an alarm ID. Therefore multiple alarms for the same Lambda
      can be created with \`LambdaAction\`.

      If the flag is set to false then it can only make one alarm for the Lambda with
      \`LambdaAction\`.
    `,
        introducedIn: { v2: "2.124.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Enables Pipeline to set the default value for crossAccountKeys to false.",
        detailsMd: `
      When this feature flag is enabled, and the \`crossAccountKeys\` property is not provided in a \`Pipeline\`
      construct, the construct automatically defaults the value of this property to false.
    `,
        introducedIn: { v2: "2.127.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `crossAccountKeys: true` to `Pipeline` construct to restore the previous behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Enables Pipeline to set the default pipeline type to V2.",
        detailsMd: `
      When this feature flag is enabled, and the \`pipelineType\` property is not provided in a \`Pipeline\`
      construct, the construct automatically defaults the value of this property to \`PipelineType.V2\`.
    `,
        introducedIn: { v2: "2.133.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `pipelineType: PipelineType.V1` to `Pipeline` construct to restore the previous behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.KMS_REDUCE_CROSS_ACCOUNT_REGION_POLICY_SCOPE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, IAM Policy created from KMS key grant will reduce the resource scope to this key only.",
        detailsMd: `
      When this feature flag is enabled and calling KMS key grant method, the created IAM policy will reduce the resource scope from
      '*' to this specific granting KMS key.
    `,
        introducedIn: { v2: "2.134.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.PIPELINE_REDUCE_ASSET_ROLE_TRUST_SCOPE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Remove the root account principal from PipelineAssetsFileRole trust policy",
        detailsMd: `
      When this feature flag is enabled, the root account principal will not be added to the trust policy of asset role.
      When this feature flag is disabled, it will keep the root account principal in the trust policy.
    `,
        introducedIn: { v2: "2.141.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to add the root account principal back"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EKS_NODEGROUP_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, nodegroupName attribute of the provisioned EKS NodeGroup will not have the cluster name prefix.",
        detailsMd: `
      When this feature flag is enabled, the nodegroupName attribute will be exactly the name of the nodegroup without
      any prefix.
    `,
        introducedIn: { v2: "2.139.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EBS_DEFAULT_GP3]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, the default volume type of the EBS volume will be GP3",
        detailsMd: `
      When this featuer flag is enabled, the default volume type of the EBS volume will be \`EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3\`.
    `,
        introducedIn: { v2: "2.140.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Pass `volumeType: EbsDeviceVolumeType.GENERAL_PURPOSE_SSD` to `Volume` construct to restore the previous behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ECS_REMOVE_DEFAULT_DEPLOYMENT_ALARM]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, remove default deployment alarm settings",
        detailsMd: `
      When this featuer flag is enabled, remove the default deployment alarm settings when creating a AWS ECS service.
    `,
        introducedIn: { v2: "2.143.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Set AWS::ECS::Service 'DeploymentAlarms' manually to restore the previous behavior."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LOG_API_RESPONSE_DATA_PROPERTY_TRUE_DEFAULT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the custom resource used for `AwsCustomResource` will configure the `logApiResponseData` property as true by default",
        detailsMd: `
      This results in 'logApiResponseData' being passed as true to the custom resource provider. This will cause the custom resource handler to receive an 'Update' event. If you don't
      have an SDK call configured for the 'Update' event and you're dependent on specific SDK call response data, you will see this error from CFN:

      CustomResource attribute error: Vendor response doesn't contain <attribute-name> attribute in object. See https://github.com/aws/aws-cdk/issues/29949) for more details.

      Unlike most feature flags, we don't recommend setting this feature flag to true. However, if you're using the 'AwsCustomResource' construct with 'logApiResponseData' as true in
      the event object, then setting this feature flag will keep this behavior. Otherwise, setting this feature flag to false will trigger an 'Update' event by removing the 'logApiResponseData'
      property from the event object.
    `,
        introducedIn: { v2: "2.145.0" },
        recommendedValue: false
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_KEEP_NOTIFICATION_IN_IMPORTED_BUCKET]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, Adding notifications to a bucket in the current stack will not remove notification from imported stack.",
        detailsMd: `
      Currently, adding notifications to a bucket where it was created by ourselves will override notification added where it is imported.

      When this feature flag is enabled, adding notifications to a bucket in the current stack will only update notification defined in this stack.
      Other notifications that are not managed by this stack will be kept.
    `,
        introducedIn: { v2: "2.155.0" },
        recommendedValue: false
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.USE_NEW_S3URI_PARAMETERS_FOR_BEDROCK_INVOKE_MODEL_TASK]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, use new props for S3 URI field in task definition of state machine for bedrock invoke model.",
        detailsMd: `
    Currently, 'inputPath' and 'outputPath' from the TaskStateBase Props is being used under BedrockInvokeModelProps to define S3URI under 'input' and 'output' fields
    of State Machine Task definition.

    When this feature flag is enabled, specify newly introduced props 's3InputUri' and
    's3OutputUri' to populate S3 uri under input and output fields in state machine task definition for Bedrock invoke model.

    `,
        introducedIn: { v2: "2.156.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to use input and output path fields for s3 URI"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.Enable_IMDS_Blocking_Deprecated_Feature]: {
        type: flag_modeling_1.FlagType.Temporary,
        summary: "When set to true along with canContainersAccessInstanceRole=false in ECS cluster, new updated commands will be added to UserData to block container accessing IMDS. **Applicable to Linux only. IMPORTANT: See [details.](#aws-cdkaws-ecsenableImdsBlockingDeprecatedFeature)**",
        detailsMd: `
    In an ECS Cluster with \`MachineImageType.AMAZON_LINUX_2\`, the canContainersAccessInstanceRole=false option attempts to add commands to block containers from
    accessing IMDS. Set this flag to true in order to use new and updated commands. Please note that this
    feature alone with this feature flag will be deprecated by <ins>**end of 2025**</ins> as CDK cannot
    guarantee the correct execution of the feature in all platforms. See [Github discussion](https://github.com/aws/aws-cdk/discussions/32609) for more information.
    It is recommended to follow ECS documentation to block IMDS for your specific platform and cluster configuration.
    `,
        introducedIn: { v2: "2.175.0" },
        recommendedValue: false,
        compatibilityWithOldBehaviorMd: "Set this flag to false in order to continue using old and outdated commands. However, it is **not** recommended."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.Disable_ECS_IMDS_Blocking]: {
        type: flag_modeling_1.FlagType.Temporary,
        summary: "When set to true, CDK synth will throw exception if canContainersAccessInstanceRole is false. **IMPORTANT: See [details.](#aws-cdkaws-ecsdisableEcsImdsBlocking)**",
        detailsMd: `
    In an ECS Cluster with \`MachineImageType.AMAZON_LINUX_2\`, the canContainersAccessInstanceRole=false option attempts to add commands to block containers from
    accessing IMDS. CDK cannot guarantee the correct execution of the feature in all platforms. Setting this feature flag
    to true will ensure CDK does not attempt to implement IMDS blocking. By <ins>**end of 2025**</ins>, CDK will remove the
    IMDS blocking feature. See [Github discussion](https://github.com/aws/aws-cdk/discussions/32609) for more information.

    It is recommended to follow ECS documentation to block IMDS for your specific platform and cluster configuration.
    `,
        introducedIn: { v2: "2.175.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "It is strongly recommended to set this flag to true. However, if necessary, set this flag to false to continue using the old implementation."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.REDUCE_EC2_FARGATE_CLOUDWATCH_PERMISSIONS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, we will only grant the necessary permissions when users specify cloudwatch log group through logConfiguration",
        detailsMd: `
    Currently, we automatically add a number of cloudwatch permissions to the task role when no cloudwatch log group is
    specified as logConfiguration and it will grant 'Resources': ['*'] to the task role.

    When this feature flag is enabled, we will only grant the necessary permissions when users specify cloudwatch log group.
    `,
        introducedIn: { v2: "2.159.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to continue grant permissions to log group when no log group is specified"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.DYNAMODB_TABLEV2_RESOURCE_POLICY_PER_REPLICA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled will allow you to specify a resource policy per replica, and not copy the source table policy to all replicas",
        detailsMd: `
      If this flag is not set, the default behavior for \`TableV2\` is to use a different \`resourcePolicy\` for each replica.

      If this flag is set to false, the behavior is that each replica shares the same \`resourcePolicy\` as the source table.
      This will prevent you from creating a new table which has an additional replica and a resource policy.

      This is a feature flag as the old behavior was technically incorrect but users may have come to depend on it.`,
        introducedIn: { v2: "2.164.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EC2_SUM_TIMEOUT_ENABLED]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, initOptions.timeout and resourceSignalTimeout values will be summed together.",
        detailsMd: `
      Currently is both initOptions.timeout and resourceSignalTimeout are both specified in the options for creating an EC2 Instance,
      only the value from 'resourceSignalTimeout' will be used.

      When this feature flag is enabled, if both initOptions.timeout and resourceSignalTimeout are specified, the values will to be summed together.
      `,
        recommendedValue: true,
        introducedIn: { v2: "2.160.0" }
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.APPSYNC_GRAPHQLAPI_SCOPE_LAMBDA_FUNCTION_PERMISSION]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, a Lambda authorizer Permission created when using GraphqlApi will be properly scoped with a SourceArn.",
        detailsMd: `
        Currently, when using a Lambda authorizer with an AppSync GraphQL API, the AWS CDK automatically generates the necessary AWS::Lambda::Permission
        to allow the AppSync API to invoke the Lambda authorizer. This permission is overly permissive because it lacks a SourceArn, meaning
        it allows invocations from any source.

        When this feature flag is enabled, the AWS::Lambda::Permission will be properly scoped with the SourceArn corresponding to the
        specific AppSync GraphQL API.
        `,
        recommendedValue: true,
        introducedIn: { v2: "2.161.0" }
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.USE_CORRECT_VALUE_FOR_INSTANCE_RESOURCE_ID_PROPERTY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the value of property `instanceResourceId` in construct `DatabaseInstanceReadReplica` will be set to the correct value which is `DbiResourceId` instead of currently `DbInstanceArn`",
        detailsMd: `
      Currently, the value of the property 'instanceResourceId' in construct 'DatabaseInstanceReadReplica' is not correct, and set to 'DbInstanceArn' which is not correct when it is used to create the IAM Policy in the grantConnect method.

      When this feature flag is enabled, the value of that property will be as expected set to 'DbiResourceId' attribute, and that will fix the grantConnect method.
    `,
        introducedIn: { v2: "2.161.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to use `DbInstanceArn` as value for property `instanceResourceId`"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.CFN_INCLUDE_REJECT_COMPLEX_RESOURCE_UPDATE_CREATE_POLICY_INTRINSICS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, CFN templates added with `cfn-include` will error if the template contains Resource Update or Create policies with CFN Intrinsics that include non-primitive values.",
        detailsMd: `
    Without enabling this feature flag, \`cfn-include\` will silently drop resource update or create policies that contain CFN Intrinsics if they include non-primitive values.

    Enabling this feature flag will make \`cfn-include\` throw on these templates, unless you specify the logical ID of the resource in the 'unhydratedResources' property.
    `,
        recommendedValue: true,
        introducedIn: { v2: "2.161.0" }
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_NODEJS_SDK_V3_EXCLUDE_SMITHY_PACKAGES]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, both `@aws-sdk` and `@smithy` packages will be excluded from the Lambda Node.js 18.x runtime to prevent version mismatches in bundled applications.",
        detailsMd: `
      Currently, when bundling Lambda functions with the non-latest runtime that supports AWS SDK JavaScript (v3), only the '@aws-sdk/*' packages are excluded by default.
      However, this can cause version mismatches between the '@aws-sdk/*' and '@smithy/*' packages, as they are tightly coupled dependencies in AWS SDK v3.

      When this feature flag is enabled, both '@aws-sdk/*' and '@smithy/*' packages will be excluded during the bundling process. This ensures that no mismatches
      occur between these tightly coupled dependencies when using the AWS SDK v3 in Lambda functions.
    `,
        introducedIn: { v2: "2.161.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.STEPFUNCTIONS_TASKS_FIX_RUN_ECS_TASK_POLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the resource of IAM Run Ecs policy generated by SFN EcsRunTask will reference the definition, instead of constructing ARN.",
        detailsMd: `
      Currently, in the IAM Run Ecs policy generated by SFN EcsRunTask(), CDK will construct the ARN with wildcard attached at the end.
      The revision number at the end will be replaced with a wildcard which it shouldn't.

      When this feature flag is enabled, if the task definition is created in the stack, the 'Resource' section will 'Ref' the taskDefinition.
    `,
        introducedIn: { v2: "2.163.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.BASTION_HOST_USE_AMAZON_LINUX_2023_BY_DEFAULT]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, the BastionHost construct will use the latest Amazon Linux 2023 AMI, instead of Amazon Linux 2.",
        detailsMd: `
      Currently, if the machineImage property of the BastionHost construct defaults to using the latest Amazon Linux 2
      AMI. Amazon Linux 2 hits end-of-life in June 2025, so using Amazon Linux 2023 by default is a more future-proof
      and secure option.

      When this feature flag is enabled, if you do not pass the machineImage property to the BastionHost construct,
      the latest Amazon Linux 2023 version will be used instead of Amazon Linux 2.
    `,
        introducedIn: { v2: "2.172.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag or explicitly pass an Amazon Linux 2 machine image to the BastionHost construct."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ASPECT_STABILIZATION]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: "When enabled, a stabilization loop will be run when invoking Aspects during synthesis.",
        detailsMd: `
      Currently, when Aspects are invoked in one single pass of the construct tree.
      This means that the Aspects that create other Aspects are not run and Aspects that create new nodes of the tree sometimes do not inherit their parent Aspects.

      When this feature flag is enabled, a stabilization loop is run to recurse the construct tree multiple times when invoking Aspects.
    `,
        defaults: { v2: true },
        introducedIn: { v2: "2.172.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.USER_POOL_DOMAIN_NAME_METHOD_WITHOUT_CUSTOM_RESOURCE]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, use a new method for DNS Name of user pool domain target without creating a custom resource.",
        detailsMd: `
    When this feature flag is enabled, a new method will be used to get the DNS Name of the user pool domain target. The old method
    creates a custom resource internally, but the new method doesn't need a custom resource.

    If the flag is set to false then a custom resource will be created when using \`UserPoolDomainTarget\`.
    `,
        introducedIn: { v2: "2.174.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ALB_DUALSTACK_WITHOUT_PUBLIC_IPV4_SECURITY_GROUP_RULES_DEFAULT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the default security group ingress rules will allow IPv6 ingress from anywhere",
        detailsMd: `
      For internet facing ALBs with 'dualstack-without-public-ipv4' IP address type, the default security group rules
      will allow IPv6 ingress from anywhere (::/0). Previously, the default security group rules would only allow IPv4 ingress.

      Using a feature flag to make sure existing customers who might be relying
      on the overly restrictive permissions are not broken.`,
        introducedIn: { v2: "2.176.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to only allow IPv4 ingress in the default security group rules."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.IAM_OIDC_REJECT_UNAUTHORIZED_CONNECTIONS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the default behaviour of OIDC provider will reject unauthorized connections",
        detailsMd: `
      When this feature flag is enabled, the default behaviour of OIDC Provider's custom resource handler will
      default to reject unauthorized connections when downloading CA Certificates.

      When this feature flag is disabled, the behaviour will be the same as current and will allow downloading
      thumbprints from unsecure connections.`,
        introducedIn: { v2: "2.177.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to allow unsecure OIDC connection."
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ENABLE_ADDITIONAL_METADATA_COLLECTION]: {
        type: flag_modeling_1.FlagType.VisibleContext,
        summary: "When enabled, CDK will expand the scope of usage data collected to better inform CDK development and improve communication for security concerns and emerging issues.",
        detailsMd: `
    When this feature flag is enabled, CDK expands the scope of usage data collection to include the following:
      * L2 construct property keys - Collect which property keys you use from the L2 constructs in your app. This includes property keys nested in dictionary objects.
      * L2 construct property values of BOOL and ENUM types - Collect property key values of only BOOL and ENUM types. All other types, such as string values or construct references will be redacted.
      * L2 construct method usage - Collection method name, parameter keys and parameter values of BOOL and ENUM type.
    `,
        introducedIn: { v2: "2.178.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LAMBDA_CREATE_NEW_POLICIES_WITH_ADDTOROLEPOLICY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "[Deprecated] When enabled, Lambda will create new inline policies with AddToRolePolicy instead of adding to the Default Policy Statement",
        detailsMd: `
      [Deprecated default feature] When this feature flag is enabled, Lambda will create new inline policies with AddToRolePolicy.
      The purpose of this is to prevent lambda from creating a dependency on the Default Policy Statement.
      This solves an issue where a circular dependency could occur if adding lambda to something like a Cognito Trigger, then adding the User Pool to the lambda execution role permissions.
      However in the current implementation, we have removed a dependency of the lambda function on the policy. In addition to this, a Role will be attached to the Policy instead of an inline policy being attached to the role.
      This will create a data race condition in the CloudFormation template because the creation of the Lambda function no longer waits for the policy to be created. Having said that, we are not deprecating the feature (we are defaulting the feature flag to false for new stacks) since this feature can still be used to get around the circular dependency issue (issue-7016) particularly in cases where the lambda resource creation doesnt need to depend on the policy resource creation.
      We recommend to unset the feature flag if already set which will restore the original behavior.
    `,
        introducedIn: { v2: "2.180.0" },
        recommendedValue: false
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.SET_UNIQUE_REPLICATION_ROLE_NAME]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, CDK will automatically generate a unique role name that is used for s3 object replication.",
        detailsMd: `
      When performing cross-account S3 replication, we need to explicitly specify a role name for the replication execution role.
      When this feature flag is enabled, a unique role name is specified only when performing cross-account replication.
      When disabled, 'CDKReplicationRole' is always specified.
    `,
        introducedIn: { v2: "2.182.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.PIPELINE_REDUCE_STAGE_ROLE_TRUST_SCOPE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "Remove the root account principal from Stage addActions trust policy",
        detailsMd: `
      When this feature flag is enabled, the root account principal will not be added to the trust policy of stage role.
      When this feature flag is disabled, it will keep the root account principal in the trust policy.

      For cross-account cases, when this feature flag is enabled the trust policy will be scoped to the role only.
      If you are providing a custom role, you will need to ensure 'roleName' is specified or set to PhysicalName.GENERATE_IF_NEEDED.
    `,
        introducedIn: { v2: "2.184.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to add the root account principal back"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EVENTBUS_POLICY_SID_REQUIRED]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, grantPutEventsTo() will use resource policies with Statement IDs for service principals.",
        detailsMd: `
      Currently, when granting permissions to service principals using grantPutEventsTo(), the operation silently fails
      because service principals require resource policies with Statement IDs.

      When this flag is enabled:
      - Resource policies will be created with Statement IDs for service principals
      - The operation will succeed as expected

      When this flag is disabled:
      - A warning will be emitted
      - The grant operation will be dropped
      - No permissions will be added

      This fixes the issue where permissions were silently not being added for service principals.
    `,
        introducedIn: { v2: "2.186.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.ASPECT_PRIORITIES_MUTATING]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When set to true, Aspects added by the construct library on your behalf will be given a priority of MUTATING.",
        detailsMd: `
      Custom Aspects you add have a priority of DEFAULT (500) if you don't
      assign a more specific priority, which is higher than MUTATING (200). This
      is relevant if a custom Aspect you add and an Aspect added by CDK try to
      configure the same value.

      If this flag is set to false (old behavior), Aspects added by CDK are also
      added with a priority of DEFAULT; because their priorities are equal, the
      Aspects that is closest to the target construct executes last (either
      yours or the Aspect added by the CDK).

      If this flag is set to true (recommended behavior), Aspects added by CDK are added
      with a priority of MUTATING, and custom Aspects you add with DEFAULT
      priority will always execute last and "win" the write. If you need Aspects
      added by CDK to run after yours, your Aspect needs to have a priority of
      MUTATING or lower.

      This setting only applies to Aspects that were already being added for you
      before version 2.172.0. Aspects introduced since that version will always
      be added with a priority of MUTATING, independent of this feature flag.
    `,
        introducedIn: { v2: "2.189.1" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: `
      To add mutating Aspects controlling construct values that can be overridden
      by Aspects added by CDK, give them MUTATING priority:

      \`\`\`
      Aspects.of(stack).add(new MyCustomAspect(), {
        priority: AspectPriority.MUTATING,
      });
      \`\`\`
    `
      },
      [exports2.DYNAMODB_TABLE_RETAIN_TABLE_REPLICA]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, table replica will be default to the removal policy of source table unless specified otherwise.",
        detailsMd: `
      Currently, table replica will always be deleted when stack deletes regardless of source table's deletion policy.
      When enabled, table replica will be default to the removal policy of source table unless specified otherwise.
    `,
        introducedIn: { v2: "2.187.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.LOG_USER_POOL_CLIENT_SECRET_VALUE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When disabled, the value of the user pool client secret will not be logged in the custom resource lambda function logs.",
        detailsMd: `
      When this feature flag is enabled, the SDK API call response to desribe user pool client values will be logged in the custom
      resource lambda function logs.

      When this feature flag is disabled, the SDK API call response to describe user pool client values will not be logged in the custom
      resource lambda function logs.
    `,
        introducedIn: { v2: "2.187.0" },
        defaults: { v2: false },
        recommendedValue: false,
        compatibilityWithOldBehaviorMd: "Enable the feature flag to keep the old behavior and log the client secret values"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.PIPELINE_REDUCE_CROSS_ACCOUNT_ACTION_ROLE_TRUST_SCOPE]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, scopes down the trust policy for the cross-account action role",
        detailsMd: `
        When this feature flag is enabled, the trust policy of the cross-account action role will be scoped to the pipeline role.
        If you are providing a custom role, you will need to ensure 'roleName' is specified or set to PhysicalName.GENERATE_IF_NEEDED.
        When this feature flag is disabled, it will keep the root account principal in the trust policy.
      `,
        introducedIn: { v2: "2.189.0" },
        defaults: { v2: true },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag to add the root account principal back"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.STEPFUNCTIONS_USE_DISTRIBUTED_MAP_RESULT_WRITER_V2]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, the resultWriterV2 property of DistributedMap will be used insted of resultWriter",
        detailsMd: `
      When this feature flag is enabled, the resultWriterV2 property is used instead of resultWriter in DistributedMap class.
      resultWriterV2 uses ResultWriterV2 class in StepFunctions ASL and can have either Bucket/Prefix or WriterConfig or both.
    `,
        introducedIn: { v2: "2.188.0" },
        recommendedValue: true,
        compatibilityWithOldBehaviorMd: "Disable the feature flag and set resultWriter in DistributedMap"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_TRUST_KEY_POLICY_FOR_SNS_SUBSCRIPTIONS]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "Add an S3 trust policy to a KMS key resource policy for SNS subscriptions.",
        detailsMd: `
      When this feature flag is enabled, a S3 trust policy will be added to the KMS key resource policy for encrypted SNS subscriptions.
          `,
        introducedIn: { v2: "2.195.0" },
        recommendedValue: true
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.EC2_REQUIRE_PRIVATE_SUBNETS_FOR_EGRESSONLYINTERNETGATEWAY]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, the EgressOnlyGateway resource is only created if private subnets are defined in the dual-stack VPC.",
        detailsMd: `
      When this feature flag is enabled, EgressOnlyGateway resource will not be created when you create a vpc with only public subnets.
          `,
        introducedIn: { v2: "2.196.0" },
        recommendedValue: true
      },
      /// ///////////////////////////////////////////////////////////////////
      [exports2.USE_RESOURCEID_FOR_VPCV2_MIGRATION]: {
        type: flag_modeling_1.FlagType.ApiDefault,
        summary: "When enabled, use resource IDs for VPC V2 migration",
        detailsMd: `
        When this feature flag is enabled, the VPC V2 migration will use resource IDs instead of getAtt references
        for migrating resources from VPC V1 to VPC V2. This helps ensure a smoother migration path between
        the two versions.
      `,
        introducedIn: { v2: "V2_NEXT" },
        recommendedValue: false,
        defaults: { v2: false },
        compatibilityWithOldBehaviorMd: "Disable the feature flag to use getAtt references for VPC V2 migration"
      },
      //////////////////////////////////////////////////////////////////////
      [exports2.S3_PUBLIC_ACCESS_BLOCKED_BY_DEFAULT]: {
        type: flag_modeling_1.FlagType.BugFix,
        summary: "When enabled, setting any combination of options for BlockPublicAccess will automatically set true for any options not defined.",
        detailsMd: `
      When BlockPublicAccess is not set at all, s3's default behavior will be to set all options to true in aws console. 
      The previous behavior in cdk before this feature was; if only some of the BlockPublicAccessOptions were set (not all 4), then the ones undefined would default to false.
      This is counter intuitive to the console behavior where the options would start in true state and a user would uncheck the boxes as needed.
      The new behavior from this feature will allow a user, for example, to set 1 of the 4 BlockPublicAccessOpsions to false, and on deployment the other 3 will remain true.
    `,
        introducedIn: { v2: "2.196.0" },
        recommendedValue: true
      }
    };
    var CURRENT_MV = "v2";
    exports2.CURRENT_VERSION_EXPIRED_FLAGS = Object.entries(exports2.FLAGS).filter(([_3, flag]) => flag.introducedIn[CURRENT_MV] === void 0).map(([name, _3]) => name).sort();
    exports2.CURRENTLY_RECOMMENDED_FLAGS = Object.fromEntries(Object.entries(exports2.FLAGS).filter(([_3, flag]) => {
      var _a4;
      return flag.recommendedValue !== ((_a4 = flag.defaults) == null ? void 0 : _a4[CURRENT_MV]) && flag.introducedIn[CURRENT_MV];
    }).map(([name, flag]) => [name, flag.recommendedValue]));
    exports2.CURRENT_VERSION_FLAG_DEFAULTS = Object.fromEntries(Object.entries(exports2.FLAGS).filter(([_3, flag]) => {
      var _a4;
      return ((_a4 = flag.defaults) == null ? void 0 : _a4[CURRENT_MV]) !== void 0;
    }).map(([name, flag]) => {
      var _a4;
      return [name, (_a4 = flag.defaults) == null ? void 0 : _a4[CURRENT_MV]];
    }));
    function futureFlagDefault2(flag) {
      const value = exports2.CURRENT_VERSION_FLAG_DEFAULTS[flag] ?? false;
      if (typeof value !== "boolean") {
        throw new Error(`futureFlagDefault: default type of flag '${flag}' should be boolean, got '${typeof value}'`);
      }
      return value;
    }
    exports2.FUTURE_FLAGS_EXPIRED = exports2.CURRENT_VERSION_EXPIRED_FLAGS;
    exports2.FUTURE_FLAGS = Object.fromEntries(Object.entries(exports2.CURRENTLY_RECOMMENDED_FLAGS).filter(([_3, v6]) => typeof v6 === "boolean"));
    exports2.NEW_PROJECT_DEFAULT_CONTEXT = Object.fromEntries(Object.entries(exports2.CURRENTLY_RECOMMENDED_FLAGS).filter(([_3, v6]) => typeof v6 !== "boolean"));
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/placeholders.js
var require_placeholders = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/placeholders.js"(exports2) {
    "use strict";
    var _a4;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EnvironmentPlaceholders = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var EnvironmentPlaceholders4 = class _EnvironmentPlaceholders {
      /**
       * Replace the environment placeholders in all strings found in a complex object.
       *
       * Duplicated between cdk-assets and aws-cdk CLI because we don't have a good single place to put it
       * (they're nominally independent tools).
       */
      static replace(object, values) {
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_EnvironmentPlaceholderValues(values);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, this.replace);
          }
          throw error5;
        }
        return this.recurse(object, (value) => {
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_REGION, values.region);
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
          return value;
        });
      }
      /**
       * Like 'replace', but asynchronous
       */
      static async replaceAsync(object, provider) {
        try {
          jsiiDeprecationWarnings._aws_cdk_cx_api_IEnvironmentPlaceholderProvider(provider);
        } catch (error5) {
          if (process.env.JSII_DEBUG !== "1" && error5.name === "DeprecationError") {
            Error.captureStackTrace(error5, this.replaceAsync);
          }
          throw error5;
        }
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, (value) => {
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_REGION) > 1) {
            needRegion = true;
          }
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
            needAccountId = true;
          }
          if (value.indexOf(_EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
            needPartition = true;
          }
          return value;
        });
        const region = needRegion ? await provider.region() : void 0;
        const accountId = needAccountId ? await provider.accountId() : void 0;
        const partition3 = needPartition ? await provider.partition() : void 0;
        return this.recurse(object, (value) => {
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_REGION, region ?? "WONTHAPPEN");
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId ?? "WONTHAPPEN");
          value = replaceAll(value, _EnvironmentPlaceholders.CURRENT_PARTITION, partition3 ?? "WONTHAPPEN");
          return value;
        });
      }
      static recurse(value, cb) {
        if (typeof value === "string") {
          return cb(value);
        }
        if (typeof value !== "object" || value === null) {
          return value;
        }
        if (Array.isArray(value)) {
          return value.map((x3) => this.recurse(x3, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
          ret[key] = this.recurse(inner, cb);
        }
        return ret;
      }
    };
    exports2.EnvironmentPlaceholders = EnvironmentPlaceholders4;
    _a4 = JSII_RTTI_SYMBOL_1;
    EnvironmentPlaceholders4[_a4] = { fqn: "@aws-cdk/cx-api.EnvironmentPlaceholders", version: "2.198.0" };
    EnvironmentPlaceholders4.CURRENT_REGION = "${AWS::Region}";
    EnvironmentPlaceholders4.CURRENT_ACCOUNT = "${AWS::AccountId}";
    EnvironmentPlaceholders4.CURRENT_PARTITION = "${AWS::Partition}";
    function replaceAll(s3, search, replace) {
      return s3.split(search).join(replace);
    }
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/app.js
var require_app = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/app.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BUNDLING_STACKS = exports2.DISABLE_LOGICAL_ID_METADATA = exports2.DISABLE_METADATA_STACK_TRACE = exports2.DISABLE_ASSET_STAGING_CONTEXT = exports2.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports2.PATH_METADATA_ENABLE_CONTEXT = void 0;
    exports2.PATH_METADATA_ENABLE_CONTEXT = "aws:cdk:enable-path-metadata";
    exports2.ANALYTICS_REPORTING_ENABLED_CONTEXT = "aws:cdk:version-reporting";
    exports2.DISABLE_ASSET_STAGING_CONTEXT = "aws:cdk:disable-asset-staging";
    exports2.DISABLE_METADATA_STACK_TRACE = "aws:cdk:disable-stack-trace";
    exports2.DISABLE_LOGICAL_ID_METADATA = "aws:cdk:disable-logicalId-metadata";
    exports2.BUNDLING_STACKS = "aws:cdk:bundling-stacks";
  }
});

// ../../node_modules/@aws-cdk/cx-api/lib/index.js
var require_lib3 = __commonJS({
  "../../node_modules/@aws-cdk/cx-api/lib/index.js"(exports2) {
    "use strict";
    var __createBinding3 = exports2 && exports2.__createBinding || (Object.create ? function(o3, m3, k3, k22) {
      if (k22 === void 0) k22 = k3;
      var desc = Object.getOwnPropertyDescriptor(m3, k3);
      if (!desc || ("get" in desc ? !m3.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m3[k3];
        } };
      }
      Object.defineProperty(o3, k22, desc);
    } : function(o3, m3, k3, k22) {
      if (k22 === void 0) k22 = k3;
      o3[k22] = m3[k3];
    });
    var __exportStar3 = exports2 && exports2.__exportStar || function(m3, exports3) {
      for (var p3 in m3) if (p3 !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p3)) __createBinding3(exports3, m3, p3);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar3(require_cxapi(), exports2);
    __exportStar3(require_vpc(), exports2);
    __exportStar3(require_ami(), exports2);
    __exportStar3(require_load_balancer(), exports2);
    __exportStar3(require_availability_zones(), exports2);
    __exportStar3(require_endpoint_service_availability_zones(), exports2);
    __exportStar3(require_security_group(), exports2);
    __exportStar3(require_key(), exports2);
    __exportStar3(require_cloud_artifact(), exports2);
    require_cloud_artifact_aug();
    __exportStar3(require_asset_manifest_artifact(), exports2);
    __exportStar3(require_cloudformation_artifact(), exports2);
    __exportStar3(require_tree_cloud_artifact(), exports2);
    __exportStar3(require_nested_cloud_assembly_artifact(), exports2);
    require_nested_cloud_assembly_artifact_aug();
    __exportStar3(require_cloud_assembly(), exports2);
    __exportStar3(require_assets(), exports2);
    __exportStar3(require_environment(), exports2);
    __exportStar3(require_metadata(), exports2);
    __exportStar3(require_features(), exports2);
    __exportStar3(require_placeholders(), exports2);
    __exportStar3(require_app(), exports2);
  }
});

// ../../node_modules/universalify/index.js
var require_universalify = __commonJS({
  "../../node_modules/universalify/index.js"(exports2) {
    "use strict";
    exports2.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function") fn.apply(this, args);
        else {
          return new Promise((resolve12, reject) => {
            args.push((err, res) => err != null ? reject(err) : resolve12(res));
            fn.apply(this, args);
          });
        }
      }, "name", { value: fn.name });
    };
    exports2.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function") return fn.apply(this, args);
        else {
          args.pop();
          fn.apply(this, args).then((r3) => cb(null, r3), cb);
        }
      }, "name", { value: fn.name });
    };
  }
});

// ../../node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "../../node_modules/graceful-fs/polyfills.js"(exports2, module2) {
    var constants3 = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform3 = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d3) {
        cwd = null;
        chdir.call(process, d3);
      };
      if (Object.setPrototypeOf) Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs38) {
      if (constants3.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs38);
      }
      if (!fs38.lutimes) {
        patchLutimes(fs38);
      }
      fs38.chown = chownFix(fs38.chown);
      fs38.fchown = chownFix(fs38.fchown);
      fs38.lchown = chownFix(fs38.lchown);
      fs38.chmod = chmodFix(fs38.chmod);
      fs38.fchmod = chmodFix(fs38.fchmod);
      fs38.lchmod = chmodFix(fs38.lchmod);
      fs38.chownSync = chownFixSync(fs38.chownSync);
      fs38.fchownSync = chownFixSync(fs38.fchownSync);
      fs38.lchownSync = chownFixSync(fs38.lchownSync);
      fs38.chmodSync = chmodFixSync(fs38.chmodSync);
      fs38.fchmodSync = chmodFixSync(fs38.fchmodSync);
      fs38.lchmodSync = chmodFixSync(fs38.lchmodSync);
      fs38.stat = statFix(fs38.stat);
      fs38.fstat = statFix(fs38.fstat);
      fs38.lstat = statFix(fs38.lstat);
      fs38.statSync = statFixSync(fs38.statSync);
      fs38.fstatSync = statFixSync(fs38.fstatSync);
      fs38.lstatSync = statFixSync(fs38.lstatSync);
      if (fs38.chmod && !fs38.lchmod) {
        fs38.lchmod = function(path34, mode, cb) {
          if (cb) process.nextTick(cb);
        };
        fs38.lchmodSync = function() {
        };
      }
      if (fs38.chown && !fs38.lchown) {
        fs38.lchown = function(path34, uid, gid, cb) {
          if (cb) process.nextTick(cb);
        };
        fs38.lchownSync = function() {
        };
      }
      if (platform3 === "win32") {
        fs38.rename = typeof fs38.rename !== "function" ? fs38.rename : function(fs$rename) {
          function rename(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM" || er.code === "EBUSY") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs38.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb) cb(er);
            });
          }
          if (Object.setPrototypeOf) Object.setPrototypeOf(rename, fs$rename);
          return rename;
        }(fs38.rename);
      }
      fs38.read = typeof fs38.read !== "function" ? fs38.read : function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = function(er, _3, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs38, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            };
          }
          return fs$read.call(fs38, fd, buffer, offset, length, position, callback);
        }
        if (Object.setPrototypeOf) Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs38.read);
      fs38.readSync = typeof fs38.readSync !== "function" ? fs38.readSync : /* @__PURE__ */ function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs38, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs38.readSync);
      function patchLchmod(fs39) {
        fs39.lchmod = function(path34, mode, callback) {
          fs39.open(
            path34,
            constants3.O_WRONLY | constants3.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback) callback(err);
                return;
              }
              fs39.fchmod(fd, mode, function(err2) {
                fs39.close(fd, function(err22) {
                  if (callback) callback(err2 || err22);
                });
              });
            }
          );
        };
        fs39.lchmodSync = function(path34, mode) {
          var fd = fs39.openSync(path34, constants3.O_WRONLY | constants3.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs39.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs39.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs39.closeSync(fd);
            }
          }
          return ret;
        };
      }
      function patchLutimes(fs39) {
        if (constants3.hasOwnProperty("O_SYMLINK") && fs39.futimes) {
          fs39.lutimes = function(path34, at, mt, cb) {
            fs39.open(path34, constants3.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb) cb(er);
                return;
              }
              fs39.futimes(fd, at, mt, function(er2) {
                fs39.close(fd, function(er22) {
                  if (cb) cb(er2 || er22);
                });
              });
            });
          };
          fs39.lutimesSync = function(path34, at, mt) {
            var fd = fs39.openSync(path34, constants3.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs39.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs39.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs39.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs39.futimes) {
          fs39.lutimes = function(_a4, _b2, _c, cb) {
            if (cb) process.nextTick(cb);
          };
          fs39.lutimesSync = function() {
          };
        }
      }
      function chmodFix(orig) {
        if (!orig) return orig;
        return function(target, mode, cb) {
          return orig.call(fs38, target, mode, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      function chmodFixSync(orig) {
        if (!orig) return orig;
        return function(target, mode) {
          try {
            return orig.call(fs38, target, mode);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      function chownFix(orig) {
        if (!orig) return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs38, target, uid, gid, function(er) {
            if (chownErOk(er)) er = null;
            if (cb) cb.apply(this, arguments);
          });
        };
      }
      function chownFixSync(orig) {
        if (!orig) return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs38, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er)) throw er;
          }
        };
      }
      function statFix(orig) {
        if (!orig) return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0) stats.uid += 4294967296;
              if (stats.gid < 0) stats.gid += 4294967296;
            }
            if (cb) cb.apply(this, arguments);
          }
          return options ? orig.call(fs38, target, options, callback) : orig.call(fs38, target, callback);
        };
      }
      function statFixSync(orig) {
        if (!orig) return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs38, target, options) : orig.call(fs38, target);
          if (stats) {
            if (stats.uid < 0) stats.uid += 4294967296;
            if (stats.gid < 0) stats.gid += 4294967296;
          }
          return stats;
        };
      }
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
    }
  }
});

// ../../node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "../../node_modules/graceful-fs/legacy-streams.js"(exports2, module2) {
    var Stream2 = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs38) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path34, options) {
        if (!(this instanceof ReadStream)) return new ReadStream(path34, options);
        Stream2.call(this);
        var self2 = this;
        this.path = path34;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding) this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self2._read();
          });
          return;
        }
        fs38.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self2.emit("error", err);
            self2.readable = false;
            return;
          }
          self2.fd = fd;
          self2.emit("open", fd);
          self2._read();
        });
      }
      function WriteStream(path34, options) {
        if (!(this instanceof WriteStream)) return new WriteStream(path34, options);
        Stream2.call(this);
        this.path = path34;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs38.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
    }
  }
});

// ../../node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "../../node_modules/graceful-fs/clone.js"(exports2, module2) {
    "use strict";
    module2.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy2 = { __proto__: getPrototypeOf(obj) };
      else
        var copy2 = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy2, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy2;
    }
  }
});

// ../../node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "../../node_modules/graceful-fs/graceful-fs.js"(exports2, module2) {
    var fs38 = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util11 = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue2;
        }
      });
    }
    var debug4 = noop;
    if (util11.debuglog)
      debug4 = util11.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug4 = function() {
        var m3 = util11.format.apply(util11, arguments);
        m3 = "GFS4: " + m3.split(/\n/).join("\nGFS4: ");
        console.error(m3);
      };
    if (!fs38[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs38, queue);
      fs38.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs38, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs38.close);
      fs38.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs38, arguments);
          resetQueue();
        }
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs38.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug4(fs38[gracefulQueue]);
          require("assert").equal(fs38[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs38[gracefulQueue]);
    }
    module2.exports = patch(clone(fs38));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs38.__patched) {
      module2.exports = patch(fs38);
      fs38.__patched = true;
    }
    function patch(fs39) {
      polyfills(fs39);
      fs39.gracefulify = patch;
      fs39.createReadStream = createReadStream2;
      fs39.createWriteStream = createWriteStream3;
      var fs$readFile = fs39.readFile;
      fs39.readFile = readFile4;
      function readFile4(path34, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path34, options, cb);
        function go$readFile(path35, options2, cb2, startTime) {
          return fs$readFile(path35, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path35, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$writeFile = fs39.writeFile;
      fs39.writeFile = writeFile4;
      function writeFile4(path34, data2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path34, data2, options, cb);
        function go$writeFile(path35, data3, options2, cb2, startTime) {
          return fs$writeFile(path35, data3, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path35, data3, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$appendFile = fs39.appendFile;
      if (fs$appendFile)
        fs39.appendFile = appendFile;
      function appendFile(path34, data2, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path34, data2, options, cb);
        function go$appendFile(path35, data3, options2, cb2, startTime) {
          return fs$appendFile(path35, data3, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path35, data3, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$copyFile = fs39.copyFile;
      if (fs$copyFile)
        fs39.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$readdir = fs39.readdir;
      fs39.readdir = readdir3;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir3(path34, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? function go$readdir2(path35, options2, cb2, startTime) {
          return fs$readdir(path35, fs$readdirCallback(
            path35,
            options2,
            cb2,
            startTime
          ));
        } : function go$readdir2(path35, options2, cb2, startTime) {
          return fs$readdir(path35, options2, fs$readdirCallback(
            path35,
            options2,
            cb2,
            startTime
          ));
        };
        return go$readdir(path34, options, cb);
        function fs$readdirCallback(path35, options2, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path35, options2, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
      }
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs39);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs39.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs39.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs39, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val2) {
          ReadStream = val2;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs39, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val2) {
          WriteStream = val2;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs39, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val2) {
          FileReadStream = val2;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs39, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val2) {
          FileWriteStream = val2;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path34, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      function ReadStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      function WriteStream(path34, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      function WriteStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      function createReadStream2(path34, options) {
        return new fs39.ReadStream(path34, options);
      }
      function createWriteStream3(path34, options) {
        return new fs39.WriteStream(path34, options);
      }
      var fs$open = fs39.open;
      fs39.open = open;
      function open(path34, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path34, flags, mode, cb);
        function go$open(path35, flags2, mode2, cb2, startTime) {
          return fs$open(path35, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path35, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      return fs39;
    }
    function enqueue(elem) {
      debug4("ENQUEUE", elem[0].name, elem[1]);
      fs38[gracefulQueue].push(elem);
      retry();
    }
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i3 = 0; i3 < fs38[gracefulQueue].length; ++i3) {
        if (fs38[gracefulQueue][i3].length > 2) {
          fs38[gracefulQueue][i3][3] = now;
          fs38[gracefulQueue][i3][4] = now;
        }
      }
      retry();
    }
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs38[gracefulQueue].length === 0)
        return;
      var elem = fs38[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug4("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug4("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug4("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs38[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/fs/index.js"(exports2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var fs38 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs38[key] === "function";
    });
    Object.keys(fs38).forEach((key) => {
      if (key === "promises") {
        return;
      }
      exports2[key] = fs38[key];
    });
    api.forEach((method) => {
      exports2[method] = u3(fs38[method]);
    });
    exports2.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs38.exists(filename, callback);
      }
      return new Promise((resolve12) => {
        return fs38.exists(filename, resolve12);
      });
    };
    exports2.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs38.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve12, reject) => {
        fs38.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err) return reject(err);
          resolve12({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports2.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs38.write(fd, buffer, ...args);
      }
      return new Promise((resolve12, reject) => {
        fs38.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err) return reject(err);
          resolve12({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs38.writev === "function") {
      exports2.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs38.writev(fd, buffers, ...args);
        }
        return new Promise((resolve12, reject) => {
          fs38.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err) return reject(err);
            resolve12({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
    if (typeof fs38.realpath.native === "function") {
      exports2.realpath.native = u3(fs38.realpath.native);
    }
  }
});

// ../../node_modules/at-least-node/index.js
var require_at_least_node = __commonJS({
  "../../node_modules/at-least-node/index.js"(exports2, module2) {
    module2.exports = (r3) => {
      const n3 = process.versions.node.split(".").map((x3) => parseInt(x3, 10));
      r3 = r3.split(".").map((x3) => parseInt(x3, 10));
      return n3[0] > r3[0] || n3[0] === r3[0] && (n3[1] > r3[1] || n3[1] === r3[1] && n3[2] >= r3[2]);
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports2, module2) {
    "use strict";
    var fs38 = require_fs();
    var path34 = require("path");
    var atLeastNode = require_at_least_node();
    var useNativeRecursiveOption = atLeastNode("10.12.0");
    var checkPath = (pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path34.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error5 = new Error(`Path contains invalid characters: ${pth}`);
          error5.code = "EINVAL";
          throw error5;
        }
      }
    };
    var processOptions = (options) => {
      const defaults4 = { mode: 511 };
      if (typeof options === "number") options = { mode: options };
      return { ...defaults4, ...options };
    };
    var permissionError = (pth) => {
      const error5 = new Error(`operation not permitted, mkdir '${pth}'`);
      error5.code = "EPERM";
      error5.errno = -4048;
      error5.path = pth;
      error5.syscall = "mkdir";
      return error5;
    };
    module2.exports.makeDir = async (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path34.resolve(input);
        return fs38.mkdir(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = async (pth) => {
        try {
          await fs38.mkdir(pth, options.mode);
        } catch (error5) {
          if (error5.code === "EPERM") {
            throw error5;
          }
          if (error5.code === "ENOENT") {
            if (path34.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error5.message.includes("null bytes")) {
              throw error5;
            }
            await make(path34.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await fs38.stat(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error5;
          }
        }
      };
      return make(path34.resolve(input));
    };
    module2.exports.makeDirSync = (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path34.resolve(input);
        return fs38.mkdirSync(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = (pth) => {
        try {
          fs38.mkdirSync(pth, options.mode);
        } catch (error5) {
          if (error5.code === "EPERM") {
            throw error5;
          }
          if (error5.code === "ENOENT") {
            if (path34.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error5.message.includes("null bytes")) {
              throw error5;
            }
            make(path34.dirname(pth));
            return make(pth);
          }
          try {
            if (!fs38.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error5;
          }
        }
      };
      return make(path34.resolve(input));
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/mkdirs/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u3(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      // alias
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/utimes.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    function utimesMillis(path34, atime, mtime, callback) {
      fs38.open(path34, "r+", (err, fd) => {
        if (err) return callback(err);
        fs38.futimes(fd, atime, mtime, (futimesErr) => {
          fs38.close(fd, (closeErr) => {
            if (callback) callback(futimesErr || closeErr);
          });
        });
      });
    }
    function utimesMillisSync(path34, atime, mtime) {
      const fd = fs38.openSync(path34, "r+");
      fs38.futimesSync(fd, atime, mtime);
      return fs38.closeSync(fd);
    }
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/util/stat.js"(exports2, module2) {
    "use strict";
    var fs38 = require_fs();
    var path34 = require("path");
    var util11 = require("util");
    var atLeastNode = require_at_least_node();
    var nodeSupportsBigInt = atLeastNode("10.5.0");
    var stat5 = (file) => nodeSupportsBigInt ? fs38.stat(file, { bigint: true }) : fs38.stat(file);
    var statSync2 = (file) => nodeSupportsBigInt ? fs38.statSync(file, { bigint: true }) : fs38.statSync(file);
    function getStats(src, dest) {
      return Promise.all([
        stat5(src),
        stat5(dest).catch((err) => {
          if (err.code === "ENOENT") return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    function getStatsSync(src, dest) {
      let destStat;
      const srcStat = statSync2(src);
      try {
        destStat = statSync2(dest);
      } catch (err) {
        if (err.code === "ENOENT") return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    function checkPaths(src, dest, funcName, cb) {
      util11.callbackify(getStats)(src, dest, (err, stats) => {
        if (err) return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat && areIdentical(srcStat, destStat)) {
          return cb(new Error("Source and destination must not be the same."));
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    function checkPathsSync(src, dest, funcName) {
      const { srcStat, destStat } = getStatsSync(src, dest);
      if (destStat && areIdentical(srcStat, destStat)) {
        throw new Error("Source and destination must not be the same.");
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path34.resolve(path34.dirname(src));
      const destParent = path34.resolve(path34.dirname(dest));
      if (destParent === srcParent || destParent === path34.parse(destParent).root) return cb();
      const callback = (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT") return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      };
      if (nodeSupportsBigInt) fs38.stat(destParent, { bigint: true }, callback);
      else fs38.stat(destParent, callback);
    }
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path34.resolve(path34.dirname(src));
      const destParent = path34.resolve(path34.dirname(dest));
      if (destParent === srcParent || destParent === path34.parse(destParent).root) return;
      let destStat;
      try {
        destStat = statSync2(destParent);
      } catch (err) {
        if (err.code === "ENOENT") return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    function areIdentical(srcStat, destStat) {
      if (destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev) {
        if (nodeSupportsBigInt || destStat.ino < Number.MAX_SAFE_INTEGER) {
          return true;
        }
        if (destStat.size === srcStat.size && destStat.mode === srcStat.mode && destStat.nlink === srcStat.nlink && destStat.atimeMs === srcStat.atimeMs && destStat.mtimeMs === srcStat.mtimeMs && destStat.ctimeMs === srcStat.ctimeMs && destStat.birthtimeMs === srcStat.birthtimeMs) {
          return true;
        }
      }
      return false;
    }
    function isSrcSubdir(src, dest) {
      const srcArr = path34.resolve(src).split(path34.sep).filter((i3) => i3);
      const destArr = path34.resolve(dest).split(path34.sep).filter((i3) => i3);
      return srcArr.reduce((acc, cur, i3) => acc && destArr[i3] === cur, true);
    }
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var mkdirsSync2 = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat5 = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat5.checkPathsSync(src, dest, "copy");
      stat5.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest)) return;
      const destParent = path34.dirname(dest);
      if (!fs38.existsSync(destParent)) mkdirsSync2(destParent);
      return startCopy(destStat, src, dest, opts);
    }
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest)) return;
      return getStats(destStat, src, dest, opts);
    }
    function getStats(destStat, src, dest, opts) {
      const statSync2 = opts.dereference ? fs38.statSync : fs38.lstatSync;
      const srcStat = statSync2(src);
      if (srcStat.isDirectory()) return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice()) return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink()) return onLink(destStat, src, dest, opts);
    }
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat) return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs38.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    function copyFile(srcStat, src, dest, opts) {
      fs38.copyFileSync(src, dest);
      if (opts.preserveTimestamps) handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode)) makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    function setDestMode(dest, srcMode) {
      return fs38.chmodSync(dest, srcMode);
    }
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs38.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat) return mkDirAndCopy(srcStat.mode, src, dest, opts);
      if (destStat && !destStat.isDirectory()) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
      }
      return copyDir(src, dest, opts);
    }
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs38.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    function copyDir(src, dest, opts) {
      fs38.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path34.join(src, item);
      const destItem = path34.join(dest, item);
      const { destStat } = stat5.checkPathsSync(srcItem, destItem, "copy");
      return startCopy(destStat, srcItem, destItem, opts);
    }
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs38.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path34.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs38.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs38.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN") return fs38.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path34.resolve(process.cwd(), resolvedDest);
        }
        if (stat5.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs38.statSync(dest).isDirectory() && stat5.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    function copyLink(resolvedSrc, dest) {
      fs38.unlinkSync(dest);
      return fs38.symlinkSync(resolvedSrc, dest);
    }
    module2.exports = copySync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy-sync/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync()
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/path-exists/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var fs38 = require_fs();
    function pathExists8(path34) {
      return fs38.access(path34).then(() => true).catch(() => false);
    }
    module2.exports = {
      pathExists: u3(pathExists8),
      pathExistsSync: fs38.existsSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/copy.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists8 = require_path_exists().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat5 = require_stat();
    function copy2(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat5.checkPaths(src, dest, "copy", (err, stats) => {
        if (err) return cb(err);
        const { srcStat, destStat } = stats;
        stat5.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2) return cb(err2);
          if (opts.filter) return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path34.dirname(dest);
      pathExists8(destParent, (err, dirExists) => {
        if (err) return cb(err);
        if (dirExists) return startCopy(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2) return cb(err2);
          return startCopy(destStat, src, dest, opts, cb);
        });
      });
    }
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include) return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error5) => cb(error5));
    }
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter) return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    function getStats(destStat, src, dest, opts, cb) {
      const stat6 = opts.dereference ? fs38.stat : fs38.lstat;
      stat6(src, (err, srcStat) => {
        if (err) return cb(err);
        if (srcStat.isDirectory()) return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice()) return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink()) return onLink(destStat, src, dest, opts, cb);
      });
    }
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat) return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs38.unlink(dest, (err) => {
          if (err) return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else return cb();
    }
    function copyFile(srcStat, src, dest, opts, cb) {
      fs38.copyFile(src, dest, (err) => {
        if (err) return cb(err);
        if (opts.preserveTimestamps) return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err) return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err) return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    function setDestMode(dest, srcMode, cb) {
      return fs38.chmod(dest, srcMode, cb);
    }
    function setDestTimestamps(src, dest, cb) {
      fs38.stat(src, (err, updatedSrcStat) => {
        if (err) return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat) return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      if (destStat && !destStat.isDirectory()) {
        return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
      }
      return copyDir(src, dest, opts, cb);
    }
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs38.mkdir(dest, (err) => {
        if (err) return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2) return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    function copyDir(src, dest, opts, cb) {
      fs38.readdir(src, (err, items) => {
        if (err) return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item) return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path34.join(src, item);
      const destItem = path34.join(dest, item);
      stat5.checkPaths(srcItem, destItem, "copy", (err, stats) => {
        if (err) return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2) return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    function onLink(destStat, src, dest, opts, cb) {
      fs38.readlink(src, (err, resolvedSrc) => {
        if (err) return cb(err);
        if (opts.dereference) {
          resolvedSrc = path34.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs38.symlink(resolvedSrc, dest, cb);
        } else {
          fs38.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN") return fs38.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path34.resolve(process.cwd(), resolvedDest);
            }
            if (stat5.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat5.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    function copyLink(resolvedSrc, dest, cb) {
      fs38.unlink(dest, (err) => {
        if (err) return cb(err);
        return fs38.symlink(resolvedSrc, dest, cb);
      });
    }
    module2.exports = copy2;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/copy/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    module2.exports = {
      copy: u3(require_copy())
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/rimraf.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var assert = require("assert");
    var isWindows = process.platform === "win32";
    function defaults4(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m3) => {
        options[m3] = options[m3] || fs38[m3];
        m3 = m3 + "Sync";
        options[m3] = options[m3] || fs38[m3];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    function rimraf(p3, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p3, "rimraf: missing path");
      assert.strictEqual(typeof p3, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults4(options);
      rimraf_(p3, options, function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time = busyTries * 100;
            return setTimeout(() => rimraf_(p3, options, CB), time);
          }
          if (er.code === "ENOENT") er = null;
        }
        cb(er);
      });
    }
    function rimraf_(p3, options, cb) {
      assert(p3);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p3, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows) {
          return fixWinEPERM(p3, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p3, options, er, cb);
        }
        options.unlink(p3, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows ? fixWinEPERM(p3, options, er2, cb) : rmdir(p3, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p3, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    function fixWinEPERM(p3, options, er, cb) {
      assert(p3);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p3, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p3, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p3, options, er, cb);
            } else {
              options.unlink(p3, cb);
            }
          });
        }
      });
    }
    function fixWinEPERMSync(p3, options, er) {
      let stats;
      assert(p3);
      assert(options);
      try {
        options.chmodSync(p3, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p3);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync2(p3, options, er);
      } else {
        options.unlinkSync(p3);
      }
    }
    function rmdir(p3, options, originalEr, cb) {
      assert(p3);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p3, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p3, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    function rmkids(p3, options, cb) {
      assert(p3);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p3, (er, files) => {
        if (er) return cb(er);
        let n3 = files.length;
        let errState;
        if (n3 === 0) return options.rmdir(p3, cb);
        files.forEach((f3) => {
          rimraf(path34.join(p3, f3), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2) return cb(errState = er2);
            if (--n3 === 0) {
              options.rmdir(p3, cb);
            }
          });
        });
      });
    }
    function rimrafSync(p3, options) {
      let st;
      options = options || {};
      defaults4(options);
      assert(p3, "rimraf: missing path");
      assert.strictEqual(typeof p3, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p3);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows) {
          fixWinEPERMSync(p3, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync2(p3, options, null);
        } else {
          options.unlinkSync(p3);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows ? fixWinEPERMSync(p3, options, er) : rmdirSync2(p3, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync2(p3, options, er);
      }
    }
    function rmdirSync2(p3, options, originalEr) {
      assert(p3);
      assert(options);
      try {
        options.rmdirSync(p3);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p3, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    function rmkidsSync(p3, options) {
      assert(p3);
      assert(options);
      options.readdirSync(p3).forEach((f3) => rimrafSync(path34.join(p3, f3), options));
      if (isWindows) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p3, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p3, options);
        return ret;
      }
    }
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/remove/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var rimraf = require_rimraf();
    module2.exports = {
      remove: u3(rimraf),
      removeSync: rimraf.sync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/empty/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var mkdir2 = require_mkdirs();
    var remove = require_remove();
    var emptyDir = u3(function emptyDir2(dir, callback) {
      callback = callback || function() {
      };
      fs38.readdir(dir, (err, items) => {
        if (err) return mkdir2.mkdirs(dir, callback);
        items = items.map((item) => path34.join(dir, item));
        deleteItem();
        function deleteItem() {
          const item = items.pop();
          if (!item) return callback();
          remove.remove(item, (err2) => {
            if (err2) return callback(err2);
            deleteItem();
          });
        }
      });
    });
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs38.readdirSync(dir);
      } catch {
        return mkdir2.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path34.join(dir, item);
        remove.removeSync(item);
      });
    }
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/file.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path34 = require("path");
    var fs38 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    function createFile(file, callback) {
      function makeFile() {
        fs38.writeFile(file, "", (err) => {
          if (err) return callback(err);
          callback();
        });
      }
      fs38.stat(file, (err, stats) => {
        if (!err && stats.isFile()) return callback();
        const dir = path34.dirname(file);
        fs38.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir2.mkdirs(dir, (err3) => {
                if (err3) return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory()) makeFile();
          else {
            fs38.readdir(dir, (err3) => {
              if (err3) return callback(err3);
            });
          }
        });
      });
    }
    function createFileSync(file) {
      let stats;
      try {
        stats = fs38.statSync(file);
      } catch {
      }
      if (stats && stats.isFile()) return;
      const dir = path34.dirname(file);
      try {
        if (!fs38.statSync(dir).isDirectory()) {
          fs38.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT") mkdir2.mkdirsSync(dir);
        else throw err;
      }
      fs38.writeFileSync(file, "");
    }
    module2.exports = {
      createFile: u3(createFile),
      createFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/link.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path34 = require("path");
    var fs38 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    var pathExists8 = require_path_exists().pathExists;
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs38.link(srcpath2, dstpath2, (err) => {
          if (err) return callback(err);
          callback(null);
        });
      }
      pathExists8(dstpath, (err, destinationExists) => {
        if (err) return callback(err);
        if (destinationExists) return callback(null);
        fs38.lstat(srcpath, (err2) => {
          if (err2) {
            err2.message = err2.message.replace("lstat", "ensureLink");
            return callback(err2);
          }
          const dir = path34.dirname(dstpath);
          pathExists8(dir, (err3, dirExists) => {
            if (err3) return callback(err3);
            if (dirExists) return makeLink(srcpath, dstpath);
            mkdir2.mkdirs(dir, (err4) => {
              if (err4) return callback(err4);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    function createLinkSync(srcpath, dstpath) {
      const destinationExists = fs38.existsSync(dstpath);
      if (destinationExists) return void 0;
      try {
        fs38.lstatSync(srcpath);
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path34.dirname(dstpath);
      const dirExists = fs38.existsSync(dir);
      if (dirExists) return fs38.linkSync(srcpath, dstpath);
      mkdir2.mkdirsSync(dir);
      return fs38.linkSync(srcpath, dstpath);
    }
    module2.exports = {
      createLink: u3(createLink),
      createLinkSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports2, module2) {
    "use strict";
    var path34 = require("path");
    var fs38 = require_graceful_fs();
    var pathExists8 = require_path_exists().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path34.isAbsolute(srcpath)) {
        return fs38.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path34.dirname(dstpath);
        const relativeToDst = path34.join(dstdir, srcpath);
        return pathExists8(relativeToDst, (err, exists) => {
          if (err) return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs38.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path34.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path34.isAbsolute(srcpath)) {
        exists = fs38.existsSync(srcpath);
        if (!exists) throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path34.dirname(dstpath);
        const relativeToDst = path34.join(dstdir, srcpath);
        exists = fs38.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs38.existsSync(srcpath);
          if (!exists) throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path34.relative(dstdir, srcpath)
          };
        }
      }
    }
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type) return callback(null, type);
      fs38.lstat(srcpath, (err, stats) => {
        if (err) return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type) return type;
      try {
        stats = fs38.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/symlink.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path34 = require("path");
    var fs38 = require_graceful_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync2 = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists8 = require_path_exists().pathExists;
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      pathExists8(dstpath, (err, destinationExists) => {
        if (err) return callback(err);
        if (destinationExists) return callback(null);
        symlinkPaths(srcpath, dstpath, (err2, relative2) => {
          if (err2) return callback(err2);
          srcpath = relative2.toDst;
          symlinkType(relative2.toCwd, type, (err3, type2) => {
            if (err3) return callback(err3);
            const dir = path34.dirname(dstpath);
            pathExists8(dir, (err4, dirExists) => {
              if (err4) return callback(err4);
              if (dirExists) return fs38.symlink(srcpath, dstpath, type2, callback);
              mkdirs(dir, (err5) => {
                if (err5) return callback(err5);
                fs38.symlink(srcpath, dstpath, type2, callback);
              });
            });
          });
        });
      });
    }
    function createSymlinkSync(srcpath, dstpath, type) {
      const destinationExists = fs38.existsSync(dstpath);
      if (destinationExists) return void 0;
      const relative2 = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative2.toDst;
      type = symlinkTypeSync(relative2.toCwd, type);
      const dir = path34.dirname(dstpath);
      const exists = fs38.existsSync(dir);
      if (exists) return fs38.symlinkSync(srcpath, dstpath, type);
      mkdirsSync2(dir);
      return fs38.symlinkSync(srcpath, dstpath, type);
    }
    module2.exports = {
      createSymlink: u3(createSymlink),
      createSymlinkSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/ensure/index.js"(exports2, module2) {
    "use strict";
    var file = require_file();
    var link = require_link();
    var symlink = require_symlink();
    module2.exports = {
      // file
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      // link
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      // symlink
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// ../../node_modules/jsonfile/utils.js
var require_utils = __commonJS({
  "../../node_modules/jsonfile/utils.js"(exports2, module2) {
    function stringify3(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF2 = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF2;
    }
    function stripBom(content) {
      if (Buffer.isBuffer(content)) content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    module2.exports = { stringify: stringify3, stripBom };
  }
});

// ../../node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "../../node_modules/jsonfile/index.js"(exports2, module2) {
    var _fs3;
    try {
      _fs3 = require_graceful_fs();
    } catch (_3) {
      _fs3 = require("fs");
    }
    var universalify = require_universalify();
    var { stringify: stringify3, stripBom } = require_utils();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs38 = options.fs || _fs3;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data2 = await universalify.fromCallback(fs38.readFile)(file, options);
      data2 = stripBom(data2);
      let obj;
      try {
        obj = JSON.parse(data2, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    var readFile4 = universalify.fromPromise(_readFile);
    function readFileSync9(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs38 = options.fs || _fs3;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs38.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    async function _writeFile(file, obj, options = {}) {
      const fs38 = options.fs || _fs3;
      const str = stringify3(obj, options);
      await universalify.fromCallback(fs38.writeFile)(file, str, options);
    }
    var writeFile4 = universalify.fromPromise(_writeFile);
    function writeFileSync4(file, obj, options = {}) {
      const fs38 = options.fs || _fs3;
      const str = stringify3(obj, options);
      return fs38.writeFileSync(file, str, options);
    }
    var jsonfile = {
      readFile: readFile4,
      readFileSync: readFileSync9,
      writeFile: writeFile4,
      writeFileSync: writeFileSync4
    };
    module2.exports = jsonfile;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/jsonfile.js"(exports2, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      // jsonfile exports
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/output/index.js
var require_output = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/output/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var mkdir2 = require_mkdirs();
    var pathExists8 = require_path_exists().pathExists;
    function outputFile(file, data2, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path34.dirname(file);
      pathExists8(dir, (err, itDoes) => {
        if (err) return callback(err);
        if (itDoes) return fs38.writeFile(file, data2, encoding, callback);
        mkdir2.mkdirs(dir, (err2) => {
          if (err2) return callback(err2);
          fs38.writeFile(file, data2, encoding, callback);
        });
      });
    }
    function outputFileSync(file, ...args) {
      const dir = path34.dirname(file);
      if (fs38.existsSync(dir)) {
        return fs38.writeFileSync(file, ...args);
      }
      mkdir2.mkdirsSync(dir);
      fs38.writeFileSync(file, ...args);
    }
    module2.exports = {
      outputFile: u3(outputFile),
      outputFileSync
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify3 } = require_utils();
    var { outputFile } = require_output();
    async function outputJson(file, data2, options = {}) {
      const str = stringify3(data2, options);
      await outputFile(file, str, options);
    }
    module2.exports = outputJson;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/output-json-sync.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify3 } = require_utils();
    var { outputFileSync } = require_output();
    function outputJsonSync(file, data2, options) {
      const str = stringify3(data2, options);
      outputFileSync(file, str, options);
    }
    module2.exports = outputJsonSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/json/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u3(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/move-sync.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var copySync = require_copy_sync2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync2 = require_mkdirs().mkdirpSync;
    var stat5 = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat } = stat5.checkPathsSync(src, dest, "move");
      stat5.checkParentPathsSync(src, srcStat, dest, "move");
      mkdirpSync2(path34.dirname(dest));
      return doRename(src, dest, overwrite);
    }
    function doRename(src, dest, overwrite) {
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs38.existsSync(dest)) throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    function rename(src, dest, overwrite) {
      try {
        fs38.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV") throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    module2.exports = moveSync;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move-sync/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync()
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/move.js"(exports2, module2) {
    "use strict";
    var fs38 = require_graceful_fs();
    var path34 = require("path");
    var copy2 = require_copy2().copy;
    var remove = require_remove().remove;
    var mkdirp2 = require_mkdirs().mkdirp;
    var pathExists8 = require_path_exists().pathExists;
    var stat5 = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat5.checkPaths(src, dest, "move", (err, stats) => {
        if (err) return cb(err);
        const { srcStat } = stats;
        stat5.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2) return cb(err2);
          mkdirp2(path34.dirname(dest), (err3) => {
            if (err3) return cb(err3);
            return doRename(src, dest, overwrite, cb);
          });
        });
      });
    }
    function doRename(src, dest, overwrite, cb) {
      if (overwrite) {
        return remove(dest, (err) => {
          if (err) return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists8(dest, (err, destExists) => {
        if (err) return cb(err);
        if (destExists) return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    function rename(src, dest, overwrite, cb) {
      fs38.rename(src, dest, (err) => {
        if (!err) return cb();
        if (err.code !== "EXDEV") return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy2(src, dest, opts, (err) => {
        if (err) return cb(err);
        return remove(src, cb);
      });
    }
    module2.exports = move;
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/move/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    module2.exports = {
      move: u3(require_move())
    };
  }
});

// ../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/index.js
var require_lib4 = __commonJS({
  "../@aws-cdk/toolkit-lib/node_modules/fs-extra/lib/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      // Export promiseified graceful-fs:
      ...require_fs(),
      // Export extra methods:
      ...require_copy_sync2(),
      ...require_copy2(),
      ...require_empty(),
      ...require_ensure(),
      ...require_json(),
      ...require_mkdirs(),
      ...require_move_sync2(),
      ...require_move2(),
      ...require_output(),
      ...require_path_exists(),
      ...require_remove()
    };
    var fs38 = require("fs");
    if (Object.getOwnPropertyDescriptor(fs38, "promises")) {
      Object.defineProperty(module2.exports, "promises", {
        get() {
          return fs38.promises;
        }
      });
    }
  }
});

// ../@aws-cdk/toolkit-lib/lib/api/bootstrap/bootstrap-props.ts
var BUCKET_NAME_OUTPUT, REPOSITORY_NAME_OUTPUT, BUCKET_DOMAIN_NAME_OUTPUT, BOOTSTRAP_VERSION_OUTPUT, BOOTSTRAP_VERSION_RESOURCE, BOOTSTRAP_VARIANT_PARAMETER, DEFAULT_BOOTSTRAP_VARIANT;
var init_bootstrap_props = __esm({
  "../@aws-cdk/toolkit-lib/lib/api/bootstrap/bootstrap-props.ts"() {
    "use strict";
    BUCKET_NAME_OUTPUT = "BucketName";
    REPOSITORY_NAME_OUTPUT = "ImageRepositoryName";
    BUCKET_DOMAIN_NAME_OUTPUT = "BucketDomainName";
    BOOTSTRAP_VERSION_OUTPUT = "BootstrapVersion";
    BOOTSTRAP_VERSION_RESOURCE = "CdkBootstrapVersion";
    BOOTSTRAP_VARIANT_PARAMETER = "BootstrapVariant";
    DEFAULT_BOOTSTRAP_VARIANT = "AWS CDK: Default Resources";
  }
});

// ../cdk-assets/lib/progress.ts
var progress_exports = {};
__export(progress_exports, {
  EventType: () => EventType,
  shellEventPublisherFromEventEmitter: () => shellEventPublisherFromEventEmitter,
  shellEventToEventType: () => shellEventToEventType
});
function shellEventToEventType(event) {
  switch (event) {
    case "open":
      return "shell_open" /* SHELL_OPEN */;
    case "close":
      return "shell_close" /* SHELL_CLOSE */;
    case "data_stdout":
      return "shell_stdout" /* SHELL_STDOUT */;
    case "data_stderr":
      return "shell_stderr" /* SHELL_STDERR */;
  }
}
function shellEventPublisherFromEventEmitter(eventEmitter) {
  return (event, message2) => {
    const eventType = shellEventToEventType(event);
    eventEmitter(eventType, message2);
  };
}
var EventType;
var init_progress = __esm({
  "../cdk-assets/lib/progress.ts"() {
    "use strict";
    EventType = /* @__PURE__ */ ((EventType2) => {
      EventType2["START"] = "start";
      EventType2["SUCCESS"] = "success";
      EventType2["FAIL"] = "fail";
      EventType2["CHECK"] = "check";
      EventType2["FOUND"] = "found";
      EventType2["CACHED"] = "cached";
      EventType2["BUILD"] = "build";
      EventType2["UPLOAD"] = "upload";
      EventType2["DEBUG"] = "debug";
      EventType2["SHELL_OPEN"] = "shell_open";
      EventType2["SHELL_STDOUT"] = "shell_stdout";
      EventType2["SHELL_STDERR"] = "shell_stderr";
      EventType2["SHELL_CLOSE"] = "shell_close";
      return EventType2;
    })(EventType || {});
  }
});

// ../cdk-assets/lib/private/docker-credentials.ts
function cdkCredentialsConfigFile() {
  return process.env.CDK_DOCKER_CREDS_FILE ?? path.join(
    (os.userInfo().homedir ?? os.homedir()).trim() || "/",
    ".cdk",
    "cdk-docker-creds.json"
  );
}
function cdkCredentialsConfig() {
  if (!_cdkCredentials) {
    try {
      _cdkCredentials = JSON.parse(
        fs2.readFileSync(cdkCredentialsConfigFile(), { encoding: "utf-8" })
      );
    } catch {
    }
  }
  return _cdkCredentials;
}
async function obtainEcrCredentials(ecr, eventEmitter) {
  if (eventEmitter) {
    eventEmitter("debug" /* DEBUG */, "Fetching ECR authorization token");
  }
  const authData = (await ecr.getAuthorizationToken()).authorizationData || [];
  if (authData.length === 0) {
    throw new Error("No authorization data received from ECR");
  }
  const token = Buffer.from(authData[0].authorizationToken, "base64").toString("ascii");
  const [username, password] = token.split(":");
  if (!username || !password) {
    throw new Error("unexpected ECR authData format");
  }
  return {
    username,
    password,
    endpoint: authData[0].proxyEndpoint
  };
}
var fs2, os, path, _cdkCredentials;
var init_docker_credentials = __esm({
  "../cdk-assets/lib/private/docker-credentials.ts"() {
    "use strict";
    fs2 = __toESM(require("fs"));
    os = __toESM(require("os"));
    path = __toESM(require("path"));
    init_progress();
  }
});

// ../cdk-assets/lib/private/shell.ts
async function shell(command2, options) {
  handleShellOutput(renderCommandLine(command2), options, "open");
  const child = child_process.spawn(command2[0], command2.slice(1), {
    ...options,
    stdio: [options.input ? "pipe" : "ignore", "pipe", "pipe"]
  });
  return new Promise((resolve12, reject) => {
    if (options.input) {
      child.stdin.write(options.input);
      child.stdin.end();
    }
    const stdout2 = new Array();
    const stderr2 = new Array();
    child.stdout.on("data", (chunk) => {
      handleShellOutput(chunk, options, "data_stdout");
      stdout2.push(chunk);
    });
    child.stderr.on("data", (chunk) => {
      handleShellOutput(chunk, options, "data_stderr");
      stderr2.push(chunk);
    });
    child.once("error", reject);
    child.once("close", (code, signal) => {
      handleShellOutput(renderCommandLine(command2), options, "close");
      if (code === 0) {
        resolve12(Buffer.concat(stdout2).toString("utf-8"));
      } else {
        const out = Buffer.concat(stderr2).toString("utf-8").trim();
        reject(
          new ProcessFailed(
            code,
            signal,
            `${renderCommandLine(command2)} exited with ${code != null ? "error code" : "signal"} ${code ?? signal}: ${out}`
          )
        );
      }
    });
  });
}
function handleShellOutput(chunk, options, shellEventType) {
  switch (options.subprocessOutputDestination) {
    case "ignore":
      return;
    case "publish":
      options.shellEventPublisher(shellEventType, chunk.toString("utf-8"));
      break;
    case "stdio":
    default:
      switch (shellEventType) {
        case "data_stdout":
          process.stdout.write(chunk);
          break;
        case "data_stderr":
          process.stderr.write(chunk);
          break;
        case "open":
          options.shellEventPublisher(shellEventType, chunk.toString("utf-8"));
          break;
      }
      break;
  }
}
function renderCommandLine(cmd) {
  if (process.platform !== "win32") {
    return doRender(cmd, hasAnyChars(" ", "\\", "!", '"', "'", "&", "$"), posixEscape);
  } else {
    return doRender(cmd, hasAnyChars(" ", '"', "&", "^", "%"), windowsEscape);
  }
}
function doRender(cmd, needsEscaping, doEscape) {
  return cmd.map((x3) => needsEscaping(x3) ? doEscape(x3) : x3).join(" ");
}
function hasAnyChars(...chars) {
  return (str) => {
    return chars.some((c3) => str.indexOf(c3) !== -1);
  };
}
function posixEscape(x3) {
  x3 = x3.replace(/'/g, `'"'"'`);
  return `'${x3}'`;
}
function windowsEscape(x3) {
  x3 = `"${x3}"`;
  const shellMeta = /* @__PURE__ */ new Set(['"', "&", "^", "%"]);
  return x3.split("").map((c3) => shellMeta.has(x3) ? "^" + c3 : c3).join("");
}
var child_process, ProcessFailed;
var init_shell = __esm({
  "../cdk-assets/lib/private/shell.ts"() {
    "use strict";
    child_process = __toESM(require("child_process"));
    ProcessFailed = class extends Error {
      constructor(exitCode, signal, message2) {
        super(message2);
        this.exitCode = exitCode;
        this.signal = signal;
        this.code = "PROCESS_FAILED";
      }
    };
  }
});

// ../cdk-assets/lib/private/util.ts
function createCriticalSection() {
  let lock = Promise.resolve();
  return async (criticalFunction) => {
    const res = lock.then(() => criticalFunction());
    lock = res.catch((e3) => e3);
    return res;
  };
}
var init_util = __esm({
  "../cdk-assets/lib/private/util.ts"() {
    "use strict";
  }
});

// ../cdk-assets/lib/private/docker.ts
function getDockerCmd() {
  return process.env.CDK_DOCKER ?? "docker";
}
function flatten(x3) {
  return Array.prototype.concat([], ...x3);
}
var fs3, os2, path2, Docker, DockerFactory;
var init_docker = __esm({
  "../cdk-assets/lib/private/docker.ts"() {
    "use strict";
    fs3 = __toESM(require("fs"));
    os2 = __toESM(require("os"));
    path2 = __toESM(require("path"));
    init_docker_credentials();
    init_shell();
    init_util();
    init_progress();
    Docker = class {
      constructor(eventEmitter, subprocessOutputDestination) {
        this.eventEmitter = eventEmitter;
        this.subprocessOutputDestination = subprocessOutputDestination;
        this.configDir = void 0;
      }
      /**
       * Whether an image with the given tag exists
       */
      async exists(tag) {
        try {
          await this.execute(["inspect", tag], {
            subprocessOutputDestination: "ignore"
          });
          return true;
        } catch (e3) {
          const error5 = e3;
          if (error5.code !== "PROCESS_FAILED") {
            throw error5;
          }
          switch (error5.exitCode) {
            case 1 /* Docker */:
            case 125 /* Podman */:
              return false;
            default:
              throw error5;
          }
        }
      }
      async build(options) {
        const buildCommand = [
          "build",
          ...flatten(
            Object.entries(options.buildArgs || {}).map(([k3, v6]) => ["--build-arg", `${k3}=${v6}`])
          ),
          ...flatten(
            Object.entries(options.buildSecrets || {}).map(([k3, v6]) => ["--secret", `id=${k3},${v6}`])
          ),
          ...options.buildSsh ? ["--ssh", options.buildSsh] : [],
          "--tag",
          options.tag,
          ...options.target ? ["--target", options.target] : [],
          ...options.file ? ["--file", options.file] : [],
          ...options.networkMode ? ["--network", options.networkMode] : [],
          ...options.platform ? ["--platform", options.platform] : [],
          ...options.outputs ? options.outputs.map((output) => [`--output=${output}`]) : [],
          ...options.cacheFrom ? [
            ...options.cacheFrom.map((cacheFrom) => ["--cache-from", this.cacheOptionToFlag(cacheFrom)]).flat()
          ] : [],
          ...options.cacheTo ? ["--cache-to", this.cacheOptionToFlag(options.cacheTo)] : [],
          ...options.cacheDisabled ? ["--no-cache"] : [],
          "."
        ];
        await this.execute(buildCommand, {
          cwd: options.directory,
          subprocessOutputDestination: this.subprocessOutputDestination,
          env: {
            BUILDX_NO_DEFAULT_ATTESTATIONS: "1"
            // Docker Build adds provenance attestations by default that confuse cdk-assets
          }
        });
      }
      /**
       * Get credentials from ECR and run docker login
       */
      async login(ecr) {
        const credentials = await obtainEcrCredentials(ecr, this.eventEmitter);
        await this.execute(
          ["login", "--username", credentials.username, "--password-stdin", credentials.endpoint.replace(/^https?:\/\/|\/$/g, "")],
          {
            input: credentials.password,
            // Need to ignore otherwise Docker will complain
            // 'WARNING! Your password will be stored unencrypted'
            // doesn't really matter since it's a token.
            subprocessOutputDestination: "ignore"
          }
        );
      }
      async tag(sourceTag, targetTag) {
        await this.execute(["tag", sourceTag, targetTag]);
      }
      async push(options) {
        await this.execute(["push", options.tag], {
          subprocessOutputDestination: this.subprocessOutputDestination
        });
      }
      /**
       * If a CDK Docker Credentials file exists, creates a new Docker config directory.
       * Sets up `docker-credential-cdk-assets` to be the credential helper for each domain in the CDK config.
       * All future commands (e.g., `build`, `push`) will use this config.
       *
       * See https://docs.docker.com/engine/reference/commandline/login/#credential-helpers for more details on cred helpers.
       *
       * @returns true if CDK config was found and configured, false otherwise
       */
      configureCdkCredentials() {
        const config = cdkCredentialsConfig();
        if (!config) {
          return false;
        }
        this.configDir = fs3.mkdtempSync(path2.join(os2.tmpdir(), "cdkDockerConfig"));
        const domains = Object.keys(config.domainCredentials);
        const credHelpers = domains.reduce((map2, domain) => {
          map2[domain] = "cdk-assets";
          return map2;
        }, {});
        fs3.writeFileSync(path2.join(this.configDir, "config.json"), JSON.stringify({ credHelpers }), {
          encoding: "utf-8"
        });
        return true;
      }
      /**
       * Removes any configured Docker config directory.
       * All future commands (e.g., `build`, `push`) will use the default config.
       *
       * This is useful after calling `configureCdkCredentials` to reset to default credentials.
       */
      resetAuthPlugins() {
        this.configDir = void 0;
      }
      async execute(args, options = {}) {
        var _a4;
        const configArgs = this.configDir ? ["--config", this.configDir] : [];
        const pathToCdkAssets = path2.resolve(__dirname, "..", "..", "bin");
        const shellEventPublisher = shellEventPublisherFromEventEmitter(this.eventEmitter);
        try {
          await shell([getDockerCmd(), ...configArgs, ...args], {
            ...options,
            shellEventPublisher,
            env: {
              ...process.env,
              ...options.env,
              PATH: `${pathToCdkAssets}${path2.delimiter}${((_a4 = options.env) == null ? void 0 : _a4.PATH) ?? process.env.PATH}`
            }
          });
        } catch (e3) {
          if (e3.code === "ENOENT") {
            throw new Error(
              `Failed to find and execute '${getDockerCmd()}' while attempting to build a container asset. Please install '${getDockerCmd()}' and try again. (Or set the 'CDK_DOCKER ' environment variable to choose a different compatible container client.)`
            );
          }
          throw e3;
        }
      }
      cacheOptionToFlag(option) {
        let flag = `type=${option.type}`;
        if (option.params) {
          flag += "," + Object.entries(option.params).map(([k3, v6]) => `${k3}=${v6}`).join(",");
        }
        return flag;
      }
    };
    DockerFactory = class {
      constructor() {
        this.enterLoggedInDestinationsCriticalSection = createCriticalSection();
        this.loggedInDestinations = /* @__PURE__ */ new Set();
      }
      /**
       * Gets a Docker instance for building images.
       */
      async forBuild(options) {
        const docker = new Docker(options.eventEmitter, options.subprocessOutputDestination);
        let cdkDockerCredentialsConfigured = docker.configureCdkCredentials();
        if (!cdkDockerCredentialsConfigured) {
          await this.loginOncePerDestination(docker, options);
        }
        return docker;
      }
      /**
       * Gets a Docker instance for pushing images to ECR.
       */
      async forEcrPush(options) {
        const docker = new Docker(options.eventEmitter, options.subprocessOutputDestination);
        await this.loginOncePerDestination(docker, options);
        return docker;
      }
      async loginOncePerDestination(docker, options) {
        const repositoryDomain = options.repoUri.split("/")[0];
        await this.enterLoggedInDestinationsCriticalSection(async () => {
          if (this.loggedInDestinations.has(repositoryDomain)) {
            return;
          }
          await docker.login(options.ecr);
          this.loggedInDestinations.add(repositoryDomain);
        });
      }
    };
  }
});

// ../cdk-assets/lib/private/handlers/client-options.ts
function destinationToClientOptions(destination) {
  return {
    assumeRoleArn: destination.assumeRoleArn,
    assumeRoleExternalId: destination.assumeRoleExternalId,
    assumeRoleAdditionalOptions: destination.assumeRoleAdditionalOptions,
    region: destination.region
  };
}
var init_client_options = __esm({
  "../cdk-assets/lib/private/handlers/client-options.ts"() {
    "use strict";
  }
});

// ../cdk-assets/lib/private/placeholders.ts
async function replaceAwsPlaceholders(object, aws) {
  let partition3 = async () => {
    const p3 = await aws.discoverPartition();
    partition3 = () => Promise.resolve(p3);
    return p3;
  };
  let account = async () => {
    const a3 = await aws.discoverCurrentAccount();
    account = () => Promise.resolve(a3);
    return a3;
  };
  return import_cx_api.EnvironmentPlaceholders.replaceAsync(object, {
    async region() {
      return object.region ?? aws.discoverDefaultRegion();
    },
    async accountId() {
      return (await account()).accountId;
    },
    async partition() {
      return partition3();
    }
  });
}
var import_cx_api;
var init_placeholders = __esm({
  "../cdk-assets/lib/private/placeholders.ts"() {
    "use strict";
    import_cx_api = __toESM(require_lib3());
  }
});

// ../cdk-assets/lib/private/handlers/container-images.ts
async function imageExists(ecr, repositoryName, imageTag) {
  try {
    await ecr.describeImages({
      repositoryName,
      imageIds: [{ imageTag }]
    });
    return true;
  } catch (e3) {
    if (e3.name !== "ImageNotFoundException") {
      throw e3;
    }
    return false;
  }
}
async function repositoryUri(ecr, repositoryName) {
  var _a4;
  try {
    const response = await ecr.describeRepositories({
      repositoryNames: [repositoryName]
    });
    return (_a4 = (response.repositories || [])[0]) == null ? void 0 : _a4.repositoryUri;
  } catch (e3) {
    if (e3.name !== "RepositoryNotFoundException") {
      throw e3;
    }
    return void 0;
  }
}
var path3, ContainerImageAssetHandler, ContainerImageBuilder;
var init_container_images = __esm({
  "../cdk-assets/lib/private/handlers/container-images.ts"() {
    "use strict";
    path3 = __toESM(require("path"));
    init_client_options();
    init_progress();
    init_placeholders();
    init_shell();
    ContainerImageAssetHandler = class {
      constructor(workDir, asset, host, options) {
        this.workDir = workDir;
        this.asset = asset;
        this.host = host;
        this.options = options;
      }
      async build() {
        const initOnce = await this.initOnce();
        if (initOnce.destinationAlreadyExists) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        const dockerForBuilding = await this.host.dockerFactory.forBuild({
          repoUri: initOnce.repoUri,
          eventEmitter: (m3) => this.host.emitMessage("debug" /* DEBUG */, m3),
          ecr: initOnce.ecr,
          subprocessOutputDestination: this.options.subprocessOutputDestination
        });
        const builder = new ContainerImageBuilder(
          dockerForBuilding,
          this.workDir,
          this.asset,
          this.host
        );
        const localTagName = await builder.build();
        if (localTagName === void 0 || this.host.aborted) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        await dockerForBuilding.tag(localTagName, initOnce.imageUri);
      }
      async isPublished() {
        try {
          const initOnce = await this.initOnce({ quiet: true });
          return initOnce.destinationAlreadyExists;
        } catch (e3) {
          this.host.emitMessage("debug" /* DEBUG */, `${e3.message}`);
        }
        return false;
      }
      async publish() {
        const initOnce = await this.initOnce();
        if (initOnce.destinationAlreadyExists) {
          return;
        }
        if (this.host.aborted) {
          return;
        }
        const dockerForPushing = await this.host.dockerFactory.forEcrPush({
          repoUri: initOnce.repoUri,
          eventEmitter: this.host.emitMessage,
          ecr: initOnce.ecr,
          subprocessOutputDestination: this.options.subprocessOutputDestination
        });
        if (this.host.aborted) {
          return;
        }
        this.host.emitMessage("upload" /* UPLOAD */, `Push ${initOnce.imageUri}`);
        await dockerForPushing.push({
          tag: initOnce.imageUri
        });
      }
      async initOnce(options = {}) {
        if (this.init) {
          return this.init;
        }
        const destination = await replaceAwsPlaceholders(this.asset.destination, this.host.aws);
        const ecr = await this.host.aws.ecrClient({
          ...destinationToClientOptions(destination),
          quiet: options.quiet
        });
        const account = async () => {
          var _a4;
          return (_a4 = await this.host.aws.discoverCurrentAccount()) == null ? void 0 : _a4.accountId;
        };
        const repoUri = await repositoryUri(ecr, destination.repositoryName);
        if (!repoUri) {
          throw new Error(
            `No ECR repository named '${destination.repositoryName}' in account ${await account()}. Is this account bootstrapped?`
          );
        }
        const imageUri = `${repoUri}:${destination.imageTag}`;
        this.init = {
          imageUri,
          ecr,
          repoUri,
          destinationAlreadyExists: await this.destinationAlreadyExists(ecr, destination, imageUri)
        };
        return this.init;
      }
      /**
       * Check whether the image already exists in the ECR repo
       *
       * Use the fields from the destination to do the actual check. The imageUri
       * should correspond to that, but is only used to print Docker image location
       * for user benefit (the format is slightly different).
       */
      async destinationAlreadyExists(ecr, destination, imageUri) {
        this.host.emitMessage("check" /* CHECK */, `Check ${imageUri}`);
        if (await imageExists(ecr, destination.repositoryName, destination.imageTag)) {
          this.host.emitMessage("found" /* FOUND */, `Found ${imageUri}`);
          return true;
        }
        return false;
      }
    };
    ContainerImageBuilder = class {
      constructor(docker, workDir, asset, host) {
        this.docker = docker;
        this.workDir = workDir;
        this.asset = asset;
        this.host = host;
      }
      async build() {
        return this.asset.source.executable ? this.buildExternalAsset(this.asset.source.executable) : this.buildDirectoryAsset();
      }
      /**
       * Build a (local) Docker asset from a directory with a Dockerfile
       *
       * Tags under a deterministic, unique, local identifier wich will skip
       * the build if it already exists.
       */
      async buildDirectoryAsset() {
        const localTagName = `cdkasset-${this.asset.id.assetId.toLowerCase()}`;
        if (!await this.isImageCached(localTagName)) {
          if (this.host.aborted) {
            return void 0;
          }
          await this.buildImage(localTagName);
        }
        return localTagName;
      }
      /**
       * Build a (local) Docker asset by running an external command
       *
       * External command is responsible for deduplicating the build if possible,
       * and is expected to return the generated image identifier on stdout.
       */
      async buildExternalAsset(executable, cwd) {
        const assetPath = cwd ?? this.workDir;
        this.host.emitMessage("build" /* BUILD */, `Building Docker image using command '${executable}'`);
        if (this.host.aborted) {
          return void 0;
        }
        const shellEventPublisher = shellEventPublisherFromEventEmitter(this.host.emitMessage);
        return (await shell(executable, {
          cwd: assetPath,
          shellEventPublisher,
          subprocessOutputDestination: "ignore"
        })).trim();
      }
      async buildImage(localTagName) {
        const source = this.asset.source;
        if (!source.directory) {
          throw new Error(
            `'directory' is expected in the DockerImage asset source, got: ${JSON.stringify(source)}`
          );
        }
        const fullPath = path3.resolve(this.workDir, source.directory);
        this.host.emitMessage("build" /* BUILD */, `Building Docker image at ${fullPath}`);
        await this.docker.build({
          directory: fullPath,
          tag: localTagName,
          buildArgs: source.dockerBuildArgs,
          buildSecrets: source.dockerBuildSecrets,
          buildSsh: source.dockerBuildSsh,
          target: source.dockerBuildTarget,
          file: source.dockerFile,
          networkMode: source.networkMode,
          platform: source.platform,
          outputs: source.dockerOutputs,
          cacheFrom: source.cacheFrom,
          cacheTo: source.cacheTo,
          cacheDisabled: source.cacheDisabled
        });
      }
      async isImageCached(localTagName) {
        if (await this.docker.exists(localTagName)) {
          this.host.emitMessage("cached" /* CACHED */, `Cached ${localTagName}`);
          return true;
        }
        return false;
      }
    };
  }
});

// ../../node_modules/mime/Mime.js
var require_Mime = __commonJS({
  "../../node_modules/mime/Mime.js"(exports2, module2) {
    "use strict";
    function Mime() {
      this._types = /* @__PURE__ */ Object.create(null);
      this._extensions = /* @__PURE__ */ Object.create(null);
      for (let i3 = 0; i3 < arguments.length; i3++) {
        this.define(arguments[i3]);
      }
      this.define = this.define.bind(this);
      this.getType = this.getType.bind(this);
      this.getExtension = this.getExtension.bind(this);
    }
    Mime.prototype.define = function(typeMap, force) {
      for (let type in typeMap) {
        let extensions = typeMap[type].map(function(t3) {
          return t3.toLowerCase();
        });
        type = type.toLowerCase();
        for (let i3 = 0; i3 < extensions.length; i3++) {
          const ext4 = extensions[i3];
          if (ext4[0] === "*") {
            continue;
          }
          if (!force && ext4 in this._types) {
            throw new Error(
              'Attempt to change mapping for "' + ext4 + '" extension from "' + this._types[ext4] + '" to "' + type + '". Pass `force=true` to allow this, otherwise remove "' + ext4 + '" from the list of extensions for "' + type + '".'
            );
          }
          this._types[ext4] = type;
        }
        if (force || !this._extensions[type]) {
          const ext4 = extensions[0];
          this._extensions[type] = ext4[0] !== "*" ? ext4 : ext4.substr(1);
        }
      }
    };
    Mime.prototype.getType = function(path34) {
      path34 = String(path34);
      let last = path34.replace(/^.*[/\\]/, "").toLowerCase();
      let ext4 = last.replace(/^.*\./, "").toLowerCase();
      let hasPath = last.length < path34.length;
      let hasDot = ext4.length < last.length - 1;
      return (hasDot || !hasPath) && this._types[ext4] || null;
    };
    Mime.prototype.getExtension = function(type) {
      type = /^\s*([^;\s]*)/.test(type) && RegExp.$1;
      return type && this._extensions[type.toLowerCase()] || null;
    };
    module2.exports = Mime;
  }
});

// ../../node_modules/mime/types/standard.js
var require_standard = __commonJS({
  "../../node_modules/mime/types/standard.js"(exports2, module2) {
    module2.exports = { "application/andrew-inset": ["ez"], "application/applixware": ["aw"], "application/atom+xml": ["atom"], "application/atomcat+xml": ["atomcat"], "application/atomdeleted+xml": ["atomdeleted"], "application/atomsvc+xml": ["atomsvc"], "application/atsc-dwd+xml": ["dwd"], "application/atsc-held+xml": ["held"], "application/atsc-rsat+xml": ["rsat"], "application/bdoc": ["bdoc"], "application/calendar+xml": ["xcs"], "application/ccxml+xml": ["ccxml"], "application/cdfx+xml": ["cdfx"], "application/cdmi-capability": ["cdmia"], "application/cdmi-container": ["cdmic"], "application/cdmi-domain": ["cdmid"], "application/cdmi-object": ["cdmio"], "application/cdmi-queue": ["cdmiq"], "application/cu-seeme": ["cu"], "application/dash+xml": ["mpd"], "application/davmount+xml": ["davmount"], "application/docbook+xml": ["dbk"], "application/dssc+der": ["dssc"], "application/dssc+xml": ["xdssc"], "application/ecmascript": ["es", "ecma"], "application/emma+xml": ["emma"], "application/emotionml+xml": ["emotionml"], "application/epub+zip": ["epub"], "application/exi": ["exi"], "application/express": ["exp"], "application/fdt+xml": ["fdt"], "application/font-tdpfr": ["pfr"], "application/geo+json": ["geojson"], "application/gml+xml": ["gml"], "application/gpx+xml": ["gpx"], "application/gxf": ["gxf"], "application/gzip": ["gz"], "application/hjson": ["hjson"], "application/hyperstudio": ["stk"], "application/inkml+xml": ["ink", "inkml"], "application/ipfix": ["ipfix"], "application/its+xml": ["its"], "application/java-archive": ["jar", "war", "ear"], "application/java-serialized-object": ["ser"], "application/java-vm": ["class"], "application/javascript": ["js", "mjs"], "application/json": ["json", "map"], "application/json5": ["json5"], "application/jsonml+json": ["jsonml"], "application/ld+json": ["jsonld"], "application/lgr+xml": ["lgr"], "application/lost+xml": ["lostxml"], "application/mac-binhex40": ["hqx"], "application/mac-compactpro": ["cpt"], "application/mads+xml": ["mads"], "application/manifest+json": ["webmanifest"], "application/marc": ["mrc"], "application/marcxml+xml": ["mrcx"], "application/mathematica": ["ma", "nb", "mb"], "application/mathml+xml": ["mathml"], "application/mbox": ["mbox"], "application/mediaservercontrol+xml": ["mscml"], "application/metalink+xml": ["metalink"], "application/metalink4+xml": ["meta4"], "application/mets+xml": ["mets"], "application/mmt-aei+xml": ["maei"], "application/mmt-usd+xml": ["musd"], "application/mods+xml": ["mods"], "application/mp21": ["m21", "mp21"], "application/mp4": ["mp4s", "m4p"], "application/msword": ["doc", "dot"], "application/mxf": ["mxf"], "application/n-quads": ["nq"], "application/n-triples": ["nt"], "application/node": ["cjs"], "application/octet-stream": ["bin", "dms", "lrf", "mar", "so", "dist", "distz", "pkg", "bpk", "dump", "elc", "deploy", "exe", "dll", "deb", "dmg", "iso", "img", "msi", "msp", "msm", "buffer"], "application/oda": ["oda"], "application/oebps-package+xml": ["opf"], "application/ogg": ["ogx"], "application/omdoc+xml": ["omdoc"], "application/onenote": ["onetoc", "onetoc2", "onetmp", "onepkg"], "application/oxps": ["oxps"], "application/p2p-overlay+xml": ["relo"], "application/patch-ops-error+xml": ["xer"], "application/pdf": ["pdf"], "application/pgp-encrypted": ["pgp"], "application/pgp-signature": ["asc", "sig"], "application/pics-rules": ["prf"], "application/pkcs10": ["p10"], "application/pkcs7-mime": ["p7m", "p7c"], "application/pkcs7-signature": ["p7s"], "application/pkcs8": ["p8"], "application/pkix-attr-cert": ["ac"], "application/pkix-cert": ["cer"], "application/pkix-crl": ["crl"], "application/pkix-pkipath": ["pkipath"], "application/pkixcmp": ["pki"], "application/pls+xml": ["pls"], "application/postscript": ["ai", "eps", "ps"], "application/provenance+xml": ["provx"], "application/pskc+xml": ["pskcxml"], "application/raml+yaml": ["raml"], "application/rdf+xml": ["rdf", "owl"], "application/reginfo+xml": ["rif"], "application/relax-ng-compact-syntax": ["rnc"], "application/resource-lists+xml": ["rl"], "application/resource-lists-diff+xml": ["rld"], "application/rls-services+xml": ["rs"], "application/route-apd+xml": ["rapd"], "application/route-s-tsid+xml": ["sls"], "application/route-usd+xml": ["rusd"], "application/rpki-ghostbusters": ["gbr"], "application/rpki-manifest": ["mft"], "application/rpki-roa": ["roa"], "application/rsd+xml": ["rsd"], "application/rss+xml": ["rss"], "application/rtf": ["rtf"], "application/sbml+xml": ["sbml"], "application/scvp-cv-request": ["scq"], "application/scvp-cv-response": ["scs"], "application/scvp-vp-request": ["spq"], "application/scvp-vp-response": ["spp"], "application/sdp": ["sdp"], "application/senml+xml": ["senmlx"], "application/sensml+xml": ["sensmlx"], "application/set-payment-initiation": ["setpay"], "application/set-registration-initiation": ["setreg"], "application/shf+xml": ["shf"], "application/sieve": ["siv", "sieve"], "application/smil+xml": ["smi", "smil"], "application/sparql-query": ["rq"], "application/sparql-results+xml": ["srx"], "application/srgs": ["gram"], "application/srgs+xml": ["grxml"], "application/sru+xml": ["sru"], "application/ssdl+xml": ["ssdl"], "application/ssml+xml": ["ssml"], "application/swid+xml": ["swidtag"], "application/tei+xml": ["tei", "teicorpus"], "application/thraud+xml": ["tfi"], "application/timestamped-data": ["tsd"], "application/toml": ["toml"], "application/trig": ["trig"], "application/ttml+xml": ["ttml"], "application/ubjson": ["ubj"], "application/urc-ressheet+xml": ["rsheet"], "application/urc-targetdesc+xml": ["td"], "application/voicexml+xml": ["vxml"], "application/wasm": ["wasm"], "application/widget": ["wgt"], "application/winhlp": ["hlp"], "application/wsdl+xml": ["wsdl"], "application/wspolicy+xml": ["wspolicy"], "application/xaml+xml": ["xaml"], "application/xcap-att+xml": ["xav"], "application/xcap-caps+xml": ["xca"], "application/xcap-diff+xml": ["xdf"], "application/xcap-el+xml": ["xel"], "application/xcap-ns+xml": ["xns"], "application/xenc+xml": ["xenc"], "application/xhtml+xml": ["xhtml", "xht"], "application/xliff+xml": ["xlf"], "application/xml": ["xml", "xsl", "xsd", "rng"], "application/xml-dtd": ["dtd"], "application/xop+xml": ["xop"], "application/xproc+xml": ["xpl"], "application/xslt+xml": ["*xsl", "xslt"], "application/xspf+xml": ["xspf"], "application/xv+xml": ["mxml", "xhvml", "xvml", "xvm"], "application/yang": ["yang"], "application/yin+xml": ["yin"], "application/zip": ["zip"], "audio/3gpp": ["*3gpp"], "audio/adpcm": ["adp"], "audio/amr": ["amr"], "audio/basic": ["au", "snd"], "audio/midi": ["mid", "midi", "kar", "rmi"], "audio/mobile-xmf": ["mxmf"], "audio/mp3": ["*mp3"], "audio/mp4": ["m4a", "mp4a"], "audio/mpeg": ["mpga", "mp2", "mp2a", "mp3", "m2a", "m3a"], "audio/ogg": ["oga", "ogg", "spx", "opus"], "audio/s3m": ["s3m"], "audio/silk": ["sil"], "audio/wav": ["wav"], "audio/wave": ["*wav"], "audio/webm": ["weba"], "audio/xm": ["xm"], "font/collection": ["ttc"], "font/otf": ["otf"], "font/ttf": ["ttf"], "font/woff": ["woff"], "font/woff2": ["woff2"], "image/aces": ["exr"], "image/apng": ["apng"], "image/avif": ["avif"], "image/bmp": ["bmp"], "image/cgm": ["cgm"], "image/dicom-rle": ["drle"], "image/emf": ["emf"], "image/fits": ["fits"], "image/g3fax": ["g3"], "image/gif": ["gif"], "image/heic": ["heic"], "image/heic-sequence": ["heics"], "image/heif": ["heif"], "image/heif-sequence": ["heifs"], "image/hej2k": ["hej2"], "image/hsj2": ["hsj2"], "image/ief": ["ief"], "image/jls": ["jls"], "image/jp2": ["jp2", "jpg2"], "image/jpeg": ["jpeg", "jpg", "jpe"], "image/jph": ["jph"], "image/jphc": ["jhc"], "image/jpm": ["jpm"], "image/jpx": ["jpx", "jpf"], "image/jxr": ["jxr"], "image/jxra": ["jxra"], "image/jxrs": ["jxrs"], "image/jxs": ["jxs"], "image/jxsc": ["jxsc"], "image/jxsi": ["jxsi"], "image/jxss": ["jxss"], "image/ktx": ["ktx"], "image/ktx2": ["ktx2"], "image/png": ["png"], "image/sgi": ["sgi"], "image/svg+xml": ["svg", "svgz"], "image/t38": ["t38"], "image/tiff": ["tif", "tiff"], "image/tiff-fx": ["tfx"], "image/webp": ["webp"], "image/wmf": ["wmf"], "message/disposition-notification": ["disposition-notification"], "message/global": ["u8msg"], "message/global-delivery-status": ["u8dsn"], "message/global-disposition-notification": ["u8mdn"], "message/global-headers": ["u8hdr"], "message/rfc822": ["eml", "mime"], "model/3mf": ["3mf"], "model/gltf+json": ["gltf"], "model/gltf-binary": ["glb"], "model/iges": ["igs", "iges"], "model/mesh": ["msh", "mesh", "silo"], "model/mtl": ["mtl"], "model/obj": ["obj"], "model/step+xml": ["stpx"], "model/step+zip": ["stpz"], "model/step-xml+zip": ["stpxz"], "model/stl": ["stl"], "model/vrml": ["wrl", "vrml"], "model/x3d+binary": ["*x3db", "x3dbz"], "model/x3d+fastinfoset": ["x3db"], "model/x3d+vrml": ["*x3dv", "x3dvz"], "model/x3d+xml": ["x3d", "x3dz"], "model/x3d-vrml": ["x3dv"], "text/cache-manifest": ["appcache", "manifest"], "text/calendar": ["ics", "ifb"], "text/coffeescript": ["coffee", "litcoffee"], "text/css": ["css"], "text/csv": ["csv"], "text/html": ["html", "htm", "shtml"], "text/jade": ["jade"], "text/jsx": ["jsx"], "text/less": ["less"], "text/markdown": ["markdown", "md"], "text/mathml": ["mml"], "text/mdx": ["mdx"], "text/n3": ["n3"], "text/plain": ["txt", "text", "conf", "def", "list", "log", "in", "ini"], "text/richtext": ["rtx"], "text/rtf": ["*rtf"], "text/sgml": ["sgml", "sgm"], "text/shex": ["shex"], "text/slim": ["slim", "slm"], "text/spdx": ["spdx"], "text/stylus": ["stylus", "styl"], "text/tab-separated-values": ["tsv"], "text/troff": ["t", "tr", "roff", "man", "me", "ms"], "text/turtle": ["ttl"], "text/uri-list": ["uri", "uris", "urls"], "text/vcard": ["vcard"], "text/vtt": ["vtt"], "text/xml": ["*xml"], "text/yaml": ["yaml", "yml"], "video/3gpp": ["3gp", "3gpp"], "video/3gpp2": ["3g2"], "video/h261": ["h261"], "video/h263": ["h263"], "video/h264": ["h264"], "video/iso.segment": ["m4s"], "video/jpeg": ["jpgv"], "video/jpm": ["*jpm", "jpgm"], "video/mj2": ["mj2", "mjp2"], "video/mp2t": ["ts"], "video/mp4": ["mp4", "mp4v", "mpg4"], "video/mpeg": ["mpeg", "mpg", "mpe", "m1v", "m2v"], "video/ogg": ["ogv"], "video/quicktime": ["qt", "mov"], "video/webm": ["webm"] };
  }
});

// ../../node_modules/mime/types/other.js
var require_other = __commonJS({
  "../../node_modules/mime/types/other.js"(exports2, module2) {
    module2.exports = { "application/prs.cww": ["cww"], "application/vnd.1000minds.decision-model+xml": ["1km"], "application/vnd.3gpp.pic-bw-large": ["plb"], "application/vnd.3gpp.pic-bw-small": ["psb"], "application/vnd.3gpp.pic-bw-var": ["pvb"], "application/vnd.3gpp2.tcap": ["tcap"], "application/vnd.3m.post-it-notes": ["pwn"], "application/vnd.accpac.simply.aso": ["aso"], "application/vnd.accpac.simply.imp": ["imp"], "application/vnd.acucobol": ["acu"], "application/vnd.acucorp": ["atc", "acutc"], "application/vnd.adobe.air-application-installer-package+zip": ["air"], "application/vnd.adobe.formscentral.fcdt": ["fcdt"], "application/vnd.adobe.fxp": ["fxp", "fxpl"], "application/vnd.adobe.xdp+xml": ["xdp"], "application/vnd.adobe.xfdf": ["xfdf"], "application/vnd.ahead.space": ["ahead"], "application/vnd.airzip.filesecure.azf": ["azf"], "application/vnd.airzip.filesecure.azs": ["azs"], "application/vnd.amazon.ebook": ["azw"], "application/vnd.americandynamics.acc": ["acc"], "application/vnd.amiga.ami": ["ami"], "application/vnd.android.package-archive": ["apk"], "application/vnd.anser-web-certificate-issue-initiation": ["cii"], "application/vnd.anser-web-funds-transfer-initiation": ["fti"], "application/vnd.antix.game-component": ["atx"], "application/vnd.apple.installer+xml": ["mpkg"], "application/vnd.apple.keynote": ["key"], "application/vnd.apple.mpegurl": ["m3u8"], "application/vnd.apple.numbers": ["numbers"], "application/vnd.apple.pages": ["pages"], "application/vnd.apple.pkpass": ["pkpass"], "application/vnd.aristanetworks.swi": ["swi"], "application/vnd.astraea-software.iota": ["iota"], "application/vnd.audiograph": ["aep"], "application/vnd.balsamiq.bmml+xml": ["bmml"], "application/vnd.blueice.multipass": ["mpm"], "application/vnd.bmi": ["bmi"], "application/vnd.businessobjects": ["rep"], "application/vnd.chemdraw+xml": ["cdxml"], "application/vnd.chipnuts.karaoke-mmd": ["mmd"], "application/vnd.cinderella": ["cdy"], "application/vnd.citationstyles.style+xml": ["csl"], "application/vnd.claymore": ["cla"], "application/vnd.cloanto.rp9": ["rp9"], "application/vnd.clonk.c4group": ["c4g", "c4d", "c4f", "c4p", "c4u"], "application/vnd.cluetrust.cartomobile-config": ["c11amc"], "application/vnd.cluetrust.cartomobile-config-pkg": ["c11amz"], "application/vnd.commonspace": ["csp"], "application/vnd.contact.cmsg": ["cdbcmsg"], "application/vnd.cosmocaller": ["cmc"], "application/vnd.crick.clicker": ["clkx"], "application/vnd.crick.clicker.keyboard": ["clkk"], "application/vnd.crick.clicker.palette": ["clkp"], "application/vnd.crick.clicker.template": ["clkt"], "application/vnd.crick.clicker.wordbank": ["clkw"], "application/vnd.criticaltools.wbs+xml": ["wbs"], "application/vnd.ctc-posml": ["pml"], "application/vnd.cups-ppd": ["ppd"], "application/vnd.curl.car": ["car"], "application/vnd.curl.pcurl": ["pcurl"], "application/vnd.dart": ["dart"], "application/vnd.data-vision.rdz": ["rdz"], "application/vnd.dbf": ["dbf"], "application/vnd.dece.data": ["uvf", "uvvf", "uvd", "uvvd"], "application/vnd.dece.ttml+xml": ["uvt", "uvvt"], "application/vnd.dece.unspecified": ["uvx", "uvvx"], "application/vnd.dece.zip": ["uvz", "uvvz"], "application/vnd.denovo.fcselayout-link": ["fe_launch"], "application/vnd.dna": ["dna"], "application/vnd.dolby.mlp": ["mlp"], "application/vnd.dpgraph": ["dpg"], "application/vnd.dreamfactory": ["dfac"], "application/vnd.ds-keypoint": ["kpxx"], "application/vnd.dvb.ait": ["ait"], "application/vnd.dvb.service": ["svc"], "application/vnd.dynageo": ["geo"], "application/vnd.ecowin.chart": ["mag"], "application/vnd.enliven": ["nml"], "application/vnd.epson.esf": ["esf"], "application/vnd.epson.msf": ["msf"], "application/vnd.epson.quickanime": ["qam"], "application/vnd.epson.salt": ["slt"], "application/vnd.epson.ssf": ["ssf"], "application/vnd.eszigno3+xml": ["es3", "et3"], "application/vnd.ezpix-album": ["ez2"], "application/vnd.ezpix-package": ["ez3"], "application/vnd.fdf": ["fdf"], "application/vnd.fdsn.mseed": ["mseed"], "application/vnd.fdsn.seed": ["seed", "dataless"], "application/vnd.flographit": ["gph"], "application/vnd.fluxtime.clip": ["ftc"], "application/vnd.framemaker": ["fm", "frame", "maker", "book"], "application/vnd.frogans.fnc": ["fnc"], "application/vnd.frogans.ltf": ["ltf"], "application/vnd.fsc.weblaunch": ["fsc"], "application/vnd.fujitsu.oasys": ["oas"], "application/vnd.fujitsu.oasys2": ["oa2"], "application/vnd.fujitsu.oasys3": ["oa3"], "application/vnd.fujitsu.oasysgp": ["fg5"], "application/vnd.fujitsu.oasysprs": ["bh2"], "application/vnd.fujixerox.ddd": ["ddd"], "application/vnd.fujixerox.docuworks": ["xdw"], "application/vnd.fujixerox.docuworks.binder": ["xbd"], "application/vnd.fuzzysheet": ["fzs"], "application/vnd.genomatix.tuxedo": ["txd"], "application/vnd.geogebra.file": ["ggb"], "application/vnd.geogebra.tool": ["ggt"], "application/vnd.geometry-explorer": ["gex", "gre"], "application/vnd.geonext": ["gxt"], "application/vnd.geoplan": ["g2w"], "application/vnd.geospace": ["g3w"], "application/vnd.gmx": ["gmx"], "application/vnd.google-apps.document": ["gdoc"], "application/vnd.google-apps.presentation": ["gslides"], "application/vnd.google-apps.spreadsheet": ["gsheet"], "application/vnd.google-earth.kml+xml": ["kml"], "application/vnd.google-earth.kmz": ["kmz"], "application/vnd.grafeq": ["gqf", "gqs"], "application/vnd.groove-account": ["gac"], "application/vnd.groove-help": ["ghf"], "application/vnd.groove-identity-message": ["gim"], "application/vnd.groove-injector": ["grv"], "application/vnd.groove-tool-message": ["gtm"], "application/vnd.groove-tool-template": ["tpl"], "application/vnd.groove-vcard": ["vcg"], "application/vnd.hal+xml": ["hal"], "application/vnd.handheld-entertainment+xml": ["zmm"], "application/vnd.hbci": ["hbci"], "application/vnd.hhe.lesson-player": ["les"], "application/vnd.hp-hpgl": ["hpgl"], "application/vnd.hp-hpid": ["hpid"], "application/vnd.hp-hps": ["hps"], "application/vnd.hp-jlyt": ["jlt"], "application/vnd.hp-pcl": ["pcl"], "application/vnd.hp-pclxl": ["pclxl"], "application/vnd.hydrostatix.sof-data": ["sfd-hdstx"], "application/vnd.ibm.minipay": ["mpy"], "application/vnd.ibm.modcap": ["afp", "listafp", "list3820"], "application/vnd.ibm.rights-management": ["irm"], "application/vnd.ibm.secure-container": ["sc"], "application/vnd.iccprofile": ["icc", "icm"], "application/vnd.igloader": ["igl"], "application/vnd.immervision-ivp": ["ivp"], "application/vnd.immervision-ivu": ["ivu"], "application/vnd.insors.igm": ["igm"], "application/vnd.intercon.formnet": ["xpw", "xpx"], "application/vnd.intergeo": ["i2g"], "application/vnd.intu.qbo": ["qbo"], "application/vnd.intu.qfx": ["qfx"], "application/vnd.ipunplugged.rcprofile": ["rcprofile"], "application/vnd.irepository.package+xml": ["irp"], "application/vnd.is-xpr": ["xpr"], "application/vnd.isac.fcs": ["fcs"], "application/vnd.jam": ["jam"], "application/vnd.jcp.javame.midlet-rms": ["rms"], "application/vnd.jisp": ["jisp"], "application/vnd.joost.joda-archive": ["joda"], "application/vnd.kahootz": ["ktz", "ktr"], "application/vnd.kde.karbon": ["karbon"], "application/vnd.kde.kchart": ["chrt"], "application/vnd.kde.kformula": ["kfo"], "application/vnd.kde.kivio": ["flw"], "application/vnd.kde.kontour": ["kon"], "application/vnd.kde.kpresenter": ["kpr", "kpt"], "application/vnd.kde.kspread": ["ksp"], "application/vnd.kde.kword": ["kwd", "kwt"], "application/vnd.kenameaapp": ["htke"], "application/vnd.kidspiration": ["kia"], "application/vnd.kinar": ["kne", "knp"], "application/vnd.koan": ["skp", "skd", "skt", "skm"], "application/vnd.kodak-descriptor": ["sse"], "application/vnd.las.las+xml": ["lasxml"], "application/vnd.llamagraphics.life-balance.desktop": ["lbd"], "application/vnd.llamagraphics.life-balance.exchange+xml": ["lbe"], "application/vnd.lotus-1-2-3": ["123"], "application/vnd.lotus-approach": ["apr"], "application/vnd.lotus-freelance": ["pre"], "application/vnd.lotus-notes": ["nsf"], "application/vnd.lotus-organizer": ["org"], "application/vnd.lotus-screencam": ["scm"], "application/vnd.lotus-wordpro": ["lwp"], "application/vnd.macports.portpkg": ["portpkg"], "application/vnd.mapbox-vector-tile": ["mvt"], "application/vnd.mcd": ["mcd"], "application/vnd.medcalcdata": ["mc1"], "application/vnd.mediastation.cdkey": ["cdkey"], "application/vnd.mfer": ["mwf"], "application/vnd.mfmp": ["mfm"], "application/vnd.micrografx.flo": ["flo"], "application/vnd.micrografx.igx": ["igx"], "application/vnd.mif": ["mif"], "application/vnd.mobius.daf": ["daf"], "application/vnd.mobius.dis": ["dis"], "application/vnd.mobius.mbk": ["mbk"], "application/vnd.mobius.mqy": ["mqy"], "application/vnd.mobius.msl": ["msl"], "application/vnd.mobius.plc": ["plc"], "application/vnd.mobius.txf": ["txf"], "application/vnd.mophun.application": ["mpn"], "application/vnd.mophun.certificate": ["mpc"], "application/vnd.mozilla.xul+xml": ["xul"], "application/vnd.ms-artgalry": ["cil"], "application/vnd.ms-cab-compressed": ["cab"], "application/vnd.ms-excel": ["xls", "xlm", "xla", "xlc", "xlt", "xlw"], "application/vnd.ms-excel.addin.macroenabled.12": ["xlam"], "application/vnd.ms-excel.sheet.binary.macroenabled.12": ["xlsb"], "application/vnd.ms-excel.sheet.macroenabled.12": ["xlsm"], "application/vnd.ms-excel.template.macroenabled.12": ["xltm"], "application/vnd.ms-fontobject": ["eot"], "application/vnd.ms-htmlhelp": ["chm"], "application/vnd.ms-ims": ["ims"], "application/vnd.ms-lrm": ["lrm"], "application/vnd.ms-officetheme": ["thmx"], "application/vnd.ms-outlook": ["msg"], "application/vnd.ms-pki.seccat": ["cat"], "application/vnd.ms-pki.stl": ["*stl"], "application/vnd.ms-powerpoint": ["ppt", "pps", "pot"], "application/vnd.ms-powerpoint.addin.macroenabled.12": ["ppam"], "application/vnd.ms-powerpoint.presentation.macroenabled.12": ["pptm"], "application/vnd.ms-powerpoint.slide.macroenabled.12": ["sldm"], "application/vnd.ms-powerpoint.slideshow.macroenabled.12": ["ppsm"], "application/vnd.ms-powerpoint.template.macroenabled.12": ["potm"], "application/vnd.ms-project": ["mpp", "mpt"], "application/vnd.ms-word.document.macroenabled.12": ["docm"], "application/vnd.ms-word.template.macroenabled.12": ["dotm"], "application/vnd.ms-works": ["wps", "wks", "wcm", "wdb"], "application/vnd.ms-wpl": ["wpl"], "application/vnd.ms-xpsdocument": ["xps"], "application/vnd.mseq": ["mseq"], "application/vnd.musician": ["mus"], "application/vnd.muvee.style": ["msty"], "application/vnd.mynfc": ["taglet"], "application/vnd.neurolanguage.nlu": ["nlu"], "application/vnd.nitf": ["ntf", "nitf"], "application/vnd.noblenet-directory": ["nnd"], "application/vnd.noblenet-sealer": ["nns"], "application/vnd.noblenet-web": ["nnw"], "application/vnd.nokia.n-gage.ac+xml": ["*ac"], "application/vnd.nokia.n-gage.data": ["ngdat"], "application/vnd.nokia.n-gage.symbian.install": ["n-gage"], "application/vnd.nokia.radio-preset": ["rpst"], "application/vnd.nokia.radio-presets": ["rpss"], "application/vnd.novadigm.edm": ["edm"], "application/vnd.novadigm.edx": ["edx"], "application/vnd.novadigm.ext": ["ext"], "application/vnd.oasis.opendocument.chart": ["odc"], "application/vnd.oasis.opendocument.chart-template": ["otc"], "application/vnd.oasis.opendocument.database": ["odb"], "application/vnd.oasis.opendocument.formula": ["odf"], "application/vnd.oasis.opendocument.formula-template": ["odft"], "application/vnd.oasis.opendocument.graphics": ["odg"], "application/vnd.oasis.opendocument.graphics-template": ["otg"], "application/vnd.oasis.opendocument.image": ["odi"], "application/vnd.oasis.opendocument.image-template": ["oti"], "application/vnd.oasis.opendocument.presentation": ["odp"], "application/vnd.oasis.opendocument.presentation-template": ["otp"], "application/vnd.oasis.opendocument.spreadsheet": ["ods"], "application/vnd.oasis.opendocument.spreadsheet-template": ["ots"], "application/vnd.oasis.opendocument.text": ["odt"], "application/vnd.oasis.opendocument.text-master": ["odm"], "application/vnd.oasis.opendocument.text-template": ["ott"], "application/vnd.oasis.opendocument.text-web": ["oth"], "application/vnd.olpc-sugar": ["xo"], "application/vnd.oma.dd2+xml": ["dd2"], "application/vnd.openblox.game+xml": ["obgx"], "application/vnd.openofficeorg.extension": ["oxt"], "application/vnd.openstreetmap.data+xml": ["osm"], "application/vnd.openxmlformats-officedocument.presentationml.presentation": ["pptx"], "application/vnd.openxmlformats-officedocument.presentationml.slide": ["sldx"], "application/vnd.openxmlformats-officedocument.presentationml.slideshow": ["ppsx"], "application/vnd.openxmlformats-officedocument.presentationml.template": ["potx"], "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": ["xlsx"], "application/vnd.openxmlformats-officedocument.spreadsheetml.template": ["xltx"], "application/vnd.openxmlformats-officedocument.wordprocessingml.document": ["docx"], "application/vnd.openxmlformats-officedocument.wordprocessingml.template": ["dotx"], "application/vnd.osgeo.mapguide.package": ["mgp"], "application/vnd.osgi.dp": ["dp"], "application/vnd.osgi.subsystem": ["esa"], "application/vnd.palm": ["pdb", "pqa", "oprc"], "application/vnd.pawaafile": ["paw"], "application/vnd.pg.format": ["str"], "application/vnd.pg.osasli": ["ei6"], "application/vnd.picsel": ["efif"], "application/vnd.pmi.widget": ["wg"], "application/vnd.pocketlearn": ["plf"], "application/vnd.powerbuilder6": ["pbd"], "application/vnd.previewsystems.box": ["box"], "application/vnd.proteus.magazine": ["mgz"], "application/vnd.publishare-delta-tree": ["qps"], "application/vnd.pvi.ptid1": ["ptid"], "application/vnd.quark.quarkxpress": ["qxd", "qxt", "qwd", "qwt", "qxl", "qxb"], "application/vnd.rar": ["rar"], "application/vnd.realvnc.bed": ["bed"], "application/vnd.recordare.musicxml": ["mxl"], "application/vnd.recordare.musicxml+xml": ["musicxml"], "application/vnd.rig.cryptonote": ["cryptonote"], "application/vnd.rim.cod": ["cod"], "application/vnd.rn-realmedia": ["rm"], "application/vnd.rn-realmedia-vbr": ["rmvb"], "application/vnd.route66.link66+xml": ["link66"], "application/vnd.sailingtracker.track": ["st"], "application/vnd.seemail": ["see"], "application/vnd.sema": ["sema"], "application/vnd.semd": ["semd"], "application/vnd.semf": ["semf"], "application/vnd.shana.informed.formdata": ["ifm"], "application/vnd.shana.informed.formtemplate": ["itp"], "application/vnd.shana.informed.interchange": ["iif"], "application/vnd.shana.informed.package": ["ipk"], "application/vnd.simtech-mindmapper": ["twd", "twds"], "application/vnd.smaf": ["mmf"], "application/vnd.smart.teacher": ["teacher"], "application/vnd.software602.filler.form+xml": ["fo"], "application/vnd.solent.sdkm+xml": ["sdkm", "sdkd"], "application/vnd.spotfire.dxp": ["dxp"], "application/vnd.spotfire.sfs": ["sfs"], "application/vnd.stardivision.calc": ["sdc"], "application/vnd.stardivision.draw": ["sda"], "application/vnd.stardivision.impress": ["sdd"], "application/vnd.stardivision.math": ["smf"], "application/vnd.stardivision.writer": ["sdw", "vor"], "application/vnd.stardivision.writer-global": ["sgl"], "application/vnd.stepmania.package": ["smzip"], "application/vnd.stepmania.stepchart": ["sm"], "application/vnd.sun.wadl+xml": ["wadl"], "application/vnd.sun.xml.calc": ["sxc"], "application/vnd.sun.xml.calc.template": ["stc"], "application/vnd.sun.xml.draw": ["sxd"], "application/vnd.sun.xml.draw.template": ["std"], "application/vnd.sun.xml.impress": ["sxi"], "application/vnd.sun.xml.impress.template": ["sti"], "application/vnd.sun.xml.math": ["sxm"], "application/vnd.sun.xml.writer": ["sxw"], "application/vnd.sun.xml.writer.global": ["sxg"], "application/vnd.sun.xml.writer.template": ["stw"], "application/vnd.sus-calendar": ["sus", "susp"], "application/vnd.svd": ["svd"], "application/vnd.symbian.install": ["sis", "sisx"], "application/vnd.syncml+xml": ["xsm"], "application/vnd.syncml.dm+wbxml": ["bdm"], "application/vnd.syncml.dm+xml": ["xdm"], "application/vnd.syncml.dmddf+xml": ["ddf"], "application/vnd.tao.intent-module-archive": ["tao"], "application/vnd.tcpdump.pcap": ["pcap", "cap", "dmp"], "application/vnd.tmobile-livetv": ["tmo"], "application/vnd.trid.tpt": ["tpt"], "application/vnd.triscape.mxs": ["mxs"], "application/vnd.trueapp": ["tra"], "application/vnd.ufdl": ["ufd", "ufdl"], "application/vnd.uiq.theme": ["utz"], "application/vnd.umajin": ["umj"], "application/vnd.unity": ["unityweb"], "application/vnd.uoml+xml": ["uoml"], "application/vnd.vcx": ["vcx"], "application/vnd.visio": ["vsd", "vst", "vss", "vsw"], "application/vnd.visionary": ["vis"], "application/vnd.vsf": ["vsf"], "application/vnd.wap.wbxml": ["wbxml"], "application/vnd.wap.wmlc": ["wmlc"], "application/vnd.wap.wmlscriptc": ["wmlsc"], "application/vnd.webturbo": ["wtb"], "application/vnd.wolfram.player": ["nbp"], "application/vnd.wordperfect": ["wpd"], "application/vnd.wqd": ["wqd"], "application/vnd.wt.stf": ["stf"], "application/vnd.xara": ["xar"], "application/vnd.xfdl": ["xfdl"], "application/vnd.yamaha.hv-dic": ["hvd"], "application/vnd.yamaha.hv-script": ["hvs"], "application/vnd.yamaha.hv-voice": ["hvp"], "application/vnd.yamaha.openscoreformat": ["osf"], "application/vnd.yamaha.openscoreformat.osfpvg+xml": ["osfpvg"], "application/vnd.yamaha.smaf-audio": ["saf"], "application/vnd.yamaha.smaf-phrase": ["spf"], "application/vnd.yellowriver-custom-menu": ["cmp"], "application/vnd.zul": ["zir", "zirz"], "application/vnd.zzazz.deck+xml": ["zaz"], "application/x-7z-compressed": ["7z"], "application/x-abiword": ["abw"], "application/x-ace-compressed": ["ace"], "application/x-apple-diskimage": ["*dmg"], "application/x-arj": ["arj"], "application/x-authorware-bin": ["aab", "x32", "u32", "vox"], "application/x-authorware-map": ["aam"], "application/x-authorware-seg": ["aas"], "application/x-bcpio": ["bcpio"], "application/x-bdoc": ["*bdoc"], "application/x-bittorrent": ["torrent"], "application/x-blorb": ["blb", "blorb"], "application/x-bzip": ["bz"], "application/x-bzip2": ["bz2", "boz"], "application/x-cbr": ["cbr", "cba", "cbt", "cbz", "cb7"], "application/x-cdlink": ["vcd"], "application/x-cfs-compressed": ["cfs"], "application/x-chat": ["chat"], "application/x-chess-pgn": ["pgn"], "application/x-chrome-extension": ["crx"], "application/x-cocoa": ["cco"], "application/x-conference": ["nsc"], "application/x-cpio": ["cpio"], "application/x-csh": ["csh"], "application/x-debian-package": ["*deb", "udeb"], "application/x-dgc-compressed": ["dgc"], "application/x-director": ["dir", "dcr", "dxr", "cst", "cct", "cxt", "w3d", "fgd", "swa"], "application/x-doom": ["wad"], "application/x-dtbncx+xml": ["ncx"], "application/x-dtbook+xml": ["dtb"], "application/x-dtbresource+xml": ["res"], "application/x-dvi": ["dvi"], "application/x-envoy": ["evy"], "application/x-eva": ["eva"], "application/x-font-bdf": ["bdf"], "application/x-font-ghostscript": ["gsf"], "application/x-font-linux-psf": ["psf"], "application/x-font-pcf": ["pcf"], "application/x-font-snf": ["snf"], "application/x-font-type1": ["pfa", "pfb", "pfm", "afm"], "application/x-freearc": ["arc"], "application/x-futuresplash": ["spl"], "application/x-gca-compressed": ["gca"], "application/x-glulx": ["ulx"], "application/x-gnumeric": ["gnumeric"], "application/x-gramps-xml": ["gramps"], "application/x-gtar": ["gtar"], "application/x-hdf": ["hdf"], "application/x-httpd-php": ["php"], "application/x-install-instructions": ["install"], "application/x-iso9660-image": ["*iso"], "application/x-iwork-keynote-sffkey": ["*key"], "application/x-iwork-numbers-sffnumbers": ["*numbers"], "application/x-iwork-pages-sffpages": ["*pages"], "application/x-java-archive-diff": ["jardiff"], "application/x-java-jnlp-file": ["jnlp"], "application/x-keepass2": ["kdbx"], "application/x-latex": ["latex"], "application/x-lua-bytecode": ["luac"], "application/x-lzh-compressed": ["lzh", "lha"], "application/x-makeself": ["run"], "application/x-mie": ["mie"], "application/x-mobipocket-ebook": ["prc", "mobi"], "application/x-ms-application": ["application"], "application/x-ms-shortcut": ["lnk"], "application/x-ms-wmd": ["wmd"], "application/x-ms-wmz": ["wmz"], "application/x-ms-xbap": ["xbap"], "application/x-msaccess": ["mdb"], "application/x-msbinder": ["obd"], "application/x-mscardfile": ["crd"], "application/x-msclip": ["clp"], "application/x-msdos-program": ["*exe"], "application/x-msdownload": ["*exe", "*dll", "com", "bat", "*msi"], "application/x-msmediaview": ["mvb", "m13", "m14"], "application/x-msmetafile": ["*wmf", "*wmz", "*emf", "emz"], "application/x-msmoney": ["mny"], "application/x-mspublisher": ["pub"], "application/x-msschedule": ["scd"], "application/x-msterminal": ["trm"], "application/x-mswrite": ["wri"], "application/x-netcdf": ["nc", "cdf"], "application/x-ns-proxy-autoconfig": ["pac"], "application/x-nzb": ["nzb"], "application/x-perl": ["pl", "pm"], "application/x-pilot": ["*prc", "*pdb"], "application/x-pkcs12": ["p12", "pfx"], "application/x-pkcs7-certificates": ["p7b", "spc"], "application/x-pkcs7-certreqresp": ["p7r"], "application/x-rar-compressed": ["*rar"], "application/x-redhat-package-manager": ["rpm"], "application/x-research-info-systems": ["ris"], "application/x-sea": ["sea"], "application/x-sh": ["sh"], "application/x-shar": ["shar"], "application/x-shockwave-flash": ["swf"], "application/x-silverlight-app": ["xap"], "application/x-sql": ["sql"], "application/x-stuffit": ["sit"], "application/x-stuffitx": ["sitx"], "application/x-subrip": ["srt"], "application/x-sv4cpio": ["sv4cpio"], "application/x-sv4crc": ["sv4crc"], "application/x-t3vm-image": ["t3"], "application/x-tads": ["gam"], "application/x-tar": ["tar"], "application/x-tcl": ["tcl", "tk"], "application/x-tex": ["tex"], "application/x-tex-tfm": ["tfm"], "application/x-texinfo": ["texinfo", "texi"], "application/x-tgif": ["*obj"], "application/x-ustar": ["ustar"], "application/x-virtualbox-hdd": ["hdd"], "application/x-virtualbox-ova": ["ova"], "application/x-virtualbox-ovf": ["ovf"], "application/x-virtualbox-vbox": ["vbox"], "application/x-virtualbox-vbox-extpack": ["vbox-extpack"], "application/x-virtualbox-vdi": ["vdi"], "application/x-virtualbox-vhd": ["vhd"], "application/x-virtualbox-vmdk": ["vmdk"], "application/x-wais-source": ["src"], "application/x-web-app-manifest+json": ["webapp"], "application/x-x509-ca-cert": ["der", "crt", "pem"], "application/x-xfig": ["fig"], "application/x-xliff+xml": ["*xlf"], "application/x-xpinstall": ["xpi"], "application/x-xz": ["xz"], "application/x-zmachine": ["z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8"], "audio/vnd.dece.audio": ["uva", "uvva"], "audio/vnd.digital-winds": ["eol"], "audio/vnd.dra": ["dra"], "audio/vnd.dts": ["dts"], "audio/vnd.dts.hd": ["dtshd"], "audio/vnd.lucent.voice": ["lvp"], "audio/vnd.ms-playready.media.pya": ["pya"], "audio/vnd.nuera.ecelp4800": ["ecelp4800"], "audio/vnd.nuera.ecelp7470": ["ecelp7470"], "audio/vnd.nuera.ecelp9600": ["ecelp9600"], "audio/vnd.rip": ["rip"], "audio/x-aac": ["aac"], "audio/x-aiff": ["aif", "aiff", "aifc"], "audio/x-caf": ["caf"], "audio/x-flac": ["flac"], "audio/x-m4a": ["*m4a"], "audio/x-matroska": ["mka"], "audio/x-mpegurl": ["m3u"], "audio/x-ms-wax": ["wax"], "audio/x-ms-wma": ["wma"], "audio/x-pn-realaudio": ["ram", "ra"], "audio/x-pn-realaudio-plugin": ["rmp"], "audio/x-realaudio": ["*ra"], "audio/x-wav": ["*wav"], "chemical/x-cdx": ["cdx"], "chemical/x-cif": ["cif"], "chemical/x-cmdf": ["cmdf"], "chemical/x-cml": ["cml"], "chemical/x-csml": ["csml"], "chemical/x-xyz": ["xyz"], "image/prs.btif": ["btif"], "image/prs.pti": ["pti"], "image/vnd.adobe.photoshop": ["psd"], "image/vnd.airzip.accelerator.azv": ["azv"], "image/vnd.dece.graphic": ["uvi", "uvvi", "uvg", "uvvg"], "image/vnd.djvu": ["djvu", "djv"], "image/vnd.dvb.subtitle": ["*sub"], "image/vnd.dwg": ["dwg"], "image/vnd.dxf": ["dxf"], "image/vnd.fastbidsheet": ["fbs"], "image/vnd.fpx": ["fpx"], "image/vnd.fst": ["fst"], "image/vnd.fujixerox.edmics-mmr": ["mmr"], "image/vnd.fujixerox.edmics-rlc": ["rlc"], "image/vnd.microsoft.icon": ["ico"], "image/vnd.ms-dds": ["dds"], "image/vnd.ms-modi": ["mdi"], "image/vnd.ms-photo": ["wdp"], "image/vnd.net-fpx": ["npx"], "image/vnd.pco.b16": ["b16"], "image/vnd.tencent.tap": ["tap"], "image/vnd.valve.source.texture": ["vtf"], "image/vnd.wap.wbmp": ["wbmp"], "image/vnd.xiff": ["xif"], "image/vnd.zbrush.pcx": ["pcx"], "image/x-3ds": ["3ds"], "image/x-cmu-raster": ["ras"], "image/x-cmx": ["cmx"], "image/x-freehand": ["fh", "fhc", "fh4", "fh5", "fh7"], "image/x-icon": ["*ico"], "image/x-jng": ["jng"], "image/x-mrsid-image": ["sid"], "image/x-ms-bmp": ["*bmp"], "image/x-pcx": ["*pcx"], "image/x-pict": ["pic", "pct"], "image/x-portable-anymap": ["pnm"], "image/x-portable-bitmap": ["pbm"], "image/x-portable-graymap": ["pgm"], "image/x-portable-pixmap": ["ppm"], "image/x-rgb": ["rgb"], "image/x-tga": ["tga"], "image/x-xbitmap": ["xbm"], "image/x-xpixmap": ["xpm"], "image/x-xwindowdump": ["xwd"], "message/vnd.wfa.wsc": ["wsc"], "model/vnd.collada+xml": ["dae"], "model/vnd.dwf": ["dwf"], "model/vnd.gdl": ["gdl"], "model/vnd.gtw": ["gtw"], "model/vnd.mts": ["mts"], "model/vnd.opengex": ["ogex"], "model/vnd.parasolid.transmit.binary": ["x_b"], "model/vnd.parasolid.transmit.text": ["x_t"], "model/vnd.sap.vds": ["vds"], "model/vnd.usdz+zip": ["usdz"], "model/vnd.valve.source.compiled-map": ["bsp"], "model/vnd.vtu": ["vtu"], "text/prs.lines.tag": ["dsc"], "text/vnd.curl": ["curl"], "text/vnd.curl.dcurl": ["dcurl"], "text/vnd.curl.mcurl": ["mcurl"], "text/vnd.curl.scurl": ["scurl"], "text/vnd.dvb.subtitle": ["sub"], "text/vnd.fly": ["fly"], "text/vnd.fmi.flexstor": ["flx"], "text/vnd.graphviz": ["gv"], "text/vnd.in3d.3dml": ["3dml"], "text/vnd.in3d.spot": ["spot"], "text/vnd.sun.j2me.app-descriptor": ["jad"], "text/vnd.wap.wml": ["wml"], "text/vnd.wap.wmlscript": ["wmls"], "text/x-asm": ["s", "asm"], "text/x-c": ["c", "cc", "cxx", "cpp", "h", "hh", "dic"], "text/x-component": ["htc"], "text/x-fortran": ["f", "for", "f77", "f90"], "text/x-handlebars-template": ["hbs"], "text/x-java-source": ["java"], "text/x-lua": ["lua"], "text/x-markdown": ["mkd"], "text/x-nfo": ["nfo"], "text/x-opml": ["opml"], "text/x-org": ["*org"], "text/x-pascal": ["p", "pas"], "text/x-processing": ["pde"], "text/x-sass": ["sass"], "text/x-scss": ["scss"], "text/x-setext": ["etx"], "text/x-sfv": ["sfv"], "text/x-suse-ymp": ["ymp"], "text/x-uuencode": ["uu"], "text/x-vcalendar": ["vcs"], "text/x-vcard": ["vcf"], "video/vnd.dece.hd": ["uvh", "uvvh"], "video/vnd.dece.mobile": ["uvm", "uvvm"], "video/vnd.dece.pd": ["uvp", "uvvp"], "video/vnd.dece.sd": ["uvs", "uvvs"], "video/vnd.dece.video": ["uvv", "uvvv"], "video/vnd.dvb.file": ["dvb"], "video/vnd.fvt": ["fvt"], "video/vnd.mpegurl": ["mxu", "m4u"], "video/vnd.ms-playready.media.pyv": ["pyv"], "video/vnd.uvvu.mp4": ["uvu", "uvvu"], "video/vnd.vivo": ["viv"], "video/x-f4v": ["f4v"], "video/x-fli": ["fli"], "video/x-flv": ["flv"], "video/x-m4v": ["m4v"], "video/x-matroska": ["mkv", "mk3d", "mks"], "video/x-mng": ["mng"], "video/x-ms-asf": ["asf", "asx"], "video/x-ms-vob": ["vob"], "video/x-ms-wm": ["wm"], "video/x-ms-wmv": ["wmv"], "video/x-ms-wmx": ["wmx"], "video/x-ms-wvx": ["wvx"], "video/x-msvideo": ["avi"], "video/x-sgi-movie": ["movie"], "video/x-smv": ["smv"], "x-conference/x-cooltalk": ["ice"] };
  }
});

// ../../node_modules/mime/index.js
var require_mime = __commonJS({
  "../../node_modules/mime/index.js"(exports2, module2) {
    "use strict";
    var Mime = require_Mime();
    module2.exports = new Mime(require_standard(), require_other());
  }
});

// ../../node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "../../node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a3, b3, str) {
      if (a3 instanceof RegExp) a3 = maybeMatch(a3, str);
      if (b3 instanceof RegExp) b3 = maybeMatch(b3, str);
      var r3 = range(a3, b3, str);
      return r3 && {
        start: r3[0],
        end: r3[1],
        pre: str.slice(0, r3[0]),
        body: str.slice(r3[0] + a3.length, r3[1]),
        post: str.slice(r3[1] + b3.length)
      };
    }
    function maybeMatch(reg, str) {
      var m3 = str.match(reg);
      return m3 ? m3[0] : null;
    }
    balanced.range = range;
    function range(a3, b3, str) {
      var begs, beg, left, right, result3;
      var ai = str.indexOf(a3);
      var bi = str.indexOf(b3, ai + 1);
      var i3 = ai;
      if (ai >= 0 && bi > 0) {
        if (a3 === b3) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i3 >= 0 && !result3) {
          if (i3 == ai) {
            begs.push(i3);
            ai = str.indexOf(a3, i3 + 1);
          } else if (begs.length == 1) {
            result3 = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b3, i3 + 1);
          }
          i3 = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result3 = [left, right];
        }
      }
      return result3;
    }
  }
});

// ../../node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "../../node_modules/brace-expansion/index.js"(exports2, module2) {
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m3 = balanced("{", "}", str);
      if (!m3)
        return str.split(",");
      var pre = m3.pre;
      var body = m3.body;
      var post = m3.post;
      var p3 = pre.split(",");
      p3[p3.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p3[p3.length - 1] += postParts.shift();
        p3.push.apply(p3, postParts);
      }
      parts.push.apply(parts, p3);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand4(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte2(i3, y2) {
      return i3 <= y2;
    }
    function gte(i3, y2) {
      return i3 >= y2;
    }
    function expand4(str, isTop) {
      var expansions = [];
      var m3 = balanced("{", "}", str);
      if (!m3) return [str];
      var pre = m3.pre;
      var post = m3.post.length ? expand4(m3.post, false) : [""];
      if (/\$$/.test(m3.pre)) {
        for (var k3 = 0; k3 < post.length; k3++) {
          var expansion = pre + "{" + m3.body + "}" + post[k3];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m3.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m3.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m3.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m3.post.match(/,.*\}/)) {
            str = m3.pre + "{" + m3.body + escClose + m3.post;
            return expand4(str);
          }
          return [str];
        }
        var n3;
        if (isSequence) {
          n3 = m3.body.split(/\.\./);
        } else {
          n3 = parseCommaParts(m3.body);
          if (n3.length === 1) {
            n3 = expand4(n3[0], false).map(embrace);
            if (n3.length === 1) {
              return post.map(function(p3) {
                return m3.pre + n3[0] + p3;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x3 = numeric(n3[0]);
          var y2 = numeric(n3[1]);
          var width = Math.max(n3[0].length, n3[1].length);
          var incr = n3.length == 3 ? Math.abs(numeric(n3[2])) : 1;
          var test = lte2;
          var reverse = y2 < x3;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          var pad = n3.some(isPadded);
          N = [];
          for (var i3 = x3; test(i3, y2); i3 += incr) {
            var c3;
            if (isAlphaSequence) {
              c3 = String.fromCharCode(i3);
              if (c3 === "\\")
                c3 = "";
            } else {
              c3 = String(i3);
              if (pad) {
                var need = width - c3.length;
                if (need > 0) {
                  var z2 = new Array(need + 1).join("0");
                  if (i3 < 0)
                    c3 = "-" + z2 + c3.slice(1);
                  else
                    c3 = z2 + c3;
                }
              }
            }
            N.push(c3);
          }
        } else {
          N = [];
          for (var j3 = 0; j3 < n3.length; j3++) {
            N.push.apply(N, expand4(n3[j3], false));
          }
        }
        for (var j3 = 0; j3 < N.length; j3++) {
          for (var k3 = 0; k3 < post.length; k3++) {
            var expansion = pre + N[j3] + post[k3];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/assert-valid-pattern.js
var MAX_PATTERN_LENGTH, assertValidPattern;
var init_assert_valid_pattern = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/assert-valid-pattern.js"() {
    MAX_PATTERN_LENGTH = 1024 * 64;
    assertValidPattern = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    };
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/brace-expressions.js
var posixClasses, braceEscape, regexpEscape, rangesToString, parseClass;
var init_brace_expressions = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/brace-expressions.js"() {
    posixClasses = {
      "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
      "[:alpha:]": ["\\p{L}\\p{Nl}", true],
      "[:ascii:]": ["\\x00-\\x7f", false],
      "[:blank:]": ["\\p{Zs}\\t", true],
      "[:cntrl:]": ["\\p{Cc}", true],
      "[:digit:]": ["\\p{Nd}", true],
      "[:graph:]": ["\\p{Z}\\p{C}", true, true],
      "[:lower:]": ["\\p{Ll}", true],
      "[:print:]": ["\\p{C}", true],
      "[:punct:]": ["\\p{P}", true],
      "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
      "[:upper:]": ["\\p{Lu}", true],
      "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
      "[:xdigit:]": ["A-Fa-f0-9", false]
    };
    braceEscape = (s3) => s3.replace(/[[\]\\-]/g, "\\$&");
    regexpEscape = (s3) => s3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    rangesToString = (ranges) => ranges.join("");
    parseClass = (glob2, position) => {
      const pos = position;
      if (glob2.charAt(pos) !== "[") {
        throw new Error("not in a brace expression");
      }
      const ranges = [];
      const negs = [];
      let i3 = pos + 1;
      let sawStart = false;
      let uflag = false;
      let escaping = false;
      let negate = false;
      let endPos = pos;
      let rangeStart = "";
      WHILE: while (i3 < glob2.length) {
        const c3 = glob2.charAt(i3);
        if ((c3 === "!" || c3 === "^") && i3 === pos + 1) {
          negate = true;
          i3++;
          continue;
        }
        if (c3 === "]" && sawStart && !escaping) {
          endPos = i3 + 1;
          break;
        }
        sawStart = true;
        if (c3 === "\\") {
          if (!escaping) {
            escaping = true;
            i3++;
            continue;
          }
        }
        if (c3 === "[" && !escaping) {
          for (const [cls, [unip, u3, neg]] of Object.entries(posixClasses)) {
            if (glob2.startsWith(cls, i3)) {
              if (rangeStart) {
                return ["$.", false, glob2.length - pos, true];
              }
              i3 += cls.length;
              if (neg)
                negs.push(unip);
              else
                ranges.push(unip);
              uflag = uflag || u3;
              continue WHILE;
            }
          }
        }
        escaping = false;
        if (rangeStart) {
          if (c3 > rangeStart) {
            ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c3));
          } else if (c3 === rangeStart) {
            ranges.push(braceEscape(c3));
          }
          rangeStart = "";
          i3++;
          continue;
        }
        if (glob2.startsWith("-]", i3 + 1)) {
          ranges.push(braceEscape(c3 + "-"));
          i3 += 2;
          continue;
        }
        if (glob2.startsWith("-", i3 + 1)) {
          rangeStart = c3;
          i3 += 2;
          continue;
        }
        ranges.push(braceEscape(c3));
        i3++;
      }
      if (endPos < i3) {
        return ["", false, 0, false];
      }
      if (!ranges.length && !negs.length) {
        return ["$.", false, glob2.length - pos, true];
      }
      if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
        const r3 = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r3), false, endPos - pos, false];
      }
      const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
      const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
      const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
      return [comb, uflag, endPos - pos, true];
    };
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/unescape.js
var unescape2;
var init_unescape = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/unescape.js"() {
    unescape2 = (s3, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s3.replace(/\[([^\/\\])\]/g, "$1") : s3.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
    };
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/ast.js
var types, isExtglobType, startNoTraversal, startNoDot, addPatternStart, justDots, reSpecials, regExpEscape, qmark, star, starNoEmpty, _root, _hasMagic, _uflag, _parts, _parent, _parentIndex, _negs, _filledNegs, _options, _toString, _emptyExt, _AST_instances, fillNegs_fn, _AST_static, parseAST_fn, partsToRegExp_fn, parseGlob_fn, _AST, AST;
var init_ast = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/ast.js"() {
    init_brace_expressions();
    init_unescape();
    types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
    isExtglobType = (c3) => types.has(c3);
    startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
    startNoDot = "(?!\\.)";
    addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
    justDots = /* @__PURE__ */ new Set(["..", "."]);
    reSpecials = new Set("().*{}+?[]^$\\!");
    regExpEscape = (s3) => s3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    qmark = "[^/]";
    star = qmark + "*?";
    starNoEmpty = qmark + "+?";
    _AST = class _AST {
      constructor(type, parent, options = {}) {
        __privateAdd(this, _AST_instances);
        __publicField(this, "type");
        __privateAdd(this, _root);
        __privateAdd(this, _hasMagic);
        __privateAdd(this, _uflag, false);
        __privateAdd(this, _parts, []);
        __privateAdd(this, _parent);
        __privateAdd(this, _parentIndex);
        __privateAdd(this, _negs);
        __privateAdd(this, _filledNegs, false);
        __privateAdd(this, _options);
        __privateAdd(this, _toString);
        // set to true if it's an extglob with no children
        // (which really means one child of '')
        __privateAdd(this, _emptyExt, false);
        this.type = type;
        if (type)
          __privateSet(this, _hasMagic, true);
        __privateSet(this, _parent, parent);
        __privateSet(this, _root, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _root) : this);
        __privateSet(this, _options, __privateGet(this, _root) === this ? options : __privateGet(__privateGet(this, _root), _options));
        __privateSet(this, _negs, __privateGet(this, _root) === this ? [] : __privateGet(__privateGet(this, _root), _negs));
        if (type === "!" && !__privateGet(__privateGet(this, _root), _filledNegs))
          __privateGet(this, _negs).push(this);
        __privateSet(this, _parentIndex, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0);
      }
      get hasMagic() {
        if (__privateGet(this, _hasMagic) !== void 0)
          return __privateGet(this, _hasMagic);
        for (const p3 of __privateGet(this, _parts)) {
          if (typeof p3 === "string")
            continue;
          if (p3.type || p3.hasMagic)
            return __privateSet(this, _hasMagic, true);
        }
        return __privateGet(this, _hasMagic);
      }
      // reconstructs the pattern
      toString() {
        if (__privateGet(this, _toString) !== void 0)
          return __privateGet(this, _toString);
        if (!this.type) {
          return __privateSet(this, _toString, __privateGet(this, _parts).map((p3) => String(p3)).join(""));
        } else {
          return __privateSet(this, _toString, this.type + "(" + __privateGet(this, _parts).map((p3) => String(p3)).join("|") + ")");
        }
      }
      push(...parts) {
        for (const p3 of parts) {
          if (p3 === "")
            continue;
          if (typeof p3 !== "string" && !(p3 instanceof _AST && __privateGet(p3, _parent) === this)) {
            throw new Error("invalid part: " + p3);
          }
          __privateGet(this, _parts).push(p3);
        }
      }
      toJSON() {
        var _a4;
        const ret = this.type === null ? __privateGet(this, _parts).slice().map((p3) => typeof p3 === "string" ? p3 : p3.toJSON()) : [this.type, ...__privateGet(this, _parts).map((p3) => p3.toJSON())];
        if (this.isStart() && !this.type)
          ret.unshift([]);
        if (this.isEnd() && (this === __privateGet(this, _root) || __privateGet(__privateGet(this, _root), _filledNegs) && ((_a4 = __privateGet(this, _parent)) == null ? void 0 : _a4.type) === "!")) {
          ret.push({});
        }
        return ret;
      }
      isStart() {
        var _a4;
        if (__privateGet(this, _root) === this)
          return true;
        if (!((_a4 = __privateGet(this, _parent)) == null ? void 0 : _a4.isStart()))
          return false;
        if (__privateGet(this, _parentIndex) === 0)
          return true;
        const p3 = __privateGet(this, _parent);
        for (let i3 = 0; i3 < __privateGet(this, _parentIndex); i3++) {
          const pp = __privateGet(p3, _parts)[i3];
          if (!(pp instanceof _AST && pp.type === "!")) {
            return false;
          }
        }
        return true;
      }
      isEnd() {
        var _a4, _b2, _c;
        if (__privateGet(this, _root) === this)
          return true;
        if (((_a4 = __privateGet(this, _parent)) == null ? void 0 : _a4.type) === "!")
          return true;
        if (!((_b2 = __privateGet(this, _parent)) == null ? void 0 : _b2.isEnd()))
          return false;
        if (!this.type)
          return (_c = __privateGet(this, _parent)) == null ? void 0 : _c.isEnd();
        const pl = __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0;
        return __privateGet(this, _parentIndex) === pl - 1;
      }
      copyIn(part) {
        if (typeof part === "string")
          this.push(part);
        else
          this.push(part.clone(this));
      }
      clone(parent) {
        const c3 = new _AST(this.type, parent);
        for (const p3 of __privateGet(this, _parts)) {
          c3.copyIn(p3);
        }
        return c3;
      }
      static fromGlob(pattern, options = {}) {
        var _a4;
        const ast = new _AST(null, void 0, options);
        __privateMethod(_a4 = _AST, _AST_static, parseAST_fn).call(_a4, pattern, ast, 0, options);
        return ast;
      }
      // returns the regular expression if there's magic, or the unescaped
      // string if not.
      toMMPattern() {
        if (this !== __privateGet(this, _root))
          return __privateGet(this, _root).toMMPattern();
        const glob2 = this.toString();
        const [re, body, hasMagic2, uflag] = this.toRegExpSource();
        const anyMagic = hasMagic2 || __privateGet(this, _hasMagic) || __privateGet(this, _options).nocase && !__privateGet(this, _options).nocaseMagicOnly && glob2.toUpperCase() !== glob2.toLowerCase();
        if (!anyMagic) {
          return body;
        }
        const flags = (__privateGet(this, _options).nocase ? "i" : "") + (uflag ? "u" : "");
        return Object.assign(new RegExp(`^${re}$`, flags), {
          _src: re,
          _glob: glob2
        });
      }
      get options() {
        return __privateGet(this, _options);
      }
      // returns the string match, the regexp source, whether there's magic
      // in the regexp (so a regular expression is required) and whether or
      // not the uflag is needed for the regular expression (for posix classes)
      // TODO: instead of injecting the start/end at this point, just return
      // the BODY of the regexp, along with the start/end portions suitable
      // for binding the start/end in either a joined full-path makeRe context
      // (where we bind to (^|/), or a standalone matchPart context (where
      // we bind to ^, and not /).  Otherwise slashes get duped!
      //
      // In part-matching mode, the start is:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: ^(?!\.\.?$)
      // - if dots allowed or not possible: ^
      // - if dots possible and not allowed: ^(?!\.)
      // end is:
      // - if not isEnd(): nothing
      // - else: $
      //
      // In full-path matching mode, we put the slash at the START of the
      // pattern, so start is:
      // - if first pattern: same as part-matching mode
      // - if not isStart(): nothing
      // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
      // - if dots allowed or not possible: /
      // - if dots possible and not allowed: /(?!\.)
      // end is:
      // - if last pattern, same as part-matching mode
      // - else nothing
      //
      // Always put the (?:$|/) on negated tails, though, because that has to be
      // there to bind the end of the negated pattern portion, and it's easier to
      // just stick it in now rather than try to inject it later in the middle of
      // the pattern.
      //
      // We can just always return the same end, and leave it up to the caller
      // to know whether it's going to be used joined or in parts.
      // And, if the start is adjusted slightly, can do the same there:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
      // - if dots allowed or not possible: (?:/|^)
      // - if dots possible and not allowed: (?:/|^)(?!\.)
      //
      // But it's better to have a simpler binding without a conditional, for
      // performance, so probably better to return both start options.
      //
      // Then the caller just ignores the end if it's not the first pattern,
      // and the start always gets applied.
      //
      // But that's always going to be $ if it's the ending pattern, or nothing,
      // so the caller can just attach $ at the end of the pattern when building.
      //
      // So the todo is:
      // - better detect what kind of start is needed
      // - return both flavors of starting pattern
      // - attach $ at the end of the pattern when creating the actual RegExp
      //
      // Ah, but wait, no, that all only applies to the root when the first pattern
      // is not an extglob. If the first pattern IS an extglob, then we need all
      // that dot prevention biz to live in the extglob portions, because eg
      // +(*|.x*) can match .xy but not .yx.
      //
      // So, return the two flavors if it's #root and the first child is not an
      // AST, otherwise leave it to the child AST to handle it, and there,
      // use the (?:^|/) style of start binding.
      //
      // Even simplified further:
      // - Since the start for a join is eg /(?!\.) and the start for a part
      // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
      // or start or whatever) and prepend ^ or / at the Regexp construction.
      toRegExpSource(allowDot) {
        var _a4;
        const dot = allowDot ?? !!__privateGet(this, _options).dot;
        if (__privateGet(this, _root) === this)
          __privateMethod(this, _AST_instances, fillNegs_fn).call(this);
        if (!this.type) {
          const noEmpty = this.isStart() && this.isEnd();
          const src = __privateGet(this, _parts).map((p3) => {
            var _a5;
            const [re, _3, hasMagic2, uflag] = typeof p3 === "string" ? __privateMethod(_a5 = _AST, _AST_static, parseGlob_fn).call(_a5, p3, __privateGet(this, _hasMagic), noEmpty) : p3.toRegExpSource(allowDot);
            __privateSet(this, _hasMagic, __privateGet(this, _hasMagic) || hasMagic2);
            __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
            return re;
          }).join("");
          let start2 = "";
          if (this.isStart()) {
            if (typeof __privateGet(this, _parts)[0] === "string") {
              const dotTravAllowed = __privateGet(this, _parts).length === 1 && justDots.has(__privateGet(this, _parts)[0]);
              if (!dotTravAllowed) {
                const aps = addPatternStart;
                const needNoTrav = (
                  // dots are allowed, and the pattern starts with [ or .
                  dot && aps.has(src.charAt(0)) || // the pattern starts with \., and then [ or .
                  src.startsWith("\\.") && aps.has(src.charAt(2)) || // the pattern starts with \.\., and then [ or .
                  src.startsWith("\\.\\.") && aps.has(src.charAt(4))
                );
                const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
              }
            }
          }
          let end = "";
          if (this.isEnd() && __privateGet(__privateGet(this, _root), _filledNegs) && ((_a4 = __privateGet(this, _parent)) == null ? void 0 : _a4.type) === "!") {
            end = "(?:$|\\/)";
          }
          const final2 = start2 + src + end;
          return [
            final2,
            unescape2(src),
            __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
            __privateGet(this, _uflag)
          ];
        }
        const repeated = this.type === "*" || this.type === "+";
        const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
        let body = __privateMethod(this, _AST_instances, partsToRegExp_fn).call(this, dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
          const s3 = this.toString();
          __privateSet(this, _parts, [s3]);
          this.type = null;
          __privateSet(this, _hasMagic, void 0);
          return [s3, unescape2(this.toString()), false, false];
        }
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : __privateMethod(this, _AST_instances, partsToRegExp_fn).call(this, true);
        if (bodyDotAllowed === body) {
          bodyDotAllowed = "";
        }
        if (bodyDotAllowed) {
          body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        let final = "";
        if (this.type === "!" && __privateGet(this, _emptyExt)) {
          final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
        } else {
          const close = this.type === "!" ? (
            // !() must match something,but !(x) can match ''
            "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")"
          ) : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
          final = start + body + close;
        }
        return [
          final,
          unescape2(body),
          __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
          __privateGet(this, _uflag)
        ];
      }
    };
    _root = new WeakMap();
    _hasMagic = new WeakMap();
    _uflag = new WeakMap();
    _parts = new WeakMap();
    _parent = new WeakMap();
    _parentIndex = new WeakMap();
    _negs = new WeakMap();
    _filledNegs = new WeakMap();
    _options = new WeakMap();
    _toString = new WeakMap();
    _emptyExt = new WeakMap();
    _AST_instances = new WeakSet();
    fillNegs_fn = function() {
      if (this !== __privateGet(this, _root))
        throw new Error("should only call on root");
      if (__privateGet(this, _filledNegs))
        return this;
      this.toString();
      __privateSet(this, _filledNegs, true);
      let n3;
      while (n3 = __privateGet(this, _negs).pop()) {
        if (n3.type !== "!")
          continue;
        let p3 = n3;
        let pp = __privateGet(p3, _parent);
        while (pp) {
          for (let i3 = __privateGet(p3, _parentIndex) + 1; !pp.type && i3 < __privateGet(pp, _parts).length; i3++) {
            for (const part of __privateGet(n3, _parts)) {
              if (typeof part === "string") {
                throw new Error("string part in extglob AST??");
              }
              part.copyIn(__privateGet(pp, _parts)[i3]);
            }
          }
          p3 = pp;
          pp = __privateGet(p3, _parent);
        }
      }
      return this;
    };
    _AST_static = new WeakSet();
    parseAST_fn = function(str, ast, pos, opt) {
      var _a4, _b2;
      let escaping = false;
      let inBrace = false;
      let braceStart = -1;
      let braceNeg = false;
      if (ast.type === null) {
        let i4 = pos;
        let acc2 = "";
        while (i4 < str.length) {
          const c3 = str.charAt(i4++);
          if (escaping || c3 === "\\") {
            escaping = !escaping;
            acc2 += c3;
            continue;
          }
          if (inBrace) {
            if (i4 === braceStart + 1) {
              if (c3 === "^" || c3 === "!") {
                braceNeg = true;
              }
            } else if (c3 === "]" && !(i4 === braceStart + 2 && braceNeg)) {
              inBrace = false;
            }
            acc2 += c3;
            continue;
          } else if (c3 === "[") {
            inBrace = true;
            braceStart = i4;
            braceNeg = false;
            acc2 += c3;
            continue;
          }
          if (!opt.noext && isExtglobType(c3) && str.charAt(i4) === "(") {
            ast.push(acc2);
            acc2 = "";
            const ext4 = new _AST(c3, ast);
            i4 = __privateMethod(_a4 = _AST, _AST_static, parseAST_fn).call(_a4, str, ext4, i4, opt);
            ast.push(ext4);
            continue;
          }
          acc2 += c3;
        }
        ast.push(acc2);
        return i4;
      }
      let i3 = pos + 1;
      let part = new _AST(null, ast);
      const parts = [];
      let acc = "";
      while (i3 < str.length) {
        const c3 = str.charAt(i3++);
        if (escaping || c3 === "\\") {
          escaping = !escaping;
          acc += c3;
          continue;
        }
        if (inBrace) {
          if (i3 === braceStart + 1) {
            if (c3 === "^" || c3 === "!") {
              braceNeg = true;
            }
          } else if (c3 === "]" && !(i3 === braceStart + 2 && braceNeg)) {
            inBrace = false;
          }
          acc += c3;
          continue;
        } else if (c3 === "[") {
          inBrace = true;
          braceStart = i3;
          braceNeg = false;
          acc += c3;
          continue;
        }
        if (isExtglobType(c3) && str.charAt(i3) === "(") {
          part.push(acc);
          acc = "";
          const ext4 = new _AST(c3, part);
          part.push(ext4);
          i3 = __privateMethod(_b2 = _AST, _AST_static, parseAST_fn).call(_b2, str, ext4, i3, opt);
          continue;
        }
        if (c3 === "|") {
          part.push(acc);
          acc = "";
          parts.push(part);
          part = new _AST(null, ast);
          continue;
        }
        if (c3 === ")") {
          if (acc === "" && __privateGet(ast, _parts).length === 0) {
            __privateSet(ast, _emptyExt, true);
          }
          part.push(acc);
          acc = "";
          ast.push(...parts, part);
          return i3;
        }
        acc += c3;
      }
      ast.type = null;
      __privateSet(ast, _hasMagic, void 0);
      __privateSet(ast, _parts, [str.substring(pos - 1)]);
      return i3;
    };
    partsToRegExp_fn = function(dot) {
      return __privateGet(this, _parts).map((p3) => {
        if (typeof p3 === "string") {
          throw new Error("string type in extglob ast??");
        }
        const [re, _3, _hasMagic4, uflag] = p3.toRegExpSource(dot);
        __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
        return re;
      }).filter((p3) => !(this.isStart() && this.isEnd()) || !!p3).join("|");
    };
    parseGlob_fn = function(glob2, hasMagic2, noEmpty = false) {
      let escaping = false;
      let re = "";
      let uflag = false;
      for (let i3 = 0; i3 < glob2.length; i3++) {
        const c3 = glob2.charAt(i3);
        if (escaping) {
          escaping = false;
          re += (reSpecials.has(c3) ? "\\" : "") + c3;
          continue;
        }
        if (c3 === "\\") {
          if (i3 === glob2.length - 1) {
            re += "\\\\";
          } else {
            escaping = true;
          }
          continue;
        }
        if (c3 === "[") {
          const [src, needUflag, consumed, magic] = parseClass(glob2, i3);
          if (consumed) {
            re += src;
            uflag = uflag || needUflag;
            i3 += consumed - 1;
            hasMagic2 = hasMagic2 || magic;
            continue;
          }
        }
        if (c3 === "*") {
          if (noEmpty && glob2 === "*")
            re += starNoEmpty;
          else
            re += star;
          hasMagic2 = true;
          continue;
        }
        if (c3 === "?") {
          re += qmark;
          hasMagic2 = true;
          continue;
        }
        re += regExpEscape(c3);
      }
      return [re, unescape2(glob2), !!hasMagic2, uflag];
    };
    __privateAdd(_AST, _AST_static);
    AST = _AST;
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/escape.js
var escape;
var init_escape = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/escape.js"() {
    escape = (s3, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s3.replace(/[?*()[\]]/g, "[$&]") : s3.replace(/[?*()[\]\\]/g, "\\$&");
    };
  }
});

// ../../node_modules/glob/node_modules/minimatch/dist/esm/index.js
var import_brace_expansion, minimatch, starDotExtRE, starDotExtTest, starDotExtTestDot, starDotExtTestNocase, starDotExtTestNocaseDot, starDotStarRE, starDotStarTest, starDotStarTestDot, dotStarRE, dotStarTest, starRE, starTest, starTestDot, qmarksRE, qmarksTestNocase, qmarksTestNocaseDot, qmarksTestDot, qmarksTest, qmarksTestNoExt, qmarksTestNoExtDot, defaultPlatform, path4, sep, GLOBSTAR, qmark2, star2, twoStarDot, twoStarNoDot, filter, ext, defaults, braceExpand, makeRe, match, globMagic, regExpEscape2, Minimatch;
var init_esm = __esm({
  "../../node_modules/glob/node_modules/minimatch/dist/esm/index.js"() {
    import_brace_expansion = __toESM(require_brace_expansion(), 1);
    init_assert_valid_pattern();
    init_ast();
    init_escape();
    init_unescape();
    init_ast();
    init_escape();
    init_unescape();
    minimatch = (p3, pattern, options = {}) => {
      assertValidPattern(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options).match(p3);
    };
    starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
    starDotExtTest = (ext4) => (f3) => !f3.startsWith(".") && f3.endsWith(ext4);
    starDotExtTestDot = (ext4) => (f3) => f3.endsWith(ext4);
    starDotExtTestNocase = (ext4) => {
      ext4 = ext4.toLowerCase();
      return (f3) => !f3.startsWith(".") && f3.toLowerCase().endsWith(ext4);
    };
    starDotExtTestNocaseDot = (ext4) => {
      ext4 = ext4.toLowerCase();
      return (f3) => f3.toLowerCase().endsWith(ext4);
    };
    starDotStarRE = /^\*+\.\*+$/;
    starDotStarTest = (f3) => !f3.startsWith(".") && f3.includes(".");
    starDotStarTestDot = (f3) => f3 !== "." && f3 !== ".." && f3.includes(".");
    dotStarRE = /^\.\*+$/;
    dotStarTest = (f3) => f3 !== "." && f3 !== ".." && f3.startsWith(".");
    starRE = /^\*+$/;
    starTest = (f3) => f3.length !== 0 && !f3.startsWith(".");
    starTestDot = (f3) => f3.length !== 0 && f3 !== "." && f3 !== "..";
    qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
    qmarksTestNocase = ([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      if (!ext4)
        return noext;
      ext4 = ext4.toLowerCase();
      return (f3) => noext(f3) && f3.toLowerCase().endsWith(ext4);
    };
    qmarksTestNocaseDot = ([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      if (!ext4)
        return noext;
      ext4 = ext4.toLowerCase();
      return (f3) => noext(f3) && f3.toLowerCase().endsWith(ext4);
    };
    qmarksTestDot = ([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      return !ext4 ? noext : (f3) => noext(f3) && f3.endsWith(ext4);
    };
    qmarksTest = ([$0, ext4 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      return !ext4 ? noext : (f3) => noext(f3) && f3.endsWith(ext4);
    };
    qmarksTestNoExt = ([$0]) => {
      const len = $0.length;
      return (f3) => f3.length === len && !f3.startsWith(".");
    };
    qmarksTestNoExtDot = ([$0]) => {
      const len = $0.length;
      return (f3) => f3.length === len && f3 !== "." && f3 !== "..";
    };
    defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
    path4 = {
      win32: { sep: "\\" },
      posix: { sep: "/" }
    };
    sep = defaultPlatform === "win32" ? path4.win32.sep : path4.posix.sep;
    minimatch.sep = sep;
    GLOBSTAR = Symbol("globstar **");
    minimatch.GLOBSTAR = GLOBSTAR;
    qmark2 = "[^/]";
    star2 = qmark2 + "*?";
    twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    filter = (pattern, options = {}) => (p3) => minimatch(p3, pattern, options);
    minimatch.filter = filter;
    ext = (a3, b3 = {}) => Object.assign({}, a3, b3);
    defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch;
      }
      const orig = minimatch;
      const m3 = (p3, pattern, options = {}) => orig(p3, pattern, ext(def, options));
      return Object.assign(m3, {
        Minimatch: class Minimatch extends orig.Minimatch {
          constructor(pattern, options = {}) {
            super(pattern, ext(def, options));
          }
          static defaults(options) {
            return orig.defaults(ext(def, options)).Minimatch;
          }
        },
        AST: class AST extends orig.AST {
          /* c8 ignore start */
          constructor(type, parent, options = {}) {
            super(type, parent, ext(def, options));
          }
          /* c8 ignore stop */
          static fromGlob(pattern, options = {}) {
            return orig.AST.fromGlob(pattern, ext(def, options));
          }
        },
        unescape: (s3, options = {}) => orig.unescape(s3, ext(def, options)),
        escape: (s3, options = {}) => orig.escape(s3, ext(def, options)),
        filter: (pattern, options = {}) => orig.filter(pattern, ext(def, options)),
        defaults: (options) => orig.defaults(ext(def, options)),
        makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def, options)),
        braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)),
        match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def, options)),
        sep: orig.sep,
        GLOBSTAR
      });
    };
    minimatch.defaults = defaults;
    braceExpand = (pattern, options = {}) => {
      assertValidPattern(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return (0, import_brace_expansion.default)(pattern);
    };
    minimatch.braceExpand = braceExpand;
    makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
    minimatch.makeRe = makeRe;
    match = (list, pattern, options = {}) => {
      const mm = new Minimatch(pattern, options);
      list = list.filter((f3) => mm.match(f3));
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    minimatch.match = match;
    globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
    regExpEscape2 = (s3) => s3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    Minimatch = class {
      options;
      set;
      pattern;
      windowsPathsNoEscape;
      nonegate;
      negate;
      comment;
      empty;
      preserveMultipleSlashes;
      partial;
      globSet;
      globParts;
      nocase;
      isWindows;
      platform;
      windowsNoMagicRoot;
      regexp;
      constructor(pattern, options = {}) {
        assertValidPattern(pattern);
        options = options || {};
        this.options = options;
        this.pattern = pattern;
        this.platform = options.platform || defaultPlatform;
        this.isWindows = this.platform === "win32";
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
          return true;
        }
        for (const pattern of this.set) {
          for (const part of pattern) {
            if (typeof part !== "string")
              return true;
          }
        }
        return false;
      }
      debug(..._3) {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        this.globSet = [...new Set(this.braceExpand())];
        if (options.debug) {
          this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        const rawGlobParts = this.globSet.map((s3) => this.slashSplit(s3));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        let set = this.globParts.map((s3, _3, __) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const isUNC = s3[0] === "" && s3[1] === "" && (s3[2] === "?" || !globMagic.test(s3[2])) && !globMagic.test(s3[3]);
            const isDrive = /^[a-z]:/i.test(s3[0]);
            if (isUNC) {
              return [...s3.slice(0, 4), ...s3.slice(4).map((ss) => this.parse(ss))];
            } else if (isDrive) {
              return [s3[0], ...s3.slice(1).map((ss) => this.parse(ss))];
            }
          }
          return s3.map((ss) => this.parse(ss));
        });
        this.debug(this.pattern, set);
        this.set = set.filter((s3) => s3.indexOf(false) === -1);
        if (this.isWindows) {
          for (let i3 = 0; i3 < this.set.length; i3++) {
            const p3 = this.set[i3];
            if (p3[0] === "" && p3[1] === "" && this.globParts[i3][2] === "?" && typeof p3[3] === "string" && /^[a-z]:$/i.test(p3[3])) {
              p3[2] = "?";
            }
          }
        }
        this.debug(this.pattern, this.set);
      }
      // various transforms to equivalent pattern sets that are
      // faster to process in a filesystem walk.  The goal is to
      // eliminate what we can, and push all ** patterns as far
      // to the right as possible, even if it increases the number
      // of patterns that we have to process.
      preprocess(globParts) {
        if (this.options.noglobstar) {
          for (let i3 = 0; i3 < globParts.length; i3++) {
            for (let j3 = 0; j3 < globParts[i3].length; j3++) {
              if (globParts[i3][j3] === "**") {
                globParts[i3][j3] = "*";
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          globParts = this.firstPhasePreProcess(globParts);
          globParts = this.secondPhasePreProcess(globParts);
        } else if (optimizationLevel >= 1) {
          globParts = this.levelOneOptimize(globParts);
        } else {
          globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
      }
      // just get rid of adjascent ** portions
      adjascentGlobstarOptimize(globParts) {
        return globParts.map((parts) => {
          let gs = -1;
          while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
            let i3 = gs;
            while (parts[i3 + 1] === "**") {
              i3++;
            }
            if (i3 !== gs) {
              parts.splice(gs, i3 - gs);
            }
          }
          return parts;
        });
      }
      // get rid of adjascent ** and resolve .. portions
      levelOneOptimize(globParts) {
        return globParts.map((parts) => {
          parts = parts.reduce((set, part) => {
            const prev = set[set.length - 1];
            if (part === "**" && prev === "**") {
              return set;
            }
            if (part === "..") {
              if (prev && prev !== ".." && prev !== "." && prev !== "**") {
                set.pop();
                return set;
              }
            }
            set.push(part);
            return set;
          }, []);
          return parts.length === 0 ? [""] : parts;
        });
      }
      levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
          parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
          didSomething = false;
          if (!this.preserveMultipleSlashes) {
            for (let i3 = 1; i3 < parts.length - 1; i3++) {
              const p3 = parts[i3];
              if (i3 === 1 && p3 === "" && parts[0] === "")
                continue;
              if (p3 === "." || p3 === "") {
                didSomething = true;
                parts.splice(i3, 1);
                i3--;
              }
            }
            if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
              didSomething = true;
              parts.pop();
            }
          }
          let dd = 0;
          while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
            const p3 = parts[dd - 1];
            if (p3 && p3 !== "." && p3 !== ".." && p3 !== "**") {
              didSomething = true;
              parts.splice(dd - 1, 2);
              dd -= 2;
            }
          }
        } while (didSomething);
        return parts.length === 0 ? [""] : parts;
      }
      // First phase: single-pattern processing
      // <pre> is 1 or more portions
      // <rest> is 1 or more portions
      // <p> is any portion other than ., .., '', or **
      // <e> is . or ''
      //
      // **/.. is *brutal* for filesystem walking performance, because
      // it effectively resets the recursive walk each time it occurs,
      // and ** cannot be reduced out by a .. pattern part like a regexp
      // or most strings (other than .., ., and '') can be.
      //
      // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
      // <pre>/<e>/<rest> -> <pre>/<rest>
      // <pre>/<p>/../<rest> -> <pre>/<rest>
      // **/**/<rest> -> **/<rest>
      //
      // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
      // this WOULD be allowed if ** did follow symlinks, or * didn't
      firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
          didSomething = false;
          for (let parts of globParts) {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
              let gss = gs;
              while (parts[gss + 1] === "**") {
                gss++;
              }
              if (gss > gs) {
                parts.splice(gs + 1, gss - gs);
              }
              let next = parts[gs + 1];
              const p3 = parts[gs + 2];
              const p22 = parts[gs + 3];
              if (next !== "..")
                continue;
              if (!p3 || p3 === "." || p3 === ".." || !p22 || p22 === "." || p22 === "..") {
                continue;
              }
              didSomething = true;
              parts.splice(gs, 1);
              const other = parts.slice(0);
              other[gs] = "**";
              globParts.push(other);
              gs--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let i3 = 1; i3 < parts.length - 1; i3++) {
                const p3 = parts[i3];
                if (i3 === 1 && p3 === "" && parts[0] === "")
                  continue;
                if (p3 === "." || p3 === "") {
                  didSomething = true;
                  parts.splice(i3, 1);
                  i3--;
                }
              }
              if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
                didSomething = true;
                parts.pop();
              }
            }
            let dd = 0;
            while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
              const p3 = parts[dd - 1];
              if (p3 && p3 !== "." && p3 !== ".." && p3 !== "**") {
                didSomething = true;
                const needDot = dd === 1 && parts[dd + 1] === "**";
                const splin = needDot ? ["."] : [];
                parts.splice(dd - 1, 2, ...splin);
                if (parts.length === 0)
                  parts.push("");
                dd -= 2;
              }
            }
          }
        } while (didSomething);
        return globParts;
      }
      // second phase: multi-pattern dedupes
      // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
      // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
      // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
      //
      // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
      // ^-- not valid because ** doens't follow symlinks
      secondPhasePreProcess(globParts) {
        for (let i3 = 0; i3 < globParts.length - 1; i3++) {
          for (let j3 = i3 + 1; j3 < globParts.length; j3++) {
            const matched = this.partsMatch(globParts[i3], globParts[j3], !this.preserveMultipleSlashes);
            if (matched) {
              globParts[i3] = [];
              globParts[j3] = matched;
              break;
            }
          }
        }
        return globParts.filter((gs) => gs.length);
      }
      partsMatch(a3, b3, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result3 = [];
        let which = "";
        while (ai < a3.length && bi < b3.length) {
          if (a3[ai] === b3[bi]) {
            result3.push(which === "b" ? b3[bi] : a3[ai]);
            ai++;
            bi++;
          } else if (emptyGSMatch && a3[ai] === "**" && b3[bi] === a3[ai + 1]) {
            result3.push(a3[ai]);
            ai++;
          } else if (emptyGSMatch && b3[bi] === "**" && a3[ai] === b3[bi + 1]) {
            result3.push(b3[bi]);
            bi++;
          } else if (a3[ai] === "*" && b3[bi] && (this.options.dot || !b3[bi].startsWith(".")) && b3[bi] !== "**") {
            if (which === "b")
              return false;
            which = "a";
            result3.push(a3[ai]);
            ai++;
            bi++;
          } else if (b3[bi] === "*" && a3[ai] && (this.options.dot || !a3[ai].startsWith(".")) && a3[ai] !== "**") {
            if (which === "a")
              return false;
            which = "b";
            result3.push(b3[bi]);
            ai++;
            bi++;
          } else {
            return false;
          }
        }
        return a3.length === b3.length && result3;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i3 = 0; i3 < pattern.length && pattern.charAt(i3) === "!"; i3++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset)
          this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial = false) {
        const options = this.options;
        if (this.isWindows) {
          const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
          const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
          const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
          const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
          const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
          const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
          if (typeof fdi === "number" && typeof pdi === "number") {
            const [fd, pd] = [file[fdi], pattern[pdi]];
            if (fd.toLowerCase() === pd.toLowerCase()) {
              pattern[pdi] = fd;
              if (pdi > fdi) {
                pattern = pattern.slice(pdi);
              } else if (fdi > pdi) {
                file = file.slice(fdi);
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          file = this.levelTwoFileOptimize(file);
        }
        this.debug("matchOne", this, { file, pattern });
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
          this.debug("matchOne loop");
          var p3 = pattern[pi];
          var f3 = file[fi];
          this.debug(pattern, p3, f3);
          if (p3 === false) {
            return false;
          }
          if (p3 === GLOBSTAR) {
            this.debug("GLOBSTAR", [pattern, p3, f3]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                  return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) {
                return true;
              }
            }
            return false;
          }
          let hit;
          if (typeof p3 === "string") {
            hit = f3 === p3;
            this.debug("string match", p3, f3, hit);
          } else {
            hit = p3.test(f3);
            this.debug("pattern match", p3, f3, hit);
          }
          if (!hit)
            return false;
        }
        if (fi === fl && pi === pl) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl) {
          return fi === fl - 1 && file[fi] === "";
        } else {
          throw new Error("wtf?");
        }
      }
      braceExpand() {
        return braceExpand(this.pattern, this.options);
      }
      parse(pattern) {
        assertValidPattern(pattern);
        const options = this.options;
        if (pattern === "**")
          return GLOBSTAR;
        if (pattern === "")
          return "";
        let m3;
        let fastTest = null;
        if (m3 = pattern.match(starRE)) {
          fastTest = options.dot ? starTestDot : starTest;
        } else if (m3 = pattern.match(starDotExtRE)) {
          fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m3[1]);
        } else if (m3 = pattern.match(qmarksRE)) {
          fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m3);
        } else if (m3 = pattern.match(starDotStarRE)) {
          fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
        } else if (m3 = pattern.match(dotStarRE)) {
          fastTest = dotStarTest;
        }
        const re = AST.fromGlob(pattern, this.options).toMMPattern();
        if (fastTest && typeof re === "object") {
          Reflect.defineProperty(re, "test", { value: fastTest });
        }
        return re;
      }
      makeRe() {
        if (this.regexp || this.regexp === false)
          return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star2 : options.dot ? twoStarDot : twoStarNoDot;
        const flags = new Set(options.nocase ? ["i"] : []);
        let re = set.map((pattern) => {
          const pp = pattern.map((p3) => {
            if (p3 instanceof RegExp) {
              for (const f3 of p3.flags.split(""))
                flags.add(f3);
            }
            return typeof p3 === "string" ? regExpEscape2(p3) : p3 === GLOBSTAR ? GLOBSTAR : p3._src;
          });
          pp.forEach((p3, i3) => {
            const next = pp[i3 + 1];
            const prev = pp[i3 - 1];
            if (p3 !== GLOBSTAR || prev === GLOBSTAR) {
              return;
            }
            if (prev === void 0) {
              if (next !== void 0 && next !== GLOBSTAR) {
                pp[i3 + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
              } else {
                pp[i3] = twoStar;
              }
            } else if (next === void 0) {
              pp[i3 - 1] = prev + "(?:\\/|" + twoStar + ")?";
            } else if (next !== GLOBSTAR) {
              pp[i3 - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
              pp[i3 + 1] = GLOBSTAR;
            }
          });
          return pp.filter((p3) => p3 !== GLOBSTAR).join("/");
        }).join("|");
        const [open, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
        re = "^" + open + re + close + "$";
        if (this.negate)
          re = "^(?!" + re + ").+$";
        try {
          this.regexp = new RegExp(re, [...flags].join(""));
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(p3) {
        if (this.preserveMultipleSlashes) {
          return p3.split("/");
        } else if (this.isWindows && /^\/\/[^\/]+/.test(p3)) {
          return ["", ...p3.split(/\/+/)];
        } else {
          return p3.split(/\/+/);
        }
      }
      match(f3, partial = this.partial) {
        this.debug("match", f3, this.pattern);
        if (this.comment) {
          return false;
        }
        if (this.empty) {
          return f3 === "";
        }
        if (f3 === "/" && partial) {
          return true;
        }
        const options = this.options;
        if (this.isWindows) {
          f3 = f3.split("\\").join("/");
        }
        const ff = this.slashSplit(f3);
        this.debug(this.pattern, "split", ff);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename = ff[ff.length - 1];
        if (!filename) {
          for (let i3 = ff.length - 2; !filename && i3 >= 0; i3--) {
            filename = ff[i3];
          }
        }
        for (let i3 = 0; i3 < set.length; i3++) {
          const pattern = set[i3];
          let file = ff;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) {
              return true;
            }
            return !this.negate;
          }
        }
        if (options.flipNegate) {
          return false;
        }
        return this.negate;
      }
      static defaults(def) {
        return minimatch.defaults(def).Minimatch;
      }
    };
    minimatch.AST = AST;
    minimatch.Minimatch = Minimatch;
    minimatch.escape = escape;
    minimatch.unescape = unescape2;
  }
});

// ../../node_modules/path-scurry/node_modules/lru-cache/dist/esm/index.js
var perf, warned, PROCESS, emitWarning, AC, AS, _a, shouldWarn, TYPE, isPosInt, getUintArray, ZeroArray, Stack, _a2, _b, _max, _maxSize, _dispose, _onInsert, _disposeAfter, _fetchMethod, _memoMethod, _size, _calculatedSize, _keyMap, _keyList, _valList, _next, _prev, _head, _tail, _free, _disposed, _sizes, _starts, _ttls, _hasDispose, _hasFetchMethod, _hasDisposeAfter, _hasOnInsert, _LRUCache_instances, initializeTTLTracking_fn, _updateItemAge, _statusTTL, _setItemTTL, _isStale, initializeSizeTracking_fn, _removeItemSize, _addItemSize, _requireSize, indexes_fn, rindexes_fn, isValidIndex_fn, evict_fn, backgroundFetch_fn, isBackgroundFetch_fn, connect_fn, moveToTail_fn, delete_fn, clear_fn, _LRUCache, LRUCache;
var init_esm2 = __esm({
  "../../node_modules/path-scurry/node_modules/lru-cache/dist/esm/index.js"() {
    perf = typeof performance === "object" && performance && typeof performance.now === "function" ? performance : Date;
    warned = /* @__PURE__ */ new Set();
    PROCESS = typeof process === "object" && !!process ? process : {};
    emitWarning = (msg, type, code, fn) => {
      typeof PROCESS.emitWarning === "function" ? PROCESS.emitWarning(msg, type, code, fn) : console.error(`[${code}] ${type}: ${msg}`);
    };
    AC = globalThis.AbortController;
    AS = globalThis.AbortSignal;
    if (typeof AC === "undefined") {
      AS = class AbortSignal {
        onabort;
        _onabort = [];
        reason;
        aborted = false;
        addEventListener(_3, fn) {
          this._onabort.push(fn);
        }
      };
      AC = class AbortController {
        constructor() {
          warnACPolyfill();
        }
        signal = new AS();
        abort(reason) {
          var _a4, _b2;
          if (this.signal.aborted)
            return;
          this.signal.reason = reason;
          this.signal.aborted = true;
          for (const fn of this.signal._onabort) {
            fn(reason);
          }
          (_b2 = (_a4 = this.signal).onabort) == null ? void 0 : _b2.call(_a4, reason);
        }
      };
      let printACPolyfillWarning = ((_a = PROCESS.env) == null ? void 0 : _a.LRU_CACHE_IGNORE_AC_WARNING) !== "1";
      const warnACPolyfill = () => {
        if (!printACPolyfillWarning)
          return;
        printACPolyfillWarning = false;
        emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.", "NO_ABORT_CONTROLLER", "ENOTSUP", warnACPolyfill);
      };
    }
    shouldWarn = (code) => !warned.has(code);
    TYPE = Symbol("type");
    isPosInt = (n3) => n3 && n3 === Math.floor(n3) && n3 > 0 && isFinite(n3);
    getUintArray = (max) => !isPosInt(max) ? null : max <= Math.pow(2, 8) ? Uint8Array : max <= Math.pow(2, 16) ? Uint16Array : max <= Math.pow(2, 32) ? Uint32Array : max <= Number.MAX_SAFE_INTEGER ? ZeroArray : null;
    ZeroArray = class extends Array {
      constructor(size) {
        super(size);
        this.fill(0);
      }
    };
    Stack = class _Stack {
      heap;
      length;
      // private constructor
      static #constructing = false;
      static create(max) {
        const HeapCls = getUintArray(max);
        if (!HeapCls)
          return [];
        _Stack.#constructing = true;
        const s3 = new _Stack(max, HeapCls);
        _Stack.#constructing = false;
        return s3;
      }
      constructor(max, HeapCls) {
        if (!_Stack.#constructing) {
          throw new TypeError("instantiate Stack using Stack.create(n)");
        }
        this.heap = new HeapCls(max);
        this.length = 0;
      }
      push(n3) {
        this.heap[this.length++] = n3;
      }
      pop() {
        return this.heap[--this.length];
      }
    };
    _LRUCache = class _LRUCache {
      constructor(options) {
        __privateAdd(this, _LRUCache_instances);
        // options that cannot be changed without disaster
        __privateAdd(this, _max);
        __privateAdd(this, _maxSize);
        __privateAdd(this, _dispose);
        __privateAdd(this, _onInsert);
        __privateAdd(this, _disposeAfter);
        __privateAdd(this, _fetchMethod);
        __privateAdd(this, _memoMethod);
        /**
         * {@link LRUCache.OptionsBase.ttl}
         */
        __publicField(this, "ttl");
        /**
         * {@link LRUCache.OptionsBase.ttlResolution}
         */
        __publicField(this, "ttlResolution");
        /**
         * {@link LRUCache.OptionsBase.ttlAutopurge}
         */
        __publicField(this, "ttlAutopurge");
        /**
         * {@link LRUCache.OptionsBase.updateAgeOnGet}
         */
        __publicField(this, "updateAgeOnGet");
        /**
         * {@link LRUCache.OptionsBase.updateAgeOnHas}
         */
        __publicField(this, "updateAgeOnHas");
        /**
         * {@link LRUCache.OptionsBase.allowStale}
         */
        __publicField(this, "allowStale");
        /**
         * {@link LRUCache.OptionsBase.noDisposeOnSet}
         */
        __publicField(this, "noDisposeOnSet");
        /**
         * {@link LRUCache.OptionsBase.noUpdateTTL}
         */
        __publicField(this, "noUpdateTTL");
        /**
         * {@link LRUCache.OptionsBase.maxEntrySize}
         */
        __publicField(this, "maxEntrySize");
        /**
         * {@link LRUCache.OptionsBase.sizeCalculation}
         */
        __publicField(this, "sizeCalculation");
        /**
         * {@link LRUCache.OptionsBase.noDeleteOnFetchRejection}
         */
        __publicField(this, "noDeleteOnFetchRejection");
        /**
         * {@link LRUCache.OptionsBase.noDeleteOnStaleGet}
         */
        __publicField(this, "noDeleteOnStaleGet");
        /**
         * {@link LRUCache.OptionsBase.allowStaleOnFetchAbort}
         */
        __publicField(this, "allowStaleOnFetchAbort");
        /**
         * {@link LRUCache.OptionsBase.allowStaleOnFetchRejection}
         */
        __publicField(this, "allowStaleOnFetchRejection");
        /**
         * {@link LRUCache.OptionsBase.ignoreFetchAbort}
         */
        __publicField(this, "ignoreFetchAbort");
        // computed properties
        __privateAdd(this, _size);
        __privateAdd(this, _calculatedSize);
        __privateAdd(this, _keyMap);
        __privateAdd(this, _keyList);
        __privateAdd(this, _valList);
        __privateAdd(this, _next);
        __privateAdd(this, _prev);
        __privateAdd(this, _head);
        __privateAdd(this, _tail);
        __privateAdd(this, _free);
        __privateAdd(this, _disposed);
        __privateAdd(this, _sizes);
        __privateAdd(this, _starts);
        __privateAdd(this, _ttls);
        __privateAdd(this, _hasDispose);
        __privateAdd(this, _hasFetchMethod);
        __privateAdd(this, _hasDisposeAfter);
        __privateAdd(this, _hasOnInsert);
        // conditionally set private methods related to TTL
        __privateAdd(this, _updateItemAge, () => {
        });
        __privateAdd(this, _statusTTL, () => {
        });
        __privateAdd(this, _setItemTTL, () => {
        });
        /* c8 ignore stop */
        __privateAdd(this, _isStale, () => false);
        __privateAdd(this, _removeItemSize, (_i) => {
        });
        __privateAdd(this, _addItemSize, (_i, _s, _st) => {
        });
        __privateAdd(this, _requireSize, (_k, _v, size, sizeCalculation) => {
          if (size || sizeCalculation) {
            throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");
          }
          return 0;
        });
        /**
         * A String value that is used in the creation of the default string
         * description of an object. Called by the built-in method
         * `Object.prototype.toString`.
         */
        __publicField(this, _a2, "LRUCache");
        const { max = 0, ttl, ttlResolution = 1, ttlAutopurge, updateAgeOnGet, updateAgeOnHas, allowStale, dispose, onInsert, disposeAfter, noDisposeOnSet, noUpdateTTL, maxSize = 0, maxEntrySize = 0, sizeCalculation, fetchMethod, memoMethod, noDeleteOnFetchRejection, noDeleteOnStaleGet, allowStaleOnFetchRejection, allowStaleOnFetchAbort, ignoreFetchAbort } = options;
        if (max !== 0 && !isPosInt(max)) {
          throw new TypeError("max option must be a nonnegative integer");
        }
        const UintArray = max ? getUintArray(max) : Array;
        if (!UintArray) {
          throw new Error("invalid max value: " + max);
        }
        __privateSet(this, _max, max);
        __privateSet(this, _maxSize, maxSize);
        this.maxEntrySize = maxEntrySize || __privateGet(this, _maxSize);
        this.sizeCalculation = sizeCalculation;
        if (this.sizeCalculation) {
          if (!__privateGet(this, _maxSize) && !this.maxEntrySize) {
            throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");
          }
          if (typeof this.sizeCalculation !== "function") {
            throw new TypeError("sizeCalculation set to non-function");
          }
        }
        if (memoMethod !== void 0 && typeof memoMethod !== "function") {
          throw new TypeError("memoMethod must be a function if defined");
        }
        __privateSet(this, _memoMethod, memoMethod);
        if (fetchMethod !== void 0 && typeof fetchMethod !== "function") {
          throw new TypeError("fetchMethod must be a function if specified");
        }
        __privateSet(this, _fetchMethod, fetchMethod);
        __privateSet(this, _hasFetchMethod, !!fetchMethod);
        __privateSet(this, _keyMap, /* @__PURE__ */ new Map());
        __privateSet(this, _keyList, new Array(max).fill(void 0));
        __privateSet(this, _valList, new Array(max).fill(void 0));
        __privateSet(this, _next, new UintArray(max));
        __privateSet(this, _prev, new UintArray(max));
        __privateSet(this, _head, 0);
        __privateSet(this, _tail, 0);
        __privateSet(this, _free, Stack.create(max));
        __privateSet(this, _size, 0);
        __privateSet(this, _calculatedSize, 0);
        if (typeof dispose === "function") {
          __privateSet(this, _dispose, dispose);
        }
        if (typeof onInsert === "function") {
          __privateSet(this, _onInsert, onInsert);
        }
        if (typeof disposeAfter === "function") {
          __privateSet(this, _disposeAfter, disposeAfter);
          __privateSet(this, _disposed, []);
        } else {
          __privateSet(this, _disposeAfter, void 0);
          __privateSet(this, _disposed, void 0);
        }
        __privateSet(this, _hasDispose, !!__privateGet(this, _dispose));
        __privateSet(this, _hasOnInsert, !!__privateGet(this, _onInsert));
        __privateSet(this, _hasDisposeAfter, !!__privateGet(this, _disposeAfter));
        this.noDisposeOnSet = !!noDisposeOnSet;
        this.noUpdateTTL = !!noUpdateTTL;
        this.noDeleteOnFetchRejection = !!noDeleteOnFetchRejection;
        this.allowStaleOnFetchRejection = !!allowStaleOnFetchRejection;
        this.allowStaleOnFetchAbort = !!allowStaleOnFetchAbort;
        this.ignoreFetchAbort = !!ignoreFetchAbort;
        if (this.maxEntrySize !== 0) {
          if (__privateGet(this, _maxSize) !== 0) {
            if (!isPosInt(__privateGet(this, _maxSize))) {
              throw new TypeError("maxSize must be a positive integer if specified");
            }
          }
          if (!isPosInt(this.maxEntrySize)) {
            throw new TypeError("maxEntrySize must be a positive integer if specified");
          }
          __privateMethod(this, _LRUCache_instances, initializeSizeTracking_fn).call(this);
        }
        this.allowStale = !!allowStale;
        this.noDeleteOnStaleGet = !!noDeleteOnStaleGet;
        this.updateAgeOnGet = !!updateAgeOnGet;
        this.updateAgeOnHas = !!updateAgeOnHas;
        this.ttlResolution = isPosInt(ttlResolution) || ttlResolution === 0 ? ttlResolution : 1;
        this.ttlAutopurge = !!ttlAutopurge;
        this.ttl = ttl || 0;
        if (this.ttl) {
          if (!isPosInt(this.ttl)) {
            throw new TypeError("ttl must be a positive integer if specified");
          }
          __privateMethod(this, _LRUCache_instances, initializeTTLTracking_fn).call(this);
        }
        if (__privateGet(this, _max) === 0 && this.ttl === 0 && __privateGet(this, _maxSize) === 0) {
          throw new TypeError("At least one of max, maxSize, or ttl is required");
        }
        if (!this.ttlAutopurge && !__privateGet(this, _max) && !__privateGet(this, _maxSize)) {
          const code = "LRU_CACHE_UNBOUNDED";
          if (shouldWarn(code)) {
            warned.add(code);
            const msg = "TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.";
            emitWarning(msg, "UnboundedCacheWarning", code, _LRUCache);
          }
        }
      }
      /**
       * Do not call this method unless you need to inspect the
       * inner workings of the cache.  If anything returned by this
       * object is modified in any way, strange breakage may occur.
       *
       * These fields are private for a reason!
       *
       * @internal
       */
      static unsafeExposeInternals(c3) {
        return {
          // properties
          starts: __privateGet(c3, _starts),
          ttls: __privateGet(c3, _ttls),
          sizes: __privateGet(c3, _sizes),
          keyMap: __privateGet(c3, _keyMap),
          keyList: __privateGet(c3, _keyList),
          valList: __privateGet(c3, _valList),
          next: __privateGet(c3, _next),
          prev: __privateGet(c3, _prev),
          get head() {
            return __privateGet(c3, _head);
          },
          get tail() {
            return __privateGet(c3, _tail);
          },
          free: __privateGet(c3, _free),
          // methods
          isBackgroundFetch: (p3) => {
            var _a4;
            return __privateMethod(_a4 = c3, _LRUCache_instances, isBackgroundFetch_fn).call(_a4, p3);
          },
          backgroundFetch: (k3, index, options, context) => {
            var _a4;
            return __privateMethod(_a4 = c3, _LRUCache_instances, backgroundFetch_fn).call(_a4, k3, index, options, context);
          },
          moveToTail: (index) => {
            var _a4;
            return __privateMethod(_a4 = c3, _LRUCache_instances, moveToTail_fn).call(_a4, index);
          },
          indexes: (options) => {
            var _a4;
            return __privateMethod(_a4 = c3, _LRUCache_instances, indexes_fn).call(_a4, options);
          },
          rindexes: (options) => {
            var _a4;
            return __privateMethod(_a4 = c3, _LRUCache_instances, rindexes_fn).call(_a4, options);
          },
          isStale: (index) => {
            var _a4;
            return __privateGet(_a4 = c3, _isStale).call(_a4, index);
          }
        };
      }
      // Protected read-only members
      /**
       * {@link LRUCache.OptionsBase.max} (read-only)
       */
      get max() {
        return __privateGet(this, _max);
      }
      /**
       * {@link LRUCache.OptionsBase.maxSize} (read-only)
       */
      get maxSize() {
        return __privateGet(this, _maxSize);
      }
      /**
       * The total computed size of items in the cache (read-only)
       */
      get calculatedSize() {
        return __privateGet(this, _calculatedSize);
      }
      /**
       * The number of items stored in the cache (read-only)
       */
      get size() {
        return __privateGet(this, _size);
      }
      /**
       * {@link LRUCache.OptionsBase.fetchMethod} (read-only)
       */
      get fetchMethod() {
        return __privateGet(this, _fetchMethod);
      }
      get memoMethod() {
        return __privateGet(this, _memoMethod);
      }
      /**
       * {@link LRUCache.OptionsBase.dispose} (read-only)
       */
      get dispose() {
        return __privateGet(this, _dispose);
      }
      /**
       * {@link LRUCache.OptionsBase.onInsert} (read-only)
       */
      get onInsert() {
        return __privateGet(this, _onInsert);
      }
      /**
       * {@link LRUCache.OptionsBase.disposeAfter} (read-only)
       */
      get disposeAfter() {
        return __privateGet(this, _disposeAfter);
      }
      /**
       * Return the number of ms left in the item's TTL. If item is not in cache,
       * returns `0`. Returns `Infinity` if item is in cache without a defined TTL.
       */
      getRemainingTTL(key) {
        return __privateGet(this, _keyMap).has(key) ? Infinity : 0;
      }
      /**
       * Return a generator yielding `[key, value]` pairs,
       * in order from most recently used to least recently used.
       */
      *entries() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this)) {
          if (__privateGet(this, _valList)[i3] !== void 0 && __privateGet(this, _keyList)[i3] !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield [__privateGet(this, _keyList)[i3], __privateGet(this, _valList)[i3]];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.entries}
       *
       * Return a generator yielding `[key, value]` pairs,
       * in order from least recently used to most recently used.
       */
      *rentries() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this)) {
          if (__privateGet(this, _valList)[i3] !== void 0 && __privateGet(this, _keyList)[i3] !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield [__privateGet(this, _keyList)[i3], __privateGet(this, _valList)[i3]];
          }
        }
      }
      /**
       * Return a generator yielding the keys in the cache,
       * in order from most recently used to least recently used.
       */
      *keys() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this)) {
          const k3 = __privateGet(this, _keyList)[i3];
          if (k3 !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield k3;
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.keys}
       *
       * Return a generator yielding the keys in the cache,
       * in order from least recently used to most recently used.
       */
      *rkeys() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this)) {
          const k3 = __privateGet(this, _keyList)[i3];
          if (k3 !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield k3;
          }
        }
      }
      /**
       * Return a generator yielding the values in the cache,
       * in order from most recently used to least recently used.
       */
      *values() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this)) {
          const v6 = __privateGet(this, _valList)[i3];
          if (v6 !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield __privateGet(this, _valList)[i3];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.values}
       *
       * Return a generator yielding the values in the cache,
       * in order from least recently used to most recently used.
       */
      *rvalues() {
        for (const i3 of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this)) {
          const v6 = __privateGet(this, _valList)[i3];
          if (v6 !== void 0 && !__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, __privateGet(this, _valList)[i3])) {
            yield __privateGet(this, _valList)[i3];
          }
        }
      }
      /**
       * Iterating over the cache itself yields the same results as
       * {@link LRUCache.entries}
       */
      [(_b = Symbol.iterator, _a2 = Symbol.toStringTag, _b)]() {
        return this.entries();
      }
      /**
       * Find a value for which the supplied fn method returns a truthy value,
       * similar to `Array.find()`. fn is called as `fn(value, key, cache)`.
       */
      find(fn, getOptions = {}) {
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this)) {
          const v6 = __privateGet(this, _valList)[i3];
          const value = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
          if (value === void 0)
            continue;
          if (fn(value, __privateGet(this, _keyList)[i3], this)) {
            return this.get(__privateGet(this, _keyList)[i3], getOptions);
          }
        }
      }
      /**
       * Call the supplied function on each item in the cache, in order from most
       * recently used to least recently used.
       *
       * `fn` is called as `fn(value, key, cache)`.
       *
       * If `thisp` is provided, function will be called in the `this`-context of
       * the provided object, or the cache if no `thisp` object is provided.
       *
       * Does not update age or recenty of use, or iterate over stale values.
       */
      forEach(fn, thisp = this) {
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this)) {
          const v6 = __privateGet(this, _valList)[i3];
          const value = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
          if (value === void 0)
            continue;
          fn.call(thisp, value, __privateGet(this, _keyList)[i3], this);
        }
      }
      /**
       * The same as {@link LRUCache.forEach} but items are iterated over in
       * reverse order.  (ie, less recently used items are iterated over first.)
       */
      rforEach(fn, thisp = this) {
        for (const i3 of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this)) {
          const v6 = __privateGet(this, _valList)[i3];
          const value = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
          if (value === void 0)
            continue;
          fn.call(thisp, value, __privateGet(this, _keyList)[i3], this);
        }
      }
      /**
       * Delete any stale entries. Returns true if anything was removed,
       * false otherwise.
       */
      purgeStale() {
        let deleted = false;
        for (const i3 of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this, { allowStale: true })) {
          if (__privateGet(this, _isStale).call(this, i3)) {
            __privateMethod(this, _LRUCache_instances, delete_fn).call(this, __privateGet(this, _keyList)[i3], "expire");
            deleted = true;
          }
        }
        return deleted;
      }
      /**
       * Get the extended info about a given entry, to get its value, size, and
       * TTL info simultaneously. Returns `undefined` if the key is not present.
       *
       * Unlike {@link LRUCache#dump}, which is designed to be portable and survive
       * serialization, the `start` value is always the current timestamp, and the
       * `ttl` is a calculated remaining time to live (negative if expired).
       *
       * Always returns stale values, if their info is found in the cache, so be
       * sure to check for expirations (ie, a negative {@link LRUCache.Entry#ttl})
       * if relevant.
       */
      info(key) {
        const i3 = __privateGet(this, _keyMap).get(key);
        if (i3 === void 0)
          return void 0;
        const v6 = __privateGet(this, _valList)[i3];
        const value = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
        if (value === void 0)
          return void 0;
        const entry = { value };
        if (__privateGet(this, _ttls) && __privateGet(this, _starts)) {
          const ttl = __privateGet(this, _ttls)[i3];
          const start = __privateGet(this, _starts)[i3];
          if (ttl && start) {
            const remain = ttl - (perf.now() - start);
            entry.ttl = remain;
            entry.start = Date.now();
          }
        }
        if (__privateGet(this, _sizes)) {
          entry.size = __privateGet(this, _sizes)[i3];
        }
        return entry;
      }
      /**
       * Return an array of [key, {@link LRUCache.Entry}] tuples which can be
       * passed to {@link LRUCache#load}.
       *
       * The `start` fields are calculated relative to a portable `Date.now()`
       * timestamp, even if `performance.now()` is available.
       *
       * Stale entries are always included in the `dump`, even if
       * {@link LRUCache.OptionsBase.allowStale} is false.
       *
       * Note: this returns an actual array, not a generator, so it can be more
       * easily passed around.
       */
      dump() {
        const arr = [];
        for (const i3 of __privateMethod(this, _LRUCache_instances, indexes_fn).call(this, { allowStale: true })) {
          const key = __privateGet(this, _keyList)[i3];
          const v6 = __privateGet(this, _valList)[i3];
          const value = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
          if (value === void 0 || key === void 0)
            continue;
          const entry = { value };
          if (__privateGet(this, _ttls) && __privateGet(this, _starts)) {
            entry.ttl = __privateGet(this, _ttls)[i3];
            const age = perf.now() - __privateGet(this, _starts)[i3];
            entry.start = Math.floor(Date.now() - age);
          }
          if (__privateGet(this, _sizes)) {
            entry.size = __privateGet(this, _sizes)[i3];
          }
          arr.unshift([key, entry]);
        }
        return arr;
      }
      /**
       * Reset the cache and load in the items in entries in the order listed.
       *
       * The shape of the resulting cache may be different if the same options are
       * not used in both caches.
       *
       * The `start` fields are assumed to be calculated relative to a portable
       * `Date.now()` timestamp, even if `performance.now()` is available.
       */
      load(arr) {
        this.clear();
        for (const [key, entry] of arr) {
          if (entry.start) {
            const age = Date.now() - entry.start;
            entry.start = perf.now() - age;
          }
          this.set(key, entry.value, entry);
        }
      }
      /**
       * Add a value to the cache.
       *
       * Note: if `undefined` is specified as a value, this is an alias for
       * {@link LRUCache#delete}
       *
       * Fields on the {@link LRUCache.SetOptions} options param will override
       * their corresponding values in the constructor options for the scope
       * of this single `set()` operation.
       *
       * If `start` is provided, then that will set the effective start
       * time for the TTL calculation. Note that this must be a previous
       * value of `performance.now()` if supported, or a previous value of
       * `Date.now()` if not.
       *
       * Options object may also include `size`, which will prevent
       * calling the `sizeCalculation` function and just use the specified
       * number if it is a positive integer, and `noDisposeOnSet` which
       * will prevent calling a `dispose` function in the case of
       * overwrites.
       *
       * If the `size` (or return value of `sizeCalculation`) for a given
       * entry is greater than `maxEntrySize`, then the item will not be
       * added to the cache.
       *
       * Will update the recency of the entry.
       *
       * If the value is `undefined`, then this is an alias for
       * `cache.delete(key)`. `undefined` is never stored in the cache.
       */
      set(k3, v6, setOptions = {}) {
        var _a4, _b2, _c, _d, _e, _f, _g;
        if (v6 === void 0) {
          this.delete(k3);
          return this;
        }
        const { ttl = this.ttl, start, noDisposeOnSet = this.noDisposeOnSet, sizeCalculation = this.sizeCalculation, status } = setOptions;
        let { noUpdateTTL = this.noUpdateTTL } = setOptions;
        const size = __privateGet(this, _requireSize).call(this, k3, v6, setOptions.size || 0, sizeCalculation);
        if (this.maxEntrySize && size > this.maxEntrySize) {
          if (status) {
            status.set = "miss";
            status.maxEntrySizeExceeded = true;
          }
          __privateMethod(this, _LRUCache_instances, delete_fn).call(this, k3, "set");
          return this;
        }
        let index = __privateGet(this, _size) === 0 ? void 0 : __privateGet(this, _keyMap).get(k3);
        if (index === void 0) {
          index = __privateGet(this, _size) === 0 ? __privateGet(this, _tail) : __privateGet(this, _free).length !== 0 ? __privateGet(this, _free).pop() : __privateGet(this, _size) === __privateGet(this, _max) ? __privateMethod(this, _LRUCache_instances, evict_fn).call(this, false) : __privateGet(this, _size);
          __privateGet(this, _keyList)[index] = k3;
          __privateGet(this, _valList)[index] = v6;
          __privateGet(this, _keyMap).set(k3, index);
          __privateGet(this, _next)[__privateGet(this, _tail)] = index;
          __privateGet(this, _prev)[index] = __privateGet(this, _tail);
          __privateSet(this, _tail, index);
          __privateWrapper(this, _size)._++;
          __privateGet(this, _addItemSize).call(this, index, size, status);
          if (status)
            status.set = "add";
          noUpdateTTL = false;
          if (__privateGet(this, _hasOnInsert)) {
            (_a4 = __privateGet(this, _onInsert)) == null ? void 0 : _a4.call(this, v6, k3, "add");
          }
        } else {
          __privateMethod(this, _LRUCache_instances, moveToTail_fn).call(this, index);
          const oldVal = __privateGet(this, _valList)[index];
          if (v6 !== oldVal) {
            if (__privateGet(this, _hasFetchMethod) && __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, oldVal)) {
              oldVal.__abortController.abort(new Error("replaced"));
              const { __staleWhileFetching: s3 } = oldVal;
              if (s3 !== void 0 && !noDisposeOnSet) {
                if (__privateGet(this, _hasDispose)) {
                  (_b2 = __privateGet(this, _dispose)) == null ? void 0 : _b2.call(this, s3, k3, "set");
                }
                if (__privateGet(this, _hasDisposeAfter)) {
                  (_c = __privateGet(this, _disposed)) == null ? void 0 : _c.push([s3, k3, "set"]);
                }
              }
            } else if (!noDisposeOnSet) {
              if (__privateGet(this, _hasDispose)) {
                (_d = __privateGet(this, _dispose)) == null ? void 0 : _d.call(this, oldVal, k3, "set");
              }
              if (__privateGet(this, _hasDisposeAfter)) {
                (_e = __privateGet(this, _disposed)) == null ? void 0 : _e.push([oldVal, k3, "set"]);
              }
            }
            __privateGet(this, _removeItemSize).call(this, index);
            __privateGet(this, _addItemSize).call(this, index, size, status);
            __privateGet(this, _valList)[index] = v6;
            if (status) {
              status.set = "replace";
              const oldValue = oldVal && __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, oldVal) ? oldVal.__staleWhileFetching : oldVal;
              if (oldValue !== void 0)
                status.oldValue = oldValue;
            }
          } else if (status) {
            status.set = "update";
          }
          if (__privateGet(this, _hasOnInsert)) {
            (_f = this.onInsert) == null ? void 0 : _f.call(this, v6, k3, v6 === oldVal ? "update" : "replace");
          }
        }
        if (ttl !== 0 && !__privateGet(this, _ttls)) {
          __privateMethod(this, _LRUCache_instances, initializeTTLTracking_fn).call(this);
        }
        if (__privateGet(this, _ttls)) {
          if (!noUpdateTTL) {
            __privateGet(this, _setItemTTL).call(this, index, ttl, start);
          }
          if (status)
            __privateGet(this, _statusTTL).call(this, status, index);
        }
        if (!noDisposeOnSet && __privateGet(this, _hasDisposeAfter) && __privateGet(this, _disposed)) {
          const dt = __privateGet(this, _disposed);
          let task;
          while (task = dt == null ? void 0 : dt.shift()) {
            (_g = __privateGet(this, _disposeAfter)) == null ? void 0 : _g.call(this, ...task);
          }
        }
        return this;
      }
      /**
       * Evict the least recently used item, returning its value or
       * `undefined` if cache is empty.
       */
      pop() {
        var _a4;
        try {
          while (__privateGet(this, _size)) {
            const val2 = __privateGet(this, _valList)[__privateGet(this, _head)];
            __privateMethod(this, _LRUCache_instances, evict_fn).call(this, true);
            if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, val2)) {
              if (val2.__staleWhileFetching) {
                return val2.__staleWhileFetching;
              }
            } else if (val2 !== void 0) {
              return val2;
            }
          }
        } finally {
          if (__privateGet(this, _hasDisposeAfter) && __privateGet(this, _disposed)) {
            const dt = __privateGet(this, _disposed);
            let task;
            while (task = dt == null ? void 0 : dt.shift()) {
              (_a4 = __privateGet(this, _disposeAfter)) == null ? void 0 : _a4.call(this, ...task);
            }
          }
        }
      }
      /**
       * Check if a key is in the cache, without updating the recency of use.
       * Will return false if the item is stale, even though it is technically
       * in the cache.
       *
       * Check if a key is in the cache, without updating the recency of
       * use. Age is updated if {@link LRUCache.OptionsBase.updateAgeOnHas} is set
       * to `true` in either the options or the constructor.
       *
       * Will return `false` if the item is stale, even though it is technically in
       * the cache. The difference can be determined (if it matters) by using a
       * `status` argument, and inspecting the `has` field.
       *
       * Will not update item age unless
       * {@link LRUCache.OptionsBase.updateAgeOnHas} is set.
       */
      has(k3, hasOptions = {}) {
        const { updateAgeOnHas = this.updateAgeOnHas, status } = hasOptions;
        const index = __privateGet(this, _keyMap).get(k3);
        if (index !== void 0) {
          const v6 = __privateGet(this, _valList)[index];
          if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) && v6.__staleWhileFetching === void 0) {
            return false;
          }
          if (!__privateGet(this, _isStale).call(this, index)) {
            if (updateAgeOnHas) {
              __privateGet(this, _updateItemAge).call(this, index);
            }
            if (status) {
              status.has = "hit";
              __privateGet(this, _statusTTL).call(this, status, index);
            }
            return true;
          } else if (status) {
            status.has = "stale";
            __privateGet(this, _statusTTL).call(this, status, index);
          }
        } else if (status) {
          status.has = "miss";
        }
        return false;
      }
      /**
       * Like {@link LRUCache#get} but doesn't update recency or delete stale
       * items.
       *
       * Returns `undefined` if the item is stale, unless
       * {@link LRUCache.OptionsBase.allowStale} is set.
       */
      peek(k3, peekOptions = {}) {
        const { allowStale = this.allowStale } = peekOptions;
        const index = __privateGet(this, _keyMap).get(k3);
        if (index === void 0 || !allowStale && __privateGet(this, _isStale).call(this, index)) {
          return;
        }
        const v6 = __privateGet(this, _valList)[index];
        return __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6) ? v6.__staleWhileFetching : v6;
      }
      async fetch(k3, fetchOptions = {}) {
        const {
          // get options
          allowStale = this.allowStale,
          updateAgeOnGet = this.updateAgeOnGet,
          noDeleteOnStaleGet = this.noDeleteOnStaleGet,
          // set options
          ttl = this.ttl,
          noDisposeOnSet = this.noDisposeOnSet,
          size = 0,
          sizeCalculation = this.sizeCalculation,
          noUpdateTTL = this.noUpdateTTL,
          // fetch exclusive options
          noDeleteOnFetchRejection = this.noDeleteOnFetchRejection,
          allowStaleOnFetchRejection = this.allowStaleOnFetchRejection,
          ignoreFetchAbort = this.ignoreFetchAbort,
          allowStaleOnFetchAbort = this.allowStaleOnFetchAbort,
          context,
          forceRefresh = false,
          status,
          signal
        } = fetchOptions;
        if (!__privateGet(this, _hasFetchMethod)) {
          if (status)
            status.fetch = "get";
          return this.get(k3, {
            allowStale,
            updateAgeOnGet,
            noDeleteOnStaleGet,
            status
          });
        }
        const options = {
          allowStale,
          updateAgeOnGet,
          noDeleteOnStaleGet,
          ttl,
          noDisposeOnSet,
          size,
          sizeCalculation,
          noUpdateTTL,
          noDeleteOnFetchRejection,
          allowStaleOnFetchRejection,
          allowStaleOnFetchAbort,
          ignoreFetchAbort,
          status,
          signal
        };
        let index = __privateGet(this, _keyMap).get(k3);
        if (index === void 0) {
          if (status)
            status.fetch = "miss";
          const p3 = __privateMethod(this, _LRUCache_instances, backgroundFetch_fn).call(this, k3, index, options, context);
          return p3.__returned = p3;
        } else {
          const v6 = __privateGet(this, _valList)[index];
          if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
            const stale = allowStale && v6.__staleWhileFetching !== void 0;
            if (status) {
              status.fetch = "inflight";
              if (stale)
                status.returnedStale = true;
            }
            return stale ? v6.__staleWhileFetching : v6.__returned = v6;
          }
          const isStale = __privateGet(this, _isStale).call(this, index);
          if (!forceRefresh && !isStale) {
            if (status)
              status.fetch = "hit";
            __privateMethod(this, _LRUCache_instances, moveToTail_fn).call(this, index);
            if (updateAgeOnGet) {
              __privateGet(this, _updateItemAge).call(this, index);
            }
            if (status)
              __privateGet(this, _statusTTL).call(this, status, index);
            return v6;
          }
          const p3 = __privateMethod(this, _LRUCache_instances, backgroundFetch_fn).call(this, k3, index, options, context);
          const hasStale = p3.__staleWhileFetching !== void 0;
          const staleVal = hasStale && allowStale;
          if (status) {
            status.fetch = isStale ? "stale" : "refresh";
            if (staleVal && isStale)
              status.returnedStale = true;
          }
          return staleVal ? p3.__staleWhileFetching : p3.__returned = p3;
        }
      }
      async forceFetch(k3, fetchOptions = {}) {
        const v6 = await this.fetch(k3, fetchOptions);
        if (v6 === void 0)
          throw new Error("fetch() returned undefined");
        return v6;
      }
      memo(k3, memoOptions = {}) {
        const memoMethod = __privateGet(this, _memoMethod);
        if (!memoMethod) {
          throw new Error("no memoMethod provided to constructor");
        }
        const { context, forceRefresh, ...options } = memoOptions;
        const v6 = this.get(k3, options);
        if (!forceRefresh && v6 !== void 0)
          return v6;
        const vv = memoMethod(k3, v6, {
          options,
          context
        });
        this.set(k3, vv, options);
        return vv;
      }
      /**
       * Return a value from the cache. Will update the recency of the cache
       * entry found.
       *
       * If the key is not found, get() will return `undefined`.
       */
      get(k3, getOptions = {}) {
        const { allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, status } = getOptions;
        const index = __privateGet(this, _keyMap).get(k3);
        if (index !== void 0) {
          const value = __privateGet(this, _valList)[index];
          const fetching = __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, value);
          if (status)
            __privateGet(this, _statusTTL).call(this, status, index);
          if (__privateGet(this, _isStale).call(this, index)) {
            if (status)
              status.get = "stale";
            if (!fetching) {
              if (!noDeleteOnStaleGet) {
                __privateMethod(this, _LRUCache_instances, delete_fn).call(this, k3, "expire");
              }
              if (status && allowStale)
                status.returnedStale = true;
              return allowStale ? value : void 0;
            } else {
              if (status && allowStale && value.__staleWhileFetching !== void 0) {
                status.returnedStale = true;
              }
              return allowStale ? value.__staleWhileFetching : void 0;
            }
          } else {
            if (status)
              status.get = "hit";
            if (fetching) {
              return value.__staleWhileFetching;
            }
            __privateMethod(this, _LRUCache_instances, moveToTail_fn).call(this, index);
            if (updateAgeOnGet) {
              __privateGet(this, _updateItemAge).call(this, index);
            }
            return value;
          }
        } else if (status) {
          status.get = "miss";
        }
      }
      /**
       * Deletes a key out of the cache.
       *
       * Returns true if the key was deleted, false otherwise.
       */
      delete(k3) {
        return __privateMethod(this, _LRUCache_instances, delete_fn).call(this, k3, "delete");
      }
      /**
       * Clear the cache entirely, throwing away all values.
       */
      clear() {
        return __privateMethod(this, _LRUCache_instances, clear_fn).call(this, "delete");
      }
    };
    _max = new WeakMap();
    _maxSize = new WeakMap();
    _dispose = new WeakMap();
    _onInsert = new WeakMap();
    _disposeAfter = new WeakMap();
    _fetchMethod = new WeakMap();
    _memoMethod = new WeakMap();
    _size = new WeakMap();
    _calculatedSize = new WeakMap();
    _keyMap = new WeakMap();
    _keyList = new WeakMap();
    _valList = new WeakMap();
    _next = new WeakMap();
    _prev = new WeakMap();
    _head = new WeakMap();
    _tail = new WeakMap();
    _free = new WeakMap();
    _disposed = new WeakMap();
    _sizes = new WeakMap();
    _starts = new WeakMap();
    _ttls = new WeakMap();
    _hasDispose = new WeakMap();
    _hasFetchMethod = new WeakMap();
    _hasDisposeAfter = new WeakMap();
    _hasOnInsert = new WeakMap();
    _LRUCache_instances = new WeakSet();
    initializeTTLTracking_fn = function() {
      const ttls = new ZeroArray(__privateGet(this, _max));
      const starts = new ZeroArray(__privateGet(this, _max));
      __privateSet(this, _ttls, ttls);
      __privateSet(this, _starts, starts);
      __privateSet(this, _setItemTTL, (index, ttl, start = perf.now()) => {
        starts[index] = ttl !== 0 ? start : 0;
        ttls[index] = ttl;
        if (ttl !== 0 && this.ttlAutopurge) {
          const t3 = setTimeout(() => {
            if (__privateGet(this, _isStale).call(this, index)) {
              __privateMethod(this, _LRUCache_instances, delete_fn).call(this, __privateGet(this, _keyList)[index], "expire");
            }
          }, ttl + 1);
          if (t3.unref) {
            t3.unref();
          }
        }
      });
      __privateSet(this, _updateItemAge, (index) => {
        starts[index] = ttls[index] !== 0 ? perf.now() : 0;
      });
      __privateSet(this, _statusTTL, (status, index) => {
        if (ttls[index]) {
          const ttl = ttls[index];
          const start = starts[index];
          if (!ttl || !start)
            return;
          status.ttl = ttl;
          status.start = start;
          status.now = cachedNow || getNow();
          const age = status.now - start;
          status.remainingTTL = ttl - age;
        }
      });
      let cachedNow = 0;
      const getNow = () => {
        const n3 = perf.now();
        if (this.ttlResolution > 0) {
          cachedNow = n3;
          const t3 = setTimeout(() => cachedNow = 0, this.ttlResolution);
          if (t3.unref) {
            t3.unref();
          }
        }
        return n3;
      };
      this.getRemainingTTL = (key) => {
        const index = __privateGet(this, _keyMap).get(key);
        if (index === void 0) {
          return 0;
        }
        const ttl = ttls[index];
        const start = starts[index];
        if (!ttl || !start) {
          return Infinity;
        }
        const age = (cachedNow || getNow()) - start;
        return ttl - age;
      };
      __privateSet(this, _isStale, (index) => {
        const s3 = starts[index];
        const t3 = ttls[index];
        return !!t3 && !!s3 && (cachedNow || getNow()) - s3 > t3;
      });
    };
    _updateItemAge = new WeakMap();
    _statusTTL = new WeakMap();
    _setItemTTL = new WeakMap();
    _isStale = new WeakMap();
    initializeSizeTracking_fn = function() {
      const sizes = new ZeroArray(__privateGet(this, _max));
      __privateSet(this, _calculatedSize, 0);
      __privateSet(this, _sizes, sizes);
      __privateSet(this, _removeItemSize, (index) => {
        __privateSet(this, _calculatedSize, __privateGet(this, _calculatedSize) - sizes[index]);
        sizes[index] = 0;
      });
      __privateSet(this, _requireSize, (k3, v6, size, sizeCalculation) => {
        if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
          return 0;
        }
        if (!isPosInt(size)) {
          if (sizeCalculation) {
            if (typeof sizeCalculation !== "function") {
              throw new TypeError("sizeCalculation must be a function");
            }
            size = sizeCalculation(v6, k3);
            if (!isPosInt(size)) {
              throw new TypeError("sizeCalculation return invalid (expect positive integer)");
            }
          } else {
            throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");
          }
        }
        return size;
      });
      __privateSet(this, _addItemSize, (index, size, status) => {
        sizes[index] = size;
        if (__privateGet(this, _maxSize)) {
          const maxSize = __privateGet(this, _maxSize) - sizes[index];
          while (__privateGet(this, _calculatedSize) > maxSize) {
            __privateMethod(this, _LRUCache_instances, evict_fn).call(this, true);
          }
        }
        __privateSet(this, _calculatedSize, __privateGet(this, _calculatedSize) + sizes[index]);
        if (status) {
          status.entrySize = size;
          status.totalCalculatedSize = __privateGet(this, _calculatedSize);
        }
      });
    };
    _removeItemSize = new WeakMap();
    _addItemSize = new WeakMap();
    _requireSize = new WeakMap();
    indexes_fn = function* ({ allowStale = this.allowStale } = {}) {
      if (__privateGet(this, _size)) {
        for (let i3 = __privateGet(this, _tail); true; ) {
          if (!__privateMethod(this, _LRUCache_instances, isValidIndex_fn).call(this, i3)) {
            break;
          }
          if (allowStale || !__privateGet(this, _isStale).call(this, i3)) {
            yield i3;
          }
          if (i3 === __privateGet(this, _head)) {
            break;
          } else {
            i3 = __privateGet(this, _prev)[i3];
          }
        }
      }
    };
    rindexes_fn = function* ({ allowStale = this.allowStale } = {}) {
      if (__privateGet(this, _size)) {
        for (let i3 = __privateGet(this, _head); true; ) {
          if (!__privateMethod(this, _LRUCache_instances, isValidIndex_fn).call(this, i3)) {
            break;
          }
          if (allowStale || !__privateGet(this, _isStale).call(this, i3)) {
            yield i3;
          }
          if (i3 === __privateGet(this, _tail)) {
            break;
          } else {
            i3 = __privateGet(this, _next)[i3];
          }
        }
      }
    };
    isValidIndex_fn = function(index) {
      return index !== void 0 && __privateGet(this, _keyMap).get(__privateGet(this, _keyList)[index]) === index;
    };
    evict_fn = function(free) {
      var _a4, _b2;
      const head = __privateGet(this, _head);
      const k3 = __privateGet(this, _keyList)[head];
      const v6 = __privateGet(this, _valList)[head];
      if (__privateGet(this, _hasFetchMethod) && __privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
        v6.__abortController.abort(new Error("evicted"));
      } else if (__privateGet(this, _hasDispose) || __privateGet(this, _hasDisposeAfter)) {
        if (__privateGet(this, _hasDispose)) {
          (_a4 = __privateGet(this, _dispose)) == null ? void 0 : _a4.call(this, v6, k3, "evict");
        }
        if (__privateGet(this, _hasDisposeAfter)) {
          (_b2 = __privateGet(this, _disposed)) == null ? void 0 : _b2.push([v6, k3, "evict"]);
        }
      }
      __privateGet(this, _removeItemSize).call(this, head);
      if (free) {
        __privateGet(this, _keyList)[head] = void 0;
        __privateGet(this, _valList)[head] = void 0;
        __privateGet(this, _free).push(head);
      }
      if (__privateGet(this, _size) === 1) {
        __privateSet(this, _head, __privateSet(this, _tail, 0));
        __privateGet(this, _free).length = 0;
      } else {
        __privateSet(this, _head, __privateGet(this, _next)[head]);
      }
      __privateGet(this, _keyMap).delete(k3);
      __privateWrapper(this, _size)._--;
      return head;
    };
    backgroundFetch_fn = function(k3, index, options, context) {
      const v6 = index === void 0 ? void 0 : __privateGet(this, _valList)[index];
      if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
        return v6;
      }
      const ac = new AC();
      const { signal } = options;
      signal == null ? void 0 : signal.addEventListener("abort", () => ac.abort(signal.reason), {
        signal: ac.signal
      });
      const fetchOpts = {
        signal: ac.signal,
        options,
        context
      };
      const cb = (v7, updateCache = false) => {
        const { aborted } = ac.signal;
        const ignoreAbort = options.ignoreFetchAbort && v7 !== void 0;
        if (options.status) {
          if (aborted && !updateCache) {
            options.status.fetchAborted = true;
            options.status.fetchError = ac.signal.reason;
            if (ignoreAbort)
              options.status.fetchAbortIgnored = true;
          } else {
            options.status.fetchResolved = true;
          }
        }
        if (aborted && !ignoreAbort && !updateCache) {
          return fetchFail(ac.signal.reason);
        }
        const bf2 = p3;
        if (__privateGet(this, _valList)[index] === p3) {
          if (v7 === void 0) {
            if (bf2.__staleWhileFetching) {
              __privateGet(this, _valList)[index] = bf2.__staleWhileFetching;
            } else {
              __privateMethod(this, _LRUCache_instances, delete_fn).call(this, k3, "fetch");
            }
          } else {
            if (options.status)
              options.status.fetchUpdated = true;
            this.set(k3, v7, fetchOpts.options);
          }
        }
        return v7;
      };
      const eb = (er) => {
        if (options.status) {
          options.status.fetchRejected = true;
          options.status.fetchError = er;
        }
        return fetchFail(er);
      };
      const fetchFail = (er) => {
        const { aborted } = ac.signal;
        const allowStaleAborted = aborted && options.allowStaleOnFetchAbort;
        const allowStale = allowStaleAborted || options.allowStaleOnFetchRejection;
        const noDelete = allowStale || options.noDeleteOnFetchRejection;
        const bf2 = p3;
        if (__privateGet(this, _valList)[index] === p3) {
          const del = !noDelete || bf2.__staleWhileFetching === void 0;
          if (del) {
            __privateMethod(this, _LRUCache_instances, delete_fn).call(this, k3, "fetch");
          } else if (!allowStaleAborted) {
            __privateGet(this, _valList)[index] = bf2.__staleWhileFetching;
          }
        }
        if (allowStale) {
          if (options.status && bf2.__staleWhileFetching !== void 0) {
            options.status.returnedStale = true;
          }
          return bf2.__staleWhileFetching;
        } else if (bf2.__returned === bf2) {
          throw er;
        }
      };
      const pcall = (res, rej) => {
        var _a4;
        const fmp = (_a4 = __privateGet(this, _fetchMethod)) == null ? void 0 : _a4.call(this, k3, v6, fetchOpts);
        if (fmp && fmp instanceof Promise) {
          fmp.then((v7) => res(v7 === void 0 ? void 0 : v7), rej);
        }
        ac.signal.addEventListener("abort", () => {
          if (!options.ignoreFetchAbort || options.allowStaleOnFetchAbort) {
            res(void 0);
            if (options.allowStaleOnFetchAbort) {
              res = (v7) => cb(v7, true);
            }
          }
        });
      };
      if (options.status)
        options.status.fetchDispatched = true;
      const p3 = new Promise(pcall).then(cb, eb);
      const bf = Object.assign(p3, {
        __abortController: ac,
        __staleWhileFetching: v6,
        __returned: void 0
      });
      if (index === void 0) {
        this.set(k3, bf, { ...fetchOpts.options, status: void 0 });
        index = __privateGet(this, _keyMap).get(k3);
      } else {
        __privateGet(this, _valList)[index] = bf;
      }
      return bf;
    };
    isBackgroundFetch_fn = function(p3) {
      if (!__privateGet(this, _hasFetchMethod))
        return false;
      const b3 = p3;
      return !!b3 && b3 instanceof Promise && b3.hasOwnProperty("__staleWhileFetching") && b3.__abortController instanceof AC;
    };
    connect_fn = function(p3, n3) {
      __privateGet(this, _prev)[n3] = p3;
      __privateGet(this, _next)[p3] = n3;
    };
    moveToTail_fn = function(index) {
      if (index !== __privateGet(this, _tail)) {
        if (index === __privateGet(this, _head)) {
          __privateSet(this, _head, __privateGet(this, _next)[index]);
        } else {
          __privateMethod(this, _LRUCache_instances, connect_fn).call(this, __privateGet(this, _prev)[index], __privateGet(this, _next)[index]);
        }
        __privateMethod(this, _LRUCache_instances, connect_fn).call(this, __privateGet(this, _tail), index);
        __privateSet(this, _tail, index);
      }
    };
    delete_fn = function(k3, reason) {
      var _a4, _b2, _c, _d;
      let deleted = false;
      if (__privateGet(this, _size) !== 0) {
        const index = __privateGet(this, _keyMap).get(k3);
        if (index !== void 0) {
          deleted = true;
          if (__privateGet(this, _size) === 1) {
            __privateMethod(this, _LRUCache_instances, clear_fn).call(this, reason);
          } else {
            __privateGet(this, _removeItemSize).call(this, index);
            const v6 = __privateGet(this, _valList)[index];
            if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
              v6.__abortController.abort(new Error("deleted"));
            } else if (__privateGet(this, _hasDispose) || __privateGet(this, _hasDisposeAfter)) {
              if (__privateGet(this, _hasDispose)) {
                (_a4 = __privateGet(this, _dispose)) == null ? void 0 : _a4.call(this, v6, k3, reason);
              }
              if (__privateGet(this, _hasDisposeAfter)) {
                (_b2 = __privateGet(this, _disposed)) == null ? void 0 : _b2.push([v6, k3, reason]);
              }
            }
            __privateGet(this, _keyMap).delete(k3);
            __privateGet(this, _keyList)[index] = void 0;
            __privateGet(this, _valList)[index] = void 0;
            if (index === __privateGet(this, _tail)) {
              __privateSet(this, _tail, __privateGet(this, _prev)[index]);
            } else if (index === __privateGet(this, _head)) {
              __privateSet(this, _head, __privateGet(this, _next)[index]);
            } else {
              const pi = __privateGet(this, _prev)[index];
              __privateGet(this, _next)[pi] = __privateGet(this, _next)[index];
              const ni = __privateGet(this, _next)[index];
              __privateGet(this, _prev)[ni] = __privateGet(this, _prev)[index];
            }
            __privateWrapper(this, _size)._--;
            __privateGet(this, _free).push(index);
          }
        }
      }
      if (__privateGet(this, _hasDisposeAfter) && ((_c = __privateGet(this, _disposed)) == null ? void 0 : _c.length)) {
        const dt = __privateGet(this, _disposed);
        let task;
        while (task = dt == null ? void 0 : dt.shift()) {
          (_d = __privateGet(this, _disposeAfter)) == null ? void 0 : _d.call(this, ...task);
        }
      }
      return deleted;
    };
    clear_fn = function(reason) {
      var _a4, _b2, _c;
      for (const index of __privateMethod(this, _LRUCache_instances, rindexes_fn).call(this, { allowStale: true })) {
        const v6 = __privateGet(this, _valList)[index];
        if (__privateMethod(this, _LRUCache_instances, isBackgroundFetch_fn).call(this, v6)) {
          v6.__abortController.abort(new Error("deleted"));
        } else {
          const k3 = __privateGet(this, _keyList)[index];
          if (__privateGet(this, _hasDispose)) {
            (_a4 = __privateGet(this, _dispose)) == null ? void 0 : _a4.call(this, v6, k3, reason);
          }
          if (__privateGet(this, _hasDisposeAfter)) {
            (_b2 = __privateGet(this, _disposed)) == null ? void 0 : _b2.push([v6, k3, reason]);
          }
        }
      }
      __privateGet(this, _keyMap).clear();
      __privateGet(this, _valList).fill(void 0);
      __privateGet(this, _keyList).fill(void 0);
      if (__privateGet(this, _ttls) && __privateGet(this, _starts)) {
        __privateGet(this, _ttls).fill(0);
        __privateGet(this, _starts).fill(0);
      }
      if (__privateGet(this, _sizes)) {
        __privateGet(this, _sizes).fill(0);
      }
      __privateSet(this, _head, 0);
      __privateSet(this, _tail, 0);
      __privateGet(this, _free).length = 0;
      __privateSet(this, _calculatedSize, 0);
      __privateSet(this, _size, 0);
      if (__privateGet(this, _hasDisposeAfter) && __privateGet(this, _disposed)) {
        const dt = __privateGet(this, _disposed);
        let task;
        while (task = dt == null ? void 0 : dt.shift()) {
          (_c = __privateGet(this, _disposeAfter)) == null ? void 0 : _c.call(this, ...task);
        }
      }
    };
    LRUCache = _LRUCache;
  }
});

// ../../node_modules/minipass/dist/esm/index.js
var import_node_events, import_node_stream, import_node_string_decoder, proc, isStream, isReadable, isWritable, EOF, MAYBE_EMIT_END, EMITTED_END, EMITTING_END, EMITTED_ERROR, CLOSED, READ, FLUSH, FLUSHCHUNK, ENCODING, DECODER, FLOWING, PAUSED, RESUME, BUFFER, PIPES, BUFFERLENGTH, BUFFERPUSH, BUFFERSHIFT, OBJECTMODE, DESTROYED, ERROR, EMITDATA, EMITEND, EMITEND2, ASYNC, ABORT, ABORTED, SIGNAL, DATALISTENERS, DISCARDED, defer, nodefer, isEndish, isArrayBufferLike, isArrayBufferView, Pipe, PipeProxyErrors, isObjectModeOptions, isEncodingOptions, Minipass;
var init_esm3 = __esm({
  "../../node_modules/minipass/dist/esm/index.js"() {
    import_node_events = require("events");
    import_node_stream = __toESM(require("stream"), 1);
    import_node_string_decoder = require("string_decoder");
    proc = typeof process === "object" && process ? process : {
      stdout: null,
      stderr: null
    };
    isStream = (s3) => !!s3 && typeof s3 === "object" && (s3 instanceof Minipass || s3 instanceof import_node_stream.default || isReadable(s3) || isWritable(s3));
    isReadable = (s3) => !!s3 && typeof s3 === "object" && s3 instanceof import_node_events.EventEmitter && typeof s3.pipe === "function" && // node core Writable streams have a pipe() method, but it throws
    s3.pipe !== import_node_stream.default.Writable.prototype.pipe;
    isWritable = (s3) => !!s3 && typeof s3 === "object" && s3 instanceof import_node_events.EventEmitter && typeof s3.write === "function" && typeof s3.end === "function";
    EOF = Symbol("EOF");
    MAYBE_EMIT_END = Symbol("maybeEmitEnd");
    EMITTED_END = Symbol("emittedEnd");
    EMITTING_END = Symbol("emittingEnd");
    EMITTED_ERROR = Symbol("emittedError");
    CLOSED = Symbol("closed");
    READ = Symbol("read");
    FLUSH = Symbol("flush");
    FLUSHCHUNK = Symbol("flushChunk");
    ENCODING = Symbol("encoding");
    DECODER = Symbol("decoder");
    FLOWING = Symbol("flowing");
    PAUSED = Symbol("paused");
    RESUME = Symbol("resume");
    BUFFER = Symbol("buffer");
    PIPES = Symbol("pipes");
    BUFFERLENGTH = Symbol("bufferLength");
    BUFFERPUSH = Symbol("bufferPush");
    BUFFERSHIFT = Symbol("bufferShift");
    OBJECTMODE = Symbol("objectMode");
    DESTROYED = Symbol("destroyed");
    ERROR = Symbol("error");
    EMITDATA = Symbol("emitData");
    EMITEND = Symbol("emitEnd");
    EMITEND2 = Symbol("emitEnd2");
    ASYNC = Symbol("async");
    ABORT = Symbol("abort");
    ABORTED = Symbol("aborted");
    SIGNAL = Symbol("signal");
    DATALISTENERS = Symbol("dataListeners");
    DISCARDED = Symbol("discarded");
    defer = (fn) => Promise.resolve().then(fn);
    nodefer = (fn) => fn();
    isEndish = (ev) => ev === "end" || ev === "finish" || ev === "prefinish";
    isArrayBufferLike = (b3) => b3 instanceof ArrayBuffer || !!b3 && typeof b3 === "object" && b3.constructor && b3.constructor.name === "ArrayBuffer" && b3.byteLength >= 0;
    isArrayBufferView = (b3) => !Buffer.isBuffer(b3) && ArrayBuffer.isView(b3);
    Pipe = class {
      src;
      dest;
      opts;
      ondrain;
      constructor(src, dest, opts) {
        this.src = src;
        this.dest = dest;
        this.opts = opts;
        this.ondrain = () => src[RESUME]();
        this.dest.on("drain", this.ondrain);
      }
      unpipe() {
        this.dest.removeListener("drain", this.ondrain);
      }
      // only here for the prototype
      /* c8 ignore start */
      proxyErrors(_er) {
      }
      /* c8 ignore stop */
      end() {
        this.unpipe();
        if (this.opts.end)
          this.dest.end();
      }
    };
    PipeProxyErrors = class extends Pipe {
      unpipe() {
        this.src.removeListener("error", this.proxyErrors);
        super.unpipe();
      }
      constructor(src, dest, opts) {
        super(src, dest, opts);
        this.proxyErrors = (er) => dest.emit("error", er);
        src.on("error", this.proxyErrors);
      }
    };
    isObjectModeOptions = (o3) => !!o3.objectMode;
    isEncodingOptions = (o3) => !o3.objectMode && !!o3.encoding && o3.encoding !== "buffer";
    Minipass = class extends import_node_events.EventEmitter {
      [FLOWING] = false;
      [PAUSED] = false;
      [PIPES] = [];
      [BUFFER] = [];
      [OBJECTMODE];
      [ENCODING];
      [ASYNC];
      [DECODER];
      [EOF] = false;
      [EMITTED_END] = false;
      [EMITTING_END] = false;
      [CLOSED] = false;
      [EMITTED_ERROR] = null;
      [BUFFERLENGTH] = 0;
      [DESTROYED] = false;
      [SIGNAL];
      [ABORTED] = false;
      [DATALISTENERS] = 0;
      [DISCARDED] = false;
      /**
       * true if the stream can be written
       */
      writable = true;
      /**
       * true if the stream can be read
       */
      readable = true;
      /**
       * If `RType` is Buffer, then options do not need to be provided.
       * Otherwise, an options object must be provided to specify either
       * {@link Minipass.SharedOptions.objectMode} or
       * {@link Minipass.SharedOptions.encoding}, as appropriate.
       */
      constructor(...args) {
        const options = args[0] || {};
        super();
        if (options.objectMode && typeof options.encoding === "string") {
          throw new TypeError("Encoding and objectMode may not be used together");
        }
        if (isObjectModeOptions(options)) {
          this[OBJECTMODE] = true;
          this[ENCODING] = null;
        } else if (isEncodingOptions(options)) {
          this[ENCODING] = options.encoding;
          this[OBJECTMODE] = false;
        } else {
          this[OBJECTMODE] = false;
          this[ENCODING] = null;
        }
        this[ASYNC] = !!options.async;
        this[DECODER] = this[ENCODING] ? new import_node_string_decoder.StringDecoder(this[ENCODING]) : null;
        if (options && options.debugExposeBuffer === true) {
          Object.defineProperty(this, "buffer", { get: () => this[BUFFER] });
        }
        if (options && options.debugExposePipes === true) {
          Object.defineProperty(this, "pipes", { get: () => this[PIPES] });
        }
        const { signal } = options;
        if (signal) {
          this[SIGNAL] = signal;
          if (signal.aborted) {
            this[ABORT]();
          } else {
            signal.addEventListener("abort", () => this[ABORT]());
          }
        }
      }
      /**
       * The amount of data stored in the buffer waiting to be read.
       *
       * For Buffer strings, this will be the total byte length.
       * For string encoding streams, this will be the string character length,
       * according to JavaScript's `string.length` logic.
       * For objectMode streams, this is a count of the items waiting to be
       * emitted.
       */
      get bufferLength() {
        return this[BUFFERLENGTH];
      }
      /**
       * The `BufferEncoding` currently in use, or `null`
       */
      get encoding() {
        return this[ENCODING];
      }
      /**
       * @deprecated - This is a read only property
       */
      set encoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * @deprecated - Encoding may only be set at instantiation time
       */
      setEncoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * True if this is an objectMode stream
       */
      get objectMode() {
        return this[OBJECTMODE];
      }
      /**
       * @deprecated - This is a read-only property
       */
      set objectMode(_om) {
        throw new Error("objectMode must be set at instantiation time");
      }
      /**
       * true if this is an async stream
       */
      get ["async"]() {
        return this[ASYNC];
      }
      /**
       * Set to true to make this stream async.
       *
       * Once set, it cannot be unset, as this would potentially cause incorrect
       * behavior.  Ie, a sync stream can be made async, but an async stream
       * cannot be safely made sync.
       */
      set ["async"](a3) {
        this[ASYNC] = this[ASYNC] || !!a3;
      }
      // drop everything and get out of the flow completely
      [ABORT]() {
        var _a4, _b2;
        this[ABORTED] = true;
        this.emit("abort", (_a4 = this[SIGNAL]) == null ? void 0 : _a4.reason);
        this.destroy((_b2 = this[SIGNAL]) == null ? void 0 : _b2.reason);
      }
      /**
       * True if the stream has been aborted.
       */
      get aborted() {
        return this[ABORTED];
      }
      /**
       * No-op setter. Stream aborted status is set via the AbortSignal provided
       * in the constructor options.
       */
      set aborted(_3) {
      }
      write(chunk, encoding, cb) {
        var _a4;
        if (this[ABORTED])
          return false;
        if (this[EOF])
          throw new Error("write after end");
        if (this[DESTROYED]) {
          this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), { code: "ERR_STREAM_DESTROYED" }));
          return true;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (!encoding)
          encoding = "utf8";
        const fn = this[ASYNC] ? defer : nodefer;
        if (!this[OBJECTMODE] && !Buffer.isBuffer(chunk)) {
          if (isArrayBufferView(chunk)) {
            chunk = Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength);
          } else if (isArrayBufferLike(chunk)) {
            chunk = Buffer.from(chunk);
          } else if (typeof chunk !== "string") {
            throw new Error("Non-contiguous data written to non-objectMode stream");
          }
        }
        if (this[OBJECTMODE]) {
          if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
            this[FLUSH](true);
          if (this[FLOWING])
            this.emit("data", chunk);
          else
            this[BUFFERPUSH](chunk);
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (!chunk.length) {
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (typeof chunk === "string" && // unless it is a string already ready for us to use
        !(encoding === this[ENCODING] && !((_a4 = this[DECODER]) == null ? void 0 : _a4.lastNeed))) {
          chunk = Buffer.from(chunk, encoding);
        }
        if (Buffer.isBuffer(chunk) && this[ENCODING]) {
          chunk = this[DECODER].write(chunk);
        }
        if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
          this[FLUSH](true);
        if (this[FLOWING])
          this.emit("data", chunk);
        else
          this[BUFFERPUSH](chunk);
        if (this[BUFFERLENGTH] !== 0)
          this.emit("readable");
        if (cb)
          fn(cb);
        return this[FLOWING];
      }
      /**
       * Low-level explicit read method.
       *
       * In objectMode, the argument is ignored, and one item is returned if
       * available.
       *
       * `n` is the number of bytes (or in the case of encoding streams,
       * characters) to consume. If `n` is not provided, then the entire buffer
       * is returned, or `null` is returned if no data is available.
       *
       * If `n` is greater that the amount of data in the internal buffer,
       * then `null` is returned.
       */
      read(n3) {
        if (this[DESTROYED])
          return null;
        this[DISCARDED] = false;
        if (this[BUFFERLENGTH] === 0 || n3 === 0 || n3 && n3 > this[BUFFERLENGTH]) {
          this[MAYBE_EMIT_END]();
          return null;
        }
        if (this[OBJECTMODE])
          n3 = null;
        if (this[BUFFER].length > 1 && !this[OBJECTMODE]) {
          this[BUFFER] = [
            this[ENCODING] ? this[BUFFER].join("") : Buffer.concat(this[BUFFER], this[BUFFERLENGTH])
          ];
        }
        const ret = this[READ](n3 || null, this[BUFFER][0]);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [READ](n3, chunk) {
        if (this[OBJECTMODE])
          this[BUFFERSHIFT]();
        else {
          const c3 = chunk;
          if (n3 === c3.length || n3 === null)
            this[BUFFERSHIFT]();
          else if (typeof c3 === "string") {
            this[BUFFER][0] = c3.slice(n3);
            chunk = c3.slice(0, n3);
            this[BUFFERLENGTH] -= n3;
          } else {
            this[BUFFER][0] = c3.subarray(n3);
            chunk = c3.subarray(0, n3);
            this[BUFFERLENGTH] -= n3;
          }
        }
        this.emit("data", chunk);
        if (!this[BUFFER].length && !this[EOF])
          this.emit("drain");
        return chunk;
      }
      end(chunk, encoding, cb) {
        if (typeof chunk === "function") {
          cb = chunk;
          chunk = void 0;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (chunk !== void 0)
          this.write(chunk, encoding);
        if (cb)
          this.once("end", cb);
        this[EOF] = true;
        this.writable = false;
        if (this[FLOWING] || !this[PAUSED])
          this[MAYBE_EMIT_END]();
        return this;
      }
      // don't let the internal resume be overwritten
      [RESUME]() {
        if (this[DESTROYED])
          return;
        if (!this[DATALISTENERS] && !this[PIPES].length) {
          this[DISCARDED] = true;
        }
        this[PAUSED] = false;
        this[FLOWING] = true;
        this.emit("resume");
        if (this[BUFFER].length)
          this[FLUSH]();
        else if (this[EOF])
          this[MAYBE_EMIT_END]();
        else
          this.emit("drain");
      }
      /**
       * Resume the stream if it is currently in a paused state
       *
       * If called when there are no pipe destinations or `data` event listeners,
       * this will place the stream in a "discarded" state, where all data will
       * be thrown away. The discarded state is removed if a pipe destination or
       * data handler is added, if pause() is called, or if any synchronous or
       * asynchronous iteration is started.
       */
      resume() {
        return this[RESUME]();
      }
      /**
       * Pause the stream
       */
      pause() {
        this[FLOWING] = false;
        this[PAUSED] = true;
        this[DISCARDED] = false;
      }
      /**
       * true if the stream has been forcibly destroyed
       */
      get destroyed() {
        return this[DESTROYED];
      }
      /**
       * true if the stream is currently in a flowing state, meaning that
       * any writes will be immediately emitted.
       */
      get flowing() {
        return this[FLOWING];
      }
      /**
       * true if the stream is currently in a paused state
       */
      get paused() {
        return this[PAUSED];
      }
      [BUFFERPUSH](chunk) {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] += 1;
        else
          this[BUFFERLENGTH] += chunk.length;
        this[BUFFER].push(chunk);
      }
      [BUFFERSHIFT]() {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] -= 1;
        else
          this[BUFFERLENGTH] -= this[BUFFER][0].length;
        return this[BUFFER].shift();
      }
      [FLUSH](noDrain = false) {
        do {
        } while (this[FLUSHCHUNK](this[BUFFERSHIFT]()) && this[BUFFER].length);
        if (!noDrain && !this[BUFFER].length && !this[EOF])
          this.emit("drain");
      }
      [FLUSHCHUNK](chunk) {
        this.emit("data", chunk);
        return this[FLOWING];
      }
      /**
       * Pipe all data emitted by this stream into the destination provided.
       *
       * Triggers the flow of data.
       */
      pipe(dest, opts) {
        if (this[DESTROYED])
          return dest;
        this[DISCARDED] = false;
        const ended = this[EMITTED_END];
        opts = opts || {};
        if (dest === proc.stdout || dest === proc.stderr)
          opts.end = false;
        else
          opts.end = opts.end !== false;
        opts.proxyErrors = !!opts.proxyErrors;
        if (ended) {
          if (opts.end)
            dest.end();
        } else {
          this[PIPES].push(!opts.proxyErrors ? new Pipe(this, dest, opts) : new PipeProxyErrors(this, dest, opts));
          if (this[ASYNC])
            defer(() => this[RESUME]());
          else
            this[RESUME]();
        }
        return dest;
      }
      /**
       * Fully unhook a piped destination stream.
       *
       * If the destination stream was the only consumer of this stream (ie,
       * there are no other piped destinations or `'data'` event listeners)
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      unpipe(dest) {
        const p3 = this[PIPES].find((p4) => p4.dest === dest);
        if (p3) {
          if (this[PIPES].length === 1) {
            if (this[FLOWING] && this[DATALISTENERS] === 0) {
              this[FLOWING] = false;
            }
            this[PIPES] = [];
          } else
            this[PIPES].splice(this[PIPES].indexOf(p3), 1);
          p3.unpipe();
        }
      }
      /**
       * Alias for {@link Minipass#on}
       */
      addListener(ev, handler) {
        return this.on(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.on`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * - Adding a 'data' event handler will trigger the flow of data
       *
       * - Adding a 'readable' event handler when there is data waiting to be read
       *   will cause 'readable' to be emitted immediately.
       *
       * - Adding an 'endish' event handler ('end', 'finish', etc.) which has
       *   already passed will cause the event to be emitted immediately and all
       *   handlers removed.
       *
       * - Adding an 'error' event handler after an error has been emitted will
       *   cause the event to be re-emitted immediately with the error previously
       *   raised.
       */
      on(ev, handler) {
        const ret = super.on(ev, handler);
        if (ev === "data") {
          this[DISCARDED] = false;
          this[DATALISTENERS]++;
          if (!this[PIPES].length && !this[FLOWING]) {
            this[RESUME]();
          }
        } else if (ev === "readable" && this[BUFFERLENGTH] !== 0) {
          super.emit("readable");
        } else if (isEndish(ev) && this[EMITTED_END]) {
          super.emit(ev);
          this.removeAllListeners(ev);
        } else if (ev === "error" && this[EMITTED_ERROR]) {
          const h3 = handler;
          if (this[ASYNC])
            defer(() => h3.call(this, this[EMITTED_ERROR]));
          else
            h3.call(this, this[EMITTED_ERROR]);
        }
        return ret;
      }
      /**
       * Alias for {@link Minipass#off}
       */
      removeListener(ev, handler) {
        return this.off(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.off`
       *
       * If a 'data' event handler is removed, and it was the last consumer
       * (ie, there are no pipe destinations or other 'data' event listeners),
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      off(ev, handler) {
        const ret = super.off(ev, handler);
        if (ev === "data") {
          this[DATALISTENERS] = this.listeners("data").length;
          if (this[DATALISTENERS] === 0 && !this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * Mostly identical to `EventEmitter.removeAllListeners`
       *
       * If all 'data' event handlers are removed, and they were the last consumer
       * (ie, there are no pipe destinations), then the flow of data will stop
       * until there is another consumer or {@link Minipass#resume} is explicitly
       * called.
       */
      removeAllListeners(ev) {
        const ret = super.removeAllListeners(ev);
        if (ev === "data" || ev === void 0) {
          this[DATALISTENERS] = 0;
          if (!this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * true if the 'end' event has been emitted
       */
      get emittedEnd() {
        return this[EMITTED_END];
      }
      [MAYBE_EMIT_END]() {
        if (!this[EMITTING_END] && !this[EMITTED_END] && !this[DESTROYED] && this[BUFFER].length === 0 && this[EOF]) {
          this[EMITTING_END] = true;
          this.emit("end");
          this.emit("prefinish");
          this.emit("finish");
          if (this[CLOSED])
            this.emit("close");
          this[EMITTING_END] = false;
        }
      }
      /**
       * Mostly identical to `EventEmitter.emit`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * If the stream has been destroyed, and the event is something other
       * than 'close' or 'error', then `false` is returned and no handlers
       * are called.
       *
       * If the event is 'end', and has already been emitted, then the event
       * is ignored. If the stream is in a paused or non-flowing state, then
       * the event will be deferred until data flow resumes. If the stream is
       * async, then handlers will be called on the next tick rather than
       * immediately.
       *
       * If the event is 'close', and 'end' has not yet been emitted, then
       * the event will be deferred until after 'end' is emitted.
       *
       * If the event is 'error', and an AbortSignal was provided for the stream,
       * and there are no listeners, then the event is ignored, matching the
       * behavior of node core streams in the presense of an AbortSignal.
       *
       * If the event is 'finish' or 'prefinish', then all listeners will be
       * removed after emitting the event, to prevent double-firing.
       */
      emit(ev, ...args) {
        const data2 = args[0];
        if (ev !== "error" && ev !== "close" && ev !== DESTROYED && this[DESTROYED]) {
          return false;
        } else if (ev === "data") {
          return !this[OBJECTMODE] && !data2 ? false : this[ASYNC] ? (defer(() => this[EMITDATA](data2)), true) : this[EMITDATA](data2);
        } else if (ev === "end") {
          return this[EMITEND]();
        } else if (ev === "close") {
          this[CLOSED] = true;
          if (!this[EMITTED_END] && !this[DESTROYED])
            return false;
          const ret2 = super.emit("close");
          this.removeAllListeners("close");
          return ret2;
        } else if (ev === "error") {
          this[EMITTED_ERROR] = data2;
          super.emit(ERROR, data2);
          const ret2 = !this[SIGNAL] || this.listeners("error").length ? super.emit("error", data2) : false;
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "resume") {
          const ret2 = super.emit("resume");
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "finish" || ev === "prefinish") {
          const ret2 = super.emit(ev);
          this.removeAllListeners(ev);
          return ret2;
        }
        const ret = super.emit(ev, ...args);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITDATA](data2) {
        for (const p3 of this[PIPES]) {
          if (p3.dest.write(data2) === false)
            this.pause();
        }
        const ret = this[DISCARDED] ? false : super.emit("data", data2);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITEND]() {
        if (this[EMITTED_END])
          return false;
        this[EMITTED_END] = true;
        this.readable = false;
        return this[ASYNC] ? (defer(() => this[EMITEND2]()), true) : this[EMITEND2]();
      }
      [EMITEND2]() {
        if (this[DECODER]) {
          const data2 = this[DECODER].end();
          if (data2) {
            for (const p3 of this[PIPES]) {
              p3.dest.write(data2);
            }
            if (!this[DISCARDED])
              super.emit("data", data2);
          }
        }
        for (const p3 of this[PIPES]) {
          p3.end();
        }
        const ret = super.emit("end");
        this.removeAllListeners("end");
        return ret;
      }
      /**
       * Return a Promise that resolves to an array of all emitted data once
       * the stream ends.
       */
      async collect() {
        const buf = Object.assign([], {
          dataLength: 0
        });
        if (!this[OBJECTMODE])
          buf.dataLength = 0;
        const p3 = this.promise();
        this.on("data", (c3) => {
          buf.push(c3);
          if (!this[OBJECTMODE])
            buf.dataLength += c3.length;
        });
        await p3;
        return buf;
      }
      /**
       * Return a Promise that resolves to the concatenation of all emitted data
       * once the stream ends.
       *
       * Not allowed on objectMode streams.
       */
      async concat() {
        if (this[OBJECTMODE]) {
          throw new Error("cannot concat in objectMode");
        }
        const buf = await this.collect();
        return this[ENCODING] ? buf.join("") : Buffer.concat(buf, buf.dataLength);
      }
      /**
       * Return a void Promise that resolves once the stream ends.
       */
      async promise() {
        return new Promise((resolve12, reject) => {
          this.on(DESTROYED, () => reject(new Error("stream destroyed")));
          this.on("error", (er) => reject(er));
          this.on("end", () => resolve12());
        });
      }
      /**
       * Asynchronous `for await of` iteration.
       *
       * This will continue emitting all chunks until the stream terminates.
       */
      [Symbol.asyncIterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = async () => {
          this.pause();
          stopped = true;
          return { value: void 0, done: true };
        };
        const next = () => {
          if (stopped)
            return stop();
          const res = this.read();
          if (res !== null)
            return Promise.resolve({ done: false, value: res });
          if (this[EOF])
            return stop();
          let resolve12;
          let reject;
          const onerr = (er) => {
            this.off("data", ondata);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            stop();
            reject(er);
          };
          const ondata = (value) => {
            this.off("error", onerr);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            this.pause();
            resolve12({ value, done: !!this[EOF] });
          };
          const onend = () => {
            this.off("error", onerr);
            this.off("data", ondata);
            this.off(DESTROYED, ondestroy);
            stop();
            resolve12({ done: true, value: void 0 });
          };
          const ondestroy = () => onerr(new Error("stream destroyed"));
          return new Promise((res2, rej) => {
            reject = rej;
            resolve12 = res2;
            this.once(DESTROYED, ondestroy);
            this.once("error", onerr);
            this.once("end", onend);
            this.once("data", ondata);
          });
        };
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.asyncIterator]() {
            return this;
          }
        };
      }
      /**
       * Synchronous `for of` iteration.
       *
       * The iteration will terminate when the internal buffer runs out, even
       * if the stream has not yet terminated.
       */
      [Symbol.iterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = () => {
          this.pause();
          this.off(ERROR, stop);
          this.off(DESTROYED, stop);
          this.off("end", stop);
          stopped = true;
          return { done: true, value: void 0 };
        };
        const next = () => {
          if (stopped)
            return stop();
          const value = this.read();
          return value === null ? stop() : { done: false, value };
        };
        this.once("end", stop);
        this.once(ERROR, stop);
        this.once(DESTROYED, stop);
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.iterator]() {
            return this;
          }
        };
      }
      /**
       * Destroy a stream, preventing it from being used for any further purpose.
       *
       * If the stream has a `close()` method, then it will be called on
       * destruction.
       *
       * After destruction, any attempt to write data, read data, or emit most
       * events will be ignored.
       *
       * If an error argument is provided, then it will be emitted in an
       * 'error' event.
       */
      destroy(er) {
        if (this[DESTROYED]) {
          if (er)
            this.emit("error", er);
          else
            this.emit(DESTROYED);
          return this;
        }
        this[DESTROYED] = true;
        this[DISCARDED] = true;
        this[BUFFER].length = 0;
        this[BUFFERLENGTH] = 0;
        const wc = this;
        if (typeof wc.close === "function" && !this[CLOSED])
          wc.close();
        if (er)
          this.emit("error", er);
        else
          this.emit(DESTROYED);
        return this;
      }
      /**
       * Alias for {@link isStream}
       *
       * Former export location, maintained for backwards compatibility.
       *
       * @deprecated
       */
      static get isStream() {
        return isStream;
      }
    };
  }
});

// ../../node_modules/path-scurry/dist/esm/index.js
var import_node_path, import_node_url, import_fs, actualFS, import_promises, realpathSync, defaultFS, fsFromOption, uncDriveRegexp, uncToDrive, eitherSep, UNKNOWN, IFIFO, IFCHR, IFDIR, IFBLK, IFREG, IFLNK, IFSOCK, IFMT, IFMT_UNKNOWN, READDIR_CALLED, LSTAT_CALLED, ENOTDIR, ENOENT, ENOREADLINK, ENOREALPATH, ENOCHILD, TYPEMASK, entToType, normalizeCache, normalize, normalizeNocaseCache, normalizeNocase, ResolveCache, ChildrenCache, setAsCwd, _fs, _dev, _mode, _nlink, _uid, _gid, _rdev, _blksize, _ino, _size2, _blocks, _atimeMs, _mtimeMs, _ctimeMs, _birthtimeMs, _atime, _mtime, _ctime, _birthtime, _matchName, _depth, _fullpath, _fullpathPosix, _relative, _relativePosix, _type, _children, _linkTarget, _realpath, _PathBase_instances, resolveParts_fn, readdirSuccess_fn, markENOENT_fn, markChildrenENOENT_fn, markENOREALPATH_fn, markENOTDIR_fn, readdirFail_fn, lstatFail_fn, readlinkFail_fn, readdirAddChild_fn, readdirAddNewChild_fn, readdirMaybePromoteChild_fn, readdirPromoteChild_fn, applyStat_fn, _onReaddirCB, _readdirCBInFlight, callOnReaddirCB_fn, _asyncReaddirInFlight, PathBase, PathWin32, PathPosix, _resolveCache, _resolvePosixCache, _children2, _fs2, PathScurryBase, PathScurryWin32, PathScurryPosix, PathScurryDarwin, Path, PathScurry;
var init_esm4 = __esm({
  "../../node_modules/path-scurry/dist/esm/index.js"() {
    init_esm2();
    import_node_path = require("path");
    import_node_url = require("url");
    import_fs = require("fs");
    actualFS = __toESM(require("fs"), 1);
    import_promises = require("fs/promises");
    init_esm3();
    realpathSync = import_fs.realpathSync.native;
    defaultFS = {
      lstatSync: import_fs.lstatSync,
      readdir: import_fs.readdir,
      readdirSync: import_fs.readdirSync,
      readlinkSync: import_fs.readlinkSync,
      realpathSync,
      promises: {
        lstat: import_promises.lstat,
        readdir: import_promises.readdir,
        readlink: import_promises.readlink,
        realpath: import_promises.realpath
      }
    };
    fsFromOption = (fsOption) => !fsOption || fsOption === defaultFS || fsOption === actualFS ? defaultFS : {
      ...defaultFS,
      ...fsOption,
      promises: {
        ...defaultFS.promises,
        ...fsOption.promises || {}
      }
    };
    uncDriveRegexp = /^\\\\\?\\([a-z]:)\\?$/i;
    uncToDrive = (rootPath) => rootPath.replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
    eitherSep = /[\\\/]/;
    UNKNOWN = 0;
    IFIFO = 1;
    IFCHR = 2;
    IFDIR = 4;
    IFBLK = 6;
    IFREG = 8;
    IFLNK = 10;
    IFSOCK = 12;
    IFMT = 15;
    IFMT_UNKNOWN = ~IFMT;
    READDIR_CALLED = 16;
    LSTAT_CALLED = 32;
    ENOTDIR = 64;
    ENOENT = 128;
    ENOREADLINK = 256;
    ENOREALPATH = 512;
    ENOCHILD = ENOTDIR | ENOENT | ENOREALPATH;
    TYPEMASK = 1023;
    entToType = (s3) => s3.isFile() ? IFREG : s3.isDirectory() ? IFDIR : s3.isSymbolicLink() ? IFLNK : s3.isCharacterDevice() ? IFCHR : s3.isBlockDevice() ? IFBLK : s3.isSocket() ? IFSOCK : s3.isFIFO() ? IFIFO : UNKNOWN;
    normalizeCache = /* @__PURE__ */ new Map();
    normalize = (s3) => {
      const c3 = normalizeCache.get(s3);
      if (c3)
        return c3;
      const n3 = s3.normalize("NFKD");
      normalizeCache.set(s3, n3);
      return n3;
    };
    normalizeNocaseCache = /* @__PURE__ */ new Map();
    normalizeNocase = (s3) => {
      const c3 = normalizeNocaseCache.get(s3);
      if (c3)
        return c3;
      const n3 = normalize(s3.toLowerCase());
      normalizeNocaseCache.set(s3, n3);
      return n3;
    };
    ResolveCache = class extends LRUCache {
      constructor() {
        super({ max: 256 });
      }
    };
    ChildrenCache = class extends LRUCache {
      constructor(maxSize = 16 * 1024) {
        super({
          maxSize,
          // parent + children
          sizeCalculation: (a3) => a3.length + 1
        });
      }
    };
    setAsCwd = Symbol("PathScurry setAsCwd");
    PathBase = class {
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        __privateAdd(this, _PathBase_instances);
        /**
         * the basename of this path
         *
         * **Important**: *always* test the path name against any test string
         * usingthe {@link isNamed} method, and not by directly comparing this
         * string. Otherwise, unicode path strings that the system sees as identical
         * will not be properly treated as the same path, leading to incorrect
         * behavior and possible security issues.
         */
        __publicField(this, "name");
        /**
         * the Path entry corresponding to the path root.
         *
         * @internal
         */
        __publicField(this, "root");
        /**
         * All roots found within the current PathScurry family
         *
         * @internal
         */
        __publicField(this, "roots");
        /**
         * a reference to the parent path, or undefined in the case of root entries
         *
         * @internal
         */
        __publicField(this, "parent");
        /**
         * boolean indicating whether paths are compared case-insensitively
         * @internal
         */
        __publicField(this, "nocase");
        /**
         * boolean indicating that this path is the current working directory
         * of the PathScurry collection that contains it.
         */
        __publicField(this, "isCWD", false);
        // potential default fs override
        __privateAdd(this, _fs);
        // Stats fields
        __privateAdd(this, _dev);
        __privateAdd(this, _mode);
        __privateAdd(this, _nlink);
        __privateAdd(this, _uid);
        __privateAdd(this, _gid);
        __privateAdd(this, _rdev);
        __privateAdd(this, _blksize);
        __privateAdd(this, _ino);
        __privateAdd(this, _size2);
        __privateAdd(this, _blocks);
        __privateAdd(this, _atimeMs);
        __privateAdd(this, _mtimeMs);
        __privateAdd(this, _ctimeMs);
        __privateAdd(this, _birthtimeMs);
        __privateAdd(this, _atime);
        __privateAdd(this, _mtime);
        __privateAdd(this, _ctime);
        __privateAdd(this, _birthtime);
        __privateAdd(this, _matchName);
        __privateAdd(this, _depth);
        __privateAdd(this, _fullpath);
        __privateAdd(this, _fullpathPosix);
        __privateAdd(this, _relative);
        __privateAdd(this, _relativePosix);
        __privateAdd(this, _type);
        __privateAdd(this, _children);
        __privateAdd(this, _linkTarget);
        __privateAdd(this, _realpath);
        __privateAdd(this, _onReaddirCB, []);
        __privateAdd(this, _readdirCBInFlight, false);
        __privateAdd(this, _asyncReaddirInFlight);
        this.name = name;
        __privateSet(this, _matchName, nocase ? normalizeNocase(name) : normalize(name));
        __privateSet(this, _type, type & TYPEMASK);
        this.nocase = nocase;
        this.roots = roots;
        this.root = root || this;
        __privateSet(this, _children, children);
        __privateSet(this, _fullpath, opts.fullpath);
        __privateSet(this, _relative, opts.relative);
        __privateSet(this, _relativePosix, opts.relativePosix);
        this.parent = opts.parent;
        if (this.parent) {
          __privateSet(this, _fs, __privateGet(this.parent, _fs));
        } else {
          __privateSet(this, _fs, fsFromOption(opts.fs));
        }
      }
      get dev() {
        return __privateGet(this, _dev);
      }
      get mode() {
        return __privateGet(this, _mode);
      }
      get nlink() {
        return __privateGet(this, _nlink);
      }
      get uid() {
        return __privateGet(this, _uid);
      }
      get gid() {
        return __privateGet(this, _gid);
      }
      get rdev() {
        return __privateGet(this, _rdev);
      }
      get blksize() {
        return __privateGet(this, _blksize);
      }
      get ino() {
        return __privateGet(this, _ino);
      }
      get size() {
        return __privateGet(this, _size2);
      }
      get blocks() {
        return __privateGet(this, _blocks);
      }
      get atimeMs() {
        return __privateGet(this, _atimeMs);
      }
      get mtimeMs() {
        return __privateGet(this, _mtimeMs);
      }
      get ctimeMs() {
        return __privateGet(this, _ctimeMs);
      }
      get birthtimeMs() {
        return __privateGet(this, _birthtimeMs);
      }
      get atime() {
        return __privateGet(this, _atime);
      }
      get mtime() {
        return __privateGet(this, _mtime);
      }
      get ctime() {
        return __privateGet(this, _ctime);
      }
      get birthtime() {
        return __privateGet(this, _birthtime);
      }
      /**
       * This property is for compatibility with the Dirent class as of
       * Node v20, where Dirent['parentPath'] refers to the path of the
       * directory that was passed to readdir. For root entries, it's the path
       * to the entry itself.
       */
      get parentPath() {
        return (this.parent || this).fullpath();
      }
      /**
       * Deprecated alias for Dirent['parentPath'] Somewhat counterintuitively,
       * this property refers to the *parent* path, not the path object itself.
       *
       * @deprecated
       */
      get path() {
        return this.parentPath;
      }
      /**
       * Returns the depth of the Path object from its root.
       *
       * For example, a path at `/foo/bar` would have a depth of 2.
       */
      depth() {
        if (__privateGet(this, _depth) !== void 0)
          return __privateGet(this, _depth);
        if (!this.parent)
          return __privateSet(this, _depth, 0);
        return __privateSet(this, _depth, this.parent.depth() + 1);
      }
      /**
       * @internal
       */
      childrenCache() {
        return __privateGet(this, _children);
      }
      /**
       * Get the Path object referenced by the string path, resolved from this Path
       */
      resolve(path34) {
        var _a4;
        if (!path34) {
          return this;
        }
        const rootPath = this.getRootString(path34);
        const dir = path34.substring(rootPath.length);
        const dirParts = dir.split(this.splitSep);
        const result3 = rootPath ? __privateMethod(_a4 = this.getRoot(rootPath), _PathBase_instances, resolveParts_fn).call(_a4, dirParts) : __privateMethod(this, _PathBase_instances, resolveParts_fn).call(this, dirParts);
        return result3;
      }
      /**
       * Returns the cached children Path objects, if still available.  If they
       * have fallen out of the cache, then returns an empty array, and resets the
       * READDIR_CALLED bit, so that future calls to readdir() will require an fs
       * lookup.
       *
       * @internal
       */
      children() {
        const cached4 = __privateGet(this, _children).get(this);
        if (cached4) {
          return cached4;
        }
        const children = Object.assign([], { provisional: 0 });
        __privateGet(this, _children).set(this, children);
        __privateSet(this, _type, __privateGet(this, _type) & ~READDIR_CALLED);
        return children;
      }
      /**
       * Resolves a path portion and returns or creates the child Path.
       *
       * Returns `this` if pathPart is `''` or `'.'`, or `parent` if pathPart is
       * `'..'`.
       *
       * This should not be called directly.  If `pathPart` contains any path
       * separators, it will lead to unsafe undefined behavior.
       *
       * Use `Path.resolve()` instead.
       *
       * @internal
       */
      child(pathPart, opts) {
        if (pathPart === "" || pathPart === ".") {
          return this;
        }
        if (pathPart === "..") {
          return this.parent || this;
        }
        const children = this.children();
        const name = this.nocase ? normalizeNocase(pathPart) : normalize(pathPart);
        for (const p3 of children) {
          if (__privateGet(p3, _matchName) === name) {
            return p3;
          }
        }
        const s3 = this.parent ? this.sep : "";
        const fullpath = __privateGet(this, _fullpath) ? __privateGet(this, _fullpath) + s3 + pathPart : void 0;
        const pchild = this.newChild(pathPart, UNKNOWN, {
          ...opts,
          parent: this,
          fullpath
        });
        if (!this.canReaddir()) {
          __privateSet(pchild, _type, __privateGet(pchild, _type) | ENOENT);
        }
        children.push(pchild);
        return pchild;
      }
      /**
       * The relative path from the cwd. If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpath()
       */
      relative() {
        if (this.isCWD)
          return "";
        if (__privateGet(this, _relative) !== void 0) {
          return __privateGet(this, _relative);
        }
        const name = this.name;
        const p3 = this.parent;
        if (!p3) {
          return __privateSet(this, _relative, this.name);
        }
        const pv = p3.relative();
        return pv + (!pv || !p3.parent ? "" : this.sep) + name;
      }
      /**
       * The relative path from the cwd, using / as the path separator.
       * If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpathPosix()
       * On posix systems, this is identical to relative().
       */
      relativePosix() {
        if (this.sep === "/")
          return this.relative();
        if (this.isCWD)
          return "";
        if (__privateGet(this, _relativePosix) !== void 0)
          return __privateGet(this, _relativePosix);
        const name = this.name;
        const p3 = this.parent;
        if (!p3) {
          return __privateSet(this, _relativePosix, this.fullpathPosix());
        }
        const pv = p3.relativePosix();
        return pv + (!pv || !p3.parent ? "" : "/") + name;
      }
      /**
       * The fully resolved path string for this Path entry
       */
      fullpath() {
        if (__privateGet(this, _fullpath) !== void 0) {
          return __privateGet(this, _fullpath);
        }
        const name = this.name;
        const p3 = this.parent;
        if (!p3) {
          return __privateSet(this, _fullpath, this.name);
        }
        const pv = p3.fullpath();
        const fp = pv + (!p3.parent ? "" : this.sep) + name;
        return __privateSet(this, _fullpath, fp);
      }
      /**
       * On platforms other than windows, this is identical to fullpath.
       *
       * On windows, this is overridden to return the forward-slash form of the
       * full UNC path.
       */
      fullpathPosix() {
        if (__privateGet(this, _fullpathPosix) !== void 0)
          return __privateGet(this, _fullpathPosix);
        if (this.sep === "/")
          return __privateSet(this, _fullpathPosix, this.fullpath());
        if (!this.parent) {
          const p4 = this.fullpath().replace(/\\/g, "/");
          if (/^[a-z]:\//i.test(p4)) {
            return __privateSet(this, _fullpathPosix, `//?/${p4}`);
          } else {
            return __privateSet(this, _fullpathPosix, p4);
          }
        }
        const p3 = this.parent;
        const pfpp = p3.fullpathPosix();
        const fpp = pfpp + (!pfpp || !p3.parent ? "" : "/") + this.name;
        return __privateSet(this, _fullpathPosix, fpp);
      }
      /**
       * Is the Path of an unknown type?
       *
       * Note that we might know *something* about it if there has been a previous
       * filesystem operation, for example that it does not exist, or is not a
       * link, or whether it has child entries.
       */
      isUnknown() {
        return (__privateGet(this, _type) & IFMT) === UNKNOWN;
      }
      isType(type) {
        return this[`is${type}`]();
      }
      getType() {
        return this.isUnknown() ? "Unknown" : this.isDirectory() ? "Directory" : this.isFile() ? "File" : this.isSymbolicLink() ? "SymbolicLink" : this.isFIFO() ? "FIFO" : this.isCharacterDevice() ? "CharacterDevice" : this.isBlockDevice() ? "BlockDevice" : (
          /* c8 ignore start */
          this.isSocket() ? "Socket" : "Unknown"
        );
      }
      /**
       * Is the Path a regular file?
       */
      isFile() {
        return (__privateGet(this, _type) & IFMT) === IFREG;
      }
      /**
       * Is the Path a directory?
       */
      isDirectory() {
        return (__privateGet(this, _type) & IFMT) === IFDIR;
      }
      /**
       * Is the path a character device?
       */
      isCharacterDevice() {
        return (__privateGet(this, _type) & IFMT) === IFCHR;
      }
      /**
       * Is the path a block device?
       */
      isBlockDevice() {
        return (__privateGet(this, _type) & IFMT) === IFBLK;
      }
      /**
       * Is the path a FIFO pipe?
       */
      isFIFO() {
        return (__privateGet(this, _type) & IFMT) === IFIFO;
      }
      /**
       * Is the path a socket?
       */
      isSocket() {
        return (__privateGet(this, _type) & IFMT) === IFSOCK;
      }
      /**
       * Is the path a symbolic link?
       */
      isSymbolicLink() {
        return (__privateGet(this, _type) & IFLNK) === IFLNK;
      }
      /**
       * Return the entry if it has been subject of a successful lstat, or
       * undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* simply
       * mean that we haven't called lstat on it.
       */
      lstatCached() {
        return __privateGet(this, _type) & LSTAT_CALLED ? this : void 0;
      }
      /**
       * Return the cached link target if the entry has been the subject of a
       * successful readlink, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readlink() has been called at some point.
       */
      readlinkCached() {
        return __privateGet(this, _linkTarget);
      }
      /**
       * Returns the cached realpath target if the entry has been the subject
       * of a successful realpath, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * realpath() has been called at some point.
       */
      realpathCached() {
        return __privateGet(this, _realpath);
      }
      /**
       * Returns the cached child Path entries array if the entry has been the
       * subject of a successful readdir(), or [] otherwise.
       *
       * Does not read the filesystem, so an empty array *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readdir() has been called recently enough to still be valid.
       */
      readdirCached() {
        const children = this.children();
        return children.slice(0, children.provisional);
      }
      /**
       * Return true if it's worth trying to readlink.  Ie, we don't (yet) have
       * any indication that readlink will definitely fail.
       *
       * Returns false if the path is known to not be a symlink, if a previous
       * readlink failed, or if the entry does not exist.
       */
      canReadlink() {
        if (__privateGet(this, _linkTarget))
          return true;
        if (!this.parent)
          return false;
        const ifmt = __privateGet(this, _type) & IFMT;
        return !(ifmt !== UNKNOWN && ifmt !== IFLNK || __privateGet(this, _type) & ENOREADLINK || __privateGet(this, _type) & ENOENT);
      }
      /**
       * Return true if readdir has previously been successfully called on this
       * path, indicating that cachedReaddir() is likely valid.
       */
      calledReaddir() {
        return !!(__privateGet(this, _type) & READDIR_CALLED);
      }
      /**
       * Returns true if the path is known to not exist. That is, a previous lstat
       * or readdir failed to verify its existence when that would have been
       * expected, or a parent entry was marked either enoent or enotdir.
       */
      isENOENT() {
        return !!(__privateGet(this, _type) & ENOENT);
      }
      /**
       * Return true if the path is a match for the given path name.  This handles
       * case sensitivity and unicode normalization.
       *
       * Note: even on case-sensitive systems, it is **not** safe to test the
       * equality of the `.name` property to determine whether a given pathname
       * matches, due to unicode normalization mismatches.
       *
       * Always use this method instead of testing the `path.name` property
       * directly.
       */
      isNamed(n3) {
        return !this.nocase ? __privateGet(this, _matchName) === normalize(n3) : __privateGet(this, _matchName) === normalizeNocase(n3);
      }
      /**
       * Return the Path object corresponding to the target of a symbolic link.
       *
       * If the Path is not a symbolic link, or if the readlink call fails for any
       * reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       */
      async readlink() {
        var _a4;
        const target = __privateGet(this, _linkTarget);
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = await __privateGet(this, _fs).promises.readlink(this.fullpath());
          const linkTarget = (_a4 = await this.parent.realpath()) == null ? void 0 : _a4.resolve(read);
          if (linkTarget) {
            return __privateSet(this, _linkTarget, linkTarget);
          }
        } catch (er) {
          __privateMethod(this, _PathBase_instances, readlinkFail_fn).call(this, er.code);
          return void 0;
        }
      }
      /**
       * Synchronous {@link PathBase.readlink}
       */
      readlinkSync() {
        var _a4;
        const target = __privateGet(this, _linkTarget);
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = __privateGet(this, _fs).readlinkSync(this.fullpath());
          const linkTarget = (_a4 = this.parent.realpathSync()) == null ? void 0 : _a4.resolve(read);
          if (linkTarget) {
            return __privateSet(this, _linkTarget, linkTarget);
          }
        } catch (er) {
          __privateMethod(this, _PathBase_instances, readlinkFail_fn).call(this, er.code);
          return void 0;
        }
      }
      /**
       * Call lstat() on this Path, and update all known information that can be
       * determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat() {
        if ((__privateGet(this, _type) & ENOENT) === 0) {
          try {
            __privateMethod(this, _PathBase_instances, applyStat_fn).call(this, await __privateGet(this, _fs).promises.lstat(this.fullpath()));
            return this;
          } catch (er) {
            __privateMethod(this, _PathBase_instances, lstatFail_fn).call(this, er.code);
          }
        }
      }
      /**
       * synchronous {@link PathBase.lstat}
       */
      lstatSync() {
        if ((__privateGet(this, _type) & ENOENT) === 0) {
          try {
            __privateMethod(this, _PathBase_instances, applyStat_fn).call(this, __privateGet(this, _fs).lstatSync(this.fullpath()));
            return this;
          } catch (er) {
            __privateMethod(this, _PathBase_instances, lstatFail_fn).call(this, er.code);
          }
        }
      }
      /**
       * Standard node-style callback interface to get list of directory entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       *
       * @param cb The callback called with (er, entries).  Note that the `er`
       * param is somewhat extraneous, as all readdir() errors are handled and
       * simply result in an empty set of entries being returned.
       * @param allowZalgo Boolean indicating that immediately known results should
       * *not* be deferred with `queueMicrotask`. Defaults to `false`. Release
       * zalgo at your peril, the dark pony lord is devious and unforgiving.
       */
      readdirCB(cb, allowZalgo = false) {
        if (!this.canReaddir()) {
          if (allowZalgo)
            cb(null, []);
          else
            queueMicrotask(() => cb(null, []));
          return;
        }
        const children = this.children();
        if (this.calledReaddir()) {
          const c3 = children.slice(0, children.provisional);
          if (allowZalgo)
            cb(null, c3);
          else
            queueMicrotask(() => cb(null, c3));
          return;
        }
        __privateGet(this, _onReaddirCB).push(cb);
        if (__privateGet(this, _readdirCBInFlight)) {
          return;
        }
        __privateSet(this, _readdirCBInFlight, true);
        const fullpath = this.fullpath();
        __privateGet(this, _fs).readdir(fullpath, { withFileTypes: true }, (er, entries) => {
          if (er) {
            __privateMethod(this, _PathBase_instances, readdirFail_fn).call(this, er.code);
            children.provisional = 0;
          } else {
            for (const e3 of entries) {
              __privateMethod(this, _PathBase_instances, readdirAddChild_fn).call(this, e3, children);
            }
            __privateMethod(this, _PathBase_instances, readdirSuccess_fn).call(this, children);
          }
          __privateMethod(this, _PathBase_instances, callOnReaddirCB_fn).call(this, children.slice(0, children.provisional));
          return;
        });
      }
      /**
       * Return an array of known child entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async readdir() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        if (__privateGet(this, _asyncReaddirInFlight)) {
          await __privateGet(this, _asyncReaddirInFlight);
        } else {
          let resolve12 = () => {
          };
          __privateSet(this, _asyncReaddirInFlight, new Promise((res) => resolve12 = res));
          try {
            for (const e3 of await __privateGet(this, _fs).promises.readdir(fullpath, {
              withFileTypes: true
            })) {
              __privateMethod(this, _PathBase_instances, readdirAddChild_fn).call(this, e3, children);
            }
            __privateMethod(this, _PathBase_instances, readdirSuccess_fn).call(this, children);
          } catch (er) {
            __privateMethod(this, _PathBase_instances, readdirFail_fn).call(this, er.code);
            children.provisional = 0;
          }
          __privateSet(this, _asyncReaddirInFlight, void 0);
          resolve12();
        }
        return children.slice(0, children.provisional);
      }
      /**
       * synchronous {@link PathBase.readdir}
       */
      readdirSync() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        try {
          for (const e3 of __privateGet(this, _fs).readdirSync(fullpath, {
            withFileTypes: true
          })) {
            __privateMethod(this, _PathBase_instances, readdirAddChild_fn).call(this, e3, children);
          }
          __privateMethod(this, _PathBase_instances, readdirSuccess_fn).call(this, children);
        } catch (er) {
          __privateMethod(this, _PathBase_instances, readdirFail_fn).call(this, er.code);
          children.provisional = 0;
        }
        return children.slice(0, children.provisional);
      }
      canReaddir() {
        if (__privateGet(this, _type) & ENOCHILD)
          return false;
        const ifmt = IFMT & __privateGet(this, _type);
        if (!(ifmt === UNKNOWN || ifmt === IFDIR || ifmt === IFLNK)) {
          return false;
        }
        return true;
      }
      shouldWalk(dirs, walkFilter) {
        return (__privateGet(this, _type) & IFDIR) === IFDIR && !(__privateGet(this, _type) & ENOCHILD) && !dirs.has(this) && (!walkFilter || walkFilter(this));
      }
      /**
       * Return the Path object corresponding to path as resolved
       * by realpath(3).
       *
       * If the realpath call fails for any reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       * On success, returns a Path object.
       */
      async realpath() {
        if (__privateGet(this, _realpath))
          return __privateGet(this, _realpath);
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & __privateGet(this, _type))
          return void 0;
        try {
          const rp = await __privateGet(this, _fs).promises.realpath(this.fullpath());
          return __privateSet(this, _realpath, this.resolve(rp));
        } catch (_3) {
          __privateMethod(this, _PathBase_instances, markENOREALPATH_fn).call(this);
        }
      }
      /**
       * Synchronous {@link realpath}
       */
      realpathSync() {
        if (__privateGet(this, _realpath))
          return __privateGet(this, _realpath);
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & __privateGet(this, _type))
          return void 0;
        try {
          const rp = __privateGet(this, _fs).realpathSync(this.fullpath());
          return __privateSet(this, _realpath, this.resolve(rp));
        } catch (_3) {
          __privateMethod(this, _PathBase_instances, markENOREALPATH_fn).call(this);
        }
      }
      /**
       * Internal method to mark this Path object as the scurry cwd,
       * called by {@link PathScurry#chdir}
       *
       * @internal
       */
      [setAsCwd](oldCwd) {
        if (oldCwd === this)
          return;
        oldCwd.isCWD = false;
        this.isCWD = true;
        const changed = /* @__PURE__ */ new Set([]);
        let rp = [];
        let p3 = this;
        while (p3 && p3.parent) {
          changed.add(p3);
          __privateSet(p3, _relative, rp.join(this.sep));
          __privateSet(p3, _relativePosix, rp.join("/"));
          p3 = p3.parent;
          rp.push("..");
        }
        p3 = oldCwd;
        while (p3 && p3.parent && !changed.has(p3)) {
          __privateSet(p3, _relative, void 0);
          __privateSet(p3, _relativePosix, void 0);
          p3 = p3.parent;
        }
      }
    };
    _fs = new WeakMap();
    _dev = new WeakMap();
    _mode = new WeakMap();
    _nlink = new WeakMap();
    _uid = new WeakMap();
    _gid = new WeakMap();
    _rdev = new WeakMap();
    _blksize = new WeakMap();
    _ino = new WeakMap();
    _size2 = new WeakMap();
    _blocks = new WeakMap();
    _atimeMs = new WeakMap();
    _mtimeMs = new WeakMap();
    _ctimeMs = new WeakMap();
    _birthtimeMs = new WeakMap();
    _atime = new WeakMap();
    _mtime = new WeakMap();
    _ctime = new WeakMap();
    _birthtime = new WeakMap();
    _matchName = new WeakMap();
    _depth = new WeakMap();
    _fullpath = new WeakMap();
    _fullpathPosix = new WeakMap();
    _relative = new WeakMap();
    _relativePosix = new WeakMap();
    _type = new WeakMap();
    _children = new WeakMap();
    _linkTarget = new WeakMap();
    _realpath = new WeakMap();
    _PathBase_instances = new WeakSet();
    resolveParts_fn = function(dirParts) {
      let p3 = this;
      for (const part of dirParts) {
        p3 = p3.child(part);
      }
      return p3;
    };
    readdirSuccess_fn = function(children) {
      var _a4;
      __privateSet(this, _type, __privateGet(this, _type) | READDIR_CALLED);
      for (let p3 = children.provisional; p3 < children.length; p3++) {
        const c3 = children[p3];
        if (c3)
          __privateMethod(_a4 = c3, _PathBase_instances, markENOENT_fn).call(_a4);
      }
    };
    markENOENT_fn = function() {
      if (__privateGet(this, _type) & ENOENT)
        return;
      __privateSet(this, _type, (__privateGet(this, _type) | ENOENT) & IFMT_UNKNOWN);
      __privateMethod(this, _PathBase_instances, markChildrenENOENT_fn).call(this);
    };
    markChildrenENOENT_fn = function() {
      var _a4;
      const children = this.children();
      children.provisional = 0;
      for (const p3 of children) {
        __privateMethod(_a4 = p3, _PathBase_instances, markENOENT_fn).call(_a4);
      }
    };
    markENOREALPATH_fn = function() {
      __privateSet(this, _type, __privateGet(this, _type) | ENOREALPATH);
      __privateMethod(this, _PathBase_instances, markENOTDIR_fn).call(this);
    };
    // save the information when we know the entry is not a dir
    markENOTDIR_fn = function() {
      if (__privateGet(this, _type) & ENOTDIR)
        return;
      let t3 = __privateGet(this, _type);
      if ((t3 & IFMT) === IFDIR)
        t3 &= IFMT_UNKNOWN;
      __privateSet(this, _type, t3 | ENOTDIR);
      __privateMethod(this, _PathBase_instances, markChildrenENOENT_fn).call(this);
    };
    readdirFail_fn = function(code = "") {
      if (code === "ENOTDIR" || code === "EPERM") {
        __privateMethod(this, _PathBase_instances, markENOTDIR_fn).call(this);
      } else if (code === "ENOENT") {
        __privateMethod(this, _PathBase_instances, markENOENT_fn).call(this);
      } else {
        this.children().provisional = 0;
      }
    };
    lstatFail_fn = function(code = "") {
      var _a4;
      if (code === "ENOTDIR") {
        const p3 = this.parent;
        __privateMethod(_a4 = p3, _PathBase_instances, markENOTDIR_fn).call(_a4);
      } else if (code === "ENOENT") {
        __privateMethod(this, _PathBase_instances, markENOENT_fn).call(this);
      }
    };
    readlinkFail_fn = function(code = "") {
      var _a4;
      let ter = __privateGet(this, _type);
      ter |= ENOREADLINK;
      if (code === "ENOENT")
        ter |= ENOENT;
      if (code === "EINVAL" || code === "UNKNOWN") {
        ter &= IFMT_UNKNOWN;
      }
      __privateSet(this, _type, ter);
      if (code === "ENOTDIR" && this.parent) {
        __privateMethod(_a4 = this.parent, _PathBase_instances, markENOTDIR_fn).call(_a4);
      }
    };
    readdirAddChild_fn = function(e3, c3) {
      return __privateMethod(this, _PathBase_instances, readdirMaybePromoteChild_fn).call(this, e3, c3) || __privateMethod(this, _PathBase_instances, readdirAddNewChild_fn).call(this, e3, c3);
    };
    readdirAddNewChild_fn = function(e3, c3) {
      const type = entToType(e3);
      const child = this.newChild(e3.name, type, { parent: this });
      const ifmt = __privateGet(child, _type) & IFMT;
      if (ifmt !== IFDIR && ifmt !== IFLNK && ifmt !== UNKNOWN) {
        __privateSet(child, _type, __privateGet(child, _type) | ENOTDIR);
      }
      c3.unshift(child);
      c3.provisional++;
      return child;
    };
    readdirMaybePromoteChild_fn = function(e3, c3) {
      for (let p3 = c3.provisional; p3 < c3.length; p3++) {
        const pchild = c3[p3];
        const name = this.nocase ? normalizeNocase(e3.name) : normalize(e3.name);
        if (name !== __privateGet(pchild, _matchName)) {
          continue;
        }
        return __privateMethod(this, _PathBase_instances, readdirPromoteChild_fn).call(this, e3, pchild, p3, c3);
      }
    };
    readdirPromoteChild_fn = function(e3, p3, index, c3) {
      const v6 = p3.name;
      __privateSet(p3, _type, __privateGet(p3, _type) & IFMT_UNKNOWN | entToType(e3));
      if (v6 !== e3.name)
        p3.name = e3.name;
      if (index !== c3.provisional) {
        if (index === c3.length - 1)
          c3.pop();
        else
          c3.splice(index, 1);
        c3.unshift(p3);
      }
      c3.provisional++;
      return p3;
    };
    applyStat_fn = function(st) {
      const { atime, atimeMs, birthtime, birthtimeMs, blksize, blocks, ctime, ctimeMs, dev, gid, ino, mode, mtime, mtimeMs, nlink, rdev, size, uid } = st;
      __privateSet(this, _atime, atime);
      __privateSet(this, _atimeMs, atimeMs);
      __privateSet(this, _birthtime, birthtime);
      __privateSet(this, _birthtimeMs, birthtimeMs);
      __privateSet(this, _blksize, blksize);
      __privateSet(this, _blocks, blocks);
      __privateSet(this, _ctime, ctime);
      __privateSet(this, _ctimeMs, ctimeMs);
      __privateSet(this, _dev, dev);
      __privateSet(this, _gid, gid);
      __privateSet(this, _ino, ino);
      __privateSet(this, _mode, mode);
      __privateSet(this, _mtime, mtime);
      __privateSet(this, _mtimeMs, mtimeMs);
      __privateSet(this, _nlink, nlink);
      __privateSet(this, _rdev, rdev);
      __privateSet(this, _size2, size);
      __privateSet(this, _uid, uid);
      const ifmt = entToType(st);
      __privateSet(this, _type, __privateGet(this, _type) & IFMT_UNKNOWN | ifmt | LSTAT_CALLED);
      if (ifmt !== UNKNOWN && ifmt !== IFDIR && ifmt !== IFLNK) {
        __privateSet(this, _type, __privateGet(this, _type) | ENOTDIR);
      }
    };
    _onReaddirCB = new WeakMap();
    _readdirCBInFlight = new WeakMap();
    callOnReaddirCB_fn = function(children) {
      __privateSet(this, _readdirCBInFlight, false);
      const cbs = __privateGet(this, _onReaddirCB).slice();
      __privateGet(this, _onReaddirCB).length = 0;
      cbs.forEach((cb) => cb(null, children));
    };
    _asyncReaddirInFlight = new WeakMap();
    PathWin32 = class _PathWin32 extends PathBase {
      /**
       * Separator for generating path strings.
       */
      sep = "\\";
      /**
       * Separator for parsing path strings.
       */
      splitSep = eitherSep;
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      newChild(name, type = UNKNOWN, opts = {}) {
        return new _PathWin32(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
      /**
       * @internal
       */
      getRootString(path34) {
        return import_node_path.win32.parse(path34).root;
      }
      /**
       * @internal
       */
      getRoot(rootPath) {
        rootPath = uncToDrive(rootPath.toUpperCase());
        if (rootPath === this.root.name) {
          return this.root;
        }
        for (const [compare2, root] of Object.entries(this.roots)) {
          if (this.sameRoot(rootPath, compare2)) {
            return this.roots[rootPath] = root;
          }
        }
        return this.roots[rootPath] = new PathScurryWin32(rootPath, this).root;
      }
      /**
       * @internal
       */
      sameRoot(rootPath, compare2 = this.root.name) {
        rootPath = rootPath.toUpperCase().replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
        return rootPath === compare2;
      }
    };
    PathPosix = class _PathPosix extends PathBase {
      /**
       * separator for parsing path strings
       */
      splitSep = "/";
      /**
       * separator for generating path strings
       */
      sep = "/";
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      getRootString(path34) {
        return path34.startsWith("/") ? "/" : "";
      }
      /**
       * @internal
       */
      getRoot(_rootPath) {
        return this.root;
      }
      /**
       * @internal
       */
      newChild(name, type = UNKNOWN, opts = {}) {
        return new _PathPosix(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
    };
    PathScurryBase = class {
      /**
       * This class should not be instantiated directly.
       *
       * Use PathScurryWin32, PathScurryDarwin, PathScurryPosix, or PathScurry
       *
       * @internal
       */
      constructor(cwd = process.cwd(), pathImpl, sep5, { nocase, childrenCacheSize = 16 * 1024, fs: fs38 = defaultFS } = {}) {
        /**
         * The root Path entry for the current working directory of this Scurry
         */
        __publicField(this, "root");
        /**
         * The string path for the root of this Scurry's current working directory
         */
        __publicField(this, "rootPath");
        /**
         * A collection of all roots encountered, referenced by rootPath
         */
        __publicField(this, "roots");
        /**
         * The Path entry corresponding to this PathScurry's current working directory.
         */
        __publicField(this, "cwd");
        __privateAdd(this, _resolveCache);
        __privateAdd(this, _resolvePosixCache);
        __privateAdd(this, _children2);
        /**
         * Perform path comparisons case-insensitively.
         *
         * Defaults true on Darwin and Windows systems, false elsewhere.
         */
        __publicField(this, "nocase");
        __privateAdd(this, _fs2);
        __privateSet(this, _fs2, fsFromOption(fs38));
        if (cwd instanceof URL || cwd.startsWith("file://")) {
          cwd = (0, import_node_url.fileURLToPath)(cwd);
        }
        const cwdPath = pathImpl.resolve(cwd);
        this.roots = /* @__PURE__ */ Object.create(null);
        this.rootPath = this.parseRootPath(cwdPath);
        __privateSet(this, _resolveCache, new ResolveCache());
        __privateSet(this, _resolvePosixCache, new ResolveCache());
        __privateSet(this, _children2, new ChildrenCache(childrenCacheSize));
        const split2 = cwdPath.substring(this.rootPath.length).split(sep5);
        if (split2.length === 1 && !split2[0]) {
          split2.pop();
        }
        if (nocase === void 0) {
          throw new TypeError("must provide nocase setting to PathScurryBase ctor");
        }
        this.nocase = nocase;
        this.root = this.newRoot(__privateGet(this, _fs2));
        this.roots[this.rootPath] = this.root;
        let prev = this.root;
        let len = split2.length - 1;
        const joinSep = pathImpl.sep;
        let abs = this.rootPath;
        let sawFirst = false;
        for (const part of split2) {
          const l3 = len--;
          prev = prev.child(part, {
            relative: new Array(l3).fill("..").join(joinSep),
            relativePosix: new Array(l3).fill("..").join("/"),
            fullpath: abs += (sawFirst ? "" : joinSep) + part
          });
          sawFirst = true;
        }
        this.cwd = prev;
      }
      /**
       * Get the depth of a provided path, string, or the cwd
       */
      depth(path34 = this.cwd) {
        if (typeof path34 === "string") {
          path34 = this.cwd.resolve(path34);
        }
        return path34.depth();
      }
      /**
       * Return the cache of child entries.  Exposed so subclasses can create
       * child Path objects in a platform-specific way.
       *
       * @internal
       */
      childrenCache() {
        return __privateGet(this, _children2);
      }
      /**
       * Resolve one or more path strings to a resolved string
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolve(...paths) {
        let r3 = "";
        for (let i3 = paths.length - 1; i3 >= 0; i3--) {
          const p3 = paths[i3];
          if (!p3 || p3 === ".")
            continue;
          r3 = r3 ? `${p3}/${r3}` : p3;
          if (this.isAbsolute(p3)) {
            break;
          }
        }
        const cached4 = __privateGet(this, _resolveCache).get(r3);
        if (cached4 !== void 0) {
          return cached4;
        }
        const result3 = this.cwd.resolve(r3).fullpath();
        __privateGet(this, _resolveCache).set(r3, result3);
        return result3;
      }
      /**
       * Resolve one or more path strings to a resolved string, returning
       * the posix path.  Identical to .resolve() on posix systems, but on
       * windows will return a forward-slash separated UNC path.
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolvePosix(...paths) {
        let r3 = "";
        for (let i3 = paths.length - 1; i3 >= 0; i3--) {
          const p3 = paths[i3];
          if (!p3 || p3 === ".")
            continue;
          r3 = r3 ? `${p3}/${r3}` : p3;
          if (this.isAbsolute(p3)) {
            break;
          }
        }
        const cached4 = __privateGet(this, _resolvePosixCache).get(r3);
        if (cached4 !== void 0) {
          return cached4;
        }
        const result3 = this.cwd.resolve(r3).fullpathPosix();
        __privateGet(this, _resolvePosixCache).set(r3, result3);
        return result3;
      }
      /**
       * find the relative path from the cwd to the supplied path string or entry
       */
      relative(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relative();
      }
      /**
       * find the relative path from the cwd to the supplied path string or
       * entry, using / as the path delimiter, even on Windows.
       */
      relativePosix(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relativePosix();
      }
      /**
       * Return the basename for the provided string or Path object
       */
      basename(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.name;
      }
      /**
       * Return the dirname for the provided string or Path object
       */
      dirname(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return (entry.parent || entry).fullpath();
      }
      async readdir(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else {
          const p3 = await entry.readdir();
          return withFileTypes ? p3 : p3.map((e3) => e3.name);
        }
      }
      readdirSync(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else if (withFileTypes) {
          return entry.readdirSync();
        } else {
          return entry.readdirSync().map((e3) => e3.name);
        }
      }
      /**
       * Call lstat() on the string or Path object, and update all known
       * information that can be determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstat();
      }
      /**
       * synchronous {@link PathScurryBase.lstat}
       */
      lstatSync(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstatSync();
      }
      async readlink(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e3 = await entry.readlink();
        return withFileTypes ? e3 : e3 == null ? void 0 : e3.fullpath();
      }
      readlinkSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e3 = entry.readlinkSync();
        return withFileTypes ? e3 : e3 == null ? void 0 : e3.fullpath();
      }
      async realpath(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e3 = await entry.realpath();
        return withFileTypes ? e3 : e3 == null ? void 0 : e3.fullpath();
      }
      realpathSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e3 = entry.realpathSync();
        return withFileTypes ? e3 : e3 == null ? void 0 : e3.fullpath();
      }
      async walk(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = [];
        if (!filter4 || filter4(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const walk = (dir, cb) => {
          dirs.add(dir);
          dir.readdirCB((er, entries) => {
            if (er) {
              return cb(er);
            }
            let len = entries.length;
            if (!len)
              return cb();
            const next = () => {
              if (--len === 0) {
                cb();
              }
            };
            for (const e3 of entries) {
              if (!filter4 || filter4(e3)) {
                results.push(withFileTypes ? e3 : e3.fullpath());
              }
              if (follow && e3.isSymbolicLink()) {
                e3.realpath().then((r3) => (r3 == null ? void 0 : r3.isUnknown()) ? r3.lstat() : r3).then((r3) => (r3 == null ? void 0 : r3.shouldWalk(dirs, walkFilter)) ? walk(r3, next) : next());
              } else {
                if (e3.shouldWalk(dirs, walkFilter)) {
                  walk(e3, next);
                } else {
                  next();
                }
              }
            }
          }, true);
        };
        const start = entry;
        return new Promise((res, rej) => {
          walk(start, (er) => {
            if (er)
              return rej(er);
            res(results);
          });
        });
      }
      walkSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = [];
        if (!filter4 || filter4(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e3 of entries) {
            if (!filter4 || filter4(e3)) {
              results.push(withFileTypes ? e3 : e3.fullpath());
            }
            let r3 = e3;
            if (e3.isSymbolicLink()) {
              if (!(follow && (r3 = e3.realpathSync())))
                continue;
              if (r3.isUnknown())
                r3.lstatSync();
            }
            if (r3.shouldWalk(dirs, walkFilter)) {
              dirs.add(r3);
            }
          }
        }
        return results;
      }
      /**
       * Support for `for await`
       *
       * Alias for {@link PathScurryBase.iterate}
       *
       * Note: As of Node 19, this is very slow, compared to other methods of
       * walking.  Consider using {@link PathScurryBase.stream} if memory overhead
       * and backpressure are concerns, or {@link PathScurryBase.walk} if not.
       */
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
      iterate(entry = this.cwd, options = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          options = entry;
          entry = this.cwd;
        }
        return this.stream(entry, options)[Symbol.asyncIterator]();
      }
      /**
       * Iterating over a PathScurry performs a synchronous walk.
       *
       * Alias for {@link PathScurryBase.iterateSync}
       */
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      *iterateSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        if (!filter4 || filter4(entry)) {
          yield withFileTypes ? entry : entry.fullpath();
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e3 of entries) {
            if (!filter4 || filter4(e3)) {
              yield withFileTypes ? e3 : e3.fullpath();
            }
            let r3 = e3;
            if (e3.isSymbolicLink()) {
              if (!(follow && (r3 = e3.realpathSync())))
                continue;
              if (r3.isUnknown())
                r3.lstatSync();
            }
            if (r3.shouldWalk(dirs, walkFilter)) {
              dirs.add(r3);
            }
          }
        }
      }
      stream(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = new Minipass({ objectMode: true });
        if (!filter4 || filter4(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const queue = [entry];
        let processing = 0;
        const process3 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const onReaddir = (er, entries, didRealpaths = false) => {
              if (er)
                return results.emit("error", er);
              if (follow && !didRealpaths) {
                const promises3 = [];
                for (const e3 of entries) {
                  if (e3.isSymbolicLink()) {
                    promises3.push(e3.realpath().then((r3) => (r3 == null ? void 0 : r3.isUnknown()) ? r3.lstat() : r3));
                  }
                }
                if (promises3.length) {
                  Promise.all(promises3).then(() => onReaddir(null, entries, true));
                  return;
                }
              }
              for (const e3 of entries) {
                if (e3 && (!filter4 || filter4(e3))) {
                  if (!results.write(withFileTypes ? e3 : e3.fullpath())) {
                    paused = true;
                  }
                }
              }
              processing--;
              for (const e3 of entries) {
                const r3 = e3.realpathCached() || e3;
                if (r3.shouldWalk(dirs, walkFilter)) {
                  queue.push(r3);
                }
              }
              if (paused && !results.flowing) {
                results.once("drain", process3);
              } else if (!sync2) {
                process3();
              }
            };
            let sync2 = true;
            dir.readdirCB(onReaddir, true);
            sync2 = false;
          }
        };
        process3();
        return results;
      }
      streamSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter4, walkFilter } = opts;
        const results = new Minipass({ objectMode: true });
        const dirs = /* @__PURE__ */ new Set();
        if (!filter4 || filter4(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const queue = [entry];
        let processing = 0;
        const process3 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const entries = dir.readdirSync();
            for (const e3 of entries) {
              if (!filter4 || filter4(e3)) {
                if (!results.write(withFileTypes ? e3 : e3.fullpath())) {
                  paused = true;
                }
              }
            }
            processing--;
            for (const e3 of entries) {
              let r3 = e3;
              if (e3.isSymbolicLink()) {
                if (!(follow && (r3 = e3.realpathSync())))
                  continue;
                if (r3.isUnknown())
                  r3.lstatSync();
              }
              if (r3.shouldWalk(dirs, walkFilter)) {
                queue.push(r3);
              }
            }
          }
          if (paused && !results.flowing)
            results.once("drain", process3);
        };
        process3();
        return results;
      }
      chdir(path34 = this.cwd) {
        const oldCwd = this.cwd;
        this.cwd = typeof path34 === "string" ? this.cwd.resolve(path34) : path34;
        this.cwd[setAsCwd](oldCwd);
      }
    };
    _resolveCache = new WeakMap();
    _resolvePosixCache = new WeakMap();
    _children2 = new WeakMap();
    _fs2 = new WeakMap();
    PathScurryWin32 = class extends PathScurryBase {
      /**
       * separator for generating path strings
       */
      sep = "\\";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, import_node_path.win32, "\\", { ...opts, nocase });
        this.nocase = nocase;
        for (let p3 = this.cwd; p3; p3 = p3.parent) {
          p3.nocase = this.nocase;
        }
      }
      /**
       * @internal
       */
      parseRootPath(dir) {
        return import_node_path.win32.parse(dir).root.toUpperCase();
      }
      /**
       * @internal
       */
      newRoot(fs38) {
        return new PathWin32(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs38 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p3) {
        return p3.startsWith("/") || p3.startsWith("\\") || /^[a-z]:(\/|\\)/i.test(p3);
      }
    };
    PathScurryPosix = class extends PathScurryBase {
      /**
       * separator for generating path strings
       */
      sep = "/";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = false } = opts;
        super(cwd, import_node_path.posix, "/", { ...opts, nocase });
        this.nocase = nocase;
      }
      /**
       * @internal
       */
      parseRootPath(_dir) {
        return "/";
      }
      /**
       * @internal
       */
      newRoot(fs38) {
        return new PathPosix(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs38 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p3) {
        return p3.startsWith("/");
      }
    };
    PathScurryDarwin = class extends PathScurryPosix {
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, { ...opts, nocase });
      }
    };
    Path = process.platform === "win32" ? PathWin32 : PathPosix;
    PathScurry = process.platform === "win32" ? PathScurryWin32 : process.platform === "darwin" ? PathScurryDarwin : PathScurryPosix;
  }
});

// ../../node_modules/glob/dist/esm/pattern.js
var isPatternList, isGlobList, _patternList, _globList, _index, _platform, _rest, _globString, _isDrive, _isUNC, _isAbsolute, _followGlobstar, _Pattern, Pattern;
var init_pattern = __esm({
  "../../node_modules/glob/dist/esm/pattern.js"() {
    init_esm();
    isPatternList = (pl) => pl.length >= 1;
    isGlobList = (gl) => gl.length >= 1;
    _Pattern = class _Pattern {
      constructor(patternList, globList, index, platform3) {
        __privateAdd(this, _patternList);
        __privateAdd(this, _globList);
        __privateAdd(this, _index);
        __publicField(this, "length");
        __privateAdd(this, _platform);
        __privateAdd(this, _rest);
        __privateAdd(this, _globString);
        __privateAdd(this, _isDrive);
        __privateAdd(this, _isUNC);
        __privateAdd(this, _isAbsolute);
        __privateAdd(this, _followGlobstar, true);
        if (!isPatternList(patternList)) {
          throw new TypeError("empty pattern list");
        }
        if (!isGlobList(globList)) {
          throw new TypeError("empty glob list");
        }
        if (globList.length !== patternList.length) {
          throw new TypeError("mismatched pattern list and glob list lengths");
        }
        this.length = patternList.length;
        if (index < 0 || index >= this.length) {
          throw new TypeError("index out of range");
        }
        __privateSet(this, _patternList, patternList);
        __privateSet(this, _globList, globList);
        __privateSet(this, _index, index);
        __privateSet(this, _platform, platform3);
        if (__privateGet(this, _index) === 0) {
          if (this.isUNC()) {
            const [p0, p1, p22, p3, ...prest] = __privateGet(this, _patternList);
            const [g0, g1, g22, g3, ...grest] = __privateGet(this, _globList);
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p4 = [p0, p1, p22, p3, ""].join("/");
            const g4 = [g0, g1, g22, g3, ""].join("/");
            __privateSet(this, _patternList, [p4, ...prest]);
            __privateSet(this, _globList, [g4, ...grest]);
            this.length = __privateGet(this, _patternList).length;
          } else if (this.isDrive() || this.isAbsolute()) {
            const [p1, ...prest] = __privateGet(this, _patternList);
            const [g1, ...grest] = __privateGet(this, _globList);
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p3 = p1 + "/";
            const g3 = g1 + "/";
            __privateSet(this, _patternList, [p3, ...prest]);
            __privateSet(this, _globList, [g3, ...grest]);
            this.length = __privateGet(this, _patternList).length;
          }
        }
      }
      /**
       * The first entry in the parsed list of patterns
       */
      pattern() {
        return __privateGet(this, _patternList)[__privateGet(this, _index)];
      }
      /**
       * true of if pattern() returns a string
       */
      isString() {
        return typeof __privateGet(this, _patternList)[__privateGet(this, _index)] === "string";
      }
      /**
       * true of if pattern() returns GLOBSTAR
       */
      isGlobstar() {
        return __privateGet(this, _patternList)[__privateGet(this, _index)] === GLOBSTAR;
      }
      /**
       * true if pattern() returns a regexp
       */
      isRegExp() {
        return __privateGet(this, _patternList)[__privateGet(this, _index)] instanceof RegExp;
      }
      /**
       * The /-joined set of glob parts that make up this pattern
       */
      globString() {
        return __privateSet(this, _globString, __privateGet(this, _globString) || (__privateGet(this, _index) === 0 ? this.isAbsolute() ? __privateGet(this, _globList)[0] + __privateGet(this, _globList).slice(1).join("/") : __privateGet(this, _globList).join("/") : __privateGet(this, _globList).slice(__privateGet(this, _index)).join("/")));
      }
      /**
       * true if there are more pattern parts after this one
       */
      hasMore() {
        return this.length > __privateGet(this, _index) + 1;
      }
      /**
       * The rest of the pattern after this part, or null if this is the end
       */
      rest() {
        if (__privateGet(this, _rest) !== void 0)
          return __privateGet(this, _rest);
        if (!this.hasMore())
          return __privateSet(this, _rest, null);
        __privateSet(this, _rest, new _Pattern(__privateGet(this, _patternList), __privateGet(this, _globList), __privateGet(this, _index) + 1, __privateGet(this, _platform)));
        __privateSet(__privateGet(this, _rest), _isAbsolute, __privateGet(this, _isAbsolute));
        __privateSet(__privateGet(this, _rest), _isUNC, __privateGet(this, _isUNC));
        __privateSet(__privateGet(this, _rest), _isDrive, __privateGet(this, _isDrive));
        return __privateGet(this, _rest);
      }
      /**
       * true if the pattern represents a //unc/path/ on windows
       */
      isUNC() {
        const pl = __privateGet(this, _patternList);
        return __privateGet(this, _isUNC) !== void 0 ? __privateGet(this, _isUNC) : __privateSet(this, _isUNC, __privateGet(this, _platform) === "win32" && __privateGet(this, _index) === 0 && pl[0] === "" && pl[1] === "" && typeof pl[2] === "string" && !!pl[2] && typeof pl[3] === "string" && !!pl[3]);
      }
      // pattern like C:/...
      // split = ['C:', ...]
      // XXX: would be nice to handle patterns like `c:*` to test the cwd
      // in c: for *, but I don't know of a way to even figure out what that
      // cwd is without actually chdir'ing into it?
      /**
       * True if the pattern starts with a drive letter on Windows
       */
      isDrive() {
        const pl = __privateGet(this, _patternList);
        return __privateGet(this, _isDrive) !== void 0 ? __privateGet(this, _isDrive) : __privateSet(this, _isDrive, __privateGet(this, _platform) === "win32" && __privateGet(this, _index) === 0 && this.length > 1 && typeof pl[0] === "string" && /^[a-z]:$/i.test(pl[0]));
      }
      // pattern = '/' or '/...' or '/x/...'
      // split = ['', ''] or ['', ...] or ['', 'x', ...]
      // Drive and UNC both considered absolute on windows
      /**
       * True if the pattern is rooted on an absolute path
       */
      isAbsolute() {
        const pl = __privateGet(this, _patternList);
        return __privateGet(this, _isAbsolute) !== void 0 ? __privateGet(this, _isAbsolute) : __privateSet(this, _isAbsolute, pl[0] === "" && pl.length > 1 || this.isDrive() || this.isUNC());
      }
      /**
       * consume the root of the pattern, and return it
       */
      root() {
        const p3 = __privateGet(this, _patternList)[0];
        return typeof p3 === "string" && this.isAbsolute() && __privateGet(this, _index) === 0 ? p3 : "";
      }
      /**
       * Check to see if the current globstar pattern is allowed to follow
       * a symbolic link.
       */
      checkFollowGlobstar() {
        return !(__privateGet(this, _index) === 0 || !this.isGlobstar() || !__privateGet(this, _followGlobstar));
      }
      /**
       * Mark that the current globstar pattern is following a symbolic link
       */
      markFollowGlobstar() {
        if (__privateGet(this, _index) === 0 || !this.isGlobstar() || !__privateGet(this, _followGlobstar))
          return false;
        __privateSet(this, _followGlobstar, false);
        return true;
      }
    };
    _patternList = new WeakMap();
    _globList = new WeakMap();
    _index = new WeakMap();
    _platform = new WeakMap();
    _rest = new WeakMap();
    _globString = new WeakMap();
    _isDrive = new WeakMap();
    _isUNC = new WeakMap();
    _isAbsolute = new WeakMap();
    _followGlobstar = new WeakMap();
    Pattern = _Pattern;
  }
});

// ../../node_modules/glob/dist/esm/ignore.js
var defaultPlatform2, Ignore;
var init_ignore = __esm({
  "../../node_modules/glob/dist/esm/ignore.js"() {
    init_esm();
    init_pattern();
    defaultPlatform2 = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    Ignore = class {
      relative;
      relativeChildren;
      absolute;
      absoluteChildren;
      platform;
      mmopts;
      constructor(ignored, { nobrace, nocase, noext, noglobstar, platform: platform3 = defaultPlatform2 }) {
        this.relative = [];
        this.absolute = [];
        this.relativeChildren = [];
        this.absoluteChildren = [];
        this.platform = platform3;
        this.mmopts = {
          dot: true,
          nobrace,
          nocase,
          noext,
          noglobstar,
          optimizationLevel: 2,
          platform: platform3,
          nocomment: true,
          nonegate: true
        };
        for (const ign of ignored)
          this.add(ign);
      }
      add(ign) {
        const mm = new Minimatch(ign, this.mmopts);
        for (let i3 = 0; i3 < mm.set.length; i3++) {
          const parsed = mm.set[i3];
          const globParts = mm.globParts[i3];
          if (!parsed || !globParts) {
            throw new Error("invalid pattern object");
          }
          while (parsed[0] === "." && globParts[0] === ".") {
            parsed.shift();
            globParts.shift();
          }
          const p3 = new Pattern(parsed, globParts, 0, this.platform);
          const m3 = new Minimatch(p3.globString(), this.mmopts);
          const children = globParts[globParts.length - 1] === "**";
          const absolute = p3.isAbsolute();
          if (absolute)
            this.absolute.push(m3);
          else
            this.relative.push(m3);
          if (children) {
            if (absolute)
              this.absoluteChildren.push(m3);
            else
              this.relativeChildren.push(m3);
          }
        }
      }
      ignored(p3) {
        const fullpath = p3.fullpath();
        const fullpaths = `${fullpath}/`;
        const relative2 = p3.relative() || ".";
        const relatives = `${relative2}/`;
        for (const m3 of this.relative) {
          if (m3.match(relative2) || m3.match(relatives))
            return true;
        }
        for (const m3 of this.absolute) {
          if (m3.match(fullpath) || m3.match(fullpaths))
            return true;
        }
        return false;
      }
      childrenIgnored(p3) {
        const fullpath = p3.fullpath() + "/";
        const relative2 = (p3.relative() || ".") + "/";
        for (const m3 of this.relativeChildren) {
          if (m3.match(relative2))
            return true;
        }
        for (const m3 of this.absoluteChildren) {
          if (m3.match(fullpath))
            return true;
        }
        return false;
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/processor.js
var HasWalkedCache, MatchRecord, SubWalks, Processor;
var init_processor = __esm({
  "../../node_modules/glob/dist/esm/processor.js"() {
    init_esm();
    HasWalkedCache = class _HasWalkedCache {
      store;
      constructor(store = /* @__PURE__ */ new Map()) {
        this.store = store;
      }
      copy() {
        return new _HasWalkedCache(new Map(this.store));
      }
      hasWalked(target, pattern) {
        var _a4;
        return (_a4 = this.store.get(target.fullpath())) == null ? void 0 : _a4.has(pattern.globString());
      }
      storeWalked(target, pattern) {
        const fullpath = target.fullpath();
        const cached4 = this.store.get(fullpath);
        if (cached4)
          cached4.add(pattern.globString());
        else
          this.store.set(fullpath, /* @__PURE__ */ new Set([pattern.globString()]));
      }
    };
    MatchRecord = class {
      store = /* @__PURE__ */ new Map();
      add(target, absolute, ifDir) {
        const n3 = (absolute ? 2 : 0) | (ifDir ? 1 : 0);
        const current = this.store.get(target);
        this.store.set(target, current === void 0 ? n3 : n3 & current);
      }
      // match, absolute, ifdir
      entries() {
        return [...this.store.entries()].map(([path34, n3]) => [
          path34,
          !!(n3 & 2),
          !!(n3 & 1)
        ]);
      }
    };
    SubWalks = class {
      store = /* @__PURE__ */ new Map();
      add(target, pattern) {
        if (!target.canReaddir()) {
          return;
        }
        const subs = this.store.get(target);
        if (subs) {
          if (!subs.find((p3) => p3.globString() === pattern.globString())) {
            subs.push(pattern);
          }
        } else
          this.store.set(target, [pattern]);
      }
      get(target) {
        const subs = this.store.get(target);
        if (!subs) {
          throw new Error("attempting to walk unknown path");
        }
        return subs;
      }
      entries() {
        return this.keys().map((k3) => [k3, this.store.get(k3)]);
      }
      keys() {
        return [...this.store.keys()].filter((t3) => t3.canReaddir());
      }
    };
    Processor = class _Processor {
      hasWalkedCache;
      matches = new MatchRecord();
      subwalks = new SubWalks();
      patterns;
      follow;
      dot;
      opts;
      constructor(opts, hasWalkedCache) {
        this.opts = opts;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.hasWalkedCache = hasWalkedCache ? hasWalkedCache.copy() : new HasWalkedCache();
      }
      processPatterns(target, patterns) {
        this.patterns = patterns;
        const processingSet = patterns.map((p3) => [target, p3]);
        for (let [t3, pattern] of processingSet) {
          this.hasWalkedCache.storeWalked(t3, pattern);
          const root = pattern.root();
          const absolute = pattern.isAbsolute() && this.opts.absolute !== false;
          if (root) {
            t3 = t3.resolve(root === "/" && this.opts.root !== void 0 ? this.opts.root : root);
            const rest2 = pattern.rest();
            if (!rest2) {
              this.matches.add(t3, true, false);
              continue;
            } else {
              pattern = rest2;
            }
          }
          if (t3.isENOENT())
            continue;
          let p3;
          let rest;
          let changed = false;
          while (typeof (p3 = pattern.pattern()) === "string" && (rest = pattern.rest())) {
            const c3 = t3.resolve(p3);
            t3 = c3;
            pattern = rest;
            changed = true;
          }
          p3 = pattern.pattern();
          rest = pattern.rest();
          if (changed) {
            if (this.hasWalkedCache.hasWalked(t3, pattern))
              continue;
            this.hasWalkedCache.storeWalked(t3, pattern);
          }
          if (typeof p3 === "string") {
            const ifDir = p3 === ".." || p3 === "" || p3 === ".";
            this.matches.add(t3.resolve(p3), absolute, ifDir);
            continue;
          } else if (p3 === GLOBSTAR) {
            if (!t3.isSymbolicLink() || this.follow || pattern.checkFollowGlobstar()) {
              this.subwalks.add(t3, pattern);
            }
            const rp = rest == null ? void 0 : rest.pattern();
            const rrest = rest == null ? void 0 : rest.rest();
            if (!rest || (rp === "" || rp === ".") && !rrest) {
              this.matches.add(t3, absolute, rp === "" || rp === ".");
            } else {
              if (rp === "..") {
                const tp = t3.parent || t3;
                if (!rrest)
                  this.matches.add(tp, absolute, true);
                else if (!this.hasWalkedCache.hasWalked(tp, rrest)) {
                  this.subwalks.add(tp, rrest);
                }
              }
            }
          } else if (p3 instanceof RegExp) {
            this.subwalks.add(t3, pattern);
          }
        }
        return this;
      }
      subwalkTargets() {
        return this.subwalks.keys();
      }
      child() {
        return new _Processor(this.opts, this.hasWalkedCache);
      }
      // return a new Processor containing the subwalks for each
      // child entry, and a set of matches, and
      // a hasWalkedCache that's a copy of this one
      // then we're going to call
      filterEntries(parent, entries) {
        const patterns = this.subwalks.get(parent);
        const results = this.child();
        for (const e3 of entries) {
          for (const pattern of patterns) {
            const absolute = pattern.isAbsolute();
            const p3 = pattern.pattern();
            const rest = pattern.rest();
            if (p3 === GLOBSTAR) {
              results.testGlobstar(e3, pattern, rest, absolute);
            } else if (p3 instanceof RegExp) {
              results.testRegExp(e3, p3, rest, absolute);
            } else {
              results.testString(e3, p3, rest, absolute);
            }
          }
        }
        return results;
      }
      testGlobstar(e3, pattern, rest, absolute) {
        if (this.dot || !e3.name.startsWith(".")) {
          if (!pattern.hasMore()) {
            this.matches.add(e3, absolute, false);
          }
          if (e3.canReaddir()) {
            if (this.follow || !e3.isSymbolicLink()) {
              this.subwalks.add(e3, pattern);
            } else if (e3.isSymbolicLink()) {
              if (rest && pattern.checkFollowGlobstar()) {
                this.subwalks.add(e3, rest);
              } else if (pattern.markFollowGlobstar()) {
                this.subwalks.add(e3, pattern);
              }
            }
          }
        }
        if (rest) {
          const rp = rest.pattern();
          if (typeof rp === "string" && // dots and empty were handled already
          rp !== ".." && rp !== "" && rp !== ".") {
            this.testString(e3, rp, rest.rest(), absolute);
          } else if (rp === "..") {
            const ep = e3.parent || e3;
            this.subwalks.add(ep, rest);
          } else if (rp instanceof RegExp) {
            this.testRegExp(e3, rp, rest.rest(), absolute);
          }
        }
      }
      testRegExp(e3, p3, rest, absolute) {
        if (!p3.test(e3.name))
          return;
        if (!rest) {
          this.matches.add(e3, absolute, false);
        } else {
          this.subwalks.add(e3, rest);
        }
      }
      testString(e3, p3, rest, absolute) {
        if (!e3.isNamed(p3))
          return;
        if (!rest) {
          this.matches.add(e3, absolute, false);
        } else {
          this.subwalks.add(e3, rest);
        }
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/walker.js
var makeIgnore, _onResume, _ignore, _sep, _GlobUtil_instances, ignored_fn, childrenIgnored_fn, GlobUtil, GlobWalker, GlobStream;
var init_walker = __esm({
  "../../node_modules/glob/dist/esm/walker.js"() {
    init_esm3();
    init_ignore();
    init_processor();
    makeIgnore = (ignore, opts) => typeof ignore === "string" ? new Ignore([ignore], opts) : Array.isArray(ignore) ? new Ignore(ignore, opts) : ignore;
    GlobUtil = class {
      constructor(patterns, path34, opts) {
        __privateAdd(this, _GlobUtil_instances);
        __publicField(this, "path");
        __publicField(this, "patterns");
        __publicField(this, "opts");
        __publicField(this, "seen", /* @__PURE__ */ new Set());
        __publicField(this, "paused", false);
        __publicField(this, "aborted", false);
        __privateAdd(this, _onResume, []);
        __privateAdd(this, _ignore);
        __privateAdd(this, _sep);
        __publicField(this, "signal");
        __publicField(this, "maxDepth");
        __publicField(this, "includeChildMatches");
        this.patterns = patterns;
        this.path = path34;
        this.opts = opts;
        __privateSet(this, _sep, !opts.posix && opts.platform === "win32" ? "\\" : "/");
        this.includeChildMatches = opts.includeChildMatches !== false;
        if (opts.ignore || !this.includeChildMatches) {
          __privateSet(this, _ignore, makeIgnore(opts.ignore ?? [], opts));
          if (!this.includeChildMatches && typeof __privateGet(this, _ignore).add !== "function") {
            const m3 = "cannot ignore child matches, ignore lacks add() method.";
            throw new Error(m3);
          }
        }
        this.maxDepth = opts.maxDepth || Infinity;
        if (opts.signal) {
          this.signal = opts.signal;
          this.signal.addEventListener("abort", () => {
            __privateGet(this, _onResume).length = 0;
          });
        }
      }
      // backpressure mechanism
      pause() {
        this.paused = true;
      }
      resume() {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          return;
        this.paused = false;
        let fn = void 0;
        while (!this.paused && (fn = __privateGet(this, _onResume).shift())) {
          fn();
        }
      }
      onResume(fn) {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          return;
        if (!this.paused) {
          fn();
        } else {
          __privateGet(this, _onResume).push(fn);
        }
      }
      // do the requisite realpath/stat checking, and return the path
      // to add or undefined to filter it out.
      async matchCheck(e3, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e3.realpathCached() || await e3.realpath();
          if (!rpc)
            return void 0;
          e3 = rpc;
        }
        const needStat = e3.isUnknown() || this.opts.stat;
        const s3 = needStat ? await e3.lstat() : e3;
        if (this.opts.follow && this.opts.nodir && (s3 == null ? void 0 : s3.isSymbolicLink())) {
          const target = await s3.realpath();
          if (target && (target.isUnknown() || this.opts.stat)) {
            await target.lstat();
          }
        }
        return this.matchCheckTest(s3, ifDir);
      }
      matchCheckTest(e3, ifDir) {
        var _a4;
        return e3 && (this.maxDepth === Infinity || e3.depth() <= this.maxDepth) && (!ifDir || e3.canReaddir()) && (!this.opts.nodir || !e3.isDirectory()) && (!this.opts.nodir || !this.opts.follow || !e3.isSymbolicLink() || !((_a4 = e3.realpathCached()) == null ? void 0 : _a4.isDirectory())) && !__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, e3) ? e3 : void 0;
      }
      matchCheckSync(e3, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e3.realpathCached() || e3.realpathSync();
          if (!rpc)
            return void 0;
          e3 = rpc;
        }
        const needStat = e3.isUnknown() || this.opts.stat;
        const s3 = needStat ? e3.lstatSync() : e3;
        if (this.opts.follow && this.opts.nodir && (s3 == null ? void 0 : s3.isSymbolicLink())) {
          const target = s3.realpathSync();
          if (target && ((target == null ? void 0 : target.isUnknown()) || this.opts.stat)) {
            target.lstatSync();
          }
        }
        return this.matchCheckTest(s3, ifDir);
      }
      matchFinish(e3, absolute) {
        var _a4;
        if (__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, e3))
          return;
        if (!this.includeChildMatches && ((_a4 = __privateGet(this, _ignore)) == null ? void 0 : _a4.add)) {
          const ign = `${e3.relativePosix()}/**`;
          __privateGet(this, _ignore).add(ign);
        }
        const abs = this.opts.absolute === void 0 ? absolute : this.opts.absolute;
        this.seen.add(e3);
        const mark = this.opts.mark && e3.isDirectory() ? __privateGet(this, _sep) : "";
        if (this.opts.withFileTypes) {
          this.matchEmit(e3);
        } else if (abs) {
          const abs2 = this.opts.posix ? e3.fullpathPosix() : e3.fullpath();
          this.matchEmit(abs2 + mark);
        } else {
          const rel = this.opts.posix ? e3.relativePosix() : e3.relative();
          const pre = this.opts.dotRelative && !rel.startsWith(".." + __privateGet(this, _sep)) ? "." + __privateGet(this, _sep) : "";
          this.matchEmit(!rel ? "." + mark : pre + rel + mark);
        }
      }
      async match(e3, absolute, ifDir) {
        const p3 = await this.matchCheck(e3, ifDir);
        if (p3)
          this.matchFinish(p3, absolute);
      }
      matchSync(e3, absolute, ifDir) {
        const p3 = this.matchCheckSync(e3, ifDir);
        if (p3)
          this.matchFinish(p3, absolute);
      }
      walkCB(target, patterns, cb) {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          cb();
        this.walkCB2(target, patterns, new Processor(this.opts), cb);
      }
      walkCB2(target, patterns, processor, cb) {
        var _a4;
        if (__privateMethod(this, _GlobUtil_instances, childrenIgnored_fn).call(this, target))
          return cb();
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m3, absolute, ifDir] of processor.matches.entries()) {
          if (__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, m3))
            continue;
          tasks++;
          this.match(m3, absolute, ifDir).then(() => next());
        }
        for (const t3 of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t3.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const childrenCached = t3.readdirCached();
          if (t3.calledReaddir())
            this.walkCB3(t3, childrenCached, processor, next);
          else {
            t3.readdirCB((_3, entries) => this.walkCB3(t3, entries, processor, next), true);
          }
        }
        next();
      }
      walkCB3(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m3, absolute, ifDir] of processor.matches.entries()) {
          if (__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, m3))
            continue;
          tasks++;
          this.match(m3, absolute, ifDir).then(() => next());
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2(target2, patterns, processor.child(), next);
        }
        next();
      }
      walkCBSync(target, patterns, cb) {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          cb();
        this.walkCB2Sync(target, patterns, new Processor(this.opts), cb);
      }
      walkCB2Sync(target, patterns, processor, cb) {
        var _a4;
        if (__privateMethod(this, _GlobUtil_instances, childrenIgnored_fn).call(this, target))
          return cb();
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2Sync(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m3, absolute, ifDir] of processor.matches.entries()) {
          if (__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, m3))
            continue;
          this.matchSync(m3, absolute, ifDir);
        }
        for (const t3 of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t3.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const children = t3.readdirSync();
          this.walkCB3Sync(t3, children, processor, next);
        }
        next();
      }
      walkCB3Sync(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m3, absolute, ifDir] of processor.matches.entries()) {
          if (__privateMethod(this, _GlobUtil_instances, ignored_fn).call(this, m3))
            continue;
          this.matchSync(m3, absolute, ifDir);
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2Sync(target2, patterns, processor.child(), next);
        }
        next();
      }
    };
    _onResume = new WeakMap();
    _ignore = new WeakMap();
    _sep = new WeakMap();
    _GlobUtil_instances = new WeakSet();
    ignored_fn = function(path34) {
      var _a4, _b2;
      return this.seen.has(path34) || !!((_b2 = (_a4 = __privateGet(this, _ignore)) == null ? void 0 : _a4.ignored) == null ? void 0 : _b2.call(_a4, path34));
    };
    childrenIgnored_fn = function(path34) {
      var _a4, _b2;
      return !!((_b2 = (_a4 = __privateGet(this, _ignore)) == null ? void 0 : _a4.childrenIgnored) == null ? void 0 : _b2.call(_a4, path34));
    };
    GlobWalker = class extends GlobUtil {
      matches = /* @__PURE__ */ new Set();
      constructor(patterns, path34, opts) {
        super(patterns, path34, opts);
      }
      matchEmit(e3) {
        this.matches.add(e3);
      }
      async walk() {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          await this.path.lstat();
        }
        await new Promise((res, rej) => {
          this.walkCB(this.path, this.patterns, () => {
            var _a5;
            if ((_a5 = this.signal) == null ? void 0 : _a5.aborted) {
              rej(this.signal.reason);
            } else {
              res(this.matches);
            }
          });
        });
        return this.matches;
      }
      walkSync() {
        var _a4;
        if ((_a4 = this.signal) == null ? void 0 : _a4.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => {
          var _a5;
          if ((_a5 = this.signal) == null ? void 0 : _a5.aborted)
            throw this.signal.reason;
        });
        return this.matches;
      }
    };
    GlobStream = class extends GlobUtil {
      results;
      constructor(patterns, path34, opts) {
        super(patterns, path34, opts);
        this.results = new Minipass({
          signal: this.signal,
          objectMode: true
        });
        this.results.on("drain", () => this.resume());
        this.results.on("resume", () => this.resume());
      }
      matchEmit(e3) {
        this.results.write(e3);
        if (!this.results.flowing)
          this.pause();
      }
      stream() {
        const target = this.path;
        if (target.isUnknown()) {
          target.lstat().then(() => {
            this.walkCB(target, this.patterns, () => this.results.end());
          });
        } else {
          this.walkCB(target, this.patterns, () => this.results.end());
        }
        return this.results;
      }
      streamSync() {
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => this.results.end());
        return this.results;
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/glob.js
var import_node_url2, defaultPlatform3, Glob;
var init_glob = __esm({
  "../../node_modules/glob/dist/esm/glob.js"() {
    init_esm();
    import_node_url2 = require("url");
    init_esm4();
    init_pattern();
    init_walker();
    defaultPlatform3 = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    Glob = class {
      absolute;
      cwd;
      root;
      dot;
      dotRelative;
      follow;
      ignore;
      magicalBraces;
      mark;
      matchBase;
      maxDepth;
      nobrace;
      nocase;
      nodir;
      noext;
      noglobstar;
      pattern;
      platform;
      realpath;
      scurry;
      stat;
      signal;
      windowsPathsNoEscape;
      withFileTypes;
      includeChildMatches;
      /**
       * The options provided to the constructor.
       */
      opts;
      /**
       * An array of parsed immutable {@link Pattern} objects.
       */
      patterns;
      /**
       * All options are stored as properties on the `Glob` object.
       *
       * See {@link GlobOptions} for full options descriptions.
       *
       * Note that a previous `Glob` object can be passed as the
       * `GlobOptions` to another `Glob` instantiation to re-use settings
       * and caches with a new pattern.
       *
       * Traversal functions can be called multiple times to run the walk
       * again.
       */
      constructor(pattern, opts) {
        if (!opts)
          throw new TypeError("glob options required");
        this.withFileTypes = !!opts.withFileTypes;
        this.signal = opts.signal;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.dotRelative = !!opts.dotRelative;
        this.nodir = !!opts.nodir;
        this.mark = !!opts.mark;
        if (!opts.cwd) {
          this.cwd = "";
        } else if (opts.cwd instanceof URL || opts.cwd.startsWith("file://")) {
          opts.cwd = (0, import_node_url2.fileURLToPath)(opts.cwd);
        }
        this.cwd = opts.cwd || "";
        this.root = opts.root;
        this.magicalBraces = !!opts.magicalBraces;
        this.nobrace = !!opts.nobrace;
        this.noext = !!opts.noext;
        this.realpath = !!opts.realpath;
        this.absolute = opts.absolute;
        this.includeChildMatches = opts.includeChildMatches !== false;
        this.noglobstar = !!opts.noglobstar;
        this.matchBase = !!opts.matchBase;
        this.maxDepth = typeof opts.maxDepth === "number" ? opts.maxDepth : Infinity;
        this.stat = !!opts.stat;
        this.ignore = opts.ignore;
        if (this.withFileTypes && this.absolute !== void 0) {
          throw new Error("cannot set absolute and withFileTypes:true");
        }
        if (typeof pattern === "string") {
          pattern = [pattern];
        }
        this.windowsPathsNoEscape = !!opts.windowsPathsNoEscape || opts.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          pattern = pattern.map((p3) => p3.replace(/\\/g, "/"));
        }
        if (this.matchBase) {
          if (opts.noglobstar) {
            throw new TypeError("base matching requires globstar");
          }
          pattern = pattern.map((p3) => p3.includes("/") ? p3 : `./**/${p3}`);
        }
        this.pattern = pattern;
        this.platform = opts.platform || defaultPlatform3;
        this.opts = { ...opts, platform: this.platform };
        if (opts.scurry) {
          this.scurry = opts.scurry;
          if (opts.nocase !== void 0 && opts.nocase !== opts.scurry.nocase) {
            throw new Error("nocase option contradicts provided scurry option");
          }
        } else {
          const Scurry = opts.platform === "win32" ? PathScurryWin32 : opts.platform === "darwin" ? PathScurryDarwin : opts.platform ? PathScurryPosix : PathScurry;
          this.scurry = new Scurry(this.cwd, {
            nocase: opts.nocase,
            fs: opts.fs
          });
        }
        this.nocase = this.scurry.nocase;
        const nocaseMagicOnly = this.platform === "darwin" || this.platform === "win32";
        const mmo = {
          // default nocase based on platform
          ...opts,
          dot: this.dot,
          matchBase: this.matchBase,
          nobrace: this.nobrace,
          nocase: this.nocase,
          nocaseMagicOnly,
          nocomment: true,
          noext: this.noext,
          nonegate: true,
          optimizationLevel: 2,
          platform: this.platform,
          windowsPathsNoEscape: this.windowsPathsNoEscape,
          debug: !!this.opts.debug
        };
        const mms = this.pattern.map((p3) => new Minimatch(p3, mmo));
        const [matchSet, globParts] = mms.reduce((set, m3) => {
          set[0].push(...m3.set);
          set[1].push(...m3.globParts);
          return set;
        }, [[], []]);
        this.patterns = matchSet.map((set, i3) => {
          const g3 = globParts[i3];
          if (!g3)
            throw new Error("invalid pattern object");
          return new Pattern(set, g3, 0, this.platform);
        });
      }
      async walk() {
        return [
          ...await new GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walk()
        ];
      }
      walkSync() {
        return [
          ...new GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walkSync()
        ];
      }
      stream() {
        return new GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).stream();
      }
      streamSync() {
        return new GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).streamSync();
      }
      /**
       * Default sync iteration function. Returns a Generator that
       * iterates over the results.
       */
      iterateSync() {
        return this.streamSync()[Symbol.iterator]();
      }
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      /**
       * Default async iteration function. Returns an AsyncGenerator that
       * iterates over the results.
       */
      iterate() {
        return this.stream()[Symbol.asyncIterator]();
      }
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
    };
  }
});

// ../../node_modules/glob/dist/esm/has-magic.js
var hasMagic;
var init_has_magic = __esm({
  "../../node_modules/glob/dist/esm/has-magic.js"() {
    init_esm();
    hasMagic = (pattern, options = {}) => {
      if (!Array.isArray(pattern)) {
        pattern = [pattern];
      }
      for (const p3 of pattern) {
        if (new Minimatch(p3, options).hasMagic())
          return true;
      }
      return false;
    };
  }
});

// ../../node_modules/glob/dist/esm/index.js
function globStreamSync(pattern, options = {}) {
  return new Glob(pattern, options).streamSync();
}
function globStream(pattern, options = {}) {
  return new Glob(pattern, options).stream();
}
function globSync(pattern, options = {}) {
  return new Glob(pattern, options).walkSync();
}
async function glob_(pattern, options = {}) {
  return new Glob(pattern, options).walk();
}
function globIterateSync(pattern, options = {}) {
  return new Glob(pattern, options).iterateSync();
}
function globIterate(pattern, options = {}) {
  return new Glob(pattern, options).iterate();
}
var streamSync, stream, iterateSync, iterate, sync, glob;
var init_esm5 = __esm({
  "../../node_modules/glob/dist/esm/index.js"() {
    init_esm();
    init_glob();
    init_has_magic();
    init_esm();
    init_glob();
    init_has_magic();
    init_ignore();
    streamSync = globStreamSync;
    stream = Object.assign(globStream, { sync: globStreamSync });
    iterateSync = globIterateSync;
    iterate = Object.assign(globIterate, {
      sync: globIterateSync
    });
    sync = Object.assign(globSync, {
      stream: globStreamSync,
      iterate: globIterateSync
    });
    glob = Object.assign(glob_, {
      glob: glob_,
      globSync,
      sync,
      globStream,
      stream,
      globStreamSync,
      streamSync,
      globIterate,
      iterate,
      globIterateSync,
      iterateSync,
      Glob,
      hasMagic,
      escape,
      unescape: unescape2
    });
    glob.glob = glob;
  }
});

// ../../node_modules/readdir-glob/node_modules/minimatch/lib/path.js
var require_path = __commonJS({
  "../../node_modules/readdir-glob/node_modules/minimatch/lib/path.js"(exports2, module2) {
    var isWindows = typeof process === "object" && process && process.platform === "win32";
    module2.exports = isWindows ? { sep: "\\" } : { sep: "/" };
  }
});

// ../../node_modules/readdir-glob/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "../../node_modules/readdir-glob/node_modules/minimatch/minimatch.js"(exports2, module2) {
    var minimatch4 = module2.exports = (p3, pattern, options = {}) => {
      assertValidPattern4(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch4(pattern, options).match(p3);
    };
    module2.exports = minimatch4;
    var path34 = require_path();
    minimatch4.sep = path34.sep;
    var GLOBSTAR4 = Symbol("globstar **");
    minimatch4.GLOBSTAR = GLOBSTAR4;
    var expand4 = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark7 = "[^/]";
    var star7 = qmark7 + "*?";
    var twoStarDot4 = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot4 = "(?:(?!(?:\\/|^)\\.).)*?";
    var charSet = (s3) => s3.split("").reduce((set, c3) => {
      set[c3] = true;
      return set;
    }, {});
    var reSpecials4 = charSet("().*{}+?[]^$\\!");
    var addPatternStartSet = charSet("[.(");
    var slashSplit = /\/+/;
    minimatch4.filter = (pattern, options = {}) => (p3, i3, list) => minimatch4(p3, pattern, options);
    var ext4 = (a3, b3 = {}) => {
      const t3 = {};
      Object.keys(a3).forEach((k3) => t3[k3] = a3[k3]);
      Object.keys(b3).forEach((k3) => t3[k3] = b3[k3]);
      return t3;
    };
    minimatch4.defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch4;
      }
      const orig = minimatch4;
      const m3 = (p3, pattern, options) => orig(p3, pattern, ext4(def, options));
      m3.Minimatch = class Minimatch extends orig.Minimatch {
        constructor(pattern, options) {
          super(pattern, ext4(def, options));
        }
      };
      m3.Minimatch.defaults = (options) => orig.defaults(ext4(def, options)).Minimatch;
      m3.filter = (pattern, options) => orig.filter(pattern, ext4(def, options));
      m3.defaults = (options) => orig.defaults(ext4(def, options));
      m3.makeRe = (pattern, options) => orig.makeRe(pattern, ext4(def, options));
      m3.braceExpand = (pattern, options) => orig.braceExpand(pattern, ext4(def, options));
      m3.match = (list, pattern, options) => orig.match(list, pattern, ext4(def, options));
      return m3;
    };
    minimatch4.braceExpand = (pattern, options) => braceExpand4(pattern, options);
    var braceExpand4 = (pattern, options = {}) => {
      assertValidPattern4(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand4(pattern);
    };
    var MAX_PATTERN_LENGTH4 = 1024 * 64;
    var assertValidPattern4 = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH4) {
        throw new TypeError("pattern is too long");
      }
    };
    var SUBPARSE = Symbol("subparse");
    minimatch4.makeRe = (pattern, options) => new Minimatch4(pattern, options || {}).makeRe();
    minimatch4.match = (list, pattern, options = {}) => {
      const mm = new Minimatch4(pattern, options);
      list = list.filter((f3) => mm.match(f3));
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    var globUnescape = (s3) => s3.replace(/\\(.)/g, "$1");
    var charUnescape = (s3) => s3.replace(/\\([^-\]])/g, "$1");
    var regExpEscape7 = (s3) => s3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var braExpEscape = (s3) => s3.replace(/[[\]\\]/g, "\\$&");
    var Minimatch4 = class {
      constructor(pattern, options) {
        assertValidPattern4(pattern);
        if (!options) options = {};
        this.options = options;
        this.set = [];
        this.pattern = pattern;
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.regexp = null;
        this.negate = false;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.make();
      }
      debug() {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        let set = this.globSet = this.braceExpand();
        if (options.debug) this.debug = (...args) => console.error(...args);
        this.debug(this.pattern, set);
        set = this.globParts = set.map((s3) => s3.split(slashSplit));
        this.debug(this.pattern, set);
        set = set.map((s3, si, set2) => s3.map(this.parse, this));
        this.debug(this.pattern, set);
        set = set.filter((s3) => s3.indexOf(false) === -1);
        this.debug(this.pattern, set);
        this.set = set;
      }
      parseNegate() {
        if (this.options.nonegate) return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i3 = 0; i3 < pattern.length && pattern.charAt(i3) === "!"; i3++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset) this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial) {
        var options = this.options;
        this.debug(
          "matchOne",
          { "this": this, file, pattern }
        );
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
          this.debug("matchOne loop");
          var p3 = pattern[pi];
          var f3 = file[fi];
          this.debug(pattern, p3, f3);
          if (p3 === false) return false;
          if (p3 === GLOBSTAR4) {
            this.debug("GLOBSTAR", [pattern, p3, f3]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".") return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) return true;
            }
            return false;
          }
          var hit;
          if (typeof p3 === "string") {
            hit = f3 === p3;
            this.debug("string match", p3, f3, hit);
          } else {
            hit = f3.match(p3);
            this.debug("pattern match", p3, f3, hit);
          }
          if (!hit) return false;
        }
        if (fi === fl && pi === pl) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl) {
          return fi === fl - 1 && file[fi] === "";
        }
        throw new Error("wtf?");
      }
      braceExpand() {
        return braceExpand4(this.pattern, this.options);
      }
      parse(pattern, isSub) {
        assertValidPattern4(pattern);
        const options = this.options;
        if (pattern === "**") {
          if (!options.noglobstar)
            return GLOBSTAR4;
          else
            pattern = "*";
        }
        if (pattern === "") return "";
        let re = "";
        let hasMagic2 = false;
        let escaping = false;
        const patternListStack = [];
        const negativeLists = [];
        let stateChar;
        let inClass = false;
        let reClassStart = -1;
        let classStart = -1;
        let cs;
        let pl;
        let sp;
        let dotTravAllowed = pattern.charAt(0) === ".";
        let dotFileAllowed = options.dot || dotTravAllowed;
        const patternStart = () => dotTravAllowed ? "" : dotFileAllowed ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
        const subPatternStart = (p3) => p3.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
        const clearStateChar = () => {
          if (stateChar) {
            switch (stateChar) {
              case "*":
                re += star7;
                hasMagic2 = true;
                break;
              case "?":
                re += qmark7;
                hasMagic2 = true;
                break;
              default:
                re += "\\" + stateChar;
                break;
            }
            this.debug("clearStateChar %j %j", stateChar, re);
            stateChar = false;
          }
        };
        for (let i3 = 0, c3; i3 < pattern.length && (c3 = pattern.charAt(i3)); i3++) {
          this.debug("%s	%s %s %j", pattern, i3, re, c3);
          if (escaping) {
            if (c3 === "/") {
              return false;
            }
            if (reSpecials4[c3]) {
              re += "\\";
            }
            re += c3;
            escaping = false;
            continue;
          }
          switch (c3) {
            /* istanbul ignore next */
            case "/": {
              return false;
            }
            case "\\":
              if (inClass && pattern.charAt(i3 + 1) === "-") {
                re += c3;
                continue;
              }
              clearStateChar();
              escaping = true;
              continue;
            // the various stateChar values
            // for the "extglob" stuff.
            case "?":
            case "*":
            case "+":
            case "@":
            case "!":
              this.debug("%s	%s %s %j <-- stateChar", pattern, i3, re, c3);
              if (inClass) {
                this.debug("  in class");
                if (c3 === "!" && i3 === classStart + 1) c3 = "^";
                re += c3;
                continue;
              }
              this.debug("call clearStateChar %j", stateChar);
              clearStateChar();
              stateChar = c3;
              if (options.noext) clearStateChar();
              continue;
            case "(": {
              if (inClass) {
                re += "(";
                continue;
              }
              if (!stateChar) {
                re += "\\(";
                continue;
              }
              const plEntry = {
                type: stateChar,
                start: i3 - 1,
                reStart: re.length,
                open: plTypes[stateChar].open,
                close: plTypes[stateChar].close
              };
              this.debug(this.pattern, "	", plEntry);
              patternListStack.push(plEntry);
              re += plEntry.open;
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re += subPatternStart(pattern.slice(i3 + 1));
              }
              this.debug("plType %j %j", stateChar, re);
              stateChar = false;
              continue;
            }
            case ")": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re += "\\)";
                continue;
              }
              patternListStack.pop();
              clearStateChar();
              hasMagic2 = true;
              pl = plEntry;
              re += pl.close;
              if (pl.type === "!") {
                negativeLists.push(Object.assign(pl, { reEnd: re.length }));
              }
              continue;
            }
            case "|": {
              const plEntry = patternListStack[patternListStack.length - 1];
              if (inClass || !plEntry) {
                re += "\\|";
                continue;
              }
              clearStateChar();
              re += "|";
              if (plEntry.start === 0 && plEntry.type !== "!") {
                dotTravAllowed = true;
                re += subPatternStart(pattern.slice(i3 + 1));
              }
              continue;
            }
            // these are mostly the same in regexp and glob
            case "[":
              clearStateChar();
              if (inClass) {
                re += "\\" + c3;
                continue;
              }
              inClass = true;
              classStart = i3;
              reClassStart = re.length;
              re += c3;
              continue;
            case "]":
              if (i3 === classStart + 1 || !inClass) {
                re += "\\" + c3;
                continue;
              }
              cs = pattern.substring(classStart + 1, i3);
              try {
                RegExp("[" + braExpEscape(charUnescape(cs)) + "]");
                re += c3;
              } catch (er) {
                re = re.substring(0, reClassStart) + "(?:$.)";
              }
              hasMagic2 = true;
              inClass = false;
              continue;
            default:
              clearStateChar();
              if (reSpecials4[c3] && !(c3 === "^" && inClass)) {
                re += "\\";
              }
              re += c3;
              break;
          }
        }
        if (inClass) {
          cs = pattern.slice(classStart + 1);
          sp = this.parse(cs, SUBPARSE);
          re = re.substring(0, reClassStart) + "\\[" + sp[0];
          hasMagic2 = hasMagic2 || sp[1];
        }
        for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
          let tail;
          tail = re.slice(pl.reStart + pl.open.length);
          this.debug("setting tail", re, pl);
          tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, (_3, $1, $2) => {
            if (!$2) {
              $2 = "\\";
            }
            return $1 + $1 + $2 + "|";
          });
          this.debug("tail=%j\n   %s", tail, tail, pl, re);
          const t3 = pl.type === "*" ? star7 : pl.type === "?" ? qmark7 : "\\" + pl.type;
          hasMagic2 = true;
          re = re.slice(0, pl.reStart) + t3 + "\\(" + tail;
        }
        clearStateChar();
        if (escaping) {
          re += "\\\\";
        }
        const addPatternStart4 = addPatternStartSet[re.charAt(0)];
        for (let n3 = negativeLists.length - 1; n3 > -1; n3--) {
          const nl = negativeLists[n3];
          const nlBefore = re.slice(0, nl.reStart);
          const nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
          let nlAfter = re.slice(nl.reEnd);
          const nlLast = re.slice(nl.reEnd - 8, nl.reEnd) + nlAfter;
          const closeParensBefore = nlBefore.split(")").length;
          const openParensBefore = nlBefore.split("(").length - closeParensBefore;
          let cleanAfter = nlAfter;
          for (let i3 = 0; i3 < openParensBefore; i3++) {
            cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
          }
          nlAfter = cleanAfter;
          const dollar = nlAfter === "" && isSub !== SUBPARSE ? "(?:$|\\/)" : "";
          re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (re !== "" && hasMagic2) {
          re = "(?=.)" + re;
        }
        if (addPatternStart4) {
          re = patternStart() + re;
        }
        if (isSub === SUBPARSE) {
          return [re, hasMagic2];
        }
        if (options.nocase && !hasMagic2) {
          hasMagic2 = pattern.toUpperCase() !== pattern.toLowerCase();
        }
        if (!hasMagic2) {
          return globUnescape(pattern);
        }
        const flags = options.nocase ? "i" : "";
        try {
          return Object.assign(new RegExp("^" + re + "$", flags), {
            _glob: pattern,
            _src: re
          });
        } catch (er) {
          return new RegExp("$.");
        }
      }
      makeRe() {
        if (this.regexp || this.regexp === false) return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star7 : options.dot ? twoStarDot4 : twoStarNoDot4;
        const flags = options.nocase ? "i" : "";
        let re = set.map((pattern) => {
          pattern = pattern.map(
            (p3) => typeof p3 === "string" ? regExpEscape7(p3) : p3 === GLOBSTAR4 ? GLOBSTAR4 : p3._src
          ).reduce((set2, p3) => {
            if (!(set2[set2.length - 1] === GLOBSTAR4 && p3 === GLOBSTAR4)) {
              set2.push(p3);
            }
            return set2;
          }, []);
          pattern.forEach((p3, i3) => {
            if (p3 !== GLOBSTAR4 || pattern[i3 - 1] === GLOBSTAR4) {
              return;
            }
            if (i3 === 0) {
              if (pattern.length > 1) {
                pattern[i3 + 1] = "(?:\\/|" + twoStar + "\\/)?" + pattern[i3 + 1];
              } else {
                pattern[i3] = twoStar;
              }
            } else if (i3 === pattern.length - 1) {
              pattern[i3 - 1] += "(?:\\/|" + twoStar + ")?";
            } else {
              pattern[i3 - 1] += "(?:\\/|\\/" + twoStar + "\\/)" + pattern[i3 + 1];
              pattern[i3 + 1] = GLOBSTAR4;
            }
          });
          return pattern.filter((p3) => p3 !== GLOBSTAR4).join("/");
        }).join("|");
        re = "^(?:" + re + ")$";
        if (this.negate) re = "^(?!" + re + ").*$";
        try {
          this.regexp = new RegExp(re, flags);
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      match(f3, partial = this.partial) {
        this.debug("match", f3, this.pattern);
        if (this.comment) return false;
        if (this.empty) return f3 === "";
        if (f3 === "/" && partial) return true;
        const options = this.options;
        if (path34.sep !== "/") {
          f3 = f3.split(path34.sep).join("/");
        }
        f3 = f3.split(slashSplit);
        this.debug(this.pattern, "split", f3);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename;
        for (let i3 = f3.length - 1; i3 >= 0; i3--) {
          filename = f3[i3];
          if (filename) break;
        }
        for (let i3 = 0; i3 < set.length; i3++) {
          const pattern = set[i3];
          let file = f3;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) return true;
            return !this.negate;
          }
        }
        if (options.flipNegate) return false;
        return this.negate;
      }
      static defaults(def) {
        return minimatch4.defaults(def).Minimatch;
      }
    };
    minimatch4.Minimatch = Minimatch4;
  }
});

// ../../node_modules/readdir-glob/index.js
var require_readdir_glob = __commonJS({
  "../../node_modules/readdir-glob/index.js"(exports2, module2) {
    module2.exports = readdirGlob;
    var fs38 = require("fs");
    var { EventEmitter: EventEmitter2 } = require("events");
    var { Minimatch: Minimatch4 } = require_minimatch();
    var { resolve: resolve12 } = require("path");
    function readdir3(dir, strict) {
      return new Promise((resolve13, reject) => {
        fs38.readdir(dir, { withFileTypes: true }, (err, files) => {
          if (err) {
            switch (err.code) {
              case "ENOTDIR":
                if (strict) {
                  reject(err);
                } else {
                  resolve13([]);
                }
                break;
              case "ENOTSUP":
              // Operation not supported
              case "ENOENT":
              // No such file or directory
              case "ENAMETOOLONG":
              // Filename too long
              case "UNKNOWN":
                resolve13([]);
                break;
              case "ELOOP":
              // Too many levels of symbolic links
              default:
                reject(err);
                break;
            }
          } else {
            resolve13(files);
          }
        });
      });
    }
    function stat5(file, followSymlinks) {
      return new Promise((resolve13, reject) => {
        const statFunc = followSymlinks ? fs38.stat : fs38.lstat;
        statFunc(file, (err, stats) => {
          if (err) {
            switch (err.code) {
              case "ENOENT":
                if (followSymlinks) {
                  resolve13(stat5(file, false));
                } else {
                  resolve13(null);
                }
                break;
              default:
                resolve13(null);
                break;
            }
          } else {
            resolve13(stats);
          }
        });
      });
    }
    async function* exploreWalkAsync(dir, path34, followSymlinks, useStat, shouldSkip, strict) {
      let files = await readdir3(path34 + dir, strict);
      for (const file of files) {
        let name = file.name;
        if (name === void 0) {
          name = file;
          useStat = true;
        }
        const filename = dir + "/" + name;
        const relative2 = filename.slice(1);
        const absolute = path34 + "/" + relative2;
        let stats = null;
        if (useStat || followSymlinks) {
          stats = await stat5(absolute, followSymlinks);
        }
        if (!stats && file.name !== void 0) {
          stats = file;
        }
        if (stats === null) {
          stats = { isDirectory: () => false };
        }
        if (stats.isDirectory()) {
          if (!shouldSkip(relative2)) {
            yield { relative: relative2, absolute, stats };
            yield* exploreWalkAsync(filename, path34, followSymlinks, useStat, shouldSkip, false);
          }
        } else {
          yield { relative: relative2, absolute, stats };
        }
      }
    }
    async function* explore(path34, followSymlinks, useStat, shouldSkip) {
      yield* exploreWalkAsync("", path34, followSymlinks, useStat, shouldSkip, true);
    }
    function readOptions(options) {
      return {
        pattern: options.pattern,
        dot: !!options.dot,
        noglobstar: !!options.noglobstar,
        matchBase: !!options.matchBase,
        nocase: !!options.nocase,
        ignore: options.ignore,
        skip: options.skip,
        follow: !!options.follow,
        stat: !!options.stat,
        nodir: !!options.nodir,
        mark: !!options.mark,
        silent: !!options.silent,
        absolute: !!options.absolute
      };
    }
    var ReaddirGlob = class extends EventEmitter2 {
      constructor(cwd, options, cb) {
        super();
        if (typeof options === "function") {
          cb = options;
          options = null;
        }
        this.options = readOptions(options || {});
        this.matchers = [];
        if (this.options.pattern) {
          const matchers = Array.isArray(this.options.pattern) ? this.options.pattern : [this.options.pattern];
          this.matchers = matchers.map(
            (m3) => new Minimatch4(m3, {
              dot: this.options.dot,
              noglobstar: this.options.noglobstar,
              matchBase: this.options.matchBase,
              nocase: this.options.nocase
            })
          );
        }
        this.ignoreMatchers = [];
        if (this.options.ignore) {
          const ignorePatterns = Array.isArray(this.options.ignore) ? this.options.ignore : [this.options.ignore];
          this.ignoreMatchers = ignorePatterns.map(
            (ignore) => new Minimatch4(ignore, { dot: true })
          );
        }
        this.skipMatchers = [];
        if (this.options.skip) {
          const skipPatterns = Array.isArray(this.options.skip) ? this.options.skip : [this.options.skip];
          this.skipMatchers = skipPatterns.map(
            (skip) => new Minimatch4(skip, { dot: true })
          );
        }
        this.iterator = explore(resolve12(cwd || "."), this.options.follow, this.options.stat, this._shouldSkipDirectory.bind(this));
        this.paused = false;
        this.inactive = false;
        this.aborted = false;
        if (cb) {
          this._matches = [];
          this.on("match", (match4) => this._matches.push(this.options.absolute ? match4.absolute : match4.relative));
          this.on("error", (err) => cb(err));
          this.on("end", () => cb(null, this._matches));
        }
        setTimeout(() => this._next(), 0);
      }
      _shouldSkipDirectory(relative2) {
        return this.skipMatchers.some((m3) => m3.match(relative2));
      }
      _fileMatches(relative2, isDirectory) {
        const file = relative2 + (isDirectory ? "/" : "");
        return (this.matchers.length === 0 || this.matchers.some((m3) => m3.match(file))) && !this.ignoreMatchers.some((m3) => m3.match(file)) && (!this.options.nodir || !isDirectory);
      }
      _next() {
        if (!this.paused && !this.aborted) {
          this.iterator.next().then((obj) => {
            if (!obj.done) {
              const isDirectory = obj.value.stats.isDirectory();
              if (this._fileMatches(obj.value.relative, isDirectory)) {
                let relative2 = obj.value.relative;
                let absolute = obj.value.absolute;
                if (this.options.mark && isDirectory) {
                  relative2 += "/";
                  absolute += "/";
                }
                if (this.options.stat) {
                  this.emit("match", { relative: relative2, absolute, stat: obj.value.stats });
                } else {
                  this.emit("match", { relative: relative2, absolute });
                }
              }
              this._next(this.iterator);
            } else {
              this.emit("end");
            }
          }).catch((err) => {
            this.abort();
            this.emit("error", err);
            if (!err.code && !this.options.silent) {
              console.error(err);
            }
          });
        } else {
          this.inactive = true;
        }
      }
      abort() {
        this.aborted = true;
      }
      pause() {
        this.paused = true;
      }
      resume() {
        this.paused = false;
        if (this.inactive) {
          this.inactive = false;
          this._next();
        }
      }
    };
    function readdirGlob(pattern, options, cb) {
      return new ReaddirGlob(pattern, options, cb);
    }
    readdirGlob.ReaddirGlob = ReaddirGlob;
  }
});

// ../../node_modules/async/dist/async.js
var require_async = __commonJS({
  "../../node_modules/async/dist/async.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2.async = {}));
    })(exports2, function(exports3) {
      "use strict";
      function apply(fn, ...args) {
        return (...callArgs) => fn(...args, ...callArgs);
      }
      function initialParams(fn) {
        return function(...args) {
          var callback = args.pop();
          return fn.call(this, args, callback);
        };
      }
      var hasQueueMicrotask = typeof queueMicrotask === "function" && queueMicrotask;
      var hasSetImmediate = typeof setImmediate === "function" && setImmediate;
      var hasNextTick = typeof process === "object" && typeof process.nextTick === "function";
      function fallback(fn) {
        setTimeout(fn, 0);
      }
      function wrap(defer2) {
        return (fn, ...args) => defer2(() => fn(...args));
      }
      var _defer$1;
      if (hasQueueMicrotask) {
        _defer$1 = queueMicrotask;
      } else if (hasSetImmediate) {
        _defer$1 = setImmediate;
      } else if (hasNextTick) {
        _defer$1 = process.nextTick;
      } else {
        _defer$1 = fallback;
      }
      var setImmediate$1 = wrap(_defer$1);
      function asyncify(func) {
        if (isAsync(func)) {
          return function(...args) {
            const callback = args.pop();
            const promise = func.apply(this, args);
            return handlePromise(promise, callback);
          };
        }
        return initialParams(function(args, callback) {
          var result3;
          try {
            result3 = func.apply(this, args);
          } catch (e3) {
            return callback(e3);
          }
          if (result3 && typeof result3.then === "function") {
            return handlePromise(result3, callback);
          } else {
            callback(null, result3);
          }
        });
      }
      function handlePromise(promise, callback) {
        return promise.then((value) => {
          invokeCallback(callback, null, value);
        }, (err) => {
          invokeCallback(callback, err && (err instanceof Error || err.message) ? err : new Error(err));
        });
      }
      function invokeCallback(callback, error5, value) {
        try {
          callback(error5, value);
        } catch (err) {
          setImmediate$1((e3) => {
            throw e3;
          }, err);
        }
      }
      function isAsync(fn) {
        return fn[Symbol.toStringTag] === "AsyncFunction";
      }
      function isAsyncGenerator(fn) {
        return fn[Symbol.toStringTag] === "AsyncGenerator";
      }
      function isAsyncIterable(obj) {
        return typeof obj[Symbol.asyncIterator] === "function";
      }
      function wrapAsync(asyncFn) {
        if (typeof asyncFn !== "function") throw new Error("expected a function");
        return isAsync(asyncFn) ? asyncify(asyncFn) : asyncFn;
      }
      function awaitify(asyncFn, arity) {
        if (!arity) arity = asyncFn.length;
        if (!arity) throw new Error("arity is undefined");
        function awaitable(...args) {
          if (typeof args[arity - 1] === "function") {
            return asyncFn.apply(this, args);
          }
          return new Promise((resolve12, reject2) => {
            args[arity - 1] = (err, ...cbArgs) => {
              if (err) return reject2(err);
              resolve12(cbArgs.length > 1 ? cbArgs : cbArgs[0]);
            };
            asyncFn.apply(this, args);
          });
        }
        return awaitable;
      }
      function applyEach$1(eachfn) {
        return function applyEach2(fns, ...callArgs) {
          const go = awaitify(function(callback) {
            var that = this;
            return eachfn(fns, (fn, cb) => {
              wrapAsync(fn).apply(that, callArgs.concat(cb));
            }, callback);
          });
          return go;
        };
      }
      function _asyncMap(eachfn, arr, iteratee, callback) {
        arr = arr || [];
        var results = [];
        var counter = 0;
        var _iteratee = wrapAsync(iteratee);
        return eachfn(arr, (value, _3, iterCb) => {
          var index2 = counter++;
          _iteratee(value, (err, v6) => {
            results[index2] = v6;
            iterCb(err);
          });
        }, (err) => {
          callback(err, results);
        });
      }
      function isArrayLike(value) {
        return value && typeof value.length === "number" && value.length >= 0 && value.length % 1 === 0;
      }
      const breakLoop = {};
      function once(fn) {
        function wrapper(...args) {
          if (fn === null) return;
          var callFn = fn;
          fn = null;
          callFn.apply(this, args);
        }
        Object.assign(wrapper, fn);
        return wrapper;
      }
      function getIterator(coll) {
        return coll[Symbol.iterator] && coll[Symbol.iterator]();
      }
      function createArrayIterator(coll) {
        var i3 = -1;
        var len = coll.length;
        return function next() {
          return ++i3 < len ? { value: coll[i3], key: i3 } : null;
        };
      }
      function createES2015Iterator(iterator) {
        var i3 = -1;
        return function next() {
          var item = iterator.next();
          if (item.done)
            return null;
          i3++;
          return { value: item.value, key: i3 };
        };
      }
      function createObjectIterator(obj) {
        var okeys = obj ? Object.keys(obj) : [];
        var i3 = -1;
        var len = okeys.length;
        return function next() {
          var key = okeys[++i3];
          if (key === "__proto__") {
            return next();
          }
          return i3 < len ? { value: obj[key], key } : null;
        };
      }
      function createIterator(coll) {
        if (isArrayLike(coll)) {
          return createArrayIterator(coll);
        }
        var iterator = getIterator(coll);
        return iterator ? createES2015Iterator(iterator) : createObjectIterator(coll);
      }
      function onlyOnce(fn) {
        return function(...args) {
          if (fn === null) throw new Error("Callback was already called.");
          var callFn = fn;
          fn = null;
          callFn.apply(this, args);
        };
      }
      function asyncEachOfLimit(generator, limit, iteratee, callback) {
        let done = false;
        let canceled = false;
        let awaiting = false;
        let running = 0;
        let idx = 0;
        function replenish() {
          if (running >= limit || awaiting || done) return;
          awaiting = true;
          generator.next().then(({ value, done: iterDone }) => {
            if (canceled || done) return;
            awaiting = false;
            if (iterDone) {
              done = true;
              if (running <= 0) {
                callback(null);
              }
              return;
            }
            running++;
            iteratee(value, idx, iterateeCallback);
            idx++;
            replenish();
          }).catch(handleError);
        }
        function iterateeCallback(err, result3) {
          running -= 1;
          if (canceled) return;
          if (err) return handleError(err);
          if (err === false) {
            done = true;
            canceled = true;
            return;
          }
          if (result3 === breakLoop || done && running <= 0) {
            done = true;
            return callback(null);
          }
          replenish();
        }
        function handleError(err) {
          if (canceled) return;
          awaiting = false;
          done = true;
          callback(err);
        }
        replenish();
      }
      var eachOfLimit$2 = (limit) => {
        return (obj, iteratee, callback) => {
          callback = once(callback);
          if (limit <= 0) {
            throw new RangeError("concurrency limit cannot be less than 1");
          }
          if (!obj) {
            return callback(null);
          }
          if (isAsyncGenerator(obj)) {
            return asyncEachOfLimit(obj, limit, iteratee, callback);
          }
          if (isAsyncIterable(obj)) {
            return asyncEachOfLimit(obj[Symbol.asyncIterator](), limit, iteratee, callback);
          }
          var nextElem = createIterator(obj);
          var done = false;
          var canceled = false;
          var running = 0;
          var looping = false;
          function iterateeCallback(err, value) {
            if (canceled) return;
            running -= 1;
            if (err) {
              done = true;
              callback(err);
            } else if (err === false) {
              done = true;
              canceled = true;
            } else if (value === breakLoop || done && running <= 0) {
              done = true;
              return callback(null);
            } else if (!looping) {
              replenish();
            }
          }
          function replenish() {
            looping = true;
            while (running < limit && !done) {
              var elem = nextElem();
              if (elem === null) {
                done = true;
                if (running <= 0) {
                  callback(null);
                }
                return;
              }
              running += 1;
              iteratee(elem.value, elem.key, onlyOnce(iterateeCallback));
            }
            looping = false;
          }
          replenish();
        };
      };
      function eachOfLimit(coll, limit, iteratee, callback) {
        return eachOfLimit$2(limit)(coll, wrapAsync(iteratee), callback);
      }
      var eachOfLimit$1 = awaitify(eachOfLimit, 4);
      function eachOfArrayLike(coll, iteratee, callback) {
        callback = once(callback);
        var index2 = 0, completed = 0, { length } = coll, canceled = false;
        if (length === 0) {
          callback(null);
        }
        function iteratorCallback(err, value) {
          if (err === false) {
            canceled = true;
          }
          if (canceled === true) return;
          if (err) {
            callback(err);
          } else if (++completed === length || value === breakLoop) {
            callback(null);
          }
        }
        for (; index2 < length; index2++) {
          iteratee(coll[index2], index2, onlyOnce(iteratorCallback));
        }
      }
      function eachOfGeneric(coll, iteratee, callback) {
        return eachOfLimit$1(coll, Infinity, iteratee, callback);
      }
      function eachOf(coll, iteratee, callback) {
        var eachOfImplementation = isArrayLike(coll) ? eachOfArrayLike : eachOfGeneric;
        return eachOfImplementation(coll, wrapAsync(iteratee), callback);
      }
      var eachOf$1 = awaitify(eachOf, 3);
      function map2(coll, iteratee, callback) {
        return _asyncMap(eachOf$1, coll, iteratee, callback);
      }
      var map$1 = awaitify(map2, 3);
      var applyEach = applyEach$1(map$1);
      function eachOfSeries(coll, iteratee, callback) {
        return eachOfLimit$1(coll, 1, iteratee, callback);
      }
      var eachOfSeries$1 = awaitify(eachOfSeries, 3);
      function mapSeries(coll, iteratee, callback) {
        return _asyncMap(eachOfSeries$1, coll, iteratee, callback);
      }
      var mapSeries$1 = awaitify(mapSeries, 3);
      var applyEachSeries = applyEach$1(mapSeries$1);
      const PROMISE_SYMBOL = Symbol("promiseCallback");
      function promiseCallback() {
        let resolve12, reject2;
        function callback(err, ...args) {
          if (err) return reject2(err);
          resolve12(args.length > 1 ? args : args[0]);
        }
        callback[PROMISE_SYMBOL] = new Promise((res, rej) => {
          resolve12 = res, reject2 = rej;
        });
        return callback;
      }
      function auto(tasks, concurrency, callback) {
        if (typeof concurrency !== "number") {
          callback = concurrency;
          concurrency = null;
        }
        callback = once(callback || promiseCallback());
        var numTasks = Object.keys(tasks).length;
        if (!numTasks) {
          return callback(null);
        }
        if (!concurrency) {
          concurrency = numTasks;
        }
        var results = {};
        var runningTasks = 0;
        var canceled = false;
        var hasError = false;
        var listeners = /* @__PURE__ */ Object.create(null);
        var readyTasks = [];
        var readyToCheck = [];
        var uncheckedDependencies = {};
        Object.keys(tasks).forEach((key) => {
          var task = tasks[key];
          if (!Array.isArray(task)) {
            enqueueTask(key, [task]);
            readyToCheck.push(key);
            return;
          }
          var dependencies = task.slice(0, task.length - 1);
          var remainingDependencies = dependencies.length;
          if (remainingDependencies === 0) {
            enqueueTask(key, task);
            readyToCheck.push(key);
            return;
          }
          uncheckedDependencies[key] = remainingDependencies;
          dependencies.forEach((dependencyName) => {
            if (!tasks[dependencyName]) {
              throw new Error("async.auto task `" + key + "` has a non-existent dependency `" + dependencyName + "` in " + dependencies.join(", "));
            }
            addListener(dependencyName, () => {
              remainingDependencies--;
              if (remainingDependencies === 0) {
                enqueueTask(key, task);
              }
            });
          });
        });
        checkForDeadlocks();
        processQueue();
        function enqueueTask(key, task) {
          readyTasks.push(() => runTask(key, task));
        }
        function processQueue() {
          if (canceled) return;
          if (readyTasks.length === 0 && runningTasks === 0) {
            return callback(null, results);
          }
          while (readyTasks.length && runningTasks < concurrency) {
            var run = readyTasks.shift();
            run();
          }
        }
        function addListener(taskName, fn) {
          var taskListeners = listeners[taskName];
          if (!taskListeners) {
            taskListeners = listeners[taskName] = [];
          }
          taskListeners.push(fn);
        }
        function taskComplete(taskName) {
          var taskListeners = listeners[taskName] || [];
          taskListeners.forEach((fn) => fn());
          processQueue();
        }
        function runTask(key, task) {
          if (hasError) return;
          var taskCallback = onlyOnce((err, ...result3) => {
            runningTasks--;
            if (err === false) {
              canceled = true;
              return;
            }
            if (result3.length < 2) {
              [result3] = result3;
            }
            if (err) {
              var safeResults = {};
              Object.keys(results).forEach((rkey) => {
                safeResults[rkey] = results[rkey];
              });
              safeResults[key] = result3;
              hasError = true;
              listeners = /* @__PURE__ */ Object.create(null);
              if (canceled) return;
              callback(err, safeResults);
            } else {
              results[key] = result3;
              taskComplete(key);
            }
          });
          runningTasks++;
          var taskFn = wrapAsync(task[task.length - 1]);
          if (task.length > 1) {
            taskFn(results, taskCallback);
          } else {
            taskFn(taskCallback);
          }
        }
        function checkForDeadlocks() {
          var currentTask;
          var counter = 0;
          while (readyToCheck.length) {
            currentTask = readyToCheck.pop();
            counter++;
            getDependents(currentTask).forEach((dependent) => {
              if (--uncheckedDependencies[dependent] === 0) {
                readyToCheck.push(dependent);
              }
            });
          }
          if (counter !== numTasks) {
            throw new Error(
              "async.auto cannot execute tasks due to a recursive dependency"
            );
          }
        }
        function getDependents(taskName) {
          var result3 = [];
          Object.keys(tasks).forEach((key) => {
            const task = tasks[key];
            if (Array.isArray(task) && task.indexOf(taskName) >= 0) {
              result3.push(key);
            }
          });
          return result3;
        }
        return callback[PROMISE_SYMBOL];
      }
      var FN_ARGS = /^(?:async\s)?(?:function)?\s*(?:\w+\s*)?\(([^)]+)\)(?:\s*{)/;
      var ARROW_FN_ARGS = /^(?:async\s)?\s*(?:\(\s*)?((?:[^)=\s]\s*)*)(?:\)\s*)?=>/;
      var FN_ARG_SPLIT = /,/;
      var FN_ARG = /(=.+)?(\s*)$/;
      function stripComments(string) {
        let stripped = "";
        let index2 = 0;
        let endBlockComment = string.indexOf("*/");
        while (index2 < string.length) {
          if (string[index2] === "/" && string[index2 + 1] === "/") {
            let endIndex = string.indexOf("\n", index2);
            index2 = endIndex === -1 ? string.length : endIndex;
          } else if (endBlockComment !== -1 && string[index2] === "/" && string[index2 + 1] === "*") {
            let endIndex = string.indexOf("*/", index2);
            if (endIndex !== -1) {
              index2 = endIndex + 2;
              endBlockComment = string.indexOf("*/", index2);
            } else {
              stripped += string[index2];
              index2++;
            }
          } else {
            stripped += string[index2];
            index2++;
          }
        }
        return stripped;
      }
      function parseParams(func) {
        const src = stripComments(func.toString());
        let match4 = src.match(FN_ARGS);
        if (!match4) {
          match4 = src.match(ARROW_FN_ARGS);
        }
        if (!match4) throw new Error("could not parse args in autoInject\nSource:\n" + src);
        let [, args] = match4;
        return args.replace(/\s/g, "").split(FN_ARG_SPLIT).map((arg) => arg.replace(FN_ARG, "").trim());
      }
      function autoInject(tasks, callback) {
        var newTasks = {};
        Object.keys(tasks).forEach((key) => {
          var taskFn = tasks[key];
          var params;
          var fnIsAsync = isAsync(taskFn);
          var hasNoDeps = !fnIsAsync && taskFn.length === 1 || fnIsAsync && taskFn.length === 0;
          if (Array.isArray(taskFn)) {
            params = [...taskFn];
            taskFn = params.pop();
            newTasks[key] = params.concat(params.length > 0 ? newTask : taskFn);
          } else if (hasNoDeps) {
            newTasks[key] = taskFn;
          } else {
            params = parseParams(taskFn);
            if (taskFn.length === 0 && !fnIsAsync && params.length === 0) {
              throw new Error("autoInject task functions require explicit parameters.");
            }
            if (!fnIsAsync) params.pop();
            newTasks[key] = params.concat(newTask);
          }
          function newTask(results, taskCb) {
            var newArgs = params.map((name) => results[name]);
            newArgs.push(taskCb);
            wrapAsync(taskFn)(...newArgs);
          }
        });
        return auto(newTasks, callback);
      }
      class DLL {
        constructor() {
          this.head = this.tail = null;
          this.length = 0;
        }
        removeLink(node) {
          if (node.prev) node.prev.next = node.next;
          else this.head = node.next;
          if (node.next) node.next.prev = node.prev;
          else this.tail = node.prev;
          node.prev = node.next = null;
          this.length -= 1;
          return node;
        }
        empty() {
          while (this.head) this.shift();
          return this;
        }
        insertAfter(node, newNode) {
          newNode.prev = node;
          newNode.next = node.next;
          if (node.next) node.next.prev = newNode;
          else this.tail = newNode;
          node.next = newNode;
          this.length += 1;
        }
        insertBefore(node, newNode) {
          newNode.prev = node.prev;
          newNode.next = node;
          if (node.prev) node.prev.next = newNode;
          else this.head = newNode;
          node.prev = newNode;
          this.length += 1;
        }
        unshift(node) {
          if (this.head) this.insertBefore(this.head, node);
          else setInitial(this, node);
        }
        push(node) {
          if (this.tail) this.insertAfter(this.tail, node);
          else setInitial(this, node);
        }
        shift() {
          return this.head && this.removeLink(this.head);
        }
        pop() {
          return this.tail && this.removeLink(this.tail);
        }
        toArray() {
          return [...this];
        }
        *[Symbol.iterator]() {
          var cur = this.head;
          while (cur) {
            yield cur.data;
            cur = cur.next;
          }
        }
        remove(testFn) {
          var curr = this.head;
          while (curr) {
            var { next } = curr;
            if (testFn(curr)) {
              this.removeLink(curr);
            }
            curr = next;
          }
          return this;
        }
      }
      function setInitial(dll, node) {
        dll.length = 1;
        dll.head = dll.tail = node;
      }
      function queue$1(worker, concurrency, payload) {
        if (concurrency == null) {
          concurrency = 1;
        } else if (concurrency === 0) {
          throw new RangeError("Concurrency must not be zero");
        }
        var _worker = wrapAsync(worker);
        var numRunning = 0;
        var workersList = [];
        const events = {
          error: [],
          drain: [],
          saturated: [],
          unsaturated: [],
          empty: []
        };
        function on(event, handler) {
          events[event].push(handler);
        }
        function once2(event, handler) {
          const handleAndRemove = (...args) => {
            off(event, handleAndRemove);
            handler(...args);
          };
          events[event].push(handleAndRemove);
        }
        function off(event, handler) {
          if (!event) return Object.keys(events).forEach((ev) => events[ev] = []);
          if (!handler) return events[event] = [];
          events[event] = events[event].filter((ev) => ev !== handler);
        }
        function trigger(event, ...args) {
          events[event].forEach((handler) => handler(...args));
        }
        var processingScheduled = false;
        function _insert(data2, insertAtFront, rejectOnError, callback) {
          if (callback != null && typeof callback !== "function") {
            throw new Error("task callback must be a function");
          }
          q3.started = true;
          var res, rej;
          function promiseCallback2(err, ...args) {
            if (err) return rejectOnError ? rej(err) : res();
            if (args.length <= 1) return res(args[0]);
            res(args);
          }
          var item = q3._createTaskItem(
            data2,
            rejectOnError ? promiseCallback2 : callback || promiseCallback2
          );
          if (insertAtFront) {
            q3._tasks.unshift(item);
          } else {
            q3._tasks.push(item);
          }
          if (!processingScheduled) {
            processingScheduled = true;
            setImmediate$1(() => {
              processingScheduled = false;
              q3.process();
            });
          }
          if (rejectOnError || !callback) {
            return new Promise((resolve12, reject2) => {
              res = resolve12;
              rej = reject2;
            });
          }
        }
        function _createCB(tasks) {
          return function(err, ...args) {
            numRunning -= 1;
            for (var i3 = 0, l3 = tasks.length; i3 < l3; i3++) {
              var task = tasks[i3];
              var index2 = workersList.indexOf(task);
              if (index2 === 0) {
                workersList.shift();
              } else if (index2 > 0) {
                workersList.splice(index2, 1);
              }
              task.callback(err, ...args);
              if (err != null) {
                trigger("error", err, task.data);
              }
            }
            if (numRunning <= q3.concurrency - q3.buffer) {
              trigger("unsaturated");
            }
            if (q3.idle()) {
              trigger("drain");
            }
            q3.process();
          };
        }
        function _maybeDrain(data2) {
          if (data2.length === 0 && q3.idle()) {
            setImmediate$1(() => trigger("drain"));
            return true;
          }
          return false;
        }
        const eventMethod = (name) => (handler) => {
          if (!handler) {
            return new Promise((resolve12, reject2) => {
              once2(name, (err, data2) => {
                if (err) return reject2(err);
                resolve12(data2);
              });
            });
          }
          off(name);
          on(name, handler);
        };
        var isProcessing = false;
        var q3 = {
          _tasks: new DLL(),
          _createTaskItem(data2, callback) {
            return {
              data: data2,
              callback
            };
          },
          *[Symbol.iterator]() {
            yield* q3._tasks[Symbol.iterator]();
          },
          concurrency,
          payload,
          buffer: concurrency / 4,
          started: false,
          paused: false,
          push(data2, callback) {
            if (Array.isArray(data2)) {
              if (_maybeDrain(data2)) return;
              return data2.map((datum) => _insert(datum, false, false, callback));
            }
            return _insert(data2, false, false, callback);
          },
          pushAsync(data2, callback) {
            if (Array.isArray(data2)) {
              if (_maybeDrain(data2)) return;
              return data2.map((datum) => _insert(datum, false, true, callback));
            }
            return _insert(data2, false, true, callback);
          },
          kill() {
            off();
            q3._tasks.empty();
          },
          unshift(data2, callback) {
            if (Array.isArray(data2)) {
              if (_maybeDrain(data2)) return;
              return data2.map((datum) => _insert(datum, true, false, callback));
            }
            return _insert(data2, true, false, callback);
          },
          unshiftAsync(data2, callback) {
            if (Array.isArray(data2)) {
              if (_maybeDrain(data2)) return;
              return data2.map((datum) => _insert(datum, true, true, callback));
            }
            return _insert(data2, true, true, callback);
          },
          remove(testFn) {
            q3._tasks.remove(testFn);
          },
          process() {
            if (isProcessing) {
              return;
            }
            isProcessing = true;
            while (!q3.paused && numRunning < q3.concurrency && q3._tasks.length) {
              var tasks = [], data2 = [];
              var l3 = q3._tasks.length;
              if (q3.payload) l3 = Math.min(l3, q3.payload);
              for (var i3 = 0; i3 < l3; i3++) {
                var node = q3._tasks.shift();
                tasks.push(node);
                workersList.push(node);
                data2.push(node.data);
              }
              numRunning += 1;
              if (q3._tasks.length === 0) {
                trigger("empty");
              }
              if (numRunning === q3.concurrency) {
                trigger("saturated");
              }
              var cb = onlyOnce(_createCB(tasks));
              _worker(data2, cb);
            }
            isProcessing = false;
          },
          length() {
            return q3._tasks.length;
          },
          running() {
            return numRunning;
          },
          workersList() {
            return workersList;
          },
          idle() {
            return q3._tasks.length + numRunning === 0;
          },
          pause() {
            q3.paused = true;
          },
          resume() {
            if (q3.paused === false) {
              return;
            }
            q3.paused = false;
            setImmediate$1(q3.process);
          }
        };
        Object.defineProperties(q3, {
          saturated: {
            writable: false,
            value: eventMethod("saturated")
          },
          unsaturated: {
            writable: false,
            value: eventMethod("unsaturated")
          },
          empty: {
            writable: false,
            value: eventMethod("empty")
          },
          drain: {
            writable: false,
            value: eventMethod("drain")
          },
          error: {
            writable: false,
            value: eventMethod("error")
          }
        });
        return q3;
      }
      function cargo$1(worker, payload) {
        return queue$1(worker, 1, payload);
      }
      function cargo(worker, concurrency, payload) {
        return queue$1(worker, concurrency, payload);
      }
      function reduce(coll, memo, iteratee, callback) {
        callback = once(callback);
        var _iteratee = wrapAsync(iteratee);
        return eachOfSeries$1(coll, (x3, i3, iterCb) => {
          _iteratee(memo, x3, (err, v6) => {
            memo = v6;
            iterCb(err);
          });
        }, (err) => callback(err, memo));
      }
      var reduce$1 = awaitify(reduce, 4);
      function seq(...functions) {
        var _functions = functions.map(wrapAsync);
        return function(...args) {
          var that = this;
          var cb = args[args.length - 1];
          if (typeof cb == "function") {
            args.pop();
          } else {
            cb = promiseCallback();
          }
          reduce$1(
            _functions,
            args,
            (newargs, fn, iterCb) => {
              fn.apply(that, newargs.concat((err, ...nextargs) => {
                iterCb(err, nextargs);
              }));
            },
            (err, results) => cb(err, ...results)
          );
          return cb[PROMISE_SYMBOL];
        };
      }
      function compose(...args) {
        return seq(...args.reverse());
      }
      function mapLimit(coll, limit, iteratee, callback) {
        return _asyncMap(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var mapLimit$1 = awaitify(mapLimit, 4);
      function concatLimit(coll, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(coll, limit, (val2, iterCb) => {
          _iteratee(val2, (err, ...args) => {
            if (err) return iterCb(err);
            return iterCb(err, args);
          });
        }, (err, mapResults) => {
          var result3 = [];
          for (var i3 = 0; i3 < mapResults.length; i3++) {
            if (mapResults[i3]) {
              result3 = result3.concat(...mapResults[i3]);
            }
          }
          return callback(err, result3);
        });
      }
      var concatLimit$1 = awaitify(concatLimit, 4);
      function concat(coll, iteratee, callback) {
        return concatLimit$1(coll, Infinity, iteratee, callback);
      }
      var concat$1 = awaitify(concat, 3);
      function concatSeries(coll, iteratee, callback) {
        return concatLimit$1(coll, 1, iteratee, callback);
      }
      var concatSeries$1 = awaitify(concatSeries, 3);
      function constant$1(...args) {
        return function(...ignoredArgs) {
          var callback = ignoredArgs.pop();
          return callback(null, ...args);
        };
      }
      function _createTester(check, getResult) {
        return (eachfn, arr, _iteratee, cb) => {
          var testPassed = false;
          var testResult;
          const iteratee = wrapAsync(_iteratee);
          eachfn(arr, (value, _3, callback) => {
            iteratee(value, (err, result3) => {
              if (err || err === false) return callback(err);
              if (check(result3) && !testResult) {
                testPassed = true;
                testResult = getResult(true, value);
                return callback(null, breakLoop);
              }
              callback();
            });
          }, (err) => {
            if (err) return cb(err);
            cb(null, testPassed ? testResult : getResult(false));
          });
        };
      }
      function detect(coll, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOf$1, coll, iteratee, callback);
      }
      var detect$1 = awaitify(detect, 3);
      function detectLimit(coll, limit, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var detectLimit$1 = awaitify(detectLimit, 4);
      function detectSeries(coll, iteratee, callback) {
        return _createTester((bool) => bool, (res, item) => item)(eachOfLimit$2(1), coll, iteratee, callback);
      }
      var detectSeries$1 = awaitify(detectSeries, 3);
      function consoleFunc(name) {
        return (fn, ...args) => wrapAsync(fn)(...args, (err, ...resultArgs) => {
          if (typeof console === "object") {
            if (err) {
              if (console.error) {
                console.error(err);
              }
            } else if (console[name]) {
              resultArgs.forEach((x3) => console[name](x3));
            }
          }
        });
      }
      var dir = consoleFunc("dir");
      function doWhilst(iteratee, test, callback) {
        callback = onlyOnce(callback);
        var _fn = wrapAsync(iteratee);
        var _test = wrapAsync(test);
        var results;
        function next(err, ...args) {
          if (err) return callback(err);
          if (err === false) return;
          results = args;
          _test(...args, check);
        }
        function check(err, truth) {
          if (err) return callback(err);
          if (err === false) return;
          if (!truth) return callback(null, ...results);
          _fn(next);
        }
        return check(null, true);
      }
      var doWhilst$1 = awaitify(doWhilst, 3);
      function doUntil(iteratee, test, callback) {
        const _test = wrapAsync(test);
        return doWhilst$1(iteratee, (...args) => {
          const cb = args.pop();
          _test(...args, (err, truth) => cb(err, !truth));
        }, callback);
      }
      function _withoutIndex(iteratee) {
        return (value, index2, callback) => iteratee(value, callback);
      }
      function eachLimit$2(coll, iteratee, callback) {
        return eachOf$1(coll, _withoutIndex(wrapAsync(iteratee)), callback);
      }
      var each = awaitify(eachLimit$2, 3);
      function eachLimit(coll, limit, iteratee, callback) {
        return eachOfLimit$2(limit)(coll, _withoutIndex(wrapAsync(iteratee)), callback);
      }
      var eachLimit$1 = awaitify(eachLimit, 4);
      function eachSeries(coll, iteratee, callback) {
        return eachLimit$1(coll, 1, iteratee, callback);
      }
      var eachSeries$1 = awaitify(eachSeries, 3);
      function ensureAsync(fn) {
        if (isAsync(fn)) return fn;
        return function(...args) {
          var callback = args.pop();
          var sync2 = true;
          args.push((...innerArgs) => {
            if (sync2) {
              setImmediate$1(() => callback(...innerArgs));
            } else {
              callback(...innerArgs);
            }
          });
          fn.apply(this, args);
          sync2 = false;
        };
      }
      function every(coll, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOf$1, coll, iteratee, callback);
      }
      var every$1 = awaitify(every, 3);
      function everyLimit(coll, limit, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var everyLimit$1 = awaitify(everyLimit, 4);
      function everySeries(coll, iteratee, callback) {
        return _createTester((bool) => !bool, (res) => !res)(eachOfSeries$1, coll, iteratee, callback);
      }
      var everySeries$1 = awaitify(everySeries, 3);
      function filterArray(eachfn, arr, iteratee, callback) {
        var truthValues = new Array(arr.length);
        eachfn(arr, (x3, index2, iterCb) => {
          iteratee(x3, (err, v6) => {
            truthValues[index2] = !!v6;
            iterCb(err);
          });
        }, (err) => {
          if (err) return callback(err);
          var results = [];
          for (var i3 = 0; i3 < arr.length; i3++) {
            if (truthValues[i3]) results.push(arr[i3]);
          }
          callback(null, results);
        });
      }
      function filterGeneric(eachfn, coll, iteratee, callback) {
        var results = [];
        eachfn(coll, (x3, index2, iterCb) => {
          iteratee(x3, (err, v6) => {
            if (err) return iterCb(err);
            if (v6) {
              results.push({ index: index2, value: x3 });
            }
            iterCb(err);
          });
        }, (err) => {
          if (err) return callback(err);
          callback(null, results.sort((a3, b3) => a3.index - b3.index).map((v6) => v6.value));
        });
      }
      function _filter(eachfn, coll, iteratee, callback) {
        var filter5 = isArrayLike(coll) ? filterArray : filterGeneric;
        return filter5(eachfn, coll, wrapAsync(iteratee), callback);
      }
      function filter4(coll, iteratee, callback) {
        return _filter(eachOf$1, coll, iteratee, callback);
      }
      var filter$1 = awaitify(filter4, 3);
      function filterLimit(coll, limit, iteratee, callback) {
        return _filter(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var filterLimit$1 = awaitify(filterLimit, 4);
      function filterSeries(coll, iteratee, callback) {
        return _filter(eachOfSeries$1, coll, iteratee, callback);
      }
      var filterSeries$1 = awaitify(filterSeries, 3);
      function forever(fn, errback) {
        var done = onlyOnce(errback);
        var task = wrapAsync(ensureAsync(fn));
        function next(err) {
          if (err) return done(err);
          if (err === false) return;
          task(next);
        }
        return next();
      }
      var forever$1 = awaitify(forever, 2);
      function groupByLimit(coll, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(coll, limit, (val2, iterCb) => {
          _iteratee(val2, (err, key) => {
            if (err) return iterCb(err);
            return iterCb(err, { key, val: val2 });
          });
        }, (err, mapResults) => {
          var result3 = {};
          var { hasOwnProperty } = Object.prototype;
          for (var i3 = 0; i3 < mapResults.length; i3++) {
            if (mapResults[i3]) {
              var { key } = mapResults[i3];
              var { val: val2 } = mapResults[i3];
              if (hasOwnProperty.call(result3, key)) {
                result3[key].push(val2);
              } else {
                result3[key] = [val2];
              }
            }
          }
          return callback(err, result3);
        });
      }
      var groupByLimit$1 = awaitify(groupByLimit, 4);
      function groupBy(coll, iteratee, callback) {
        return groupByLimit$1(coll, Infinity, iteratee, callback);
      }
      function groupBySeries(coll, iteratee, callback) {
        return groupByLimit$1(coll, 1, iteratee, callback);
      }
      var log = consoleFunc("log");
      function mapValuesLimit(obj, limit, iteratee, callback) {
        callback = once(callback);
        var newObj = {};
        var _iteratee = wrapAsync(iteratee);
        return eachOfLimit$2(limit)(obj, (val2, key, next) => {
          _iteratee(val2, key, (err, result3) => {
            if (err) return next(err);
            newObj[key] = result3;
            next(err);
          });
        }, (err) => callback(err, newObj));
      }
      var mapValuesLimit$1 = awaitify(mapValuesLimit, 4);
      function mapValues2(obj, iteratee, callback) {
        return mapValuesLimit$1(obj, Infinity, iteratee, callback);
      }
      function mapValuesSeries(obj, iteratee, callback) {
        return mapValuesLimit$1(obj, 1, iteratee, callback);
      }
      function memoize2(fn, hasher = (v6) => v6) {
        var memo = /* @__PURE__ */ Object.create(null);
        var queues = /* @__PURE__ */ Object.create(null);
        var _fn = wrapAsync(fn);
        var memoized = initialParams((args, callback) => {
          var key = hasher(...args);
          if (key in memo) {
            setImmediate$1(() => callback(null, ...memo[key]));
          } else if (key in queues) {
            queues[key].push(callback);
          } else {
            queues[key] = [callback];
            _fn(...args, (err, ...resultArgs) => {
              if (!err) {
                memo[key] = resultArgs;
              }
              var q3 = queues[key];
              delete queues[key];
              for (var i3 = 0, l3 = q3.length; i3 < l3; i3++) {
                q3[i3](err, ...resultArgs);
              }
            });
          }
        });
        memoized.memo = memo;
        memoized.unmemoized = fn;
        return memoized;
      }
      var _defer;
      if (hasNextTick) {
        _defer = process.nextTick;
      } else if (hasSetImmediate) {
        _defer = setImmediate;
      } else {
        _defer = fallback;
      }
      var nextTick = wrap(_defer);
      var _parallel = awaitify((eachfn, tasks, callback) => {
        var results = isArrayLike(tasks) ? [] : {};
        eachfn(tasks, (task, key, taskCb) => {
          wrapAsync(task)((err, ...result3) => {
            if (result3.length < 2) {
              [result3] = result3;
            }
            results[key] = result3;
            taskCb(err);
          });
        }, (err) => callback(err, results));
      }, 3);
      function parallel(tasks, callback) {
        return _parallel(eachOf$1, tasks, callback);
      }
      function parallelLimit(tasks, limit, callback) {
        return _parallel(eachOfLimit$2(limit), tasks, callback);
      }
      function queue(worker, concurrency) {
        var _worker = wrapAsync(worker);
        return queue$1((items, cb) => {
          _worker(items[0], cb);
        }, concurrency, 1);
      }
      class Heap {
        constructor() {
          this.heap = [];
          this.pushCount = Number.MIN_SAFE_INTEGER;
        }
        get length() {
          return this.heap.length;
        }
        empty() {
          this.heap = [];
          return this;
        }
        percUp(index2) {
          let p3;
          while (index2 > 0 && smaller(this.heap[index2], this.heap[p3 = parent(index2)])) {
            let t3 = this.heap[index2];
            this.heap[index2] = this.heap[p3];
            this.heap[p3] = t3;
            index2 = p3;
          }
        }
        percDown(index2) {
          let l3;
          while ((l3 = leftChi(index2)) < this.heap.length) {
            if (l3 + 1 < this.heap.length && smaller(this.heap[l3 + 1], this.heap[l3])) {
              l3 = l3 + 1;
            }
            if (smaller(this.heap[index2], this.heap[l3])) {
              break;
            }
            let t3 = this.heap[index2];
            this.heap[index2] = this.heap[l3];
            this.heap[l3] = t3;
            index2 = l3;
          }
        }
        push(node) {
          node.pushCount = ++this.pushCount;
          this.heap.push(node);
          this.percUp(this.heap.length - 1);
        }
        unshift(node) {
          return this.heap.push(node);
        }
        shift() {
          let [top] = this.heap;
          this.heap[0] = this.heap[this.heap.length - 1];
          this.heap.pop();
          this.percDown(0);
          return top;
        }
        toArray() {
          return [...this];
        }
        *[Symbol.iterator]() {
          for (let i3 = 0; i3 < this.heap.length; i3++) {
            yield this.heap[i3].data;
          }
        }
        remove(testFn) {
          let j3 = 0;
          for (let i3 = 0; i3 < this.heap.length; i3++) {
            if (!testFn(this.heap[i3])) {
              this.heap[j3] = this.heap[i3];
              j3++;
            }
          }
          this.heap.splice(j3);
          for (let i3 = parent(this.heap.length - 1); i3 >= 0; i3--) {
            this.percDown(i3);
          }
          return this;
        }
      }
      function leftChi(i3) {
        return (i3 << 1) + 1;
      }
      function parent(i3) {
        return (i3 + 1 >> 1) - 1;
      }
      function smaller(x3, y2) {
        if (x3.priority !== y2.priority) {
          return x3.priority < y2.priority;
        } else {
          return x3.pushCount < y2.pushCount;
        }
      }
      function priorityQueue(worker, concurrency) {
        var q3 = queue(worker, concurrency);
        var {
          push,
          pushAsync
        } = q3;
        q3._tasks = new Heap();
        q3._createTaskItem = ({ data: data2, priority }, callback) => {
          return {
            data: data2,
            priority,
            callback
          };
        };
        function createDataItems(tasks, priority) {
          if (!Array.isArray(tasks)) {
            return { data: tasks, priority };
          }
          return tasks.map((data2) => {
            return { data: data2, priority };
          });
        }
        q3.push = function(data2, priority = 0, callback) {
          return push(createDataItems(data2, priority), callback);
        };
        q3.pushAsync = function(data2, priority = 0, callback) {
          return pushAsync(createDataItems(data2, priority), callback);
        };
        delete q3.unshift;
        delete q3.unshiftAsync;
        return q3;
      }
      function race(tasks, callback) {
        callback = once(callback);
        if (!Array.isArray(tasks)) return callback(new TypeError("First argument to race must be an array of functions"));
        if (!tasks.length) return callback();
        for (var i3 = 0, l3 = tasks.length; i3 < l3; i3++) {
          wrapAsync(tasks[i3])(callback);
        }
      }
      var race$1 = awaitify(race, 2);
      function reduceRight(array, memo, iteratee, callback) {
        var reversed = [...array].reverse();
        return reduce$1(reversed, memo, iteratee, callback);
      }
      function reflect(fn) {
        var _fn = wrapAsync(fn);
        return initialParams(function reflectOn(args, reflectCallback) {
          args.push((error5, ...cbArgs) => {
            let retVal = {};
            if (error5) {
              retVal.error = error5;
            }
            if (cbArgs.length > 0) {
              var value = cbArgs;
              if (cbArgs.length <= 1) {
                [value] = cbArgs;
              }
              retVal.value = value;
            }
            reflectCallback(null, retVal);
          });
          return _fn.apply(this, args);
        });
      }
      function reflectAll(tasks) {
        var results;
        if (Array.isArray(tasks)) {
          results = tasks.map(reflect);
        } else {
          results = {};
          Object.keys(tasks).forEach((key) => {
            results[key] = reflect.call(this, tasks[key]);
          });
        }
        return results;
      }
      function reject$2(eachfn, arr, _iteratee, callback) {
        const iteratee = wrapAsync(_iteratee);
        return _filter(eachfn, arr, (value, cb) => {
          iteratee(value, (err, v6) => {
            cb(err, !v6);
          });
        }, callback);
      }
      function reject(coll, iteratee, callback) {
        return reject$2(eachOf$1, coll, iteratee, callback);
      }
      var reject$1 = awaitify(reject, 3);
      function rejectLimit(coll, limit, iteratee, callback) {
        return reject$2(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var rejectLimit$1 = awaitify(rejectLimit, 4);
      function rejectSeries(coll, iteratee, callback) {
        return reject$2(eachOfSeries$1, coll, iteratee, callback);
      }
      var rejectSeries$1 = awaitify(rejectSeries, 3);
      function constant(value) {
        return function() {
          return value;
        };
      }
      const DEFAULT_TIMES = 5;
      const DEFAULT_INTERVAL = 0;
      function retry(opts, task, callback) {
        var options = {
          times: DEFAULT_TIMES,
          intervalFunc: constant(DEFAULT_INTERVAL)
        };
        if (arguments.length < 3 && typeof opts === "function") {
          callback = task || promiseCallback();
          task = opts;
        } else {
          parseTimes(options, opts);
          callback = callback || promiseCallback();
        }
        if (typeof task !== "function") {
          throw new Error("Invalid arguments for async.retry");
        }
        var _task = wrapAsync(task);
        var attempt = 1;
        function retryAttempt() {
          _task((err, ...args) => {
            if (err === false) return;
            if (err && attempt++ < options.times && (typeof options.errorFilter != "function" || options.errorFilter(err))) {
              setTimeout(retryAttempt, options.intervalFunc(attempt - 1));
            } else {
              callback(err, ...args);
            }
          });
        }
        retryAttempt();
        return callback[PROMISE_SYMBOL];
      }
      function parseTimes(acc, t3) {
        if (typeof t3 === "object") {
          acc.times = +t3.times || DEFAULT_TIMES;
          acc.intervalFunc = typeof t3.interval === "function" ? t3.interval : constant(+t3.interval || DEFAULT_INTERVAL);
          acc.errorFilter = t3.errorFilter;
        } else if (typeof t3 === "number" || typeof t3 === "string") {
          acc.times = +t3 || DEFAULT_TIMES;
        } else {
          throw new Error("Invalid arguments for async.retry");
        }
      }
      function retryable(opts, task) {
        if (!task) {
          task = opts;
          opts = null;
        }
        let arity = opts && opts.arity || task.length;
        if (isAsync(task)) {
          arity += 1;
        }
        var _task = wrapAsync(task);
        return initialParams((args, callback) => {
          if (args.length < arity - 1 || callback == null) {
            args.push(callback);
            callback = promiseCallback();
          }
          function taskFn(cb) {
            _task(...args, cb);
          }
          if (opts) retry(opts, taskFn, callback);
          else retry(taskFn, callback);
          return callback[PROMISE_SYMBOL];
        });
      }
      function series(tasks, callback) {
        return _parallel(eachOfSeries$1, tasks, callback);
      }
      function some2(coll, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOf$1, coll, iteratee, callback);
      }
      var some$1 = awaitify(some2, 3);
      function someLimit(coll, limit, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOfLimit$2(limit), coll, iteratee, callback);
      }
      var someLimit$1 = awaitify(someLimit, 4);
      function someSeries(coll, iteratee, callback) {
        return _createTester(Boolean, (res) => res)(eachOfSeries$1, coll, iteratee, callback);
      }
      var someSeries$1 = awaitify(someSeries, 3);
      function sortBy(coll, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return map$1(coll, (x3, iterCb) => {
          _iteratee(x3, (err, criteria) => {
            if (err) return iterCb(err);
            iterCb(err, { value: x3, criteria });
          });
        }, (err, results) => {
          if (err) return callback(err);
          callback(null, results.sort(comparator).map((v6) => v6.value));
        });
        function comparator(left, right) {
          var a3 = left.criteria, b3 = right.criteria;
          return a3 < b3 ? -1 : a3 > b3 ? 1 : 0;
        }
      }
      var sortBy$1 = awaitify(sortBy, 3);
      function timeout(asyncFn, milliseconds, info3) {
        var fn = wrapAsync(asyncFn);
        return initialParams((args, callback) => {
          var timedOut = false;
          var timer;
          function timeoutCallback() {
            var name = asyncFn.name || "anonymous";
            var error5 = new Error('Callback function "' + name + '" timed out.');
            error5.code = "ETIMEDOUT";
            if (info3) {
              error5.info = info3;
            }
            timedOut = true;
            callback(error5);
          }
          args.push((...cbArgs) => {
            if (!timedOut) {
              callback(...cbArgs);
              clearTimeout(timer);
            }
          });
          timer = setTimeout(timeoutCallback, milliseconds);
          fn(...args);
        });
      }
      function range(size) {
        var result3 = Array(size);
        while (size--) {
          result3[size] = size;
        }
        return result3;
      }
      function timesLimit(count, limit, iteratee, callback) {
        var _iteratee = wrapAsync(iteratee);
        return mapLimit$1(range(count), limit, _iteratee, callback);
      }
      function times(n3, iteratee, callback) {
        return timesLimit(n3, Infinity, iteratee, callback);
      }
      function timesSeries(n3, iteratee, callback) {
        return timesLimit(n3, 1, iteratee, callback);
      }
      function transform(coll, accumulator, iteratee, callback) {
        if (arguments.length <= 3 && typeof accumulator === "function") {
          callback = iteratee;
          iteratee = accumulator;
          accumulator = Array.isArray(coll) ? [] : {};
        }
        callback = once(callback || promiseCallback());
        var _iteratee = wrapAsync(iteratee);
        eachOf$1(coll, (v6, k3, cb) => {
          _iteratee(accumulator, v6, k3, cb);
        }, (err) => callback(err, accumulator));
        return callback[PROMISE_SYMBOL];
      }
      function tryEach(tasks, callback) {
        var error5 = null;
        var result3;
        return eachSeries$1(tasks, (task, taskCb) => {
          wrapAsync(task)((err, ...args) => {
            if (err === false) return taskCb(err);
            if (args.length < 2) {
              [result3] = args;
            } else {
              result3 = args;
            }
            error5 = err;
            taskCb(err ? null : {});
          });
        }, () => callback(error5, result3));
      }
      var tryEach$1 = awaitify(tryEach);
      function unmemoize(fn) {
        return (...args) => {
          return (fn.unmemoized || fn)(...args);
        };
      }
      function whilst(test, iteratee, callback) {
        callback = onlyOnce(callback);
        var _fn = wrapAsync(iteratee);
        var _test = wrapAsync(test);
        var results = [];
        function next(err, ...rest) {
          if (err) return callback(err);
          results = rest;
          if (err === false) return;
          _test(check);
        }
        function check(err, truth) {
          if (err) return callback(err);
          if (err === false) return;
          if (!truth) return callback(null, ...results);
          _fn(next);
        }
        return _test(check);
      }
      var whilst$1 = awaitify(whilst, 3);
      function until(test, iteratee, callback) {
        const _test = wrapAsync(test);
        return whilst$1((cb) => _test((err, truth) => cb(err, !truth)), iteratee, callback);
      }
      function waterfall(tasks, callback) {
        callback = once(callback);
        if (!Array.isArray(tasks)) return callback(new Error("First argument to waterfall must be an array of functions"));
        if (!tasks.length) return callback();
        var taskIndex = 0;
        function nextTask(args) {
          var task = wrapAsync(tasks[taskIndex++]);
          task(...args, onlyOnce(next));
        }
        function next(err, ...args) {
          if (err === false) return;
          if (err || taskIndex === tasks.length) {
            return callback(err, ...args);
          }
          nextTask(args);
        }
        nextTask([]);
      }
      var waterfall$1 = awaitify(waterfall);
      var index = {
        apply,
        applyEach,
        applyEachSeries,
        asyncify,
        auto,
        autoInject,
        cargo: cargo$1,
        cargoQueue: cargo,
        compose,
        concat: concat$1,
        concatLimit: concatLimit$1,
        concatSeries: concatSeries$1,
        constant: constant$1,
        detect: detect$1,
        detectLimit: detectLimit$1,
        detectSeries: detectSeries$1,
        dir,
        doUntil,
        doWhilst: doWhilst$1,
        each,
        eachLimit: eachLimit$1,
        eachOf: eachOf$1,
        eachOfLimit: eachOfLimit$1,
        eachOfSeries: eachOfSeries$1,
        eachSeries: eachSeries$1,
        ensureAsync,
        every: every$1,
        everyLimit: everyLimit$1,
        everySeries: everySeries$1,
        filter: filter$1,
        filterLimit: filterLimit$1,
        filterSeries: filterSeries$1,
        forever: forever$1,
        groupBy,
        groupByLimit: groupByLimit$1,
        groupBySeries,
        log,
        map: map$1,
        mapLimit: mapLimit$1,
        mapSeries: mapSeries$1,
        mapValues: mapValues2,
        mapValuesLimit: mapValuesLimit$1,
        mapValuesSeries,
        memoize: memoize2,
        nextTick,
        parallel,
        parallelLimit,
        priorityQueue,
        queue,
        race: race$1,
        reduce: reduce$1,
        reduceRight,
        reflect,
        reflectAll,
        reject: reject$1,
        rejectLimit: rejectLimit$1,
        rejectSeries: rejectSeries$1,
        retry,
        retryable,
        seq,
        series,
        setImmediate: setImmediate$1,
        some: some$1,
        someLimit: someLimit$1,
        someSeries: someSeries$1,
        sortBy: sortBy$1,
        timeout,
        times,
        timesLimit,
        timesSeries,
        transform,
        tryEach: tryEach$1,
        unmemoize,
        until,
        waterfall: waterfall$1,
        whilst: whilst$1,
        // aliases
        all: every$1,
        allLimit: everyLimit$1,
        allSeries: everySeries$1,
        any: some$1,
        anyLimit: someLimit$1,
        anySeries: someSeries$1,
        find: detect$1,
        findLimit: detectLimit$1,
        findSeries: detectSeries$1,
        flatMap: concat$1,
        flatMapLimit: concatLimit$1,
        flatMapSeries: concatSeries$1,
        forEach: each,
        forEachSeries: eachSeries$1,
        forEachLimit: eachLimit$1,
        forEachOf: eachOf$1,
        forEachOfSeries: eachOfSeries$1,
        forEachOfLimit: eachOfLimit$1,
        inject: reduce$1,
        foldl: reduce$1,
        foldr: reduceRight,
        select: filter$1,
        selectLimit: filterLimit$1,
        selectSeries: filterSeries$1,
        wrapSync: asyncify,
        during: whilst$1,
        doDuring: doWhilst$1
      };
      exports3.all = every$1;
      exports3.allLimit = everyLimit$1;
      exports3.allSeries = everySeries$1;
      exports3.any = some$1;
      exports3.anyLimit = someLimit$1;
      exports3.anySeries = someSeries$1;
      exports3.apply = apply;
      exports3.applyEach = applyEach;
      exports3.applyEachSeries = applyEachSeries;
      exports3.asyncify = asyncify;
      exports3.auto = auto;
      exports3.autoInject = autoInject;
      exports3.cargo = cargo$1;
      exports3.cargoQueue = cargo;
      exports3.compose = compose;
      exports3.concat = concat$1;
      exports3.concatLimit = concatLimit$1;
      exports3.concatSeries = concatSeries$1;
      exports3.constant = constant$1;
      exports3.default = index;
      exports3.detect = detect$1;
      exports3.detectLimit = detectLimit$1;
      exports3.detectSeries = detectSeries$1;
      exports3.dir = dir;
      exports3.doDuring = doWhilst$1;
      exports3.doUntil = doUntil;
      exports3.doWhilst = doWhilst$1;
      exports3.during = whilst$1;
      exports3.each = each;
      exports3.eachLimit = eachLimit$1;
      exports3.eachOf = eachOf$1;
      exports3.eachOfLimit = eachOfLimit$1;
      exports3.eachOfSeries = eachOfSeries$1;
      exports3.eachSeries = eachSeries$1;
      exports3.ensureAsync = ensureAsync;
      exports3.every = every$1;
      exports3.everyLimit = everyLimit$1;
      exports3.everySeries = everySeries$1;
      exports3.filter = filter$1;
      exports3.filterLimit = filterLimit$1;
      exports3.filterSeries = filterSeries$1;
      exports3.find = detect$1;
      exports3.findLimit = detectLimit$1;
      exports3.findSeries = detectSeries$1;
      exports3.flatMap = concat$1;
      exports3.flatMapLimit = concatLimit$1;
      exports3.flatMapSeries = concatSeries$1;
      exports3.foldl = reduce$1;
      exports3.foldr = reduceRight;
      exports3.forEach = each;
      exports3.forEachLimit = eachLimit$1;
      exports3.forEachOf = eachOf$1;
      exports3.forEachOfLimit = eachOfLimit$1;
      exports3.forEachOfSeries = eachOfSeries$1;
      exports3.forEachSeries = eachSeries$1;
      exports3.forever = forever$1;
      exports3.groupBy = groupBy;
      exports3.groupByLimit = groupByLimit$1;
      exports3.groupBySeries = groupBySeries;
      exports3.inject = reduce$1;
      exports3.log = log;
      exports3.map = map$1;
      exports3.mapLimit = mapLimit$1;
      exports3.mapSeries = mapSeries$1;
      exports3.mapValues = mapValues2;
      exports3.mapValuesLimit = mapValuesLimit$1;
      exports3.mapValuesSeries = mapValuesSeries;
      exports3.memoize = memoize2;
      exports3.nextTick = nextTick;
      exports3.parallel = parallel;
      exports3.parallelLimit = parallelLimit;
      exports3.priorityQueue = priorityQueue;
      exports3.queue = queue;
      exports3.race = race$1;
      exports3.reduce = reduce$1;
      exports3.reduceRight = reduceRight;
      exports3.reflect = reflect;
      exports3.reflectAll = reflectAll;
      exports3.reject = reject$1;
      exports3.rejectLimit = rejectLimit$1;
      exports3.rejectSeries = rejectSeries$1;
      exports3.retry = retry;
      exports3.retryable = retryable;
      exports3.select = filter$1;
      exports3.selectLimit = filterLimit$1;
      exports3.selectSeries = filterSeries$1;
      exports3.seq = seq;
      exports3.series = series;
      exports3.setImmediate = setImmediate$1;
      exports3.some = some$1;
      exports3.someLimit = someLimit$1;
      exports3.someSeries = someSeries$1;
      exports3.sortBy = sortBy$1;
      exports3.timeout = timeout;
      exports3.times = times;
      exports3.timesLimit = timesLimit;
      exports3.timesSeries = timesSeries;
      exports3.transform = transform;
      exports3.tryEach = tryEach$1;
      exports3.unmemoize = unmemoize;
      exports3.until = until;
      exports3.waterfall = waterfall$1;
      exports3.whilst = whilst$1;
      exports3.wrapSync = asyncify;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// ../../node_modules/is-stream/index.js
var require_is_stream = __commonJS({
  "../../node_modules/is-stream/index.js"(exports2, module2) {
    "use strict";
    var isStream2 = (stream3) => stream3 !== null && typeof stream3 === "object" && typeof stream3.pipe === "function";
    isStream2.writable = (stream3) => isStream2(stream3) && stream3.writable !== false && typeof stream3._write === "function" && typeof stream3._writableState === "object";
    isStream2.readable = (stream3) => isStream2(stream3) && stream3.readable !== false && typeof stream3._read === "function" && typeof stream3._readableState === "object";
    isStream2.duplex = (stream3) => isStream2.writable(stream3) && isStream2.readable(stream3);
    isStream2.transform = (stream3) => isStream2.duplex(stream3) && typeof stream3._transform === "function";
    module2.exports = isStream2;
  }
});

// ../../node_modules/process-nextick-args/index.js
var require_process_nextick_args = __commonJS({
  "../../node_modules/process-nextick-args/index.js"(exports2, module2) {
    "use strict";
    if (typeof process === "undefined" || !process.version || process.version.indexOf("v0.") === 0 || process.version.indexOf("v1.") === 0 && process.version.indexOf("v1.8.") !== 0) {
      module2.exports = { nextTick };
    } else {
      module2.exports = process;
    }
    function nextTick(fn, arg1, arg2, arg3) {
      if (typeof fn !== "function") {
        throw new TypeError('"callback" argument must be a function');
      }
      var len = arguments.length;
      var args, i3;
      switch (len) {
        case 0:
        case 1:
          return process.nextTick(fn);
        case 2:
          return process.nextTick(function afterTickOne() {
            fn.call(null, arg1);
          });
        case 3:
          return process.nextTick(function afterTickTwo() {
            fn.call(null, arg1, arg2);
          });
        case 4:
          return process.nextTick(function afterTickThree() {
            fn.call(null, arg1, arg2, arg3);
          });
        default:
          args = new Array(len - 1);
          i3 = 0;
          while (i3 < args.length) {
            args[i3++] = arguments[i3];
          }
          return process.nextTick(function afterTick() {
            fn.apply(null, args);
          });
      }
    }
  }
});

// ../../node_modules/lazystream/node_modules/isarray/index.js
var require_isarray = __commonJS({
  "../../node_modules/lazystream/node_modules/isarray/index.js"(exports2, module2) {
    var toString = {}.toString;
    module2.exports = Array.isArray || function(arr) {
      return toString.call(arr) == "[object Array]";
    };
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/stream.js
var require_stream = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/stream.js"(exports2, module2) {
    module2.exports = require("stream");
  }
});

// ../../node_modules/lazystream/node_modules/safe-buffer/index.js
var require_safe_buffer = __commonJS({
  "../../node_modules/lazystream/node_modules/safe-buffer/index.js"(exports2, module2) {
    var buffer = require("buffer");
    var Buffer2 = buffer.Buffer;
    function copyProps(src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer;
    } else {
      copyProps(buffer, exports2);
      exports2.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer.SlowBuffer(size);
    };
  }
});

// ../../node_modules/core-util-is/lib/util.js
var require_util = __commonJS({
  "../../node_modules/core-util-is/lib/util.js"(exports2) {
    function isArray2(arg) {
      if (Array.isArray) {
        return Array.isArray(arg);
      }
      return objectToString(arg) === "[object Array]";
    }
    exports2.isArray = isArray2;
    function isBoolean(arg) {
      return typeof arg === "boolean";
    }
    exports2.isBoolean = isBoolean;
    function isNull(arg) {
      return arg === null;
    }
    exports2.isNull = isNull;
    function isNullOrUndefined(arg) {
      return arg == null;
    }
    exports2.isNullOrUndefined = isNullOrUndefined;
    function isNumber(arg) {
      return typeof arg === "number";
    }
    exports2.isNumber = isNumber;
    function isString(arg) {
      return typeof arg === "string";
    }
    exports2.isString = isString;
    function isSymbol(arg) {
      return typeof arg === "symbol";
    }
    exports2.isSymbol = isSymbol;
    function isUndefined(arg) {
      return arg === void 0;
    }
    exports2.isUndefined = isUndefined;
    function isRegExp(re) {
      return objectToString(re) === "[object RegExp]";
    }
    exports2.isRegExp = isRegExp;
    function isObject3(arg) {
      return typeof arg === "object" && arg !== null;
    }
    exports2.isObject = isObject3;
    function isDate(d3) {
      return objectToString(d3) === "[object Date]";
    }
    exports2.isDate = isDate;
    function isError(e3) {
      return objectToString(e3) === "[object Error]" || e3 instanceof Error;
    }
    exports2.isError = isError;
    function isFunction(arg) {
      return typeof arg === "function";
    }
    exports2.isFunction = isFunction;
    function isPrimitive(arg) {
      return arg === null || typeof arg === "boolean" || typeof arg === "number" || typeof arg === "string" || typeof arg === "symbol" || // ES6 symbol
      typeof arg === "undefined";
    }
    exports2.isPrimitive = isPrimitive;
    exports2.isBuffer = require("buffer").Buffer.isBuffer;
    function objectToString(o3) {
      return Object.prototype.toString.call(o3);
    }
  }
});

// ../../node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "../../node_modules/inherits/inherits_browser.js"(exports2, module2) {
    if (typeof Object.create === "function") {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function() {
          };
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  }
});

// ../../node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "../../node_modules/inherits/inherits.js"(exports2, module2) {
    try {
      util11 = require("util");
      if (typeof util11.inherits !== "function") throw "";
      module2.exports = util11.inherits;
    } catch (e3) {
      module2.exports = require_inherits_browser();
    }
    var util11;
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/BufferList.js
var require_BufferList = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/BufferList.js"(exports2, module2) {
    "use strict";
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }
    var Buffer2 = require_safe_buffer().Buffer;
    var util11 = require("util");
    function copyBuffer(src, target, offset) {
      src.copy(target, offset);
    }
    module2.exports = function() {
      function BufferList() {
        _classCallCheck(this, BufferList);
        this.head = null;
        this.tail = null;
        this.length = 0;
      }
      BufferList.prototype.push = function push(v6) {
        var entry = { data: v6, next: null };
        if (this.length > 0) this.tail.next = entry;
        else this.head = entry;
        this.tail = entry;
        ++this.length;
      };
      BufferList.prototype.unshift = function unshift(v6) {
        var entry = { data: v6, next: this.head };
        if (this.length === 0) this.tail = entry;
        this.head = entry;
        ++this.length;
      };
      BufferList.prototype.shift = function shift() {
        if (this.length === 0) return;
        var ret = this.head.data;
        if (this.length === 1) this.head = this.tail = null;
        else this.head = this.head.next;
        --this.length;
        return ret;
      };
      BufferList.prototype.clear = function clear() {
        this.head = this.tail = null;
        this.length = 0;
      };
      BufferList.prototype.join = function join26(s3) {
        if (this.length === 0) return "";
        var p3 = this.head;
        var ret = "" + p3.data;
        while (p3 = p3.next) {
          ret += s3 + p3.data;
        }
        return ret;
      };
      BufferList.prototype.concat = function concat(n3) {
        if (this.length === 0) return Buffer2.alloc(0);
        var ret = Buffer2.allocUnsafe(n3 >>> 0);
        var p3 = this.head;
        var i3 = 0;
        while (p3) {
          copyBuffer(p3.data, ret, i3);
          i3 += p3.data.length;
          p3 = p3.next;
        }
        return ret;
      };
      return BufferList;
    }();
    if (util11 && util11.inspect && util11.inspect.custom) {
      module2.exports.prototype[util11.inspect.custom] = function() {
        var obj = util11.inspect({ length: this.length });
        return this.constructor.name + " " + obj;
      };
    }
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/destroy.js
var require_destroy = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/internal/streams/destroy.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    function destroy(err, cb) {
      var _this = this;
      var readableDestroyed = this._readableState && this._readableState.destroyed;
      var writableDestroyed = this._writableState && this._writableState.destroyed;
      if (readableDestroyed || writableDestroyed) {
        if (cb) {
          cb(err);
        } else if (err) {
          if (!this._writableState) {
            pna.nextTick(emitErrorNT, this, err);
          } else if (!this._writableState.errorEmitted) {
            this._writableState.errorEmitted = true;
            pna.nextTick(emitErrorNT, this, err);
          }
        }
        return this;
      }
      if (this._readableState) {
        this._readableState.destroyed = true;
      }
      if (this._writableState) {
        this._writableState.destroyed = true;
      }
      this._destroy(err || null, function(err2) {
        if (!cb && err2) {
          if (!_this._writableState) {
            pna.nextTick(emitErrorNT, _this, err2);
          } else if (!_this._writableState.errorEmitted) {
            _this._writableState.errorEmitted = true;
            pna.nextTick(emitErrorNT, _this, err2);
          }
        } else if (cb) {
          cb(err2);
        }
      });
      return this;
    }
    function undestroy() {
      if (this._readableState) {
        this._readableState.destroyed = false;
        this._readableState.reading = false;
        this._readableState.ended = false;
        this._readableState.endEmitted = false;
      }
      if (this._writableState) {
        this._writableState.destroyed = false;
        this._writableState.ended = false;
        this._writableState.ending = false;
        this._writableState.finalCalled = false;
        this._writableState.prefinished = false;
        this._writableState.finished = false;
        this._writableState.errorEmitted = false;
      }
    }
    function emitErrorNT(self2, err) {
      self2.emit("error", err);
    }
    module2.exports = {
      destroy,
      undestroy
    };
  }
});

// ../../node_modules/util-deprecate/node.js
var require_node = __commonJS({
  "../../node_modules/util-deprecate/node.js"(exports2, module2) {
    module2.exports = require("util").deprecate;
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_writable.js
var require_stream_writable = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_writable.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    module2.exports = Writable3;
    function CorkedRequest(state2) {
      var _this = this;
      this.next = null;
      this.entry = null;
      this.finish = function() {
        onCorkedFinish(_this, state2);
      };
    }
    var asyncWrite = !process.browser && ["v0.10", "v0.9."].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
    var Duplex;
    Writable3.WritableState = WritableState;
    var util11 = Object.create(require_util());
    util11.inherits = require_inherits();
    var internalUtil = {
      deprecate: require_node()
    };
    var Stream2 = require_stream();
    var Buffer2 = require_safe_buffer().Buffer;
    var OurUint8Array = (typeof global !== "undefined" ? global : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    var destroyImpl = require_destroy();
    util11.inherits(Writable3, Stream2);
    function nop() {
    }
    function WritableState(options, stream3) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      var isDuplex = stream3 instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;
      var hwm = options.highWaterMark;
      var writableHwm = options.writableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      if (hwm || hwm === 0) this.highWaterMark = hwm;
      else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;
      else this.highWaterMark = defaultHwm;
      this.highWaterMark = Math.floor(this.highWaterMark);
      this.finalCalled = false;
      this.needDrain = false;
      this.ending = false;
      this.ended = false;
      this.finished = false;
      this.destroyed = false;
      var noDecode = options.decodeStrings === false;
      this.decodeStrings = !noDecode;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.length = 0;
      this.writing = false;
      this.corked = 0;
      this.sync = true;
      this.bufferProcessing = false;
      this.onwrite = function(er) {
        onwrite(stream3, er);
      };
      this.writecb = null;
      this.writelen = 0;
      this.bufferedRequest = null;
      this.lastBufferedRequest = null;
      this.pendingcb = 0;
      this.prefinished = false;
      this.errorEmitted = false;
      this.bufferedRequestCount = 0;
      this.corkedRequestsFree = new CorkedRequest(this);
    }
    WritableState.prototype.getBuffer = function getBuffer() {
      var current = this.bufferedRequest;
      var out = [];
      while (current) {
        out.push(current);
        current = current.next;
      }
      return out;
    };
    (function() {
      try {
        Object.defineProperty(WritableState.prototype, "buffer", {
          get: internalUtil.deprecate(function() {
            return this.getBuffer();
          }, "_writableState.buffer is deprecated. Use _writableState.getBuffer instead.", "DEP0003")
        });
      } catch (_3) {
      }
    })();
    var realHasInstance;
    if (typeof Symbol === "function" && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === "function") {
      realHasInstance = Function.prototype[Symbol.hasInstance];
      Object.defineProperty(Writable3, Symbol.hasInstance, {
        value: function(object) {
          if (realHasInstance.call(this, object)) return true;
          if (this !== Writable3) return false;
          return object && object._writableState instanceof WritableState;
        }
      });
    } else {
      realHasInstance = function(object) {
        return object instanceof this;
      };
    }
    function Writable3(options) {
      Duplex = Duplex || require_stream_duplex();
      if (!realHasInstance.call(Writable3, this) && !(this instanceof Duplex)) {
        return new Writable3(options);
      }
      this._writableState = new WritableState(options, this);
      this.writable = true;
      if (options) {
        if (typeof options.write === "function") this._write = options.write;
        if (typeof options.writev === "function") this._writev = options.writev;
        if (typeof options.destroy === "function") this._destroy = options.destroy;
        if (typeof options.final === "function") this._final = options.final;
      }
      Stream2.call(this);
    }
    Writable3.prototype.pipe = function() {
      this.emit("error", new Error("Cannot pipe, not readable"));
    };
    function writeAfterEnd(stream3, cb) {
      var er = new Error("write after end");
      stream3.emit("error", er);
      pna.nextTick(cb, er);
    }
    function validChunk(stream3, state2, chunk, cb) {
      var valid3 = true;
      var er = false;
      if (chunk === null) {
        er = new TypeError("May not write null values to stream");
      } else if (typeof chunk !== "string" && chunk !== void 0 && !state2.objectMode) {
        er = new TypeError("Invalid non-string/buffer chunk");
      }
      if (er) {
        stream3.emit("error", er);
        pna.nextTick(cb, er);
        valid3 = false;
      }
      return valid3;
    }
    Writable3.prototype.write = function(chunk, encoding, cb) {
      var state2 = this._writableState;
      var ret = false;
      var isBuf = !state2.objectMode && _isUint8Array(chunk);
      if (isBuf && !Buffer2.isBuffer(chunk)) {
        chunk = _uint8ArrayToBuffer(chunk);
      }
      if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (isBuf) encoding = "buffer";
      else if (!encoding) encoding = state2.defaultEncoding;
      if (typeof cb !== "function") cb = nop;
      if (state2.ended) writeAfterEnd(this, cb);
      else if (isBuf || validChunk(this, state2, chunk, cb)) {
        state2.pendingcb++;
        ret = writeOrBuffer(this, state2, isBuf, chunk, encoding, cb);
      }
      return ret;
    };
    Writable3.prototype.cork = function() {
      var state2 = this._writableState;
      state2.corked++;
    };
    Writable3.prototype.uncork = function() {
      var state2 = this._writableState;
      if (state2.corked) {
        state2.corked--;
        if (!state2.writing && !state2.corked && !state2.bufferProcessing && state2.bufferedRequest) clearBuffer(this, state2);
      }
    };
    Writable3.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
      if (typeof encoding === "string") encoding = encoding.toLowerCase();
      if (!(["hex", "utf8", "utf-8", "ascii", "binary", "base64", "ucs2", "ucs-2", "utf16le", "utf-16le", "raw"].indexOf((encoding + "").toLowerCase()) > -1)) throw new TypeError("Unknown encoding: " + encoding);
      this._writableState.defaultEncoding = encoding;
      return this;
    };
    function decodeChunk(state2, chunk, encoding) {
      if (!state2.objectMode && state2.decodeStrings !== false && typeof chunk === "string") {
        chunk = Buffer2.from(chunk, encoding);
      }
      return chunk;
    }
    Object.defineProperty(Writable3.prototype, "writableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function() {
        return this._writableState.highWaterMark;
      }
    });
    function writeOrBuffer(stream3, state2, isBuf, chunk, encoding, cb) {
      if (!isBuf) {
        var newChunk = decodeChunk(state2, chunk, encoding);
        if (chunk !== newChunk) {
          isBuf = true;
          encoding = "buffer";
          chunk = newChunk;
        }
      }
      var len = state2.objectMode ? 1 : chunk.length;
      state2.length += len;
      var ret = state2.length < state2.highWaterMark;
      if (!ret) state2.needDrain = true;
      if (state2.writing || state2.corked) {
        var last = state2.lastBufferedRequest;
        state2.lastBufferedRequest = {
          chunk,
          encoding,
          isBuf,
          callback: cb,
          next: null
        };
        if (last) {
          last.next = state2.lastBufferedRequest;
        } else {
          state2.bufferedRequest = state2.lastBufferedRequest;
        }
        state2.bufferedRequestCount += 1;
      } else {
        doWrite(stream3, state2, false, len, chunk, encoding, cb);
      }
      return ret;
    }
    function doWrite(stream3, state2, writev, len, chunk, encoding, cb) {
      state2.writelen = len;
      state2.writecb = cb;
      state2.writing = true;
      state2.sync = true;
      if (writev) stream3._writev(chunk, state2.onwrite);
      else stream3._write(chunk, encoding, state2.onwrite);
      state2.sync = false;
    }
    function onwriteError(stream3, state2, sync2, er, cb) {
      --state2.pendingcb;
      if (sync2) {
        pna.nextTick(cb, er);
        pna.nextTick(finishMaybe, stream3, state2);
        stream3._writableState.errorEmitted = true;
        stream3.emit("error", er);
      } else {
        cb(er);
        stream3._writableState.errorEmitted = true;
        stream3.emit("error", er);
        finishMaybe(stream3, state2);
      }
    }
    function onwriteStateUpdate(state2) {
      state2.writing = false;
      state2.writecb = null;
      state2.length -= state2.writelen;
      state2.writelen = 0;
    }
    function onwrite(stream3, er) {
      var state2 = stream3._writableState;
      var sync2 = state2.sync;
      var cb = state2.writecb;
      onwriteStateUpdate(state2);
      if (er) onwriteError(stream3, state2, sync2, er, cb);
      else {
        var finished = needFinish(state2);
        if (!finished && !state2.corked && !state2.bufferProcessing && state2.bufferedRequest) {
          clearBuffer(stream3, state2);
        }
        if (sync2) {
          asyncWrite(afterWrite, stream3, state2, finished, cb);
        } else {
          afterWrite(stream3, state2, finished, cb);
        }
      }
    }
    function afterWrite(stream3, state2, finished, cb) {
      if (!finished) onwriteDrain(stream3, state2);
      state2.pendingcb--;
      cb();
      finishMaybe(stream3, state2);
    }
    function onwriteDrain(stream3, state2) {
      if (state2.length === 0 && state2.needDrain) {
        state2.needDrain = false;
        stream3.emit("drain");
      }
    }
    function clearBuffer(stream3, state2) {
      state2.bufferProcessing = true;
      var entry = state2.bufferedRequest;
      if (stream3._writev && entry && entry.next) {
        var l3 = state2.bufferedRequestCount;
        var buffer = new Array(l3);
        var holder = state2.corkedRequestsFree;
        holder.entry = entry;
        var count = 0;
        var allBuffers = true;
        while (entry) {
          buffer[count] = entry;
          if (!entry.isBuf) allBuffers = false;
          entry = entry.next;
          count += 1;
        }
        buffer.allBuffers = allBuffers;
        doWrite(stream3, state2, true, state2.length, buffer, "", holder.finish);
        state2.pendingcb++;
        state2.lastBufferedRequest = null;
        if (holder.next) {
          state2.corkedRequestsFree = holder.next;
          holder.next = null;
        } else {
          state2.corkedRequestsFree = new CorkedRequest(state2);
        }
        state2.bufferedRequestCount = 0;
      } else {
        while (entry) {
          var chunk = entry.chunk;
          var encoding = entry.encoding;
          var cb = entry.callback;
          var len = state2.objectMode ? 1 : chunk.length;
          doWrite(stream3, state2, false, len, chunk, encoding, cb);
          entry = entry.next;
          state2.bufferedRequestCount--;
          if (state2.writing) {
            break;
          }
        }
        if (entry === null) state2.lastBufferedRequest = null;
      }
      state2.bufferedRequest = entry;
      state2.bufferProcessing = false;
    }
    Writable3.prototype._write = function(chunk, encoding, cb) {
      cb(new Error("_write() is not implemented"));
    };
    Writable3.prototype._writev = null;
    Writable3.prototype.end = function(chunk, encoding, cb) {
      var state2 = this._writableState;
      if (typeof chunk === "function") {
        cb = chunk;
        chunk = null;
        encoding = null;
      } else if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (chunk !== null && chunk !== void 0) this.write(chunk, encoding);
      if (state2.corked) {
        state2.corked = 1;
        this.uncork();
      }
      if (!state2.ending) endWritable(this, state2, cb);
    };
    function needFinish(state2) {
      return state2.ending && state2.length === 0 && state2.bufferedRequest === null && !state2.finished && !state2.writing;
    }
    function callFinal(stream3, state2) {
      stream3._final(function(err) {
        state2.pendingcb--;
        if (err) {
          stream3.emit("error", err);
        }
        state2.prefinished = true;
        stream3.emit("prefinish");
        finishMaybe(stream3, state2);
      });
    }
    function prefinish(stream3, state2) {
      if (!state2.prefinished && !state2.finalCalled) {
        if (typeof stream3._final === "function") {
          state2.pendingcb++;
          state2.finalCalled = true;
          pna.nextTick(callFinal, stream3, state2);
        } else {
          state2.prefinished = true;
          stream3.emit("prefinish");
        }
      }
    }
    function finishMaybe(stream3, state2) {
      var need = needFinish(state2);
      if (need) {
        prefinish(stream3, state2);
        if (state2.pendingcb === 0) {
          state2.finished = true;
          stream3.emit("finish");
        }
      }
      return need;
    }
    function endWritable(stream3, state2, cb) {
      state2.ending = true;
      finishMaybe(stream3, state2);
      if (cb) {
        if (state2.finished) pna.nextTick(cb);
        else stream3.once("finish", cb);
      }
      state2.ended = true;
      stream3.writable = false;
    }
    function onCorkedFinish(corkReq, state2, err) {
      var entry = corkReq.entry;
      corkReq.entry = null;
      while (entry) {
        var cb = entry.callback;
        state2.pendingcb--;
        cb(err);
        entry = entry.next;
      }
      state2.corkedRequestsFree.next = corkReq;
    }
    Object.defineProperty(Writable3.prototype, "destroyed", {
      get: function() {
        if (this._writableState === void 0) {
          return false;
        }
        return this._writableState.destroyed;
      },
      set: function(value) {
        if (!this._writableState) {
          return;
        }
        this._writableState.destroyed = value;
      }
    });
    Writable3.prototype.destroy = destroyImpl.destroy;
    Writable3.prototype._undestroy = destroyImpl.undestroy;
    Writable3.prototype._destroy = function(err, cb) {
      this.end();
      cb(err);
    };
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_duplex.js
var require_stream_duplex = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_duplex.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    var objectKeys = Object.keys || function(obj) {
      var keys2 = [];
      for (var key in obj) {
        keys2.push(key);
      }
      return keys2;
    };
    module2.exports = Duplex;
    var util11 = Object.create(require_util());
    util11.inherits = require_inherits();
    var Readable = require_stream_readable();
    var Writable3 = require_stream_writable();
    util11.inherits(Duplex, Readable);
    {
      keys = objectKeys(Writable3.prototype);
      for (v6 = 0; v6 < keys.length; v6++) {
        method = keys[v6];
        if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable3.prototype[method];
      }
    }
    var keys;
    var method;
    var v6;
    function Duplex(options) {
      if (!(this instanceof Duplex)) return new Duplex(options);
      Readable.call(this, options);
      Writable3.call(this, options);
      if (options && options.readable === false) this.readable = false;
      if (options && options.writable === false) this.writable = false;
      this.allowHalfOpen = true;
      if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;
      this.once("end", onend);
    }
    Object.defineProperty(Duplex.prototype, "writableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function() {
        return this._writableState.highWaterMark;
      }
    });
    function onend() {
      if (this.allowHalfOpen || this._writableState.ended) return;
      pna.nextTick(onEndNT, this);
    }
    function onEndNT(self2) {
      self2.end();
    }
    Object.defineProperty(Duplex.prototype, "destroyed", {
      get: function() {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return false;
        }
        return this._readableState.destroyed && this._writableState.destroyed;
      },
      set: function(value) {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return;
        }
        this._readableState.destroyed = value;
        this._writableState.destroyed = value;
      }
    });
    Duplex.prototype._destroy = function(err, cb) {
      this.push(null);
      this.end();
      pna.nextTick(cb, err);
    };
  }
});

// ../../node_modules/lazystream/node_modules/string_decoder/lib/string_decoder.js
var require_string_decoder = __commonJS({
  "../../node_modules/lazystream/node_modules/string_decoder/lib/string_decoder.js"(exports2) {
    "use strict";
    var Buffer2 = require_safe_buffer().Buffer;
    var isEncoding = Buffer2.isEncoding || function(encoding) {
      encoding = "" + encoding;
      switch (encoding && encoding.toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
        case "raw":
          return true;
        default:
          return false;
      }
    };
    function _normalizeEncoding(enc) {
      if (!enc) return "utf8";
      var retried;
      while (true) {
        switch (enc) {
          case "utf8":
          case "utf-8":
            return "utf8";
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return "utf16le";
          case "latin1":
          case "binary":
            return "latin1";
          case "base64":
          case "ascii":
          case "hex":
            return enc;
          default:
            if (retried) return;
            enc = ("" + enc).toLowerCase();
            retried = true;
        }
      }
    }
    function normalizeEncoding(enc) {
      var nenc = _normalizeEncoding(enc);
      if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc))) throw new Error("Unknown encoding: " + enc);
      return nenc || enc;
    }
    exports2.StringDecoder = StringDecoder2;
    function StringDecoder2(encoding) {
      this.encoding = normalizeEncoding(encoding);
      var nb;
      switch (this.encoding) {
        case "utf16le":
          this.text = utf16Text;
          this.end = utf16End;
          nb = 4;
          break;
        case "utf8":
          this.fillLast = utf8FillLast;
          nb = 4;
          break;
        case "base64":
          this.text = base64Text;
          this.end = base64End;
          nb = 3;
          break;
        default:
          this.write = simpleWrite;
          this.end = simpleEnd;
          return;
      }
      this.lastNeed = 0;
      this.lastTotal = 0;
      this.lastChar = Buffer2.allocUnsafe(nb);
    }
    StringDecoder2.prototype.write = function(buf) {
      if (buf.length === 0) return "";
      var r3;
      var i3;
      if (this.lastNeed) {
        r3 = this.fillLast(buf);
        if (r3 === void 0) return "";
        i3 = this.lastNeed;
        this.lastNeed = 0;
      } else {
        i3 = 0;
      }
      if (i3 < buf.length) return r3 ? r3 + this.text(buf, i3) : this.text(buf, i3);
      return r3 || "";
    };
    StringDecoder2.prototype.end = utf8End;
    StringDecoder2.prototype.text = utf8Text;
    StringDecoder2.prototype.fillLast = function(buf) {
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
      this.lastNeed -= buf.length;
    };
    function utf8CheckByte(byte) {
      if (byte <= 127) return 0;
      else if (byte >> 5 === 6) return 2;
      else if (byte >> 4 === 14) return 3;
      else if (byte >> 3 === 30) return 4;
      return byte >> 6 === 2 ? -1 : -2;
    }
    function utf8CheckIncomplete(self2, buf, i3) {
      var j3 = buf.length - 1;
      if (j3 < i3) return 0;
      var nb = utf8CheckByte(buf[j3]);
      if (nb >= 0) {
        if (nb > 0) self2.lastNeed = nb - 1;
        return nb;
      }
      if (--j3 < i3 || nb === -2) return 0;
      nb = utf8CheckByte(buf[j3]);
      if (nb >= 0) {
        if (nb > 0) self2.lastNeed = nb - 2;
        return nb;
      }
      if (--j3 < i3 || nb === -2) return 0;
      nb = utf8CheckByte(buf[j3]);
      if (nb >= 0) {
        if (nb > 0) {
          if (nb === 2) nb = 0;
          else self2.lastNeed = nb - 3;
        }
        return nb;
      }
      return 0;
    }
    function utf8CheckExtraBytes(self2, buf, p3) {
      if ((buf[0] & 192) !== 128) {
        self2.lastNeed = 0;
        return "\uFFFD";
      }
      if (self2.lastNeed > 1 && buf.length > 1) {
        if ((buf[1] & 192) !== 128) {
          self2.lastNeed = 1;
          return "\uFFFD";
        }
        if (self2.lastNeed > 2 && buf.length > 2) {
          if ((buf[2] & 192) !== 128) {
            self2.lastNeed = 2;
            return "\uFFFD";
          }
        }
      }
    }
    function utf8FillLast(buf) {
      var p3 = this.lastTotal - this.lastNeed;
      var r3 = utf8CheckExtraBytes(this, buf, p3);
      if (r3 !== void 0) return r3;
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, p3, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, p3, 0, buf.length);
      this.lastNeed -= buf.length;
    }
    function utf8Text(buf, i3) {
      var total = utf8CheckIncomplete(this, buf, i3);
      if (!this.lastNeed) return buf.toString("utf8", i3);
      this.lastTotal = total;
      var end = buf.length - (total - this.lastNeed);
      buf.copy(this.lastChar, 0, end);
      return buf.toString("utf8", i3, end);
    }
    function utf8End(buf) {
      var r3 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) return r3 + "\uFFFD";
      return r3;
    }
    function utf16Text(buf, i3) {
      if ((buf.length - i3) % 2 === 0) {
        var r3 = buf.toString("utf16le", i3);
        if (r3) {
          var c3 = r3.charCodeAt(r3.length - 1);
          if (c3 >= 55296 && c3 <= 56319) {
            this.lastNeed = 2;
            this.lastTotal = 4;
            this.lastChar[0] = buf[buf.length - 2];
            this.lastChar[1] = buf[buf.length - 1];
            return r3.slice(0, -1);
          }
        }
        return r3;
      }
      this.lastNeed = 1;
      this.lastTotal = 2;
      this.lastChar[0] = buf[buf.length - 1];
      return buf.toString("utf16le", i3, buf.length - 1);
    }
    function utf16End(buf) {
      var r3 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) {
        var end = this.lastTotal - this.lastNeed;
        return r3 + this.lastChar.toString("utf16le", 0, end);
      }
      return r3;
    }
    function base64Text(buf, i3) {
      var n3 = (buf.length - i3) % 3;
      if (n3 === 0) return buf.toString("base64", i3);
      this.lastNeed = 3 - n3;
      this.lastTotal = 3;
      if (n3 === 1) {
        this.lastChar[0] = buf[buf.length - 1];
      } else {
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
      }
      return buf.toString("base64", i3, buf.length - n3);
    }
    function base64End(buf) {
      var r3 = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) return r3 + this.lastChar.toString("base64", 0, 3 - this.lastNeed);
      return r3;
    }
    function simpleWrite(buf) {
      return buf.toString(this.encoding);
    }
    function simpleEnd(buf) {
      return buf && buf.length ? this.write(buf) : "";
    }
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_readable.js
var require_stream_readable = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_readable.js"(exports2, module2) {
    "use strict";
    var pna = require_process_nextick_args();
    module2.exports = Readable;
    var isArray2 = require_isarray();
    var Duplex;
    Readable.ReadableState = ReadableState;
    var EE = require("events").EventEmitter;
    var EElistenerCount = function(emitter, type) {
      return emitter.listeners(type).length;
    };
    var Stream2 = require_stream();
    var Buffer2 = require_safe_buffer().Buffer;
    var OurUint8Array = (typeof global !== "undefined" ? global : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    var util11 = Object.create(require_util());
    util11.inherits = require_inherits();
    var debugUtil = require("util");
    var debug4 = void 0;
    if (debugUtil && debugUtil.debuglog) {
      debug4 = debugUtil.debuglog("stream");
    } else {
      debug4 = function() {
      };
    }
    var BufferList = require_BufferList();
    var destroyImpl = require_destroy();
    var StringDecoder2;
    util11.inherits(Readable, Stream2);
    var kProxyEvents = ["error", "close", "destroy", "pause", "resume"];
    function prependListener(emitter, event, fn) {
      if (typeof emitter.prependListener === "function") return emitter.prependListener(event, fn);
      if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
      else if (isArray2(emitter._events[event])) emitter._events[event].unshift(fn);
      else emitter._events[event] = [fn, emitter._events[event]];
    }
    function ReadableState(options, stream3) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      var isDuplex = stream3 instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;
      var hwm = options.highWaterMark;
      var readableHwm = options.readableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      if (hwm || hwm === 0) this.highWaterMark = hwm;
      else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;
      else this.highWaterMark = defaultHwm;
      this.highWaterMark = Math.floor(this.highWaterMark);
      this.buffer = new BufferList();
      this.length = 0;
      this.pipes = null;
      this.pipesCount = 0;
      this.flowing = null;
      this.ended = false;
      this.endEmitted = false;
      this.reading = false;
      this.sync = true;
      this.needReadable = false;
      this.emittedReadable = false;
      this.readableListening = false;
      this.resumeScheduled = false;
      this.destroyed = false;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.awaitDrain = 0;
      this.readingMore = false;
      this.decoder = null;
      this.encoding = null;
      if (options.encoding) {
        if (!StringDecoder2) StringDecoder2 = require_string_decoder().StringDecoder;
        this.decoder = new StringDecoder2(options.encoding);
        this.encoding = options.encoding;
      }
    }
    function Readable(options) {
      Duplex = Duplex || require_stream_duplex();
      if (!(this instanceof Readable)) return new Readable(options);
      this._readableState = new ReadableState(options, this);
      this.readable = true;
      if (options) {
        if (typeof options.read === "function") this._read = options.read;
        if (typeof options.destroy === "function") this._destroy = options.destroy;
      }
      Stream2.call(this);
    }
    Object.defineProperty(Readable.prototype, "destroyed", {
      get: function() {
        if (this._readableState === void 0) {
          return false;
        }
        return this._readableState.destroyed;
      },
      set: function(value) {
        if (!this._readableState) {
          return;
        }
        this._readableState.destroyed = value;
      }
    });
    Readable.prototype.destroy = destroyImpl.destroy;
    Readable.prototype._undestroy = destroyImpl.undestroy;
    Readable.prototype._destroy = function(err, cb) {
      this.push(null);
      cb(err);
    };
    Readable.prototype.push = function(chunk, encoding) {
      var state2 = this._readableState;
      var skipChunkCheck;
      if (!state2.objectMode) {
        if (typeof chunk === "string") {
          encoding = encoding || state2.defaultEncoding;
          if (encoding !== state2.encoding) {
            chunk = Buffer2.from(chunk, encoding);
            encoding = "";
          }
          skipChunkCheck = true;
        }
      } else {
        skipChunkCheck = true;
      }
      return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
    };
    Readable.prototype.unshift = function(chunk) {
      return readableAddChunk(this, chunk, null, true, false);
    };
    function readableAddChunk(stream3, chunk, encoding, addToFront, skipChunkCheck) {
      var state2 = stream3._readableState;
      if (chunk === null) {
        state2.reading = false;
        onEofChunk(stream3, state2);
      } else {
        var er;
        if (!skipChunkCheck) er = chunkInvalid(state2, chunk);
        if (er) {
          stream3.emit("error", er);
        } else if (state2.objectMode || chunk && chunk.length > 0) {
          if (typeof chunk !== "string" && !state2.objectMode && Object.getPrototypeOf(chunk) !== Buffer2.prototype) {
            chunk = _uint8ArrayToBuffer(chunk);
          }
          if (addToFront) {
            if (state2.endEmitted) stream3.emit("error", new Error("stream.unshift() after end event"));
            else addChunk(stream3, state2, chunk, true);
          } else if (state2.ended) {
            stream3.emit("error", new Error("stream.push() after EOF"));
          } else {
            state2.reading = false;
            if (state2.decoder && !encoding) {
              chunk = state2.decoder.write(chunk);
              if (state2.objectMode || chunk.length !== 0) addChunk(stream3, state2, chunk, false);
              else maybeReadMore(stream3, state2);
            } else {
              addChunk(stream3, state2, chunk, false);
            }
          }
        } else if (!addToFront) {
          state2.reading = false;
        }
      }
      return needMoreData(state2);
    }
    function addChunk(stream3, state2, chunk, addToFront) {
      if (state2.flowing && state2.length === 0 && !state2.sync) {
        stream3.emit("data", chunk);
        stream3.read(0);
      } else {
        state2.length += state2.objectMode ? 1 : chunk.length;
        if (addToFront) state2.buffer.unshift(chunk);
        else state2.buffer.push(chunk);
        if (state2.needReadable) emitReadable(stream3);
      }
      maybeReadMore(stream3, state2);
    }
    function chunkInvalid(state2, chunk) {
      var er;
      if (!_isUint8Array(chunk) && typeof chunk !== "string" && chunk !== void 0 && !state2.objectMode) {
        er = new TypeError("Invalid non-string/buffer chunk");
      }
      return er;
    }
    function needMoreData(state2) {
      return !state2.ended && (state2.needReadable || state2.length < state2.highWaterMark || state2.length === 0);
    }
    Readable.prototype.isPaused = function() {
      return this._readableState.flowing === false;
    };
    Readable.prototype.setEncoding = function(enc) {
      if (!StringDecoder2) StringDecoder2 = require_string_decoder().StringDecoder;
      this._readableState.decoder = new StringDecoder2(enc);
      this._readableState.encoding = enc;
      return this;
    };
    var MAX_HWM = 8388608;
    function computeNewHighWaterMark(n3) {
      if (n3 >= MAX_HWM) {
        n3 = MAX_HWM;
      } else {
        n3--;
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 |= n3 >>> 16;
        n3++;
      }
      return n3;
    }
    function howMuchToRead(n3, state2) {
      if (n3 <= 0 || state2.length === 0 && state2.ended) return 0;
      if (state2.objectMode) return 1;
      if (n3 !== n3) {
        if (state2.flowing && state2.length) return state2.buffer.head.data.length;
        else return state2.length;
      }
      if (n3 > state2.highWaterMark) state2.highWaterMark = computeNewHighWaterMark(n3);
      if (n3 <= state2.length) return n3;
      if (!state2.ended) {
        state2.needReadable = true;
        return 0;
      }
      return state2.length;
    }
    Readable.prototype.read = function(n3) {
      debug4("read", n3);
      n3 = parseInt(n3, 10);
      var state2 = this._readableState;
      var nOrig = n3;
      if (n3 !== 0) state2.emittedReadable = false;
      if (n3 === 0 && state2.needReadable && (state2.length >= state2.highWaterMark || state2.ended)) {
        debug4("read: emitReadable", state2.length, state2.ended);
        if (state2.length === 0 && state2.ended) endReadable(this);
        else emitReadable(this);
        return null;
      }
      n3 = howMuchToRead(n3, state2);
      if (n3 === 0 && state2.ended) {
        if (state2.length === 0) endReadable(this);
        return null;
      }
      var doRead = state2.needReadable;
      debug4("need readable", doRead);
      if (state2.length === 0 || state2.length - n3 < state2.highWaterMark) {
        doRead = true;
        debug4("length less than watermark", doRead);
      }
      if (state2.ended || state2.reading) {
        doRead = false;
        debug4("reading or ended", doRead);
      } else if (doRead) {
        debug4("do read");
        state2.reading = true;
        state2.sync = true;
        if (state2.length === 0) state2.needReadable = true;
        this._read(state2.highWaterMark);
        state2.sync = false;
        if (!state2.reading) n3 = howMuchToRead(nOrig, state2);
      }
      var ret;
      if (n3 > 0) ret = fromList(n3, state2);
      else ret = null;
      if (ret === null) {
        state2.needReadable = true;
        n3 = 0;
      } else {
        state2.length -= n3;
      }
      if (state2.length === 0) {
        if (!state2.ended) state2.needReadable = true;
        if (nOrig !== n3 && state2.ended) endReadable(this);
      }
      if (ret !== null) this.emit("data", ret);
      return ret;
    };
    function onEofChunk(stream3, state2) {
      if (state2.ended) return;
      if (state2.decoder) {
        var chunk = state2.decoder.end();
        if (chunk && chunk.length) {
          state2.buffer.push(chunk);
          state2.length += state2.objectMode ? 1 : chunk.length;
        }
      }
      state2.ended = true;
      emitReadable(stream3);
    }
    function emitReadable(stream3) {
      var state2 = stream3._readableState;
      state2.needReadable = false;
      if (!state2.emittedReadable) {
        debug4("emitReadable", state2.flowing);
        state2.emittedReadable = true;
        if (state2.sync) pna.nextTick(emitReadable_, stream3);
        else emitReadable_(stream3);
      }
    }
    function emitReadable_(stream3) {
      debug4("emit readable");
      stream3.emit("readable");
      flow(stream3);
    }
    function maybeReadMore(stream3, state2) {
      if (!state2.readingMore) {
        state2.readingMore = true;
        pna.nextTick(maybeReadMore_, stream3, state2);
      }
    }
    function maybeReadMore_(stream3, state2) {
      var len = state2.length;
      while (!state2.reading && !state2.flowing && !state2.ended && state2.length < state2.highWaterMark) {
        debug4("maybeReadMore read 0");
        stream3.read(0);
        if (len === state2.length)
          break;
        else len = state2.length;
      }
      state2.readingMore = false;
    }
    Readable.prototype._read = function(n3) {
      this.emit("error", new Error("_read() is not implemented"));
    };
    Readable.prototype.pipe = function(dest, pipeOpts) {
      var src = this;
      var state2 = this._readableState;
      switch (state2.pipesCount) {
        case 0:
          state2.pipes = dest;
          break;
        case 1:
          state2.pipes = [state2.pipes, dest];
          break;
        default:
          state2.pipes.push(dest);
          break;
      }
      state2.pipesCount += 1;
      debug4("pipe count=%d opts=%j", state2.pipesCount, pipeOpts);
      var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
      var endFn = doEnd ? onend : unpipe;
      if (state2.endEmitted) pna.nextTick(endFn);
      else src.once("end", endFn);
      dest.on("unpipe", onunpipe);
      function onunpipe(readable, unpipeInfo) {
        debug4("onunpipe");
        if (readable === src) {
          if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
            unpipeInfo.hasUnpiped = true;
            cleanup();
          }
        }
      }
      function onend() {
        debug4("onend");
        dest.end();
      }
      var ondrain = pipeOnDrain(src);
      dest.on("drain", ondrain);
      var cleanedUp = false;
      function cleanup() {
        debug4("cleanup");
        dest.removeListener("close", onclose);
        dest.removeListener("finish", onfinish);
        dest.removeListener("drain", ondrain);
        dest.removeListener("error", onerror);
        dest.removeListener("unpipe", onunpipe);
        src.removeListener("end", onend);
        src.removeListener("end", unpipe);
        src.removeListener("data", ondata);
        cleanedUp = true;
        if (state2.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
      }
      var increasedAwaitDrain = false;
      src.on("data", ondata);
      function ondata(chunk) {
        debug4("ondata");
        increasedAwaitDrain = false;
        var ret = dest.write(chunk);
        if (false === ret && !increasedAwaitDrain) {
          if ((state2.pipesCount === 1 && state2.pipes === dest || state2.pipesCount > 1 && indexOf(state2.pipes, dest) !== -1) && !cleanedUp) {
            debug4("false write response, pause", state2.awaitDrain);
            state2.awaitDrain++;
            increasedAwaitDrain = true;
          }
          src.pause();
        }
      }
      function onerror(er) {
        debug4("onerror", er);
        unpipe();
        dest.removeListener("error", onerror);
        if (EElistenerCount(dest, "error") === 0) dest.emit("error", er);
      }
      prependListener(dest, "error", onerror);
      function onclose() {
        dest.removeListener("finish", onfinish);
        unpipe();
      }
      dest.once("close", onclose);
      function onfinish() {
        debug4("onfinish");
        dest.removeListener("close", onclose);
        unpipe();
      }
      dest.once("finish", onfinish);
      function unpipe() {
        debug4("unpipe");
        src.unpipe(dest);
      }
      dest.emit("pipe", src);
      if (!state2.flowing) {
        debug4("pipe resume");
        src.resume();
      }
      return dest;
    };
    function pipeOnDrain(src) {
      return function() {
        var state2 = src._readableState;
        debug4("pipeOnDrain", state2.awaitDrain);
        if (state2.awaitDrain) state2.awaitDrain--;
        if (state2.awaitDrain === 0 && EElistenerCount(src, "data")) {
          state2.flowing = true;
          flow(src);
        }
      };
    }
    Readable.prototype.unpipe = function(dest) {
      var state2 = this._readableState;
      var unpipeInfo = { hasUnpiped: false };
      if (state2.pipesCount === 0) return this;
      if (state2.pipesCount === 1) {
        if (dest && dest !== state2.pipes) return this;
        if (!dest) dest = state2.pipes;
        state2.pipes = null;
        state2.pipesCount = 0;
        state2.flowing = false;
        if (dest) dest.emit("unpipe", this, unpipeInfo);
        return this;
      }
      if (!dest) {
        var dests = state2.pipes;
        var len = state2.pipesCount;
        state2.pipes = null;
        state2.pipesCount = 0;
        state2.flowing = false;
        for (var i3 = 0; i3 < len; i3++) {
          dests[i3].emit("unpipe", this, { hasUnpiped: false });
        }
        return this;
      }
      var index = indexOf(state2.pipes, dest);
      if (index === -1) return this;
      state2.pipes.splice(index, 1);
      state2.pipesCount -= 1;
      if (state2.pipesCount === 1) state2.pipes = state2.pipes[0];
      dest.emit("unpipe", this, unpipeInfo);
      return this;
    };
    Readable.prototype.on = function(ev, fn) {
      var res = Stream2.prototype.on.call(this, ev, fn);
      if (ev === "data") {
        if (this._readableState.flowing !== false) this.resume();
      } else if (ev === "readable") {
        var state2 = this._readableState;
        if (!state2.endEmitted && !state2.readableListening) {
          state2.readableListening = state2.needReadable = true;
          state2.emittedReadable = false;
          if (!state2.reading) {
            pna.nextTick(nReadingNextTick, this);
          } else if (state2.length) {
            emitReadable(this);
          }
        }
      }
      return res;
    };
    Readable.prototype.addListener = Readable.prototype.on;
    function nReadingNextTick(self2) {
      debug4("readable nexttick read 0");
      self2.read(0);
    }
    Readable.prototype.resume = function() {
      var state2 = this._readableState;
      if (!state2.flowing) {
        debug4("resume");
        state2.flowing = true;
        resume(this, state2);
      }
      return this;
    };
    function resume(stream3, state2) {
      if (!state2.resumeScheduled) {
        state2.resumeScheduled = true;
        pna.nextTick(resume_, stream3, state2);
      }
    }
    function resume_(stream3, state2) {
      if (!state2.reading) {
        debug4("resume read 0");
        stream3.read(0);
      }
      state2.resumeScheduled = false;
      state2.awaitDrain = 0;
      stream3.emit("resume");
      flow(stream3);
      if (state2.flowing && !state2.reading) stream3.read(0);
    }
    Readable.prototype.pause = function() {
      debug4("call pause flowing=%j", this._readableState.flowing);
      if (false !== this._readableState.flowing) {
        debug4("pause");
        this._readableState.flowing = false;
        this.emit("pause");
      }
      return this;
    };
    function flow(stream3) {
      var state2 = stream3._readableState;
      debug4("flow", state2.flowing);
      while (state2.flowing && stream3.read() !== null) {
      }
    }
    Readable.prototype.wrap = function(stream3) {
      var _this = this;
      var state2 = this._readableState;
      var paused = false;
      stream3.on("end", function() {
        debug4("wrapped end");
        if (state2.decoder && !state2.ended) {
          var chunk = state2.decoder.end();
          if (chunk && chunk.length) _this.push(chunk);
        }
        _this.push(null);
      });
      stream3.on("data", function(chunk) {
        debug4("wrapped data");
        if (state2.decoder) chunk = state2.decoder.write(chunk);
        if (state2.objectMode && (chunk === null || chunk === void 0)) return;
        else if (!state2.objectMode && (!chunk || !chunk.length)) return;
        var ret = _this.push(chunk);
        if (!ret) {
          paused = true;
          stream3.pause();
        }
      });
      for (var i3 in stream3) {
        if (this[i3] === void 0 && typeof stream3[i3] === "function") {
          this[i3] = /* @__PURE__ */ function(method) {
            return function() {
              return stream3[method].apply(stream3, arguments);
            };
          }(i3);
        }
      }
      for (var n3 = 0; n3 < kProxyEvents.length; n3++) {
        stream3.on(kProxyEvents[n3], this.emit.bind(this, kProxyEvents[n3]));
      }
      this._read = function(n4) {
        debug4("wrapped _read", n4);
        if (paused) {
          paused = false;
          stream3.resume();
        }
      };
      return this;
    };
    Object.defineProperty(Readable.prototype, "readableHighWaterMark", {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function() {
        return this._readableState.highWaterMark;
      }
    });
    Readable._fromList = fromList;
    function fromList(n3, state2) {
      if (state2.length === 0) return null;
      var ret;
      if (state2.objectMode) ret = state2.buffer.shift();
      else if (!n3 || n3 >= state2.length) {
        if (state2.decoder) ret = state2.buffer.join("");
        else if (state2.buffer.length === 1) ret = state2.buffer.head.data;
        else ret = state2.buffer.concat(state2.length);
        state2.buffer.clear();
      } else {
        ret = fromListPartial(n3, state2.buffer, state2.decoder);
      }
      return ret;
    }
    function fromListPartial(n3, list, hasStrings) {
      var ret;
      if (n3 < list.head.data.length) {
        ret = list.head.data.slice(0, n3);
        list.head.data = list.head.data.slice(n3);
      } else if (n3 === list.head.data.length) {
        ret = list.shift();
      } else {
        ret = hasStrings ? copyFromBufferString(n3, list) : copyFromBuffer(n3, list);
      }
      return ret;
    }
    function copyFromBufferString(n3, list) {
      var p3 = list.head;
      var c3 = 1;
      var ret = p3.data;
      n3 -= ret.length;
      while (p3 = p3.next) {
        var str = p3.data;
        var nb = n3 > str.length ? str.length : n3;
        if (nb === str.length) ret += str;
        else ret += str.slice(0, n3);
        n3 -= nb;
        if (n3 === 0) {
          if (nb === str.length) {
            ++c3;
            if (p3.next) list.head = p3.next;
            else list.head = list.tail = null;
          } else {
            list.head = p3;
            p3.data = str.slice(nb);
          }
          break;
        }
        ++c3;
      }
      list.length -= c3;
      return ret;
    }
    function copyFromBuffer(n3, list) {
      var ret = Buffer2.allocUnsafe(n3);
      var p3 = list.head;
      var c3 = 1;
      p3.data.copy(ret);
      n3 -= p3.data.length;
      while (p3 = p3.next) {
        var buf = p3.data;
        var nb = n3 > buf.length ? buf.length : n3;
        buf.copy(ret, ret.length - n3, 0, nb);
        n3 -= nb;
        if (n3 === 0) {
          if (nb === buf.length) {
            ++c3;
            if (p3.next) list.head = p3.next;
            else list.head = list.tail = null;
          } else {
            list.head = p3;
            p3.data = buf.slice(nb);
          }
          break;
        }
        ++c3;
      }
      list.length -= c3;
      return ret;
    }
    function endReadable(stream3) {
      var state2 = stream3._readableState;
      if (state2.length > 0) throw new Error('"endReadable()" called on non-empty stream');
      if (!state2.endEmitted) {
        state2.ended = true;
        pna.nextTick(endReadableNT, state2, stream3);
      }
    }
    function endReadableNT(state2, stream3) {
      if (!state2.endEmitted && state2.length === 0) {
        state2.endEmitted = true;
        stream3.readable = false;
        stream3.emit("end");
      }
    }
    function indexOf(xs, x3) {
      for (var i3 = 0, l3 = xs.length; i3 < l3; i3++) {
        if (xs[i3] === x3) return i3;
      }
      return -1;
    }
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_transform.js
var require_stream_transform = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_transform.js"(exports2, module2) {
    "use strict";
    module2.exports = Transform;
    var Duplex = require_stream_duplex();
    var util11 = Object.create(require_util());
    util11.inherits = require_inherits();
    util11.inherits(Transform, Duplex);
    function afterTransform(er, data2) {
      var ts = this._transformState;
      ts.transforming = false;
      var cb = ts.writecb;
      if (!cb) {
        return this.emit("error", new Error("write callback called multiple times"));
      }
      ts.writechunk = null;
      ts.writecb = null;
      if (data2 != null)
        this.push(data2);
      cb(er);
      var rs = this._readableState;
      rs.reading = false;
      if (rs.needReadable || rs.length < rs.highWaterMark) {
        this._read(rs.highWaterMark);
      }
    }
    function Transform(options) {
      if (!(this instanceof Transform)) return new Transform(options);
      Duplex.call(this, options);
      this._transformState = {
        afterTransform: afterTransform.bind(this),
        needTransform: false,
        transforming: false,
        writecb: null,
        writechunk: null,
        writeencoding: null
      };
      this._readableState.needReadable = true;
      this._readableState.sync = false;
      if (options) {
        if (typeof options.transform === "function") this._transform = options.transform;
        if (typeof options.flush === "function") this._flush = options.flush;
      }
      this.on("prefinish", prefinish);
    }
    function prefinish() {
      var _this = this;
      if (typeof this._flush === "function") {
        this._flush(function(er, data2) {
          done(_this, er, data2);
        });
      } else {
        done(this, null, null);
      }
    }
    Transform.prototype.push = function(chunk, encoding) {
      this._transformState.needTransform = false;
      return Duplex.prototype.push.call(this, chunk, encoding);
    };
    Transform.prototype._transform = function(chunk, encoding, cb) {
      throw new Error("_transform() is not implemented");
    };
    Transform.prototype._write = function(chunk, encoding, cb) {
      var ts = this._transformState;
      ts.writecb = cb;
      ts.writechunk = chunk;
      ts.writeencoding = encoding;
      if (!ts.transforming) {
        var rs = this._readableState;
        if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
      }
    };
    Transform.prototype._read = function(n3) {
      var ts = this._transformState;
      if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
        ts.transforming = true;
        this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
      } else {
        ts.needTransform = true;
      }
    };
    Transform.prototype._destroy = function(err, cb) {
      var _this2 = this;
      Duplex.prototype._destroy.call(this, err, function(err2) {
        cb(err2);
        _this2.emit("close");
      });
    };
    function done(stream3, er, data2) {
      if (er) return stream3.emit("error", er);
      if (data2 != null)
        stream3.push(data2);
      if (stream3._writableState.length) throw new Error("Calling transform done when ws.length != 0");
      if (stream3._transformState.transforming) throw new Error("Calling transform done when still transforming");
      return stream3.push(null);
    }
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_passthrough.js
var require_stream_passthrough = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/lib/_stream_passthrough.js"(exports2, module2) {
    "use strict";
    module2.exports = PassThrough;
    var Transform = require_stream_transform();
    var util11 = Object.create(require_util());
    util11.inherits = require_inherits();
    util11.inherits(PassThrough, Transform);
    function PassThrough(options) {
      if (!(this instanceof PassThrough)) return new PassThrough(options);
      Transform.call(this, options);
    }
    PassThrough.prototype._transform = function(chunk, encoding, cb) {
      cb(null, chunk);
    };
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/readable.js
var require_readable = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/readable.js"(exports2, module2) {
    var Stream2 = require("stream");
    if (process.env.READABLE_STREAM === "disable" && Stream2) {
      module2.exports = Stream2;
      exports2 = module2.exports = Stream2.Readable;
      exports2.Readable = Stream2.Readable;
      exports2.Writable = Stream2.Writable;
      exports2.Duplex = Stream2.Duplex;
      exports2.Transform = Stream2.Transform;
      exports2.PassThrough = Stream2.PassThrough;
      exports2.Stream = Stream2;
    } else {
      exports2 = module2.exports = require_stream_readable();
      exports2.Stream = Stream2 || exports2;
      exports2.Readable = exports2;
      exports2.Writable = require_stream_writable();
      exports2.Duplex = require_stream_duplex();
      exports2.Transform = require_stream_transform();
      exports2.PassThrough = require_stream_passthrough();
    }
  }
});

// ../../node_modules/lazystream/node_modules/readable-stream/passthrough.js
var require_passthrough = __commonJS({
  "../../node_modules/lazystream/node_modules/readable-stream/passthrough.js"(exports2, module2) {
    module2.exports = require_readable().PassThrough;
  }
});

// ../../node_modules/lazystream/lib/lazystream.js
var require_lazystream = __commonJS({
  "../../node_modules/lazystream/lib/lazystream.js"(exports2, module2) {
    var util11 = require("util");
    var PassThrough = require_passthrough();
    module2.exports = {
      Readable,
      Writable: Writable3
    };
    util11.inherits(Readable, PassThrough);
    util11.inherits(Writable3, PassThrough);
    function beforeFirstCall(instance, method, callback) {
      instance[method] = function() {
        delete instance[method];
        callback.apply(this, arguments);
        return this[method].apply(this, arguments);
      };
    }
    function Readable(fn, options) {
      if (!(this instanceof Readable))
        return new Readable(fn, options);
      PassThrough.call(this, options);
      beforeFirstCall(this, "_read", function() {
        var source = fn.call(this, options);
        var emit = this.emit.bind(this, "error");
        source.on("error", emit);
        source.pipe(this);
      });
      this.emit("readable");
    }
    function Writable3(fn, options) {
      if (!(this instanceof Writable3))
        return new Writable3(fn, options);
      PassThrough.call(this, options);
      beforeFirstCall(this, "_write", function() {
        var destination = fn.call(this, options);
        var emit = this.emit.bind(this, "error");
        destination.on("error", emit);
        this.pipe(destination);
      });
      this.emit("writable");
    }
  }
});

// ../../node_modules/normalize-path/index.js
var require_normalize_path = __commonJS({
  "../../node_modules/normalize-path/index.js"(exports2, module2) {
    module2.exports = function(path34, stripTrailing) {
      if (typeof path34 !== "string") {
        throw new TypeError("expected path to be a string");
      }
      if (path34 === "\\" || path34 === "/") return "/";
      var len = path34.length;
      if (len <= 1) return path34;
      var prefix2 = "";
      if (len > 4 && path34[3] === "\\") {
        var ch = path34[2];
        if ((ch === "?" || ch === ".") && path34.slice(0, 2) === "\\\\") {
          path34 = path34.slice(2);
          prefix2 = "//";
        }
      }
      var segs = path34.split(/[/\\]+/);
      if (stripTrailing !== false && segs[segs.length - 1] === "") {
        segs.pop();
      }
      return prefix2 + segs.join("/");
    };
  }
});

// ../../node_modules/lodash/identity.js
var require_identity = __commonJS({
  "../../node_modules/lodash/identity.js"(exports2, module2) {
    function identity(value) {
      return value;
    }
    module2.exports = identity;
  }
});

// ../../node_modules/lodash/_apply.js
var require_apply = __commonJS({
  "../../node_modules/lodash/_apply.js"(exports2, module2) {
    function apply(func, thisArg, args) {
      switch (args.length) {
        case 0:
          return func.call(thisArg);
        case 1:
          return func.call(thisArg, args[0]);
        case 2:
          return func.call(thisArg, args[0], args[1]);
        case 3:
          return func.call(thisArg, args[0], args[1], args[2]);
      }
      return func.apply(thisArg, args);
    }
    module2.exports = apply;
  }
});

// ../../node_modules/lodash/_overRest.js
var require_overRest = __commonJS({
  "../../node_modules/lodash/_overRest.js"(exports2, module2) {
    var apply = require_apply();
    var nativeMax = Math.max;
    function overRest(func, start, transform) {
      start = nativeMax(start === void 0 ? func.length - 1 : start, 0);
      return function() {
        var args = arguments, index = -1, length = nativeMax(args.length - start, 0), array = Array(length);
        while (++index < length) {
          array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while (++index < start) {
          otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return apply(func, this, otherArgs);
      };
    }
    module2.exports = overRest;
  }
});

// ../../node_modules/lodash/constant.js
var require_constant = __commonJS({
  "../../node_modules/lodash/constant.js"(exports2, module2) {
    function constant(value) {
      return function() {
        return value;
      };
    }
    module2.exports = constant;
  }
});

// ../../node_modules/lodash/_freeGlobal.js
var require_freeGlobal = __commonJS({
  "../../node_modules/lodash/_freeGlobal.js"(exports2, module2) {
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    module2.exports = freeGlobal;
  }
});

// ../../node_modules/lodash/_root.js
var require_root = __commonJS({
  "../../node_modules/lodash/_root.js"(exports2, module2) {
    var freeGlobal = require_freeGlobal();
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    module2.exports = root;
  }
});

// ../../node_modules/lodash/_Symbol.js
var require_Symbol = __commonJS({
  "../../node_modules/lodash/_Symbol.js"(exports2, module2) {
    var root = require_root();
    var Symbol2 = root.Symbol;
    module2.exports = Symbol2;
  }
});

// ../../node_modules/lodash/_getRawTag.js
var require_getRawTag = __commonJS({
  "../../node_modules/lodash/_getRawTag.js"(exports2, module2) {
    var Symbol2 = require_Symbol();
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var nativeObjectToString = objectProto.toString;
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function getRawTag(value) {
      var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
      try {
        value[symToStringTag] = void 0;
        var unmasked = true;
      } catch (e3) {
      }
      var result3 = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }
      return result3;
    }
    module2.exports = getRawTag;
  }
});

// ../../node_modules/lodash/_objectToString.js
var require_objectToString = __commonJS({
  "../../node_modules/lodash/_objectToString.js"(exports2, module2) {
    var objectProto = Object.prototype;
    var nativeObjectToString = objectProto.toString;
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    module2.exports = objectToString;
  }
});

// ../../node_modules/lodash/_baseGetTag.js
var require_baseGetTag = __commonJS({
  "../../node_modules/lodash/_baseGetTag.js"(exports2, module2) {
    var Symbol2 = require_Symbol();
    var getRawTag = require_getRawTag();
    var objectToString = require_objectToString();
    var nullTag = "[object Null]";
    var undefinedTag = "[object Undefined]";
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function baseGetTag(value) {
      if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
      }
      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    module2.exports = baseGetTag;
  }
});

// ../../node_modules/lodash/isObject.js
var require_isObject = __commonJS({
  "../../node_modules/lodash/isObject.js"(exports2, module2) {
    function isObject3(value) {
      var type = typeof value;
      return value != null && (type == "object" || type == "function");
    }
    module2.exports = isObject3;
  }
});

// ../../node_modules/lodash/isFunction.js
var require_isFunction = __commonJS({
  "../../node_modules/lodash/isFunction.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isObject3 = require_isObject();
    var asyncTag = "[object AsyncFunction]";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var proxyTag = "[object Proxy]";
    function isFunction(value) {
      if (!isObject3(value)) {
        return false;
      }
      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    module2.exports = isFunction;
  }
});

// ../../node_modules/lodash/_coreJsData.js
var require_coreJsData = __commonJS({
  "../../node_modules/lodash/_coreJsData.js"(exports2, module2) {
    var root = require_root();
    var coreJsData = root["__core-js_shared__"];
    module2.exports = coreJsData;
  }
});

// ../../node_modules/lodash/_isMasked.js
var require_isMasked = __commonJS({
  "../../node_modules/lodash/_isMasked.js"(exports2, module2) {
    var coreJsData = require_coreJsData();
    var maskSrcKey = function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
      return uid ? "Symbol(src)_1." + uid : "";
    }();
    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    module2.exports = isMasked;
  }
});

// ../../node_modules/lodash/_toSource.js
var require_toSource = __commonJS({
  "../../node_modules/lodash/_toSource.js"(exports2, module2) {
    var funcProto = Function.prototype;
    var funcToString = funcProto.toString;
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e3) {
        }
        try {
          return func + "";
        } catch (e3) {
        }
      }
      return "";
    }
    module2.exports = toSource;
  }
});

// ../../node_modules/lodash/_baseIsNative.js
var require_baseIsNative = __commonJS({
  "../../node_modules/lodash/_baseIsNative.js"(exports2, module2) {
    var isFunction = require_isFunction();
    var isMasked = require_isMasked();
    var isObject3 = require_isObject();
    var toSource = require_toSource();
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var funcProto = Function.prototype;
    var objectProto = Object.prototype;
    var funcToString = funcProto.toString;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var reIsNative = RegExp(
      "^" + funcToString.call(hasOwnProperty).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
    );
    function baseIsNative(value) {
      if (!isObject3(value) || isMasked(value)) {
        return false;
      }
      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    module2.exports = baseIsNative;
  }
});

// ../../node_modules/lodash/_getValue.js
var require_getValue = __commonJS({
  "../../node_modules/lodash/_getValue.js"(exports2, module2) {
    function getValue(object, key) {
      return object == null ? void 0 : object[key];
    }
    module2.exports = getValue;
  }
});

// ../../node_modules/lodash/_getNative.js
var require_getNative = __commonJS({
  "../../node_modules/lodash/_getNative.js"(exports2, module2) {
    var baseIsNative = require_baseIsNative();
    var getValue = require_getValue();
    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : void 0;
    }
    module2.exports = getNative;
  }
});

// ../../node_modules/lodash/_defineProperty.js
var require_defineProperty = __commonJS({
  "../../node_modules/lodash/_defineProperty.js"(exports2, module2) {
    var getNative = require_getNative();
    var defineProperty = function() {
      try {
        var func = getNative(Object, "defineProperty");
        func({}, "", {});
        return func;
      } catch (e3) {
      }
    }();
    module2.exports = defineProperty;
  }
});

// ../../node_modules/lodash/_baseSetToString.js
var require_baseSetToString = __commonJS({
  "../../node_modules/lodash/_baseSetToString.js"(exports2, module2) {
    var constant = require_constant();
    var defineProperty = require_defineProperty();
    var identity = require_identity();
    var baseSetToString = !defineProperty ? identity : function(func, string) {
      return defineProperty(func, "toString", {
        "configurable": true,
        "enumerable": false,
        "value": constant(string),
        "writable": true
      });
    };
    module2.exports = baseSetToString;
  }
});

// ../../node_modules/lodash/_shortOut.js
var require_shortOut = __commonJS({
  "../../node_modules/lodash/_shortOut.js"(exports2, module2) {
    var HOT_COUNT = 800;
    var HOT_SPAN = 16;
    var nativeNow = Date.now;
    function shortOut(func) {
      var count = 0, lastCalled = 0;
      return function() {
        var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return arguments[0];
          }
        } else {
          count = 0;
        }
        return func.apply(void 0, arguments);
      };
    }
    module2.exports = shortOut;
  }
});

// ../../node_modules/lodash/_setToString.js
var require_setToString = __commonJS({
  "../../node_modules/lodash/_setToString.js"(exports2, module2) {
    var baseSetToString = require_baseSetToString();
    var shortOut = require_shortOut();
    var setToString = shortOut(baseSetToString);
    module2.exports = setToString;
  }
});

// ../../node_modules/lodash/_baseRest.js
var require_baseRest = __commonJS({
  "../../node_modules/lodash/_baseRest.js"(exports2, module2) {
    var identity = require_identity();
    var overRest = require_overRest();
    var setToString = require_setToString();
    function baseRest(func, start) {
      return setToString(overRest(func, start, identity), func + "");
    }
    module2.exports = baseRest;
  }
});

// ../../node_modules/lodash/eq.js
var require_eq2 = __commonJS({
  "../../node_modules/lodash/eq.js"(exports2, module2) {
    function eq2(value, other) {
      return value === other || value !== value && other !== other;
    }
    module2.exports = eq2;
  }
});

// ../../node_modules/lodash/isLength.js
var require_isLength = __commonJS({
  "../../node_modules/lodash/isLength.js"(exports2, module2) {
    var MAX_SAFE_INTEGER = 9007199254740991;
    function isLength(value) {
      return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    module2.exports = isLength;
  }
});

// ../../node_modules/lodash/isArrayLike.js
var require_isArrayLike = __commonJS({
  "../../node_modules/lodash/isArrayLike.js"(exports2, module2) {
    var isFunction = require_isFunction();
    var isLength = require_isLength();
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    module2.exports = isArrayLike;
  }
});

// ../../node_modules/lodash/_isIndex.js
var require_isIndex = __commonJS({
  "../../node_modules/lodash/_isIndex.js"(exports2, module2) {
    var MAX_SAFE_INTEGER = 9007199254740991;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    function isIndex(value, length) {
      var type = typeof value;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
    }
    module2.exports = isIndex;
  }
});

// ../../node_modules/lodash/_isIterateeCall.js
var require_isIterateeCall = __commonJS({
  "../../node_modules/lodash/_isIterateeCall.js"(exports2, module2) {
    var eq2 = require_eq2();
    var isArrayLike = require_isArrayLike();
    var isIndex = require_isIndex();
    var isObject3 = require_isObject();
    function isIterateeCall(value, index, object) {
      if (!isObject3(object)) {
        return false;
      }
      var type = typeof index;
      if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
        return eq2(object[index], value);
      }
      return false;
    }
    module2.exports = isIterateeCall;
  }
});

// ../../node_modules/lodash/_baseTimes.js
var require_baseTimes = __commonJS({
  "../../node_modules/lodash/_baseTimes.js"(exports2, module2) {
    function baseTimes(n3, iteratee) {
      var index = -1, result3 = Array(n3);
      while (++index < n3) {
        result3[index] = iteratee(index);
      }
      return result3;
    }
    module2.exports = baseTimes;
  }
});

// ../../node_modules/lodash/isObjectLike.js
var require_isObjectLike = __commonJS({
  "../../node_modules/lodash/isObjectLike.js"(exports2, module2) {
    function isObjectLike(value) {
      return value != null && typeof value == "object";
    }
    module2.exports = isObjectLike;
  }
});

// ../../node_modules/lodash/_baseIsArguments.js
var require_baseIsArguments = __commonJS({
  "../../node_modules/lodash/_baseIsArguments.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isObjectLike = require_isObjectLike();
    var argsTag = "[object Arguments]";
    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }
    module2.exports = baseIsArguments;
  }
});

// ../../node_modules/lodash/isArguments.js
var require_isArguments = __commonJS({
  "../../node_modules/lodash/isArguments.js"(exports2, module2) {
    var baseIsArguments = require_baseIsArguments();
    var isObjectLike = require_isObjectLike();
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var propertyIsEnumerable = objectProto.propertyIsEnumerable;
    var isArguments = baseIsArguments(/* @__PURE__ */ function() {
      return arguments;
    }()) ? baseIsArguments : function(value) {
      return isObjectLike(value) && hasOwnProperty.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
    };
    module2.exports = isArguments;
  }
});

// ../../node_modules/lodash/isArray.js
var require_isArray = __commonJS({
  "../../node_modules/lodash/isArray.js"(exports2, module2) {
    var isArray2 = Array.isArray;
    module2.exports = isArray2;
  }
});

// ../../node_modules/lodash/stubFalse.js
var require_stubFalse = __commonJS({
  "../../node_modules/lodash/stubFalse.js"(exports2, module2) {
    function stubFalse() {
      return false;
    }
    module2.exports = stubFalse;
  }
});

// ../../node_modules/lodash/isBuffer.js
var require_isBuffer = __commonJS({
  "../../node_modules/lodash/isBuffer.js"(exports2, module2) {
    var root = require_root();
    var stubFalse = require_stubFalse();
    var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer = nativeIsBuffer || stubFalse;
    module2.exports = isBuffer;
  }
});

// ../../node_modules/lodash/_baseIsTypedArray.js
var require_baseIsTypedArray = __commonJS({
  "../../node_modules/lodash/_baseIsTypedArray.js"(exports2, module2) {
    var baseGetTag = require_baseGetTag();
    var isLength = require_isLength();
    var isObjectLike = require_isObjectLike();
    var argsTag = "[object Arguments]";
    var arrayTag = "[object Array]";
    var boolTag = "[object Boolean]";
    var dateTag = "[object Date]";
    var errorTag = "[object Error]";
    var funcTag = "[object Function]";
    var mapTag = "[object Map]";
    var numberTag = "[object Number]";
    var objectTag = "[object Object]";
    var regexpTag = "[object RegExp]";
    var setTag = "[object Set]";
    var stringTag = "[object String]";
    var weakMapTag = "[object WeakMap]";
    var arrayBufferTag = "[object ArrayBuffer]";
    var dataViewTag = "[object DataView]";
    var float32Tag = "[object Float32Array]";
    var float64Tag = "[object Float64Array]";
    var int8Tag = "[object Int8Array]";
    var int16Tag = "[object Int16Array]";
    var int32Tag = "[object Int32Array]";
    var uint8Tag = "[object Uint8Array]";
    var uint8ClampedTag = "[object Uint8ClampedArray]";
    var uint16Tag = "[object Uint16Array]";
    var uint32Tag = "[object Uint32Array]";
    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }
    module2.exports = baseIsTypedArray;
  }
});

// ../../node_modules/lodash/_baseUnary.js
var require_baseUnary = __commonJS({
  "../../node_modules/lodash/_baseUnary.js"(exports2, module2) {
    function baseUnary(func) {
      return function(value) {
        return func(value);
      };
    }
    module2.exports = baseUnary;
  }
});

// ../../node_modules/lodash/_nodeUtil.js
var require_nodeUtil = __commonJS({
  "../../node_modules/lodash/_nodeUtil.js"(exports2, module2) {
    var freeGlobal = require_freeGlobal();
    var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
    var freeModule = freeExports && typeof module2 == "object" && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal.process;
    var nodeUtil = function() {
      try {
        var types5 = freeModule && freeModule.require && freeModule.require("util").types;
        if (types5) {
          return types5;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e3) {
      }
    }();
    module2.exports = nodeUtil;
  }
});

// ../../node_modules/lodash/isTypedArray.js
var require_isTypedArray = __commonJS({
  "../../node_modules/lodash/isTypedArray.js"(exports2, module2) {
    var baseIsTypedArray = require_baseIsTypedArray();
    var baseUnary = require_baseUnary();
    var nodeUtil = require_nodeUtil();
    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    module2.exports = isTypedArray;
  }
});

// ../../node_modules/lodash/_arrayLikeKeys.js
var require_arrayLikeKeys = __commonJS({
  "../../node_modules/lodash/_arrayLikeKeys.js"(exports2, module2) {
    var baseTimes = require_baseTimes();
    var isArguments = require_isArguments();
    var isArray2 = require_isArray();
    var isBuffer = require_isBuffer();
    var isIndex = require_isIndex();
    var isTypedArray = require_isTypedArray();
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    function arrayLikeKeys(value, inherited) {
      var isArr = isArray2(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result3 = skipIndexes ? baseTimes(value.length, String) : [], length = result3.length;
      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
        (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
        isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
        isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
        isIndex(key, length)))) {
          result3.push(key);
        }
      }
      return result3;
    }
    module2.exports = arrayLikeKeys;
  }
});

// ../../node_modules/lodash/_isPrototype.js
var require_isPrototype = __commonJS({
  "../../node_modules/lodash/_isPrototype.js"(exports2, module2) {
    var objectProto = Object.prototype;
    function isPrototype(value) {
      var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
      return value === proto;
    }
    module2.exports = isPrototype;
  }
});

// ../../node_modules/lodash/_nativeKeysIn.js
var require_nativeKeysIn = __commonJS({
  "../../node_modules/lodash/_nativeKeysIn.js"(exports2, module2) {
    function nativeKeysIn(object) {
      var result3 = [];
      if (object != null) {
        for (var key in Object(object)) {
          result3.push(key);
        }
      }
      return result3;
    }
    module2.exports = nativeKeysIn;
  }
});

// ../../node_modules/lodash/_baseKeysIn.js
var require_baseKeysIn = __commonJS({
  "../../node_modules/lodash/_baseKeysIn.js"(exports2, module2) {
    var isObject3 = require_isObject();
    var isPrototype = require_isPrototype();
    var nativeKeysIn = require_nativeKeysIn();
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    function baseKeysIn(object) {
      if (!isObject3(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype(object), result3 = [];
      for (var key in object) {
        if (!(key == "constructor" && (isProto || !hasOwnProperty.call(object, key)))) {
          result3.push(key);
        }
      }
      return result3;
    }
    module2.exports = baseKeysIn;
  }
});

// ../../node_modules/lodash/keysIn.js
var require_keysIn = __commonJS({
  "../../node_modules/lodash/keysIn.js"(exports2, module2) {
    var arrayLikeKeys = require_arrayLikeKeys();
    var baseKeysIn = require_baseKeysIn();
    var isArrayLike = require_isArrayLike();
    function keysIn(object) {
      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
    }
    module2.exports = keysIn;
  }
});

// ../../node_modules/lodash/defaults.js
var require_defaults = __commonJS({
  "../../node_modules/lodash/defaults.js"(exports2, module2) {
    var baseRest = require_baseRest();
    var eq2 = require_eq2();
    var isIterateeCall = require_isIterateeCall();
    var keysIn = require_keysIn();
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var defaults4 = baseRest(function(object, sources) {
      object = Object(object);
      var index = -1;
      var length = sources.length;
      var guard = length > 2 ? sources[2] : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        length = 1;
      }
      while (++index < length) {
        var source = sources[index];
        var props = keysIn(source);
        var propsIndex = -1;
        var propsLength = props.length;
        while (++propsIndex < propsLength) {
          var key = props[propsIndex];
          var value = object[key];
          if (value === void 0 || eq2(value, objectProto[key]) && !hasOwnProperty.call(object, key)) {
            object[key] = source[key];
          }
        }
      }
      return object;
    });
    module2.exports = defaults4;
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/primordials.js
var require_primordials = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/primordials.js"(exports2, module2) {
    "use strict";
    var AggregateError = class extends Error {
      constructor(errors) {
        if (!Array.isArray(errors)) {
          throw new TypeError(`Expected input to be an Array, got ${typeof errors}`);
        }
        let message2 = "";
        for (let i3 = 0; i3 < errors.length; i3++) {
          message2 += `    ${errors[i3].stack}
`;
        }
        super(message2);
        this.name = "AggregateError";
        this.errors = errors;
      }
    };
    module2.exports = {
      AggregateError,
      ArrayIsArray(self2) {
        return Array.isArray(self2);
      },
      ArrayPrototypeIncludes(self2, el) {
        return self2.includes(el);
      },
      ArrayPrototypeIndexOf(self2, el) {
        return self2.indexOf(el);
      },
      ArrayPrototypeJoin(self2, sep5) {
        return self2.join(sep5);
      },
      ArrayPrototypeMap(self2, fn) {
        return self2.map(fn);
      },
      ArrayPrototypePop(self2, el) {
        return self2.pop(el);
      },
      ArrayPrototypePush(self2, el) {
        return self2.push(el);
      },
      ArrayPrototypeSlice(self2, start, end) {
        return self2.slice(start, end);
      },
      Error,
      FunctionPrototypeCall(fn, thisArgs, ...args) {
        return fn.call(thisArgs, ...args);
      },
      FunctionPrototypeSymbolHasInstance(self2, instance) {
        return Function.prototype[Symbol.hasInstance].call(self2, instance);
      },
      MathFloor: Math.floor,
      Number,
      NumberIsInteger: Number.isInteger,
      NumberIsNaN: Number.isNaN,
      NumberMAX_SAFE_INTEGER: Number.MAX_SAFE_INTEGER,
      NumberMIN_SAFE_INTEGER: Number.MIN_SAFE_INTEGER,
      NumberParseInt: Number.parseInt,
      ObjectDefineProperties(self2, props) {
        return Object.defineProperties(self2, props);
      },
      ObjectDefineProperty(self2, name, prop) {
        return Object.defineProperty(self2, name, prop);
      },
      ObjectGetOwnPropertyDescriptor(self2, name) {
        return Object.getOwnPropertyDescriptor(self2, name);
      },
      ObjectKeys(obj) {
        return Object.keys(obj);
      },
      ObjectSetPrototypeOf(target, proto) {
        return Object.setPrototypeOf(target, proto);
      },
      Promise,
      PromisePrototypeCatch(self2, fn) {
        return self2.catch(fn);
      },
      PromisePrototypeThen(self2, thenFn, catchFn) {
        return self2.then(thenFn, catchFn);
      },
      PromiseReject(err) {
        return Promise.reject(err);
      },
      PromiseResolve(val2) {
        return Promise.resolve(val2);
      },
      ReflectApply: Reflect.apply,
      RegExpPrototypeTest(self2, value) {
        return self2.test(value);
      },
      SafeSet: Set,
      String,
      StringPrototypeSlice(self2, start, end) {
        return self2.slice(start, end);
      },
      StringPrototypeToLowerCase(self2) {
        return self2.toLowerCase();
      },
      StringPrototypeToUpperCase(self2) {
        return self2.toUpperCase();
      },
      StringPrototypeTrim(self2) {
        return self2.trim();
      },
      Symbol,
      SymbolFor: Symbol.for,
      SymbolAsyncIterator: Symbol.asyncIterator,
      SymbolHasInstance: Symbol.hasInstance,
      SymbolIterator: Symbol.iterator,
      SymbolDispose: Symbol.dispose || Symbol("Symbol.dispose"),
      SymbolAsyncDispose: Symbol.asyncDispose || Symbol("Symbol.asyncDispose"),
      TypedArrayPrototypeSet(self2, buf, len) {
        return self2.set(buf, len);
      },
      Boolean,
      Uint8Array
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util/inspect.js
var require_inspect = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/util/inspect.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      format(format26, ...args) {
        return format26.replace(/%([sdifj])/g, function(...[_unused, type]) {
          const replacement = args.shift();
          if (type === "f") {
            return replacement.toFixed(6);
          } else if (type === "j") {
            return JSON.stringify(replacement);
          } else if (type === "s" && typeof replacement === "object") {
            const ctor = replacement.constructor !== Object ? replacement.constructor.name : "";
            return `${ctor} {}`.trim();
          } else {
            return replacement.toString();
          }
        });
      },
      inspect(value) {
        switch (typeof value) {
          case "string":
            if (value.includes("'")) {
              if (!value.includes('"')) {
                return `"${value}"`;
              } else if (!value.includes("`") && !value.includes("${")) {
                return `\`${value}\``;
              }
            }
            return `'${value}'`;
          case "number":
            if (isNaN(value)) {
              return "NaN";
            } else if (Object.is(value, -0)) {
              return String(value);
            }
            return value;
          case "bigint":
            return `${String(value)}n`;
          case "boolean":
          case "undefined":
            return String(value);
          case "object":
            return "{}";
        }
      }
    };
  }
});

// ../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/errors.js
var require_errors = __commonJS({
  "../../node_modules/archiver-utils/node_modules/readable-stream/lib/ours/errors.js"(exports2, module2) {
    "use strict";
    var { format: format26, inspect: inspect4 } = require_inspect();
    var { AggregateError: CustomAggregateError } = require_primordials();
    var AggregateError = globalThis.AggregateError || CustomAggregateError;
    var kIsNodeError = Symbol("kIsNodeError");
    var kTypes = [
      "string",
      "function",
      "number",
      "object",
      // Accept 'Function' and 'Object' as alternative to the lower cased version.
      "Function",
      "Object",
      "boolean",
      "bigint",
      "symbol"
    ];
    var classRegExp = /^([A-Z][a-z0-9]*)+$/;
    var nodeInternalPrefix = "__node_internal_";
    var codes = {};
    function assert(value, message2) {
      if (!value) {
        throw new codes.ERR_INTERNAL_ASSERTION(message2);
      }
    }
    function addNumericalSeparator(val2) {
      let res = "";
      let i3 = val2.length;
      const start = val2[0] === "-" ? 1 : 0;
      for (; i3 >= start + 4; i3 -= 3) {
        res = `_${val2.slice(i3 - 3, i3)}${res}`;
      }
      return `${val2.slice(0, i3)}${res}`;
    }
    function getMessage(key, msg, args) {
      if (typeof msg === "function") {
        assert(
          msg.length <= args.length,
          // Default options do not count.
          `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${msg.length}).`
        );
        return msg(...args);
      }
      const expectedLength = (msg.match(/%[dfijoOs]/g) || []).length;
      assert(
        expectedLength === args.length,
        `Code: ${key}; The provided arguments length (${args.length}) does not match the required ones (${expectedLength}).`
      );
      if (args.length === 0) {
        return msg;
      }
      return format26(msg, ...args);
    }
    function E2(code, message2, Base) {
      if (!Base) {
        Base = Error;
      }
      class NodeError extends Base {
        constructor(...args) {
          super(getMessage(code, message2, args));
        }
        toString() {
          return `${this.name} [${code}]: ${this.message}`;
        }
      }
      Object.defineProperties(NodeError.prototype, {
        name: {
          value: Base.name,
          writable: true,
          enumerable: false,
          configurable: true
        },
        toString: {
          value() {
            return `${this.name} [${code}]: ${this.message}`;
          },
          writable: true,
          enumerable: false,
          configurable: true
        }
      });
      NodeError.prototype.code = code;
      NodeError.prototype[kIsNodeError] = true;
      codes[code] = NodeError;
    }
    function hideStackFrames(fn) {
      const hidden = nodeInternalPrefix + fn.name;
      Object.defineProperty(fn, "name", {
        value: hidden
      });
      return fn;
    }
    function aggregateTwoErrors(innerError, outerError) {
      if (innerError && outerError && innerError !== outerError) {
        if (Array.isArray(outerError.errors)) {
          outerError.errors.push(innerError);
          return outerError;
        }
        const err = new AggregateError([outerError, innerError], outerError.message);
        err.code = outerError.code;
        return err;
      }
      return innerError || outerError;
    }
    var AbortError = class extends Error {
      constructor(message2 = "The operation was aborted", options = void 0) {
        if (options !== void 0 && typeof options !== "object") {
          throw new codes.ERR_INVALID_ARG_TYPE("options", "Object", options);
        }
        super(message2, options);
        this.code = "ABORT_ERR";
        this.name = "AbortError";
      }
    };
    E2("ERR_ASSERTION", "%s", Error);
    E2(
      "ERR_INVALID_ARG_TYPE",
      (name, expected, actual) => {
        assert(typeof name === "string", "'name' must be a string");
        if (!Array.isArray(expected)) {
          expected = [expected];
        }
        let msg = "The ";
        if (name.endsWith(" argument")) {
          msg += `${name} `;
        } else {
          msg += `"${name}" ${name.includes(".") ? "property" : "argument"} `;
        }
        msg += "must be ";
        const types5 = [];
        const instances = [];
        const other = [];
        for (const value of expected) {
          assert(typeof value === "string", "All expected entries have to be of type string");
          if (kTypes.includes(value)) {
            types5.push(value.toLowerCase());
          } else if (classRegExp.test(value)) {
            instances.push(value);
          } else {
            assert(value !== "object", 'The value "object" should be written as "Object"');
            other.push(value);
          }
        }
        if (instances.length > 0) {
          const pos = types5.indexOf("object");
          if (pos !== -1) {
            types5.splice(types5, pos, 1);
            instances.push("Object");
          }
        }
        if (types5.length > 0) {
          switch (types5.length) {
            case 1:
              msg += `of type ${types5[0]}`;
              break;
            case 2:
              msg += `one of type ${types5[0]} or ${types5[1]}`;
              break;
            default: {
              const last = types5.pop();
              msg += `one of type ${types5.join(", ")}, or ${last}`;
            }
          }
          if (instances.length > 0 || other.length > 0) {
            msg += " or ";
          }
        }
        if (instances.length > 0) {
          switch (instances.length) {
            case 1:
              msg += `an instance of ${instances[0]}`;
              break;
            case 2:
              msg += `an instance of ${instances[0]} or ${instances[1]}`;
              break;
            default: {
              const last = instances.pop();
              msg += `an instance of ${instances.join(", ")}, or ${last}`;
            }
          }
          if (other.length > 0) {
            msg += " or ";
          }
        }
        switch (other.length) {
          case 0:
            break;
          case 1:
            if (other[0].toLowerCase() !== other[0]) {
              msg += "an ";
            }
            msg += `${other[0]}`;
            break;
          case 2:
            msg += `one of ${other[0]} or ${other[1]}`;
            break;
          default: {
            const last = other.pop();
            msg += `one of ${other.join(", ")}, or ${last}`;
          }
        }
        if (actual == null) {
          msg += `. Received ${actual}`;
        } else if (typeof actual === "function" && actual.name) {
          msg += `. Received function ${actual.name}`;
        } else if (typeof actual === "object") {
          var _actual$constructor;
          if ((_actual$constructor = actual.constructor) !== null && _actual$constructor !== void 0 && _actual$constructor.name) {
            msg += `. Received an instance of ${actual.constructor.name}`;
          } else {
            const inspected = inspect4(actual, {
              depth: -1
            });
            msg += `. Received ${inspected}`;
          }
        } else {
          let inspected = inspect4(actual, {
            colors: false
          });
          if (inspected.length > 25) {
            inspected = `${inspected.slice(0, 25)}...`;
          }
          msg += `. Received type ${typeof actual} (${inspected})`;
        }
        return msg;
      },
      TypeError
    );
    E2(
      "ERR_INVALID_ARG_VALUE",
      (name, value, reason = "is invalid") => {
        let inspected = inspect4(value);
        if (inspected.length > 128) {
          inspected = inspected.slice(0, 128) + "...";
        }
        const type = name.includes(".") ? "property" : "argument";
        return `The ${type} '${name}' ${reason}. Received ${inspected}`;
      },
      TypeError
    );
    E2(
      "ERR_INVALID_RETURN_VALUE",
      (input