"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listStacks = listStacks;
const cxapp_1 = require("../cxapp");
/**
 * List Stacks
 *
 * @param toolkit cdk toolkit
 * @param options list stacks options
 * @returns StackDetails[]
 */
async function listStacks(toolkit, options) {
    const assembly = await toolkit.assembly();
    const stacks = await assembly.selectStacks({
        patterns: options.selectors,
    }, {
        extend: cxapp_1.ExtendedStackSelection.Upstream,
        defaultBehavior: cxapp_1.DefaultSelection.AllStacks,
    });
    return stacks.withDependencies();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdC1zdGFja3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0LXN0YWNrcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQXVCQSxnQ0FXQztBQWhDRCxvQ0FBb0U7QUFjcEU7Ozs7OztHQU1HO0FBQ0ksS0FBSyxVQUFVLFVBQVUsQ0FBQyxPQUFtQixFQUFFLE9BQTBCO0lBQzlFLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBRTFDLE1BQU0sTUFBTSxHQUFHLE1BQU0sUUFBUSxDQUFDLFlBQVksQ0FBQztRQUN6QyxRQUFRLEVBQUUsT0FBTyxDQUFDLFNBQVM7S0FDNUIsRUFBRTtRQUNELE1BQU0sRUFBRSw4QkFBc0IsQ0FBQyxRQUFRO1FBQ3ZDLGVBQWUsRUFBRSx3QkFBZ0IsQ0FBQyxTQUFTO0tBQzVDLENBQUMsQ0FBQztJQUVILE9BQU8sTUFBTSxDQUFDLGdCQUFnQixFQUFFLENBQUM7QUFDbkMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB0eXBlIHsgU3RhY2tEZXRhaWxzIH0gZnJvbSAnQGF3cy1jZGsvdG9vbGtpdC1saWInO1xuaW1wb3J0IHR5cGUgeyBDZGtUb29sa2l0IH0gZnJvbSAnLi4vY2xpL2Nkay10b29sa2l0JztcbmltcG9ydCB7IERlZmF1bHRTZWxlY3Rpb24sIEV4dGVuZGVkU3RhY2tTZWxlY3Rpb24gfSBmcm9tICcuLi9jeGFwcCc7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgTGlzdCBTdGFja3NcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMaXN0U3RhY2tzT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBTdGFja3MgdG8gbGlzdFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEFsbCBzdGFja3MgYXJlIGxpc3RlZFxuICAgKi9cbiAgcmVhZG9ubHkgc2VsZWN0b3JzOiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBMaXN0IFN0YWNrc1xuICpcbiAqIEBwYXJhbSB0b29sa2l0IGNkayB0b29sa2l0XG4gKiBAcGFyYW0gb3B0aW9ucyBsaXN0IHN0YWNrcyBvcHRpb25zXG4gKiBAcmV0dXJucyBTdGFja0RldGFpbHNbXVxuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gbGlzdFN0YWNrcyh0b29sa2l0OiBDZGtUb29sa2l0LCBvcHRpb25zOiBMaXN0U3RhY2tzT3B0aW9ucyk6IFByb21pc2U8U3RhY2tEZXRhaWxzW10+IHtcbiAgY29uc3QgYXNzZW1ibHkgPSBhd2FpdCB0b29sa2l0LmFzc2VtYmx5KCk7XG5cbiAgY29uc3Qgc3RhY2tzID0gYXdhaXQgYXNzZW1ibHkuc2VsZWN0U3RhY2tzKHtcbiAgICBwYXR0ZXJuczogb3B0aW9ucy5zZWxlY3RvcnMsXG4gIH0sIHtcbiAgICBleHRlbmQ6IEV4dGVuZGVkU3RhY2tTZWxlY3Rpb24uVXBzdHJlYW0sXG4gICAgZGVmYXVsdEJlaGF2aW9yOiBEZWZhdWx0U2VsZWN0aW9uLkFsbFN0YWNrcyxcbiAgfSk7XG5cbiAgcmV0dXJuIHN0YWNrcy53aXRoRGVwZW5kZW5jaWVzKCk7XG59XG4iXX0=