"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosStackArtifact = void 0;
const cxschema = require("@alicloud/ros-cdk-assembly-schema");
const fs = require("fs");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
class RosStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        var _a;
        super(assembly, artifactId, artifact);
        const properties = (this.manifest.properties ||
            {});
        if (!properties.templateFile) {
            throw new Error('Invalid ROS stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters || {};
        this.stackName = properties.stackName || artifactId;
        this.displayName =
            this.stackName === artifactId
                ? this.stackName
                : `${artifactId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
        this.tags = (_a = properties.tags) !== null && _a !== void 0 ? _a : this.tagsFromMetadata();
    }
    /**
     * The ROS template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(path.join(this.assembly.directory, this.templateFile), "utf-8"));
        }
        return this._template;
    }
    tagsFromMetadata() {
        var _a;
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of ((_a = metadataEntry.data) !== null && _a !== void 0 ? _a : [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.RosStackArtifact = RosStackArtifact;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9zLXN0YWNrLWFydGlmYWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicm9zLXN0YWNrLWFydGlmYWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhEQUE4RDtBQUM5RCx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLHNEQUFrRDtBQUdsRCxNQUFhLGdCQUFpQixTQUFRLDhCQUFhO0lBc0NqRCxZQUNJLFFBQXVCLEVBQ3ZCLFVBQWtCLEVBQ2xCLFFBQW1DOztRQUVyQyxLQUFLLENBQUMsUUFBUSxFQUFFLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUV0QyxNQUFNLFVBQVUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVTtZQUN4QyxFQUFFLENBQXNDLENBQUM7UUFDN0MsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUU7WUFDNUIsTUFBTSxJQUFJLEtBQUssQ0FDWCx3RkFBd0YsQ0FDM0YsQ0FBQztTQUNIO1FBRUQsSUFBSSxDQUFDLFlBQVksR0FBRyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzVDLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7UUFDOUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxVQUFVLENBQUMsU0FBUyxJQUFJLFVBQVUsQ0FBQztRQUNwRCxJQUFJLENBQUMsV0FBVztZQUNaLElBQUksQ0FBQyxTQUFTLEtBQUssVUFBVTtnQkFDekIsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTO2dCQUNoQixDQUFDLENBQUMsR0FBRyxVQUFVLEtBQUssSUFBSSxDQUFDLFNBQVMsR0FBRyxDQUFDO1FBQzlDLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLG1CQUFtQjtRQUMvQyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDbkMsSUFBSSxDQUFDLElBQUksU0FBRyxVQUFVLENBQUMsSUFBSSxtQ0FBSSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztJQUN6RCxDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLFFBQVE7UUFDakIsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQ3ZCLEVBQUUsQ0FBQyxZQUFZLENBQ1gsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLEVBQ3JELE9BQU8sQ0FDVixDQUNKLENBQUM7U0FDSDtRQUNELE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBRU8sZ0JBQWdCOztRQUN0QixNQUFNLEdBQUcsR0FBMkIsRUFBRSxDQUFDO1FBQ3ZDLEtBQUssTUFBTSxhQUFhLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyx5QkFBeUIsQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUNsRyxLQUFLLE1BQU0sR0FBRyxJQUFJLE9BQUMsYUFBYSxDQUFDLElBQUksbUNBQUksRUFBRSxDQUFvQyxFQUFFO2dCQUMvRSxHQUFHLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUM7YUFDMUI7U0FDRjtRQUNELE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztDQUNGO0FBekZELDRDQXlGQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGN4c2NoZW1hIGZyb20gXCJAYWxpY2xvdWQvcm9zLWNkay1hc3NlbWJseS1zY2hlbWFcIjtcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmc1wiO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgQ2xvdWRBcnRpZmFjdCB9IGZyb20gXCIuLi9jbG91ZC1hcnRpZmFjdFwiO1xuaW1wb3J0IHsgQ2xvdWRBc3NlbWJseSB9IGZyb20gXCIuLi9jbG91ZC1hc3NlbWJseVwiO1xuXG5leHBvcnQgY2xhc3MgUm9zU3RhY2tBcnRpZmFjdCBleHRlbmRzIENsb3VkQXJ0aWZhY3Qge1xuICAvKipcbiAgICogVGhlIGZpbGUgbmFtZSBvZiB0aGUgdGVtcGxhdGUuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdGVtcGxhdGVGaWxlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBvcmlnaW5hbCBuYW1lIGFzIGRlZmluZWQgaW4gdGhlIENESyBhcHAuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgb3JpZ2luYWxOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJPUyBwYXJhbWV0ZXJzIHRvIHBhc3MgdG8gdGhlIHN0YWNrLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHBhcmFtZXRlcnM6IHsgW2lkOiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogVGhlIHBoeXNpY2FsIG5hbWUgb2YgdGhpcyBzdGFjay5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzdGFja05hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogQSBzdHJpbmcgdGhhdCByZXByZXNlbnRzIHRoaXMgc3RhY2suIFNob3VsZCBvbmx5IGJlIHVzZWQgaW4gdXNlciBpbnRlcmZhY2VzLlxuICAgKiBJZiB0aGUgc3RhY2tOYW1lIGFuZCBhcnRpZmFjdElkIGFyZSB0aGUgc2FtZSwgaXQgd2lsbCBqdXN0IHJldHVybiB0aGF0LiBPdGhlcndpc2UsXG4gICAqIGl0IHdpbGwgcmV0dXJuIHNvbWV0aGluZyBsaWtlIFwiPGFydGlmYWN0SWQ+ICg8c3RhY2tOYW1lPilcIlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRpc3BsYXlOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwaHlzaWNhbCBuYW1lIG9mIHRoaXMgc3RhY2suXG4gICAqIEBkZXByZWNhdGVkIHJlbmFtZWQgdG8gYHN0YWNrTmFtZWBcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IHRhZ3M6IGFueTtcblxuICBwcml2YXRlIF90ZW1wbGF0ZTogYW55IHwgdW5kZWZpbmVkO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgICAgYXNzZW1ibHk6IENsb3VkQXNzZW1ibHksXG4gICAgICBhcnRpZmFjdElkOiBzdHJpbmcsXG4gICAgICBhcnRpZmFjdDogY3hzY2hlbWEuQXJ0aWZhY3RNYW5pZmVzdFxuICApIHtcbiAgICBzdXBlcihhc3NlbWJseSwgYXJ0aWZhY3RJZCwgYXJ0aWZhY3QpO1xuXG4gICAgY29uc3QgcHJvcGVydGllcyA9ICh0aGlzLm1hbmlmZXN0LnByb3BlcnRpZXMgfHxcbiAgICAgICAge30pIGFzIGN4c2NoZW1hLkFsaXl1blJvc1N0YWNrUHJvcGVydGllcztcbiAgICBpZiAoIXByb3BlcnRpZXMudGVtcGxhdGVGaWxlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICAgJ0ludmFsaWQgUk9TIHN0YWNrIGFydGlmYWN0LiBNaXNzaW5nIFwidGVtcGxhdGVGaWxlXCIgcHJvcGVydHkgaW4gY2xvdWQgYXNzZW1ibHkgbWFuaWZlc3QnXG4gICAgICApO1xuICAgIH1cblxuICAgIHRoaXMudGVtcGxhdGVGaWxlID0gcHJvcGVydGllcy50ZW1wbGF0ZUZpbGU7XG4gICAgdGhpcy5wYXJhbWV0ZXJzID0gcHJvcGVydGllcy5wYXJhbWV0ZXJzIHx8IHt9O1xuICAgIHRoaXMuc3RhY2tOYW1lID0gcHJvcGVydGllcy5zdGFja05hbWUgfHwgYXJ0aWZhY3RJZDtcbiAgICB0aGlzLmRpc3BsYXlOYW1lID1cbiAgICAgICAgdGhpcy5zdGFja05hbWUgPT09IGFydGlmYWN0SWRcbiAgICAgICAgICAgID8gdGhpcy5zdGFja05hbWVcbiAgICAgICAgICAgIDogYCR7YXJ0aWZhY3RJZH0gKCR7dGhpcy5zdGFja05hbWV9KWA7XG4gICAgdGhpcy5uYW1lID0gdGhpcy5zdGFja05hbWU7IC8vIGJhY2t3YXJkcyBjb21wYXRcbiAgICB0aGlzLm9yaWdpbmFsTmFtZSA9IHRoaXMuc3RhY2tOYW1lO1xuICAgIHRoaXMudGFncyA9IHByb3BlcnRpZXMudGFncyA/PyB0aGlzLnRhZ3NGcm9tTWV0YWRhdGEoKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgUk9TIHRlbXBsYXRlIGZvciB0aGlzIHN0YWNrLlxuICAgKi9cbiAgcHVibGljIGdldCB0ZW1wbGF0ZSgpOiBhbnkge1xuICAgIGlmICh0aGlzLl90ZW1wbGF0ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLl90ZW1wbGF0ZSA9IEpTT04ucGFyc2UoXG4gICAgICAgICAgZnMucmVhZEZpbGVTeW5jKFxuICAgICAgICAgICAgICBwYXRoLmpvaW4odGhpcy5hc3NlbWJseS5kaXJlY3RvcnksIHRoaXMudGVtcGxhdGVGaWxlKSxcbiAgICAgICAgICAgICAgXCJ1dGYtOFwiXG4gICAgICAgICAgKVxuICAgICAgKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuX3RlbXBsYXRlO1xuICB9XG5cbiAgcHJpdmF0ZSB0YWdzRnJvbU1ldGFkYXRhKCkge1xuICAgIGNvbnN0IHJldDogUmVjb3JkPHN0cmluZywgc3RyaW5nPiA9IHt9O1xuICAgIGZvciAoY29uc3QgbWV0YWRhdGFFbnRyeSBvZiB0aGlzLmZpbmRNZXRhZGF0YUJ5VHlwZShjeHNjaGVtYS5BcnRpZmFjdE1ldGFkYXRhRW50cnlUeXBlLlNUQUNLX1RBR1MpKSB7XG4gICAgICBmb3IgKGNvbnN0IHRhZyBvZiAobWV0YWRhdGFFbnRyeS5kYXRhID8/IFtdKSBhcyBjeHNjaGVtYS5TdGFja1RhZ3NNZXRhZGF0YUVudHJ5KSB7XG4gICAgICAgIHJldFt0YWcua2V5XSA9IHRhZy52YWx1ZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHJldDtcbiAgfVxufVxuIl19