"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteAliasRecord = void 0;
const crypto = require("crypto");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
class WebsiteAliasRecord extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { domainName, recordNames, target, privateZone, vpcId } = props;
        const zone = aws_route53_1.HostedZone.fromLookup(this, 'Zone', {
            domainName,
            privateZone,
            vpcId,
        });
        recordNames.forEach((recordName) => {
            const hash = crypto.createHash('md5').update(recordName).digest('hex').substr(0, 6);
            new aws_route53_1.ARecord(this, `WebsiteAliasRecord${hash}`, {
                zone,
                recordName: `${recordName}.`,
                target: aws_route53_1.RecordTarget.fromAlias(target),
            });
            if (!props.disableIPv6) {
                new aws_route53_1.AaaaRecord(this, `WebsiteIPv6AliasRecord${hash}`, {
                    zone,
                    recordName: `${recordName}.`,
                    target: aws_route53_1.RecordTarget.fromAlias(target),
                });
            }
        });
    }
}
exports.WebsiteAliasRecord = WebsiteAliasRecord;
//# sourceMappingURL=data:application/json;base64,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