"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate header matching methods.
 */
class HeaderMatch {
    /**
     * The value of the header with the given name in the request must match the
     * specified value exactly.
     *
     * @param headerName the name of the header to match against
     * @param headerValue The exact value to test against
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must not match
     * the specified value exactly.
     *
     * @param headerName the name of the header to match against
     * @param headerValue The exact value to test against
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must start with
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param prefix The prefix to test against
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * The value of the header with the given name in the request must not start
     * with the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param prefix The prefix to test against
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * The value of the header with the given name in the request must end with
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param suffix The suffix to test against
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * The value of the header with the given name in the request must not end
     * with the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param suffix The suffix to test against
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * The value of the header with the given name in the request must include
     * the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param regex The regex to test against
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * The value of the header with the given name in the request must not
     * include the specified characters.
     *
     * @param headerName the name of the header to match against
     * @param regex The regex to test against
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * The value of the header with the given name in the request must be in a
     * range of values.
     *
     * @param headerName the name of the header to match against
     * @param start Match on values starting at and including this value
     * @param end Match on values up to but not including this value
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * The value of the header with the given name in the request must not be in
     * a range of values.
     *
     * @param headerName the name of the header to match against
     * @param start Match on values starting at and including this value
     * @param end Match on values up to but not including this value
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
exports.HeaderMatch = HeaderMatch;
_a = JSII_RTTI_SYMBOL_1;
HeaderMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.HeaderMatch", version: "1.194.0" };
class HeaderMatchImpl extends HeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            headerMatch: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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