# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyiqvia']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.0', 'backoff>=1.11.1']

setup_kwargs = {
    'name': 'pyiqvia',
    'version': '2022.4.0',
    'description': 'A clean, async-focused Python3 API for IQVIA data',
    'long_description': '# 🌻 pyiqvia: A clean, async-focused Python3 API for IQVIA™\n\n[![CI](https://github.com/bachya/pyiqvia/workflows/CI/badge.svg)](https://github.com/bachya/pyiqvia/actions)\n[![PyPi](https://img.shields.io/pypi/v/pyiqvia.svg)](https://pypi.python.org/pypi/pyiqvia)\n[![Version](https://img.shields.io/pypi/pyversions/pyiqvia.svg)](https://pypi.python.org/pypi/pyiqvia)\n[![License](https://img.shields.io/pypi/l/pyiqvia.svg)](https://github.com/bachya/pyiqvia/blob/master/LICENSE)\n[![Code Coverage](https://codecov.io/gh/bachya/pyiqvia/branch/dev/graph/badge.svg)](https://codecov.io/gh/bachya/pyiqvia)\n[![Maintainability](https://api.codeclimate.com/v1/badges/3bf37f9cabf73b5d991e/maintainability)](https://codeclimate.com/github/bachya/pyiqvia/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`pyiqvia` is an async-focused Python3 library for allergen, asthma, and disease\ndata from the [IQVIA™](https://www.iqvia.com) family of websites (such as \nhttps://pollen.com, https://flustar.com, and more).\n\n- [Python Versions](#python-versions)\n- [Installation](#installation)\n- [Usage](#usage)\n- [Contributing](#contributing)\n\n# Python Versions\n\n`pyiqvia` is currently supported on:\n\n* Python 3.8\n* Python 3.9\n* Python 3.10\n\n# Installation\n\n```python\npip install pyiqvia\n```\n\n# Usage\n\n```python\nimport asyncio\n\nfrom aiohttp import ClientSession\n\nfrom pyiqvia import Client\n\n\nasync def main() -> None:\n    """Run!"""\n    # Note that ZIP codes must be provided as strings:\n    client = Client("80012")\n\n    # Get current allergen information:\n    await client.allergens.current()\n\n    # Get more information on the current allergen outlook:\n    await client.allergens.outlook()\n\n    # Get extended forecast allergen information:\n    await client.allergens.extended()\n\n    # Get historic allergen information:\n    await client.allergens.historic()\n\n    # Get current asthma information:\n    await client.asthma.current()\n\n    # Get extended forecast asthma information:\n    await client.asthma.extended()\n\n    # Get historic asthma information:\n    await client.asthma.historic()\n\n    # Get current cold and flu information:\n    await client.disease.current()\n\n    # Get extended forecast cold and flu information:\n    await client.disease.extended()\n\n    # Get historic cold and flu information:\n    await client.disease.historic()\n\n\nasyncio.run(main())\n```\n\n## Retries\n\nBy default, `pyiqvia` will retry appropriate errors 4 times (with an exponentially\nincreasing delay in-between). This logic can be changed by passing a different value for\n`request_retries` to the `Client` constructor:\n\n```python\nimport asyncio\n\nfrom pyiqvia import Client\n\n\nasync def main():\n    client = Client("80012", request_retries=5)\n\n    # ...\n\n\nasyncio.run(main())\n```\n\n## Connection Pooling\n\nBy default, the library creates a new connection to IQVIA with each coroutine. If you\nare calling a large number of coroutines (or merely want to squeeze out every second of\nruntime savings possible), an\n[`aiohttp`](https://github.com/aio-libs/aiohttp) `ClientSession` can be used for connection\npooling:\n\n```python\nimport asyncio\n\nfrom aiohttp import ClientSession\n\nfrom pyiqvia import Client\n\n\nasync def main() -> None:\n    """Run!"""\n    async with ClientSession() as session:\n        client = Client("80012", session=session)\n\n        # ...\n\n\nasyncio.run(main())\n```\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/pyiqvia/issues)\n  or [initiate a discussion on one](https://github.com/bachya/pyiqvia/issues/new).\n2. [Fork the repository](https://github.com/bachya/pyiqvia/fork).\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./.venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix.\n7. Write tests that cover your new functionality.\n8. Run tests and ensure 100% code coverage: `script/test`\n9. Update `README.md` with any new documentation.\n10. Add yourself to `AUTHORS.md`.\n11. Submit a pull request!\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bachya/pyiqvia',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
