from .views import (AdminDashboardView,AdminPageView,
                    AdminTemplateView,AdminBlockView,
                    AdminCMSListView,AdminListPageView,
                    AdminDetailView,AdminEditView,
                    PageListView,AdminBlogView,AdminAddCategoryView,
                    AdminAddBlogView)
from . import admin

routes = [
        ((admin),
            ('','index',AdminDashboardView),
            ('/settings','settings',AdminDashboardView),
            ('/add/category','add_category',AdminAddCategoryView),
            ('/add/page','add_page',AdminPageView),
            ('/add/blog','add_blog',AdminAddBlogView),
            ('/edit/page/content','page_content',AdminPageView),
            ('/add/template','add_template',AdminTemplateView),
            ('/add/block','add_block',AdminBlockView),
            ('/edit/block/content','block_content',AdminBlockView),
            ('/list/blocks','blocks',AdminCMSListView),
            ('/list/pages','pages',AdminCMSListView),
            ('/list/users','users',AdminCMSListView),
            ('/list/templates','templates',AdminCMSListView),
            ('/paged/page/<int:page_num>','page_page',AdminListPageView),
            ('/paged/user/<int:page_num>','page_users',AdminListPageView),
            ('/paged/template/<int:page_num>','page_template',AdminListPageView),
            ('/paged/block/<int:page_num>','page_block',AdminListPageView),
            ('/view/block/<name>','block_view',AdminDetailView),
            ('/view/page/<slug>','page_view',AdminDetailView),
            ('/view/template/<name>','template_view',AdminDetailView),
            ('/edit/block/<item_id>','edit_block',AdminEditView),
            ('/edit/page/<item_id>','edit_page',AdminEditView),
            ('/edit/template/<item_id>','edit_template',AdminEditView),
            ('/edit/page/content/<item_id>','edit_page_content',AdminEditView),
            ('/edit/block/content/<item_id>','edit_block_content',AdminEditView),
            ('/pages','page_list',PageListView),
            ('/blogs','blogs',AdminBlogView),
        )
    ]
