# ignorem

ignorem - The best git*ignore* *m*anager yet!

# About

ignorem makes interacting with your `.gitignore` file just like using a package manager. You can "install" [pre-made gitignores](https://github.com/github/gitignore) into your file, remove them, and update them with ease! ignorem also supports user-modified gitignores, so your manual gitignore entries will be saved.

# Installation

`pip install ignorem`

# Usage

`ignorem (command) [gitignore...]`

Run `ignorem` from the command line, in the directory that contains the `.gitignore` file. ignorem requires one additional command:

| Command | Description | Additional arguments |
| --- | --- | --- |
| help | Shows info/help text. | |
| list | Lists gitignores installed in `.gitignore`. | |
| query | Lists all available pre-made gitignores. | |
| add | Add the specified pre-made gitignore(s) to `.gitignore`. | Gitignore(s) to add |
| remove | Remove the specified pre-made gitignore(s) from `.gitignore`. | Gitignore(s) to remove |
| update | Update all pre-made gitignores installed to `.gitignore`. | |
| repo-list | Lists all enabled repositories. | |
| repo-add | Adds the specified repository. | Repository URL |
| repo-del | Removes the specified repository. Cannot remove default repository. | Repository URL |

## Examples

Create a new gitignore for python  
`ignorem add python`

Add android and vim to the gitignore  
`ignorem add android vim`

Remove vim from the gitignore  
`ignorem remove vim`

## Manual ignores

ignorem will save the entries you add manually to the `.gitignore` file. Simply place those entries outside of the `# (BEGIN/END) ignorem auto-gen` tags.

An empty gitignore is below to demonstrate this:  
```
# BEGIN ignorem auto-gen
# This gitingore was generated by ignorem version 1.0
# https://github.com/itsmaxymoo/ignorem
# DO NOT EDIT ANY TEXT INSIDE THE ignorem auto-gen tags!
# It will be overwritten next time ignorem is ran.
# Following this header are the loose ignores, or ignores added externally.
# After that, there are the ignores generated by ignorem.
# END ignorem auto-gen

(Place your manual entries here)

# BEGIN ignorem auto-gen
# Beginning of ignorem generated ignores.
# ignorem installed gitignores: 

(will contain pre-made gitignores)

# END ignorem auto-gen
```

## Repositories

A repository is a file on a web server with instructions for downloading gitignores.
A repository must be encoded as UTF-8, and follow the format:

```
<id> <url>
...
```

Where *id* is the name of the gitignore to be used in ignorem, and
*url* is the url to the raw gitignore file.

For example:
```
c++ https://raw.githubusercontent.com/github/gitignore/master/C++.gitignore
...
```

For a real example, see the [default repository](SOURCES).
