# -*- coding: utf-8 -*-

import re

TONES = ('', '\\', '/', '?', '~', '.')

TONE_NAMES = ('?', 'GRAVE', 'ACUTE', 'HOOK ABOVE', 'TILDE', 'DOT BELOW')

CHAR_ORDER_DICT = {'0': 0, '1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9, 'a': 10,'A': 11, 'à': 12, 'À': 13, 'á': 14, 'Á': 15,'ả': 16, 'Ả': 17, 'ã': 18, 'Ã': 19, 'ạ': 20,'Ạ': 21, 'ă': 22, 'Ă': 23, 'ằ': 24, 'Ằ': 25,'ắ': 26, 'Ắ': 27, 'ẳ': 28, 'Ẳ': 29, 'ẵ': 30,'Ẵ': 31, 'ặ': 32, 'Ặ': 33, 'â': 34, 'Â': 35,'ầ': 36, 'Ầ': 37, 'ẩ': 38, 'Ẩ': 39, 'ẫ': 40,'Ẫ': 41, 'ấ': 42, 'Ấ': 43, 'ậ': 44, 'Ậ': 45,'b': 46, 'B': 47, 'c': 48, 'C': 49, 'd': 50,'D': 51, 'đ': 52, 'Đ': 53, 'e': 54, 'E': 55,'è': 56, 'È': 57, 'é': 58, 'É': 59, 'ẻ': 60,'Ẻ': 61, 'ẽ': 62, 'Ẽ': 63, 'ẹ': 64, 'Ẹ': 65,'ê': 66, 'Ê': 67, 'ề': 68, 'Ề': 69, 'ế': 70,'Ế': 71, 'ể': 72, 'Ể': 73, 'ễ': 74, 'Ễ': 75,'ệ': 76, 'Ệ': 77, 'f': 78, 'F': 79, 'g': 80,'G': 81, 'h': 82, 'H': 83, 'i': 84, 'I': 85,'ì': 86, 'Ì': 87, 'í': 88, 'Í': 89, 'ỉ': 90,'Ỉ': 91, 'ĩ': 92, 'Ĩ': 93, 'ị': 94, 'Ị': 95,'j': 96, 'J': 97, 'k': 98, 'K': 99, 'l': 100, 'L': 101, 'm': 102, 'M': 103, 'n': 104, 'N': 105, 'o': 106, 'O': 107, 'ò': 108, 'Ò': 109, 'ó': 110, 'Ó': 111, 'ỏ': 112, 'Ỏ': 113, 'õ': 114, 'Õ': 115, 'ọ': 116, 'Ọ': 117, 'ô': 118, 'Ô': 119, 'ồ': 120, 'Ồ': 121, 'ố': 122, 'Ố': 123, 'ổ': 124, 'Ổ': 125, 'ỗ': 126, 'Ỗ': 127, 'ộ': 128, 'Ộ': 129, 'ơ': 130, 'Ơ': 131, 'ờ': 132, 'Ờ': 133, 'ớ': 134, 'Ớ': 135, 'ở': 136, 'Ở': 137, 'ỡ': 138, 'Ỡ': 139, 'ợ': 140, 'Ợ': 141, 'p': 142, 'P': 143, 'q': 144, 'Q': 145, 'r': 146, 'R': 147, 's': 148, 'S': 149, 't': 150, 'T': 151, 'u': 152, 'U': 153, 'ù': 154, 'Ù': 155, 'ú': 156, 'Ú': 157, 'ủ': 158, 'Ủ': 159, 'ũ': 160, 'Ũ': 161, 'ụ': 162, 'Ụ': 163, 'ư': 164, 'Ư': 165, 'ừ': 166, 'Ừ': 167, 'ứ': 168, 'Ứ': 169, 'ử': 170, 'Ử': 171, 'ữ': 172, 'Ữ': 173, 'ự': 174, 'Ự': 175, 'v': 176, 'V': 177, 'w': 178, 'W': 179, 'x': 180, 'X': 181, 'y': 182, 'Y': 183, 'ỳ': 184, 'Ỳ': 185, 'ý': 186, 'Ý': 187, 'ỷ': 188, 'Ỷ': 189, 'ỹ': 190, 'Ỹ': 191, 'ỵ': 192, 'Ỵ': 193, 'z': 194, 'Z': 195}

CHAR_ORDER_STRING = r"0123456789aAàÀáÁảẢãÃạẠăĂằẰắẮẳẲẵẴặẶâÂầẦẩẨẫẪấẤậẬbBcCdDđĐeEèÈéÉẻẺẽẼẹẸêÊềỀếẾểỂễỄệỆfFgGhHiIìÌíÍỉỈĩĨịỊjJkKlLmMnNoOòÒóÓỏỎõÕọỌôÔồỒốỐổỔỗỖộỘơƠờỜớỚởỞỡỠợỢpPqQrRsStTuUùÙúÚủỦũŨụỤưƯừỪứỨửỬữỮựỰvVwWxXyYỳỲýÝỷỶỹỸỵỴzZ"

VIETNAMESE_CHARSET_REGEX = re.compile(r"[a-z àáảãạăằắẳẵặâầấẩẫậèéẻẽẹêềếểễệđìíỉĩịòóỏõọôồốổỗộơờớởỡợùúủũụưừứửữựỳýỷỹỵ]+", re.IGNORECASE)

NO_TONE_CHAR_TRANS = str.maketrans("àáảãạằắẳẵặầấẩẫậèéẻẽẹềếểễệìíỉĩịòóỏõọồốổỗộờớởỡợùúủũụừứửữựỳýỷỹỵÀÁẢÃẠẰẮẲẴẶẦẤẨẪẬÈÉẺẼẸỀẾỂỄỆÌÍỈĨỊÒÓỎÕỌỒỐỔỖỘỜỚỞỠỢÙÚỦŨỤỪỨỬỮỰỲÝỶỸỴ",
                                   "aaaaaăăăăăâââââeeeeeêêêêêiiiiioooooôôôôôơơơơơuuuuuưưưưưyyyyyAAAAAĂĂĂĂĂÂÂÂÂÂEEEEEÊÊÊÊÊIIIIIOOOOOÔÔÔÔÔƠƠƠƠƠUUUUUƯƯƯƯƯYYYYY")
