import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * Properties to use to customize an S3 Origin.
 *
 * @stability stable
 */
export interface S3OriginProps extends cloudfront.OriginProps {
    /**
     * An optional Origin Access Identity of the origin identity cloudfront will use when calling your s3 bucket.
     *
     * @default - An Origin Access Identity will be created.
     * @stability stable
     */
    readonly originAccessIdentity?: cloudfront.IOriginAccessIdentity;
}
/**
 * An Origin that is backed by an S3 bucket.
 *
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling. Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 *
 * @stability stable
 */
export declare class S3Origin implements cloudfront.IOrigin {
    private readonly origin;
    /**
     * @stability stable
     */
    constructor(bucket: s3.IBucket, props?: S3OriginProps);
    /**
     * The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @stability stable
     */
    bind(scope: Construct, options: cloudfront.OriginBindOptions): cloudfront.OriginBindConfig;
}
