# Generated by Django 3.0.10 on 2020-10-19 17:08

import customers.models
from django.db import migrations, models
import django.db.models.deletion
import exchange.models
import invoices.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('products', '0001_initial'),
        ('customers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Arrival',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('discount', models.PositiveIntegerField(default=0, verbose_name='Discount, %')),
                ('type', invoices.models.InvoiceTypeField(choices=[(1, 'Income'), (2, 'Return'), (3, 'Custom')], verbose_name='Type')),
                ('customer', customers.models.CustomerField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='arrivals', to='customers.Customer', verbose_name='Customer')),
            ],
            options={
                'verbose_name': 'Arrival',
                'verbose_name_plural': 'Arrivals',
            },
        ),
        migrations.CreateModel(
            name='Sale',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('discount', models.PositiveIntegerField(default=0, verbose_name='Discount, %')),
                ('type', invoices.models.InvoiceTypeField(choices=[(1, 'Cash register'), (2, 'Write off'), (5, 'Debt'), (4, 'Custom')], verbose_name='Type')),
                ('customer', customers.models.CustomerField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='sales', to='customers.Customer', verbose_name='Customer')),
            ],
            options={
                'verbose_name': 'Sale',
                'verbose_name_plural': 'Sales',
            },
        ),
        migrations.CreateModel(
            name='SaleItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_wholesale', models.FloatField(default=0, verbose_name='Wholesale price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', exchange.models.CurrencyField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('qty', models.IntegerField(verbose_name='Quantity')),
                ('invoice', invoices.models.InvoiceField(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='invoices.Sale', verbose_name='Invoice')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='products.Product', verbose_name='Product')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArrivalItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_wholesale', models.FloatField(default=0, verbose_name='Wholesale price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', exchange.models.CurrencyField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('qty', models.IntegerField(verbose_name='Quantity')),
                ('invoice', invoices.models.InvoiceField(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='invoices.Arrival', verbose_name='Invoice')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='products.Product', verbose_name='Product')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
