#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'Click>=7.0',
    'nibabel',
    'numpy',
    'SimpleITK',
    'torch>=1.1',
    'tqdm',
]

setup_requirements = []

test_requirements = []

setup(
    author='Fernando Perez-Garcia',
    author_email='fernando.perezgarcia.17@ucl.ac.uk',
    python_requires='>=3.5',
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Intended Audience :: Science/Research',
        'Natural Language :: English',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
    description='PyTorch implementation of HighRes3DNet',
    entry_points={
        'console_scripts': [
            'deepgif=highresnet.cli.deepgif:main',
            'download_oasis=highresnet.cli.download_oasis:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    long_description_content_type='text/x-rst',
    include_package_data=True,
    keywords='highresnet',
    name='highresnet',
    packages=find_packages(include=['highresnet', 'highresnet.*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/fepegar/highresnet',
    version='0.10.2',
    zip_safe=False,
)
