import os
import os.path
import sys


u_home = os.path.expanduser("~")
home = os.path.join(u_home, '.tdlc')

HOME_PATH = os.environ.get("TDLC_HOME",  home)

LANGUAGE_SCALA = 'scala'
LANGUAGE_PYTHON = 'python'
LANGUAGE_R = 'r'


LANGUAGES_SUPPORTED = [LANGUAGE_SCALA, LANGUAGE_PYTHON]

CU_SIZE_SMALL = 'small'                 # 1C 4G
CU_SIZE_MEDIUM = 'medium'               # 2C 8G
CU_SIZE_LARGE = 'large'                 # 4C 16G
CU_SIZE_XLARGE = 'xlarge'               # 8C 32G
CU_SIZE_MEM_SMALL = 'm.small'
CU_SIZE_MEM_MEDIUM = 'm.medium'
CU_SIZE_MEM_LARGE = 'm.large'
CU_SIZE_MEM_XLARGE = 'm.xlarge'

CU_SIZE_SUPPORTED = [CU_SIZE_SMALL, CU_SIZE_MEDIUM, CU_SIZE_LARGE, CU_SIZE_XLARGE, CU_SIZE_MEM_SMALL, CU_SIZE_MEM_MEDIUM, CU_SIZE_MEM_LARGE, CU_SIZE_MEM_XLARGE]

# https://livy.apache.org/docs/latest/rest-api.html

SESSION_MODE_NATIVE = 'native'
SESSION_MODE_ATTACH = 'attach'

SESSION_KIND_SPARK = 'spark'
SESSION_KIND_PYSPARK = 'pyspark'
SESSION_KIND_SPARKR = 'sparkr'
SESSION_KIND_SQL = 'spark'

SESSION_KIND_SUPPORTED = [SESSION_KIND_SPARK, SESSION_KIND_PYSPARK, SESSION_KIND_SQL]

SESSION_STATUS_NOT_STARTED = 'not_started'
SESSION_STATUS_STARTING = 'starting'
SESSION_STATUS_IDLE = 'idle'
SESSION_STATUS_BUSY = 'busy'
SESSION_STATUS_SHUTTING_DOWN = 'shutting_down'
SESSION_STATUS_ERROR = 'error'
SESSION_STATUS_DEAD = 'dead'
SESSION_STATUS_KILLED = 'killed'
SESSION_STATUS_SUCCESS = 'success'
SESSION_STATUS_LOST = 'lost'

SESSION_STATUS_SUPPORTED = [
    SESSION_STATUS_NOT_STARTED,
    SESSION_STATUS_STARTING,
    SESSION_STATUS_IDLE,
    SESSION_STATUS_BUSY,
    SESSION_STATUS_SHUTTING_DOWN,
    SESSION_STATUS_ERROR,
    SESSION_STATUS_DEAD,
    SESSION_STATUS_KILLED,
    SESSION_STATUS_SUCCESS,
    SESSION_STATUS_LOST,
]

SESSION_ACTIVE_STATUS = (
    SESSION_STATUS_STARTING,
    SESSION_STATUS_IDLE,
    SESSION_STATUS_BUSY,
)

SESSION_FINAL_STATUS = (
    SESSION_STATUS_DEAD,
    SESSION_STATUS_ERROR,
    SESSION_STATUS_KILLED,
    SESSION_STATUS_SUCCESS,
    SESSION_STATUS_LOST,
)

STATEMENT_STATUS_WAITING = 'waiting'
STATEMENT_STATUS_RUNNING = 'running'
STATEMENT_STATUS_AVAILABLE = 'available'
STATEMENT_STATUS_ERROR = 'error'
STATEMENT_STATUS_CANCELLING = 'cancelling'
STATEMENT_STATUS_CANCELLED = 'cancelled'

STATEMENT_FINAL_STATUS = (
    STATEMENT_STATUS_ERROR,
    STATEMENT_STATUS_CANCELLED,
    STATEMENT_STATUS_AVAILABLE,
)

OUTPUT_STATUS_OK = 'ok'
OUTPUT_STATUS_ERROR = 'error'


MIMETYPE_IMAGE_PNG = 'image/png'
MIMETYPE_TEXT_HTML = 'text/html'
MIMETYPE_TEXT_PLAIN = 'text/plain'


CONTEXT_NAME_SPARK = 'spark'
CONTEXT_NAME_SQL = 'sql' 

LONG_RANDOM_VAR_NAME = "DLCAd2cQ5Jpxo6d"


LANGUAGE_TO_KIND = {
    LANGUAGE_SCALA: SESSION_KIND_SPARK,
    LANGUAGE_R: SESSION_KIND_SPARKR,
    LANGUAGE_PYTHON: SESSION_KIND_PYSPARK,
}


KERNEL_MODE_IPYTHON = 'ipython'
KERNEL_MODE_SPARK = 'spark'



SESSION_COLUMNS = ['Id', 'Name', 'Remote Name', 'Engine', 'Spark UI', 'Kind', 'Status', 'Properties', 'Current']