# ===========
# pysap - Python library for crafting SAP's network protocols packets
#
# SECUREAUTH LABS. Copyright (C) 2020 SecureAuth Corporation. All rights reserved.
#
# The library was designed and developed by Martin Gallo from
# the SecureAuth Labs team.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# ==============

__title__ = 'pysap'
"""The title of the library"""

__version__ = '0.1.18'
"""The version of pysap"""

__url__ = "https://www.secureauth.com/labs/open-source-tools/pysap"
"""The URL for pysap's homepage"""

__repo__ = "https://github.com/SecureAuthCorp/pysap"
"""The URL for pysap's repository"""

__license__ = "GNU General Public License v2 or later (GPLv2+)"
"""The license governing the use and distribution of pysap"""

epilog = "pysap %(version)s - %(url)s - %(repo)s" % {"version": __version__,
                                                     "url": __url__,
                                                     "repo": __repo__}
"""Epilog to use in example and tools to print out version numbers"""
