# aisolutions.freeflyer.runtimeapi package

"""
    Contains the exception class raised due to errors generated by the FreeFlyer Runtime API Engine
"""

import ctypes

from ctypes import byref

from .CInterfaceWrapper import CInterfaceWrapper

class RuntimeApiException(Exception):
    """
        An exception class that wraps all errors resulting from a runtime API function call.
    """

    def __init__(self, composed_result):
        """
            Construct the exception based on a composed result code.

            :param composedResult: The composed result code.

            :param message: message.
        """
        from .Utilities import Utilities

        super(RuntimeApiException, self).__init__()

        self.composedResult = composed_result
        self.functionId = Utilities.getFunctionId(composed_result)
        self.result = Utilities.getResult(composed_result)

        message_ptr = ctypes.c_char_p()

        description_result = CInterfaceWrapper.lib.ffGetResultDescription(
            self.composedResult, byref(message_ptr))

        if Utilities.isComposedResultAnError(description_result):
            self.message = "Unable to get result description."
        else:
            self.message = Utilities.nativeToPythonString(message_ptr)

    def __str__(self):
        return self.message
